<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_isapi - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_isapi</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_isapi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_isapi.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/mod/mod_isapi.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Extensions ISAPI dans Apache pour Windows</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>isapi_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_isapi.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Win32 only</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module implmente l'API des extensions du Serveur Internet. Il
    permet  Apache pour Windows de servir les extensions du Serveur
    Internet (par exemple les modules .dll ISAPI), compte tenu des
    restrictions spcifies.</p>

    <p>Les modules d'extension ISAPI (fichiers .dll) sont des modules
    tiers. Leur auteur n'est pas le Groupe Apache, et nous n'assurons
    donc pas leur support. Veuillez contacter directement l'auteur
    d'ISAPI si vous rencontrez des problmes  l'excution d'une
    extension ISAPI. <strong>Merci de <em>ne pas</em> soumettre ce genre
    de problme dans les listes d'Apache ou dans les pages de rapports
    de bogues.</strong></p>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#usage">Utilisation</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#notes">Notes additionnelles</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#journal">Journal du programmeur</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#isapiappendlogtoerrors">ISAPIAppendLogToErrors</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#isapiappendlogtoquery">ISAPIAppendLogToQuery</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#isapicachefile">ISAPICacheFile</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#isapifakeasync">ISAPIFakeAsync</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#isapilognotsupported">ISAPILogNotSupported</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#isapireadaheadbuffer">ISAPIReadAheadBuffer</a></li>
</ul>
<ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="usage" id="usage">Utilisation</a></h2>

    <p>Dans le fichier de configuration du serveur, utilisez la
    directive <code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code> pour
    associer les fichiers ISAPI au gestionnaire
    <code>isapi-handler</code>  l'aide de l'extension de leur nom de
    fichier. Pour faire en sorte que tout fichier .dll soit trait en
    tant qu'extension ISAPI, ditez le fichier httpd.conf et ajoutez les
    lignes suivantes :</p>
    <pre class="prettyprint lang-config">AddHandler isapi-handler .dll</pre>


    <div class="note">Dans les versions plus anciennes du serveur Apache, le nom du
    gestionnaire tait <code>isapi-isa</code> au lieu de
    <code>isapi-handler</code>. Depuis les versions de dveloppement 2.3
    du serveur Apache, <code>isapi-isa</code> n'est plus valide, et vous
    devrez ventuellement modifier votre configuration pour utiliser
    <code>isapi-handler</code>  la place.</div>

    <p>Le serveur Apache ne propose aucun moyen de conserver en mmoire
    un module charg. Vous pouvez cependant prcharger et garder un
    module spcifique en mmoire en utilisant la syntaxe suivante dans
    votre httpd.conf :</p>
    <pre class="prettyprint lang-config">ISAPICacheFile c:/WebWork/Scripts/ISAPI/mytest.dll</pre>


    <p>Que vous ayez ou non prcharg une extension ISAPI, ces dernires
    sont toutes soumises au mmes restrictions et possdent les mmes
    permissions que les scripts CGI. En d'autres termes, <code class="directive"><a href="../mod/core.html#options">Options</a></code> <code>ExecCGI</code> doit tre
    dfini pour le rpertoire qui contient le fichier .dll ISAPI.</p>

    <p>Reportez-vous aux <a href="#notes">Notes additionnelles</a> et au
    <a href="#journal">Journal du programmeur</a> pour plus de dtails
    et une clarification  propos du support spcifique ISAPI fourni par
    le module <code class="module"><a href="../mod/mod_isapi.html">mod_isapi</a></code>.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="notes" id="notes">Notes additionnelles</a></h2>

    <p>L'implmentation ISAPI d'Apache se conforme  toutes les
    spcifications ISAPI 2.0,  l'exception de certaines extensions
    "spcifiques Microsoft" utilisant des entres/sorties asynchrones.
    Le modle des entres/sorties d'Apache ne permet pas l'criture et
    la lecture asynchrone de la manire dont ISAPI pourrait le faire. Si
    une extension tente d'utiliser des fonctionnalits non supportes,
    comme les entres/sorties asynchrones, un message est enregistr
    dans le journal des erreurs afin d'aider au dbogage. Comme ces
    messages peuvent devenir envahissants, la directive
    <code>ISAPILogNotSupported Off</code> permet de filter ce bruit de
    fond.</p>

    <p>Si aucune option de configuration particulire n'est spcifie,
    certains serveurs, comme Microsoft IIS, chargent l'extension ISAPI
    dans le serveur et la conservent en mmoire jusqu' ce que
    l'utilisation de cette dernire devienne trop leve. Apache, par
    contre, charge et dcharge rellement l'extension ISAPI chaque fois
    qu'elle est invoque, si la directive <code class="directive"><a href="#isapicachefile">ISAPICacheFile</a></code> n'a pas t spcifie.
    Ce n'est pas trs performant, mais le modle de mmoire d'Apache
    fait que cette mthode est la plus efficace. De nombreux modules
    ISAPI prsentent des incompatibilits subtiles avec le serveur
    Apache, et le dchargement de ces modules permet d'assurer la
    stabilit du serveur.</p>

    <p>En outre, gardez  l'esprit que si Apache supporte les extensions
    ISAPI, il <strong>ne supporte pas les filtres ISAPI</strong>. Le
    support des filtres sera peut-tre ajout dans le futur, mais n'a
    pas encore t planifi.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="journal" id="journal">Journal du programmeur</a></h2>

    <p>Si vous crivez des modules <code class="module"><a href="../mod/mod_isapi.html">mod_isapi</a></code> Apache
    2.0, vous devez limiter vos appels 
    <code>ServerSupportFunction</code> aux directives suivantes :</p>

    <dl>
      <dt><code>HSE_REQ_SEND_URL_REDIRECT_RESP</code></dt>
      <dd>Redirige l'utilisateur vers une autre adresse.<br />
      Il doit s'agir d'une URL pleinement qualifie (comme
      <code>http://serveur/chemin</code>).</dd>

      <dt><code>HSE_REQ_SEND_URL</code></dt>
      <dd>Redirige l'utilisateur vers une autre adresse.<br />
      Ce ne doit pas tre une URL pleinement qualifie ; la mention du
      protocole ou du nom du serveur n'est pas autorise (par exemple,
      utilisez simplement <code>/chemin</code>).<br />
      La redirection n'est pas assure par le navigateur mais par le
      serveur lui-mme.<br />
      <div class="warning"><h3>Avertissement</h3>
        <p>Dans sa documentation rcente, Microsoft semble avoir
	abandonn la distinction entre les deux fonctions
	<code>HSE_REQ_SEND_URL</code>. Apache, quant  lui, continue de
	les traiter comme deux fonctions distinctes avec des contraintes
	et des comportements spcifiques.</p>
      </div></dd>

      <dt><code>HSE_REQ_SEND_RESPONSE_HEADER</code></dt>
      <dd>Apache accepte un corps de rponse aprs l'en-tte s'il se
      situe aprs la ligne vide (deux caractres newline conscutifs)
      dans la chane des arguments d'en-ttes. Ce corps ne doit pas
      contenir de caractres NULL, car l'argument des en-ttes est
      lui-mme termin par un caractre NULL.</dd>

      <dt><code>HSE_REQ_DONE_WITH_SESSION</code></dt>
      <dd>Apache considre ceci comme sans objet, car la session est
      ferme lorsque l'extension ISAPI termine son traitement.</dd>

      <dt><code>HSE_REQ_MAP_URL_TO_PATH</code></dt>
      <dd>Apache va traduire un nom virtuel en nom physique.</dd>

      <dt><code>HSE_APPEND_LOG_PARAMETER</code></dt>
      <dd>
        Ce paramtre peut intervenir dans un de ces journaux :

        <ul>
          <li>dans le composant <code>\"%{isapi-parameter}n\"</code>
	  d'une directive <code class="directive"><a href="../mod/mod_log_config.html#customlog">CustomLog</a></code></li>

          <li>dans le composant <code>%q</code> avec la directive
	  <code class="directive"><a href="#isapiappendlogtoquery">ISAPIAppendLogToQuery</a></code>
	  <code>On</code></li>

          <li>dans le journal des erreurs avec la directive <code class="directive"><a href="#isapiappendlogtoerrors">ISAPIAppendLogToErrors</a></code>
	  <code>On</code></li>
        </ul>

        <p>La premire option, le composant
	<code>%{isapi-parameter}n</code>, est prfrable et toujours
	disponible.</p>
      </dd>

      <dt><code>HSE_REQ_IS_KEEP_CONN</code></dt>
      <dd>retourne le statut ngoci Keep-Alive.</dd>

      <dt><code>HSE_REQ_SEND_RESPONSE_HEADER_EX</code></dt>
      <dd>se comportera comme indiqu dans le documentation, bien que le
      drapeau <code>fKeepConn</code> soit ignor.</dd>

      <dt><code>HSE_REQ_IS_CONNECTED</code></dt>
      <dd>renverra faux si la requte a t abandonne.</dd>
    </dl>

    <p>Apache renvoie <code>FALSE</code> pour tout appel non support 
    <code>ServerSupportFunction</code>, et <code>GetLastError</code>
    renverra la valeur <code>ERROR_INVALID_PARAMETER</code>.</p>

    <p><code>ReadClient</code> extrait la partie du corps de la requte
    qui dpasse le tampon initial (dfini par la directive <code class="directive"><a href="#isapireadaheadbuffer">ISAPIReadAheadBuffer</a></code>). En fonction de
    la dfinition de la directive
    <code class="directive">ISAPIReadAheadBuffer</code> (nombre d'octets 
    mettre dans le tampon avant d'appeler le gestionnaire ISAPI), les
    requtes courtes sont envoyes en entier  l'extension lorsque
    celle-ci est invoque. Si la taille de la requte est trop
    importante, l'extension ISAPI doit faire appel 
    <code>ReadClient</code> pour extraire la totalit du corps de la
    requte.</p>

    <p><code>WriteClient</code> est support, mais seulement avec le
    drapeau <code>HSE_IO_SYNC</code> ou le drapeau "aucune option"
    (valeur <code>0</code>). Toute autre requte
    <code>WriteClient</code> sera rejete avec une valeur de retour
    <code>FALSE</code>, et <code>GetLastError</code> renverra la valeur
    <code>ERROR_INVALID_PARAMETER</code></p>

    <p><code>GetServerVariable</code> est support, bien que les
    variables tendues de serveur n'existent pas (comme dfini par
    d'autres serveurs). Toutes les variables d'environnement CGI
    usuelles d'Apache sont disponibles  partir de
    <code>GetServerVariable</code>, ainsi que les valeurs
    <code>ALL_HTTP</code> et <code>ALL_RAW</code>.</p>

    <p>Depuis httpd 2.0, <code class="module"><a href="../mod/mod_isapi.html">mod_isapi</a></code> propose des
    fonctionnalits supplmentaires introduites dans les versions
    actualises de la spcification ISAPI, ainsi qu'une mulation
    limite des entres/sorties asynchrones et la smantique
    <code>TransmitFile</code>. Apache httpd supporte aussi le prchargement
    des .dlls ISAPI  des fins de performances.</p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="isapiappendlogtoerrors" id="isapiappendlogtoerrors">Directive</a> <a name="ISAPIAppendLogToErrors" id="ISAPIAppendLogToErrors">ISAPIAppendLogToErrors</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Enregistrement des requtes
<code>HSE_APPEND_LOG_PARAMETER</code> de la part des extensions ISAPI
dans le journal des erreurs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ISAPIAppendLogToErrors on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ISAPIAppendLogToErrors off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_isapi</td></tr>
</table>
    <p>Cette directive permet d'enregistrer les requtes
    <code>HSE_APPEND_LOG_PARAMETER</code> de la part des extensions
    ISAPI dans le journal des erreurs.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="isapiappendlogtoquery" id="isapiappendlogtoquery">Directive</a> <a name="ISAPIAppendLogToQuery" id="ISAPIAppendLogToQuery">ISAPIAppendLogToQuery</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Enregistre les requtes
<code>HSE_APPEND_LOG_PARAMETER</code> de la part des extensions ISAPI
dans la partie arguments de la requte</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ISAPIAppendLogToQuery on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ISAPIAppendLogToQuery on</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_isapi</td></tr>
</table>
    <p>Cette directive permet d'enregistrer les requtes
    <code>HSE_APPEND_LOG_PARAMETER</code> de la part des extensions
    ISAPI dans la partie arguments de la requte (ajout au composant
    <code>%q</code> de la directive <code class="directive"><a href="../mod/mod_log_config.html#customlog">CustomLog</a></code>).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="isapicachefile" id="isapicachefile">Directive</a> <a name="ISAPICacheFile" id="ISAPICacheFile">ISAPICacheFile</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fichiers .dll ISAPI devant tre chargs au
dmarrage</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ISAPICacheFile <var>chemin-fichier</var>
[<var>chemin-fichier</var>]
...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_isapi</td></tr>
</table>
    <p>Cette directive permet de spcifier une liste, spars par des
    espaces, de noms de fichiers devant tre chargs au dmarrage
    du serveur Apache, et rester en mmoire jusqu' l'arrt du serveur.
    Cette directive peut tre rpte pour chaque fichier .dll ISAPI
    souhait. Le chemin complet du fichier doit tre spcifi. Si le
    chemin n'est pas absolu, il sera considr comme relatif au
    rpertoire dfini par la directive <code class="directive"><a href="../mod/core.html#serverroot">ServerRoot</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="isapifakeasync" id="isapifakeasync">Directive</a> <a name="ISAPIFakeAsync" id="ISAPIFakeAsync">ISAPIFakeAsync</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Emulation du support des entres/sorties asynchrones pour
les appels ISAPI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ISAPIFakeAsync on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ISAPIFakeAsync off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_isapi</td></tr>
</table>
    <p>Lorsquelle est dfinie  "on", cette directive permet d'muler le
    support des entres/sorties asynchrones pour les appels ISAPI.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="isapilognotsupported" id="isapilognotsupported">Directive</a> <a name="ISAPILogNotSupported" id="ISAPILogNotSupported">ISAPILogNotSupported</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Journalisation des demandes de fonctionnalits non
supportes de la part des extensions ISAPI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ISAPILogNotSupported on|off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ISAPILogNotSupported off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_isapi</td></tr>
</table>
    <p>Cette directive permet d'enregistrer dans le journal des erreurs
    toutes les demandes de fonctionnalits non supportes de la part des
    extensions ISAPI. Ceci peut aider les administrateurs  dcortiquer
    certains problmes. Lorsqu'elle a t dfinie  "on" et si tous les
    modules ISAPI fonctionnent, elle peut tre redfinie  "off".</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="isapireadaheadbuffer" id="isapireadaheadbuffer">Directive</a> <a name="ISAPIReadAheadBuffer" id="ISAPIReadAheadBuffer">ISAPIReadAheadBuffer</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille du tampon de lecture anticipe envoy aux extensions
ISAPI</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ISAPIReadAheadBuffer <var>taille</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ISAPIReadAheadBuffer 49152</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire, .htaccess</td></tr>
<tr><th><a href="directive-dict.html#Override">AllowOverride:</a></th><td>FileInfo</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Base</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_isapi</td></tr>
</table>
    <p>Cette directive permet de dfinir la taille maximale du tampon de
    lecture anticipe envoy aux extensions ISAPI lorsqu'elles sont
    initialement invoques. Toute donne restante doit tre extraite en
    faisant appel  <code>ReadClient</code> ; certaines extensions ISAPI
    peuvent ne pas supporter la fonction <code>ReadClient</code>.
    Pour plus de dtails, veuillez vous adresser  l'auteur de
    l'extension ISAPI.</p>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_isapi.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_isapi.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ko/mod/mod_isapi.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_isapi.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>