#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import random, string, math
from genetic import organism, lifecycle


PHENOTYPE_GOOD = 1
PHENOTYPE_EVIL = 2

def alignment(x):
    if x > 0.0: return PHENOTYPE_GOOD
    if x < 0.0: return PHENOTYPE_EVIL
    return None

class GoodOrBad(organism.Organism):
  characteristics = [
    organism.Characteristic("alignment", alignment, organism.PERCHROMOSOM_DOMINANCY_PHENOTYPE)
    ]
  
  def __cmp__(self, other):
    return cmp(self.alignment, other.alignment)


def cycle(max = 70, printoutput = 1):
    # Create the initial set of organisms.
    
    organismA = GoodOrBad([
        organism.Chromosom(x = 1.0, __mutampl__ = 2.0, __break__ = 0.0),
        ])
    organismB = GoodOrBad([
        organism.Chromosom(x = -1.0, __mutampl__ = 2.0, __break__ = 0.0),
        ])
    organisms = [organismA, organismB]
    
    generation = 0
    try:
        while 1:
            generation = generation + 1
            if generation > max: return PHENOTYPE_GOOD
            
            children = lifecycle.make_love(organisms, 30)
            organisms = children
            
            nb_evil = len(filter(lambda organism: organism.alignment == PHENOTYPE_EVIL, organisms))
            for i in range(nb_evil): organisms.remove(random.choice(organisms))
            
            if len(organisms) == 0: return PHENOTYPE_EVIL
            
            nb_good = len(filter(lambda organism: organism.alignment == PHENOTYPE_GOOD, organisms))
            
            if printoutput: print "generation %s: %s organisms, %s%% good." % (generation, len(organisms), (nb_good * 100.0) / len(organisms))
    except: return PHENOTYPE_EVIL


nb_good = 0
for i in range(100):
    if cycle(50, 0) == PHENOTYPE_GOOD:
        nb_good = nb_good + 1
        print "test %s: good wins ;-)" % i
    else:
        print "test %s: evil wins :-(" % i
    
print "result %s%% good." % nb_good

