// Copyright (C) 2000-2007, Luca Padovani <padovani@sti.uniurb.it>.
// 
// This file is part of GtkMathView, a flexible, high-quality rendering
// engine for MathML documents.
// 
// GtkMathView is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
// 
// GtkMathView is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include "TFM.hh"

static TFM::Font font = {
"CMMI",

  0xf0,
  "TeX math italic",
  0x00700000,
  0x30659772,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x0012baf2 },
  { 0x07, "extra_space", 0x00000000 }
};


static TFM::Kerning C_00_Kerning[] = {
  { 0x3a, 0xfffe0820 },
  { 0x3b, 0xfffe0820 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_01_Kerning[] = {
  { 0x7f, 0x0002f3d7 }
};

static TFM::Kerning C_02_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_03_Kerning[] = {
  { 0x7f, 0x0002f3d7 }
};

static TFM::Kerning C_04_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_05_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_06_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_07_Kerning[] = {
  { 0x3a, 0xfffe0820 },
  { 0x3b, 0xfffe0820 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_08_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_09_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_0a_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_0b_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_0c_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_0e_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_0f_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_10_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_11_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_12_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_13_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_16_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_17_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_18_Kerning[] = {
  { 0x7f, 0x0001f7e5 }
};

static TFM::Kerning C_1a_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_1b_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 }
};

static TFM::Kerning C_1c_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_1d_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_1e_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_1f_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x7f, 0x0001f7e5 }
};

static TFM::Kerning C_22_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_23_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_25_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_26_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_3d_Kerning[] = {
  { 0x01, 0xffff0410 },
  { 0x41, 0xffff0410 },
  { 0x4d, 0xffff0410 },
  { 0x4e, 0xffff0410 },
  { 0x59, 0x0000fbf0 },
  { 0x5a, 0xffff0410 }
};

static TFM::Kerning C_40_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x7f, 0x000275de }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff8207 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x3a, 0xfffe0820 },
  { 0x3b, 0xfffe0820 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x7f, 0x0001f7e5 }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x3a, 0xfffe0820 },
  { 0x3b, 0xfffe0820 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x0002f3d7 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xfffe8617 },
  { 0x3d, 0xffff8207 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x3a, 0xfffe0820 },
  { 0x3b, 0xfffe0820 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff8207 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x3a, 0xfffe0820 },
  { 0x3b, 0xfffe0820 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x3a, 0xfffd0c30 },
  { 0x3b, 0xfffd0c30 },
  { 0x3d, 0xfffe0820 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x3a, 0xfffd0c30 },
  { 0x3b, 0xfffd0c30 },
  { 0x3d, 0xfffe0820 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xfffe8617 },
  { 0x3d, 0xffff8207 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x3a, 0xfffd0c30 },
  { 0x3b, 0xfffd0c30 },
  { 0x3d, 0xfffe0820 }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x3d, 0xffff0410 },
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_60_Kerning[] = {
  { 0x7f, 0x0001f7e5 }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_64_Kerning[] = {
  { 0x59, 0x0000fbf0 },
  { 0x5a, 0xffff0410 },
  { 0x66, 0xfffd0c30 },
  { 0x6a, 0xfffe0820 },
  { 0x7f, 0x0002f3d7 }
};

static TFM::Kerning C_65_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x7f, 0x0002f3d7 }
};

static TFM::Kerning C_67_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_68_Kerning[] = {
  { 0x7f, 0xffff8207 }
};

static TFM::Kerning C_6a_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 }
};

static TFM::Kerning C_6c_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_71_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_72_Kerning[] = {
  { 0x3a, 0xffff0410 },
  { 0x3b, 0xffff0410 },
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_73_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_74_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_75_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_76_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_78_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_79_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_7a_Kerning[] = {
  { 0x7f, 0x0000fbf2 }
};

static TFM::Kerning C_7b_Kerning[] = {
  { 0x7f, 0x00007df9 }
};

static TFM::Kerning C_7c_Kerning[] = {
  { 0x7f, 0x000179eb }
};

static TFM::Kerning C_7d_Kerning[] = {
  { 0x7f, 0x0001f7e5 }
};


static TFM::Character character[] = {
  { 0x00, 0x000b199e, 0x000aeef0, 0x00000000, 0x0000dfe5, 4, C_00_Kerning, 0, 0 },
  { 0x01, 0x000f4519, 0x000aeef0, 0x00000000, 0x00000000, 1, C_01_Kerning, 0, 0 },
  { 0x02, 0x000de722, 0x000aeef0, 0x00000000, 0x00007df9, 1, C_02_Kerning, 0, 0 },
  { 0x03, 0x000cc312, 0x000aeef0, 0x00000000, 0x00000000, 1, C_03_Kerning, 0, 0 },
  { 0x04, 0x000d8310, 0x000aeef0, 0x00000000, 0x000062e0, 1, C_04_Kerning, 0, 0 },
  { 0x05, 0x000ef84e, 0x000aeef0, 0x00000000, 0x00006e39, 4, C_05_Kerning, 0, 0 },
  { 0x06, 0x000e2e57, 0x000aeef0, 0x00000000, 0x0000e11e, 1, C_06_Kerning, 0, 0 },
  { 0x07, 0x000ad75e, 0x000aeef0, 0x00000000, 0x0000dfe5, 4, C_07_Kerning, 0, 0 },
  { 0x08, 0x000c5147, 0x000aeef0, 0x00000000, 0x00000000, 1, C_08_Kerning, 0, 0 },
  { 0x09, 0x000b785e, 0x000aeef0, 0x00000000, 0x0000c769, 4, C_09_Kerning, 0, 0 },
  { 0x0a, 0x000e14a5, 0x000aeef0, 0x00000000, 0x0000c769, 1, C_0a_Kerning, 0, 0 },
  { 0x0b, 0x000be205, 0x0006e38e, 0x00000000, 0x00000000, 1, C_0b_Kerning, 0, 0 },
  { 0x0c, 0x000a5d47, 0x000b1c72, 0x00031c72, 0x0000d27e, 1, C_0c_Kerning, 0, 0 },
  { 0x0d, 0x000999e9, 0x0006e38e, 0x00031c72, 0x0000fbf0, 0, 0, 0, 0 },
  { 0x0e, 0x00084ed7, 0x000b1c72, 0x00000000, 0x00009485, 3, C_0e_Kerning, 0, 0 },
  { 0x0f, 0x00079e49, 0x0006e38e, 0x00000000, 0x00000000, 1, C_0f_Kerning, 0, 0 },
  { 0x10, 0x00085147, 0x000b1c72, 0x00031c72, 0x00000000, 1, C_10_Kerning, 0, 0 },
  { 0x11, 0x00096ae5, 0x0006e38e, 0x00031c72, 0x000092f7, 1, C_11_Kerning, 0, 0 },
  { 0x12, 0x0008b4d2, 0x000b1c72, 0x00000000, 0x00007df9, 1, C_12_Kerning, 0, 0 },
  { 0x13, 0x0006c3be, 0x0006e38e, 0x00000000, 0x00000000, 1, C_13_Kerning, 0, 0 },
  { 0x14, 0x000ab37e, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000ad762, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000b1d27, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_16_Kerning, 0, 0 },
  { 0x17, 0x00092a02, 0x0006e38e, 0x00000000, 0x000014f9, 3, C_17_Kerning, 0, 0 },
  { 0x18, 0x00085147, 0x000b1c72, 0x00031c72, 0x00008bae, 1, C_18_Kerning, 0, 0 },
  { 0x19, 0x000ab050, 0x0006e38e, 0x00000000, 0x000092f7, 0, 0, 0, 0 },
  { 0x1a, 0x00097bc0, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_1a_Kerning, 0, 0 },
  { 0x1b, 0x000a9785, 0x0006e38e, 0x00000000, 0x000092f7, 2, C_1b_Kerning, 0, 0 },
  { 0x1c, 0x00086dee, 0x0006e38e, 0x00000000, 0x0000d27e, 3, C_1c_Kerning, 0, 0 },
  { 0x1d, 0x000a2087, 0x0006e38e, 0x00000000, 0x000092f7, 1, C_1d_Kerning, 0, 0 },
  { 0x1e, 0x000afd92, 0x000b1c72, 0x00031c72, 0x00000000, 1, C_1e_Kerning, 0, 0 },
  { 0x1f, 0x000b6bb2, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_1f_Kerning, 0, 0 },
  { 0x20, 0x000c1867, 0x000b1c72, 0x00031c72, 0x000092f7, 1, C_20_Kerning, 0, 0 },
  { 0x21, 0x000b83d0, 0x0006e38e, 0x00000000, 0x000092f7, 0, 0, 0, 0 },
  { 0x22, 0x0008a2c0, 0x0006e38e, 0x00000000, 0x00000000, 1, C_22_Kerning, 0, 0 },
  { 0x23, 0x000b09a5, 0x000b1c72, 0x00000000, 0x00000000, 1, C_23_Kerning, 0, 0 },
  { 0x24, 0x000f3307, 0x0006e38e, 0x00000000, 0x00007df9, 0, 0, 0, 0 },
  { 0x25, 0x00097bc0, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_25_Kerning, 0, 0 },
  { 0x26, 0x0007071e, 0x0006e38e, 0x00018e39, 0x00007df9, 1, C_26_Kerning, 0, 0 },
  { 0x27, 0x000c05b5, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_27_Kerning, 0, 0 },
  { 0x28, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x00056db9, 0x0007e6e5, 0xffffe6e5, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x00056db9, 0x0007e6e5, 0xffffe6e5, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x00095d79, 0x000771c7, 0xffff71c7, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x00095d79, 0x000771c7, 0xffff71c7, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00095d79, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x00095d79, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x00095d79, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x00095d79, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00095d79, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00095d79, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00095d79, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00095d79, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x00095d79, 0x000a4fa5, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x00095d79, 0x0006e38e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x00056db9, 0x0001d75e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x00056db9, 0x0001d75e, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000e4929, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x00095d79, 0x000c0000, 0x00040000, 0x00000000, 6, C_3d_Kerning, 0, 0 },
  { 0x3e, 0x000e4929, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x00095d79, 0x000771c7, 0xffff71c7, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x0009c2d9, 0x000b1c72, 0x00000000, 0x0000fbf0, 1, C_40_Kerning, 0, 0 },
  { 0x41, 0x000dbf02, 0x000aeef0, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000dcf92, 0x000aeef0, 0x00000000, 0x0000c769, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x000d1c37, 0x000aeef0, 0x00000000, 0x000017b7, 4, C_43_Kerning, 0, 0 },
  { 0x44, 0x000ef1f5, 0x000aeef0, 0x00000000, 0x00007df9, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x000d6b4b, 0x000aeef0, 0x00000000, 0x0000e11e, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000b9797, 0x000aeef0, 0x00000000, 0x0000dfe5, 4, C_46_Kerning, 0, 0 },
  { 0x47, 0x000e3b17, 0x000aeef0, 0x00000000, 0x00000000, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x000ef84e, 0x000aeef0, 0x00000000, 0x00006e39, 4, C_48_Kerning, 0, 0 },
  { 0x49, 0x000819d2, 0x000aeef0, 0x00000000, 0x00008bae, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000a1cdb, 0x000aeef0, 0x00000000, 0x000092f7, 4, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000f5bde, 0x000aeef0, 0x00000000, 0x000017b7, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000c8a2e, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x00116e25, 0x000aeef0, 0x00000000, 0x00009485, 4, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x000e7a55, 0x000aeef0, 0x00000000, 0x00009485, 5, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000de722, 0x000aeef0, 0x00000000, 0x00007df9, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000ba329, 0x000aeef0, 0x00000000, 0x0000dfe5, 4, C_50_Kerning, 0, 0 },
  { 0x51, 0x000e651b, 0x000aeef0, 0x00031c72, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x000dc50e, 0x000aeef0, 0x00000000, 0x000014f9, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x000b3950, 0x000aeef0, 0x00000000, 0x0000dfe5, 4, C_53_Kerning, 0, 0 },
  { 0x54, 0x000acbcb, 0x000aeef0, 0x00000000, 0x0000dfe5, 4, C_54_Kerning, 0, 0 },
  { 0x55, 0x000c7395, 0x000aeef0, 0x00000000, 0x00009485, 4, C_55_Kerning, 0, 0 },
  { 0x56, 0x000acb32, 0x000aeef0, 0x00000000, 0x0000ecb2, 3, C_56_Kerning, 0, 0 },
  { 0x57, 0x001130c9, 0x000aeef0, 0x00000000, 0x0000dfe5, 3, C_57_Kerning, 0, 0 },
  { 0x58, 0x000efd62, 0x000aeef0, 0x00000000, 0x00008bae, 5, C_58_Kerning, 0, 0 },
  { 0x59, 0x000abe9b, 0x000aeef0, 0x00000000, 0x0000ecb2, 3, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000c743b, 0x000aeef0, 0x00000000, 0x000017b7, 4, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x00076599, 0x000c0000, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x00076599, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x00076599, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x001238e9, 0x0005b8e5, 0xfffdb8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x001238e9, 0x0005b8e5, 0xfffdb8e5, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x0007a6a0, 0x000b1c72, 0x00000000, 0x00000000, 1, C_60_Kerning, 0, 0 },
  { 0x61, 0x0009ea25, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x000809c2, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00082b27, 0x0006e38e, 0x00000000, 0x00000000, 1, C_63_Kerning, 0, 0 },
  { 0x64, 0x000983e0, 0x000b1c72, 0x00000000, 0x00000000, 5, C_64_Kerning, 0, 0 },
  { 0x65, 0x0008ac1b, 0x0006e38e, 0x00000000, 0x00000000, 1, C_65_Kerning, 0, 0 },
  { 0x66, 0x0008e9ae, 0x000b1c72, 0x00031c72, 0x0000a7f5, 3, C_66_Kerning, 0, 0 },
  { 0x67, 0x0008ead2, 0x0006e38e, 0x00031c72, 0x000092f7, 1, C_67_Kerning, 0, 0 },
  { 0x68, 0x000ab37e, 0x000b1c72, 0x00000000, 0x00000000, 1, C_68_Kerning, 0, 0 },
  { 0x69, 0x0006778b, 0x000a9659, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00079047, 0x000a9659, 0x00031c72, 0x0000ecb2, 2, C_6a_Kerning, 0, 0 },
  { 0x6b, 0x0009b78e, 0x000b1c72, 0x00000000, 0x000062e0, 0, 0, 0, 0 },
  { 0x6c, 0x0005c7cb, 0x000b1c72, 0x00000000, 0x000017b7, 1, C_6c_Kerning, 0, 0 },
  { 0x6d, 0x0010383e, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x000b4c8e, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x000905b2, 0x0006e38e, 0x00000000, 0x00000000, 1, C_6f_Kerning, 0, 0 },
  { 0x70, 0x00096c2b, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_70_Kerning, 0, 0 },
  { 0x71, 0x000860a9, 0x0006e38e, 0x00031c72, 0x000092f7, 1, C_71_Kerning, 0, 0 },
  { 0x72, 0x00087ca2, 0x0006e38e, 0x00000000, 0x00007df9, 3, C_72_Kerning, 0, 0 },
  { 0x73, 0x0008a085, 0x0006e38e, 0x00000000, 0x00000000, 1, C_73_Kerning, 0, 0 },
  { 0x74, 0x0006e7a2, 0x0009d75e, 0x00000000, 0x00000000, 1, C_74_Kerning, 0, 0 },
  { 0x75, 0x000ace97, 0x0006e38e, 0x00000000, 0x00000000, 1, C_75_Kerning, 0, 0 },
  { 0x76, 0x00092497, 0x0006e38e, 0x00000000, 0x000092f7, 1, C_76_Kerning, 0, 0 },
  { 0x77, 0x000d3915, 0x0006e38e, 0x00000000, 0x00006e39, 1, C_77_Kerning, 0, 0 },
  { 0x78, 0x000a5d79, 0x0006e38e, 0x00000000, 0x00000000, 1, C_78_Kerning, 0, 0 },
  { 0x79, 0x0009451b, 0x0006e38e, 0x00031c72, 0x000092f7, 1, C_79_Kerning, 0, 0 },
  { 0x7a, 0x0008bba0, 0x0006e38e, 0x00000000, 0x0000a7f5, 1, C_7a_Kerning, 0, 0 },
  { 0x7b, 0x000660de, 0x0006e38e, 0x00000000, 0x00000000, 1, C_7b_Kerning, 0, 0 },
  { 0x7c, 0x00071250, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_7c_Kerning, 0, 0 },
  { 0x7d, 0x000bae8b, 0x0006e38e, 0x00031c72, 0x00000000, 1, C_7d_Kerning, 0, 0 },
  { 0x7e, 0x00095d79, 0x000b7feb, 0x00000000, 0x0000e11e, 0, 0, 0, 0 },
  { 0x7f, 0x00056db9, 0x000b1c72, 0x00000000, 0x0000fbf0, 0, 0, 0, 0 }
};

void
cmmi7_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
