#ifndef _HAPROXY_QUIC_SOCK_T_H
#define _HAPROXY_QUIC_SOCK_T_H
#ifdef USE_QUIC

#include <haproxy/buf-t.h>

/* QUIC socket allocation strategy. */
enum quic_sock_mode {
	QUIC_SOCK_MODE_CONN,  /* Use a dedicated socket per connection. */
	QUIC_SOCK_MODE_LSTNR, /* Multiplex connections over listener socket. */
};

/* QUIC connection accept queue. One per thread. */
struct quic_accept_queue {
	struct mt_list listeners; /* QUIC listeners with at least one connection ready to be accepted on this queue */
	struct tasklet *tasklet;  /* task responsible to call listener_accept */
};

/* Buffer used to receive QUIC datagrams on random thread and redispatch them
 * to the connection thread.
 */
struct quic_receiver_buf {
	struct buffer buf; /* storage for datagrams received. */
	struct list dgram_list; /* datagrams received with this rxbuf. */
	struct mt_list rxbuf_el; /* list element into receiver.rxbuf_list. */
};

/* QUIC datagram */
struct quic_dgram {
	void *owner;
	unsigned char *buf;
	size_t len;
	unsigned char *dcid;
	size_t dcid_len;
	struct sockaddr_storage saddr;
	struct sockaddr_storage daddr;
	struct quic_conn *qc;

	struct list recv_list; /* elemt to quic_receiver_buf <dgram_list>. */
	struct mt_list handler_list; /* elem to quic_dghdlr <dgrams>. */
};

/* QUIC datagram handler */
struct quic_dghdlr {
	struct mt_list dgrams;
	struct tasklet *task;
};

#endif /* USE_QUIC */
#endif /* _HAPROXY_QUIC_SOCK_T_H */
