/* propertypanel.c generated by valac 0.56.12, the Vala compiler
 * generated from propertypanel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013-2016 Red Hat, Inc.
 * Copyright(c) 2013-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2013-2023 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <ibus.h>
#include <glib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gdk/gdkx.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>

#define PROPERTY_PANEL_MONITOR_NET_WORKAREA_TIMEOUT ((guint) 300000)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	PANEL_SHOW_DO_NOT_SHOW,
	PANEL_SHOW_AUTO_HIDE,
	PANEL_SHOW_ALWAYS
} PanelShow;

#define TYPE_PANEL_SHOW (panel_show_get_type ())

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;
typedef struct _PropertyPanelPrivate PropertyPanelPrivate;

#define TYPE_IPROP_TOOL_ITEM (iprop_tool_item_get_type ())
#define IPROP_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPROP_TOOL_ITEM, IPropToolItem))
#define IS_IPROP_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPROP_TOOL_ITEM))
#define IPROP_TOOL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPROP_TOOL_ITEM, IPropToolItemIface))

typedef struct _IPropToolItem IPropToolItem;
typedef struct _IPropToolItemIface IPropToolItemIface;
enum  {
	PROPERTY_PANEL_0_PROPERTY,
	PROPERTY_PANEL_NUM_PROPERTIES
};
static GParamSpec* property_panel_properties[PROPERTY_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;

#define TYPE_PROP_TOGGLE_TOOL_BUTTON (prop_toggle_tool_button_get_type ())
#define PROP_TOGGLE_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton))
#define PROP_TOGGLE_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonClass))
#define IS_PROP_TOGGLE_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON))
#define IS_PROP_TOGGLE_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_TOGGLE_TOOL_BUTTON))
#define PROP_TOGGLE_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonClass))

typedef struct _PropToggleToolButton PropToggleToolButton;
typedef struct _PropToggleToolButtonClass PropToggleToolButtonClass;

#define TYPE_PROP_MENU_TOOL_BUTTON (prop_menu_tool_button_get_type ())
#define PROP_MENU_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButton))
#define PROP_MENU_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonClass))
#define IS_PROP_MENU_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_MENU_TOOL_BUTTON))
#define IS_PROP_MENU_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_MENU_TOOL_BUTTON))
#define PROP_MENU_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonClass))

typedef struct _PropMenuToolButton PropMenuToolButton;
typedef struct _PropMenuToolButtonClass PropMenuToolButtonClass;

#define TYPE_PROP_TOOL_BUTTON (prop_tool_button_get_type ())
#define PROP_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_TOOL_BUTTON, PropToolButton))
#define PROP_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_TOOL_BUTTON, PropToolButtonClass))
#define IS_PROP_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_TOOL_BUTTON))
#define IS_PROP_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_TOOL_BUTTON))
#define PROP_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_TOOL_BUTTON, PropToolButtonClass))

typedef struct _PropToolButton PropToolButton;
typedef struct _PropToolButtonClass PropToolButtonClass;

#define TYPE_PROP_SEPARATOR_TOOL_ITEM (prop_separator_tool_item_get_type ())
#define PROP_SEPARATOR_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItem))
#define PROP_SEPARATOR_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItemClass))
#define IS_PROP_SEPARATOR_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM))
#define IS_PROP_SEPARATOR_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_SEPARATOR_TOOL_ITEM))
#define PROP_SEPARATOR_TOOL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItemClass))

typedef struct _PropSeparatorToolItem PropSeparatorToolItem;
typedef struct _PropSeparatorToolItemClass PropSeparatorToolItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	PROPERTY_PANEL_PROPERTY_ACTIVATE_SIGNAL,
	PROPERTY_PANEL_NUM_SIGNALS
};
static guint property_panel_signals[PROPERTY_PANEL_NUM_SIGNALS] = {0};
enum  {
	IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL,
	IPROP_TOOL_ITEM_NUM_SIGNALS
};
static guint iprop_tool_item_signals[IPROP_TOOL_ITEM_NUM_SIGNALS] = {0};

#define TYPE_PROP_MENU (prop_menu_get_type ())
#define PROP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_MENU, PropMenu))
#define PROP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_MENU, PropMenuClass))
#define IS_PROP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_MENU))
#define IS_PROP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_MENU))
#define PROP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_MENU, PropMenuClass))

typedef struct _PropMenu PropMenu;
typedef struct _PropMenuClass PropMenuClass;
typedef struct _PropMenuPrivate PropMenuPrivate;

#define TYPE_IPROP_ITEM (iprop_item_get_type ())
#define IPROP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPROP_ITEM, IPropItem))
#define IS_IPROP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPROP_ITEM))
#define IPROP_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPROP_ITEM, IPropItemIface))

typedef struct _IPropItem IPropItem;
typedef struct _IPropItemIface IPropItemIface;
enum  {
	PROP_MENU_0_PROPERTY,
	PROP_MENU_NUM_PROPERTIES
};
static GParamSpec* prop_menu_properties[PROP_MENU_NUM_PROPERTIES];

#define TYPE_PROP_RADIO_MENU_ITEM (prop_radio_menu_item_get_type ())
#define PROP_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItem))
#define PROP_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItemClass))
#define IS_PROP_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_RADIO_MENU_ITEM))
#define IS_PROP_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_RADIO_MENU_ITEM))
#define PROP_RADIO_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItemClass))

typedef struct _PropRadioMenuItem PropRadioMenuItem;
typedef struct _PropRadioMenuItemClass PropRadioMenuItemClass;

#define TYPE_PROP_IMAGE_MENU_ITEM (prop_image_menu_item_get_type ())
#define PROP_IMAGE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItem))
#define PROP_IMAGE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItemClass))
#define IS_PROP_IMAGE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_IMAGE_MENU_ITEM))
#define IS_PROP_IMAGE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_IMAGE_MENU_ITEM))
#define PROP_IMAGE_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItemClass))

typedef struct _PropImageMenuItem PropImageMenuItem;
typedef struct _PropImageMenuItemClass PropImageMenuItemClass;

#define TYPE_PROP_CHECK_MENU_ITEM (prop_check_menu_item_get_type ())
#define PROP_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItem))
#define PROP_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItemClass))
#define IS_PROP_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_CHECK_MENU_ITEM))
#define IS_PROP_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_CHECK_MENU_ITEM))
#define PROP_CHECK_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItemClass))

typedef struct _PropCheckMenuItem PropCheckMenuItem;
typedef struct _PropCheckMenuItemClass PropCheckMenuItemClass;

#define TYPE_PROP_SEPARATOR_MENU_ITEM (prop_separator_menu_item_get_type ())
#define PROP_SEPARATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItem))
#define PROP_SEPARATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItemClass))
#define IS_PROP_SEPARATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM))
#define IS_PROP_SEPARATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_SEPARATOR_MENU_ITEM))
#define PROP_SEPARATOR_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItemClass))

typedef struct _PropSeparatorMenuItem PropSeparatorMenuItem;
typedef struct _PropSeparatorMenuItemClass PropSeparatorMenuItemClass;
typedef struct _PropToolButtonPrivate PropToolButtonPrivate;
enum  {
	PROP_TOOL_BUTTON_0_PROPERTY,
	PROP_TOOL_BUTTON_NUM_PROPERTIES
};
static GParamSpec* prop_tool_button_properties[PROP_TOOL_BUTTON_NUM_PROPERTIES];

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _PropToggleToolButtonPrivate PropToggleToolButtonPrivate;
enum  {
	PROP_TOGGLE_TOOL_BUTTON_0_PROPERTY,
	PROP_TOGGLE_TOOL_BUTTON_NUM_PROPERTIES
};
static GParamSpec* prop_toggle_tool_button_properties[PROP_TOGGLE_TOOL_BUTTON_NUM_PROPERTIES];
typedef struct _PropMenuToolButtonPrivate PropMenuToolButtonPrivate;
enum  {
	PROP_MENU_TOOL_BUTTON_0_PROPERTY,
	PROP_MENU_TOOL_BUTTON_NUM_PROPERTIES
};
static GParamSpec* prop_menu_tool_button_properties[PROP_MENU_TOOL_BUTTON_NUM_PROPERTIES];
typedef struct _PropSeparatorToolItemPrivate PropSeparatorToolItemPrivate;
enum  {
	PROP_SEPARATOR_TOOL_ITEM_0_PROPERTY,
	PROP_SEPARATOR_TOOL_ITEM_NUM_PROPERTIES
};
static GParamSpec* prop_separator_tool_item_properties[PROP_SEPARATOR_TOOL_ITEM_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PropertyPanel {
	GtkBox parent_instance;
	PropertyPanelPrivate * priv;
};

struct _PropertyPanelClass {
	GtkBoxClass parent_class;
};

struct _IPropToolItemIface {
	GTypeInterface parent_iface;
	void (*update_property) (IPropToolItem* self, IBusProperty* prop);
};

struct _PropertyPanelPrivate {
	GdkWindow* m_root_window;
	Display* m_xdisplay;
	GtkWindow* m_toplevel;
	IBusPropList* m_props;
	IPropToolItem** m_items;
	gint m_items_length1;
	gint _m_items_size_;
	GdkRectangle m_cursor_location;
	gint m_show;
	guint m_auto_hide_timeout;
	guint m_auto_hide_timeout_id;
	gboolean m_follow_input_cursor_when_always_shown;
	guint m_remove_filter_id;
};

struct _PropMenu {
	GtkMenu parent_instance;
	PropMenuPrivate * priv;
};

struct _PropMenuClass {
	GtkMenuClass parent_class;
};

struct _IPropItemIface {
	GTypeInterface parent_iface;
	void (*update_property) (IPropItem* self, IBusProperty* prop);
};

struct _PropMenuPrivate {
	GtkWidget* m_parent_button;
	IPropItem** m_items;
	gint m_items_length1;
	gint _m_items_size_;
};

struct _PropToolButton {
	GtkToolButton parent_instance;
	PropToolButtonPrivate * priv;
};

struct _PropToolButtonClass {
	GtkToolButtonClass parent_class;
};

struct _PropToolButtonPrivate {
	IBusProperty* m_prop;
};

struct _PropToggleToolButton {
	GtkToggleToolButton parent_instance;
	PropToggleToolButtonPrivate * priv;
};

struct _PropToggleToolButtonClass {
	GtkToggleToolButtonClass parent_class;
};

struct _PropToggleToolButtonPrivate {
	IBusProperty* m_prop;
};

struct _PropMenuToolButton {
	PropToggleToolButton parent_instance;
	PropMenuToolButtonPrivate * priv;
};

struct _PropMenuToolButtonClass {
	PropToggleToolButtonClass parent_class;
};

struct _PropMenuToolButtonPrivate {
	PropMenu* m_menu;
};

struct _PropSeparatorToolItem {
	GtkSeparatorToolItem parent_instance;
	PropSeparatorToolItemPrivate * priv;
};

struct _PropSeparatorToolItemClass {
	GtkSeparatorToolItemClass parent_class;
};

static gint PropertyPanel_private_offset;
static gpointer property_panel_parent_class = NULL;
static gint PropMenu_private_offset;
static gpointer prop_menu_parent_class = NULL;
static IPropToolItemIface * prop_menu_iprop_tool_item_parent_iface = NULL;
static gint PropToolButton_private_offset;
static gpointer prop_tool_button_parent_class = NULL;
static IPropToolItemIface * prop_tool_button_iprop_tool_item_parent_iface = NULL;
static gint PropToggleToolButton_private_offset;
static gpointer prop_toggle_tool_button_parent_class = NULL;
static IPropToolItemIface * prop_toggle_tool_button_iprop_tool_item_parent_iface = NULL;
static gint PropMenuToolButton_private_offset;
static gpointer prop_menu_tool_button_parent_class = NULL;
static IPropToolItemIface * prop_menu_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_separator_tool_item_parent_class = NULL;
static IPropToolItemIface * prop_separator_tool_item_iprop_tool_item_parent_iface = NULL;

VALA_EXTERN GType panel_show_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType property_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropertyPanel, g_object_unref)
VALA_EXTERN GType iprop_tool_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IPropToolItem, g_object_unref)
VALA_EXTERN PropertyPanel* property_panel_new (void);
VALA_EXTERN PropertyPanel* property_panel_construct (GType object_type);
VALA_EXTERN GdkX11Display* binding_common_get_xdisplay (void);
VALA_EXTERN GType handle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Handle, g_object_unref)
VALA_EXTERN Handle* handle_new (void);
VALA_EXTERN Handle* handle_construct (GType object_type);
static void __lambda53_ (PropertyPanel* self,
                  GtkWidget* w,
                  GtkAllocation* a);
static void property_panel_set_default_location (PropertyPanel* self);
static void ___lambda53__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
static void property_panel_monitor_net_workarea_atom (PropertyPanel* self);
VALA_EXTERN void property_panel_set_properties (PropertyPanel* self,
                                    IBusPropList* props);
VALA_EXTERN GType prop_toggle_tool_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropToggleToolButton, g_object_unref)
VALA_EXTERN GType prop_menu_tool_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropMenuToolButton, g_object_unref)
static void property_panel_create_menu_items (PropertyPanel* self);
static void property_panel_show_with_auto_hide_timer (PropertyPanel* self);
VALA_EXTERN void property_panel_update_property (PropertyPanel* self,
                                     IBusProperty* prop);
VALA_EXTERN void iprop_tool_item_update_property (IPropToolItem* self,
                                      IBusProperty* prop);
VALA_EXTERN void property_panel_set_cursor_location (PropertyPanel* self,
                                         gint x,
                                         gint y,
                                         gint width,
                                         gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                                     const cairo_rectangle_int_t * s2);
static void property_panel_hide_if_necessary (PropertyPanel* self);
static void property_panel_adjust_window_position (PropertyPanel* self);
VALA_EXTERN void property_panel_set_preedit_text (PropertyPanel* self,
                                      IBusText* text,
                                      guint cursor);
VALA_EXTERN void property_panel_set_auxiliary_text (PropertyPanel* self,
                                        IBusText* text);
VALA_EXTERN void property_panel_set_lookup_table (PropertyPanel* self,
                                      IBusLookupTable* table);
VALA_EXTERN void property_panel_show (PropertyPanel* self);
VALA_EXTERN void property_panel_hide (PropertyPanel* self);
VALA_EXTERN void property_panel_focus_in (PropertyPanel* self);
VALA_EXTERN void property_panel_set_show (PropertyPanel* self,
                              gint _show);
VALA_EXTERN void property_panel_set_auto_hide_timeout (PropertyPanel* self,
                                           guint timeout);
VALA_EXTERN void property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self,
                                                               gboolean is_follow);
VALA_EXTERN PropToolButton* prop_tool_button_new (IBusProperty* prop);
VALA_EXTERN PropToolButton* prop_tool_button_construct (GType object_type,
                                            IBusProperty* prop);
VALA_EXTERN GType prop_tool_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropToolButton, g_object_unref)
VALA_EXTERN PropToggleToolButton* prop_toggle_tool_button_new (IBusProperty* prop);
VALA_EXTERN PropToggleToolButton* prop_toggle_tool_button_construct (GType object_type,
                                                         IBusProperty* prop);
VALA_EXTERN PropMenuToolButton* prop_menu_tool_button_new (IBusProperty* prop);
VALA_EXTERN PropMenuToolButton* prop_menu_tool_button_construct (GType object_type,
                                                     IBusProperty* prop);
VALA_EXTERN PropSeparatorToolItem* prop_separator_tool_item_new (IBusProperty* prop);
VALA_EXTERN PropSeparatorToolItem* prop_separator_tool_item_construct (GType object_type,
                                                           IBusProperty* prop);
VALA_EXTERN GType prop_separator_tool_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropSeparatorToolItem, g_object_unref)
static void _vala_array_add26 (IPropToolItem** * array,
                        gint* length,
                        gint* size,
                        IPropToolItem* value);
static void ____lambda58_ (PropertyPanel* self,
                    IPropToolItem* w,
                    const gchar* k,
                    gint s);
static void _____lambda58__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                       const gchar* key,
                                                       gint state,
                                                       gpointer self);
static void property_panel_move (PropertyPanel* self,
                          gint x,
                          gint y);
static gboolean property_panel_is_bottom_panel (PropertyPanel* self);
static GdkFilterReturn property_panel_root_window_filter (PropertyPanel* self,
                                                   GdkXEvent* gdkxevent,
                                                   GdkEvent* event);
static GdkFilterReturn _property_panel_root_window_filter_gdk_filter_func (GdkXEvent* xevent,
                                                                    GdkEvent* event,
                                                                    gpointer self);
static gboolean __lambda54_ (PropertyPanel* self);
static gboolean ___lambda54__gsource_func (gpointer self);
static gboolean __lambda59_ (PropertyPanel* self);
static gboolean ___lambda59__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data);
static void property_panel_finalize (GObject * obj);
static GType property_panel_get_type_once (void);
static GType iprop_tool_item_get_type_once (void);
VALA_EXTERN GType prop_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropMenu, g_object_unref)
VALA_EXTERN GType iprop_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IPropItem, g_object_unref)
VALA_EXTERN PropMenu* prop_menu_new (IBusProperty* prop);
VALA_EXTERN PropMenu* prop_menu_construct (GType object_type,
                               IBusProperty* prop);
static void prop_menu_create_items (PropMenu* self,
                             IBusPropList* props);
static void prop_menu_real_update_property (IPropToolItem* base,
                                     IBusProperty* prop);
VALA_EXTERN void iprop_item_update_property (IPropItem* self,
                                 IBusProperty* prop);
VALA_EXTERN void prop_menu_popup (PropMenu* self,
                      guint button,
                      guint32 activate_time,
                      GtkWidget* widget);
static void prop_menu_real_destroy (GtkWidget* base);
VALA_EXTERN GType prop_radio_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropRadioMenuItem, g_object_unref)
VALA_EXTERN PropImageMenuItem* prop_image_menu_item_new (IBusProperty* property);
VALA_EXTERN PropImageMenuItem* prop_image_menu_item_construct (GType object_type,
                                                   IBusProperty* property);
VALA_EXTERN GType prop_image_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropImageMenuItem, g_object_unref)
VALA_EXTERN PropCheckMenuItem* prop_check_menu_item_new (IBusProperty* property);
VALA_EXTERN PropCheckMenuItem* prop_check_menu_item_construct (GType object_type,
                                                   IBusProperty* property);
VALA_EXTERN GType prop_check_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropCheckMenuItem, g_object_unref)
VALA_EXTERN PropRadioMenuItem* prop_radio_menu_item_new (IBusProperty* property,
                                             PropRadioMenuItem* group_source);
VALA_EXTERN PropRadioMenuItem* prop_radio_menu_item_construct (GType object_type,
                                                   IBusProperty* property,
                                                   PropRadioMenuItem* group_source);
VALA_EXTERN PropSeparatorMenuItem* prop_separator_menu_item_new (IBusProperty* property);
VALA_EXTERN PropSeparatorMenuItem* prop_separator_menu_item_construct (GType object_type,
                                                           IBusProperty* property);
VALA_EXTERN GType prop_separator_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PropSeparatorMenuItem, g_object_unref)
static void ____lambda55_ (PropMenu* self,
                    IPropItem* w,
                    const gchar* k,
                    gint s);
static void _____lambda55__iprop_item_property_activate (IPropItem* _sender,
                                                  const gchar* key,
                                                  gint state,
                                                  gpointer self);
static void _vala_array_add27 (IPropItem** * array,
                        gint* length,
                        gint* size,
                        IPropItem* value);
static void prop_menu_finalize (GObject * obj);
static GType prop_menu_get_type_once (void);
static void prop_tool_button_sync (PropToolButton* self);
static void prop_tool_button_real_update_property (IPropToolItem* base,
                                            IBusProperty* prop);
VALA_EXTERN void prop_tool_button_set_icon_name (PropToolButton* self,
                                     const gchar* icon_name);
static void prop_tool_button_real_clicked (GtkToolButton* base);
VALA_EXTERN GType icon_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IconWidget, g_object_unref)
VALA_EXTERN IconWidget* icon_widget_new (const gchar* icon_name_or_path,
                             GtkIconSize size);
VALA_EXTERN IconWidget* icon_widget_construct (GType object_type,
                                   const gchar* icon_name_or_path,
                                   GtkIconSize size);
static void prop_tool_button_finalize (GObject * obj);
static GType prop_tool_button_get_type_once (void);
static void prop_toggle_tool_button_sync (PropToggleToolButton* self);
VALA_EXTERN void prop_toggle_tool_button_set_property (PropToggleToolButton* self,
                                           IBusProperty* prop);
static void prop_toggle_tool_button_real_update_property (IPropToolItem* base,
                                                   IBusProperty* prop);
VALA_EXTERN void prop_toggle_tool_button_set_icon_name (PropToggleToolButton* self,
                                            const gchar* icon_name);
static void prop_toggle_tool_button_real_toggled (GtkToggleToolButton* base);
static void prop_toggle_tool_button_finalize (GObject * obj);
static GType prop_toggle_tool_button_get_type_once (void);
static void __lambda56_ (PropMenuToolButton* self,
                  GtkMenuShell* m);
static void ___lambda56__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                             gpointer self);
static void __lambda57_ (PropMenuToolButton* self,
                  const gchar* k,
                  gint s);
static void ___lambda57__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                     const gchar* key,
                                                     gint state,
                                                     gpointer self);
static void prop_menu_tool_button_real_update_property (IPropToolItem* base,
                                                 IBusProperty* prop);
static void prop_menu_tool_button_real_toggled (GtkToggleToolButton* base);
static void prop_menu_tool_button_real_destroy (GtkWidget* base);
static void prop_menu_tool_button_finalize (GObject * obj);
static GType prop_menu_tool_button_get_type_once (void);
static void prop_separator_tool_item_real_update_property (IPropToolItem* base,
                                                    IBusProperty* prop);
static GType prop_separator_tool_item_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static GType
panel_show_get_type_once (void)
{
	static const GEnumValue values[] = {{PANEL_SHOW_DO_NOT_SHOW, "PANEL_SHOW_DO_NOT_SHOW", "do-not-show"}, {PANEL_SHOW_AUTO_HIDE, "PANEL_SHOW_AUTO_HIDE", "auto-hide"}, {PANEL_SHOW_ALWAYS, "PANEL_SHOW_ALWAYS", "always"}, {0, NULL, NULL}};
	GType panel_show_type_id;
	panel_show_type_id = g_enum_register_static ("PanelShow", values);
	return panel_show_type_id;
}

GType
panel_show_get_type (void)
{
	static volatile gsize panel_show_type_id__once = 0;
	if (g_once_init_enter (&panel_show_type_id__once)) {
		GType panel_show_type_id;
		panel_show_type_id = panel_show_get_type_once ();
		g_once_init_leave (&panel_show_type_id__once, panel_show_type_id);
	}
	return panel_show_type_id__once;
}

static inline gpointer
property_panel_get_instance_private (PropertyPanel* self)
{
	return G_STRUCT_MEMBER_P (self, PropertyPanel_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda53_ (PropertyPanel* self,
             GtkWidget* w,
             GtkAllocation* a)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	if (!self->priv->m_follow_input_cursor_when_always_shown) {
		_tmp3_ = self->priv->m_show == ((gint) PANEL_SHOW_ALWAYS);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		IPropToolItem** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->m_items;
		_tmp4__length1 = self->priv->m_items_length1;
		_tmp2_ = _tmp4__length1 > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkRectangle _tmp5_;
		_tmp5_ = self->priv->m_cursor_location;
		_tmp1_ = _tmp5_.x == -1;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GdkRectangle _tmp6_;
		_tmp6_ = self->priv->m_cursor_location;
		_tmp0_ = _tmp6_.y == -1;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		property_panel_set_default_location (self);
		self->priv->m_cursor_location.x = 0;
		self->priv->m_cursor_location.y = 0;
	}
}

static void
___lambda53__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda53_ ((PropertyPanel*) self, _sender, allocation);
}

PropertyPanel*
property_panel_construct (GType object_type)
{
	PropertyPanel * self = NULL;
	GdkX11Display* display = NULL;
	GdkX11Display* _tmp0_;
	GdkX11Display* _tmp1_;
	GtkWindow* _tmp9_;
	GtkWindow* _tmp10_;
	Handle* handle = NULL;
	Handle* _tmp11_;
	GtkWindow* _tmp12_;
	GtkWindow* _tmp13_;
	self = (PropertyPanel*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = binding_common_get_xdisplay ();
	display = _tmp0_;
	_tmp1_ = display;
	if (_tmp1_ != NULL) {
		GdkX11Display* _tmp2_;
		Display* _tmp3_;
		GdkScreen* screen = NULL;
		GdkX11Display* _tmp4_;
		GdkScreen* _tmp5_;
		GdkScreen* _tmp6_;
		GdkScreen* _tmp7_;
		GdkWindow* _tmp8_;
		_tmp2_ = display;
		_tmp3_ = gdk_x11_display_get_xdisplay (_tmp2_);
		self->priv->m_xdisplay = _tmp3_;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen ((GdkDisplay*) _tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		screen = _tmp6_;
		_tmp7_ = screen;
		_tmp8_ = gdk_screen_get_root_window (_tmp7_);
		self->priv->m_root_window = _tmp8_;
		_g_object_unref0 (screen);
	}
	_tmp9_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp9_;
	_tmp10_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp10_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp11_ = handle_new ();
	g_object_ref_sink (_tmp11_);
	handle = _tmp11_;
	gtk_widget_set_visible ((GtkWidget*) handle, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) handle, FALSE, FALSE, (guint) 0);
	_tmp12_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) self);
	_tmp13_ = self->priv->m_toplevel;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "size-allocate", (GCallback) ___lambda53__gtk_widget_size_allocate, self, 0);
	property_panel_monitor_net_workarea_atom (self);
	_g_object_unref0 (handle);
	_g_object_unref0 (display);
	return self;
}

PropertyPanel*
property_panel_new (void)
{
	return property_panel_construct (TYPE_PROPERTY_PANEL);
}

void
property_panel_set_properties (PropertyPanel* self,
                               IBusPropList* props)
{
	gboolean has_active = FALSE;
	IPropToolItem** _tmp0_;
	gint _tmp0__length1;
	IPropToolItem** _tmp5_;
	gint _tmp5__length1;
	IPropToolItem** _tmp8_;
	IBusPropList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	g_debug ("propertypanel.vala:86: set_properties()\n");
	has_active = FALSE;
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			IPropToolItem* _tmp1_;
			IPropToolItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				GType type = 0UL;
				IPropToolItem* _tmp2_;
				gboolean _tmp3_ = FALSE;
				_tmp2_ = item;
				type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp2_);
				if (type == TYPE_PROP_MENU_TOOL_BUTTON) {
					_tmp3_ = TRUE;
				} else {
					_tmp3_ = type == TYPE_PROP_TOGGLE_TOOL_BUTTON;
				}
				if (_tmp3_) {
					IPropToolItem* _tmp4_;
					_tmp4_ = item;
					if (gtk_toggle_tool_button_get_active (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_toggle_tool_button_get_type ()) ? ((GtkToggleToolButton*) _tmp4_) : NULL)) {
						has_active = TRUE;
						_g_object_unref0 (item);
						break;
					}
				}
				_g_object_unref0 (item);
			}
		}
	}
	if (has_active) {
		return;
	}
	_tmp5_ = self->priv->m_items;
	_tmp5__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp5_;
		item_collection_length1 = _tmp5__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			IPropToolItem* _tmp6_;
			IPropToolItem* item = NULL;
			_tmp6_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp6_;
			{
				IPropToolItem* _tmp7_;
				_tmp7_ = item;
				gtk_container_remove ((GtkContainer*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp7_) : NULL);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp8_ = g_new0 (IPropToolItem*, 0 + 1);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_items = _tmp8_;
	self->priv->m_items_length1 = 0;
	self->priv->_m_items_size_ = self->priv->m_items_length1;
	_tmp9_ = _g_object_ref0 (props);
	_g_object_unref0 (self->priv->m_props);
	self->priv->m_props = _tmp9_;
	property_panel_create_menu_items (self);
	property_panel_show_with_auto_hide_timer (self);
}

void
property_panel_update_property (PropertyPanel* self,
                                IBusProperty* prop)
{
	const gchar* _tmp0_;
	IBusPropList* _tmp1_;
	IPropToolItem** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_vala_assert (prop != NULL, "prop != null");
	_tmp0_ = ibus_property_get_key (prop);
	g_debug ("propertypanel.vala:124: update_property(prop.key = %s)\n", _tmp0_);
	_tmp1_ = self->priv->m_props;
	if (_tmp1_ != NULL) {
		IBusPropList* _tmp2_;
		_tmp2_ = self->priv->m_props;
		ibus_prop_list_update_property (_tmp2_, prop);
	}
	_tmp3_ = self->priv->m_items;
	_tmp3__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp3_;
		item_collection_length1 = _tmp3__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			IPropToolItem* _tmp4_;
			IPropToolItem* item = NULL;
			_tmp4_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp4_;
			{
				IPropToolItem* _tmp5_;
				_tmp5_ = item;
				iprop_tool_item_update_property (_tmp5_, prop);
				_g_object_unref0 (item);
			}
		}
	}
	property_panel_show_with_auto_hide_timer (self);
}

static gboolean
_cairo_rectangle_int_equal (const cairo_rectangle_int_t * s1,
                            const cairo_rectangle_int_t * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

void
property_panel_set_cursor_location (PropertyPanel* self,
                                    gint x,
                                    gint y,
                                    gint width,
                                    gint height)
{
	gboolean _tmp0_ = FALSE;
	GdkRectangle location = {0};
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp8_;
	g_return_if_fail (self != NULL);
	if (!self->priv->m_follow_input_cursor_when_always_shown) {
		_tmp0_ = self->priv->m_show == ((gint) PANEL_SHOW_ALWAYS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	memset (&_tmp1_, 0, sizeof (GdkRectangle));
	_tmp1_.x = x;
	_tmp1_.y = y;
	_tmp1_.width = width;
	_tmp1_.height = height;
	location = _tmp1_;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = location;
	if (_cairo_rectangle_int_equal (&_tmp2_, &_tmp3_) == TRUE) {
		return;
	}
	g_debug ("propertypanel.vala:165: set_cursor_location(x = %d, y = %d, width = %d" \
", height = %d)\n", x, y, width, height);
	if (self->priv->m_show == ((gint) PANEL_SHOW_AUTO_HIDE)) {
		gboolean _tmp4_ = FALSE;
		GdkRectangle _tmp5_;
		_tmp5_ = self->priv->m_cursor_location;
		if (_tmp5_.x != -1) {
			_tmp4_ = TRUE;
		} else {
			GdkRectangle _tmp6_;
			_tmp6_ = self->priv->m_cursor_location;
			_tmp4_ = _tmp6_.y != -1;
		}
		if (_tmp4_) {
			GdkRectangle _tmp7_;
			_tmp7_ = location;
			self->priv->m_cursor_location = _tmp7_;
			property_panel_hide_if_necessary (self);
			property_panel_adjust_window_position (self);
			return;
		}
	}
	_tmp8_ = location;
	self->priv->m_cursor_location = _tmp8_;
	property_panel_adjust_window_position (self);
	property_panel_show_with_auto_hide_timer (self);
}

void
property_panel_set_preedit_text (PropertyPanel* self,
                                 IBusText* text,
                                 guint cursor)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (text == NULL) {
		_tmp0_ = cursor == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	g_debug ("propertypanel.vala:189: set_preedit_text(text, cursor = %u)\n", cursor);
	property_panel_hide_if_necessary (self);
}

void
property_panel_set_auxiliary_text (PropertyPanel* self,
                                   IBusText* text)
{
	g_return_if_fail (self != NULL);
	if (text == NULL) {
		return;
	}
	g_debug ("propertypanel.vala:201: set_auxiliary_text(text)\n");
	property_panel_hide_if_necessary (self);
}

void
property_panel_set_lookup_table (PropertyPanel* self,
                                 IBusLookupTable* table)
{
	g_return_if_fail (self != NULL);
	if (table == NULL) {
		return;
	}
	g_debug ("propertypanel.vala:210: set_lookup_table(table)\n");
	property_panel_hide_if_necessary (self);
}

void
property_panel_show (PropertyPanel* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->m_show == ((gint) PANEL_SHOW_DO_NOT_SHOW)) {
		GtkWindow* _tmp0_;
		_tmp0_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp0_);
		return;
	} else {
		if (self->priv->m_show == ((gint) PANEL_SHOW_ALWAYS)) {
			GtkWindow* _tmp1_;
			_tmp1_ = self->priv->m_toplevel;
			gtk_widget_show_all ((GtkWidget*) _tmp1_);
			return;
		}
	}
}

void
property_panel_hide (PropertyPanel* self)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

void
property_panel_focus_in (PropertyPanel* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("propertypanel.vala:235: focus_in()\n");
	property_panel_hide_if_necessary (self);
	if (self->priv->m_follow_input_cursor_when_always_shown) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->m_show != ((gint) PANEL_SHOW_ALWAYS);
	}
	if (_tmp0_) {
		GdkRectangle _tmp1_ = {0};
		_tmp1_.x = -1;
		_tmp1_.y = -1;
		_tmp1_.width = 0;
		_tmp1_.height = 0;
		self->priv->m_cursor_location = _tmp1_;
	}
}

void
property_panel_set_show (PropertyPanel* self,
                         gint _show)
{
	g_return_if_fail (self != NULL);
	self->priv->m_show = _show;
	property_panel_show (self);
}

void
property_panel_set_auto_hide_timeout (PropertyPanel* self,
                                      guint timeout)
{
	g_return_if_fail (self != NULL);
	self->priv->m_auto_hide_timeout = timeout;
}

void
property_panel_set_follow_input_cursor_when_always_shown (PropertyPanel* self,
                                                          gboolean is_follow)
{
	g_return_if_fail (self != NULL);
	self->priv->m_follow_input_cursor_when_always_shown = is_follow;
}

static void
_vala_array_add26 (IPropToolItem** * array,
                   gint* length,
                   gint* size,
                   IPropToolItem* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IPropToolItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
____lambda58_ (PropertyPanel* self,
               IPropToolItem* w,
               const gchar* k,
               gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	g_signal_emit (self, property_panel_signals[PROPERTY_PANEL_PROPERTY_ACTIVATE_SIGNAL], 0, k, s);
}

static void
_____lambda58__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                  const gchar* key,
                                                  gint state,
                                                  gpointer self)
{
	____lambda58_ ((PropertyPanel*) self, _sender, key, state);
}

static void
property_panel_create_menu_items (PropertyPanel* self)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusPropList* _tmp0_;
		IBusProperty* _tmp1_;
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		gint _tmp4_;
		IPropToolItem* item = NULL;
		IBusProperty* _tmp5_;
		IPropToolItem* _tmp15_;
		_tmp0_ = self->priv->m_props;
		_tmp1_ = ibus_prop_list_get (_tmp0_, (guint) i);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		prop = _tmp2_;
		_tmp3_ = prop;
		if (_tmp3_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp4_ = i;
		i = _tmp4_ + 1;
		item = NULL;
		_tmp5_ = prop;
		switch (ibus_property_get_prop_type (_tmp5_)) {
			case PROP_TYPE_NORMAL:
			{
				IBusProperty* _tmp6_;
				PropToolButton* _tmp7_;
				_tmp6_ = prop;
				_tmp7_ = prop_tool_button_new (_tmp6_);
				g_object_ref_sink (_tmp7_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp7_;
				break;
			}
			case PROP_TYPE_TOGGLE:
			{
				IBusProperty* _tmp8_;
				PropToggleToolButton* _tmp9_;
				_tmp8_ = prop;
				_tmp9_ = prop_toggle_tool_button_new (_tmp8_);
				g_object_ref_sink (_tmp9_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp9_;
				break;
			}
			case PROP_TYPE_MENU:
			{
				IBusProperty* _tmp10_;
				PropMenuToolButton* _tmp11_;
				_tmp10_ = prop;
				_tmp11_ = prop_menu_tool_button_new (_tmp10_);
				g_object_ref_sink (_tmp11_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp11_;
				break;
			}
			case PROP_TYPE_SEPARATOR:
			{
				IBusProperty* _tmp12_;
				PropSeparatorToolItem* _tmp13_;
				_tmp12_ = prop;
				_tmp13_ = prop_separator_tool_item_new (_tmp12_);
				g_object_ref_sink (_tmp13_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp13_;
				break;
			}
			default:
			{
				IBusProperty* _tmp14_;
				_tmp14_ = prop;
				g_warning ("propertypanel.vala:288: unknown property type %d", (gint) ibus_property_get_prop_type (_tmp14_));
				break;
			}
		}
		_tmp15_ = item;
		if (_tmp15_ != NULL) {
			IPropToolItem* _tmp16_;
			IPropToolItem* _tmp17_;
			IPropToolItem* _tmp18_;
			IPropToolItem* _tmp19_;
			_tmp16_ = item;
			gtk_box_pack_start ((GtkBox*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp16_) : NULL, FALSE, FALSE, (guint) 0);
			_tmp17_ = item;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_vala_array_add26 (&self->priv->m_items, &self->priv->m_items_length1, &self->priv->_m_items_size_, _tmp18_);
			_tmp19_ = item;
			g_signal_connect_object (_tmp19_, "property-activate", (GCallback) _____lambda58__iprop_tool_item_property_activate, self, 0);
		}
		_g_object_unref0 (item);
		_g_object_unref0 (prop);
	}
}

static void
property_panel_move (PropertyPanel* self,
                     gint x,
                     gint y)
{
	GtkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_move (_tmp0_, x, y);
}

static void
property_panel_adjust_window_position (PropertyPanel* self)
{
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp5_;
	GtkAllocation _tmp6_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp7_;
	GtkAllocation _tmp8_;
	GdkPoint _tmp9_;
	GtkAllocation _tmp10_;
	GdkPoint _tmp11_ = {0};
	gint root_width = 0;
	GdkWindow* _tmp12_;
	gint root_height = 0;
	GdkWindow* _tmp13_;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp14_;
	GdkPoint _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = self->priv->m_cursor_location;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = self->priv->m_cursor_location;
	_tmp4_.x = _tmp0_.x + _tmp1_.width;
	_tmp4_.y = _tmp2_.y + _tmp3_.height;
	cursor_right_bottom = _tmp4_;
	_tmp5_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp5_, &_tmp6_);
	allocation = _tmp6_;
	_tmp7_ = cursor_right_bottom;
	_tmp8_ = allocation;
	_tmp9_ = cursor_right_bottom;
	_tmp10_ = allocation;
	_tmp11_.x = _tmp7_.x + _tmp8_.width;
	_tmp11_.y = _tmp9_.y + _tmp10_.height;
	window_right_bottom = _tmp11_;
	_tmp12_ = self->priv->m_root_window;
	root_width = gdk_window_get_width (_tmp12_);
	_tmp13_ = self->priv->m_root_window;
	root_height = gdk_window_get_height (_tmp13_);
	_tmp14_ = window_right_bottom;
	if (_tmp14_.x > root_width) {
		GtkAllocation _tmp15_;
		_tmp15_ = allocation;
		x = root_width - _tmp15_.width;
	} else {
		GdkPoint _tmp16_;
		_tmp16_ = cursor_right_bottom;
		x = _tmp16_.x;
	}
	_tmp17_ = window_right_bottom;
	if (_tmp17_.y > root_height) {
		GdkRectangle _tmp18_;
		GtkAllocation _tmp19_;
		_tmp18_ = self->priv->m_cursor_location;
		_tmp19_ = allocation;
		y = _tmp18_.y - _tmp19_.height;
	} else {
		GdkPoint _tmp20_;
		_tmp20_ = cursor_right_bottom;
		y = _tmp20_.y;
	}
	property_panel_move (self, x, y);
}

static gboolean
property_panel_is_bottom_panel (PropertyPanel* self)
{
	gchar* desktop = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp1_ = g_strdup (_tmp0_);
	desktop = _tmp1_;
	_tmp2_ = desktop;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = g_getenv ("XDG_SESSION_DESKTOP");
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (desktop);
		desktop = _tmp4_;
	}
	_tmp5_ = desktop;
	_tmp6_ = _tmp5_;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("KDE")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (desktop);
				return result;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("LXDE")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				_g_free0 (desktop);
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				_g_free0 (desktop);
				return result;
			}
		}
	}
}

static void
property_panel_set_default_location (PropertyPanel* self)
{
	GtkAllocation allocation = {0};
	GtkWindow* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GdkRectangle monitor_area = {0};
	GdkMonitor* monitor = NULL;
	GdkDisplay* _tmp2_;
	GdkMonitor* _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkRectangle _tmp6_ = {0};
	gint monitor_right = 0;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	gint monitor_bottom = 0;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	gint x = 0;
	gint y = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
	allocation = _tmp1_;
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_display_get_monitor (_tmp2_, 0);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	monitor = _tmp4_;
	_tmp5_ = monitor;
	gdk_monitor_get_workarea (_tmp5_, &_tmp6_);
	monitor_area = _tmp6_;
	_tmp7_ = monitor_area;
	_tmp8_ = monitor_area;
	monitor_right = _tmp7_.x + _tmp8_.width;
	_tmp9_ = monitor_area;
	_tmp10_ = monitor_area;
	monitor_bottom = _tmp9_.y + _tmp10_.height;
	if (property_panel_is_bottom_panel (self)) {
		if (g_strcmp0 (_ ("default:LTR"), "default:RTL") != 0) {
			GtkAllocation _tmp11_;
			GtkAllocation _tmp12_;
			_tmp11_ = allocation;
			x = monitor_right - _tmp11_.width;
			_tmp12_ = allocation;
			y = monitor_bottom - _tmp12_.height;
		} else {
			GdkRectangle _tmp13_;
			GtkAllocation _tmp14_;
			_tmp13_ = monitor_area;
			x = _tmp13_.x;
			_tmp14_ = allocation;
			y = monitor_bottom - _tmp14_.height;
		}
	} else {
		if (g_strcmp0 (_ ("default:LTR"), "default:RTL") != 0) {
			GtkAllocation _tmp15_;
			GdkRectangle _tmp16_;
			_tmp15_ = allocation;
			x = monitor_right - _tmp15_.width;
			_tmp16_ = monitor_area;
			y = _tmp16_.y;
		} else {
			GdkRectangle _tmp17_;
			GdkRectangle _tmp18_;
			_tmp17_ = monitor_area;
			x = _tmp17_.x;
			_tmp18_ = monitor_area;
			y = _tmp18_.y;
		}
	}
	property_panel_move (self, x, y);
	_g_object_unref0 (monitor);
}

static GdkFilterReturn
_property_panel_root_window_filter_gdk_filter_func (GdkXEvent* xevent,
                                                    GdkEvent* event,
                                                    gpointer self)
{
	GdkFilterReturn result;
	result = property_panel_root_window_filter ((PropertyPanel*) self, xevent, event);
	return result;
}

static GdkFilterReturn
property_panel_root_window_filter (PropertyPanel* self,
                                   GdkXEvent* gdkxevent,
                                   GdkEvent* event)
{
	XEvent* xevent = NULL;
	XEvent* _tmp0_;
	GdkFilterReturn result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (gdkxevent != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	xevent = (XEvent*) gdkxevent;
	_tmp0_ = xevent;
	if ((*_tmp0_).type == ((gint) PropertyNotify)) {
		Display* _tmp1_;
		gchar* aname = NULL;
		Display* _tmp2_;
		XEvent* _tmp3_;
		XPropertyEvent _tmp4_;
		gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_;
		_tmp1_ = self->priv->m_xdisplay;
		if (_tmp1_ == NULL) {
			if (self->priv->m_remove_filter_id > ((guint) 0)) {
				g_source_remove (self->priv->m_remove_filter_id);
				self->priv->m_remove_filter_id = (guint) 0;
			}
			result = GDK_FILTER_CONTINUE;
			return result;
		}
		_tmp2_ = self->priv->m_xdisplay;
		_tmp3_ = xevent;
		_tmp4_ = (*_tmp3_).xproperty;
		_tmp5_ = XGetAtomName (_tmp2_, _tmp4_.atom);
		aname = _tmp5_;
		_tmp7_ = aname;
		if (g_strcmp0 (_tmp7_, "_NET_WORKAREA") == 0) {
			XEvent* _tmp8_;
			XPropertyEvent _tmp9_;
			_tmp8_ = xevent;
			_tmp9_ = (*_tmp8_).xproperty;
			_tmp6_ = _tmp9_.state == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GdkWindow* _tmp10_;
			property_panel_set_default_location (self);
			_tmp10_ = self->priv->m_root_window;
			gdk_window_remove_filter (_tmp10_, _property_panel_root_window_filter_gdk_filter_func, self);
			if (self->priv->m_remove_filter_id > ((guint) 0)) {
				g_source_remove (self->priv->m_remove_filter_id);
				self->priv->m_remove_filter_id = (guint) 0;
			}
			result = GDK_FILTER_CONTINUE;
			_g_free0 (aname);
			return result;
		}
		_g_free0 (aname);
	}
	result = GDK_FILTER_CONTINUE;
	return result;
}

static gboolean
__lambda54_ (PropertyPanel* self)
{
	GdkWindow* _tmp0_;
	gboolean result;
	self->priv->m_remove_filter_id = (guint) 0;
	_tmp0_ = self->priv->m_root_window;
	gdk_window_remove_filter (_tmp0_, _property_panel_root_window_filter_gdk_filter_func, self);
	result = FALSE;
	return result;
}

static gboolean
___lambda54__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda54_ ((PropertyPanel*) self);
	return result;
}

static void
property_panel_monitor_net_workarea_atom (PropertyPanel* self)
{
	GdkEventMask events = 0U;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_root_window;
	events = gdk_window_get_events (_tmp0_);
	if ((events & GDK_PROPERTY_CHANGE_MASK) == 0) {
		GdkWindow* _tmp1_;
		_tmp1_ = self->priv->m_root_window;
		gdk_window_set_events (_tmp1_, events | GDK_PROPERTY_CHANGE_MASK);
	}
	_tmp2_ = self->priv->m_root_window;
	gdk_window_add_filter (_tmp2_, _property_panel_root_window_filter_gdk_filter_func, self);
	self->priv->m_remove_filter_id = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, PROPERTY_PANEL_MONITOR_NET_WORKAREA_TIMEOUT, ___lambda54__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda59_ (PropertyPanel* self)
{
	GtkWindow* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->m_auto_hide_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda59__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda59_ ((PropertyPanel*) self);
	return result;
}

static void
property_panel_show_with_auto_hide_timer (PropertyPanel* self)
{
	GtkWindow* _tmp0_;
	IPropToolItem** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp4_ = FALSE;
	GdkRectangle _tmp5_;
	GtkWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp0_, 1, 1);
	_tmp1_ = self->priv->m_items;
	_tmp1__length1 = self->priv->m_items_length1;
	if (_tmp1__length1 == 0) {
		gboolean _tmp2_ = FALSE;
		if (self->priv->m_follow_input_cursor_when_always_shown) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->m_show != ((gint) PANEL_SHOW_ALWAYS);
		}
		if (_tmp2_) {
			GtkWindow* _tmp3_;
			_tmp3_ = self->priv->m_toplevel;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		}
		return;
	}
	if (self->priv->m_show != ((gint) PANEL_SHOW_AUTO_HIDE)) {
		property_panel_show (self);
		return;
	}
	_tmp5_ = self->priv->m_cursor_location;
	if (_tmp5_.x == -1) {
		GdkRectangle _tmp6_;
		_tmp6_ = self->priv->m_cursor_location;
		_tmp4_ = _tmp6_.y == -1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		return;
	}
	if (self->priv->m_auto_hide_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->m_auto_hide_timeout_id);
	}
	_tmp7_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp7_);
	self->priv->m_auto_hide_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->m_auto_hide_timeout, ___lambda59__gsource_func, g_object_ref (self), g_object_unref);
}

static void
property_panel_hide_if_necessary (PropertyPanel* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->m_show == ((gint) PANEL_SHOW_AUTO_HIDE)) {
		_tmp0_ = self->priv->m_auto_hide_timeout_id != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkWindow* _tmp1_;
		g_source_remove (self->priv->m_auto_hide_timeout_id);
		self->priv->m_auto_hide_timeout_id = (guint) 0;
		_tmp1_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure,
                                          GValue * return_value,
                                          guint n_param_values,
                                          const GValue * param_values,
                                          gpointer invocation_hint,
                                          gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
property_panel_class_init (PropertyPanelClass * klass,
                           gpointer klass_data)
{
	property_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PropertyPanel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = property_panel_finalize;
	property_panel_signals[PROPERTY_PANEL_PROPERTY_ACTIVATE_SIGNAL] = g_signal_new ("property-activate", TYPE_PROPERTY_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
}

static void
property_panel_instance_init (PropertyPanel * self,
                              gpointer klass)
{
	GdkRectangle _tmp0_ = {0};
	self->priv = property_panel_get_instance_private (self);
	memset (&_tmp0_, 0, sizeof (GdkRectangle));
	_tmp0_.x = -1;
	_tmp0_.y = -1;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	self->priv->m_cursor_location = _tmp0_;
	self->priv->m_show = (gint) PANEL_SHOW_DO_NOT_SHOW;
	self->priv->m_auto_hide_timeout = (guint) 10000;
	self->priv->m_auto_hide_timeout_id = (guint) 0;
	self->priv->m_follow_input_cursor_when_always_shown = FALSE;
}

static void
property_panel_finalize (GObject * obj)
{
	PropertyPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTY_PANEL, PropertyPanel);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_props);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (property_panel_parent_class)->finalize (obj);
}

static GType
property_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropertyPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) property_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropertyPanel), 0, (GInstanceInitFunc) property_panel_instance_init, NULL };
	GType property_panel_type_id;
	property_panel_type_id = g_type_register_static (gtk_box_get_type (), "PropertyPanel", &g_define_type_info, 0);
	PropertyPanel_private_offset = g_type_add_instance_private (property_panel_type_id, sizeof (PropertyPanelPrivate));
	return property_panel_type_id;
}

GType
property_panel_get_type (void)
{
	static volatile gsize property_panel_type_id__once = 0;
	if (g_once_init_enter (&property_panel_type_id__once)) {
		GType property_panel_type_id;
		property_panel_type_id = property_panel_get_type_once ();
		g_once_init_leave (&property_panel_type_id__once, property_panel_type_id);
	}
	return property_panel_type_id__once;
}

void
iprop_tool_item_update_property (IPropToolItem* self,
                                 IBusProperty* prop)
{
	IPropToolItemIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = IPROP_TOOL_ITEM_GET_INTERFACE (self);
	if (_iface_->update_property) {
		_iface_->update_property (self, prop);
	}
}

static void
iprop_tool_item_default_init (IPropToolItemIface * iface,
                              gpointer iface_data)
{
	iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL] = g_signal_new ("property-activate", TYPE_IPROP_TOOL_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
}

static GType
iprop_tool_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (IPropToolItemIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iprop_tool_item_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType iprop_tool_item_type_id;
	iprop_tool_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "IPropToolItem", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (iprop_tool_item_type_id, G_TYPE_OBJECT);
	return iprop_tool_item_type_id;
}

GType
iprop_tool_item_get_type (void)
{
	static volatile gsize iprop_tool_item_type_id__once = 0;
	if (g_once_init_enter (&iprop_tool_item_type_id__once)) {
		GType iprop_tool_item_type_id;
		iprop_tool_item_type_id = iprop_tool_item_get_type_once ();
		g_once_init_leave (&iprop_tool_item_type_id__once, iprop_tool_item_type_id);
	}
	return iprop_tool_item_type_id__once;
}

static inline gpointer
prop_menu_get_instance_private (PropMenu* self)
{
	return G_STRUCT_MEMBER_P (self, PropMenu_private_offset);
}

PropMenu*
prop_menu_construct (GType object_type,
                     IBusProperty* prop)
{
	PropMenu * self = NULL;
	IBusPropList* _tmp0_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropMenu*) g_object_new (object_type, NULL);
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) self, FALSE);
	_tmp0_ = ibus_property_get_sub_props (prop);
	prop_menu_create_items (self, _tmp0_);
	gtk_widget_show_all ((GtkWidget*) self);
	gtk_widget_set_sensitive ((GtkWidget*) self, ibus_property_get_sensitive (prop));
	return self;
}

PropMenu*
prop_menu_new (IBusProperty* prop)
{
	return prop_menu_construct (TYPE_PROP_MENU, prop);
}

static void
prop_menu_real_update_property (IPropToolItem* base,
                                IBusProperty* prop)
{
	PropMenu * self;
	IPropItem** _tmp0_;
	gint _tmp0__length1;
	self = (PropMenu*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			IPropItem* _tmp1_;
			IPropItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				IPropItem* _tmp2_;
				_tmp2_ = item;
				iprop_item_update_property (_tmp2_, prop);
				_g_object_unref0 (item);
			}
		}
	}
}

void
prop_menu_popup (PropMenu* self,
                 guint button,
                 guint32 activate_time,
                 GtkWidget* widget)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_menu_popup_at_widget (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_menu_get_type (), GtkMenu), widget, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
}

static void
prop_menu_real_destroy (GtkWidget* base)
{
	PropMenu * self;
	IPropItem** _tmp0_;
	gint _tmp0__length1;
	IPropItem** _tmp3_;
	self = (PropMenu*) base;
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_parent_button = NULL;
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < item_collection_length1; item_it = item_it + 1) {
			IPropItem* _tmp1_;
			IPropItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				IPropItem* _tmp2_;
				_tmp2_ = item;
				gtk_container_remove ((GtkContainer*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp2_) : NULL);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp3_ = g_new0 (IPropItem*, 0 + 1);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_items = _tmp3_;
	self->priv->m_items_length1 = 0;
	self->priv->_m_items_size_ = self->priv->m_items_length1;
	GTK_WIDGET_CLASS (prop_menu_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_menu_get_type (), GtkMenu));
}

static void
____lambda55_ (PropMenu* self,
               IPropItem* w,
               const gchar* k,
               gint s)
{
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, k, s);
}

static void
_____lambda55__iprop_item_property_activate (IPropItem* _sender,
                                             const gchar* key,
                                             gint state,
                                             gpointer self)
{
	____lambda55_ ((PropMenu*) self, _sender, key, state);
}

static void
_vala_array_add27 (IPropItem** * array,
                   gint* length,
                   gint* size,
                   IPropItem* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IPropItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
prop_menu_create_items (PropMenu* self,
                        IBusPropList* props)
{
	gint i = 0;
	PropRadioMenuItem* last_radio = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	i = 0;
	last_radio = NULL;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusProperty* _tmp0_;
		IBusProperty* _tmp1_;
		IBusProperty* _tmp2_;
		gint _tmp3_;
		IPropItem* item = NULL;
		IBusProperty* _tmp4_;
		IBusProperty* _tmp25_;
		IPropItem* _tmp26_;
		_tmp0_ = ibus_prop_list_get (props, (guint) i);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		prop = _tmp1_;
		_tmp2_ = prop;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp3_ = i;
		i = _tmp3_ + 1;
		item = NULL;
		_tmp4_ = prop;
		switch (ibus_property_get_prop_type (_tmp4_)) {
			case PROP_TYPE_NORMAL:
			{
				IBusProperty* _tmp5_;
				PropImageMenuItem* _tmp6_;
				_tmp5_ = prop;
				_tmp6_ = prop_image_menu_item_new (_tmp5_);
				g_object_ref_sink (_tmp6_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp6_;
				break;
			}
			case PROP_TYPE_TOGGLE:
			{
				IBusProperty* _tmp7_;
				PropCheckMenuItem* _tmp8_;
				_tmp7_ = prop;
				_tmp8_ = prop_check_menu_item_new (_tmp7_);
				g_object_ref_sink (_tmp8_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp8_;
				break;
			}
			case PROP_TYPE_RADIO:
			{
				IBusProperty* _tmp9_;
				PropRadioMenuItem* _tmp10_;
				PropRadioMenuItem* _tmp11_;
				PropRadioMenuItem* _tmp12_;
				IPropItem* _tmp13_;
				_tmp9_ = prop;
				_tmp10_ = last_radio;
				_tmp11_ = prop_radio_menu_item_new (_tmp9_, _tmp10_);
				g_object_ref_sink (_tmp11_);
				_g_object_unref0 (last_radio);
				last_radio = _tmp11_;
				_tmp12_ = last_radio;
				_tmp13_ = _g_object_ref0 ((IPropItem*) _tmp12_);
				_g_object_unref0 (item);
				item = _tmp13_;
				break;
			}
			case PROP_TYPE_MENU:
			{
				{
					PropImageMenuItem* menuitem = NULL;
					IBusProperty* _tmp14_;
					PropImageMenuItem* _tmp15_;
					PropImageMenuItem* _tmp16_;
					IBusProperty* _tmp17_;
					PropMenu* _tmp18_;
					PropMenu* _tmp19_;
					PropImageMenuItem* _tmp20_;
					IPropItem* _tmp21_;
					_tmp14_ = prop;
					_tmp15_ = prop_image_menu_item_new (_tmp14_);
					g_object_ref_sink (_tmp15_);
					menuitem = _tmp15_;
					_tmp16_ = menuitem;
					_tmp17_ = prop;
					_tmp18_ = prop_menu_new (_tmp17_);
					g_object_ref_sink (_tmp18_);
					_tmp19_ = _tmp18_;
					gtk_menu_item_set_submenu ((GtkMenuItem*) _tmp16_, (GtkMenu*) _tmp19_);
					_g_object_unref0 (_tmp19_);
					_tmp20_ = menuitem;
					_tmp21_ = _g_object_ref0 ((IPropItem*) _tmp20_);
					_g_object_unref0 (item);
					item = _tmp21_;
					_g_object_unref0 (menuitem);
				}
				break;
			}
			case PROP_TYPE_SEPARATOR:
			{
				IBusProperty* _tmp22_;
				PropSeparatorMenuItem* _tmp23_;
				_tmp22_ = prop;
				_tmp23_ = prop_separator_menu_item_new (_tmp22_);
				g_object_ref_sink (_tmp23_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp23_;
				break;
			}
			default:
			{
				IBusProperty* _tmp24_;
				_tmp24_ = prop;
				g_warning ("propertypanel.vala:567: Unknown property type: %d", (gint) ibus_property_get_prop_type (_tmp24_));
				break;
			}
		}
		_tmp25_ = prop;
		if (ibus_property_get_prop_type (_tmp25_) != PROP_TYPE_RADIO) {
			_g_object_unref0 (last_radio);
			last_radio = NULL;
		}
		_tmp26_ = item;
		if (_tmp26_ != NULL) {
			IPropItem* _tmp27_;
			IPropItem* _tmp28_;
			IPropItem* _tmp29_;
			IPropItem* _tmp30_;
			_tmp27_ = item;
			gtk_menu_shell_append ((GtkMenuShell*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp27_) : NULL);
			_tmp28_ = item;
			g_signal_connect_object (_tmp28_, "property-activate", (GCallback) _____lambda55__iprop_item_property_activate, self, 0);
			_tmp29_ = item;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			_vala_array_add27 (&self->priv->m_items, &self->priv->m_items_length1, &self->priv->_m_items_size_, _tmp30_);
		}
		_g_object_unref0 (item);
		_g_object_unref0 (prop);
	}
	_g_object_unref0 (last_radio);
}

static void
prop_menu_class_init (PropMenuClass * klass,
                      gpointer klass_data)
{
	prop_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PropMenu_private_offset);
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) prop_menu_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = prop_menu_finalize;
}

static void
prop_menu_iprop_tool_item_interface_init (IPropToolItemIface * iface,
                                          gpointer iface_data)
{
	prop_menu_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem*, IBusProperty*)) prop_menu_real_update_property;
}

static void
prop_menu_instance_init (PropMenu * self,
                         gpointer klass)
{
	self->priv = prop_menu_get_instance_private (self);
}

static void
prop_menu_finalize (GObject * obj)
{
	PropMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_MENU, PropMenu);
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (prop_menu_parent_class)->finalize (obj);
}

static GType
prop_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropMenu), 0, (GInstanceInitFunc) prop_menu_instance_init, NULL };
	static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_menu_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType prop_menu_type_id;
	prop_menu_type_id = g_type_register_static (gtk_menu_get_type (), "PropMenu", &g_define_type_info, 0);
	g_type_add_interface_static (prop_menu_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
	PropMenu_private_offset = g_type_add_instance_private (prop_menu_type_id, sizeof (PropMenuPrivate));
	return prop_menu_type_id;
}

GType
prop_menu_get_type (void)
{
	static volatile gsize prop_menu_type_id__once = 0;
	if (g_once_init_enter (&prop_menu_type_id__once)) {
		GType prop_menu_type_id;
		prop_menu_type_id = prop_menu_get_type_once ();
		g_once_init_leave (&prop_menu_type_id__once, prop_menu_type_id);
	}
	return prop_menu_type_id__once;
}

static inline gpointer
prop_tool_button_get_instance_private (PropToolButton* self)
{
	return G_STRUCT_MEMBER_P (self, PropToolButton_private_offset);
}

PropToolButton*
prop_tool_button_construct (GType object_type,
                            IBusProperty* prop)
{
	PropToolButton * self = NULL;
	IBusProperty* _tmp0_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropToolButton*) g_object_new (object_type, "halign", GTK_ALIGN_START, NULL);
	_tmp0_ = _g_object_ref0 (prop);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp0_;
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	prop_tool_button_sync (self);
	return self;
}

PropToolButton*
prop_tool_button_new (IBusProperty* prop)
{
	return prop_tool_button_construct (TYPE_PROP_TOOL_BUTTON, prop);
}

static void
prop_tool_button_real_update_property (IPropToolItem* base,
                                       IBusProperty* prop)
{
	PropToolButton * self;
	IBusProperty* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	IBusProperty* _tmp5_;
	IBusText* _tmp6_;
	IBusProperty* _tmp7_;
	IBusProperty* _tmp8_;
	const gchar* _tmp9_;
	IBusProperty* _tmp10_;
	IBusProperty* _tmp11_;
	self = (PropToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = ibus_property_get_key (prop);
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		return;
	}
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_symbol (prop);
	ibus_property_set_symbol (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->m_prop;
	_tmp6_ = ibus_property_get_tooltip (prop);
	ibus_property_set_tooltip (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->m_prop;
	ibus_property_set_sensitive (_tmp7_, ibus_property_get_sensitive (prop));
	_tmp8_ = self->priv->m_prop;
	_tmp9_ = ibus_property_get_icon (prop);
	ibus_property_set_icon (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	ibus_property_set_state (_tmp10_, ibus_property_get_state (prop));
	_tmp11_ = self->priv->m_prop;
	ibus_property_set_visible (_tmp11_, ibus_property_get_visible (prop));
	prop_tool_button_sync (self);
}

static void
prop_tool_button_sync (PropToolButton* self)
{
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	const gchar* _tmp5_;
	IBusProperty* _tmp6_;
	IBusProperty* _tmp7_;
	const gchar* _tmp8_;
	IBusProperty* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp2_);
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_tooltip (_tmp3_);
	_tmp5_ = ibus_text_get_text (_tmp4_);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self, _tmp5_);
	_tmp6_ = self->priv->m_prop;
	gtk_widget_set_sensitive ((GtkWidget*) self, ibus_property_get_sensitive (_tmp6_));
	_tmp7_ = self->priv->m_prop;
	_tmp8_ = ibus_property_get_icon (_tmp7_);
	prop_tool_button_set_icon_name (self, _tmp8_);
	_tmp9_ = self->priv->m_prop;
	if (ibus_property_get_visible (_tmp9_)) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}

static void
prop_tool_button_real_clicked (GtkToolButton* base)
{
	PropToolButton * self;
	IBusProperty* _tmp0_;
	const gchar* _tmp1_;
	IBusProperty* _tmp2_;
	self = (PropToolButton*) base;
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = self->priv->m_prop;
	g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, _tmp1_, (gint) ibus_property_get_state (_tmp2_));
}

void
prop_tool_button_set_icon_name (PropToolButton* self,
                                const gchar* icon_name)
{
	gchar* label = NULL;
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	IconWidget* icon_widget = NULL;
	const gchar* _tmp4_;
	IconWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	icon_widget = NULL;
	_tmp4_ = label;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		IconWidget* _tmp5_;
		_g_free0 (label);
		label = NULL;
		_tmp5_ = icon_widget_new (icon_name, GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (icon_widget);
		icon_widget = _tmp5_;
		gtk_tool_item_set_is_important ((GtkToolItem*) self, FALSE);
	} else {
		gtk_tool_item_set_is_important ((GtkToolItem*) self, TRUE);
	}
	_tmp6_ = icon_widget;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) _tmp6_);
	_g_object_unref0 (icon_widget);
	_g_free0 (label);
}

static void
prop_tool_button_class_init (PropToolButtonClass * klass,
                             gpointer klass_data)
{
	prop_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PropToolButton_private_offset);
	((GtkToolButtonClass *) klass)->clicked = (void (*) (GtkToolButton*)) prop_tool_button_real_clicked;
	G_OBJECT_CLASS (klass)->finalize = prop_tool_button_finalize;
}

static void
prop_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface,
                                                 gpointer iface_data)
{
	prop_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem*, IBusProperty*)) prop_tool_button_real_update_property;
}

static void
prop_tool_button_instance_init (PropToolButton * self,
                                gpointer klass)
{
	self->priv = prop_tool_button_get_instance_private (self);
	self->priv->m_prop = NULL;
}

static void
prop_tool_button_finalize (GObject * obj)
{
	PropToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_TOOL_BUTTON, PropToolButton);
	_g_object_unref0 (self->priv->m_prop);
	G_OBJECT_CLASS (prop_tool_button_parent_class)->finalize (obj);
}

static GType
prop_tool_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropToolButton), 0, (GInstanceInitFunc) prop_tool_button_instance_init, NULL };
	static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType prop_tool_button_type_id;
	prop_tool_button_type_id = g_type_register_static (gtk_tool_button_get_type (), "PropToolButton", &g_define_type_info, 0);
	g_type_add_interface_static (prop_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
	PropToolButton_private_offset = g_type_add_instance_private (prop_tool_button_type_id, sizeof (PropToolButtonPrivate));
	return prop_tool_button_type_id;
}

GType
prop_tool_button_get_type (void)
{
	static volatile gsize prop_tool_button_type_id__once = 0;
	if (g_once_init_enter (&prop_tool_button_type_id__once)) {
		GType prop_tool_button_type_id;
		prop_tool_button_type_id = prop_tool_button_get_type_once ();
		g_once_init_leave (&prop_tool_button_type_id__once, prop_tool_button_type_id);
	}
	return prop_tool_button_type_id__once;
}

static inline gpointer
prop_toggle_tool_button_get_instance_private (PropToggleToolButton* self)
{
	return G_STRUCT_MEMBER_P (self, PropToggleToolButton_private_offset);
}

PropToggleToolButton*
prop_toggle_tool_button_construct (GType object_type,
                                   IBusProperty* prop)
{
	PropToggleToolButton * self = NULL;
	IBusProperty* _tmp0_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropToggleToolButton*) g_object_new (object_type, "halign", GTK_ALIGN_START, NULL);
	_tmp0_ = _g_object_ref0 (prop);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp0_;
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	prop_toggle_tool_button_sync (self);
	return self;
}

PropToggleToolButton*
prop_toggle_tool_button_new (IBusProperty* prop)
{
	return prop_toggle_tool_button_construct (TYPE_PROP_TOGGLE_TOOL_BUTTON, prop);
}

void
prop_toggle_tool_button_set_property (PropToggleToolButton* self,
                                      IBusProperty* prop)
{
	IBusProperty* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = _g_object_ref0 (prop);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp0_;
	prop_toggle_tool_button_sync (self);
}

static void
prop_toggle_tool_button_real_update_property (IPropToolItem* base,
                                              IBusProperty* prop)
{
	PropToggleToolButton * self;
	IBusProperty* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	IBusProperty* _tmp5_;
	IBusText* _tmp6_;
	IBusProperty* _tmp7_;
	IBusProperty* _tmp8_;
	const gchar* _tmp9_;
	IBusProperty* _tmp10_;
	IBusProperty* _tmp11_;
	self = (PropToggleToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = ibus_property_get_key (prop);
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		return;
	}
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_symbol (prop);
	ibus_property_set_symbol (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->m_prop;
	_tmp6_ = ibus_property_get_tooltip (prop);
	ibus_property_set_tooltip (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->m_prop;
	ibus_property_set_sensitive (_tmp7_, ibus_property_get_sensitive (prop));
	_tmp8_ = self->priv->m_prop;
	_tmp9_ = ibus_property_get_icon (prop);
	ibus_property_set_icon (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	ibus_property_set_state (_tmp10_, ibus_property_get_state (prop));
	_tmp11_ = self->priv->m_prop;
	ibus_property_set_visible (_tmp11_, ibus_property_get_visible (prop));
	prop_toggle_tool_button_sync (self);
}

static void
prop_toggle_tool_button_sync (PropToggleToolButton* self)
{
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	IBusProperty* _tmp3_;
	IBusText* _tmp4_;
	const gchar* _tmp5_;
	IBusProperty* _tmp6_;
	IBusProperty* _tmp7_;
	const gchar* _tmp8_;
	IBusProperty* _tmp9_;
	IBusProperty* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp2_);
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_tooltip (_tmp3_);
	_tmp5_ = ibus_text_get_text (_tmp4_);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self, _tmp5_);
	_tmp6_ = self->priv->m_prop;
	gtk_widget_set_sensitive ((GtkWidget*) self, ibus_property_get_sensitive (_tmp6_));
	_tmp7_ = self->priv->m_prop;
	_tmp8_ = ibus_property_get_icon (_tmp7_);
	prop_toggle_tool_button_set_icon_name (self, _tmp8_);
	_tmp9_ = self->priv->m_prop;
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) self, ibus_property_get_state (_tmp9_) == PROP_STATE_CHECKED);
	_tmp10_ = self->priv->m_prop;
	if (ibus_property_get_visible (_tmp10_)) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}

static void
prop_toggle_tool_button_real_toggled (GtkToggleToolButton* base)
{
	PropToggleToolButton * self;
	gboolean do_emit = FALSE;
	self = (PropToggleToolButton*) base;
	do_emit = FALSE;
	if (gtk_toggle_tool_button_get_active ((GtkToggleToolButton*) self)) {
		IBusProperty* _tmp0_;
		IBusProperty* _tmp1_;
		_tmp0_ = self->priv->m_prop;
		if (ibus_property_get_state (_tmp0_) != PROP_STATE_CHECKED) {
			do_emit = TRUE;
		}
		_tmp1_ = self->priv->m_prop;
		ibus_property_set_state (_tmp1_, PROP_STATE_CHECKED);
	} else {
		IBusProperty* _tmp2_;
		IBusProperty* _tmp3_;
		_tmp2_ = self->priv->m_prop;
		if (ibus_property_get_state (_tmp2_) != PROP_STATE_UNCHECKED) {
			do_emit = TRUE;
		}
		_tmp3_ = self->priv->m_prop;
		ibus_property_set_state (_tmp3_, PROP_STATE_UNCHECKED);
	}
	if (do_emit) {
		IBusProperty* _tmp4_;
		const gchar* _tmp5_;
		IBusProperty* _tmp6_;
		_tmp4_ = self->priv->m_prop;
		_tmp5_ = ibus_property_get_key (_tmp4_);
		_tmp6_ = self->priv->m_prop;
		g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, _tmp5_, (gint) ibus_property_get_state (_tmp6_));
	}
}

void
prop_toggle_tool_button_set_icon_name (PropToggleToolButton* self,
                                       const gchar* icon_name)
{
	gchar* label = NULL;
	IBusProperty* _tmp0_;
	IBusText* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	IconWidget* icon_widget = NULL;
	const gchar* _tmp4_;
	IconWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	icon_widget = NULL;
	_tmp4_ = label;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		IconWidget* _tmp5_;
		_g_free0 (label);
		label = NULL;
		_tmp5_ = icon_widget_new (icon_name, GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (icon_widget);
		icon_widget = _tmp5_;
		gtk_tool_item_set_is_important ((GtkToolItem*) self, FALSE);
	} else {
		gtk_tool_item_set_is_important ((GtkToolItem*) self, TRUE);
	}
	_tmp6_ = icon_widget;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) _tmp6_);
	_g_object_unref0 (icon_widget);
	_g_free0 (label);
}

static void
prop_toggle_tool_button_class_init (PropToggleToolButtonClass * klass,
                                    gpointer klass_data)
{
	prop_toggle_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PropToggleToolButton_private_offset);
	((GtkToggleToolButtonClass *) klass)->toggled = (void (*) (GtkToggleToolButton*)) prop_toggle_tool_button_real_toggled;
	G_OBJECT_CLASS (klass)->finalize = prop_toggle_tool_button_finalize;
}

static void
prop_toggle_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface,
                                                        gpointer iface_data)
{
	prop_toggle_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem*, IBusProperty*)) prop_toggle_tool_button_real_update_property;
}

static void
prop_toggle_tool_button_instance_init (PropToggleToolButton * self,
                                       gpointer klass)
{
	self->priv = prop_toggle_tool_button_get_instance_private (self);
	self->priv->m_prop = NULL;
}

static void
prop_toggle_tool_button_finalize (GObject * obj)
{
	PropToggleToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton);
	_g_object_unref0 (self->priv->m_prop);
	G_OBJECT_CLASS (prop_toggle_tool_button_parent_class)->finalize (obj);
}

static GType
prop_toggle_tool_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropToggleToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_toggle_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropToggleToolButton), 0, (GInstanceInitFunc) prop_toggle_tool_button_instance_init, NULL };
	static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_toggle_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType prop_toggle_tool_button_type_id;
	prop_toggle_tool_button_type_id = g_type_register_static (gtk_toggle_tool_button_get_type (), "PropToggleToolButton", &g_define_type_info, 0);
	g_type_add_interface_static (prop_toggle_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
	PropToggleToolButton_private_offset = g_type_add_instance_private (prop_toggle_tool_button_type_id, sizeof (PropToggleToolButtonPrivate));
	return prop_toggle_tool_button_type_id;
}

GType
prop_toggle_tool_button_get_type (void)
{
	static volatile gsize prop_toggle_tool_button_type_id__once = 0;
	if (g_once_init_enter (&prop_toggle_tool_button_type_id__once)) {
		GType prop_toggle_tool_button_type_id;
		prop_toggle_tool_button_type_id = prop_toggle_tool_button_get_type_once ();
		g_once_init_leave (&prop_toggle_tool_button_type_id__once, prop_toggle_tool_button_type_id);
	}
	return prop_toggle_tool_button_type_id__once;
}

static inline gpointer
prop_menu_tool_button_get_instance_private (PropMenuToolButton* self)
{
	return G_STRUCT_MEMBER_P (self, PropMenuToolButton_private_offset);
}

static void
__lambda56_ (PropMenuToolButton* self,
             GtkMenuShell* m)
{
	g_return_if_fail (m != NULL);
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) self, FALSE);
}

static void
___lambda56__gtk_menu_shell_deactivate (GtkMenuShell* _sender,
                                        gpointer self)
{
	__lambda56_ ((PropMenuToolButton*) self, _sender);
}

static void
__lambda57_ (PropMenuToolButton* self,
             const gchar* k,
             gint s)
{
	g_return_if_fail (k != NULL);
	g_signal_emit ((IPropToolItem*) self, iprop_tool_item_signals[IPROP_TOOL_ITEM_PROPERTY_ACTIVATE_SIGNAL], 0, k, s);
}

static void
___lambda57__iprop_tool_item_property_activate (IPropToolItem* _sender,
                                                const gchar* key,
                                                gint state,
                                                gpointer self)
{
	__lambda57_ ((PropMenuToolButton*) self, key, state);
}

PropMenuToolButton*
prop_menu_tool_button_construct (GType object_type,
                                 IBusProperty* prop)
{
	PropMenuToolButton * self = NULL;
	PropMenu* _tmp0_;
	PropMenu* _tmp1_;
	PropMenu* _tmp2_;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropMenuToolButton*) g_object_new (object_type, "halign", GTK_ALIGN_START, NULL);
	_tmp0_ = prop_menu_new (prop);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = _tmp0_;
	_tmp1_ = self->priv->m_menu;
	g_signal_connect_object ((GtkMenuShell*) _tmp1_, "deactivate", (GCallback) ___lambda56__gtk_menu_shell_deactivate, self, 0);
	_tmp2_ = self->priv->m_menu;
	g_signal_connect_object ((IPropToolItem*) _tmp2_, "property-activate", (GCallback) ___lambda57__iprop_tool_item_property_activate, self, 0);
	prop_toggle_tool_button_set_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton), prop);
	return self;
}

PropMenuToolButton*
prop_menu_tool_button_new (IBusProperty* prop)
{
	return prop_menu_tool_button_construct (TYPE_PROP_MENU_TOOL_BUTTON, prop);
}

static void
prop_menu_tool_button_real_update_property (IPropToolItem* base,
                                            IBusProperty* prop)
{
	PropMenuToolButton * self;
	PropMenu* _tmp0_;
	self = (PropMenuToolButton*) base;
	g_return_if_fail (prop != NULL);
	prop_menu_tool_button_iprop_tool_item_parent_iface->update_property ((IPropToolItem*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton), prop);
	_tmp0_ = self->priv->m_menu;
	iprop_tool_item_update_property ((IPropToolItem*) _tmp0_, prop);
}

static void
prop_menu_tool_button_real_toggled (GtkToggleToolButton* base)
{
	PropMenuToolButton * self;
	self = (PropMenuToolButton*) base;
	if (gtk_toggle_tool_button_get_active ((GtkToggleToolButton*) self)) {
		PropMenu* _tmp0_;
		_tmp0_ = self->priv->m_menu;
		prop_menu_popup (_tmp0_, (guint) 0, gtk_get_current_event_time (), (GtkWidget*) self);
	}
}

static void
prop_menu_tool_button_real_destroy (GtkWidget* base)
{
	PropMenuToolButton * self;
	self = (PropMenuToolButton*) base;
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = NULL;
	GTK_WIDGET_CLASS (prop_menu_tool_button_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton));
}

static void
prop_menu_tool_button_class_init (PropMenuToolButtonClass * klass,
                                  gpointer klass_data)
{
	prop_menu_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PropMenuToolButton_private_offset);
	((GtkToggleToolButtonClass *) klass)->toggled = (void (*) (GtkToggleToolButton*)) prop_menu_tool_button_real_toggled;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) prop_menu_tool_button_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = prop_menu_tool_button_finalize;
}

static void
prop_menu_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface,
                                                      gpointer iface_data)
{
	prop_menu_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem*, IBusProperty*)) prop_menu_tool_button_real_update_property;
}

static void
prop_menu_tool_button_instance_init (PropMenuToolButton * self,
                                     gpointer klass)
{
	self->priv = prop_menu_tool_button_get_instance_private (self);
	self->priv->m_menu = NULL;
}

static void
prop_menu_tool_button_finalize (GObject * obj)
{
	PropMenuToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButton);
	_g_object_unref0 (self->priv->m_menu);
	G_OBJECT_CLASS (prop_menu_tool_button_parent_class)->finalize (obj);
}

static GType
prop_menu_tool_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropMenuToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_menu_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropMenuToolButton), 0, (GInstanceInitFunc) prop_menu_tool_button_instance_init, NULL };
	static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_menu_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType prop_menu_tool_button_type_id;
	prop_menu_tool_button_type_id = g_type_register_static (TYPE_PROP_TOGGLE_TOOL_BUTTON, "PropMenuToolButton", &g_define_type_info, 0);
	g_type_add_interface_static (prop_menu_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
	PropMenuToolButton_private_offset = g_type_add_instance_private (prop_menu_tool_button_type_id, sizeof (PropMenuToolButtonPrivate));
	return prop_menu_tool_button_type_id;
}

GType
prop_menu_tool_button_get_type (void)
{
	static volatile gsize prop_menu_tool_button_type_id__once = 0;
	if (g_once_init_enter (&prop_menu_tool_button_type_id__once)) {
		GType prop_menu_tool_button_type_id;
		prop_menu_tool_button_type_id = prop_menu_tool_button_get_type_once ();
		g_once_init_leave (&prop_menu_tool_button_type_id__once, prop_menu_tool_button_type_id);
	}
	return prop_menu_tool_button_type_id__once;
}

PropSeparatorToolItem*
prop_separator_tool_item_construct (GType object_type,
                                    IBusProperty* prop)
{
	PropSeparatorToolItem * self = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropSeparatorToolItem*) g_object_new (object_type, NULL);
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	return self;
}

PropSeparatorToolItem*
prop_separator_tool_item_new (IBusProperty* prop)
{
	return prop_separator_tool_item_construct (TYPE_PROP_SEPARATOR_TOOL_ITEM, prop);
}

static void
prop_separator_tool_item_real_update_property (IPropToolItem* base,
                                               IBusProperty* prop)
{
	PropSeparatorToolItem * self;
	self = (PropSeparatorToolItem*) base;
	g_return_if_fail (prop != NULL);
}

static void
prop_separator_tool_item_class_init (PropSeparatorToolItemClass * klass,
                                     gpointer klass_data)
{
	prop_separator_tool_item_parent_class = g_type_class_peek_parent (klass);
}

static void
prop_separator_tool_item_iprop_tool_item_interface_init (IPropToolItemIface * iface,
                                                         gpointer iface_data)
{
	prop_separator_tool_item_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*) (IPropToolItem*, IBusProperty*)) prop_separator_tool_item_real_update_property;
}

static void
prop_separator_tool_item_instance_init (PropSeparatorToolItem * self,
                                        gpointer klass)
{
}

static GType
prop_separator_tool_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PropSeparatorToolItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_separator_tool_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropSeparatorToolItem), 0, (GInstanceInitFunc) prop_separator_tool_item_instance_init, NULL };
	static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_separator_tool_item_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType prop_separator_tool_item_type_id;
	prop_separator_tool_item_type_id = g_type_register_static (gtk_separator_tool_item_get_type (), "PropSeparatorToolItem", &g_define_type_info, 0);
	g_type_add_interface_static (prop_separator_tool_item_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
	return prop_separator_tool_item_type_id;
}

GType
prop_separator_tool_item_get_type (void)
{
	static volatile gsize prop_separator_tool_item_type_id__once = 0;
	if (g_once_init_enter (&prop_separator_tool_item_type_id__once)) {
		GType prop_separator_tool_item_type_id;
		prop_separator_tool_item_type_id = prop_separator_tool_item_get_type_once ();
		g_once_init_leave (&prop_separator_tool_item_type_id__once, prop_separator_tool_item_type_id);
	}
	return prop_separator_tool_item_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

