/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * OMAP44xx SCRM registers and bitfields
 *
 * Copyright (C) 2010 Texas Instruments, Inc.
 *
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_SCRM_44XX_H
#define __ARCH_ARM_MACH_OMAP2_SCRM_44XX_H

#define OMAP4_SCRM_BASE				0x4a30a000

#define OMAP44XX_SCRM_REGADDR(reg)	\
		OMAP2_L4_IO_ADDRESS(OMAP4_SCRM_BASE + (reg))

/* Registers offset */
#define OMAP4_SCRM_CLKSETUPTIME			OMAP44XX_SCRM_REGADDR(0x0100)

/* CLKSETUPTIME */
#define OMAP4_DOWNTIME_SHIFT			16
#define OMAP4_DOWNTIME_MASK			(0x3f << 16)
#define OMAP4_SETUPTIME_SHIFT			0
#define OMAP4_SETUPTIME_MASK			(0xfff << 0)

#endif
