; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown             | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=i686-unknown -mattr=sse2 | FileCheck %s --check-prefixes=CHECK,SSE2
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=CHECK,X64

define i32 @testmsws(float %x) {
; CHECK-LABEL: testmsws:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lroundf # TAILCALL
entry:
  %0 = tail call i32 @llvm.lround.i32.f32(float %x)
  ret i32 %0
}

define i32 @testmswd(double %x) {
; CHECK-LABEL: testmswd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lround # TAILCALL
entry:
  %0 = tail call i32 @llvm.lround.i32.f64(double %x)
  ret i32 %0
}

define i32 @testmsll(x86_fp80 %x) {
; CHECK-LABEL: testmsll:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jmp lroundl # TAILCALL
entry:
  %0 = tail call i32 @llvm.lround.i32.f80(x86_fp80 %x)
  ret i32 %0
}

declare i32 @llvm.lround.i32.f32(float) nounwind readnone
declare i32 @llvm.lround.i32.f64(double) nounwind readnone
declare i32 @llvm.lround.i32.f80(x86_fp80) nounwind readnone
