// RUN: llvm-mc -triple x86_64-unknown-unknown -show-encoding %s | FileCheck %s
// some AMX instruction must use SIB.

// CHECK: tilerelease
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0xc0]
          tilerelease

// CHECK: tilezero %tmm6
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xf0]
          tilezero %tmm6

// CHECK: tilezero %tmm3
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xd8]
          tilezero %tmm3

// CHECK: tilerelease
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0xc0]
          tilerelease

// CHECK: tilezero %tmm6
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xf0]
          tilezero %tmm6

// CHECK: tilezero %tmm3
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xd8]
          tilezero %tmm3

// CHECK: ldtilecfg  268435456(%rbp,%r14,8)
// CHECK: encoding: [0xc4,0xa2,0x78,0x49,0x84,0xf5,0x00,0x00,0x00,0x10]
          ldtilecfg  268435456(%rbp,%r14,8)

// CHECK: ldtilecfg  291(%r8,%rax,4)
// CHECK: encoding: [0xc4,0xc2,0x78,0x49,0x84,0x80,0x23,0x01,0x00,0x00]
          ldtilecfg  291(%r8,%rax,4)

// CHECK: ldtilecfg  (%rip)
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0x05,0x00,0x00,0x00,0x00]
          ldtilecfg  (%rip)

// CHECK: ldtilecfg  -2048(,%rbp,2)
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0x04,0x6d,0x00,0xf8,0xff,0xff]
          ldtilecfg  -2048(,%rbp,2)

// CHECK: sttilecfg  268435456(%rbp,%r14,8)
// CHECK: encoding: [0xc4,0xa2,0x79,0x49,0x84,0xf5,0x00,0x00,0x00,0x10]
          sttilecfg  268435456(%rbp,%r14,8)

// CHECK: sttilecfg  291(%r8,%rax,4)
// CHECK: encoding: [0xc4,0xc2,0x79,0x49,0x84,0x80,0x23,0x01,0x00,0x00]
          sttilecfg  291(%r8,%rax,4)

// CHECK: sttilecfg  (%rip)
// CHECK: encoding: [0xc4,0xe2,0x79,0x49,0x05,0x00,0x00,0x00,0x00]
          sttilecfg  (%rip)

// CHECK: sttilecfg  -2048(,%rbp,2)
// CHECK: encoding: [0xc4,0xe2,0x79,0x49,0x04,0x6d,0x00,0xf8,0xff,0xff]
          sttilecfg  -2048(,%rbp,2)

// CHECK: tileloadd 268435456(%rbp,%r14,8), %tmm6
// CHECK: encoding: [0xc4,0xa2,0x7b,0x4b,0xb4,0xf5,0x00,0x00,0x00,0x10]
          tileloadd 268435456(%rbp,%r14,8), %tmm6

// CHECK: tileloadd 291(%r8,%rax,4), %tmm3
// CHECK: encoding: [0xc4,0xc2,0x7b,0x4b,0x9c,0x80,0x23,0x01,0x00,0x00]
          tileloadd 291(%r8,%rax,4), %tmm3

// CHECK: tileloadd 64(%rbx), %tmm4
// CHECK: encoding: [0xc4,0xe2,0x7b,0x4b,0x64,0x23,0x40]
          tileloadd 64(%rbx), %tmm4

// CHECK: tileloadd -32(,%rbp,2), %tmm3
// CHECK: encoding: [0xc4,0xe2,0x7b,0x4b,0x1c,0x6d,0xe0,0xff,0xff,0xff]
          tileloadd -32(,%rbp,2), %tmm3

// CHECK: tileloaddt1 268435456(%rbp,%r14,8), %tmm6
// CHECK: encoding: [0xc4,0xa2,0x79,0x4b,0xb4,0xf5,0x00,0x00,0x00,0x10]
          tileloaddt1 268435456(%rbp,%r14,8), %tmm6

// CHECK: tileloaddt1 291(%r8,%rax,4), %tmm3
// CHECK: encoding: [0xc4,0xc2,0x79,0x4b,0x9c,0x80,0x23,0x01,0x00,0x00]
          tileloaddt1 291(%r8,%rax,4), %tmm3

// CHECK: tileloaddt1 -32(,%rbp,2), %tmm3
// CHECK: encoding: [0xc4,0xe2,0x79,0x4b,0x1c,0x6d,0xe0,0xff,0xff,0xff]
          tileloaddt1 -32(,%rbp,2), %tmm3

// CHECK: tileloaddt1 16(%rbp), %tmm6
// CHECK: encoding: [0xc4,0xe2,0x79,0x4b,0x74,0x25,0x10]
          tileloaddt1 16(%rbp), %tmm6

// CHECK: tilerelease
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0xc0]
          tilerelease

// CHECK: tilestored %tmm6, 268435456(%rbp,%r14,8)
// CHECK: encoding: [0xc4,0xa2,0x7a,0x4b,0xb4,0xf5,0x00,0x00,0x00,0x10]
          tilestored %tmm6, 268435456(%rbp,%r14,8)

// CHECK: tilestored %tmm3, 291(%r8,%rax,4)
// CHECK: encoding: [0xc4,0xc2,0x7a,0x4b,0x9c,0x80,0x23,0x01,0x00,0x00]
          tilestored %tmm3, 291(%r8,%rax,4)

// CHECK: tilestored %tmm3, -32(,%rbp,2)
// CHECK: encoding: [0xc4,0xe2,0x7a,0x4b,0x1c,0x6d,0xe0,0xff,0xff,0xff]
          tilestored %tmm3, -32(,%rbp,2)

// CHECK: tilestored %tmm3, (%r8)
// CHECK: encoding: [0xc4,0xc2,0x7a,0x4b,0x1c,0x20]
          tilestored %tmm3, (%r8)

// CHECK: tilezero %tmm6
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xf0]
          tilezero %tmm6

// CHECK: tilezero %tmm3
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xd8]
          tilezero %tmm3

// CHECK: ldtilecfg  268435456(%rbp,%r14,8)
// CHECK: encoding: [0xc4,0xa2,0x78,0x49,0x84,0xf5,0x00,0x00,0x00,0x10]
          ldtilecfg  268435456(%rbp,%r14,8)

// CHECK: ldtilecfg  291(%r8,%rax,4)
// CHECK: encoding: [0xc4,0xc2,0x78,0x49,0x84,0x80,0x23,0x01,0x00,0x00]
          ldtilecfg  291(%r8,%rax,4)

// CHECK: ldtilecfg  (%rip)
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0x05,0x00,0x00,0x00,0x00]
          ldtilecfg  (%rip)

// CHECK: ldtilecfg  -2048(,%rbp,2)
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0x04,0x6d,0x00,0xf8,0xff,0xff]
          ldtilecfg  -2048(,%rbp,2)

// CHECK: sttilecfg  268435456(%rbp,%r14,8)
// CHECK: encoding: [0xc4,0xa2,0x79,0x49,0x84,0xf5,0x00,0x00,0x00,0x10]
          sttilecfg  268435456(%rbp,%r14,8)

// CHECK: sttilecfg  291(%r8,%rax,4)
// CHECK: encoding: [0xc4,0xc2,0x79,0x49,0x84,0x80,0x23,0x01,0x00,0x00]
          sttilecfg  291(%r8,%rax,4)

// CHECK: sttilecfg  (%rip)
// CHECK: encoding: [0xc4,0xe2,0x79,0x49,0x05,0x00,0x00,0x00,0x00]
          sttilecfg  (%rip)

// CHECK: sttilecfg  -2048(,%rbp,2)
// CHECK: encoding: [0xc4,0xe2,0x79,0x49,0x04,0x6d,0x00,0xf8,0xff,0xff]
          sttilecfg  -2048(,%rbp,2)

// CHECK: tileloadd 268435456(%rbp,%r14,8), %tmm6
// CHECK: encoding: [0xc4,0xa2,0x7b,0x4b,0xb4,0xf5,0x00,0x00,0x00,0x10]
          tileloadd 268435456(%rbp,%r14,8), %tmm6

// CHECK: tileloadd 291(%r8,%rax,4), %tmm3
// CHECK: encoding: [0xc4,0xc2,0x7b,0x4b,0x9c,0x80,0x23,0x01,0x00,0x00]
          tileloadd 291(%r8,%rax,4), %tmm3

// CHECK: tileloadd -32(,%rbp,2), %tmm3
// CHECK: encoding: [0xc4,0xe2,0x7b,0x4b,0x1c,0x6d,0xe0,0xff,0xff,0xff]
          tileloadd -32(,%rbp,2), %tmm3

// CHECK: tileloaddt1 268435456(%rbp,%r14,8), %tmm6
// CHECK: encoding: [0xc4,0xa2,0x79,0x4b,0xb4,0xf5,0x00,0x00,0x00,0x10]
          tileloaddt1 268435456(%rbp,%r14,8), %tmm6

// CHECK: tileloaddt1 291(%r8,%rax,4), %tmm3
// CHECK: encoding: [0xc4,0xc2,0x79,0x4b,0x9c,0x80,0x23,0x01,0x00,0x00]
          tileloaddt1 291(%r8,%rax,4), %tmm3

// CHECK: tileloaddt1 -32(,%rbp,2), %tmm3
// CHECK: encoding: [0xc4,0xe2,0x79,0x4b,0x1c,0x6d,0xe0,0xff,0xff,0xff]
          tileloaddt1 -32(,%rbp,2), %tmm3

// CHECK: tilerelease
// CHECK: encoding: [0xc4,0xe2,0x78,0x49,0xc0]
          tilerelease

// CHECK: tilestored %tmm6, 268435456(%rbp,%r14,8)
// CHECK: encoding: [0xc4,0xa2,0x7a,0x4b,0xb4,0xf5,0x00,0x00,0x00,0x10]
          tilestored %tmm6, 268435456(%rbp,%r14,8)

// CHECK: tilestored %tmm3, 291(%r8,%rax,4)
// CHECK: encoding: [0xc4,0xc2,0x7a,0x4b,0x9c,0x80,0x23,0x01,0x00,0x00]
          tilestored %tmm3, 291(%r8,%rax,4)

// CHECK: tilestored %tmm3, -32(,%rbp,2)
// CHECK: encoding: [0xc4,0xe2,0x7a,0x4b,0x1c,0x6d,0xe0,0xff,0xff,0xff]
          tilestored %tmm3, -32(,%rbp,2)

// CHECK: tilezero %tmm6
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xf0]
          tilezero %tmm6

// CHECK: tilezero %tmm3
// CHECK: encoding: [0xc4,0xe2,0x7b,0x49,0xd8]
          tilezero %tmm3
