// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/remoteworkers/v1test2/tasks.proto

package remoteworkers

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import google_protobuf3 "google.golang.org/genproto/protobuf/field_mask"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A Task represents a unit of work. Its result and logs are defined as
// subresources.
//
// If all the `Any` fields are populated, this can be a very large message, and
// clients may not want the entire message returned on every call to every
// method. Such clients should request partial responses
// (https://cloud.google.com/apis/design/design_patterns#partial_response) and
// servers should implement partial responses in order to reduce unnecessry
// overhead.
type Task struct {
	// The name of this task. Output only.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The actual task to perform. For example, this could be CommandTask to run a
	// command line.
	Description *google_protobuf1.Any `protobuf:"bytes,2,opt,name=description" json:"description,omitempty"`
	// Handles to logs. The key is a human-readable name like `stdout`, and the
	// handle is a resource name that can be passed to ByteStream or other
	// accessors.
	//
	// An implementation may define some logs by default (like `stdout`), and may
	// allow clients to add new logs via AddTaskLog.
	Logs map[string]string `protobuf:"bytes,3,rep,name=logs" json:"logs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Task) Reset()                    { *m = Task{} }
func (m *Task) String() string            { return proto.CompactTextString(m) }
func (*Task) ProtoMessage()               {}
func (*Task) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{0} }

func (m *Task) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Task) GetDescription() *google_protobuf1.Any {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *Task) GetLogs() map[string]string {
	if m != nil {
		return m.Logs
	}
	return nil
}

// The result and metadata of the task.
type TaskResult struct {
	// The name of the task result; must be a name of a `Task` followed by
	// `/result`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The result may be updated several times; the client must only set
	// `complete` to true to indicate that no further updates are allowed.
	// If this is not true, the `status` field must not be examined since its zero
	// value is equivalent to `OK`.
	//
	// Once a task is completed, it must not be updated with further results,
	// though the implementation may choose to continue to receive logs.
	Complete bool `protobuf:"varint,2,opt,name=complete" json:"complete,omitempty"`
	// The final status of the task itself. For example, if task.description
	// included a timeout which was violated, status.code may be
	// DEADLINE_EXCEEDED. This field can only be read if `complete` is true.
	Status *google_rpc.Status `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	// Any non-log output, such as output files and exit codes. See
	// CommandResult as an example.
	Output *google_protobuf1.Any `protobuf:"bytes,4,opt,name=output" json:"output,omitempty"`
	// Any information about how the command was executed, eg runtime. See
	// CommandOverhead as an example.
	Meta *google_protobuf1.Any `protobuf:"bytes,5,opt,name=meta" json:"meta,omitempty"`
}

func (m *TaskResult) Reset()                    { *m = TaskResult{} }
func (m *TaskResult) String() string            { return proto.CompactTextString(m) }
func (*TaskResult) ProtoMessage()               {}
func (*TaskResult) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{1} }

func (m *TaskResult) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TaskResult) GetComplete() bool {
	if m != nil {
		return m.Complete
	}
	return false
}

func (m *TaskResult) GetStatus() *google_rpc.Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *TaskResult) GetOutput() *google_protobuf1.Any {
	if m != nil {
		return m.Output
	}
	return nil
}

func (m *TaskResult) GetMeta() *google_protobuf1.Any {
	if m != nil {
		return m.Meta
	}
	return nil
}

// Request message for `GetTask`.
type GetTaskRequest struct {
	// The task name.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetTaskRequest) Reset()                    { *m = GetTaskRequest{} }
func (m *GetTaskRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTaskRequest) ProtoMessage()               {}
func (*GetTaskRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{2} }

func (m *GetTaskRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for `UpdateTaskResult`.
type UpdateTaskResultRequest struct {
	// The task result name; must match `result.name`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The result being updated.
	Result *TaskResult `protobuf:"bytes,2,opt,name=result" json:"result,omitempty"`
	// The fields within `result` that are specified.
	UpdateMask *google_protobuf3.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
	// If this is being updated by a bot from BotManager, the source should be
	// bot.session_id. That way, if two bots accidentally get the same name, we'll
	// know to reject updates from the older one.
	Source string `protobuf:"bytes,4,opt,name=source" json:"source,omitempty"`
}

func (m *UpdateTaskResultRequest) Reset()                    { *m = UpdateTaskResultRequest{} }
func (m *UpdateTaskResultRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateTaskResultRequest) ProtoMessage()               {}
func (*UpdateTaskResultRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{3} }

func (m *UpdateTaskResultRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateTaskResultRequest) GetResult() *TaskResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *UpdateTaskResultRequest) GetUpdateMask() *google_protobuf3.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateTaskResultRequest) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

// Request message for `AddTaskLog`.
type AddTaskLogRequest struct {
	// The name of the task that will own the new log.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The human-readable name of the log, like `stdout` or a relative file path.
	LogId string `protobuf:"bytes,2,opt,name=log_id,json=logId" json:"log_id,omitempty"`
}

func (m *AddTaskLogRequest) Reset()                    { *m = AddTaskLogRequest{} }
func (m *AddTaskLogRequest) String() string            { return proto.CompactTextString(m) }
func (*AddTaskLogRequest) ProtoMessage()               {}
func (*AddTaskLogRequest) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{4} }

func (m *AddTaskLogRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AddTaskLogRequest) GetLogId() string {
	if m != nil {
		return m.LogId
	}
	return ""
}

// Response message for `AddTaskLog`.
type AddTaskLogResponse struct {
	// The handle for the new log, as would be returned in Task.logs.
	Handle string `protobuf:"bytes,1,opt,name=handle" json:"handle,omitempty"`
}

func (m *AddTaskLogResponse) Reset()                    { *m = AddTaskLogResponse{} }
func (m *AddTaskLogResponse) String() string            { return proto.CompactTextString(m) }
func (*AddTaskLogResponse) ProtoMessage()               {}
func (*AddTaskLogResponse) Descriptor() ([]byte, []int) { return fileDescriptor2, []int{5} }

func (m *AddTaskLogResponse) GetHandle() string {
	if m != nil {
		return m.Handle
	}
	return ""
}

func init() {
	proto.RegisterType((*Task)(nil), "google.devtools.remoteworkers.v1test2.Task")
	proto.RegisterType((*TaskResult)(nil), "google.devtools.remoteworkers.v1test2.TaskResult")
	proto.RegisterType((*GetTaskRequest)(nil), "google.devtools.remoteworkers.v1test2.GetTaskRequest")
	proto.RegisterType((*UpdateTaskResultRequest)(nil), "google.devtools.remoteworkers.v1test2.UpdateTaskResultRequest")
	proto.RegisterType((*AddTaskLogRequest)(nil), "google.devtools.remoteworkers.v1test2.AddTaskLogRequest")
	proto.RegisterType((*AddTaskLogResponse)(nil), "google.devtools.remoteworkers.v1test2.AddTaskLogResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Tasks service

type TasksClient interface {
	// GetTask reads the current state of the task. Tasks must be created through
	// some other interface, and should be immutable once created and exposed to
	// the bots.
	GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error)
	// UpdateTaskResult updates the result.
	UpdateTaskResult(ctx context.Context, in *UpdateTaskResultRequest, opts ...grpc.CallOption) (*TaskResult, error)
	// AddTaskLog creates a new streaming log. The log is streamed and marked as
	// completed through other interfaces (i.e., ByteStream). This can be called
	// by the bot if it wants to create a new log; the server can also predefine
	// logs that do not need to be created (e.g. `stdout`).
	AddTaskLog(ctx context.Context, in *AddTaskLogRequest, opts ...grpc.CallOption) (*AddTaskLogResponse, error)
}

type tasksClient struct {
	cc *grpc.ClientConn
}

func NewTasksClient(cc *grpc.ClientConn) TasksClient {
	return &tasksClient{cc}
}

func (c *tasksClient) GetTask(ctx context.Context, in *GetTaskRequest, opts ...grpc.CallOption) (*Task, error) {
	out := new(Task)
	err := grpc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Tasks/GetTask", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tasksClient) UpdateTaskResult(ctx context.Context, in *UpdateTaskResultRequest, opts ...grpc.CallOption) (*TaskResult, error) {
	out := new(TaskResult)
	err := grpc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Tasks/UpdateTaskResult", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tasksClient) AddTaskLog(ctx context.Context, in *AddTaskLogRequest, opts ...grpc.CallOption) (*AddTaskLogResponse, error) {
	out := new(AddTaskLogResponse)
	err := grpc.Invoke(ctx, "/google.devtools.remoteworkers.v1test2.Tasks/AddTaskLog", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Tasks service

type TasksServer interface {
	// GetTask reads the current state of the task. Tasks must be created through
	// some other interface, and should be immutable once created and exposed to
	// the bots.
	GetTask(context.Context, *GetTaskRequest) (*Task, error)
	// UpdateTaskResult updates the result.
	UpdateTaskResult(context.Context, *UpdateTaskResultRequest) (*TaskResult, error)
	// AddTaskLog creates a new streaming log. The log is streamed and marked as
	// completed through other interfaces (i.e., ByteStream). This can be called
	// by the bot if it wants to create a new log; the server can also predefine
	// logs that do not need to be created (e.g. `stdout`).
	AddTaskLog(context.Context, *AddTaskLogRequest) (*AddTaskLogResponse, error)
}

func RegisterTasksServer(s *grpc.Server, srv TasksServer) {
	s.RegisterService(&_Tasks_serviceDesc, srv)
}

func _Tasks_GetTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TasksServer).GetTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Tasks/GetTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TasksServer).GetTask(ctx, req.(*GetTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tasks_UpdateTaskResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TasksServer).UpdateTaskResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Tasks/UpdateTaskResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TasksServer).UpdateTaskResult(ctx, req.(*UpdateTaskResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tasks_AddTaskLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTaskLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TasksServer).AddTaskLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.remoteworkers.v1test2.Tasks/AddTaskLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TasksServer).AddTaskLog(ctx, req.(*AddTaskLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Tasks_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.remoteworkers.v1test2.Tasks",
	HandlerType: (*TasksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTask",
			Handler:    _Tasks_GetTask_Handler,
		},
		{
			MethodName: "UpdateTaskResult",
			Handler:    _Tasks_UpdateTaskResult_Handler,
		},
		{
			MethodName: "AddTaskLog",
			Handler:    _Tasks_AddTaskLog_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/remoteworkers/v1test2/tasks.proto",
}

func init() { proto.RegisterFile("google/devtools/remoteworkers/v1test2/tasks.proto", fileDescriptor2) }

var fileDescriptor2 = []byte{
	// 634 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0x95, 0x13, 0xc7, 0x34, 0x13, 0x09, 0x95, 0x55, 0xa1, 0xc6, 0xea, 0x21, 0x58, 0x80, 0xa2,
	0x34, 0xb2, 0x95, 0x20, 0xa0, 0xa4, 0xa2, 0x52, 0x91, 0x00, 0x45, 0x0a, 0x17, 0x53, 0x2e, 0x5c,
	0xaa, 0x6d, 0xbc, 0x5d, 0xac, 0x38, 0x5e, 0xe3, 0x5d, 0x07, 0x45, 0x28, 0x17, 0x4e, 0x5c, 0x11,
	0x1f, 0xc2, 0x95, 0x23, 0x3f, 0xc0, 0x09, 0x89, 0x2f, 0xe0, 0x43, 0x90, 0xd7, 0xeb, 0xb4, 0x69,
	0x9b, 0x90, 0x70, 0xf3, 0x78, 0xde, 0x9b, 0x99, 0x37, 0x6f, 0xb4, 0xd0, 0xa6, 0x8c, 0xd1, 0x90,
	0xb8, 0x3e, 0x19, 0x0b, 0xc6, 0x42, 0xee, 0x26, 0x64, 0xc4, 0x04, 0xf9, 0xc0, 0x92, 0x21, 0x49,
	0xb8, 0x3b, 0x6e, 0x0b, 0xc2, 0x45, 0xc7, 0x15, 0x98, 0x0f, 0xb9, 0x13, 0x27, 0x4c, 0x30, 0x74,
	0x2f, 0xa7, 0x38, 0x05, 0xc5, 0x99, 0xa3, 0x38, 0x8a, 0x62, 0xed, 0xa8, 0xca, 0x38, 0x0e, 0x5c,
	0x1c, 0x45, 0x4c, 0x60, 0x11, 0xb0, 0x48, 0x15, 0xb1, 0x6e, 0xab, 0xac, 0x8c, 0x4e, 0xd2, 0x53,
	0x17, 0x47, 0x13, 0x95, 0xaa, 0x5f, 0x4c, 0x9d, 0x06, 0x24, 0xf4, 0x8f, 0x47, 0x98, 0x0f, 0x15,
	0x62, 0x5b, 0x21, 0x92, 0x78, 0xe0, 0x72, 0x81, 0x45, 0xaa, 0xaa, 0xda, 0xbf, 0x35, 0xd0, 0x8f,
	0x30, 0x1f, 0x22, 0x04, 0x7a, 0x84, 0x47, 0xc4, 0xd4, 0xea, 0x5a, 0xa3, 0xea, 0xc9, 0x6f, 0xf4,
	0x08, 0x6a, 0x3e, 0xe1, 0x83, 0x24, 0x88, 0xb3, 0x41, 0xcc, 0x52, 0x5d, 0x6b, 0xd4, 0x3a, 0x5b,
	0x8e, 0x52, 0x53, 0x74, 0x73, 0x0e, 0xa3, 0x89, 0x77, 0x1e, 0x88, 0x7a, 0xa0, 0x87, 0x8c, 0x72,
	0xb3, 0x5c, 0x2f, 0x37, 0x6a, 0x9d, 0x87, 0xce, 0x4a, 0xf2, 0x9d, 0x6c, 0x0c, 0xa7, 0xcf, 0x28,
	0x7f, 0x1e, 0x89, 0x64, 0xe2, 0xc9, 0x12, 0xd6, 0x63, 0xa8, 0xce, 0x7e, 0xa1, 0x4d, 0x28, 0x0f,
	0xc9, 0x44, 0x8d, 0x98, 0x7d, 0xa2, 0x2d, 0xa8, 0x8c, 0x71, 0x98, 0x12, 0x39, 0x5b, 0xd5, 0xcb,
	0x83, 0x6e, 0x69, 0x4f, 0xb3, 0x7f, 0x68, 0x00, 0x59, 0x45, 0x8f, 0xf0, 0x34, 0x14, 0x57, 0xca,
	0xb3, 0x60, 0x63, 0xc0, 0x46, 0x71, 0x48, 0x44, 0xce, 0xdf, 0xf0, 0x66, 0x31, 0x6a, 0x82, 0x91,
	0xef, 0xc9, 0x2c, 0x4b, 0xd5, 0xa8, 0x10, 0x91, 0xc4, 0x03, 0xe7, 0xb5, 0xcc, 0x78, 0x0a, 0x81,
	0x5a, 0x60, 0xb0, 0x54, 0xc4, 0xa9, 0x30, 0xf5, 0x25, 0x1b, 0x52, 0x18, 0xd4, 0x00, 0x7d, 0x44,
	0x04, 0x36, 0x2b, 0x4b, 0xb0, 0x12, 0x61, 0xdf, 0x85, 0xeb, 0x2f, 0x89, 0xc8, 0x45, 0xbc, 0x4f,
	0x09, 0xbf, 0x52, 0x85, 0xfd, 0x53, 0x83, 0xed, 0x37, 0xb1, 0x8f, 0x05, 0x39, 0x93, 0xbb, 0x04,
	0x8f, 0x7a, 0x60, 0x24, 0x12, 0xa4, 0xfc, 0x6c, 0xaf, 0x61, 0x8f, 0xaa, 0xae, 0x0a, 0xa0, 0x7d,
	0xa8, 0xa5, 0xb2, 0xb3, 0x3c, 0x35, 0xb5, 0x29, 0xeb, 0x92, 0xa2, 0x17, 0xd9, 0x35, 0xbe, 0xca,
	0xe8, 0x90, 0xc3, 0xb3, 0x6f, 0x74, 0x0b, 0x0c, 0xce, 0xd2, 0x64, 0x40, 0xe4, 0xd6, 0xaa, 0x9e,
	0x8a, 0xec, 0x03, 0xb8, 0x71, 0xe8, 0xfb, 0x59, 0xb7, 0x3e, 0xa3, 0xcb, 0x84, 0xdc, 0x04, 0x23,
	0x64, 0xf4, 0x38, 0xf0, 0x0b, 0xf3, 0x43, 0x46, 0x7b, 0xbe, 0xdd, 0x02, 0x74, 0x9e, 0xcf, 0x63,
	0x16, 0x71, 0x92, 0x75, 0x7b, 0x87, 0x23, 0x3f, 0x2c, 0x4a, 0xa8, 0xa8, 0xf3, 0x59, 0x87, 0x4a,
	0x86, 0xe5, 0xe8, 0x8b, 0x06, 0xd7, 0xd4, 0xba, 0xd1, 0xaa, 0x27, 0x3b, 0x6f, 0x8f, 0xb5, 0xbb,
	0xc6, 0x2a, 0x6d, 0xfb, 0xd3, 0xaf, 0x3f, 0x5f, 0x4b, 0x3b, 0xc8, 0x9a, 0x3d, 0x19, 0x1f, 0x33,
	0x59, 0x4f, 0x9b, 0xcd, 0xfc, 0xed, 0x70, 0x9b, 0x53, 0xf4, 0x5d, 0x83, 0xcd, 0x8b, 0xde, 0xa2,
	0x83, 0x15, 0xbb, 0x2c, 0x38, 0x0a, 0x6b, 0x7d, 0xc3, 0xed, 0xb6, 0x9c, 0x75, 0xb7, 0x73, 0x67,
	0xe1, 0xac, 0x6e, 0x7e, 0x12, 0xd3, 0x6e, 0x71, 0x1b, 0xdf, 0x34, 0x80, 0x33, 0x1f, 0xd0, 0xde,
	0x8a, 0x4d, 0x2f, 0x59, 0x6f, 0x3d, 0xf9, 0x0f, 0x66, 0x6e, 0xba, 0xdd, 0x92, 0x63, 0xdf, 0xb7,
	0x17, 0x8f, 0x3d, 0xed, 0x62, 0xdf, 0xef, 0x33, 0xda, 0xd5, 0x9a, 0xcf, 0x8e, 0xde, 0x7a, 0xaa,
	0x13, 0x65, 0x21, 0x8e, 0xa8, 0xc3, 0x12, 0xea, 0x52, 0x12, 0xc9, 0x3b, 0x76, 0xf3, 0x14, 0x8e,
	0x03, 0xfe, 0x8f, 0x97, 0x7f, 0x7f, 0xee, 0xef, 0x89, 0x21, 0xe9, 0x0f, 0xfe, 0x06, 0x00, 0x00,
	0xff, 0xff, 0xb8, 0x8f, 0xed, 0xe0, 0x37, 0x06, 0x00, 0x00,
}
