/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef FB2METADATACONTEXT_H_INCLUDED
#define FB2METADATACONTEXT_H_INCLUDED

#include "FB2ParserContext.h"

namespace libebook
{

class FB2Authors;

class FB2AnnotationContext : public FB2BlockFormatContextBase
{
public:
  FB2AnnotationContext(FB2ParserContext *parentContext, const FB2BlockFormat &format);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2AuthorContext : public FB2ParserContext
{
public:
  FB2AuthorContext(FB2ParserContext *parentContext, FB2Authors &authors);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors &m_authors;
};

class FB2BookNameContext : public FB2ParserContext
{
public:
  explicit FB2BookNameContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2BookTitleContext : public FB2ParserContext
{
public:
  explicit FB2BookTitleContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2CityContext : public FB2ParserContext
{
public:
  explicit FB2CityContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2CoverpageContext : public FB2ParserContext
{
public:
  explicit FB2CoverpageContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2CustomInfoContext : public FB2ParserContext
{
public:
  explicit FB2CustomInfoContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  WPXString m_type;
  WPXString m_text;
};

class FB2DateContext : public FB2ParserContext
{
  // no copying
  FB2DateContext(const FB2DateContext &);
  FB2DateContext &operator=(const FB2DateContext &);

public:
  FB2DateContext(FB2ParserContext *parentContext, const char *name);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  const char *const m_name;
};

class FB2DescriptionContext : public FB2ParserContext
{
public:
  FB2DescriptionContext(FB2ParserContext *parentContext, FB2Collector *collector);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class DocumentInfoContext : public FB2ParserContext
{
  // no copying
  DocumentInfoContext(const DocumentInfoContext &other);
  DocumentInfoContext &operator=(const DocumentInfoContext &other);

public:
  DocumentInfoContext(FB2ParserContext *parentContext);

private:
  virtual ~DocumentInfoContext();

  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors *m_authors;
};

class FB2EmailContext : public FB2ParserContext
{
public:
  explicit FB2EmailContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2FirstNameContext : public FB2ParserContext
{
public:
  FB2FirstNameContext(FB2ParserContext *parentContext, FB2Authors &authors);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors &m_authors;
};

class FB2GenreContext : public FB2ParserContext
{
public:
  explicit FB2GenreContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2HistoryContext : public FB2ParserContext
{
public:
  explicit FB2HistoryContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2HomePageContext : public FB2ParserContext
{
public:
  explicit FB2HomePageContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2IdContext : public FB2ParserContext
{
public:
  explicit FB2IdContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2IsbnContext : public FB2ParserContext
{
public:
  explicit FB2IsbnContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2KeywordsContext : public FB2ParserContext
{
public:
  explicit FB2KeywordsContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2LangContext : public FB2ParserContext
{
public:
  explicit FB2LangContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2LastNameContext : public FB2ParserContext
{
public:
  FB2LastNameContext(FB2ParserContext *parentContext, FB2Authors &authors);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors &m_authors;
};

class FB2MiddleNameContext : public FB2ParserContext
{
public:
  FB2MiddleNameContext(FB2ParserContext *parentContext, FB2Authors &authors);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors &m_authors;
};

class FB2NicknameContext : public FB2ParserContext
{
public:
  FB2NicknameContext(FB2ParserContext *parentContext, FB2Authors &authors);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors &m_authors;
};

class FB2OutputContext : public FB2ParserContext
{
public:
  explicit FB2OutputContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2OutputDocumentClassContext : public FB2ParserContext
{
public:
  explicit FB2OutputDocumentClassContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2PartContext : public FB2ParserContext
{
public:
  explicit FB2PartContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2ProgramUsedContext : public FB2ParserContext
{
public:
  explicit FB2ProgramUsedContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2PublisherContext : public FB2ParserContext
{
public:
  explicit FB2PublisherContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2PublishInfoContext : public FB2ParserContext
{
public:
  explicit FB2PublishInfoContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2SequenceContext : public FB2ParserContext
{
public:
  explicit FB2SequenceContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2SrcLangContext : public FB2ParserContext
{
public:
  explicit FB2SrcLangContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2SrcOcrContext : public FB2ParserContext
{
public:
  explicit FB2SrcOcrContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2SrcTitleInfoContext : public FB2ParserContext
{
public:
  explicit FB2SrcTitleInfoContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2SrcUrlContext : public FB2ParserContext
{
public:
  explicit FB2SrcUrlContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2TitleInfoContext : public FB2ParserContext
{
  // no copying
  FB2TitleInfoContext(const FB2TitleInfoContext &other);
  FB2TitleInfoContext &operator=(const FB2TitleInfoContext &other);

public:
  explicit FB2TitleInfoContext(FB2ParserContext *parentContext);

private:
  virtual ~FB2TitleInfoContext();

  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);

private:
  FB2Authors *m_authors;
};

class FB2TranslatorContext : public FB2ParserContext
{
public:
  explicit FB2TranslatorContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2VersionContext : public FB2ParserContext
{
public:
  explicit FB2VersionContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

class FB2YearContext : public FB2ParserContext
{
public:
  explicit FB2YearContext(FB2ParserContext *parentContext);

private:
  virtual FB2XMLParserContext *element(const EBOOKToken &name, const EBOOKToken &ns);
  virtual void startOfElement();
  virtual void endOfElement();
  virtual void endOfAttributes() {}
  virtual void attribute(const EBOOKToken &name, const EBOOKToken *ns, const char *value);
  virtual void text(const char *value);
};

}

#endif // FB2METADATACONTEXT_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
