/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.odftoolkit.odfvalidator.Configuration;
import org.odftoolkit.odfvalidator.InternalResources;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ODFFileFilter;
import org.odftoolkit.odfvalidator.ODFFileValidator;
import org.odftoolkit.odfvalidator.ODFStreamValidator;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.ODFValidatorProvider;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.odftoolkit.odfvalidator.SchemaErrorHandler;
import org.odftoolkit.odfvalidator.SchemaResourceResolver;
import org.odftoolkit.odfvalidator.ValidationOOoTaskIdErrorFilter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ODFValidator
implements ODFValidatorProvider {
    private Logger.LogLevel m_nLogLevel;
    private SchemaFactory m_aRNGSchemaFactory = null;
    private SchemaFactory m_aXSDSchemaFactory = null;
    protected Configuration m_aConfig = null;
    protected OdfVersion m_aVersion = null;
    protected OdfVersion mOdfPackageVersion = null;
    protected boolean m_bUseMathDTD = false;
    private HashMap<String, Schema> m_aSchemaMap = null;
    private HashMap<OdfVersion, Configuration> m_aConfigurationMap = null;
    private String m_aGenerator = "";
    private static final String MISSING_ODF_VERSION = " 'Missing ODF version'";

    public ODFValidator(Configuration aConfig, Logger.LogLevel nLogLevel, OdfVersion aVersion, boolean bUseMathDTD) throws ODFValidatorException {
        this.m_nLogLevel = nLogLevel;
        this.m_aConfig = aConfig;
        this.m_aVersion = aVersion;
        this.m_bUseMathDTD = bUseMathDTD;
        Logger.enableHTML(false);
    }

    public ODFValidator(Configuration aConfig, Logger.LogLevel nLogLevel, boolean logAsHTML, OdfVersion aVersion, boolean bUseMathDTD) throws ODFValidatorException {
        this.m_nLogLevel = nLogLevel;
        this.m_aConfig = aConfig;
        this.m_aVersion = aVersion;
        this.m_bUseMathDTD = bUseMathDTD;
        Logger.enableHTML(logAsHTML);
    }

    public String getOdfVersion() {
        String version = MISSING_ODF_VERSION;
        if (this.m_aVersion != null) {
            version = this.m_aVersion.toString();
        } else if (this.mOdfPackageVersion != null) {
            version = this.mOdfPackageVersion.toString();
        }
        return version;
    }

    public boolean validate(PrintStream aOut, Configuration aConfig, OdfValidatorMode eMode) throws ODFValidatorException {
        List<String> aFileNames = aConfig.getListPropety("path");
        String aExcludeRegExp = aConfig.getProperty("exclude");
        String aRecursive = aConfig.getProperty("recursive");
        boolean bRecursive = aRecursive != null ? Boolean.valueOf(aRecursive) : false;
        String aFilterFileName = aConfig.getProperty("filter");
        return this.validate(aOut, aFileNames, aExcludeRegExp, eMode, bRecursive, aFilterFileName);
    }

    public boolean validate(PrintStream aOut, List<String> aFileNames, String aExcludeRegExp, OdfValidatorMode eMode, boolean bRecursive, String aFilterFileName) throws ODFValidatorException {
        boolean bRet = false;
        ValidationOOoTaskIdErrorFilter aFilter = null;
        if (aFilterFileName != null && aFilterFileName.length() != 0) {
            aFilter = new ValidationOOoTaskIdErrorFilter(new File(aFilterFileName), aOut);
        }
        ODFFileFilter aFileFilter = new ODFFileFilter(aExcludeRegExp, bRecursive);
        Iterator<String> aIter = aFileNames.iterator();
        while (aIter.hasNext()) {
            File aFile = new File(aIter.next());
            bRet |= aFile.isDirectory() ? this.validateDir(aOut, aFile, aFileFilter, eMode, aFilter) : this.validateFile(aOut, aFile, eMode, aFilter);
        }
        return bRet;
    }

    public boolean validate(PrintStream aOut, InputStream aInputStream, String aBaseURI, OdfValidatorMode eMode, SAXParseExceptionFilter aFilter) throws ODFValidatorException {
        return this.validateStream(aOut, aInputStream, aBaseURI, eMode, aFilter);
    }

    private boolean validateDir(PrintStream aOut, File aDir, FileFilter aFileFilter, OdfValidatorMode eMode, SAXParseExceptionFilter aFilter) throws ODFValidatorException {
        boolean bRet = true;
        File[] aFiles = aDir.listFiles(aFileFilter);
        if (aFiles != null) {
            for (int i = 0; i < aFiles.length; ++i) {
                File aFile = aFiles[i];
                if (aFile.isDirectory()) {
                    bRet |= this.validateDir(aOut, aFile, aFileFilter, eMode, aFilter);
                    continue;
                }
                bRet |= this.validateFile(aOut, aFile, eMode, aFilter);
            }
        }
        return bRet;
    }

    public boolean validateFile(PrintStream aOut, File aDocFile, OdfValidatorMode eMode, SAXParseExceptionFilter aFilter) throws ODFValidatorException {
        ODFFileValidator aFileValidator = new ODFFileValidator(aDocFile, this.m_nLogLevel, eMode, this.m_aVersion, aFilter, this);
        boolean result = aFileValidator.validate(aOut);
        this.mOdfPackageVersion = aFileValidator.mOdfPackageVersion;
        this.m_aGenerator = aFileValidator.getGenerator();
        return result;
    }

    public boolean validateStream(PrintStream aOut, InputStream aInputStream, String aBaseURI, OdfValidatorMode eMode, SAXParseExceptionFilter aFilter) throws ODFValidatorException {
        ODFStreamValidator aStreamValidator = new ODFStreamValidator(aInputStream, aBaseURI, this.m_nLogLevel, eMode, this.m_aVersion, aFilter, this);
        boolean result = aStreamValidator.validate(aOut);
        this.m_aGenerator = aStreamValidator.getGenerator();
        this.mOdfPackageVersion = aStreamValidator.mOdfPackageVersion;
        return result;
    }

    @Override
    public Validator getManifestValidator(PrintStream aOut, OdfVersion aVersion) throws ODFValidatorException {
        return this.getValidatorForSchema(aOut, this.getSchemaFileName("manifest-schema", aVersion));
    }

    @Override
    public Validator getValidator(PrintStream aOut, OdfVersion aVersion) throws ODFValidatorException {
        return this.getValidatorForSchema(aOut, this.getSchemaFileName("schema", aVersion));
    }

    @Override
    public Validator getStrictValidator(PrintStream aOut, OdfVersion aVersion) throws ODFValidatorException {
        return this.getValidatorForSchema(aOut, this.getSchemaFileName("strict-schema", aVersion));
    }

    @Override
    public Validator getMathMLValidator(PrintStream aOut, OdfVersion aVersion) throws ODFValidatorException {
        return this.getValidatorForSchema(aOut, this.getSchemaFileName("mathml2-schema", aVersion));
    }

    @Override
    public String getMathMLDTDSystemId(OdfVersion aVersion) throws ODFValidatorException {
        String aDTD = null;
        if (this.m_bUseMathDTD) {
            Configuration aConfig = this.m_aConfig != null ? this.m_aConfig : this.getConfiguration(aVersion);
            aDTD = aConfig.getProperty("mathml-schema");
            if (this.m_aConfig == null && aDTD != null && aDTD.length() > 0) {
                aDTD = InternalResources.createInternalResourceIdentifier(aDTD);
            }
        }
        return aDTD;
    }

    @Override
    public Validator getDSigValidator(PrintStream aOut, OdfVersion aVersion) throws ODFValidatorException {
        return this.getValidatorForSchema(aOut, this.getSchemaFileName("dsig-schema", aVersion));
    }

    @Override
    public void resetValidatorProvider() {
        this.m_aRNGSchemaFactory = null;
        this.m_aXSDSchemaFactory = null;
        this.m_aSchemaMap = null;
    }

    private String getSchemaFileName(String aConfigName, OdfVersion aVersion) throws ODFValidatorException {
        Configuration aConfig = this.m_aConfig != null ? this.m_aConfig : this.getConfiguration(aVersion);
        String aFileName = aConfig.getProperty(aConfigName);
        if (this.m_aConfig == null && aFileName != null && aFileName.length() > 0) {
            aFileName = InternalResources.createInternalResourceIdentifier(aFileName);
        }
        return aFileName;
    }

    private Configuration getConfiguration(OdfVersion aVersion) throws ODFValidatorException {
        Configuration aConfig;
        if (this.m_aConfigurationMap == null) {
            this.m_aConfigurationMap = new HashMap();
        }
        if ((aConfig = this.m_aConfigurationMap.get((Object)aVersion)) == null) {
            String aConfigName = null;
            if (aVersion == null || aVersion == OdfVersion.V1_3) {
                aConfigName = "/schema/odf1_3.properties";
            } else if (aVersion == OdfVersion.V1_2) {
                aConfigName = "/schema/odf1_2.properties";
            } else if (aVersion == OdfVersion.V1_1) {
                aConfigName = "/schema/odf1_1.properties";
            } else if (aVersion == OdfVersion.V1_0) {
                aConfigName = "/schema/odf1_0.properties";
            } else {
                throw new ODFValidatorException("unsupported ODF version: ".concat(aVersion.toString()));
            }
            InputStream aInStream = this.getClass().getResourceAsStream(aConfigName);
            if (aInStream == null) {
                throw new ODFValidatorException("Internal configuration file is missing: ".concat(aConfigName));
            }
            aConfig = new Configuration();
            try {
                aConfig.loadFromXML(aInStream);
                aInStream.close();
            }
            catch (IOException e) {
                throw new ODFValidatorException(e);
            }
            this.m_aConfigurationMap.put(aVersion, aConfig);
        }
        return aConfig;
    }

    private Validator getValidatorForSchema(PrintStream aOut, String aSchemaFileName) throws ODFValidatorException {
        Schema aSchema;
        if (this.m_aSchemaMap == null) {
            this.m_aSchemaMap = new HashMap();
        }
        if ((aSchema = this.m_aSchemaMap.get(aSchemaFileName)) == null) {
            aSchema = this.createSchema(aOut, aSchemaFileName);
            this.m_aSchemaMap.put(aSchemaFileName, aSchema);
        }
        return aSchema.newValidator();
    }

    private Schema createSchema(PrintStream aOut, String aSchemaFileName) throws ODFValidatorException {
        Logger aLogger = new Logger(aSchemaFileName, "", aOut, this.m_nLogLevel);
        if (aSchemaFileName == null || aSchemaFileName.length() == 0) {
            return null;
        }
        String aSchemaLanguage = aSchemaFileName.endsWith("xsd") ? "http://www.w3.org/2001/XMLSchema" : "http://relaxng.org/ns/structure/1.0";
        SchemaFactory aSchemaFactory = this.getSchemaFactory(aSchemaLanguage);
        SchemaErrorHandler aErrorHandler = new SchemaErrorHandler(aLogger, null);
        aSchemaFactory.setErrorHandler(aErrorHandler);
        aSchemaFactory.setResourceResolver(new SchemaResourceResolver(aLogger, aSchemaFileName));
        Schema aSchema = null;
        StreamSource aSource = null;
        if (InternalResources.isInternalResourceIdentifer(aSchemaFileName)) {
            String aPath = InternalResources.getResourcePath(aSchemaFileName);
            InputStream aInStream = this.getClass().getResourceAsStream(aPath);
            if (aInStream == null) {
                throw new ODFValidatorException("Internal schema file is missing: ".concat(aPath));
            }
            aSource = new StreamSource(aInStream, aSchemaFileName);
        } else {
            File aFile = new File(aSchemaFileName);
            if (!aFile.exists()) {
                aLogger.logFatalError(aSchemaFileName + ": file does not exist");
                return null;
            }
            aSource = new StreamSource(aFile);
        }
        try {
            aSchema = aSchemaFactory.newSchema(aSource);
        }
        catch (SAXParseException e) {
            aLogger.logFatalError(e);
        }
        catch (SAXException e) {
            aLogger.logFatalError(e.getMessage());
        }
        if (aLogger.hasError()) {
            throw new ODFValidatorException(aSchemaFileName, "", "Schema has validation errors.");
        }
        aLogger.logInfo("parsed.", false);
        return aSchema;
    }

    private SchemaFactory getSchemaFactory(String aSchemaLanguage) throws ODFValidatorException {
        SchemaFactory aSchemaFactory;
        boolean isRNG = aSchemaLanguage.equals("http://relaxng.org/ns/structure/1.0");
        SchemaFactory schemaFactory = aSchemaFactory = isRNG ? this.m_aRNGSchemaFactory : this.m_aXSDSchemaFactory;
        if (aSchemaFactory == null) {
            try {
                if (isRNG) {
                    System.setProperty("javax.xml.validation.SchemaFactory:" + aSchemaLanguage, "org.iso_relax.verifier.jaxp.validation.RELAXNGSchemaFactoryImpl");
                    SchemaFactory sf = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
                    aSchemaFactory = this.m_aRNGSchemaFactory = SchemaFactory.newInstance(aSchemaLanguage);
                } else {
                    System.setProperty("javax.xml.validation.SchemaFactory:" + aSchemaLanguage, "org.apache.xerces.jaxp.validation.XMLSchemaFactory");
                    aSchemaFactory = this.m_aXSDSchemaFactory = SchemaFactory.newInstance(aSchemaLanguage);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ODFValidatorException(aSchemaLanguage + " support is not installed: " + e.getMessage());
            }
        }
        return aSchemaFactory;
    }

    public String getGenerator() {
        return this.m_aGenerator;
    }
}

