/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <vcl/layout.hxx>
#include <vcl/stdtext.hxx>

#include <svids.hrc>
#include <svdata.hxx>

OUString GetStandardText( sal_uInt16 nStdText )
{
    ResMgr* pResMgr = ImplGetResMgr();
    if (pResMgr)
    {
        return ResId(nStdText-STANDARD_TEXT_FIRST+SV_STDTEXT_FIRST, *pResMgr).
            toString();
    }
    return OUString();
}

void ShowServiceNotAvailableError(vcl::Window* pParent,
    const OUString& rServiceName, bool bError)
{
    OUString aText  = GetStandardText(STANDARD_TEXT_SERVICE_NOT_AVAILABLE).
        replaceAll("%s", rServiceName);
    ScopedVclPtrInstance< MessageDialog > aBox( pParent, aText, bError ? VCL_MESSAGE_ERROR : VCL_MESSAGE_WARNING );
    aBox->Execute();
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
