/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.beans.Disposable;
import org.jhotdraw.beans.WeakPropertyChangeListener;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.FigureSelectionEvent;
import org.jhotdraw.draw.FigureSelectionListener;
import org.jhotdraw.util.ResourceBundleUtil;

public abstract class AbstractSelectedAction
extends AbstractAction
implements Disposable {
    private DrawingEditor editor;
    private transient DrawingView activeView;
    protected ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
    private EventHandler eventHandler = new EventHandler();

    public AbstractSelectedAction(DrawingEditor drawingEditor) {
        this.setEditor(drawingEditor);
        this.updateEnabledState();
    }

    protected void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 0);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void dispose() {
        this.setEditor(null);
    }

    public void setEditor(DrawingEditor drawingEditor) {
        if (this.eventHandler != null) {
            this.unregisterEventHandler();
        }
        this.editor = drawingEditor;
        if (drawingEditor != null && this.eventHandler != null) {
            this.registerEventHandler();
            this.updateEnabledState();
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected DrawingView getView() {
        return this.editor == null ? null : this.editor.getActiveView();
    }

    protected Drawing getDrawing() {
        return this.getView() == null ? null : this.getView().getDrawing();
    }

    protected void fireUndoableEditHappened(UndoableEdit undoableEdit) {
        this.getDrawing().fireUndoableEditHappened(undoableEdit);
    }

    public void setUpdateEnabledState(boolean bl) {
        if (this.eventHandler != null != bl) {
            if (bl) {
                this.eventHandler = new EventHandler();
                this.registerEventHandler();
            } else {
                this.unregisterEventHandler();
                this.eventHandler = null;
            }
        }
        if (bl) {
            this.updateEnabledState();
        }
    }

    public boolean isUpdatEnabledState() {
        return this.eventHandler != null;
    }

    private void unregisterEventHandler() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this.eventHandler);
        }
        if (this.activeView != null) {
            this.activeView.removeFigureSelectionListener(this.eventHandler);
            this.activeView.removePropertyChangeListener(this.eventHandler);
            this.activeView = null;
        }
    }

    private void registerEventHandler() {
        if (this.editor != null) {
            this.editor.addPropertyChangeListener(new WeakPropertyChangeListener(this.eventHandler));
            if (this.activeView != null) {
                this.activeView.removeFigureSelectionListener(this.eventHandler);
                this.activeView.removePropertyChangeListener(this.eventHandler);
            }
            this.activeView = this.editor.getActiveView();
            if (this.activeView != null) {
                this.activeView.addFigureSelectionListener(this.eventHandler);
                this.activeView.addPropertyChangeListener(this.eventHandler);
            }
        }
    }

    private class EventHandler
    implements PropertyChangeListener,
    FigureSelectionListener,
    Serializable {
        private EventHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "activeView") {
                if (AbstractSelectedAction.this.activeView != null) {
                    AbstractSelectedAction.this.activeView.removeFigureSelectionListener(this);
                    AbstractSelectedAction.this.activeView.removePropertyChangeListener(this);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    AbstractSelectedAction.this.activeView = (DrawingView)propertyChangeEvent.getNewValue();
                    AbstractSelectedAction.this.activeView.addFigureSelectionListener(this);
                    AbstractSelectedAction.this.activeView.addPropertyChangeListener(this);
                }
                AbstractSelectedAction.this.updateEnabledState();
            } else if (propertyChangeEvent.getPropertyName().equals("enabled")) {
                AbstractSelectedAction.this.updateEnabledState();
            }
        }

        public String toString() {
            return AbstractSelectedAction.this + " " + this.getClass() + "@" + this.hashCode();
        }

        @Override
        public void selectionChanged(FigureSelectionEvent figureSelectionEvent) {
            AbstractSelectedAction.this.updateEnabledState();
        }
    }
}

