/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.WrongType;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Map;

@GwtCompatible
public class MapContainsValueTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_yes() {
        MapContainsValueTester.assertTrue((String)"containsValue(present) should return true", (boolean)this.getMap().containsValue(((Map.Entry)this.samples.e0).getValue()));
    }

    public void testContains_no() {
        MapContainsValueTester.assertFalse((String)"containsValue(notPresent) should return false", (boolean)this.getMap().containsValue(((Map.Entry)this.samples.e3).getValue()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContains_nullNotContainedButAllowed() {
        MapContainsValueTester.assertFalse((String)"containsValue(null) should return false", (boolean)this.getMap().containsValue(null));
    }

    @MapFeature.Require(absent={MapFeature.ALLOWS_NULL_QUERIES})
    public void testContains_nullNotContainedAndUnsupported() {
        this.expectNullValueMissingWhenNullValuesUnsupported("containsValue(null) should return false or throw");
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nonNullWhenNullContained() {
        this.initMapWithNullValue();
        MapContainsValueTester.assertFalse((String)"containsValue(notPresent) should return false", (boolean)this.getMap().containsValue(((Map.Entry)this.samples.e3).getValue()));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testContains_nullContained() {
        this.initMapWithNullValue();
        MapContainsValueTester.assertTrue((String)"containsValue(null) should return true", (boolean)this.getMap().containsValue(null));
    }

    public void testContains_wrongType() {
        try {
            MapContainsValueTester.assertFalse((String)"containsValue(wrongType) should return false or throw", (boolean)this.getMap().containsValue((Object)WrongType.VALUE));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

