/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

ChromeUtils.import("resource://gre/modules/Services.jsm");

var testGenerator = testSteps();

function* testSteps()
{
  const principalInfos = [
    { url: "http://localhost" },
    { url: "http://www.mozilla.org" },
    { url: "http://example.com" },
    { url: "http://example.org", attrs: { userContextId: 5 } },

    { url: "http://origin.test", attrs: {} },

    { url: "http://prefix.test", attrs: {} },
    { url: "http://prefix.test", attrs: { userContextId: 10 } },

    { url: "http://pattern.test", attrs: { userContextId: 15 } },
    { url: "http://pattern.test:8080", attrs: { userContextId: 15 } },
    { url: "https://pattern.test", attrs: { userContextId: 15 } },
  ];

  const data = {
    key: "foo",
    value: "bar"
  };

  function getLocalStorage(principalInfo)
  {
    let uri = Services.io.newURI(principalInfo.url);
    let attrs = principalInfo.attrs ? principalInfo.attrs : { };
    let principal =
      Services.scriptSecurityManager.createCodebasePrincipal(uri, attrs);
    return Services.domStorageManager.createStorage(null, principal, "");
  }

  info("Getting storages");

  let storages = [];
  for (let i = 0; i < principalInfos.length; i++) {
    let storage = getLocalStorage(principalInfos[i]);
    storages.push(storage);
  }

  info("Adding data");

  for (let i = 0; i < storages.length; i++) {
    storages[i].setItem(data.key + i, data.value + i);
  }

  finishTest();
}
