#!/bin/sh
# 
# Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# This code is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 only, as
# published by the Free Software Foundation.
# 
# This code is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# version 2 for more details (a copy is included in the LICENSE file that
# accompanied this code).
# 
# You should have received a copy of the GNU General Public License version
# 2 along with this work; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
# 
# Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
# or visit www.oracle.com if you need additional information or have any
# questions.
# 
# 

##
## @test
## @bug 8011675
## @summary testing of ciReplay with using generated by VM replay.txt 
## @author igor.ignatyev@oracle.com
## @run shell TestVM.sh
##

if [ "${TESTSRC}" = "" ]
then
  TESTSRC=${PWD}
  echo "TESTSRC not set.  Using "${TESTSRC}" as default"
fi
echo "TESTSRC=${TESTSRC}"

## Adding common setup Variables for running shell tests.
. ${TESTSRC}/../../test_env.sh

. ${TESTSRC}/common.sh

generate_replay

if [ ! -s ${replay_data} ]
then
    test_fail 1 "CHECK :: REPLAY DATA GENERATION" \
        "replay data wasn't generated by VM"
fi

common_tests 10
${VM_TYPE}_tests 20

cleanup

if [ $is_tiered -eq 1 ]
then
    stop_level=1
    while [ $stop_level -le $server_level ]
    do
        generate_replay "-XX:TieredStopAtLevel=$stop_level"
        if [ ! -s ${replay_data} ]
        then
            test_fail `expr $stop_level + 30` \
                    "TIERED LEVEL $stop_level :: REPLAY DATA GENERATION" \
                    "replay data wasn't generated by VM with stop_level=$stop_level"
        fi
        level=`grep "^compile " $replay_data | awk '{print $6}'`
        if [ $level -gt $stop_level ]
        then
            test_fail `expr $stop_level + 40` \
                    "TIERED LEVEL $stop_level :: COMP_LEVEL VERIFICATION" \
                    "comp_level in replay[$level] is greater than stop_level[$stop_level]"
        fi
        positive_test `expr $stop_level + 50` "TIERED LEVEL $stop_level :: REPLAY" \
                "-XX:TieredStopAtLevel=$stop_level"
        stop_level=`expr $stop_level + 1`
    done
    cleanup
fi

echo TEST PASSED

