#ifndef INCLUDE_DRIVER_BACKLIGHT_GMA950_H
#define INCLUDE_DRIVER_BACKLIGHT_GMA950_H
/**
 * @brief Low level backlight driver for Intel GMA960 graphic cards.
 *
 * This file contains some definitions and the prototypes for the
 * GMA950 backlight driver.
 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation
 * (http://www.gnu.org/licenses/gpl.html)
 *
 * @file    src/driver_backlight_gma950.h
 * @author  Matthias Grimm <matthias.grimm@users.sourceforge.net>
 * @author  Stefan Bruda <bruda@cs.ubishops.ca> 
 * @author  Nicolas Boichat <nicolas@boichat.ch>
 * @author  Julien Blache <jb@jblache.org>
 */

#define GMA950_BRIGHTNESS_MIN 0x1f

#define PCI_ID_VENDOR_INTEL   0x8086
#define PCI_ID_PRODUCT_GMA950 0x27A2

struct driver_backlight *driver_backlight_gma950_init ();

#endif    /* INCLUDE_DRIVER_BACKLIGHT_GMA950_H */
