/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSRealtimeAnalyserNode.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSFloat32Array.h"
#include "JSUint8Array.h"
#include "RealtimeAnalyserNode.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSRealtimeAnalyserNode);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSRealtimeAnalyserNodeTableValues[7] =
{
    { "fftSize", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRealtimeAnalyserNodeFftSize), (intptr_t)setJSRealtimeAnalyserNodeFftSize THUNK_GENERATOR(0) },
    { "frequencyBinCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRealtimeAnalyserNodeFrequencyBinCount), (intptr_t)0 THUNK_GENERATOR(0) },
    { "minDecibels", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRealtimeAnalyserNodeMinDecibels), (intptr_t)setJSRealtimeAnalyserNodeMinDecibels THUNK_GENERATOR(0) },
    { "maxDecibels", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRealtimeAnalyserNodeMaxDecibels), (intptr_t)setJSRealtimeAnalyserNodeMaxDecibels THUNK_GENERATOR(0) },
    { "smoothingTimeConstant", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRealtimeAnalyserNodeSmoothingTimeConstant), (intptr_t)setJSRealtimeAnalyserNodeSmoothingTimeConstant THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsRealtimeAnalyserNodeConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSRealtimeAnalyserNodeTable = { 17, 15, JSRealtimeAnalyserNodeTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSRealtimeAnalyserNodeConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSRealtimeAnalyserNodeConstructorTable = { 1, 0, JSRealtimeAnalyserNodeConstructorTableValues, 0 };
class JSRealtimeAnalyserNodeConstructor : public DOMConstructorObject {
public:
    JSRealtimeAnalyserNodeConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSRealtimeAnalyserNodeConstructor::s_info = { "RealtimeAnalyserNodeConstructor", &DOMConstructorObject::s_info, &JSRealtimeAnalyserNodeConstructorTable, 0 };

JSRealtimeAnalyserNodeConstructor::JSRealtimeAnalyserNodeConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSRealtimeAnalyserNodePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSRealtimeAnalyserNodeConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRealtimeAnalyserNodeConstructor, JSDOMWrapper>(exec, &JSRealtimeAnalyserNodeConstructorTable, this, propertyName, slot);
}

bool JSRealtimeAnalyserNodeConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRealtimeAnalyserNodeConstructor, JSDOMWrapper>(exec, &JSRealtimeAnalyserNodeConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSRealtimeAnalyserNodePrototypeTableValues[4] =
{
    { "getFloatFrequencyData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRealtimeAnalyserNodePrototypeFunctionGetFloatFrequencyData), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getByteFrequencyData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRealtimeAnalyserNodePrototypeFunctionGetByteFrequencyData), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getByteTimeDomainData", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsRealtimeAnalyserNodePrototypeFunctionGetByteTimeDomainData), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSRealtimeAnalyserNodePrototypeTable = { 8, 7, JSRealtimeAnalyserNodePrototypeTableValues, 0 };
const ClassInfo JSRealtimeAnalyserNodePrototype::s_info = { "RealtimeAnalyserNodePrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSRealtimeAnalyserNodePrototypeTable, 0 };

JSObject* JSRealtimeAnalyserNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSRealtimeAnalyserNode>(exec, globalObject);
}

bool JSRealtimeAnalyserNodePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSRealtimeAnalyserNodePrototypeTable, this, propertyName, slot);
}

bool JSRealtimeAnalyserNodePrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSRealtimeAnalyserNodePrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSRealtimeAnalyserNode::s_info = { "RealtimeAnalyserNode", &JSAudioNode::s_info, &JSRealtimeAnalyserNodeTable, 0 };

JSRealtimeAnalyserNode::JSRealtimeAnalyserNode(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<RealtimeAnalyserNode> impl)
    : JSAudioNode(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSRealtimeAnalyserNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSRealtimeAnalyserNodePrototype(exec->globalData(), globalObject, JSRealtimeAnalyserNodePrototype::createStructure(exec->globalData(), JSAudioNodePrototype::self(exec, globalObject)));
}

bool JSRealtimeAnalyserNode::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSRealtimeAnalyserNode, Base>(exec, &JSRealtimeAnalyserNodeTable, this, propertyName, slot);
}

bool JSRealtimeAnalyserNode::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSRealtimeAnalyserNode, Base>(exec, &JSRealtimeAnalyserNodeTable, this, propertyName, descriptor);
}

JSValue jsRealtimeAnalyserNodeFftSize(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(imp->fftSize());
    return result;
}


JSValue jsRealtimeAnalyserNodeFrequencyBinCount(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(imp->frequencyBinCount());
    return result;
}


JSValue jsRealtimeAnalyserNodeMinDecibels(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(imp->minDecibels());
    return result;
}


JSValue jsRealtimeAnalyserNodeMaxDecibels(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(imp->maxDecibels());
    return result;
}


JSValue jsRealtimeAnalyserNodeSmoothingTimeConstant(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    JSValue result = jsNumber(imp->smoothingTimeConstant());
    return result;
}


JSValue jsRealtimeAnalyserNodeConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSRealtimeAnalyserNode* domObject = static_cast<JSRealtimeAnalyserNode*>(asObject(slotBase));
    return JSRealtimeAnalyserNode::getConstructor(exec, domObject->globalObject());
}

void JSRealtimeAnalyserNode::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSRealtimeAnalyserNode, Base>(exec, propertyName, value, &JSRealtimeAnalyserNodeTable, this, slot);
}

void setJSRealtimeAnalyserNodeFftSize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(thisObject);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    imp->setFftSize(value.toUInt32(exec));
}


void setJSRealtimeAnalyserNodeMinDecibels(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(thisObject);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    imp->setMinDecibels(value.toFloat(exec));
}


void setJSRealtimeAnalyserNodeMaxDecibels(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(thisObject);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    imp->setMaxDecibels(value.toFloat(exec));
}


void setJSRealtimeAnalyserNodeSmoothingTimeConstant(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(thisObject);
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    imp->setSmoothingTimeConstant(value.toFloat(exec));
}


JSValue JSRealtimeAnalyserNode::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSRealtimeAnalyserNodeConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsRealtimeAnalyserNodePrototypeFunctionGetFloatFrequencyData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRealtimeAnalyserNode::s_info))
        return throwVMTypeError(exec);
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(thisValue));
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    Float32Array* array(toFloat32Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->getFloatFrequencyData(array);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRealtimeAnalyserNodePrototypeFunctionGetByteFrequencyData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRealtimeAnalyserNode::s_info))
        return throwVMTypeError(exec);
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(thisValue));
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    Uint8Array* array(toUint8Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->getByteFrequencyData(array);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsRealtimeAnalyserNodePrototypeFunctionGetByteTimeDomainData(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSRealtimeAnalyserNode::s_info))
        return throwVMTypeError(exec);
    JSRealtimeAnalyserNode* castedThis = static_cast<JSRealtimeAnalyserNode*>(asObject(thisValue));
    RealtimeAnalyserNode* imp = static_cast<RealtimeAnalyserNode*>(castedThis->impl());
    Uint8Array* array(toUint8Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->getByteTimeDomainData(array);
    return JSValue::encode(jsUndefined());
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, RealtimeAnalyserNode* impl)
{
    return wrap<JSRealtimeAnalyserNode>(exec, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
