
/*
 * GB18030 four-byte extension
 */

static const unsigned short gb18030uni_charset2uni_ranges[368] = {
  0x0000, 0x0022,  0x0023, 0x0024,  0x0025, 0x002b,  0x002c, 0x0030,
  0x0031, 0x004f,  0x0050, 0x0057,  0x0058, 0x005d,  0x005e, 0x005e,
  0x005f, 0x0062,  0x0063, 0x0065,  0x0066, 0x0066,  0x0067, 0x0067,
  0x0068, 0x006b,  0x006c, 0x007c,  0x007d, 0x0083,  0x0084, 0x0092,
  0x0093, 0x00aa,  0x00ab, 0x00ad,  0x00ae, 0x00b1,  0x00b2, 0x00ce,
  0x00cf, 0x0130,  0x0131, 0x0131,  0x0132, 0x0132,  0x0133, 0x0133,
  0x0134, 0x0134,  0x0135, 0x0135,  0x0136, 0x0136,  0x0137, 0x0137,
  0x0138, 0x0153,  0x0154, 0x01aa,  0x01ab, 0x01b9,  0x01ba, 0x021e,
  0x021f, 0x021f,  0x0220, 0x022c,  0x022d, 0x02e3,  0x02e5, 0x02eb,
  0x02ec, 0x02ec,  0x02ed, 0x0323,  0x0324, 0x0331,  0x0332, 0x0332,
  0x0333, 0x1ef0,  0x1ef1, 0x1ef2,  0x1ef3, 0x1ef3,  0x1ef4, 0x1ef5,
  0x1ef6, 0x1efc,  0x1efd, 0x1f05,  0x1f06, 0x1f06,  0x1f07, 0x1f07,
  0x1f08, 0x1f0c,  0x1f0d, 0x1f7c,  0x1f7d, 0x1fd2,  0x1fd3, 0x1fd3,
  0x1fd4, 0x1fd6,  0x1fd7, 0x1fe2,  0x1fe3, 0x1fec,  0x1fed, 0x202a,
  0x202b, 0x202e,  0x202f, 0x2038,  0x2045, 0x2046,  0x2047, 0x20b4,
  0x20b5, 0x20ba,  0x20bb, 0x20bb,  0x20bc, 0x20be,  0x20bf, 0x20c2,
  0x20c3, 0x20c4,  0x20c5, 0x20c6,  0x20c7, 0x20c7,  0x20c8, 0x20c8,
  0x20c9, 0x20ca,  0x20cb, 0x20cf,  0x20d0, 0x20d4,  0x20d5, 0x20de,
  0x20df, 0x20e1,  0x20e2, 0x20e6,  0x20e7, 0x20f3,  0x20f4, 0x20f5,
  0x20f6, 0x20fb,  0x20fc, 0x2120,  0x2121, 0x2123,  0x2124, 0x212e,
  0x212f, 0x2147,  0x2148, 0x2199,  0x219a, 0x22d1,  0x22e7, 0x22f0,
  0x22f1, 0x233f,  0x2355, 0x2358,  0x2359, 0x2365,  0x2366, 0x2368,
  0x2373, 0x2382,  0x2383, 0x238a,  0x238b, 0x2392,  0x2393, 0x2395,
  0x2396, 0x2397,  0x2398, 0x23a9,  0x23aa, 0x23c8,  0x23c9, 0x23ca,
  0x23cb, 0x2400,  0x2401, 0x2401,  0x2402, 0x2c3f,  0x2c40, 0x2c41,
  0x2c42, 0x2c44,  0x2c45, 0x2c46,  0x2c47, 0x2c60,  0x2c61, 0x2c62,
  0x2c63, 0x2c65,  0x2c66, 0x2c69,  0x2c6a, 0x2c6b,  0x2c6c, 0x2c6e,
  0x2c6f, 0x2c7c,  0x2c7d, 0x2d87,  0x2da6, 0x2da6,  0x2da7, 0x2dab,
  0x2dac, 0x2dad,  0x2dae, 0x2dc3,  0x2dc5, 0x2dcb,  0x2dce, 0x2dd2,
  0x2dd9, 0x2ecb,  0x2ecf, 0x2ed5,  0x2ed6, 0x2f46,  0x2f47, 0x3030,
  0x3031, 0x303c,  0x303d, 0x303e,  0x303f, 0x3060,  0x3061, 0x3069,
  0x306a, 0x306b,  0x306c, 0x306d,  0x306e, 0x30de,  0x30df, 0x3109,
  0x310a, 0x3233,  0x3234, 0x32a2,  0x32a3, 0x32ad,  0x32ae, 0x35aa,
  0x35ab, 0x35ff,  0x3600, 0x365f,  0x3660, 0x366d,  0x366e, 0x3700,
  0x3701, 0x37da,  0x37db, 0x38f9,  0x38fa, 0x396a,  0x396b, 0x3cdf,
  0x3ce0, 0x3de7,  0x3de8, 0x3fbe,  0x3fbf, 0x4032,  0x4033, 0x4036,
  0x4037, 0x4061,  0x4062, 0x4159,  0x415a, 0x42ce,  0x42cf, 0x42e2,
  0x42e3, 0x43a3,  0x43a4, 0x43a8,  0x43a9, 0x43fa,  0x43fb, 0x440a,
  0x440b, 0x45c3,  0x45c4, 0x45f5,  0x45f6, 0x45f7,  0x45f8, 0x45fb,
  0x45fc, 0x45fc,  0x45fd, 0x4610,  0x4611, 0x4613,  0x4614, 0x4629,
  0x462a, 0x48e8,  0x48e9, 0x490f,  0x4910, 0x497e,  0x497f, 0x4a12,
  0x4a13, 0x4a19,  0x4abe, 0x8261,  0x9b59, 0x9b84,  0x9b85, 0x9bd0,
  0x9bd1, 0x9beb,  0x9bec, 0x9c3c,  0x9c3d, 0x9c45,  0x9c46, 0x9c5f,
  0x9c60, 0x9c60,  0x9c61, 0x9c61,  0x9c62, 0x9c64,  0x9c65, 0x9c6a,
  0x9c6b, 0x9c6b,  0x9c6c, 0x9c6d,  0x9c6e, 0xa067,  0xa074, 0xa074,
  0xa07a, 0xa07a,  0xa080, 0xa10f,  0xa113, 0xa18e,  0xa192, 0xa1a9
};

static const unsigned short gb18030uni_uni2charset_ranges[368] = {
  0x0081, 0x00a3,  0x00a5, 0x00a6,  0x00a9, 0x00af,  0x00b2, 0x00b6,
  0x00b8, 0x00d6,  0x00d8, 0x00df,  0x00e2, 0x00e7,  0x00eb, 0x00eb,
  0x00ee, 0x00f1,  0x00f4, 0x00f6,  0x00f8, 0x00f8,  0x00fb, 0x00fb,
  0x00fd, 0x0100,  0x0102, 0x0112,  0x0114, 0x011a,  0x011c, 0x012a,
  0x012c, 0x0143,  0x0145, 0x0147,  0x0149, 0x014c,  0x014e, 0x016a,
  0x016c, 0x01cd,  0x01cf, 0x01cf,  0x01d1, 0x01d1,  0x01d3, 0x01d3,
  0x01d5, 0x01d5,  0x01d7, 0x01d7,  0x01d9, 0x01d9,  0x01db, 0x01db,
  0x01dd, 0x01f8,  0x01fa, 0x0250,  0x0252, 0x0260,  0x0262, 0x02c6,
  0x02c8, 0x02c8,  0x02cc, 0x02d8,  0x02da, 0x0390,  0x03aa, 0x03b0,
  0x03c2, 0x03c2,  0x03ca, 0x0400,  0x0402, 0x040f,  0x0450, 0x0450,
  0x0452, 0x200f,  0x2011, 0x2012,  0x2017, 0x2017,  0x201a, 0x201b,
  0x201e, 0x2024,  0x2027, 0x202f,  0x2031, 0x2031,  0x2034, 0x2034,
  0x2036, 0x203a,  0x203c, 0x20ab,  0x20ad, 0x2102,  0x2104, 0x2104,
  0x2106, 0x2108,  0x210a, 0x2115,  0x2117, 0x2120,  0x2122, 0x215f,
  0x216c, 0x216f,  0x217a, 0x2183,  0x2194, 0x2195,  0x219a, 0x2207,
  0x2209, 0x220e,  0x2210, 0x2210,  0x2212, 0x2214,  0x2216, 0x2219,
  0x221b, 0x221c,  0x2221, 0x2222,  0x2224, 0x2224,  0x2226, 0x2226,
  0x222c, 0x222d,  0x222f, 0x2233,  0x2238, 0x223c,  0x223e, 0x2247,
  0x2249, 0x224b,  0x224d, 0x2251,  0x2253, 0x225f,  0x2262, 0x2263,
  0x2268, 0x226d,  0x2270, 0x2294,  0x2296, 0x2298,  0x229a, 0x22a4,
  0x22a6, 0x22be,  0x22c0, 0x2311,  0x2313, 0x244a,  0x246a, 0x2473,
  0x249c, 0x24ea,  0x254c, 0x254f,  0x2574, 0x2580,  0x2590, 0x2592,
  0x25a2, 0x25b1,  0x25b4, 0x25bb,  0x25be, 0x25c5,  0x25c8, 0x25ca,
  0x25cc, 0x25cd,  0x25d0, 0x25e1,  0x25e6, 0x2604,  0x2607, 0x2608,
  0x260a, 0x263f,  0x2641, 0x2641,  0x2643, 0x2e80,  0x2e82, 0x2e83,
  0x2e85, 0x2e87,  0x2e89, 0x2e8a,  0x2e8d, 0x2ea6,  0x2ea8, 0x2ea9,
  0x2eab, 0x2ead,  0x2eaf, 0x2eb2,  0x2eb4, 0x2eb5,  0x2eb8, 0x2eba,
  0x2ebc, 0x2ec9,  0x2ecb, 0x2fd5,  0x3004, 0x3004,  0x3018, 0x301c,
  0x301f, 0x3020,  0x302a, 0x303f,  0x3094, 0x309a,  0x30f7, 0x30fb,
  0x312a, 0x321c,  0x322a, 0x3230,  0x3232, 0x32a2,  0x32a4, 0x338d,
  0x3390, 0x339b,  0x339f, 0x33a0,  0x33a2, 0x33c3,  0x33c5, 0x33cd,
  0x33cf, 0x33d0,  0x33d3, 0x33d4,  0x33d6, 0x3446,  0x3448, 0x3472,
  0x3474, 0x359d,  0x359f, 0x360d,  0x360f, 0x3619,  0x361b, 0x3917,
  0x3919, 0x396d,  0x396f, 0x39ce,  0x39d1, 0x39de,  0x39e0, 0x3a72,
  0x3a74, 0x3b4d,  0x3b4f, 0x3c6d,  0x3c6f, 0x3cdf,  0x3ce1, 0x4055,
  0x4057, 0x415e,  0x4160, 0x4336,  0x4338, 0x43ab,  0x43ad, 0x43b0,
  0x43b2, 0x43dc,  0x43de, 0x44d5,  0x44d7, 0x464b,  0x464d, 0x4660,
  0x4662, 0x4722,  0x4724, 0x4728,  0x472a, 0x477b,  0x477d, 0x478c,
  0x478e, 0x4946,  0x4948, 0x4979,  0x497b, 0x497c,  0x497e, 0x4981,
  0x4984, 0x4984,  0x4987, 0x499a,  0x499c, 0x499e,  0x49a0, 0x49b5,
  0x49b8, 0x4c76,  0x4c78, 0x4c9e,  0x4ca4, 0x4d12,  0x4d1a, 0x4dad,
  0x4daf, 0x4db5,  0xa000, 0xd7a3,  0xf900, 0xf92b,  0xf92d, 0xf978,
  0xf97a, 0xf994,  0xf996, 0xf9e6,  0xf9e8, 0xf9f0,  0xf9f2, 0xfa0b,
  0xfa10, 0xfa10,  0xfa12, 0xfa12,  0xfa15, 0xfa17,  0xfa19, 0xfa1e,
  0xfa22, 0xfa22,  0xfa25, 0xfa26,  0xfa2a, 0xfe23,  0xfe32, 0xfe32,
  0xfe58, 0xfe58,  0xfe70, 0xfeff,  0xff61, 0xffdc,  0xffe6, 0xfffd
};

static const struct { unsigned short diff; unsigned short bitmap_offset; } gb18030uni_ranges[184] = {
  {   129, 0x0000 }, {   130, 0x0023 }, {   132, 0x0025 }, {   134, 0x002c },
  {   135, 0x0031 }, {   136, 0x0050 }, {   138, 0x0058 }, {   141, 0x005e },
  {   143, 0x005f }, {   145, 0x0063 }, {   146, 0x0066 }, {   148, 0x0067 },
  {   149, 0x0068 }, {   150, 0x006c }, {   151, 0x007d }, {   152, 0x0084 },
  {   153, 0x0093 }, {   154, 0x00ab }, {   155, 0x00ae }, {   156, 0x00b2 },
  {   157, 0x00cf }, {   158, 0x0131 }, {   159, 0x0132 }, {   160, 0x0133 },
  {   161, 0x0134 }, {   162, 0x0135 }, {   163, 0x0136 }, {   164, 0x0137 },
  {   165, 0x0138 }, {   166, 0x0154 }, {   167, 0x01ab }, {   168, 0x01ba },
  {   169, 0x021f }, {   172, 0x0220 }, {   173, 0x022d }, {   197, 0x02e4 },
  {   214, 0x02eb }, {   221, 0x02ec }, {   222, 0x0323 }, {   286, 0x0331 },
  {   287, 0x0332 }, {   288, 0x1ef0 }, {   292, 0x1ef2 }, {   294, 0x1ef3 },
  {   296, 0x1ef5 }, {   298, 0x1efc }, {   299, 0x1f05 }, {   301, 0x1f06 },
  {   302, 0x1f07 }, {   303, 0x1f0c }, {   304, 0x1f7c }, {   305, 0x1fd2 },
  {   306, 0x1fd3 }, {   307, 0x1fd6 }, {   308, 0x1fe2 }, {   309, 0x1fec },
  {   321, 0x202a }, {   331, 0x202e }, {   335, 0x2038 }, {   339, 0x203a },
  {   340, 0x20a8 }, {   341, 0x20ae }, {   342, 0x20af }, {   343, 0x20b2 },
  {   344, 0x20b6 }, {   348, 0x20b8 }, {   349, 0x20ba }, {   350, 0x20bb },
  {   355, 0x20bc }, {   356, 0x20be }, {   360, 0x20c3 }, {   361, 0x20c8 },
  {   362, 0x20d2 }, {   363, 0x20d5 }, {   364, 0x20da }, {   366, 0x20e7 },
  {   370, 0x20e9 }, {   372, 0x20ef }, {   373, 0x2114 }, {   374, 0x2117 },
  {   375, 0x2122 }, {   376, 0x213b }, {   377, 0x218d }, {   387, 0x22c5 },
  {   427, 0x22cf }, {   503, 0x231e }, {   539, 0x2322 }, {   554, 0x232f },
  {   559, 0x2332 }, {   561, 0x2342 }, {   563, 0x234a }, {   565, 0x2352 },
  {   566, 0x2355 }, {   568, 0x2357 }, {   572, 0x2369 }, {   574, 0x2388 },
  {   575, 0x238a }, {   576, 0x23c0 }, {   577, 0x23c1 }, {   578, 0x2bff },
  {   579, 0x2c01 }, {   580, 0x2c04 }, {   582, 0x2c06 }, {   583, 0x2c20 },
  {   584, 0x2c22 }, {   585, 0x2c25 }, {   586, 0x2c29 }, {   588, 0x2c2b },
  {   589, 0x2c2e }, {   590, 0x2c3c }, {   606, 0x2d47 }, {   625, 0x2d48 },
  {   627, 0x2d4d }, {   636, 0x2d4f }, {   719, 0x2d65 }, {   809, 0x2d6c },
  {   849, 0x2d71 }, {   859, 0x2e64 }, {   860, 0x2e6b }, {   861, 0x2edc },
  {   863, 0x2fc6 }, {   866, 0x2fd2 }, {   867, 0x2fd4 }, {   868, 0x2ff6 },
  {   869, 0x2fff }, {   871, 0x3001 }, {   872, 0x3003 }, {   873, 0x3074 },
  {   874, 0x309f }, {   875, 0x31c9 }, {   876, 0x3238 }, {   877, 0x3243 },
  {   878, 0x3540 }, {   879, 0x3595 }, {   881, 0x35f5 }, {   882, 0x3603 },
  {   883, 0x3696 }, {   884, 0x3770 }, {   885, 0x388f }, {   886, 0x3900 },
  {   887, 0x3c75 }, {   888, 0x3d7d }, {   889, 0x3f54 }, {   890, 0x3fc8 },
  {   891, 0x3fcc }, {   892, 0x3ff7 }, {   893, 0x40ef }, {   894, 0x4264 },
  {   895, 0x4278 }, {   896, 0x4339 }, {   897, 0x433e }, {   898, 0x4390 },
  {   899, 0x43a0 }, {   900, 0x4559 }, {   901, 0x458b }, {   902, 0x458d },
  {   904, 0x4591 }, {   906, 0x4592 }, {   907, 0x45a6 }, {   908, 0x45a9 },
  {   910, 0x45bf }, {   911, 0x487e }, {   916, 0x48a5 }, {   923, 0x4914 },
  {   924, 0x49a8 }, { 21826, 0x49af }, { 23975, 0x8153 }, { 23976, 0x817f },
  { 23977, 0x81cb }, { 23978, 0x81e6 }, { 23979, 0x8237 }, { 23980, 0x8240 },
  { 23984, 0x825a }, { 23985, 0x825b }, { 23987, 0x825c }, { 23988, 0x825f },
  { 23991, 0x8265 }, { 23993, 0x8266 }, { 23996, 0x8268 }, { 23998, 0x8662 },
  { 24030, 0x8663 }, { 24048, 0x8664 }, { 24142, 0x86f4 }, { 24148, 0x8770 }
};

static const unsigned char gb18030uni_bitmap[4337] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
  0xff, 0x3f, 0x00, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x03, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x03, 0x00, 0x38, 0x00, 0x80, 0x21, 0x82, 0xbf, 0xfe, 0xff, 0xfd, 0xf3,
  0xff, 0xff, 0x3f, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x7f, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x19, 0xff, 0xff,
  0xff, 0xff, 0x3f, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0xff,
  0xff, 0xff, 0x7f, 0xfe, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x06, 0xfe, 0xff,
  0xfb, 0xff, 0xff, 0xfb, 0x1f, 0x00, 0xff, 0xff, 0xff, 0x07, 0x1f, 0x00,
  0x00, 0x10, 0x00, 0x88, 0xfe, 0xff, 0xff, 0x07, 0xff, 0xff, 0x3f, 0x00,
  0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xff,
  0xff, 0x1f, 0xff, 0xff, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3f, 0x1f, 0xff,
  0xff, 0xff, 0x01, 0x00, 0xee, 0x9f, 0xf9, 0xff, 0xff, 0xfd, 0xc5, 0xd3,
  0x9f, 0x39, 0x80, 0xb0, 0xcf, 0xff, 0xff, 0x07, 0xe4, 0x87, 0xf9, 0xff,
  0xff, 0xfd, 0x6d, 0xd3, 0x87, 0x39, 0x00, 0x5e, 0xc0, 0xff, 0x1f, 0x00,
  0xee, 0xaf, 0xfb, 0xff, 0xff, 0xfd, 0xed, 0xf3, 0xbf, 0x3b, 0x01, 0x00,
  0xc1, 0xff, 0x00, 0x00, 0xee, 0x9f, 0xf9, 0xff, 0xff, 0xfd, 0xcd, 0xf3,
  0x8f, 0x39, 0xc0, 0xb0, 0xc3, 0xff, 0x01, 0x00, 0xec, 0xc7, 0x3d, 0xd6,
  0x18, 0xc7, 0xbf, 0xc3, 0xc7, 0x3d, 0x80, 0x00, 0x80, 0xff, 0x07, 0x00,
  0xee, 0xdf, 0xfd, 0xff, 0xff, 0xfd, 0xef, 0xc3, 0xdf, 0x3d, 0x60, 0x00,
  0xc3, 0xff, 0x00, 0x00, 0xec, 0xdf, 0xfd, 0xff, 0xff, 0xfd, 0xef, 0xc3,
  0xdf, 0x3d, 0x60, 0x40, 0xc3, 0xff, 0x00, 0x00, 0xec, 0xdf, 0xfd, 0xff,
  0xff, 0xfd, 0xff, 0xc3, 0xcf, 0x3d, 0x80, 0x00, 0xc3, 0xff, 0x00, 0x00,
  0xec, 0xff, 0x7f, 0xfc, 0xff, 0xff, 0xfb, 0x2f, 0x7f, 0x84, 0x5f, 0xff,
  0x00, 0x00, 0x1c, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87,
  0xff, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x96, 0x25, 0xf0, 0xfe,
  0xae, 0xec, 0xff, 0x3b, 0x5f, 0x3f, 0xff, 0x33, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
  0xff, 0x07, 0xfe, 0xff, 0xff, 0x0f, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xdf,
  0xff, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0xfb, 0xf6, 0xc7, 0x03, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0x08, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03,
  0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x3d, 0x7f, 0x3d,
  0xff, 0xff, 0xff, 0xff, 0x7f, 0x3d, 0xff, 0xff, 0xff, 0x7f, 0x3d, 0x7f,
  0x3d, 0x7f, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0x7f, 0x3d, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0x07, 0xfe, 0xff, 0xff, 0x1f,
  0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0x1f, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00,
  0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0x03, 0x00, 0x00,
  0xff, 0x7f, 0xff, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0x3f, 0x3f,
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x3f, 0xff, 0xaa, 0xff, 0xff, 0xff, 0x3f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xdf, 0xff, 0xcf, 0xef,
  0xff, 0xff, 0xdc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x3f,
  0x00, 0x00, 0x00, 0xfc, 0xf1, 0xff, 0xff, 0x7f, 0x00, 0x00, 0xff, 0x7f,
  0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0x07, 0x00, 0x00, 0x80, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0x00, 0xe0, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x1f, 0x00, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x1f, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc,
  0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0xfc, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07, 0xf8, 0xff, 0x0f, 0xfe,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x80, 0xf7, 0xfc, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff,
  0xff, 0xeb, 0xd1, 0x9f, 0x3f, 0x00, 0xf0, 0xff, 0xff, 0xff, 0xc7, 0xff,
  0xff, 0xbf, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xc0, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x38, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x7f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f,
  0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x01, 0x00, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x7f, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe7, 0xff, 0xff, 0xff, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xf9, 0xff,
  0xf7, 0xff, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0,
  0x1f, 0x00, 0x3e, 0xf8, 0xff, 0xff, 0xdf, 0xd7, 0xf6, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
  0x00, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f,
  0x00, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x03,
  0x00, 0x00, 0x00, 0xc0, 0x7f, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xe7,
  0xe7, 0xe7, 0xfd, 0x01, 0xf8
};

static int
gb18030uni_mbtowc (conv_t conv, ucs4_t *pwc, const unsigned char *s, int n)
{
  unsigned char c1 = s[0];
  if (c1 >= 0x81 && c1 <= 0x84) {
    if (n >= 2) {
      unsigned char c2 = s[1];
      if (c2 >= 0x30 && c2 <= 0x39) {
        if (n >= 3) {
          unsigned char c3 = s[2];
          if (c3 >= 0x81 && c3 <= 0xfe) {
            if (n >= 4) {
              unsigned char c4 = s[3];
              if (c4 >= 0x30 && c4 <= 0x39) {
                unsigned int i = (((c1 - 0x81) * 10 + (c2 - 0x30)) * 126 + (c3 - 0x81)) * 10 + (c4 - 0x30);
                if (i >= 0 && i <= 41385) {
                  unsigned int k1 = 0;
                  unsigned int k2 = 183;
                  while (k1 < k2) {
                    unsigned int k = (k1 + k2) / 2;
                    if (i <= gb18030uni_charset2uni_ranges[2*k+1])
                      k2 = k;
                    else if (i >= gb18030uni_charset2uni_ranges[2*k+2])
                      k1 = k + 1;
                    else
                      return RET_ILSEQ;
                  }
                  {
                    unsigned int bitmap_index = i - gb18030uni_charset2uni_ranges[2*k1] + gb18030uni_ranges[k1].bitmap_offset;
                    if ((gb18030uni_bitmap[bitmap_index >> 3] >> (bitmap_index & 7)) & 1) {
                      unsigned int diff = gb18030uni_ranges[k1].diff;
                      *pwc = (ucs4_t) (i + diff);
                      return 4;
                    }
                  }
                }
              }
              return RET_ILSEQ;
            }
            return RET_TOOFEW(0);
          }
          return RET_ILSEQ;
        }
        return RET_TOOFEW(0);
      }
      return RET_ILSEQ;
    }
    return RET_TOOFEW(0);
  }
  return RET_ILSEQ;
}

static int
gb18030uni_wctomb (conv_t conv, unsigned char *r, ucs4_t wc, int n)
{
  if (n >= 4) {
    unsigned int i = wc;
    if (i >= 0x0081 && i <= 0xfffd) {
      unsigned int k1 = 0;
      unsigned int k2 = 183;
      while (k1 < k2) {
        unsigned int k = (k1 + k2) / 2;
        if (i <= gb18030uni_uni2charset_ranges[2*k+1])
          k2 = k;
        else if (i >= gb18030uni_uni2charset_ranges[2*k+2])
          k1 = k + 1;
        else
          return RET_ILSEQ;
      }
      {
        unsigned int bitmap_index = i - gb18030uni_uni2charset_ranges[2*k1] + gb18030uni_ranges[k1].bitmap_offset;
        if ((gb18030uni_bitmap[bitmap_index >> 3] >> (bitmap_index & 7)) & 1) {
          unsigned int diff = gb18030uni_ranges[k1].diff;
          i -= diff;
          r[3] = (i % 10) + 0x30; i = i / 10;
          r[2] = (i % 126) + 0x81; i = i / 126;
          r[1] = (i % 10) + 0x30; i = i / 10;
          r[0] = i + 0x81;
          return 4;
        }
      }
    }
    return RET_ILSEQ;
  }
  return RET_TOOSMALL;
}
