/* catalog.c generated by valac 0.28.0, the Vala compiler
 * generated from catalog.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libseahorse/seahorse-application.h"
#include "libseahorse/seahorse-prefs.h"
#include "config.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _SeahorseCatalogPrivate {
	gchar* _ui_name;
	GtkBuilder* _builder;
	GtkUIManager* _ui_manager;
	GHashTable* _actions;
	GtkAction* _edit_delete;
	GtkAction* _properties_object;
	GtkAction* _file_export;
	GtkAction* _edit_copy;
	GList* _selection_actions;
	gboolean _disposed;
	GSettings* _settings;
};

struct _Block1Data {
	int _ref_count_;
	SeahorseCatalog* self;
	GtkAboutDialog* about;
};


static gpointer seahorse_catalog_parent_class = NULL;

#define SEAHORSE_CATALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SEAHORSE_TYPE_CATALOG, SeahorseCatalogPrivate))
enum  {
	SEAHORSE_CATALOG_DUMMY_PROPERTY,
	SEAHORSE_CATALOG_WINDOW,
	SEAHORSE_CATALOG_UI_NAME
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_catalog_on_key_export_file (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_key_export_file_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_key_export_clipboard (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_key_export_clipboard_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_object_delete (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_object_delete_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_properties_object (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_properties_object_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_properties_place (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_properties_place_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_app_preferences (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_app_preferences_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_app_about (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_app_about_gtk_action_callback (GtkAction* action, gpointer self);
static void seahorse_catalog_on_help_show (GtkAction* action, SeahorseCatalog* self);
static void _seahorse_catalog_on_help_show_gtk_action_callback (GtkAction* action, gpointer self);
static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self);
static SeahorsePlace* seahorse_catalog_real_get_focused_place (SeahorseCatalog* self);
static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self);
static void seahorse_catalog_real_dispose (GObject* base);
static GList* seahorse_catalog_lookup_actions_for_objects (SeahorseCatalog* self, GList* objects);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda10_ (Block1Data* _data1_, gint response);
static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self);
static GObject * seahorse_catalog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _seahorse_catalog___lambda11_ (SeahorseCatalog* self, GtkWidget* widget);
static void __seahorse_catalog___lambda11__gtk_ui_manager_add_widget (GtkUIManager* _sender, GtkWidget* widget, gpointer self);
static void _seahorse_catalog___lambda12_ (SeahorseCatalog* self, GtkAction* action);
static void __seahorse_catalog___lambda12__gtk_ui_manager_pre_activate (GtkUIManager* _sender, GtkAction* action, gpointer self);
static void _seahorse_catalog___lambda13_ (SeahorseCatalog* self, GtkAction* action);
static void __seahorse_catalog___lambda13__gtk_ui_manager_post_activate (GtkUIManager* _sender, GtkAction* action, gpointer self);
static void seahorse_catalog_finalize (GObject* obj);
static void _vala_seahorse_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_seahorse_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SEAHORSE_CATALOG_AUTHORS[10] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Jose Carlos Garcia Sogo <jsogo@users.sourceforge.net>", "Jean Schurger <yshark@schurger.org>", "Stef Walter <stef@memberwebs.com>", "Adam Schreiber <sadam@clemson.edu>", "", "Contributions:", "Albrecht Dreß <albrecht.dress@arcor.de>", "Jim Pharis <binbrain@gmail.com>", NULL};
static const gchar* SEAHORSE_CATALOG_DOCUMENTERS[4] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Adam Schreiber <sadam@clemson.edu>", "Milo Casagrande <milo_casagrande@yahoo.it>", NULL};
static const gchar* SEAHORSE_CATALOG_ARTISTS[3] = {"Jacob Perkins <jap1@users.sourceforge.net>", "Stef Walter <stef@memberwebs.com>", NULL};
static const GtkActionEntry SEAHORSE_CATALOG_UI_ENTRIES[12] = {{"file-menu", NULL, "_File"}, {"file-export", GTK_STOCK_SAVE_AS, "E_xport...", NULL, "Export to a file", (GCallback) _seahorse_catalog_on_key_export_file_gtk_action_callback}, {"edit-menu", NULL, "_Edit"}, {"edit-export-clipboard", GTK_STOCK_COPY, NULL, "<control>C", "Copy to the clipboard", (GCallback) _seahorse_catalog_on_key_export_clipboard_gtk_action_callback}, {"edit-delete", GTK_STOCK_DELETE, "_Delete", NULL, "Delete selected items", (GCallback) _seahorse_catalog_on_object_delete_gtk_action_callback}, {"properties-object", GTK_STOCK_PROPERTIES, NULL, NULL, "Show the properties of this item", (GCallback) _seahorse_catalog_on_properties_object_gtk_action_callback}, {"properties-keyring", GTK_STOCK_PROPERTIES, NULL, NULL, "Show the properties of this keyring", (GCallback) _seahorse_catalog_on_properties_place_gtk_action_callback}, {"app-preferences", GTK_STOCK_PREFERENCES, "Prefere_nces", NULL, "Change preferences for this program", (GCallback) _seahorse_catalog_on_app_preferences_gtk_action_callback}, {"view-menu", NULL, "_View"}, {"help-menu", NULL, "_Help"}, {"app-about", GTK_STOCK_ABOUT, NULL, NULL, "About this program", (GCallback) _seahorse_catalog_on_app_about_gtk_action_callback}, {"help-show", GTK_STOCK_HELP, "_Contents", "F1", "Show Seahorse help", (GCallback) _seahorse_catalog_on_help_show_gtk_action_callback}};

static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _seahorse_catalog_on_key_export_file_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_key_export_file (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_key_export_clipboard_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_key_export_clipboard (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_object_delete_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_object_delete (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_properties_object_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_properties_object (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_properties_place_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_properties_place (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_app_preferences_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_app_preferences (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_app_about_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_app_about (action, (SeahorseCatalog*) self);
}


static void _seahorse_catalog_on_help_show_gtk_action_callback (GtkAction* action, gpointer self) {
	seahorse_catalog_on_help_show (action, (SeahorseCatalog*) self);
}


static GList* seahorse_catalog_real_get_backends (SeahorseCatalog* self) {
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_backends'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GList* seahorse_catalog_get_backends (SeahorseCatalog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_backends (self);
}


static SeahorsePlace* seahorse_catalog_real_get_focused_place (SeahorseCatalog* self) {
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_focused_place'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


SeahorsePlace* seahorse_catalog_get_focused_place (SeahorseCatalog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_focused_place (self);
}


static GList* seahorse_catalog_real_get_selected_objects (SeahorseCatalog* self) {
	g_critical ("Type `%s' does not implement abstract method `seahorse_catalog_get_selected_objects'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GList* seahorse_catalog_get_selected_objects (SeahorseCatalog* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return SEAHORSE_CATALOG_GET_CLASS (self)->get_selected_objects (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void seahorse_catalog_real_dispose (GObject* base) {
	SeahorseCatalog * self;
	GList* _tmp0_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (SeahorseCatalog*) base;
	_g_object_unref0 (self->priv->_edit_copy);
	self->priv->_edit_copy = NULL;
	_g_object_unref0 (self->priv->_edit_delete);
	self->priv->_edit_delete = NULL;
	_g_object_unref0 (self->priv->_file_export);
	self->priv->_file_export = NULL;
	_g_object_unref0 (self->priv->_properties_object);
	self->priv->_properties_object = NULL;
	_tmp0_ = self->priv->_selection_actions;
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
		group_collection = _tmp0_;
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			GtkActionGroup* _tmp1_ = NULL;
			GtkActionGroup* group = NULL;
			_tmp1_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
			group = _tmp1_;
			{
				GtkUIManager* _tmp2_ = NULL;
				GtkActionGroup* _tmp3_ = NULL;
				_tmp2_ = self->priv->_ui_manager;
				_tmp3_ = group;
				gtk_ui_manager_remove_action_group (_tmp2_, _tmp3_);
				_g_object_unref0 (group);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
	self->priv->_selection_actions = NULL;
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = NULL;
	_tmp4_ = self->priv->_actions;
	g_hash_table_remove_all (_tmp4_);
	_tmp5_ = self->priv->_disposed;
	if (!_tmp5_) {
		gint width = 0;
		gint height = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		GSettings* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GSettings* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		GtkApplication* _tmp12_ = NULL;
		self->priv->_disposed = TRUE;
		gtk_window_get_size ((GtkWindow*) self, &_tmp6_, &_tmp7_);
		width = _tmp6_;
		height = _tmp7_;
		_tmp8_ = self->priv->_settings;
		_tmp9_ = width;
		g_settings_set_int (_tmp8_, "width", _tmp9_);
		_tmp10_ = self->priv->_settings;
		_tmp11_ = height;
		g_settings_set_int (_tmp10_, "height", _tmp11_);
		_tmp12_ = seahorse_application_get ();
		gtk_application_remove_window (_tmp12_, (GtkWindow*) self);
	}
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
}


GtkBuilder* seahorse_catalog_get_builder (SeahorseCatalog* self) {
	GtkBuilder* result = NULL;
	GtkBuilder* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_builder;
	result = _tmp0_;
	return result;
}


gconstpointer seahorse_catalog_get_widget (SeahorseCatalog* self, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, const gchar* name) {
	gconstpointer result = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_builder;
	_tmp1_ = name;
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
	result = (gconstpointer) _tmp2_;
	return result;
}


void seahorse_catalog_ensure_updated (SeahorseCatalog* self) {
	GtkUIManager* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ui_manager;
	gtk_ui_manager_ensure_update (_tmp0_);
}


void seahorse_catalog_include_actions (SeahorseCatalog* self, GtkActionGroup* group) {
	GtkUIManager* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
	GHashTable* _tmp17_ = NULL;
	GtkActionGroup* _tmp18_ = NULL;
	GtkActionGroup* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = self->priv->_ui_manager;
	_tmp1_ = group;
	gtk_ui_manager_insert_action_group (_tmp0_, _tmp1_, 10);
	_tmp2_ = group;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, SEAHORSE_TYPE_ACTIONS)) {
		SeahorseActions* actions = NULL;
		GtkActionGroup* _tmp3_ = NULL;
		SeahorseActions* _tmp4_ = NULL;
		SeahorseActions* _tmp5_ = NULL;
		gchar* definition = NULL;
		SeahorseActions* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp3_ = group;
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_TYPE_ACTIONS, SeahorseActions));
		actions = _tmp4_;
		_tmp5_ = actions;
		seahorse_actions_set_catalog (_tmp5_, self);
		_tmp6_ = actions;
		_tmp7_ = seahorse_actions_get_definition (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		definition = _tmp9_;
		_tmp10_ = definition;
		if (_tmp10_ != NULL) {
			{
				GtkUIManager* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				_tmp11_ = self->priv->_ui_manager;
				_tmp12_ = definition;
				gtk_ui_manager_add_ui_from_string (_tmp11_, _tmp12_, (gssize) (-1), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				SeahorseActions* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				err = _inner_error_;
				_inner_error_ = NULL;
				_tmp13_ = actions;
				_tmp14_ = gtk_action_group_get_name ((GtkActionGroup*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = definition;
				g_warning ("catalog.vala:193: couldn't add ui defintion for action group: %s: %s", _tmp15_, _tmp16_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (definition);
				_g_object_unref0 (actions);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_free0 (definition);
		_g_object_unref0 (actions);
	}
	_tmp17_ = self->priv->_actions;
	_tmp18_ = group;
	_tmp19_ = _g_object_ref0 (_tmp18_);
	g_hash_table_add (_tmp17_, _tmp19_);
}


void seahorse_catalog_show_properties (SeahorseCatalog* self, GObject* obj) {
	GObject* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = obj;
	seahorse_viewable_view (_tmp0_, (GtkWindow*) self);
}


void seahorse_catalog_show_context_menu (SeahorseCatalog* self, const gchar* name, guint button, guint time) {
	gchar* path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup_printf ("/%s", _tmp0_);
	path = _tmp1_;
	_tmp2_ = self->priv->_ui_manager;
	_tmp3_ = path;
	_tmp4_ = gtk_ui_manager_get_widget (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	menu = _tmp5_;
	_tmp6_ = menu;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (menu);
		_g_free0 (path);
		return;
	}
	_tmp7_ = menu;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_menu_get_type ())) {
		GtkWidget* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		GtkWidget* _tmp11_ = NULL;
		_tmp8_ = menu;
		_tmp9_ = button;
		_tmp10_ = time;
		gtk_menu_popup (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_menu_get_type (), GtkMenu), NULL, NULL, NULL, NULL, _tmp9_, (guint32) _tmp10_);
		_tmp11_ = menu;
		gtk_widget_show (_tmp11_);
	} else {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = name;
		g_warning ("catalog.vala:219: the object /%s isn't a menu", _tmp12_);
	}
	_g_object_unref0 (menu);
	_g_free0 (path);
}


static GList* seahorse_catalog_lookup_actions_for_objects (SeahorseCatalog* self, GList* objects) {
	GList* result = NULL;
	GHashTable* table = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GHashTableIter iter = {0};
	GHashTable* _tmp14_ = NULL;
	GList* results = NULL;
	GtkActionGroup* group = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_object_unref0_, NULL);
	table = _tmp2_;
	_tmp3_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp3_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp4_ = NULL;
			GObject* object = NULL;
			_tmp4_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp4_;
			{
				GtkActionGroup* actions = NULL;
				GObject* _tmp5_ = NULL;
				GtkActionGroup* _tmp6_ = NULL;
				GHashTable* _tmp7_ = NULL;
				GtkActionGroup* _tmp8_ = NULL;
				gconstpointer _tmp9_ = NULL;
				GHashTable* _tmp11_ = NULL;
				GtkActionGroup* _tmp12_ = NULL;
				GtkActionGroup* _tmp13_ = NULL;
				actions = NULL;
				_tmp5_ = object;
				g_object_get (_tmp5_, "actions", &actions, NULL, NULL);
				_tmp6_ = actions;
				if (_tmp6_ == NULL) {
					_g_object_unref0 (actions);
					_g_object_unref0 (object);
					continue;
				}
				_tmp7_ = self->priv->_actions;
				_tmp8_ = actions;
				_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
				if (((GtkActionGroup*) _tmp9_) == NULL) {
					GtkActionGroup* _tmp10_ = NULL;
					_tmp10_ = actions;
					seahorse_catalog_include_actions (self, _tmp10_);
				}
				_tmp11_ = self->priv->_actions;
				_tmp12_ = actions;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				g_hash_table_add (_tmp11_, _tmp13_);
				_g_object_unref0 (actions);
				_g_object_unref0 (object);
			}
		}
	}
	_tmp14_ = table;
	g_hash_table_iter_init (&iter, _tmp14_);
	results = NULL;
	while (TRUE) {
		gconstpointer _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		GtkActionGroup* _tmp17_ = NULL;
		GtkActionGroup* _tmp18_ = NULL;
		GtkActionGroup* _tmp19_ = NULL;
		_tmp16_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp15_), (gpointer*) NULL);
		_g_object_unref0 (group);
		_tmp17_ = _g_object_ref0 (_tmp15_);
		group = _tmp17_;
		if (!_tmp16_) {
			break;
		}
		_tmp18_ = group;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		results = g_list_prepend (results, _tmp19_);
	}
	result = results;
	_g_object_unref0 (group);
	_g_hash_table_unref0 (table);
	return result;
}


static void seahorse_catalog_on_app_preferences (GtkAction* action, SeahorseCatalog* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	seahorse_prefs_show ((GtkWindow*) self, NULL);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SeahorseCatalog* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->about);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda10_ (Block1Data* _data1_, gint response) {
	SeahorseCatalog* self;
	self = _data1_->self;
	gtk_widget_hide ((GtkWidget*) _data1_->about);
}


static void ___lambda10__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda10_ (self, response_id);
}


static void seahorse_catalog_on_app_about (GtkAction* action, SeahorseCatalog* self) {
	Block1Data* _data1_;
	GtkAboutDialog* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_data1_->about = _tmp0_;
	gtk_about_dialog_set_artists (_data1_->about, SEAHORSE_CATALOG_ARTISTS);
	gtk_about_dialog_set_authors (_data1_->about, SEAHORSE_CATALOG_AUTHORS);
	gtk_about_dialog_set_documenters (_data1_->about, SEAHORSE_CATALOG_DOCUMENTERS);
	gtk_about_dialog_set_version (_data1_->about, VERSION);
	_tmp1_ = _ ("Passwords and Keys");
	gtk_about_dialog_set_comments (_data1_->about, _tmp1_);
	gtk_about_dialog_set_copyright (_data1_->about, "Copyright \xc2\xa9 2002 - 2010 Seahorse Project");
	_tmp2_ = _ ("translator-credits");
	gtk_about_dialog_set_translator_credits (_data1_->about, _tmp2_);
	gtk_about_dialog_set_logo_icon_name (_data1_->about, "seahorse");
	gtk_about_dialog_set_website (_data1_->about, "http://www.gnome.org/projects/seahorse");
	_tmp3_ = _ ("Seahorse Project Homepage");
	gtk_about_dialog_set_website_label (_data1_->about, _tmp3_);
	g_signal_connect_data ((GtkDialog*) _data1_->about, "response", (GCallback) ___lambda10__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	gtk_window_set_transient_for ((GtkWindow*) _data1_->about, (GtkWindow*) self);
	gtk_dialog_run ((GtkDialog*) _data1_->about);
	gtk_widget_destroy ((GtkWidget*) _data1_->about);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void seahorse_catalog_on_object_delete (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GList* objects = NULL;
		GList* _tmp0_ = NULL;
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
		objects = _tmp0_;
		seahorse_deletable_delete_with_prompt_wait (objects, (GtkWindow*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_list_free0 (objects);
			goto __catch1_g_error;
		}
		_g_list_free0 (objects);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = seahorse_catalog_get_window (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = _ ("Cannot delete");
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		seahorse_util_show_error ((GtkWidget*) _tmp2_, _tmp3_, _tmp5_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void seahorse_catalog_on_properties_object (GtkAction* action, SeahorseCatalog* self) {
	GList* objects = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
	objects = _tmp0_;
	_tmp1_ = objects;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ > ((guint) 0)) {
		GList* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		_tmp3_ = objects;
		_tmp4_ = _tmp3_->data;
		seahorse_catalog_show_properties (self, (GObject*) _tmp4_);
	}
	_g_list_free0 (objects);
}


static void seahorse_catalog_on_properties_place (GtkAction* action, SeahorseCatalog* self) {
	SeahorsePlace* place = NULL;
	SeahorsePlace* _tmp0_ = NULL;
	SeahorsePlace* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = seahorse_catalog_get_focused_place (self);
	place = _tmp0_;
	_tmp1_ = place;
	if (_tmp1_ != NULL) {
		SeahorsePlace* _tmp2_ = NULL;
		_tmp2_ = place;
		seahorse_catalog_show_properties (self, (GObject*) _tmp2_);
	}
	_g_object_unref0 (place);
}


static void seahorse_catalog_on_key_export_file (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
		_tmp1_ = _tmp0_;
		seahorse_exportable_export_to_prompt_wait (_tmp1_, (GtkWindow*) self, &_inner_error_);
		_g_list_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		GtkWindow* _tmp2_ = NULL;
		GtkWindow* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = seahorse_catalog_get_window (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _ ("Couldn't export keys");
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		seahorse_util_show_error ((GtkWidget*) _tmp3_, _tmp4_, _tmp6_);
		_g_error_free0 (err);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void seahorse_catalog_on_key_export_clipboard (GtkAction* action, SeahorseCatalog* self) {
	guint8* output = NULL;
	gint output_length1 = 0;
	gint _output_size_ = 0;
	GtkClipboard* board = NULL;
	GtkClipboard* _tmp7_ = NULL;
	GtkClipboard* _tmp8_ = NULL;
	GtkClipboard* _tmp9_ = NULL;
	guint8* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	guint8* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		GList* objects = NULL;
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
		guint8* _tmp2_ = NULL;
		size_t _tmp3_;
		_tmp0_ = seahorse_catalog_get_selected_objects (self);
		objects = _tmp0_;
		_tmp1_ = objects;
		seahorse_exportable_export_to_text_wait (_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
		output = (g_free (output), NULL);
		output = _tmp2_;
		output_length1 = _tmp3_;
		_output_size_ = output_length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_list_free0 (objects);
			goto __catch3_g_error;
		}
		_g_list_free0 (objects);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Couldn't export data");
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		seahorse_util_show_error ((GtkWidget*) self, _tmp4_, _tmp6_);
		_g_error_free0 (err);
		output = (g_free (output), NULL);
		return;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		output = (g_free (output), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	board = _tmp8_;
	_tmp9_ = board;
	_tmp10_ = output;
	_tmp10__length1 = output_length1;
	_tmp11_ = output;
	_tmp11__length1 = output_length1;
	gtk_clipboard_set_text (_tmp9_, (const gchar*) _tmp10_, _tmp11__length1);
	_g_object_unref0 (board);
	output = (g_free (output), NULL);
}


static void seahorse_catalog_on_help_show (GtkAction* action, SeahorseCatalog* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	{
		gchar* document = NULL;
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup_printf ("help:%s", PACKAGE);
		document = _tmp0_;
		g_app_info_launch_default_for_uri (document, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (document);
			goto __catch4_g_error;
		}
		_g_free0 (document);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _ ("Could not display help: %s");
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		seahorse_util_show_error ((GtkWidget*) self, _tmp1_, _tmp3_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


SeahorseCatalog* seahorse_catalog_construct (GType object_type) {
	SeahorseCatalog * self = NULL;
	self = (SeahorseCatalog*) g_object_new (object_type, NULL);
	return self;
}


GtkWindow* seahorse_catalog_get_window (SeahorseCatalog* self) {
	GtkWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GtkWindow*) self;
	return result;
}


const gchar* seahorse_catalog_get_ui_name (SeahorseCatalog* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ui_name;
	result = _tmp0_;
	return result;
}


static void seahorse_catalog_set_ui_name (SeahorseCatalog* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_ui_name);
	self->priv->_ui_name = _tmp1_;
	g_object_notify ((GObject *) self, "ui-name");
}


static void seahorse_catalog_real_selection_changed (SeahorseCatalog* self) {
	gboolean can_properties = FALSE;
	gboolean can_delete = FALSE;
	gboolean can_export = FALSE;
	GList* objects = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkAction* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkAction* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GtkAction* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GtkAction* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GList* _tmp21_ = NULL;
	GList* _tmp24_ = NULL;
	GList* _tmp25_ = NULL;
	GList* _tmp26_ = NULL;
	can_properties = FALSE;
	can_delete = FALSE;
	can_export = FALSE;
	_tmp0_ = seahorse_catalog_get_selected_objects (self);
	objects = _tmp0_;
	_tmp1_ = objects;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = _tmp1_;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* object = NULL;
			object = (GObject*) object_it->data;
			{
				GObject* _tmp2_ = NULL;
				gboolean _tmp3_ = FALSE;
				GObject* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				GObject* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				_tmp2_ = object;
				_tmp3_ = seahorse_exportable_can_export (_tmp2_);
				if (_tmp3_) {
					can_export = TRUE;
				}
				_tmp4_ = object;
				_tmp5_ = seahorse_deletable_can_delete (_tmp4_);
				if (_tmp5_) {
					can_delete = TRUE;
				}
				_tmp6_ = object;
				_tmp7_ = seahorse_viewable_can_view (_tmp6_);
				if (_tmp7_) {
					can_properties = TRUE;
				}
				_tmp10_ = can_export;
				if (_tmp10_) {
					gboolean _tmp11_ = FALSE;
					_tmp11_ = can_delete;
					_tmp9_ = _tmp11_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					gboolean _tmp12_ = FALSE;
					_tmp12_ = can_properties;
					_tmp8_ = _tmp12_;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					break;
				}
			}
		}
	}
	_tmp13_ = self->priv->_properties_object;
	_tmp14_ = can_properties;
	gtk_action_set_sensitive (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->_edit_delete;
	_tmp16_ = can_delete;
	gtk_action_set_sensitive (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->_edit_copy;
	_tmp18_ = can_export;
	gtk_action_set_sensitive (_tmp17_, _tmp18_);
	_tmp19_ = self->priv->_file_export;
	_tmp20_ = can_export;
	gtk_action_set_sensitive (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->_selection_actions;
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
		group_collection = _tmp21_;
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			GtkActionGroup* _tmp22_ = NULL;
			GtkActionGroup* group = NULL;
			_tmp22_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
			group = _tmp22_;
			{
				GtkActionGroup* _tmp23_ = NULL;
				_tmp23_ = group;
				gtk_action_group_set_visible (_tmp23_, FALSE);
				_g_object_unref0 (group);
			}
		}
	}
	_tmp24_ = objects;
	_tmp25_ = seahorse_catalog_lookup_actions_for_objects (self, _tmp24_);
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
	self->priv->_selection_actions = _tmp25_;
	_tmp26_ = self->priv->_selection_actions;
	{
		GList* group_collection = NULL;
		GList* group_it = NULL;
		group_collection = _tmp26_;
		for (group_it = group_collection; group_it != NULL; group_it = group_it->next) {
			GtkActionGroup* _tmp27_ = NULL;
			GtkActionGroup* group = NULL;
			_tmp27_ = _g_object_ref0 ((GtkActionGroup*) group_it->data);
			group = _tmp27_;
			{
				GtkActionGroup* _tmp28_ = NULL;
				_tmp28_ = group;
				gtk_action_group_set_visible (_tmp28_, TRUE);
				_g_object_unref0 (group);
			}
		}
	}
	_g_list_free0 (objects);
}


static void _seahorse_catalog___lambda11_ (SeahorseCatalog* self, GtkWidget* widget) {
	const gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	GObject* holder = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_menu_bar_get_type ())) {
		name = "menu-placeholder";
	} else {
		GtkWidget* _tmp1_ = NULL;
		_tmp1_ = widget;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ())) {
			name = "toolbar-placeholder";
		} else {
			name = NULL;
		}
	}
	_tmp2_ = self->priv->_builder;
	_tmp3_ = name;
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	holder = _tmp5_;
	_tmp6_ = holder;
	if (_tmp6_ != NULL) {
		GObject* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		GtkWidget* _tmp9_ = NULL;
		_tmp7_ = holder;
		_tmp8_ = widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), _tmp8_);
		_tmp9_ = widget;
		gtk_widget_show (_tmp9_);
	} else {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = name;
		g_warning ("catalog.vala:68: no place holder found for: %s", _tmp10_);
	}
	_g_object_unref0 (holder);
}


static void __seahorse_catalog___lambda11__gtk_ui_manager_add_widget (GtkUIManager* _sender, GtkWidget* widget, gpointer self) {
	_seahorse_catalog___lambda11_ ((SeahorseCatalog*) self, widget);
}


static void _seahorse_catalog___lambda12_ (SeahorseCatalog* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	seahorse_action_pre_activate (_tmp0_, self, (GtkWindow*) self);
}


static void __seahorse_catalog___lambda12__gtk_ui_manager_pre_activate (GtkUIManager* _sender, GtkAction* action, gpointer self) {
	_seahorse_catalog___lambda12_ ((SeahorseCatalog*) self, action);
}


static void _seahorse_catalog___lambda13_ (SeahorseCatalog* self, GtkAction* action) {
	GtkAction* _tmp0_ = NULL;
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	seahorse_action_post_activate (_tmp0_);
}


static void __seahorse_catalog___lambda13__gtk_ui_manager_post_activate (GtkUIManager* _sender, GtkAction* action, gpointer self) {
	_seahorse_catalog___lambda13_ ((SeahorseCatalog*) self, action);
}


static GObject * seahorse_catalog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseCatalog * self;
	const gchar* _tmp0_ = NULL;
	GtkBuilder* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	GtkUIManager* _tmp5_ = NULL;
	GtkUIManager* _tmp6_ = NULL;
	GtkUIManager* _tmp7_ = NULL;
	GtkUIManager* _tmp8_ = NULL;
	gchar* key = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GSettings* _tmp12_ = NULL;
	gint width = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint height = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_ = 0;
	GtkUIManager* _tmp29_ = NULL;
	GtkAccelGroup* _tmp30_ = NULL;
	GtkActionGroup* actions = NULL;
	GtkActionGroup* _tmp31_ = NULL;
	GtkActionGroup* _tmp32_ = NULL;
	GtkActionGroup* _tmp33_ = NULL;
	GtkAction* action = NULL;
	GtkActionGroup* _tmp34_ = NULL;
	GtkAction* _tmp35_ = NULL;
	GtkAction* _tmp36_ = NULL;
	GtkAction* _tmp37_ = NULL;
	gboolean _tmp38_ = FALSE;
	GtkActionGroup* _tmp39_ = NULL;
	GtkAction* _tmp40_ = NULL;
	GtkAction* _tmp41_ = NULL;
	GtkActionGroup* _tmp42_ = NULL;
	GtkAction* _tmp43_ = NULL;
	GtkAction* _tmp44_ = NULL;
	GtkActionGroup* _tmp45_ = NULL;
	GtkAction* _tmp46_ = NULL;
	GtkAction* _tmp47_ = NULL;
	GtkActionGroup* _tmp48_ = NULL;
	GtkAction* _tmp49_ = NULL;
	GtkAction* _tmp50_ = NULL;
	GtkUIManager* _tmp51_ = NULL;
	GtkActionGroup* _tmp52_ = NULL;
	GtkApplication* _tmp53_ = NULL;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (seahorse_catalog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	_tmp0_ = self->priv->_ui_name;
	_tmp1_ = seahorse_util_load_built_contents ((GtkContainer*) self, _tmp0_);
	_g_object_unref0 (self->priv->_builder);
	self->priv->_builder = _tmp1_;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->_actions);
	self->priv->_actions = _tmp4_;
	_tmp5_ = gtk_ui_manager_new ();
	_g_object_unref0 (self->priv->_ui_manager);
	self->priv->_ui_manager = _tmp5_;
	_tmp6_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp6_, "add-widget", (GCallback) __seahorse_catalog___lambda11__gtk_ui_manager_add_widget, self, 0);
	_tmp7_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp7_, "pre-activate", (GCallback) __seahorse_catalog___lambda12__gtk_ui_manager_pre_activate, self, 0);
	_tmp8_ = self->priv->_ui_manager;
	g_signal_connect_object (_tmp8_, "post-activate", (GCallback) __seahorse_catalog___lambda13__gtk_ui_manager_post_activate, self, 0);
	_tmp9_ = self->priv->_ui_name;
	_tmp10_ = g_strdup_printf ("/apps/seahorse/windows/%s/", _tmp9_);
	key = _tmp10_;
	_tmp11_ = key;
	_tmp12_ = g_settings_new_with_path ("org.gnome.seahorse.window", _tmp11_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp12_;
	_tmp13_ = self->priv->_settings;
	_tmp14_ = g_settings_get_int (_tmp13_, "width");
	width = _tmp14_;
	_tmp15_ = self->priv->_settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "height");
	height = _tmp16_;
	_tmp18_ = width;
	if (_tmp18_ > 0) {
		gint _tmp19_ = 0;
		_tmp19_ = height;
		_tmp17_ = _tmp19_ > 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp20_ = width;
		_tmp21_ = height;
		gtk_window_resize ((GtkWindow*) self, _tmp20_, _tmp21_);
	}
	{
		gchar* path = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		GtkUIManager* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp22_ = self->priv->_ui_name;
		_tmp23_ = g_strdup_printf ("/org/gnome/Seahorse/seahorse-%s.ui", _tmp22_);
		path = _tmp23_;
		_tmp24_ = self->priv->_ui_manager;
		_tmp25_ = path;
		gtk_ui_manager_add_ui_from_resource (_tmp24_, _tmp25_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (path);
			goto __catch5_g_error;
		}
		_g_free0 (path);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = self->priv->_ui_name;
		_tmp27_ = err;
		_tmp28_ = _tmp27_->message;
		g_warning ("catalog.vala:93: couldn't load ui description for '%s': %s", _tmp26_, _tmp28_);
		_g_error_free0 (err);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp29_ = self->priv->_ui_manager;
	_tmp30_ = gtk_ui_manager_get_accel_group (_tmp29_);
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp30_);
	_tmp31_ = gtk_action_group_new ("main");
	actions = _tmp31_;
	_tmp32_ = actions;
	gtk_action_group_set_translation_domain (_tmp32_, GETTEXT_PACKAGE);
	_tmp33_ = actions;
	gtk_action_group_add_actions (_tmp33_, SEAHORSE_CATALOG_UI_ENTRIES, G_N_ELEMENTS (SEAHORSE_CATALOG_UI_ENTRIES), self);
	_tmp34_ = actions;
	_tmp35_ = gtk_action_group_get_action (_tmp34_, "app-preferences");
	_tmp36_ = _g_object_ref0 (_tmp35_);
	action = _tmp36_;
	_tmp37_ = action;
	_tmp38_ = seahorse_prefs_available ();
	gtk_action_set_visible (_tmp37_, _tmp38_);
	_tmp39_ = actions;
	_tmp40_ = gtk_action_group_get_action (_tmp39_, "edit-delete");
	_tmp41_ = _g_object_ref0 (_tmp40_);
	_g_object_unref0 (self->priv->_edit_delete);
	self->priv->_edit_delete = _tmp41_;
	_tmp42_ = actions;
	_tmp43_ = gtk_action_group_get_action (_tmp42_, "properties-object");
	_tmp44_ = _g_object_ref0 (_tmp43_);
	_g_object_unref0 (self->priv->_properties_object);
	self->priv->_properties_object = _tmp44_;
	_tmp45_ = actions;
	_tmp46_ = gtk_action_group_get_action (_tmp45_, "edit-export-clipboard");
	_tmp47_ = _g_object_ref0 (_tmp46_);
	_g_object_unref0 (self->priv->_edit_copy);
	self->priv->_edit_copy = _tmp47_;
	_tmp48_ = actions;
	_tmp49_ = gtk_action_group_get_action (_tmp48_, "file-export");
	_tmp50_ = _g_object_ref0 (_tmp49_);
	_g_object_unref0 (self->priv->_file_export);
	self->priv->_file_export = _tmp50_;
	_tmp51_ = self->priv->_ui_manager;
	_tmp52_ = actions;
	gtk_ui_manager_insert_action_group (_tmp51_, _tmp52_, 0);
	_tmp53_ = seahorse_application_get ();
	gtk_application_add_window (_tmp53_, (GtkWindow*) self);
	_g_object_unref0 (action);
	_g_object_unref0 (actions);
	_g_free0 (key);
	return obj;
}


static void seahorse_catalog_class_init (SeahorseCatalogClass * klass) {
	seahorse_catalog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SeahorseCatalogPrivate));
	((SeahorseCatalogClass *) klass)->get_backends = seahorse_catalog_real_get_backends;
	((SeahorseCatalogClass *) klass)->get_focused_place = seahorse_catalog_real_get_focused_place;
	((SeahorseCatalogClass *) klass)->get_selected_objects = seahorse_catalog_real_get_selected_objects;
	((GObjectClass *) klass)->dispose = seahorse_catalog_real_dispose;
	((SeahorseCatalogClass *) klass)->selection_changed = seahorse_catalog_real_selection_changed;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_catalog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_catalog_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_catalog_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_catalog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_WINDOW, g_param_spec_object ("window", "window", "window", gtk_window_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_CATALOG_UI_NAME, g_param_spec_string ("ui-name", "ui-name", "ui-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("selection_changed", SEAHORSE_TYPE_CATALOG, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (SeahorseCatalogClass, selection_changed), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void seahorse_catalog_instance_init (SeahorseCatalog * self) {
	self->priv = SEAHORSE_CATALOG_GET_PRIVATE (self);
}


static void seahorse_catalog_finalize (GObject* obj) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	_g_free0 (self->priv->_ui_name);
	_g_object_unref0 (self->priv->_builder);
	_g_object_unref0 (self->priv->_ui_manager);
	_g_hash_table_unref0 (self->priv->_actions);
	_g_object_unref0 (self->priv->_edit_delete);
	_g_object_unref0 (self->priv->_properties_object);
	_g_object_unref0 (self->priv->_file_export);
	_g_object_unref0 (self->priv->_edit_copy);
	__g_list_free__g_object_unref0_0 (self->priv->_selection_actions);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (seahorse_catalog_parent_class)->finalize (obj);
}


GType seahorse_catalog_get_type (void) {
	static volatile gsize seahorse_catalog_type_id__volatile = 0;
	if (g_once_init_enter (&seahorse_catalog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SeahorseCatalogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_catalog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseCatalog), 0, (GInstanceInitFunc) seahorse_catalog_instance_init, NULL };
		GType seahorse_catalog_type_id;
		seahorse_catalog_type_id = g_type_register_static (gtk_window_get_type (), "SeahorseCatalog", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&seahorse_catalog_type_id__volatile, seahorse_catalog_type_id);
	}
	return seahorse_catalog_type_id__volatile;
}


static void _vala_seahorse_catalog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	switch (property_id) {
		case SEAHORSE_CATALOG_WINDOW:
		g_value_set_object (value, seahorse_catalog_get_window (self));
		break;
		case SEAHORSE_CATALOG_UI_NAME:
		g_value_set_string (value, seahorse_catalog_get_ui_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_seahorse_catalog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SeahorseCatalog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_CATALOG, SeahorseCatalog);
	switch (property_id) {
		case SEAHORSE_CATALOG_UI_NAME:
		seahorse_catalog_set_ui_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



