//------------------------------------------------------------------------------
// GB_JITpackage.c: packaged GraphBLAS source code for the JIT
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2023, All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

#include "GB_JITpackage.h"

#ifdef NJIT
// JIT is disabled at compile time
int GB_JITpackage_nfiles = 0 ;
GB_JITpackage_index_struct GB_JITpackage_index [1] = {{0, 0, NULL, NULL}} ;
#else
int GB_JITpackage_nfiles = 217 ;

// ../Include/GraphBLAS.h:
uint8_t GB_JITpackage_0 [56504] = {
 40,181, 47,253,160,170,243,  8,  0,132,208,  0,122,184, 76, 33, 45,176,174,172,
 27,186,140,104,187,228, 76, 62,247,248, 41,106,132, 27,156, 41,209, 37,224,236,
112,143,255, 15,172,106,159, 41,129,174, 84, 58,222, 74,242,131,254,131,253,141,
 93,  9,230,  1, 24,  2, 24,  2,158, 49,221, 78,111,174, 90,202,182,178, 87,225,
 45,221,126,154,149, 31,219,249,118,122,131,210,249,145,212,178,140,125, 95,210,
207,118,255,105, 88,201,150,210, 45,127,152, 35, 79, 45,199, 11,125, 67,131,244,
200,117,134,206, 91,163,199,143,179, 60, 54,213,238,132,127,181,166,192,177, 92,
 39,196,165,243,225,219,139,149,107,123, 38,247,255,111,159,110, 83,235, 14,198,
 23,134,122,239,173,107,209,187, 87, 38,  1, 97,240,253,184,113,100, 11,181,217,
117,220,122, 33,106, 59, 16,205,225, 26, 53,110,255,110,236,141,181,233, 93, 27,
 35,131, 64, 42,190, 48, 11,117,227, 87,203,237,221,105,254, 91,211, 34, 55,135,
175,173,124,255,243, 66,247,227, 48,108,202,153, 63, 61, 28,162, 52,106,179,118,
 90, 95,254,175,187, 63, 39,167, 43,103, 18, 12,  6,117,119,126,248,155,114, 98,
213,234,183,241,167, 55,166,152,167,150, 31,213,234, 12,192, 86,243,254,175,206,
120,171,213,184,233,220,248,103,167,153, 94,243,186,187, 53,114, 77,187, 90,150,
253,145,195,239,117,119,186,229,234,188,177, 93,227, 13,183,159,246,162,111,220,
158,249,223,222,161,223,230,253,177, 29, 57, 61,214,185,251,221,218, 52,122,230,
 87,161,185, 61,106, 19,126,107, 33,173,182, 22, 41,200,104, 47,203,158,180,211,
137, 92,187,115,192, 60,125,119, 66,183, 70,126,183,161,219,211,163,135,101,223,
233, 77, 90, 63,190,111, 61, 26,185, 58,255, 99,248, 92,157, 62,189,142,206,105,
142, 70,217,178,246,  5, 53,215, 24,189, 59,150, 65,211,111,244,248,111,127,119,
218,236, 62, 12,165, 71, 89,227,253,205,114,188,181,189,201,125,155,118, 60,171,
113,228,159,236,120, 76, 18, 16,221, 81, 28,241,158,219,188,181,229,  5,209, 95,
 91,155, 20,136,  7, 19,204, 36,219,227,253,157,225,191, 29, 55, 51, 76, 41,197,
144,128,196, 67,  2,226,  0,228, 33,193,146, 22, 49,252,233,137, 19,158, 40, 14,
117,215,122, 83,195,208,209, 92,220,208, 98,135,187,187,236,118,227,175,118,222,
 89,231,214,146, 35,221,196, 16, 17, 17, 14,137,233, 49, 33, 96,140,162, 72,186,
 78,116,140, 72,191,199, 14,214,119,126, 24, 71, 68,  4,215, 38,194, 30,233,167,
205, 27,201, 30,196,199, 84, 96,130, 60, 96,  1,  8,177, 88,149,235, 67,  4,166,
 58,167,105,146,  8,192,  7,148,136, 44, 76,100,195, 60,221,249, 28,249,251,125,
219,155, 23,130,139,188,161,117,167,121,115,188,175,218,207,117,106,221, 86,142,
 88, 40,200, 50, 77,243, 84,166,174,201,165, 97,201,178,170,210,176,100, 76,155,
255,163, 29,237,126,187,116,101, 15, 60,128, 37,201, 35, 41,138,164, 40,146,240,
184, 14, 85,139, 21,137,105,130, 53,141,251, 46, 62, 43,249, 70, 75, 55,  7,132,
177, 75,166,162, 42, 25, 70,101,100, 28,177,196, 50, 98,105, 66,143, 46, 30, 84,
  5, 38, 38, 21,124, 51,  9,  2,213,197,197,245, 41,184,155,157,149,  7, 22, 69,
246, 70,155, 78,190, 23,243,212, 77, 17, 88, 68,107,254, 89, 44,162,  3,122, 80,
 32,104,239,251,143, 14, 10,197,163,128,  1,200,131,130,130,  2,194, 17, 10, 10,
  9,  8,  4, 66,121, 64, 34,  7,178,204,114,185,176, 73,214,158,216, 89,201,205,
197,143,171,208,129,252, 41,183,249,160,168,238,148,164,219, 79,168, 55, 28, 17,
255,157,110, 47,253,226,243,212, 31,177,114, 10,121,244,235, 89,223, 24, 86,203,
213,165,161, 52, 24,165,146,163, 44,227,234,110, 33,255,199,202, 58, 29,196,138,
 53,153, 11,230,129,149, 81, 40, 19, 12, 11, 69,193,128,129,114, 97, 42,151, 42,
163, 88, 26,203,149, 69, 25, 75, 35,171,176, 74, 54,117,166,107,223, 18,190,156,
182, 90,143, 33,148, 36,  8, 96, 46, 50,108, 67,193,244,198,164, 20,218, 53, 19,
141, 28, 75, 61, 82,173,101,132, 66, 73, 46, 20, 12,111, 58,183, 41,171, 68,210,
191,233,167, 29,192,209,208, 77, 13, 32, 16,232,129,103, 36, 16,195,172,130, 17,
 49,179,  4,138, 38,136,106,107,247,231,118,236,190, 63,182, 99,248,180,171,247,
134,127,154,102,191,173,244,158,212,163,183,135,251,173, 86,231, 51,252, 88, 74,
109,107,113, 91, 32,153,153, 29, 18, 91,149, 75, 99,217,100, 50,205,197, 32,  3,
192,  2,  4,176, 20, 49,133,210,176, 66, 28, 32,  0,131, 88, 10, 65, 80, 36,161,
161, 42,239, 27,105,132,100, 88, 66, 81, 52, 84,197,139,181,157,243,120,235,164,
214,114, 56,147,202,234,222, 10,186,201, 78,121, 63, 65,136,195,178,221,249, 45,
  2, 56, 50,178, 12, 12,149,193,224,173,101,221,102,  0,105,187,235,223,253,182,
251,159,157, 30,234,143,238,177, 94,  7, 20,  6, 65, 72,198,118,122, 64,179,193,
116,218,196,117, 61, 43, 13,100, 84, 26,170,130, 93, 84,229, 50,121,203,249,108,
  1, 25, 57,237,217,231, 10,  2,147,203,126, 29,137,204,  5,147,201,182, 48,105,
228,218, 15, 33, 16,108, 49,177, 34, 92, 20,202,114, 89, 54,255,197, 14,212, 20,
  8, 30,  7,216,  2,219, 80, 25, 15, 44, 71,127, 75, 20,224,140, 40,  8, 97, 11,
182, 54, 89,164, 70, 72,105,127,224,131, 45, 24,195,172,170,218, 96, 23, 28, 30,
 89, 83, 89, 12, 36,151, 12,130,  6, 83,177, 38,150,230, 98,177, 64,211,132,167,
227,217,235,113, 53,118,149,231,189,175,118, 72, 78, 73, 96,130,220,239,201,237,
214,227,237,123,254,248,217,110,148,254,221,118, 26,167,117,151,238,157, 93,173,
247, 86, 33, 65, 24,130,165,199,  4, 39, 72,  0,137, 88,138, 34,201, 99, 98,130,
  4,100,128,219,217, 31,141,158,251,205,249,  3,107, 98,169,224,207,237,213,126,
122, 83,194,201,213,251, 40,127,172, 71, 64,176, 66, 93, 24,195,235,205,161, 19,
 99,154,178,217,  1, 82,236,177,235,164,240,102,235,164,184,118,186,  1,135,188,
246,102, 80,113,144, 48, 79, 27,154,117, 47, 82,168, 45,225,106,132,192,212, 99,
197, 48,250,108,183, 21,118,232,183, 12,106,164,116, 86,180, 10,223,107, 53,236,
239,141, 21,237,163,159,132,235,148, 33, 10, 70, 96,197,255,211,243,238, 84,111,
143,229,186,167,229,217, 12, 39,150,171,  1, 67,176, 80,124,113, 77, 44,151,138,
 51, 23,198, 44, 42,147,161, 28,100,104, 46,  7, 16,187, 48, 74,194, 13, 18,176,
139,127, 78,217, 30, 63,119,179,119,186,115,241, 19,233, 55,173,155,136,143,224,
220, 78,113,250,124, 62, 85,194,141,204,177,204,159,133,208, 90,141,179, 78, 13,
212,161,232,241,103, 67, 92, 33, 53, 72,104,144, 16, 49,100,150, 22,102,177,170,
139,210, 80, 37, 76,161, 59,235,134, 43,  2, 40,254,  8,106,174, 90, 44,128,167,
169, 97,236, 93,221, 78, 79,152,167,255,136,136, 72,231,222,174, 74,104,104,208,
108, 46, 18,138,227,247,217,225,126,150, 19, 29,160, 99,210,128, 24,128,176,199,
 90, 36,152, 89,178,193, 30,150, 11,  1,103, 46, 12,168, 10,195,  9,  8,119,253,
 24,104,168, 73, 67,  3, 91, 21,202,146, 73, 18,133,178,121, 60, 30,144,  7,137,
243, 61,116, 91,167,  7,221, 82,136, 94,244,180, 61, 77,189,185,190, 28, 57, 98,
 97, 25, 10,131, 89,154,254, 93,237,243,251,247,211,245, 43,222,195,237,159, 70,
  0, 34, 81, 33,  8, 38, 87, 38, 69,124,160,129,101,147, 81, 77, 96, 19,202,202,
100,104, 44,255,182,115,145,180,231, 69,118, 89,122,228,135,236,  1,214,239, 99,
233, 87, 22,230,150, 37,191, 17,107, 48, 74,130,112,196, 17,188, 63,107,199,172,
204,213,122,219,154,171,149, 28,174,248, 80,252,208, 24,113,245,157, 16,180,222,
 22, 98,188,159,225, 61, 97,181,236, 77,237,117,251,176, 29,188,143,130,195,140,
145,175, 45, 43, 56,169,144,223,218, 13, 29,164, 73,177, 69, 68,115,153, 52,165,
247, 78,234,158, 72,134,229, 68,205,191, 14,  4,141,210, 90, 78, 99,162,104,108,
 45,118, 94,251,136,200,193,119,168,246, 67, 48, 98,185, 96, 26, 20, 70,132, 63,
181,150,223, 27,244,118, 31, 51,222, 19, 65,211,227, 72, 84, 49, 71, 32, 96, 30,
 80, 24,199, 27,229,182, 89,103,  8,250,125, 59, 79,252,159,182,245,116, 14,198,
231,246,126, 81,138,126,250,215,157,127,118,243, 64, 30,232,129, 30,200,171,147,
161,228,129,234, 91,237,236, 38, 22,136,146, 29,129, 92,142,211,163,193, 60,133,
226,199, 35,211,122,177,157,175,209,225, 79,136,143,247,125,110,154,  7,134,115,
163,108,111, 57,159,179,241,239,207,  8,117, 62, 96,  4,139, 89,241,215,216, 30,
 67, 44, 60,183,245,246, 67, 43,179,209, 84,155,140,  6,131, 13, 48,170, 18,161,
130, 31, 22, 85, 69,132, 41,105, 96, 21, 89,176,130, 74,130,170, 94,211,198, 71,
239,139,119,155, 92,113,133, 20,140,149,113,203, 26,202,134,186,176, 38,145,233,
237,244,196,174, 57,210, 78, 30,248,114,243,235, 55,213,207, 89,227, 54, 39,113,
183,111,220,206, 80,131,210,205,218,194,252,136, 37,230, 44,123,136,248,129,229,
180, 30,168,221,102,168,121, 12,146, 28,182, 70,157,143,175,199,251, 13, 85, 67,
 69,250,232, 99, 41, 54, 24,140, 12,114,117,114, 68,115, 65,101, 38, 92, 31,195,
114, 53,168, 46, 20,137,165,114,177, 70,143,173,236,206,221,154,118, 15,121,210,
 44,229, 48,127,222, 71,158, 66,118,107, 14,115,  5,219,205,145,193,225,136, 60,
  1, 13, 96, 19, 75,231,115,255,249,232,184,207,214,230, 80,116,143, 86, 69, 93,
213,117,113,177,193, 66,110,189,246, 36, 32,100, 46, 21,171,146, 93, 92,178,143,
173, 27,245,123, 84,151, 37,135,222,168,195, 57,130,150,132, 76,205,204, 72,146,
 20, 50,140,  1,147, 64, 16, 12, 16,143,148,141,136,115,121, 26, 63, 35, 49, 51,
113, 41, 40,  9,149, 24,133, 51,132, 17, 98,136, 33, 36, 34, 34, 34, 34,129, 72,
144, 36,205,  3,231, 64,131,236, 46, 18,137,131,103,109,220,186, 99,101,166, 98,
 80, 55, 48,160,129,242,  8,245,194, 30, 51,189,226, 40, 43, 67,172, 32,211,185,
 43,107,108,121,  2,230,144,124,114,  0, 28, 43, 48,243, 22,  4,133,188,251,141,
 68,213,  4,143, 24,129,155,225, 41, 52,243, 21, 86,103,247, 18, 60,226,131,174,
149, 57,254, 81,255,105,208, 13, 14,140, 11,168, 99,158,  5,124, 53,175,  5, 30,
252,195,225,203,  8,185,123, 48,145, 15,206, 16,204,113, 79,153,172, 68, 84,241,
 62,221, 37,132,175,184,207,198, 44,182,137,137,154,228,195,158,219,111, 57,139,
 22, 72, 66, 55,183,204,122,141,105, 48,241,167,166,100, 96,193,109, 88, 17,214,
 67,175, 27,239, 54,225,174,112,132,103,143,227,225, 75,248,254,228,191,196,163,
 16, 88,185, 96, 25,193,121, 49,138, 78, 81,  5, 33, 41,211,149,102, 28,242, 25,
 90,134,  5,103,198, 37, 51,255, 48,196,181,144,219,106, 45, 55, 79,185,229, 75,
 20,133, 31, 12,131,232,151,105,100, 34, 62,179,174, 11, 77,105,137, 24,  0, 74,
198,132, 96, 73, 36,  5, 49, 66, 56,174,235,204, 53, 45, 76, 89,131,214,176,252,
154,229, 79, 69,143,115,236,232,169,184,111, 77, 87,115,202, 21,141,220,154, 69,
235,124, 98,169,  9,221, 48,109,179,144,186, 13, 62,158, 19,127,189,132,146, 24,
  8,  0,148, 32,108,108, 51,195, 34, 64,235,153,  2,162, 32,155,247, 45, 12, 69,
163,137, 44, 56,119,219, 49, 82,239,207, 78,136,176, 51, 23, 87,182, 55, 73,116,
 23,146,209, 42,242, 71,148,  6,161,171, 95, 51,199, 83, 60, 47, 14,199,162,187,
138, 62,108, 47,191,190,182,231,  0,158, 92,245, 18, 56,165,197,178,220,236, 36,
244,179,103,163,204, 58, 53,203,165, 36, 17,158,190,131, 44,  4, 37,226, 64,142,
 21,222, 24,183,  2,215, 48,117,193, 55, 81,241,136,237, 88, 98,152,  0,239,138,
219,201,124, 10, 75,181, 26,221,181,  1, 78,231,170,148,  5,  5,165, 58, 69, 70,
  8, 49,132, 81,170,  1,232,115,136,242,164, 13,170,182,  5,105, 37, 98, 57, 87,
212,  8,140,207,149,169,174,207,251,230,225,221, 87, 83, 95,175,161,176,110,113,
 62, 43,149,140,  7, 87,193, 21,103,151, 37, 72, 58, 26, 70,253,150,187,  6,117,
 91, 54,168, 66,251,178, 19, 79,194, 62,173, 60,254, 23,150,135,245, 56,196,139,
 70,204,134, 83,186,107,241,255,130,161,  7, 32,103,242,203,231, 13, 74,130,111,
 17,229,214,254,125, 50, 23, 25, 35, 82, 19,149,224,119,211,209,244, 41,159,224,
 49,146,251, 95,152, 92,179, 40,134,127,124,187,151,120, 74,190,147,218,124, 77,
154,238, 45,227,150, 63,159,195, 39, 94,234,102,213, 38, 14, 86,168,170,240,251,
  7, 74,128,147,178,247,214,176, 38, 80,190,111,180, 88,239,179,210,171,213,147,
165, 52,114,192,154,230, 75,184,228, 10,102,206, 33,253,124,170,129,106,169,208,
 60, 74,  7,  3, 93,153, 93,151,219,161,139, 87, 32,203,223,160,184,203, 83, 44,
  5,241,116,118,193, 73, 89, 18,207, 53, 98, 62, 52,104, 95, 34,156,166,241, 18,
 13, 20,  0,203, 64,130, 37,190, 97,251, 90, 65, 70,200,193, 96, 97,229,173,149,
  9,173,132,133,232,214, 54,163,143,  7,124,  0,214,136,198,221,150,128,107, 80,
105,107,133, 82, 64, 62,171,135, 36,175,160,197,  9,218,255, 82,107, 80, 16,118,
113,173, 50, 49,113,204,156,  1,250,248,209, 19,146,153,170, 57,220,158,146, 62,
245,205,210,151, 21,164,169,  8, 48,252,182,184, 73,200, 89,184,133,132,114, 10,
156,231,204, 34,169,197, 51, 15,160,176,178,145,241,172,122, 12,  0,206,154, 68,
194, 10, 91, 90,212,240,147,178,223,124,137, 65, 29, 87, 86, 73, 27,204,130,212,
 26,248,204, 29,113, 64,140, 45,218,182,249,  9, 14, 52, 14, 81,122,112,230,  0,
 48,137,104,155,147,128,248,  2,153,181,228,134,214, 44,127, 17,156,120, 76,207,
128, 13, 81,  0,226,223,244, 49, 83,147,190, 23, 30, 88, 13,113,213, 10,252,230,
 12, 63, 29,  7, 85, 27,144, 97, 89, 77,189, 52,211,181, 76,246, 44,171, 27,196,
158,138,185,221, 83,157, 50, 11, 13,247,126, 97,211,210, 62,177, 77, 46,121,101,
104,115,148,138,215, 84, 41, 35,159,120,220,112,190,236, 37, 31, 81,194,226,254,
227,245,193,181,189,115,180, 51, 27,210,194, 49,198, 33, 74,173,  0, 86,158, 47,
  1, 96, 81,104,117, 46,147,193,153, 77,216,234,125,237, 65, 32, 66, 52,241,209,
174, 97, 83,230, 42,175, 36,140,192,242,197, 79,190, 63, 84,132,229,227,207,163,
242,121,135,134,175,192,121, 70, 68,195,  7,232,218,254,120,131,234,224, 65, 43,
231,181,  5,242, 93, 60,  1,161, 12,  6, 66, 29,  0,120, 54,207, 39, 30,215, 31,
 76,153,239, 49, 18,106, 52,117,189,226,131,205,157,103, 60, 31,101, 33, 13,204,
227,175, 11,101,148, 47, 27,180,156,227, 70, 95,166, 87,239,179, 93,249,192, 13,
 71,  3, 21,187, 46, 29,200, 49,169,255,182, 94,122,246, 72,147,214,192,126, 34,
 76,206,199, 56, 26,172,118,228, 93,140, 34, 40,  7, 14, 83, 35,153, 78,150,137,
 25, 13,144, 41, 38,142, 60, 35,220,172, 34, 93,112, 85, 21,129,150,192, 26,156,
 46,248,209,139, 90,115,135, 49, 87,175, 10,143, 97,  4,206, 80,222, 34,142,136,
140,160,151, 26,182, 54,133,  3, 14,226,111, 16,122,199,  8,208, 83,183,115,153,
242, 99,206,210,213,221, 14,254,167, 34,101, 64, 95,223,189, 19, 73,112,169, 67,
 53,194, 82,113,207, 88, 63, 37, 97, 99,242,216, 54,146,222,204, 22,237,117,  1,
180,219,212,127, 68,121, 12, 86,220,120, 31, 17,144,165,201, 89, 88, 38, 87,204,
 69,241, 17,120,120,100,205,182, 65,252, 97,254,214,157, 20,  7, 10,227,216, 72,
136, 95,114,238, 37, 75, 88,250,152,129, 10, 76,239,  8, 44,146,223,239,112,162,
  0,122, 54, 99,201,241, 65,163, 94, 42,135,188,115,229, 18,  6,117,108,179,187,
210,244, 18,175, 23,148,239,191,191, 81,249,  2,197,103,156,248,155, 71, 26,231,
184,136,138, 73, 97,135,  3,138,183,112,215,234,151,184,155,177, 64, 36,187,220,
198, 33, 63,168,225,223,255,223,164,198, 94,119, 96,209,206,114,155,113,228, 32,
109,127, 25,141, 40, 80,176,178, 29, 10,250,164,168,112,149,228,235, 47,241,230,
 85, 11, 27,172, 10, 99,144,  2,128,207,148,124, 49,106,128, 40, 62, 61,253,172,
152,136, 23, 19,144,101,184,126,161, 72,144,176, 59, 88, 56,107,106, 43,244,191,
200,188, 20,  9, 27,184,120,202,223,166, 67,250, 83,128, 39,243,112,210,198,138,
 88,241,114, 98,220,191, 62,115,242, 38, 65,160,166, 65,123,116,158,110,216, 99,
255,111, 54,198,225,178,246,106,166,240,168,112,154, 21, 91,156,  3,252, 84, 83,
173, 39, 41,145,  3,149,  2,188, 12,118,207, 61,117, 86,104,136,140,195, 36,255,
136, 16,238,236, 48, 66, 48,163, 33, 66, 16, 51, 10, 69, 90, 71,222, 11,139,179,
204,195,254,215,231,  1,115, 50,190,125, 87, 59,144, 49,118,245,125, 58,131,248,
 48,143,250,  9,111,106,237, 88, 50,192,141,132,178,199, 22,243,112, 43,185,116,
 82, 87,127,220,  2,  3, 72,197,148, 37,168, 64, 26, 71,248, 74,186,106, 10,164,
134,144,150, 64, 40,114, 86,149, 77,190,133, 23, 78,  6, 42,176,208, 47,196,131,
113, 12,133,210,135,103,181,222,155,178,  2,142,116,217, 93,165,  4,155, 26,191,
106,193, 30, 74, 49,237, 32, 20,179, 94,  0, 84,  7, 33,153,227,246,116,243, 50,
199,120, 99, 41, 96,122,221,  6,192, 97,171,216,187,205,213, 30, 64,226,242,234,
224,100, 50,121, 43,112, 56,132,220, 19, 53,189,214, 79, 53, 63, 58,155, 63,146,
 57,165, 84,227,213,145,128,223, 63, 16,234,185, 25, 81,241, 54,159,147,243,231,
 71, 19,  8,101, 69,199, 49, 91,151,  9,198,175,204,149,155,113, 86,248,239,255,
230,141,251,255, 84, 83,142, 26,139,240,196,  2,123,106,113,243,136, 85,156, 61,
129, 54,217,233,106, 64,250, 86, 10, 88, 31, 41,155,  6,133,179, 52, 86,198,124,
128,123,238,237,254, 65, 42,118,223, 67,130,129,225, 18, 77,142,  1,102,114,195,
168, 29,  9,135, 96,183,213, 73,248, 81, 84, 11, 28,153,136,167,  4, 72,207,155,
 64, 24,227,127, 19,191, 35,213,100, 79,155, 91, 55,241,159,240,166, 27, 11,113,
188, 34,250,  3,255, 92,203,219,122,116,201, 99, 19,129,143,112, 18,132,164, 44,
 33,  3, 39,153,  7,124, 60,226,250,166, 17,240,187, 13,250,177, 61,134,107, 33,
 99,182,138,248,132,221,  6,242,137,173,158,255, 14,252,213,255,252, 87,188,170,
 36,194,217, 18,124, 26,236, 98,  3,162,125, 52,133,121,112,  2,135,215,225,132,
200,147, 94, 26,  0,212,129,235,185,113, 84,163,167,108, 68,208,  2, 44, 89,200,
141,168, 34, 71,150,142,149,137,228,251,129, 92, 96,248, 10,  8,245,245,208, 36,
 41,235, 40,  5,116, 82,208,142,126,155,104, 15,111,204,224,186, 46,192,132, 54,
 47,251,206,  8, 18, 67, 40, 32,179, 55,200, 76, 47, 17, 32,  5,129, 26, 15,174,
203,179, 86,211,167,133, 10, 85,224,  7,179,242,189,103,131, 22,131,  1,175, 53,
 22,130,114, 11,130,250, 84,168, 86, 64,172, 75, 69,219,140,159,  5,176, 79,229,
 31,150, 10, 68,131,186, 70, 33, 85, 95,187, 48,  2,192, 59,169,212,241,224, 65,
106,211, 65,149,  6, 38, 94,255,126,209,249,175,241,135, 54,220,138,181, 24,204,
152,  8,  6, 56, 99,130,164,184,142,152, 25,186,107,151,248,164,220, 22, 59, 85,
101, 13,145,246,198,197, 46,254,103,229, 59,203,170,  0,254,184, 77,226, 39, 23,
244, 50,220,151,139, 16,220,186,229, 19,199, 64,217, 46,125, 16,238, 25,118,157,
 50, 46, 39,136,242,165,105, 59,196,178,  7,250,247, 16, 70, 96,166,188,105, 85,
103,223,192, 39,118, 55,105,216, 21,204,254,221, 70,212, 34,134,100, 87,156,120,
 60, 18,176, 55,250,159, 40, 18, 40,246, 79,234, 63, 92, 74,172,224,  0,211, 78,
 43,180,121,196,  5,  0, 18,115, 15,201,217,216,218,177, 98,234, 56,241,230,236,
194, 29,208, 12,  1,249,204,240,  6, 45,227,100,202, 93,195, 97, 26, 81,109,149,
119,209,202,112,187,226,133, 78,212,239,180, 49,172,228,123, 21, 46,  2, 74,121,
124, 68,190,100,207,213, 62,206,176,188,199, 34,189,158,105,223,153,231, 84,253,
 49,168, 20, 50,225, 27, 35, 40,153,146,219,164,148,170, 18, 16, 15,121, 71,253,
  1,152, 86,141,194,250, 33,145,142, 46,140, 29,136,249,218,234,228,113,136, 86,
 35,190,180, 50,206,159,  5,180,174,114, 45,192,211,233,112, 36, 62,107,248,130,
 65, 68, 39,103, 41,112,175,244,236,141,255,212, 39, 64,230,255, 36,252, 41,194,
 84,209, 57, 37,  2, 89,121,124,216, 23, 92,216, 78,115, 13,230,248,121,112,185,
  6, 92,106,138, 82,140,131, 43,107, 59,201,198,198,201,147,200, 93,191,252,114,
124, 24, 36,168,244, 39, 55,212, 73,234,130,159,100, 10,203, 58,206,215, 12, 26,
 86,223,194,134,184,242, 78,129,142, 44,253, 27,213,  8, 40, 92,167,117,117,111,
 58,219, 79,142,147,221, 32,235,237,140,124,185, 16, 30, 87, 96, 11, 82,145, 65,
  7,115, 27,120,114,119,132,247,199,148,  0,136,116, 20,  1,139,145,224,105, 34,
 71,168,150,184,202,228, 78,120,  8,162,196,186, 19,170,244, 70,243,  7, 71,206,
116,147, 84,223,135, 47,120,224,200,136,188, 35,196,207,  8,136, 13,162, 68,  1,
241, 22,238,240, 83,126, 99, 58, 24,181,197, 14,203,140,142,200, 50,192, 80,232,
214,171, 35, 74,117,204,238,145,249, 43, 83,239,218, 88,230,155, 88, 81, 35,136,
 38, 23,188,195,144,148,246,143,191,243, 95,143,160,110, 54, 80,254,196,189, 61,
192,158, 26,222,152, 80, 31, 43, 73,247, 76, 33, 58, 97,240, 66, 38,112, 37,136,
214,242, 72,186,204,139,176, 76,  2, 27,168,232,229,206,200,216,130,239,138, 43,
120, 72,153,226,143,212,155, 93, 85,172,168,176, 48, 73, 37, 18,187, 41,209,  9,
192,156, 55,243,176, 49, 49, 28, 43, 68,185,118,138,201, 24, 83, 76, 65, 35,206,
 55, 31, 68,213, 37, 62,100, 94,243,146,201, 71, 74,119,191,130,145, 99,206,186,
 85, 12, 44, 75,240, 78, 10, 48, 21,145, 82,210, 72,164, 65,205, 99, 56, 83,124,
113, 24,224,206,167, 18, 41,165, 67,224,  7,230, 10,231,  4, 24,167, 58,  5,182,
141,170, 52,208, 62, 99,106, 56, 66, 17, 65,190,205,196, 34,171, 27,142,  1,180,
  7, 33,230,188,167,179,241,228,170,136,225,158, 81,  5,232,109,226,188,199, 35,
 92,177, 26,165,112,171,129,216,194, 28, 18,165,217,154, 55, 88, 47, 77,191,225,
222, 18,167,155,161,196,154,148, 40, 13, 94, 26, 41,107,160, 28,184,106, 63, 93,
102, 42,132,129,181,108, 44, 19,218,158,112,204,138,234,186, 37, 54, 21,132, 38,
 11,233, 38,151,  4,  5, 21,144,152,122,141, 54,248, 85,197,140,248,136,  4, 78,
194,251, 45,132,157, 20,189, 46,128, 57,172,204,220,131,108,254, 22,  9, 20,206,
251, 48,109, 31, 66, 64, 63, 16, 64,238,114,121, 68, 65,242,  7, 59, 31, 27,123,
155, 11,182, 43, 25, 80, 52,221,195,146, 88, 61,121, 87,219,206, 77, 12,104, 58,
 30,105,208,144,229, 88,181, 94, 41,118,220, 56,168,163,122,105, 98,187,125, 83,
 56,205,251,172, 67,123,220,213,197, 27, 22,247, 96,223,182, 86,146, 29,189, 92,
 91,161,167,238, 51, 43,219,226,109, 88, 38,163,207, 53,  2, 70,235, 25,154, 63,
234, 27,204,238,232,137, 11, 94, 14,170,197,164, 25,219,248, 38, 32,161,206, 11,
 21,255,226, 72,135, 75,105,120,183, 77,224,236, 59,174, 59, 71, 46,181, 62,135,
 57,222,134,200,149, 70,169,122, 25,106,243, 88, 68,251,181,209, 85,119,240,117,
228, 37,113,226,138,116,195,166,185,226,  4,222, 89, 77,170,112, 14, 93,148,197,
245, 60,171,128,142,193, 24, 89, 29,222,180,  3,106, 43, 50,184,179, 85, 48, 59,
 84,223, 22,149,130, 96,252,152,209, 31, 86, 93,227,106,174,  3,158,193,190,246,
124,167,128,138, 91,129,123,109, 81, 66,190,110,226,218,145,107, 52,112,211, 16,
219, 58,116,112,125, 95,244,103,130,123, 33, 57,217,183,  2, 64,174, 77, 91, 19,
  0,182,102, 17,106, 57,133,252, 48, 23, 92,249,187,145, 21, 24,197,111,148,186,
197,141,  1,155,  8,141,202, 90, 74,130,226,228,136, 99,148, 27,161,  1,  2,248,
227,210,126,179,123,145, 49,210,111,212,195,251, 94, 47, 37,  9,102,146,235,146,
227,132, 31,173,181, 95,142,214, 57, 32,101,114,118, 51,152,130, 28,248, 40,206,
204,243,217,192,207, 79,236,208,143,235,145,110,165,158, 31, 93,237,125, 92, 33,
 79,115, 53,160, 35, 72,120,128,185,221,190, 63, 75,157, 10, 90, 24,123, 23, 43,
222, 21, 97,106,  4,171,167, 81,181, 66, 78,239,217,239,109, 76, 93,238,119, 15,
121,191, 96, 93,165, 61, 53,155, 79, 87, 42, 76, 94, 95, 58, 31,224,120,120,196,
189,108,  2, 10,139,183,190,  3, 84, 74, 33, 72, 63, 20,165,128,  0,154, 54,133,
 21, 26,177, 70,187, 35,210,124, 21, 17, 68,185,166,162, 93,173, 75, 13,158, 12,
123,143, 63,189, 97,195,156,147,189,130,  3,205, 69, 12,101,225, 37,134,225,207,
158,114,233, 76,190,218, 50, 23, 69,239, 35,252,101,206,128,110, 29,143,177, 90,
117,237,120,139, 83, 10,  1, 19,169,121, 25, 92,122, 51,233,125,124,198, 30,114,
142,184, 44,231,168, 58,235, 98, 26, 87,222,127,120,195,110,200, 71,182,169, 56,
 36, 43, 40,174,242, 17,207, 72,110,  8,187,241,157, 53,201, 83,108, 84,168, 39,
221,  4,  2, 84, 97,137,168, 61,  5, 31,133,125,190, 86,161, 34,152, 72, 25,211,
196,156,192,188,118, 42,132,  4, 89,155, 48,100,228, 21, 78,232, 14,120,184,102,
161,208, 25,  8, 85,126,105, 49, 55,241,123,149,207,228,215,120,155,161, 93, 73,
200, 88, 21,151,176, 28,176,152, 98, 44,163,136, 14,  2,212,220,108, 85, 40,191,
161,196,230,245,163,141,251,  3,215,199,135, 10, 74,237,192,192,214,248,197,211,
147, 86,  1, 66,228, 62, 57, 22, 29,166, 83,107,203,135, 31,138,  2,164, 50,109,
190, 95,  7,244, 90,158, 74,207, 85,189,232,  5,104,126,104,241, 69,227,133, 31,
184, 45,159, 57,168,189,  2,255, 89,251,182, 18,205,185, 85,134, 92,150, 95, 61,
  5, 74, 68,243,147,214,198, 94,174,239, 24,249,205,139, 81, 29,246,137,174,221,
 46,229,202, 45, 12, 65,167, 14,121,131, 91, 20,133,136, 10,120, 14,225,167, 59,
202, 58,140,148,151, 40,162,192,163, 77,179,  9,133,182,122,174,192,124,102,130,
251,  3,210,155,254,156,177,164, 61, 67,163,124,124,184,242,131, 48, 72, 13,108,
200,139,197, 77,206,154,235, 88,170,227,215, 87, 47,180,193,165,171,149,198,157,
157, 48, 39,123, 39,162,203,120, 91,154, 51, 36,217,235, 74,173,215,122, 32,199,
246, 59,  4, 17,  9, 96, 66, 97,167, 89, 70,151,202,133, 10,154, 88,185,152,239,
230, 62, 40,124,166,  8, 26, 98, 93,168,151, 72, 66, 23,169,155,255,211,120,228,
112, 95,205, 98,218, 13,232,198,217,192, 98, 79,190,123,189,222,213,175,144,249,
192,109,  3,120, 64, 31,125,229, 19, 58,119,204,229,193, 93,217, 21,220, 27,192,
 68, 98, 75,222, 84,222, 90, 61,250,124, 85, 60,207,209,190, 82, 17, 90,127,195,
 63,244,132,165,244,135,  2, 46,  6, 23,245, 61, 16, 64,143,179,151,225, 62,154,
 45,191,218,  8, 55,198,120,232,180,204,231,121,119,118,131, 59,202,170,  5,192,
  0,218,249,209,134,130, 94, 72, 86, 16,238, 13,155,176,200,224, 87,200,176, 27,
 28,109,124,  6,192,116,232,254,  3,137,140,221,144, 35, 49, 94,210,225, 89,178,
223, 83, 81, 32,131,  7, 95,220,235, 60,  2, 17, 76, 52, 69,143,213,128,253,124,
 76, 72,223,145,254, 84, 37,136,251, 85, 35,230,148,198,212, 62, 17,238,202,203,
215,116,190,  8, 68, 48,196, 92,132,254,189,163,142,248, 49,142, 29,110,145,204,
234, 11,  6, 24,  0, 29, 17,115,210, 67,  2, 72, 61, 78, 72,174, 86, 69,178, 22,
 20,240,135, 21,223,146,109,126,196,104,  6,236,101,  6,148,148,124, 72, 16, 18,
210, 51, 62,227,205, 65, 82,241,239,193, 29,204, 44,192,214,208, 10, 16,221,236,
 73,179, 65,131, 47, 26,101,248,248, 12, 98,163,145,221,190,185, 78,187,210, 53,
173,  8, 97, 12,122,218,206,153,239,115,189,  7, 35, 65, 61,125, 36,126,238,134,
 72,148, 20, 63,227, 47,133, 95, 56, 10,246, 86,144,145,240,100,195,131, 82, 29,
  9,174, 90,212, 18,243,156, 60,177, 39,244,215,163,183,158,140,224,105, 51, 71,
 95,147,213,  3,106,206,122,203, 56,123, 39,221,115,135,115, 30,224,223, 95,230,
155,246,152, 61,241, 90, 30,224, 78,245,184, 79, 89,172, 15,211,  5,120, 13,218,
141, 84, 88, 52,212,153,254, 53, 73,141, 29, 59, 27,113,147, 89,237,223, 14,  3,
 97,188, 99,  8, 72, 32,103,243,167,115,104,160,112, 34,105, 28,103,  7, 42,194,
 29,107,103,150, 37,162, 75, 26, 66,157,120,232, 35,115, 31, 53,198,178,250,108,
 48,203, 88,190, 84,145, 17,101,130, 85,247, 29, 41,230,  9, 22, 79,100,177, 21,
 73, 60,112, 43,118,210,194, 21,154,  8,218,103,155, 42, 12, 24,131,204, 74, 21,
 53,243, 93,  9,224,181, 80,219,130,217,196, 28, 94,135, 40,236,110,164, 87, 83,
 23,106,213, 77,143,122,102,254, 70, 27,178,104, 80,172,254,191,138, 69,154, 34,
201, 23, 91,241,232,  9,  1, 44, 28, 14,173,207,238,251,207,  0, 74,249,117, 11,
198, 72,214, 52, 48,154,254,190, 34, 13,181,130, 11, 32,132,205,180, 85,240,150,
 45,  6, 68,  4,105,111,  0,159, 60,223, 52,196,170,137,211,214,116, 73,105, 12,
102,146,244, 27, 70,  4,245, 19,218, 14,235,172,173, 40,248,212, 72, 69, 26,224,
136,157, 73, 20,  2, 83,100, 33,193, 60, 67,233,  9, 18,107,179,137,177,152,180,
225, 85,140, 20,  7,204, 96, 89,161,135, 65, 18,116,154,240, 62, 87, 30,115, 65,
199,222, 89, 10,215,153, 10,132,204, 42,219,196,129, 37, 54, 72,225,  1, 46,169,
212,242,184,247, 31, 41, 31,104, 60,137,168,113,  9, 46, 30,193,219,110,163,146,
162,185,138, 54, 58, 87,201, 30, 36, 58,  2,166,142,224, 75, 86, 28,214,185,146,
133,126,196, 86, 36,102,254, 23,238,114,201,237,252,200, 82,145,180,151,175,249,
232,234,153, 40,225,159, 90,177,178, 27,205,195, 25,103, 49, 66,114, 81,243, 77,
148,114,184,184,169,189,238,177,165, 94, 81,135,130, 96,254, 57,160,202,206, 87,
 26, 13,160, 27,100,143,  0,198,180,164, 40,208,206,204,  3,200,  4,  1,156, 94,
173,164,204,193, 47,109,144,152,219,117, 27, 76,167,223,198, 11,163, 66,165, 87,
141, 55,105, 14, 93, 70,169,135,163, 84, 76,151,  0,153,  0,150,  0,243,167,231,
 63,122,235,165, 25,113, 22,142, 94,100, 42,149, 63,251, 79,254,159,105,101,232,
165,114,246,201,103, 40,202,117, 12,235,196,132,236, 72, 42, 73,181, 61,  8,  8,
221,107, 52,205,194, 70, 18,127, 86, 29,123,151,241,  5,237, 91, 67,171,181, 20,
189, 56,138,117,239, 43, 99,171,250,124, 52, 28,107,166, 19,140,195, 30,219,111,
 24,199, 61, 48,236,241,152, 85,231,193, 56, 11,245,255,213,  3, 88, 28, 58, 85,
204,143, 72, 56, 23,136,193,191,158,244, 60,129, 64,246, 43,221, 85,135,159, 59,
 77, 95, 73, 11, 58, 98, 15,230,241, 55,100,251, 15,233, 19,253,  1, 53, 17,249,
200, 15,238, 35,167,154,154,145,125,146, 89, 52, 30, 44,254,190,164, 14,  7,195,
209,127, 55,244,169,141,198,108, 52,230, 64,196,208, 55, 23,219,155,235,166,164,
 69, 23, 63,227, 39, 47, 17,137,120,142,177,173, 71, 65, 12, 34, 84,247,168,200,
 68,144, 60,229, 35,  4,145, 73, 82, 77, 74,213,221,104, 80, 74, 69,137,222, 77,
133, 33,121,167,206,117,127, 52,211,137, 15,  1, 82, 77,108,208,173,225,115, 42,
 70,253, 82, 61,231,148,200,104,127, 92, 64,226, 17,111, 60,223, 59,215, 11,235,
 33,227,223,246, 87,179,253, 72,209, 83,254,243,128,120,138,190,178,109, 28,221,
171,121, 95,237,145,250,130,234,215,218,226, 29,122,244, 45, 78,194,180,167,244,
  1, 89,230,210,173,241,119, 45,132,131,209,186,141,129,123,200,239,108,161,165,
 72,244, 82,212,177,118,136,190,166,216,218,242,128, 75,107,136,113,197, 17,194,
 97,181, 33, 87,177,100, 90,213, 54,180,173,183,201, 16,255,215,139, 69,114,227,
235,105,143,  2,112,172,211, 50,205, 53, 33,186, 76,151, 89, 18, 64,245,126,213,
 86,180,125, 91,233,241,148,128,231,209,  7, 20, 84, 20, 47,185,  5, 65,178,211,
250,242,148,119, 76,211,116,171, 72,130,232,215,195,122, 49,234,154,121,201,103,
  9, 90, 23,  4, 74, 60,  2, 41,229,147,111,141, 90,207,244,118, 42,149,241,228,
144,230,214,180, 62,190,210,156,255,185, 56, 13,153,132, 94, 48,241, 78,241, 78,
224,160, 89,184,142,219, 50, 79, 39, 53, 87, 58,207,150,185, 56,145, 65,165,191,
  2, 44,214,132, 62,123,159,214,179, 21,206, 57,231,188, 28,241,220,128,124,150,
 19,140,248,243,114,150,115,122,233,187, 47, 77,209,192,192,165,102,127,233,  5,
175,213,118,187, 48,215, 38,115, 89,182, 76, 65, 84,180,214, 66,166, 81, 88, 30,
 54,135,136,231,190,245, 98,170,181,221,151,138, 53,131,149,157,189,203,214, 93,
155,205,133,209,128,121, 83, 81,164,160, 48, 83,206,163,170, 54,144,241, 81, 85,
 34,  4,203,182, 77,211, 52, 23, 77,198,130,125, 55,227,208,214,111,211,201, 48,
 10, 19, 87,118,117,156,134,  5,135,223,168,211,156,177,162, 77,146,230,179,  3,
 17, 12, 48, 10,203, 99,114, 49, 11,115,241,  3, 83,128,146, 80, 29, 34,  5,203,
 81, 16, 48, 33, 18, 33,140, 24,194,  8, 33,132,136,  4, 34, 66, 34, 82, 18,169,
  3,247, 14,179,210,244,144,142, 74,136,207,136, 84,173,252,144, 67,237,166,197,
 21,182, 82,206, 32, 13,110, 29,153,105, 67, 83, 53,225,176, 68,109, 40, 49, 48,
163,213,210,104,188, 84, 17,195, 17,105, 75,122,205, 28,118, 49,242,124,212, 10,
 59,241,210,118,196, 84,234, 21,147,248,105,220, 99,132, 44, 48, 80,121, 10,158,
180,148,123, 47,244,243,  5, 52, 44,211, 13, 75, 27, 36, 76,233, 97, 97, 68, 57,
137,134, 17,136, 46,214,132,216,166, 25,126,178, 33, 85, 62, 73,204,152,199,  8,
221,  6,151,101,105, 28, 77,100,148,125,198, 82, 69,  3, 18,221, 80,228, 73,183,
 33,108, 69, 38,110, 84, 20,133,190,137,188,166, 30,109,236, 35,162, 81, 15, 26,
  4, 47,173,226, 87,181, 99, 54, 75,182,242,128, 42,163, 65,141,113, 50,162, 48,
163,221,221,251, 93, 53,230,215, 64,223,111,195,189, 67,130,247,110,211, 29,132,
113,244,180,198,184,237, 20,228,185,103,196,220,153,113,  4,225,226, 65,138,251,
 43,  0,141,214, 15, 89,243, 36,  1, 43, 72,250, 31, 23,155, 18,  1,204,248, 90,
196, 38, 27, 62, 13,248, 53, 99, 83,244,  5,112, 27,210,242, 71, 22, 85,250,177,
 71,219,205, 90,238,  7, 51,188,172, 29,161, 37,107,238, 55,250, 61,214,216,111,
139, 81, 14, 24,234, 85,163, 59,249,177, 49,232, 32, 63, 91,217, 64,174,140,169,
139,170, 34,108,108, 66,185,254,193,175,161,227,107,163,187,174,234,189,166,120,
  8,205,183, 71, 94,147, 21, 26,228,107,119,  8,181,  0,249, 26,226,214,226,109,
173,174, 75,100,174, 99,131,186,  6, 91, 94,238, 60, 10, 97,196,163, 57,130,201,
 73,206, 46,132,249,194,203,161,163,114,221,140,108,235, 89,183, 52,128,124,240,
 95, 51,247, 91,126,  3,203,177,  7,117, 52,  2, 24,  8, 35, 11, 44,108, 74,245,
 70,242, 65,239, 16, 46, 68, 20,193,141,238,176,158, 26, 86, 71,113, 58,250, 80,
243, 63,122, 19, 95,221, 13,155,124, 80, 23,144,100, 56,158,133, 56, 74,  6, 30,
107,149,130, 12, 33,145,204, 50,162,250,110,215,123,215, 46,245, 31,228, 76,167,
112,251, 59,252,136, 62, 60, 20,163, 85, 68,207,123, 87, 11,117,106,123, 64,124,
116,220,180,242,145,  3,245,145,126,222,114,216, 70,237, 55,126, 13,138,134,221,
159,149,100,209,236,188, 26, 58, 97,242,107, 59,202,200, 51, 52, 22,  8, 48,158,
 26,141,153,208,145, 23, 81, 12, 81,239, 88,106,  4,205,196,178, 52,138, 17,156,
243, 77,184,144, 94,101, 23,173,105, 96, 94, 14, 42,149,234, 34,242,141,100,129,
  2,210,105,102, 19,236, 33, 53,165,208, 67, 10,174,215, 13, 85, 57,200,235, 62,
154, 22,  6,235,232,140, 51,  1, 31,146,186,241,193, 22, 54,197, 54,233, 29, 54,
 49,247,168,153,158, 70,205,134,133,205, 50,102,252,207, 24,155,198,104,213, 37,
228,244, 89,200,115,220, 92,104,186,160,175, 24, 33,233, 84,  7,148,252, 52, 47,
 26,209, 49,101,228, 28,162, 43,197,153, 53, 26,103,190, 83,238, 52, 61,228,215,
139,235,107,178,190, 69,105,112, 53,208, 45,110,216,181, 29, 65, 75,198, 46, 14,
167,232,236,  1,208,230, 40,129,134,100, 85, 70,244,  8,241, 15,181, 80,136,152,
185, 70, 27,  7,155,224,220,221, 79,  9,140,244,212, 58,182, 25, 70,184,160,227,
 67,133,116,139,206,209,243,229,154,253,232,122,166, 80,130,162, 90,  3,125,168,
 53,197, 67,138,243, 19,255, 62, 42,197,123, 56, 89, 49, 81,247, 67,121,154,220,
148,196,  5, 57,158,  0,135, 17, 12, 59,138,  7,202,220,188,  2,225, 44,207,182,
202,237, 44, 88,167,134,221, 47, 10,174, 37, 31, 66,136,186, 54, 69,113,203,246,
204,191, 98, 94,203,178,167,122, 47,203,102,230, 51, 93,154,209,108,232,211,150,
144, 28,159,123, 13,127, 52, 23,227,150, 36,130,212,109,129,207, 31, 73,230, 48,
 22,170, 87, 42,155, 90, 56,249,199,185, 76,227,240,174,130,139,146,154,180, 25,
185, 45,156,221,116,227, 19,152,242,193,103,102,238, 77,203, 33,193, 80,187, 15,
144, 79,170,  6,228, 74, 94, 58,210, 64, 36, 18,145, 98, 84,172, 69,222,138,197,
118, 64,251,160,170, 48,208,141,104,115, 73, 33,214,212, 39,105,163, 20,119,218,
 82,140, 28,167,158, 39,215,169, 86,255,220,119,227,  4,148,105,166, 76,101,154,
 41,167,208,164,157,185, 82, 15,235, 56,  6, 20,226,210,168,132, 99,205, 73, 57,
229,  9, 64,130, 54, 29, 65, 51,254, 93,201, 99,136, 37,192,213, 30,234,160, 48,
  2,232,218,167,255, 13, 87,134,102,243,211,117,220,191,120, 28,128,247, 66, 90,
248, 26,250,218,194, 23, 99,223,178,159,200,  4, 47,249, 54, 48,229, 18,131,186,
122,141,125,217,102,161,121, 85, 74,120,108,148,164, 27,121,143,113,172, 51, 82,
155, 26,  5,126,150, 88,  8,220,102,207,171, 76, 95,126, 36, 15,179,120,101,  8,
238, 25, 62,169,145, 63, 50,163,236,137, 69, 46, 18,200,250, 20,128,245,192,202,
 74,176, 21, 29, 95, 33,  0,232, 49, 85,180, 75, 84,186,145,209,212, 51, 70, 48,
149,252,174,177,249, 65,  1, 85,194,166, 88,229, 80,148,160, 38, 28,126, 55,161,
105,  0,  0,164, 37, 64,185, 36,241, 62, 54,  7, 34, 75,209,  9,224, 19, 51, 13,
183,228,107, 66,225, 41, 19,  8,252,136,180,137,215,183, 61,120,171,202,160,174,
 16, 15, 58,179,179,140,246, 54,130,209, 34, 76, 59,131,112,104,168,163, 73, 95,
 38,134,146,218,235, 18, 36,242, 68,217,162,193, 34, 79,233, 32,126, 44,  1, 71,
 90,170,146,212,236,190,236, 23, 63, 62,228,147,149, 52,162,116,255,  8,204,227,
146,  5,153, 95,227,126,129, 70,204,247, 69,180,136,208,130, 71,196, 36, 35,205,
132,248, 64, 87, 53,188, 10,210,165,145, 49, 74,246,100, 69, 62,129, 98, 26,198,
137,235,136, 49,217,139,251,175, 72,233, 90, 53,163,187, 61,193,253,214, 32,195,
236,  1,164, 21, 11,125,207,244, 46,210, 88,139, 59,220, 75, 30,219,166,194,247,
149,130,223, 82,171, 50,198,216,246, 23,145,114, 39, 97, 89,221,147, 17,147,253,
188, 25,224,246,199,214,240,  8,215, 30,178,  4,249,243, 89,228,  3, 92,133,159,
135,178,168,150,143,196, 18,182, 40,205, 93,116,194,143, 73,149,  4,129,244,208,
215,170,119,138,100, 82, 75, 91,193, 56, 40, 57,148, 58,  8, 30, 19, 49, 71,238,
252,183, 33,164, 53, 84,101,101, 33, 26,173,181,223,231,125,137,120, 16, 63,123,
225,197, 65, 31,245, 81, 84, 27, 53, 73,240, 76,109,162,108, 47, 34, 10, 31, 18,
 15,249,121, 98, 37,109,200,220,  1, 34,231,130,219, 44,211,146, 90, 73, 85,151,
208,215,102,172,175,103, 49, 18, 88, 55,226,105,229,150,238, 67, 33, 71,231, 82,
226, 12, 81, 18,242, 89,226, 96,236, 91,195, 85,  9,223, 82, 61,  1,134, 80,228,
 99,135,132,190, 26,110,149,239, 77,120, 38,197, 30, 10, 64,179,175,167,200,170,
104,205, 61,159, 34,102,153, 27,255,247,174, 22, 53,242,225,231,183,230,113,253,
 60,221,208, 60, 73,190,171,255,113, 42,103, 64, 70,252, 51, 28, 86, 45,208, 93,
 76,140,174,228, 64, 36,203,217,182,190,142,226,  3,171,131, 32,102,154,150,138,
226,110,104,184,227,143,236,214, 51, 90,164, 50, 51, 78, 23,141, 12,157,241,163,
148,  1,161, 91,116, 25,244,203,216, 67, 59,161, 97,213,232, 63,  8,187,199, 80,
 75, 91,201,232,151,244,206, 37,212, 37,209,194,156, 78, 45, 52,154,116, 74, 25,
133,105,241,156, 72,198, 65,190, 94, 49, 26, 83, 73, 75,193,207,199,111, 34,192,
154,156, 19,226, 50,156,167, 87,210,177,  9, 41,126,200, 10,229,214, 73,233,214,
179, 52,153, 73,182,221,158, 24,219, 40,147,133, 54,218,144,169,229, 80, 51, 41,
165, 30, 71,241,226,253,143,214,214,167,  9, 67,248, 89,246, 44, 61,228, 32,204,
148,107, 81, 23, 95, 32, 29,186, 13, 65,  3,196,193,207,154,103,254, 97,145,222,
 43,133,125,179,180,238,253, 94,236, 44,162,149,140, 51,211,206,196,201,129,224,
 71,209, 42,233,224,251, 25,136,100,140,127,124, 86,164,198,185,195, 68,216, 92,
231, 57, 58,  7,126, 40,230, 34, 70,193,225,237, 55, 57, 69,190,204,  3, 66,184,
230,173,192,185,211,167,182,231, 28,217, 91,180,184,224, 81, 42, 55,196,107,157,
156,101,217,120,179,172, 24,133,110, 95,  7, 44,202,212, 88, 54,143,210,232,210,
248, 35,200,190,167,127,231,126,234,  2,159, 79, 58,244, 91,192, 39, 90,250,121,
 95,223,109,216, 23,133, 98, 82, 64, 53,216,127, 13,193,123, 20,117, 66,163,112,
198,140,175,145,216, 28,204,230, 41,105, 30,155,  3,  1,189, 68,174,152,218, 77,
173, 90, 70, 33,222, 71,146,238,127,119,174,157, 43,143,152,134,244,120, 16, 80,
 67,167, 62,133, 44,192,  2,252,254,236, 41,120,222,202, 64, 29,  9,156,205, 23,
122, 84,229,165,184, 21,138,201,121,248, 53,176,175,181,235,  8, 62,173, 88,218,
 91,194, 70,223,202,237,159,233, 69, 37,186,198,168, 58,160, 76,133,185,120,169,
 77,200,169, 68,203,117, 54,242, 30,  6,168,107, 78, 42,222,155,144,164,254,211,
217,163,175,123,240,100,  8,253, 82,254,114, 16, 49,168,137,173, 93,184, 73, 64,
 54,135, 87, 58,134, 38,230, 54, 32,107,116, 76,157,211,134,232, 85,237,121,229,
 24, 78,179,  0,137, 42,  1, 94,104, 82,224,154,105,  9,190, 81,183, 66,254,136,
248,  3,172, 25,  5,242, 56, 19, 59, 49,  4,172,103, 44, 78, 48,236, 65, 60, 52,
179,125,225,126,255, 95,251,  1, 10,131,213, 10,  8, 27,206,204,  8,232, 40, 96,
 73,238, 14, 64,179, 66, 88,254,136,141,188,160,  9, 25,194,100,155, 67, 75,233,
197, 28, 73,214,128,112,186, 76,121,186,215,137,135, 50, 43,132, 74,131,137,  1,
 58,147,175, 81,230,140,204,240, 97,158, 85, 71,247,  0,148,229, 14,237,147, 19,
  5,131, 58,114,149,211,243, 51,234, 37,156,153,127,  5,  3, 61, 67, 10,146,163,
105,234,160,229,139,255,  3,217, 26, 82, 58,159,152,215, 97, 25, 94,152, 87,111,
106,  9, 20, 79,205,150,198,  4,194,183,250,  0,249,  4, 31, 36,220,104,158, 26,
 46,235,178, 42,232, 82,198, 63, 98, 31,235, 36, 76, 28, 43, 37, 80, 95,150,240,
172,  4,226,  4,102,198,136,235,153,104, 64, 86,231,134,130,178,167, 88,168,240,
221,148, 98, 27,229,159,  1,110,202,235, 22, 51,209,190,102,149, 56,202,215, 49,
160, 82,222, 12, 41,121,200,153,135,196,237,222,162,174,139, 47,143,107, 32,116,
183, 66,129,  7,119,246, 35, 21,238, 40,129,128,160,158,173,229,166,170,234, 70,
 75, 32,152,227,185,179,121,112,186,225, 88, 11,251,216, 28,116,195,149, 64,131,
 72,132,182,246,197, 15, 90, 10, 90, 74, 74,171,243,255,168, 48,  7,168,250,122,
244,132,102,163,174,161, 36, 25, 32, 99,155,176,248,131,192, 61,223,178,234,220,
 96,247,202,232, 24,223,254,122, 44,221,  2,109,114,122,207,254, 13, 79, 24,223,
 99,216,203,138,133, 11,157, 33,135, 49, 10,192,193,239,196,197,245,233, 57, 87,
188,  6,  3, 29, 49, 86,183,106,236,238,180,221,130,107, 93, 40,253,120, 65, 76,
 39, 99,221,217,255,244,114, 31,250,189, 91,237, 92,176,109, 85,213,237,155,115,
170,184,192, 45,138,235, 57, 16,153,  9, 74,229,141, 86,  8,248,125,155,237, 87,
247, 99, 79,124, 68,193,  2,211, 67, 66,229,212,154, 70,102,209, 40, 45,246, 48,
218, 61,234,116, 54, 41, 49,122, 95,211,240,159, 74,233,246,122, 70, 79,  8,167,
192,177, 51,149, 51,122,119, 93, 68,199,  4,  2, 63,235,245, 52, 97,138,113,123,
 23,149,225,156,126,250, 86,103,229, 62,120,117, 55,238,125,161, 65,227, 88,218,
147,126,189, 54,112, 19, 43, 12, 61, 74,203,154,180,  9,208, 34,113, 56,240, 10,
221,  3,  2,165,102,224, 86,138,188,198, 18,107, 86,217, 58,  5,246, 12, 81,  9,
124, 91,172,155,248, 83,100,130,116, 24, 44, 43, 32,150, 49,135, 50,193,162, 38,
171, 23,126,231, 35, 25, 29,229,190,165,244, 17,160, 61,157,192,240,220,252,145,
198,154,  1,202, 95,152,205,205, 21,189,142,112, 46,109, 56, 21,232,116,255,249,
 48, 96,  4,219,205,171,249, 54, 39, 64, 43,169,253, 75, 55,194, 62,162, 25, 72,
187, 80, 45,243, 83, 58, 35,212,160, 91, 37,202, 19,116,181,121, 81, 34,121,110,
202,  4,255,174, 66,  6,104,133,191,106,166, 68,175, 43,188,157, 71,249, 48,195,
242,194, 30, 63,104,141, 52,176, 14,210,117,136, 53,  7,137,162,206, 38, 58,151,
136, 16,135, 48,129,220, 15,128, 53,132,168, 68, 70,253,103, 42, 10,209, 19,153,
213,207,169, 24, 68, 37, 50,194,222, 37,  2,209, 64,  9, 56,101,136,128,101, 34,
  3,137,169, 58,176, 24,244,130, 10, 68, 48, 64,168, 56, 96,228, 56,194,184,161,
197,117,188,247,134, 76, 18, 42,186,142, 47,109,152, 73, 66,197, 17, 99,171, 69,
184,161, 37,145,129,128,254,121, 33, 35, 13,232,151,137, 26,  5,151,220,111,255,
199,148,156,253, 55, 68,134,132,212,244, 47, 12,242,159,221,215,217,143,221,194,
183, 18, 92,  4,232,226, 76,190,229, 25, 27, 20,195, 62,102, 55,163, 63,102,175,
104, 72,151, 61,165,194,  4,148,134,142, 26, 97, 57, 37,188, 16,243,122,225,145,
120,176,204,201, 33,170,  0,203,113,  6,153,192,106,156, 98,177, 16,253, 36,148,
197,170, 67,108, 45,235,107,207,  9,145, 85, 29, 75, 21, 23,224,190,132, 84,165,
169, 52,205,  1,190,141, 72,229,252,229,  1,120, 87,192,169, 58,177,197, 38,250,
 80,177,189,254, 37,172,145,169,134, 18,117, 35,119,155,210,225,218,211,227,201,
192,231,180,188,146, 42, 63, 85,233, 64,154,248, 47,194, 47,148,207, 18,130, 55,
104, 54,238,253, 76,199,179,103,186,246,127, 21,249,185, 56,198,204, 10,145,119,
205, 61, 63,135,162,243,179, 70,164,109,144,123,222,215,137,133,248,148, 93,100,
 12,136,212,130,244,141,  2, 50,159,111,154, 84,192,129,202, 36, 93, 53, 12, 54,
 72, 10,219, 94, 59, 22, 53,135,117,126,226, 19, 49,111, 15,242,190,222, 94,121,
255,143,175, 82, 66, 46,176,126,188,140,229,149,147, 54,202, 73, 34,247, 11, 61,
160, 84,187,251,209,139,182,206,192, 76,134,147, 40,107,225,176,162,214,168, 76,
112,136,158,242,195,103, 67, 34,165, 90, 49,  2,141,242,164, 96,145, 83, 53,196,
145,142, 77,120,227,129, 76,234,179,179, 80,163,138, 52, 87,204, 74, 91,244, 54,
 23, 32, 76,136,158,234,225,123,157, 24,129, 82, 88,249,176, 60,132,218,123,135,
225, 17,144,111,192, 38, 16, 13, 32, 63, 51, 84,149,117,155, 55, 63,104, 40, 36,
 15,188, 15, 51,112,151,104, 73, 16,154, 71,246, 47,210,136, 29,211,116, 83,108,
 58,229,173,140,251,192, 47,144,100, 66,183,255,153,150, 56, 15,110,227,131,171,
  9,192, 81, 98, 36, 21,121, 48, 42,228,183, 16, 73,  4,120, 19,139,245,166,154,
254, 59,178, 66, 30, 25,255,102,196,130, 78,193,240,130, 38, 45,194, 13,134,100,
115, 53, 61, 59, 32, 46,133,163,  5, 99,200, 44,130,230, 32, 19,171,251,217, 38,
200, 68,207, 51,154, 83, 43,107,  1,112, 16, 90,  0, 39, 24,138, 64, 26,156,230,
195, 92,207, 68,109, 98, 97, 61,181,153,150,136,152, 88,175,108,230,111,154,247,
248, 12,204, 86,194,169,178,244, 54,227,115, 29,191,102,122, 73, 47, 24,200, 28,
213,124,118,135,143, 38,103,224, 25,214,199,  9,140,159,144,176, 48, 75,109,120,
 26, 14,167,151,162, 62,144, 26,236,185,230, 94, 72,100,114,157,114, 51,248,112,
240, 97,179, 68,245,193, 25,195,163, 24, 61, 67, 50,255,121,254, 28,199,  4,151,
241, 52,229, 17,206, 37, 61,  3,222, 12,101, 94,206,192, 28, 44, 31,148,112, 10,
 13, 37,185,160,  9,197, 34, 39,241,173, 83, 94, 49,112, 53,224,196,133,236,166,
  2, 41, 31, 27,246,136,156, 58, 65,175,112,138,  9, 99, 92,101,200,127,153,176,
131,143,222, 99, 43,112,198, 90,214, 27,226,240,118, 35,245,172, 47,165,111,244,
 23,241, 28, 10, 63, 69, 58,  7,219, 25, 82,200,222,226, 78,132, 11,146,129,168,
151,112,135,152,  1,168,133,160, 37,133,238,129,196,132, 22,195,159, 92,224,191,
 79, 24, 96,129,252,174, 19,237,191,239,130, 91,136,250, 24,128,235, 46, 45, 44,
118, 79, 15, 77,120,105,185, 61, 21,202, 29,125, 78, 35,104,  0,212,156, 14,234,
154, 23,195, 26, 16,254, 23,202,176, 12,213,170, 47,234, 43,  6, 83,216,196,116,
171, 75,211,111,250, 61, 90, 46,104, 58,118,162, 43, 86,212, 73, 38, 31,105, 42,
150,107, 41,130, 16,  6,142,169, 21,245,132, 85,202,180, 73, 46, 32, 66,122, 15,
148, 45, 93,121,243,193,120,172,135,152,122,133,183, 57,187,156,242,135, 36, 15,
192, 99,252,133,217,159, 34,111, 62,157,138,181,138, 56,254, 64,125,182, 63,225,
 77, 10, 59, 74,180,238, 28, 61,  6, 78,146,220,177,107,179,201,247,200,205,164,
210, 97,206,255,172, 88,196,142,202,216, 90, 34,154,195,148, 64, 34,139, 72,205,
102,111,164,123, 84,255, 67,236,171,116,231, 86,211, 90,214,104,  9,211,148, 96,
254,141,214,214,220,170,139, 99,231,111, 51,235, 97,213,245,170, 72,197,116, 70,
203, 71,159, 45,  2, 25,164, 75,197, 28, 72,109, 63,251,118,183, 53, 61, 41,163,
 83,172, 28, 26,  0,219, 82,  2, 42, 20,223, 66, 64, 59,173, 95, 46,104,169, 97,
 86, 13, 32,236,173,105,225,166,124, 90, 61,154,203, 68, 50,250, 29,123,  5,210,
 61,232, 66,194,233, 73,  8,107,130, 74, 42,222,134, 53, 90,105, 16, 29,214,159,
253,226, 10,192,196,243, 52, 64,178, 50,159, 88, 18, 10,152,209,  4, 76,166,130,
164, 23,221,157,  9, 25,106,228, 19,176,172, 13,207,112,100, 52, 90,115, 29, 36,
119,129, 90,254, 67,202,215,209, 96, 19,194,202,106,219,126,236, 29,  1,250, 74,
  0, 14, 40,192,210,209,  3,176, 86,175, 89,221, 15,178, 39,184,195,148,106,  9,
 67, 63,210,226,180,  7,128,185,238,222, 45,255,209, 11,251,227,233,119, 21,133,
 44, 10,184,217,  0,216,  0,217,  0, 27,149,  8, 28,  7,125, 73, 36,215, 74,168,
156,156,102,138,146, 48, 77,153,234, 79, 84,  5, 93, 56,151,204,196, 80,237,243,
194,228,135,208,106,242, 44,253,167,125,127, 51,107,237, 71,201,207, 99, 18,108,
 21,214, 14,136,183,211,222,254,212,190,158,182,245, 92,187,138,107,200, 47,167,
186,104,151,170, 71,167,213, 33,130,216, 68, 52, 80, 60,135,174,247,243,234, 11,
107,135,152, 39,208,227, 84, 59, 17, 44,231,  9,110,207, 84, 61,254,107,103, 16,
 39, 19,210, 52,152, 84,233,233,169,131, 25,225,160,124, 55,211,141,148,253,197,
231,129,211, 28,166, 91,234, 50,161,121, 38, 32, 68,158,207, 69, 68, 71, 55, 91,
167,138,118,219, 85,121,215, 19, 45,  4,121, 58,237,237,157,181,189,163,139,135,
 51, 48, 96,159,126,134,208,171,204,164,108,138,167,202, 86,149,198, 17,105, 28,
 44, 20, 90,174, 84, 48,253,212,196,186,187, 77,101,238,254,120, 84, 63,167,149,
237,196,  6, 25, 79,114, 14, 88,146,251,177, 68, 99,137, 25,122,237, 20, 90,203,
107,101,187,214,  1,181,103,172,145, 57, 28,207, 26,244,219, 69,154,118, 25, 49,
140,210,239, 76, 36,203, 50,195,147,122,189,121,214,242, 84, 41, 35,108,  0,159,
253, 23, 74, 82, 80, 56, 96, 56,144, 30, 59, 85, 93,117,102,  7,155, 76,218, 77,
118, 83,128, 25,200,206, 18, 20, 24, 90,211,180, 13,221,168,231,209,142,187,190,
174,234, 38,153,118, 74,137, 73,172,177,174, 78,142,166,154,158, 44, 77,109,131,
116,183,219,234,158,244, 84,181,247,178, 59,219,  3, 13,251,160,238,152, 13, 48,
236,130, 76, 77,245, 63,227, 97,  2,192, 84,100,197, 84,243,192,128,199, 13, 93,
242, 71,250, 84, 60,116,104, 26,218,249,118,237,207,230,190,237, 39,103, 89,118,
 83,  9, 81, 90, 98, 28,163, 80, 18, 82,214,141,148,244,163,114, 62, 62, 32,198,
138, 31,149,174, 20,108, 36, 34,  9,118,182,232, 87, 11,122, 29, 32, 36, 44,124,
237, 15, 14, 33, 52,176, 44, 14,214, 36,131,191,239,251,162,133,177, 87, 58, 58,
157, 30,152,118,220,173,165, 59, 97,177,104, 28, 68,156,  0,173, 83,  1, 59,163,
208,170,156,188,205,100, 65,206,176,126,147,233,  6, 84, 56,238,179, 84,124, 39,
 59,107,231,245, 87,148,251,105,214,109,130,202, 98, 46,168, 16,116,189,219,209,
149, 55,189,154,170,165,153, 59,231,235, 70,137, 36, 55,182,240,128, 52, 14,199,
147,193, 91,245,  8, 59,118, 70,117,183, 99,133, 43, 10,198,182, 98,117, 53,115,
123,109, 71,213,201,221,212, 45, 25,120, 94,228, 46,212, 68, 34,142, 38,210,  0,
184,  7,164, 97, 64, 64,120, 52,151,205, 67,133,115, 54, 32, 81,246,160,137, 46,
 25, 13,244,209, 30, 96,127,206, 57,231,156, 49,198, 56,211, 60,231,206, 86,172,
 24,186,186,164,217, 94, 53,133,116,223,135,182, 98, 48,157, 45,200,171, 61,155,
 16, 29,120,255,218,238,171,221,236,250,163, 84, 57,120,245,213,142,179, 12,221,
113,  5, 51, 88,160, 41,163,145, 57,177, 62,234,238, 26,108, 76, 93,233,141,145,
143,248, 38,227, 69, 15,187,126,138,246,215,218, 31, 90,173,176,175,106,103, 53,
131, 63,247, 88, 97, 72,123,132,112, 20,221, 67,224,200,107,151,193,223,104,227,
117, 28,165, 72, 42, 26, 71, 46,125,  3, 43, 29,210,157, 77,254,243,166,247,125,
191,174,124, 69,249, 66, 44,148,214,250,202,162,245, 63,239, 24, 66,136,191,141,
 58,198,255, 90,105,118, 30,166,254, 17, 71,236, 15,175,238,110,212,235, 46,199,
125,223,141, 33,206,224,254,240, 99,127,247,168,230,209,127,152,245, 11,208,211,
252,138,143,178,187,219, 24,180,104,245, 74,243,173, 59, 75,245, 39,233,167,123,
151, 81,126,126,189, 40,206,186,219,182,233, 86,168,251,218,213,127,122, 88,239,
 49,226,232,238,238,238,151,119,173,157, 48, 79,213, 70,103, 42,182,  7,143,190,
168, 20, 27,230,176, 54, 32,  8,  3,164,  0,  8, 28,137,  9,100, 34,105, 26, 73,
138,252,180,128,135, 67,155,  5, 17,  5,146,  5,162,128, 70, 16, 16,  0, 28,128,
  1, 36,128,  0, 12,  0, 24, 64,  1,  0,  1,  3, 20,  2, 76,179,  7,205,183,128,
238,186,160,126,116, 64,224,114,151,111,239, 10,184, 49,126,  6,238,165,134,204,
 96,234, 51,101, 22,204,148,171,202,151,145, 79,203,219, 11,239,230,200, 17,179,
169,  5, 50,248,229,102,195, 53,241,232, 74, 67,137,212,241,236,129, 91, 58,186,
161,187,234,132,245,176, 78,134,212,217,102,182,214,153, 40,215, 45, 72, 10,248,
 54, 46,213,217,118, 86,222, 35, 10,221, 12, 62,104, 26,201,189,237,110, 93,181,
 24, 12, 29,238,201,  7,195, 81,147,249, 21,202, 35, 77, 98,149, 90,217,206,172,
 60, 19, 19,223,170, 93,222,124,204,166,204,164,232,148, 97,235,197,218,100,208,
 17,185, 97, 50, 74,148,  1, 15,  3,206,118,193,201,238, 44, 12,230, 85, 92,114,
229,105,145,  0,122,204,157,208,187, 53, 77,124,193, 23, 61, 57, 11, 80, 90,112,
 92,148, 62,160,101,138, 24,252,193,104,228,163,113,105,145,207,149,183,207, 25,
228,191,  3,241,212, 27,230,132,180, 42,154, 29, 71, 25,235, 85, 42, 65, 59,221,
 31,204, 81, 73,158,203, 69,166,120,100,108,  4,126, 35,250, 52, 45, 26, 76,250,
 67, 92,147,250,229, 54,219,165,163,101, 99,229, 67,125,195,205,  9,199,108,100,
 51, 25,  2,  6, 24,200, 31,247, 23,188,238,202, 73,147, 33,199, 11,194,104, 21,
 84,  5,217,253, 53,140,203,171, 15,209,149,171, 35,209,117, 43,231, 45,138, 51,
236,146,230,197, 75,225,141,179,  1,170,194,185,183, 91,205,133,192, 83, 60,128,
222, 16, 77,192,238, 35,142, 67, 17, 88,174, 29,193,139,187,141,239,169,253,137,
133, 72, 89,125, 14, 75, 93, 29,158, 85, 73, 18,113, 88, 31,241,177,238,234, 98,
155,157, 69, 54, 35,200, 26, 20,143, 10,177, 72,178, 45,207, 63,199,139,154,253,
 36, 88, 18,251, 92,195, 92,118,250, 94,170, 50,215, 85, 78,241,126,149,  9,173,
 49,183,125, 81, 29,181, 73,209, 72,112,117,121,124,253, 86,236,227,120,251, 94,
232,219, 55,111,246, 84,194,210, 94, 41, 87,246,202,254,137,148,123,136, 68,141,
162,176,251,198,179,212, 38,152,147, 66,121, 10,  8, 20,236,139, 62,185,205,145,
 44,116,243,100,179,173,146, 75,209,180, 72, 42, 86,204,159,165,248,112, 32, 31,
 17,160,158, 40, 26,225,143,104,216,158,168,185,253,134,130, 79,156,195, 87,193,
115,161,153,183,247,137, 81, 39, 92,100, 75,153,221,125, 87,243, 52,211, 99,122,
247, 39,211, 97,241,137,137, 45,160,140,132, 53, 18,166,119,129,114, 21,150,228,
 47,213,  8,202, 86, 88,225,188,116, 55, 40, 43, 97,193,232,210, 61,161,188, 38,
235, 73,162, 69,161,168, 16,107, 77, 75,119, 13,229, 55, 44, 69,150,132,252,152,
143, 37, 60, 30,218,126, 10,232,161,190,227, 33,223,248,184, 29,210,186,111,207,
123,175, 60,247, 80, 80,120,173,233, 21,205, 20,115, 17,138, 96,200,172,139, 87,
152,175, 21,248,245, 10, 55,216,236,137,156,138,209,148,165,213,150, 50,242,171,
245,215, 93,160,190, 96, 59,242, 83,  1, 86,229, 10,156,128,  6, 70,141, 51,201,
 59,140, 36,184,204,131,226,218, 53,187, 84,139,224,155, 72, 62,122, 89, 20, 49,
 10,  1, 31,218,234,211,221,164,114, 19, 52, 30,189,203, 37, 45, 82,138,  8, 82,
162,111, 32,128,226, 71,175, 96, 56,168,248, 89,142,227,255,251,243, 82, 73, 82,
191,189,103, 26,153,251,123, 14,122,189,  2,227,171,118,121, 81,198, 19,120,208,
 97, 63,125,237, 51, 68, 12,223,195, 73,207,  7,209,  7, 94,  4,114,229,223,129,
 16, 11,196,116, 66,136, 34,205, 21, 32,135,249,109,130,148, 14, 10,198,105,214,
 52, 68, 10,239, 41,199,241, 39, 21, 49, 64, 70,151,248,139,188,  6, 18,134, 23,
158,210, 85,157, 47,168,  2,136,197,138, 50,102,136, 84, 28, 22, 18, 68,  3,  9,
115,105,240, 57,192,155, 70, 10,128, 12,187,  1,131,224,182, 15,135,191,170,218,
164,230, 68, 10, 53,121, 56, 82, 74,146, 11, 83, 60,252,188,168, 20, 25,109,216,
247,225,235,110,250,105,145, 12,136,  8, 54,133, 77,135,104, 19, 97,148,  1,154,
117,206,246,224,153, 74, 11,205, 37, 16,170,113, 82, 14,167, 27, 51,155,220,199,
220, 92,144,168, 17,  0,132,178, 12,124, 45,117, 87, 50, 46,227, 54,125,236, 73,
 27, 37,217,177, 37,200,234, 78, 39,153,172,138,221,220, 77, 90, 13,135, 77,218,
 72,  6,135, 33,116, 80,215,152,242,131,124,158, 10, 98, 87, 79, 38, 18,180,193,
139, 79, 13,  6, 75, 57,122,104,153,104,110,249,150,225,201, 94, 38,219, 24,186,
184,133,234,108,151,159,223,247, 46,234, 39,139,177, 94,190, 82,180, 12, 20, 93,
134,171,190,252, 70,189, 21, 53,255,154, 40, 54, 28, 61, 41,174,242,146, 61,213,
201,158,183,171,230, 65,189,178,114, 41, 28,150,114,242, 91, 63,234,202,232,217,
 46,155,172,184,147, 54, 93,206, 95,203,185,132,102,250,196,132,  5,196,249, 26,
 24,165,181,150,122,  4, 38,187,154,180,190,156,184,195,140, 73,111,120,103,224,
 99,101, 75,194, 16,169, 12,129, 51,100,200,198,193, 26,  1, 94,171, 52, 73,  5,
162, 66,164,190,229,125, 60,141, 18, 15, 32,252,121, 26,161,187,132,125,105,  7,
193,181,222,159,246,147,188,133,193,180, 27,210, 93,242,226,249,131, 89,121, 43,
143, 98,201, 71, 34,121,  6,213, 58,150,156,211,110,242,159,233, 92,101, 58, 12,
244,201,133,106, 96,250,239,103,254, 99, 64,255, 74,183,252, 40,107,157,147,180,
186,146,156, 68,255, 29, 74,222,183, 73,163,127,111,137,242,129,  0,227,213, 28,
162,205, 14,211, 93, 79,166, 35,101,183, 54,  4, 10,212,144, 31,157, 41,133,183,
 13,207, 48,224, 53, 70,101,111, 89, 11,129,118,128, 18,137,237,236,162,164,121,
192,129,218, 41,226,210,199,122,248, 67, 80,228,118,122,186,208,204,113, 99,224,
 32,205,200,224,174, 68,182, 77,180, 59, 62,248,189,181,112, 51, 94,239,152,225,
 68,171,  0,219,109,162, 53, 82,207, 23, 71,243, 56, 66, 14,160,238,215, 52,128,
193,245,151,123, 63,  4, 72,177,192,197,183,221,228,  6, 61,111,142,112,  0, 63,
206,102, 61, 32,104, 81,233,233,  0,228,142,235, 29, 13, 14,121, 53, 50,163,224,
136,220, 30, 64, 70, 34, 57,246, 78,198,140, 25, 46,153, 28,213,111,192, 57, 58,
 46,131,161,237,100,119, 86,230, 12, 92,195,  9, 23,165,199, 82,140,155,126,181,
117,182,182, 72,243, 57,182,216,223,197, 56,176, 27, 86,216,109,103,180, 28,198,
216,198,133, 80,187,185, 98, 97,189,155, 37, 35, 62,  6, 87,164, 36, 45,222,184,
  9, 68,192,221,156,188,233, 25,188, 81,148,100,191,125, 27, 10, 50, 22, 26,230,
 86,105, 18, 44,111, 73,253,170,216,201,104, 11,200,  0, 65,138,220, 95,107, 64,
 90, 74, 78,160, 91, 59,132,206, 62, 11,122,143, 97, 89, 16,184,190,172,200, 88,
192,  6,111, 54,174,192,240, 21, 80, 28,209,215,149,115,240,175, 83,241,132, 54,
145, 33,161,102,199, 53, 34, 85, 82, 43,240, 74,111, 17,115,116,126,149, 62,139,
211, 20, 24, 85,128,129,107,149,228, 58,  5,255,171, 35,161,132, 37,165,  0, 91,
173,237, 32, 85, 49,225, 76, 53,207,115, 80, 64, 70, 46,208, 76,106,227,122,157,
242,255,251, 16, 64,118,243,133,146,221, 86,201,226,128, 42, 18,189, 31,237,113,
 53, 47,  0,106,238,236,185,199,238,243, 33,210, 59,123,193, 13, 43,146, 63, 75,
177,102,198, 83, 36, 60,100,162,165,226,122,139,224, 52, 71,142, 37,221, 29,147,
234, 16,158,205,173, 56,247, 68, 34,143, 92, 72,119, 14,236,136,225,241,142, 44,
 66, 50,158,131,235,145,232,166,187,227, 22,  1,229,191, 18,235,149,200,186,233,
 43, 73,232, 49, 44,147, 51, 66, 86, 22,145,249,208,134, 88,238, 63,170, 61, 68,
 44, 16, 32,237,126, 30, 17, 51, 30,146, 43, 89,107, 27, 30,240, 56,  6,219, 30,
176, 32, 18,170, 94,216,116,123, 28,244,252,138,242,204, 43, 18,112,151, 14,103,
 36,240,112, 59,132,117, 58,183,247,218,144, 16, 37, 41,186, 14,240,219,161, 24,
 18,173, 29,199, 76,188, 46, 30, 71, 62,227, 12,174,119,200,102,237,136, 63, 29,
123, 98, 33,183, 71, 77,193,181,125,229,239,110,194,246, 48, 31,227,184, 88,125,
126,221,246,181,218, 57,130,144, 14, 80,194,108, 67,154,119,192,145, 23, 39,  3,
100,175, 45,136,233,171,168,241,184,202,236, 81, 92,132,220, 14, 70,148,131,114,
197, 18, 21, 99, 45,184, 60, 84,157, 63,255,125, 35,212,181,136,201, 52, 91, 15,
 54,216, 77,148,200,100,203,179,217,252,158,238,  3, 95,151,236,113,168,227,167,
 23,178,193, 38, 65, 79,206,176,113,108,188, 83, 45,235,213, 76, 32,  2,225,154,
145,221,235, 36,153, 84,199,199,240,201, 71, 57, 55,  6,  8, 85, 10, 71,251, 50,
226,  5, 99,138,186, 60,168,145,152, 19, 53,237, 72, 52, 39,131,201,104,108, 76,
 68, 37, 62,112,167,249,192,190,145,123,189,194,206, 24,  2,176, 30,157,126, 20,
227,226,202,130,176,140, 16, 61,152, 58,184,251, 24, 43,123, 15, 18,189, 75,111,
  8, 17,170, 11,195, 94, 10, 32,  7,217,215,163,132,184, 16,215,186,233,198, 21,
230, 62, 71,186, 15,192, 69, 88,105,253,221, 70,132, 13,153, 99,177, 41,140, 50,
127, 20, 73,199,212,207,121,241,135,215,250,177,204,135, 66,  1,248, 24, 66,217,
 27, 81, 18,232,156,143, 91,130,147, 70, 10,206, 98,103, 20,242,137, 61,118,226,
 97, 20,220, 66,208,160, 61, 30,227,170,235,207, 69, 10, 18,206, 31, 69,135,175,
149,210, 73,181,110, 53,179,230,176,118, 58,221,114,182,210,  0, 34, 96,253, 30,
128, 46,  2,154,147, 31,115,  2,123,160,102, 30,165,238,106,239, 38,181,167, 91,
 95,154, 73,  6, 58,141,139,179, 39, 73,207,181,197, 57, 46,164,195,233, 22,192,
 48, 49,213,102,193,134, 22, 51, 85,163,188,132, 24,139, 92, 90, 60,176,160,135,
  6,244, 53,227,251, 99,  9, 23,166, 54,240,241,149,106,181, 58, 77,172, 57,252,
204, 12, 66,172, 25, 20, 75,243,225,221,111,122,251,165, 49, 24,124, 25, 71,252,
162,176,162,143,184, 80,240, 16,136, 66,169,165,113, 66,131,194,174,145,115, 63,
194,116,167, 88,175,110,108,126,148, 72,  9,156,236, 55,161,233,126, 10,101, 95,
 81,130, 36,112,118, 25, 73,132, 94,196,223,188,170,238, 18,106,160, 62,208,201,
148, 73,246,166,134, 35,131, 65,  8,141,121,139,178, 51, 11, 38,217,235,145, 42,
 37, 91,  7,100,201,140,110,150,163,249,248, 53,138, 88,180,163, 33,176,134, 69,
192, 29,127,144, 51,126,166, 85, 97, 52,197,205,150,228, 34,165,135,118,107,154,
 13, 49,244,240,128,217, 87,121,199,210,139, 47,240,231, 18,113,177,184,110,214,
 79,188, 36, 62,112,180,145,184,226,137,190,221,131,144, 83, 11, 48,163, 36, 72,
  9,114,175, 37, 60, 82, 81,172, 25, 98, 53,205,232, 41,193,218, 88,121,  3, 66,
186,157, 37,182,159,188,214,118,104,125,  7, 98,241,158,196, 94, 55,221,191,235,
129,157,118, 31,230,245,150, 50, 18,180,139,113, 15, 23,117,245,168,214, 73,214,
106, 29,118, 25, 71,216, 28,133,118, 30,244,108,104, 12, 36,239,211,102,  2,186,
115,237,215,249,168, 48,  4, 22, 22, 37,211,118,159,186,  9,181, 70,136, 78,187,
208,100,255,139,237, 12,217,201,255,236,  8,209,235,189,  5, 45, 11, 46,102, 47,
218,210, 96,169,104,160,193,169,150, 36,162, 82, 43,229, 84,140,185, 25,170,135,
 29,204,253, 58, 23, 49, 31,105,101, 41, 49,151,170, 46,223,111,225,177,251,161,
184,155,150, 84,  4,120,172, 53, 54, 16,228,180,216,144, 56,121,216,189,154, 92,
 34,227, 79,251,143,123,193, 48,215,116,179,135, 28,110,  0,171, 71,115, 56, 85,
 17, 13,182,200,179, 84,179, 65,252,219,173,192,101,104,187,101, 75, 59,190,226,
 51,216,194,106,188,229,  9,120,217, 77,247,160,223,  3,189, 14,127, 79,209,158,
100,229,129,106, 85,  4,  9, 18,213,230, 79,102,136,222, 31, 74, 26,194,  6, 24,
145, 14, 94,139,149,235,230,212,100,157,198,254,120,107,255, 53, 63, 36, 46,156,
141, 15,160, 73, 10,105, 31,146,195,199,162,122,243,144,159,220, 97,116, 10,228,
246,240, 34,  3, 69,124, 52, 48,129, 45,124,236,234,113, 37,169, 67, 70,243,142,
 52,252,179, 93,148,231, 18, 26,219, 88,  6, 73,132,204,142,  0,108,240,156, 30,
 22,215,141,240,196,240,100,167,181,117,154,114,200, 35, 43,249,140,153,232, 61,
230, 42,105, 30,203,128, 19,116,145,231,213,161,234, 70,118, 80,182, 38,202,  1,
 28,250, 71, 23, 19,209, 56,164,223,151,206,146, 94,121,109,109, 28,249,180, 30,
156,167, 51, 47, 80,120,196,126, 32,251,238,104,248, 94,125,167, 52,239, 66, 14,
147, 27, 54, 79,  6,112, 54,135,135, 73,254, 57, 89, 26,250,178, 43,154, 26, 38,
 53,109,217,  7,203, 78, 62,232,114, 15,104, 48, 47,176, 83,111, 56, 71, 44, 69,
111, 98,124, 80,158,204, 83,195,116, 52,236,158,195,232, 79, 55,136,159,116, 60,
201, 34,  2,157,209,217, 91,235,  9,149, 75, 74,141,  1,103,234, 30, 54,241,152,
 27,126,220,237,152,183, 35, 46, 30,  0,253,140,197,103,106,219, 99,224,128, 25,
132,186,198, 81,247,140, 47,122,153, 54,102,  3,215, 51,154,137, 35, 41,172, 34,
 90, 88, 68, 24,115,129,221,106, 75,102, 50, 38, 23, 28, 61,  4, 93,139, 33, 95,
 85,178,  2,215, 94,130, 47,101,129, 35,118, 13,101, 40, 78,148,231, 57,194, 53,
177, 42,190, 74,146,  2,126,202,160,134, 93,192,149, 72, 68, 79,207,145,203, 91,
126,251, 19,  5,126,200,192,135,147,145,194,232, 58,174,131,216, 58,163,246,208,
147,236, 71, 12,155,186, 44,112,240,125, 40,118,186,100,251, 61, 26,182, 44,140,
 20,227,101,103,179,134, 59,230, 81,228,181,200, 14,132,135, 13, 48,245,139,  0,
 61,186,136,101, 12,171,240,224, 77,226,234,104,177, 75, 29, 41,163,114,208,145,
228, 93, 14, 76,144,215, 97, 25,253, 58,131,246, 68,  5,105, 49,248, 71,160,230,
172,238,228,193,129, 61, 12,230,243, 79,240,117,163,165,137, 57,248,167,133,115,
104, 47, 14, 59,132,185, 81, 27,226, 82,244, 79,  7,200,104,230,150,149,126,116,
 58,109,181,122,206,244,248,181,152, 55,209,210,132, 63,192,104,106,236, 26, 81,
218,164,209,108, 84,115,177, 35,109,217,  7,161,182,148, 88, 14,142, 80,145,117,
212,103, 69,211, 29,252, 86,116, 81,207,243, 73,178,204, 87, 72,158,208, 75,184,
167,121, 47,179,174,  2, 16, 85,174,216, 82,134, 42, 19, 55, 38, 74, 10, 53,106,
240,138,209,194,196,101,133,204, 11, 66,  0,132,163, 52,138,164, 26, 74,166,156,
167,115,143, 91,242,  9,134,158, 71, 27, 47,125,229, 99, 60,124, 62,186, 87,  6,
 82, 19, 73, 68,215, 59,206,196,225, 33, 15, 75, 39, 16, 21,243,220, 54,147, 77,
225, 57, 36,185, 80,197, 50, 14, 89, 40,246, 90, 22, 75, 77,116, 29,129,100,211,
132, 86, 66, 32,139,237, 30,150,199,162,178,152, 95,212,204,161,243,135, 76,246,
 86,147, 69,101,242,100,246, 12, 84,250, 16, 23, 86,211,116,162, 16,181,158, 37,
171, 88,211, 14,122, 73, 25,  3, 18, 47, 23,209, 21,127, 66, 23,164, 99,138,172,
225,134, 13,129,191,214, 92,244,187, 80, 73,139,197,189, 14, 81,217, 92,225, 95,
 76, 79,128,222, 36, 21,156,128,101,137, 87, 54, 90,195, 48, 28,213, 41, 65, 26,
192,139,204, 38,147,173,126, 16, 32,131,118,123,163, 62,130,  4,106, 64,141, 32,
 32,131,149,136,107, 61,131,149,148,153,181, 39,116,  0,143, 34,197,122, 17, 88,
111, 25,155,217, 81,167, 72,  7,219,146,  7,175,213,102, 98,163,246,250,180,148,
203,162, 64,161,143,220,188,108,210,189,193,112,142,144,118,203,218, 59, 41,171,
216,132,106,201, 26,156, 53, 55, 39,136, 91, 45,140,111,207,223, 35,  5,137,238,
174,180, 56, 51, 81,152,104, 32,212, 69,211, 53, 80,179, 45, 73, 67,160,187, 40,
104, 21,157, 30,168, 89,139,128,121, 22,173,193,131, 98,183,122,169,129, 72,  2,
198,160,210,152, 22,201, 93,248,218, 23,189,221, 27, 89, 58,198, 61, 38, 67,  1,
125, 42,175, 89,226,254,214,201,167,100,246, 72,175,246, 52,255,132,163, 15,144,
211,105, 69, 40,  0,124,181,103, 36,233, 26,117,234, 69, 73,163,252,123,233,169,
 57,228, 34,238, 20,118,157, 98,  8,128,214,142, 37, 40,201,163,114,169, 91,220,
130, 68,212, 29,252,169,184, 17, 20, 86, 54, 69, 80, 68, 93, 70,245, 93,113,126,
143,130, 13, 38,125,170,145,226,136,115, 36, 16,  5,188,  9, 24,134, 74,224,170,
 66,238, 56,181,226,243, 99, 35, 48,149,156,175, 68,123,145, 74,204,130,151, 41,
230,189,214,238, 68,218, 23,240, 89, 77,  2,188, 56,246,184, 75, 62,254,  2,179,
194,200,138, 71,248,156,214,192,235,161,253, 24,106,197, 76,185,110,104,134,180,
 40, 72,114,210,251, 10,122,132, 70, 45, 53,101,212,221, 55,250, 39, 17, 49, 34,
254, 22,165,203,100,236,198, 41, 65, 34,183,219,168, 49,188, 67,225,158,200,240,
113,213,240,243,132,208,  7,183,108,111, 95, 15, 46,238, 49,179, 45,174, 11,109,
235,176, 15,117, 57,241,146, 56, 49,105, 57,200,132,109,120,213,188,124,167,145,
 23,255,  4,240,187,145,212,210,184, 21,122,217,185, 15, 77, 39, 50, 35,132,165,
162,223, 55,142,206, 63,217,136,250,171, 42,161,244, 12,229,163,112,133,195,170,
 49, 80, 60, 23,110,240,253, 57,144,  1,211, 64, 49,151, 62, 25,115,187, 93, 24,
 92, 74,140, 84, 40,144,126,166,111,227, 12,121,158, 80, 32,128,208,227,250,200,
179,  7,245, 51, 93, 33, 33,110, 14,140,161,193, 94, 61,  0, 34,153,178,232, 38,
116, 84, 28, 13,142, 70,236, 21, 19, 66,183,137, 55, 59,181,193, 92,  8, 78, 59,
126,172,176,184,158,159,201, 99,142,166,134,206, 33, 56,122,188,101,178,241, 72,
175,149, 45,121,152,112, 79,245, 89,125,  6,203,179,111,181, 96,163, 86, 14,168,
247,123,171,243, 23,141,144, 90,241,148, 21,120,214,240, 20,147,111,198,103, 36,
179,210, 84,162,161, 40,216, 34,178, 52,234, 37, 64,251,111,248, 57,206,224, 52,
215,132, 24, 52,133,204, 88, 61,136, 49,162, 51, 28,202, 28,218,250,111,211,232,
 86, 90,126, 34,200,226,118,160, 37,176, 28, 12,104, 94, 43, 90,162,113, 29,172,
202,189,202,186,158,147, 31,101,177, 91,121,191,210,165,253,137,251, 32, 56, 31,
 51,101, 11, 68,127,154, 74, 31,205,222,231, 85,141,114,  3, 28,240, 27, 73,180,
 22,211,117, 53, 10,191, 19,164,249,179,154,159, 43,185, 48,182,249,229,248,132,
246,108,195,105,211,126, 66,170,177,102,168, 10,150,113,186, 95,183, 42,200, 61,
141,  0,225,189,174,175,184, 38,243, 66,222,139,  3,229,156,187, 71,194, 51, 56,
174, 11, 52,242,196,  7,180, 29, 20,  3, 18,126,156, 64,149,  0,135,135,233,144,
 40, 25,249,163, 34, 28, 65,246, 51, 28,135, 64,224,214,120,247, 24,192,113,  5,
 52, 58, 18,114, 66,128, 87,138, 45, 42,185, 84, 99,160, 11,152,105, 76,216,  0,
139,194,199,124,217,195,200, 26, 35, 16, 41,  3, 29,226,130,  4,150,105,254, 63,
 58,238,183,210,148, 92,129, 87, 97,171,252,159,203,167, 21,172,  9, 84,130, 19,
 27,198,142,110,245,246, 35, 70, 68, 49,238,255,126, 34,170, 23, 77,166,173,  1,
225, 15,136,254, 82,112, 65, 82,140,194,  0,133,173, 77, 53,184,178,222,152,204,
 44,193, 75,236,163, 31, 18,116,105,220,  2,204, 51,138,233,  8, 57,104,235, 79,
214, 70,236,211, 72,248,102, 13,175,138,180,112,132, 59,217,193,216,135,112, 84,
244,106,170, 35,134,240,158,216, 31,213,237,218,142,110, 23,194,217,  5, 48,237,
206,155,  4,114,235,130,204,192,237, 46,151, 82,106,115, 42,177,200,158,190,168,
 82, 71, 83,240,158,206,216,163,186,176,154,129,155,170,201,151,133,111,162,  2,
217,178, 72, 76, 68, 60,166,175,198,255,162,242, 13,102,121, 96,130,127,252,248,
 57,184,185, 59, 56,245,207, 62, 56,248,170,108,217, 14,159, 71, 38,179,221,153,
131,167, 56,238,  3,159,  8, 16,211,231, 91,223,170, 15,247,208,115,112,223,208,
 55,196,249, 70,111,246,161,196,188,  8, 67, 95,223,139,103, 42,201, 84, 36, 96,
 83,254, 51,127,149,245, 98,160, 39, 44,182,165, 79,171, 36,107, 88,215, 40,100,
 31,252,104, 90,215,237,107,181, 52,232,134,201,247,246, 60,128, 56,  7, 24, 14,
 22,237,178,243,104, 29,215,235,221,165,114,106,186,187, 81,247, 43, 99,193,134,
164,232,146,240,255, 82,  6,164, 34,130, 77,172,101, 53,195,136,227,245,252,237,
 44,241, 72, 93, 47, 42, 14,113, 25,139,107, 13, 16, 13, 26,245, 82,195,178, 69,
 61,137,215,160,204,231,134, 70, 38,234,181,100,168,247,232,198,232, 29,122, 24,
 43,179,153, 17,118, 28,101,224, 34,173, 38,220,104,160,241,124, 25,167,114, 19,
 10, 23, 79,238,204,232, 85,183,186,234, 86, 18,244,146,227,198,173,189,193,145,
 51,  3, 73, 18,224,148,160,244,126,117,243,196, 27, 57,157,242, 73, 70, 78, 91,
226, 84,225,199, 25,  0, 22,128,168,113,228, 12, 57,  5,225,145,136,155,113,182,
150,255, 41,153,  2, 80,166,138, 72,144,227,110, 21, 48,144,227,147, 40,177, 96,
160,224,  6, 32,205,234,113,111,147,146, 37,  8,247,233,111,223,  4,225, 67,199,
213,211,216, 74,244,106, 89,115,130,199,246,  1, 26, 61,242, 26, 38, 40,133, 17,
254, 51,144,167,140,158,176,225, 17,147, 18,152, 71,112,220,219,122,223,184, 46,
175,  3,220, 56,211,221, 77,196, 54,142,212,217,184,218, 62,127,113,125, 62, 70,
231,197,253,215, 56,104, 23, 23,146,112,139,175, 31,229, 67, 60, 87, 65,  7,132,
 78,152,159, 53, 80,214,232, 26,217, 16, 55,121,236,222,178, 82, 20,110, 71,162,
  0, 52,158, 43,137,162,115,138, 53, 60,211,173, 26, 44, 95, 29, 65,107,216, 11,
  8,245,207, 69,  3,151, 80, 27, 37, 30,121,193,196,154,248,111,215,187,205,201,
197, 30, 48,174,221,129, 45,241,230, 60,  5, 41,131,176, 31,  8, 49,151,137, 16,
  6,133, 17, 92,208,117,239, 11,194, 71,119,193,172, 91, 78, 13, 28, 70, 44,220,
 64,147,113, 79,141,  2, 76,171,133, 30, 61,105,115,148, 49,198,151, 72,188,204,
 18, 67,117, 19, 33,229,161, 98,  5, 26, 14, 25, 42, 39,249,212,211,245,190,221,
229,131, 92, 25,195,  1, 63,236,223,177,180,156, 19,  7, 89, 63,251,126, 96,134,
 41,154,  4,228,219,140,162, 81,167, 97,231,123, 49, 36,175,  1,102, 95,119,  6,
200,115,210, 55,253, 15, 13,208,144,229,  5,211,188, 35, 46,112, 36, 34, 55, 48,
129,236,101, 14, 68, 18, 28,179,229, 65, 41,236,152, 29,177,240, 90,125, 64,122,
 34, 64,233,194,192,171,212, 36,209, 13, 57,  5, 39,123,188, 90, 51,209,246,140,
126,167, 36,169, 60, 49,255,  5, 11, 67,125,254,186,200,183, 74, 16, 44,135, 54,
209,220, 35,110,110,109, 40,203, 58,151,101,205,227, 14,172, 74, 15,211, 80,174,
 23, 34, 88,151, 18, 65, 78,112, 86, 49, 12,159, 88,  0, 78,183, 64,225,222,245,
165,244,149,146,  3,151,248,  3,216, 46,  4,193, 62, 99,209,139,204,238, 85,209,
210, 61,230,186, 23, 75,122,121,193, 95, 49,130, 61, 14, 56, 22,220, 27, 89, 42,
 84,177,163,156,245, 89,169, 38,123, 96,189,232,122, 50,247, 94,187,  5,204, 20,
163,183,135,246,222,129,138,218, 70, 57, 50,117,135,177,121,193,222, 37,210,163,
211,214, 12, 61,234,101, 73,233,146,218,  0, 66,226,167, 66,  8,190,150,169,253,
 56, 42,118,217, 36,203,127,201, 55,212,123,145,168,168,151, 96,145,124,135,218,
 80, 73, 47, 91,105, 60, 41,148,161,108,180, 59,149,202, 96,153,247, 16,191, 50,
185,255,123,212, 34,224,201, 54, 27, 94, 22,120,159, 83,154,184,184, 91, 17, 64,
140, 78,172,176, 89,114,139, 66, 69, 92,179,179,224,  4,180,244, 72, 31,190,224,
 95,100,142, 41,236, 14,144, 37,178,212, 57, 44, 92, 11,135,109,136, 79,234, 71,
161,185, 10,200, 73,170,115,126, 23,211,  9,109,115,140,243, 54, 31,227, 11,225,
 93,186,231, 11, 91, 36,  7,125,194,196,  2, 42,221, 95, 40,140,194,194, 40,122,
164,165, 78,187,119, 82, 71,  0,179,123, 73, 75, 62, 89,126, 90,248, 37, 59, 44,
 31,  0,112,179,194, 97,161,113,164,129,132, 53,105, 47,156,163,101,234,126,168,
 55, 83, 88, 41,159,149, 98,  9,218,225, 24, 32,231, 14, 10,172,250,  3,138,156,
 71,126, 97, 20,173,  6,215, 40,167,113,246, 32,128,190, 95, 96,210, 81, 73,133,
 17, 72, 96, 66, 69, 40, 22, 62, 17,236,176,235,176,191,208,176, 56,177, 48,153,
125,238,124,155,172,123,213, 46,  7, 69,254, 31, 24, 58,244, 94,234, 16, 81,184,
248,117, 67,141,142, 42, 13,229, 96, 78, 57,191,181,  6,253,115, 96,180,151,141,
128,182,219,101,  3,238,206, 87,121,224,205,178, 16,108, 12, 48,215,206,236,248,
213, 12,146, 99,219,104,118,204,154,169,127,247,125,235, 41, 43,201, 59, 84,144,
143,230, 65,218,163,208,165,204,163,176,147,123, 33, 76, 60,180, 82, 12,246, 51,
120,252,158,212,232,208,122, 91,172,159,145, 97,255,187,191, 39,201,239, 38,108,
136,  3, 82,240, 32,151,225, 24,246, 69, 14,216, 98,173,187,240, 19,  0,241,140,
154,  5,142,164,  5,168,238,197, 64,161, 42, 31,155,138, 22,232,196, 14, 83, 17,
225,196,203,234,219,141,187, 24,143,115, 21,116,124, 79,252,127, 75, 64,193,  9,
  4,141,191,129,197, 92,180,192, 50,181,222,141, 37,128,143,190,243,143,138,117,
 18, 91,193,134, 23,121,  2,144, 96, 42, 39,243,217,166,132, 72, 90, 56, 37, 76,
253, 12, 15,  9,219, 52,198,166, 94,186,116,120,146,210,128,242, 89, 11,189,110,
219, 52,102,131,120,181,236, 83,235, 21, 55,131,212, 56,113,167,  0, 31, 77,209,
  3, 19,160,201, 29, 10,185, 44,147, 89,168, 22, 81, 18, 64,131, 94, 49,240,229,
212,221,188, 83,227,115,193,211, 74, 17,143,191, 43, 63, 16,221,146,110,160,  5,
230,141,  1, 16,253, 79, 26,179,151,240,131,242,211,121, 36,142,137,120,110, 88,
 38, 75,176,183, 85, 54, 81, 56,152,156,103,126,145, 55,206,214, 50,111,137,112,
120,145,116,222, 15, 77, 80,171,103,182,168,236, 67,114, 39,155,221,149,214, 96,
 67,210, 88,209,216,127, 19,210,156,235,164,167, 69,226,222,150, 32, 33, 33,205,
194, 61, 89,248, 49, 57,186,174, 10,171,192, 66, 46,200, 68, 82, 35,112,103,152,
 14, 16,195, 95, 37,  8,102,122,224,219,172, 39,190, 99,138,193,116,237, 84,137,
165, 55,110,122,130,183,163,167, 67, 78,241, 17, 20,229,118,197,114,148,211,233,
161,170,245, 70, 42, 75, 20, 56,192,124, 32,195,211,211,182,136, 34, 91,141,250,
225,253,  7, 15, 86,119, 73,242,231,118, 80, 21,119,  2, 18, 42,  7,123,193,113,
 89,239,176, 53,128,141,250, 58,247, 50,218, 21,251,118,224,171,163,231, 39,145,
100, 84, 38, 67,162, 63,221,172,173,209,118,112, 99,202,238, 88,204,203, 89,194,
107,223,176,153, 54,226,134, 87,197, 55,122, 31, 44,  8, 23,196,171, 37, 42,236,
162, 73,115,165, 43,171, 70, 83,154,106, 19,161,150,138,142, 84,168,128, 52, 65,
 74,121,136,124,147,165,131,128,152,160, 41,107,173, 10,  5, 69,113,123, 53,232,
158,229, 64, 98,176,190, 58,193, 62, 52, 21,143, 58, 18,156,250,229, 81,160,116,
146, 20,215, 99, 60,183, 48,246,132,164, 77, 25, 87,239,122,223, 72,102, 55,189,
231,143,  7, 37, 35,140,190,179,208,137, 29,187, 57, 86,116,116,128,  1,145, 50,
193,167,201, 79, 83,214,121,241, 91,165,118, 94,130,128,143, 39,208,181,212,140,
 52,104,106,109,171,196, 21,130,211, 52,212, 21,134, 85, 83,157,213,147, 87,242,
159,112,184, 36,204,191,135,200, 72,131, 96,129,  9, 73,179,187,121,116,  8,196,
221,232,160, 14,178,169,142,253,112, 43, 70,168,147,  1, 40,103,111,173, 74,160,
124,202, 54, 90, 73, 12,253,249,236, 18,  0,132,161,158,143, 92, 13,193,237,141,
 83,111,234,128, 62,191,241,106,183, 98, 36,198, 67,  2, 61,  9,242,119,243,252,
  0,158,158,175, 50, 22, 39,172,129,  5,190, 49, 34, 45, 35, 16,216, 44,  0, 16,
149,192, 54,162, 23,188,157,178,214, 72,231, 60, 72,201,144, 61,205, 13,139,123,
221, 75,193,242,183,108,206,237,241,102,225,147,211, 18, 87, 98, 94, 23,169,248,
190, 43,197,182,176, 94,186,184,153, 18, 90,225, 82,179,205,139,174,126,149,105,
 76,238,226,232,  9,197, 12,115, 11,174,180,199, 78,125,112,220,211,166, 21, 91,
126,244, 42,199,165, 10,212,209,253, 78, 51,220,105,  6,196,142,239,104, 29,202,
 76,166,136,119, 56,  6,236, 21,158,181,236, 45,230,205, 14, 39,217, 29, 37,130,
123,252, 94, 69,228,166,136, 95,151,214, 92, 37,243,210,124,240, 93,221, 42,132,
 58,134,205,225,227,213, 65,160,176,141, 53, 61,117, 78,  6,202,208,234, 91,185,
 77,192,157,226,  6,243, 44, 10, 48,198,165, 92,130,144,252, 71,246,209,170,139,
220,179,  9,179,140,238,153,112, 59, 17, 82,181,207,114, 87,174,117,121, 47, 69,
132, 19, 53,104, 25,168,129,145,195,198,155,116, 44,158,188,240,191,  1, 82,162,
246, 64,204,169,197,170,239, 37,200, 29,243,162,136,102,255,165,153, 26,177,146,
 52,155, 57,164, 41,183, 85, 44,153, 39,136,  3,201,252,172,199, 42, 27, 29,156,
 23,166,185, 88,230, 94, 30, 75, 52, 18, 31,237,187, 37, 86,255,  6,106,129,225,
244,245,202,179,223,178, 79,186,211,197,245, 27,162,121,128,133,148,132,125,103,
136,204, 72,254, 41,187,161,253,163, 45,163,104,252,  6, 39, 85,125, 50, 37,225,
 37, 98,228,224,128,175,161,120,221,228, 88, 55, 93,215,119,106, 23,163,238,238,
228,196, 26,187, 63, 34, 88, 58,169,210,151,189,166, 42,  3,195, 54,178,209,116,
243,131, 44,106,136,159,251,167,118,  5,  9, 46, 47,200,121, 76, 17, 85,250,144,
124,121,117,229, 33, 31,137,242,116,253,109,158, 21, 18,245, 67,213, 64, 80, 65,
212, 41,105,229,250,162,135,  4, 50, 59,195, 79,  5,146,198,163,181, 54,214,167,
 20,238,101, 96,170, 72,237, 28,200, 72, 98,235, 80, 68, 80,143,224,129,163, 67,
  2, 38,148,204, 74,172, 29,231,196, 85, 83,123,167,140,178,163, 88, 70,217,129,
 84,  6, 72,248,101,178, 74, 32,110,208,255,145,152,167,104,200, 61,148, 36, 41,
219,176,229,220, 86, 64,105,183,117,181,183, 71,142,165,100,213, 45,232, 51, 50,
148, 82,249,214,157,176, 16,166,170,183,232, 52,113, 40, 70,147,  2,186,100, 77,
198, 58,234,161, 72,135,144,193, 21,  9,158,163,250, 85, 93,161, 60, 46,142,118,
201, 65,  8, 66,130, 24,229, 16,186,140,  5,251,158, 14, 96, 14,187, 56,106,130,
164,161, 87,116,225,233, 56, 76,150, 12,102,240,220, 59, 60, 83,118, 78,110, 42,
 56,244, 59,228, 82,206, 14,252,224,193,100, 65, 61, 27, 98,142, 59, 78,199,101,
 95,143, 81,200, 51,  2,194, 54, 19,209,163,232, 62,241,122,127, 99,199,116, 15,
226,213, 16,251, 22,251,170, 16,230,171, 50, 68,214,198, 13,210, 68,112,250,199,
 61, 28,135,215, 27, 98, 95, 96,198,165,154,111,118, 87,220,194,159,217,144, 80,
184,160,177, 99,141, 94,217, 90,162,222,240,104, 41,117,163,158,115,252, 14,220,
 92,217,179,193,192, 63,  6, 85,222, 91,253,179,117,127,  3,233, 39,199,134, 63,
 79, 40,108,241, 87,177, 51,174,234, 66,151,214,235,164, 59,170, 50, 23, 73, 93,
 64,192, 32,105,225,118,147, 43,239, 11, 42,170,199,124,212,108,180,239, 24, 15,
154, 19,174,144,190,142,217, 54, 15,101,124,234,222,185,233,201,118,196,229, 62,
251, 77,139,108,102,153, 54,248,203,218,167, 16,134,153,150, 33,235, 10,142,146,
111,133,234,105, 80,206, 19, 88, 43,149, 67,125,207,244,152,204, 67, 91,253,255,
100, 71,172,240, 56, 62,203,169,242,215, 67, 29, 67, 99, 23,219,238,126,246, 19,
145,250, 10, 61, 84,185, 88,141,194,112,202,133,145, 18, 20, 30, 38, 86,185,105,
212,110,208,165,124,149,212, 50,163, 16, 44,128, 59,228, 33,140,185,233, 51, 28,
 91,183, 44, 94,110, 43, 80,101, 62,213,236,216, 86,108,  2,212, 80,108,  5,248,
185,235, 96, 23,166,177,179,156, 80, 68,142,182, 24,209,199, 84, 51, 40,157, 79,
 57, 13,130, 52,  7,  0,214,208,138, 34,130,164,181,115,150, 70,134,117, 81, 92,
  7,122,186,247, 92, 96,137,158,  9, 70, 37,123,201,174, 38,109, 20,149, 81, 58,
221, 24,253,122,  4,128,192,108,254,137,148,177, 76,158, 89,235,123, 56,  8,229,
  3,218,202, 20,178, 30, 77, 18, 24, 82, 66, 53,100, 84, 91,132, 91, 32, 77, 41,
  1,  0,188,117, 84,132,120,213,174,173,112,180, 65,132,208,103,242,184,184,  3,
163, 82,146, 72,153,251,152,173,113,186,246,224, 18, 12, 24, 67, 80, 71, 73,108,
 95,248,140, 41,110,124, 86,130,139,118,135, 35,141,135,212,124, 32, 70,211,233,
179, 84,141, 23, 24,100,159,164, 43,251,137,173, 45,208,226, 99,243,209,181, 52,
191,107,167, 42, 73, 48,128, 29,224, 13, 63, 87, 46,233,121, 57, 94,  5,230,205,
146, 47,151,220, 28,206,239,193,201, 69, 52,104,145,  5, 36,232, 60, 36, 51,  1,
 55, 24,230,219, 45, 88,122,177,182,246,162, 18,213, 40, 33,135,171,146, 86,214,
171,237,128,106, 97,217, 21,237, 61,128,170,234,217, 33, 84, 61,183, 38,164, 89,
149, 77, 12,159,226, 76, 18, 93,151,126,116,132, 44,191,205,151,107,234,196,110,
125, 90,211, 40,183,133,227, 12,142,115,250,167,238,206,230,  5,141, 25, 30, 75,
208,249,241, 92, 68,250,  6, 56,136,103, 66,183,101,183,223,206,178, 79, 53,110,
 43,250,189, 66, 53, 37,196,106,  6,196,222,255,130,109, 78, 35, 62,159,217,107,
115,  2,  5, 21,118,195, 83,125, 68, 21,131,108, 10, 63,245,105,140, 35,100,219,
 31,194,190, 70,115, 27, 75,151, 66,225, 39, 81, 50, 85,156,194,185, 41,155, 68,
 84, 45, 68,190,137, 76, 99, 17,126, 22, 73,233,222,232, 71,245,  0, 44,217,147,
106,178,153, 97, 20, 31,204,214,227,138, 80, 35, 33, 57, 82,  3,  3,209,200, 85,
236,121,218,177, 38,190, 46, 32,184,217,127,130,217, 11,115,  6, 88,239,147, 70,
 47, 42,192,106,116, 63,226,144,126,253,235,101,  6,114,134,125,132, 78,205,120,
 10, 73,229,188,167, 99,201, 33,246,253,243, 29, 60,166, 43, 68, 47,114,208,198,
 67,135,217,169, 61, 42, 96,200,202,243, 78,151,247,175,110,186,  8,121,129, 60,
212, 42, 88, 40, 99,126,184,202,175, 64, 46,141,109,186,232, 35,196,199, 97,168,
 84,240,188, 23,196,113,166,120,232,251,142,176,238, 41, 61,154, 83, 28,177,246,
 30, 35,160,242, 25, 87,102, 19,199, 94,149,231, 41, 17,195, 17, 20,164, 98,117,
132,179, 83,120, 31,  3,106,154, 81, 48, 40, 21,240, 91, 81, 76, 16,192,105,147,
147, 15, 40,204,254, 55,210,180, 28,206, 32,209, 56,100,211, 33, 46,183, 56, 82,
207, 56, 22,195,136,  1,107,167, 81, 43, 36,149,166,208,219,140,237,173,230,181,
214,210,  7,159,174,140,254, 67, 44, 34, 18,107,173, 18, 34, 10, 20,101, 16,135,
246, 32,121,180, 52,  0, 38,190, 73,193,108, 67, 65, 51,119,207,200,221,  1,221,
137,234,240, 42, 18,164, 23,174, 15,243, 58,116,127, 16,119,200, 55, 35,123,119,
214, 50,  7,202,241, 75,190,169, 10, 16,215,114,175,239,  8, 26, 67, 48,186,161,
116,194, 78,161,150,177,189,188,136,130,241, 67,224, 79, 53,242,221,184,160,228,
197, 66,150,116, 44,162, 29,104,  2,  0,100, 36,154,111, 75,166, 21, 24,193,181,
100, 22,145,153, 42, 78, 16,235,167,212,198, 35,123, 94, 20,204, 58,215, 63, 26,
111, 76, 39,186,188, 69,168,242,223, 67, 87, 62,198, 46, 77,200,118,106,225,128,
152,165,104,127,134,142, 52,104,158,186,220,198,142, 95, 53, 40,211,  6, 35,151,
172,101, 12, 15, 72,118,144,130,  2,197,  8, 66,228,119,160, 39,161, 86,252, 94,
135, 13,169,  9, 17,108,174,234, 74,210,110,142, 38, 38,  5,108,248, 48,224, 77,
 49,145, 61,180, 11, 92, 12,135, 35,  8,230,204,  7, 53, 25,130,114,190, 35, 77,
 31,109, 35,224, 74,245,107,212,221,253, 89,127, 17,216,228, 37,134,120, 59,  5,
243, 53, 43, 66, 92,246,100,249, 61, 22,117,177, 89,254,250,144,145,159,239,234,
169,195,138,152, 82,208,202, 22,157,201,198,232, 94,127, 18,216, 95, 18,151, 38,
 96,232,230,194, 65, 94, 18,177,249,206,243,133,113,136, 51,211, 20,232,176,139,
 78,243,134,221,148,104,172, 67, 21,198, 26,  6,199, 93, 58, 99,165, 14, 71,148,
 51, 33,185, 17,228,106,189, 13, 22,186, 57,178, 88,118,198, 32,  9, 66,166,131,
106,129,117, 96, 81,  1, 80, 38, 32,175,122,114, 20,159,141,  0,246,212, 41,201,
137,220,141,204, 92, 73,218,127,159, 45, 54,172,229, 78,210,124,126,110, 36,189,
105,218,149, 64,241,251,213,208,237,162, 23, 44,177,163,131, 33,202,153,193, 64,
 15, 13, 29,107, 51, 89, 83,152,240,208, 17,157,  8, 48,  7,103,126,186,120,118,
105, 23,207, 33,201,133,206, 94,100,  8,100, 52,160,209,176,  4,234,117, 10,135,
 67,161,193, 10,243,135,139,176, 62, 72, 49,121,216, 14,162, 87,225,212, 69, 31,
174, 12, 26,202,  8,113,230,114,134, 36,205, 16,102,138, 10,  4,207, 27,131, 95,
 22, 66,169, 64,128,185,206, 32,200, 46, 28,122, 97,178, 43, 15, 46, 66,  8,177,
 20, 33,187,242,226,173,182, 14,127, 53,132,207, 69, 60, 20,172, 50,164,184,104,
236,148,  1,119,163, 64,231,188, 91,  1, 58,101,116, 19, 41,192, 14,109,  3, 10,
136,233, 53,198, 87,213,220, 19,101,118,  8,  5,105,151,253,135,234, 17,  9,139,
235, 14, 70,154,156,249,159,150, 33,219,166, 40, 48, 69,  7,  2, 32,  1, 57,  1,
 41,  1, 10, 59,159,162,119,162, 37,177,165,192, 44,146, 89, 86,250,175,233, 91,
 95, 81, 60,173,222, 40,212,209,138, 62,197, 44, 61,159, 44,244, 39,232,174, 60,
162,111,136,117,254,147,195, 65, 62,178,199,233,145,159, 68, 35,102, 61, 56,249,
 68, 99,175, 89,235,114, 63,106,190,119,122,239,116,122, 88,241,158, 28,175, 55,
 62, 85,122,100, 29,249,154,250, 45,140,197, 92,142,214,209,188, 79,238,159,  5,
170, 31,121,118,253,249,111, 46,195, 73, 37,217,155,119,168,139, 72,132, 76, 18,
 33, 44,145, 51,153, 47, 50, 44, 41, 70,125,150, 24,181,142, 85,157,159,252, 11,
 98,209, 44,138,141,191, 68,218, 56,165, 29,101,201,141, 71,254,102, 89,249, 13,
 45, 25, 94, 11,155,172,101,178,170,215,184, 26, 71, 83,228,113, 38, 79,109, 90,
146,198,161,117, 47, 99, 91,227,244,114, 66,254, 32,179, 44,195,200, 30, 25,195,
 48, 45,115,199,136,124, 68,162,187,226,213, 24, 22,117,223,140, 59, 22,142,101,
 41,226,  8, 78,122,200,228,200, 23,150,112,179, 52, 89,242,145,177,135,227, 45,
145,216, 49,207, 51,198,159, 42,231,139, 71,148,222,150,148, 86,140, 85,189,212,
 43,166, 86, 51,189,213,228,239,121, 85,234, 38,247, 30,227, 97, 60,140,135,241,
170,174, 94,189, 74, 18,137, 90, 10,  1,  2,214,227, 91,185,128,127,134,222, 56,
248, 73,141, 45, 73,223, 49,159,239,128, 60,172,138,243, 93,231,  0, 90,251,127,
229,124, 64,150, 99, 51,242,175,244,104, 82, 96, 55,171,114, 45,243,111,  3, 57,
164,104, 59, 70,178,216,255,154, 59, 91,141, 19,194,236,225,133,247,127,178,173,
165,114, 50,144,  9,  8, 68,221,124,154, 30, 80,237,132, 55,180,229, 56,142, 29,
  6,  0,192, 71,182,207,224,123,  2,201,199,219,128, 18, 68, 30, 39,147,169,214,
100, 32,235, 56, 73,193,111,175,125, 86,153,165,255,  6,154,144,128, 28, 16,252,
 58,237,243,128, 78,150, 36,101,158,143,161,106, 74,219,162,170,  5,228, 65, 34,
146, 79,237,136,190,  5,175,130,159,141, 87, 19,190,139,  9,190,203, 41,227,145,
 97,163, 61, 10, 53,147,224,249,111, 94,166, 37,150,207, 83, 43,153, 40,195,225,
116, 68, 37,125,142,217,130,  7,148,153,216, 25,155,168,136,150,240,217, 92,192,
 14,  9,111, 93,102,131, 76,  5,  4, 85, 44, 76,147,167,124,150,210,167,116, 52,
249,162, 56, 29,205,230,235,112,  8, 50, 14, 28,200,178,236,210,169, 89,168,109,
234, 35,153, 65, 65,  6,  4, 17,108, 27,114,186, 33,169,  6,172,106,131,  0, 43,
 88,185,100,110, 88, 74, 62, 11, 71,  3,209,121, 30, 15,  2,122, 94,251, 84, 13,
200, 73,200, 58, 85,243,185,148,251, 35,145,  8,193,197,193, 35,  2,191,238,106,
  8,128, 69, 14,135,195, 65,  6, 56,242, 25,134, 21, 85, 86,214,119,254, 22,170,
236,222,242,220,221,173,175,124,125, 84,249,251,220, 40, 75,226,176, 74,249,160,
148,141,161, 23,118,186, 41, 32,188,  1,101, 10, 91, 84,104, 90,210,134,216,  3,
 46, 44,160,114, 97,255,208,156,181,162,231,174, 32,175,198,233,159,106,164,208,
 74, 88,241,174,113, 53, 26,142,198, 83, 34,242,105, 85,174,234,230, 69, 59, 52,
 37,209,239,194,198,157,176,250,241,221, 87,212,181, 38,203, 73,133,101,236,  0,
126,227, 67,223,113,100,183,190, 27,219,212,119,215, 87, 95,198,178,169, 11, 58,
139,162, 40,138, 68, 30,  5,176,138,106,131, 72,228,221, 91, 24,134,125, 38,154,
182,186,174,109,150, 58,203, 28,254,163,235,122,127,236, 18,189,232, 47,243, 28,
 93,169, 37, 69, 89, 95, 33,  9, 31, 93, 37, 44,181, 59, 83,232,183,102, 41, 80,
 89,187, 53,214, 26,135,126, 69, 43,230, 43,254,149,249,205,229,  1,  0,102,201,
128, 28,  7,209,231,225, 35,153,103,169,187,157,222, 10,172, 11, 30,132,168,178,
 24,213,184, 45,128,112, 25, 36,167, 46,246,  3, 26, 23,209,168,248,102,105,117,
190,223,198,  3, 81, 29, 50, 30,  1,  1,  4,215,214,162,176, 91,115, 74, 87,190,
 52,207,114,101, 75, 22, 56,129, 79,185,172, 92,143,214,158, 48,220,249, 87, 53,
102,186,113, 27,183,113, 27,167, 73, 52,137, 38, 49,187,206,236, 58,207,196,223,
 13,124,247,110, 13,164,105,250,185, 46,136,231, 37,108,220,198,109,220,198,105,
 18, 77,146,214,106,202,239,121,  9, 27,183,113, 27,183,113,154, 68,147,156,160,
 19, 20,145,166,214,121, 98,138,113, 99, 18, 78,159,180, 40,239, 66, 18,162, 70,
  3,215,243,211,244, 76, 43,130,167,166, 11,246,199, 88,178,113,226, 10,161, 65,
166, 74, 48, 59, 83,228,233, 23,152,139,139,203,  5,169,161, 56,252,162, 71,108,
 39,220,186, 84, 41,215, 29, 38,177,198,188,238,183,252, 24, 83, 69,176,194,199,
249, 47,127, 62, 89,110,136,105, 44, 61, 19,182, 46, 85,166,153,214, 39,254, 33,
201, 70,137, 38,246, 15,105,190, 57,231,  5, 30,201, 36,252,146,178, 78,123,116,
145,172,204,145,202,245, 25,158, 27,103,209,146,222,230,162,121, 44, 96,117, 96,
240,106, 37,123, 88, 15, 85, 99,202,152, 73,111,204,103,185,128, 20, 75,191, 99,
159,194,166, 90,156, 45,155, 47,180,185, 40,124,149,203,107,151,119, 74, 46, 49,
 82,198,225, 13,173, 48,223, 46, 99,241,142, 42,137,246, 19, 12,229,210, 85,227,
152, 45, 93,125,124, 98, 71,103,247, 95, 73,255,109,  9, 53, 90,187,239, 72,251,
111,109, 71,149,171,199,235,232, 28,181, 82, 57, 71, 94, 53,118,155, 65,105,144,
144,168,228,249, 70, 37, 27, 18,  0, 20,  0,179,178,  0,  8, 10,139,141, 69, 18,
137,156,  7,138, 82,123,164,224, 70, 68, 24,  7, 16,  7,145,133,196,161,104, 32,
128,  8,  8,137,129,  1,152,  0,  3, 48,  8,  1,  3,160,  0, 66,  1, 24,128, 66,
128,164, 17,249, 41, 92, 88,110, 64, 72,189,192,155, 28, 69,102, 38, 88,122,238,
168,233, 53,  8,164, 18,110,154, 65,152,242, 63,247,132,123, 29, 58,216,208,  0,
125,171, 65, 35,248,194,110, 49,166, 31, 72,161,241, 75,112, 36,119, 64,229, 30,
 11, 40,255,107, 16,246,118,182,183, 32,134, 57,209,237,199, 59, 87,154,105,169,
129, 95,156,174, 93, 64, 90,242,199,107,209,  6,118,225,205,175,113, 28, 65,171,
 22, 32,243,132,126, 42,160, 29,  7,149, 90, 32,234,  9, 46, 22,196, 64,168, 80,
155,252, 21, 71,237,136,  1,105,179, 93, 95,240, 22,228,174, 20,176,178,185, 31,
  2, 12,237,250,130,  0,235,176, 39,  1,220,159,189, 16,239,193,127,197,167,189,
 26,226,232,163,254,  9, 12, 79, 52,154,135,235,201,220,190,193,152,225, 77,167,
 18, 23, 48,  5,210, 55, 26, 97,184,177,227, 40,  6,  5, 71,254, 34, 30,141, 22,
  4,164,200,191,115,120,109,203, 92, 57, 12, 73,209,159,190,143, 95, 73, 19, 24,
116, 67,174,101, 12, 99, 73, 34,195, 88,149,202, 96,200,103, 56, 55,236, 61,148,
 97, 92,145,203, 48, 94,109,253,188,148, 81,  2,104, 63,197, 51,122,144,143, 71,
198, 92,120,248, 29,112, 31,134, 47, 47, 38,237,120, 63,141,114,148,  6,204, 53,
195, 76, 41,141,236,217, 38, 53, 75, 37,156,163,244, 40, 14,148,  4,168, 98,212,
 20,253,225,246,  6,226,210,235, 12,214,152, 12,  3, 32,106,109, 66, 80,239,231,
176,160,224,129,143, 36,245,107, 14, 44, 55,116,123,168,135,109, 14,109, 72,124,
120,207, 63, 76,214, 18,166,176,199,169, 93, 40, 47,241, 13, 36, 97, 26, 41, 46,
196,113,138,177, 90,230, 44,254,155,189,186,162,  9, 81, 46,207,161,201, 25, 43,
191,186,192, 28,  9, 69,199,112, 72, 46,250,153, 44,  1, 41, 97,213,204,121, 87,
 36, 54,124, 34,143,  0, 72, 14,144,208,144,159,  7,227,121, 33, 41,114,250,231,
 22,114,148,239,144, 68,  7,230,130, 90,165,208, 86,149,102,172,225,195, 15,139,
 95,127,  0, 72,109,250, 30, 95, 52, 13, 35, 62, 51,222,250,193, 16, 59,  4,103,
170,100,109,129,148, 37, 63,186,191, 48,169,237,162, 56, 26, 69,132, 13, 75, 90,
 81,192, 43,238,232, 57, 99,  9,120,177, 42,181,171, 28,156,177,120, 81,227,225,
 94,203, 48,171, 48,190,104, 34,156,112,156,140,184,206,149, 34,198, 66, 28, 39,
126, 67,189,164,148,249, 90,138,178, 85, 20, 70,194, 40,153, 78, 84,122, 74,150,
197,142,154,172, 70,117, 12,134,188,231, 53,225,162,146, 41,164,162,195,125,  9,
185, 23, 44,133, 44,250,240, 18,162,229,183, 50, 79, 71,198,134, 56,170, 40,225,
235,153, 52, 27, 35, 14,165,162,197,166, 72, 65,214,203,185,100,220, 26,254, 31,
 50, 29, 71,168,  5, 16, 42, 58,177,148, 66, 32,236,144, 40,128,136,155,120, 20,
 59, 34,  2, 21, 67,169, 73, 67, 24,251,167, 63,120,  0, 92, 24,191,179,185,  3,
191, 48,138, 71, 40, 40, 48,149, 17,136,  1, 97,123, 69, 15,  5,208,181,  2, 62,
 48,226, 29, 32,211,130, 40,234, 25, 17,153,177,246,223,106,221,  5,130,172, 74,
  8, 58,217,220, 16,214,151,113, 98,197,135, 39, 25,240,177,193, 22, 52,201,109,
100, 91,195, 12, 16,142, 58,129, 89, 67, 21,227, 90,221,169,253, 25,153,214,  9,
 98, 48, 80, 77,194,246, 81,131,191, 86, 83, 85,164,153, 96, 83,155,144, 81, 24,
  4,171, 49, 45,152,193, 94, 47, 68, 63,194,136,208,189, 66,250, 68, 24, 37,  8,
113,133, 44,100,129, 48, 68,116, 10, 29,147,113, 36,245,105, 48,194, 94,164,173,
123,  4,141,  9, 38,185,210, 85,176,203,250, 67, 39, 43,156, 57,  2,127,122,200,
 14,  4,149,218, 96,234,  8, 33, 62, 12,225, 80, 87,139, 73,130, 17,228,121,214,
108, 65, 10, 72,212, 27,232,242,114, 33,188, 23,172,215,111, 56, 16, 56,186,186,
 97,108,112,215, 61, 18,144, 63,132,253,193,147,228, 19,  8, 59,119,116,201, 33,
 63,  8,165,195,153,165, 12, 23,104, 83,164, 46,234,212, 29, 81,196, 88,120,  6,
104, 31, 51,249, 24,142,246, 18, 69, 64,163,125, 83, 69, 22,218, 68,132,  3, 92,
 42,174,193,233, 17,121,198, 28,121,238, 36,136,119,109,237,167,131,203,150,143,
172, 11,160, 51,161,117,129, 20, 51, 31,215,222,126,216,175,215,205, 62, 30, 76,
137,253,103,236,159, 14,  9,244,187,194,157, 20,234, 65,161, 90, 39,184,158,221,
121,211, 71,235,107, 22, 13,249, 50, 62,213, 11, 69, 18,220,241,111,129,118, 87,
 70,119,122, 82,170,176, 33,237,  6,140,249,184,141,241,159,136, 13, 64,229, 53,
  2, 42,103,166, 36,238,158,237,248, 72,129, 96, 60,227,141,207,216,224,154,115,
 76,223,174, 98,  2, 14, 89, 12, 99, 43,181,243, 35,102,193,124,228, 87, 20,200,
105, 37, 22,197,106,240,222,186,158, 41,192,133, 91,159,203, 22,102, 75,254, 56,
198,128,107,113,157, 73, 96,205,131,101,150,137, 60,223,210,204,167,229,208, 82,
128, 65,136, 54,110,101, 96, 32, 56, 61,140,157,154,112, 36, 92,245, 16, 80,198,
216, 42,228,107,248,110, 10,248,206, 38, 65, 64,183,143,254, 81,106,105,132,202,
202,185,198, 68,108, 35, 64, 20,162,231,219,109,159,193, 44,244,232,248, 83,214,
103,197,200,237,192,202,139,101,228,180,253, 10,172,103,113, 56, 29, 64,148,110,
 80, 71,144, 63,214, 50,148,187,227,249,154,118,243,208,150, 26, 78, 36,  7,135,
 86,220, 53,120,134,168,109,219,158, 81,162,105,209,157, 97,221, 49,233, 76,225,
 19,146,  4,178,  2, 34,243,141,130,121,104,185,197,175, 11,151, 72,169,170,173,
 36, 32, 19,116, 12,176,223, 47,161, 73, 31, 80, 32,121,174,198, 97, 87,107,100,
252, 12,129,138,221,128,138, 91,220,159,113, 32, 16,116,178,205,121,229,153,107,
220, 28, 88, 14,211,246,150, 90, 41,128,190, 72,118,129, 71,252,247,224,227,204,
 76,100, 85, 66,113,164,249,  1,250,231,129,192,237, 26, 90, 15,139,119, 27, 31,
183,223, 64,110, 52,228, 96, 16, 16,  9,126, 86,138, 35,241,190, 86, 25,129, 21,
  0, 43,  9, 86, 35,138, 68,233,209,188, 39,193, 30,114,138,128,139,112,115,228,
215, 58, 66, 95,240, 67,145,124,135,231,170,163, 11, 30,225,155,223,194, 49, 28,
124, 30, 21,243,122,251,111, 84,199,221, 88,148, 60, 32,  6,141,205,233,116, 97,
 69,255,213, 73,136, 12, 60,113, 15,206,112, 20,205,171, 80,106,106,111, 44, 95,
186, 14,188,225,249, 57,151,222, 26,254,112, 28, 39,193,148,176,213,  2,121,210,
202, 11,103,102,246, 16, 83, 84,105,229,223,  9, 40,  1, 83,184,110,218,197,130,
 29, 56, 81,107,151,164, 59,154,196,172,207, 90,126,115,220, 65,138,  4,161,137,
176,139, 50,136,151,168,200, 17,200,204,167, 35,185, 69,242,133, 13, 22,110, 20,
 80,162, 72,  5,201,  1, 86,136, 37,230,241, 83, 87,221, 12, 92, 85,171, 41,  0,
117, 16,  5,168,130,151,138,191,112,189,210, 92,151,198,  2, 21, 23,136,156,217,
147, 80,228,114,187,197,183, 68,100,220, 21, 85,203, 60,  1, 22,240,218,203,248,
189,199, 77,218,159,194, 29,138,132,250,103, 64,100,  4,  8, 88, 83, 64,188,170,
119,  5,143, 73,197, 13,247, 39,219,230, 18,130, 50, 66,144, 31,155,207,180, 81,
150,111,133,161,107,193,  9,164,226, 55,249, 64, 49,150,  2, 40,183, 56,107, 58,
220,111, 40,245, 35,130, 62,177,175, 48,162, 34, 82, 40,184,222,186,113, 72, 30,
 29,155, 63, 33, 85,247,211,144, 31,173, 32,221,237,150, 76, 89,229,111, 99,138,
 38,121,229,132,184, 54, 42, 42,  0,  3, 27,  0,201,147,200, 96,252, 31, 95,229,
193, 50,205, 79,121,191,240,108,246, 84,158,137,134, 16,200,181, 15, 19,106,100,
200,132, 94, 47, 81, 83,129,  4, 31, 38,137, 45,191,118,206,100, 32, 31,121, 79,
101,209,210,188, 17,222, 88, 20,114, 18,  8,168, 33,239, 41,146,122,208, 68, 43,
 28,128,213, 21,220,184,  2, 61, 22,168, 82,122,131, 26, 43,195,135,135,156, 67,
 16,185, 64,191,245, 73,254, 16, 31, 13, 22, 97,245, 19, 54,212,164,246,135, 90,
171, 66,166,  0, 47, 15,198,134,244,213,220, 62,230, 17, 27, 18,114,107,172,217,
129,128,150,190, 82, 84, 27,146, 19, 78,220, 11,241,178,185,184, 79,208, 23,130,
159, 92, 35,130, 96,172,191,  8, 69, 86,  4,156,186,231,217,171,253,199,119,254,
164,226,175,109,161,241, 15,  4, 37,124,169, 75,157,154,212,104,100,132,177,163,
 68, 64, 27,223, 51,239, 97,171, 96,232,253,235,156,101,252,106,125,  2,161, 56,
 59,167,136,163,233, 98, 36, 94, 57, 13,247, 87, 55, 41,158,217, 33, 69,133,103,
211,217, 22,198,116,218,109, 33,164,  7,140,188,147,250,254,162, 44, 41,235,150,
102, 35,186,202, 82,193,101, 96,187,204,239,116,  0,223, 34, 82, 32,206,209,147,
255, 30,199,168, 41, 34,179,141,250, 60,182, 28,235,140, 62,135,184,113,243,249,
249, 61,136, 28,165, 73, 93, 48, 73,106,204,234,153,194,246,253,216,234,203, 22,
184,167,  2, 29,218, 71,165,  1,224, 56, 39,172,166,108, 52,127, 29, 77,198,160,
221,245, 21, 80,222,113, 66, 53, 22,216,212, 11, 81,212,246,169, 43,170, 22,253,
 42,209, 72,167, 26,181,216,106,144,106,116,144,106,175,221,134,238, 43,165,237,
135, 61, 83, 81, 74, 38,129,230, 53,191,163,219, 86,145, 34, 60, 24,  4,227, 56,
  9,205, 90, 52,193,228,116, 14, 70, 21, 96, 46,127, 69, 97,226,130,226,124,226,
117,160,214, 68, 40,122,253,209,216, 58,196,123,209, 24, 74,217,  4,138, 68, 11,
186,251,182,107,214,247,166, 81,130,179,106, 58,169,166,188,  9,229, 67,196,137,
 88,184, 33,198, 46,133,146,186,205,144,133, 75, 47,157,180, 19,162, 57, 14, 34,
185, 52, 95,145,194,197,134,124, 99,227,180, 74,160, 43, 71,111,156,200, 86,236,
144, 15,122, 37, 11,150,212,235,  4,217,158,236, 44, 42,139, 58, 64,210, 28, 83,
 79, 47,192,217, 30, 74, 17, 30, 95,226, 51,174,176,212, 86, 81,215,221,124,112,
161,192,159,158,164,231,  6,229,221,223,  3,131,119,213,148,  0,170,134,178, 61,
 99, 12,214,  6, 43,166,106,137,249, 35,123,122, 74,173, 57,220,159,127,253,  6,
131,172,247,102, 79, 78, 18,204,158, 75, 91,175,238, 79,  3,205,186,140,235, 15,
207, 85,  8,122, 40, 74,245,232, 74,238, 52,202,  9, 42, 25,105, 65, 23,156,215,
152,173, 19,189,231,108, 54,190, 62, 93, 30,195,224,210,196,250,172,131,240,129,
 48,133, 69, 93,140,100, 28,217,151,206, 74, 55,113,244,193,114,151, 73,233, 14,
137,250, 74,129,201, 44,138,209,  6,246, 44,101,133,226,231,161,165, 12,131,142,
161, 42, 64,216,125, 51,  9,221, 20, 61,152,119,109, 91,160,178,185,140,242, 41,
113, 35,152, 75,205,107,  5,107,156, 59,233,183,122, 74,156,188,234, 45, 12, 45,
185, 58, 79, 46,134,127,252,208,203,238,156,182,203,152,247,  9, 70, 48, 85,135,
219,159, 62,115, 83,245,  3, 36, 97,188,207,110,213,255,101,112,243,253, 57,133,
235,151,128,106, 86,150,224, 71,204,149, 82, 51,180,200,168,219,119, 24,189, 11,
226, 90,  1,237,135,  0, 10,134,155,118,  2,228,223, 58, 27, 98,188,220,109,210,
177,164,160, 57,221,120,235,120, 56,168,240,135, 35,145,163,167,226,185, 94,  9,
 53, 71,253,225, 15,162, 78, 72, 42,162,128,104,151, 37, 81,195, 39,168,254,224,
254, 44, 91,254, 48,250,170,248,148, 55,  6, 26, 37, 35, 82,145, 54,170, 91,126,
221, 57, 62, 65,229,107, 14, 80,244,246, 38,176,104,194,233, 69,190,103,131,108,
 39,108, 57, 48, 17, 67, 23, 60, 71,154, 19,163,133,119,  6, 13,250,220, 81, 12,
  9, 44,177,204,231, 40, 75, 62, 48,  1,  4, 27,102,137,117,195,234,205, 25,175,
138,194, 92, 16, 45,210,147,221,142,150,  7, 22,229, 33, 45, 68,121,116, 24,200,
 92,197, 63, 23, 93,194,111,185,116,232,200,197,120,190, 86,106,250,  2, 27,118,
 21,215,151,160, 58,249, 43,238, 89,200,157, 26,123, 78,123,232,230,106,179,109,
 21,122,189,242, 74,216,200,230,173, 23, 88,206,204,  2,137, 11, 75,192, 86, 81,
237,225, 76, 56,205,163,224,168,130, 15, 17, 70,214,152,230, 29,142,235, 94,238,
160, 50,225,139,111,131,241,163,216, 80,131,199, 45,142,116, 33, 64, 45,205, 47,
 72, 61, 59,145,159,226,198,194, 18, 22,194, 14, 62,185,240,107,252,118,109,  5,
134, 36,139,233, 28,  1, 13,184,141,223,230, 18,116,137,210,209,110,100,251, 95,
130,198,  0, 43, 81,131,  5,139, 45, 32,176, 56, 35, 20,121,226, 61,  3,  1,213,
 57,176,133,199, 90,111, 62, 88,116,113, 80,113,  5,229, 98,223,129,174,252, 82,
 32,242,169,133,129,220, 61,173, 53, 46,  0, 51,228, 26,123, 98,159,138, 58,111,
  5,226, 14,175,254,168, 46, 73, 65,243,150,217,123, 81,130,231,133, 67, 82,248,
180,107,108, 82,212, 87,120,155,139, 99,201, 36,212,175,245,199,227, 91,102, 50,
 67,130,241,208, 24,242,215,113, 10,249,151, 30,252, 91,228,214,156,119,194,160,
161,201,141,152,232, 40,  9,241,141,141, 20, 78,176, 50,245, 62,172, 74,  1,148,
105,222,204,153,143,249,127,208,195, 13, 25,226, 27, 61,  1,184, 48,199,116,226,
135,  7, 41,165, 45,198,254, 38, 65,122,251,208,140,186, 81,142, 84,154,117,167,
 11,104,237, 81,226, 42,138,155, 91,124,129,252,197,215, 64,240,146,136, 21,113,
 33,226,174, 90,196, 82,204,119, 80,107, 47,135, 90,233, 18,148, 25,213,226,196,
137,180, 79, 45,243,177,  5, 66,  6,138,197, 40, 56, 47, 82, 99, 27, 73,166,138,
192, 51,156, 39, 85, 74,177, 47,206, 34,124, 75,101, 40,220,130,123,182,122,  4,
 40, 80, 19, 46,222,228,247,208, 52,185,104,  3,113,204,127, 23,148,133, 56,103,
 91,112,226,231,144, 91,161,135, 80, 69,242,159,157, 40,193,130,  2,128,103,143,
  2,140,140, 72,115,225,218,143, 18, 19, 14,112, 83,121, 73,176,214, 53,213,224,
247,209, 84,247,111,202,  2,171,136,208, 60,245,149,110, 37, 16, 34,181, 74,174,
101,232, 42,158,252, 47,173,244, 12,172,159, 67, 35,196,158,177,136,177,211,217,
164,221,211, 68, 19, 26, 64, 52,158, 11,128, 20, 41,100,226, 62, 37,241, 79, 15,
 48, 46,133,249, 62,210, 56,233,239, 70,151,  0,187,180,229, 16,109,230,203,170,
188, 53,202, 35, 60,216,126, 69, 24, 80,  6,102, 79,179, 10, 35,240,227,221,147,
237, 51, 73, 82, 36, 90, 49,203,203, 19,214, 39, 22, 33, 13,120, 69, 69, 17, 38,
 90,157, 28,134,149, 85, 63, 74, 14,156, 84,167, 48,129, 52, 27, 78,165, 82,154,
 96,  5, 74,157, 88, 27,255, 50,138, 84, 68, 35,110,  6,161,152,112,242,191,152,
193, 39, 30,107,220,196,125, 43, 89, 57, 11,141, 38, 96, 37,196,156,247,170,100,
160, 58,150, 18,221,155,250,108,214,164,170, 39,217, 31,207,175,190,158,225, 37,
 94, 25, 57, 20,197,135,238,159,173,240, 19,182,  0,146,189,141,151,145, 45,253,
109,185, 46, 51, 83,236, 22, 45, 36,161, 55, 83,207,167,132,116,250,171,227,195,
209, 67,211,157,171,165,209,217,233,182,195,109,247,215,149,108,149, 87, 71,214,
 86,149,134,115,142,173,117,161,105,197,239, 82, 15, 10, 30,199, 85,248, 41,204,
213,113,206,110,  4,204,178,168, 74, 45, 39, 16, 47,131,140,211,249, 28,124,102,
134,119, 14,233,117,  1,175,110,240,192,101, 53,151, 47,226,125,217,105, 46,176,
 57, 23,234,165,208,  2,205,233, 16, 16, 57,245,224, 65, 61,120,163,180, 29,227,
172, 56,  4, 49, 80,154, 77,239,174,  2,250, 23,136,238,130,203, 95, 24, 52, 60,
244, 32, 94, 40,102, 11,237,244,158,  7,119, 31, 45,176,200,153,141,106,236,148,
 91,  7,178,166,114, 62,149,202, 80,234,225, 90, 69, 23,153,205, 71, 84,214,  9,
216,173,128, 73,198,200,141,218,172,126,183,167, 76,255, 32,241, 72,  8,184,155,
 22, 33,248,165,169, 70, 29, 48,109,200, 79,124,148,133,202, 52,181,187,  6,204,
 79,187, 41, 72,165,  8,198,252, 52,133,121,170,119,250, 69,204,123,129, 94,129,
162,172,244,165,  4, 21, 22,  0, 97, 65,129,158,209, 88,109, 18,150,231, 49,199,
100,  5, 21,181,102, 60,201,130,  7,152, 74,216,230,  5, 69,200, 99,102, 73, 86,
  0, 55,114,206, 50, 39,178,172,237, 61,135, 46,157, 61, 83,168, 40,195, 52, 76,
220,195,230,153, 43,169,156,142,149, 15, 52,139,210, 69,198,158, 82,174, 89, 62,
 74,221, 40,124,154,121,152,139, 80,193, 62,113,188,110,186,217,241,184,118,151,
 29,182,133, 31,209,134,171,171, 42,106,144, 32,169,225, 15,211,169,234, 90, 72,
231,143,196,246,155,224, 11,114,190, 95,165,198,175,136,176,146,  0,176, 52,164,
 18,234,208, 34, 53, 50,155,253, 17,116,174,240,163, 21, 58,184, 42,130, 75,213,
219,133,160,124,171,253, 62,101, 42,195,197, 92,133,172,147, 77, 13,103,193,202,
101, 38, 59, 32, 18, 20,244,205,  1,250,230, 88,133,227, 19,147,140,165, 75, 18,
 32, 13, 98, 92,224,246, 34, 83, 55,155,142, 23,160, 43,106, 95, 11,185,206, 54,
130,  5, 83, 74,199,248,153, 20, 43, 49, 55, 16,  6, 32,245,161,215,188,117,250,
 66,207,205, 85,191,161, 40,242,186,  5,  7, 79,104,114,132,214,  4,217,136,170,
232,215, 98, 34,100,169,184, 11,179,200,  2,153,108,  4, 44,167,150,  7, 80,138,
 69,119,194,212, 41, 22,164,171, 12, 32,  4,107, 15, 38,173,171,198,188,208, 39,
255, 77, 22, 67, 85, 11,243, 26, 34,119,136, 53, 64,112,187, 54,236, 69, 56,226,
 19,  4,  4,123,234,159, 94,106, 82,130,228,160, 85, 46,175,249, 53,190,  5, 41,
107, 40,  7,121,121,142, 58, 72, 49,128, 21,242,163, 50,140, 23,233,220,224, 78,
140, 27,174,139, 64, 58,134, 43,251,143,172,253,254,242,131,152,186,199,147, 26,
173, 62, 50, 12,139,239,170,119,148, 23, 58, 15,201,193,156,244,  4,  4, 40,134,
146,146, 76,145,247, 86, 68,253,123, 53, 59,163,103, 62,149, 33,132,192,208,225,
202,183,  4,160,234,112,234, 98,109,120,231,176,161, 22, 71,175,149, 46, 80,172,
 58, 56,211, 78,107,  0,128, 45,152, 66,147,189,155,151,122,121,150,143,138,142,
159,196, 66,  0, 38, 64,158,241,237,188,118,213, 71, 10,217,120,102,160,  6, 48,
221, 96,167,209,105,173, 47,178,141,198, 22,251, 21, 32,173,236, 58,146, 19,160,
  2, 47,127,172,  3,207,199,226, 30,148,119, 57,183,254,228,209,135,106, 69,217,
 55,195, 51,113,162, 97, 15,145,231, 38,167,159,225,101,185,105, 12, 47, 98,121,
 55,217,166, 48, 27,206,  7, 55, 29,221,171,180,232,174,195,120,132,121,104,189,
187,187,132, 58,191, 84,236, 56, 77,185,253,105, 90, 34,171, 48, 14,101,157,186,
 30,180,210, 56,157,  8, 50,138, 15,151,128, 64,119, 38, 66, 36,224, 69, 21, 51,
165,  5, 66,229, 75, 78,119, 65,125,242,237, 73, 83,158, 95,242,196, 76,242,183,
238,125, 30,244, 48,172, 68, 25,128, 47, 49,207, 47,  9,185,195,104,232,247, 32,
235,158, 88, 25,196,109,237, 11, 73, 70,  2,234,  6,132,218,144, 56, 63,124,108,
 18, 27, 17,215,121,  7,225,210,119,170, 77,155,151,100,154,222, 83,198, 72,248,
114, 74, 68,226, 83,131,238,250, 14,150,167, 16, 60,218,221,216, 65,242, 85,  3,
122,183,173,207, 15,121,152,243,160,121, 24,116, 93,128, 44, 48,  6, 82, 90, 38,
243, 12, 49, 44, 11,253, 71, 41, 70, 80, 74,196,243,245, 67,  6,130,131, 61,231,
201, 21,130,212,188,101,133,187,170, 98, 22,208,246,171,170, 98,152, 64, 41, 34,
151, 69,157,167,224,110, 60,223,  4,150,238,117, 19,236,144, 43, 45,108, 32,251,
116,234,132,139,199,153,124, 58,223, 38,236,144, 21, 26,120,229, 10, 10,  7,110,
118, 28,124, 86,175, 25,207, 19, 53, 33,143, 83,210,106, 98,192,162, 51,133,153,
151,129,152,198,118,136,245,164, 98, 78,  8, 99, 98,196, 80, 59,232,  6,135,152,
  2, 99, 95,217, 38, 87,233,124, 76,154, 14, 52, 51,233, 43, 58,168,174,118, 96,
 40,103,141, 74,159,215,162,141,198,134,137, 31,162,233,221, 86, 63, 82, 64,206,
 96,181, 64, 83, 64,  3,202, 97,156,193,171,106,  6, 38, 63,135, 41,  3, 72,  3,
183, 11,122, 17,196, 59,225, 32,  8, 30, 16, 25,140, 14, 28,224, 67, 68,244,208,
 64,  0, 25,105, 86,124,217,249,135,  6,121,  8, 43,254,202, 56,192,219, 10,  3,
 60,112,235,141,137,116, 15,112,120,103,248,129, 57,187,174, 77,153,115,166, 40,
 89,113,135,240,137, 15,227,202,131,149,130,132,173, 15,216,231,249,150,  1,232,
  6, 35, 39,118, 80,255,230,129, 84,127,126,154,213,227,210,199, 63, 20, 87,107,
234,191,128, 35,160,236, 18,146, 81,234,204,161,203, 39,111, 98,134,192,236,174,
 17,197, 75, 74,196, 49, 86,156, 93, 12, 93,235,154,164, 22,248,218,178, 52, 30,
 79, 62,240,105,135,144,  6,217,172,201,148,  5, 82,231,167,156,248,128,135, 98,
119,101, 73,117,131,106,198,231,234,234,136, 43, 79,200,208,198,225, 78, 70,121,
155, 79,201,196,160,207, 72, 97, 81,233,163, 37, 32,  7,147, 31,124,253, 29,157,
 72,185, 71, 21,189,198, 65, 25,183,243,251, 77, 55,242,111, 74, 70, 64,201,238,
164,200, 20,  3,252,182,128, 66,155,171,161,117, 68,211,108,126, 47,129, 32,144,
119,217,191, 86,140,162,  6, 35, 50,142, 50, 98, 21, 59,154, 62,142, 94, 87, 62,
 67, 24,241, 99, 76,118, 34,171, 77,110,152, 38,228,119, 54,149, 49, 62,147, 62,
162,199,217,  6,109,201, 67,123,176,200,215,173, 72,150,200,132,206,200,188,251,
 18, 91,176,  2, 78, 47, 32, 82,251, 36,110,199, 34,147,182, 82,213,227,169,130,
 33,219,224,147, 83,233, 17, 32,224,161, 69,174, 72,151,  3, 39, 13,144,198,162,
159,126, 43,136,231,101, 31,246,115,240, 80,227,138, 95,175,188, 82,239, 53, 26,
204, 75,164, 98,215, 45,104,  2, 23,135,225,123, 94, 82,133, 83, 28, 32, 19,146,
127,104,167,187,242, 60,221,255,208, 32,167,146,173,139,133,  4,157, 54,214, 30,
250,150,225,113,128,182,119,  3, 10,168, 46, 13,102,144,213,112,176,  4,211,194,
 89,255,184, 57,163, 52,111, 32,111,230,247,228,108, 83,129,146,249, 65,239,176,
127, 93, 50,119,158, 83,203, 97,152,128,214,180,154,155,125, 11,167, 43,172,129,
 28, 76, 65,171,232,  1,224, 76,200,154,193,230, 17, 97, 83, 47,228,204, 16,113,
 13, 14,216,  4,166,141,160,135, 83, 10, 68, 86,215, 14,169, 74, 87,201, 23,  0,
 95,241, 99,136,217,245, 72,187,151, 88,170,170, 35,254, 69, 50, 58, 64,210, 16,
157,129, 49,227, 23,  5,194,191,244,114,234,210,131,232,166, 34, 53,221,195,113,
204,169,223,  3, 54,150, 38, 22, 39,  9, 37,223,251,162, 84,169, 46,252,109,224,
 23,228, 84,211,177, 88,106, 89,118,114, 37,  4,119,  0,156,207,111,222, 70,180,
 41, 61,211,247,216,  9, 50,178,119, 76,139,  9,251,210,209,167, 38, 76,128, 90,
 43,229,132, 56,172,250,211,200,210, 99, 92,233,102, 34,  3, 94, 21, 29,113,209,
151, 86,197,248, 75,136, 55, 19,110,196, 84,250,184,166,158,238,250,216, 41,182,
159,170, 23,243,158, 25,103,119,102, 69, 73,148, 59,228,155,170,138,128,114,137,
 78,159,248,253, 99,243,250, 44,211,248,  5,200,242, 39, 36,166,128,131,156,237,
165, 16, 58, 41,122,210,142, 98, 65,224,216,218,225, 16,232,148, 48,159,206,133,
162,227,189, 26, 73,215,182,105,161,159, 56, 63, 10, 87,177,121, 94,126, 50, 48,
 44,222,224,251,245,216,173, 97,142,171,227,241, 85,135,191,247, 79,242,210, 63,
 26,124, 75, 52,149,110,126,198,146,134, 81,209,148, 51, 36,130,112, 14,145,193,
120,165,230,211,250,220, 32,151,106,162,105,233,114, 83,226,112, 27,153,177,152,
211,241,161, 41, 54, 16,  7,166, 34,160, 46,210,212,144,136,  5, 20,105, 60, 77,
105, 93,237, 60, 55,  7,133, 38,247,138,124, 39,157,235, 41,180,203, 13, 59, 97,
176,177, 26,179,166, 36,153,173,149,243,202,171, 81,174,100,139,104,103,120,113,
 39, 52, 48, 42,217,246,168,240,130,252, 65, 82,209, 74, 40,224,156,245,188,253,
 35,167,199,232,  5,249,213, 31,247,200,177,243, 57,200,192,122,210,142,133,109,
224,242, 26,180,229, 68,240,230, 62,  4,188, 28,138, 31, 48, 86,151,200,255, 10,
124,202,212,245, 60,111, 94,162, 51, 24,180,135,125,229,181, 21,110,172,147,249,
167,140,247, 87, 36, 38, 24, 10,177,246,107,131,107,143,212,140,  0,109,185, 84,
115, 98,137,184,206,  9,203, 37, 31,  7,226,228, 15,231,101,128, 96,151,162,  5,
213,130,228,139,114, 57,110,192,186, 58,140,165, 11, 72,242, 47, 65,200,249, 69,
 93,182,244,179,114,137,154,156, 36, 40,150,156, 90,202,229,143,193,103, 76,190,
 15,241,167,216, 87, 75,223,123,114,225,223,130,246, 92,235,149, 81,126,  8, 59,
 95,190,227, 72, 25, 27,227, 73, 22,225,250,213, 50,136,217,180,176, 68,239,157,
128, 82, 41,130,223, 98, 93, 55,160,158, 79,179,180,175, 32,188,  0, 41, 30,123,
208, 50,125,249,213,155,104,229,138,178, 69,220,124, 75,  4, 23, 53, 63,  9, 30,
180,124, 29,130,111,172, 58,228,245,136,240, 21, 40,238,134,240,105, 93,118,227,
  5,146, 68,247, 22,193,131, 55,124,195,164, 18,192, 78, 38,119, 99, 29,112, 43,
 97,227,236,197, 10, 98,  1, 57, 99,153,232, 12, 57, 37, 61,105,198, 54, 40, 11,
141,133,218,122,235, 64, 36,  1, 41,145, 49,254,177,214, 94, 78,  3,221, 36,106,
106, 29,113,144, 96,242, 51, 28, 56,112, 13,100, 51,217, 70,  0, 28,131,131,252,
 15, 70,238, 76,177,222, 54,237, 98,  2,134, 75, 37, 16,167,  9, 63, 22,223, 72,
217,111,193,139, 84,158,103,154,226, 80,117,178,155,209, 34,184, 18,184,202,244,
107, 28, 41,142, 47,186,234,211,146,236,138, 84,179,173, 65, 67,194, 81,  5,196,
 91,107,134, 83,225,113,  1, 98, 51,102,104, 43,137,249,227,  3,180, 32,160, 69,
 67,195, 60,195,114,177,141,180,137,241,251, 88, 52, 86,113,112, 56, 97,134, 86,
 25, 83,248, 58,133,121, 37, 51,185,138, 31,167, 23,249, 90,103,155, 73,225, 96,
241, 48,198, 46, 27,169,209,134,232, 10,114,202,197,234, 69,238,225,103, 39,151,
228,115, 26, 86, 30,198,152,217,242,222,123, 64,128, 72, 23, 43, 96, 76,118,111,
 47,120, 38, 14, 96, 19, 44, 85,128,138,123, 84, 14, 43,152,254,194,108, 50,198,
 83, 13,  1,149,144,126,177,193,135, 81,183,206,102, 14,121, 85, 96,150,188, 44,
 53,117,119, 81, 32,107,142,179,164, 44, 15,143, 98,204, 27,105,194,185,183,221,
  0, 74,241,216,104,251,224,173, 27,180,220, 47,144,151,180, 96,228,196, 55,104,
 33,241,131,109, 94,  2,254,211,179,170,123,197,120, 93,157,154,190,118,206, 18,
131, 26,140, 38,151, 85,252, 82, 73, 76,217,224, 26,  6,209,141,137, 22,205,144,
171, 39,126,131,187,180,177, 33,129, 70, 41,103,169,160, 30, 37, 57,128, 69,225,
161, 79,176,158,124,139, 84,201,  2,253, 12, 11, 19, 48, 81,199, 86,233, 15,201,
171,  8,216,118, 35,138,  7, 56, 23,251,184, 46, 16, 19,135, 63, 22, 80, 10, 77,
191,124,  1,221, 30,165,106,207,225,109,121,112,102,119, 21, 31,228,114,124,122,
162,121,137,139, 92, 33,227,127,217, 52, 90,148, 67,242,175,236, 53,215,113, 58,
121,185,224,235,114,239, 49,204,120, 91, 24,184,141,193,215,103,235,163, 36,166,
220, 75, 71, 92, 21,225,105, 45,124,194,216, 38,  8, 62, 36,117,196,237, 96,178,
227, 39, 29,147, 35, 19, 69,103,148,249, 98,115, 66,228,141,184, 87,  2,138,153,
 93,104, 59,234,215,174, 60,219,  0,129, 97, 35,189,149,201, 79,250,254,147, 10,
127,119,141,188,241,120,109, 19,199,214,171, 10,137, 86, 57,207,188,133,176, 45,
  6, 19, 96,197,160, 96, 17, 98, 40,153, 66,246,129,181,153, 61,101, 68,163,137,
 36,132,128,206,237,182,137,254, 11,156, 50,230, 23,149,105,  3,153, 59, 60,250,
 88, 19,205,138, 68,  9,182,148,212, 50, 78,204,193, 42,209, 73, 11,250, 11, 88,
238,183,142, 11,204,143, 46,140,102,108, 72, 90, 42,158, 71, 94, 12,  2, 97,160,
121,133, 42,106,115,130,117,160,186, 38,100,249,253,  1,155,192,187,147, 40,238,
194,181,205, 66, 27, 68,235,233, 78, 94, 40, 37, 17, 96,209,  0,175,247,113,111,
 30, 61,197, 12, 62,228,185,206, 13,178,160,180,235, 46,151,162,196,145,107, 62,
234,174, 20, 33, 71, 53,153, 88,247,200,210,164, 51, 59, 59,254,160, 76,118, 48,
 23, 97,130,161,154, 99,182,233,154, 64,252,189,151,108,130,100, 52, 40, 69,112,
  9, 13,  2,197, 58,195, 73, 66, 80, 22,146,181,139,236,254,148,192, 55,197, 28,
107, 97,158,220,192, 96,135,138,177,225,172, 46,236,180,  7, 38, 25,211,161,234,
 64,105, 91, 63, 10,144,250,231, 98,131,223, 82,117, 82,  4,147,220,106, 77,174,
 59, 98,149, 22, 96, 68,  1, 37, 58,232,134,189, 72,141, 19, 79,176, 35,220, 65,
 61,223, 81, 49, 34,162,126, 46, 36, 99, 87,228,253,188, 79,162, 70,244,254, 46,
124,125, 30,119,108,201,119,114,178, 44,169,  9, 45,170, 99,138,  7, 61,  9,240,
  8,100,160,169,  8, 20,158,230,102, 79,  7,174,191,197, 38,164, 54,181,169, 57,
210, 37, 45, 14, 21, 46, 37,141, 98, 56, 27,150,183,237, 44, 87, 27, 83,  4,111,
192,229, 77,213,212,137,142, 92, 64,161,163, 88, 94,248,154,117, 44,149,149,118,
179, 83, 47,100,255, 56,172,131, 73, 40,194,127, 88,176,125,245,  0,  6,188,144,
192,211,138, 20,174, 65, 84,118,197,176,  6, 30,135,199, 56,128, 57, 98,213,140,
248, 90, 10,141, 24,  0, 10,237, 33, 35,178, 38,156,227, 73,178,144, 40, 28,155,
 97, 51, 26, 19, 37, 55,  2, 23, 15,252, 36,206,128,170, 26, 92,142, 73,124, 42,
141,222,115,218,171,240,149,238, 54, 83,232,175, 58,130,213, 52, 52,101,  1, 59,
  1,138,251,157,192,109, 28, 28, 86,223, 43, 76,126,119,234,  0, 33,207, 97,169,
225,179,253, 39,159, 82, 49, 20,  2,165, 72,128, 37,  3, 53,167, 12,138,210,220,
134,103,128,241,145,250,170, 23, 47,168, 30,249, 43,221,213,  9,160,153, 97,138,
121, 65,181, 14, 72,  8,178,226, 74,124, 10,237,161,225,170,212, 87, 99,  8, 97,
 95,183,241, 50, 22, 41,151,172,114,131, 10,134,153,133,233,100,193,164, 84, 14,
 82, 78, 25,242, 74,  1, 14,136, 68, 39,153, 12,229,118,243, 16,  2, 83,206,178,
 78, 23,170,228, 36, 87,125, 87, 24,145,160, 99, 75,126,139,247, 69, 48, 68,204,
 74,166,156,222,190,240, 34,106,105,111,182,219,247, 95, 95,105,112, 91,236,137,
  4,201,160,172, 83,237, 35,160, 12,  2, 88,252,189,  3, 79, 13,125,173,  7, 12,
129,179, 96,157,154,117,140,254, 12, 41, 49,161, 88,124,104, 91,153,123,187,157,
196,217,190, 54, 39,146,168, 73,118,238, 12,175,187, 10,168,210,163,254,178,  8,
 19,193,168,179, 63, 73,169, 43,  1, 64, 44, 40, 49,129,222,225,126, 93, 73,107,
 15, 65, 29,  7,240, 38,172,  8, 24,102, 62,164,181, 53, 82, 29,132,191,218, 10,
114,172,249, 88,167,164,122,180,160,223, 15,146,165, 31, 31,168,253,115, 78,  3,
  2, 87,195,115, 11, 63,220,174, 73,180,231,173, 62,167, 84, 64, 40,166, 68,150,
195, 11,243,246,121, 34,209,132,181, 17,196, 88,  9,117,119, 76,147, 58,188,116,
102,179,169,175,199, 16,214,112,165,175,197, 66, 14, 52,182,211,116, 98,173,218,
 73, 45,153, 88, 40, 48, 82,105,237,153,181,  4, 73, 51,253, 20, 82,150,249,131,
186,203, 42,216, 97,165, 49, 60,116, 92,131, 78, 12, 57,207,194, 89,175,168,122,
 51,226, 30,237,140,193,156,  6,209,209,141, 48,185,132,245, 69,242,201,162, 38,
112,229,147, 66,227, 97,194, 89, 50,160,193,145, 16, 40,146,229,184, 20, 14,234,
111, 13,  5, 98, 55,229, 61,252,195,137,132,168, 89, 50,241,204, 11, 76,169,235,
251, 80, 34,139, 73,175,192,132,164,242, 79, 18,179,193,146,248,182, 28,105,113,
167,253, 77,238, 32, 87,135,209,114,206, 74, 46,238,175,234,111, 27, 14,254,185,
 13,216,244, 44, 50, 94,222,104,101, 79, 86, 70,187,137, 14, 76,138, 64, 19,105,
147,215, 30, 13, 60,  9,130, 40, 58,116, 99,197, 34,255, 95,128,110,106,177, 71,
111, 77, 89,102, 65, 59,  8, 58,  2,128,117, 49,224,217,145,170,183,182,246, 56,
 48, 51,253,149, 29, 63,  3,170, 87, 44,248,191, 97, 88,130,120, 41,242,137, 89,
 83,107, 47,206,  2,237, 53,166,160, 86,156,186, 32,170,226, 22, 23,228, 76, 86,
205,148,129,255,119, 49,193,126, 36,107,122, 27, 65,211, 20,184, 40, 85,  4, 49,
 54,234, 24,228,194,171, 45,108,246,190,210,151,219,184,149, 23, 46, 42,  0,223,
 33,241,129, 66,186, 12,105,232,164,  4,232,180,229,117,103,  3,144, 78,131,185,
188, 45, 13,190, 96,170, 90,209,213,170,132,167,  5,252,123, 54, 49,252, 38,136,
 65,212, 28,166, 51, 87,180,144,  3,205,106, 93, 33,180, 22,106,167, 21,213,117,
 83, 50, 12, 82,255,157,  6, 93,222,213,203, 16,198, 17,243,236,106,172,182, 34,
 57,178, 83, 45,174,176,235,158, 51, 53,142, 99, 63,214, 18,204,152,199,174,231,
 48,234, 80,232,  9,227,232, 53,227,114, 81,134,128,154,117, 77, 13, 68,179,107,
245, 43,122, 67,114,153, 11, 34,181, 85, 90,237, 64,186, 74,122, 11,152,102, 27,
229, 81,143, 46, 19, 35, 31, 27,100,179,147,109, 67, 44, 39,183,138, 15,194,132,
 46, 92,152,180, 24,142, 83,127, 90,  0, 74,124, 60,193,153,236, 48,  4, 80,188,
148, 89, 72,229,193, 61, 86, 35,177,178,148, 61,219,109,136,236,254, 83,201,143,
212, 30,141,244,192,168, 61,150,  3, 23,250,132,251,105,198, 10, 62, 95,103,254,
 38,250, 89,204,244,216,181,218,229, 49,239, 49,145,127, 52, 83, 62,182,156, 74,
204, 56,212,234,137,133,252,154,165,120,226,116,223,200, 12, 25, 22, 39, 52, 14,
 62, 85, 16,218,121,135,  8, 46, 39, 97,195,175,212,193,  0, 67,152,  5, 27, 78,
 72,117,  6,120, 47,156,142,127,209,121, 69,159,235, 93, 20, 17,238,103,202, 58,
 14, 14,181, 22,135,226, 71, 85, 10,137, 51, 19,160, 18, 67,159,244, 66, 82,178,
 37, 27,102,130, 11, 24, 84, 18,232, 49,249,184,110,244,122,229,186, 92, 65,137,
 54, 43, 65,182, 28, 68,186,163,200,247,214, 30, 65,156,175,253,118,181, 25,  1,
 66,147,228, 71, 46,102, 73,160,216,102, 80,239, 53, 83,130,242,193,162, 60,210,
191,150,241, 76, 53,178,127,186,134,110,218,107,  6,160,  5,218, 75,203,244, 94,
153,170,189,164,244, 21,232,225, 11,221,225,168, 55, 69,201,117,131,225,  9,219,
 73, 78,213,227, 76,  0,162,116,240,108, 86,125, 12, 59,242,130,148, 96,226, 54,
 39, 27, 64,183,205,163,198,248,187, 90, 42, 83, 86,240, 86,253,180, 99, 33,146,
 96,  6,112, 44,106,179,229, 94,221, 31, 48,111,194,163, 94,211,100,136,195, 37,
 37,242,112,249,229,196, 52,137, 46,  2,138,117, 84,100,151,144,227,117,107, 87,
107,101, 84, 29,124,185,235,127,178,223,242, 73, 39, 52,132,  1,238,133, 53,209,
232,143,130,200, 31,  7, 78, 80,  6,133,224,114,230,192,111, 64, 20,105, 46,113,
199, 18, 85, 69,178,254,129,148,108,245, 59,117,249,116, 29,236,110, 72,175, 77,
158,134, 39, 89, 19,212, 94, 36, 40, 80,202, 82, 39,236,133,230,123,205, 26,216,
  7,236, 97,241, 19, 35, 21, 53, 53,186,159,125,106,217,208,176,130,114,224,201,
 39,180,131,108, 37,160, 85, 52,  2, 26, 42,  5,148,229,104, 58, 79, 97, 53, 27,
 38,203, 70,194,212, 47,182,205,146,231,202, 27,165,160, 67, 79, 36,132,117,203,
119, 24, 18,122,151,179, 61,147,164, 50,  3, 72,226, 19, 96,  1,  0,252, 54, 28,
  2, 99,233, 13,124, 17,176,250, 84,131,201,153, 90,202, 39,106, 42,134,134,237,
 97, 45,  1,200,133,249,171, 98,227, 11,190,108,195,186,128,212,191, 90,104,105,
110, 15,182, 22, 26,135, 97,239, 91,184,193,117,164,130,228, 32, 26,216,244, 34,
176,193,251,134, 58, 62,  3,245,233,115,128, 61,203,111,240, 44, 16,233,198, 14,
169,178, 20,166, 28, 83,246,253, 97,166, 93,178,250,173,  1,120,201,246,219,173,
 68, 88,227,128,237, 50,120,  8, 87, 20,244,160, 26,191, 20, 12, 16, 74,149,226,
 80,177,  1,130,218,225, 50,  1,156,131,124,112,214,196,222,107,177, 80,119,102,
  2, 23,146, 12, 37, 67,151,119,161,167,130, 89,108,172, 37,247,228, 50, 42, 88,
 54,116,160,255,129,189, 77,137,165, 61,218, 37,166,181,195, 54,156, 69, 17, 84,
  4,238,206,223, 95,  1,208,131, 87, 58,169,199,164,123, 76,232,  3, 41, 11,149,
151, 92,135,120,150,  7,159, 10, 53, 16,  6,151,247, 42,124, 31,221, 71,179,  7,
 67,137, 46,213, 64, 95,104,164,229,254,109,250, 21,232,202,105, 57,244, 93,174,
245,195,212,247, 45, 25,142, 49,236,101,135, 67,129, 94,109,200,236,227,130, 95,
 65,204,233,116,246,140, 22, 79,128, 34,231, 82,145,228,173,134,  6, 59, 48, 76,
 51,  5,228,  5,129,114,196,162, 31,  3,225,224,194,244, 81, 67,242,154,245, 21,
199,222, 43, 76, 68, 11, 57, 67, 36,144, 40,243, 66, 58,161,253,132,192, 71,227,
225,195,  8,203, 22,104,222, 18,173,144, 45,200,152, 94, 65, 46,192,254,182,178,
 26,181,248, 33,237, 29,248,161,  2,196,108,215,127,178, 67, 21, 21,146,222,190,
156,205,185, 93,239,107, 62,103, 19, 60, 47, 50,218,115,184,115,118,  9,  2, 75,
 74, 43,255, 95, 68,221,201, 11,  1,241,116, 99, 28, 39,177, 26,162,137,175,161,
 62,181,171, 94, 45,209, 14, 61,254, 29,124, 82,225, 71, 89, 94,253,213,144, 90,
  2, 95,128,153, 71,218, 68,175,  5, 81,216,217,178,137,  6,194, 63,  7,  2,178,
118,141, 16, 43, 97,242,164, 21,166, 13,155, 88,171,145,227, 42,218,114, 16,195,
 85,252,193,167, 50, 94, 68,195,  5,193,219, 69,179, 88,250, 78,231, 99,212,194,
154, 90,129, 16,210,115,135, 20, 76, 76, 62, 44,117, 45,212,213,175,124,166,246,
183,216,176,136, 95,105, 79, 47, 40, 66,140, 37,135,198, 90, 30, 38,133,130,179,
157,237,  8,153,131,224,105,185,130,229,226,206,152, 10, 14,162, 51, 47, 64,141,
106,  2,223,154,145,147,248, 78,232, 18, 22, 22, 37,243,  8, 21, 18,201,231, 27,
130, 10,251,154, 38, 49, 27,143,217,229,203,  1,246, 77, 94,130, 35,221,102,221,
165,134, 17, 80,148,163,215,229,235, 75,144,  6, 69,174,228,106, 55,106,254,107,
 95, 69, 60,177,197, 87,218,135,242, 41, 53, 93,147,188,128,205,214,188, 77, 86,
147,161,251,173,191, 87,235, 11, 79,143,148, 77,252, 71,106,204,228,246,244,255,
 33, 69,148,205, 73, 35,209, 50,  9,179, 10,113, 47,215,225, 82,173,176, 51,112,
180, 36, 34, 96,118, 58,162, 72,127, 77,147, 21, 32,116, 75,136, 12,155,186,111,
236,168, 62,132,120,212, 77, 30,194, 48,198, 69,192,  6,198,233,173,142,203, 37,
149,219, 59,224,122,207,  4,255, 81, 41, 54,178, 23,189, 19, 96, 75,123, 22, 88,
 39,139,100, 29,218,  0,159, 37, 61,156, 49,164,185,224,109, 88, 77, 17,  1, 69,
 85,198,131,200, 24,248, 82, 86,157,126, 32, 95, 29,158,202,146,164,230, 52,131,
 24, 46,  8,124,207,104,119, 94,193,198,151,110, 80,  2, 53,253, 75, 48,196, 56,
 27,135, 14,204, 35, 71, 13,245,249,231,212,195,206,161, 11, 80, 65, 83, 30,226,
222,255, 93,230, 68,191,120,217,  5,116,156,154,224,122, 54,180,  0,224, 29, 28,
 49,157,191,105,249,230,117, 28, 21, 96, 99,138,185,224,157,219,122,  5, 17, 22,
 25,226,173, 94,224, 73,241, 24,206,  8,211,102, 18,113,221,230, 66, 41,132,126,
 59,217, 56,213,  0, 36, 84, 37,144,236,149,112,171,165,226,244,147,229,106,242,
185, 75,162,167,100, 44,  1,145,  2, 25,  0, 70,195,254,151, 59,199,245,251,190,
169, 35, 21, 50,237,  0,100,231,177,254,117, 48, 62,194, 98,231, 19, 25,121,172,
 66,236,101, 49,143, 23,197, 81,204,239,178,215,128,168,211,108,137, 63, 38, 52,
103,199,195, 88,247, 84,119, 28,191,182,137,152,147,225, 64,241,167,140,209,  7,
232,135,193,165,112, 76, 25,226,254,191,119,199, 93, 57,  0,230, 45,144,247, 24,
 52,199,246,246, 84,179,131,219, 14, 61,136,118,191,107,175, 58,103,137,182, 53,
110, 79, 45,165,151,171,209,111,102,251, 88, 83,140,235,217,187, 38,217,252,183,
255,157,233,208,  6, 24,219,173,150,212,198,149,244, 79,188,254,161,105,214,247,
171,186, 67,192, 84,223,203,187,114,247, 89,216,198,225,193, 76, 89,191,158,128,
 66, 33,178,220, 35,  9,226,135, 11, 25, 12, 43, 26,215,163,163, 58,202, 36,213,
225, 95, 16,  1,229,219,122,128,234, 65, 60, 32, 85, 56,245,121,233,171,162, 53,
167,166, 94, 73,176, 51, 66, 27, 49,219, 28,183,169,  7,116, 38, 95, 39, 58, 49,
222, 29,  1, 93, 76, 86,236,196,128, 38,201, 99,233,160,174,168, 70, 12,212,130,
 68,154,122,252,230,  3,106,202,183, 57,190,195,213, 95, 21,211, 75, 83,128,189,
 96, 90,166,147, 35,229,123, 15,115,241, 39, 72,252,210,  1, 79,109,238,165, 97,
 67, 90,254,246,223,120,221,127,152,248,255,134,218,110,211,185,137,171, 75,151,
 44,227,214,130,124,218,209, 71,178,133, 64,253, 53,128,163,  3,179,152, 72,123,
138, 42,180, 35, 17,180, 63, 77, 52, 19, 16, 99,195,145, 16,253,152,  8,217,218,
 68, 75,192,121,186,214, 28,193,109,109,204,205,185, 31,197, 28, 68,184, 26, 90,
 12,224,234, 56,203,  0, 70, 83,251, 63, 84, 29,225,231,148, 81,188,102, 89, 71,
149, 45, 92, 36,202, 46,185,114,218, 80,180,241, 72, 50,250,162,141,191, 36,104,
132,139,209, 68, 63,147,  1,  1,231, 24, 11,140, 18,223, 21,184,228,176,219, 94,
 55, 51, 93,152,210, 19, 30,227,172,231,132, 71, 31,100, 92,215,  7, 44, 23, 19,
241,119, 18, 77,137, 89,253,178,252, 74,168, 99,214,244,125, 25,199,130, 93,190,
147, 90,193,180,181,236,102,106,  6,163,157, 25,174,199, 24,225,204, 14, 48,  5,
143,105, 41, 80,182, 84,218, 61,160, 20,  1,133, 85,218,134,100,252,160, 96,116,
234,163, 57,195, 86, 11,123, 45, 96,253,144,214, 39, 17, 81, 39, 96,104, 24,156,
103,199,134, 57, 29, 19, 63,132, 49,131,117,  5, 34,  5,127,110, 20,197,  9,185,
175, 23, 60,235, 34, 95,156,136,188, 47,253, 81,202, 93,118,116,209,202,221,111,
128,223,178, 46,163,131,234,218,130,  4,173, 58, 13,103,107,238, 36,188,203,150,
125,104,229,226,218, 32,229, 70, 99,195, 95,124,251,  3,148, 99, 30, 29,150,104,
 91,115, 72,207, 92,247,225,244,174,189,193,103,138,147, 45,109, 25,183, 20,115,
109,199, 15,217,250, 89,  3, 48, 45,190,109, 56,  8,204, 14,  4, 48,203,123,217,
249,158,195, 50,199,249,  9,  6,193,177, 60,231,150,132, 55, 13,108,218,  6,217,
 81, 45,229, 27,139, 69,220,171,239,103, 48, 99,200,255,153, 94, 11, 35,216,101,
 65,214,217,143,254, 88,  8,205,255,246, 22,137, 17, 19, 21,  0,173,105,141,  0,
  1, 63,246, 45,226,244,239,197,170,214,247,177,105, 24, 64,246,218,129, 97,143,
197,223,134,207, 21,111,151, 26,192,176,211,119,230, 27, 45,177,254, 79, 50,208,
229,235, 91,151,116, 62,136,154,107,142,128,112,133,246,136,126, 90, 19,186,  9,
150,118, 38, 88,121,184,  3,151, 51,207,  4, 67, 58,  5,120, 56,215,160,156,254,
158, 76, 27,235,188,142,200,  0,153,233, 94, 70,132,255, 40, 35, 61, 76,115,122,
 57,226,  7,181, 74,140,201,165, 43,108,241,224,222, 40,101,  2,255, 19, 16,124,
  4, 71,250,168,188, 34,161,203,  3,246, 71,253, 37,184,130,  0,228,227,134, 35,
185,228,130, 14,150,122,168,133,119, 49, 91,160,206,153,198,113,148, 16,159,203,
177, 29, 54,152, 29,115,128,212,  6,199,110, 75,144,242,207, 69,  5, 12, 65,250,
 16, 75,  8,230,215,127,137, 18,  2,175,201,213,101,249,176,168, 46,192,144,218,
 44,  6,246, 25,240,141, 81, 40,126, 31,106,215, 46,177,216,206,158, 76, 24,113,
187, 77, 85, 40,187,170, 55,195,144, 37,186,218,203, 17,142,200,113,235, 18, 70,
119,105, 99,195,202,229, 51,104,102, 67, 73,  5,135,164, 23,204, 54,  3, 72,213,
186,205,108,169, 53,234, 22, 67, 48,144, 95, 19, 81,176,142, 26,205,132,112,124,
201,134, 89, 25,119,211, 16,186, 65,145,112,131,156,171,194, 77,192, 17,146,157,
113, 58,131, 39,120, 73,198,205,155,151,  7,216, 70, 97,210, 23,219,167,111,135,
100,117,205,194,169,161,  2, 48,206,230,255,215,117, 45,169, 10,231,194, 74, 45,
 74, 10, 69,211, 38, 51,144,102,118,  2,243, 70, 51,226,173, 56, 45,222, 37,192,
215,127, 19,188, 36,239, 51, 67, 26,  1, 19, 56, 65, 44,220, 19,173, 48,113,202,
  3,150,116, 35,225,125, 43,  1,173,158, 35,200, 67,152, 90,135, 75, 14, 97,177,
200,235,155, 70,179,  2,115,253,157,178,200,251,169,220,218,  1, 13,196, 98,  0,
102,146, 58, 24, 32,123,  3,139,105, 84,104, 75,244,162,233, 37,158, 11,241,212,
 22, 53,136, 18,  0, 26,128, 21, 51,  0, 51,  0, 50,  0, 71,214, 89, 35,  9,146,
232,227,148,254, 98, 58,111,123,239,189,247, 95,187, 87, 34, 23,195, 91,125,100,
157, 53,146, 32,137, 62,218, 21,171,233,145, 42, 92,224,191, 14,123,184,255,255,
 40,138,162,188, 13,237,123,101, 40, 14, 76,180, 91, 47,236,191,182,223, 76,218,
117, 79,179,220,216,251, 21, 44,195,143, 99, 89, 95, 12,150, 53,146,244, 23,246,
190, 24,222, 98, 89,103,141, 36, 72,162, 15, 46, 60,198,155,235, 92,193,169,220,
 27, 37, 91,170, 43, 25,  4,248,238, 84,173,176,242,202,240,251, 47, 96,184, 56,
 93,189,214,200, 58,107, 36,249,225,190,242,219,237,123,146, 50,230,193,183,227,
251,127,127,251,182,127,120,147,174,173,225, 24,179,119,154, 14,187,235, 78,211,
 36, 81,243, 90,123,239,239,208, 54,235,117,245,186,174,187,155,169,222,239,186,
187, 44, 11,213, 92, 45,218,156,152, 28,236, 62,145,109,  8,143, 99,132,218,168,
195, 93,179,102, 89,  3, 35, 53, 17,  8,  6,134, 70,130,241, 72,146, 67,187, 90,
218,  3, 83, 64, 81,  8, 33, 40, 10,137,  2, 65, 32, 18,  8, 12,  2,  1, 65, 32,
132,133, 32,  8,131, 32,  8,  1, 68,128, 80,  8,133,144, 12, 66,113, 12,150,126,
 65,195, 36,170,105, 72, 39,142,226,209, 45, 11,232,120,188, 44,201,202, 32,134,
195,193,125,157,179,157, 99, 41,209, 47,169,215, 41,224, 90, 98,169, 79, 74,126,
205, 61, 12,226,179,145, 58,121, 13,243,190,158, 53,246, 50, 25,  7,199,  1, 30,
 39, 53,171, 19,244,206,126, 37,  0,118, 50, 66, 26,171, 23,  5, 69,154, 24,163,
243,189,218,118,179,200,124,194,210,  2, 27,186,123,161, 41,225, 32, 63, 67, 72,
 10, 52,150,  8,183,129,  7, 86, 94,159,199,172,202,107,189, 98,225,136,250,207,
 44,193,215, 57,201,  8, 10,118,241, 14,240, 49,158,175,134, 54,141,  5,158,245,
194,149, 35,222,235,179, 37,189,140,205,181,213,192, 68, 89,183,156, 10,178,  6,
 90, 44, 36, 41, 37, 70,214, 92,206, 18,127,138, 52,233,128,215, 33, 59,224, 66,
 62,184,193, 66,204, 34,213, 36,153,  4, 10, 64,254,132,172, 28,200, 18, 84, 10,
169,  2, 86, 38, 38,203,179,200,192, 66,200, 80, 69, 49, 10,100,112, 32, 34,172,
160, 56,  2,171,111, 99, 26,208, 21,174,141,205,255,100,218, 73,114, 97, 75,233,
 76,234,255, 19,229,206,  2,134,252,183,206, 59,136,201, 48,110,239,160,133, 33,
105, 51, 28,115,233, 45, 11,130, 74,232,245,161, 56, 56,175,116,112,163, 14,245,
158,214,133,148, 24,185,174,149,177,  2,176,177,224,145,130,183, 29,123,241, 25,
 65,166, 61, 14,248,111, 99,115, 55, 79, 73, 31, 36,164,161, 69,184,245,176, 58,
241,163,120,146, 76,190,152,193,214, 80,139, 90, 55,169,147,134, 24,  2,124, 44,
 68, 57, 65, 16, 84,  4,125,109,106,  8,150,103,216,171, 79, 97,144,134, 22, 50,
123, 81, 51, 55, 65, 73, 30,133, 26,120, 26,184,224, 35,138, 16,184, 26,106, 31,
 32, 42,140, 40,176, 70, 43,151, 87,105,213,103, 42,173,118, 26, 23,120, 40,186,
194,107,219,150,237,166, 60,137,100,200,246,208,249,202,235, 91,242,210, 77,198,
 31,211,206,234,124, 19,241,120, 98, 16, 34, 68, 47, 44,217,140,167, 24, 57,209,
160, 65, 14, 13,  4, 78,229, 72, 79, 33,204, 81,177,155, 13, 69,203, 58, 45,227,
 47, 36,119,191,118,183,253,231, 22,  5,166, 88,169,110,111, 90,241, 81, 72,169,
 72,194, 91, 48, 64,144, 79, 34, 60,183, 44, 45,165,116,196,250, 18, 77, 42,150,
 63, 72,117,245,  3, 66, 58, 32,166,134, 21, 91,255,150,202,196,115, 86,  5,148,
 64,156, 78, 25, 61,223, 61, 46,106, 93, 24, 84,160,176,144, 16, 74,224,107,152,
 33,185,250,151, 27, 22,200, 28,213,253, 96,193, 84,222, 62,152,132, 79, 43, 24,
 29,254,195,232,206, 78, 67,132, 22,123,119,203, 51,106,114,235,211, 97,208,239,
135, 70,122,214,247, 47, 83, 54,239,215,209,163,142,214,115,193,171, 66,163, 67,
151, 78, 40,211,149, 30, 55,167,222,166,106,184,226, 64,206,157,231,123, 45,236,
220,  1,228,137,116,225, 71,126,192,115, 17,253,112,  9,235, 16,241,126, 93,212,
 15,194,231, 80, 10, 66,118, 38,  1, 48,226,132,212,241,221,217,104,233,213,230,
153,152, 59,183,229, 15, 96, 31, 10, 39, 93,170,244,192, 91,209,133, 29,208, 85,
 25,  2,253, 55,197,176,226,186,120, 20,162,173, 32, 23,195,172,110, 77,253,  0,
 14, 44,177, 37,  6,108,172,103,255,118, 17,224,152,185,192,187,208,133,224,254,
220, 99,116,180,204,248, 92, 24, 15,203,184,175,196,  2,253,194,206,224, 59,106,
208, 83, 34, 80,193,141, 91,188, 80,161,248, 74,  8,  0,131,100,122,199,224,211,
238,154,142, 37,222,197,247,149,151,161, 27,141,150, 90,176,247,168,129,112, 27,
 13,248, 76, 30, 49,121,171,249,203,185,221,163,187,150,207,141,178,174,156,135,
125,168,232,  3,125,172,106, 97,  6,233,102, 45, 69,229, 97, 13, 78, 36,104, 68,
  3,240, 74, 76, 96,103, 76, 43,175,198,222, 46,178,230,192, 73, 40, 26, 84,113,
111, 14, 99,143,  2, 37,158, 56, 72,252,203, 54,232, 15, 75, 53,  6,193,133,132,
 78,145,230, 76, 85, 49,  9,216,216,216, 36,248,125,113,248, 40, 63,143,216,165,
177,233,214,106,171,195,214,168, 67, 51,113,197,207,166,201, 79,110,182, 94, 45,
209,132,234, 48,146,160,228, 24, 40,187, 24, 70,255, 96,159,241,208, 43,132, 80,
 18,  9,  4,141,210,210, 43, 91, 92,166,222,170,217, 41, 70,229,141,125,  2, 43,
217, 83,209,254,  8,242, 10, 78, 64, 71, 12,136,148,  4, 36,161, 19,  2,241,  5,
156, 37,220, 84, 32,135,131,181,  4,130,  2,122, 14,221,146, 20, 86, 33,151,140,
  1,225, 63,249,137, 80,  8,187, 36,  0,226,127, 55, 31,253, 56,228,  6, 12, 26,
 74, 65,192,138, 25, 61, 41, 33,  0, 84, 14,131,  1,229, 97,162,251,246, 99,224,
 79,139, 52, 64,218, 52, 62,192, 19, 58, 63,131, 68, 21, 80,166,232, 76,  3,129,
  4,102,130,  7,178, 50, 84,174, 65, 11, 45,224, 76,163,183, 65,243, 20,128,166,
 71,229,140,144,230, 13,186, 27,194,199,177,184,124, 24,228,116,174,124, 80,228,
 84,234, 63, 68,114,180, 46, 62, 96,114, 30,150, 15,159, 28, 85,253, 15,166,156,
 91,203,135, 86,206,175,242,129,150,179, 84,255, 97,151,115,107,249, 32,204,249,
171,124, 72,230,172,234, 63, 64,115,182, 43,196,226,195, 53,167,174,130,203,  5,
111, 14,208, 25, 65,242,168,152,202,183,151, 62, 83,161,181,112,109, 42,217,233,
149,142, 64,144,233,152, 30,162,206, 63, 94, 45,165,136,106, 45,211, 54,166,100,
135,106, 25,178,115,116,123,187, 73,126, 17,174, 69,181,248,123,202,142, 95,235,
228,193,178,113,230, 18,123, 71,109,138,  2,127,137, 18, 92,222,252,242,174,204,
212, 48, 67, 17, 77, 80, 66,  9,204, 26, 40,150, 70,159,128,115,208,155, 57,153,
198, 57,250, 52, 59, 11,161, 35,110, 87,126,216, 38,127,238,226, 27,188, 85, 98,
 94,104,148,184,170,104, 49,206, 35,194,111, 98,185,243,189, 81,133,  3,142,224,
 13, 56,131,175,220, 74,133, 70,125,163,  4, 50,220,188,244,201, 64, 96,189, 50,
151, 79,110,185, 15, 13, 31, 26, 68, 82,153, 29, 97,165,136, 92,108, 82, 52,209,
 13, 41, 82, 73, 19,142,171,128,160, 79,159,233,168,  0,211,198, 47, 82, 14, 67,
  4, 31,172, 43,177, 42, 41,178,143, 77, 62, 82,124, 64,178,175, 44, 95,252,226,
179,246, 36,219, 10, 78,107, 33, 16,116, 52,171,189,209,252,224, 94,145,241, 69,
204, 83,235,157,218,147,190,124,222, 93, 30,213,234,166,180, 73, 47,224,131,101,
 90,244,158,183, 32,239, 39,246,186,184,124,251, 16,176,242, 99, 73, 91,213, 26,
 74, 64, 30,146,220, 72,145,145, 25,180, 33,141, 36, 27,168,196, 30, 42, 50,116,
145,122, 14,156,170,216, 71,126, 24,163,180,102,248,168, 71, 42,113, 35, 18,250,
242,219, 61,249,  5, 98, 48,215,215, 96, 15,166, 19,218,171, 29,174,247,154, 19,
 36,173, 54, 11,  2,184,117,249,145,252,233,188,223,162,  0,163, 49,169, 84, 27,
191,223,120,121,  0, 96,133,222, 31,123, 43,117,154,241, 10,141, 64,199, 23, 87,
178,224,108,224, 22, 59,209,162, 22, 28,127, 47,114, 95,234, 46,  3, 23,138,249,
 59,139, 83, 76, 53,101,236,130,252,224, 45,174, 30,153,124, 33,109,208, 22, 70,
 11, 84, 48,220, 29,172, 69,157,  7,134,130, 24,242,104,144, 22,140,121,122,129,
234,109,234,244, 66, 25, 26,  2,157,112,106,195, 69, 51,160,  2,129,231, 84, 72,
  3, 26,244,127, 68,118, 42, 60, 99, 26, 74,251, 94,216,242,212,228,128, 53,136,
 29, 95,192,160,217,193, 87,234,168,124,170,200,164, 59,103, 13,222, 83,221,240,
129,  4,  0,244, 17,111,  9,113,216,207,107,252,229,223, 35,102,131, 90, 55, 53,
 64,244,136,112,240, 12,124,166, 97,219, 92, 16,143, 44,  2,107,204,160, 25,189,
 59,  2, 27,120, 25, 17,129,228, 63,228, 21, 95,248, 12, 20, 17,129, 95,130, 86,
232, 12,155,  6, 54,142,160, 20, 54, 99,140,200,198,253,151, 32,120, 33, 51,  4,
 21,169,193,151, 57,164,  7, 39,218,138,  3,  3,128, 65, 32,  7,115, 86,  0, 40,
208, 93,245,128,126, 70,254,129, 53,208,205,250, 41,202, 30, 80,135, 43,140,240,
254, 72, 44,127, 66,151,150,129,128, 30,201,142, 17,186, 33, 96, 41, 52,134,121,
182, 28, 18,112,118, 32, 33,220, 15, 52,213,194, 19,144,164,146,199, 82,133, 80,
 74,195, 30,136,245, 23, 46, 83,141, 44,226,150,133,115,170,182, 93,116, 70,113,
218,187,252, 83, 61, 14,213,184,196, 35,176, 57, 68, 84,205, 25,114, 70,181,142,
128, 87,178, 84, 45, 58,122,  6, 58,152,124,133,160, 60,114,134, 41, 22,148,170,
 34,143,154, 49, 14,108,227, 48, 66, 80,122,196, 12,209,193,234, 23,189, 63,222,
 95, 36,190, 46,222, 97,184, 69, 82,251,133,135,199, 16, 52,206,157,155, 13,185,
106,107,168, 70,191, 21,185,205, 83, 72, 30, 80,199,238, 93,131,163,134, 72,160,
 55, 49, 76, 97, 95, 94, 38,122,  8, 74,104,236, 89,108, 34,117, 71,  5,  7,167,
166,209, 50,126,213,189,164, 36,  4,157, 32, 39,203,181,237, 98,220,218,  7, 35,
137, 31,108,210,  0, 99,  1,144, 85,113, 54,171,162,  1, 24,170, 95,125, 97,141,
 93, 10,134, 32,129, 24,  6, 39,162,195,137,135, 49, 56, 24, 98, 24, 51,144, 72,
  6, 47, 67, 25,249,148, 65, 69, 78,152, 33,134,225, 94,208,154, 33,174, 20, 67,
100,166, 11,  7, 68, 51, 60, 36,129,177, 14, 98,239,216, 97,195, 44, 28,201,134,
155,153,201, 17, 63,222,121,142,168, 68,166,218,241,104,196, 70, 73, 59,143,104,
232, 66, 61,242, 94,  3,206,225, 43,252, 10,  8,208, 39,116,  0, 72,  6, 29,160,
 14,220,229, 33,124,169,  8,217,205, 66, 89, 15,  0, 54, 72, 12,189,174,105,146,
139,156,179, 13, 48, 50,137, 20, 82,242, 39, 64, 54, 10, 11, 74,250, 46, 52, 99,
 36,175,142,245, 49,221, 55, 41, 12,155, 86,223, 73,209, 97, 34,208, 22,111, 50,
248,138,109, 92,124, 11, 14,128,143,239, 77, 24,136, 56, 48, 13,150, 60,154, 55,
 73, 68, 92,141, 77,126,134,158, 98,173, 55,228, 42,194,116,194,143,141,173,104,
129,116, 60,117,184, 69,223,232, 12,197,103,184, 81,243, 21,179,204,100,202,173,
 76, 81, 97, 98,  4,204,233, 35,126,230, 25,202,198,224, 77,198, 16,113, 16, 64,
201,179,183,178,108,  3,120,242, 21,185, 34,196,123,191, 31, 75,100, 60,245,  4,
 78, 13, 95,147, 28,136,142,169, 91,197,184, 76, 91,  0, 78, 84, 89,200,153,196,
204,165,108,137,144, 20,147,160,208, 36, 48, 78, 24, 81,233,190, 73,101,216,166,
145, 51, 76,196, 84,205,245, 50,108,152,218, 16, 63,125,195,107,231,161, 18, 14,
203,204, 12,211,167,142,254,170,180, 26,235,249, 89, 93, 23,196,180,115, 86, 24,
 83,147,162,221,216,144,132,233,252, 38,243,134,151,  4,226, 12,113,108,181, 96,
 26,249, 43, 50,211,158,226, 94,239, 40,166,205,186,147,234,171,148, 48,166,127,
 50, 77,179, 47, 41,225,168,204,234,247,109, 10, 61,  3,113,132, 78,113, 81,194,
222,193,203,157, 37,  8, 99, 75,173, 89, 48,171,251,150,247, 48,125, 57,194, 85,
189,178,190, 38,231,127, 45,228,249,198, 92,195,115,104, 77,103, 64, 16,133,214,
211, 50, 62,182,223,  1, 87,167,219, 55, 80,185,119,150,177,153, 50,215,215,179,
225,101,246,144,242, 70, 49,147, 35,215, 89,  8, 52,110, 50,189,  3,167,243,153,
175, 41,  9,229, 39,211,221,237, 23,245,146,227, 26,246,190, 27,244,228,150,134,
186,192, 20,155,128,145, 23,123,127,195,114, 92,135,164,204,129,254,195,  8, 73,
 48, 28,118,208,227,253, 73,  7, 39,240,174,206, 21, 44, 20,220,207,230,144, 54,
 52,173, 92, 73, 24,144,222,185,178,128, 88,195, 83, 90, 65,191,172, 20, 61,209,
130, 96,199, 72, 32, 87,197, 86,158, 11,118,192,  9,228,187, 24, 69, 26, 61,176,
191, 52,180, 66,130, 98,100, 47,130, 32, 64,103,199, 82, 58,  3, 70,209,208,105,
 72,208,128,183, 50, 74,120, 77, 22, 69,138, 55,200,219,244,251,135,236,108, 12,
224, 66,199, 28, 76, 56,118,154,112,141,220,186,255,213,127,180,133,102, 74,173,
145,255,216,237,  7,229,197,111, 46,116, 35,252, 41,199,240,149,119,247,145, 84,
 63,203, 10, 43,172, 69,223,  0,  7,228,168,105,192,168, 33,  6, 36,129, 23,209,
 12,230,206,133,162,235,238,116,123,238,134, 44,  4,121, 37, 74,112,211,193, 24,
 17, 12, 90,233, 48,245,  8,225,161,129,233,243,192,245, 29, 57,130,  2,  7,109,
208,191,206, 20,  4, 31, 44,174,140,192,237,221, 72, 18, 72,188,160,  0, 48,129,
153, 94,137,172,  3, 22, 21, 40,  7,185,132, 19,162,152, 56,172, 48, 80, 37,104,
 50,207,122, 11, 15,134,229,  6, 66, 23,248, 74, 64,172, 61,208, 42, 23, 90,138,
147, 71, 82, 44, 68,240, 60,  1,211,241,195,224, 79,176, 42,193,252,132, 85, 82,
 20, 90,124,103, 84,162, 96, 90,232, 70,138,162, 92,213, 43,184, 22,176, 82,162,
 24, 70,197, 11,166,  5,237,132, 44,142,173, 74,  6,167, 22, 90,242, 82,199, 34,
 14,150, 53,184, 14,176,149,161, 24,195, 26,  7, 19,  4,173, 85, 44,138, 97,181,
131,  5,  1,247, 34,138,110, 88,247, 96, 37,252, 60, 54,124, 97,178, 87,107, 10,
156, 86,  0, 38,148, 65, 32,  0,211, 60,164,193, 75,225,143,105,254, 24,185,214,
243,238, 18, 51,195,153,195, 68,  9, 41, 43,  0,164, 37,170,170,170,106, 86, 56,
  0, 56,  0, 57,  0,211,106,208, 79, 69, 69,117, 42,246,140,213,218, 78, 23,202,
179,207,164,111,193, 73, 58, 73,228,251, 23, 51,142, 60,163,230,206, 94,138, 92,
202,196, 35,162,135,123,166, 45,  7,180, 56,107, 14,160,250,204,157, 86,242, 37,
 24,183,122,190,109,107, 80,156,242, 47,181,200, 55, 85,253,165,201,190,119,214,
224, 95,207, 15,147,123,163,247,244,186,230,174, 24,188,195,221,200, 96,140, 82,
 71,174,243,132,105, 25, 77,182,206,181,136,113,105, 91,184, 82, 42, 32, 80, 95,
112, 18,117,222,236,138,171,237,120,157, 14,110, 58,230,115,  4,157, 45,163,133,
 34,248,187,133, 85,251, 86,  5,106, 93,223,199,102,112, 13,117, 14,231,188,174,
 13,226,152, 22, 85,234,241, 60, 21,132, 99,237,248,235, 22,246,  3, 73,146, 28,
109, 97, 21,197,230,191,103, 47,176, 32,182, 55, 12,175,184,247,253, 74,243,139,
 18, 48,139,122, 64,219, 25,125, 69,187, 55, 64, 11, 93,247,190,111,115, 91,250,
251, 71,143,115,222, 91,188,  1,132,219,168,195, 77,115,146,130,100, 57,147,244,
 16, 20, 28,141, 73,131,  2, 77, 73, 41,104, 12,247,  1,115, 80, 97, 72, 41, 64,
 18,147,  3, 65, 96, 19,  4, 69, 16, 16, 81,  2, 74, 64,  4,132,  8,136, 64, 18,
130,  4, 68,110,196, 76,  7, 16, 96,187,148,210,166,137, 98, 74,225,199,  0,110,
102, 72, 63, 19, 21,130,100,119,133,210, 91,142, 45, 69,145,223,100,105, 29,215,
  4,113,175,173,126,113,217,  4,245,136,161,170,144, 96, 63,172, 38,237,147,156,
 98,213,246,160, 67, 85,124, 19,192, 75,179,149, 39, 39,120, 45,142,142,139, 75,
221,105, 29,128, 73,144, 88,230,115,225,223,  4,105,113,232, 29,195,226, 26,131,
179,224, 56, 32, 82,169, 63, 19,191,156, 91, 93,220,146,246,116,149,156, 38,229,
165, 11,204,191, 70,159,190, 74, 81, 18,136,219,150,228, 77,244,105,150,210,101,
206,228, 77,112,222, 78, 53,236,233,140, 80,248,105,116,176,152, 84,131,234,142,
 25, 58,190, 70, 15, 54,  6, 82, 82,173,116, 52, 36,123, 99,176,140,244, 97,120,
232, 83,144, 52,145, 84,245, 32,240,146, 69,144,152,  8,106, 38,150,106,214,255,
132,  1,206, 40, 27,219,149, 94,238,145,249, 54, 73,241, 93,213,178,117,  3, 87,
 32, 71,187, 99,118, 37,225,206,252,252,153,186, 74, 32,186,247,148,  9,132,114,
248, 44,233,130, 38,178,103,150, 25, 64, 74,125,107, 96, 27, 71, 23, 20,190, 13,
 41,232, 95,155, 85, 26, 61, 74,249, 24, 82,244,146,186, 83,175,230, 29,217, 70,
 99, 17,175, 73,147, 25,170,118,204, 76,  5, 69, 76, 45, 19,138,158, 89,108,231,
 68,165,108, 13,170,163, 83,102, 14, 26,194,  4,103, 16, 30,131, 12,100,181, 94,
209,223,229,249,191,240, 48, 14,236,120,150, 71,233,180,167,202,240,167,182, 26,
109,166, 72,160, 45, 65, 91,235,140,214,216,188,210, 54, 64, 98, 86,170, 13, 57,
185,245, 52, 79,206,255, 91,  2, 66, 24,166,181,183,151,210,110,111, 89,111,215,
 10,160,140,247, 19,162, 45,209,120,190,164,252, 13,206,168,167,227,146, 58, 37,
114,245,198, 83, 99, 32,168,181,  6,211,154,216,104,216,191,  7,185,148,212, 70,
 16, 48,134, 54,136,194,103,187,233,105, 15,202,  2, 23, 67,191, 77, 27,171,198,
128, 10, 18, 18, 85,163,195, 11, 93, 22,182,145,113,249,225,197,142, 11, 83, 26,
218,191,  7,230,142, 11,125,212,  3,135,100,132, 13, 47, 14, 34, 89, 76,109,209,
 84,181,216,134,179, 73, 14,114,212,135,247,129, 55,189, 52, 35,106, 31,189,117,
169, 24,128,137, 89,205, 12, 92,233,172,218, 21, 91, 22, 10, 14,232,106,161,201,
182,220, 97,170, 93,188, 30,137, 32,201,155,212, 18, 35,200,230,176,149, 78, 97,
247,179,  0, 64,252,123,150,222,245, 22,180,143,119,243,176,191,136,211, 58,115,
 24,197,157, 13,188, 20,187,110,231, 57, 20,179,199,153,109, 74,170,216, 51,192,
 31, 76,143,158,176,255,154,199, 81, 56,209,  9,178,122,200, 93,247,235, 56,223,
 59,177,211,186,225,146,231,112, 46, 20,127,187,163,170,148,187, 61,145, 67, 93,
151,116, 54,183,114, 92, 68, 91,127,234,207, 52, 75, 98,128,182,  4, 30,222, 33,
242,160,212,245,158,150, 52, 36,203, 57,164,250,165,109,198, 26,129,192, 39,136,
 88,227,130,200,157,238,135,227,120,142,249,171,126, 42,133,129,128,160,158,142,
197,209, 21, 56,115,107,223, 30,184, 81, 11, 61,189,160, 61,238, 75, 80,112,156,
 11,120,201,147,251,251,137, 37,230,190, 72, 41,195, 51, 29,191, 14, 99,182, 64,
 95,180, 73,220,159,190,115,177, 64,233,240, 42, 34, 45, 70,244, 16, 76, 38,243,
 87,  4,117,236,  8,197,121,235,197,247, 13,221,  2, 72,162,217,226,161,175,174,
147, 85,206, 82,158, 54, 65,128,130,119,160,255, 54,181, 67, 80, 75,201,120,156,
 62,203, 83,149,122,168,106, 45, 37,187,179,153, 56,229,123,213,155,  7,242,132,
240, 46, 97, 42, 38,184,179,207,116, 79, 30, 23, 82, 85,148,232, 73,103,120,  9,
250,  8,104,192,207,228, 29, 44, 85,207,217,201,239,116,115,248, 71, 99,121, 56,
 16, 34,226,213,161,231,191,144,224,249,  7,146, 93, 39,131,104,113, 35,179,  0,
 97,226, 55, 99,177,237,119,145,240,194,229,230,133,230,115,246,184,152,  5,158,
197,195,231,  7, 15, 41, 65,117,253, 34, 57, 69,147,143,136,  0,164,185,156, 82,
173,222,223,187,161, 41, 57,204,178,128, 25,231, 64,191, 31,  9,247,132,246,100,
181, 66, 87,236,138, 37,179,248,194,204,119, 30, 47,133, 32,189,103,  9,225, 98,
 83, 24,223,201,191,  4,252, 39, 38, 93,232,235, 85, 34,250, 24,134, 83, 21,201,
 65,162,172,224,114,189,141, 35, 45,158, 39,112,234,139,113,143, 48, 41,166, 28,
252,118, 64,112,132, 23,150,181, 97,  0,241, 93, 52, 38,228, 89,180, 97,254,118,
159,245,100, 50,162,209,250, 37,177,163,118,144, 43,138,132,173,  6, 98, 24,200,
  0,  8, 54, 76,133,232, 92, 15,248, 24,170, 21, 57,242,166,197,184,130,113,242,
  3,196,238,191,247,231,167,238, 15,245, 19,206,191,  5,202,241,204, 41,161,255,
107, 28,151,230,242,101,207,104,  3, 62,238, 31, 15,157,185,240,174,100,150,141,
179,140, 24,128,217, 67, 49,  7,206,196, 91,216,119,153,105, 56,102,207,129, 63,
194,156, 63,182, 12,158,194,178,130,221, 16,218,113,114,147,  6,151,148,226,195,
248,116,241,109,159,150,100,196,135,166, 29,  2,188,197,135,205,  6, 54,192,172,
114, 13,237,239,142,216,101,109, 44, 88,120,106,196, 30,173,201, 33, 92, 94, 92,
 23,  1,127, 13, 25, 13, 58, 90, 47,254, 39,155, 23,248, 38, 76,125, 20,125,171,
140,179,161, 39,254, 52,217,244,250,176, 49, 82,182, 43,164, 29, 45, 80,215,103,
151,155, 77, 92,235,194,132,117,147, 15, 74,107,141,104,214, 26, 34, 51,178,225,
 21,102,227, 50,240, 37,129,173,151,170, 99,142,117,135, 38,125,239,184,216, 27,
201,247,237,154, 39, 68,130,252,  9,209,240, 69, 70,246,  7,231,187, 49,153,142,
182,161,193,179,161,152, 41,135, 60, 23,101,136, 60, 30, 23,220,193,187, 91, 60,
246,244, 17,124, 19,125, 10, 69, 18,134,210,185, 77,159,198, 67,178,196,167,176,
 96,248, 77,  9,133,145, 56,160,197,229,137,183,205,143, 63,114,112,202,162, 95,
150,133, 57,250,214,251,227, 49,116,120,190,231,142,195, 45,136,206,189,190,158,
 64, 79,251, 43,106, 85, 14,204, 99,108,229,147, 31,228,173,199,184,  0,166,137,
 14,211,212,201,151, 90,125,103,191, 52,146,223,168,215,254,191, 50, 45,186,232,
 26, 90, 77,193,228,114,169, 80,255,205, 90,161, 84, 61,203,247,155,172,150,167,
142,198,105,244,156,216,195, 99, 49, 12,121, 94, 92,149,111, 39, 54, 17, 53,  1,
235, 60,145,134, 25,178, 92,177,  4,141, 90,  0, 49,  8,107, 20,200,146, 83, 53,
 23,255,225,116,147,117,116,102, 32,141,134,135, 99, 53,255,136,164, 91, 88,254,
 88, 21,129,128,102,  6, 33, 78, 49,129,217,215,208,169,154,115,  6,194, 43, 14,
216,154, 84,185,166,165,171, 25,169, 44,  8,211,134, 10,221,206, 28,159,255,203,
 38, 25, 69,154, 94,232,180,112, 14,232, 92,199,230, 50, 38,204, 37, 21, 48,190,
137,  1,227,  6,156,190, 61,202,231, 92,114,140,233,232, 82,246, 54,154,203,157,
151,116, 62,127, 56, 77,193, 98, 63,171,103,181,244, 27, 31,124, 16,193,  9, 86,
107, 45,234, 55, 65, 40, 13,198,142, 22,186,200, 15, 22, 19, 58,  8, 11,108,231,
192,203,132,155,200,114,136, 16, 66,151,135,225,158, 40, 52,113, 33, 81,168,184,
  5, 26, 81,137, 54,167, 54,201,102, 24, 45,213,195,115,185,173,123, 44,132, 46,
186, 66,171, 44, 17, 61,198, 41,234,182,216,139,243, 34,105,150,247,254, 22, 42,
123,213,106,121,146,236,123,  9, 24,140, 67, 53,128, 32,199, 61, 40,155,246, 94,
 17,202, 26, 12,219, 26,234,173, 68,147,  5,152, 78, 63,254,244, 88,246, 81,191,
148,149,196,245,143,200,113, 47, 36, 75,194, 28, 27,160,162,221,101,126, 29, 26,
129,202,250,101,179,103,108, 75,238,153,183, 63, 72, 25,192,104, 26,195,138,140,
 70, 97,130,128, 36, 94,194,126, 65,252, 80,106, 17, 39,158, 34, 82,123,205,147,
206,141,239,219, 72,140,169,170, 30,162, 60,169, 68,213,210,244,249,204,155,132,
 42, 66,103,178, 64, 43,176,250,203, 78, 98,132,225,199,128,225, 56,144,241,192,
101, 56, 38,196, 81, 60,145, 41,233, 67, 75,223, 76,194,148, 55,126,132,170,  2,
223, 51,129,147,185,225, 30, 11,  3, 32,147,129,174,132, 45,182, 76, 57, 58, 32,
 16,223, 47, 55,131,176, 67,104,233,104,241,146,170,209,168,238,108, 70,209,226,
 68,201,177, 87,162,167,148, 23, 93, 66,  8,108, 50,250, 75, 54,202,135,175,196,
246, 30,205,142,229, 65, 60,113, 35,236,218,  5,223,251, 67, 27, 74,174, 80, 36,
236,126,118, 90, 79,252,162, 71,182, 93,117, 40,110,204, 78,109,185,228, 87, 64,
190,143, 58,188,119, 90,242,108,119, 25,235,200, 99, 30,237, 54, 23,  6, 10,  8,
220,171, 58, 28,193,220,183,141, 17, 45, 17,234,205,161, 68, 25,233, 58, 94,216,
 68,144,186, 37, 54, 93,235,234, 10, 28,221,105,168, 67, 53,238,218, 29, 79,100,
168,226,236,199,220,145, 12,112,219,217,135,129, 35,154, 73,114,153, 33, 60,142,
204,147, 13,237,110,  6,139,188,250,114, 33, 51,168, 84,239,131,140,193,137, 41,
141, 79, 40,164,216, 18, 10,164,225, 18,108, 20, 21,243,227,176,226,222,145,203,
190,121,160,158, 59, 41,244,239,164, 60,152,122,130, 25,  9, 77,114,214,142,158,
197,192, 80,154,209,160,157,172,160,158,249,105, 11, 62,148,144,105, 70,121, 72,
158,171,110, 16,201, 11,128,198,149,224,170,166, 43, 47, 57, 13,162,180, 73,217,
 11,202, 17, 42, 37,140,109,138, 89,173,  7, 89,137,216, 59,127, 69,236, 24,124,
 87,132,169,194, 60,138,197, 91, 36, 21, 33,127,204, 34, 33, 13,174,  0,122,193,
 36,204,165, 81, 63,144,237,145,187, 52, 64,160,115,188,193,190,193,150,120,252,
205, 99, 62,240,233,251,223, 50,142,115,123,227,143,165,253,  2,206,113,169,222,
 67,126,243,177,182, 27,200, 70,230, 90,152,214,251,173,147, 46,  7,112,189, 69,
134,158,172, 84,249,227,242,147,203,196,137,206, 62, 62,176,210,212, 40,215, 43,
154, 19, 15, 29, 30,184,176,254,103, 67, 89,  4,189,255,210,215,  3, 22,190,210,
  8,131, 93,184,165,237, 59,104,117,199,128,240,113, 22,103, 48,226, 63,154,194,
148,153,246,254, 13,234, 23,103, 53,155,122,  9,105, 15,208, 39, 94,111,184,  0,
159,174,255, 37,101,105, 35,  8,  5,227,196,128, 37,156,111,168, 83,127, 86,121,
143,169,213,224,104,211,132,123,224,214, 88, 23, 87,165,  6,208, 51,113,102, 82,
157,179,147,246,254,128,184, 70, 72,172,210, 97, 58,  5,160, 18,252, 58,183, 25,
132, 47,194,117,129, 56, 60,206,172,244, 98,182,227,171,253, 43,237,169, 53, 13,
  4,130,149, 28,125,195,123, 20,199,112, 18,  6, 25,  4, 49, 59,181,237,250,139,
247,184,240,120, 25,208,155,244,123,166,154,210,235,  3, 81, 24, 82,102,116,147,
  8,105, 54,150,112,242,174, 14,244,255, 83, 85, 68,171,130, 65, 22,250, 94, 94,
199, 98,  2,118, 32,236,  3,185,111,111, 46,209,216,110, 42,240,215, 14, 36,178,
172,184, 53,128,177,184, 40,135,  6,165,  8,154,  1,133, 78,226, 59,144, 40, 30,
119, 81,  1,222,120,220,252,135,178, 86,201, 66, 61, 46,156, 27,  0,104, 95, 85,
 82, 71, 84, 76, 76, 71, 69, 76, 76, 76, 88,134,134,168,243,207,  1,131, 45, 68,
192,142,208,136,154,230, 35, 48, 16,  0,134, 32, 49,  0, 17,  2,153, 71, 38, 66,
 17,145,242, 43,109, 41,220, 71,184,208,  7,219,200,254,185, 85, 17, 90, 91, 70,
 42,205,138,174, 70, 54, 41, 49,197,200,159, 12,221,129, 97, 66,245, 70, 13,  9,
115, 80, 83,144, 13,194,142,102, 68, 67, 24, 19, 48, 69, 29,189, 44,202,197, 26,
205,153,170, 66,105,132, 71,140,235, 57,216,163, 27,118,  8, 21,101,154, 66, 77,
 65, 82,121, 88,  4,129,226, 69, 67,  0,102, 57,226,128, 23, 46,218,  2,172,213,
 98, 84,225, 52,146, 24,124,161,154,180, 13,223,160, 43, 43, 16,  4,105,114,201,
 77, 30, 22, 65,160,200,118,  0,139,146,104, 93,233,212, 72, 19, 37,211, 16,250,
163, 33,111, 48, 40,  0, 91,213, 97,242,144, 41,192,124, 44,130, 70,249,166,  3,
182,100,162, 10,128,230,210,141, 52, 81, 41,175,128,123,115,224,242, 83,129,228,
 16, 92, 72, 72,151,188,  6,130, 64,145,237,  0, 22,207,208,186,210,169,145, 38,
 74,166, 33,244, 71, 67,222, 96, 80,  0,182,170,195,228, 33, 83,128,249, 88,  4,
141,242, 77,  7,108,201, 68, 21,  0,205,133, 27,105,162,100, 26,161, 63, 26,242,
  5,195,  4, 96,171, 58, 74, 30, 50,  5, 88,223, 64,208, 40,223,116,192,150, 76,
 84, 91,  0, 91, 45, 94,202, 30, 70, 53,146, 84,201, 20, 66,103,164,188, 74, 31,
232,146, 29, 66, 69, 89, 33, 81,  7, 58, 10,138, 69,208, 40, 94, 52,  4, 99, 22,
 81, 43,151,162,182,163,111,181, 24,157, 80,140, 54,112,140,121,218,100, 82,178,
 64,173,165,230,243, 22,121,132, 80,160,214, 82,243, 75,180,128,243, 19, 10, 20,
178,149,242, 37, 90,192,249,  9,  5, 10,217, 74,121,137, 22,112,126, 66,129, 66,
182, 50,178, 49,  2, 47, 65,160,224,173, 25,105, 10,200, 73, 32, 80,108,169, 79,
154,  2,114, 18,  8, 20, 91,234,147,166,128,156,  4,  2,197,150,154,207, 91,228,
 17, 66,129,162, 23,116,133,254,215,111, 87, 35,155,202,194,153,  6,166,137,248,
118,149,195,148, 56,131,196, 65,245,144, 41, 50,  4,  6,173,129, 70,  0,190,253,
202,231,170, 24,181,186, 21,125,153,105,106,  6, 39, 49,121,  5,114,210,147, 63,
153, 26,161, 38, 43,232, 40, 40,165,174, 65, 88,208,140,104,  8, 96,255, 17, 89,
 69,185,168,  2, 96,173,138,162, 11,117, 20, 49,241,165,122,164, 54,172,201,158,
110, 32, 72,108, 43,104,201,143,140,208, 76,181,237, 79,226, 47,219,133,150,109,
141,112,181,120,201,160,141,235,129, 43, 89, 39,166,153,164,176,160, 18,239,126,
 30,170,210, 54,162, 12,113, 75, 96, 33, 37, 93,115, 13,113,135, 48, 21, 73,195,
 16,149,153,246,155,143,153, 52, 96,161, 96,245,  3,140,234,124, 52,194,221, 88,
135, 61,249, 23,172,162, 62,130,  5,231, 40,119, 99,116,158, 36,185,164, 58, 96,
 92,161,233, 36, 64, 40,193,182, 96,160,252, 96, 38,148,169,246,128, 35,176,210,
127,165,224,240,231,166,101, 48,216,145,194, 44,154,193,117, 96,212, 36,141, 65,
 84,134,214,159,141,147, 20, 99,170,216, 13,  1,163, 26, 31,141,112, 55,214, 97,
151,233,131, 32,170,126,217,  1,148, 89,196, 85, 81, 73, 22,169, 91, 45, 70,101,
163,185,115, 73, 40,195,121, 81,106,130,189,221,240, 67,168, 40,211, 20,106, 10,
146,170,143, 69,208,170,140,203, 14,152,147, 68,188,  0,138,139,197, 12, 64, 43,
116,199,245, 62,225,  9, 63,167,173,202, 80,195, 25, 44,147, 82,141, 26,102,  3,
  6,  2,164,  1, 83,197,214,  1, 83,147,244,  1, 84, 18,250,227,113,146,122, 76,
 29,123,  3, 76, 37, 91,210, 30, 80, 73,232,143,199,233,238, 49, 82,144, 26, 98,
212,119, 87,  7, 42,187,238,226, 16,154,180,128,  4, 11,194, 81,248,230,  9, 92,
161, 44,230, 41,162,142, 56, 42,198,220,104,210, 12, 48, 56, 23, 84,233, 63,254,
190, 85,179,134,170,117,180,197, 31,125,219,170,209, 58, 39,123, 33,125,232,  6,
 28, 57,  0,114, 69, 20, 24,112,111,  3, 40, 15,166,148,187,112,133, 32,149,191,
154,251,182, 16,101, 37,171,255,187,137,  3, 67,251,  3,180, 59,112, 82,244, 88,
143, 23,212, 26,  6,123,121, 44, 71,162,207,221,156,140,184,222,150,205,165,187,
 56,177,130,178,204, 89,198, 83,210, 38,196,  8, 31,126,140,204, 51, 15, 37,148,
141,154,216, 97,168,122,  1,134,134,168,115,111, 51, 28, 83,138,  4,  8, 20,210,
 28,131,202,204, 76, 74,  7, 51,112, 32,168, 24, 40,  6, 24,194, 65,112, 29, 16,
 69,  8, 36, 18,160, 64, 68, 68, 36, 40, 41, 40,104,210,  6,199,219,101,254,169,
234,202, 36,145,175,158, 65,136, 53, 24,200,169,139, 17, 56,161,168,228, 95,241,
 39, 60,249,214, 45, 86, 56,101,120, 55, 42,132,160,222, 97, 78, 94, 19,141,158,
186,134,174,129,137,122, 16,190,250, 45,215, 13,197, 28,159,119,185,106,193, 59,
 16,128,174,212,225, 15,142,199,215,169,150,100, 46, 29,108,185,184,  0,103,183,
 22, 86,108,221,  3, 70,169,197,177,163,181, 94,  0,224, 11, 60,225, 18, 95,224,
 94,  6,  7, 86,196,171,126,124,139,  2, 79,128, 95,227,147, 31, 43,192, 79,147,
 24,195, 28,  3,204, 24,160, 27,149,  4,185, 16,100,104, 23,196,  7,120, 36,111,
148,203, 29, 72, 12,133,112,116,219,119,213,  1, 18,126, 88,241,205,178, 48,  8,
104, 77,161,247,104, 11,110,142, 43,175,170, 43,238,204,203,  8,188,191,175, 43,
 48,241, 87, 61,155,  3,102, 92,  8, 95, 11,  3,205,141, 36, 98,149,  0,217,192,
 23, 16, 36, 15, 18, 36, 47,234,  0,127, 74,  6,194,166,212,130,141,196,  8, 67,
130, 94,253, 57,247,181,128, 70, 55, 64, 71,165,139, 65, 13,104, 42,107, 18, 51,
236, 19, 36,108, 45,172, 23, 84, 70,102,148,200, 90,206,126,177,  3,214,150, 97,
 26, 13,120,166,175, 54, 99,205,137,171,229,250,164, 92, 92,203,219,136, 26,205,
105, 57,200,162,171, 45,227, 90,174,141,194,111, 25, 66,159, 62,189,152,  8, 94,
157, 61,  2, 82,  4, 45,148,119, 70,178,164,122,162,112,177, 39,135,224,227, 62,
208,114,194,140,252, 47,220, 69,187, 41,166,251,185,238, 40,231, 98,213,133, 86,
148, 32, 92,239,154,254,165,218,163,207,224, 61,224, 33, 25,126, 15,157,246,217,
166,199, 22,168,155,248,243, 77, 96,220,139, 14,247,230, 97, 90, 50, 31, 46,230,
156, 21,230,232,131,228,159, 55, 49,232, 42, 67,139, 44, 19,122,  7,145,149,115,
103, 46,244, 23,105,167,140,159,231,145, 73, 52,252,127, 76, 93,192,189,144, 74,
127, 54,106,208,221,231, 33,  3,135, 12,208,232,224, 91,247,226,131,224, 60,177,
 18, 83,151, 11, 59,128,228,219, 46, 60,172, 12,173,192,192,  3,197,172, 46, 71,
 96,178,198, 93, 64,229, 67,246,139,185, 20, 11,142,173,130, 35, 75,210, 44,157,
 13, 69,138,128, 99, 77, 77,252, 13,169, 77,147,  3, 69,244,209,129,147, 78,224,
 47,165,188,127, 65,  4,161,204, 61,108,192,184,198, 46, 58,219, 23, 36, 15,243,
246,203,104, 73,225, 54,187,113, 82,149,179,117,201,231,  0,215,226, 94,194, 22,
137, 24,242,103,214,224,141,176,207,252,222, 61,109, 91,167, 66, 84, 58, 61,142,
216, 45,202,169,240,130,216,243,241,134, 49,160,207, 66,182, 57,169, 21,170, 99,
119, 41,102, 23, 53, 83,249,144, 46,124,208,202,156,220, 69,194, 38,123,201,245,
249, 28,240, 71,231,  5,  0,240, 43, 65, 48,174, 23,219,208,112, 70,103,129,158,
 49,244,233, 17,220,243,176, 21, 56,  5, 57,136,236,138,212,  5,253,201, 93,  6,
163, 11,204,228, 60,170,155, 62,182,226, 38, 80,  7,194,166, 97,233,133, 64,213,
150, 54,214,137,158,230,145,211, 67, 51,206,109,194,111, 96,160,  9, 31,130,138,
 44, 92,119,155, 59,124, 57,177, 15,252, 62,241, 18,185, 23,181, 49,250,184,207,
 60,161, 78, 10,247,211,183,175,103, 58,180,214,231,135,239,126,117, 71,253,175,
183,172, 88, 86,148, 24,203,250,135,190,202,245,177, 44, 30, 92,108,224,177, 56,
177,197, 60,251,198, 42,124,148, 60, 21, 16,126,215,227, 46,143, 95,249, 42, 52,
108,242,223,216,165,218,208,209,160, 49,166, 75, 78, 40,153, 85, 25, 15,163, 47,
 37,228,209,140,115, 86,114, 80,208,  9,  1, 29,165,238,202, 66,156, 99,234,  7,
 22, 53, 81, 33,170,150,224, 85,102,137, 69,222,186,236, 53, 62,226,179,181,  3,
216,131,108,194,216,103,189,232,231, 88, 66,200,220,163, 56,158,233,253,103,202,
121,225, 98, 47,248,107, 15,102,150, 76,147,150, 69,114,167,126,218,218,246, 58,
 28,192,227, 43,241,186,218,232, 95,113,150, 44,125, 77, 92,213,103, 26,194,204,
 80, 95, 37,168, 63,223,102,102,170,254,212,154,139,140,245,174, 10,234,111,119,
203,113,122, 95, 10,119,171, 23, 38,169, 99, 83, 94,251,120,107,200, 84,123, 99,
137, 90, 95,183,216, 69,121,190,  9,127,164, 55,223, 58, 33,164,242,186,168,219,
143,201,112,  7,222,223,146, 98, 87,115, 77, 61, 37,194,162, 66, 75,195,116, 78,
111,253, 49,104, 10,169, 81,127, 16,118,219,166, 87,250,112,171,232,198, 70, 93,
183,137, 12,205,160,214,200,237, 27, 44, 90, 92, 79, 31, 89,141,219,139,217,214,
 72,160,168,167,197,135,137,191,209,145,207,109, 55,226,244, 63, 41, 24, 64, 16,
250,224,135, 89, 53, 16, 67,135,250, 75,207, 53,206,193, 44, 70,153, 43,198,133,
185,254, 11, 19, 29, 40,249, 94,252,121, 44, 25, 14,139,121,175,180,138, 57,241,
160,160,229,165,254, 46, 18,200, 22,184,124, 16,161, 15,122,166,186,236,250,207,
 47, 61,125, 94,  4,188,174,209,212, 47, 41,232,116, 90,219,218, 61,109,192,226,
250, 83,231, 71,192,139,237,104,187,109,112,207, 22, 65,104,245, 26, 30,125,197,
224, 11,233,184,147,106,117,156, 66, 55,191, 55, 24,228,255, 55,149,146,115,150,
245,183,174,226,249, 76,128, 45,212,220,106,115, 38, 45, 98,131,103, 51,203,  7,
183,182, 17,149,136, 57, 55,  2,  6, 23,  6,119, 61, 93,189, 25,225, 99,162, 72,
 19,145, 55,235,162,203,110, 98,175, 14,  0, 43,  5,163, 87, 55,200,141,130,224,
 53,157,153,132,164,250,103, 10, 32,103,172,148,171, 22,147, 20,209, 40,206,113,
184,204,209, 96,209, 85,145,224,  0,194,195,148, 91,198,156,226,127,114,134,139,
182, 33, 65,116, 19,166,225, 70, 97, 73,232,131, 28,101,119, 76,106, 14, 65,104,
 25,154,  9,234, 95,197, 99, 68,114, 39,120,169,216,228,218,199,  4,164, 68,161,
247,131,226,115, 83,219,192,225, 58,163, 43, 64,  8, 31,  4, 92,111, 84, 91,197,
250, 61, 85,173, 40,134,204,236,  1,171, 97,100, 74,193, 35,229,  9,188,117, 52,
245,187, 85, 12,255,108, 92,189, 69,175,116, 81,228,129,213,230, 30,166,180,137,
120, 38,216,138, 60,  6,198,212, 33, 31, 96,207,232,222,234,  4, 64,162,164,227,
 65,253, 49,172,182,129,113, 69, 67, 23, 33,  8, 21, 44, 52, 46,236,104, 57, 20,
138,129,178, 22,252,  4,245,243, 33, 95, 20,223,161,218, 18,228,175,132,204,140,
224,237,  4,125,195,208, 91,181,135, 70, 11, 93,  0, 37,232, 48,208,184,117, 89,
 60,213,254, 20,188,  3, 25, 57,134,151, 84,140, 19,104, 21,166,220, 78,104,236,
200,208,206,173, 49,236,179,241, 45,179, 69,175,185,228,116,205, 49,198,154,121,
249,104,240,124,156,161,123, 67, 68,220,147, 65,181,206,220, 47, 85,140, 61,219,
189, 26,137,202,134, 50,191,225, 30,233,220, 77,172,254,204, 74,159,170, 99, 15,
 55,246, 12, 30,117,175, 85,225,232, 86, 97,176,223,238,195,174,146,180, 33,147,
252, 55,183, 96,159, 72,218,144, 73,254,155, 93,181,214,132,140, 55, 20, 74, 82,
253,231,210,240,  4,185,244,119,173,248,230, 15,192, 12,129, 46, 18, 19,  6,254,
167,221,210, 67,156, 82,  0, 38,252, 43, 61,233,107, 23,  4,112, 36, 54,  6,  3,
179,210,116, 21, 93,230,200,173, 97,101,195,173,226,135,219, 66,135,132, 93, 37,
165,218,171,223,254, 18, 67,133,138,170,130, 43,233,118,155,174,185,160,232,  8,
 76, 80, 26,205,230,136,174, 73,204,141,187,161,162,166,236,241,107,  4,225, 79,
 38, 90, 22,233, 57, 21,130, 21, 75,178, 97, 21,130,187, 66,191,144, 92,177,  0,
 31,150,190,234,155, 83, 52,210, 19,143, 64,138,149, 91, 36,223,  8, 55,255, 15,
 72,125, 46,232, 37, 96, 66,248,122, 14,108, 12,  1, 70,183,166, 38,208, 84,209,
  3,233, 86,110,173, 54,141, 95,127,105,  4,188, 74,137,176,128, 74, 38,166,196,
153, 83, 87, 18,  9,127,128, 33,250,128, 47,158,228,234, 51,160,  0,153,  0,149,
  0, 85, 38,183, 90,229, 53, 99, 79,237,224,202,  3,139,247,168,166,106,187,254,
135,118, 49,161, 82, 44,  9, 73,160, 76,  4, 36, 26,152,  7,132,104,226,147,197,
170,201, 64, 11, 11,142,249,124, 69,173,210,247,196, 79, 70, 33,168, 53, 16,137,
 47, 98,135,142, 16, 50, 76,163, 28, 91, 41,234,146,213,206,207,245,111,227, 34,
195, 60, 90,173,209,241, 39, 94, 88,157,245, 59, 68, 86,142, 89,253,206, 38,102,
 84,163,174,231,120, 62,135,104, 19,  4, 61,206, 40,211, 41, 49,  7, 20, 60, 41,
142,219, 66,125, 20,196, 17, 21, 25,198,151,220,100,  5, 72,229,203,109,216,154,
187, 34, 28,110, 89,163,204, 54,146, 47,114,228,171,204, 64,160,140,  8,134, 14,
 75,150,245,160, 71,145, 72, 24,130, 64,166,198,145, 87, 66,  8,147,202, 36,161,
234,158, 27,124,190,210, 51,215,165, 73,100, 30,248, 51,209, 25,141, 89, 47, 88,
214,239, 11,157,132,214,151,192,126, 22, 69, 97,  1,178,215,108,115,170,252,205,
 49,188,155,227, 27, 61, 35,253, 54,238,194,182, 32,247, 67,238,  9,114, 99,144,
187,130,152,214, 34,138,223,  8,247, 40, 14,211,152, 43,102,114,147,213, 78,185,
253, 70,122,170,157,250,193,  1,151, 73, 56,146,249, 33,182, 86, 74,171,205,124,
126,147,235,207,101,169,141, 25,125,209,125, 42,  1,246, 85,205,100, 39,118,231,
175,217,  5,  5,206,243, 89,226,145,204, 56,225, 68, 25, 29, 74, 47,141,131,  1,
135, 19, 25, 97, 18, 77, 20, 54,230,105,114,119,119,159, 38,247,170,250,119,191,
156, 11,109,102, 31,162,182,198,159,124,224,187,239,251,161,179, 50,155,218,  6,
154,166,109,187,108,219,198,116,198,109,219,182,237,183,118,247,139, 67,190, 64,
 86,129,187,187, 19, 80,184,190, 85,240, 60,153, 60,  2,226, 52,245,  4,161,111,
176,220,255,221, 29,114,247, 78,167,129,223, 83, 77, 48,216,149,165,130, 85, 85,
 85,255,212,178,  8,205, 88,214, 91,239,238,255,208,195,119,119,175,111, 33,180,
215,143,247,192, 62,222, 94,200,192, 31, 31, 31, 30, 13,209,235, 58,181,190,215,
106,119, 57,206,206,159,168, 26,238,110,145, 42,145, 69,178, 72, 22,169, 18, 85,
162, 74, 36, 81, 36, 74, 31, 84, 26, 93, 54,184, 33,191,126, 23, 62,235,161, 26,
186,151,249,197,144,176, 72,149,136, 67,227,176, 72, 22,169, 18, 85, 34,137, 34,
 81,254,222,127,216, 63,199, 18, 92,193, 96,220,101, 52, 46, 81,180,239,152, 19,
 61, 20, 69, 41, 86,189, 40,146,137, 92,  9, 42,172,178, 50,107, 60, 12,149,184,
 73,190,104,248,162,217,124,141, 15,204, 81, 83, 53, 29, 13,174,239,  7, 29,215,
216,217, 68, 77, 71, 43,169,103,154,192, 55, 48,112,255,126,213, 24, 28,176,154,
214, 12, 92,174,231,158,203,180,144,249,159, 75,218,248,127,193,117,162,130, 20,
211,  2,141, 12,168,  4, 59, 38,109,  6,  0, 65,  3, 99,114,  0,  0, 12,138,137,
 67, 82,153, 72,148, 70, 81, 12,250,  1,196, 32,  6,131,152,133, 21,  7, 22, 69,
195, 64, 37, 24, 60,134,193, 25, 10,  0,  2,  6,128,  0,  0,  1, 64,  0, 32,162,
  8, 67,192, 64, 71,125,169,167, 95, 55,253,128,  6,140, 17,218, 82,  6,246,221,
 12,163,  4,236, 58, 55,239,213, 12, 66,227,118,189,119,187,215,156,213,118,136,
235, 89, 66,182, 50,173,219, 65, 11,113, 95,232, 19,218,136, 52, 78,207,201, 90,
112, 66,140,242, 96,214,105, 81,168,254,197,198, 17,231,150,194,  3, 57,152,220,
 41,101,177,132, 72, 62,243,148, 93,168,185, 63,255, 66,137,118, 67,232, 45,245,
146,153,160,151,203, 31,199,208, 79, 34, 27,212, 72,248, 49,  1, 58,181,221,183,
 11, 55,  0, 67, 79, 74,222, 88,142,214,231,215,240, 70, 98,235,119, 34, 52,235,
164, 26, 50,144,191,235,220, 48,213,248,174,158,134, 21, 33, 28, 93, 35, 59, 40,
 50, 11,158,118,248,231, 72,238, 72, 78, 65,221, 83,  3, 93, 96,180,211, 16,200,
 78, 94, 38,216,123,138,224,133,114,157, 28,245,  0,189,123,121,235,224,237,148,
  7,205,169,169,227, 59,213,218,200,243,151, 92, 36,130,163, 35,252, 44,177,148,
220,216,227,130,215, 79, 18, 31,114,167, 92,157,130,150,167,116, 29, 21, 55,195,
238,176,217,115,248,235, 28,154,236,  4,187, 37,172,243, 90,214, 53, 52,243,122,
121,244,163, 54,223,219,121,176,131,206,190, 31,226,147,220,207, 38, 43, 38, 84,
218,181,136, 39,175,171, 64,189, 63,192,151, 28,182,194, 96,198,177,164, 94,164,
184, 87, 34, 85, 27,196, 80,238,236,227, 51, 85,118, 89,155,164,232, 43,141,243,
117,  1,128, 45,113,219, 46,134,164, 68,181,202, 16,208, 33, 35, 73,202, 58,191,
109, 47,243,  2, 33,168, 10,  2,219,247,212, 94,157,194,209,243,236,154,165, 58,
135, 55,236, 55, 91, 47,230,180, 81,197,182,195,181, 92,136,209,120,171, 99,119,
172,128,  9,210,214, 89,105,161, 33,182,104,111, 58,139, 50,121,145,204, 50,215,
234, 20, 96,  6,151, 99,163, 67, 54,132,163,178,192, 22,158,  4,136,113, 21, 21,
 37,110, 16,233,108,112,237, 72,176,190,230, 37,174,158, 28,  1, 21,  2,  4,106,
  5, 48, 98,110, 24,249,238,132,166,197, 81,184, 85,117,176, 37, 84,198,  1, 16,
 60, 40,  1,134, 70, 55, 93,222,137,156, 64,242,106, 81, 17, 42,114,  9,  4,210,
 41, 66,128, 38,252,188,236,194, 43,172, 52,215,213,191, 24, 66, 61, 16, 71,132,
123, 86, 70,117, 10,101,  2,159, 60,114,128,187,  4,250,226,226,  2, 98, 60, 82,
255,242,137,175,160, 60,136,254,189,242, 34,209, 66, 15,178, 77,224,  8,218,160,
191,163,234,205, 79,132, 21,159,156,202,233, 66,123, 47,121,230, 61,210,248,182,
 55,160,201,107, 26, 98,101,212, 11, 74, 32,213,188, 48,159, 31,228, 59,160,175,
136,134,137,247, 13,207, 56,118,137, 14,237,147,152, 91,213, 28,246,225,235, 60,
 44, 18, 14,235,163,184,235,170,253,157,171, 81, 76, 23, 81,223,190,115, 72,223,
196,136,120,154,232, 67,169,135, 31,186, 79, 52,236,193,112, 62, 37,  2, 48, 80,
138,245, 96, 34,194,139, 81, 57,214, 25,254,120, 39,216,168, 57,197, 61, 15, 74,
  6, 52,194,152,240,226,106,147, 99,205,163,161,223, 56,  6,126,142,200, 65,194,
190, 86,172, 55,113,218,  6, 58,126,162, 72,191,147, 32, 47, 65,102, 10,106, 28,
189, 10,234, 13, 96,125, 98,199,250, 94,100, 22,160, 65, 56,167,205,162, 67, 51,
212,101,  8, 75,106,202, 15, 56, 50,166,177, 38,229,253, 86, 17, 33, 13,218,207,
 36, 72,233,168,133,215,154,253, 14, 99, 18,209,162,147,164,111, 69,159, 99, 33,
249,189,187, 96, 46, 91,249,103,  2,123,253,128,225, 44, 89,180, 64,165,154, 47,
213,245,201, 99,216,251, 45, 21,101,103,171,133,133,200,205,225, 32,140, 84,171,
 21,246,247,220, 76,161,139,139,244,185,185, 61,203, 38, 65,150,160, 60,151,112,
 83, 31,177, 18,230,182, 82, 96,255,151, 54,244,229, 69, 65, 56, 14, 71,243,185,
255,  2, 15,  3, 80, 16,187,203,156,174,215,191,200, 85, 67,185,153,159, 62,119,
118,148,130, 16,110,236,237,  4,165,253, 54,130,144,102,155, 85,198,226, 17, 65,
 27,220,146,128,185,244,119, 25,156,126,  9,235,110, 43,153,166,107,232,106,188,
  5, 44,213, 19,122,165, 61,241, 70,214, 18, 18, 71, 42, 49,163, 92,227, 33,190,
 43,104,186, 30,253,124,132,126,190,130, 17,113, 48, 29,176,  9, 43, 16, 84,200,
244,143, 42,  1,193, 37,149,  5, 61,178,146, 13,234,179,230,253,209,143,139, 87,
 58, 58, 43,182,120,103,233,189, 10,197,245,250, 85,183,246,123,229, 89,234, 53,
127,224, 20,123, 36, 22,133,187,169,247,187, 54,220,145, 59,237,196,164,217,183,
151,243,146, 71,253,191, 28, 52,240, 44,193,161, 75, 85,  5,168,217, 78,154, 54,
249,176,147,221,137, 87, 81,154, 47, 87,166,193, 34, 46, 43,106, 90, 15,239,130,
 16,127,238, 14,176, 73, 77,  8,228, 45,240, 59,187,189,136,237,112,177,171,216,
 91, 92,167,215,185,225,126, 70,234, 48,116,161, 61,139, 66,132,155,198,137, 89,
184,139,227, 85, 78, 70,108,106, 87, 34,112,163,206,198,  8, 70,  6,199, 30, 39,
 67, 76,226,252, 92,203,224,178,161, 99,166, 57,175,213,220,108,158,239, 18,251,
 76, 38, 92,153,189, 90,103,183, 86,239, 67,211,118,239,226,119, 95, 91,222,183,
 77,201,242,231, 38,172,131,  7,185, 46, 18, 14,172,250, 29, 20,111,161, 57,  0,
158, 86,104,153, 83,191, 81,163,130, 29,147,253, 42, 98,110,174,205,246,188,240,
214,201, 85, 40,207, 99, 57,239,128,156,198, 56,241, 23, 88, 67, 89, 38,206,145,
113,238,244, 32, 59,171,161,140, 86,214, 29,134,164, 81,234,106,127,200,183, 66,
 34, 72,230, 55, 66,101,190, 40,199,255,194,132,  0,193,  9,219, 54, 33,103,211,
254,255,201,148, 85,  8,123,129, 52,167,136, 69, 64,208,183, 98,242,210,170, 39,
104,233,114, 23,156,162, 10,  2,154, 47, 57, 17,165, 91,  0, 83,212, 52,182, 37,
225, 53, 86,  2,114, 14,222,109, 56,158,183,242,192,154, 38,149,105, 66, 78, 20,
175, 49,139,186,198, 41, 77,183,167,160,134,118,  7, 44, 35,122,  2, 83,183,118,
185, 81,153,112,209, 51,158,147,176, 44, 19, 97,120,  2,102,145,196,242, 36,177,
238,138,164, 97,123,196,111,137, 91,217,203,245, 35,169,125, 22,244, 71, 89,225,
 91,242,182, 56,255,  1,213,148,125,125,177,170,188,133,110,170, 14,  1,192,210,
174,112,176,222,  4,103,199, 78, 48, 18,247,148,227,182, 98,  0,235, 51,219, 73,
 42,150, 68,137, 77, 53,234,250,242,134, 75,237, 75,138, 76,109, 31, 92,109,  1,
 68, 59,200, 86,218,150, 76, 65,  4,  7, 34, 48,148,200,127,221, 84, 71, 52,214,
 26,137,  9,237, 78,224, 18,221, 33,104,243,137, 51,133,155,164, 85,184,  1,165,
 88, 95, 31,210,188,112,140,108, 47, 14,202, 84,151, 36,152, 90,207,211,187,231,
225, 95,205, 38,227,158, 94,209, 90,187, 75,186,140,198,118,221,159, 10, 33,223,
 14, 48, 86, 81,239,138,179, 30, 96, 70,171,161,106,172,144,159, 43, 86,207, 51,
 33, 81,  6, 62, 92,155,193, 96,215, 69,  4,207,159,142,219,215,169,110, 22, 18,
205,187, 30,226,107,240, 41,126,227,133,180,235, 49, 92,228, 63,235, 38,  7,115,
250, 14,210, 12,239,212, 95,229,193,254,252, 80,110,  5, 48,137, 74,199,109,102,
  7,151,136,  0,199,217,251, 19,  1, 42,106, 40,228,233,217,196, 47,165,135,196,
142, 86, 97,168, 33,125, 42,  4,172,224, 19, 50,105, 48, 31,199,209, 66,243, 52,
238, 34,233, 71,176, 57,  2,250, 49,114, 75,125,160,225,222, 13,116, 25,106,222,
 99,111, 81,165, 82, 75,133,169,144,210,241, 75, 86,234, 41, 59, 18, 84, 50,173,
140, 18, 47,200,106, 19,128,250,155, 14,125,249, 61,194,172,220,123,153,139,224,
151,130,162,187,165, 87, 69, 27,225,184,243,220,124,193,109, 14,127,222,179,169,
 68, 87, 37,201, 99,198, 78,157, 77, 37,  0, 14,  9,242,223,132, 51, 87,167, 79,
106,255,131, 20,187, 86, 61,149, 28,150,  8,156,198,240, 12,159,231, 96,226, 46,
172,228,176,143,135,164,131,230, 32,151, 93,255,  1,  6,153, 93, 53,254,129,249,
  6, 44, 34, 10, 91,143,234, 23, 76, 54,148, 38,127,222,228,188,141, 10,235,108,
172,131,242, 94,188,  2,118, 84,212,175,227,225, 77,167,164,180,201,216,107,166,
 13,  8, 54, 42,204, 89,227,247, 98,106,187,167,125,220,178, 99,  6,159,114,235,
 74,179,196, 12,117, 96,173, 70,135, 40, 98,180,168,117,168,252,104,187,129,123,
 86, 46,123,201, 81, 73,221,189,  9, 51, 23, 49, 22,171, 31,104,122,235,179,208,
109, 84,170,246, 12, 14, 56, 66,135, 72,182,157, 91, 76, 41,212,147,212,181, 39,
 20,149,162,199,  1,  1,148,213,207,115, 74, 58, 94,150, 55,145,245,122, 27,129,
228,224,104, 94,118,116,204,107,178, 59,124, 95,146, 26, 28, 40,176, 87,105, 17,
162,249,245, 77,158, 40,102,148, 62,133,154, 63, 45,118,129,248,194, 11,217,116,
162,126,200,129,238, 93, 38,134,132,164,102, 60, 60, 24,154, 95,112, 29,114,244,
 81, 16, 98, 62, 19, 46, 14,168, 44, 13, 59, 76,120,178,178,164,236,222,102, 49,
 45,230,225,128,208, 51,126,194,115, 88,168, 21,121,192,  3,193, 80, 45, 12, 95,
 84,252, 75, 10, 73,113,156,231,  0,154,178,249, 93, 64, 84,  6,238,141,121,177,
 17,139, 33,201,  0,208,145,170,102, 64,154,187, 29,245,173,177,149,254, 94,177,
199,162,220, 68, 51, 36,179,142,248,166, 46,211,255, 73, 39,218, 56,210,  7, 63,
 73,234, 30,129, 37, 82,253,  8, 86,144, 49,109, 10,121, 90, 28,  6,212,144,238,
170, 91, 50, 26, 23, 39,236,236, 22,121,150,228,240, 39, 12, 76, 20,108,197,114,
140, 74, 54,126,151,178, 27,165, 45,230,238,105,248,  5, 17,114, 29, 19, 66,185,
142,118, 16, 94, 54,122,115, 50,130,152, 68,249, 86, 33,226,215,180, 86,126, 83,
104, 74,217,253,153,150,193,118,206,178, 88, 75,178,  6,197, 26,216, 25, 50,113,
101, 74, 74,225, 63,237,234,197,109,162,127, 50, 52, 92,223,254,181,248,157,250,
 53,200, 13, 44,174,248,  0,163,179, 96,151,187,180,110, 48, 59, 93,153, 15,100,
  4, 85,254,202,125,179, 18,225,224,220,222,252,223,245,201, 59,205,149,187,144,
 20,203,  4, 45,127,192, 91,226, 53,124,195, 17, 72, 56,247,129,196,144,248, 48,
 50,188, 74,145,214,245,155,221, 60, 11,184,209,109,222, 77,154,176,180,247,251,
153,  3,172, 98,213,  0,172,120,131,130,184,150,239,126,181, 54,203, 67, 51,252,
237, 69, 92,225, 22,191,196,211,206, 82,234,243,243,224,122,216,140, 28,192,185,
 97,254,246,121, 62,101, 13,250,181, 32, 58,129,153,112,  0, 73,142, 64,239,186,
242,248,  0, 32, 48, 81, 44,254,125,253,240,216, 42,210, 75,209,111,  5, 48,217,
232, 90,233,156,180, 21,104,174,  3,193, 21, 37, 17,131, 18,241, 15,208,171, 42,
215, 34,109, 45,112, 78, 29,223, 37,202,220,120,201, 44,198, 34, 76, 34,254,139,
196,111, 30,  7,  1,137, 51,246, 17, 37, 51, 35, 64, 52,  5,190,238, 74, 61,196,
180,141,  4,201, 74,216,181,183, 26, 48,109, 30, 68,  8,169,137,200, 68,107,177,
138,104,240, 71, 49,232,  5, 81, 93, 88,147,248,152, 99,167,147,245, 78, 20, 23,
228,  9, 61, 19,196,159, 51,152,112,  0, 86,197, 81,130, 65,235, 99,  1,251,224,
 72,121, 74,176,182, 61,199, 39, 88,245, 20,185,194,150, 72,135,245, 41,  6,207,
112,138, 26, 95, 66, 16,212,223, 58, 79, 36,156,205,128, 71, 65,137,118, 70,231,
  7, 80, 44,173,221, 78,  4,173, 34,226, 70,222,127,174, 74, 70, 55,194,157,181,
144,138,248,167, 51,136,200,245, 15, 30,112,226,191, 58,114, 54, 65,134, 76,208,
203,234,254,170, 90, 46,130,243,239, 51, 60,210,114,205, 27,222, 32,251,117,114,
 66, 15, 21, 71,164, 14, 17,175,177,218,245,211,105,213, 33,185,  6, 43, 36,153,
112,135,206, 87,178,233, 17,255, 41,133,142, 30,135,128,244,132,165, 42,108, 11,
202,232,230, 71,135, 13,151, 42, 50, 43,245, 80, 70, 68, 83, 26,156,133,133, 53,
170,221,147,201, 17,191,138, 64, 47,156,132,199,190,  4, 33,234, 75, 94,206, 91,
 34,166, 55,162, 82, 50,136,  0, 51, 57, 23,253, 13,175,246, 73,189, 66,158, 73,
145,210, 78,214, 49,112,195,112,193,  1, 98,179,242, 80, 80, 98,115, 35,110,125,
 28, 82,181, 66, 22,108,114, 79, 83, 39,196,100,187,235,192, 44,154, 36,168, 19,
  9,161,140,116,128,138, 70, 11,199, 44, 49,174,100, 78,231,  8,250,144, 14, 12,
 11,202, 45,  8,236,154,172,210,105, 82,134,177, 72,145,253, 38,232,133,250, 89,
122,213, 20,135,108,  3, 62,255,211, 31,212, 85, 12,239, 87,206,252, 54,196,121,
136,144,241,121, 88,151,  3,134,229, 55,  4, 89, 43,129, 90,113,203, 79,  4,100,
 67,252, 92,212,190,  5, 80, 50,246, 52,153,172,110,126,167, 65,195,234, 70,242,
164,134,135,226,  0,154, 13, 36,220, 51, 51,111, 21, 73,151,168, 58,189, 58,228,
 52,120,113,113,176, 57, 31, 96,  8, 19, 11, 79, 22,163, 61,142,149, 64,242,141,
230,135,247,249,199, 88, 13,204,227,154, 87, 75,205,191, 23,172, 46, 91,172,214,
 39,198, 81, 22, 33, 34,141,198,246, 41,128, 67,169,114,135,174,206,156, 32, 21,
209,235,169,198, 47, 87,  5,195,198,241, 45,177,158, 33,167,195, 65, 71,  3, 61,
156, 15,115,125,160,236,151,107,210,240,145, 68,180, 24,130,124,160,239, 50,246,
192,195, 20,211,120,108,121, 61,108, 90, 12, 88,145, 26,150, 87,165,200, 43, 85,
214, 37,146,193,190, 13,145,  2, 35,208, 94, 95,234,196,160,193, 38, 43,134, 48,
107, 31, 65, 98,228, 71, 10, 34,220,194,219,199,  1, 60, 94, 21, 13,169,216, 53,
204,142, 94, 96,175, 74,214, 21,242, 48, 90, 74,142,147,162,205, 39,224,194,168,
 56,159, 40, 57,126, 14,193,198, 72,140,181, 62,151, 13,246,194, 14,191, 22, 54,
158, 86,176, 15,  9,237,225,159, 22,101, 51, 44,210, 22,154,  3, 69, 65,239, 64,
 25,197,136,116, 94, 39, 39, 74, 41, 27, 54,228,  3, 35,221, 72,156,235,239,190,
 71, 53, 27, 38, 13, 71,231,  8, 24,251, 51,116,237,191, 15,209,165,139,129, 50,
185, 37,176,100,146,105, 36,  6, 95,185, 84, 65,171, 54,214,101,214,121,201, 42,
159,153,144,239,  7,242,119, 48,135, 18, 23,239,238,187, 20,241,136,159, 86,178,
112,126,122, 65,192,240,249,  5, 40,153,176,161, 90,146,153,237, 53,194, 89,219,
 25,  2,176, 71, 62,181,178,  6,199,120,116, 42, 36, 72, 22, 54,232,245,185,119,
154,145, 84,170, 21,221, 99,219,144,214,  6,199,247,112,163,131, 85, 24,255,147,
121,  8, 57,225,211,132,161,187, 30,221, 29,219,111,188,173,210,199,199,125,203,
198, 94,182,213,116, 77, 22, 57, 40,181,203, 56,222,248,253,206,  6,127,179,239,
 23,116, 80,209,161,131, 42,250,124,107, 98, 20, 72, 65, 54,189,131,238, 52, 27,
197,132, 74,189,244,185,194,199,213, 58, 59,  1,101,  2, 27,185,199, 96,240,217,
  8, 46,220, 84,138, 54, 23, 97, 69, 91,162, 22,109,119,251,209,136, 10,133, 35,
203,207, 58,182, 99,123,246, 27, 55, 16,216,214,136,176, 11, 80,157, 57, 54, 84,
  8,117,  5,112,204, 70, 93,234,197, 23, 92, 12, 54, 24,153,183,157, 76, 26, 64,
175,173, 29,104,126,249, 73,237, 44, 56, 79,208,106,216, 65,138,  9,155,113,243,
150, 50,171,154, 93,150,178,130,161,164,208, 63,105,160,105,221, 67,187,162, 25,
 40,240, 23, 16,177, 46,187,196,  4,112,  9,237,137,153,114, 86, 30,195, 53,140,
198, 46,255,225, 20, 62,129,206,155,118,154,249, 55, 93,  3, 49, 25, 96, 58, 75,
 79,179,138,145,240,115, 55,215, 76, 48, 84,231, 55,  6, 22,222,231, 87, 56, 37,
141,162, 65,119,176, 68, 64,116,204,200, 45,147,123,158,  0,171,101,235,191,244,
184,115, 51, 65, 88, 30,181,158,218, 60,138, 46,145, 81, 85, 44,125,245,249,  5,
253,237,205, 84, 89,224, 74, 89,164,216,144, 24,143, 31, 78,107,137, 45, 85,145,
 11, 76,180,188,218, 97,165,228,232, 83,204,240,185,222, 79,157, 41,128, 30,152,
207,201,181, 48,116,222, 66,129,  7,225, 15, 75,168,106,188, 27,120,241,252,106,
 29, 62, 61, 71,249, 52,136, 38, 35,162,134, 62,139,214,  2, 48, 88, 67,178,137,
238, 30,167, 39,249,110,226,148,128,119, 73, 66,139,145,244,102,106, 77,118,215,
 45,203,144,168, 82,234, 99,196,212,140,175,193,117,172,184,170, 82,226,206,120,
 84,153, 70, 60,131, 51, 33, 65,129,105, 18,119,101,  7,204,156,172,158,158, 48,
202, 78, 29,210,244,230,  7,246,118, 23, 23,102,  1, 36, 80, 91,177,250, 37,110,
171,145,197,226,210, 54, 26,167,140,155,170,232,134,136,183, 55,167, 20, 16,134,
111,251, 71,170, 45,  3, 85,158,148, 11,110,127,195, 61,207,178, 31,183,194,164,
121,243,118,103,207, 18, 56,226, 22, 51, 57,101,220, 26,220,179,153,  6, 91, 30,
 35, 32,178,116,220,135, 26, 28,193,149,  5, 54,200,197, 25, 96,103,113, 11,251,
203,179,207,173,118, 68,215, 90,114, 70, 18,183,112, 25,206, 57,192,101,211, 42,
220,213,242,221,182,224,111,198,103,234,152,230,227,217,  0,188,219,142,151, 69,
188, 95,164,213,184,112, 69,121,241,238,110,123, 88,198,183,236,184,165, 65,  2,
 57,179,111, 84,126,210, 73, 99,130,182, 78,132, 68,197,161,104,165,107,128, 55,
 73,236, 40,115,174,189, 13, 69, 50,230,159, 45,144,253, 92, 95,  1,227, 15,191,
133,120,205,221, 87,244,135,252,218,110,154,140,248,192,246, 17,222,198,142, 77,
236,220, 55,155,218,218,184,105,140,161, 47,236,155,144,110,  4,110,127,213, 64,
237, 51,228, 70,171,185,255, 11,115,209,169,132,118, 48,222,139,179,104,208, 60,
 73, 43,195, 46, 63,152, 31, 12,107,155,168,104,139,133, 74,246,209,128,195, 93,
 45,  7, 11, 52, 11,145,177,113,  5,136,135, 64,129, 35,228,217,240,180,231,242,
 52, 27,203, 77,199, 16,235, 83,242,152, 45,201,170, 37, 26,126, 40,126,111,187,
172, 27, 38, 62, 53,152, 15, 48, 65,144, 72,248,216, 98, 99,214,252, 21, 56, 17,
 77, 31,238,170,  8,133, 81,149,117,130,134, 48, 65,  7, 90,121,194,120,179,  8,
179, 32, 14, 37,239, 29,188,  9,244,  1, 18, 43,222, 12,104,220, 74, 23, 30, 25,
249,252,201, 96,196, 70, 16,  4, 45,218, 39,104,147,188,103, 98,100, 74,206, 36,
208,207,115,223, 94,127,233, 47, 21,233,145,202,146,185, 61,214, 28,123,233,104,
 96,208,229,204, 73,157,251,217, 81, 11,211,210,224,145,138,148,  4,186,112, 34,
209, 62,151,216,134,132, 66, 53, 31,225, 15,115,247, 80,185,148,204,232,247,117,
  2,  6, 16,248,143,189,172,235,174, 66, 54,207, 40, 22, 45, 58,245,141, 28, 18,
151,233,188,172,207, 28,235, 73,214,  5, 45, 73,115,116,251,172,238,223,255,167,
 73,175,100, 48, 32,107,104, 98,182,102, 69,195,156,107, 15, 11,  1,172, 20,145,
247,170, 58, 68,165, 43,226,225, 68,214, 63,131,113, 48,223,143, 14, 87,239, 32,
173,215, 74,202,120,184,226,184,  0,243, 90,185, 16, 50, 29, 65, 24, 32, 59, 79,
141,210, 31,158, 24, 32,252,200,119,213, 72,196,250, 14, 92,225, 59,251,146,151,
224,160,219,246, 64,114,150, 72,153, 93,117, 14,109, 44, 52, 38,213,210, 55,148,
249,117, 98, 95,169, 90,128,202,165,140,185,179,186, 43,132, 26,157,160,203, 73,
 13,143, 39,212,228,244, 79,141,130,170, 59,184,205,225, 79,241, 93,103,  9,150,
174,228,240,238, 84,126,152,167, 69,219, 39, 70, 77,143,218,186, 54, 39, 91,155,
 70,115,  6, 53,174,213, 98,187,174,113,125,219,  5,216,145,194,  8, 50, 67,183,
 23,119, 29,246,182,110,211,210,143,166, 59,146, 32,199,224, 31, 26,157,138, 20,
 23,153,112, 84,171,184, 95,230,207,194,224,232,143, 49,201,233, 66,216,164,142,
200, 54,113,244,208,244, 14,104, 36, 16, 39,  4,  9, 54, 99, 20,  1,122,186, 12,
176,156, 91,  9,  2, 79,218,  6,152,136,157,215,172,206,238,126,139, 50,194, 48,
 50,109,198, 68,  4,183,100, 42,207,221, 14, 19, 25, 78, 69,152,143, 95, 22,140,
 85,119,138, 56,100,118,157, 44,118, 54,202,142, 27, 70,216,115, 88, 84, 75,137,
183,118,173,162, 16,225, 56,162,206, 81, 87,220,214,  7,211,  2, 88, 17, 11, 68,
 29, 16,201, 32,250, 37, 19,212,137,166, 90,133,250,147, 65,124,103,  1,175,153,
 82, 24, 56,200,214,234,  4, 12, 25,142,183,184, 70,158, 87,113, 39,188,242,180,
180, 59,176,224,131,177,149,213,206, 63,128,139,147,246,139, 21,155, 98, 27, 17,
143,222,129,118,137,  5,225, 67,  7,129,155,215,118,147, 98,144, 16,158, 96, 99,
139,221,209, 34, 14, 12, 34,165,194,176,116,145,185,153,143,244,  0,246,240, 40,
 84,200,244,244,183,224,126,195,176, 43, 45,231,114, 97,239,239,255,  9,123,240,
209,  4,173,184, 46,195, 42,227,227,144,134, 21, 90,162, 11,155,234,163, 68,244,
160,213,197,204,136,208,255,194,213,100,204,231,103,117,226, 18, 32,213,185, 90,
228,149,176,123,195,101,129, 82,139, 98,166,170,225,177,161,139, 88, 67,145, 23,
  1,146, 35,102,205,215,208,204, 79, 90, 11,  2,228, 97,231,163,161, 79, 37,174,
186,194, 25,196, 40,143,225,190,230, 88, 73,233, 18,226, 18, 84,156,242, 60,137,
174, 40, 15,174, 75,213,236,184,182, 51,235,238,143, 11, 22,222,229, 89,210,139,
103,  3, 54, 19,109,177,242,230,120,210, 71, 32,133,227,120,115, 64, 17,200,232,
128,166,213,  1,  1,253,250,229, 94,150,236,144,227,240, 96,231,106,144,211,193,
131, 16,123, 96,249,209, 23,174,183, 88,231,155,  4,105,145,155, 32,235,154, 16,
177,164, 99,245,101,116,243,176,135, 77, 96,125,201,188,241,153,151, 94,125,101,
 41, 98,129,251, 66,152, 78,136,199,152,184, 15,166, 44,111,158, 37,206, 34,164,
243,242, 39, 87,245,140, 43,154,101,248,245, 19, 90,170,226, 67,  3, 58,166,100,
107, 56, 88,224,181,234,194,177, 28, 69,  3,159,180,132,157,151,192, 77,192, 94,
246, 90,157, 93,140,214,131,107,104, 85,247,230,220, 33,167,137,176,134, 15,230,
219,196, 83,252, 85, 58,152, 42, 58, 13, 79, 91, 19,253,226,166,101, 98,218, 79,
  7,106,204,122, 93, 12,213,107,  6,  8, 96,245,138, 94,239,162,218,  0,203,249,
 37,124, 58,171, 69,  4, 43,132,212, 28, 77,154, 48,154, 52, 59, 83,151, 49,195,
176,176,157,169, 71, 16,188, 22,  8,181,118,247, 36,107, 56,221,191,184,200,207,
103,183, 49,190,237, 88, 73,144,192,174,243,  9, 69, 93,233, 36,224, 42, 36,101,
246, 59, 98,145, 60, 73,200,  1, 58,255,195,188,104,150, 19, 16,202,177,197,131,
254,233,169, 56,108,160,223,118, 53,223, 85,106,148, 96,151,122, 19,105,135, 89,
113,137,126, 46,  1,161,246, 89,  0,128,188,179, 18, 19,194, 19,204, 26,183, 67,
 90,104, 51,160, 40, 59,133,215,212,168, 33,127,170, 48,  1,237, 22,197, 18, 52,
 59, 57, 78,232, 83, 40,109, 63,108, 44,127,167,244, 36,100,166, 93, 62,128,111,
161, 89,183, 35,199, 59,193,139, 32,232, 80, 32,148,223, 29, 50, 78,120,115, 78,
 28,203,165,189,125,108, 95,179, 67, 83,245,204, 48,175,231,121,228,237,242, 68,
130,  0,  7, 17,135,122,103, 65, 41,183,142, 56, 40,154, 30,133, 83,216,186, 37,
 34, 83,160, 81,152, 67, 48, 13, 79,109,114,223, 26,148,132,110,208,102, 85,201,
237,116,232,188,248,220,172, 10,192, 34, 36,144, 56,154, 61,139,101,148, 52,193,
 77,241, 22, 37, 61, 56, 28, 39,154, 70, 41, 79, 93,144, 73,123,148,245,252,133,
134,125,183,209, 84,102, 80, 63, 86,240,242,193, 28, 22,130,248,  1, 11, 99,248,
 60,111,195,166, 78,140,146, 67,174, 15,102,203, 84,184,104,148,141, 19, 19,149,
187,144, 64,192,243, 40,196, 81,164, 36,222,242,106, 22, 33,143,217,123,137, 12,
166,158,154,133,  8,110,154, 11,162,199,119,104, 91, 93,189,135,222, 58,193,176,
 33,132,213, 22,131,210,123,197,185,118,148, 78,107,251, 75,243,189,167,209, 86,
 43,155,199,192,237,212, 43, 75,162, 34, 88, 30,157, 19,144,101,212,103,113,202,
 26, 92, 70, 89, 20,139, 85, 56, 80, 67, 16,242,227,143,145,  1,227,226,228,206,
168, 92,127,115,114,  8,139, 46,117, 87,208,187,224, 26,195,  8,  1, 82,100,167,
 31, 39, 91,107,111,120, 88,250,180,226, 23,123,186,182,133, 68, 33, 24,210, 17,
  5, 31, 36,184, 34, 42, 76, 57,212,182,122,152,175,242, 38,233,190,170,132, 95,
 21,132,117, 34,196, 77,246,122,181,209, 33,111, 36,220,112,131,  9, 87,128, 97,
230, 55,161,118,197, 70,150,165, 66,149,132,  9,220,238,214,121, 60, 77, 33, 18,
176, 93,141, 37,149, 83,246,108,197, 26,169,210, 72,222, 27,202,119, 23,208,164,
218, 90,193,196,100,184,142, 70,188,143,118, 42, 19,104, 53, 14, 33,178, 36,197,
 81,188,147,248,173,160,232, 75,190,236, 73,  4,191,207,149, 96,144,188, 29,180,
 41,155, 84,133,105,230, 90, 60,149,240, 80,186, 74, 15, 59, 82,156,250,102,231,
134, 20,122, 78, 77,186, 74, 37,238, 45, 48,103,114,189,233,129, 33,151, 64,114,
193,153,235, 26, 81,203,147, 40,  5,213,  8,207,167,  5,  4, 42, 24,130,230,209,
 79, 32,144,238,  8, 75, 93,204,162, 29,183, 54, 14, 50, 66,208, 43,  8, 67,176,
122,206, 68, 82,149,185,243, 15,107,252,204,177, 30, 87, 21,112,120,233, 48,171,
233, 83,101, 74, 45, 81, 97,  8, 46, 50,  8,165,164,246, 79,154,240, 52,165, 56,
252,102, 75,216,221,135,156,174, 38,139,202, 67,240, 99,134,  8,207,102,106, 10,
190, 40, 69, 25,223,105,233, 28,146,130,169, 56, 97,245, 74,237,197, 47, 88,183,
194, 56,139, 36,253,  4, 19,244,231,118,154,184,239, 50,103,247,135,  4, 69, 74,
 14,253,180, 27,209, 69, 58, 63,204,213,232, 99,132, 24, 25, 75, 24,  2, 95, 83,
 46,113,191, 88, 79, 67,140,212,132,  9,  7, 80,101, 51, 67,222, 72, 81, 72,215,
241,240,131, 13, 43, 72,164, 35, 39, 90, 13,211,143, 53,251, 18,224, 56,117,206,
 96,117, 60,243, 11, 44,115,206, 60, 70,182, 28,215,190, 11, 42,151, 96,105,126,
 14, 80,118,150,230,250,110,230,138, 20, 86, 28,100, 74,122, 20,  8, 66,152,161,
186,187,129,250,123,247,193, 46,242,216, 24, 45, 54,205, 46,231,106, 47,197, 88,
241, 70, 30, 58, 60, 68,239,138,138,241,  0,226,107, 72,131,129,  0,147,100, 72,
207, 31,213,132, 18,157,232, 24,119,214,221,173,192,103, 62,221, 71, 21,  3,181,
 97,176,182,197,180, 40,  8,251,142,231, 15,220,164,154, 42, 27,131, 65, 55,232,
 57,154,135,160,231, 32, 40,100,119, 42,204, 60,198, 27,207, 25,166, 16, 84,120,
147,252, 37,174,199,121,120, 39, 40,  8, 72,125,203,125, 11,124,168, 61, 32, 69,
121,141, 81,  8,162,253, 99, 31,248,129, 68, 81,203,127, 41,154,199, 30,136, 98,
176,119,154, 46,121, 55,169, 79,151, 32,116, 84, 42,145, 59,195,143,149,  1,189,
196, 35,103, 58,246,118, 96,158, 76,209,158,242,183,163,171, 72,  1, 50, 77,125,
192, 20,  4,250,  3,220,157,236,241,136,169,133,168, 70,180,115,251, 91,246,215,
133, 54,165,165,187, 75, 12, 76, 63, 10,251,178,192, 34, 17, 79,211,139,236,  2,
123,196, 83,213,205,155, 73,  9,123,168,145,206,251,186,185,157, 72,159,194, 46,
  6, 62, 78, 15,  7, 99,133,199, 67, 67,142, 43,  2,244, 88, 80,115,163, 23, 61,
208, 78, 14, 62,125,215, 29, 40,178,105,  1,130, 83,174,128,224,157,210,  9,217,
 44,151,148,211, 16,233,253,105,157,159, 75, 68,152, 51, 68, 57,205,113,209, 62,
 80,224,232, 10, 37,226,195, 37, 69,123,130,222,203, 77,246, 26,197,230, 42, 44,
 60, 34, 61,255,129, 90,200,137,112,241,212,182,159,224,119,165,231, 73,126, 83,
 56,248, 42,142,124, 43,201,183,187,115, 38, 39, 70,142, 14,132, 56, 60,176,244,
108,114, 61, 57,236,158,172,  5,216, 21,121,140,119,172, 17,218, 93, 79,227, 84,
212,179,129, 25,162,231,  9,120, 32, 15,251,223, 41, 43,210,238,213,172, 67,169,
106,170,105,109, 62,207, 70,249,152,189, 56, 70, 41, 77, 19,250,  2,168, 66,203,
227, 96,206, 65,235,170, 33,182, 87,122,174,166, 72,205, 72,180,134, 62,191,193,
 97, 18,151, 35,170,  4, 63, 20,246,242, 87, 91,243, 20,106, 96, 36,244,167,148,
 58,164, 58, 72,116,180,117, 96,117,181,206,172,150, 87,208, 51,255,192, 50,147,
 65, 67,140, 61,159, 45, 22, 90, 86,156,236, 68,152,  9,221, 35,  9,211,167, 82,
103,243,149,143,140, 41, 77, 94,100, 24,254, 69,115,147,163,236, 72,125,210,  4,
 18,193,192,144,244, 59,253,220,171,134,224,147, 99, 55, 91,112,212, 50,220,  4,
241,203,109,177, 11,224,208, 49, 85,120,  9,153,175, 81,122, 43,132, 53,203,201,
 15,165,219,156, 20, 72, 48,170,163, 43,126,209, 97,103,142, 53,173,195,196,184,
132,210, 72, 30,254,225,249,183, 24,151,246, 33,158, 98,141,119, 41,184,243, 89,
202,214,191, 26,100,176, 55, 61,230,239, 22,200, 37,237,228,185,149,127,166, 39,
127, 12,  4,204,180, 57, 25, 85,225,245,127,207,131,195,241, 40, 21,114, 13,169,
117,247,219,122, 33,102,111,101, 14,239, 12, 24, 80, 46, 23,149,129,208,  4, 94,
206,188,211, 72,144,247,188, 25,178,106, 35, 80,151, 19,154, 44,111,208,105,197,
203,190,130,163,194,165,212,156, 67, 10,192,232, 62, 63,114,245, 32,135,151,  0,
175,153,166,158,143, 51,  5,201, 94,234, 40,249,207, 62, 87, 50,182, 62, 47, 49,
179,134, 67,140,171, 27,  5,175, 45,196,223,184,166, 84, 76,100,131, 89,103,153,
196,133, 90, 77,207,216,159, 26,223,172,127,168,253, 16, 17,183,125, 26,142,225,
208, 48, 72, 34, 26,173,  0, 84,115, 68, 83, 80,104,249,148, 76,224,227,177,181,
 34,215,164,133, 41,131, 23, 72,181, 74,170, 18,231,177,217,159, 21,224,243,200,
 94, 91,182,  3, 86,183,133,141, 56, 69,215, 36, 88,241, 65,117,  8, 30,111,158,
 10,234,100,218,185, 87, 49,  0,130,132,112,197,221,101, 21,199, 47, 57,136,210,
245, 61,  7,136,211,208,208,214,  1,248,130,192,  0,132,142, 36,149, 26, 81,186,
208, 75, 81, 91,230,152,128,245,167,152,161, 37,148,195, 65,137,203, 99,247, 50,
 70,208, 44,176, 55,225,194,203, 87, 18,186,117,167, 40,139, 47,203, 64, 87,198,
169,178,125, 10, 13, 67, 23,200, 30,135,  8,251,160,219,136,177,247,236,  8,  7,
158, 84,104,239, 28,198,231,200, 69, 23,131, 22,165,207,135,157,234,  9,140,145,
 87, 80,107, 52, 68,250,252,124,233, 74, 45,144, 18,151,121,183, 41,180, 75, 28,
217, 92, 98,137,133, 66,174,113, 17,208, 35,246, 47,211,141,102, 34,158,110, 92,
 66, 94, 30, 27, 63,250,192, 78,235,241,153,174,227,194,154,113,139, 80,171, 37,
219,169, 91, 34, 78, 33, 48, 72,178, 44, 40, 89,168,149,178,177,149,228,197, 60,
125,114,209,206,219, 22, 19,142, 48,182, 47,173, 20, 51,130, 31, 71,245, 66, 61,
230,118,  0, 55,146, 15, 80,243, 22, 32,218,246,238,127,206, 18, 58, 67,234,237,
230,232, 77,133,253,  5,235,214,126, 48,248,180, 43,184,141, 85,154, 16, 76,129,
111,212,191,101,  3, 28, 17, 54,230, 69, 10,253,216,140,115,204, 65,255, 10,100,
 93,213, 45, 79,133,121,108,250, 55,133,127, 82,203,226, 58,210,125,  1,159, 33,
156,126,187, 98,  4,181,132,225,229,157, 49,141,101, 88,209, 35,216, 58,117,252,
204, 63,  0,167,  9,120, 84,146,120, 45,  5,237, 57, 15, 26,110,  6, 89,180,216,
124, 56,116,182,232, 18,142,238, 10,173,200, 88, 53, 76, 99,175,238,136,209,146,
104,182,116,190,165,108, 91,166,249, 15,140, 76, 58,133,154,252,167, 10,131,157,
107,131, 89,218,220, 24,  7,159,167, 23,174,195,205,  8,138,144,212,159,165,125,
149,114,142, 29,212,197,181, 39,187,115,210, 17,151,220,162, 84, 64, 27,247,  9,
220,254, 72,186,209,126,172,120, 12,170,143,143, 38, 57,192,215,  1, 81,192,166,
229, 83,199,146,247,185, 37,166, 62, 79,102, 15, 10,145,237, 33,105, 51,236,230,
195,223,133, 40, 46,221, 45,170,121,112, 14, 75,111,228,102, 13, 34,107, 38,114,
 79,184, 23,249,  0,168, 97, 43,126,153, 79,156,209, 19,122, 39,116, 42,153,167,
 53,156,129,105,120,124, 73,209,195,196, 31,249,151,166,148, 74,250,229,237,156,
 17,160,203, 89,144,215,162, 32,243,175, 71, 67,192, 21,107,247, 53, 58,203,134,
 91,202, 29,190,133,161, 73, 23,118, 77,170, 40,106,224, 56, 63, 29, 70,105, 43,
166,128, 60,104,103,144,113, 16,182, 58, 77,209,250,100,114,115, 60,149,213,111,
164, 82,215, 31,237, 95, 81, 92,201,  4,239, 34, 50,250,  1,236,150,125, 12,140,
182,102, 75, 35, 49,244, 29, 44,111,107,181, 78, 73,189,162,122, 24,232,140, 29,
 93,230, 18,204, 31,163, 40, 97, 82, 60,164,124, 20, 35,134, 72, 90,235,211, 45,
200, 86,210,193, 27,108,136,196, 78,108,243,120,188,117, 99,211,134, 83,186, 94,
157,  8,  9, 32,205, 47,156,134,203,  7,138,247, 78, 44, 57,245,142,225,180,173,
 93,146,210,199, 44,211,230, 79,188,223, 52, 37, 13, 61, 37, 12, 56, 13,170,217,
239, 70, 48,213,  2,185,255, 78,121, 20,199,159,  0, 29, 21,101,113,205, 99,231,
134,157,227,236,182, 23,108, 21,183, 54, 66,243, 57,149,205,110,141, 55, 57,118,
108,222, 69,236,177,222,150, 67, 45, 87, 95, 29,154,170,148,130, 56, 19,126,152,
 32, 47, 83,115,204, 85, 91, 92, 77,183, 18,187,238, 32,212,127, 48, 43,245,184,
 89,102,176,211, 50,251,255,189,153, 11, 83,219,205, 68,116,140,147, 54, 54,234,
 41,167,131, 11, 45,245,196,228,125, 66,229, 18, 36,155,103, 27,126, 97,245,122,
184,215, 77, 87,190,121,208,207, 43, 34, 66, 11,185,130,144,113, 93,180,188,127,
 20, 85,138,180,164,148,145,200, 57,169, 91,158,221,197,180,160, 45, 61,182, 34,
 73,134,195,250,149, 26, 88,152, 91, 33,198, 63,176, 55,143,145,130, 15, 41, 58,
 61,193,117,123, 95,250,  9, 93,  3,129,131,164, 20, 13,168,151, 61,170,103,126,
213,233,222,110, 10,141,100,154,  9,191,184,173,194, 42, 90, 24,161,170, 97,137,
  0,246, 65,158,207, 74,140, 50,  3,206, 18,192,208, 44, 20,249, 52, 70,186, 74,
249, 74,192, 80,115, 96,140,220,232,136, 22,249,131, 44,  5, 83, 66,184, 71,101,
 95, 65,130, 49,204, 20,107,  4,108, 25, 89, 32,161,  0, 51, 35, 16, 56, 79, 10,
 73,128, 60,126, 76,253,129,157,254,114, 73, 95,176, 81,245, 28, 58,170,220,166,
 63,187,142, 49, 54, 40, 92,212, 72,171, 70,  5,145, 63,176,186,182,204,212, 32,
  8, 30, 41,150, 96,188, 87,254, 19, 60,203,137,134, 20,106, 52,240,209, 82,235,
210, 88,  0, 60,254, 52,199, 30,231, 82,216,207, 65,169, 81, 15,244,171, 16,202,
136,207, 58,248,100, 68,205,203,246,  5, 97,165, 75,145,254, 87,109,197,  5,110,
164,201,127, 50,189,103,155,170,143, 38, 81,222,  5,179,243, 90,220,196,182,248,
146,210,226, 38,214, 14, 48, 26,159,253,159, 26, 20,170, 98, 16, 91, 33,237, 32,
 47, 95,145,133,147,248,100, 34,221,115,137,116, 37,226, 37,248, 76, 78,207, 82,
 34,242,150,153,242, 45, 14,143,123,139, 44,156,228,131, 44,161,171, 28, 49,241,
237,228, 42,134,153, 26, 62,219,201,237,139, 75, 22, 59,153, 72, 74,182, 19,143,
216, 78,174,  2,219,137, 71, 54, 39, 87, 91,155,212, 92,186,162, 79,124, 58,  8,
161, 35, 52, 88,161,237,124,114, 50,252, 42, 24, 79,132, 27,145,169,183, 20, 94,
186,151, 14,228,174, 44,193,234, 44,108,  3,102,152,199, 36,141, 45, 96, 89,217,
197, 22, 18,187, 27,228, 69, 88,250,158,229, 76,133, 89,109,193,189,248, 98,220,
131,137,237, 89,129,209, 72, 97,171,  7, 41, 94,109, 22,  2,255, 20,184, 69, 55,
228,215,194,168,248,103,117,232,166, 98,146, 66, 78, 21,150, 80, 42,171,112, 64,
 85,237,175,206, 67,100,149,245,220,160,107,173,231, 37,222,224,186,129,146, 53,
 21,  3,157,240,  0,182,118,164, 40,208,178,232,  1,164, 41,186,150,149,226,239,
136, 90, 80, 65,230,165,216,  5, 66, 96, 40,  9, 19, 22,197, 96, 15,188,234,197,
216,254,  2, 95, 60,192,106,  3,  2,155,  0,153,  0,150,  0, 14,118,187,154,221,
178, 70,115,235, 69,243,222,250, 70, 68,252,192,114,119,170,138,188,193,226, 32,
185,128,240, 56, 49,251,153,163,107,158,251,125,161, 34,199, 56, 41,199, 90,198,
230,253, 17,178, 25,122,192, 37,228,220, 69,  3,195, 43, 57,122, 92,152, 11,250,
102, 25,141,  6,234,248,104,144,195,149, 73,224,164,203,233, 30,161,107, 66,191,
117,222, 46,215,145,230, 70, 87, 95, 82,166,109,142,100, 81,  5,211,148,247,107,
 82,237,200, 76,147,212,159,253,246, 50,220,231,121,237, 93,234, 58, 22,104,135,
191,231, 57,152,255,147,101,153,234,247,140,222,141,171,246, 57, 57,214,156, 85,
107, 33,204,205, 48, 80,189, 38,152,  3, 25, 11, 16,184,120,213,140,165, 25,197,
104,239, 36,  0, 21, 36,110,207,211,236, 90, 54, 42,110,215,205,191,171,  4, 80,
 20, 79, 70,202, 77,172, 86,253, 81,243,150, 61,245,240,231,158,147,161,123, 83,
138, 91,188,221,119,182,102, 80, 90,  0,166, 71, 83,251,115,240,110,203,162, 44,
203,170,170, 72,229,150, 85, 57,101, 69, 40,183, 40,175,168,119,249, 88, 38,214,
165, 63,162,221, 37,222, 24, 40, 71, 79, 96,151,249,198, 90, 33,200,242,174,221,
239,104,135, 59,229, 45, 31,187,169,246, 91, 87,151, 92,154,254,194,232,236,198,
186, 20, 11, 28, 82, 64,165, 74,122,168, 38, 15, 52, 46,175,117,231,100,116,174,
156,205,  7,155,148,242,229,235,141,253,136, 73,248, 34,199,216,  3,252,231,203,
199,244,134,203,141,105,138,229, 70,229, 90,252,255, 32, 79, 58, 23, 43, 72,212,
152, 52, 50, 58,246, 48,  7,129, 76,208, 53, 31,225,228, 14,147, 23,206,118,153,
201, 46, 78, 84,106,  9,161,252,152,243, 50, 93,123, 30,195,153,148,191, 58, 20,
218,154,117,168,135,106,250,171,164, 96,249, 52,213, 22, 24, 74,136, 32, 58, 77,
 48,223, 76,171,222, 18,215,103,155,182,101, 38, 68,173,121, 83,175,248,128,209,
154, 49,254, 94,229,156, 75, 87,240, 23,113,150,196, 39, 88, 69,150,172,240,133,
 64, 36,215, 59,137,187,104,142,181,235, 84,219,208, 31,207,227,123, 16,226,239,
 57,231, 31,156,121, 22,201,196,138,188, 39,157,186,250, 49,252,121,230,131,110,
147, 76,172,136, 59,  0,128, 69, 50,177, 34,147, 74,163,118, 71,232, 18, 78,142,
 35,199,199,122,228,224,240, 72,  6, 29, 45,234,116, 58,223,121,215,233,192,124,
175,198, 20,154,202,215,163,133, 90,101,211, 68, 76, 27,236, 19,108, 60,246,162,
116, 83,186,219,245,118,183,205,205,168,125, 10,  8,105,189,185, 94,124, 44, 37,
123, 31, 31,  5,187, 87,197,248, 49,173, 63,223, 72, 61, 98, 88, 21,101,105,250,
139,246, 29,186,164, 80, 42,  9,148,  4,127,205,117,137,160, 73,253,255,232,140,
172,128,124, 80,219,139, 33,172,244, 26, 70,143, 52,  8,  2, 35,129,  0,  0, 12,
141,139, 68,114,161, 60,158,231,105, 28,242, 13,243,194, 98, 29,203, 84,216, 22,
205,239,215, 40,190,242,236,137,146,145,211,102,250,228, 69, 49,  9, 72,156, 13,
210, 12, 34, 34, 66,136,124, 34,240,251, 28,219, 21, 37,246, 78, 13, 94,235,155,
 70, 51, 48,165, 94, 82, 88, 87,207,133,242, 43,201,159, 68, 50,152, 31, 26, 62,
 20,217,175, 71,123,206,206,160,218,173,247,115, 94,243,149,167,251,213,163, 90,
  7,241,162, 25,205, 54,124,  8,175,111,245,237,121, 37,  5,234,125,225,177, 43,
113,140,154, 11,130,161,193,187, 17, 63,251,165,184, 50,152,178, 43,136,106,224,
 99,  5,125, 35,199, 78, 16, 65, 60,120, 91,184,208,200, 86, 56,191, 31,223, 80,
 49,104,222,136, 52,123,255,143,159, 79,  2,128, 62, 65,206,166,112,173, 78,  1,
 75, 31,  8,  9, 71,239,148, 72,124, 85,120,156,238, 32,176,171,134,101,188,184,
118, 18,200, 24, 68,232,108,252,132,129, 43,148, 44,127,193,120,  8,109, 40,137,
222, 31,219, 11,230,223, 55,253,166,162,236,216, 11,108,247,209,175, 90,186,108,
109,162,157,166,140, 94,117,148,227, 57,133,227, 18, 50,213,178,219,220,224, 49,
 50,121,242, 32, 98, 93, 60, 37,219, 37,150,130,112,240, 13,196,125, 36,228,207,
243,152, 47,171,115, 21, 64,250, 99, 80, 47,187,161,147,153,159,166,127,250,233,
 51, 23,135,206,227,155,119, 15,192, 70, 48,182,250,232,  4,208,111, 60,197,226,
147, 64, 31, 87, 98,243, 57,118,224,  5, 22,203, 61,157,158,208, 66, 51, 59, 65,
 74, 40, 26,228,206, 27,126, 39,100,101,230,184,171, 91, 27,122, 57,114, 10, 37,
 48,140, 70,133,106, 41,152,172, 39,207,151,193,116,144,170, 64,102,146,166, 86,
  0,156,153,203, 92,194,  8,139,193, 28,157, 92, 55,193,236,229, 36,178,229, 92,
129,242, 23,244,238,192, 90, 52,253, 41,200,238,178, 60, 46,227,184, 67,  4,140,
243,195,203,210, 62, 61,244,220, 53,230, 53,137,218,222,249,123,184,175,252,222,
 52, 58, 98,228,185,230, 57, 93, 21,129, 16,  7,178,166,106,110,236, 66,171, 57,
 31,100,180,167,117,186, 81,167,124,199, 62,211,147,205,128,159,193,  6,233,121,
142, 71, 30,158,146,216, 79, 80,161,179,106,212,  9,142, 45, 17, 63,228,213,118,
174, 54,240,140,162,223, 55, 69,203,247,  1,106,244,128, 28,118, 53,163,124,158,
 93, 30,159,208,189,126,215,156, 34,234,148, 55,250,145,190,217,  3,210,193,128,
140, 10, 33, 49,233, 68,182,185, 61,182, 56,195,213, 86,198, 86,252,201, 41, 13,
228, 94, 31, 55, 76,234, 36, 29,212,101,142, 58, 97,254,169,  4,173,163,110,180,
  6, 62, 39, 10, 15, 92,179,204,254,173,188, 47,198,238, 20, 48, 87,182,232, 27,
166,143, 44,117,149,133,217,233,198, 96,115,211, 61,193,236, 59, 40,126,155,157,
220,213,134,186,242,250, 26,140,229,116,145, 62, 86, 24,172, 79,132, 24, 23,175,
109,243,190,245,229,129,100,255, 61,241,152,130, 76,115,163,229,222,205, 60,153,
  3,188,215,164,121,  5,206, 11,  3,118, 58,178, 85,235, 68,138,224, 93,140,152,
 23,111,131,202, 87,127, 46,172,144, 79,199,238, 96, 49,184,198, 36,126, 24, 18,
 98,124,145,206, 72,148,252,210, 34,177, 97,230, 86,228,219, 95, 69,109,180,114,
193,240,149,211,169,137,239,246,193, 45, 92,252,121,179,153,118,126,164, 61,201,
 93,183, 11,143, 70, 27,  4, 75,142,215,240,250, 17,215, 25, 25, 91,112, 72,219,
 75, 72, 76,  2,190,127,249, 33, 29,  9,176,199,  1, 51, 27,194, 26,136,166, 60,
125,140,177, 36,112, 76, 85, 84,  5,230,169, 71,  6,  6,253,118, 87, 87, 47,168,
 40,172,  1,110, 10,198, 68,150,148,255,168,  7,165,131, 71,243,193,140, 28,118,
191,140, 58,180, 74,171,159,176,160,175, 83,  7,167, 96,101,133, 25,189, 97, 10,
 10, 56,241,203,243, 75,132,  9,207,151,130,231,134,105,228, 98,146, 26, 71, 88,
231,119,127,220,141,205,171, 11,243, 91, 95, 37, 21,167,195,110,181, 36,112,173,
233, 38,198, 30,155,169,159,233,222, 23,178, 54,227, 83,150,172, 99,170,224, 44,
 13, 64,190,  6,220,129, 82, 72, 87,160,171,174, 62,246,149,  9,226, 50,228, 77,
120,186,141, 23,254, 80,193, 50,142, 25,131,130,212, 54,161,164, 88,119, 55,214,
 65,242, 90, 67,165,128,153,144, 53,236,225,121,162, 90, 69,181, 15,124, 60,112,
 67,179, 91,227,247, 62,178,134,124, 20, 17, 65, 92,244,130,120,232, 66,202,201,
194,147, 20,186,242, 77,136,204,107,223,253,204,228,195,206,173,199,152, 66,145,
 33,124,225, 74,  1,161, 57,160,184,215, 71, 85, 54,190,  2, 96, 55,145, 77,121,
136,125,  1,210,101, 78, 41,  4,135,156,121, 58, 89,128,166, 18, 77,179,178,155,
191,176,  5, 83, 92,147,184,  3, 93,221,222,230,172,199, 80,252, 34,136,211,171,
 19,118, 62,184, 46,114,175,253, 98, 84, 53,148,227, 21,167,134,  4,119,111,100,
184,249,149,254,101,210, 81,223,  0, 66,114, 34,246,224,  8, 58, 73,211,229,174,
 73,177, 39,216,217,178,111,140, 36, 44,103, 74,110,105, 12,  6,250,212,154, 37,
214, 59,113, 59, 64,238,189, 34,156,  2, 21, 67,244, 18,198, 16, 24,232, 44,154,
163, 86, 84,225,234,159,206,237,156,110, 87,188,123, 73, 71,148,225,190,116,  4,
 84, 31,174,223, 97,127, 82, 50,241,153,226,195,151,203,136,210,203,150, 52,216,
  7,193,151, 15,208,251, 50, 99, 11, 50,205,198,136, 51,216, 13, 83, 61,224,185,
  0,219,226,122,248, 40,132, 32,127,152,128, 82,140,135,178, 16,121,146, 23,180,
 73, 92, 42,108,221,228, 82,139, 87, 69, 98,199,201,145, 30,182,172,172, 94,104,
211,171,188,248,167,207,101, 26, 79, 91,224,247,223,123,134,225, 64,121, 18,184,
156,199,143,107,124,103, 92,237,162, 57,245,119, 38, 51, 89,204,244,255,125,  2,
195, 38,139,188, 41,241,186,224,129,144,237, 32,185,200,161,128,106,141,224,107,
 30, 23,195,167, 29,192,113, 65, 70, 65, 97,103,165,183,255,114,144,204,215, 93,
212,233,113, 93, 17,186, 32, 32,214,141, 84, 12, 76,  9, 48, 68, 47, 57,186, 19,
199,124,185,103,182,109, 53,212,212, 92, 93,233, 15,241,107,150, 50,121, 40,176,
 18,162,201, 76,242,233,214,155, 84,  8,167,164, 21, 41, 26, 68, 46,150,226,233,
199,222,163,110, 54, 11,193,195, 44, 55, 85,190, 89, 47, 15,101, 99, 83,213, 75,
 64,255,234,  1, 15, 65,190,238,133, 25,208,183, 64, 12,235,124,235,171,217,123,
 60,125, 99,161,151,239, 23,213, 27, 36,228,205,  6,140,  4, 65,  9,221,174,176,
 92, 42,175,  1,160, 64,167,180,191, 29, 72,143, 60,151,233,102,245, 45, 10, 27,
237,202,187,  8,208, 47,102,119, 48,118, 13,184, 14,249, 44,101,181,157, 16,144,
178,139, 47, 82,246,142,210,228,155,196, 85,239,124, 10, 23,132,167,195,248,171,
 60,196,129,192, 25,114,255,207,229, 82,  4,137, 37, 31, 63,136,183, 16,181,233,
170,232,143,111,153,114,119,198,141,182,185,202,106,199, 92, 87, 16,112, 38, 69,
137,162,193, 40,228, 21, 22,242,  7,224,140,143, 28,150,201,221,168,131,  6, 67,
177,192, 73, 92, 74,169,212, 45,207,199, 11, 11,246, 15,239,163, 46, 73, 70,  6,
219,131,150,214,105, 84,157, 39,240,  1,  9,191,112,229,183,110,151,141,114,136,
 79,190,242,101,233,101,142,171, 31, 27,157,250,225, 67,247,116,212, 84,147, 11,
 36, 58,182, 39,141,132,150, 25,255,171,120, 78, 61,  4,188,157,208,217, 95,142,
122,121,228,192, 93,153,117,227,128,213,113,240,241, 53,253, 70, 89,138,108,172,
  3,223,117,134, 53,181,131, 56,130, 23, 89, 23, 66, 64, 76,220, 27, 13, 40, 58,
 96,215,196,215,217, 26,211, 82,116, 17,219, 29,145, 35,152, 45,130,222,249,147,
 10,245,201, 46,153,179,129,252, 64, 37,214,225,133, 57,218, 70,196,229, 25, 30,
 59,245,  4, 97,236,191,107, 86, 66, 33, 57,225, 97,133, 43,255,252,102, 59,216,
232,249, 31,  8, 66,166,254, 56, 65,207,  3,134,176,144,131,137, 64, 26,140,  1,
197,186, 67,200, 97, 56, 75, 57,179, 47,109,117,  1,171,112,246,146, 70, 28, 74,
130,224,232, 73, 99,110,208,161,237,108,213,137,141,216,143,190,102,133,245,135,
208, 33,227, 86,165, 60,107,219,242,153,241,208,146, 64, 32, 58,180,140, 11,229,
  2, 60,119,218,166, 84, 33,143,222,121, 39,187,219,149,200,239, 41,  1,200,246,
 53,202, 68,176,244,185,225,224,  1,105, 87,157,253,208,140, 23,247,160,241, 15,
 84, 35,165, 79,149,119,253, 90,113, 96, 70, 54,133,128,204, 38,165, 57,174,191,
246,126,129,131,136,110,185, 68,218,207, 54, 71,216,169, 70,225,254,100,248,105,
177, 18, 51,250,144, 88,144,138,144,113, 27,243,191, 50,153, 99,247, 20,194,  9,
127,117,206, 17, 46,110,170,127, 35, 79,106,141, 31, 30,125,144, 79,159,145,157,
236, 43, 30,207,133, 61, 20, 93,137,106, 74,219, 19,233,168, 13,206, 27,123,163,
165,186, 61, 80, 65,232,227,156,200, 20, 95,156,235, 79,132, 22,252, 18,190, 26,
110,142, 37, 41,211,248,208,217, 73,133, 65,123, 66, 79,113,149,105, 90, 73, 17,
227,165,165,160,215, 17, 32, 17, 90,  7, 17,100, 50,148,255,112, 20,151,213,112,
 97,182, 13, 45,212,216,189,251,195, 81, 36,239, 80,  2,178,189,160,224, 54,202,
 95,141, 88, 64,  8, 73,155,115,175,245,146, 29, 66,122, 99, 82,208,235,202,205,
151, 89, 73,253, 81,126,121,189, 71, 10,244,104,118, 99,226, 47,152,155, 13,191,
 49, 86,147, 75, 50,143, 57,231,118, 14, 57,197,  5,125, 76,192,234,221,124,113,
124,112,171, 17,177,154, 54,228,231, 52,126,171, 47,121,252,152,202,230,123,199,
162, 88, 58,212, 50, 58,227, 51,158, 86, 57,104,150,120, 14, 87,241, 66,166, 79,
118,255,198,174, 97, 99,180,105,114,188,156,175,199,115, 29,195,117, 99,147, 94,
110,138, 31, 62,234,162,101,100, 99,  2,228,158, 16, 68, 55,225, 76,160,219,152,
 94,223,215,187,144,250,211,168,  0, 69, 68, 71,193,  7,229,  2, 13,206,197,113,
237, 37,216,134,197, 18,  4,  3,104,231, 71,218,188, 82, 78, 85, 52,127,157,119,
191,  3,201, 36, 58,111,113,187,240,168,138, 59,123,200,157,  3, 13, 48,134, 42,
 57,  2,195,130,211,247, 54, 91,174, 10, 33,183,177,210,213,102,105, 29,  4,147,
127,171,181,250, 19,178,253,232,179,212, 51,176,201,179,188, 10, 64,253,214, 95,
 46,235,205,  6, 83, 23, 54,241, 24, 75, 58,178, 50,145,118,  5,230,105,171, 47,
176,188,133,113,106,171,194,160, 89,208,154, 73, 97,167,246, 77,245,111, 91,138,
 41,213,  6, 77,102,216,243,134,218,161,169,218,192,201,128, 43, 96,131,226,122,
 31, 58,102, 54, 68,105,179, 54, 74, 56,105,214,124, 79,128, 36,  4, 22, 19, 71,
 88,190, 35,158, 42,129,155, 82,180, 94, 56, 23, 39, 71,228,108,116,170, 17,  4,
 50,236,112,205, 54,211, 89,198,139, 84,140,137, 81, 70, 46, 98,223, 80,146, 84,
 97,191, 70, 63, 61,205, 46, 55, 80,131, 47, 71,139,151, 11, 34, 64,195, 40,159,
155,240,  4, 31,149,120,158,228,  3, 11,129,159,194,239,  5,174,239,188,133, 41,
182, 27, 65,191,122, 60, 62, 37, 67, 82,169,113, 98, 48,176,195,108,234,111, 20,
215,225,211,  3, 84, 41,240, 79, 74, 47,118,154,210,193, 13,226,202,185, 48,109,
166,170,222,224, 35,  3, 35,118, 18,176,130, 44, 50,214,167,168,195,116, 95,211,
 18,196,153,231,114,246,116,217,119,197, 93, 16, 78, 49, 99, 82, 76,120, 82,128,
133,207, 58, 40, 23, 53,217,183,195,110,141,179, 22,203,131, 57, 43, 24, 35,218,
124,237, 45, 62,180,  1, 26, 39, 54,187, 96,223,235,118, 59,  9, 14,121,133,137,
 20, 70,215,240,136,214,234,157,238,189, 64,190, 17,114, 76,142,242,227,134,253,
253,237,186, 29,165,  8,122,118, 34,226, 79,136, 17,132,105,103,185,146, 22, 52,
216, 85,181, 47,160,249,115,150, 52,119, 15, 85,165, 23,190,155,237, 86,123,230,
 13, 64,107, 96,138,121, 69,192,118,162, 72, 88, 21,143,206,231, 81, 13,202,144,
140, 40,187,136, 66,131,143,250,  5,119, 14, 88,  7, 79,120, 78,157,250,187, 15,
221,184,187, 29,218,167,  1, 46, 56, 81, 68, 66,100,185, 78, 79,  2,163, 36, 13,
132,195,157, 94,226,128,236,172, 73,164,178, 85,166, 43,157, 57,228, 98,104,226,
154,199,112,110, 33,228,124,174,152,170, 75,231, 10, 61, 20, 34,155, 61,164, 25,
180,245,138,118,157, 51,244, 20, 68,  7, 94,145, 10, 24,237,208,106,135,211, 50,
 32,171, 46,  5,  8,106, 98, 69, 49,144,171,227,158,186,226, 45,234,109, 56,  6,
225, 76, 82,136,188,209,  0,161,213, 58,149,173, 88,138, 47, 64, 80, 99, 16, 32,
 49,252,  0, 27, 26,179,194, 54,181, 95, 64,208,124,117,253,122,185,250, 30,220,
 68,119,  1,219,165,179,  3,173,  1, 63, 42, 62, 69,254, 59,247,160,184,149, 74,
193,113, 11,132,135, 18,138, 65,197,134, 66,222,168,123,119,251,  4,198, 13, 31,
227,216,114, 67,235,126,119,255,128,199,  0,153,227,214,210,173,112,118,128,198,
174,186,248, 48,196, 61, 74,149,237,  5,125, 51,241, 36,101,125, 60,209,114,  2,
 40,243,157,138,112,  1,221,227, 85,240, 91, 91,201, 45,202, 55, 92, 64, 26, 54,
185, 78,  0, 17,190,198, 40,168, 56,235, 22, 29,221, 99, 86,250, 86,  4,161,  6,
  4,249,213, 63, 59, 65,112, 17, 28,143,102, 65,215,  2,180,196,154, 90,250,159,
209, 12,128,196,170,125,107,154,148,  1, 86,240, 30,243, 31, 46,173,113,231,124,
235, 86,155, 23,248,170, 55, 10, 57, 38, 61, 68,234,117,126, 76,  4, 62,100,187,
160,  8,209, 88,238, 51,156,  8, 60,210, 26,206, 44,166,211,213,100,108,115,225,
138,247, 30,  9, 12,129,139,  2,193,137, 47,253,189,118, 31,242,147,159,120,172,
 24,131, 30,152,142,204,181,247,109, 12, 77,110,124, 29,181, 34, 47,108, 34,200,
148,230,164,148,  1, 85,231,110, 26, 93,244, 58, 66, 15,254,211,193,109,129,215,
167, 33,115,154, 12, 81, 98,180,235,133,226, 72, 77, 18,  2,143, 74,  2, 11,143,
 40, 23,170,253,181,195,  4, 35,205, 55,134,141,197,198,172, 25, 32, 22, 92,250,
240,166, 42, 83,237,142, 48, 50,140, 86,253, 41, 62,196, 91, 61, 32,134,254,229,
220,242, 99, 14, 64,170,119,130,  2,196,102,251,123, 84, 39,199, 99,173, 71,160,
255,127,254, 87,135,174, 78, 20, 16, 53,208,213,164,227,142,186, 67, 49,110,195,
107,128,133,248,226, 25,153,219,195,194,173, 81, 19,184,113, 55,186, 41, 70,  3,
157,115,166,181,224,170,217,255, 68,175,127,162, 92, 97,189,166, 32,157,255,134,
 87, 75, 40,123, 26,118, 59, 46,166, 65,125, 52, 99, 35,225,114, 92,162, 50, 45,
105,158, 21,115,120,115, 11, 45,102,204,152, 49, 30,165,211,217,120, 25,172,109,
227,207,137, 79, 88, 22, 80, 99, 26,174,107, 51, 79,238,  0,218,189,198, 96,143,
132, 33,197,  5, 71,146, 29,148,214, 11,146, 78,148,100, 79,199,107,215,228,211,
 52,199,231, 51, 39,117,182,235,181, 77, 17, 95,  5,186,204,180,126,106,231,204,
 38, 90,108, 17,193,215,  3,157,175, 50,182,194,150,147, 42, 27,235, 84,116,192,
134,144,  7, 39,199, 64,251, 69, 50, 35,  2,100, 63,151, 71, 59, 44, 98, 51,229,
 96,109,220,225, 58,  4, 86, 68,232,105,123,155, 66, 22,174,  6,164, 89, 57,225,
 82,220,207,  8, 74, 85, 20, 73,  3,254, 37, 83,248,128,203,119,103, 11,218,190,
 81, 75, 56, 56, 53,204, 74,142,166,113, 18,100, 82,190, 58,135,216,245, 39, 71,
 54, 43, 65,132, 94,100,152, 46,124,108,198,250,227,239, 32,104, 98,223, 54, 59,
  4, 57, 16,146,100,129,236, 98, 89,212,165,193, 41,136,139,145, 61,115, 52, 71,
134,250,147, 83, 19,139,134,139,147, 79, 99,247,113,116,110,160,122, 80,178, 32,
 57, 31, 16,184,136,229,254,254,113,125,253, 89, 44, 44, 76, 20,155,210, 26,182,
218,239, 82,163,  7,132,187, 68,121, 38, 81, 55, 30,111,208, 99,213, 96,148,164,
143,129, 29,196,120, 60,118,119,120,207,219,227,235, 60,142,254, 78,233,139,168,
137, 65,197, 11, 86, 53,128, 21,165,  6,130, 34,160, 32,  2, 97, 44,228,158,113,
120,158, 62,175,145,141, 47,185,118,187,216, 74,209,114, 97, 89, 19, 94, 62,105,
163,231,212,176,138, 34,170,180,202,210,136,200,193,193, 22, 90, 30,  3, 10,179,
243, 73,102,174, 24,187, 29, 90,120,  0,173,213, 93,124,184,139, 97,210,195, 25,
 70, 28, 70,162, 67, 18,125,172, 72, 52, 15,155, 47,170,228,156, 47, 61, 12,172,
254, 37,203,117,164, 86,125, 78, 39,110,170,252,182,  0,244,210,  9,  4, 94, 75,
233, 27, 50,240, 26,108,  7,208,101, 84,221, 15,193,222,  7, 85,203,171,134,133,
 89,218, 85,128, 25,129,181, 98, 99, 14, 50, 72,106,191,163, 70,  0, 94, 25,153,
 30, 19,250, 92, 35, 71,  2, 23,  1,231, 32,190, 45, 47, 76, 73,166, 75,176,239,
 35, 81,201, 63,166, 43, 51, 60,205, 35,133,227, 32,145,216,163,203,159, 93, 53,
118,237, 69,102, 80,160,  6, 53,179,119,125,173,200,156, 48,167,142,122,192,222,
254, 43, 78,233,144,119,191,200,128,129, 53, 74,182,222, 71, 72,193,131,246, 94,
165, 46, 31,142,115,125,  1, 81,171, 70,254,245, 94, 48, 82, 70,244, 90,131, 99,
246,117,117, 52,128, 78, 64,164,219, 20, 27, 11, 69,232, 13,156,108, 73,114,237,
131,170, 54,219,147,183,  2,253, 54, 59,178,  9, 61,  1, 76, 57, 66,229,  8, 22,
 22, 57, 67,220, 41,108,141, 51, 47, 83, 22, 43,101,159, 21,127,192, 56, 37,232,
169,225,210, 84,136,166, 74,112,122, 53,202,247, 30, 51,218,230,199,244,160,102,
 80,206,112, 37, 74,239,203,161,152, 56, 37,254, 71,121,255,227, 80,108, 23,228,
 45, 24,  8, 67, 10,106,221,168, 62,168,203, 45, 11,210,172,101,189,251,216, 57,
 21, 36, 10, 57,  5, 84, 43,207, 35, 31, 21, 82,  4,186,104, 17,140,164,109,  7,
 71, 51, 21, 58,182,171, 57,108,224, 15, 26,190,118,162,196,156, 99,225, 94,177,
 91,170,172,141,140,  5,186,157,190,108,219, 33, 78, 80,137,  5, 50, 68,199, 98,
239,174,129, 65,169,143,245,214,168, 82,238,247,149,135, 51, 72,144,161,133,255,
142,127,192,195,234,120,152, 44,135,114,105,141,242, 73, 51, 87,199,183,182,152,
 64, 52,  9, 65,120, 99,254, 99,218,118,194,177,248, 70,149, 55, 53,228,103, 82,
198,168,119,201,105, 13,207, 96,  4,161,161, 43,122,234, 72,  4,220, 22,196,  9,
189,199,165,224,111,  9, 70,198,115,147, 59,176,231, 20,229,167,159, 71,160,  7,
133,240,148,205,  5, 77,249,199, 95, 12,226,236, 23,243,149,192,109,115, 82, 89,
219, 25,128,  8, 41,233,145,237,157,186,134,240,171, 18,126, 40, 41,131,117,236,
  9,105, 72, 39,182,117,147,204, 24, 60, 66,104,160,  4,249, 63,220, 28, 35,143,
 54, 71, 18, 29,232,  9, 56, 57,110, 33, 48, 95,161,242, 24, 10,236, 85,248,  0,
 90,250,155, 66,140,189,  8,106,200, 27,148,223, 93,214, 58, 44,185,118,186,153,
 32, 97, 57, 45,228,224, 76,203,243,109,135,168,202, 97,  9, 40,138,182,219,152,
 13,189,130,101, 21,171, 42,116, 78,174, 64,165,125,101,146,196,132,111,202,231,
248,115, 80, 83,247, 36, 69,229, 54, 16,117,149,156,226, 70, 53,161,129,166,104,
243,139, 81, 22,179,118,103,227, 60,140,203, 31, 84,151, 23, 37,107,140, 56,171,
151,133,109,116, 96, 75, 95,213,255,188, 32,122, 93, 81, 52,113,173, 75,218,162,
110,105, 57,205, 85, 22,214,102,207,124, 29, 16, 73, 37,174, 96,142, 39,116, 90,
  7,155, 10,155,192,237, 82,200,162,182,255,209, 73, 89, 60, 49, 75, 19,164,203,
228, 72,  4,  4,163,105,  4, 21,193,197,148,239, 50, 24,197,111,  5, 73,233,217,
221, 81,191,137, 44,217, 54, 80, 15,236, 25,248,187,227, 85, 63,168, 22, 35,160,
168,159, 38, 16, 14,175, 24,  1,  2,255,140, 62, 22, 12, 62,  8, 78,140,122,170,
 42,196,113,164,126, 74,239,238,228,245, 81,162, 33,  6,193,153,139,103,148, 80,
 71, 21, 63, 13, 72,101,222,125, 86,233, 78,202, 49, 15,140,126,150,246, 13,160,
  1, 69, 21,173, 42,213,120, 50, 63,242, 88, 28, 47,117, 53,194,212,135,106,114,
 17,  6, 29, 47, 91,204,191,185, 88,211, 44, 99, 38, 69, 82, 39, 41, 91,207,143,
 86,106,  8, 20,234,158,202, 43, 71,155,235,206,175, 99, 91, 34,197,135,152, 15,
 49,203, 85,217,242,119, 95,114,116,193, 32,178, 54, 88,231, 71,238,142, 29,149,
203,192, 36,  4,235,  7, 50, 24, 17,241,124,151,157, 51, 71,234,194,212,199,227,
  5,188,184, 88, 26, 83, 52,162,201, 58,147,177, 53,206,128,169,109, 29,194, 14,
100,129,164, 37, 57, 49,229, 54,111,  4, 33,165, 95,122,218, 20,196,155,153, 59,
 48,230,254,243, 58,128,198, 83, 64,253, 26,165, 37, 57,253,103, 65, 85,161, 21,
243, 23,227,207,120, 47,210, 30, 45,195,131, 58,  9, 98,111,152,  5,189,204,107,
 93,107,138,223,238, 87,203,  2,132,  7,223,103,115, 59,107,127,149, 98, 46, 28,
 81, 26, 78, 93,240,197,241, 94,225, 70,130, 29,195,139, 70,171, 84,117,180, 86,
 84,166,207, 27,104,121,171,105,118,197,238, 35, 71,  7, 43,134,  4, 45,158,245,
194,209,  0,149,  5,159, 68,249, 38, 36,184,253, 51, 98,  8, 34,213,193,119,112,
 54, 65,125,159, 57,164,249, 98,  2,247,247,145,142,230, 76, 64, 50,214,224,225,
185, 55,176,183,184, 46,169,  1,106,214,  2,203, 52,165, 39, 50, 57,191,129,213,
 16,222,249, 44,197,  1, 62, 14,  8,150,158, 45, 98, 90, 47,144,201, 33,  1,  3,
128, 30, 20,167, 56,204, 75,119, 36,196,159, 70,198,162, 28,228,207,248,  2,101,
163,215, 67, 19, 24, 82,211,165,213,181, 44,216, 27,171,220,164, 42, 23,103,191,
188,107,212, 16,217, 94, 71,149,237,175, 16,229,110,205,129,  0,232,140, 40, 53,
110,178,205,219,216,160,  8, 20, 37,116,149,164,134, 72,120,146,211,123,113, 55,
110, 33,153,147,207, 83, 10, 72,181,224,145,125, 27,113, 10,229, 91, 59,216,102,
246, 13, 66,235, 96,204,238, 25,218, 85,112, 61,108,187, 14,236,246, 94,182, 31,
 22,162, 77, 90,155,202, 96, 77,254,224, 15,159,190, 71,200,206, 92, 78,209,213,
240,234, 86,108,140,114,187, 45, 41,153,115,245,230, 81, 65, 17,163, 97,202,136,
195,109,108,244, 25, 15,254,142,136,237,207,109,138,182, 37,112, 30,191,214,246,
187,227,111,216,253,134,162,235, 34,197,  3,155, 41,115,185,136,151,217, 46,130,
182,140, 90,177,112, 95,235,171,188,169,141,202,120, 95,231,222, 18,205, 75, 67,
 82, 40, 13, 30,  7,107,122,150,165,189, 35, 93, 42,  1,232,238, 98,183,240, 51,
133, 23,123, 68,165,109,156,241,217,228,250, 53, 93,197, 52,254,198,163,177, 26,
 77,248, 45,206,227,153,182, 41, 37, 78,119, 69,187, 76,  4,115,206, 96, 69, 76,
179,  2, 38,100,139,213, 19, 39,238,111, 85,161,238, 50,105,131,189, 25, 21,122,
227,146,211, 69, 30, 85,252,  8,141,235, 29,145,155, 36,115, 60,251,  4, 10,169,
 31, 23,114, 18,241, 99,184,  3,108,190, 23, 75, 67,238,193,127, 67, 81,189,111,
117,146, 79, 29,179,105,105,121,255,101, 68,232,248, 85,137, 24, 97,236, 47,146,
242,210, 65,242,135,155,  7, 46,159,169, 25, 21, 87,199,172,121, 84, 46,146,241,
 63, 44,174,186,  2, 72, 70,188, 75,150,213, 48, 52,100,232,131, 49,143, 58,149,
149,128,214, 22,110,  7, 24,231,218,  0,219,123, 49, 19, 32, 39,151,252,167,209,
 57,129,130,199, 16,101, 13,238,164, 77, 98,226,230,222, 83, 97, 47, 97,186,124,
199, 65,203, 90, 32,193,251,195,240, 98,224,229,126,231,229,  0,102,124,194,163,
 22,  3,120,251,185,114,112,243,127,142, 20, 93,251,179,113, 89,112, 61,111,151,
253, 73,128,223,162, 68, 35, 23,187,109, 58, 84,108, 11,167, 98,252,187, 29, 58,
220,243,244, 26, 31, 67,139,249, 49, 37, 53,107, 66, 48,254, 64,193, 71,246,178,
178,  7, 98,111, 22, 70, 65, 23, 32,  3,156,218, 42,225, 35, 68, 93,107,226, 34,
 61, 12,133,232,170,181,201, 37,252,141,184,243,  2,  3,175, 69, 64,234,207, 64,
228, 76,232, 89,253, 75, 54,113,224,230,183,185,199,  0, 92,218,153,132,245,  0,
 23,163,167,105,180,106,  6, 58,198, 21,117,255, 71, 13, 26, 81,249, 56, 26, 31,
177, 46,107,127, 95, 61, 42, 90, 80, 58,214, 95,158,140, 20,190,190, 81, 71, 85,
232,109, 11,129, 43, 50, 11,101,152, 78,247, 20, 56,103, 70,254,103, 45, 52,210,
177, 59,207,241, 37,151,135,229,114,128,117,206, 50,116,129, 73, 44,119,161,125,
195,196,222,144, 38,111,238,156, 81,139,108, 21,155,102,225, 11,252,195, 96,135,
 46,143,206,223, 94,194,204,236,197,100, 95,189, 53, 59,208, 26,122, 46,136, 17,
230, 55,104,230,162,115,232, 77, 62,  8,247, 14,189,  5,205, 48,169, 66,186, 43,
 40,202, 76,230, 89,252,134,169,216,223, 78, 25,212,167, 88,215,176,171,139,106,
195, 66, 61,145, 61, 88, 38, 48,157, 34,203,197,162,109,227,180,236,  1,114,153,
217, 33,135, 90, 98, 28, 57,155, 90,235,220,172,216,  3, 76,190,  7, 24, 66,202,
 77,212, 31,179,215, 40,247,128, 18, 22,200,112,231, 67,242,139, 95,134,140,239,
226, 22,131,183,201,161,143, 39, 99,160,178,108,104,129,137, 40, 61, 10,247,118,
144, 45,  0, 63,119, 29,147,151, 32, 88,158,213, 12,232,166,199, 94, 52, 50, 55,
162,142,243, 53,209,144, 47,149,155,107, 92,179,153,209,253,101,239,151,236,210,
 10,118, 90, 20,242,229, 10, 30,235,127,160, 69,211,243,101,185,175,248,230, 12,
239, 21, 92,101,206, 25,214,180, 40, 44, 65,239, 50,161, 22,148,240, 35,120,184,
 77,  4, 62,202, 61,125,235,251, 58, 50,169, 33, 43, 72,229, 82, 40, 49,179,170,
  6, 47, 14,117,220,188, 80, 28,110, 62,134, 35, 30,  7,200,209, 70, 40,150,117,
 85, 44,219, 99, 77,224, 96,216, 43, 57,132,146,114,163, 71, 74, 65, 45, 52,151,
111, 56, 77,  6, 49, 66,144, 37,200, 16,228,208, 15, 61,122,110,158, 21,163, 60,
238,167,249,195, 11, 12,225, 61, 55,138,111,  2,106,116, 85, 25,170,189, 89,177,
139, 63, 76, 59,160, 48, 42,198, 80, 82,106, 75,198,104,228,144, 22, 39, 77,163,
  3,218,240,216,112, 76,153,114, 19, 37,152, 65, 96, 78,108,234,248,  8, 87,239,
176,169, 11,249,157,161,137,215,217, 37,112, 26,234,207,188,175, 22,134,113,210,
189,206,236,143,225,224, 39, 41,200,128, 95, 90, 71,166,131, 65,142, 15, 45,158,
188, 92,243,169,229,133, 88,118,198,254,165,103,249, 78,180,139, 99,  8, 50, 56,
 71,129, 94, 67, 73, 37,229, 77,185,240, 77,130,165,243, 15, 11,141,202, 76,216,
 96,250,130, 48,156,186,178, 66, 81,177, 69,168, 45,247,101,  1, 93,147,103,147,
232,227, 48, 38, 27,123, 60,145, 21,234,227, 28,245,158,164,  6, 52,175,122,193,
 14,222, 11,147, 36,239,236,138, 66, 51,134,152, 61,162, 29,172,129,238, 89, 65,
209,118,204,  9, 19,207, 64, 76, 63,144, 76, 83, 96,197,189,229, 15,183, 91,254,
215,255, 68, 16, 89,177,  3,255, 34, 89,192,  1,181,218,114, 16, 72,160,246,149,
191,243,124,241,130,202,108,152, 56, 44,108,127,211,218,173,221,250, 63, 10, 99,
202, 10,212,223,186, 92, 86, 18,176,162,226, 44,179, 34,173,175, 12,  5,135,176,
107,219, 19, 84, 88, 29,140,189, 37,142, 86, 44, 38, 17,215,243,152, 74, 65,195,
 45, 51,188,129, 42,115,149, 25,101, 54,236,133, 93,230, 76, 64,208,217,238,124,
 36,174, 93,164,218,218,120,120, 85,162,169,118, 42,  2, 89,121, 60,201,183,201,
 81, 65,224, 71,147,165,199,145, 13,159, 92,132, 63, 46, 19,225, 79,225,239,174,
209,205,109, 40,147,147,165, 63,171,244,230, 52,130,205, 14,180,  9,  2,145,121,
158,253,  4, 97,212, 23, 25,174,188,167,234,172,182,141,150, 86,108, 17, 51,181,
220, 88,117,180,158,204,114, 85,249, 24, 99, 21,128,245, 29, 58, 42, 16,108,234,
246,213,226, 94, 28, 10, 40, 87, 37,113,219,166,184,254,246, 13,179, 92,207,251,
206, 38, 56, 40,163,213,225,143,199, 82,  2, 62, 80,109, 86, 32,153,234, 90,240,
 24, 92, 51, 26, 95,189,127, 70, 14, 55,205,215,219,152,160,129,112,110, 24, 68,
 44,  4, 13, 16, 76,221,215,130,126, 60,  4,  4,  7, 58,171,179,143, 12,166, 23,
111,197,244,232,167, 49,116,189,113, 54, 85,113,129,231, 13, 23, 18,157,181,215,
133, 80,146,196, 51,208,103,189,157,225, 92,220,  6, 10,149,  6,192,183,250,204,
164,229, 59,108,206,226, 32, 50,133,212,128,161, 98,160,  3,150,175,235,173,217,
177, 94,203,240,236,236, 49,155,237,176,  7,208,214, 78, 83,  8, 52,183, 74, 32,
129,103,235,106, 96, 82,104, 47,100, 49,138, 72, 24,198,198, 87, 32,147,219,152,
116, 75,219,224,  7,131,190,177,216, 81,216,180, 48, 82,169, 66, 23, 76, 12,124,
 34,221,203,244,  2,228,203,244, 21,226,194,252,252, 10,177,159,  6,241,191, 71,
199,203,  4, 68,134,  0, 32, 37,104,132, 63, 45,172,228,192,205,214,184,160, 31,
169, 58, 18,243,254,193, 24, 67,129,132,  4,227,189,139,180,148, 63, 96,112,200,
112,202, 97, 94,104, 59, 46,250,242, 48,250,185,160,139, 69,211, 80,183,240,217,
111,106, 93, 76,213, 50, 50,124, 24,165, 85, 96,232,131, 38, 17,101,163,236,128,
213,237,118,167,228,242,231, 61,  5,  0, 93,  7,253,218,110,199,224,104, 41,233,
 59,130,123,180,161,132,231, 53,122, 95,189, 48,208,240,177, 43,107,  6,203,142,
 65,239,233,192, 47, 43,171,245,252,231,111, 72, 87, 71,149,198,211, 53, 60, 22,
124,224,120,175, 54,143, 76,153, 89, 78, 21,149, 11, 18, 63,224, 92,142,116,169,
101,177,103,  6, 86,208,248, 95,254, 44,  7, 51, 48, 21,130,182,160, 31, 75, 66,
164,221,252, 14,189,101, 80, 66,248, 34,126,222,134,195,181,146,103,188,177, 24,
206,  8, 15,211,124,250, 24, 33, 39,113,182,  4, 86,198,138, 25, 25,115,217,181,
 23,153,171,164,111,182,194,124,255, 16,125, 57, 10, 46,189, 16,191,125,128,107,
 86,136,123,175, 80,182,229,172,201,174,130, 51, 77,191, 86,224, 87, 39, 40,177,
183,245,225, 45, 70, 65, 87,111,123,104,169,185,115, 18, 14,226,210,145, 91, 24,
 72, 81, 29,169,108, 72,207,114,226,167,195,104,224, 94,128,163,222,138,147, 50,
 11,247, 36, 28, 94,103,158,230, 75,122, 94,144,190,  0,163,145, 96, 51, 10, 90,
 95, 98,  0,227,150, 71,103,174,209,188,  1,125,172, 29,146,234,207, 25,100,156,
146,215,154, 86,  5,149,217, 74,222,139, 16,119, 45, 13,  1, 91,185,129,106,140,
172,249,186,208,101, 49, 54, 66,252, 59,166, 73, 59,252,140,220, 87,  3,246,121,
223, 73,251,189,130,221,102,175, 52,165,153,111,211, 22, 77, 97,161,174, 70,105,
 20,109,205,  2,248,137,187,104, 94,  4,241, 26,233,221,247,228,197, 68, 69,197,
 88,181, 38,236,179,183, 36,207,195, 22, 58, 48,185, 33,215,238,  4, 11, 56,175,
  7, 36,169,174,161,117,120,144, 12,205,124,116,227,227, 28,  8, 22,153,  8,109,
 16, 25,246,161, 39,232,218, 50, 34,102,212,206, 30,180,157,215,130, 26,  8,195,
108, 30, 70,248,158, 72,230, 85, 45,181,245,181,198,194,140,169,128, 65,254,141,
246, 11, 22,106,125,192,137,206,192,239,185, 56,148,105,123,141,129,249, 58,236,
 10,169,  5, 13,152, 80,  1, 15,212, 60,118,  8,211,155,211, 86, 22, 27,174,144,
 73,231,232,139,124,199,107,  0, 16,  9,178, 82, 80,170, 50,226,246, 24, 12,167,
 81, 41, 82, 23,242,214,216,198, 31,124,189,206, 83,146,200, 59,116,239, 85, 84,
 70,218,  8, 11, 17,114,205, 19, 23, 42, 41,198,138, 57,241, 99, 75,240,198,245,
 51,221,132,214,129,184,199, 50, 14,149,  2,215, 83, 89, 77,  2,222, 27,112, 93,
174, 23,220, 38,198,179, 48, 87, 46,146,188,211, 56, 48, 79, 12, 83, 32,172,154,
102,234,144,132, 97, 98, 12,221,244,133, 45,139,  3, 86,100,  4,158,175,  2, 23,
175,191,134,215,219,  2,157,222,  9, 19,235,150,212,  9,  6,105,240,106,170,175,
  5,211, 53,  6,
} ;

// ../Source/Template/GB_AxB_dot2_meta.c:
uint8_t GB_JITpackage_1 [2052] = {
 40,181, 47,253, 96, 55, 47,213, 63,  0,150,252,182, 41,176,146,217, 28,170, 70,
 99,199, 27,154,246,231,168,157,119,146,207,118, 82,  3,243,132, 49, 82, 91, 51,
 80,138,156,226,249, 32,142, 31,244, 31,244, 95,120, 40,  1,170,  0,170,  0,175,
  0,249,222,230,167, 96,177,195,209,119,177, 69,109,223,226,124, 37,173,119,118,
126,146,207,125,241,255,135, 64, 58, 32, 24,148,219,  2, 62, 60,218, 49,224,221,
141,149,179,212,162,121, 52,109,169,215, 93,  4, 66, 81, 44,147,254,184, 25,202,
 95,196,166, 30,205,182,187,205,164,177,109,142,114, 38, 20,154, 15,165,107,145,
216,184, 65,199,249,187,160,160,215, 42, 63, 25, 88, 40,203, 36,161, 66, 89, 46,
225,164, 79,152,138,166,230, 20,249,209,151, 47, 72,181, 79,153,228, 84, 95, 56,
197,135, 75, 99,113,134, 89,103, 58,102, 16,156,185,177,187, 98,248, 79, 42,  2,
 16,239, 51, 24,131,245,169, 34, 24,144, 24,235,151,153, 27,220, 44,249,118, 91,
181, 33,183,234,225,  5,  5,144, 73, 65, 65,159, 10,  8,128,234, 24,207,189, 50,
144,252,100, 21,165,161, 48, 51,169,194, 10,226,209,206,118,142,145,142,169,247,
134, 26,215,182, 54, 76, 55,139,115,117, 64,151,196,166,109, 34,188,238, 60, 26,
177, 93, 69, 25,135, 50, 19,235,152,135,172,103, 14,183, 72,160,176,112,  9,135,
 51,225,112, 15,143, 75, 44,233, 31,137,105,155,106,203, 54,210, 53,208,149,101,
114,225,212, 49,199,117,138, 44,247,188, 29, 32, 80,218,222,238,182, 63,141,207,
223,108,233, 51,184, 25,194,180,214,209, 43,  8, 39,152,105, 72,195,246, 82,108,
 27,164,157,216, 32, 62,158,223, 55,168,152, 39,120,235, 25,139,212, 59, 40, 94,
239, 26,183,214,249,225,237,230,119,157,237,229,166, 60,134,150,222,222,143,250,
 11,154, 43,243,124,178,142,  4,105,155, 38,101,135,164,107,124, 67,108,167,152,
183, 77, 86,238,233,216, 49,146,179,237, 16,252,181,159,142,233,173,183, 56, 89,
127,135, 71, 33,  1, 28,165,243,172, 33,216, 57,224,203,116, 67,168, 32, 84,164,
118,213,105, 41, 40,118,230,144,174,101, 29,142,236,108,176,237,  2, 73,142,117,
105, 36,210, 37,146,132, 97,191,188,  1,147,176, 15,230,177,254, 16,188,156,102,
 77,128,180,108,147,200,228,184, 97, 88,  4,203, 68, 24,172,133,144, 61,193,155,
163, 21, 79,123,204,113,  6,158,217, 94, 90,150,101, 65, 30, 58, 27,208,  6,187,
178, 13,180,169,232,200,170,170,170,106, 67, 34,109,104,154, 38, 63,  0,151, 82,
 74, 41,165,148, 82, 74, 41,165,148, 82,134,114,122,  7, 93,  1,144,138,203, 76,
172,143, 10,149,153,100,240,121,107, 14,138,  1,198, 94, 56,192,229, 82, 73, 23,
217,209,107, 47,248, 47, 83,141, 91, 58,201,149,142,161,215, 58,127,193, 34,  5,
 27, 95,186,122,191,119, 23,150, 94,143,190, 59,166,215, 92, 22, 27,142,220, 88,
215, 39,171,147,114,157,153, 48,201, 53, 27, 79,199,131, 29,195,176,105, 82,232,
122,172, 83, 28, 37,121, 98,131,124, 59,233,185, 67,183,216,193, 47, 18,201, 54,
216, 21,187,116, 93,239,187,134, 40,190,165, 66,141,166, 70,157, 17,134, 14,200,
 72,188,153,155, 30, 69, 85,100,133,170,100,117,  1,129,227,198,147,187,193, 79,
153, 62,170,153,114,148,118,247,203, 13,222,114,204, 79, 85,168,143,234,212, 43,
150, 53, 77, 50,130, 71,168, 98,212, 78, 41, 26, 25, 25, 41, 72, 82, 88,214,146,
 41,132,  1,105, 22,136, 97,106,249,194, 88, 52,201, 16,  9,196, 97, 12, 33,136,
 17, 39, 32,  4,  9,136, 34,129, 72,100, 18,200,  4, 51, 10,212, 28, 52, 39, 74,
 35,200, 92,169, 75,101,112, 96, 77,121,195,185, 12, 80,153, 43,131,212, 61, 45,
176,150,227, 87,105, 77,117,173,227,194,191,186,161, 66,128, 25, 11, 16, 50, 18,
 82, 24,134,243, 17,148, 99, 12,176, 54,249,180,170,164,  9, 10, 40,156, 77,161,
 10, 44, 52,211,236, 11, 91,209, 57,161,202,238,102,255, 38, 27, 74,172,255, 32,
  4, 38,227,145, 46,  4,194, 98, 73,246,176, 45,161,113,195,109, 83, 41,126,168,
251,222,158, 80,143,216, 59,246, 85,228, 81, 20,226, 40,237, 77,163, 81,153,168,
 70, 20, 63,138,238,119,152,133,195, 28,184, 50,241, 92, 50,154,102, 54,145, 75,
177,225, 40, 59,149,188,  9,187,144, 88,174, 87,  4,140, 18, 97,176, 33, 16,129,
 86,224, 75, 54,  5,194,209, 27,144,237,218,188,110, 72,139, 41,  3,229,100, 58,
163, 69, 25,209,171,142,240, 13,201,197, 37,  9,154,146,185, 91, 66, 85,245, 83,
120,101,216,  3,212,187,156,101,115,166,176,138,162,188,151,143,212, 98,216,186,
120, 34, 98, 39,112,197,148,180,247,118,168,198, 54,248,170,193,193,120,147,167,
 96, 69,120,178,252,192,253, 50, 72, 64, 93,190,152,215,170,  5, 57,230, 85,149,
182, 49,120, 84, 69,249, 49,169, 14,181,198, 88,179,172,221, 41,236, 72,198,201,
245,157, 23,112,211,127,171, 59, 93,147,220, 85,112,108,112, 27,217,155, 56, 75,
216, 65,116, 10, 52,118, 38, 61,232, 39, 61, 93, 25, 46,132,115,167, 50,191, 50,
152,214,212,  2, 43,116,223, 83,185,122,139,241,227, 48, 36,213, 83,158,212,174,
171,225,162, 80, 53, 74, 67, 57,128, 89,160, 58,227,213,206,130, 49, 14,138, 95,
 16,202,107,215,241,179, 85, 12, 51,111, 47,203, 93,223,150, 83,248,151,131, 82,
157,165,135, 95, 84, 25,110,248,102,114,146, 54,229, 87, 43, 56, 91, 91,130,  2,
 49,124,202, 93, 56, 18, 56, 45, 86, 36,158,225,231, 79,181,255, 86,110,174,101,
109,218,168,180,247,232,175,149,195, 44, 58,173,190,142,149,184,131, 72,154,248,
216,248,  1,121, 12,  2,153,224,112,120, 48,161, 61,254, 37,226,131, 31,187, 19,
  3,121, 51,220, 68,249, 55,  7,251,199,195, 28, 87,111,104, 19,152, 21,178,148,
 17,102,216,116, 77,108, 92, 71,149,173, 41, 68,162,195,112,  7,105,223,167,179,
  1,196, 20,223,  1,158,205,128, 30, 29, 68, 89,165,216, 27,202, 50, 58,214,128,
 11, 82,206,162, 62,247,133,224,243, 11,189,162, 77,202, 19,213, 59,170,179,164,
119,146,132,216,155, 31,151,129,182, 91, 99, 39,226,102,186, 16,101, 17, 31, 31,
196,229,144, 78,229, 26,125,138,129,170, 53,251, 28,225, 17,156, 84,103,176,244,
208, 36,201,253, 38,172,237, 11,115, 21,130,163,246, 71, 67,231, 33,244, 14, 57,
 53,106,227, 54,173,123,128,119,212, 70, 93,134, 36,165, 80,229,231, 37, 63, 85,
 93, 41,111,130, 81,212,229, 34, 19,172,151,140, 46,191, 83,210,252, 68, 72,218,
 72,188,112,194, 33,105, 14,  9,121, 81,132,169,215, 33,114,222,150, 79, 72, 54,
144, 64,120,158, 12, 42,136,200,122,117,118,123, 66, 61, 48,143,242, 64,155, 79,
141,139,207,187, 44,105, 38,186,143, 66,151,240,253, 53, 23,222,177, 92,220,169,
 35,217,202,229,102, 58, 49,213,245,130, 81,143,184, 53,200, 63,102,136,125,237,
249,145,218,110, 65,165,125,126,218, 75, 20,130,131, 26, 19,207, 11,186, 68, 29,
141,130,205,201,129,  4,102,242,149,168, 55,107,232,129, 39,109,183,135,224,114,
 21,152,124, 79, 46,123, 31,188,198,212,233,181, 65,254,189,217, 81, 79, 34, 37,
 81,212, 46, 46, 23, 20,  5, 64,110,210,174,110,102,213,121,160,148, 79,213,106,
 89,211, 84,137,117,186,137,162,100,131,192, 25,181, 30, 57,200, 68, 63,201,118,
 91,252,228,201,222, 93,252,245, 21, 19, 78,100,237,215,168,132,211, 66, 27,  9,
248,  8,131,182,249,125,140,202,185,223,164, 62,127,134,160,177, 73,202,211,192,
139, 79,123,124,156, 69,130, 26,214,165, 11, 66,144,235, 90,174,  0,212, 83,222,
140,201, 38,143, 64,165,108,204,169, 32,  7,231, 87,106,250,128,244,184, 10,132,
125,193,114,195,103, 43, 29,188, 97, 49,228, 73,227, 10,172, 30,254,248, 77,236,
200, 95, 36, 22, 53,148, 57, 16,231,194,174,127,118, 20,198,237,159,108,  6, 98,
104,132,  3,251,150,216,168,146, 18,131,222,191,  1,  1,  5, 87,213,223, 35, 77,
224, 60,240, 37, 86,230,104,110,183, 28, 45,125,226, 64,204,167,  0,204,174,221,
 66, 99,126,236,193,143, 54,181,115, 67, 22,139, 20, 58, 83, 42,246,184,129,200,
 26,227, 67, 31,152, 11,170,104, 55, 16, 84,211,118,191,135,170,146,151,240, 33,
 10,208, 75, 96,246,168, 69,245, 49,194,235,193, 63, 12, 32, 27,202,144,187,109,
  2,247, 69,151,149,128,152, 73,209,221, 67,100,226,105,112,174,209,149, 66,189,
231,194, 38,247, 59,219, 68,232,108, 50,110,  2,181,  7,229,123,130,223,132, 63,
  8,184, 38,247, 91, 93,183,  5, 20, 43,163,250,175, 99,111,205, 84,252, 53, 30,
 31, 23,136,178,248,170,133,156, 50, 72,133,157, 19,145,198,128, 14,158,190,101,
250, 33,114, 15,229, 94,208, 62,209,229,212,  4,  7,189,  6, 59, 41,122,138,100,
253, 88, 60, 55,100, 80, 98,223,249,253,255, 88,132,  3, 80,137, 41, 83,236,115,
205,208,205,  5,241,107,112,227, 27, 63, 33, 65, 51,152, 90,239, 61,111,167,180,
213,129,202, 49,169, 71, 47, 66, 40,218,134,110,116,223,202, 31,144, 85, 44, 38,
233, 87, 45, 33, 63, 64, 42, 94,207,144,108,250, 20,202, 78, 82, 25,115,148,247,
 90, 46,167,183,133, 26,  7,163, 65,243, 66,203, 76,217,141,248,207, 53, 96, 33,
129,  4,123,130, 25,108,217, 71,171, 35, 95, 14,
} ;

// ../Source/Template/GB_AxB_dot2_template.c:
uint8_t GB_JITpackage_2 [2026] = {
 40,181, 47,253, 96, 53, 32,  5, 63,  0,170, 69,252, 12, 45,160, 78, 25,235,184,
194, 44, 82,108,249,122,136,121, 98,176,241, 11,253, 82, 96,190,194,181,190,  6,
247,144,161,156,105, 67,140, 81,  0, 68, 30, 94,193,235,240, 58,104, 29,158, 42,
193,  0,202,  0,193,  0,207, 69, 88, 78, 77,242,199,194, 37,243,126,155,213, 99,
251,214,100, 97,198,  8, 63,246,205,171,241,149, 51, 11, 77,117, 74, 44,103, 93,
 47,220, 46,136,202, 62,127,238, 61,215, 31,169, 76, 67,159, 87,214, 96,121, 42,
 70,144,135,194,237,118,231,147, 61, 87,248,234,154,132,119,142, 73, 36,  2,194,
159, 12, 82,119, 74,229,246,244,149,172, 93, 16,182,146,179,190, 64, 32, 84, 52,
 17,141, 53, 42, 91,222,220,222,207, 69,111, 30,163,251, 68, 32, 98, 18,  1, 57,
  0, 49,137,184,148, 69,159,108,107,192,202, 35,238,161,207,157, 91,115, 62, 97,
238, 82,125, 40,172,  9, 40,108, 43,164, 24,223,  6, 97, 14,123, 51,144, 54, 43,
253, 97,107,188,122,168,243, 83,245, 48,192, 77, 80, 96, 28, 36,172,159,194, 23,
 70,186,241,125, 17,119,106,175,218,112,175, 74,112,137,196,  1,145, 72,  2,212,
181,190,191,178,185,  2,144,176, 44,  7,  6,135, 84,  9, 16,240,141, 69, 19, 65,
  1,128, 71,111,216, 26, 94,103,173, 12, 48,135,121, 21,153, 12,148,132,113,176,
 11,130,229, 69,246,218,222,224,223,190,173,243,182,207,160, 67, 57,167,189,133,
150, 53,160,253,164,245,148,115,123,157,158,202, 85,145,169,192,188,  8, 25, 23,
234, 60,164, 65,174, 17,222, 90,142, 18,244,201,211,154,124, 60,108,132, 26, 50,
123, 25, 22, 94,234, 16, 29,139,109,100,  7, 71,  6,234,146, 69, 63, 77,209, 45,
 78,  3,141,228,225, 20, 44,106,241, 13,235, 15,146, 99,152,240,255,142,203,165,
  1,130,135, 93,207,106,  7,135,  4, 57, 56, 48, 58,251,196, 37,140,169, 35,235,
148,  5,151,245, 44, 14, 28,246,176,  8,238,193,197, 85, 44,219,119,103, 11,229,
181, 89,151, 26,203,246,176,230, 80,177, 96, 21, 26, 44,227, 54,156,199,169,200,
  4,152,187,146, 45, 87,154,249, 35, 23,178,219, 78,122,202,194,116,187,118,253,
 41, 41, 48, 14, 18, 16,139,247,235, 52,140,215,214,246, 80,159, 59, 93,  6,  6,
201,190,210, 52,249, 68,225, 33, 32,250,101,187,241,214,177, 94, 33,199,236, 82,
206, 54,248, 83,232,210,141,167,246,121,159, 81,167,133, 79,121, 12,144, 11, 18,
163,  3,241,192,176, 56,141,110,193, 54, 78,131, 85, 21,117,201, 81, 35,187, 69,
 41,145, 37, 65, 77, 28, 67,  2, 80,117,170, 10,226,241, 83,176,184, 21, 94,251,
 92,198,239, 43, 96, 32, 64,135, 58,103, 29,109, 71, 94,242,224,181,117, 94,218,
 53,179,172,253,242,197, 31, 15, 43, 47, 65,125,242,137,136,242,136,228,108,174,
 18,196,148,245,  6,101, 72,139, 56,130, 52,254,100,246,146,140,236,231,190, 13,
 36, 35,199,  8, 43,164,167,219, 60,220, 46, 96,165,  1,142,170,170, 42,141,195,
112,174,106,226,209,144, 69, 94,195, 89,  3,197, 76, 78, 18,100,174,205,133,177,
 96,239,226, 44,155,183,185, 92,131,139, 70,178,108,220,197,178, 84,216, 70,232,
121, 24,157,213,121, 12,221,253, 11,111, 47, 81,174,229, 75, 59, 67,154,156,194,
185,134,109,113,234,156,227,206,231,165,216, 86,128, 56, 69, 84,249, 94,152,217,
 75,230,206, 45,252, 76,137, 47,180,221, 62,113, 48,103, 97, 62,129,209,219,227,
156, 29,137, 22,186, 29,170,176, 86,120, 10, 70,194, 76,248, 84,132, 21,116, 51,
 80,189, 22,115, 74,196, 94,  9,121,235, 11,225,216, 17, 78,217,229,103,251,209,
109, 98,206,153,108,251, 41,194,206,152,218,219, 51,210, 13,214,152,229, 45, 79,
237,145,101,229,140,115,174,  5,210, 43, 22,  9,215,197, 93,150, 69,131, 69,143,
209, 57, 27, 11, 22,130,  5,168, 82,164, 16, 42, 52, 83, 34,133,  5, 73, 74,141,
  1,162, 32,132,  1,105,170,232,129, 78, 31,210,112, 72,136,130, 12,  4, 98,  2,
226,  8, 49,134, 24, 34,  5, 34, 50, 18,136,  4, 20,148,164,196, 57,146,123, 75,
104, 91,149,114,  6,164, 54, 98, 62, 29,138,201,159,188, 30,113, 54, 49,122,148,
249, 45, 93, 81, 99, 96,243,184,160,146,200, 69,129, 42, 24,221,136, 34, 63,241,
207, 83, 77,228,175,179, 55,187,113,149,203, 44,198,171, 55,199, 31,210,170,  6,
137,  9,110,166,201,116,168, 17,152,254, 66,234, 11, 26,221,197,131,123,  5, 37,
 78,227, 33,245,176,222,237,139,131,135,190,114,  6, 28,240,193, 70, 91, 29,194,
211,131,148,190,135, 67, 75,173,  3, 20,208,142,171,207,147,128,195, 89,133,  9,
 96,250,242,189,252,234,251,237, 97,115, 71, 23, 53,116, 70, 43, 17,124, 74,131,
 78, 83,223,159,101, 91,204,158, 97,150,232,115, 15, 16,223,143, 23, 34,156,146,
 32, 82,114,109,183,233,209,  4,213, 25,190, 23,225, 15, 20,229,  9,131,139, 53,
190,246, 45,141,177,243, 14,213,131, 80,  0, 71,140,160, 72, 50,251,127,252,165,
 42,191, 83,242,158,122, 61, 61, 81,117,254, 17,112,210,248,233,116,154,194,176,
225, 75,183, 88,155, 64,224,182, 21,167, 90, 74,181, 41, 16,101,143, 73,122, 66,
100,120,  1,113, 22,145,139, 29, 61, 24, 77, 58,117,131, 17,131,  4, 38, 93, 61,
113,162,  1,144, 35,235,244,212, 70,110,  3,114,  5,101,117, 68,100, 71,204,250,
  1, 34, 57,180, 68, 24, 41,190,140,172, 82,137, 85,166, 73,178,114,118,234,196,
 84,186, 78,185, 95, 12, 12, 61,  5, 79,223, 98,110,182,107, 65,190,167,154,106,
  1,239,206,134,250,180,190, 95, 40, 46,119,107, 76,142,161,223,  0,  8, 65, 84,
112,208,248,133, 70,222, 69, 52,103,142, 82,171,237, 63, 48,244, 76, 91,190,142,
230, 36,140,188, 30,  3,161,255, 42,210,120,179, 36,225, 32,123,158,227,220,  4,
252,185, 62, 32,218,221,122,  0, 71,159, 88, 60, 65,  3, 36, 96,176,  1, 36,176,
 44,114, 41,232, 53,215, 51,194, 85,105,213, 10,240,170,208, 29, 53,192, 33,199,
206,107,157, 57,134, 91,157,199,215,152,171,100,105,113, 90,139, 47, 68,180,223,
 28,140,199,210,206,209,191, 85,131,209, 30, 27, 81,149,165,240, 47,109,137,103,
 46,  3, 60,177,147,  6, 11,253,125, 28, 20,205, 74,133,205,143, 38,251, 90, 61,
 20, 16, 78,225, 94, 58,232,225,115, 54,241,115,  7, 95,162,109,201, 90, 10, 34,
170, 87,138, 23, 68,225,206, 80, 77,190, 83, 62,173, 98, 20,191,104,232,191,118,
 42,195, 67,208,228, 23,152,229,200, 76, 17,118, 39,168,145,170,254,194,233,131,
 42, 51,116, 16,133, 41,230,173, 30, 35,231, 24, 21,236, 21,216,111, 30, 34, 33,
 48, 95, 83,208,220,128,165,231,138,111, 77,138,255, 38, 96,116,205, 95,150, 62,
 21,109,232,193,128,226,198,106,190,  3,127,186,150,244,115,169, 86,124, 65,189,
 97, 37, 20,171,222, 61, 93,143,104,229,184, 56, 91, 18,238,212,126,241,167, 24,
 73,253,135,249,210, 97, 80,114, 39, 80,183,253,246, 51,189,167, 32,105, 20,  4,
114,138,247, 51, 23, 27,172, 31, 39,207,180,154,134,181,229,138,190,  2,127,132,
 68,239, 20,140, 58, 82,118,221,171,225,177,167,144, 31,149,133, 88,160,127,120,
 67,174,154, 40,141,116, 19, 38,209,216,170,244,119, 57,128,102, 34,176,224,204,
169,217,128,107, 42, 86, 76,200,131,167,191,116, 13, 78,103, 26,206,167,216, 96,
 21, 63,166,143, 33, 12, 72,226, 14,179,154,178,160,138,196, 44,172,111, 14, 67,
255,150,124, 36, 18, 48,144,177, 40,  2,181, 12,118,100,165, 89,240,121, 45,241,
207,173,177,239,175,205,185,160,135, 69,157,  1,119,185, 88, 53,240,242, 79,130,
168,206, 15,134,  0,186,106,248,252,125,232, 67,121, 10, 13,165,100,182, 53,210,
183,246, 98,188, 52,152, 16, 30,200, 69,163, 53, 79,118, 17, 31, 92,174, 94, 82,
148,137, 27, 64, 52,134, 17,117,139, 87,205, 21,232,137, 98, 54,238,191,254,120,
252,155,212,211,184, 84,157,222,145,208, 35, 93, 94, 43,140,140,251,187,199,  6,
 59, 68, 60,134,201, 38, 65,112,102, 40,246,170,239,123,180,211,178,218,204,103,
120, 24,116,187, 50,129,222,195,183,213,134, 65,107,200, 86, 94,104,140, 48, 16,
188,224, 38,168, 98, 12, 28,161, 43,196,158, 79, 13, 69,145,242,176, 50,138, 43,
172, 19,195,228,166,137,105,239, 53, 96,155,121,216, 79,129, 88, 87,215, 58,112,
  6, 85,120, 61,161, 58,160,201, 48,106, 47,138,157,154,233, 94,255, 61,209, 62,
  5, 49, 12, 43,204,197, 92,186,151,  8, 79,131,225,171,  5,134,242,128, 84, 53,
129, 81, 73, 61, 35,169,219,117,223, 42,197,  2,150,202,123,  2,118,118,254,153,
 71,203,166, 36,107,193, 16,210,119, 72,117,213,229,  8,207,239,133,213, 92,211,
 91,167,153,119,163, 45,  7, 89,  8,196,174,172, 49,198,161,130, 70, 40,126,212,
117,215,178,252, 78,244,246, 91,240,230,228,207, 37,114,  4,219,228, 28, 35,183,
197,200,227, 25,196, 54, 97,175,219,165,183,166,248, 99, 99,210,241, 34,188, 68,
 34, 34,132,182,210, 73, 94, 85, 40,  3, 11,179,233, 10,218, 25,173,187,103,112,
 92,234, 72,141, 81,217, 52,241,129,153,252, 51, 18, 34,199, 40, 94,136,216,143,
 52,160,234, 40,234,  3,
} ;

// ../Source/Template/GB_AxB_dot3_meta.c:
uint8_t GB_JITpackage_3 [1649] = {
 40,181, 47,253, 96,113, 24, 61, 51,  0,214,186,179, 41,176,148,117, 14,116,  1,
 51,  1,125,107, 15,196,  4,187, 55, 64,211,134,110, 39,103,238, 32,235, 43, 44,
178,117, 92,124,131, 34,108,127,208,127,176,191,177, 43,  1,166,  0,166,  0,164,
  0,222,185, 58, 54,216, 30,167,175,220, 26,175,  5, 67,238,225,137,134,220,224,
 96,125, 71,208, 29,233,227,192, 42,240,190,244, 19, 71,125,111,171,167, 77, 10,
 46, 26, 75,123, 28, 21,249,214,216, 85, 84, 47,216, 29,199,210, 22,108,174,118,
 44, 25,155,207,165,235,210,216,182, 65,183,215,243,168,160,127, 31,191, 50,208,
 20,104, 44,  9,153,  2,205, 41,142,242,202,214, 18,221,252,194, 63,121, 55, 28,
 85,237, 85,198, 29,233,137,116,140,176,178,190,149,148, 77,198, 22, 79, 30,166,
237, 72, 69,123, 91, 63,223, 99,123, 33,175,236,229, 72, 93, 56,138, 63,173,165,
203, 10,  1, 55, 56, 96, 12,243, 22,189, 61,218, 12,110,216,109,210,196,155,140,
 56,  6, 51,177, 96, 48,  1, 99,248, 30,233,189, 27,134, 40,  7,199,190,151,138,
 63,221,218, 35,106,187, 68,189, 99,115,190,  3,233, 43,249,138, 95, 97,191, 35,
 84,166,101,156,140,139,242, 91, 95,137,106,  7,118, 73,173,115,225,212, 20, 95,
 85,148, 79,205,226,131,169,188, 99,138, 27, 55,205, 87, 48, 11,111,123,109, 53,
245,246, 17,142,255,255,100, 66, 49, 47,137,185,137,222,112,234,163,170,148,121,
107,130, 51,183,235,130,179, 45,211, 96,140, 14,111, 31,149, 11,240, 44,  9, 36,
  5, 92,115,101, 44,241,217, 12,180,138,205, 27,172,162,238,  4, 38, 19,238,178,
221,250,113,235,196, 45,144,107,156,  9,201,111,239,190,170,216,175,193,177, 41,
 78, 99,120, 57, 10, 65,113,151, 13,163,221,234,194, 82, 74, 41,165,148,214,169,
204, 45, 31,213,174, 68,177,158,165,158,201, 84,107,167, 99,225,185,245,112,138,
162,161,129,109,114,140, 96,102,102,102,102,102,102,166,204,204,204, 44,114, 40,
 27,190, 48, 12, 85,132, 31,198, 52,142, 20,233,232,214,208,102,235, 38,223,181,
169,138,174, 73,118, 46, 15,232,162,216,186,227,186,  4,134,106, 40,164, 32,165,
 20, 37,216, 95,137,171,213,243, 68,  7,203, 20,231, 47,103,123,172,156,  2, 93,
 31, 13,137,147,144, 80,126,101, 32,254,112, 52,208,149,101,188,240,  2,240,119,
 59, 64,184,224,168, 63,241, 55,  4,111,235,177,255, 18, 26,133, 34, 33,215,161,
159,232,232,243,162,240,182,235,120,193,254, 21,155, 51,117, 69, 61,  6, 11, 37,
 34,  7,203, 45, 57, 72,146, 18,162,224,207,124,115,105,158, 11,187, 58, 31, 76,
171,240,108,155, 14,131, 44, 36, 87,149,245,209,202,181,104, 63, 66, 73, 30, 24,
192, 48,172,132,187, 88, 48,172,183,110,  8, 25,132, 12,107, 23,246, 81,176,142,
198,190, 34,148,107,153,167, 98,110, 29,246,112,176,237,  2,113,103, 94,155,145,
139,230, 20,170, 44, 13, 94, 77,230, 99,107, 93,147, 62, 90,250,232, 72,178, 61,
138, 31, 13, 29,196,172,174, 63,111,100, 41,247,254, 66,213,218, 80,252,  1,165,
172,  7, 10,134, 97,216,168, 69,170,197, 42,166, 77, 11,144,150,109, 20, 25, 99,
 27,136,165, 24,213,192,115,206, 25,225,225,128, 56,216,149,109, 32,142,134,135,
165,148, 82,154, 40, 77,211,248,  3,112, 25,129,175,168, 49, 81,100,104, 70, 36,
 16,145, 20, 36, 73, 90,  3,  1,  9, 49,138, 58,198,206, 58, 66, 73,152,133, 49,
148, 65,136, 33,130,136, 33,132, 16, 71, 36,152, 96, 68, 36, 40, 41, 72, 65, 33,
 29,166, 86, 65,216, 46,235,170,103,161,138,155, 73, 21,  4,  9,111,162,120,111,
 76,124, 40,162,189,164, 99, 22,170,211, 12,198,251,209, 52,174, 62,174,198,197,
 27, 73,  8,113,152,179, 21,205, 84,218, 35,103,133,103,149,248,236,166, 25,189,
 90,182,156,153,138,209, 23,241,170,155,251,195,136,  7,106,206, 23, 87, 53, 65,
139,243, 38,  3,188,249,161,166,194, 44,255, 66,179,175, 62,236,192,176, 71,  5,
129,175, 77, 64, 53, 98,231,235,157,241,146,184,211,237,196,215, 63,206, 40, 82,
220,202,245,149,185, 35, 39, 10,160,142,101, 25,161,140, 95, 22,153,136,199,206,
207, 91, 53, 44,175, 37,247, 71, 62,161, 88,132, 84,  5,224, 94,191,244,191,  7,
 81,169, 97,165, 78, 56, 32,220,142,164,151, 75,209,  5,112,109, 98, 65,184,155,
247,145,166,210,172, 84, 44,151,242,218,163, 40, 48, 41,120, 84,209,230, 81,134,
155, 23, 56,131,218,130,140, 37, 41,  1, 50,140,242, 43,249, 91,140, 56,124,230,
  6,155,116,164,144,196, 43, 17,140,167, 55,160, 56,112,161,214,168,197, 24,210,
195, 68,  1, 50,  4,133, 97,195,  3, 20,251,157,139,139, 51,115,212, 85,201, 79,
 12,244,227,103,217, 86, 28, 13, 30, 15,177, 11,117, 26, 15, 53,209,253,108,167,
 62,122,156, 73, 77, 87,251,247,245,115,251, 99,183, 68, 33,226,224, 44, 41, 67,
182,187, 31, 91,250, 14,221,140, 84, 20,113,167,122,138,173,137, 17, 51, 33,247,
166,171,182,  2,208,128, 89, 27,120,106, 73,137,172,247, 89,  2, 51,140,207,146,
134,189,109,204,156, 81, 37, 10,201,221,116,248,212, 60, 48,126,198, 62,156, 27,
157,149,223,136,225,225,133,142,105, 26,177,130, 81, 79,244,131,199, 11,147,163,
125,108, 97,146,156, 83, 83, 43,  9,168,169,137,247,102,  0, 50,231, 10,145,  0,
143, 74,215, 22,191,223,151,253, 78, 46,188,201,201,107, 46,137, 54, 56,134,164,
176,118, 98,176, 51,129,186,124, 34,229,105,175, 22,105,111,166,138, 61,162,174,
 68,  6,191, 94,252,155,137, 97,218,133, 79,179, 91,149,128, 82,179,  1,  1,189,
 49, 19,233,  9,  5,210,200,224,133, 74,195,195, 18, 91,190, 26, 22,118,123,  2,
185,185,123, 85,251,187,106,195,173, 21,213,191,187,232, 55,230,226, 14,207,247,
 30, 51, 21,217,218, 63, 97, 27, 76,114, 75,211,173,200,195,147,245,196,236,159,
246, 26, 52,134, 18,137, 39, 39,135,202,  7,194,  1,156,203,123, 86, 41, 12, 70,
146,238, 91, 93,242,153, 44,102,109,219,152,220,196,222,132,179, 34, 24,113,106,
149, 23, 49,132,229,167, 71, 18, 56, 59, 91,128,156,180,108, 53, 42, 74, 81,  9,
 21,174, 50,147,138, 35, 85,101,155, 54, 95,108, 41,131,150,118,157,221,102,190,
128,231,235,243, 85,221, 35,133,215,193,160,108, 10,202, 88, 29, 60,186,100, 34,
  6,181,201,166, 23,252,230,201,175, 39,160,248,246,221, 31,227, 51, 51,207,  0,
 58,203,242, 18, 98,203,171,108,164,194,250,174,232, 84, 73,166,207,114,  7,235,
236,111,152,166,177,223,195,  5, 61,191,120, 87,210, 18,210,232, 75, 58,236,221,
 32, 12, 45, 80, 86,149, 73, 33,157,  6, 92,227,  1,173, 16,125,236,172, 90, 22,
236, 31, 58,131,110, 28,252,144,111,231, 11,186,165, 70,113, 60,219,198,155, 11,
  1, 25, 40, 54,202, 31,139,118,108,160,217,165,162, 35,111, 42,220,129, 39, 53,
141,216,128, 49,  6,  9,238,132,195, 85, 30, 89, 35,106, 29,209,236,121,159, 37,
 64, 93,195, 19,  2, 33,189,173,102,224,107, 80, 91,  3,107,150,103, 47,200, 15,
252, 14,148,115,140,132,251, 16,188,194, 75, 99, 77, 90, 39, 29, 40,160, 14, 86,
199, 61,180, 83,164,141,156, 93,135,200,254,212, 83,167, 17,248, 53, 57,  4,188,
 38,192,244,252,171,220,154,198,121,148,225,111, 41, 49,200,148,163,110, 31,117,
175,153,160, 79, 55,160,223, 52,231,106, 48, 77, 43, 25,  6,201, 27, 62,194, 36,
235,107,149, 12, 64, 41, 45,195,  3,
} ;

// ../Source/Template/GB_AxB_dot3_phase1_template.c:
uint8_t GB_JITpackage_4 [1473] = {
 40,181, 47,253, 96,245, 19,189, 45,  0, 10, 66,252, 11, 39,208, 22,113, 14, 84,
 95,152,188,188, 92, 27,233,115,229, 27,185, 69, 24, 67,202,154, 12,  5, 28,227,
130,  0,113,161, 15,245,118,251,128, 47, 30,  2,185,191,183,  0,180,  0,184,  0,
239,255, 43, 39,149, 10,  6, 84,151,235,201, 88,  9, 95,170,220,193, 29,121, 40,
238,107,101, 12,219,150,241,149,235,219, 60, 63,134, 43,225,174,138, 74, 92,147,
207,228,214,204,157,183, 62,246,160,252,112,161,250, 16,100,218,101, 84, 14, 48,
  8, 23,222,176,157,212, 27, 40, 63,237,117,228,140,226,194, 53, 50,246, 44, 46,
 28, 17, 25,152,140, 71, 40, 87,230,188,246,  6,242, 56,135,144,186,148,128,112,
128,112, 97,200, 28, 32,220,130, 69,151,234, 27,217,136, 99,168,135,182,150,220,
243, 92,234, 80, 22,213, 54,151, 74, 52,112,165, 59, 59,220,175,235, 84, 42,130,
  1,234,211, 33,172,  7,205, 29, 78,165,246,215, 87, 67,112,227,190,129,123,225,
228,184,175, 12,215,221,230,149,208, 50,187,170, 18,234,170, 36,110, 96, 80,185,
 24, 24,  4, 27,139, 12, 11, 67,115,121, 48, 46,174,136, 11,234,178,160, 56, 26,
 30,141,  6,199,211,185, 54, 29, 14,149,209,185, 42, 58,148, 21, 61,227,236,218,
 11,176,158,197,189,102,107,144, 20, 50, 61,212,183,245,227,123,133,112,207,221,
 77, 78, 98, 41,199,120,228, 12, 65,226,211,228, 25,123,176,126, 31,229, 43,247,
 82,158,242,251, 19, 75,116,205,146,185,124,154,162,139,227,211, 14,165,252,188,
235, 66,  7,204,135,199,187, 62, 11, 80, 93,207,167,119,165, 79,  3,189, 47,133,
  5, 42,123, 62,138, 85,206,222, 12,242, 87, 42, 39,  5,  5, 53,254,225, 14, 63,
248, 20, 89, 50, 18,246,184,141,161, 44, 98,216,101,188, 97,245,150, 24,213,108,
153,110,125,113, 93,132, 12,225,210,157,159,156,252,114, 32, 75,103,128,195,179,
215,239, 24, 18,110,230,  5,183,160,160, 92, 66, 65,137, 30, 31,247,250,  8,  6,
 44,239, 69,154, 55,214,101,146,206,119,100,140, 10,209,142,252, 13, 91,150,125,
 16,149, 36,220,203,189,174,124,153,110, 18, 67, 62,150,232,  4, 15,129,176,211,
230,114, 31,153,130,143, 16,143,207,234,211,161,192,127,169,246,251,148,188,142,
171,186, 52,171,232,179,  3, 73,  9,175, 75,106,186, 93,175,106,110,117,183,119,
 64, 92,170,238, 89, 67,125,175, 56,155,140,142,137,171, 67,113, 85,150, 16,169,
 33,170, 34,195, 17,238,210,180, 46,101,145, 47,107, 94,178,102,116, 14,134, 71,
179,217,184, 60, 27,  9,237,101,209,  2,186,180,105,162,107,174,137, 74,130,242,
 12,109,242, 91,203,207, 41,111,253,152, 43,100,135,135,116,141, 18,171,103,106,
 89, 30,177,241, 92,108,172,149, 74, 74, 10,215,143,231,241, 73,125,162,164,232,
 23, 20, 22,197, 84, 64, 81,111, 41,138,162, 40, 74,162, 40,234, 89,159,254, 44,
108,242, 42, 87, 98, 69,247,116, 40, 77,237,119, 16,198, 91,198, 28, 37,184,180,
107,172,163,109,  1,156,100, 62,253,195,154, 30,154,135, 91,243, 14,231,247,225,
164,201,183, 46,200, 66,173, 95,236, 94, 25,180,125,  8, 95,215,247,123,119,159,
 75,178, 33,100,146,215,189,230,178, 94, 10,245,228,248,228,224, 19,230, 96,178,
222, 57, 94,252,152,173,116,235, 27, 97, 42, 53,254,208,229, 57,151,159,246,122,
101,236,119,138,241, 99, 36, 73,131, 80,230,190,146, 38,191, 97,116,185, 62, 68,
 55,190,207,247, 76, 95, 39,194,244, 25,236, 36,  6,183,107,108,207, 89,236, 72,
  2,129, 37,168,129,169, 66,138,144,140,136, 72, 10,146,164,208, 24, 97, 12,130,
144,130, 92, 66, 59,114,152, 88, 18,102, 80,  2,137, 16, 37, 64,144,  8,  4,145,
 64, 68,100, 34, 18,145,160,176, 40,206,  1, 25, 21,151,234, 18,113,135, 37,215,
 56,173, 54,137, 23, 14,232,161,102,111,218, 36,202, 71, 44,110,220, 55, 81,223,
 31,118,106, 69,223,202, 61,104,178, 94, 75,138,114,190,195,119, 73,248,169,249,
239, 92,205,128,144,177, 14, 23, 32,243, 74, 16,243, 89,  3,130, 45,250,167, 32,
 28,206,162,  0, 23,166, 32,243, 17,237,136,195,126,165, 32,116, 39,124,148, 59,
 59, 10,  2,162,219,129,207,207, 38,234, 89,148, 32,130,215, 36, 18,108,120,234,
 61,215,  0,247, 95,190,138,119,189,146,247,189,119,228, 38, 57, 73, 93, 41,161,
 44,232, 42,216,160, 58,  7,173, 40, 58, 48,227,255,147, 46, 26, 12,237, 92,187,
156,106,150,205,112,246,252,210,204, 52,200, 73,  7, 68, 48,148,149,114, 55,185,
120,132,158, 46,228, 23,113,242,197,103, 80,179,159,209, 24, 67, 40,254,115,152,
132,137,141,  1, 49,215, 68,199,204,190,211,114,146, 48, 75,243, 21,186, 31, 98,
250,190, 62,153,188,137,  2, 68,254,143,125,240,233, 59, 83,223, 94,221, 79,102,
 95,181,162,248,139,190,135,149, 35, 79,119,222,152, 16, 71,207,153,161, 97,251,
144,222, 75,105,224,136, 71,117, 33,  8,159,235,223,110,132,130, 20, 21,166, 40,
218,221,112,134,191,225,123,192,251,157, 29,211,212,195, 75,169, 64, 88, 95,169,
  9,198, 13, 44,180,234,188,177,125, 90, 95,164,100, 67,169, 77, 20,  1,182,248,
212,196,179,101,136,191, 23,152,137, 38,141,110,149, 75, 44, 19, 15, 84,167, 51,
150,215,  7,147,164, 75,140,221, 35,131,250,113,186,232,130,107,130, 59,104,237,
153, 29,  9,182, 24,107, 78, 40,220, 83,145, 16, 92,221,147, 25,170,105, 28, 85,
 41,218, 60,133,244, 37,193, 73,120, 20,135,  6, 60,202,171,223,127, 14,142, 37,
150,133,154, 23,141,254,  4,  3, 42,243, 96, 89,109,106,225,229, 87, 20,233,169,
 62,  1,137,200,  2, 65, 14,116,138,232,243,132,  0,101,139,136,207,  8,192, 26,
246,  8, 42,218,167, 88, 90,241,  3, 98, 53,150,154, 26, 16,114,135,  6,173,143,
 50,143,  5,163, 74,114,251,148,192, 46,187,115,214, 69, 73,235, 67,148,111, 40,
 48, 42,202,179, 79,238,245,110, 94,189, 66,149, 50,178,199, 79,176, 88,171,130,
 19,156,132,241,130,145,138, 62,120,247, 12,246, 77, 12,157,121,181,190,219, 27,
 81,241, 35,148,254, 60,191,120,227,129,141,238,159, 61, 89, 83, 99,141, 91,142,
 27,248, 47,248,  8,253,149, 68, 98,122,  8,178,244,228,210, 97, 99, 65,159,189,
230,191, 95,207,211,176,223,202,106,171,134,147, 88, 73,238,102,252,109,211,207,
240, 50,166, 33,254,150,129,155, 22,208, 65,193, 82,101,206, 18, 45, 93, 55,171,
103,236,144,128,224, 92, 79, 21,183, 74,131, 79, 87,226, 23, 14,142,163,240,212,
 83, 17,211,162, 23, 52,154, 82, 63,237, 13,104,171,232,166,105,252,153,201,106,
228, 95,207,148, 61,131,204,213, 36,148, 58, 86, 38,
} ;

// ../Source/Template/GB_AxB_dot3_template.c:
uint8_t GB_JITpackage_5 [1626] = {
 40,181, 47,253, 96,129, 25,133, 50,  0, 70,122,176, 40,192, 84,117, 14,228, 92,
191,111,207,197,152, 60,188,110,206, 71,161,139,  8,157,241,134,216, 94, 63,253,
231,100, 42, 39, 77, 77, 20,251,111,138, 66, 71,113, 46,162,  0,158,  0,170,  0,
156,223,227, 91,169,101,240,187,174,115,245,163,175,106,151,183,253,238,193, 82,
 77, 96, 61,232, 12,202, 95,223,168,124, 53, 57,184, 36, 88,184,211,228, 23,143,
  1,185,185,190,148, 55,142,133, 45,101,173, 45, 75,  6, 68,231,178,241,  7,200,
150, 61,183,183,243,104,207,231,140,159, 20, 18, 14, 18, 44, 13,  8,  7,  9,167,
104,210, 39,219, 31, 18,226,151,248, 81,119,171,215,159, 79, 88,180,168,238,147,
160,  4,  6,227,219, 33, 54,  1,249, 27,117,  6,108, 65,249,217,219,126,117,  6,
185,  3,249,100,175, 22,110, 21,252,126,217, 31,167, 10,  8,162,230,225,114,168,
142,225, 43,231,231,241,205, 20,110,221, 50, 42, 36,102,148,196, 13, 12, 38, 22,
  3,131,188,157,107,  1,138,  8, 35, 81, 68, 19, 70,170, 52, 14,180,111,193,122,
 53,254,248,156,242,124, 67,219,221,253,  8,244,141,134,149, 19,200, 54,202,213,
151, 85,159,156,153, 75,199,198,175,109,235,115,205,175,  5,155, 19,253,102, 11,
 12, 96,189, 95,131,154,229,237,231,238,254,178,199, 43, 21, 43,178,242,210, 59,
100,126,112,141, 68,177,220, 32,175,138, 80, 76, 69,162,181, 25,252,132,227, 20,
132, 73,107, 79,210,209, 38,241, 12, 55,238, 52,123, 10,149,236, 38, 25,236,110,
230,133,148,251,228, 41,191, 95,122, 30, 18,252,  4, 50,223,250,254,210,254,255,
201,100,100, 50,185, 76,  9,134,224,181, 27,135, 83,126,156, 65, 31, 73,239, 55,
116,196,162,185,  8, 13,129, 40, 36, 36,151, 40,207,143, 23, 60, 52,103,248, 79,
122, 33,106, 14,124, 10, 77,246, 54, 40,164, 53, 50,234,211, 71, 73,255, 66, 81,
173, 51,203, 38,170,179,178,187,198,131,133,242,160,109,195,111,180,185, 99,108,
159,242,108, 58, 26, 19, 25, 22,162, 46,150,175,180, 74, 38,233, 22,156,139,147,
161, 32,115,202,190,147,214, 76,196, 71, 52, 23, 73,231, 16, 42,207,188, 67,180,
241,175,186,160,188,150,235,141, 82, 68,159,186, 74,122,149, 77,128,220,221,102,
182,147, 51, 15, 93, 75,171,118,253, 16,155,143,197,230,218, 88,157,235,162,202,
 62, 23, 22, 25,132, 69,204,172,232,193,248, 84, 24,158, 15,150,109, 48, 79,236,
 96, 89,  5, 22, 47,233, 27,211,230,  2, 19,138,178, 44,140,136, 78,188, 62, 28,
138, 55, 26, 10, 84, 42,216,  7,227,100,108,  0,  2,180, 75, 22,112,222,194,169,
209,238,248, 16, 99,203, 24, 99,140,113,138, 49,110, 12,178, 32,213,163, 80, 88,
164,173,247, 41,228,146,254,193, 98,101,237,237,139, 52,238,180,141,153, 78, 92,
  3,112,245, 18, 22, 28, 15,231,218, 96,153, 21, 55,158,204,195,137, 24, 86, 71,
250,198, 19,173,106,  3,145, 81,112, 42,182, 83,114,215,220, 94,219, 33,156,133,
 90,251,172, 21, 84, 64, 64,233,248,112, 57, 84, 22, 10,212,180, 51, 84,140,145,
 67,218,183,195,177, 34,170,234,219,120, 95, 45, 91,170, 42, 21,135, 74, 83,185,
 31,107, 33,252,105,116, 63,143,111,187,110,175,247, 34,176,130,188,  6,129,144,
168,241,173,154,145, 17, 81, 80, 80,144, 20,164,208, 24, 97, 12, 98, 20, 99,218,
 65,234,  1,242, 88,166,227, 57,  8, 81,  2,226,136, 49,156,136,  8,137,136, 72,
 32, 18,136,140,130, 50,221,152,181,  1, 89,239, 88,236,232, 58,130,149,194,143,
188, 92,122,242,220,128, 83,169,161,211, 32, 70, 45,254,195,196,243,190,152,209,
111,139, 26, 81,250,203, 68,204,218,159,166,148,176, 50,112,  2,238, 43,109, 51,
142, 85,249, 98,178, 38,127,110, 39,224,  6,194,150,168,132, 89,226, 76, 61, 58,
 66,191,175,246,101,166,242,  9,248, 10, 74,179, 76,190,140, 21, 22, 28,  2,235,
 89, 63,215, 91,246,200,  6, 99,111, 42,150,196, 27, 76,162,185, 57,233,237,134,
 24, 63,139, 64,195,  8,  5,172,228,208, 89, 13,183, 25,219,  8,189,220, 40,226,
 38, 74, 49,148, 38,215,190,109,197, 94, 58, 98,157,  0,194,201, 13,155,212,204,
253,228,148, 91,162, 44,230,228,174,186, 41, 61, 62,197, 78, 59,125, 54, 54,224,
 17,240, 90,125,178,119,  4,162, 65,124, 60, 87,178,130,200,107,168,198,185,164,
168,202,142,109,249,119,203, 89,179, 11,139, 13,170,180, 34, 22,199,199,172, 24,
165,119, 49, 42,248,111,132, 36, 26, 39, 99, 42,226,130, 40, 73, 86,106,238,166,
135,210,232,147,137, 34,124,248, 84,153,134, 57, 70,172,187, 19,243,105,212,242,
183,180,118, 10, 12, 76,159,101,224, 51,172,247, 50,141,163, 59,110, 90,174,133,
155, 77,121,201,211,118,108,129, 36,247,152,120,154,171, 32,175,122, 22,234,  3,
168, 63,230,158, 29,170, 85,168,233,174,119,208,144,116, 48, 64,157, 14, 70, 42,
131, 18, 83,111,240,194,168, 82, 44,167,218,189,184,252, 31,131, 95, 65,249,255,
156,158,  5, 35,208,251,  0, 31,127, 52, 49,125, 39,202,162, 68,245, 29,110, 99,
 47,172,186,172,107,172,155,104, 18,109, 43,134,147,142,190,  8,189, 56, 48,  0,
 40,122,147, 83,205, 58, 81, 43,158,165,240,240, 68,252,128,230,100,108,179,179,
181,132,193, 98, 48,194, 18,151,182,180,117,244,177,132,133, 44,  9,255,112, 65,
  9, 45, 40,162,235,138,116, 37,116, 18, 72, 87, 47, 54,198,111,208,151, 17,148,
106,230,192,  6,121,189,149,115, 47,150,253,112,127, 50,101, 17, 29,221,210, 56,
 60,104, 72,194,  2, 18,156,129,209,  8,149,215, 66,236,172, 59, 47, 93,219, 40,
148, 82, 97, 45,178,166, 78, 57,226, 86,196,244, 20,120,169,148, 75,194,151,  3,
100,156,  7, 79,228, 29, 77, 87,128, 26,180, 99,232,194,182,160,  7, 98,  2, 35,
 10,233,116,203, 77, 81,171,170, 54, 52, 27,207, 13, 44,177, 28,223,109,207,220,
 70,140,139,158,114, 10,193,230,  0,190,  4, 23,164, 83, 52,112,224,102, 91,208,
187, 17, 67, 10, 75,180,128, 17,240, 96, 70, 72, 28,192,249,164,197,241,137, 40,
200,160, 41, 67, 41, 38,179, 34,242,164,  8, 39,231,240,135, 72, 36,184,196, 25,
250, 16,130, 38, 28,128,224, 39,  6,171, 72,216, 76,196, 88,134,127,110,149, 76,
 47, 82,204,146,150, 44, 61,166, 73, 12, 46,161,199, 46,164, 81,130, 63, 80,106,
214,116,129,122,242, 37,111,193,120, 95, 97,178,109,129, 43, 11, 17,111,  0,231,
 18,230,206, 80,101, 60,160, 94,204,  1,108, 29,130,  2,  6, 21,105,167,126, 90,
180,126, 36,104, 87,201,172,167, 28, 27, 28,175,151, 65,214,171,163,171, 10, 24,
 75,115, 29,197,229,218, 57, 62,  7, 15,165, 89,208,180, 86,216,150,191, 11, 79,
 19,  2,129, 12, 19,169,216,149,144,  1,213, 95,179,180,108, 53,155, 39,186, 77,
199,153, 29,107,186, 25,147, 17, 51,169,216,153,247,115, 35,106,113, 57, 72, 11,
183, 56,235,159,187,255, 37, 39,174,248,188,127, 63,164, 62, 96,170, 81, 81,226,
155,  6, 42, 57, 24, 92, 46, 39, 63,200, 32, 23, 85,141, 71,232, 99,140, 71,120,
 52, 83, 68,247,190, 11,217,226,121, 14,252, 96,147,176,156,116,194,170, 45,113,
111,188,116, 82, 48, 67,159,122,101,221,111,152,135, 44, 98,180, 71,194,229,229,
 31,  8, 36,192, 20,253,166,  9,253,193, 36,168,106, 74,100,197,206, 67,242, 15,
  0, 95,169,195, 34,  3,
} ;

// ../Source/Template/GB_AxB_dot4_cij.c:
uint8_t GB_JITpackage_6 [1108] = {
 40,181, 47,253, 96,196, 19, 85, 34,  0,198,108,139, 33,208, 92, 23,  3,152,106,
251,250,230, 58,198,210,204,165, 70,110,  0,234,204,179,160, 25, 68, 82,166,126,
 25,165, 30,184,224,  2,  2,130,  0,121,  0,134,  0,249,188,190,190,247,180,196,
 97, 97,176,169,177,162,222,187,108,111,121, 55,182,100,104,176, 26,219,241,106,
 12,163,138,231, 64,218, 86,182,218,126,174,119, 10,117, 63, 55, 77,239, 28, 99,
145, 88, 24, 30,138,196,226,131,113, 59,167,111,171, 86,126,240, 14, 75,237,147,
117, 67,231, 64,158,230, 75,161, 53, 99, 58,171,115, 69, 65,118,223, 20,164,145,
103,106, 91,214,159,207,178,219, 62,130, 96,112,185,110,243, 62, 41,124,160,226,
238,  6,190, 27, 15,170, 59,138,141,125,146,226,247,242,196, 15,115,  4, 66, 51,
 32, 16,  1,226,183,189,188,128, 61,166,228,153,209, 91, 19,133,175,126,125,247,
  1,136,158,219, 14, 54, 66, 22,140,197, 67, 10,137,160,  9, 68, 75,127,129,223,
 53,242,157,235,214, 98,225, 32,250, 45, 54, 28, 27,223,111,141,207,241, 96,241,
 73,186, 48,  7,219,247,147,171,238,248,109,245,223,133,194, 12,190,103,165,227,
 88, 15,195,245,101,122,155,218,174,211, 52,235,187,206,230,116,167,229,182,168,
255,191,166,201, 52, 13, 60,137,235, 57,180,178,246, 61,153,102, 90,126,231,178,
 69, 97,169,  7,117,191,203,132, 64,159,240, 34,114,194, 77,195,209,112,160, 42,
235,114,219,246,210,172, 54,143, 11,198, 72,227,217,128, 98,  6,243,178, 38,202,
 58,199,131, 23,  4,162, 96,205, 83,122,110,215,211, 44, 49,225,183, 96, 44, 24,
 14,133, 67,113,185,104,157,158,131, 64, 64, 34,141,199,180,179,129, 70,241, 74,
 60,240,189,125, 16,121, 12,223,250, 59,126,176,109,159,124,167, 40,124,243,101,
 89,253,  1,121, 79,124,178,126, 92,173,121,158,167,237, 50, 12, 39,252,132, 27,
 11, 72,252,132,158, 71,252,116, 70, 26, 12,226, 26,141,232, 34,130,194,154, 54,
211, 34,147,163,240,221,186,142, 22,133,193,114,205,251,158,114,221,110, 90,156,
237,234, 54,219, 20, 73,218, 86,213,147,194,200, 51, 24, 40,213,156,173,170,205,
 39, 83,233,167, 47,223, 82,211,202, 75,226,213,170,240,161,231,208,115,171,237,
161, 78,197, 84, 40, 92,114,244,145,123, 40,186, 85,194, 14,167,179, 17, 57,157,
 48,  4,138, 42,150,143, 88,217,132, 32,209,219, 96,188,143,199,234,145,167, 48,
144,216,138,213, 28,121,171,144,  5,116,185,116, 10, 55,121,104,233,215, 91, 37,
 78,193,247,176,188,177,253,214,138, 85,128,228,168,193,157, 51, 52, 35, 51, 19,
 36,  5, 41,165, 49, 64, 68, 32,198, 20, 86,231, 82,248, 64,198,210, 12, 50,142,
 16, 68,136,128,  8,145,184, 33,113, 50,129, 80,  5, 66,230,  1,  0,145,139, 68,
186, 52, 72, 20, 26,185, 55, 44,252,103,100, 89,207, 86,107, 69, 26,  2,169, 70,
210, 14,  0,178,165, 31, 77,145,145,162,176, 19,101, 79,180,251, 19,179, 91, 54,
231, 87,136,247,178, 48,  6,136,236, 42,121,139, 28,150,193, 21, 11,119,195,161,
 30, 47,161, 67,122,133,138,125, 21,218,223,126,234,130, 95, 30,204, 86,255, 57,
 20,233,109,241, 11,245, 17, 48,148,177,215, 24,129,184, 36,142, 20,245,148, 33,
 45, 28,209, 71, 88,201, 77,106,136,  2, 32,107, 65,210, 48, 43,  9,237,100,192,
 60, 57,164, 88,243,167, 78, 24,129, 23, 51, 33,  5,208,241,170,135,111, 21,238,
 80, 25,  9,132,123,207,  7,  6,163, 98,183,246, 97,181, 27,230,217,246, 46, 65,
 65, 32,112,210,134,120,176,165, 74,202, 10,171,117,164, 82,185, 65,101, 36,171,
248,111, 87, 54,172,103, 98, 88, 21,222, 25,209, 23,249,151, 68,157, 10, 38, 98,
 73,128, 24,126,245,165,  8, 64, 72,218, 87,210, 26, 71,134,171,189,170, 71, 11,
182,  5,195,140, 67,191,147,177, 55, 47,209,198,180,254,141,142, 30,148, 18,111,
 88,179, 93, 41,128, 22, 78, 62,149,176,127,217,  1,215,116,157,150, 11,226,101,
250,184,250,124,174,  2,236,191,119,154,110,157,180,151,198, 79, 72, 27, 23, 12,
173, 39,227, 47,138,  1,150, 64, 58, 44,139,147,120, 61, 66,174,224, 24,111,101,
166,118, 34,102,143, 51, 44, 14,174,185, 86,161,137,213,244, 57, 33, 90, 84,251,
114,249,236,102,211, 59,208,193, 10,213,227,225,123, 28,177,  8,238,181,178,108,
154,202, 30,120,253,  8,188, 55, 56, 64, 59,162,217, 12, 33, 92,198,245,250,165,
 50,241,127,115,124, 66,  7,234,  6,173, 74,180, 79,212,173,204,159, 75, 53,156,
 29, 77, 74,144, 30, 65, 19, 83,185,245, 14,200,206, 30, 27, 27,107, 72,142,130,
 18, 34,103,  1, 28, 79,101,  1,203, 82, 60,112,168,225,  4,  5, 72, 33,234,197,
 72, 23, 78,167,239, 59,178,177, 64,137,188, 69, 23,  3, 66, 36,102,170,154,174,
 10,127,231,140, 72, 30, 32,238,147,254, 55,201,165,158, 69,225,228,252, 56, 35,
158, 80, 15,238,199, 53, 25, 71, 72,185,105,190, 63, 51,105,202,137,251,  4, 54,
 12,233,176, 70, 41, 77,  2, 60,
} ;

// ../Source/Template/GB_AxB_dot4_meta.c:
uint8_t GB_JITpackage_7 [1390] = {
 40,181, 47,253, 96, 73, 16, 37, 43,  0,102,186,173, 40,208,210, 56,  7,104, 33,
108,194, 55,174, 67, 96,233,196,246,146,228, 40, 58, 88, 83, 81, 40,240,111, 50,
144,140, 88,224,203,162,244,186,140, 82, 15, 13,176,188,161,  0,150,  0,168,  0,
 50,222,122,204,174,221,177,229,237, 62, 68,175, 53,157,116,187,254, 11,203,200,
121,150,217,215,248,126, 94, 71,229,181, 25, 79,234,122, 99,119,237, 81, 82,112,
 57,176,240, 38,163,  7,223, 80,185, 67,125, 39,107,150,133,237,100,217, 28, 75,
134,230,226,162,241,168,178,229,207,237,221, 60,250,115,142,131,159, 16, 14, 10,
 14, 44, 11,  6,  5,  7,167,200, 73,143,162,230, 23,248,210,118,105,215,215, 39,
 16,228, 80,155, 23,171, 68,  3,219, 26, 61, 16,223,254, 64, 18,142,251, 66,183,
253,234, 92,121,  3,249,100,175,252, 52, 90,189, 63,246,232, 84,101,  0,102,  8,
170,191, 33, 94,238,176,132, 75, 53,140, 34, 65,140,146, 56,  6, 35,177, 96, 48,
  1,245, 78,142, 28,249,218,105,209,217, 32,149,183,235,249, 47, 26,135, 52, 23,
251,246,236,251,233,227,226,104,178,149,189,210,118,174,241,212, 43,197,192,135,
 44,147,206,211,235,145,248,147, 57,179,113, 59,233,193, 82,201, 26,185, 40,237,
 38,123,202, 62,221,143,158,218,174,254,203,236, 87,203,241,172, 44,250,101, 81,
 68, 11, 87,175,196, 77,122,173,255, 98, 43,223,217,212,155,180,175,156, 95,200,
 14,148, 60,217,113,119,217,149, 39,123, 84, 26,186,198,246,251,213,232,118,185,
187, 84,223,110,131,156, 39,213,206,217,103,148,215, 70, 73,231,111, 12,169,216,
 43,221,169,210, 27, 43,123,244,221, 39,  3, 24,232, 24,103,211,249,108, 42,176,
203,162,  8,181, 64,215,218, 40,163,186,183, 45,203, 24,188,  7,139, 71,253,202,
174,215,114,173,220, 33,243,201,220, 72,254, 98,  9, 10,119,246,175,157, 84,194,
 95,246,184, 68, 50,242, 73,164,209,192,139,131, 97, 65, 81,159, 62, 68,217,228,
 20,230,212, 54,  6,189, 79, 36,248,169, 69,113,114,200,169, 54, 26, 76,229,153,
 76,168, 47,138, 92,179, 87, 48,119, 56,133,139,179,187,202,175,128,155, 15,133,
113, 96,199,178,248,108, 46, 44,194,250, 47, 34,225, 56,133,242, 38,232,125,126,
  2, 18,202,  7,245,202, 41, 61,137, 38,240, 25,130, 39, 92, 30,205,236, 16,107,
  2, 18, 73,149,177, 59,197,155, 62, 90, 78,170,132,107, 35,209,165,236,165,165,
 74,175,140,161,  0,121,225, 27, 57,175,227,139,  5,108, 23,219,152,130, 65,188,
220,  5,156,181,143,147, 83,193,  0, 94,155,202, 33,155,175,156,101,115, 54, 78,
 43,178,241,206,223,217,111,128, 56, 69,150,110,107, 92,214,213,217,104,172,142,
 53, 27,171,108,  4,233, 79,239, 40,216,224,237, 86, 85, 85,253, 20, 69, 81, 20,
137, 50, 33, 93,157, 11, 94,  0, 76,126,129, 58,158, 42,192,222, 74, 61,239,179,
  1,175,180, 86,141,229,233,120, 44, 48,141, 14,132, 16, 66,  8, 33,132, 16,194,
138, 50,249,245,217,128, 64, 16, 70,  8, 33,132, 16,194, 80,107,211,129, 82,147,
103, 56, 74, 51,182, 28,123,232,  6,244,129, 23,160, 11,104,113, 89,148, 23,187,
219,217,103,115,161, 49, 17,129, 71,168,129,189, 81, 72,102, 38, 72,146,130, 36,
141,  1,209, 12, 49,136, 90,203,138,  7, 50,177, 76,  5,147, 16, 35,202, 40, 66,
200,136,140,140, 72, 48,129,136,164, 32,  5, 37,133,  7,120,172, 69,196,159,  3,
196, 82,223,124,247,191, 34,228,188,182,241, 96, 36,173,127, 71,166,184,217,239,
151,154,180, 89,199, 79, 26,243, 82,165, 29,179,125,169,146,205,138, 41,163, 12,
159, 19,126, 99, 10,247,215, 48, 94, 69, 12, 55,153,142,110,217,181,124, 70,245,
245, 57,184, 34,182,193, 71,115, 16,213, 77, 69, 26,244,133,174,128,218,127, 64,
200,114,182, 69,127,163, 91,221,147, 74,247,172,154,101,175,241,188,168, 49, 93,
 92,135, 14, 10,208,159,113, 14,110,181, 23, 41,144, 63,217, 17,254,157, 38,182,
147,181,136,167,144,141,146,181, 20,214, 41,161, 28, 81, 89, 22,140,191,208,188,
192,159,156,245,211, 99,176, 65,140,133,107,184,122,196,186,128, 82,232,161,130,
240,231, 17, 66,226, 10, 64,157, 55, 16, 94,169,110,100, 46,206,209, 22,151,248,
143,146,137, 68, 21,141,186,179,  9,  9,  1,202, 32,205,160,217,115, 41, 94, 34,
 52,102,208,  8, 50,254,127, 49,255,176,205, 74,200,136,168,155,128, 58, 16,133,
 46,136,209, 47,108,138, 29,176,203, 25, 35, 16,110,157, 78,  6,126,217,213, 41,
204, 41,112,195, 47, 99,236,153,161,159,156,136,150,160,221,136,112, 21,252, 25,
180,157,119,172, 84, 66, 97, 65, 36,177, 11, 19,222,201,242,248, 32, 91, 12,234,
192,177, 63,  9, 22,140,239,198, 45,135, 67, 39, 62,158, 94,150,129,152,117, 14,
149,135, 84,102, 68,235,196,215, 76,249, 71,107, 27,185, 88, 65,232, 90, 49, 78,
144,168,142,254,117, 85, 15, 89, 94,  3, 40,205, 37,136, 17,216,119,161,216, 27,
153,149,215,195,161,191,213,163,142, 44, 98,217, 12,239,193,234,143,252, 35,240,
184,  8,107,183,132,233,110, 80,224,225,102, 58,132, 15, 62, 96, 85,154,126, 36,
 21,253,179, 42, 57,182,183,252,166,188,212,131,207, 95, 27,137, 59,211, 19,163,
 70, 72,120,144,183,190,247,188,162, 69, 35, 73,170,122,244,100, 37,104, 73, 80,
 54, 41,238, 71,199,  3,232, 93,178,247,180, 59,254,222, 38,255,125, 91, 34,130,
220,217,179,142, 66, 16, 93,136,224, 75, 17,115,166,129, 30,253,222, 87, 34,105,
 61,161, 70, 73,132, 96,  5,114,236,250,137,223,103, 29, 70,175,169,153, 39,232,
208,216,124, 82,218,139,205, 94,247,169,227,222,142, 39,252,249, 98,199,248,188,
161,180, 40,216, 11, 43,113, 56,193,161,193,188,225,229, 88,184,247,225, 35,  8,
 28,  7,  4,168,196, 35, 62, 53,181,107, 28,110,  9,214, 96,136,161, 63, 99, 44,
 61,125, 11,200,  3,156,138, 92, 22,251,145, 38, 33,130,156,147,131,118, 56,111,
151, 29,157, 22, 63, 66,151,150,110,115,137, 89, 60,165,193,203,124,153,138,191,
210,254, 74, 85, 80, 77, 34,197, 95,224, 11,170,215, 27,229,237, 27,160, 72,122,
122, 25,187, 22,166,116, 56, 48, 61, 71,108,154,183,218,244, 87,142,140,149,159,
119,167,232,213,173,107,233,225,114,  2,
} ;

// ../Source/Template/GB_AxB_dot4_template.c:
uint8_t GB_JITpackage_8 [4767] = {
 40,181, 47,253, 96,160,183,173,148,  0,170,119, 44, 22, 45,160,172,174,115,218,
  2,183,125,243,219,143, 33,195,235,246,190, 99, 56,189,138, 94, 50,174, 94,209,
 64, 84, 37,154,162,112,183,138, 29,208,114,106,194,235,240, 58, 24, 11, 94,169,
 79,  1, 87,  1, 87,  1, 16, 38, 48,141,115,241,186,155,  1, 58,158, 29,  6,120,
165,181,178,128,134,  2,237,210,185, 76, 92, 36, 34, 20,112,180,204,131,140,199,
221,244, 90, 64,163,225,240, 73,198,217, 95,229, 43, 65,122,135, 51,161,161,104,
 24,108,226,146,217, 84, 58, 90,101,131, 97, 40,149,136,107, 89,182,247,  2,220,
133,146,155, 45, 96, 70,206, 86, 79,246, 74, 27,176,123, 18,250,246, 99, 82,  6,
 69,252,201,188,217,232,185,  8,226, 65,225,106,148,145,179, 30,174,169,237,212,
 13,233, 39, 61,181,253, 75,103, 40,234,106,217, 70,238, 50, 54,199,160,253,157,
241, 86, 10,126,125,174,241,150, 67,125, 35,215, 18,236, 43,195,239, 11, 58,156,
205, 69, 98,115,193, 40, 24, 36, 80, 24, 28, 93,170,210, 27, 43,131,244, 95,200,
113,209,222,248, 97,204,174,253,177, 61,123,238, 61,250,174,233,164,223,217,211,
249, 25,152,123,204,126,199, 55,  4, 63,202,189,155,241, 13,  8,131,245, 96, 15,
 23, 65,236,146,202,237,245,157,220, 93, 30,108, 39,115,141,121, 60,136,160, 96,
232, 56, 84,217,242,230,246,122, 48,122,115, 41,177, 83,151,  5,177, 30,  7, 42,
136,245,137,147, 78,217, 14,197,136, 51, 96, 31,121, 46,253,186,115,138,131, 97,
 50, 15, 24,171, 69,194,182, 70,144,195,183, 67, 78, 67,202,208,187,237, 83,206,
149, 61, 25,167,236,229,194,142, 86,240,143, 29,122,182, 80,  0,155, 56, 40,191,
132,111,148,224,199, 87,139, 92,218,105,153,  8,211, 50,203, 27, 26, 26,143,134,
134,119,242,175,173,237,129,226,189, 68,139, 24,128,156,146,164,123, 50,114,229,
172,235,  1,134, 34, 67,209, 22, 88, 68, 44, 41, 18, 21, 28, 44,183,144,118,175,
244,212,141, 84,122,150, 75,102, 93,214,101,160, 50, 80, 73, 72, 88, 27,158, 66,
128,128, 83,129,161,144, 92, 97,194, 84, 34,200,  9,252, 74,159,164, 27, 78,159,
145, 37,165,155,244,  9,150,137,203,230,146,169,112, 52,109,163,121,128,201, 88,
 98,204,182,143,151,252, 21, 10,  8, 29,141,114, 65,185,209,193,241,161, 90,162,
 52, 54, 53,214, 88, 99,157, 57,124,178, 12,113, 95,248,135,  2, 78, 31, 74, 34,
101, 15, 14, 91,150, 85,142,243,133,197,173,241, 90, 13,  3,221,192,128,205,225,
204,181,180,219,124,131, 22,175,157,148,171,244,130, 93, 57,203,221, 47, 99,220,
225,176, 32, 27,239,252,131,195, 33,159, 72, 83, 69,113,253,197, 57,234, 36,150,
 30,206,126,154,146,237, 34, 87,207,213,190,112, 74,150, 50,130, 31,125,252, 48,
 98,  5,  5, 56,188,187,179, 25, 98,189, 31, 85,250, 49, 87,203,178,111, 39, 67,
154, 81,249, 94,108,222,201,205,181,231,241, 71,178, 70, 25,114,125, 59,234,185,
252,221,182,167,115, 73,101, 83,209,169,144,104,  0,227,119,123,251,246,137,227,
148,255,127,163, 49,161, 49,101, 39, 64,224, 19,  6, 83, 33,113, 10, 20, 78,129,
101, 58,151, 76,146, 46, 64,139,139, 40,151, 60,193, 39,106, 91,155,173, 81,164,
 79,254,  9,164, 62,205, 73,  2, 26,148, 72,167, 98,121,165,222,187,136,139,102,
 66,147,209,  2,167, 40,233, 12, 54, 26,  7, 26, 69,131,193, 96, 16, 19, 92,215,
107,185, 46, 88,154,  3,201, 51,210, 83,153, 36,131, 72,168,198, 39, 11,192, 49,
  4,120,129, 71, 71, 16,115,192, 64, 22,247, 52,246,201, 32,149, 94,142, 67, 94,
 55,178,233,  1,147,166,132, 25,165,115, 48, 88,131,137,200, 41,201, 33,213, 39,
147,127,221,133, 54,  9,204,176,208,251, 59, 43,181,209, 50,199, 69,107,111,243,
 86,192, 98, 39,119,103,136,247,112,161,149,178,103, 80, 41,163,101,218, 77,214,
 39,230, 64,149,102,220,193, 89,194,140, 93, 57,131, 61,233, 83, 37,253,146,209,
140,212, 13, 59,227,212,118, 41,251,218, 59, 99,215,218,150,122,112, 88,189,203,
 36,  1,184,132,209,108, 38, 42,248,107,217,159, 25,116,130, 44,157, 84,118,138,
 55,236, 18,219, 73,234,249,164,125, 41,149,191,150,206,236,108, 41,104,103,172,
157,145,156,244, 49,111,  4,255,233, 19, 29, 14,101, 12,253,209, 35,138, 31,109,
246,215,176,112,144,126,180,176,169, 92, 48, 20,151, 14,166, 34,115,185, 20,225,
 27,141, 86,225, 96, 23, 74,133,161, 99, 41,105,157,225,121, 59,189, 29,243,252,
165,115, 70,206, 70,239,163,202, 33,182,146,134,249,141,130, 10,103,131, 81,112,
164, 70,133,201, 57, 20, 45,134, 61, 30, 16, 21, 64,145,235,118, 97,241, 45,155,
253, 12,  3,221,145, 57, 48,240, 20, 72,122, 71,227,112, 60, 28,  4,162, 84,104,
 17,153, 11, 71,195, 50, 22,108, 67,193,214,241,234, 17,229,  3, 12,212,169,112,
 36, 36, 52,147, 67,140,106,141,134,215,221, 28,221,254,226, 13, 67,209,147,101,
 89,150,125, 98, 75, 58,126,182, 10,140, 81,249, 59,189, 87,196, 19,  4,154,128,
113,107,  8,233,157, 77,133,195,193, 38,138,186,  2,202,  6,131,176,193, 38, 46,
153,150,185,108, 58,245,122, 44,171,199,214, 18, 41,227,187, 26, 57,219,221,214,
 82,118,174,212,227,237, 12,130,177, 31,182,152,129, 24, 40,157,101,123, 50,232,
125,183,112,  4,135, 24, 93,240,  3,163,164,191,  5, 46, 46, 30, 48,  6, 43,163,
173, 28,138,245,222,118, 53,102,128,184, 24,121,210,142,251,232, 35, 25,185,222,
 25,210, 73,169,141,163,237, 84,199,183,169,  4, 69,108, 39,142, 63, 30, 16, 25,
120, 81, 61, 28, 89,132,100,159, 13,204, 50, 14,209, 45,182, 60, 53, 35,119,127,
202,  1,129, 74,101, 35,193, 92,175,235,186,174,235,138, 68, 34,215,117, 69,174,
 43,114, 93,145, 72,196,138, 92,215, 21,177, 44,203,178, 44,235,186, 44,203,186,
 44,235,178,172,235,186,190,112, 89,150,117, 85, 19,135,163,186,197, 82, 77, 86,
 37,153,125,235, 49,218, 44,150, 10,213, 29,211,133,197, 45,213, 31, 50,  9,132,
235,235,224,123,100,208, 90, 57, 52, 29,149,117, 49,233,136,  8,140,173,140,222,
 41,208, 41,234,  3,202,192, 83, 34,236, 20,104,241,126,131, 30,192,105,161, 79,
 65,184,238,  8,142,139,178, 79,  7,201, 43,201,175, 12,227,231, 15,233, 30,206,
 82,145, 91,159, 87, 15,235, 35,169, 34, 85, 85, 77, 16, 54,154, 76, 37,163,117,
 42, 52, 90, 86, 45,210,103, 13, 47, 87,143, 18,  8,133,106,168,147,249,130,212,
 41, 52, 51, 50, 34, 73, 82,144, 52,  6,163,113,  8, 80, 72, 68, 50,145,147,134,
218, 34,235,  3,163, 49,226, 65, 80, 16, 24,194, 32, 12,129, 16,144,128, 65, 16,
 20, 65, 24,  4, 65, 17,129, 33,132, 24,129,145,134, 24,  3, 85,154,  7,  3,170,
162,222,231, 73,109,228,120, 48, 25,235,110, 59,190,122,219, 72, 85,250,129,243,
 33,124,230,130,173,216,240,166,155, 44, 38,153,103, 12, 94,138,134,184, 55,100,
 24, 21, 70,107,101,232, 47,223,138,134,140,160, 82,233,177,203,180,149, 14,205,
 72,145, 36,  2, 74,153,175,241, 86,170,124,161,104,122,185,232,137, 19,161,184,
 63, 19, 71,227, 54,  0,146, 87,160,201, 12,202, 96,227,252,218,185,166,105,254,
139,221,214,183,164, 44, 82,196,202,137,194,213,162,157,116,121,127, 90,144, 57,
245, 67,211,159, 55, 60,180,188,124,151,  6,110, 48,192,242,125, 80, 49,132,189,
 29,111,  8, 55,182,203,101,  3,  4,105, 71,101,224,173,234, 43, 90,217,109, 51,
198,196,  3, 52, 65,172,113, 79, 10,156,223, 95,129,254, 18,125, 72, 12,226, 82,
 47,199,171,118,203,152, 59, 85, 98,188, 79,230, 62,137,110,185,162, 77,167,226,
 56, 30, 52,106,156,149,255,145, 46,173,254,172,240,152,100, 81,156, 41, 29, 74,
230, 53,170, 36, 60, 36,178, 55,  0,136,200,211,182, 29,124,195,218,183, 96,170,
142,195, 59,180,166, 47, 85,210, 42,220,  2, 39,169,196, 81, 34, 28, 62,  7, 36,
 22,235,171, 59,169,241,152,214,153, 78,118,210,254,124, 76,215, 33,211,131, 52,
 95, 43, 46, 38, 64,122,237,111, 76,203, 58,194,129,248,152,161, 18,136, 22, 26,
106, 82,225, 71, 19, 27,113,218, 69,  2,234,213,114, 99,122, 56, 63,131, 12, 93,
100, 26,133, 44,240,144, 10, 65, 74,240, 24,137,191,210,116,111, 19,227, 25,  8,
216,146, 94, 38, 30, 46, 96, 72, 19, 79,103,169,210, 46,225, 26,235,233,103,107,
 54,179,109,145,197, 91, 43,133,175,230, 66,193, 84,212,218, 59,247, 37,  9,226,
 69,174,220, 67,127,182, 86,135,137,252, 58,112, 17, 50,242,164,200,231, 86,214,
205,119,  1,108,126, 75,175,171, 30, 17, 98, 91,237, 29,242,102, 65,141, 98,175,
204, 86,140,148, 49, 35,149,138,248,231,231, 70,252, 21,107,216, 38,221,  1,228,
126,246,132, 28,141, 17,185,163, 77,149, 21,146,123, 86, 84,161,152,220,137,156,
156,104,  2, 94,147,244,159,128,123,222, 61,129,162, 95,148,211, 15,209, 28, 65,
187,227,100,242,126,153,142,128, 60,168,216,190,211,  9,233, 78,131, 94, 43,220,
 78,164, 13,204,244,170, 64,148,252,223,108, 40, 73,206,205, 46, 35, 69,120,148,
229,217, 58,170, 73,226,146, 49,218, 39,242,213,159,197, 16, 81,  8,217,179,150,
139, 38,138, 44, 91, 77,160,133,140, 91,208,204,248,194,170,115,212,207, 78, 33,
159,191,182,112,235, 88,232,155,106,171,147,233, 23,176,170, 54,130,244,189,  4,
228,113,121,245,  3,255,239,231,209,167, 99,108,140,181, 39,188,189, 45, 12,214,
100,229, 31,130,192, 47, 85,145, 33,  9,224, 73,123,212, 30,113,252, 71,153,213,
227,100, 50,144,227, 79,178, 65,227, 11,178,219,226, 30, 72, 24, 28,126, 99, 89,
 94, 19,214, 32,158, 20,197,129,139,227, 22, 95,180,243,240,190, 58,110,142,  3,
197, 13, 13, 56, 55,102, 87, 50, 91,172, 96,164,193, 82, 25,101, 43, 67, 34,181,
248,235, 69, 19,252, 93,243,188, 11,112,140,221,224,159,177,239,213,247,155, 36,
176,191,118,114, 29, 14,230,134, 17,  4, 35,219, 48,221, 96, 94, 27,190,176,133,
103,195,171,211,109,216, 41,187, 97, 29,153,173,204,184,243,244,163,148,102,113,
 19,108, 20, 10,  8,250,254,241,226,195,118,105,105, 67,151,205,158,134,209,199,
 47,240, 40,126, 69,201,153,143,145,109, 86, 65,235,159,236, 82, 24,135,249, 45,
198,247,235,147, 80, 78,205,249,201,119,159,231,253,174, 94, 74,217,227, 98,  3,
112,245,166, 11,202, 46, 94, 53,213, 88,227,128,169, 82,183,189,203,204,166, 34,
 13,106,208,155,185, 15, 17,126, 40,190,130, 62, 18,151,146, 23,213, 87,148,115,
107,174,170, 56,  2,142, 69,235,176,134,121,158,220, 72,254,240,127,229,209,210,
 49, 21, 90,239,167,244,  1, 25, 34, 40,  9,251, 28, 33,150, 41, 78,137,148,162,
 28, 65,160,147,128, 11,215,231, 59,133, 53, 36,153, 35,171, 96,212,211,222,186,
242,179,251,  7,178, 71, 62,234,113,239,123,237, 16, 95,249, 76,123, 17,154,138,
 69, 20,181,156,153,226, 37, 46,  6,107,177,122, 88,163, 35,238,119, 82,252,192,
119,169,134, 39, 95,176, 35, 41,245,207,106,136,148,136,137,  8, 98,213,144, 83,
102,183,  0,138, 99, 76,236, 87,146,160,152,245,194, 49,116,218,154,134, 45, 65,
 92,  4,224, 72,250, 66,120,165,  0, 68, 90,123, 67,110, 21, 96,212,144,182,186,
206, 13, 36,156, 69,205, 94,236,250,149,151,197,219, 53,115,173, 20, 57, 20, 42,
117,149, 72, 37,156,122,184,168, 10, 76, 39, 96,148,234,151,183, 70,229,250, 17,
 25, 22, 38, 79,196,240,245,102,151,239,211, 27,133,113, 38,176, 38,197, 54, 73,
161, 56,208,130,202,232,226,196,151,100, 93,160, 66, 97, 19, 29, 88,155, 33, 76,
 90,226, 70,162,128,  9,203, 51, 15,254,160,206,240,157,163,141,135, 54,246,243,
117, 52, 96,230,  7,150,219,228, 91, 63,122,184, 48,143, 45,119,127, 58,149, 77,
200,200, 11, 64, 12, 62,162,238,214,152, 99,  9,189,228,231,127,180,248,  1, 99,
147, 35, 27,103,251,248,218,  5,174,242, 14, 20,219,173,122,  0,245,192,171,254,
126,226,188,181,165, 20, 95, 30,150,154, 65, 84, 23,106, 12,211,135,125,190,143,
 18,  7, 97,201, 13,126, 54,206,199, 27,128,116,253,197,235,112, 93, 74,139, 77,
  8, 73,218,150,129, 58,235, 72,  7,107,  4,160,  6, 38,110, 32,190,126,176,241,
  1, 67,216,  5,203,223, 34, 73, 82, 54, 39,132,107, 86, 36,208, 17,235, 77, 34,
235,231,178,247, 19, 27, 48, 28, 34,129,128,160, 96,149, 83,237,237, 95,181,172,
147,168,215,143,105, 32,217,213,  2,174,154, 82,169,249,253, 15, 37,197, 38,221,
 31,235, 15, 36,135,189, 20, 33,240, 55,131,252,213, 53, 42,105, 96, 18,240,113,
127,209,151,158,170,168, 50,143, 20,218,142,212, 75, 25, 58,160,177,252,148,130,
 13, 65, 99, 35,  0,174,202, 12, 35,192,110,204,193, 51,134,224, 61,121,212,  5,
 56, 45,163, 71, 12, 20,132,  6, 77, 74, 72,105, 64, 51,134,115,171,117,224,216,
 27, 63,188, 67, 48, 83,112,131,240,107,214,253,248, 28,238,191,227, 48,102, 94,
 61,199, 17,207,182,250,145,190,101, 10,163,144,169, 35,  8, 81,129,228,194, 61,
 98, 61,135,201,151,124, 50,126,195, 57,249, 71,150,115,156, 66, 42,187,154,242,
187,220,122,230, 74,148,237, 38, 36, 85,234, 12, 10,210,170, 84,250, 70, 95, 26,
230,185, 84, 62, 44,193,249, 93,142, 81,152,170,162, 90, 42, 76,182,148, 20, 64,
 48,214,214,163, 20,103, 63, 62,  2, 93,  8,132, 41,103, 61,102, 91,143,222,119,
 15,122,126,155,228, 38,219, 38,163, 75, 12,213, 17,180,206,167,138,127, 23,128,
142,184,205,162,223,198, 38, 77, 64,255,199,182, 90,239,196,146,207,122,238, 36,
149,184, 33,  2,237,242,181,208,160, 63,207,174,127,244, 65,176,227,207,213,163,
 33,212, 73,194, 63, 53,194,125,102,253,144,233,133,241,192, 23, 86,188,120, 29,
151,183, 42,234,  9,177, 60, 43,197, 59,233, 62,  3,120,134,160,109, 45,134, 78,
218, 70,102, 42,217,161,174,250, 77, 45,162, 86,252,168, 11, 57,148, 79,200,246,
 45,113,232,240,120,194, 23,106,190, 34,181,150, 79,197, 88,161,220,210,198,182,
221,109, 96, 80, 50,  6,149,212, 95,255, 55,116, 15,134,181, 63,183,139,183,162,
 26,104, 20,113, 55,200,177, 71, 57, 66,210,150,204,254,192,211,220, 70, 71,221,
186,157,133,151, 74, 17, 81,102,124,117, 44,124, 47, 73,172, 71,209,223,221, 98,
202,205,125,232, 96,114, 50, 42, 10,233,139,114,115,105,154, 25, 45,127,177,212,
 42,101, 79,112,255,245, 60, 54,188,187,229,142,201, 50,183,244,110,253,184,252,
 76, 51,104,253,153, 62, 30,204,182,125,119,253, 19,233,115,149,121,231,118,213,
108,109,240, 42,218,170, 22, 20,227, 21,176, 17, 26,123, 75,  7,183, 58,208,145,
 52,101, 78,182, 87,178,156, 76,144,122, 82,156,237,110, 50, 61, 71, 17,154,183,
 57, 34,174, 77, 74,103, 19,100,133, 33,135,132,158,223,237,193,251, 45,160,144,
 97, 23, 70,146, 23,197, 72,144, 62,165,204,238, 39,243,232,145, 91,168, 97, 82,
180,191,162, 65, 64,129, 93, 15,247, 97,185,234, 16,215, 42, 77,214, 66, 94, 43,
155,153,125,190, 39, 52, 99,180,176,220,151,216,226,181,144,193,193,225,114,232,
108,196,105,220,189, 58,209,194,102,201, 87, 12,156,163,181, 48, 73,122, 98,102,
 26,117,  5, 83,204, 96, 44, 35,139, 54,109, 88, 56,193,141, 24,  7,252,119, 28,
108,169,240, 63, 29,174,148, 11,220, 99, 97,217,183, 27,169,244,202, 18, 38,179,
 45, 91, 66,121, 46,187,133,107,107,190,118,176, 97,180,153,233, 80,242,132,191,
169,130,154,134, 56,237,209, 35, 78, 29,108, 18,244, 55, 36,191,150, 60,187,165,
105,118,130,108,202,166,135,  6,132,255,205, 75,142, 22,136,244, 75,123, 64, 31,
154,117, 10, 26,222,229,123,100,172, 63,109,146, 40,137, 89, 16,142,223, 63, 56,
 25,202, 97,112, 73,135, 78,149, 76,159, 39, 68, 75,117, 72, 95,204,113, 45,224,
220, 32, 46,169, 89,135,191, 41,180,252,154,175,104,214,178,157,164,255, 47, 19,
108, 47, 17,168, 98,  7, 91,170, 31,248,219, 79,105, 92,234,  5, 78,  6, 34, 54,
 78,142,234, 32,227,180,132,  3,242,247,  2, 65, 46,101,117, 92,218, 67,104, 85,
243,128, 91,171,120,239,233, 99,250, 41,191,232, 24,153, 47, 41, 64,110,131, 63,
206, 57,138,247,213,142,213,170,140,156,122,156,158,169,254,  3, 63,229,245,122,
 50,123,110, 68,160, 37, 35,134, 67,104,121,109,127,187,109,223,214, 64, 92, 49,
216,133,137,162, 85,180,175, 27,111,196,210,220,225,119,119,218,216,191, 84, 31,
169, 41, 96,136,248,212, 81,132, 90,170,226,158, 16, 35,112, 46, 83, 42,121, 44,
160,119,167, 88,166,127,246, 63,166,171, 92, 53, 52,244,192, 94,230,241, 49,167,
 30,232,194, 94,212,117,129, 60,187,131,173,253,222,250,187, 31,154, 47,112,151,
172, 88,237,228, 84, 73,  0,165,143, 83,198, 58,248, 67, 84,231,  0,167, 67,228,
128,235,130, 60, 25,182,186,147,173,118, 99,173, 57,156,172,200,144, 48, 64, 39,
180,234,113,193,137,166, 34,196,138,196, 33,240, 56,251,131,196,112, 21,192,102,
177,129,120,139,106,147,246,184,186,119,191,112, 46,110, 42,222,164, 11, 87, 32,
237, 61,154, 61,126,238,163, 20,149, 42,164, 98,  6,217,213,252, 59,120,161,239,
221,174,238,139,177, 13,159,  7,219,222, 65,164,192,233,214,203,215,181, 46,198,
182, 50, 27,169,105, 29, 78,182, 26,231,116, 73,196,126,234,178,  8,103, 53,254,
102, 56, 97,  3,173, 72,137,  4, 23,209,208, 31,174, 64,138,255,241,226,144,239,
205,214,110, 63,226,166, 43,123, 91, 18,193,157,120,152, 79,205,204,  9,163, 29,
 49,147,173,201,216, 48,208,164,  1,187,124,201, 97,145,190, 37,112, 89,166,192,
129, 81, 39,118, 42, 77,169,239, 99,158,206, 53, 61,197,100,230,130,221,225,179,
 55,  5,147,180,245,182,231,169,145,220, 83,140,182,154,118,161,133,149, 86,148,
187,140,188,150,138, 17,231,152,170,237, 44,224,250,161, 11,186,233, 70,140, 73,
182,203,178, 89, 98,166,230,104, 12,214, 90, 28, 62,160, 13,240,160,155, 66, 75,
249,214, 68, 24, 17,207, 11,174,176,189, 90, 17, 44,  3, 83,180,134, 35,213,131,
215,225, 98,110,139,  1, 31,150, 53, 29,209,250,178, 79, 37, 43,208, 76,196,182,
133, 24,236, 64,165, 86, 40, 81,132, 47, 69,180,125,107,193,241, 30, 60,  9,248,
 77,142,227,142,172,196,157,116, 39,216,120,122,  0,  2,182, 12,133,209, 51, 13,
251,183, 18,220,204,185,219,111,208,181, 75, 12,187,231,108,123,245, 18,102,127,
 25,243,128, 79,164,153, 39, 79, 98,  8,240,173,190,117,106, 91,220, 58, 54,  1,
 51, 74, 65,168, 50, 32,163, 64,231,123,209,238,249, 78,205, 40, 27, 27,117, 29,
 18, 86, 72, 77,165,158, 10,172,110,148,171, 82, 74, 38,124, 16, 36,150,204,182,
145, 95, 23,145,147, 73,136, 30, 29,  8,161,126,192, 61,112, 69, 90,207, 90, 23,
152,170,140,247,126,128,139,170, 86,196, 15,144,222,  2, 10, 74, 65, 37,  8, 20,
 59,156,244,228,238, 27,206,194,133,123,158, 76, 19, 87, 64,178,114,115,216, 45,
248, 16, 14,148,119, 46, 35, 85, 39,148, 80,108,235,217, 44,190, 59,123, 90,179,
  7,108, 99, 91,  7, 41,242, 73,209,114,149,238,149,177,142, 40, 52,242, 59,168,
112,126, 80, 11,162,177, 46,252, 25,120,  1,152,230, 98, 29,228, 54,251,170,  6,
 35,117,169,180,191,134,240, 52, 85,236, 11, 68,148,241, 97, 83, 62,185,204,  7,
 36,194,199,197, 15,195,116,113,120,170, 40,114, 93,237,209,186, 62, 40, 44,215,
182,223, 71, 46,195, 32,149, 51, 87, 69,192,184,  9, 29, 69,192,173, 64,195,203,
 28,221,  0,242,188,114, 69, 55,120,140,231, 78,195,151, 14, 45,113,208,215, 43,
218,195,202,123,  0,215, 45,111, 39, 64, 94, 14,173, 50,239,132, 17,176, 66,250,
243,122, 30,177,226, 57,235, 25,228,223,252,149,249, 69,196, 21,182,192,151,197,
122,209,122,133,220,176, 37,138,136,189,188,171,145,120, 30, 28, 11, 97,140, 85,
 27, 18, 11,125,246, 32,225, 35,187,240, 10, 57,168,107, 27,166,167,172,167,  9,
167,228,139,108,  4,103,161,  4,222,129,133, 83,225,166,253,221,245, 18, 42, 98,
 27,212, 74,246, 61,253, 69, 61,115,183, 38,236,115,116,159,137, 84, 40,130,114,
253, 94, 51,207,132,255, 43,200,167,103, 36, 71, 17, 49,155, 34, 74, 28,107,181,
200, 60,222,123,213,145, 68, 85, 42,120,229,108,193, 53,  8,118,227, 45, 81,246,
106, 15, 72, 15,183,177,215, 70,203, 73,113, 49, 79, 28,250,136,135, 97,124, 46,
 63, 42, 14,226,242,153,244,217,206,168,166, 84,202, 30, 37,189, 92,162, 29,  1,
161, 11,219,195,167, 56,220, 97, 53,215,150,199,196, 69,141, 65,219, 73, 88, 38,
  2,  9,217,108,180,245,184, 60,224, 78,125, 97, 38,  4,145,122,111,214,105,233,
 77,169, 80, 51,152,140,165,141,113,117,226, 63,102,237,212,191,116,199,118, 40,
133,203,155, 98,228,179, 13,  6, 30, 14,  4,226,  1, 32, 60,152, 48,204, 40,127,
142,156,168, 23, 74,132,100, 81,151,205, 91, 35,221, 64,  2, 48,  0,211,132, 20,
100, 43,197, 83, 27, 61, 98,156,205, 75, 34, 65,226, 31,206,  0,185,111,136,249,
 53,245, 68,254, 16,210,254,234,  6, 13,157,199, 24, 24, 46,223,117,249,244,173,
240,197, 97, 44, 31,122,181,169,190, 36, 20,149,232,138, 34,231, 65,222,155, 31,
 68, 77,166,116, 11, 99,137,251, 76, 47,161, 74,104,125,148, 76,248, 60,226,210,
229,235,165,195,201,244,140,211,164,201, 93, 48, 19,108, 38,  2,200,142,137,137,
254,179,122, 90,241, 82, 30,
} ;

// ../Source/Template/GB_AxB_dot_cij.c:
uint8_t GB_JITpackage_9 [2904] = {
 40,181, 47,253, 96,149, 87,117, 90,  0,186, 86, 40, 16, 41,192,146,117, 14,106,
166,126,159, 61,135,219,228, 88, 54,247,173, 34,237,169,111,132, 51,228,  6, 14,
151,236, 98,102,232,194, 69,151,  1,211, 36,  8,162, 73, 14,  2,243,  0,242,  0,
  5,  1,111, 18,205,147,163,160, 72, 51, 56,134,199,243,162, 52, 61,192,105,129,
224,232, 93,218,242,249,245,250, 43, 86,129,  0,117,145,231,168, 20,211,174,186,
174,212,235, 78, 32,163,193, 64, 33,236, 35, 69,153,150,129, 62,154,188, 71, 43,
  9,183,197,210,168,239,188, 71,156, 97,166, 27,230,181, 71, 30, 71,168,244,  0,
 93,157, 17,158,  7,204, 43,  9,129,249,  5, 55,158,220,187,239, 40,207, 95,235,
189,107, 60, 98,250,206, 19, 20,195,206,199,116,148,253,149,204,141,157,189,226,
143, 63, 41,233,199, 24,201, 65,  5,129,210, 35,110,138,242,151,219,212,163,185,
118,119, 81, 26,215,230,104,135,130,145,  9, 85,186, 38,221,198, 45, 58,206, 35,
 14, 42, 58,  8,202, 87,  9,  8,  7,  8, 20,  6,203,  1,194, 41,110,122,133, 41,
105,102, 94,145, 47,141,178, 13,105,246, 10,147, 29,107, 36,206,203,185, 52,190,
 83,196, 58,211, 17,147, 80, 29, 86,  1,  1, 69,171,203, 36, 15,113,170,163,162,
 19,230,157, 71, 49,180,220, 47, 29,148,211,178,237, 52,235, 67,106, 22,231,  6,
  6, 18,138,129, 65,147,  4, 67,147,249, 92,154, 28, 61,218,213,128, 58,  6,220,
219,  2, 18,  9,237,202,174,207,181,201, 72, 96,154,  7,195, 83, 61, 42,192, 85,
 56,106,144,189, 27, 79,183,167,192,  9, 50, 61,195, 62, 32,140,214,145,159,203,
 35,210,100,154, 70, 36, 59, 24, 77,166, 65,234, 17,116, 55,130, 92,165,  2,221,
 40, 90,177, 47,189,214,160,  4, 86, 91, 65,104, 72, 51,206,248, 25,143,225, 40,
219,141, 66,152,222,217,112,187, 52,108,252, 14,  8,100,105, 90,198,125,237, 12,
 79,249, 40,120,156,185, 41,  2, 97,220,195,130,158,189,173,225,136,241,124, 69,
 77, 32,181,190, 68,113,133, 85,116, 66,161,189,222, 45,159,111, 16,164, 30,175,
121,138,165, 82,247,198, 86, 20, 71,252,234, 54,169, 61,172,  4, 56,111,215,230,
168,186, 58,246,102, 71,165, 44,134, 77,169,182, 86, 75, 51,215,185, 82,122, 11,
 68,198, 71,118,212, 86,235,125,255,190, 73, 30, 55,189,158,253,165, 83, 28,113,
121,134, 47,213,170,171,125, 30,237,113,  6, 39,229,186, 67,139,143,187,163, 36,
209, 37, 67,191, 54, 79, 27,210,147, 73, 38, 46,140,166,177,144,152,134,101,200,
139,142,252, 50, 25,105,125,223,228,251, 38, 20,214,198,163,255,102,223,201,228,
193,225,150,111,202, 92,160, 15,200,163, 97, 42,180,140,231,194, 52,233,225, 72,
 81,168,224,213,  1,229,166,103,157, 10,143,101,189,234,248,182,233,150,197, 84,
147,226,171, 15,249, 42,211,112,232, 55,167, 75,170,195,122,193,193, 36, 27, 79,
110,161, 76, 16, 67,122, 50, 13,182,217,128, 50,190,212,235,111,230, 95, 38, 50,
 76,116,109, 52,133,133,106,154, 48, 58, 33, 15, 70,155,224,124, 52,136,217, 52,
184,141,182,202,147,115, 89,  8,  9,  8,  9, 11,150,  5,203,102,131,241,248,170,
161,161, 99,249, 56,248,192, 79,141,211,148,105,152,137,170,179, 65,107,183,169,
  3,246,136,197,199,220,193,118,183,185, 62,132,243,185, 68,151, 71,131,113, 66,
  6,  6,222,233, 84,108,232,148, 18,164,118,108,212, 69,154, 80,134,132,136,200,
 53,152, 72,134, 48, 13,187, 52,107, 58,117,240,136, 79,207, 68, 26, 12,147, 14,
207,119,102,172, 65,220,210, 20, 22,254, 75, 66, 64,252,249, 11,213, 24,164,106,
131,164,130,137, 20,167, 83, 95, 18,201, 72, 41,211,112,230,209,110,243, 77,154,
 35,203,178, 44,171, 99,210, 11,157,205,113, 59,252,232,122,231,247,125, 27, 61,
196,100, 66, 68, 80, 85,117,  9,140, 72,102,136, 44,205,115,137, 50,202,136,131,
222, 73,246, 26, 20, 45,148,141, 94, 38, 61,135,105,183,209,110, 81,220, 62,169,
 37, 74,113,122,131,116,228, 97,243,187, 82,193, 27,176, 12,187, 48, 52,154,197,
  1,192, 77, 39,204, 29,196,  9,218,103,  2,109,163, 21,124,109,230,154,116,207,
 30,156,248, 54,105,226,238, 78,143,143,155,219,231, 71,153,122,188,171,237,222,
219, 59,112,180,220, 75,125,123,244, 18, 56,251,230,103, 91, 95,193,165,106, 45,
 62,158,207,165,237, 85,215,153, 90, 80,252,104,220, 88,254,151, 82,126,147, 95,
138, 84, 82,147,248,138, 66,137,184,148, 84, 30, 98,227, 15, 23,197,239,167,190,
107, 39,207,254,163, 59, 15,123, 29, 54, 44,148,174,182, 54,249,  6,181, 40,171,
 64, 30,226,152,201,128,250,166, 83, 40, 17, 35, 95,143, 55,227,140,233, 71,107,
 27, 26,223,172,131, 74, 31, 10,131, 34,168, 66,156,208, 49,101,136, 68, 36, 73,
 82, 41, 52,  6,226, 32,  4,130, 64, 32, 75,114,141,221,  6, 66,137, 32,  8, 52,
 16,131, 17, 48, 66,  8, 49,132, 16, 67,  8, 33,136,  8,132,136,136,200,136,140,
200, 12, 59, 18,161,164,188,225,157,159,153, 54,218,159,114, 93, 57,215, 92,224,
 52,160, 62,241,195,164, 86,133,245, 10,173, 59,121,212,195,190, 76,176,168,203,
104, 90,173, 21,166,110, 12,182,207,128,198, 20,243, 61,110, 90, 77,  3, 76, 82,
  3,169,243,134,  1,107,167, 26,239, 21,130,183, 32, 35, 46, 96,175,237, 80,196,
225, 18,187, 64, 44,  1,147, 42, 76,228, 31,207,249,130, 75, 75, 45, 61, 24,183,
224,242,114,246,195,183, 25,239, 64,148,203,109, 53,251,162, 16, 39, 31,203, 67,
201,179,212,109,234,229, 22,220,217,171,  4,250, 17, 67, 11, 53,125, 74,156,240,
220,206,108,165,155, 92, 96, 76, 53,124, 25,166, 30,136,226, 13, 41,147,105,114,
  2, 12,217,229, 22,143, 33,172, 71, 74, 15,227,  1,235,181, 25,170,198,106,  8,
 41,110, 39,223,149, 90,  3,201, 12,111,248, 21, 44,249, 81,187, 62, 45, 27, 15,
152,188, 55,154,231,140,222, 37, 16,182, 34, 75, 40, 95,138,198, 27, 27,122,246,
211,194,254,168,102,187,212, 22,215,214,116,  5,106,237,189,247, 87,  1, 75,162,
153,182,249, 29,234,196, 93, 49, 51,207, 30,214,184,164,122, 34,156, 95, 11, 74,
 71,102, 61, 22,109,237, 43, 86, 69,155,181,147, 38,245, 95,195, 92,212,216,136,
 64,126,213,235,238, 82,213,167,227,175, 98, 15,227, 36, 74,140,  0,232,242, 28,
165,128, 10, 85, 14,235,201,177, 24, 65, 52,138,146,117,181,146,111,248, 43,126,
236,110, 66, 52,213,148,120,241,  5,225,249, 33,145,  7, 33, 76,194, 65,143, 10,
197,184,219, 67,123,208,167,162, 26,225,165, 64, 97, 14, 22,207, 65, 26,241, 23,
162,  0,163, 29,231,116,194,227, 47, 42, 61, 56, 67, 80,213,225, 42, 18,251,161,
197,204,102, 19,131, 45, 79,248, 84,241,101, 71,229,102,  2,122,192,166,234,237,
 42,149, 17,117,119, 43, 34, 54,180, 29, 91,187,148,186, 58, 43,  0,126, 16,234,
 58,140,  3,137, 89,120,202,210, 24, 53,246, 22, 57,239,189,185,208, 89,187, 88,
 59, 43,221,253,118, 97, 44,188,207, 55,216,255, 97,235,186,188,185,223, 22,118,
254,136, 74, 29,139,124, 23, 58,212,111,119,123,254, 80,199, 38,199,165,185,185,
 24,  8, 54,225,204, 73,158, 91,213, 72,174,185,221, 51,245, 90, 83,199,239, 12,
164,131,217,157,212,178,165,115,212,232,237,156, 57,118, 56, 99,206, 28,142,151,
 83,195,185,242,147,177, 29,103,162,200,117,237,113,225,177, 49,252,187,127,181,
162,225,245, 79,167,184,160, 27, 52,248,182,149,230,207, 62,179,194, 31,177, 10,
109,184,129,174, 10,195,134,  5,106,217, 46,116, 69,237, 84, 42,154, 26,217,152,
118,108,172, 64,223, 75,140,239,187,209,167,146, 30,190,198, 39,205,212,225, 94,
 61,103, 30,253, 16, 35,  1,143,239, 66, 27,126,186,  9, 18,  1,  7,119, 77, 85,
  5, 82, 48,251,253,101,151, 19,158,153,224, 84,125, 88,104,115,201, 73, 82, 58,
 70,117, 48,109,217,  3,254, 14, 13, 72,  7, 41,189,101,225, 69, 67,153,120,119,
182,155, 30,134,112,233,121, 62, 46,117, 48,160,112, 26, 13,133,186,103, 88, 46,
186,  0,132,  3,207,169,130, 82, 77,111,225,222, 36, 52, 78, 22, 60,135,227, 14,
111,132, 16, 65, 78,163,104,112, 29, 57,161,143,153, 48, 92,177,132,  7,182,178,
 31, 17, 98,245,168,106, 90,150, 78,115,185,208,133, 63, 30,160, 61,158, 85,252,
223,131,110,179,236,177,183,184, 64, 61,209,175, 67,  8,149,200,123,  0,197, 18,
227, 49,130, 62, 32,123,213,136, 50, 59, 64,113,145,223,106,216,217,227, 64, 10,
204,224,166,148, 45, 31, 35,166,135,115,182,220,233,140, 53,115, 59, 95,206, 26,
142,149,  7,145,224, 57,127,244, 47,233,165,107,249, 23,114,231,171,120, 64, 19,
 43, 72,115,  7, 30,116,193, 66,135, 34,209,250,141,141,  2,137, 32,218,  6, 23,
132,158,148,160,179, 14,232,235,160, 45, 71, 74, 97, 39,209,160,  2, 92,208,118,
159, 58,213, 91, 86,  5, 61,127,241,127,105,139, 59, 51, 88,180, 69,192,170,245,
113,185, 94,227,120,252,160,224, 20,  9,113,117,229,236,230,  5,  9,175, 39,  5,
186,189,239, 26, 93, 12,113, 93, 44, 18,126, 11, 49,177,168,106,149,230, 33, 70,
234,  8, 22,244, 83,229,127,117,152, 63,110, 61, 91,142,220, 84,158,140, 41,113,
185,146,181, 43,144,223, 48,108,143, 58,126,165,133,207,107, 23, 50, 87,171, 14,
 33,151,  5,152, 29, 24,159,238,245,156, 83, 86, 56,160,152,230, 66,  1, 33,179,
190, 11,194,165,156,127,171,125,216,160,148, 15,205,178,226, 73, 79,243, 66, 47,
177,204,240, 16,161,232,190, 67,200, 37,251,179,193,193,224,216,104, 15, 73,137,
195,180,135,212,132,  9, 46,135, 49,207,224,116,192, 83,119, 24,152,149,253, 45,
166,145, 68,225,126,104, 50, 92, 71,133,144,201,217, 70,217, 13,207,106, 12,215,
145,148, 97,168, 21,107,144,219, 99,151,106,158,171, 15, 90,213, 36,213, 79, 32,
 17,213,117, 14,179, 86,241, 39, 75,172,133,  5,203,254,115, 72, 65,131,165,230,
  0,241,193,226,162, 42,240, 19,234,251,248,119,233,186,214, 18, 65, 90, 86,134,
 17, 35, 11, 17,228, 23, 34,178,  9,220, 51,184, 98,252,139, 46, 59, 52,113, 60,
 75,116, 19,177, 73, 26,243,192,150,103,213,251,243, 11,117,185,  2,182, 10,140,
 53,177,161, 74,106,  5,172, 43, 46, 17, 90, 87,205, 15,191,178,179,102, 43,179,
198,180, 70,189,138, 29, 37,192,211,252,  7, 12, 50,203,204,112,232, 20, 32,212,
254,  4,253, 31,142, 35,100,153,154, 29, 33,157, 11, 57,195,113, 34,223,155, 84,
168,237, 42, 86,115,116, 26,108, 54,243, 20,197, 72, 58, 43,138,203,142,226,209,
234, 44,197, 40,  0,175,194, 45,103, 69, 59, 57,171,255,195, 89,227,209, 93,101,
 22,170,236,152, 61,  7,108,254,170,219,186,105, 14, 44, 27, 46,149, 51,  2,121,
 21, 29,240,245, 31,194, 60,120, 41,213,233,161,221, 25,235,199, 30,220,153,103,
215,254,175,106,239,235,241,214,188, 42,100,150, 54,164, 97, 22,229, 98,137, 89,
 24,128,243,  2,225, 58, 98,  7,162,158,201, 53,249,214, 61, 85, 56,201,214,229,
 14,184,198,193, 20, 85,145,200,  6,245,153,195,171,149, 52,157,143,127,106,177,
111,173,103, 43, 63,  1,234,122, 44, 35, 26,178, 54, 33,192,157,129,  3, 11, 12,
 80, 70, 54, 82,231, 74,227,236,197,242,166,  4, 65,150,188,168,  5,148,121,  5,
 68, 11,250, 52, 70, 84,  7,129,120,236,121, 58,134,129,236,139,125,114,133,253,
 72,  1,194, 73,105,222,212,223,202,169,156, 68, 56, 84, 13,117,132,149,121,152,
235, 60, 77,246, 94,194,159,128,153, 77,109, 95,172, 64, 76, 73,217,210,136,140,
109, 43,189,  1,201,  2,200, 83,196,122,151,222, 40, 95,149,215,199,207,  2,231,
145, 60, 11,118, 25,199, 65, 14,200, 65, 79,239,182,151,198, 31, 77, 79,115,122,
 82,233,199,249, 21, 36,207,234,137, 71, 30, 65, 67,118,136, 13,234,135, 61,126,
232, 31,146,204,106,127,235, 51, 80, 18,104, 67,212,146,225,136,195, 85, 88, 93,
124, 22, 44, 78,134,130,158,166, 97,179,255,142,242,245, 89,226,237,216,136,233,
111,128,189, 17, 65,158,  2,126, 50,165, 84,110,241, 75,142, 68, 40,130,251,  1,
204,235, 49,231, 35,105,165,240, 19, 68,  9, 30, 63,142, 71,  1,214, 48,135, 32,
 92,232,152, 21, 75, 91,232,130,196,197, 33,103,219, 59,239,100,129,127,114, 70,
241,155,152,171,182,105, 19,124,193,164,132,218, 92, 38,230,103, 83,123, 71,100,
 92, 40,224, 74,  7, 96,  8,183,120,187,205, 76, 99,125,207,216,134, 66,164,  9,
129, 82,181,119, 91,219, 93, 23,138,243, 34, 95, 35,100, 72, 27, 13,156, 70, 41,
114, 46,251,121,237,188,173,105,108,157, 28,130, 38,  4, 29, 44,147, 90, 53,216,
198, 48, 60,198, 81,148, 74,238,245,180,122, 58,  4, 60,117, 33, 96, 56,146,  8,
 17,196,  1,148,191,106,244,136,229,119,176,146, 96, 69,178,184,  9,235, 39, 76,
213,  8,197, 64, 93,200,143,202,162,240,121, 51,158,111, 57,242, 40,210, 44,185,
236, 35, 96,194,139,242, 20, 99,133,163, 93,115,150,112,226,193, 72,119, 36, 68,
 37, 24,114, 65,136,107,184,105, 86, 14,204,  4, 68,128, 47, 63,136,204,253,166,
 86, 14, 25, 20,
} ;

// ../Source/Template/GB_AxB_dot_cij.h:
uint8_t GB_JITpackage_10 [1313] = {
 40,181, 47,253, 96,250, 22,189, 40,  0,214,182,163, 40,208,210, 56,  7,168, 73,
177,111,246, 72, 71, 89, 58,113,163,105,119,215,150,230,149,180, 27,232,249, 35,
 65, 52, 25,240,252,162,231, 47,240,197,  3, 89,106, 94,152,  0,149,  0,153,  0,
114,179, 63,119,247,150,171,244, 54,230,174,252,228,128,155,242, 55, 86, 40,124,
165,247,141, 88, 59,  8,232, 32,222,164,231,216,146,110,251, 28,237, 46,143,190,
113,167, 77,  5,147,138,132,187, 77,126,240,150,202, 29,234, 59,153,203, 36,108,
 39,111,189,145, 84, 96, 34, 38, 28,123, 84,182,236,185,189,221, 70,123,238,121,
240,214, 65,165,160, 34, 81, 48, 40,168,188,218,168, 91,182, 61, 36,230, 19,120,
144,238,210, 81,107,183, 62,112,115,117,159,172, 26, 11,219, 42,191, 15,223, 38,
125,166,109,160,210,208,237,164,125,123,118,136,185, 91,186,  9, 71,111,241, 82,
 46, 94, 37, 24, 47,205, 41,148, 73, 66,161,  4, 25,132, 39,163,197,140,  7,110,
176,204,181,164,209,217,235,208,  5,152, 35,121,219,236,128,201,237,115,229,238,
131,126,118,202,122,227,165, 51,194,119,183, 63,110, 85,102,255, 26,128, 23,236,
126,188,149,248,150, 45,105,126, 45, 29,217, 59,155,126,135,159,232, 37,230,102,
211,123, 79,146, 58,248,221,165,160,115,189, 46, 13,248, 97,188,161, 39,103,143,
 42,223,135,250, 34,201, 21,244,105, 85, 28,215,  7, 94, 85, 34,171, 41,248, 74,
 95,181, 37,162, 32,245, 11,129, 69,235, 96,166,201,198,236,218, 35,182,223,192,
140, 39,122, 50, 24, 17, 63, 18,155,  8, 90, 57,228,244,254,246, 45,135,180, 39,
173,150,239,173, 83,205, 82,149,152,110,191,116, 82,103, 15, 68,162,156,117, 37,
245, 66,183,108,229, 13,190, 19, 36, 65, 72,160,232,108, 24, 60,153,137, 78,135,
163,201,226,  5,243,103,194,217,254,237, 79,  6,189,224,151, 43,187,218,238,174,
 39,185,198,218,242,139,150,228,125,255,255,105,210,112, 50, 79,  6,145,249,196,
248,201, 66, 29, 48, 77, 31,237,147, 85,100,152, 84,239,  3,166,  7, 44,211,128,
 69,135, 12,251, 36,  5, 76,111, 10,219,184,219, 40,151,173,237, 18,199, 13,233,
133, 62, 37,123,180,187,219,100,235,202,147, 55, 34,179,165, 14, 34, 63,126,233,
148, 63, 87, 90,133, 80,215, 62,156, 14, 22, 55,144, 19, 15, 23, 67,118,219,199,
 96,224,  9,168,135,218,178,181,158,244,152, 91, 20, 89,121, 13, 64,216,229, 26,
216,135,113, 12,195, 52,137,136, 62,193,111,149,215,198,203,177,239, 55, 34, 36,
220,217,159, 28,221,  6, 85,110,137,180,141,  4,196,172,124,175,252, 56, 78, 86,
  2,144,186,174, 91, 28, 34, 16,245,139,242,203, 63, 64,161,182, 35,252,110,149,
224, 45, 45,163,169, 90, 36,169,195,202, 31, 72,103,177, 91,170, 31, 80,231,184,
187,183,184,166,147,142,142,201, 58,156, 14, 68,180,224,192,105, 10, 53, 55, 71,
 22,126, 17,201,240, 60, 57,178,188,112,  2,130,234,250, 44,248, 89, 79,134, 38,
183,205, 60, 43,  0,234, 55,129, 11,168,177, 37, 98, 72,102, 68, 68,146, 36, 41,
 12,107, 97, 12, 66, 12,163, 80, 75,245,226,136, 76,135,115, 24,134,140,128, 16,
 35,104,  2, 39, 16,137,145, 96,  2,145, 64, 38,146,201,134, 49, 85,170,178, 68,
225,153,248,155,  3,168,  7,245,149, 85,248,162,252,211,225, 44, 80, 28,200,157,
120,242,165, 78, 17,205,244,196,202,255,118,229,184, 57, 40,168,251, 59,158, 90,
127, 86, 22,102, 25,174,250,194, 73,250,138, 64,240,181,230,109, 82,213,132, 27,
 31,140, 66,118,217,175,239, 83,146,137,157, 92, 88,148, 57,118,210,192,170,225,
 31,144, 20, 80, 48,124, 87, 67,  6,254, 98,224, 97,196, 63,240,243, 40, 46,  6,
 79,133,240, 19, 63, 64, 66,  1,  0,241, 27,178,201, 77,165, 42,127,125, 22,156,
 45, 44,143,187, 45, 24,245,242,210,203,106, 37,186, 60,227, 56, 15,128,251, 70,
 14,135,144,178, 90, 77,149,249,141,219,193,243,161,171, 83, 55, 13,126,117,154,
 49,160,245,162,215, 79, 88, 88,190,194,105,134, 62,142,172, 27,136, 13,229,124,
 56,125,199,159, 14, 62,219,167,140, 90,  2,213,204,  6,205,106,190, 91,235, 49,
 86,241,112, 70, 34,137,158,212,163, 94,190, 22,223,175,132, 66,122, 11, 44,190,
 51,184, 37, 24, 26,211,140,233, 30,250,134,132, 71, 80,212, 89,180,116, 35,250,
 92, 39, 51,205, 71, 72,101,  4,137,146,200,114, 50, 58, 95,180, 25,208, 12,143,
162,249,237,173,205,230,228,217,149,199,115,126,187, 71,216,225, 68, 44,133,134,
246, 85,206,139,187, 39,151,112,  3,  8, 21, 18,101,205,155, 97, 92,182,242,105,
144,149,244,106, 38,100,164,233, 60,227,112,142,184, 67, 21,220,159,159,190,167,
100,150,  8,115,139,121, 26, 88,136, 85,175,148, 15,127,  4,153,121,  4, 54,175,
 83, 71, 26,168, 34,238,231,243,172,150,133, 61, 68,215,169, 76,  2,118,115,100,
169,191,131, 52, 21, 91,161,144, 88,162,178,194,153, 56, 46,130,222,246,120,116,
 80, 81, 72, 29,234,150, 43,208,166,214,100,226,  6,136,122,242, 32,226,126,192,
 54, 68,  9,213,233, 11, 85, 34,158,235,242,180, 24,221, 58, 23,162,165,195,232,
197,159,149,132,116, 90, 10,206,165,106,161,  7,207,222,230,192, 36, 44,165,115,
135,233,211,123, 51,235,150, 82,187,113,215, 58,194,121,206, 43,102, 38,148, 74,
133,199, 73,159, 73,180,143,106,206,143, 12,186,145, 85, 84,249,  1,120, 36,248,
236,121, 27,234, 78, 82,110, 41, 48,220, 42, 74, 65,126,241, 33,194,160,207,151,
173,152,205,205,165,170, 83,249,170,102,170, 25,114,246,170, 14,142,201, 55, 91,
 64,163,117,  0,129,144,216, 66,143,105,100,218, 39,117, 66,200,197,238,124, 45,
118,154,161,185,246, 34, 60,168,184,173,145, 81,210,136, 20, 40, 58,106, 24,151,
 53,102,175, 80,110,225,136, 62,183,104,183,106,101,139,155, 38,169, 50, 83,155,
 49,210,190,136,108,126,210, 45, 77,170,149, 85, 12,
} ;

// ../Source/Template/GB_AxB_macros.h:
uint8_t GB_JITpackage_11 [323] = {
 40,181, 47,253, 96,  1,  2,205,  9,  0,102, 18, 61, 32,  0,181,115,187,239,245,
255,243, 94,189,182, 75,165,157,  6, 77,199, 10,128,130,102, 53, 17, 43, 55,222,
161,255,127,247,135, 23, 50,  0, 52,  0, 51,  0, 49,187,104, 56, 47,100,209,248,
206,112,235, 92, 63,155,132, 59,144,230,254,222,117,158,158,190,239,236,252, 40,
 20, 77,124, 65,239, 95, 80, 10,131,151,155,159,188, 68, 81, 94,144, 87,149, 52,
 85, 85, 53,219,238,176,169,177,109,174,102, 19,166,161, 81, 93,131,110,227,174,
 28,103,202,169,149,123, 60,241,  3,131, 69,176, 38, 69,129, 96, 93,192,  5, 62,
192, 21, 52, 27,167,226, 71, 52,131, 95,181,124,176,  5,205,205, 16,119, 46, 24,
122,211,124, 91,143,237,247,241,128,220, 61,240,183, 55,223,199,182,173,  0, 41,
 34, 55, 74,133, 17, 37,242,194,120,221, 89,175,  2, 36,  2,101, 77, 77,185, 25,
198, 47,110, 87, 47,146,228,213,206,118,226, 89,118,121, 72,202,134, 33,174, 69,
137,225,  6,217,160, 68, 44, 14,137,180, 96, 87,174,155,195, 29, 26,108,147,153,
 99, 18, 53,121,200,104,152,184, 29,110,235, 59,120,230, 83,110,118, 24,  0,100,
  0, 16,209, 69,147,  0,132,159,197,127,140,  4,232,230,139, 14,208, 24, 38, 11,
  0, 52,140, 40,104,193, 66,232,182,175,205,149,247,155, 11,236, 68,  6, 28,248,
 72,116,153, 65,243,231,153, 41,218, 42,182, 90,157, 98,208,248,249,242, 22,140,
 41, 10,134,
} ;

// ../Source/Template/GB_AxB_saxbit_A_bitmap_B_bitmap_template.c:
uint8_t GB_JITpackage_12 [2034] = {
 40,181, 47,253, 96, 92, 46, 69, 63,  0, 10, 66,108, 12, 40,176,148,117, 14,104,
161,216,247,231,240, 22,185,101, 49,202,214,112,144,109, 18,210,147,255,231,116,
195,169,154,153,193, 58,122, 36, 63,232, 63,216,254,193,185,185,  0,187,  0,186,
  0, 31,166,249,153, 43,141, 25,219,203,253,255,167,105,100,154, 42,217,189,251,
 81,254,205,182,223,213,177,230, 76, 57,124, 91,235,150,251,215, 88,197,144,209,
199,139, 63,247, 52, 76, 71,255,252, 21, 16, 44,121,150, 58,210, 99,239, 36,238,
103, 19, 65,165,128, 82, 71, 28, 21,229, 49, 99,109,175,179,173,157, 70,169,216,
 86,174, 61,148, 11,  7,138, 74, 87, 61,198,138, 43,232, 56,143, 58, 26,116, 16,
148,191, 12, 10,  8, 10, 40,  9, 23,130,130, 87, 28,245, 11,183,  7,117,120, 69,
 62,100,148,111,216,162, 95, 33,233,193, 70, 34, 29, 33, 48, 21,143, 84, 12,213,
220,165,208,148,105, 56, 94,239, 33,150,254,243,235,217, 47,108, 34, 53, 22,195,
 39, 96, 33, 59,  6,155, 34, 13,167,156,185, 55, 16,138, 39,  6, 34, 39,  6,113,
139,101,162, 88, 44,  1, 31,219, 15, 25,179,173, 94,255,227,166,121,145, 56, 36,
 18,137, 99, 93, 18,218, 71,251, 39,154, 95, 40,157,173,141,201, 35,205,184, 53,
  1, 78,198, 50,181,138,115,105,212,179,215, 92,226,126,243,115,237,248,136,101,
 45,100, 78, 85, 24,164, 30,150,195, 88,148,189,157,185,241,211,198,171,203,197,
117, 72,109, 72, 71, 85,176,212,213, 17,135, 95, 81, 51, 44,217,131, 21,  4,233,
 72,197,139,225, 61, 13, 59,232, 40,  6,116,157,183,204,132, 99,121,117,161, 88,
191, 80,199,252,242,134, 87,  4,215,104, 62, 53,251, 60, 15, 16, 64,104, 56,175,
207,150, 70,220, 47, 74,115,220,209, 58,142,178,125,230, 85,216,221, 54,121,101,
 43,232, 65, 95, 81,212, 53,255,198,251,241, 10,110,165,219, 41,116, 14, 16,190,
201,208, 66,115,227,209, 68,213,182, 87,187,  0, 28,199, 76, 56, 76,136, 62,140,
230, 29,250,133, 15, 67, 97, 24,121,141,245,113,199,105,123,147, 19,141,115, 19,
 68, 94, 52, 37,238, 81,174, 29,116,188, 25, 31,164,220,  5, 95, 71, 10,114,181,
203,125,177, 63,252,204, 51,109,175,187, 27,190,110,207,215, 90,202,125,154, 74,
198, 92, 75,182,115,149,  1,168, 62,148,215,157,205, 68,234,164,158,159, 41,218,
 64,120, 13,214,130, 15, 80, 29,102,206,145,137, 26,223,178,107,190,113,207, 83,
 33,243,190,245,201, 51,241, 83,145,174, 30,107,182,125,197,119,119, 55,192,  7,
  6, 22, 78,122,230,213,171, 31, 23,  4,233,172,153,118, 98,105,130,247,110, 30,
 79,197,  3,133,252,136, 52,140,132,228,160, 13,  5, 70,196,  4, 77,204, 77,  8,
 36, 41, 66, 51,164,205, 78, 72,126,188, 14,200,106,135,165, 56,119, 24, 62, 29,
175,118,182, 20,112,  8,  9, 13,164,125, 52, 73, 49, 49, 36,100, 71,235,  8, 82,
233, 64, 81, 97,149, 88,150, 88,107,230, 85,254,181, 17,105, 32,139,201,209,178,
201, 39,154,231,175,167,156, 34, 79, 69,230,164,111, 98, 24, 70, 29,203, 53,  4,
215,219, 77, 92, 95, 54,218, 25,  7,174,221, 83,230, 28,  7,137,137,108, 19,154,
160,137,135, 41, 34, 93,187,149, 96,216, 70,186, 62, 10,219, 72,216,118,108,194,
 25, 55, 72,173, 72, 24,236,157, 78,  9,201, 57, 52, 28, 31,229,163,110, 85,148,
166,164,172, 62,201,209,  4,184,167,244,238, 43,174,157, 85, 42,149,239,251, 40,
179,186, 54, 73,125,163,223,173,203,133, 19, 92, 18,155,244,252,149,220,175,248,
138,216,210, 49, 87,145,198,247,238, 47,220, 97,123,236,176,226,219,166,100,176,
 75,219,199,251, 80,117, 58,122,193,130,  2,168,  2,212, 80, 49, 68, 50, 34, 34,
146, 38,201,176,  6,178, 24,132,193, 80,162,135,177,164,187,  1,162,112, 36, 12,
 50, 20,195,112, 16,130, 48, 40, 66,  8, 97,  2, 98,  8, 35,132, 16,161, 64,100,
 36, 16,145,235, 28, 56,194,179,200, 36,226,118, 14,229,201,129, 35,135,215,  4,
105, 32,173,  0,172, 10,199,240, 34, 76, 37,168,234,210, 95,129,247,229, 64,250,
121,198, 77,237,229,109, 91,172,193, 34, 12,185, 16,225, 44, 38, 71,144, 96,117,
 76,107, 23,154, 13,219,253,223,140,114,112, 43,207,202, 77,141,233,180,197, 12,
186,176,180,123,121, 75,160, 12, 77,202, 99, 10, 77,243,118,223, 63,176,232,110,
 68,166, 62,238, 29, 13, 16,146, 59,201,109,168,176,250, 21,124,235,214, 25, 38,
246,100,217, 43,165,215,192, 72,155, 22,159,234, 69,149,136, 69,120, 66,253,185,
 75,137,124,202,152,254,125,217,211,194,175,152,156, 35,253, 70, 35,199,191, 71,
120,224,160,152,141, 80,220,181, 87, 49,250, 68, 75,176,242,114,202,136,239,196,
 69,245,176,130,232,227,  7,179, 20, 81,174,230,219, 29,181,208,208, 92,236,243,
182,103, 96, 76, 63,107, 31,193,251, 34,230,139, 76,207,254,250,229,208,195, 13,
210,154,158, 81,187, 72, 10,237, 72,227, 34, 71, 71, 31,108, 71,105,105,241,242,
177,236, 70,  5,250,138, 41,143,101,192, 21,192,245,121, 58,247, 81,243,228,233,
135, 53,166,146, 70, 22,237, 22,187,119, 89, 81,182, 95,192,147, 62, 53,206,173,
240, 48,153, 30, 36, 34,129,218,  6,195,102,153,  0,203,159,162,217, 12,249, 75,
 83,221,158,143,  0,  0,196, 53,  5,166,127, 73,188,129,184,187, 35,244,124, 38,
107, 96,182,  2,182,162,170,148,  5,213,128, 52,113,176, 61,198,234, 27, 65,  8,
132, 33,194,160, 74,153,129,169,219,255, 49,131,192,162, 52,236, 59,159,228, 30,
170, 78,212,245, 60, 54, 41,143, 30,142,138, 97, 60,169, 72, 59,  9, 64, 15,  8,
  4, 91,201, 62,129, 28, 70,  8,250,231, 44,135,209,141, 11, 39,200, 77,248,182,
199,175, 10,  4, 55, 25,163,206,  3,156, 70,146,102, 91, 60, 72,150,145,135, 24,
126,118,216,189, 44,251,140,162,  4,254,132, 71, 85,136,204, 97, 96, 26,217,213,
234,136,202,200, 74, 48,115, 42,  1,155,160,204,140, 73,212,161,106,179,140, 94,
141, 51,220,212,225,  7, 99,  4,255,216, 47, 92,200, 13,221, 93,161,135, 48,159,
 89,214, 81,214, 95,196,226,241,253, 94,187,182,188, 73,255,  6,133,155,140, 39,
194, 67, 91,107,192, 60,175,  3,146,108, 32,222,181, 53, 12,209,173, 50,180,230,
146, 53,176,  8, 56,220,124,108,108,131,212,125,190, 91, 32,100,127, 39, 46,236,
211, 63, 95,  3,  2,104, 87,  9,189,117,128, 18,229,175,227,116,  6,125,183,183,
 61, 19,217, 35,230,205,156,156, 81, 58,183, 98,110,167,101, 87,160, 32,205,251,
  6,130, 26,202, 32, 34,125,251, 55,250, 75, 72, 62,  2,219,196, 61,223,131, 39,
181, 17,167, 29,255,105,161,154, 60, 73,181, 38,243,143,199,196, 57,177,245,234,
156,245, 19,161,102,148, 61, 96, 29,154, 15,135,242, 80,250,136,248, 77,121,154,
203, 53,144,248,186,143,113,182,243,140,107,110,  2,143,188,182, 82,172,121, 71,
 76, 20,210,200, 59,240, 47, 78,252,104,250, 65, 77,167, 86, 52,144,159,252,218,
241,145, 65,101,112, 67,155,247,  4, 50, 87,108,203,247,109, 94, 12, 38, 95,  6,
 74, 45,170,212,243, 76,179,234, 46,177,132,176,196, 60,239,224,182, 14,240,198,
178, 49, 56, 86,212,163,162, 15,129,152,164,140,136, 49, 58, 84,127,108,  4,228,
244, 84, 90, 73, 86,193,  8, 84, 37, 40,162,211, 12,156,110, 34, 59, 18,254,152,
102, 57, 44,247,250, 17,229, 73,171, 36,242, 80,101, 68, 77, 50, 17,252, 45,191,
 72,120, 39, 37,122,205, 89, 99,217,168,201,149,218,207, 95,228, 82, 75, 61, 11,
161, 88,192,144,197,219,128,118,225, 47, 74,233,240,165, 65,135, 24,134,216,250,
185,231, 22,125,150,233, 94, 57,122,198, 91,180,118, 68,108,236,  3,  3,152,128,
161,  8, 71,229,132, 12,145,204,161,  3,215, 76, 24,248,161,  0,241, 12,  6,150,
112, 29,133, 24, 69,138, 76, 17, 50, 58,231, 20,245, 94,243, 97, 32, 47, 26,116,
215,166,133,214, 88,  0,247, 17,246, 34, 55,182, 56,193, 16, 57, 52, 63, 90,209,
 34, 78, 90,173,155,139, 24,220, 29, 18, 80, 50, 52,200,154,199,  2,213, 75,201,
 82, 56, 61,131, 47,138,148,137,197,211,111,196, 43,131, 12, 65, 15, 24, 98,133,
 25,207,208,165,201, 18, 77,230,157,245,106,102, 64,196,210,226, 63,174, 36, 69,
199,144, 73,207,243,211,130,252, 87,248, 78, 54, 77, 95,133,243,236, 25,176, 28,
117, 37,154, 75,156, 38, 28,173, 92,193,255,151,147,128,198,130,217, 66, 76, 76,
 33, 74,132,252,139,171,227,220,140, 90, 26,195,168,251,192, 23, 46,241, 27,105,
122,153,216,247, 41,  3,  6, 17,167,103, 72,240,222,139,180, 92,208,224, 18,225,
227, 21, 76,204,156,130, 63,148,169,219, 26,159, 95,145, 59, 18, 43, 20, 93, 50,
246,144,221, 66,  4,194,254, 25,138, 99,133,195,195, 44,183,253,132,176,104,  9,
 24,120,192, 20, 12,241, 37, 66,154, 74, 40,114,211, 61,150,140,195,190, 30,199,
100,178, 37, 51,  8,219, 12, 15, 81, 11,168,  2,126,159,131,107,163, 26,177,126,
 85,166,168,124,137, 38, 87, 81,  2,208,252, 38, 85,192, 51, 58,  5,146,129,190,
102,159, 90, 75,241,125, 77,218,124,158,126,153, 77, 83,171,101, 38, 39,  7,235,
229, 27,196, 74, 14, 96, 83, 57,175,  8,130, 10,215,243,
} ;

// ../Source/Template/GB_AxB_saxbit_A_sparse_B_bitmap_template.c:
uint8_t GB_JITpackage_13 [4065] = {
 40,181, 47,253, 96,174,115,189,126,  0,138,110,116, 20, 45,160, 14, 93,231,122,
116,135,  4,  1, 73,208, 36,142, 42,115,127,127, 22, 25,112,137,252,151,177,241,
167, 13,244, 52,233, 10, 79,113,181,154,155, 43,120, 29, 94, 71,158, 28,103,  8,
 52,  1, 69,  1, 55,  1, 18, 62, 61,162,214,159,156,163, 77, 98, 47,220,248,163,
217, 79, 83,178,155,228,250,185,217, 23, 78,143, 15,126,244,242,243,200, 10, 54,
 68,190,245,253,111,125,178,157,149,151,106, 89,255, 63,  3, 67,  5, 12,195,184,
222, 38, 55, 48, 76, 19,204,131,141,196, 20,218,158,103, 55, 48, 76, 32, 88, 52,
153,132,227,109,114,221,176,177, 48,248, 54,229,227,180, 53,157,244,123,198,114,
 97,178,  7, 19,215, 22,122,218,108,233, 35, 77, 90,143,103,229,238, 90, 87,158,
236,169, 44, 91,169, 73,238,209, 97,243, 81,231, 12,126,124, 63,155,141,109, 88,
233,149, 94,248,133,154, 38, 79,167,  3, 59, 71,207,159,123,122,103,127,227,202,
247, 74,205,126, 50,203,207,111, 87,122,206,114,199,229,119,120, 94,200, 57, 72,
 30, 29, 42,131,163,207,117,135,237, 99, 12, 15, 14, 72,131, 63,154,  4,175, 87,
149,155,235, 59,121,179, 52,216, 78,214, 90,162,225, 32,  2,227,216,248,162,178,
229,204,237,253,120, 58,115,207,187, 30,  9, 64, 30, 32,141,  3,143,  7,200, 39,
 77,122,180,125, 33, 35,238,184, 62,250, 92,250,245,230, 81,115, 73, 72, 62,160,
172,148, 74,195,183, 67, 13,131,103,246,231,142,166,252,229,241,216,163,132,113,
 89,  9, 46, 13, 16,216, 43, 80,126,153, 36, 99, 91, 37,104,179, 43,187,221, 17,
 73,155, 73, 68, 87, 38,161,220,193,129,161,225,224, 16,147,136,140,129, 69,194,
  4,  2, 69, 80,231,145,172,252, 54,242, 38, 80,236,164, 79, 93,108,233, 58,152,
 72, 96, 46, 20, 24,132,  1,  3,158,153, 88, 36, 48, 22, 74,214,117,118,101, 27,
137,138,203,131,109,231, 83, 71,194, 92,151,205,196, 68, 51,201, 96, 50, 80, 23,
 78, 74,169,176,215,  9,233,230, 61, 78,121,228,215,145,123,146,107,246, 43,169,
199, 69, 88, 40, 38, 40, 46, 25,132,  0,182, 32,211, 84, 72, 96,176,202, 37,210,
171, 63, 92,193,169,237, 76, 66,137, 18, 52,182,166, 23,146,132, 34,153, 24, 29,
137,244, 73,234, 80, 42,111,149,190, 82,144,252, 62,191,208,163,218,103, 63,130,
179, 49,234, 52, 58,143,147,117, 74,164,  1,206,200, 33,143,  6,  4, 84,129,211,
162, 32,172, 63, 36,211,163, 81,197, 74,138, 15,143,220,101,251,241, 87, 37,123,
 26,227,167, 46,210, 56,146, 36,154, 78,153,176,100, 44,151,137, 38,203, 52,  0,
222, 48,217,187,208,206,184, 69,132,179,214,158,205, 42,210,169,115,156,171,117,
189,150, 43,227, 55, 67,112, 67,237,244,138, 42, 92,133, 53,  9,218,174,210,208,
101, 79, 38, 49,153,216, 88, 36, 14, 46, 77,180, 92, 44,214, 61,158, 18,108, 88,
159,125, 31,191,222, 46, 58,143,210, 39, 40, 44, 27,203, 38,115, 97, 38,131, 30,
111,149,215,130,126,179,  2,  6, 46, 38,177,124,193,179,191,202,151,183, 83,212,
 60, 68,228, 15,183,164,201,122,242, 98,106, 21, 37, 77,218, 87,171,103,  8, 24,
197,130,108,211,145,128,210,179,176,181,185, 78,192, 29, 44,199,245,143,214,159,
144,141,143, 70,150,101,243,244,254,225, 31,173,236,153,178, 94, 50,233, 45, 95,
 89, 25,164,231,207, 70,235,143, 94, 57,137,136,184, 38, 17,155,204, 68,163,185,
 88,147, 30,216,152,163,141,155,218,254, 70, 63,151,191,201,159,208,185,134, 55,
228,102,159, 59,247,188, 14, 93,203,239,136,215, 11, 45,215,203,241,137,190, 76,
 82, 41,167,247,134,224,236,207,206,176, 75,231,227,198, 87,106,212,243,228, 71,
 30,118, 81,215, 43,191, 56,242,238,228, 90,195, 11, 20,197,220,221,170,128,143,
153, 73,101,115, 81, 38, 12,148, 14,234,236,146,109, 38, 20,  9,137,138,  5,211,
227,242,  9,  0, 62, 65, 62, 64,146,250,187, 71,105, 39, 83,201, 50, 20,217, 68,
163,105,160,185, 46,151,119, 26,127, 44,176, 14,166,253,145,115, 56,251, 78,170,
125,178,  0,112,198,187,210,125,202,122, 67,188, 27, 59,189,175, 76,193, 12,  3,
 35,159, 64,  7,231, 33, 64,  1, 52, 71, 86, 96,  4,  6, 56, 95, 17,152, 10,139,
154,108,185,130, 23,174, 37,122,148, 62,217, 88, 50,156, 81,189,147, 31,226,249,
202,244,112,203,186,  5,  8, 68, 85,192,  8,231, 42,145,127,154, 58, 30,233, 14,
140, 83, 45,189,114,134,195, 43,116, 60,147, 77,133,131, 74,247,216,127,236, 90,
 62, 70, 62, 93,233,147,204, 37,129,  5, 12, 12, 23, 40, 14,215,215,134,160, 77,
254,134,157,199,141, 57,122, 27, 94,176, 59, 14,199,122,119,119, 40, 52,157,  3,
 17,177, 30,154, 42, 72, 75,183,221,176,242,220,167,141,175,149,218,157, 66,161,
 24,187, 45, 24,147,244,234, 12, 80,  4,203, 58,182,134,132,170, 71,136,  3,233,
234,209,156,137, 35,157, 47,180,196,233,230,112, 64,169,226,112,143, 12,233,164,
255,156, 87, 14,182,216,247,133,150,235,230,119,112,244,182,242,103,235,203,145,
 31,208,222,214, 26,147, 47,218, 51,161,243,159,219,161,199,199,227,113,117,246,
 94,142, 70, 52, 76,190,183,107, 40, 18,169,116,134,140, 71,131,192, 43,125,132,
 60, 62, 30, 31,110, 43,207, 16,101,239,192, 99, 68,176,153,176,100,147, 76,197,
  6,115, 97, 23, 14, 84,168,108,211,237,194,109,233, 16,  0,116,100,125,198,193,
243,116,226,119,240,149, 27, 24,126,122,114,179, 44,238,124, 74,141,107,204,114,
161,216, 92,149, 91,176,240,200,187,  3,  4,  8,240,164,144,233,  2,192,178,164,
 63,104,101, 10,241,210,121, 80,107,213, 67, 53,251, 59, 95,121,109,131,111,207,
 22,241, 54,251,234,134,136,220,234, 80, 89,215, 69, 56,120, 93, 83,148, 80,186,
 83,214, 37,224,187,169,235, 30, 63,151,244, 43,171,116, 20, 69,117, 29,164,171,
 30,221, 37,157,250, 36,194,170,106, 82, 43, 47, 66, 10,227, 65,129, 34,103, 16,
 49, 65, 17,132,106,168,147,137,146,214, 57,166,100, 68,100, 36, 41, 72, 90,  3,
243,160, 16, 16, 20,145, 76,230,147,161,168, 85, 31,163, 97, 17, 57, 16, 29, 67,
129, 72, 20,130, 64, 60,130, 32, 32,131, 64, 32,130, 64,  8, 33, 16,193,132, 16,
 70,  4, 68,236,142, 27,  5,186, 41, 71, 39,255,139, 14, 55,255,247,179,236,238,
207,  3,131,249,124, 91,219, 86,  9, 20, 45, 65, 46,  5,210,177,133, 40,221,200,
203,206,212, 20,252, 81,156,  4,213, 53,143,237, 25,254,144,177, 75,164,  7, 25,
126, 66,169,101,166, 41,190,210,235, 97,239, 58, 39, 60,203,154,  9, 72, 43,185,
152, 66, 65,139,164,202,243, 99,176,244,135,116,226,139,219,  7,212,242, 55,243,
 82,246, 56,219,171,126, 51, 68,116,141, 89,230,161,222,197,168,189, 67, 79,208,
193,  3, 46, 96,197, 24, 25,156,191,139, 38,204,171,130, 96, 14, 58,209, 23,150,
 99,164, 93,242,187, 68,108,128, 20,173,164,188,252, 60,105, 20,181,227, 41,  2,
  4,179,  5,203,157, 90, 26,  6, 80,132, 31,105,219,135,170,252,160,157,  4,135,
160,232,135,191,210,134, 11, 62, 18, 20, 98,142, 55,245,242,121,173,108,255,  7,
100,206, 83, 91, 19,242,244, 41,169,199, 12, 87,190,101,180,156,255, 22,119,196,
  6,148,218, 16, 65,150, 42, 90,189,126,192,249, 29,100,  0, 75,  1,130,209,134,
170,187, 50, 21, 14, 54,249,  8,130,159,181,152,229,143, 97, 13, 99, 50, 69, 73,
 63,188,141,163, 67,129, 34,228, 42, 52,102,182,117,215,  8, 67,122,252, 14,124,
 81,227,163, 55,177,131,210,252,229, 52, 68, 93,163, 50,184,243,138, 99,103,212,
142,189, 46,227, 25, 85, 83,118, 79,224,201,248,111,148,239,  3, 94,108,  1,107,
 71,157, 45, 80,134,122,185, 68, 52,117, 94,243,  3,250, 75, 30,214,157, 66,236,
 81,244, 86, 37,104,225,105, 27,203,129,201,156, 49, 78, 46,213, 20, 85,116,119,
 38,203,228,246,132, 53,135,252,131, 11, 31, 63,183,241,133,176, 23, 36,139,158,
173, 22,164, 42,205,181,139, 39, 99, 47,  2,236, 66,103,200,136, 89,150,153, 85,
153, 48,204,120,224,238, 62,205,190,221,130, 26, 61, 74,  9,152,185,188, 68, 67,
206,244,106, 24,115, 93, 87, 12,122,210,156,205,158,110,222, 71,199,220, 40,154,
 92, 53, 27, 28,109,112,228, 19,137,107, 37,202,240, 39,242,253,183,190,176,136,
 21,182,220,237,161, 26,149,227,150, 38,106,237,123,223, 80,243, 73,113,218,104,
166,160,147,118, 68, 56, 17,148,188,112, 78,172,172, 19, 52,217, 92, 52,115, 54,
202,213,194,236, 72,188,110, 27,211,149,240,196, 13,185, 77,165, 51, 90,194,199,
 52,196,112,140, 42, 74,246,218,116,139,237,243, 65, 39, 80,249,220, 55,218,237,
 40, 29,170,238,202, 18, 49,122, 52,119,150, 10,166,198, 62, 50,194, 43, 24,192,
 46, 16,172,  5,222,180,204, 81,165,204,103,117,127, 74,133, 63,193,180,205,137,
 10,245,222,231,248,226,138,102,130,189, 36,174, 72,212,200,230,140,165,148, 14,
161,207,217, 15,224,176,  0, 13,126,119,246,116,238, 22,127, 38, 44,217,138, 38,
140,103,226,134, 41,140,227,121, 57, 38,130,240, 75,158, 31,244,243,233,203, 17,
183,227,138, 38, 91,224, 32, 93,130, 59, 19,110, 17, 77,200, 47,186,118,168, 24,
233,219,152, 42,209,107,144,156,166, 55,236,162,169,133, 41,235,234, 50,164, 73,
  2,121, 76, 41, 24, 87,219, 65,201,104,138,154,106, 41,223,100,201,131,122,136,
174,242,187,182, 68, 80,181,119, 57, 33,146,158,106,144, 41,101, 47,132,203,  2,
 95, 37, 17, 11,140,182,124,  0,211, 95, 38,198, 30,109, 45,  6,162, 96,210,157,
218, 16, 32,109,130,192,232,  8, 59,  1,218,169, 59,247, 65, 79,171,128,242,194,
  1, 50, 41, 99,157, 69, 23,255,113, 96, 68,  7,252, 49,202, 37,228,220,156, 20,
198, 30, 66,190, 26, 32,133,155,155, 91, 81,130, 69,132,101,150, 83, 26, 35, 58,
  8,210,194, 54,124,165,215,104, 77,  8,203, 57,145,178,140, 14,217, 29,101, 19,
231,139,254, 72, 35,  7, 80,215,186,196,226,184, 83,153, 55, 75,177, 37, 31,146,
183,241, 22, 78, 72,150, 49,208, 45,203,130,110, 16, 78, 70,115, 98,155, 19, 79,
123, 54,183, 70,223,220, 92,231,253,113, 64, 65,  3, 46, 57, 34,159,123, 15,  8,
 25, 77,  6, 73, 11,183,119,104,123,152,237, 96,204,  4,172,233, 37,146, 60,108,
213,  4,242, 73, 65,169,248,248,202,181,119, 45,212,168,105,200,113,209,240,139,
 65,236,156, 96, 83, 66,  7,157,138, 84,135, 86, 97,143,186, 17, 17,208, 87,121,
139,216, 43,138,114,213, 15,144,118,160,220,226, 39,118,169, 79,211,190,239, 46,
213, 74, 66,118,211,104,150,129,253, 61, 15,133,179,178,152, 13,146,  6, 82,204,
 90, 14,158,162,231,118,175,166, 74,246,213,  1,167,112,234,221, 38,121,134,102,
 33,185,147, 94,113, 21, 27, 85,150,128, 56,235, 18, 44,102,  2, 48,151,182,183,
105, 49, 30,128,234,248, 48,  1, 92,146,158, 87, 67, 67,138, 71,205,209,144,158,
209, 73,237, 16,182,180,125,202,158, 53,200, 48, 20,178,119,227,122,  6, 81, 65,
132,136,189, 61,108, 53,213, 52,222,195,199, 90,246,102, 85,222,  6,119,195,125,
141,129,100, 37, 72,150,239,241, 12,218,217,142,130,150,112,154,140,121,252,152,
 18, 18,105, 69, 94,140,132,  0,149, 52,200,117,192,150,238,132,  9, 74, 21, 15,
102, 58,194,232, 39, 67, 30,  9,206,103, 59,  6,207,178,180, 68, 31, 57,  1, 73,
208,224,190, 37,131,  6,214, 36, 74,201,229, 74, 90,100, 20,120, 62, 52,199, 48,
155,231, 27,245, 15,194, 38,238, 26, 85,209,149,233, 98, 48, 37, 37, 71, 86,158,
212,125, 98,113,158,210,223, 14,135, 91,158, 54, 86, 46,  9,237,162,133, 41,209,
184,165, 27,218,216,154, 99,242, 32, 92,166,  4,119,225,101,152,133,125,183,151,
179, 71,  2, 57, 77,235, 20, 47,194, 21,104, 40,178, 90,125,115,184, 88,216, 22,
 97, 51,188, 93,198, 67, 23,176,130,236,  3,206,190,158,199,144,101, 97,102,245,
 34,217,175,184, 40, 39,112,118, 73, 66, 13,185,114,108,243,155,  1, 67,135, 66,
 72,116,168,132, 79,238, 40,210, 39, 48, 48, 67, 29,165, 32,146, 34,120, 88,116,
101,236, 88,175,125,210,235, 16,210, 96, 60,247, 60,163,108, 56,195, 30, 34,131,
179,100,197,238,220,112,121,238,107,207,203, 94,159,127,186, 63,163,  4, 90,222,
183,229,141, 18,225, 13,126,227, 22,133,225,210, 93,119,195,226, 41, 48, 85,162,
 53,182,  7,231, 29,253,233, 53, 76, 86, 54,130,230, 12,201,202,238, 25,212, 56,
 50,154,192,125,113, 71, 73, 25,235, 90,134, 90,108,167, 31,201, 96, 82,164,244,
 21, 57, 55, 97, 59,186,199,213, 76, 92,180, 78,241,141, 38,103, 53, 56, 61,220,
133,191, 60, 80,136,219, 41,199,116,242, 75,252,226,117,135,225, 62,244, 19,214,
143,129,  8,139,233,112, 82, 15,114,208,144, 18,212, 73,  6,246,240,100, 77,209,
139,141, 76,188,157,239,163,221,  4, 74,236, 88,195,142,152,164,129,104,132,244,
150, 29, 61, 87, 70, 16, 36,141,203, 93, 15,138, 96,102, 29,107,181,241,137, 11,
 63, 72,134,240,221,135,  0,134, 17, 57,107,197, 22, 51,221, 98,136,119, 63,120,
106,122,144,123,239,154,111,203,  4,178,140, 35,117, 41,155, 84, 97,248,233,250,
141, 96, 67,179,190, 87,151,240,154, 60,138, 19,166, 55,239,163,183, 89, 91,114,
249,227, 91,102,158,108, 55, 51,216,101,192, 92,167,228,110, 50,176, 15, 41,141,
112,157,113, 32,226,246,221,232,165,119,184,255, 72,192,247, 96, 40,119,227, 44,
 36, 21,112, 67,122,216,227,194,100,210, 50, 12,136, 77, 56, 19, 60,110,202, 88,
 66, 30, 12,228, 24,123,222,199,131, 98,247,253,179,189, 62,224, 24,126,188, 74,
163, 35, 87, 59,246,136,139,215,121, 67,203,241, 85, 66, 70, 11,126, 97, 42,192,
 65,170, 36, 72,155, 82,141,181,131,  8, 51,199, 32, 60,151,108, 45, 19, 39, 91,
158,226, 35, 76, 69,252,170,154, 49,193, 20,237,232, 26,163, 59,205,178,227,107,
178, 34,254,152,  1, 48,104,144,  9, 52, 12,255,159, 64,132,165,148, 12,151, 67,
201, 73,222,242, 86,149, 83,253,242,116,115,244,118,202,129,198,246,190,102,156,
168,149,155,167,204,251,109,147,232,108,116,254, 95,235,216,118,217, 65, 15,237,
178,243, 56,178, 48, 45, 55, 69,236, 30, 97,116,167,112,215, 14,139, 99,180, 79,
192,134,206, 73, 69,175,142, 58,165, 13,201,217,251, 16,179,121, 97,117, 60,196,
 76,195, 66,131,122, 27, 58,189, 84,145,151,114,131,197, 25,198, 85,245,196,193,
203,155,197,188,219,159,229,245, 68,236, 33,139, 71, 10,  1,195,129,186,133,199,
187,115, 43,221,  2,143,231, 13, 19,213, 67,251,192,125,172,191,130, 99,163,108,
135, 17, 89, 93, 66,233,166, 29,192, 22, 65,156, 12, 74, 98,162, 16,121,147, 71,
 77, 80,227,  1,154, 19,134, 62,166,229,217,137,179,116,116, 30,184, 72,190, 94,
 77, 32,133,108,201,  9,121,254,125,106, 84,101, 41, 96, 12,  9,164, 18,255,197,
148,169,240, 52, 91, 45, 16,187,218, 95, 44, 52,152, 29,233,150,237,249,178,151,
158, 89,113,168,225,182, 38,244,249,105, 54, 78, 59, 65,170,193, 17,229,219, 96,
 78, 49, 68,100,  4,  9,161,200, 44,167,163,251, 43, 12,252,101, 33, 46,108,126,
142, 16, 27, 85,214,173,209,242,166,161,197,242,125,209,140,202,249,174,147,181,
 43, 81,222,193,206,180,204,210,181,153,185, 33,188,132,  8, 64,160,158,200,196,
107,208, 41, 36,151,198,249,159, 60,163, 93, 49, 86, 10,113,168, 79,155,  2,138,
 41,249, 27, 82,147,184,224,144,193,121,175,205, 55, 13, 42, 95, 11,219,206,138,
178,192, 33,234,130,139,225,179,138, 92,102,209,218,197,101, 56,148,  4,220,102,
 68,199, 73,254,178,225,  5, 98,231,199, 31, 10,185, 78, 18, 59,146,173, 70, 60,
 22,178,  8,127, 53,165, 80,241, 99,198, 88,210,191, 17,114,140, 80, 77, 25,198,
155, 98,230, 87,208,155,154,112,209,213, 90, 59, 19,219,109,189,251, 40, 83,212,
180,106,173,131, 69, 20,252, 74, 50,255, 81,172,142,179,101, 60,190, 29, 97,149,
204,204,129,147,  4, 38,116,123,239,130, 90,253,225,250,124, 20, 35,185,191, 63,
183, 15,253,158,126,125, 13,174,128, 17,222,110,177, 73,102, 89,191,197, 70,101,
166,111,  9,198,254, 24, 39,177, 41, 41,171,  7,183, 48,134, 69, 90, 62, 58, 37,
 22,187,216,161, 75,196,186, 82,124,178,170,164, 12,170,154,  4, 13, 33,126, 21,
 15,  5, 62,206,167,226, 65,136,179,160, 55,240,135, 24,222,136,108,178, 84,145,
153,145,  7, 16,252,105, 96,184, 35,144,195, 19, 28, 76, 70,196, 11,102,186, 54,
101,185,169, 92,193,191, 48, 65,219,201,144,164,229, 63,100,208, 95, 92,169,123,
 15,134,189,209, 83, 29,180,125,131, 33, 59, 68,130, 40,142,143, 39,178,237, 71,
245, 57,110, 47,112,101,172, 87,216, 99,155, 93,121,255,123,232, 76, 46, 47,232,
243,110,141, 12, 39,118, 16,149,204,243,155,167, 52,201, 61, 64,194, 24,233, 22,
 14,150,217,188, 19,179,163,184,246,240, 52, 32, 24,164,219,160, 36,134,  1,244,
 79,205, 38,175,189,191, 56,221,126,122,216,156, 58, 48, 82,197,161, 49,  7,147,
 59,131,151,100,244, 72, 36,185,132,207, 64,120, 19, 71,130,247,119, 62,180,168,
 62,166,247,243,147, 27, 68,160, 63, 11,202,131, 77, 11,118,223, 22,174, 16,111,
178, 64,188,231,254,234,179,207, 19,114,254, 70, 76,132,128,228, 79, 80, 37,133,
 22,222, 71, 46,123, 88,141, 65,168, 96,204,242, 77,219, 43,182,159,217, 54,218,
 67, 84,210, 52,198, 92,182, 56, 59, 77,183,187,161,175, 69, 82, 64, 24, 68,131,
195,  6, 67, 59,229,142,120, 48,210,232, 25,172,109, 44,211,111, 12,153, 96, 51,
 74,152, 78, 76, 20,152,  6,176, 72, 53,122,  6, 87,152, 20,239,138,244,247, 37,
219, 48, 60,248,  0, 63, 49, 71,249,146,228, 57, 40,244, 20, 21,146, 64,  1, 57,
 89,141,111,153, 62, 15,202,113,104, 94,  5,  2,126,222,179,  9,145,244,153,249,
176, 65, 93,101, 73,168,237,149, 66, 68, 95,178,111, 16,179, 90,175, 73,231,163,
  6,206, 77,227,102, 65, 31, 89,130,166,221,216, 57, 66,129, 70, 42,235,162,221,
 99,154,  9,138,107,233,193,184,179,184, 40, 80, 33, 36,162, 68,127, 84, 34, 18,
 99,112,200,184,171,112,140,103,102,247,204,145,183,214, 44, 60,228, 33, 58, 31,
 40, 54,205,172,110, 48,177,157, 99,158,129, 51,117, 12,217,127, 24,215, 37,153,
112,122,142, 97, 27,
} ;

// ../Source/Template/GB_AxB_saxbit_template.c:
uint8_t GB_JITpackage_14 [2199] = {
 40,181, 47,253, 96,208, 59,109, 68,  0, 22,253,183, 40,192, 84,117, 14,228, 92,
191,207,158,227, 11, 23,146,239, 51,  9,202, 26,192,226, 60, 48,177,183, 43,166,
238,194, 48, 56, 38,108,241,244,187,138,130, 45, 10,184,171,  0,166,  0,180,  0,
147, 82,233, 57,206,126,239,237,156, 23,218,121,235,154, 13,118,241,185,128,168,
112,141, 67,174,202, 79,  0,191,174,  5,189,111,152,103,120, 51,126,119,249,184,
 43,253,110,231,230, 30,202, 20,107, 33,112,114,169,100, 40,221, 77,  9,198,107,
110, 83, 16,205,181, 57, 14,165,113,237, 73, 43, 40, 24, 15,158, 10,215, 31,183,
113, 99,199,185,227,160,216, 61, 47,126, 50,200, 92, 50,148,  4,204, 37,115,105,
 70,159, 48,253,144, 15,175,196,135,186,108, 63,250,249,148,197,138,170,  3,229,
141,208, 52,190, 18,204, 58,211, 48,155,128,242, 59,166,183, 94,187,  3,121, 69,
 16,169,134, 75,128,193,186,102, 86, 58, 75, 15,252, 58,107,153,110, 33, 18,107,
 85, 72,212,170,136, 91, 44, 19,138,197, 18, 27,137,142, 86, 85, 91, 85,225, 26,
171,143,114, 82, 60, 69,213,246, 62,230,  1, 66,198,213,206,133,111, 13, 20,235,
212, 55,235,121,210,155,113, 95,130,103, 77, 33, 87, 26,146, 32,158,252,194, 37,
201,138,238,137,215,135, 83,105, 85, 68,244, 15,182,201,178, 88,197, 79,215, 39,
235,185, 57,254,255,147,201,200,165, 95,227, 91,100, 28, 13,227, 68,143,150,209,
241,170,125, 14,183, 87,249, 10,197,110, 15,201,239, 85,252,237, 46,211, 77,230,
252, 85, 37, 74,158, 23,130,166, 41,212,125,234,232, 89,126, 19,215,161, 39, 63,
 60,201,245,215,118,126,202,182,230,218,184, 47,120, 13, 71, 13, 85,121,113,212,
 86,251, 97,249,254, 36,253,181, 89,222,  6,237,191,112, 78,  9, 10,147,201,138,
 42,189,212, 49,209,232,122,232,230,218,239,166,236,204,169,130,111, 88,160,198,
 71, 44, 75,127, 59,103, 57,177,197,210, 64,201, 82, 72,116,141, 67,116, 41,132,
210,109,235, 58,240,186, 70, 34,128, 83,215,117, 93,210, 21, 65, 96, 22,218, 47,
151, 44, 58, 31,235,  2,251,100,158,203,194,210, 40,178,120,105, 30, 88, 94,223,
229,123,214, 90,132,226,144,143,118,117, 21, 21, 23,157,139, 58, 21,163, 68, 66,
242,232, 90, 45,198, 24,165,140, 92,123,219, 23,118,104,113,246, 71,149,148,110,
 91,215,129,  7, 35,182,241,100, 72,108, 50, 44,122, 50,128,186,224, 89,187, 53,
246, 90,179,152,106,213,187,210,138, 77,  7,219, 80,104, 31,206,  4,168, 57, 16,
 21,144,170,232,156,215,157, 38, 82, 43,117,145,186, 69,127,168,  8,147, 73, 73,
135,115, 81, 62,123, 65,207,244, 87,182, 55, 63, 45,204, 83, 37,184, 39,189, 89,
126,247, 60,249, 99,226,181,112,131,107,142,185,195, 37,204,165,175,124,188, 38,
151,215,240, 82, 89,226, 39, 91, 79, 81, 63,128,133,161, 82, 17, 68, 42,126,210,
219,181, 57, 66,215,230, 41, 65,  1, 49,224,205,133,222,172, 63,198,224, 96, 15,
 12,220,235,122,219,227, 35,156,237,114,231,217, 94, 99,203,178,172, 73, 68,135,
131,113,174, 77, 86, 85, 85, 85,197, 24, 99,199,  3, 48, 41, 49,192,100, 48,246,
182,200,215, 65, 53, 26, 92,169,157,  7,177,245,214, 65,152,147,125, 59,156,235,
196, 81,233,164, 94,107, 25, 45,187,168,240,104,216,230,243,137, 86,214,137,224,
100,217,116,197,233,242,233,  1,130,163,168,130,212, 12, 25,146, 17, 17, 17, 73,
146, 20, 50, 28,194, 41,  4,  2,113,152,199, 97, 41,111,146,152, 28, 19, 65, 36,
130,192,136, 35,134, 17, 34, 32,132, 32, 66,228, 68, 34,145, 68, 35, 34, 34,109,
  3, 50, 36, 99, 83,106,231,140, 74,109, 26, 80,169, 77,128, 42,181, 21, 43,133,
171,143,157, 43,233,207,133, 59,160,138,125, 75,105,145,204, 34,181,254, 36,181,
105,143,162,180, 45,130,156,160,106,200,251, 68, 75, 77,150,193, 74,153, 58, 24,
 60,253,203,  2,116,159, 97,209,208,198, 82,127,244,129,  5, 30,136,162,115, 34,
 77,100, 94,230,132, 34, 70, 64, 45, 44, 95,104,188,216, 43, 43,210,161,195,246,
183,172,196,147,168,157,158,115, 92,122,104,119,  8, 18,  0, 73,238,  4,176,233,
205,216,107,208,116,  4, 44, 19,203,  4,160,126, 64,111,  6, 82,185,171,204,180,
 14, 49,204,150, 79, 58,  3, 64, 61, 40,222,184,100, 19, 65,104, 35, 40, 54, 78,
221, 27,183,176,165,132,167, 20,117, 68,171, 24, 62,213,142, 82,210, 13, 87,230,
 60, 38,133,119,137,  0, 52,  1, 20,173, 33,152, 61,216,134,174,138,126,168,155,
 24,226, 97,158,181, 27,254,  4, 82, 58,235,153,147,132, 14,208, 37, 43, 77,165,
227,187, 59,204, 97, 15,103,250,195, 13,168,222,204,149,177,247,172,193,122,  4,
124,160, 48,215,125,199,131,213,133,203, 14,163, 11, 25, 26,144,114,213,107, 44,
162,187,102, 48,166,224,208, 28,222,168, 18,192,  3, 33, 49,245,214, 98,202,164,
 78,240,137,224,180, 77, 33, 22,156,197, 10,139,214,214, 45,156,202, 38,116,169,
 61,163, 75, 47, 15, 31,218, 41,225,165,201,203,114,164, 56,226,136,157,165,  4,
 62, 85,202, 28,234,228,200, 61, 14,123, 97,207,  6,143, 93, 31,138,109, 73,162,
218,226,173,254,253,203, 23,168,  0,155,159, 35,213, 91, 89,217,106, 57, 19,223,
 75, 15,100,164,234,149,137, 39, 63, 59,246,143,252,183, 45, 87,106,145,250,132,
 84,104,101, 37, 32,  4, 76,171,204,120, 90, 28, 17,200,158,228, 62,209,212,114,
248, 26, 46,221,180, 38, 34, 92,157, 24, 37, 64, 80,175,139,240, 11,145, 79,216,
 68, 49,113, 11,203, 50,190, 70, 37,148,126,197, 10,193, 51, 59,  1,  6, 67,158,
 82,128,144,222,234,152,229,213,139,143,249,106, 52,243,243,188,134, 56,124, 29,
164,195,187,155,115, 84,161,150,143,147,209,149, 67,137,209,  7,212,224, 17,225,
  9,200,247, 72,118, 24,122,191,128,157,185, 83,127, 87,168,221,247,  9,110,110,
141,232, 31, 48, 50,204,211,  8,191,208,141, 16, 17,245, 83, 58,  1, 55,126,144,
168, 29, 52, 54,105, 18,248, 65, 80,  0, 26, 22,  0, 62,172, 64,170, 94, 85,141,
251,236,241, 79,230,169,163, 13,184, 36, 87,230,173, 74,248,203, 12,109, 57,220,
 25, 66, 35, 47, 79,120, 20,162,229,133,140,221,238,126, 52,154,125,235,113,216,
183, 43,138, 78,169, 46,162,253,181, 11,225,199, 33, 25,198, 65, 59, 87,246,238,
239, 49, 98,207,110,140,148,230,216,115,216,207,217, 82, 70, 61,  3, 98,241, 41,
147,204, 38,101,176,166,171, 60,238,131, 52,118, 39,122, 48, 40, 89,248, 19, 88,
228,234, 85, 32,187,182,244,192, 59, 95,216, 36, 27,155,253, 80,222,168,244, 33,
212,132, 26,247,237,140, 55,127,235,106,224, 53,138,155, 74, 55, 72,164,  9, 79,
174, 96,168, 53,226, 83,154, 17,254, 41, 97,  2, 74,146,175,220,  6,208, 56,118,
 45, 14,215,252,187,246,120,122,166, 10,152,160,132, 37,238,164,150, 31,235,153,
 16,159,110,236,118,177,164, 57, 96,231,155, 20,139, 68,199, 62,172,128,215,108,
 11, 28,144,142, 51, 46, 59,147, 37,129, 87,112,202, 33,190,  3,217,224,130,195,
145,114,142,104, 21, 56,206,226,150,153,228,238,249,193,204,253,219, 50,252, 36,
  9,235,210,153, 59,172,233,149,171, 64,118,107, 43,164, 66, 43, 87,  4, 94,248,
179,153, 29,169,127,252, 81,139, 58, 49,196,240,210, 30,145,202, 64,223,232,230,
108, 38,132,213,148, 79,149, 66, 75, 21, 54, 45, 55,188, 56, 20,249,138,254, 50,
  1, 95,118,228, 36, 48,192,195, 14,179,169,219, 39, 16, 93,135,214,169,169,241,
 66,102,144, 29,  5,130,195,111,158, 65, 41,164, 69, 71, 89, 31, 18,225,158,143,
234,160,214,223,196,  8, 63, 63,107,  1,188, 11,204, 57,234,151,220,158,198,119,
202,240, 94, 43,222, 12,142, 43,168,153, 33,205,189,157,  3, 93,201,141, 27,192,
195,132,194, 20,144,136, 21, 79,249, 89, 95, 43, 66, 88,203,116,252, 66,231,191,
202,105, 24, 75, 99,248, 82,100,190,193, 10,247, 26,136, 62,169,188,165,194,102,
226,217,188,177,220,154, 67,209, 63,254,211, 85,243,130,110,201,195,226, 78,197,
 23, 94,240,131,119,125,172, 71, 44,240,153, 10,113, 80,152,161, 50,103,204,104,
108, 60,201,191,108, 77, 65, 67,230,117, 62,169, 52, 45,113, 76,126,108, 82,232,
246,206,  3,111, 71,141,198,155,187, 55,170,157,133,152,166,160, 32, 19,105,121,
118,164, 50,237,200,249, 58,176,226, 80,167,155, 96, 47, 20, 32, 32,133, 32,145,
174,150, 40, 68, 34,119, 80,174,222,124,237,244, 22,176,146, 84,  2, 26,198,152,
 22, 25,127, 44, 50,139,197, 75,124,172,168, 77,113, 55,176, 72,227, 78, 28,137,
114,  1, 16,238, 21, 45,175,249, 62,189,154,184, 13, 58, 42,116,155, 28,216,131,
203,113,141,206,120, 68,248,103, 91, 74,191, 44,210,159,146,101, 96, 37, 10, 66,
163, 57, 43,153,238, 20,134,168,152, 19,110,237,161,226,138,195,178,212,  5, 47,
132,114,184, 56,219,115,224, 43,214, 86,120, 87, 36, 28,  6, 50,230, 56, 90, 87,
111,116,209, 12,255,189,132,136,161, 62,245, 80,231,163,  7,101,177,120,219,221,
139,248,237,185, 50,207,225,120,160, 59,197, 11,105, 77, 88,149, 78,128,120,122,
 89,156,129, 59, 40, 18,  1, 73,191, 18, 38,128,169,222,221, 21, 33,165, 12, 10,
182, 73, 79,138, 80,136,102, 79,102,176,146,147,199,  7, 93,133, 41,  0,114,113,
 10,203,121,145,211,215,192,222,161,  3,233,152, 48,224,232, 61,215, 95,182, 78,
141,129,157,162, 20,168,190,120, 16,111,127,235,244,239,255, 26,150,186, 66,106,
 94, 13, 51,181, 37,103,152,106,133, 92,250, 12,255,235,137,255,211,106,179, 45,
238,  7, 17,  9,201,223, 41,170, 53,158, 48, 96,181,124,130, 16,198, 21,234,  6,
137, 93,200, 96,116,  8, 18,208,179, 96, 63,165,171,101,238,170,248,138, 54,198,
 19,190,  5,114,209, 50,191, 39, 90, 27, 99,222,206,251,126,247, 42,223,149,237,
126,223, 84,113, 96, 38,181, 33,126,115, 70,212, 66,142, 95, 83,225, 70, 18,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseGus_M_phase1.c:
uint8_t GB_JITpackage_15 [838] = {
 40,181, 47,253, 96,214,  9,229, 25,  0,134,100,113, 32,208, 28,231, 12, 34,100,
239,121,205, 27,203,134,128,226, 28, 13, 53, 26, 13,112,206,188, 47,217,127,129,
 47, 30,200, 82,243,  2,107,  0, 99,  0,103,  0, 29, 90, 78,129, 84,  1, 25, 84,
 13, 59, 27,119,232, 56,179, 86, 54,116,146,  4,255, 45, 20,  8, 69,193,145, 64,
 40,238,133,221, 63,108, 97,181,114,  3,248, 25, 43,151, 46, 59,250, 39,  2, 57,
 19,150, 89,207,203,195, 20,117,182, 47, 17,215, 57, 43,219,216,191, 91, 98, 88,
205,127,104,201, 50,229,154,225, 63, 18,141, 43,203,164, 29,138, 95,151,198,103,
 45, 67,186,152,153,178,138,233, 68,  6,210,201,229,135,  3, 87, 56, 28,  2,  4,
 66, 37, 35,144,103,124, 90,113,188,228,227,248, 76, 25,141,124,109,151,122,130,
112,187,241,115,207,158,203,171,186,245, 95, 66, 34, 57,203,187,178,199,246,148,
127,  8,137,215,250,108,215,249,227,191,229, 12, 98,249,159,165,248,241,172,174,
 71,142, 50, 24, 12,166,139,152,127, 51,146,172, 54,219,155,249,127,174,198, 33,
 12,138, 66,179,194,106,130,127,156,109, 69,155,111,171, 50,133,198, 55, 88,113,
  9,193, 99, 52,186, 91, 46, 30, 48, 68, 93,157, 14,171,137,199,179,140, 53, 43,
191,204,215, 62,219,159,157,115, 13,113, 71,180,170,219,144,247,235,218,124,203,
240, 30,130,118, 91,169,135, 44,160, 18,198,102,187, 69, 20,  2, 65, 34, 42,202,
208, 73,119,209,  6,102,217,116,245,109, 86,236,141,107,120,178,218,176, 77,124,
 14,114,196,199,209,116,147,242,232, 38,207,189, 58,228, 45, 58,161, 35,203,197,
 11, 28,119,195,109,207,124,251,118, 95,158,167,106, 50,229,122,181, 40,  8,184,
 64,112, 15,  4,187,174, 11,125, 60,183, 91,172, 47,129,128, 87,149, 20, 33,135,
193, 19,157,127,253, 58,243,224,181,211, 53,155, 76, 95, 43,182,106,172, 35, 56,
 82,112, 20,203,143,144,147, 44, 21, 79,134,182,198,215,110,228, 19,243,144,135,
148, 95,123,159,239,171, 12,191,127,249,172, 25,211,142,217,133, 44,163, 17, 72,
 17, 61,113,132,248, 28,128,159,168,145,169, 66,104,134,  2, 17,145, 36, 41, 40,
164, 49, 64,132,144,161,171,234,  1, 34,145, 72,131, 82, 84,133,136, 49,  2,105,
  2,  9,103, 38,144,236, 68, 37,137,  7,144, 12, 32,129, 60,250,226, 21,152, 70,
 20,247,254,248,195, 19, 58, 24, 12,143, 99,120, 76, 24,226,199,243,196,207, 84,
220,128,148,251, 75,189, 59,118,241,127, 20,250,202, 85,162, 30, 88,135, 86, 39,
 60, 85,129,  4, 47,139,117,137,148,227,194,173,141,181,172,156, 83, 24,202,225,
227,195,226,139, 57,105, 77, 34,199,174, 18,184,192,156,  0,153, 16,153,145, 35,
227, 56, 88, 57, 37,180,137,160,198, 57,  9,189,150, 29,245,216,  6,245,  3,192,
122,255,123,180,120, 77,240,206, 14,147,130,146,178, 30,206, 24,201, 54, 96,  9,
217, 11,157,  6,234,195,224,146,196, 39,232,246,103, 93,170,140, 57,245,135, 52,
238, 59, 89,169,  1,235,114,111, 49,182,234,198,122, 71, 94,143,211,186,242,114,
123,189,186,148, 73, 86, 62,240,186, 65,184, 76,149,166,124,  2,136,107,140,  1,
231, 92,246,213,170,  2,121, 53,  3,206,193, 88,216,101, 27,218,102, 53,164, 53,
152,173,102,  1,202,214,160,201, 42,147, 97, 61,210,193,104,204,158,138,186,199,
169,  2, 51, 31,232,226, 23,  4, 30, 21, 82,162,150,240,152, 53, 38,171,207,248,
 76,239,187,248,  3,197, 69,228,195,  8,209,159, 53,116,234,150, 56, 40,194,148,
131,192, 14, 52,231, 95, 31,218,193,251,  5,208, 61,254,240,186,109, 79,245,177,
161,217, 76,157,135,140,234,170, 21,205,174, 22,239,128, 14,110,158, 65,243,254,
193,196,150,173,205, 57, 53,124,243, 33, 28,254, 14, 48, 41,221,129, 38,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseGus_M_phase5.c:
uint8_t GB_JITpackage_16 [1094] = {
 40,181, 47,253, 96,105, 20,229, 33,  0,182,169,130, 33,208, 90, 61, 64,  7,193,
227,154,212,178,180,100,130, 86,  6,  0,  2, 59,124, 14, 78, 66,137,197,162, 54,
 75, 61, 12, 90,112,240,  2,124,  0,115,  0,122,  0,133,193, 65,112, 75,209,158,
223, 55,246,197, 36,238,250,142, 20,193,229,250,138,248, 34,  8, 69, 54,131,241,
174,246,229,151,243,188,151, 38,204,121, 20,234,123, 14,113, 40, 28,  4, 12, 67,
225,240,154,152, 61,199,241,202, 70,126,240,189,171,236,102, 10,123,158,235,124,
 23, 72,121,218, 45,105,156,157,219,177,170, 67,159,211, 38, 95,217,254,207, 65,
  2,159,247,192, 56,192,111, 40, 46,183,229, 89, 49,149,171, 36,151,111,107,138,
 21,225, 58, 91,150, 87, 72,235,171, 16,201, 19,  8, 84, 64, 32,  4,221, 95,149,
198, 93,155,226,107,133,247,178, 39,  5, 79,122,233,147,216, 61, 41,103,209,159,
 32,120, 62,133,105,219,102, 81,142,238, 59,223,152,204,239,125,206,223,107, 98,
209, 53,206, 74,111,216,244,189,252,251,117,125, 55,245,168,237,115,  6,207, 27,
140,119,155,218,132,159,227, 47,120,218,137,195, 25,230, 27,255,143,  7,164,249,
191, 77,242,243,182,169,119, 60,105, 48, 24,136,158,156, 60,231, 66,161, 44,238,
 88, 83,184,204,109,255,255,255,167, 20, 70,  3,144,243,187,231,239,218,119, 69,
 31,129, 95, 24, 52,238,185,190, 43,230,204, 56,161,199,243,129, 29,122, 69,123,
242,188, 77,150,185,111,239, 86,228,244, 13,135,247, 54,141,187,215, 18,139,236,
 67, 73,230,227, 84, 12,134,146,120,212, 55, 22,248,222,  3,107,216,201,132,145,
 26,122, 62, 27,140,  6,124, 17,239,171,111,217,199,203, 85, 28,151, 30,250,176,
 17,212,244, 69,173, 68,144,194,  9, 51,228, 29, 53,137,  1,180,145, 65,190, 95,
211,169, 66,170, 39,148,152,227,155,253, 77, 26,151,  1,148,198, 34, 25,142,166,
163, 79,188,109,224, 41,122, 12, 62,165,251,150,221,118,217,229, 18, 78, 60, 31,
 85,149,226,182,151, 87,215,182, 26,151,234, 54,201,154,205,250,101, 28, 77,102,
251, 34,155,207,166, 25, 46, 71,221, 88,111, 77,186,215,250,127,232,161,112, 64,
 53, 52,  9,100,108,223,251,158,241,229,131,225,182, 35,  4, 62,240,216, 11,192,
188,206,123,178,124,216,232, 43, 22,202,213,152,188, 35,192, 43,101,155,191, 92,
191, 76,154,159,187, 15,133,145, 12,165,158,242,107,199,  7,128,236,168,161, 49,
 67, 37, 51,146,130, 20, 20, 21, 50, 28, 48,132, 16, 82,140,170,234, 18, 81,168,
 67, 57, 12,225,  4,132, 32,163,136, 17, 16,  1, 97, 36,146, 64, 36, 70, 68, 98,
 90,139,  1, 33,232,190, 97,222,119,142,129, 28, 23,223,119, 20,205,159,247, 30,
180, 95,178,209,222,167,  9, 66,202,186,161,155,162, 58,210,151, 20,232,219, 13,
 82, 33, 12, 91,120, 14, 14,193, 10,254,205, 72, 73,221, 73,213,106,169,210,221,
 51,186,225,176, 42,157,207,133, 78,231, 46, 65, 82,178,204,108, 73,155,249,194,
128,106, 20, 95,149, 34,  0,167,177, 23,187, 30, 16,250, 28, 36, 38,253, 47,130,
172, 45,150,101, 11,230,208,242, 44, 86,108,236,204,142,200,250, 38,133,103,249,
200, 78,225, 96,147, 51,130,137, 58,152,114, 58, 45,238, 35,168,246,185, 64, 41,
242, 67, 37,108,  8,140, 32,242,168,160,112, 38, 68,205, 93,156,136,246,214,  0,
158,104,184,  1,186,150, 34, 49,212,147,213, 74, 81,191,236,145, 80,194,238, 49,
150, 45,188,239, 72,166, 83,201,  9,162,252,212,167, 18, 19, 87, 72, 21,225,137,
137,168,116, 35,180, 80,253, 25,157,238,190,252, 53, 52, 26,226,253, 57,238, 37,
 66, 79,232,244,209,136,163,131,235,248, 33,212,185, 76,240,148,131,103,226,150,
254, 10,152,170, 28, 91,144, 10,122, 68, 36,249,221, 98, 81,230,125,110,206,235,
208, 50,254,211, 24, 27,169, 66,224,183,127,169,198,191, 87, 68,132, 12,194,128,
134, 37, 73,217,216,254, 98,187, 43,228, 23, 35,148,166,122, 75,187,195, 85, 40,
140,102, 89,130,216, 34, 62,226, 25, 10,160, 45, 17,247,170,226,164,226,  3, 77,
 14, 32, 43,194,175, 36, 20, 84,151,157,237, 48, 63, 34,  0,163, 67,241,153,189,
 54, 62,138, 54,102,  2,232, 83,205, 92,150, 67, 73,199, 46, 93,251, 40,210,120,
191,108,217,156,207,123,191,187,203,  8,105, 40,168,147,181, 89,219, 93, 87,100,
 87,165,195,133,  5,243, 50,209,136, 76, 17,241, 76,195, 13,244,129,108, 92,245,
 32,248,  5,253, 93,209,237,152, 28,214,116,207, 13,241,129, 63,185,149,217, 26,
 36,194, 21, 57,125,132, 74,144,237, 16, 74,203, 54,184, 57, 67, 38,127, 98,144,
242, 45,116,131,241,184, 42,138,187,130, 99,  0, 38,242,255,113,187,115,111, 29,
 74,121,  1,237, 56,138, 83,  9,212,160,224, 19,206, 61,136,240,251,  7,240,192,
219,239,102,137,210, 26, 74,196,228, 26,205, 15,154,243, 15,166,110,181,183,157,
 44, 58,231,147,156,236, 34, 68,129, 16, 87,154,  4, 78,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseGus_noM_phase1.c:
uint8_t GB_JITpackage_17 [764] = {
 40,181, 47,253, 96, 78,  8,149, 23,  0,182, 99,107, 32,224, 90,117,160,231,236,
231,115,156,176, 66,181,246,104,133,192,205,131,  4,183, 68, 37,213,119,164, 94,
  3, 51, 12,193,188, 23,103,  0, 96,  0, 99,  0, 18, 77, 97,196,168,147, 45,111,
110,111,137,212,155,143, 99,247, 77,145, 56, 36,  8, 13,196, 33,113, 13,204,190,
217, 70, 81,201, 11,221, 87,165, 91,146,221,249,198,233, 46, 94,201,164, 39,197,
 97,114,248,246,137,131,137,150,146, 47,235,183, 90, 90, 20,189, 63,216, 99, 41,
 34, 87,246, 14,  4, 91, 90, 50, 63, 76, 89, 63,123,162,176, 61,105,  9,126,138,
149,169,162,246,243, 84,221,231, 81,110, 48, 96,  4,131, 33,191, 76, 58,119,211,
231,125,157,  9,229,191, 54, 24,208,241,193,253,218,179, 67,241,144,139,226,239,
183, 96,220,218,217,127,172,133,213,147,237,107,166,173,179,200, 43,151, 82,229,
253,101,123,219, 15,245,207, 50,188,120, 82,242,143,135, 10,133,  2,232, 97,229,
219,106, 28,105,223,174, 22,236, 80, 72, 16,184,  4, 82,179,187,227,228, 14,251,
 86, 30, 89,  8,108, 43,131,125, 33,120,  2,218, 35, 89,229, 68,170,137,157,248,
117,226, 42, 44, 47, 94,197,163,218,220, 61, 19, 73,198,242,153, 68, 68,247,226,
206,167,218,183,150,224,234,154, 36,223,118,132,251, 67,162,  8,186, 25, 57,246,
214,225, 16,200, 89,213, 36,210,190,153,104, 62, 21,151,235, 19,206,166,211,112,
 62,142,229,243,178,135, 29,176,220,231,173,124,174,229,203,147, 89,191,101, 75,
193,143,180, 65, 54,237, 49, 71,230,  5, 24,246,194, 44, 55,163,168,165,131, 65,
101,182,183,148,123,138,107,127,227,211,121,181,240, 16, 64,183,216, 15,238,247,
164,215,126,157,217,153, 20,172, 60,162,192, 63,  4,130,143, 42,127,143,123,230,
185, 31, 14,106,131, 65,118,200,195, 95,203,182,242,232,150,201, 18,100,209,195,
254,106, 60, 41,159, 84,251,210,218,228,201,247, 91,237, 11,134, 61,170,172,189,
131, 60,128,135,168,129,173, 83, 68,164, 68, 70, 10, 11, 74, 10, 25, 14, 48,134,
144, 82, 85,212,  3,194,105,154, 36, 33,158,114,  2, 34, 48, 88, 64, 51, 50,202,
191,138,117, 12,148,  4,  2,230, 31,202,172,121, 77, 19, 56, 50,123, 80, 65,218,
 14,227,159,117, 23,113,170, 29,  2, 25,232,171,176,225,182,  5, 24, 50,  1,  6,
 66,243,113,232,166,186,197,147,120, 56, 37,128,124,  1,215,222,121,102,203, 92,
 48,163,102,187,173, 56, 43,213, 93,230, 56, 53,235, 17, 23,102, 66,208, 26, 13,
236,  2,124,128, 52,225, 33,155, 37,196, 63, 37, 38, 53,108,131,136, 84,235,180,
200,179,118,232, 23,184,213,168,138,169,243,136,221,165,  4,233,136, 65,250,168,
 36, 28,161,160,195,134,  5, 29,195,114, 61, 20,216, 36,185,244,204,211,245,101,
 21,219, 15,  8,254,200, 10,170,229, 36, 19,159,145,176,251, 84,133, 88, 43,178,
 35,106, 93,235,225,  1, 17,  5,204,171,163, 72, 50,148,158,  4, 15, 26,252,242,
 85,160,226,221, 21,235,169,254,206,251,169,227,220,197, 38,196,211,223,132, 46,
 87,236,190,158,171, 46, 21,  5,145,168,114,133,143, 24, 82,219,190,232,146, 30,
 52,118, 99, 42,169,149,130, 64,175,249,255,150,225, 31,  8, 55,224, 61,175,194,
182,149,145,104, 21, 33,166,197,185,117, 22,215,138, 34, 43, 97, 59,237,108, 46,
238,108,106,211, 28,255, 96, 82,212, 45,246, 25, 16,184,103,240,176,126, 33, 76,
168, 58,192, 24,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseGus_noM_phase5.c:
uint8_t GB_JITpackage_18 [930] = {
 40,181, 47,253, 96,118, 17,197, 28,  0,102,231,120, 32,208, 92, 23,  3, 12, 34,
210, 48,115, 79,189,251,237,101,102, 38,131,210,156,195, 50,233, 64, 81,118, 90,
228,106,  6,188,120,130,115,  0,108,  0,110,  0,120,231, 59,106, 14, 87,231, 43,
226,205,129,116,241, 32,198,235, 74,175,190,159,235, 93,166,240,231,171,149,119,
 67,131,161, 96, 28, 34, 11,  5,227,156, 56,184, 65, 99,151,189, 28,225, 61, 86,
238,147,133, 67, 55,128,188,141,165, 68,109,138,145,160,160,187,113, 11,180,153,
218,178,126,230, 27,242,169, 93,118,255, 34, 78, 47,171,149, 47,121, 92,109, 75,
180,114,206, 92,117, 11,115,117,106, 79,177, 54, 98, 40,204,234,106,129,121,213,
130,121, 34,177, 29, 18,137,175, 95,109,197,175, 44, 22, 47,170,187,171,170,165,
134, 64, 76,108,163,172,123,142, 63,247,205,244,124,253,204,255,187,223, 86,198,
 59,159,226, 57,197, 41,131,147,135,159, 22,  5, 89, 86,137,221, 79,166,105, 58,
250,125,168,229, 99,182,231, 84,  6,201,224,251,190,169,127,219,102, 92,161, 96,
 87,147,238, 91,167,152, 52, 79,185,105,126, 87,  7,100,103, 60,120,122,146,255,
191,205, 54,  5,130,113,184,165,104, 81,239,146,244, 98, 50,132, 67, 22, 87,175,
 46, 24,118, 42, 72, 83, 75, 97, 88, 67, 48, 51,170,177,116,231,251,187, 74,101,
172,111,175,109,105,249, 77, 77,206,228,184,244,162,177,242, 52,218,117,213,184,
122,131, 11,  4, 95,160, 82,203, 34,241,152,111,237, 63,193, 59,229,171, 32, 40,
  4, 47, 21, 12,137, 60,156,206,135,200, 55,245, 91,238,241,234,214,247,153, 53,
 46, 67,255,246,217,199,229,187,114,137,159,230,  3,134,228, 29, 51,137,  3,227,
 53,254,247,124,203,219, 86,251, 37,252,116, 64,221,113,161,240,161,166,227,239,
220, 25, 63,189,229,182,131,205,198,171, 31, 48, 19,242, 10,222,197, 35, 42,212,
 54, 44,211,157,219, 63, 24,210,124, 70,149,148,233, 78, 56,254,140,  2,248,  9,
155, 78,102,  8,148,239,141,136,131,177,137,189, 73,247,157,218,173, 43,229, 30,
 74, 65,105,124, 20,155,166, 53,171,119,242,188,121,216, 29, 51, 38,129,151,208,
156, 61, 91,113,204,183, 78,110, 65,223,253,177,244,186, 42,  1,128,178,168,129,
169, 82, 12,201,200, 40, 72, 65,146,210,112, 64,132,144,161,170, 42, 15, 18,121,
 36, 78, 50, 28,130, 51, 74, 96,  5, 68,128,200,  9,136,226, 36,146, 60, 18,170,
 26,  3, 25, 44, 38,217, 27,147,118,174,134,214,178, 14, 98, 36, 47,253,198, 68,
 98, 50, 55, 37,216,101,181, 69,166,213, 19,176, 66,177, 55, 37, 96, 82, 99,146,
171, 94,109, 94,  0, 22,163, 80,162,194, 41, 77, 89,220,  3,225,133, 58,217,201,
 62, 54,129,177,160, 84, 81, 48, 65, 99,185,247, 84,188,  1,103, 40,166,132,157,
182,240,145,  9,124, 83,105, 89, 83, 48,131,153,202,  8,143,252,158,110, 76, 42,
 77,224, 83,176, 47, 13, 57, 16, 58,173,165,206, 12, 75,240,128, 67,193, 34, 23,
 10,237,209, 56, 64,168, 55,228,164,118, 83, 70, 33, 48,143, 14,130,180, 16, 72,
253, 97,230,228,146,235, 70,162, 91,115,245, 56, 43, 90,187, 92,118,239,227, 72,
194,161, 40,193, 40, 81,108,  0, 88,196,151,212, 18,129,235, 14, 33, 74,117, 78,
155,186,187,162,182, 68,  9,117, 18, 29, 67, 54,154, 81, 37, 48, 84, 29, 38,109,
149,181, 58, 37,182,119,252,106,185,205, 30,214, 40,148,216,115, 82,244, 27,255,
150, 36,231,171, 48,250, 13,198,248,145,198,  4,246,154,108,162,211,131,251,232,
163, 78,110,210,232, 66, 84,168,226,118, 43,183, 53, 38,210,241,165, 78,255, 31,
116, 10,  3,  1, 40, 92, 95,148, 56, 55, 45, 90,229,158,169, 26,244, 73,122, 10,
 85,207, 29,141,189,131,197,222,182,102,176, 64, 16,100,179, 30, 24, 11,145, 55,
139, 61,157,116, 74,123,144, 90,180,252, 99,244, 91,220, 18,134,171,160,208,141,
 43, 15,232, 19,136,157, 59, 41, 96, 51, 42,252,230, 57, 93,120, 81, 77, 69,126,
 28,  2,199,144,  5, 24, 85, 73,251, 90,148,220,171, 20,151,202,100,  1,216,201,
 26, 21,245, 72,184, 67, 36,252,131,230,247, 15, 38,173,222,186,158, 59,129,119,
126,139,239, 12,  1,175,106,  5,136,  1,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseGus_notM_phase1.c:
uint8_t GB_JITpackage_19 [789] = {
 40,181, 47,253, 96,149,  8, 93, 24,  0,  6,228,109, 34,208,152,205,  1,192,153,
 59,213,232, 77,168,100,135, 83,136, 96,106,211,224, 67, 42, 72, 24,160, 62,212,
252,  5,190,120,144,165,230,  5,103,  0, 96,  0, 99,  0,144, 75,246,105,210,217,
184, 49,199,121,  4, 85,204,203,146, 59,134, 56,104,  7,194,194,160, 29, 46,  8,
175, 99,184,146, 40,228, 25,247,211,152,175,168,102,142,125, 92,165, 27, 77,122,
 74, 24,230,215,185,142, 62,203,  3,124,204,181,116,204, 94, 76,162,249, 15,107,
121, 61,162, 19, 62,195,208,152,142, 38,232,229,107, 65, 60,146, 52, 62,233, 13,
 65,196,201, 52, 81, 12,118, 38, 14,236, 36, 47, 20, 44, 66,161, 16,138,108,235,
101,187, 61,199,116,252, 88,106, 24,124,250,188, 22, 84, 47, 62,102,112, 56, 50,
219,141,159,251,244,124,237,113,253,227,152,230, 16,132,176,122,121,103,252,175,
 86, 38,222,255,188,226,201,147,138,222,120, 39,203, 50,206,197,201,177, 83, 89,
210,154,171,165,188, 80,248,127, 43,101,105,217,129,208, 99, 72, 77,238,140,179,
171, 88,179,237, 15,133,208,216,118, 88, 43,  4, 77, 61,230,223,108,235,115,253,
217, 57,211, 16,123, 98,253,216,222,222, 35, 91,179,189,225,  5, 26,202,134, 60,
130, 99, 34,151,205, 68,165,122,228,195,112,151, 15,252, 40, 96,119, 93,172,129,
 83, 54, 69,109,123, 44,189, 49, 13, 95,210, 26,182,137,111,109,215, 58, 36,201,
185,249, 96, 92,221,115,131,182,135,192, 14,204, 68, 36,255,  5,131,  1, 45, 27,
219, 51, 62,171, 72,222,113,146,124,  6, 19,  1,150,181,194, 93, 87,167, 51,219,
126,169,237,233, 96,128, 65,180, 20,183,167, 52,239, 88,143,206, 92, 47,174,222,
212, 31, 91,201,202, 53,182,115, 38,103,146, 28,  9,114,164,120, 79,110,215, 68,
 32, 22, 10, 24, 34,109,227,157,249,237,225,227,182, 30,101,237,179, 29,221,112,
 19,143, 29,203, 39,205, 24,244,204, 11, 19,201,100,184,199,183,221,112, 77,124,
198,135, 59,  6, 94,135,212,196,228,121, 75,  1,128,144,168,161, 37, 99,102,130,
 18,145,130, 20,164,160,146, 14, 48,132, 16,132,172,140,  7,  2,209, 40,132,114,
 88,196,140, 17, 12, 54,129,  4,  9, 10, 74,202,127, 61,128,208,208, 68, 39, 91,
137, 23, 60,166, 50,236, 18,144,169,202, 20, 25, 37,236, 35,100,229,202,238,  5,
249,  6,134, 21,150,  5,191,127, 16,153,131,150,224,207, 40, 73,225, 13, 44,226,
 67, 38, 24,247,123,108,252,205,177,176,169,163, 65, 57, 30, 29,193,181,206,173,
 23,117, 84, 47,109,147, 81,210, 72,151,184,104,202, 66, 63,194,103,147,228,120,
 36,153,139,100,126, 38, 23, 94,179,127, 16,166, 72, 38,199,167,238, 34, 39,139,
248, 67,200,222, 24,  9, 65, 42, 52, 26, 99,  8,170,138,133, 19,230,123,226,117,
171, 80, 57,212,169,165,227, 81, 98,254,  8,156,132,242, 12, 55,254, 83,163,181,
178,100,228,190, 31,  7,164,246,174,160,168,218,126,217,221,104,145,150,163, 57,
 67,189, 98,146,  7, 85,169, 34, 24,139,255, 96, 67,128,175,230,207, 26,189,166,
179,169,120,107,160, 61,149,244,225, 72,141,154, 40,168,  2,121,100, 86, 99,229,
  3,240, 32,108,243, 64,145, 90, 80,196,243,170, 64,166,102,124, 65,151,187, 28,
185,147, 57,210,169, 17,154, 88,236,194,162,140,138,  8,196,220, 66,255,216,233,
195,107, 54,111,227,117,223, 22,186,190, 11,236,176,127,204,147,242,134, 28,245,
  7, 21, 23, 30, 56,104,253,127,208,196,169, 96, 90,234,150,129, 46,  1,254,121,
 70, 46,123, 50, 48,169, 58,174, 19,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseGus_notM_phase5.c:
uint8_t GB_JITpackage_20 [979] = {
 40,181, 47,253, 96,232, 16, 77, 30,  0,166,230,119, 33,208,154,233, 64,  7,238,
 70,126,  9,199, 65, 35,252, 58,136, 18,211,129,143,110, 23,  0,144,205,173,250,
131, 43, 60,233, 32,126,  1,114,  0,104,  0,111,  0, 54,223, 46, 47,132,198,183,
 73,139, 33,128, 40,155, 66,217,169,181,113,115,142,243, 73,178,156,155, 76,221,
 55, 69,226,144, 32, 56, 16,135,196,  5,100,246, 13,219,212, 72,121,161, 59,235,
204,233,201,134,223, 58, 29,102,114,170,227, 90,121,168,157,206, 22,213,193,190,
221, 20,167,198,252,111,147, 65,199, 73, 64, 64,196,251,131,209,120, 60, 85, 17,
204,233, 21, 49,170,210,120, 29, 83, 82, 84,176,212,213,136,197,201,170, 19, 39,
149, 27, 12, 24,193, 96,  8,104,232,170,231,169,199, 92,  2, 77, 27, 77, 17,200,
 51, 94,173,137,158, 59,138, 62,139,139, 70,190, 54,251,154,154,183,123,244,242,
142,  8,173,236, 53,189, 36,155,226,111,  8,142, 43,220,110,252,220,172,231,244,
122,223, 14,156,160,180,217, 12,252,227,255,209, 53,114,145, 13,221,180, 60, 64,
192,177,253,233,125,230, 55,121,109,103, 67,241,152,255,255,199, 48, 23,118, 40,
 36,  8,125,146,163,218,253,177,182, 53,  3,106,198,249,194,176,243, 58, 88,147,
163,138,209, 53, 85,165,107,231, 60,146, 24, 59, 34,113, 78,  3, 65,211,150,183,
 95,131,238,156, 39,126,157,204, 71, 17,191,208,179,  1, 53,222, 73,187,246,109,
 82,217, 24,133,237, 25, 98,119,149,143,204, 19,220, 54,165, 72,239,194,249, 50,
102,151,215,180,129, 71, 54,121,110, 82, 73,156,136,225, 87, 73,203,167,249,164,
107, 79,200, 27,117,109,190, 41,121,193,225, 92,118,147,112, 81,235,150, 72,200,
 69,104, 24,246,162,100, 56,154,206, 85, 59,143,189,146, 86,211, 60, 53,116,235,
 97,107,159,121, 36,101, 24, 76,103,  9, 59,173,163,108, 60, 26,215,216,212,175,
252, 21,228,130,252,127,225,133,243, 17, 65,150, 65,198,120, 64, 60,126,112,206,
222,197,221, 60,109,214, 89,212,118, 17,200,185,119, 42, 55, 66, 71,180, 67,197,
 14, 53,211,163,144,131, 62, 74,230, 34,150,208,251,200, 39,234, 33,199,103,173,
157,194, 36,131, 55, 16,130,237, 91, 94, 69, 48,128,211,168,113,177, 98,106,134,
 36, 41, 40, 40,168, 20,134,  3, 64,132,144,169,170,162,  7,  2,113, 36,138,147,
 12,131, 20, 48, 99, 28, 18,140, 80, 80, 49,146, 87, 20,164,202,112,153,  5, 40,
203,128,114,252, 50, 65,  6, 91,194, 80,132,212,128, 82,125,169, 36,106,127,  7,
172, 71,116,234,141, 84,220,186,177,149,244,141,  7,183, 67,171,180,153,168, 28,
 65,138, 96, 41,183, 12,165, 43,133,188,209,123,179, 10,117, 21, 30, 80,222, 45,
148,168,246, 29, 37, 38, 36, 53,  9,136, 90,245,254,255,105,194,153,107,  2,209,
198, 30,114,169,164,  7,178,123,  4,122, 21,181,  3,197, 59,185, 35, 73,145, 20,
  6, 98,231,148, 93,234,103,229, 37, 19,144,160, 32, 24, 16, 74,128,196, 53,164,
109, 70,134,106,133, 54, 23, 90, 74,135, 80, 52, 34, 52,202, 87,213,239,161, 51,
206,  2, 91,199,100,139, 66,150,  1,155, 18,162,108,115, 44,207,113,180, 27,125,
 47,246, 60,164,157, 81,183,145,148, 85,241, 46,245,194,114,213,213,  4,  5,144,
 61, 71,  8, 41,249,212,233,255,189,177,124,  3, 69, 24, 18, 42, 98, 76,191, 12,
 28, 52,  4,159,117, 81, 47, 52, 26, 17, 30, 25, 65, 12,161,141,173,  6,251,126,
104,122, 43,120,231,246,194, 71, 41,100,119,161,193,185, 39,238,132, 95, 12,180,
129,182, 60, 93,194,100, 21,235,224, 16,234, 34,175,169,174,181,225,129,168,139,
223,148,249,  9, 36, 13, 12,  7,231, 19,176,244, 28, 67,182,  6,254,178,231,241,
103,  8, 86, 14, 76, 85,104, 97, 10,137, 81,103, 31,109,177,150, 78, 75, 95,113,
220,199,214, 48,192, 25, 99,120, 57, 15,235,211,209, 55,157,126,229, 39, 59,160,
132, 93,176,234,222,114,109,156,222, 21,119, 10, 89,171,221,230,216,  1, 95,197,
240, 47, 49,220, 15,252,170, 85,155, 69,230, 35, 61, 28,209, 18,160,109,196,208,
196,246,137, 98, 36, 54, 49,178,  4, 21,238,130, 63, 59,243,  6,157, 11,109,247,
140,160,106, 51, 96, 30,243,223,245,241,187,243,244, 37,  7,156, 34,123, 64,  1,
211, 19,234,232,222, 48,155,129, 77, 51, 40,166,149, 28, 29,209,160, 89,250,131,
137, 43,155, 77,168, 99,  7,213, 53,194,223, 20,  9,149,198,170,104, 32,  6,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseHash_M_phase1.c:
uint8_t GB_JITpackage_21 [973] = {
 40,181, 47,253, 96,248, 12, 29, 30,  0,214,106,129, 32,208, 92,117, 12, 66,236,
247, 27,111,159,131, 98,141,  5,189,134, 34,104,163, 71,153,181, 89, 13,186, 46,
163,212,195, 11,148, 18,124,  0,116,  0,121,  0,134, 38,195,138,126,135,164,109,
 71,155,111,139, 25, 67,227,219,161,229, 24, 72, 21,208, 65,108, 87,218,184, 67,
199,153, 84,217,208, 77,243,123,199, 88, 36, 22,134,135, 34,177, 56, 23,110,239,
176,117,213,202, 15,223, 99,100, 62, 89,118,244, 78,244,113, 38, 36, 90,211, 11,
  4, 21,117,182, 45, 17,160,115, 50,219,215, 59,241, 36,115,179, 78,254,161, 53,
207, 20, 43,134, 15, 81, 52,174, 36, 10,118, 64, 18, 87, 76,227,180,158, 33,200,
136,161,176,138,193,  9,236,  3, 39,151, 35, 16,  0,  3,  2, 17,215,110,169, 43,
 10,135,219,141,159, 59,246,124,222, 78,  1,249,199,119,246, 18,174,236, 32,219,
119,213,181,247,214, 16,191, 77, 75,190,142,211, 55,174,225,177, 37,243,104, 47,
118,122, 94,149, 61,229, 93, 66,194,173, 58,187,117,222,137,109,209, 86, 24,158,
183,117,200,  8, 56,140,227,197, 91,143, 50,221, 98, 46, 57,249,220,156,195,120,
254,233, 57,190, 76, 43,235,145,163, 14,135,131,233, 35,230, 93,204, 52,171,205,
246,102,142, 64,252, 63, 96,  6, 72, 28, 22,  1, 87, 60, 49, 62,227,197, 37,  5,
174,225,216,110,185,120,190, 16,200,234,116, 88, 81, 92,166,231,171,201,252, 51,
 95,251,108,159,118,206,157,209,138,183,189,119,235,218,124,207,240, 92, 66,118,
 87,169,135, 44,160, 18,134, 70,187, 69, 20,250, 64, 34, 80,148,  1, 39,219, 71,
 43,136,101,148,213,199,246,183,201,151, 89,109,216, 40,246,158,184,228,168,178,
 52, 29,165, 64,182,201,115,171,238,125,  5, 78,192,145,229, 82, 40, 84, 51,226,
 61,227,212,142,229, 37, 47,203,103,176,225,200,  1,  0, 64, 13,183, 77,243,237,
 55,153,  1, 99,115,156,216,102,138,213, 90,129, 95,224,131,193,185,239,219,182,
208,199,243, 81, 68, 53,239,133,194,237,198,199, 85, 85,205, 87,223, 99,219, 58,
199,219,119,221, 74, 51,231,121, 47,107,167,169,115,137,209, 59,130,112,237,237,
197, 19, 56,206,110, 63, 93,179,201,244,181, 99,139,101, 45,193,175, 28,207,151,
222, 73,150,138, 39,  3,174,202,207,196,219, 96,228, 19,244,222, 67,202,175,189,
236,222,231,219, 58, 67,140,232,195,  4,128,191,168,241, 25, 51, 36, 51,129,200,
 72, 10, 74, 82, 72,  7, 80,134,136, 80, 21,149,  7,194,248, 32,  4, 18,141, 69,
144,128, 10,148,  9, 38,144, 72, 40,144, 64, 36,144,236,  4,201, 14,144, 46, 64,
150,117, 96,137,228,232,  1, 81,232, 40, 16, 13,  0, 88,164, 71,233,140, 92, 36,
 86, 18,181,188,243,173, 27,  9, 84, 40,110, 69,189,171,114,187,134,154, 85,  8,
108,162,194,128,201,161,176, 91, 98,195, 10,119,183,161,237,214,  9, 71, 64,134,
161, 24,228, 45,  2, 83, 66,232, 20,116,135,234, 30, 16,187, 27, 36,  3,109, 46,
195, 28,243,200,203, 11,153,143,201,115,249, 70,120,227,133,133, 70, 49,  7, 97,
134,156,  1,151,213,  9, 25,106,134, 49,128,116, 47, 33, 95,197,135,219,239, 37,
140, 78,247, 30,135, 93,177,194,147, 89,216, 96,217,208,138, 75, 54,221, 21,132,
251, 74, 79,134,241,230,140,190, 81,230,  6, 54,153,171,162,221,185,111, 30,122,
173,222,201,166, 56,129,181,220, 30,122,251,112, 77,100, 72, 28,200,157,180,152,
 83,128, 65, 53,197,121, 93,  3, 33,139,  2,159, 32,155, 18, 26,  9,159,195, 82,
215, 39, 12,241, 92, 42,211,137,233,128,127,108, 40,219,144,137, 98,159, 62, 14,
229, 95,139, 59,149, 13, 97,151,  9,133, 22, 14,169,197,143, 53, 12,156,162,  2,
 93, 69,200,131, 32,104,164,132,  5,128,119, 67,218, 20,243,133,117,214,184,228,
 97,118,214,177, 53,252, 83,205, 62,172,145,190,164,193,248,178, 48,212, 99,112,
122, 60,241,115,243,168,228, 18,199,198,  4, 90,108, 11,157, 22, 56, 82,188,  7,
125,210,192, 91, 88,125, 63, 33, 54,202, 82,156,  3,113,156,224,128,  2, 77,155,
185, 80, 34,244,253, 39, 55,124,111,194, 12,123,248,204, 11, 21, 52,145,100, 13,
 88,222,185,174,236,151, 18, 43, 17, 44,239,237,172,185,124,132,193,239,149, 65,
225,123,222, 34,244,129,114,140, 17,141,245, 31, 52,125, 84, 48,197,138, 39, 31,
 79,139,123,220, 35,204, 48, 16, 14, 74,209,  5, 15,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseHash_M_phase5.c:
uint8_t GB_JITpackage_22 [957] = {
 40,181, 47,253, 96, 51, 13,157, 29,  0,166,103,122, 32,208, 30, 23,  3,  4,229,
206,118,228,234,138,161,151,139, 54, 95, 34, 66,117, 69,176,  0, 60,199, 98, 59,
200,213,112,192, 61, 21,117,  0,107,  0,114,  0,228,170,154,225, 31,167,189,227,
221,217,138, 25,130,213,217,174, 46,135, 96,170,128, 10,162,141,157, 86,219,208,
245, 38, 89, 55,116,151, 43,252,167, 72, 28, 18,  4,  7,226,144,184,183,234,254,
233, 27,171,149, 23,194,211,200, 93,190,238,232,159, 40,228, 76, 72,179,158,151,
135, 41,178,251,194, 68, 28,227,255,254,111, 34,  8, 35,146, 14,132,242,  7,195,
234, 74,154,180, 67, 73, 93, 49, 86,159,181, 92, 81,  5,205,156, 85, 77, 39,179,
144, 78, 46, 55, 24, 56,130,193, 16,223,250,188, 35,126,228, 24,127,211, 69, 99,
231,219,169,142, 24,100,107,245,183,165,125,151,249, 67, 68,190,251, 72,153, 89,
151,242,239, 16,241, 90,223,237, 58,127,140,133,113, 76,157,126, 49,143,156,252,
182,156,194, 88,254,103, 57, 30,159,245,117,200, 83,133, 66,225,244,143,230,114,
213,187,111,206,140,152,151, 59,223,139,246,180,123,215,149,190,152,171,169,175,
239, 59, 31,214,117,159,252,255,115,156,141, 59, 20, 18,  4, 27,183,251,109,168,
107, 54, 25,155,239,104, 69, 64, 68,133, 43, 14, 49, 13,241, 88, 30,127,102,197,
124,193,155, 44, 21, 79,134,182,240,109, 89,204,150, 66, 62, 49, 39, 19,140, 40,
196,128, 71, 36, 30, 25,228,251,192,183, 70,128,247, 22,141,238,150,139, 39, 12,
209, 71,215,249,182,172, 22,237,208,145,229, 82,138, 47,247, 89,249,146,224, 45,
 44,223,157,203,213,189, 67,247,145,240, 84, 45,183, 86,224, 83, 24,159,110, 82,
 40, 38,103,243,  6,131,234,130,128,  1, 28,119,235,222,162, 20, 90,177,132, 44,
152, 81,120,161, 21, 79,232,195,141, 86,204, 48,240, 30,185, 58,171,213,148,118,
214,124, 85,244, 44, 71,138, 75, 26,118,161,143, 39,164,136,194, 10,136,100,119,
 21, 77,216, 65,171, 93,246,118,  7,  3,138,121,250,165,236, 25,  6,188,183,255,
117,183,140, 50,161, 18, 53, 33,100, 54, 95,223,223,127, 22,118,110,  1,190,245,
145,111,124, 57,164,142,  7, 30, 87,123,170,238,129, 55,  8,158,239,239,197, 11,
 60, 47,128,201,168,177,165, 67, 37, 50, 34, 10,146,146, 36,133,225, 80,132,200,
208, 25,231,  1,194,232, 60,  2,178, 52,  1, 34,136,  8, 16, 17, 40, 66,  4, 39,
 16,161, 80,  2,145, 80,196, 82, 29,217,184,192,134,121,115,228, 44,151,255, 17,
118, 70,  9,135,158,206, 27, 42,221,153,102,231,146,118,143,140,230,188, 60, 18,
 44, 73,253, 15, 38,116,216,148,137, 20,166,117,104,  1,240,187,250, 69,106,186,
 95, 47, 66,130,170,  4,181,154, 39,121,172, 14, 87,133,125,174, 37,179,179, 34,
131,118,159,176, 59,135,172, 27,156,157, 55,177,240,106,169,120, 65,227,  5,247,
232,121,159, 52,215,184, 18,244,171,122, 85,123, 64,161,235,178, 95,216,117,186,
241,210, 44,192,  3,196,137, 46,195, 52,217,184,106,109,178,207,188,215,169,185,
244, 58, 93,170,185,111, 47,209,141,158, 35,170,242,144, 38,166,194,141, 35,235,
121,136, 37, 35,185,142,201,104,180,188,141, 28,231,215, 58,132,162,214,147,255,
198,171, 57, 93, 60, 22,194,183, 25,135,121,142,  4,209,210,246,230,254,139, 53,
205,169,189, 12, 50, 56,219, 69, 83,197, 53, 75, 96, 65,147,  7, 12, 80, 68, 77,
166,148,167,136,184,  2,188,103,230,140,186, 67,140, 53, 84,119, 56, 90,200,  6,
181,145, 17, 24, 15, 77,216,135,140,182, 61,116,253,141, 55, 76,219,211, 86, 27,
143, 79, 68,248,121,204, 48,151,  5,101,228,192,132,117, 94,160,138,234,167,232,
 39,252,178, 25,196,242,100, 16,152,177,215, 59,115,185, 84, 36,234,244,184, 76,
172, 79,162, 93,201,219,164,168,242,249,237, 82,118,187,214,164,113, 36,168, 79,
 64,253,171,194, 65,172,252,123, 59, 49,171, 28, 14,160,192,137, 15,238,237,140,
155, 28,108, 74,234,172, 71, 27, 76,139,168,226, 98,239,227, 39,156,169, 80, 21,
145,155,114,221, 68,255,214,  3,163,142,157, 50, 62,183,225,249,224,255,192,251,
 64,100, 22,135,250,203, 24,132,130, 40,186,151,156,180,125,208,148,254, 96, 26,
 85, 70, 52, 20,211, 51,195,198,106,120,246,133,248, 83,234, 40, 78,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseHash_notM_phase1.c:
uint8_t GB_JITpackage_23 [829] = {
 40,181, 47,253, 96, 94,  9,157, 25,  0, 70,230,114, 32,224, 90,117,160,231,236,
231, 27,109,180,176,116,159, 33,  3, 19,181,169, 24,191, 37, 75, 83, 30, 52, 94,
  3, 51, 12,193,188, 23,110,  0,102,  0,104,  0, 76,251, 66,240, 72, 52,219,199,
168,146, 45,111,110,111, 56,234,205, 75,165,238, 90,  2, 97, 64, 16, 24,  7,  3,
226, 25, 21, 92,179,141,154,146,111,221, 87,225, 29, 77,221,185,198,233, 46,144,
144,156, 37,165, 65,114,248,246,137,131, 97,  0, 15,111,167,174,125, 99,120,217,
244,240,167, 93, 26, 69,166,149,125,227,192,118,134,164,135,185, 99,245, 66, 59,
 43,108,203, 57, 82, 47,177, 34, 85,211,122, 16, 85,231, 65, 40, 47, 20, 48, 66,
161, 16,162, 31,  6, 31,151, 99, 29,245,118,104,252,224,181,254,163, 50,219, 95,
 94,253,142,245, 17,205,240,200, 72, 90, 11, 48,215, 62,110,242, 68,233, 88, 79,
111,128,216,  6,130,255,234,124,  8,244,174,252,241,240,151, 47, 27, 56,254,229,
  8, 94, 44,167,233,142,135,182,109,  3, 29,172, 92, 91,149, 74,179,111, 87,203,
 11,133,255,199, 90,152, 97, 67, 16, 56,164,147,236,222, 40,185,193,190,149, 63,
 11,129,109, 13,247,227,173,253,219, 47,249,222, 73, 45,  6,236,175, 50,119, 62,
213,190,117,164,207, 12,172, 74, 18,125, 51,209,124, 42, 46,215, 39,156, 77,167,
225,120, 28,139,  7, 17, 28,236,192,234,146, 38,190,237, 87, 14, 83,103, 59,233,
 75,179, 41,147,246, 24,119,195, 31, 15,137, 34,232,100,164, 33,128,252,242,136,
 59,201,131,120,157,  9, 37, 27, 12,102,201,193,253,218,178, 65,241,143,139,226,
175,167, 88,220,218,130,202, 28, 24,246,178,220,175,236, 37, 78, 46, 69,171,242,
 86,254,188,109,238,131,  1,247,110,238,113,236,173, 20,215, 91,141, 79,229,205,
106,191, 15,102, 89, 11,186, 22,187,115,112,191,229,188,214,235,200,142, 20, 59,
209,235, 68,112,188,120, 21,127,181,185,123, 38,146,140,197, 35,137,117,210,175,
178,231, 56,132, 60,119, 26,121,237,250, 91, 79, 35,173,112,186, 10,247,  3,226,
143,  1,  6,195,116,146, 86, 44,199, 20,135,  1,128,156,168,193, 45, 82, 68, 50,
 65, 10,146,146,130, 74, 58, 64,132, 16, 50,104,236,226,240, 52,130,242,160, 52,
 70, 64,  4,154,  4, 19, 72, 48, 97, 40,255,227,  1,144, 18,152, 15, 56,157, 67,
  9,173,119,198, 36,156,179,101,109,128,192, 20,146, 38,147,145,139,168,170, 58,
160,148,196,134,136,220,244, 90,177, 39,165,129,145,122,155,101, 86,228, 64, 50,
 82,236, 73,121,158, 90, 41,164,104,219, 66,  4, 38,  9,225,112,253, 93,124,130,
 84, 86,104,162,146,116,144, 18,194,221, 61, 12,196, 52, 88,172,113,224,200,230,
179, 48,233,212,131,120,169, 94,200,182, 81,189,193,220,120, 19,126,111,182,204,
224,  4,106,110, 66,142,216,167,  0, 94,130, 58, 92,119,  1, 98,249, 10,157, 46,
137, 23,169,129,140,  9,  4, 27,189,142,212, 66,249,133,  5, 38,193,  8,  5,  8,
 65, 32, 94, 96, 67,112, 22, 81,249,221,232,157,236,255,132,210, 33, 81,199, 78,
 57, 59, 49,100,182, 65,198,205,207, 72,227,228, 51,185, 44,141, 59,230,216, 98,
105, 94,255, 88,231,123,100,107,208, 24,102, 63,147,173, 65,203, 10, 64,195,232,
210,147,105, 68,152,149,198, 35,184,138, 26, 62, 80,159, 30,236, 82,164, 21, 61,
232, 80,212,241,220, 58,163,134,210, 14, 38,182, 49,184, 83,184,178,134, 92, 47,
145, 22,  1,231,183, 69, 35,118,159, 38, 65, 87,194,165,208,134,252,219, 30, 54,
152, 81,182,197,230, 98, 88, 69,232,153,222,201,179,101,232,147,187, 10,143,244,
176,165, 38,184,136,163,145,255,131,102, 74,  5, 83,169,185, 29,233,106, 92, 84,
183,198,  7, 28, 98, 81,221, 57, 60,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseHash_notM_phase5.c:
uint8_t GB_JITpackage_24 [887] = {
 40,181, 47,253, 96,105, 10,109, 27,  0,230,163,111, 33,224, 90, 23,  3,148,119,
226,218, 99,201, 62, 75,187,166,136,204,116, 68,142, 45,253,186, 48,237, 26,132,
 57, 17, 99, 36,196,240, 11,106,  0, 97,  0,100,  0, 58,219,240, 90,  4, 32,137,
166, 19,109,234,180,218,110,174, 55, 73,186,155,155, 76,223,185,131,129, 96, 16,
 44, 10,  4,195,181, 48, 59,167,111,170, 74,222,125,103,145,187, 60,221,206, 57,
206,103,129,144,102, 61, 41, 12,147, 99,247, 69,113,176,196,207,253, 28, 36,240,
121,143, 11,192, 17, 57, 35, 97,117, 37, 77,122,217,101,166,164,174,160,213,103,
 45, 67,122, 96,153,171,170, 41,100,245, 81,  8,229,131,  1, 38, 24, 12,  2,249,
 17,142,224,105, 37,238,102,151,115,162,189, 38, 42, 12,203,140, 58, 99,236,198,
 81, 20,250,  5,239,157,252,182,150,110, 44,255,179, 28,143,207,122,186,227,162,
174,235, 66,231, 88, 38, 83,189,251,230,202,  8,190,220,249, 94,180,167,221,187,
134,250, 98,174,166,190,190,191,156,195,186,238,147,255,127, 12,115, 97,132,206,
 32,176,100, 88,205,239,140,211,222,241,238,108,197,138,192,  6, 37,156,197,108,
169,227, 16, 19,  2,  1, 57, 31,216,120,193,112,111, 99,100,151,111, 75, 42,209,
 11,237, 76, 40,165,248,114,159,148, 47,217,184, 69,229,187,115, 25, 94, 35,220,
203, 62, 10, 46,106,229, 82,216,184,  8,227,208,205, 72,196, 60,230,210,182,173,
154, 28,141,111,125,222, 17,223, 59,198,223, 20,161,216,249,102,163, 23,182, 50,
147,110, 87, 96,252, 30,119,239,101,107,245,183,101,125,151,  1, 24,246,202, 94,
162, 17, 42,153,108, 38, 96,231,163, 80,  9,102,147,225,188,182, 79,162,241,116,
251,222,238, 42,154,168, 55, 94,184,218,115,180,109, 17, 51,178, 87,160,182,207,
101,159,116, 42,155, 15,  5,129,  1,239,219,226,185,220,123,151,202,230,107,206,
162,206,173,221,143,154,118, 47,190,159,163,241,125,214,173,233,103,126,166, 55,
194, 21,127,152,126,120, 44,143,191,178, 98,190,141,131, 38, 18, 76,133,  6,128,
195,168,161, 49, 83, 36,193,136, 76,144,130,130,164, 50, 28, 64,132, 16, 82,103,
182,  1, 66,113, 32, 34,145,208, 40, 66, 12, 34,134,146, 96, 68,  2, 42, 41, 74,
 25, 53, 30, 89,155, 33, 14, 78,180,  8,134,128,255,175, 89,253, 78,138,132, 18,
144, 84,161,  1,247,163,105,147,247,223,221,214,186, 37, 62, 96,120, 73,132, 33,
143, 69, 25, 60,144,127,  5,153, 64,102,106,196, 21,187,114, 34, 33,  5, 68, 99,
 31,125, 37, 39,116, 25,238,131,167,224,248,204,160,108, 38,197, 65,229, 23,224,
129, 60,229, 50, 72,215,204,237,153,101,225,178, 53,177,172,128,171, 10,172,103,
 49, 32,165, 40, 67,147,140,219, 91,211, 80,  9, 16, 35, 77,  3, 84, 59, 36,237,
 22, 80,253, 56,159,208,238, 98,129,247,194, 65,130,133,  8, 74,235, 83,228, 72,
199,147,106, 32,108,253,105,134,140, 67, 16,204,122,227,193,169, 34, 99,230, 36,
162, 82,143,114,192,168, 32,116, 20,208, 95, 31,194,191, 36, 77, 56, 39,126, 50,
113,160,151,  8,239,219,111,120,225,161,192, 40,149, 16,180,126, 59,  2, 51,228,
119,102,118, 76,132, 43, 26,156, 13,206,155,117,135,209,230,154, 60,219, 84,110,
235, 90, 12,156,130, 49,164, 35, 66,251, 30, 83,239, 84, 86,231, 78,130,104,235,
222,213, 32, 17,149, 30, 35, 77,201, 43,240,122, 57,253, 60, 54, 51,172, 93,125,
210, 16,  2,252, 22,  3,187,178,202,156,142,171, 34,181, 36, 74,138,176, 45,  5,
141, 65,219,128, 64,167,237,155,106,137,162,  8,  8, 63,114, 97,223,247,118,236,
205, 74,119, 26, 62,237, 21,172,234,111,100, 88, 18,163, 81,113,198, 66,  0, 44,
 33,180,165, 31,120,204, 14,127,246, 86,216,200,233, 97,245,210,198,123, 62,106,
225, 19,118,110,189,212,239,  0,249,255,255, 44,237,211,236,210, 20, 81, 54,149,
 29, 39,247,193, 28, 52,213, 63,152,102,149, 81,122,184,193, 59,163,135,135, 99,
254, 43, 99,168, 74,115,100,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseHash_phase1.c:
uint8_t GB_JITpackage_25 [1341] = {
 40,181, 47,253, 96,148, 16,157, 41,  0, 38,245,156, 40,192,146,117, 14,106, 70,
158,166, 33, 20,254,  4,173,116, 91, 27, 42, 31, 50, 32,140,179,150, 21,116,  1,
112,132,243, 76,127, 33,119,112, 93, 69, 97,186, 10, 64,151,  0,142,  0,149,  0,
 93, 23,251,246,236,216,254,117,173,223,112,  5, 96, 52,175,244, 83,102,192,170,
 52,159,238,183,255,191, 68, 18, 34, 41,160, 14, 42,188,201,232, 89,183, 84,110,
173,111,167, 34,219, 83,185,120,160,160, 50,238,168,108,249,115,123, 55,142,254,
188,235,172, 79,  8,  7,  5,  7,149,  5,131,130,131, 79,164,244,201,118, 71,124,
 56,101,125,180, 93, 42,234,138, 79, 32,203,147,217,188, 88, 35, 44, 30,136,111,
127, 32,  9,103,163,104,114,246, 46, 78,218,215,163,159,126,217, 29,197, 68, 35,
123,139,  1,219,184,121,112,179,145,195,182, 70, 42, 33,194,200,251,136, 22,102,
 62, 44,152,137, 56,  1,129,164, 66, 64, 16, 81,190,139, 45,249,242,130, 87,223,
224, 56,141,123, 26,139,148,249,101,142,203, 67, 48,  3, 43, 54, 17,146,144,  9,
133, 18, 59,204,229,215,214,214,184, 87,231,184, 95,152,160,112,103, 75,148,189,
147, 45, 87, 47, 99,251,253,210,153,209,237,178,232, 20,203,216,121,159,253,174,
251,180,138,214, 21, 27,189, 40,186,141,221,158, 50,230, 36,111,242,140,125, 70,
249,235, 91,197, 36, 52,181,164,249,118,219,227,183, 84, 83,191,202,184,189, 79,
 74, 58,191, 91,180,222,158,205,248,141,234,218, 47,123, 40,141,254,149,106,231,
106, 20, 29,243, 13,138,162, 52,174,113, 62,141,  2, 31,156,205,190,252, 98,243,
 48,209,129, 33,238, 33,  6,150,117,177,237,248, 98,161, 96,151,  4,109, 67,236,
 66,134,201,173,241,242,158,209,  1,157,242,201,199,245,137, 36, 93, 98,185,199,
 99, 49,113,135, 15,114, 54, 94,175,126,101,215,107,185, 14,188,  2,218,171,210,
 43,185,227,244,  3, 11, 93,183,149,239,108,234,253,114,196, 79,133, 26, 74,128,
172, 11, 74,104, 54, 28,141,198, 89,189,147,207,147,158,183,123,238,182, 75,235,
108,242,229,252,205,190,147,202, 79,170,131,204, 16,246,207,134,  2,131, 35, 34,
242, 13,232, 99, 81,128, 32,168,  3, 51,210,181, 14, 24, 93, 79,196,147, 55,143,
179, 13, 18,201,136,229, 30,233,223,202,118, 54, 23,185, 98,  0,151,118,246, 19,
233, 51, 86,106,251,253,218,108,249,198,217,162,202,178, 70,182,103, 15,158,143,
147,237,206, 79,113,135,197,219, 61, 77,243,235, 22, 16,168,110,179,142,110, 83,
166, 73, 84,173,223,244,160,245, 44,162,118,106,159, 54, 31,123,  8, 14,200,226,
 84, 60,105,198,182,139,218,171,142, 82,236,142,176,103,124, 37, 95,170,245,189,
230, 38,237,219, 89, 75, 86,115,109, 97, 46,183, 60,203,131,152,103,188, 95, 46,
 53,159, 61,127,231, 71, 37,133, 50,114,225, 34,103,113,208,226, 52,122,238,  1,
129, 53,168,129,173, 51, 51, 67, 34, 34, 73,146, 66, 97, 24,  3, 97, 12, 66, 24,
147,150, 74, 62, 34,177, 40, 75,194, 36, 66,134, 24, 70, 12, 21,136,  4, 50, 65,
 74, 75,202, 40,211,  1, 16,  0,243, 53, 74,127,226, 23,242,130,212, 37, 86, 70,
232, 44, 63,198, 69,128, 69,189,237,151,185,187, 94,186,165, 48,197, 70,143,237,
 72, 64,196,194,150, 69, 17,136,235, 38, 11,  5,130,  1,163,147,171,237,207,173,
211,138, 67,167,182,161,232, 53, 29,110,150,125,146,232, 78,124, 68,205, 93,  6,
238,231,138, 44,159,216, 91, 34,170, 74,101,129,249, 85,196,243,111,247, 90,129,
167, 39,115,182, 52,165,147, 84,226,253,199, 26,  4,112,181, 69,227,230,237,  3,
 66,173, 77,254,113,128, 82,170,214, 48, 82, 55,144, 44,143, 90, 71,103,150, 78,
176,215, 82,134,152,137,105,223, 85,200, 26, 82,  0, 70, 36,244,121,151,170,235,
172,166,202,157,  1,152,  9, 16,219,227, 37,125, 82,207, 80, 36, 52,147,156, 74,
197,233, 35, 37, 42,202,167,113,172, 39, 68,236, 66, 96,  7,137, 55,208,134,231,
200, 13, 53,174, 26, 84, 33, 72,213, 18, 43,111,208,245,210,136, 66,237, 35,217,
127, 37, 83,158,194, 83,220,187,  7, 22, 79, 98, 23,133, 48, 26, 39, 23,  9,148,
 58, 39, 58,255,219,216,  9,245,116,113, 55,173,136, 49, 29,103,135,  1, 36,124,
180,208, 40,120, 42, 56,169, 49, 48,148,  8, 40,124,170,100,228, 83,208,242,160,
 98,176,234,233,141, 22,223,237,177,246,242, 14, 99,193,176, 75, 11, 21,148, 73,
 15,224,175, 79, 88,102,103, 85, 12,170, 82,224,102,167,112, 31,193,147,157,251,
 77,255, 37,210, 64,137,200,235,192, 45,103,110, 40,190, 81,230,142, 82,210,135,
188,171,183,219,231,202,249,213, 19,177,135,196, 49, 44,191,225, 30, 75,147,173,
 21, 23,145,236,146,150,133,122,241, 13,224, 85,241,152, 24,206,233, 72,149,194,
 39, 32,141, 17,203, 58,187, 79,123, 58,172,  7, 62,121,144,140, 70, 18,179, 91,
  1, 26,145,237,107,167,109, 98,200, 43, 16, 14,187, 24, 44, 12, 20,153, 23,209,
202,141, 33,116, 49,142,147,109, 65,108, 22,218,204,191,178,166,154,179, 57,135,
146,218,175,164,152,105,168, 62,193,254,167, 12,113,215,191, 47,237,  6, 29,124,
104,177,161, 73,251, 27,180, 68,236,173,152,200,190,147,  6,103,166, 55,206,125,
 59, 58, 98,177,156, 15, 43, 22,179, 22,195,214,180,145, 21, 36, 57,186, 18,130,
105,144,232,  5,144, 71,180,106,195,249,192,199,225, 23, 30,118,243,189, 84, 55,
185,194,207,  2,235,242,153,194,254,211,252,184, 19,189,178, 67,174,151,213, 82,
170,196,171,  8, 34, 39,187,  8,221,124,175,  4,144,151,154,202, 24, 94,121,121,
152,159,237,198,212, 48,157,152,143, 85,106,212, 49, 69,121,233,111,213,205,211,
140, 96,111, 83, 33,125,207,194,107, 31,112,100,173,131, 81,219,  9,  6, 74, 98,
  4,181, 24,163, 45, 26, 65, 87,200,231,230, 54,198,240,249,139, 15,239, 82,205,
 65,125, 50,193,210,168, 69,214,222, 20,156, 74,142,163, 12,205, 54,131,127,117,
170, 50,152,160,242,217,163,154,227,162, 39,137, 19, 96,191,243,207, 42, 13,175,
120,
} ;

// ../Source/Template/GB_AxB_saxpy3_coarseHash_phase5.c:
uint8_t GB_JITpackage_26 [1108] = {
 40,181, 47,253, 96, 83, 12, 85, 34,  0, 22, 47,144, 40,192,146,117, 14,106, 70,
132, 54, 47,219, 91, 52,121,126,214,134,106,191,157, 47,140,179,202,186,  5, 50,
 64,149,157,232,120,  7,127,114, 93, 69, 65,144, 13,102,136,  0,132,  0,134,  0,
220, 92, 49,149,119,103, 75,254, 63,138, 58, 34,130,136,  1,132,118,218,180,241,
146,144, 50,199, 93,233,134,129,208, 91,169,198, 25,200, 68, 37, 34,178,209,140,
144, 94,186,249,237,238,130, 55,255,190,248,234,192,128,192,  0,178, 80, 64, 96,
240, 73,147, 94, 93,206,152,149, 71,226, 67, 93,131, 24,156,189,226,196, 12,165,
179, 51,116,144, 88, 14,109,  6,113,162,132,191,218,192,174, 41,198,187, 63,  4,
185, 83,  4,162,117, 93,146, 64,239,236,172,236,238,188,208, 27, 78, 80,147,  7,
 33,187, 49,175,164,108, 68, 73,113,248,192, 64,  4, 25, 24,  8, 93,246, 97,249,
192,137,152,124,184, 44,151,139,163, 27,199,  0, 18,137,242,166, 23, 31, 73,145,
153,197,  1,220, 14,246, 47, 42,119, 13,214,201, 41,168,114, 87, 80,251, 68,112,
 75, 58,  7,185, 69,  1,197, 81, 63,218,228, 22,158, 87,113,123, 93, 54,234,152,
 40,106,126, 13,147,247, 13,153,243,110,221,243,222, 18, 65,161, 43, 75,211,167,
 98,233,122,215,172,241, 75,184, 87,124,107,163,108, 65,154,  6, 86,208, 37, 28,
119,223,234,188,133,117,238, 77, 51, 17, 14,188, 23, 78,140, 55,220, 34, 18,137,
 84,156,187,188, 10,125,223, 12,159,156,162,162,232, 99,114,139,  6,130, 66,163,
145, 26,203, 69, 66,126,228, 37, 45, 89, 39,  2,131,168, 60,137, 34, 48,121,241,
214, 21,189, 99, 10,169, 13,117,247,240,176, 87, 94,150, 81,122, 64,192, 11, 60,
 93,169, 61,189, 31,229,120,171,116,242, 14,103, 95,137,217, 83,247, 96,183, 90,
 99, 26, 10,188, 37, 67,223, 25,130, 90,  3,133,125, 57,126, 21,130,173,209,140,
211,174, 61, 31, 44, 19, 55,157,236,234,108, 50,142,172,104,162,140,136, 88,134,
161, 72, 14,  6,195,190, 15,196, 65, 56,134,220,219,137,209,236,249,229, 99,199,
 56, 13, 81,  5,  1, 92,  7,187,242, 67,218,245,156, 92,122,197,178,177, 92,178,
232,144,109, 32, 56, 20,117,217,171, 45,204, 70,130,223, 96,125,244,225,121,166,
126, 37,221,146,197, 74, 68, 71, 78, 76,222,183,168,141, 75,229,135,182, 73,195,
111,158,207, 28, 10,187,210,207, 83,249,252,105, 98,233, 23, 78,188,112,103, 58,
 88,200,243,141,182, 70, 27, 12, 45,199,183,236, 85,144,155, 55, 79,163,157,198,
 82,100,143, 99, 67,180,209, 90, 30,111,122, 50,122,223,160, 91,229,201, 39, 44,
 21,141, 87,167,118,101,195, 41, 54,128,229,168,145, 33, 99,102,136,  2, 17, 73,
 65, 82,144, 66, 99, 48,132, 16,195, 84, 89, 55,226,152, 64,134, 81,145,  0,  9,
164, 49,198,  9,142,  4, 18,208,200,  4,105, 73, 65,161,102,  3,236,144,  1, 86,
197, 67,199, 79,110, 20,102,230,197,124,218,177, 67,  0,252,249, 60, 16,193,193,
 45,115, 49, 81,155,180, 97,143,155,121, 64, 70, 53,  9, 16,214,110,196, 23,  4,
138,  5,129,225,213,184, 28, 56,177,158,254, 93,104,  7, 73,119, 48,104,104, 62,
241,241, 19, 29,204,209, 57,230,116, 46, 16, 46, 28,253,211,247,237, 38, 84,  8,
135,240, 47, 10,111, 41,135,  0,229,208, 39,118,114,111,138, 57,208,153, 86,  3,
248, 42,178,133, 12,255, 15, 78,  4,147, 60, 85,215,221, 23, 60, 74,230, 21,147,
113, 78,216,154,123,103,136,101, 32,170,190,224,206,  4,144, 48, 30,245, 83,126,
171,179, 54, 73,  7,140,123,228, 38, 30,165,240,133,145,207, 62,165,216,229,254,
112,249,144, 33, 54,249,203, 95, 51, 68, 48,212,140,211, 44,137,144,181, 43,175,
 96, 91,161,127, 64,176, 15, 10,124,196,155, 66,186,158, 65, 56,217,226, 28, 80,
 54,227, 35,125, 59, 95,124,164, 99,103, 64,102, 64,133, 28,237,237, 22,255,210,
  4,186, 34, 20, 33,113,136, 69, 53, 54,  2,172, 10,  3,186,103,173, 37,240, 32,
185,229, 56,139,177, 26,138, 89,118, 78,144,174, 61, 50, 79,123,203,183, 99,212,
 93, 95,169,133,113,231, 48,  9, 46,241,  4, 96,109,125, 99,237,  3, 79, 58, 19,
 39, 11, 34,208, 16,118,137,105,194,151, 13,111,109,164,159,119,148,142, 36, 61,
 35,110,158,232,193, 66,  0,142,106, 48,249,118,143,231, 88,129, 22, 74, 64,182,
  3,104,239, 37,148,117,118, 59, 76, 44,230,  1,206,231, 74,113, 35,200,249,222,
 67, 99,112, 27,119, 25, 70,194, 89,151,225,162, 47, 13,210,122,127,199,123,189,
199,253, 80,115, 85,155, 62,  6, 62,237,169,232,120,132, 87,199,235, 33, 33,221,
 81, 32,226,188,141, 29,204,217,126,200, 57,162,204, 66, 79,  3, 20, 54, 42, 72,
156, 61, 59, 90, 32, 50,172,172, 81,209, 17,  2,148, 91,120,150,166, 10,138,232,
166, 77,227,  3,123,  5,124, 97,233,185,246, 60,111,236, 98,248,185, 22, 76, 70,
 81,192,228,120,216,  7,205,246, 15, 38,174,114,234, 79, 41,187,167,191,147,141,
 80,179, 28, 60,164,122,  0, 77,
} ;

// ../Source/Template/GB_AxB_saxpy3_fineGus_M_phase2.c:
uint8_t GB_JITpackage_27 [1109] = {
 40,181, 47,253, 96,118, 18, 93, 34,  0,182, 46,142, 31,208,222,230, 64,230,110,
101,118,245,179,101,232,203, 13, 91,178,176,101,172, 13,162, 10,144,210, 44,245,
 48,126, 24, 80,  2,136,  0,128,  0,133,  0,  3,204, 15, 36,166,249,255,127,  0,
 96,  7, 88, 36, 26,136, 30, 99,212,252, 46, 57,187,138, 53,219, 14, 59,136,198,
182, 99, 21,132, 80,101, 72,137,176,109,103,227, 46, 29,231, 81, 86, 75, 47,203,
239,  7, 71, 99,209, 64, 64, 24,139,198,  9,177,193, 15,184,218,104,230,137,239,
185, 49, 95, 90, 61,253, 96,250, 64,151,209,164,231, 70,210,248,164,166,169,115,
173,153,  0, 63,216,139,109, 52,255,135, 75,225,171, 88, 66, 20,204, 37,141,198,
116, 52,193, 16,136,107,155,182, 85,  4, 29, 57, 19, 71, 49,120,193,125,224,101,
115,133,  2,128, 80, 40,  2,162, 14, 56, 35,193,203,119,183, 52,134,  9,  6, 67,
104, 27,164,252, 98,126,242,129,173,207,152,150, 15, 45,157,156,240, 96, 12,174,
217,136,190, 18,248,220,178, 79, 62, 59,105, 54,245,183,107, 63,177,181,134,163,
209,180,154,159,241, 89,197,159, 87,196,175,100,236,150, 14,198,226,208,231,181,
178,250,155, 23,128,  4,163, 98,235,219,222,240,182, 27,246, 92, 72,251, 44,233,
 47, 57,227, 22,196, 23,137, 69,229,188,207,182,113,159,230,243,181,175,131,208,
197,250,197,113,253,171,182, 46,114, 66, 20,194,236, 32,  9,207,157,217, 54,140,
158,178, 23, 42, 23, 51,159,166, 52,185,248, 12, 70,178,173,  7,184,238,249,116,
 24,  8,239,152,155,118, 92, 27,215, 44,141, 29,215,165, 73,187,177,119,  9,171,
221,240, 61,230,206,245,188, 61, 86,105, 55,211,143,185,222,142,195,122,237,165,
189, 64, 32,191, 87, 12,152,107, 78,157, 82, 10,196,116, 66,163,211,199,  1, 89,
  2,193, 51,157,145,104, 20,  2, 87,162, 15, 52,117,196, 26,168,192, 38,239,154,
173,217,222,216,  9,139, 87, 42,215, 89,146, 14, 46, 86,242, 35,193,143, 20,239,
201,227, 58,180, 85,165,201,  4,  0, 64, 15, 32,118,104,107,147, 19,198,216, 73,
 27,131,185,147,218, 10,  3,207, 43,130,228,  5,191, 65,105, 36,250, 48, 38,177,
134,182,103,235,241, 73,219, 52,233,173,237, 79, 96, 52,126,222, 51, 42,226,113,
110,217,207,182,183,219,101, 29,111,239, 17, 28, 63, 28,196,193, 35, 39, 81,  7,
212,148, 80, 39,210,135,233, 57,118,146,220, 13,111, 56,233,133,134, 63,215,119,
166,161, 89,251,  4, 19,  6,154,211,151, 33,161,190, 59,123,204,247,101, 73, 27,
151,157,113,156,252,171, 56, 32,171,240,103,178,130, 80,161,198,121,188,139,138,
 66,128,220,168,161,165, 82, 76, 68, 68, 70, 65,146,164, 80,104, 12, 64,132, 16,
 33,179,177, 14,242, 88, 34,163,105,196,104,196, 16,102,  4, 68, 96,  4,132,  8,
138, 72,100,161,132, 34,129,144,109,  3,166, 56, 73, 74,122,221, 68, 74,140, 78,
 19,232,113,174,147,142,234, 88,159,228, 65,193, 41, 91,175, 27,239,107, 96,190,
120,243,114,189, 55,113,160,242,251, 32,177,236, 22,231, 51,208,189,159,237,152,
 43,200, 55,209,181,181, 60, 14,166, 82, 21, 71,  7,  7,225,  9, 44, 98,  8, 88,
 66, 14, 69, 94,196,204, 82,178,225,176,236,228,242,155,229,151,110,142,208,115,
  5,117,250, 55, 94,228,120, 17,135, 32, 19,129,247, 63,182, 73, 96, 79,176, 36,
 91, 20,161, 70, 54,219,204,158,202,161, 80,137, 51, 74, 36,  3, 81,198,241,160,
107,133, 90, 89, 69,168,116, 70,247,118, 73, 27,234, 74,165,174, 52, 38,166, 11,
 95,186,151,231, 49, 52,195, 14,154,  9,233, 30,238,  1,154, 92,232,192,205, 43,
142, 96,120,169,168, 84, 43, 97,153,134,149,105,150,246, 56, 18,  2, 74,  6, 41,
104, 67,  1,126, 58, 64, 80, 60,180, 23, 96,135,254,192,218,235,217, 45, 71,143,
206,159,206,240,143,243,120,  6,181,  9,210, 99,205,184,226, 26, 13,106,216,108,
139,  3, 38, 27, 61,101,127,112,  0,140, 23,139,113,173,223,144,132,160, 97,235,
150, 26,160, 98,194, 58,220, 17,238, 69,126, 39,183,139,192,139,206, 26,251,190,
180, 46,108,218,160, 14, 97,205,202,206,231, 73,190,101,179, 20, 23, 33,194, 59,
142, 69,141,108,208, 32,171, 49,240, 53,183, 70, 21,164,114,160, 13,127,131, 17,
 97, 79, 33, 99,  6,215,110,165,198, 44, 41, 81,169,124,193,210, 65,167,138, 31,
 39, 25,142,  3,184,215, 34,143, 42,243,  2, 51,176,162, 56,200,154,218,248,217,
 11,208, 33, 70, 15, 50,164,233,137,  1, 24,214,132,241,144,234, 97,140,161, 48,
 98,251,139, 43,  6,185,207, 11, 64,139,191,187,118,242, 80, 45,156,127, 53,117,
 27,184,193,212,141, 51,131, 88, 75,  0,211,105,210,137,203,166, 82, 83, 96,174,
223, 86,117, 68, 71, 59,  2,  4,117,  3, 12, 73,252, 10,248,150, 74,158, 54,211,
103,145,229,160, 59, 85,148,236, 24,201,120, 72,197,206, 17,102, 16, 52,128, 76,
118, 70,231, 20, 19, 75, 78,  1, 26, 52,157,159,153,  6, 51,195, 57,198,125, 46,
137,129,151,218,175,170,186,187,119,
} ;

// ../Source/Template/GB_AxB_saxpy3_fineGus_notM_phase2.c:
uint8_t GB_JITpackage_28 [1115] = {
 40,181, 47,253, 96, 59, 14,141, 34,  0,150,109,137, 32,208, 92,117, 24, 45,246,
229,188,175,207, 65,236,108,250, 50, 22,173,229, 53,197,169, 75,106, 72,239, 69,
174,102,240,131, 89,  2,132,  0,123,  0,128,  0,255,255,  3,  0, 54, 64,151,240,
 16,125,170,200,151,248, 47,237,106,214,108,187,204, 32, 26,219, 86, 85, 13,130,
 84,241, 36,202,142,165,141,251,115,156,207, 85,253, 28, 69,197,115, 12,175,243,
 16,143, 69,231,189,160, 34,156,195, 53, 70, 86,158, 16, 79, 59,243,117,213,208,
 57,144,168,153,156, 47, 50,189,124,141, 83,242,  5,234, 92, 97, 32,192, 57,123,
113,140,204, 63, 55, 49,136,161,100, 19,136, 80,254,121,141,201,243, 53,110,242,
181, 35,134, 93,218, 86,115,100,208, 94, 51, 18,143,147,153, 56, 78, 46, 87, 40,
  0,  8,133, 34,163,216, 50,239, 91,159,117,105,235,115,175,192,147, 44, 21, 78,
102,100,181,198,201, 24,178, 92,254,219,110, 73, 21,126,225,112, 40,109,143,145,
 79, 94,  7, 79,168,151, 93,123,208,194, 60,134,215,174,154,159,113, 90,205,167,
215,196,175, 45,213, 69, 25, 92,167,215,174,234,111, 94, 44, 66, 91,223,246,150,
183,221,169,211, 74,178, 83,148,252,191, 47, 46, 65,188, 75,116, 97,122,159,109,
227, 78, 95,207,215,190, 18, 54, 55,235,187,227,122, 84, 61,221,196, 20, 88,220,
 71,160,156,107, 97, 50,  7,109,203, 23,236,223,215,149, 93,118, 91,  6,225,157,
201,140, 95,222, 51,183,235,184, 54,134,205, 26,125,185,174,234,141,166, 96,183,
124,159,185,115, 77,101, 87, 85,215,205,228,207, 92,101, 47,235,181,215,245, 91,
 66,153,207,104,164,100, 54,157,144,136, 25, 77,131,193, 43,153, 14,167,179, 25,
 75, 28,113,  4,101,204, 42, 48,159, 71, 72,182,213,240,240, 89, 35,218,212,218,
170, 98,  4,124, 78,201,140,199,240,226,235,121,108, 56,178,173, 97, 10,124,195,
108,205,246,170, 94,232, 30,134,175,217, 22, 73,104,137,173,  0,192,205,194, 58,
239,233,125, 23,154,199,185, 87, 55,239,211,182,178,219,104, 61,101,103,156,227,
 32, 33,203, 71, 20,242,136, 20,240, 12,219, 71,187,229, 45,193,133, 89, 75,219,
130, 67, 37, 80,210, 92,240,204, 70, 87,182,226,139, 21,143,136,150,102,219, 41,
 50, 93,225,180,143,162,100, 99,180,  1,183, 60,  3, 95,200, 63,  9, 51,154,192,
123, 15,111, 43,152,  1, 48,188, 89, 17, 45,159,242, 99,124,222,226,152,182,178,
245,188,229,185,178, 91,152,116,253, 91,120,199,221,169,155,231, 26,134,146,177,
203,  2,128,239,168,161, 37, 83, 72, 68, 68, 68, 68,146, 36, 41, 12,  7, 48,132,
 16, 82,204,200, 60,  2,129, 44,  5, 35, 17, 81,134, 17, 47, 32, 34, 22, 72, 48,
129, 36,201, 76, 78, 65,118,161, 17,104,207,108,143,217,150,101,244, 69,195, 81,
116,121,228,213, 28, 96,102,198,157, 97,188,215, 41, 85,219, 92,221,140,195, 15,
123,118,160, 70,124, 61, 76, 80, 44, 40,247, 36, 86,211,167,212,134, 86, 56,227,
 58,233,156, 53, 24,199,199, 18, 18,113, 21,171, 52, 88, 84,243,118,126,211,220,
101, 96,  7,208, 12,136,250,116,235, 29,118, 98,184,245,166, 65,211,180,  1,  5,
  0, 66, 15,175,136, 40,174,170,176, 81, 34,105,251,145, 42,252,172,230,  2,171,
 12, 25,106,217, 96,237, 11,107, 20,  9,125, 51,237,207,114,241,114, 42,219,195,
164, 40, 28,156,194,124,  7,239,188,216,121,211,173, 32, 34,134,249,126,228,116,
116, 31,194, 97,155, 57,215, 18,133,213,200, 10,223,144, 54,168,200, 16, 11, 30,
 20,245,240,225, 96,221,  0,184, 88,168,205, 48,201,198, 41,236,232,122,127, 55,
  6, 73, 51,  2, 46,244,207, 71,185,  5,221, 97, 41,124, 24, 77,201,109, 13, 22,
 74,  7,145,114, 37,121,180, 15, 42, 75, 65, 68,127,105,158, 71,123,225, 92, 81,
216,204,183,  3,240, 43, 11,244, 60,109,165,  5,128,148,200,176,162, 84,175,122,
 32,161, 52,229, 21, 26, 20,247,146, 22, 26, 40,132, 15,162, 97,108, 47,238,208,
111,190,228,145,115, 12,222,177,  0, 69,176, 25, 57,252,216, 93,114,184, 64, 17,
221,141,249,206,249,  5,227, 44,139,185, 65, 15,162,147,  5, 51, 92,112,236,122,
 66, 79,  6, 20, 40, 61,177,250,142,193,227,134, 78,231,110, 71,205,244, 59,150,
 65,  6,240,115,245,216, 90,  3, 20, 88,  8, 15,140,207, 43,198, 32,193,251,236,
208, 68,156,174, 95,100,142, 71,133,140,225,  2,228, 55,115, 16, 88,112, 92, 96,
106, 25,229,  2,206,116,192,  5,115, 90, 40, 78,245, 34,169, 95,112, 57, 52, 51,
 23,  0,141, 62,218,176,240,208,142,142,248,186,201,194,  6,124,189, 63, 81, 38,
 49,233,128, 39, 94,221,158,235, 88, 51, 70,170,101,193, 23,132,  9,229,114, 84,
  2,251,204,245,144, 84, 38, 80,152, 85,203, 73, 43, 91,159,  1, 51,216,244, 44,
175, 86,109,244,161,101,243, 35, 60,247,158,236, 75,140,126,164,254,178, 24, 30,
108,108,204,119, 58,147,  0,169, 38,181,195,146, 51, 92, 14,154,209,159,153,198,
157,195,156, 99, 55, 27, 24,  4,247,100, 96, 82, 61,220, 49,
} ;

// ../Source/Template/GB_AxB_saxpy3_fineGus_phase2.c:
uint8_t GB_JITpackage_29 [1010] = {
 40,181, 47,253, 96,202, 12, 69, 31,  0,134,171,130, 32,208, 28,231, 24,149,213,
127,107,213, 29, 47, 59, 22, 38,102, 40,204, 86,201, 34,231,130,  9, 99,185, 69,
174,102,240,131, 89,  2,125,  0,116,  0,122,  0,  0,  5,162, 59, 52, 25, 82,243,
123,228,236, 58,214,108, 91,220, 28, 26,219, 14, 43,231, 96,186,128, 16, 98,199,
206,198, 29, 58,206, 36,171,134, 94,150,223, 57, 70,167,232, 14,143,133,162, 59,
 33, 28,156,195, 53, 70, 47, 71,124,167,145,249,190,234,232,156,232,227, 84, 72,
147,158,153, 72,227,147,154,162,206, 21, 38,  2,156,179, 23,199,104,254, 57,241,
146,185, 95, 63, 87, 41,124,158,229,145,174, 49, 37, 77, 16,195, 50,109,235,  8,
 50,104,230,140, 98,176, 50,251,192, 74,230,137,  4,224,144, 72,  4,174,207,  5,
126,174,241,222,245, 89,139,182, 62, 55,235,255, 37, 55, 97, 46,158, 13,216,114,
129, 21,112,132,201, 28, 96,187,165, 33, 62,193, 96, 16,109,131,147, 87,204, 75,
 62, 88, 29, 83,242,245,178,107, 47,177,176,142, 65, 19,105,159, 37,237,250, 85,
243, 51, 62,235,248,243,142,183,221,248,245, 99, 61,231, 10,111,249,155, 31, 57,
227,148,195, 21,  8,197,105,101, 73,107,174,182, 30,215,171,106,234,163,134,208,
226, 34,  3,203, 57, 23,166,249,255,127,  0,192, 22,103,182,189,162,167,247,241,
242, 97, 66,184, 54,134, 61, 95,251, 89,151,230,235,134,239,114,  5,187,226,155,
204,157,235, 41,123, 88, 95, 55,211,147,185,202,142,197,122,237,125,253,158,225,
 21, 51,218,132, 74,160,101,211,249,140, 62, 13,136, 18,  8,126,217,124, 60,159,
 14,120,242,124,160,104, 51,214,192,  8,201,182,112,239,153, 67,234,212,193, 87,
 93,245,155, 72,158, 79,154, 49,232,253, 51,159,193,134, 35,219,234,173, 36,111,
152,173,217,222,240,  4,197, 61,239, 53,235,162,131,143, 53,  0,192,205,194, 18,
 44, 90,142,157,173,199, 39,109,211,164,178,182,239,126,222, 43,188,241,248,108,
 43,187, 93, 86, 82,246, 27,227, 28, 55, 14, 14, 25, 97, 66,164, 17,232,179,220,
 24,247,108, 17, 92,199, 42,218,190,221,198, 53,236,204,  8,218, 88,197,155,197,
110,251,235,249, 17,150,107,187, 18, 45, 61, 71,232, 60,111, 28, 60,219,198,125,
154,199,245,187,128, 72,103,147,249,190, 44, 27,151,157,239,205, 36, 39,228,223,
164,  1, 81, 98,103, 42,154,176,187,194, 38,195,110,164,  5,128,205,168,145, 41,
 82,104,100, 70, 68, 36,  5, 73, 82,104, 12, 64,132,144,169, 42,235,  6,226,184,
 20,201,116,  8,130,132, 16, 49, 32,193,148, 68,150, 36, 42, 40, 35, 41,213,  1,
217,181, 19,214,153,109,  5,118, 82,142,199,250,178,144, 69, 63,121,147,243,147,
 67, 48,231,187,113, 67,175,114, 76, 65,147,183,117,101, 51, 99, 84,141, 22,116,
 33, 94, 77, 13,218,158, 66,159,243, 94,137,  6,  6,253, 37,185,234,236, 17,226,
157, 57,187,166,178,235, 68,253, 87,104, 45, 76, 32,122,216,234,211,  5,246, 14,
 42, 57,  1,113,193,229, 62, 56,162,154,130, 14,127,171,195,186,131,184,187, 24,
210, 42, 35, 29,155,159, 77,200, 52, 56,150, 18, 88,107, 42,249,  6,107, 85, 97,
122,177,173,178, 56, 32,171,106,184,  7,163,138, 85, 76,144, 38,235, 60,236, 40,
  2,161,171,200, 74, 72,172, 58,187,179, 80, 63,238,205, 69, 90,198,143,223,144,
205, 61, 85,250, 31,151, 74, 55,122,166,228,137,196,193,197,178,170,163,  7,114,
 10,124, 84,179,222, 45,193,100,126, 73, 27, 74,169,148,125,198,111,208,160,116,
 96,104,193, 20,172, 71,225,161, 11, 69,163,146, 75,172,173,191,132, 64,103, 34,
  8,139, 96,149,178,180,157, 88,195, 98,  5,250, 25, 33,240, 85,232, 34,199,140,
  6,209, 45,160,183, 40,152, 63,157,216, 85,184, 93,172,232,142,151,167,100, 24,
100, 47,235, 78,172, 52,166,121,241, 62,185,236,  8,197, 69,188,244,129,240, 72,
174, 58,199, 37,212,164,238,150,128, 36,196,171,255,  2, 86, 21,142,138, 11, 68,
176,206,130, 76,107,243,224,169, 51,133,154,136,166, 13, 69,168,248,247,103, 12,
168, 27,140,234, 29,131, 57,240,240, 94, 25,242,162,124,213,244,196,184,225, 40,
189, 88,177,224, 57,160, 52,123,  1, 77,187, 98, 44,122,252, 17,102,179,131,199,
102, 56, 50,237,243,  8, 50, 48,142,121, 92,101,141,125, 55,  2,173,246,184,245,
 14, 25,  5,123,170, 78, 85,176, 41,241,233, 17,231,228,112,147, 65,153,139,175,
 97,138, 64, 38, 71,154, 62,104, 86,255,204,196, 28,117,215, 69,189, 31,113,168,
 58, 73, 53, 51,161,175,234,  1,136,  1,
} ;

// ../Source/Template/GB_AxB_saxpy3_fineHash_M_phase2.c:
uint8_t GB_JITpackage_30 [1179] = {
 40,181, 47,253, 96, 29, 18,141, 36,  0,118,111,145, 40,192,240, 58,  7,126,  7,
120,190,119,253,151,152, 41,204,181,109,223,123,149,203,120,227, 77, 47,113,209,
191,133, 69,178, 63, 28, 56,100,219, 20, 69,166,232, 64,135,  0,128,  0,134,  0,
223,182, 11, 69, 81, 89,166,204,171,207,206,123,239,255,239, 40, 57, 40,146, 43,
194, 30, 55, 69,237,150,145,155,246,173,220,121, 34,108, 43,115,141, 16,113,208,
 44, 72, 58,182, 24,217,242,231,246,122, 19,253, 57,  8,106,175, 42, 23,229,138,
 16, 88,148,235, 20, 55,189,178,109, 49, 53,151,104, 39,121, 55,172,232,208, 43,
144,134,128,241,196, 57,114, 44,108,199, 41,130,248,246,  8,228,120,245, 87,152,
135,150, 21,108,151,204, 45, 23,219,233,137,114,147,158,157, 29,174, 77,101,133,
 36, 98, 76, 43, 49, 24,154,196,112, 62,153, 56, 34,147, 73,224,229,137, 99,167,
  6,172,233, 27, 78,130,246,145, 20,114,147,161, 13,167,127, 17,214, 99, 87,133,
212, 77, 30,193,121,113, 69,223, 95, 59, 54,253, 24,210,119,197,162,208,126, 21,
222,130,200, 41,146,138, 68, 34,169,174,140,  6,103,223,174,221,199,232,216, 87,
102,209,111, 88, 47,177,178,237, 36,209, 45, 11,210, 97,157,232,119,139, 35,142,
 11,171,142, 63, 46,  4,235,232, 22,250,234,167, 60,203,238, 81,180,242,166,219,
160,  4,196, 43, 91, 52,135,118, 30,222,218,239,120,228,123, 39,103,223,213,121,
123,219,  1,  1,223,132, 52,205,  2,195,  3, 37,141,183,242,217,187, 23,205,113,
  2,203, 52,218,230, 35, 51,158, 77, 33,164, 97,167, 94,137, 65, 81,237,247,233,
 79, 81, 29,144,214,161,174,233,162,174, 95, 46,147,236,216, 78, 81,132,107,136,
221, 58,228,109,245,175, 20, 24,184,181, 39,143, 63,222,147,246,236,247,143,201,
215,  8, 12, 91, 41,226,  6,  7, 30,238,  0, 50, 17,118, 30,213,190, 53,228, 78,
101,212,111, 78,159,246, 73,237,163,225,191, 99,112, 87,219, 97,163, 73,240, 72,
138, 79, 98, 94,122,165, 32,144,174,178,188, 28, 35, 78,219,237, 12, 14,199,134,
131,114, 87, 71,  0,148,199,141,147,173, 36,141,179,182, 72,142, 33,149, 95, 40,
181,233,163,144,160,101, 64,191, 29, 39,139,226,252,197, 22,100,207,167,161,246,
  5,215,211,171,178, 50,122, 75,189,  8, 43, 15, 96,176,189,139,111, 84, 94, 85,
 31,133, 80,130, 71,110, 62, 12,161,  5, 45, 51,121,108, 28,123,229,153, 70,201,
 66,  2,193,201,117, 69,120,231,109,123, 55,236,234, 40,164,239, 87, 60, 26, 47,
101, 81,215, 11, 10, 40, 58,115,140,162,208,141,142,239,236,196,209, 55,121, 20,
 97,167,174, 67, 71,222,103, 16,140, 78, 41,155, 30, 16,128,253,168, 97,177, 82,
106, 68, 68,102, 20, 36,  5, 73,161, 49, 64,134,136,204, 89,209,  3, 18, 89,162,
  3,129, 16,113,132,  9, 17, 33,  2, 35, 36,  2, 38, 16,  9, 68,136,162,  9, 36,
136,116, 14,149,184, 67,152,  9,116,238,153, 68, 29, 77,130,232,166, 44,193, 12,
 57,231,107,207,252, 95,154, 51,220, 51,115,120,150,164,163,211, 92,137, 29, 16,
 54,137,133,199,178,216,162,239,115, 26,173,199,185, 10,120, 36, 93, 40,  9,148,
195, 56,151,138, 59,  9, 77,109,111,171, 80,213,206, 65,153, 12,153, 65,148, 40,
 14, 91, 68,119, 11, 27, 79, 32,173, 25, 51,178,139, 30,229,234, 23,160,201,141,
 79, 95, 52,146, 85, 23,186, 56,222, 63,100, 33,140, 75,168, 70,126,108,199,131,
134, 71,222,212,140,106, 38,160,235,155, 41,133,237,104, 25,118,161,144,151,120,
193,  1,194,142,201,126, 43,101, 84,129, 91, 81,231,211,156,184,211,140, 79, 37,
246,210,186, 69,  5,210,106, 70, 91, 27, 63,100, 35,177,182, 31,204, 80, 14, 76,
115, 46,221,175, 98, 17,128, 25, 40,151,177,192,145, 67,213,211,218,166, 74,139,
  3,209,118,172,170,101,184,219, 86,207,212,  9, 63,233,255,125, 83,231,159, 39,
250,113, 21,127,234, 96, 95,234, 59,201,118,138,220,106,140, 64,121,228,226, 22,
 14,204,232,150, 97,155,115, 43, 16,190, 70, 80, 53,115,190,129,200, 58, 10, 57,
148,140,244,239,216,239,100,156, 79, 74,123, 79,191,194,154,249, 33,239, 27,254,
 69,147,193,152,196,227,251,  5, 37,125, 29, 11, 54,194, 65,224,240, 70,215, 80,
100,131, 56,246,139, 96,106,  1, 56,181,201,149,111, 19, 88,162, 22,230,  6, 12,
210,237,211,123,178,233, 19,149, 61,153,255,113,211,  3, 46, 11,159,105,128, 19,
 86,204,160, 64,101,195, 74, 27,204,215, 85,222, 87, 32,203,251, 64,215, 32, 29,
179, 79,176, 87, 12,212,  8,175,245, 89, 79,246,244, 97, 34, 17,136, 80,103,254,
197, 94,178,208,178,139, 49,147, 90, 14, 89,137, 31,146,178,240,110,150,121,178,
214,167, 95,132, 10,248,254,195,253,219, 43, 82, 65, 64, 40, 34, 28,195,215,255,
234,248,127, 93,109,156,166, 64,155, 65,110,234,157,188,229,200,120,195, 58,170,
 10,178,175,168,127,138,158, 16,115,185, 18, 61, 93, 12, 12,249,218,102, 82, 39,
140, 74, 71, 50,108,192,122,139,188, 16,156,163, 87,190,224, 44,203,141,234,219,
121,245, 56,251,165,244, 18,254,226,236, 96, 81,220,163, 61,105, 43, 34,227,198,
 47,124, 87,244, 22, 49,144,136,231,100,200,206, 68,202,103,115, 91, 88, 31, 52,
255,207, 76,116, 21, 62,156,114,238,170, 17,126,200,193,185,106,229,138,  1,
} ;

// ../Source/Template/GB_AxB_saxpy3_fineHash_notM_phase2.c:
uint8_t GB_JITpackage_31 [1173] = {
 40,181, 47,253, 96,175, 14, 93, 36,  0,198,239,143, 40,208,208, 58,  7,122, 69,
 25,194, 71, 56, 26,100,102,217,140,243, 89,236,219, 81,  7, 51,161,164,239,218,
177,212,243,166,179, 24,213, 31, 92,225, 17, 31,224, 18,136,  0,125,  0,135,  0,
211, 69,180, 36,203,227,103,229,189,247,255,143,162,141, 72, 66, 80, 65,216,219,
100,152,221,170,220, 93,223,201,156,  2,132,237,228,173, 23, 32, 19,151,  7,  2,
142, 51, 42, 91,214,220, 94,175,211,154,131, 96,246, 56,169, 36, 21,228,128,146,
 84,159, 54,233,209,118,134,188,156, 32,123,200,187, 20,163, 55,143, 16,217, 66,
197, 11,101, 77,176,216, 86, 25, 66,240,109, 15, 68,244,248,199,202, 64,134, 33,
 48,  0, 80, 44,183, 42,182,210, 11, 53,134, 75,167,230, 89,153,225,217,157, 54,
  9,133, 32,105,181, 10, 40,211, 42,  9,143, 68, 34, 72, 36, 18,243,211,227,193,
 77,214, 40,175,132,191, 46,113,222,255,208,249,171,154,132, 56,201, 21,148, 21,
 99,244,253,181,181,187, 87,218,125, 50,219,247, 68,210,245, 35,189,  8,144, 83,
183, 38, 83,103,182,119, 67, 83, 74, 26, 13,202,190, 61, 65,153,170,210,217,233,
150, 44, 20,214, 33,206, 31, 41,234,209, 29,122,182,141, 78, 15,199,223, 70,193,
233,185,213, 61,254,146, 99,216,189,169,139,158,116, 27,180,168,248,228,140, 78,
232, 50,167,119,246, 57,174,124,175,220,236,185, 41, 95, 57, 12,121, 17,123,219,
 15, 19, 22, 97, 54,217,229, 33,130,162,235,128, 80,189,147,207,222, 61, 71,214,
 14,118,201, 48, 26,205,162,192,224,176,201, 58,143, 65,206,236,247,187,105,106,
233, 25,136, 44, 67, 81,183, 18, 99,170,164,235,213, 31,159,170, 83, 40,210, 49,
141, 99, 43, 57, 16,158,244, 58,245,199,155,234,129, 99,191, 11, 17, 12, 45,101,
253,117, 70,185,126,171,188, 86,195,158,133,191, 90,129,193,157,141,113,174,179,
103,246,157,116,251,164, 49, 63, 41,125,217,167,101, 95, 71,255, 29,196, 28,119,
174, 79, 96, 46, 13, 10,218,197,167, 85,180, 13, 38, 33,218,120, 81,212,193, 30,
 80,102,116, 13, 79,237, 43,141,125,239,246,231,151,206, 95, 15,231,182, 74, 14,
 67,249, 74, 65, 35, 49,251, 31,158,151,147,164,138, 84,148, 96,221,173,202,243,
 67, 49,236,  2,210, 25,108,239,243,142, 73,236, 50, 81,227,176,193,104, 34, 54,
 15,153,229,215, 39,199, 56, 54,172, 16,  8,202,173, 49,232,149,183,237, 93,202,
181, 69,117,180, 36,216, 68,113,112, 92,  8,  8,216,175, 41,234,154,155, 28, 16,
117,112,159,228,202,185,199, 30,160,204,175, 79,247, 81,250, 68, 70,123,244, 13,
190,146, 11, 61,143,236,169, 55,129,  3,168, 97, 45,100,102,130, 25, 17, 73,146,
130, 74,134,  3,113, 12, 49,136,106,105,153,  7,226,136, 60,198,179, 16,177,136,
 53, 68, 64,  2,145,145, 25, 17, 82, 82, 82, 80, 80,144, 98,198, 25,214,153,145,
 77,240,144, 60,194,210,  3,240, 16,180, 57, 19,139, 79,106,112, 31, 22,164, 92,
207,126,223, 70, 61, 82,196,133, 59,243,223,223, 29, 30, 71, 22,239, 98,134,229,
109,139,222,163,139, 70, 82, 22,164, 99,190,144,145,120, 86, 38, 59, 91, 34,168,
126, 34,214,187,145,139,  5,113,179,160, 44, 62,239, 74,107,  5, 57, 39,169, 44,
218,178,220, 22, 79,138,187,223,168,252,233,107,141,207, 79,162,240, 47,122,151,
169,222,132,148,185,131, 74, 92, 63, 52, 55, 87,  0, 90,214,  2,161, 45,127,204,
199,179,113, 53,243, 76, 40,215,105, 93, 73, 78,159,124, 48,254, 65,210,145, 95,
165, 30, 97, 36,252, 86,202, 57, 38,240, 36,108,232,231,117,172, 68,209,131,108,
 78, 25,101,206, 11, 77,200, 66, 83, 84, 28,232, 53,187,170,170,152,149,138,232,
181, 51, 53,136,133, 37, 38, 35,114,235,108,239,202,  1,174,138,122, 21, 35, 27,
107, 64,144, 59, 13,102,173, 58, 85, 71, 64,  2, 76, 11,222, 32,187,144, 83, 12,
106, 74,  3,  4, 72,141, 64, 71, 69,195,244,190, 50,130,  4, 62,246,149,177, 97,
 86,147, 89,193, 12,  4,  4, 20,123,204,146,186,114, 73,225, 29,176,196,255,155,
154, 55, 14, 40, 42, 23,131,135,161,193,151,164,217, 10, 15, 58,179, 96, 64,200,
231,228, 91,163,152,  6,218, 42, 24,113,248, 75, 30,224,116,189,241,225,103, 72,
188, 28,253,154, 25,210,107, 51,104, 23, 80,104, 53,204, 90,144,201,162,  9, 64,
214,220, 96, 52,  0,  9,158,132, 86,227, 30,241,113,189,  8, 50,  4,  2,213,100,
154,216, 58, 82,197, 59,205, 13,220,105,193, 64, 35, 51, 98,161,  2,148, 66, 26,
106,214, 97,189, 98,226,154,254, 88,118,  2,174,217,202, 72, 12,165,148, 67, 95,
116,213, 37, 14, 13, 81, 13,155, 29,162,180,105, 38,  7,105,198, 60,238,113,139,
107, 89,245,173,165,144, 30,136,224, 50,119,231, 12,219,177,154,144,210,208,243,
 69, 25, 93,159, 61,115,116,245,246, 93,136, 69,108, 77,  3,123, 73, 85, 51, 97,
 50,169,168,127, 67,  2,171,190,202, 61,124,219,  0, 37,250, 87, 79,247,140,198,
  2,220,236,177, 11,102,231,166, 57, 39, 95,223,195,134, 53, 93,121, 45,191,235,
128,136, 58, 88,160,180,253, 91,208,141, 78,158,209,126,247,220, 60,102, 17,104,
  9,229, 82,102,252, 52,167,  8, 69,114, 63, 64,131,102,244, 51, 19, 94,166, 60,
142, 41,125,232, 45, 98, 55,132,148,234,129,117,  2,
} ;

// ../Source/Template/GB_AxB_saxpy3_fineHash_phase2.c:
uint8_t GB_JITpackage_32 [1562] = {
 40,181, 47,253, 96, 83, 25,133, 48,  0, 86,249,168, 40,208,210,170,  3,106, 50,
 90,237, 98,183,121,139,167,215,173, 49, 23,187, 35,253, 14, 17,200,241,107,107,
136,  2, 26, 47,208,185,226, 15,174,240, 20,131,248,  5,160,  0,146,  0,159,  0,
 28,213, 73,167, 61,249,205,242,171,191,176, 56,183,249, 92, 17, 47, 76, 25,148,
 37,101, 78,121, 53,246,187,255, 63,  4,210,  1,161, 76, 42,201,118, 90,252,176,
 91,224, 50,199, 61,119, 99,144,108,157,171,177,131,132, 34, 33, 98,178,173,  8,
220,186,157,215,238, 48,184,115, 41,177, 83,150,138, 82, 73, 12, 42,148,234,147,
 38,157,170, 44,138,  9,159, 96, 31,117, 77, 67,252, 57,229,193, 28, 48,221, 23,
193,  5,107, 43, 24, 63,207, 54,135, 30,200,169,159,154, 86,139,242,147, 76, 62,
231, 93,179,198, 65, 42, 29, 35,128, 93,153, 91,213,214,216,125, 89, 87,227,102,
 39,115,153,101,244,109,196,154, 97, 54,176, 12,179,240,129,  1,136,100, 96, 32,
 43,106, 15,164, 26,167,219,227, 71,114,210,175, 70, 89,190, 29,187,118, 61, 41,
 87,112, 69, 93, 75, 86, 98, 76,174,175,212, 44, 20,183,165,218,115,235,130, 31,
103,219, 26,190,233,220,104,215, 27,250,100,242,183,222, 78,251, 72,202, 56, 41,
247, 71, 63,163,118,206,189, 26, 67,223,238,  3, 58, 95,131,206, 95, 42,203,104,
139, 11,202, 88,109,136,251, 93, 65,230, 14, 82,238,115,183,158,207,241, 41,218,
  8,146, 83, 38,150,201,100,194,193, 50,114,243,228, 87,254,198,230,159,240,  8,
244, 83, 85, 37,194,252,133,154, 70,183, 25,191,173,167, 81, 57,195, 91,220,169,
159,242,235,122, 55,  5,151, 79,181, 25,148, 93, 97,227,193, 54, 87, 83, 89, 63,
234, 47,180,219, 12, 41,183, 33,120,249, 86, 25, 57,174,187,164, 20,180, 18, 20,
123,242,249, 35,176,231,114,149,116,121,245,200,167,234,  7,  7,159, 42, 17,150,
164, 95, 25, 11,252,186,131,  4,135,219,110,109,155,114,252,143, 61,222, 32, 25,
156, 53,120, 48, 78,214,144,209,108, 50,220,110, 28,  3,176,132,177,199,216,193,
229, 13,198,174,217,117,236,123,103,  4,  5, 61,249,  2, 93,190,225,228,158, 84,
251,196, 49,189,232, 97, 94,134,121, 28,189,247,141,221, 22,131, 66,147,240,192,
144,101,120, 25, 38,251,104, 22, 62, 69, 34,219,220,236,224,152,239,151, 75,150,
 69,153,128,180,181, 16,200,199,134, 50,138, 14, 82,  6,191,211,249, 14, 65,175,
 96,220,239,139,175,166,198,206, 79, 20, 72,117,144,158,114,113,183,192,157, 26,
 52, 64,250, 74,238, 52,110, 57, 69,117, 32, 62,154,142,196, 39,  2,203, 92, 60,
 58, 44,141, 67,180, 35,221,216,170, 48,101, 81,174, 74,117,  4,132,138,138,  4,
 44,195,192,129,248, 96, 29,255, 52,109, 91, 35, 72,178,147, 94, 94,121,228, 21,
110, 25,134, 32, 12,157,137,139,244, 79, 71,227,241, 96,205,151,114,134,145,202,
223,218, 42,183,127, 69, 54, 54, 83, 95,243,193, 18, 34, 36, 50,138, 77,179,181,
 29,183, 47, 60,197, 77, 31, 94, 92, 16,244,201,195,131, 50, 93, 18, 40,130, 24,
215,185,119, 80, 76,105, 58,  1,129,119,168,129,177, 66, 70,102, 70, 68, 36, 73,
 82, 40, 12,  7, 81,  8, 66, 16, 36, 33,120,230,  1,178,160, 40, 13, 98, 24,  7,
 49, 66,  4,144, 16, 74, 68, 68, 36,176, 64, 36,152, 36, 65, 11, 10,154, 52,  6,
 89, 96,199, 76, 46, 11,103,152, 40,199,142,238,214, 81,255,196, 61,229, 50,151,
 18,202,148, 67, 51,101,160, 37,102, 70, 85,150, 37,168,229, 38,127, 22,242, 43,
104,173, 72,  9,250,150, 43, 63,199,180,  2, 60,  8,149, 72,207,  1, 45,158,231,
203, 35,234,193,237, 73,  6,156,249, 45, 57,156,204,127,161, 25,186,240, 21,144,
136, 54,148, 69, 85, 37,178, 66,212, 66,143, 43, 16, 91, 14,222, 93,178,211,144,
144,170,161, 21,187,236,242, 10,242,245,145,167, 45,210, 51, 41,  6, 49,254,197,
213,226,171,191,147,101,100,  4,235, 33,169,220,245, 29,177,  6,216, 55,160, 40,
 42,240,157, 20,200,163,216, 13,219, 10,114, 25,148,  7, 13, 25, 54,111,226, 70,
141,168,253,105, 29, 21,221, 94,234,204,159,  1,102, 53, 38,146,175,164,232, 95,
 26,124, 18,184,165,  3,202,131, 36, 74,161, 10, 98,142,125,158,  3, 52, 53,227,
176,163,185, 33,173,177,102,180,135, 91, 82,110,148, 98, 70,113, 51,159, 22,213,
139,149,249, 84, 26, 80,221,189,176,111,213,187, 72,192, 22, 58,150,195,190, 32,
160,149, 12,136, 36, 13,124,232,129, 98,136,106, 60,161, 23,107, 56, 40,202, 65,
241,190,131,130,188,128,127, 98, 98,251,166,161,230, 65,158, 53,252,236,235, 90,
157, 20,134,251,  1,236, 30, 78, 18,217, 42, 30, 43, 73, 43,100,165,211,221, 46,
 26,170,114,  3, 50, 76,189, 73,145, 94,141, 81,103,178,251, 53,104,113, 49, 50,
 21, 67,216,137,172,147,249,193,241,142,172,219,180,248, 78,127, 13,225,103,163,
 80,251, 86,135, 75,  3,176,121, 94, 50, 46,126,228,144,142,199, 82,219, 18, 14,
 13,179, 85, 75,254,122, 59, 61, 56,220,124,195, 53, 50,107, 84,  8,209,161,212,
140, 55, 32, 26,154, 78, 65, 43,136, 44, 28,113,235, 10, 10, 76,151,248, 66, 35,
167,116, 69,191,176,163, 96,229,245, 30,152, 35,207,106, 89, 44,146,175,252,229,
 39, 34,240,217, 81, 60,144,217,146, 26, 11, 71,139,101,171, 40, 41,150,217,108,
179,105, 89,129,116,191,143, 27,140,233,223,186,101,106,176,142, 11,179,112,165,
225,240, 62, 72,185, 16,158, 31,231, 77,248, 85,250,145,244,236,158,211,  7, 62,
175,221, 27, 70, 57, 45,176, 38,170,150,172, 81,163, 38,232,120,212,182, 75, 18,
194,192,108,110,112, 45, 59, 14,188,168,255,251,139,212,110,202,164, 92,196,121,
201,229, 33,254,152, 82,148,127,171, 39,104,145,240,145,131, 88,  5,227, 12,  8,
 24, 86,245,247,178,211,216,151, 11, 32,  2, 20,176, 81, 43,132, 47,224,236, 99,
 10,156,  2,220,196, 32,132,  6, 43,  8,242, 56,  4,252, 83, 95,155,139,243,218,
197, 18,  4,239,  2,249,142,  9,250,187, 89,215,106, 66,141,165,237,  0,136,240,
147,239, 20, 64,207, 86,133,108, 96,156, 64, 68,173,220,162,163,243, 96,118,101,
 79,122,173,182,192,236,160,217,133,145, 14,108, 42,223,131, 61,220,217, 17,129,
204, 52,109,105,104,144,140,132, 81,148,176, 94,  5, 41,148,209,203,177,219, 27,
221,182, 76,169, 37,111, 45,141,136,  3, 54,127, 63, 90, 89,129,201, 34,117,191,
252, 82,193, 54, 40, 84, 86, 65,111, 91, 57,145,222,135,  0,240,194, 40,193,151,
224,132,108,208,122, 25,134,173, 48,113,167,205, 65,234,227, 75,146,173,161,218,
 95,229,149,243,141, 80,194, 21, 68,160, 35,168,122,115,145, 68,166,  7, 29, 16,
185, 10,  5, 37,214, 34,122,132,192,205, 43, 85,155,144,173,161, 95,244, 32, 27,
232,184, 50,198,116, 30,187,120,218, 26, 92,123, 15, 96,211, 87,199, 99,173, 31,
 80, 72,240,209, 15,230, 64,147, 21,243,  9,160, 68,132, 61, 79,157,  3,201, 57,
 92, 14,154,162,159,153,206, 37, 69,119,146,173,210, 36,130,230,135,164, 40,117,
  0, 77,
} ;

// ../Source/Template/GB_AxB_saxpy3_template.c:
uint8_t GB_JITpackage_33 [3860] = {
 40,181, 47,253, 96,225, 92, 85,120,  0,202,105,156, 19, 46,192,172,140,115,247,
168,184,  9,182,237,182,  3,212,250,210, 78, 67,163,109,194,130, 50, 64,199, 17,
248, 25, 56, 10, 51, 33, 11,  0,192, 71,182,125,226,193,117, 21,  5,219, 54,112,
  1, 47,  1, 48,  1, 32,  1, 92,153, 44,210, 43, 15, 26,165, 31,182, 26, 79, 27,
 27,151, 42,141, 20, 15,122, 50, 22, 78,110,183, 63,156, 11,133,  5,230,151, 14,
231, 81,116, 98,220,116, 50,209, 66,109, 71,203,121,246,196, 69,195,185, 52,136,
158, 12,  3,140, 47,172,  3, 88, 62,221,159, 15,130, 44,179, 88, 44, 14,205,201,
 90,200,202,178,107, 39,181,166,137,137, 10,205, 43, 14,233, 30,206,165,211,121,
 15,231, 32, 32,213, 43,231,170, 95,171,235,181, 92,  7,252, 70,  2,  6,238,236,
138,178,156,122,167,224, 47, 95,252,255, 23, 22, 40,112,118,249,  2,144,217,110,
118,  0,206, 87,167, 89,179,  3, 44, 44, 68,106,102,111,251,213,185,114,150, 65,
 89,230, 70,247,162,174, 87,110,191,166,252,197,236,218, 27,219,143,166,196,110,
249,118,220, 70,173, 91,145,133,134,200,  4,194,153, 37,185,119, 74,229,198,250,
 78,190, 50, 16,182,147,173,158,128, 60,136,160,136, 92, 28,170,108,153,115,123,
179,139,230, 92,211,222, 41,135, 73,195,  4,114, 64,210, 48,249,100, 73,167,108,
135,100,196, 35,239,163,236,210,173, 61,167, 58,111,194,146,113,178, 74, 80,216,
 86,201,117,248,118,215, 89,184,104,118,121,251,101,135,238,168, 20,  2, 38,168,
 78, 89,  6,188, 74,117, 10, 95,169,113, 27,223,232, 48,226, 68,210, 70,139,232,
 69,139,196, 25, 24, 22, 32, 12, 12,  1, 24,166,187,144, 91,107,241, 87, 82, 13,
139,200,108, 52, 27, 24, 39, 14,213,130,216,169,152,160,192, 84,152, 74, 66,147,
225,100, 96,230, 81, 68, 11,205, 99, 16,161,217, 84,151, 78,228,108, 22, 68, 79,
244, 92, 36,168,204, 34,221, 18, 49, 24,146, 63,226,173, 22,110,170, 76,106, 67,
242,218, 78, 34,178,237,178,184, 73,182, 56, 20,145,  0,225,158,206, 43,  7,129,
 42,189, 92, 87,203,242,245,199, 99, 62,129, 52, 73, 40, 57, 71,151,196, 90,119,
113,102,217, 79, 83,178,151,228,154,221,168,177,166,201, 95,110, 23,178,114, 87,
 71,172,213, 27,189, 82,132,177,220,105, 50, 52, 77, 24, 20, 69,170,164,107,204,
121,202,130,200,236,211,235,244,102,151,210,202, 94, 80,165, 25,231,173,155,167,
 76,152,171, 88, 44, 22,139,229,189,247, 60,158, 71,225,128, 16, 66,  8,239,100,
110,131, 16, 66,184, 65, 64,182,223,200, 26,109, 35, 46, 19, 22, 88,  1, 33,132,
 16, 66,  8,167,137,162,160,139, 32, 43,161,244, 73,242, 68,  8, 33,132, 16, 66,
 56,189, 65,231,193,184,209, 56, 30,160,130,228,144,111,125,133, 68,162,110, 11,
 10,210,177,  6,155, 89,153,137,250,156, 69,124,147,227,  2,  4,124,122, 79,146,
172, 42,217,198, 81,149,179, 82, 44,130,232,197,218,103,235, 48,222,123,239,189,
247,222,123,239, 61,249,222,123,239,189,135,245, 53,  3,167, 64,179,203, 40,170,
146,184,234, 24,253,214,217,173,179, 78,221,217, 17, 96,112,168,192,224,192,232,
141,147, 30,222,127,188,114,200,177,157,124, 49,112, 55,251, 78,142,  8, 17,114,
127,252,131,161,201,218, 97, 42, 95,219,105, 90,135, 65,176,134, 88,201,192,150,
212,184, 56, 31,142,193,232,  6,213,  5, 83,205,142,206, 73,  2,153, 70, 83, 74,
119,202, 16,107, 92, 43, 95,204,137,166,117,198,173,116,244, 57,118, 74,239,105,
101, 13,219,109,207, 42, 24, 55,215, 89, 22, 61,118, 42,155, 28,106,137,  6,234,
226, 91,217,206,150, 80,146, 71, 75,159,148,164, 34, 29,203, 76,218, 87, 94,121,
229, 47,174,244, 98,244,125,209,197, 86,126, 32, 18,219, 19,  3,217,111, 99, 61,
 47,218,254, 90,201,218, 39,141,253,145,  9,163,178, 75, 51,238,169,189,173,113,
153, 37, 47, 14,182, 16,  2, 38,160,128,155, 42, 74,  0,172, 72,164,142, 97, 23,
 91,203,150, 37, 63, 35, 20,135,  8, 60, 70,127, 77,230,248,202, 60, 19, 73,164,
178,149,214,225, 43,103,183, 89,122, 68,114,  9,111,125,127,173,100, 84,159,193,
243,178,130,142,201,225,149, 74,111,208,100, 55,129,111, 71, 20,  8, 27, 90,130,
151, 38,251,246,236,182,159,204,159,247,169,139, 65, 22,213,102,119, 74,131,132,
134,240, 11, 11,191,253,139,177, 54,154,242,129,239,  5,213, 54, 54,238,128, 19,
143, 83,225,169, 42, 56,158, 78,140,152,152,173,116, 76, 95,182,  5,232,212,144,
238,233,104, 44, 50,241,194,121, 19, 85,100,170, 45, 57,170,210,121,106,242,197,
197,182,251,165,154, 72,  6,213,248,243, 56, 32,218,107, 54,232, 14, 35,109,210,
 95,124, 49,207, 75, 71,115,137,136, 23, 79,  5, 53,186,221,191,154, 78,186, 85,
169, 89,124,189,202,112, 46, 26,233, 23,104, 14,152, 84,  9,153,211,181, 82,  3,
 81, 64,243,154, 29,197,164,199, 35,193,195, 43,212,104, 59,228, 16, 16,150,154,
 28, 46, 64, 42,240,120,112, 46, 24,207,147,120,168, 32,210, 45, 40, 42,  6,153,
135,168,130, 80, 70,220, 31,175, 56,  8,239,234,241,232, 39,120,120,229, 21, 69,
 73,215,108, 50,158,140,231,154,220,167,186,226, 14,185,  4,201, 67, 99, 98, 88,
179,  0,  8, 84, 29,242, 56,218,126,109,114,148, 72,217,216,144,172, 90, 85, 85,
119,229,147,  5,103,  3, 47, 48, 46,216, 68, 79,197, 70,250,212, 90, 98, 23,115,
197,206, 85,242,168,210,141,183,142,118, 58,151,170,170,232, 84, 28, 19,197, 93,
189,167,216,106, 18, 59,101, 17, 73,156,138,162,254, 96,179, 79,177, 89, 27,108,
174,  4, 11,194, 57, 13, 81,213,213, 89,147,108, 59,131, 66, 38,157,212, 86,206,
174,188, 56,101, 21,168,236,224, 84,132,104,168, 51, 89,115,208, 57,167, 76,146,
 36,169,209, 26,179,145, 16, 16, 22,150,139, 71,115, 57, 73,206, 15,147, 17,226,
 32, 45, 20, 16,161, 65, 12,142,112, 28,195, 48,  8,136, 49, 70,192,  4,132, 16,
 66, 40, 33,136, 12,201, 32,117, 14,184,158, 46, 63,252, 32,125, 64, 26, 67,178,
135,204,121,223,116,154,201, 11, 53, 52, 80,121,237,255, 48,136,144,243, 55,153,
209,154, 90,243,113, 93,123,165,194,120,228, 79,187,198,172,  5,239, 57,184, 30,
112, 83,206, 56,254,134,188,172, 73,  1, 53,  1,131,233,156, 57, 52,131, 11,235,
  2,145,174,  1, 92,234, 78,178, 20,255,149, 74,147,214, 88,180,230,  3,206,128,
 47,187,249, 53,203,251,219,180,155,255,136,221, 32,171, 55,  7, 38,103, 45, 47,
 89,251, 23,203,133, 37, 65, 67, 54, 45, 91,182,251,181,176, 66,141, 37,116,123,
 53,219,195, 12,207,101, 25,231, 27, 33,  4,100,201, 74,130,136, 98,199,193,182,
 34,122,108, 36, 36,178,151,201, 20,146, 35,214, 91,237,196,106,244,214,202,241,
242,141,225,169,230,207,253,149,240,120, 14,235, 21,242, 98,203, 30,  2,  3, 43,
118,180,166,171,105, 94, 77, 92,161,255,133,228,174,202, 19,171, 76,163, 96,185,
134,135,199,187,122, 93,  5,222, 71,254, 42,244,107,251, 42, 53,183,179, 74,140,
 27, 60,100, 25,235,249,226, 76,254, 67,203,  9,210, 89, 84,  7, 99, 63,230, 26,
141, 63,166,114,248, 48, 88,208, 91, 36,  6,143, 57, 50, 11,177, 10,111,189, 18,
165,190, 31,252,161,131,195,124, 15, 39,116, 85, 70, 67,108,174,132,223, 17,173,
204,205,179,224, 41,142,130,119,123,232,158, 11, 23,209,153,218,185,195, 24,227,
154,226, 99,164,195, 61,141, 36,185,208, 86, 83,128, 45,207,109,145,171,116,134,
 44,212,  8,191, 31, 68,138,230,236,101, 30,112,241,201,197,232, 14, 80,243,172,
 59, 31, 94,  7, 67,113,239, 27,  9,140,157,155,114, 26, 26, 80,123,105, 91,244,
101, 78,199, 33, 98,120,233,203, 68,185,105,166,138,247,125,216,241,143,224,229,
 32,107,234, 92,192,168,148,145, 64,150,195,  4, 42,139,235,153,116, 63, 82, 42,
216, 88,218, 74,250, 71,141,145, 28,  0, 58,134,218, 45, 42,219,172,130,227, 47,
128,198, 50,211, 52, 10,  5, 15,  7,233,242,138, 83,189,230, 84, 98,117,132,  1,
 14,184,178,111,197, 36, 51,170,194,102, 29,186,239, 81,240,158, 79, 12,160,147,
  7,182,  7,203,230,201,105,140,228,144,216, 46, 46,181, 76,124,200, 15, 15,167,
  6, 86,195,153, 46,151, 74,199,100,203,130, 68,212,242,158, 32,200,156,116, 53,
 92,  2, 54,255,116,229, 95,185, 39,105, 34,126, 39,224,141, 23,156, 61, 19,241,
239, 65, 37,146,117,172,206, 12,195,151,231, 73, 76,246,171,199,124, 50,120,191,
 18, 40,197,238, 51,139,184,101,231, 67,146,135, 60, 13,186,161,167,163, 39,124,
245, 65, 39, 75, 59,147,  9, 54, 87,161, 98, 98,133,117,241,249,251,122, 84,105,
230, 54,100,209, 94,232,120,233, 81,136,153,  2,199,  9,138,199,169,127, 82,121,
 75,197,113,  5,  4, 99, 49, 58,180, 73,247,  0, 63,170,185,248,230,240, 91,113,
203,114,109,153,183, 20,172,139,143,251,  1, 15, 83, 16,  8, 25, 68, 47, 67, 59,
234,126, 32, 64,229,205,185,222, 48, 76,104,159,116, 20, 96,203, 70,207,176, 67,
 79, 30, 17, 10,164,246,235, 11,142, 29,  3, 36,212, 22,111,128,214,240, 22,157,
137,246,176,164, 70,178, 47, 44,181, 80,237,183,153, 91,  4, 58, 79,194, 18, 48,
  9,115, 29,141,116, 56, 19,  6,103, 33, 93,191,202,195, 73, 97,140,147,147,199,
 71,191, 31, 39, 28,223, 11, 18,220,  5,142, 78,  7,  8, 52,221,212,217, 49,133,
 89,131,194, 64,244, 16,144,152, 68,231,210,158,203,116, 49,184,222, 67,212, 69,
 60,173,116, 61, 76,233, 37,246, 77, 17,231, 16, 56,241,129,110,239,203,103,134,
 81,225, 48, 30,198,121,224,191,186, 68, 52, 38, 78,104,116,149, 17,183, 34,204,
163,228, 48,124,244, 32, 82,126,137,170, 47,113,107,103,246,246, 18,236, 49,207,
131, 50, 95, 63,198, 66,178, 46,189, 46,200,165, 58, 71,124,127,147,149, 35, 93,
166,198,163,239, 88,127,219, 71,183, 49, 40,210, 38,139, 67, 18,170, 67, 18,102,
  5,177, 40,173,136,254,129,164,  4, 57, 77, 41,212,233,237,132, 37,209, 33, 75,
 64,177,185,204, 33,145,  4,170, 58, 24, 61, 64,108, 33,156,233,255, 10,  0,128,
198,206, 43, 92,227,221,109,133,208,197, 78, 84, 12, 35, 86,172,122,148, 16,140,
186, 95, 79, 12,203, 47, 73,199,120, 73, 46,117,199,205,106,121,156, 90, 24,249,
184,104,129,182,117, 53,124,132,238,144,213,222,107, 88, 15, 84, 66,165,219, 14,
 30,216, 24, 31,164,186,106,191,127,170,110, 42,158, 34,233, 82,154,  5, 59,215,
248,157,105,127,119,248,141, 66, 50, 86,213,166,129,154,  0, 19,130,175, 74, 65,
 71,165, 66, 81,  3,237, 94, 24, 63,186, 80, 57,240,122, 14,143, 24,228,111,240,
 84,  1, 24, 73, 69,  4,190,106,141,150,129,120,130, 36, 18,112,146,115,141, 64,
 31,202, 63,115, 90, 80,214,  6,  0,164, 16,178,  8, 63,152, 59, 96, 48,  2,205,
 72,224, 12,175, 76,153,225,129,173,163,229,144,130,248,207, 19,242,116, 99,118,
119, 27, 37,113, 76,120,138,142, 61,116,115,  7,204,187,142, 47,243, 58,218,205,
 27, 44,226,122, 31,232,  6, 16,179,184,203,178,207,131, 19,234,127,155,  3,102,
 30,168,170,106, 61, 35,159, 46,245,171,218,  6,195,109, 56, 94,178,141,103,205,
142, 18, 15, 81, 89,105,  7,164,146,  6,186,220, 30,173,151,105,161, 59,174,227,
 52,107,255, 89,253,170,  0, 82,253,106,147, 50,109,214,  8,195,189,211,125, 61,
 10,130,219, 19, 75, 75,140,109, 76,182,236, 82,233, 13,122,242, 84, 21, 15,228,
 78, 51,220,216,116,206,  1, 51,148, 57,249,114,155,230,223, 59,206, 26,209, 13,
100,190, 79,198, 24,139,236,115,251, 38, 85, 57, 92,250,139,216,125,144,186,136,
 23,221,202, 98,136,242,109,130,143, 55,166,131, 35,245, 53,200,143,193, 70, 40,
126,225,158, 99,114,154,175,219, 69,203,193, 19,109, 14, 60,119, 86,182, 89,106,
 15,247,  0,207, 85, 65, 52, 21,170, 26,169, 63,230, 42,110,206, 83, 38, 85, 66,
238,254,193,138, 26,  0,206,230,142,186,107, 60, 57,200,213, 15,209,135,253,237,
 57, 20, 51,158, 19, 40,220, 39, 90,225,246,227,179, 28, 41,148, 75,124,218, 55,
 53, 77, 25,164, 83,216, 75,228,  6,180,110, 68,110,215,220, 48,209,176, 92,137,
237,137,  3,146,247, 35, 70,145,106,104,119, 54,158,140,225,187,194,164, 22, 25,
132, 42, 77, 49,245,133, 10, 32,169,134, 36, 52, 86,  2,214, 56,202, 69,169, 28,
 90,242, 51,131,250, 97,  8, 60,  4, 69, 98,180,207, 21,211,114, 49,138,116, 18,
  2, 77,135, 12,179, 86,100, 64,  0,113, 14, 18, 27,133,  0, 54, 49,154, 62,243,
 26, 63,192, 45,140, 15,133,151, 36,  6,252,  3,164,143,144,100,212, 48, 71, 61,
196, 84, 22,233,251,172, 35,136,168,243, 44, 73,135,108,190, 48, 36,112,133,249,
 24,  2, 40,236, 41,121, 13,220,153, 24, 73,178,202, 70,197,170, 74,116,141, 34,
 98, 82,249,121, 21,138,140,242,201,243,124,119,214,172, 65,189, 34,189, 47,169,
187, 65,223,203,170, 37,141,202,184,253,108,133,183, 40,200,227,189,177,155,217,
 58, 25,151,236, 59,229, 40,186,246,105,167,129,157, 93,164,186, 95, 34, 96,232,
219,144, 34, 27,102, 34, 99,190, 27,205, 96, 98,  3,203,167,150, 19, 59, 33,191,
 73,190,215,182,118, 86, 48,195,109,200,102,102, 50, 29, 46,182, 50,148,153,140,
 62,112,193, 42,204, 48,224, 60,163, 43,173, 11,255,198,179, 11,208, 79,169,219,
 87, 37, 43, 19, 59,117, 23,152,191,202,201,229, 88,  9,254,109,  3, 74, 77, 96,
 74,213,178,213, 16,161,166, 51,188, 53, 65,190,198, 67, 93,149, 35,134, 50,180,
  4,  7,129,188, 76,208,169, 15, 25, 80, 52,141, 63,230,  1,130,  8, 10, 39,106,
129,217, 24, 13,147, 70, 22,119, 53,246,197, 44,154, 30, 72,144,167,212,235,251,
255,155,  1,129, 36,227, 22,237,132,104,120,148,141,253, 80, 37, 84, 34, 45,122,
128,243,182,154,159,217,176, 98, 40,253, 71,207,214, 57,158,131, 18, 82, 50, 14,
 55,175,193,155,195, 50, 13, 48,128,244, 74,235, 32, 12,103, 17,240,239,139, 74,
 30,115,103, 59,  2,172,249,127,109,130,206,176,242,110,227,123, 55,108,121,116,
243,  4,229,  3,161, 66,104,153,244, 39,145,227,106, 20, 41,131,217, 43, 43,222,
  5,184,206, 80,124,113, 97,183,232, 99,  3, 16, 83,169,159, 20, 50,170,162,232,
195,111,255, 61,  0, 18,176,217, 72,123, 35,148,113,149, 24, 64, 47,202,166,132,
121,103,215,  1,116, 88, 97,  4, 45, 68,  4,178,218, 93, 12, 13,137,101, 63,102,
 90,176, 73, 38,164,165, 74,249,211, 27, 22,109,177,195,171, 34,156, 24,133,141,
 68,198,216,220,221,167, 94, 91, 27,151,154, 44, 97,251,114,  9,204,181,131,250,
 55,254, 35,107,171,219,157, 49, 44,182,242, 43, 61,143, 51,245,116, 95,168,222,
158,246,235,216,242, 31,104,  8, 73, 96,165,191,199,241, 11, 13, 34,138,172,188,
114,120,242,103, 64,127,162, 99,113, 34, 77,185,115,190,112,188, 42,225,224,136,
 91, 22,163, 25,170,112, 31,  2,182, 87, 13, 82,202,181,201, 50, 29, 87, 29,215,
 58,184,232,246, 20, 58,185, 58, 32,  6,122,109,149,121,197,252,247,195,177,252,
198, 24,166,105,191, 56,  0,  2,144,248,127,242,107,231,168,147, 61,230,106,143,
228, 53,145, 73, 72, 83,197,134,153, 31, 36,238,159, 99, 17,  1,129, 74, 22, 10,
188,218, 72,101, 32, 33, 33,212, 42, 21,242, 26, 69,154, 63, 63,223, 16, 92,219,
224, 43, 26,  6, 20,139,139, 47,247,176,164,163, 47,167, 39, 65, 31,103,208, 79,
200, 38,153,166,134,175,237,190,114,214, 57,  1, 65, 17, 68, 95,182,193, 27, 87,
 64,166, 88,  3,121, 39,  2,178,117,186,196,246,202,120,102, 71,104,129, 51,105,
208,235, 50,241,  8,  6, 78,206,  3, 84, 93,110,106, 55,185, 88, 61, 21, 51,115,
146,160, 32, 90,252, 94,144, 60,  0,202,135, 38,166,161,137,179,172, 60,152,101,
238, 43,227,178, 59,109, 97,196,198, 77,103, 48,116,122,152, 17, 43,101,148,152,
202,173,224,110,114,187,178,157,237,143, 19, 94,164,101,244, 20,229, 30,146,  2,
198, 99, 64,166,  9,167, 88,123, 49,120,141,172,100, 21, 78,213, 73, 69, 17,108,
161, 46, 34,193, 33,191, 29, 59,206,195,  4,245,108, 28,122,144,143, 69,248,103,
255,198,253,  7,198,125, 67, 54, 12,140, 94, 31,131, 18,213,150,204,236, 66,130,
 25,  9,241,179, 93,240,147, 21,189,191,133,197,132, 69,102, 99,158, 16,124,130,
 43,114, 60, 11, 74,173,224,144, 85, 48,185,140, 34,226, 64,112,150, 43, 63,152,
173, 60,185, 41, 14,255, 66,156,141,132,146,226, 11,115,247,105, 35, 90,112,195,
168,144,131,240,103, 59,  8,251,248, 85,121, 33, 26, 72, 36,145,233, 55, 76,102,
236, 44,229, 57,217,  6,  4, 76, 50,172, 74,188,140,114,144, 25,138, 11, 91, 58,
  0,249,180,135,126, 55,189,214, 75, 38, 42, 76,188,179, 46,  5,181,146,  0,136,
 59, 29,112,238,121,232,171,107, 47,123,196,207,173,230, 56,219, 66,197,  9, 79,
 58,249, 41,207,  8,181, 76,123, 58,214,230,210, 57,173,210, 62,114, 75,  1,160,
247,211, 85,255,158,212, 44, 76,199, 69,179, 34,233, 74, 38,106,204,220, 14, 44,
 42, 16,112, 73,220,181,242, 60,250, 77,245, 68,201,133,130,120,139, 85, 10,  3,
 31, 24, 15,208, 74, 82,230,118,243,195,147,211, 96,136,243, 85, 23,125,194, 59,
 84, 32, 16,114, 70, 55,250,123,  6, 44,186,248,106,  7, 52, 54,205,253,186,204,
100,  6, 53, 66,255, 48, 33, 75, 63,154, 19,240,238,191,252,180,206,101,240,  7,

} ;

// ../Source/Template/GB_AxB_saxpy3_template.h:
uint8_t GB_JITpackage_34 [4518] = {
 40,181, 47,253, 96,156,116,229,140,  0,250,124,196, 22, 45,176,172,142,115,242,
172,209,203,118, 47,133, 14, 53, 84,106,169, 11,103,148,  5, 53,228,221,125,206,
203,105,203,159,194,141,154, 96,229, 53,203,125,248,167,244,167,193,217,241, 12,
 97,  1,104,  1, 93,  1,214,181,177,116, 58,176,194,185,  3,229, 26,214,109,215,
169,184,109, 17, 52, 89, 40, 50,112,115, 61, 40,223,152,161,237,218, 73,177,136,
227,147,229,104,251,251, 67,214,101, 65,121, 72,202,238,195,197,237,182,231, 15,
158,173,228, 87,152,156,106,104,248,251,211,170,233,213, 85,241,236,109,143, 70,
 99, 92,214, 31,103, 77,231, 58, 17,165,242,122,112,184,102,163,118, 97, 32,120,
 88,179,159,221,222,246,173, 59, 60, 76, 56, 85,153, 43,105,151,237,203,154,254,
153,188, 91,227,181,151,197,253, 94,  4, 34,238,236, 47, 68,248, 66,165, 93, 74,
 36,154, 30,189, 24,143, 78,133,158,100,178, 94,121, 68,207, 55, 86,190,125,122,
207, 92,185, 75, 66,151,117,117, 44, 20, 11,156,  5, 88,168,184, 44, 29,136,177,
176, 44,157,107,  0,134,197,  5,228, 92,213,197,135,179,249,233,  0, 11, 11,144,
 42, 30,254, 67, 95,186,109, 89,187,159,244,217,100,142,179, 95, 58, 79,179,179,
101,173,243, 67,176, 74, 63,183,147,246,237,217, 31,150, 88, 16,  0,129,120,176,
134, 69, 14, 94, 82,185, 63,125, 39,103,151,  7,219,201, 88, 99, 30, 23, 18, 22,
144,140, 71,149, 45,111,110,175,  6,234,205,165,132,127,  3, 32,  4, 64, 60, 10,
 68,  4, 64,156,194,166, 63,219,163, 40,113,  8,124, 73,187,116,235,206, 31,  7,
 98, 42,141,139,149, 66,194,182, 70,142,195,183, 59,206, 66, 70,181,203,219, 31,
123,116,134, 74, 17, 88,  7, 42,127,149,  3,164, 84, 46,209, 32,124,163,228, 54,
190,215,128, 18,167, 17,237, 85,105,192,171,162,248,195,195,194,227,225, 33,143,
116, 56,155,203,132,104,218,186, 41,  9,137, 36,211,172, 42,143,163,226, 34,142,
 83, 42,206,115,135,115, 85, 72,116,201, 51, 68, 34,  8,215,170, 39,152, 94, 61,
 56, 89,203, 50,171, 17,196,245,180, 98,113,187,109,202, 67,231,202, 26,233,175,
250,236,170,226,116,160,133,193,192,208, 85,133,184,210,  9,234, 63,234, 78,183,
108, 32,166, 98,145,184, 20, 92, 42, 27,203,  5, 99,113,233, 96, 26, 88, 23,231,
 98, 65,179,107,111,108, 31,185,151, 40,144,200,104, 42, 22,206,181,209, 76, 92,
157,201,187, 35,183,178,157,  7,158,241,217,239, 83,222,  2, 40, 92,139,108,168,
 55,134,203, 32,139,155, 30,234,235,234, 10,145,141,247, 20,123,172,224,192, 10,
235, 20, 42, 35,226, 56,  5, 10, 14, 16,220,205,190, 20,197, 16, 17, 49,  0, 49,
128,192,189, 34, 34, 16,147,255,239,247, 50,112,103,119,211, 45, 29,140, 42, 98,
 35, 38,185,178,139, 20,111,180,221,166,107,216,109,146,237,100, 28, 61, 25,107,
119,177,174, 94,139,193, 52,200,176,149,212,235,112, 96,133,130,242, 84, 21,197,
157,108,109, 79,147,218, 81,188,172,221, 79, 71,174,158, 55,161, 60,163, 47, 21,
  5,213,208,240, 12,139,131,112, 79, 70, 67,248,167,226,167, 34,167, 80, 40,135,
227,  7, 38, 19, 69, 77,167, 92, 67,195,250,189,150,171,195, 69, 53,110,207,226,
222,189, 68, 54,110, 83,198, 25,243,156,148,228,164,183,146,103,101,209,179,  7,
214,149, 39,131, 22, 48,150,204,198,178,224,234, 92, 20, 48, 22, 57, 43,170,148,
116,136,237, 40, 78,153, 43,221, 79, 30, 53,232,222,136,217, 75,238, 21, 10,127,
153,164, 27,183, 88, 96,116,120,210,236,189, 11,104, 61,100, 46,214,103, 63,174,
236,206,131,245, 70,111,124,236, 17,117, 95, 79,144,190,147,159, 49,199,158,207,
136,157,111,204,184, 78,226,162,201,104,172,123,138,227,146, 11,  9,139,  6, 87,
229, 98,105, 58,240,122, 48,201,102,215, 44, 61,241, 78, 18,150, 87, 42,149,137,
 68,  6,114, 87,239, 41,211, 73,146,210, 70,148,216, 95,229,142,119,101,122,228,
146, 64, 61, 38,157, 19,117,209,172,114, 30, 69,150,179, 39,126,136,140,147,246,
229,104,118, 91,146, 83,115, 43,181,151,100, 44,174,206, 70,163, 81, 81,169, 76,
 78,245, 95,133,155,238,112, 84, 42,167, 96, 63,240,254,228,  2, 38,172, 37,245,
108, 37,251,146,228,218,113, 87,118,150,235, 37, 20,153,203,230, 98, 89, 56, 24,
 25,  8,201, 88,122,182, 46,116, 27,159, 49,  8, 20,229,231,182, 39,149,201,217,
202,218,141, 87,197, 82,209,129, 84,168, 47,150,  1, 33,252,155, 14,101,196,154,
163, 84,190,242,237,232,103,204, 94,202, 34, 87, 25, 29, 38,154, 37,163,185,144,
202, 35, 38, 81,237,175, 82,142, 62,107, 58,233,246,218,179,207,182,139, 52,192,
 88,108, 52, 23,152,179,214,129,208,123,154, 69,110, 75,145, 36,227,189,132,250,
133,  5, 99, 97,105, 42, 15, 24, 54, 23,104, 49, 57,244,  4,207,183,227, 54,138,
 73,140, 51, 81,247,118, 73,169,199,234,134, 80, 20, 97, 20,193,  6,  8, 33,132,
 16, 66,  8, 41, 17, 20, 93, 48,163,170,232,171,184, 63,141,234,143, 18,137, 68,
 29, 43,183,228,250,202,110, 11,  0, 52, 72,118, 69, 68, 34,128,115,214, 73,108,
246,236, 36, 17, 17,216,177, 88,113,163,101,108,140, 57, 46,205,248, 44,155,200,
163,129,138, 56,166,201, 39,148,217,125, 38, 62, 36, 42, 37,253,216,108, 70, 78,
131,175, 97, 16,  8, 68,210,215,224,236,175,196, 97, 27,111,159, 94,186,220,198,
183,188, 81,140, 61,151, 86,222,120,150,211,185, 84, 81,235, 74,170,244,246,178,
113, 64, 77, 21, 19,144,152, 49, 22, 37,215,121,254, 62,146,237,237, 82,119,177,
120, 57,198, 52,184,178,118, 10,194,110, 87,140,179,182,179, 37,224,239, 29,  6,
  8,252, 65,252, 69,108,107,247,143,202,182,163,166,107, 80,236,239,189, 73, 79,
109, 52,153,139, 63,  6,150,137, 94, 66,226,  6,138,149,187,133, 53,153,211,100,
124, 39,111, 44,185,173, 31,230,109, 52,152,207,200,143, 99,177, 46, 29,  2, 17,
160,184,245,  7,147,145,235,101,239,228,217,167,164,123, 27, 33,  6, 84, 38, 42,
223,200, 21, 52,227,180,205,208,179,178,148,113,179,150,235,141,218,181,243,113,
141,183, 91,229,123,237, 82, 15,189,191,182,219,126,173,140,159, 43, 99, 39,129,
223,229,135,100, 44,194, 88,195, 30,219, 38,105,126,200,181, 77,123, 20,181,121,
123,163,215,110,147,254, 88,122, 58,154, 69, 42, 63, 19,  8, 36, 83,239,254,149,
 65, 60,187, 11,245, 54,184,233, 21,149, 11,203,197, 48,157,101,107,164,219,159,
100, 60, 65,109,109,204,100, 71, 53,251, 76,204,220,246,237, 60, 15,  1,229,192,
116,  9,154, 57, 54, 56,135, 63, 18,207,141,133,  4,168,  3, 42, 90, 24,100,204,
212,204,140, 72,146, 36,105, 12, 83,145, 16, 24, 18,  9, 76,  6,163, 65,105,218,
 62,243, 48, 67,249, 32, 38, 68,131, 48, 10, 97, 17,  6,129, 16,  6, 65, 88,  2,
 34, 32,134,  8,  8,129,132, 16, 74,136, 33,210,171,  3, 39, 56, 61,149,231,181,
 65,138,193, 95,  4,110, 84, 34, 78,251, 12,140,193,131,  8,179, 42,224, 37,131,
 70, 17,  8,153,228, 94, 86,175,224,249,208, 59, 89,197, 76,130,  1,135, 57, 29,
193,192, 90,152,216,188,  8, 25, 81, 19,117, 58, 37,114,176, 72,174,125, 33,249,
134,113,174, 72, 91, 34,104, 44, 46, 56,118, 43,133, 71, 47,255,221,207,160, 70,
 12,167,106,  8,189,119,227, 84,163, 16,130,241, 82,235, 35,132,146,130,218,168,
207, 92, 38,212, 10,249,191,160,221,234,188,168, 85,104,113,179, 92,  5,169, 59,
  4,241, 30,179,217,106,244, 47,110, 86,174,195,243, 30,172,154,206,  2,202,169,
236, 36,108,213,102, 87,102,215,236, 47, 67, 72,230,156,210,216,222,191, 27, 25,
 28,142,  0,126,162,138,193, 21,254,115, 39,238, 60, 36,113,252, 19,  8,130, 97,
131,  2, 78,248, 32,111, 19, 91,120,102,  4, 70,155,232,123, 92, 56,173, 23, 61,
248, 35,  5,213,163,180, 22,213, 93, 62,126, 68, 12,138,254,174,  5,146, 95,100,
143,117,166,216, 13,232, 61,203,250,154,  6,  6,132,214,  2, 64,248,245,126, 20,
 96,195, 35, 84,155, 71,  0,134,186,136,180,229,165, 69,243, 70,253, 64,140,150,
 84, 51,153,138, 17, 21,203, 36, 31,171,219,114, 75,243,181,172,211, 38, 74,204,
190, 76, 47,  3,159, 83, 29,134,144,203, 47,171, 84, 71,  6,111,197,164,131,233,
164,149, 61,169,218, 13,184,126, 40, 70,169, 19,253,237,160, 86, 62,207,126, 37,
159,131,237, 36, 31,182,248, 57, 29,237,186,154,243,211,140, 67,220,  3,158,144,
146, 72, 78,162,  8, 91,120,198,221,194,179,186,109,213, 22, 12, 54,174, 34,219,
213,144,170,132,104,  7,109,218,  6,120,151,181,111, 58,219,180,130,  6, 81, 88,
  9, 89, 10,215,235,233, 63, 89, 33,166,138,240,100,161,196,116, 82, 42,246, 37,
227, 70, 53,157,231, 84,197, 11,119,250,207, 50, 88,213,131,139,168,252,208,236,
 66,121,137,248, 69,194, 56,230,247, 74,176, 16, 38, 23,108, 59,173, 55,153,172,
 12, 22, 45, 84, 85,161,117,117,198,175, 96,192,173,204,176,209,115, 23,223, 70,
232, 11, 48,212, 69,122, 60, 69,167,240,187,128,245, 12, 81, 69, 21, 82, 42,108,
  9, 13,162,237, 18,  4,150,212,145,203, 64,  1, 17, 30,127,111, 96,233,159,102,
 81,150,119,192,128, 89,240, 61,161, 42,247, 11, 14,153,147, 35,118, 66,237,244,
210,202,182,147, 18,214,133,211, 96,168,187, 71, 45,189, 38,182,137, 74,198,101,
241, 39,133, 61,  0, 78,154,125, 51, 92, 53,194,245, 45, 23,  2, 21, 47,181, 22,
 69,193, 89, 66, 13, 84,237,154,164, 21,105, 41,213,128,230, 13, 85,194,110, 38,
182, 59, 14, 60,211,105,  7, 89,191, 46,186,144, 69,121,202, 11,171,196,220,157,
 68, 85, 36, 38, 33,226, 11, 31,161, 44, 16,  1,177,237,255,187, 17, 92,146,154,
186,183, 27, 32,250,174,123,234, 35,128, 15, 47,132,124,174,157,200,229,235, 83,
189, 57,223,232,236, 77,188,253, 85,184,153,120, 44,204,241, 10,  8,215, 15, 30,
105,154, 83,221, 19, 32,134,  9,237,123, 98,112,167,145, 90,136, 64,225,100,188,
 34,148,244, 33, 64, 58, 28,174,235,  6,157, 34, 34,  0,249, 55,160, 26,125,238,
  7, 37,124,249,133,174, 45,119, 87,192,253,113, 75,210,138, 15,245, 53, 49,246,
 51, 16,181,236,123,  8,229, 70,169, 58,133, 10, 91,173, 82,218,149, 39, 17,195,
124,213, 84,183, 81,189,172,225,133, 55,178,241,189,169, 11,148, 73,241,173, 17,
 23, 87,105,118,  2, 46,254,110, 93,100,117,253,100,176,225,195, 79,109,211,211,
  5,150,159,136, 84,156, 53,237, 38,206,239,164, 12,195, 10,156,169,198,203, 92,
 28, 42,198,201, 70, 12,230,183,140, 48,108,227, 53,110,252,103,177, 11,235, 20,
 82, 67, 42, 49,101,  8,220,148, 96, 79,106,244,174,246, 39,115,246,230,230,154,
178, 75,160, 14,238,163, 23,110,132,245,148,161,139,123, 42,151,118, 54, 92, 80,
 41,  5,219, 39,202,120, 97, 82,211, 61,  1, 75, 20,234,215,244,175,101, 20,187,
 96, 98,230, 81,174, 74,246,178,222, 81,239,201,243,213,175, 87,  6,166, 89,245,
 40,217,105,200,219,203, 90,238, 27,169, 54,230,124, 23,118,114,109,236,199, 85,
208,106,167, 39,201, 71,193, 38,112, 92, 57, 42,191,230,  8,115,246, 61, 17,221,
 68,142, 80,137, 55,141,159,148,180,112,112,164, 17, 24, 52,102, 66, 97,209,134,
  5, 34,163,166, 69, 85,168, 14,236, 81, 94,149, 23,205,246, 78,124,250, 71,123,
 81, 36, 36,102,236,211, 61,235,141,135, 30,137,228,215,244,135, 30,182,254,133,
 75, 69,251,164,179,125, 56,183,157,116, 36, 62, 87,161,119,245, 28,225, 37,227,
172,127,162,235,146, 61,202, 87, 80, 32,227,233,241, 74,247, 53,225, 33, 84,160,
122, 52,171, 75, 14,149, 28,190,181,246,196,137, 96,161, 81,250,140,165,244,110,
242,185,244,206,193,151,174,218,  4,149, 74,164,160,163,216, 63,  7,247,215,211,
167,  9,232, 78, 37, 12,181,217,250, 43, 75, 85, 91,106,  3,122,159,111, 36,134,
  5, 76, 71,145,187,223, 86, 98, 75,119,234,109, 81,154, 30,  1,131,128,251,226,
 92,186, 27, 14, 26,108,151,240,241,250, 92, 82,171,243,  7, 70,149, 30,130, 99,
 67,226, 40, 69, 89,236, 36, 14, 27,162,187, 80,145,184,105,  7,213,152,  3,  0,
 18, 91,  8,128,111,180,225,116, 70,248,166,168,194,193,159,183, 96,166,128,184,
140,113,131,  7,157, 38,  1, 35, 67,201,101,  8, 71, 47,230, 22,225,145,120,150,
 44, 13,167,215, 60, 33, 42,120,184,217, 15,239,115,106,202,150,194,224, 59, 62,
214, 80,  6,123,209,227,190,235, 70,200, 85, 34,184, 22, 95, 58,217,121,  4,171,
240,129, 12, 16, 87, 64, 78,145,142,132, 48,214, 68,126,166,163,160,196,159,197,
214, 57,110, 54,148, 12,112, 35,129, 36,241, 65,225,136,192, 14,204,173,  1,194,
169, 32, 10,142, 79,200, 75,138,230,174,170, 56,216,106,124, 22,186, 63, 65,145,
197,227, 23,229, 89, 50,230, 81, 38, 76, 70, 52,243,142,111,179, 15, 64, 83, 80,
149,226,254,161, 91,228,212,158, 34,  8, 34,119,132, 26,136,176,185,212, 24, 52,
197,129, 66,120,  2,189,142, 55,209, 22,142,125,224,252, 54,107,160,210,215,129,
210,176, 29,103,153,  9,231,183, 59,196, 26,121,118,122,185,  9,213,249,193,251,
188, 96,227, 91,230,251, 31, 14,243,239,122,156,159,194,  8,100,255,223,184,  3,
235, 13, 20,242,156,208,179, 77,134,204, 86, 37,179, 26,185,126,175, 46,142,110,
 23, 67,122, 12, 33, 17,213,120,196, 24,115, 50, 93, 72, 21,  4, 24,194,192, 98,
 31, 77,194,101, 45,205,245,205,218,216, 46,188,139, 74,172,137,123,111,112,110,
 77,236,184, 69,172,123,122,130, 11,145,244,232,168,179, 97,227,150,174,255, 36,
152, 75, 13,  7,124, 49,210,240, 50,222, 29,189,115, 77,109,207,134,221,248, 90,
 36, 92, 15, 18, 73,164,216,235,164,135,144,208,218,171, 32, 22, 22, 11, 35, 80,
196,211, 66,172, 63,171, 26, 44, 84, 29,210,  1, 74,140,108,192,160, 78,  6,176,
 18, 73, 34, 42,110,101,233,239,181, 51, 55,125,161,222, 97, 43, 76,152,224,222,
 96,163, 31,103, 93,188,107,226,187,228,110, 28, 86,150, 92,233,220,123,191,189,
105,137,149, 78,130, 85,229, 84,191, 35,235,161,220,189, 12, 73,181,180,159, 23,
 95,114,157, 80, 81,148,215,211,  3,  5, 47,197,  5,202,137, 40,183,201, 79,  1,
 61,104,168, 32, 26,245,174, 51,139,241, 36,148, 10, 47, 45,  3, 74, 87, 96,124,
213,102, 68, 44, 81, 98,139,207,229,124, 38,  1,171,  2,129, 77,229,124,  9,108,
 12, 52, 83,147,101,122, 60,191,226, 71,147,111, 74,206,125,192, 47,  1, 25, 62,
156, 83,232, 72, 96,148, 96,213,237,247,  9,134,125,145, 77,250,  8,242,173, 80,
181, 99,137,147, 61,215, 19,180, 51,166,130, 54,229,158,198,  4, 44, 28,152,154,
120, 25,198, 49,178,255, 94,232,229,163, 34,158,227,245,178,115,139,151,180, 41,
122,106, 64,221, 99,196, 65,171, 38,220, 34,235,200, 38, 64, 80,245, 93,143,107,
 35, 18, 50,252, 76,252,211, 24, 70,  5,187, 41, 78,184,155, 34,203,180,183, 43,
 63, 24,134, 88,188, 80,236,164, 33,209, 73, 44, 69,213, 27,229,120,119,179,237,
126,213, 34,114, 52,193,211,143,171,  8, 24,133,129, 39,145,162,109, 78,  3,146,
119,212, 64,170, 81,  5,244,164,159,121, 75, 44,116, 99, 65,240,150,126,216,150,
197,180,171, 63, 42,134,215,108,243,161,113,235,198,116, 55,176,  3,122, 15,229,
201,250,215,  9, 58, 54,140,  2,156, 47, 39, 57,114,160,181,227,183,116,  8,209,
132,162,119, 63,195,214,148, 66, 11,  8,107,213,  6,171,159,139,149, 82,100, 90,
249,153, 84, 48, 44,108,224,154,124,182, 43,177, 45,180,122,166,218,211,  6,120,
111, 50,222,177, 32, 57,130,116,174,173,245, 15,244, 57,207,191,231, 68, 85, 67,
146, 52,180,180,238,136,178,146,168, 89, 53,134,136, 11, 49,129,238,194, 40, 87,
167, 34,193, 21, 21, 72,150, 12, 13,  7,186, 99,178,101, 86, 32, 71,157, 49,150,
123,227,252,233,218,127, 14,245,152,125,199,226,239, 70,105, 65, 33, 69,127, 10,
218,219,242, 86, 44,137, 51,157, 83,223,230,110, 70,175,215,120, 45, 74,201,169,
238,120,140,114,  6,186, 33,234,203, 13,201, 53, 59,158,186,210,119, 75,233, 81,
206,201, 29, 17,243, 24, 87, 92, 45, 37,251,127, 72,167, 84, 52,192, 66,147, 26,
216,208, 61, 77, 36,197,234, 61,138, 13, 31,170, 25,206, 30, 86,140, 89,255,146,
168, 32,250,186, 82,197,131,108, 23,157, 12, 75,156,101,123,104, 79,218,178,113,
 85, 81, 62, 16,169,  9,215, 97, 24,244,128,208,121, 37,243, 96, 76,152,129, 15,
 53, 44, 46, 80,243,225,183,184,147, 82, 54, 49,181,163,135,131,125,242, 34,206,
180,247, 40,172,114,  5,248,244, 49, 72,134, 70,130,245,220,  5, 90, 49,170,199,
160, 62,139, 58,255, 12,130, 82, 48,  4,157,235, 53,122,101,115,168,246,235,  9,
130,239,239,187, 18,205,103,155,127, 20, 13,208,209,244,115,243,165,165, 69, 93,
115,225,252,241,188,135,216,232, 65,190,100,113,146, 44,164,153,247,196, 71, 46,
 65,208,153, 99, 90,184,233,104, 11, 72,149, 26,200,162,187,119,141, 67, 45,239,
192,169, 88,211,251, 47,255,216,183,141,136, 68, 14, 81,171, 30,106,223, 89,133,
 49,161,165,245,210,102,114,121,178,192, 23,194,147,138,201,245, 80,109,202,199,
 65,131,  8, 88,134, 84,  8,106, 17,108,126,118,179,  6, 28,245,167,210,233,115,
212,217,156,217, 73, 92,  3,148, 54, 67, 98, 77,226,104,116, 75, 77,253, 29, 74,
 69, 49,198,207,254, 15, 28, 18,221,219,143, 66,119,138,183,158,  0,252, 83, 15,
162,218, 10,107, 88,167, 79,159,231,202, 34, 68,231,250, 74,186,226,213, 63,162,
 37,238,178,161, 13, 65,187, 88,226, 22,118,153,165,210,156, 51, 64,239,127,205,
226,132, 52,115, 10,205,223,115,153, 39,191,133,222,  7,178,158,  4,227,137,219,
102, 39,217,178,179, 24,136,180,224,154,  3,113,176, 29,  7, 10, 47,104,  9, 73,
159, 31, 45, 52,194, 40,177,  6, 99,108,236,204, 86,166,170,188,195, 51, 46,230,
203,  8,188,222, 23,246,210,168,150,210,209,167, 84,170,202, 84,221,237,131,181,
 45,173, 69, 67, 47, 32,238,114,206,192, 33,  7,207,150, 34,151, 34,169,  7,187,
 71, 78,198,217,246,255,  5, 91,230,187, 67,  3,225,234, 84, 69, 44,219,197, 32,
 61,185,101,  3, 42,228,236,106,232, 61, 21,174,220,255, 51,212,114, 47,225,165,
  7,178,109,128,194, 56,165,185, 14,184,185,191,114,109,153, 77, 43,204,113, 68,
 16,145,235,204,177,208, 72,167,213, 15,196,214, 76, 86,229, 66,166,119, 84,210,
218,222,103, 71,124,179, 14,  4, 14, 47, 64,237,  0, 33,128,125,159,137,207, 64,
117,  2, 89,201,232, 82, 65, 74,107,210,115, 65, 56, 29,118,200, 86,129,222,  8,
182,142, 19,154, 99,133,204, 63,126,246, 96, 23,121, 66,238, 52,208,172,168, 49,
 94, 60, 71,164,144,243,232,219, 42, 77,205,234, 27, 51,100,236,151,183, 68,151,
 51, 21, 89, 53,  3, 79, 62,227,174,229,141, 34, 80,138,248, 95,161,120,191,140,
138,133,241,202,174, 71, 30,170, 86,180,104,201, 20,  0,230, 67,162, 28,  0,230,
 45,162,132, 72,144,108,240, 95,224,213,161, 82,118, 78, 84, 73,120,200,210, 51,
194,254,156,244,123,196,224, 96,219,163, 76, 60,154,178, 73,186,152,220, 10, 20,
129, 48, 40,106, 15, 15,194,109,198,213, 54, 79, 12,  4,165,227,161,222,126, 35,
191,236, 22,205, 29, 99,153,227, 16, 96, 30, 17, 61,185,184, 98,179, 97,128, 76,
236,107,173,240,204,178,136, 29, 32,  5,116,133,176,166,187,194, 11,168,125, 84,
111,115,103,203,131,137, 28,  6, 41,233, 49, 79, 75,204,250,208,170,208,153, 72,
148,149,193,138, 14,145,131, 14,  9, 31, 71,214, 86,100, 49,145,182, 19,135,142,
242,  4,168,251,247, 19, 84,132, 74,255,152,141,215,181,  0,224,251,114,192, 64,
114,217, 54,121,179, 81,106, 74,131,  1, 68,213,175,142,207,245,104, 33,251, 54,
171,100,212,195, 39, 30,214, 34, 71,140,186,203, 31,  6,  2,183,180,234,160,116,
 23, 43, 50,174,230,220, 99,  1,108, 41, 11, 25,209, 58,  5,108,217, 31,  0,118,
 93,141, 36, 26, 50,147,218, 30,168,139, 38,160, 22,230, 87,121,204,110, 36,176,
158,234,188,249, 51, 72, 94, 73,212,  7, 25, 18, 35, 45, 70,164,108,194,190, 75,
235, 62,255,221,136,234, 68,134,151,142,175, 76,116,211,  4, 92, 48, 83, 84, 20,
  2,243, 80,235,134, 21, 24,233,  0,146, 51,167,131, 90,183, 26,131,  2,
} ;

// ../Source/Template/GB_AxB_saxpy4_meta.c:
uint8_t GB_JITpackage_35 [909] = {
 40,181, 47,253, 96,254,  9, 29, 28,  0,182,234,129, 40,192, 18, 89, 29, 74,  4,
198, 98, 30,222,  5, 14,  4,172, 77,205, 69, 93,188,126,147, 10, 99,206,215, 97,
170,156,227, 74, 58,143,167,223, 85, 20,138,235, 32,  4,121,  0,110,  0,120,  0,
219,148, 30, 60,195,109,170,209, 92, 59,171,164,198,181, 39,173, 72, 22,148, 75,
 36,107,205,109,220,152,227,188, 97, 80,204, 57, 14, 62, 58, 48, 32, 48,144, 20,
 10,  8, 12, 14,205,231, 17,166, 26, 73,121,  4,126,179,101,219,209,235,145,  5,
 43,113,243,228,133, 96,176, 58,211,207,114, 36,158,236, 50,205, 60, 62,186,237,
109, 54, 73,227, 43, 61, 12, 31,113,220,167, 29,211, 79,143,162,  0,156, 12, 76,
103,144,185, 59, 12, 97,227,109, 72,140,197, 13,136, 69,136, 75, 36,142, 36,145,
  4,158,247,225,190,242,120,210, 78,170,182, 62,171,242, 23, 22, 24,201,168,173,
182,123,111,249,184,183,153,101,247,107,179,228,190,238,155, 83,190, 35,120,210,
108,107,174,254,200, 85, 73,252,218, 71,152,235,122, 59,227, 89,103,121,187, 54,
134,212,215,171,244, 25,203,217,222, 38,223,214,111,153,106, 28, 99, 84,122,105,
215,248,149, 74,153,163, 95,230,215,106,207, 26,127,223,112,213, 30,211,103,118,
203,221, 29,211,237,114,  8, 34,  6, 82,  7,149,137,162,244,199, 73,205, 55,153,
246,149,220,236, 12, 58,117, 93, 68,236,226,170, 46, 11, 69,169, 48, 11, 70,  0,
252,129,177,163, 25,  4, 63,153, 52, 56, 72,211, 39,175,205,105,230, 51,134,144,
144, 43,125,198,213,206,141,212,224,228, 27, 14, 65,211,243, 74,165,226,225,249,
133,161, 44, 11,198,  8, 62,154,120, 52, 61, 55,198,255,223,113, 58, 28, 71,163,
 89,133,228, 74,181,206, 32,191,246,222, 14,112, 40, 21,133,133, 98,  2,195,172,
 74,163,  1, 78,204,181,241, 68,214,249,218,142,243, 65,208,152,235, 15,200,140,
116,150,156,215,117,134,188,179,143,155,149, 22, 92,235,172,126,  1,239,128, 52,
 10, 31,101, 96,217,221,214, 79,  6, 62, 77,211, 52,197, 24, 99,220,128,158,141,
203,130,161,174, 11, 94, 32,134,186, 92, 68, 64,240, 57,101, 97,224,197,130, 18,
206,214, 84,  9, 33,165,219,230,221,131, 78,188,135, 71,124,126,129, 19, 87, 21,
 39, 88,204, 52, 88, 76,177,120,206,218, 76,230,153,248, 60,233,205,184,175,192,
 51,182,192,241,252,178, 44, 20, 19,133,129,  1,128,167,168, 33, 77,163, 12,137,
204,136,164, 36,  5, 73, 26,  3, 96, 68,100,172,170,234,114,112,112,150,133, 41,
134, 20, 36,196,  4, 66,193, 72, 36, 50,138,202, 42, 40,116, 55,113,162,203,219,
178,209, 58,  5, 70,192, 85,152, 56, 30,157,157,222,132, 25, 34,175,251,151,170,
 68,120,240,186,188,108, 41, 90,171,134,  3,106,170,220,226, 72,168,134, 61,197,
195,239,190,185, 79, 72, 41,217, 18,  4,145,228,135, 72,238,199,146, 36,  3,139,
255,144,198, 57,202,166,251, 59,137, 11,109,249, 32, 95,196, 23, 25,133, 67,107,
 96,128,255,229,250,124,160,  3, 33,195,171, 74, 99, 45, 37,134,145, 58,159, 66,
 20,202,212,218,160,101,216, 29,209,219,212, 80, 93,179, 32,132,206, 50, 38,225,
181,145,213,191,145,228,158,226,109, 10, 21,189, 16,162,110, 40,199,208, 48, 15,
110, 51,145,192,215,111, 14, 60, 70,218,163,167,230,  3,172,200, 25,138, 64, 69,
185,182,123,101,170, 68,124,154,192,175, 51,129,164,129,150,112,135,131,217,134,
252, 42,158,104,144, 13, 45,123,165,230, 89, 11,238, 54, 14,142,  5,219, 78,219,
116,202,210,117, 59,100, 62,165, 48,186,  6, 21, 95,126, 66,195,140,171, 69,147,
 23, 33, 85,204,119, 61,221,115,137,242,233,166,  2, 46, 89,147, 41,251,136, 23,
235,212,250, 70, 64,207,120,155, 85,126,208, 75,240,169,209,  5,121,193,130,195,
 15,187,168, 77,247,240,249,149,187, 68,115,  0,175, 66, 30,252,155,255,250,249,
214,190, 60,236, 43,166,228,222,100,154, 58,139,176,248, 52,217,173,185, 96, 29,
158,  6,165,198, 81,  4, 16, 76,181,105, 74,127, 48,217, 42,183,  4,169,228, 31,
209, 91, 86,251,116, 67,245,112,239,
} ;

// ../Source/Template/GB_AxB_saxpy4_panel.c:
uint8_t GB_JITpackage_36 [914] = {
 40,181, 47,253, 96,129, 21, 69, 28,  0,230,167,123, 33,240,214, 54, 72,  4, 78,
 65,105,204, 13, 17,104,121,252,125,153,254,190,111,137, 57,205,201, 20, 70,164,
 76,145, 77,132,109,244,  5,115,  0,110,  0,114,  0,135,130, 70,248, 17,188,103,
117,  6,250, 88,196, 59,127, 72, 33,188,206, 15,226, 10,161, 19,201, 20,194, 31,
161,175, 95,227,122,143, 32,172,241,178,172,142,109,218, 65, 35, 40,178,131,230,
 23,104, 57,166,241,232, 70,188, 80,221, 52,110, 83,132, 61,199, 54,181,194,141,
231, 69, 59,198,107,244,158,155,223, 56,221, 84,254,217, 20,125,226,168,233,157,
160,250, 99,224, 19,103,128,133,242,243, 61, 45,194,116,150,174,182, 92,169, 90,
174,115,131,161, 34, 24, 12,  1,229,245, 31,221,209, 57, 23, 77,215,159,150,119,
228, 31,194, 72,139,115,129, 95,228, 21, 10, 97,216, 10,207,212,191,  4,101,172,
245,239,244, 20,153,160,143, 32, 30, 73,142,109,207, 56, 53, 81,240,138, 92,226,
113, 50, 22, 12,196,118, 38,254,227,246,207, 88,252,240,181,233,133,109, 45,103,
181,173,182, 44, 83, 17,226,126, 25,126,223,242, 20,189,103,249,121, 69, 27,127,
 14,241,207,245,151, 97,190,163,235,208, 28,247,139, 92,227,209,171,  2, 31,248,
 52,227,125, 93,155,134, 66, 89,  0,107,219,  4,154,150,191, 28,125,131,172,225,
 31,210,227,223,225,  3, 45, 50,213,226, 81, 56,187,161,136, 56,144, 17,180, 16,
 35,107,248,133,141,213,242,106, 39, 92,231, 91,103, 19,100,236,  7, 93,131,  1,
248,163,124,221,209,240,131, 63,188,146,190, 45, 34, 97, 57,195, 17,254,250,130,
 94, 85,167,235,204,150,143,224,198, 36,237,238, 94,157,170,170,208,185,185, 51,
246,240,195,107,150,158,255, 63, 83,120, 31, 13, 85,149,170, 66,164,237, 44,105,
189, 10,199,226, 93, 36, 27,137, 38, 99, 67,164,229,114, 26, 72, 49,118,153, 94,
241,195,204, 31, 15,207, 66,254,232,143, 36,207, 52,109,219, 26, 78,222, 71,191,
 42,181,105, 90,150, 29, 62, 80, 61,171, 99, 36,190,150, 87,132, 11, 28,159,167,
199, 49,118,199,153,121,252,244, 48,191,173,167,192, 96,216, 54, 45, 51, 53,182,
156, 99,164, 99,165,206, 49, 79,210,109, 90,214,240,235, 64,130, 44,231, 36,154,
 90,129, 72, 34, 34, 14,115,128,174,160, 65,189, 98, 72,102, 68, 68, 82, 90,144,
 20, 26,  3, 96, 68,100,202,104, 61,209,  1, 30,127,157,214,197, 79,222,125, 32,
127,200,138,  6,157, 24,146,187, 11, 24,244, 46,133, 57,120, 41,  6, 72,189,159,
144, 82, 14, 24,  6, 45, 18, 14, 65,182,176, 54,103,202, 95, 36,250,  9,170,111,
 36,164,250,122, 56,157,140, 56, 49, 59,160,183,147,  7, 61, 65,200,130,218, 42,
 17, 21, 64,149, 13,174,166,198, 80, 54, 42,  5,110,163,254,109,181,143, 86, 83,
125,217, 65,220,230, 98, 63,192, 55, 32,131,  6,242,160, 12, 26,200,160,106,135,
 14,  1,179, 96, 96,186, 52, 96,125,139, 53, 47,  0, 97,192, 67, 67, 60,117,205,
157,136, 90, 53, 57,120,230,176,153, 35, 98,209,114,189, 49, 30,246,201,249, 10,
199,247, 20,103, 39,226,203, 87,111,160,184, 25,193,220,225, 81,162,157, 66, 23,
192,126,192, 68,139,109,215,200,205,226,106, 50,195, 12, 14,183, 32,122,  3,110,
155,223,187, 50,123,248,123, 13, 98,195,131, 67,212, 57, 25, 37,143, 99,248, 77,
  1,  4,197, 92,254,230, 53,  4,148, 65,153, 47, 49,130, 90,129,253,129,110, 45,
230, 44, 56,238, 64,126, 80,139,200,198,163,  8,246,205,130,  7,128,244,103,247,
 29, 32,204,192,213,220, 43,162, 65, 41,212,141,120,  0, 14,236,244, 69,193, 89,
  6,164, 29,  0,137,  1,162, 46, 44,128,177,157,128,119, 59,179, 58, 37,168, 30,
190,189, 12,219, 64, 51, 55,111,201, 41, 90,168, 54,  9,165,165, 28, 99,192,129,
 45,  4,215,142, 90,  6, 45,  0, 37, 54,  1,194, 32,183,165, 26, 32,234,185,166,
102, 56,242, 96,199,136,107, 16,240, 16, 72,102, 38,231,131,105,116,217,  0,  0,
201, 39,232, 86,100,  3, 66,136,241,249,146,  3,210, 77,147,243, 51,147,186,  8,
 87, 29, 82,148,136, 10, 60,128, 57,110, 80, 69,175, 24,
} ;

// ../Source/Template/GB_AxB_saxpy4_template.c:
uint8_t GB_JITpackage_37 [3122] = {
 40,181, 47,253, 96,236, 72, 69, 97,  0,154, 96,212, 17, 45,176,172,172,115,200,
 50,240,251,252, 57,188, 69,102,150,141,253, 38,154,131,160,219,167,185,111, 38,
172,169,240, 92,229,182,175,114, 77, 14,153,117,252,160,255,160,255,194, 67,  9,
 12,  1, 10,  1, 27,  1, 22,217, 13,220,217,191,103,182, 13, 37,219, 89,121, 49,
154, 97,253,255, 12,134,  4,203,214,218,100,  5,134,116,201, 80, 92,209, 55,202,
 17,218,158,103, 43, 48, 46, 14,172, 13, 86,217, 88,155, 91, 43, 92, 22,131, 79,
249,104, 61,158,149, 59,233,  8,121,147,106,172, 42,131, 81, 68, 84,149, 78,153,
 61,235,202,147, 61,149,110,215,250, 31,242,242,  7,185, 30,234,216,240,182,185,
 75,107, 58,233, 71,239, 61,153,245, 43,189,210, 11,191, 48,203,228,153,187,231,
110, 95, 92,227, 27,130, 31,205, 26,213,169,233,113, 39, 91,174,224, 47,157, 16,
255,195, 54,228,193, 88,120, 72, 28,204,101, 18,172, 62,169,220, 91,223,201,154,
229, 96, 59, 57,235,  7, 71,131,134,204, 67, 99,139,202,150, 53,183,151,243,180,
230,158, 87, 61, 18,144, 44, 72, 28,  7, 34, 11,146, 75, 89,244,104,219, 66, 54,
252, 81, 61,196, 93,250,245,245,184,169, 30, 42, 28, 40,171,195,100,195,183,195,
 13,  3,  2,202,239,118,231,149,199,202, 96,136,131,176,173, 18,180,213,163,231,
133,219,109,223,242, 88,105, 84,212,100,249,132,175,244,192,143, 47, 86, 32,  4,
130,164,197, 42,160, 10,171, 56, 28,  2, 97, 56, 32,144,  7, 89, 30,150,175,189,
 61,195,219,147, 62,235,203, 31,119,187, 74,106, 31,163,237,202, 20,196, 44, 32,
117,122,111,101,123,242, 83, 30,115,238, 36,196, 37,156,138,190, 89, 48, 85,178,
151, 73,146, 20,125,242,133, 43, 56,181,141, 85, 38, 80,  2,135,214,212, 34,170,
 72,141,232,211, 59,149,232, 82,199,225, 98,  8, 42,107,149,190,210,143,252, 62,
191,208,163,217,103, 63,130,211, 17,234, 56, 58,143, 18,117,  7,138,131,162, 92,
 18,113, 72, 62,147,200,  7,156, 12,212, 35, 21, 41,226,152,196, 73,100,105, 28,
 66, 69,123, 22,195,124, 58, 40,227, 68,209,169,155,117,189,150,107,227, 22,122,
 65, 24,206, 36,104,187, 74, 47, 46,123, 30, 46, 17,  5, 40, 50, 13,170, 77,180,
 32, 44,234, 30, 79,  9, 58,168, 75, 49,126,173, 89,116, 30,163, 71, 72, 88,151,
117,105,170,204,255,201,159,199, 91,229,181, 31,219,150,202, 55,122, 91,233,205,
216,130,103,127,149, 47,107,159,166,121,  6,202, 23, 78, 69, 82, 36,102,253,201,
 25,210, 34,246, 66,141,185,204, 94,154,145,213, 36, 87,238, 98, 95, 56, 61,246,
 60,121,240,163,151,159, 71, 86, 80,129,114,173,239, 41,141, 83,  7, 77,246,  2,
212,163, 58,151, 53,119, 97, 99,196,129, 97,115,225, 31,173,236,153,178, 94,235,
 87, 64,122,230,174,172, 63,122,229,132,104,209, 92, 48, 87,229,208,152,131,243,
141, 55,166, 41,239, 79,212,165,207,193,121,134, 15,229, 28,206,190,147,102, 84,
171,244, 59,157,167,128, 52,  6, 97,  2,100,143,  0,103, 45,244,178,249,  9,159,
  9,  3, 86, 13,153,137, 75, 77, 32, 12,229,151,164,142, 39, 58,164,241,169,163,
 99,222,128, 92, 66,199,115,185, 38,186,199,254, 99,215,242,145,114,233, 70,191,
104,170,  7,203,165,  1, 99, 96, 61,144, 62,159,248,233, 60,145,149,215, 66,158,
188,237, 75,159,216, 69,151,186,216, 81,245,  6,151,135, 12,132,132,197,  1,128,
 15, 24,112,205,197,122,200, 88,145,  3,214, 53, 86, 97,215,195,  4, 68,164,115,
169, 19,101, 42,136,203,170,108, 46,154, 12,246,233, 66,133, 73, 29, 48,236,117,
 66,170,125,162,238,145, 95, 83,164,134, 39,185, 98,191,146,122, 91,131, 37, 17,
 33,  1,129, 73,  8, 88, 22, 96,155,137,135, 12,182,177,164,142, 34, 60,118,244,
203,101,105, 56, 88,131,172, 91,202, 64,152,232,227,239,151,139,162,130, 81, 92,
214, 21,113,105,176,176, 77,133,105,  5,112,158,122, 54, 67,247,178,253,132,173,
199, 19,166, 12,198,  4, 14,245,139,115, 24, 40,212, 47,164,137,164,163, 95,210,
248, 90,153, 49, 24,186,145,116, 17, 99, 55,132,134, 20,125,242,198,167,130,210,
 90,114, 49,137, 92,112, 36, 61,137, 52, 71,226, 68,231, 44,212,184, 78,186,209,
125,206, 57, 17,135,195,146,159,243,201, 67,155, 84,227,239, 11,237,228,122,253,
143,141,134, 58,183,149,185, 75, 90, 95, 14,  7,206,190, 94,104,185,222,222,118,
 76,182,104, 15,151,201, 11,157,113,129,138,206,158, 20,121,140, 91,116,  4, 87,
132,133, 93, 52, 19, 87,166,178, 80,148, 83,223, 46, 97, 18,162,148,111, 26,119,
 51,210,202, 17, 54,  8, 93,145, 81,239, 17,196, 55,156,180,111,198,182,107,118,
201,147,106,231,206,175, 13,191,223,142,206, 87,106, 96,120,201, 61, 54,136,181,
 10,172,120, 55,  3,229, 84,103,194,186,174,226, 96, 85, 73, 82,236, 62, 81,175,
128,239,164,174,123,228,170,232, 21,134,233,166,169,235, 36,221, 36,210,109,156,
 13, 99,177, 32, 36,174, 42,250,116,  9,100,241, 64,199,108,182,225, 39,147, 90,
105, 17, 58, 28,132,105, 68,166, 15,131,134,  8,  9,203,101,131,105, 36, 22, 96,
 23,118, 93, 28, 58, 21, 80,122, 16,108,237,173, 19,112, 72,131, 52,168, 66,164,
212, 41, 69, 35, 34,146,146, 36,133, 12,  7,114, 32,  8,131,161, 64,143,181, 40,
232, 14,162,128, 52,200, 81, 32,196,176,136, 33, 68, 17, 67, 12, 33,148,136,136,
  4, 34, 36,129,200,  4, 81, 32, 81,  7,137,231, 84,153,101,  6,206,171,142, 86,
139,213, 55,115,  9,163, 40,196,132, 41,161,220, 43, 18, 73, 66, 31, 12,253,118,
 78, 73, 73,224,222,159,148,222,219,166,174,112,127,182,207,126, 45,223, 42, 25,
 13, 31, 98,  7,181,181,162, 13, 75, 79,181,189, 37,157,106, 55,184,129,  3,173,
208,169,234,123,225,180,156,111, 52, 34, 41, 12,189,135, 21,  8,109,156, 19,150,
 22,237, 30,231, 27,143, 63,209,230,207,170,119,238,172, 35,130,160,120, 70,127,
239,219,182,149,186, 77, 12,155, 83,188, 76,155,142,130, 38, 60, 20, 58,172,132,
  2,196, 58, 31,241,228, 87, 13, 35, 67,150,204, 46,233, 23,242,115,197,141,120,
112, 61, 50,154, 42,196, 77, 81,167,107, 65, 53, 53,226,248, 56,125,244,250,187,
134, 13, 34,203, 53,195,  1, 59,  2,197, 73,181, 63,202, 93, 64,232, 17,182, 69,
149,226,195,130,161,225,205,200, 29,176,194,200,136,118,219, 12,180, 13, 74, 50,
104,135,239,105,240, 83,253,190, 66,224, 11, 61,156,220,157, 45,118,145,159,108,
  4,104,213,161,145,  5,211,202,  7,115,  3,210,204,112,100, 11, 14, 84,  1, 98,
111, 76, 15, 87, 59, 76,200,208, 58,215,137,181, 33,188, 26, 81,164, 69, 59,165,
  6, 38,169,157, 11,232,161, 38,189,234,193,  6,132, 94,153, 70,169,  4,103,104,
129, 77, 82,203,149,152, 51,233, 10,154, 11, 98, 73, 58,138,165,158,250, 16,194,
221,179, 85,229,204, 86,  1,173,198, 88,142, 61, 10, 17, 93,  8, 22,109, 90,218,
  2,251,209, 64, 15,250,107, 52,114, 22,226,213,120,215,220,194,232,  6,142,208,
105, 68, 23,168,208, 12, 48,  3, 99,240,162,147,171,  0,173,181, 70,183, 33,201,
210,201,122,228,150,130, 62,228, 17, 94, 42, 39, 76, 62, 53,112,221, 48,226,255,
 45,125,215,153, 33,142,145,192,114, 91, 56,237,202,207,136,237, 41,143,252,121,
 92, 48,156, 24,153, 54,135,136,164,223, 51,170,175, 47,  6, 47, 27, 78,104, 37,
234, 99,104, 70,155,243,168, 24,123,255,118,241,204,237,190, 79,200,225,167,128,
 55,135,155, 88,230, 87,196,238,186,  1,241, 54,159,177,138, 86,228,198, 91,225,
196, 98, 42,216,176, 63,195,118,145, 72,226,188, 40,137,241,  9,103,216,159,104,
238,210,134,238, 27,167, 77,120, 51,190,252,232,116,141,173, 44,  8,133, 46, 72,
157, 98, 13,198, 54, 42, 62, 21, 25, 55,162, 80, 86,171,236, 79,225,209,142,145,
 33,220,199,150,137,187,227, 68, 22,141, 63, 67, 98,219, 61,189, 99,119,231, 55,
255,144, 83,225,133, 64,204, 57, 93,162, 83,175,126, 71,219, 56, 77, 28,211,203,
 24,121,146,  1, 16,160, 76, 80, 26,190,110,  3,235, 79, 32,253,210,127,222, 23,
 89, 75,142, 60,198,138, 59, 94,145,229,139,105,205,201,111,129, 37, 28, 68,219,
112,136, 68, 74, 55,144,182,143,201,139,202,117,232,146, 54,236,122,228, 12, 73,
 24,193,253,221, 98,113,189,157, 48, 12,  7,233,109,128, 64,118,220,143,124,255,
161,250, 21,229,198, 94, 20, 57,101,184, 35, 23, 64,234,147, 40,210, 89,195,204,
233,167,144, 58, 98,217,212,195,228,243, 28, 46,128,246,156, 16,156, 45, 23, 98,
212, 67,118, 99,107, 16, 69,134,154,184,126,156,236,191,165, 19,170,122,202,128,
251, 55,  5,201, 51, 26,104,158, 75,176, 31,145,180, 62,167,159,203, 64, 98,  5,
117,192,162, 91,160, 30,  2,247, 70, 34,104, 17, 28,230,142,225, 93,103,213,160,
 91,135, 33, 24,173,208, 35,217,122,139,222, 41, 46,246, 54, 23, 18, 94, 93,244,
 70,119,177, 23,121,161, 77, 24,101,230,147, 61, 28,177,160,200,145, 19, 67, 17,
255,169, 91,122,216,236, 96,148,135,209, 56, 18,101,163,206,163,219, 61,200, 54,
149, 34,  8, 66,200,150,160,237,136, 92,118, 32,  9,251, 28,118,124, 68,109, 81,
 70, 22,228,230,237, 24,  2, 37,138, 72, 43,207,184,113,163, 25,209,120, 29,137,
 65,177,179,134,201,135,192, 92,191,103,215,105, 57,171,129,233,236,219,172,195,
125,114,111,166, 54,169, 35,190,185,175,205,224,171,120,238,147,214,215,130,124,
 93, 90, 21, 69,  6,165,103,165, 68, 48,  9,169,243,159, 52,138, 33, 55,  1,226,
231,251,  0,236,117,213,113, 40,148,213,  9, 38,159,160, 42,135,191, 33,219, 61,
 59,119,112,252,111,152,114,183,167,145, 73, 31,223, 56, 87,156,250, 69, 64, 56,
 84,211,188,144,218, 56,205,200,185, 19,126,117, 48,231, 35, 87,149, 14, 86, 21,
230,110,153,160, 68,218, 11,174,211, 38,100,237,  0, 64,130, 41,125,244,232,  0,
116,176,238,222,115,194,240,  4, 13, 44,250, 37,  2,186,248,161, 22,124, 23,153,
132, 16,213,173,174,153,108,181, 92,  6, 34,115, 42,178,135, 34,238, 37, 47, 14,
  8, 99,252, 47,134,191, 89, 28,101,223,  7,160,230,186, 15,240,247, 33, 74, 17,
 56, 56,  6, 94,101, 84,215, 31,198,209,170, 72,204,161, 52, 82, 42,130, 21,134,
 83,224,241, 70,204, 48,  2, 80,211,104,221,217,236,  2, 77,252,230, 87,102,198,
231,134,192,103,131, 66,215,112,156,200,  9, 16,230, 65,194,146,154,127, 29,119,
133, 66,124,  9, 84,146,135, 91,228,138,142,158,243, 42,101, 23, 81, 63,137,196,
  3,148,  1, 92,227,245, 66, 79, 11,202, 41, 60,229, 80, 78,  0, 76,139,160, 43,
137,188,187,197,133,217,172,218,237,164,193, 45,225,204,108,216, 23, 82,195,  6,
175, 66, 32,210,110,253, 57,143,  6,186,153,179, 20,126, 81,159,128,228, 50, 66,
242,106,104, 39, 11,  9, 18,226,109, 12,119, 25, 13, 13,238,196,182,247,157,178,
153,136,140,193,  9,242,145,147,165, 95,181, 15,239,254,136, 80, 63,147, 64, 29,
 38,242, 17,239,239,175,108,240,169,196, 28,217, 37,212,242,245,128, 69,202,213,
229, 76, 52,131, 49,231,179,245,131,171, 78, 87, 55, 80,176,155, 19,108, 19, 39,
156,155, 91,131,161,131, 61,128,235,206, 21, 31, 42, 77,113,244,247,248, 66,189,
 81,182,101,154,228, 49,164,145,255, 88,113,118, 57, 30, 73,126, 84,137, 86, 10,
202,249,225,152,208,117,129,100,120,242,219, 31,173,166,200, 94, 62, 94, 59,115,
222,150,118, 76,  3,254,177,205,165, 41,219, 38,140,245,110,195,202, 26,246, 49,
 37,217, 22,130,148,142, 32,195,182,205, 10,125,205,205,125,117,107,232,200, 70,
 30, 20,226, 85,136,206,244,252,135, 49, 60,202,195, 22,106,229,138,217,136, 73,
 51,196, 32,230,175, 35, 16,102,179,213,101,184,125,114, 39, 27, 79,193,176, 48,
180,160,104,239, 83,130, 51,115,168,200, 56,175,222,  2,110,207,100,206,116,143,
198,  0,113,212, 89, 27, 10, 31,208, 34, 72, 23, 12, 21, 61, 43,133,138, 95,156,
195,221, 98, 94,132, 83,230,125,110,111,109,178,137, 27,170,105,211,209,142, 59,
 64,120,221,120,125,227,178, 49,200, 39,199, 49, 93, 81,144, 38, 13,127,  0, 62,
229, 19, 35, 57, 64,165, 28,238, 48,101,160,161,227,172, 47, 83,192,250,158,  7,
 48, 99,129, 12,130, 80,113, 50, 27,108, 52,150,237,152,115,101, 40,214, 40, 29,
154, 85,170, 50,108,245,232,183,236, 70, 22,154,  2, 82,150,143,158,168,192,130,
129,205,188, 49,128,144, 80, 24,  3,220, 78, 77,190,110,194, 76,186,109, 32,  5,
114,152,197,195,202,  3,253, 11, 40,104, 35,248,130, 22,171,198, 30, 43, 53,102,
 12, 74, 47,228,195, 94,174, 11,207, 85, 27,164, 56, 33,197,252, 71,193, 63, 49,
112, 54,220, 12,212,144, 10,222, 62, 64,208,144,102,188,137,241, 40, 35,194,  8,
184, 12, 61,221,243,183, 65,122,241, 18, 43,  9,242,208, 90,152, 43,100, 44,201,
254, 92,177,100, 36, 70,140,249, 48,216,129,163,159,157, 32,197,163,114, 75,175,
240,132,171,161,251,118,233,255,150, 50, 27, 21, 46, 26,108, 16,101,158, 24,190,
139,119,192, 12,170,133, 22,150,100,155,  0,156, 46, 67,246, 36, 98,103,246,241,
 78,160,200,127, 89,173,138,239,103,138,243, 58,105, 48,  8,203,175,153,208, 84,
145, 40, 42,145,163, 10, 25, 40,136,158, 96, 35,  1, 13, 86,238,176, 60,239,193,
 29,182, 58, 24,170,246,  7, 33, 31, 49,161,244, 82,100,244,155,163,233,233,158,
 78, 56,172, 22,254, 30,240,160, 55,  0, 63,  0,133,114, 88, 79,148,  8,107,228,
225,220,240, 28, 83,138,151,228, 48, 19,187,115,  0,108,109,112,153,112, 66,248,
 45, 21,185,140,156,237, 97,  6, 88,244,255,165,225, 89,124, 76,175,237,  2,197,
180,194, 19, 81, 59,100, 26, 14,211,182, 22, 36,253, 24,236, 50,227, 83,206,135,
177, 43, 30,140,214, 81,113, 65,126,236,127, 62, 76,148,251, 11,124,170,195,131,
116,222, 22, 10,168,176,255, 71,177, 85, 57,149,123,212,236, 87, 39,122, 33, 55,
205,236, 16, 76,244,150,151, 73, 22,242, 17, 65,185,164, 28,  6,199,208, 42,100,
102,  2,
} ;

// ../Source/Template/GB_AxB_saxpy5_A_bitmap.c:
uint8_t GB_JITpackage_38 [1090] = {
 40,181, 47,253, 96,145, 11,197, 33,  0, 54,115,152, 40,208,210, 56,  7, 84,147,
 52,161, 39,210,162,178,116,226,198,157,168, 82, 16,  8,221,177,141,249, 16,193,
238,238,113,151, 53,210, 99, 31,240,197,131, 34,247, 23,143,  0,135,  0,140,  0,
124,111,164, 25,119, 91,  4,169,166,237,223, 41,159,201,248, 36,  2,138, 65,197,
 26, 22,233,187,165,114,131,250, 74,206, 34, 42,182,146,177,230, 84, 26,153, 11,
 74,198, 32,149, 45,119,110,175,230,209,157,111,219, 59,117, 96, 64, 96, 80, 45,
 20, 16, 24, 92,130, 77,167,108,131,196,204, 41,239, 35,237, 78,174, 61,167, 48,
 30,  7,106, 52,214,141,  5,131,111,119, 24, 82,101, 58,210, 42,108,107,164,246,
240,212,223,169,109,235, 64,183,125,235,146,181,144,195,129,135,153, 88,183, 96,
 20, 26,185,219,159,235, 93,  9, 35, 42,138,246,130,162,119,193,205, 43, 21,169,
170, 84,  2, 25,203,150, 29,214,149, 37,123, 60,224,117,214,202,  2,146, 21,209,
209, 84,104, 54, 32,206, 64, 45, 32,251,148,118, 59,228,214, 67,118,109,142,237,
101, 87,119,107,237,206,143,237,166,118,153,187,109, 59, 49,170,243, 98,241,225,
118,159,111, 44, 43,135,238,137,144,136,175, 19,244,140,175,141,216,231, 50, 98,
135, 63,165, 98,221,142,202,254,104,163,125,183,142,211,176, 27,185, 95,219,113,
127,  7,205, 95, 74,157, 55,206,111, 84,188,121,174,195,176,120,214,238,231,253,
 22,177,206,122,202,201,157, 53, 15,229,117, 30,142, 54, 57, 43, 89,  3,217,196,
 91,151,177,134,217, 75,228,100,179,200, 85,187, 23,215,201,141,183, 45,214, 72,
 79,185,249,200,121,196, 74,179,190,191,178, 37,117,126, 58,215, 99, 38,183, 44,
203,178, 32,132,208,227,121, 23, 23,192, 69,146, 73,164,185,216,240, 92,111,218,
109,206, 15,219,141, 45, 48, 34, 46, 56,109, 95,240, 28, 77, 69, 71, 51,113,117,
107, 26,117,168, 32,133,151,127, 28,170,119,204, 63,239, 23,235,122, 45,215,129,
 51, 60, 27, 50,171,192, 47,151,188,129, 56, 84,214, 49,231,126, 47,  4,133, 43,
251,215,202,137,193,119,202,250,253,127, 73, 18,145, 36, 80,103, 50, 32,146, 52,
 34,141,156, 10,157,234,247, 78,117,244, 39,183, 68,214,244, 76,230,121, 56, 25,
 20,221,220,201,190,146,142,158, 60,202,241,207,  3,152, 14,106,174,123, 32,116,
204, 31, 13, 61, 10,210, 83, 34,120,202,163,217,132, 62,211,161,166,243, 56,150,
 38, 67, 57,222,161,208, 41,165,148, 74, 58,224,  7,199, 41,103,209,203, 37,148,
  6,167,195, 11,  2,110, 36, 13, 23,204,225,  7, 46, 41,168, 44,148,101, 42,152,
252,153,228,203, 59, 56,206, 88,111,199,252,214,120,237,  5, 63,234,188,180, 43,
102, 57,187,200,100, 98, 67, 54, 94,249,134,203,  9,142,153, 10, 40,172,185, 40,
 71,  1,128,215,168,  1, 69,101, 16, 34, 25, 17, 17, 73,146, 20, 50, 28, 96, 68,
100,204,202, 54,226,112,108, 24, 36, 89,166,  8, 49,196,200, 69,150,145,146,194,
250,217,  9,166, 33, 34,206,219,108,216, 78,123, 62,120,239,234,244,116,151,206,
142,251,223, 20, 42,162,112,148, 69,169, 61, 89, 80, 85,145,181,210,150,141,168,
215, 36,235,104,231,147, 54,183,254,226,182,225,152, 85,128,  1,226, 39,133, 48,
157,178,123,248, 58,164,118,140, 69, 35, 18,129, 77,217, 35, 68,100,175, 29,135,
250, 70,224, 47,117,160, 63, 15, 77,236,244, 17,153,237, 44, 11,213, 46,  3, 38,
140, 64, 57, 43,142,210,144, 52,235, 81, 94,212,173,124,134, 98, 29, 50,197,215,
126,177, 24, 57,202,176, 83, 35,  0,254, 50,226,185,134, 66,  9,116,113, 73,193,
205, 92, 99, 69,106,125,220, 95, 13,233, 22,246,150, 11,192, 45,  4, 22,144, 34,
145, 21,180,255, 13,106, 67,231,253, 52, 86,239,180,101,100,171,151, 24,229,159,
 94,126, 26,101,164, 37, 24,198,  6, 25,190, 58,151,106, 40,159,129, 51, 32,153,
  9,135,100,  9,159,108,205,155, 98,  2, 52,107,168, 52,237,164,201,120,207, 20,
165, 44, 45,101,222, 68,178, 11, 13,235,102, 68, 46, 82,141,152, 82, 35,136,137,
 20,203,129,175,126, 35, 31, 29, 60, 47, 24,206, 64,  3,250,  8,177,127,128, 89,
106,145, 58,218, 65, 99,108, 47, 19, 19,252,104, 31,198,248, 49, 47, 42, 31,134,
 26, 45, 54, 45,239,117,230,242,  3,254,138,200,148, 23, 68,127, 48,149, 97,104,
170,218,255,138,107, 48,  7, 16, 57,  5, 12,155,119,246,195,118,151,170,133,156,
128, 80,149, 32,164,195,247, 70, 37,114,225,100, 10,153, 67, 56, 62, 17, 87, 47,
 96, 41,192,  3,168, 94,224,181, 77,195,143, 82,163, 32,152, 46, 61, 13,127,189,
 42,230,122,126,125,177,220,200,182,150,226, 68,248, 62,227,195, 79, 33,163,160,
157, 69,  2,184,189,172, 73,216, 84, 61, 42, 95,250,241,247, 94,123,152,139,121,
118,152,137,220,248, 46,216, 27,209, 10, 54,205,251,131, 41, 41,181,137, 40, 41,
208, 67, 57,122,198, 67, 41,141,135,  1,
} ;

// ../Source/Template/GB_AxB_saxpy5_A_iso_or_pattern.c:
uint8_t GB_JITpackage_39 [1253] = {
 40,181, 47,253, 96, 11, 14,221, 38,  0,166, 56,168, 40,176, 84, 85, 29,244,237,
 47, 43,182,169,206,172,243, 71,225,210,191,247,192,153,219,235, 19, 61,145,167,
 98,233,151,220,218, 41,253, 65,255,193,246,148,110,  6,159,  0,150,  0,158,  0,
157,212,122,235, 74,171,247,201, 97,150, 59,109,136,195, 49,212,209, 74,221,201,
229,158,223,168,188,245, 16,247,173,136,192, 98, 64, 77, 78,147, 22,190,225,206,
254,116,166,115,203, 80, 19,211,169,181,134,210,128,216, 88,182, 25,114, 39,158,
156,227,204,121, 52,231, 93,  7, 63, 29, 24, 16, 24, 80, 11,  5,  4,  6,159,104,
210, 39,220, 33, 18,226, 22,248, 16,151,171,215,216,167, 14,212, 68,206,202, 43,
209, 48,241,149,182, 51,115,127,157,232,242,129, 95,172,244,114,123, 14, 63,117,
221,247,185,117, 76,164,192,170, 98,189, 65,179,208, 59,115,150, 54,187, 53,171,
184, 51,152, 37,132,236,136,196, 89, 28,129, 89,148,248,229, 18, 81,151, 75,245,
 10, 28,115, 58,187,144,  7,202,122,117,239, 57, 67, 80,200,180,159, 49,173, 90,
132,159,172,231,255,143, 72,162,232,211, 27, 13,216, 38,109,250,105,125, 39,157,
 30, 15,248,173,247, 78,129,200,202,112,174,139, 75,226, 51,183, 79, 11,244, 39,
 46,183,200,177,  7,237,219,222,196,167, 77,229,174,185, 92, 61,248,171, 92,158,
222,113,227,138,144, 38, 35,242,231,121, 55,233,157,160, 99, 25, 10,249, 91, 63,
223,102,198, 82,243,156, 74,237,241,183, 92,172,252, 89,218, 15,117,182,115,199,
105, 89,122,207,248,243, 14,255,169,207,150, 91,179,172,223,184,128,185, 82, 91,
239,125,154, 38, 63,185,252,154, 31,221,189,122,190, 50,227, 44,126,220,154,109,
 95, 13,207,237, 29,  4, 28,213,229, 54,111,127, 32,243, 94,122,165,130, 65, 88,
102,122,  7,204,  9, 94, 73,147,130, 73,107, 79,210,208, 38,205,238,219, 38,167,
225, 79,168,132, 55, 57, 47,151, 51,239,163,221,236, 58,121,165,189,245,234,165,
231, 33,175,221, 58, 63,211,222,230,215,201, 16,234, 50,239,228, 68, 30, 41,240,
 85,229,150,101, 89, 86,140, 49,198,145,137, 52,114,109, 54, 48, 12,131, 27,128,
138,187, 90, 61, 19,119, 24, 49, 94,115, 93,112,174,138,172,155,227,236,  3, 21,
109,196,220,243, 64,193, 87,247,192,103,173,111,198,243, 82,206,176,129, 22, 88,
 38,102,157, 76,  6,177, 72, 81,132, 47, 16, 69, 37, 37,248,147,101,165, 95, 24,
132,216,100,100, 20, 25,171,231, 71, 59, 79, 58,250,149, 67,203,113, 15,  4,144,
238,221,225,221,248, 19,232,211,188,149,122,244, 39,249,  9, 75,159,162,253, 52,
 18, 63, 97,151,196, 68,122,188, 56, 80, 99, 93, 16,152,227, 76,103,174,244,211,
  7,200,115,202,229, 43,236,234, 68, 68, 96, 84,222,210,113,159,214, 99, 59,183,
 99,206,149,209,108, 50,152, 38,195, 34,203, 96, 29, 78, 38,  2,244,234,208,130,
160,229,120,131, 64,214, 90,107, 39, 29,241,131,227,214,179, 44,230,147,137,139,
210, 99, 54, 81,125,226,128,169, 30, 79,249,164,128,106,152, 26,164,130,202,191,
117,230,248,212,  2,129,  0,168, 81, 65, 82,102, 70, 68, 68, 36,  5, 73, 10, 25,
 14, 80,132,200, 84, 89,113,  3,242,144, 76,140,114,148,161, 68, 64,136,145,  2,
162,  9, 74,100, 22,164,160,126, 54, 65, 75,138, 74,213, 60,162, 85,  2, 52,  2,
141, 62,190,212,160, 62,189,215,181,173,101,125,200, 63,141,165, 81,181,119,136,
108,203,102,214,108,100, 86, 97,234,151, 38,199,107,220,194,137,182, 50, 56,211,
130,139,241,156,121, 72, 68,182, 95,120,123,176,211,253,213,  7,189,  0,162,116,
 98,140, 91,242, 35, 13, 31,166, 54,197,105,151,162, 72, 21,114, 85, 98, 37,231,
 68,149,  8,197,228, 89,124, 30,130, 39,  3, 45,145,222,172,161, 94,132, 97,150,
 32,120,  7,198, 10,196,250,202,115, 56,164,205,110,121, 74,195,146,212,111,156,
229,  5,196,233,  8,124, 59,113,116,143,149,133,134,137,191,156,233,209,100,109,
218,211,169, 90, 42, 63,159, 81, 33,221, 49,148,183, 29, 60,241,  0,105,206, 56,
106, 69,193,138, 27,129,120, 25,113, 82,119,224, 84, 48,153,  6, 93,181,171, 70,
119, 40, 50,  4,178,161,229, 81,248,176,235,130, 42,143,  6,180,111,203,200,236,
 72,180,205,154,249,102, 85,172,182,105,134,161,246, 33, 44,180,163,182,244,113,
 72,117,172,202, 65,124, 32,159, 90,177,196,225,251, 82, 75,254,215, 98, 17,218,
208,166,136,100,140,236, 22,184,199,136, 44,181,150, 87, 37,171, 79,149,116, 26,
245,100,164, 50,195,148, 26, 80, 76,  0,131,173,151, 51,108,221,172, 34, 43,182,
184, 99, 29,223, 16,203,154,173,174, 10,133, 56,  9,206, 79, 18,  8,169,104,111,
178, 50,234, 26,215, 17,  8, 55,239,203,209,229,244,200, 52,223, 18,174, 43,211,
  9,116,127,116,121,144,221, 85, 67,236, 31,152,209,112,224,138, 64,225,154, 64,
141, 24,232,203, 29,176,  3,179,162,132,  5,163, 99, 89,253,170, 68,102, 43,203,
144, 41,161,243,101,228, 26, 22, 90, 29, 24, 22, 24, 23,149,154,126,245,  8, 88,
247,131, 83,144,179, 73,135, 63,204, 32,210, 99,144,238, 59,171, 60, 82, 90,225,
 62, 85,153,217,120, 25, 52,230,208,200, 12, 35, 24, 61, 97, 83, 17, 15, 36,242,
 18,152, 45,255,248,179,235, 60,110,205,  8,171,250,  7,113, 94,102,138,133,199,
254, 19,113,230, 98,137, 10,156,137,  5, 97,216,100, 82,242, 36,136,209,165, 39,
186,241, 99,138, 99, 71,232, 14,151, 24, 77,  2,169,183,218,193, 23,230,  6, 44,
 23, 50,194, 50,159,180,  4,112,193,185,164,120,249,166,249,254,204,228, 51, 85,
201, 75, 63,210,173,213,104, 94, 82,171,210,192, 24,
} ;

// ../Source/Template/GB_AxB_saxpy5_unrolled.c:
uint8_t GB_JITpackage_40 [2932] = {
 40,181, 47,253, 96,105,200, 85, 91,  0, 58, 83,112, 15, 45,176,172,170,234,138,
235, 11,188,206,124,107,248,171, 15, 57, 18, 43, 79,117,184,193,112,209, 84,244,
191, 36, 90,215,140, 80, 53,210,215,221,193,180,246,  7,253,  7,203, 63, 56, 23,
236,  0,244,  0,231,  0,179,192,181,153,252, 97, 28,234,108,197,151,110,142,145,
 56,144, 29, 44,249,243,186,250,134,107,243,188,212,179,127, 64, 81,117,243,144,
103,207,125, 24, 54,109,254, 54,177,154, 85,219, 89, 46,163, 25, 79, 12,227,221,
196,110,253, 13,158,125,103,243,106,222,168,150,175, 97, 25,127,220, 45,213, 51,
246,249, 84,195, 52, 56, 80,140,119, 38,247, 44,241, 55, 92,234,117,180, 99,171,
179,117, 54,210, 93,154,243,244,126,233,183,205, 77,196,226,250,108,187,103,221,
124,229,136, 26, 58, 66, 53,108,122,213, 41,151,214, 76,205, 29,205, 36, 34, 20,
119, 20,171, 19, 17,  7, 16, 11, 54,151, 98, 90,113,156,181,140, 90,241,109,171,
 14,197,142, 58, 34,129, 81,255,129, 61,135,112,221, 76,136, 55, 84,239,104,217,
114, 21,115,200,162,154,176, 52,111,222,  8, 10,197,119,122, 22, 52,215,207,194,
177,109, 95,230,184,222,242,142,106, 27,183, 24,170, 10,196,114, 10,214,144,209,
109,179,183,251, 46,169,227,113, 38,190, 44, 78,117, 89, 17,119,112,112, 68, 28,
 28,  2,143,140, 61,195, 39,248,156, 74,168,248,122,158, 95, 23,205,243,186, 38,
216,224, 65,175,237, 50,234,161,255, 14,  8, 26, 12, 72, 83, 39,164, 81,177, 39,
163, 25,165, 29,189,243,248, 26,135, 52,135, 42, 62,244,160, 24,207,182,207,110,
188,250,181,207,183,217,217,154, 43,182, 94, 70, 87,111,229, 40,214, 60,214, 25,
254,208, 84,175, 64,254,208,128,234, 99,249, 41, 16, 16, 21,102,130, 65,130,235,
128,  4,166, 27,139,197, 98,177, 44,203,194, 96,170,  5, 23,128,115,  8, 68,170,
 63, 30, 78,117, 89,240,  0,115,109,214, 98, 80,  5, 22, 18,151,101,113,189,172,
 79, 92, 40, 42, 46,  8,174, 90, 53,237,225, 30,129,136,245,202, 61,235, 25,171,
 55, 99,122, 25, 42,188, 97,239,194, 31,222,209,109, 67, 32, 98,121,229,220,243,
 37,167,220,213,103,220, 89,204,170, 14, 89,158,255,223,225,152,224,112,100,106,
214,  5,200,104, 87,187,239, 88,189,180,163, 25, 15,112, 47, 93,112, 88, 36, 42,
 46, 20,151,136, 12,205, 50,117,  1,107, 48, 50,138, 63,171,101,202,109,180,187,
 20, 65,231,218,140,  5, 84,148, 82,202, 62,  4, 65,  6,205, 83, 57, 83,  3, 65,
 16,230, 18,241,220,186, 84, 84, 19,150, 11,132,119,241,170,169,252, 19, 60,207,
243,188,232,208, 33, 14,246,188,227, 97, 28,229, 40,110, 40,169, 40,165,148,212,
 33,125,138,122, 60,254,191, 30,242, 60, 15,195,243,202, 33, 38, 65, 72,165,212,
103,130, 18,124,228,220,  7,188, 86,  7,229,106,254,124,158,159, 96,166,248,157,
 61, 20,193,210,184,184,231,113,103,184,198,115,200, 31,144,102, 61,183, 46,  3,
149, 63,  6, 60, 84, 14, 35, 20,136,242, 64,200,127,113,138,213,237,149,231, 59,
179,198,181,217,171, 23,195, 52,123,132,  9, 94,156,131, 57, 40, 54, 61,172,185,
118,227,207, 39, 64, 32, 88,131,103,238, 62,224,225,209, 43, 15,132,176,202,205,
174,147, 61,116,251, 50,170, 97,248,143,238,193,217,164, 87,203, 23,247,117, 27,
221,182,121,167,119,143,179,159, 92,198,188, 94, 86,243, 31,127,232,181,116,119,
 75, 41,165,164, 40,138,162, 40, 80,248,247, 60,163,219,195,230,  1, 14,135,164,
104,214,125, 11, 14, 71,  5, 74,222,190,153,161, 25,140, 32,132,221,221,221,221,
 29,187, 99,199, 24,187, 59,198, 24,163,148, 82, 74, 41,165,148,146, 36, 73,146,
108, 73,146, 36,105,154,166,105,154,166,105,154, 38, 73, 75,166,150, 72, 36,146,
169, 91, 34,145, 72, 36, 20, 69, 81, 20, 69, 81, 20, 69, 77, 38,113, 50,153, 76,
168, 56,153, 76, 38,147, 40,138,162, 40,138,162, 40,138, 96,212, 13,163,110,  8,
 33,132, 48,234,238,134, 16, 66,216,221,221,221,221,221,221, 49,198, 24, 99,140,
 49, 70, 41,165,148, 82, 74, 41,229,195, 53,147, 94, 12, 14, 38,201, 40,187,194,
165,175,163,148,231, 52,156,  4, 15,113,156,212,176, 59, 74, 72,253,144,115,212,
134,203,166,221, 78,241,148,160,128,115,207, 53, 44,215, 13, 44,193,219,252,232,
 25,207, 13, 70, 56, 10, 69,132,171,192,193,100,195,216, 16,123,133,110, 38,174,
 32,201,216, 48,130, 19, 74, 50, 77,146, 36,101,140,221, 16,206, 67, 17,162, 55,
148,  1,131, 95,168, 66,139, 25,153, 25, 25, 17,145, 20, 36,  5,201,112,178, 34,
  4,162, 72,146,197,152, 85, 89,  7,146, 40, 26,  5,113,  8,  3, 34,  8,194, 96,
  8,130, 32,  8,130, 32, 36, 67,  4,132,  8,140,128,  8,  8, 33, 70, 41,163, 17,
 86,  7, 72,206, 33,134,209, 51,166, 33, 19, 13, 24, 40,218, 93, 99,210,197,252,
228,203,164, 88,138,138,124, 15, 66,202,138, 63,  6,238,190,172,217,104, 56,211,
 11,160, 70,123, 11, 67, 34,  3, 87, 77,169,137,225, 64, 53, 32, 47,123,159,115,
 64,216,172, 95, 65,150, 29,  3, 39,171,103,242,105,239, 10, 62,150,114,240,139,
217, 39,126,  6,220,160,193, 25,109,156,219,  2,101, 61, 34,194,239,119,127, 37,
108, 17,120,234,147, 13, 54,148,217, 54,233,  3, 69, 71, 38, 35,248, 69, 21,181,
177,122,100,160,240, 61,141,130, 60, 74,  8,216, 51,110,197,205,122,129,227, 23,
 75, 26,206, 80, 39,242, 16,123, 82, 63,229,158,128,170,239,254, 95,242, 43, 30,
 88,100, 90, 17,185,158,167,128,159,138, 60, 36,100,216, 51,110,109,236,186,192,
227,239, 83,241,250,155,  0,148,250,201,190,  5,186,101,109,100,146, 80, 13,212,
 49, 20,202,242,142,133,241,179, 30,208, 68,119,245, 80, 40, 30,186,255, 48, 17,
222,202, 23,196, 37, 11,167, 56, 58,112, 59, 35, 69,226, 96,152,181, 25, 71, 10,
186,122,168,132,234,173,228, 46,244,199, 91, 81,119,146,202, 28,178, 99,160,181,
203, 24,244,158, 63,221,124, 45, 90,136,203,212,204,236,108, 40, 78,198,168,152,
 76,182, 13,  8, 51, 16, 81, 70, 64, 68,176,164, 20,133,183,131,100, 30,230, 66,
151,250, 74,207,219,147,226,184, 38, 90, 51,201, 66,  9, 47,142, 56,101, 48, 72,
168, 76,125,166,240,127,  1, 55,247,217,158, 13,234,189,238,242,162,208, 73,218,
 32, 94,132, 22,105,179,141, 67, 70, 57, 12,180,114,129, 65, 94, 85,226, 28, 70,
 19,225, 83, 51,217, 97, 67,159,169,201,208,116,250,136,251,114,  9,230,206,200,
192, 59,204,116, 33, 38, 48, 89,236,122,210,116, 42,235, 58,240, 46,137,248,132,
146,105,138,236, 44, 52,163, 22, 67, 99,165,161, 96,232,208,114, 34,219,146, 57,
117,219,226,245,137, 25,110,253,169, 20,255,116, 57,  0,117,159,  1,  5, 27,224,
181,161,239, 30,168, 47,193,252,252, 85,198, 62,195, 54,  2, 48, 79, 47,234,156,
 72,182,242,200,158, 19,247,205,104,110, 94,142, 75, 71,183,189,162,173,199,140,
128,227,208, 69,208,194,216,168,217, 12,207, 26,147,141,  3,238,111, 37,131,119,
 91,226, 57, 79, 34,115, 41,209,103,200, 46,161, 50,245,179,  2, 76,119,186,237,
 29,253,254,198,250, 22,228, 39,193,222, 88,214, 41,183, 21,193,109,  9, 27,111,
233, 19,151,189,172,110,120,198, 70,196,107, 71,177,122,162,216, 13,119,166,162,
213,160,198,207,223, 51, 49,227,  8,224,102,  8, 11,218,  1,189, 28, 60,209,109,
 21, 71, 62,169, 40,253,175,205,130,204,200,195, 95, 58, 10,146,120, 35,153, 93,
116, 26, 27, 23, 69, 72,251,109, 45, 40, 61,  2, 16, 36,229,143, 64, 59,172,108,
211, 57,211,244,214, 60, 89,210,145, 29,  2,  4,134,170, 40,107, 13,141, 35, 27,
 81, 46,208,206, 27,178, 87, 12, 85,156,213, 89, 92,181,204,167,162,210,116, 28,
 37, 47,214, 92,102,124, 62,152, 34, 91, 84,194,244, 30,255,141, 73, 20, 99,238,
168, 46,195, 15,208,180, 49, 29,117,212,176,119, 40,112,162,190,162,192, 53,186,
227,174,216,158,170, 16, 94,154, 34,164, 20,133, 91,233,137,218, 82, 19,  4,210,
 18, 50,164, 36,  2,144,142,112, 39, 21, 81, 34, 13, 65, 71, 10, 66, 70,244, 67,
128,168,  7,119,160, 29, 42,225,181, 13,129, 41, 76,209,229, 71, 39,132,  7,158,
224,251,137, 45,101, 12,167,114,133,185,142,158, 12, 46, 71, 85, 93,212,221, 81,
254,130, 59,207,200, 36,166,243, 94,  0,221,202,  8,168,149,193,222, 43,144,  5,
238,152,  5,102,206,157,218,205,141,128, 40,125, 64, 54,181,129,224,194,  5,252,
105,  2,213,203,  3,168, 45, 41, 11, 24, 17,128,134, 19,192,131, 36, 59,168,102,
132, 18, 40,196,169,202,234, 95, 71,206, 36,213, 80,199,163,200,193, 73, 68, 41,
143, 22, 98,199,251, 81, 69,202, 39,128, 53, 26,143, 90,113,117, 17,117,  4,178,
  9,243, 14, 17, 55,174, 32,165,177,175, 81,217, 31,187,156, 27,195,206,108,110,
 98,212,103, 62,252, 22,103, 27,136, 76,227,243,156,102,197,107, 67,177,126,241,
143,162,178, 99, 17,  7,232,152,  1,219, 64,123,228, 31, 73,247, 13,191,128, 12,
 35,110,221,143,182, 60, 64, 80,205,135,160, 10,225,165, 49,178,187,206,132,159,
 76, 22,201, 12,190, 86,235, 98,254,100, 76,226, 69,137, 21,162, 76, 70, 84,108,
 58,213, 62, 87, 85,212, 83, 92, 86, 92, 96, 27,190,214, 85, 43,133, 23,178, 66,
201,174, 24,216,220,108,181,107,137, 93, 87,159,  3,195, 10,162,175, 68, 96, 30,
203, 83, 49,152, 14,  5,124,185, 50,242,  4,130,126,107,249,190,178,154, 94, 85,
 75,166, 22, 54,245,166,156, 90, 85, 74, 76, 11, 69, 10,159,115,224,206,208, 47,
135,206, 28,185,101,224, 48,  3,  0,105,  0,238,  9,106,145,177,100, 39, 94,148,
 68,230,160,215, 24,202,136,211,243,220,195, 59, 70,172,181,103,226,149,115,232,
 89,208,185,218,157, 10,195, 71,167,203,182,178,149,244,131, 79,156,161, 15,114,
 89,249,204,149,  2,226, 36, 22,147,240, 89,164,177, 90,102, 76,176,133, 66,132,
110,135,137,105,200, 70,186,108, 39,121,216,224, 89,  3,190,173,200, 23,103,114,
177,249, 33,180, 22,245, 16,143,191,201, 47,252, 50,177,133, 90, 31,133,106,248,
 86, 33,153,192,171,146, 76, 25, 26,149, 12,129,204,177, 94, 50,201,224,131,207,
141,105,156, 95,  9,164,110,202,195,217,127,139,225,116,143,145,157,169,211, 49,
192, 51, 45,199, 66,  4,148, 13, 70,121,153,253,251, 77, 95, 69, 16, 63,162, 48,
255,219,224, 44,234, 69,231,213, 88,  9, 96, 45,190, 42,238,140, 63,222,106,199,
203, 52,241,190, 70, 50, 64, 33,  4,  6, 86,241, 79,  3, 96,174,161,104,159, 42,
112,205,192,123,248, 21, 40, 95, 47,136,170,209,216,186,248, 32,112,171,200, 79,
 41,  2,146,112,255,243,146,156,134,103, 67,139,244, 74,128,189,158, 94,140, 66,
 77, 24,162,130, 42, 85,222,118, 72,212,193, 82,148,251,186,155,243,  4, 66,176,
115,  6,170, 14, 99, 22,243,104,255,206,240,252,152,235,135,216, 27,218,181,233,
 52,105, 24,110,131, 34,198,192,215,  7, 15,142,152,186, 66, 81,134, 35, 94, 73,
 89,157, 43,155,229,195, 32, 15, 65,197, 77,186,231, 82,128, 11, 25,193, 99, 17,
 30,148, 21,234, 71,198,134, 66, 61,111,  2, 82,204,245,170,234, 51,108, 62, 62,
161, 62, 53, 56,104,154, 51,210,147,227, 12,216,189,200,172,235,250, 38,215,183,
 68, 35, 20, 57, 26,137, 47,162,183, 23, 72,154,133,240,139,225, 56,230,144,101,
214,255, 46, 85, 25, 14, 86,194, 91, 33,223,253,222,255,110,128,212,186, 26,160,
 78,136,162,215, 67,133,236,157, 98,196,100, 44,163,168, 98, 91, 80,195,105,128,
145,214,105,101,165,211,147,203,252,215,132,228,165,102,165, 86,171,235, 13,198,
110,112, 27,215,104,228,185,213,174,172, 80,146,123,232,106,114,224, 67,172,192,
188,114,244,219, 10,142,129, 11, 49, 74, 12,235,229,  4, 95,167,196,248,156,130,
156,222,206, 80,198, 66,132,115,189,240,139, 32,229,225, 29,  3,  4,133,121, 16,
 13, 90, 23, 68, 56,108, 98,187,142,161,138,182,226,207,247,138,200, 49,132,155,
157, 75,198,167, 83,120,  3, 47, 16,230, 67, 67, 35,245,250,168, 52,251, 35,170,
207,174,150, 10,248, 93, 62, 37,212, 44,108,115,  3,113,167,178, 96,253,183, 85,
 24,227,188,203, 39,185, 95, 61,171, 83, 26,204,228, 50,  9,130, 42, 73,178,110,
151,197,165,229,227, 93,158,226, 80,121, 91, 31, 78,155,141, 95,194,123,253,153,
234,181,135, 95,245,217,241,160,209,232,216, 86,230,219,116,127,119, 41,120,118,
171, 42,100,231,194,187,143, 17,169,150,191,147,242,122,226,  4,198, 74,165,204,
175,  3, 52, 92,  8,128, 96,164, 14, 13,  9,234, 95, 96, 82, 49, 41, 12,110,133,
 30,203,139,221,239,191, 87, 49,238,114, 92, 12, 71,165,255,227,172, 99,210,151,
 47, 53, 47,140,240, 42, 11, 88,192, 90,152,128, 51,187,128,156,225, 13, 81,104,
190, 81,136,240,232,226,189,204,119,179,219, 66,162, 96,176,200,197,150,125,201,
155,130,253, 38,170,141,224, 50,149,192,212,230,138,106,118,177, 19,102,253, 46,
199,247, 49,113, 61,  5, 54, 93,104,169, 26, 76, 73,102,124, 37,183,144,199,144,
 53,190, 74, 31,174, 16, 27,195,230,130,212, 88, 44, 33, 39,205,227,169, 33,149,
244,180, 68,172,179,228,135,163, 85, 16, 19, 23,
} ;

// ../Source/Template/GB_Template.h:
uint8_t GB_JITpackage_41 [791] = {
 40,181, 47,253, 96,135,  9,109, 24,  0,166,171,125, 36, 16,115,219, 61, 14,101,
196, 77, 68,224, 69,220, 73, 52,151, 98,224,169,251, 85, 40,131,165, 43,222,121,
217, 77,198, 62, 85, 85, 13,170,252,  6,124,  0,111,  0,116,  0,141, 68,  4,113,
121, 42, 22, 19, 16, 19, 51, 56, 53, 64, 99,224, 80, 38,220,214, 82,143, 50, 72,
238,169, 31, 50,131, 38,236,144, 87, 87, 38, 26, 15, 22, 14,227, 15,201,206, 23,
234,223, 56,250, 66,157,123, 84,130, 64, 49,160, 76, 22, 14, 12, 40, 58,176,  4,
 84,226,253,177, 15,234, 60, 90,181,143,175, 47, 42,177, 60,149,134, 70,173,140,
 96, 96,151, 75, 89,248,123, 90, 26,103,177, 61, 63, 85, 25, 39,117, 24,251, 27,
246,196, 76, 25,154,195,191,142,122,124,137, 26, 34,180,160,160,153, 20, 20,  4,
 14,213, 83,143,213,249,197,197,146, 62, 20, 85,198, 73,217,162,234, 68, 34, 10,
123,242,174,167,148,137,108,155,107,229,220,194,216, 15,249, 33, 36, 99,166, 98,
140,  6, 48,108,  7, 91, 87,255,190,  7,168,254,106,249,206, 82,185,189,178, 99,
112, 91,132,157,212,222, 31, 19,201, 62, 55, 46,158,139,  6,168,194, 28, 43,249,
195, 57, 96, 67,185, 25,201,174,169, 23, 87,164, 57, 31,204, 34,202,108,186,  5,
155,163,213,212, 44, 62,253,109,223, 48, 64,149,  4,210,206,174, 39,  8, 10,168,
 66,  1, 69, 14,208,229,185, 88, 38, 64, 51,240, 60, 96, 48, 73,157,235,140,192,
130,115, 82,117, 11, 37, 63,236,166, 97,248,214,151,145,162,166,235,  7,192,200,
214, 47,165,171,222,234,221, 46,170, 14, 59,105,217,178, 84,102,152,125, 62, 53,
190, 74,158, 88, 82,234,250,112,219, 29, 28, 56, 40,100,161,120, 20,198,247,217,
161,222, 42, 97,239,140,228,246, 21,170, 78,108, 54,223,162,110,167,119,134, 90,
 38,162, 40, 34, 33, 32,  8, 77, 51, 53,131, 12,208,172,149,156,219, 69, 61,106,
 98,162,100,170,114,243, 69,  9, 10, 47,249,127,151, 71,212,190,111,137, 87, 59,
110,  0,121,190,183,249,182, 95, 83,190, 71, 24,223,167,112, 68,199,150,101,123,
136,145,156,169,100,124,252,114,185,165, 23, 67,218,146,203, 30, 85,114, 97,123,
148,107, 95,212,126, 31, 79,143,165,226, 75,118,119,199, 80, 50, 38,154, 30,182,
244,213, 47,254,194, 73, 49,131,253,110,238,196,204,249,  3,107, 32, 48, 68,168,
144,157,117, 75, 11,102,231,130,151,241,200, 28,  0, 48, 46,162,114, 98,152, 88,
162,222,178, 80,106,224,122,224,152, 20, 28,183, 61,242, 53,123,204, 36,222, 51,
168,153,192,130,234,210,195,122,183, 35,117,175,132,231,212,183,231,149,231, 34,
178,104,250,222,127,240,204,113,158,101,  2,154, 93,  0, 89,143,  0,207,244, 89,
131,147, 65,250, 97, 67, 63,148,169,124, 43, 97,245,  6,114,112, 19,168,147,129,
 53,129,223,255,142, 86, 48, 72,194,198, 48,110,114,130, 66,193,116,161, 65,147,
240, 57,  7,136,227,134,135, 62,  2, 56,109,137,255, 29, 22,187,129, 67,237,172,
184, 23,207,208, 10,236,  9,173,112, 71,  2,148,220, 95, 98, 25,191, 17,200, 91,
172,233, 96,206,194,197,194,113,  2,180, 27, 13,216,215, 26,125, 56,194, 25,105,
 87,  7, 96, 32,  1,187,190,248,206, 54,120, 45,136,  8, 16, 71,142, 58, 66, 88,
  8,234, 46,190,216, 42,191,169, 49,  2, 60, 90,206, 91,221,194,169, 81,154,  6,
 40,211,134,112,  1,218, 82,159,112,214,204, 79,185,152,  3,112,209,115,226,171,
139, 12,214,  1,  0,157,233,114,154,189,205, 43,132, 61,104,102,158,153,110, 67,
100,181,126, 32, 58,123,125,159,162, 96,  8,
} ;

// ../Source/Template/GB_add_bitmap_M_bitmap.c:
uint8_t GB_JITpackage_42 [714] = {
 40,181, 47,253, 96, 82, 17,  5, 22,  0,198, 91, 88, 32,224, 90, 55,224,207,180,
 99,154,225,243, 48,154,240, 16, 31,196, 35,115,234, 90, 59,108, 62, 52, 39,148,
 36,204, 16,105,196,132, 80,  0, 76,  0, 77,  0,251, 51, 97,144,231, 76, 29, 99,
 44, 18,139, 67, 67,145, 88,120,129, 35, 56,166,113,234, 90, 28, 65,125,245,109,
 17,196, 33,199, 54,218,169,223,120,201, 12,228, 53,121,199,237, 55, 46,183,153,
115,233,101,154, 99, 94,113,172, 26,232,132,162,  9, 36, 21,135,104,118,188,224,
198, 37,219,117,215,214,140,103,217, 60,100, 89, 88,251,234, 83,247,243, 74,243,
 37,203,205,149,228,214, 95,230,155,114,242,191,141,223,187,240, 58,182,197,176,
251, 29, 62,248,121,  4, 69,206, 49, 39, 69,215, 52,246,202, 76, 32, 22,135,255,
184, 59, 82,135,144,143, 61,188,195,239, 52,135,215,225,115,184,115, 24, 89, 62,
136,238, 83,228,235,  7,185, 14, 19, 63, 97,208,179, 40,150,124,146,188, 48, 18,
 62,196, 27,141,102, 67,151,140,173, 25,119,239,187,176, 20,212, 74,105,196, 11,
238,114, 89,141,173, 70,240, 16,232,178,109, 20, 32,113,255,106,160, 62,113,138,
 38,241, 74,196,221,125,206,214,156,136, 15, 69,223,250,126,246, 93,150,124, 95,
144, 20, 61, 95,237,115,190,220,189, 53, 61,220,133,143,215, 14,242,199,213,151,
 85,199, 52,206,255, 10,112,136,198,194,  6,252,187, 50,115,225,183,159,188,181,
211, 17, 97, 62, 84, 11,105,170,221, 52,150, 18,188,213,185,120, 64, 23,142, 13,
105, 54, 30,  6, 20, 44, 74, 95, 15, 71,188,240, 44,172, 65,199, 84, 27,173,104,
131,129, 99, 37,205,214,128,161,160,241, 37, 83, 35, 19, 68, 83,144, 20, 50,173,
  1,112,136, 12, 17,217,230, 19, 40,139, 51, 69, 74, 69,185,141,176, 84, 20,177,
 45,161, 78, 52, 44, 62, 10,155,196, 89, 92,233,174, 24,118,128,116, 23,138,217,
145, 19,231, 67,179, 57,248, 52, 61, 24,115,231, 61,100,129,168, 47,  1, 22, 70,
238,152,113, 13,200,204,156,146,198, 79, 70,244,  8,184,108,214,162, 67, 71,225,
 88,174, 96, 38, 27,231,152,251,  0,117, 50, 25,220,240, 60, 83,180, 44,117,205,
211,137,156, 74,  4, 37,100, 81, 52, 64,146,128,185, 76,220, 22, 79, 68,112,129,
200, 39,168,195, 30,150, 11,135,177, 96, 36,208, 10, 30, 58,  2,131, 35,160,243,
160,  5, 60, 87,129,199,  0,132,103, 36,127,  5,141, 90,192,111,  4,148, 93,112,
 13, 28, 52,240, 36, 65,102, 95,176, 28,235, 23,  5,  8,221, 39, 96,230,185,125,
 59,146, 84, 92,220,211, 73,196, 13,128, 29,169, 71, 24,219,107, 81,154,144,232,
226,184,209, 70,  8,186, 56,106,180, 17,131, 49, 30,233, 71, 27,126,232,146,113,
129, 90,134,145,  5,112,217, 72,193,128,194,225, 35,100,162, 72,113,227,109, 80,
140, 93, 21,166, 51, 62,103,180, 93,190, 29,240, 22, 25, 67, 51,  6,107,132,114,
153, 46,204, 25,194,215, 97, 35,240, 54,247,215,226, 68,169,159,214, 87, 25, 98,
161,148, 64, 81,  9, 48,222, 41,131,180,233, 32,219, 96,  4, 23, 32,118,159,105,
255,148,245, 70, 93, 29,194, 13, 20,126,166, 25,180,105,110, 84,102,106,159, 96,
197, 46, 25, 20,181, 35,113,113,154,102,164,232, 36,  3,
} ;

// ../Source/Template/GB_add_bitmap_M_bitmap_27.c:
uint8_t GB_JITpackage_43 [842] = {
 40,181, 47,253, 96,201, 11,  5, 26,  0,230,229,115, 40,208,240, 56,  7,254,167,
122,237,247, 13,176, 93, 64,190, 21,166,199, 48,226, 25, 38, 84, 71,207, 23,252,
 46, 30,172,172,114,205,252, 69,174,102,192, 11,231, 11,108,  0, 98,  0,104,  0,
242,110,157,113, 36,109,183,198, 36,131, 36, 66,243,153,100, 77,170,109,219,225,
246,106, 22,210,225,115,194,191,  1, 75,197, 34, 49, 16,168, 88, 14,193,168, 63,
 43, 73,172,249,  4, 94, 67,187,220, 72,134,254, 64,144,161,210, 40,215,205,165,
109,101, 10,234, 43, 59,208, 52,103, 39,162, 84,207, 54,254,131,127,157, 99,110,
253, 85, 17,152, 73,232, 60, 16,172, 95, 12, 44,157, 72,121,116,229, 21,179,140,
 99,181, 57,133, 50, 73, 40,148,242,242,181, 84,207, 46,107, 13,179,135,108,209,
162,108,198, 93,181, 27, 71,157,232,179,231,228,202,244,116,196,157, 71, 22, 92,
233,  3,243, 76,222,223, 77,102,156,118,187,243,255,159,166,210, 52, 77,180,203,
 93,239,202,112,114,237, 46,214,213,107,187,155, 76,122,109,237,202,190,220,150,
245,221,122,212,147,142, 56,236,239,149,123,199,202, 91, 83,101, 98,145,180,134,
 49,133,191,212,150,162, 21,245,234,250,187, 32,117, 24,171,106,243,204,249, 55,
 30,100,125,187,190,190, 49,102,157,179,127,221,213,123, 43, 15,185,120,146,186,
144, 35,234, 34, 74,125,129,211,137, 33,133, 13,194,233, 49,207,252,239,109,108,
 24,245,  6, 15, 39,196,  9, 57,192, 79,196,176,124,255,178,173,233,223,173,124,
 45,253,141,  4,  5,165, 72,228,  8,199,188,242, 12,  5,177,147, 73, 27,118,137,
 80, 27, 39, 47, 86, 63, 81, 28,130,  5,211,212, 81,185,220,118, 43, 51, 47, 69,
176,103, 94, 65, 39,126, 89, 16,222,230,219, 23,100,145,204, 54, 43,114, 55, 86,
 81,226,227,177, 94, 85,158,140,217,200, 26,157,220,240, 32, 31, 29,  2,148,173,
 39,233,  0,167, 22,245,143, 71,  1,196,129, 80,168,170,139,179, 50,210,191, 12,
248,119, 33, 89,  3, 61, 12,213, 35,240,153, 91, 47, 65,174,  7,  4,156,219,206,
190,206,193,113,198, 52, 26, 24, 61, 32,142,168, 51,145,124,  4,128,156,160,145,
 37, 51,138,208,136,140, 36, 73, 10, 25,214, 64,132, 24, 67,102, 55,  7,201, 98,
 63, 80,156,107,171,178, 51,142, 24,180,114,176, 32, 86,113,113,222, 29,  0,141,
 43,116, 11,243,216,  0,204,123, 89, 32,156, 76, 76, 64,  8, 92, 72,151,  4,120,
112,227, 37, 29, 47, 68, 59,134,136,102,211, 40,198, 19,153,125, 97,241, 36,114,
 61,205,  2,  3,218,230, 65,245,226,181,179,251,104,164,201, 71,184, 13,140, 44,
 16,223, 15,  8,  7,  4,  3, 12,168,182,253, 42, 32, 79,161,243,192, 37,244,154,
 33,104,131,192,236,231, 95, 10,224,242,224,246,178,133, 14,143,106,236,126,101,
225, 12, 50, 76,  2,202,  0, 78,232, 46, 38,118,102,181, 60,143,229,154,192, 68,
193, 45,  1,215,  0, 20, 38, 96, 13,120,  6, 65,119,  1,123,154, 15,139, 46,159,
 12,  3, 34,205, 96, 56,135,199, 28, 78,220,228,231,172,203,120,146, 52,  1, 62,
 68,128,240, 87, 53,192,185, 57,161,232,240, 10,166,130,  0,210,237,143, 26,217,
  2,183,  2,194,144,255,190, 41,211,173,225,192,255,203, 94, 45,157,234,123,203,
 29, 19,199,205,210,172,166, 95,255,219, 63,103, 78,201,106,178,201,166,201,206,
 63,147,216, 37,228,152,117,249,168,  1, 54,214, 48,122,193,134,206,110,207, 74,
210,218,199, 58, 14, 64,  1,103,202, 75, 20, 22, 26, 21, 53, 43, 10, 63, 50,138,
237, 22,195,109, 20,204, 84, 23,  7, 99, 55, 10, 89,200,237,104,196,105,190, 73,
100,133,164,121,110, 73,183, 64, 49, 97,104,212,118,211,110,180,201, 12, 92,124,
211,124, 84,102, 98,  7,189, 54,255, 56,122, 14, 93,127, 17,251, 57, 68, 82, 20,
220,  1,
} ;

// ../Source/Template/GB_add_bitmap_M_bitmap_28.c:
uint8_t GB_JITpackage_44 [1138] = {
 40,181, 47,253, 96, 77, 16, 69, 35,  0,198,235,132, 40,192,208,170, 14,248,125,
236, 97,162,  9,185,  8,203,  6, 37, 52,207,181,239,170,123,108, 61, 47,174,196,
 82,165,150, 92,  4,216, 75,192, 52,  9,  2,  0,150,207,126,  0,116,  0,122,  0,
151, 36,129, 80, 30,189, 97,244,198, 87,190,174, 90,205,182,179,204,163,177,109,
172, 50, 60, 34, 46, 28, 72,214,163,175,113, 59, 28,231,205,162, 58,156,227,226,
225,  0, 69, 66,121, 24, 76, 36,148, 59,176,233, 16,215, 17,189, 28, 18,143,177,
101,175,171,158,195, 78,100,144,219,165, 31,166,210,248,163,183,211,185,138, 58,
210,215, 23, 99,139, 64, 46,190, 60,228, 56,145, 22,137, 80,243,234,215,161,164,
162,133,160,  1,176, 92,175, 28, 80, 52,243,210, 46,215,207,204, 50, 58, 37,230,
145,136,244,136, 68,  2,182,239, 97,254,238,243, 36, 40,208,160,168, 91,170, 75,
110, 77, 14,108,177, 10, 53, 89,175,102,236,187, 68,113,  7, 86, 51,205,120,106,
 78,148,245,134,225, 59,236,188, 38,156,209,254,182, 60, 59,145,118,174, 57,122,
127, 59,239,180,179,160,223,  5,168,158,213,252,108,171,124, 21, 51,111,203,173,
249,255, 75,146,134, 36, 65,112,228,232, 39,202,152,232,203,184, 69, 28, 29,253,
235, 45,215,126,102,233, 97,246,108,214,217,118,215,220,237, 60,236,159,119, 13,
174, 15,119,226,159, 75,210,106,102,175,233,229, 25,167,  4,103,115, 53,230,122,
 35,242,123,104,155, 27, 61,224,247, 18,252, 40, 71, 49, 60,175,233,156,141,135,
235,188,135, 23,241, 16, 84,233, 37,110, 24,104,238,207,169,120,235, 14, 16,172,
 83,195, 67, 66, 39,  3,145, 48,233,229, 18,231,166,147,209, 58,179, 90, 61,252,
196,233,113, 74,137,185,117,250, 60, 15, 14,170,221,116,237, 78, 95,200,104,166,
 39,  1, 99,169,110,253, 16,102, 88,108,122,195, 38,227,201,120, 28, 34,103,134,
 48,205,135, 89,146,180,177, 65, 81, 19, 73,183,203, 81,208, 97,149,242,115,199,
228, 22, 86, 79, 89,151,119,226,181, 90,170,203,207,203, 88,143,190,229, 16,168,
 71,244,203,  2,214,175,  9,117, 57, 16,194,208,148,119,122,228,132, 14, 55, 57,
 93, 78,  5, 16,174,142, 16,172, 76,242,154,119,223, 91,126,102,171,102,169,254,
234, 21, 19,150,  9,196,106, 71, 45, 70, 38, 41,  2,216, 82,148,171,110, 97,235,
 12,245,148,183,222, 88,229,176,156, 25,127, 85, 11,  9,100,108, 61, 76,114, 13,
138,222,122, 69,129,  7,168,225,169, 34, 51, 34, 34, 35, 73,146,100, 89,  3, 49,
 12, 66, 97,144, 91, 73, 61,194,136, 68,138, 50, 12, 75,128,136, 35, 68, 25, 66,
  8, 18, 24,162,132, 34, 73, 19, 73, 65,242, 84, 73, 13,213,121, 90,191,155,  8,
 32, 68,218,144, 35,162,229,163,179,100, 17,  1,  9,250, 65, 41,  4, 31,161, 81,
177,175, 38,194,127,142,107, 22, 46, 21,169,127,143,188,247, 26, 97, 28, 20,247,
223,240, 12,251, 95, 16,165, 21,  8,133,166, 61,118,  2,127,163,186,117,224,  1,
191, 53,242,233, 12, 51,224,215,123, 24,206,139,219,100,121, 29, 79, 75,  5,146,
 34,249,193,195,118,  9, 31, 67, 80, 80,  3,183, 90,117,233,231,230,221,111,131,
102,104,119, 53,236, 35,237,230,254, 45,223,102,151, 72,200,207,147, 85,109, 29,
207,166,102, 65, 48, 29,184,111,254,208,239, 42,  9, 11,245,140, 47, 35,134,185,
 18,126, 45, 94,168,169,237, 92, 66,167,134,171,193,244, 50, 27,191,133,136, 40,
107,223,100,254,148, 46,218,135,121,254,227,235,153,172,167,139,176,  2,152,145,
103, 52,231, 50,114, 26,218,132,  5, 26,152,182,160,195,153, 11, 39, 54, 90, 14,
 25, 22,110, 80,214, 39,  1, 79,147, 31, 49,155,217,  1, 55,  5,169, 84, 15,206,
144,168,205,177,143, 58,250,121,124,246, 44,195, 88, 67,165,  0,117,238, 77,144,
197, 32,138,161, 52, 33,109,192,221, 82,141, 67,  2,104, 77, 63,151,208, 25, 66,
123,250,154,189, 46,164,161, 16,  8, 71,  1, 56, 96,231, 31, 94, 30,198, 36,105,
200, 90,109, 31,224,231, 91,241, 85,253, 20,188, 35, 45, 78,121,236,138,205,241,
 47,174,228,  7, 68,171, 54, 69,152,121, 18,208,235,148, 53, 47, 84,109, 59, 87,
 34,208,212,115,154,125, 84, 16, 57,146,135,153,  1, 76,254,  0,189, 60, 29, 22,
248, 27,198,228,106, 87,  5, 91,208,250, 86, 34,193,221, 94, 54,134,192,106,150,
188,136,206, 27,172,116, 36,152, 24, 56,  2, 63,165, 19,249, 14,195, 93,158, 23,
  1, 67,160,125,174,171,211,150,218,116,220, 75, 53,136,215, 31,102,222, 27,199,
240, 87,172,226,157, 82,221,117,220,  7, 94,196,175,160,111, 19,222,159,164,231,
223, 82, 84, 50,107,235,230,205, 76, 77,135, 14,139,169,157,103,  9, 26, 48, 64,
134,118,248,242,  3,128,200,174, 73, 29,248,117,195,252,195,239, 46,224,250, 13,
163, 51,190,206, 83, 64,  3,171,246, 62,  3,242,204, 40,  0,216, 28,101,180,174,
231, 21,227,252,224, 97,162,238,220, 20,247, 71,161,243,196,215,136,206,215,217,
133,100, 62,255,168,228,202,169,135,243,111, 36, 61, 80,157,228,166,105, 85,102,
 50,151, 74, 89, 39,165,166,183,235,151,108, 63,133, 78,149,  6, 56,  1,
} ;

// ../Source/Template/GB_add_bitmap_M_bitmap_29.c:
uint8_t GB_JITpackage_45 [1142] = {
 40,181, 47,253, 96, 77, 16,101, 35,  0,166,235,132, 40,208,208,234, 24,248,109,
148, 89,  1,171,114, 85, 85, 75, 52,197, 54, 54, 21,205, 35,168,240, 58,116,167,
 88, 53,228,  6,197, 93,221, 34, 87, 51,224,  7,179,  4,127,  0,116,  0,123,  0,
 87, 36,129, 80, 30,148,203, 38,142,175,100, 90,183,186, 47,213, 50, 15,170, 47,
205,170,195, 99,  2,195,129,104, 52,148,169,166, 16,215,155,195,168, 16,183, 54,
 30, 14, 80, 36,148,135,193, 68, 66,249,148, 73,135,186,134, 38,230,144,120, 13,
110,127, 94,245, 28,118,162,131,197,225,153, 23, 42, 84,231,137, 59,116, 87, 80,
 39,202, 20,107,112, 17,  8,214,143,135,214,130,182,136,  5, 53,183,252, 58,180,
168, 88, 37,104,  0, 46,215, 43,  8, 20,141,196,211,219, 21,147,154, 54,165,181,
240, 72, 36,122, 68, 34,  1,135,218,165,248,112,103,252, 45,  9, 10, 56, 40,234,
 23,203, 37,175,164, 73,223,172, 66, 73,247,171, 59,203,143, 44, 62,101,117,207,
173, 37,106, 65, 26,229, 50,253,233,202, 75,210,218,164,153,219,210,  3,109,183,
212,218,249, 79, 15, 99,102, 12, 96,185, 86,247,247,173,241, 22, 75,251,184, 77,
 53,255,255, 40,226,136, 34,136,182,236,204,160,157,129,242,214, 20,100,103,232,
153,114,187,210,107,119, 30,238,239,106,116, 95,234, 81,139,189, 47,123,254,174,
209,245,  1,213, 47,112,197,177, 43,218,170,118, 47,249,109,105, 73, 10,206,230,
186, 69,181,165, 29,145,227,195, 75,109,232,  1,199,135,121,218,153,105,121, 73,
231,108, 62, 93, 37, 62,204,176, 14, 63, 21,195,196,141,131,117,234,147,195,118,
190,250,244,129, 85,122,136, 80,232,100, 36, 20, 36,134,193, 68,185,233,100, 54,
170,221,173, 30, 98,150,116, 75, 90,213,177,111,121,240, 79,245,164,111, 88,122,
 67, 70, 35, 61, 10, 11, 23,203,171, 31,194,141,155, 73,127,216,100, 60, 25, 15,
 68,228,200, 78,207, 29, 81,212,209, 65, 81,147,184,233,220, 20,251, 28,214,199,
 56,169, 56, 77, 94,101,245, 84,245,136, 43, 94,235,197,242,152,191,157,209,208,
185,221,193,233, 67, 67, 51,111,129,234,215,132,194, 28,  8, 97, 39, 35,230,116,
135, 92,148, 30, 37,195, 71, 87,110, 79, 29,172, 72,241,219,135, 79,185,125,237,
214,237,242,174,187,229, 23, 21,151,  9,204,170, 55,175,134, 22, 41,  2,250, 82,
211, 98,220, 42, 59, 42,227,171,211,172, 90, 29,229,214,185,110,157,192,214,247,
203, 36, 20,246,129,  9,168,193,173, 50, 51, 34, 34, 35, 73,146,100, 89,  3, 65,
 12,130, 48,200,173,164, 30,178,120, 88, 16,165, 24,150,  0, 17, 72,136, 81,132,
  8,140,224, 72, 73, 80,177, 50, 75,218,  6, 68, 73,165, 83,121,186,183,155, 11,
 64, 56,216, 80, 42,226,171, 71,143, 37, 45, 10,176,173,231, 39,202,178,167,209,
 76,196,155, 73,163,190,192,152,113,172,149,226, 33,  3, 89,113,130,209, 91, 26,
 13,252,167,237,185,141,210, 61,133, 66,209,158, 68,224,135, 81,125, 25, 48, 74,
198, 30,103,151, 60, 28,200,255,104,115,202,181, 18,244, 98,160,216,199,145,200,
  2, 81, 34,249,133,234,181,242,145, 20, 26, 53,121, 34,137, 46,158,140,223, 59,
 11,136,172,237,144,200,254,  4,184,206,191, 47,110, 69,192, 36, 68,243, 36,177,
182,199,179, 71,179, 18, 92, 15,252, 57,247,251,  1, 74,250, 72,189,242,185,199,
 80,113,165,184, 40, 87,162, 62, 19,221, 26,233,182,251,209,106, 44,  7,201,132,
 91, 15, 38, 68,211,247, 72, 25,134,243, 63,107,101, 51, 52, 45,114, 24, 48,214,
204,150,200,185, 93, 20,210,210,180,130, 52,125,118,212,248, 33, 85,204,204,246,
152,179,195, 88, 31, 72, 18,164,153,253,  6,108,230, 38,220, 96,184,168, 84,114,
 74,130,  0, 56,136,252,253,107,244,100,189, 34,  8,245,198, 85,197, 54, 97, 22,
149, 40,134,210,139,105, 67,220,138,106, 30, 72,136, 86,240,195, 35, 62, 67,104,
 99,158, 51,240,  4, 80,224,150, 15, 83,192,  6, 16,254,  4,151,196,216, 30,141,
165,150, 62,241,  8, 12,127, 44,254, 74, 48,121,182,209,226,138, 71, 90, 10,116,
228,197,136, 27,180,159,108,232,  9,195,240,102, 42,157, 30,128,169, 16,200,215,
214, 94,153,183, 54,191, 15,  9, 87, 38, 11, 83, 51, 99,206,221,162, 90,  9,174,
 35,122,212, 37, 94, 66, 86,231, 45,153,125,155,  8,227,239,170,219,250, 50,140,
 52, 24,253, 28,216,234,114, 24,210, 58, 82,253,244,167, 22,118,133, 91, 47, 31,
 22, 76,  9,237,187, 46,  8, 44,237,230, 52,160, 75, 72,152, 97,190,190, 34, 51,
135,156,196,191,176, 18,127,114, 48,245, 33,156, 16, 26, 23,157,198, 76, 56,126,
172,159,215, 77, 65,242,172,175,155, 69, 51, 56, 61,138,176, 76,237, 54, 75, 20,
 81, 61,180, 49,247, 95,115,  1,143,108, 72,106,250,175, 47,230,141,252,  2,196,
209,239, 18, 61, 51, 67, 96, 78,202,224, 61,142,202,160,207, 64, 61,195,133,159,
205, 81,162,133, 61, 23, 49,206, 12, 30, 26,117, 90,167,184,122, 20, 18, 79, 72,
205,118,126,214, 21,  4,136, 50,137, 74,143,156, 50,112,248,198,249,  2, 41, 68,
110,154, 87,101, 38,122, 73, 17,215, 73,254,116,164,250,157,228, 39,106, 73, 15,
235, 24,
} ;

// ../Source/Template/GB_add_bitmap_M_sparse.c:
uint8_t GB_JITpackage_46 [1476] = {
 40,181, 47,253, 96,  1, 24,213, 45,  0, 54, 57,167, 39,192, 24,113, 14,192, 31,
182,239, 46,215, 70,243, 71,229, 27, 33,230,190, 58, 95,  0,254,168, 32,130,243,
100,196,143, 25,  8, 14,176, 44,130,128,178,168, 64,158,  0,147,  0,159,  0,152,
  1,195,248, 74,151,223,235,190, 74,182, 76,248,174,174, 54, 35,246, 19,184,231,
208,102,135,107,157, 51, 85,200, 26, 63,218,167,104,191, 19, 29, 96, 50,  5,156,
 89, 43,167, 59, 76,110,172, 43,228,203,162,128, 41,100,171, 51, 10, 62, 34, 54,
 48, 23,135, 38, 83,230, 56,173,153, 72,115,252,189,233, 46, 33,115,144, 41,104,
 64, 56,200,220, 98, 73,119,180, 67, 27,113,204,244,147,172, 70,173, 59,238, 60,
 83,  6, 39,147, 59, 41, 60, 92,123,243, 68, 24,169, 69,235, 23,220, 79,150, 39,
153,193,169,187,119,238, 56,151,105,  3, 65,  1, 60,116,238,192,116,174,164, 21,
 85,201,213,106,127,170,235,218,138, 67,113,  3,131,168,192,192, 32, 60,179, 90,
105, 27,252,227,247,118,174,188,212,226, 87, 19,217, 41,  5, 50,  4,115, 43,149,
 20, 68,183,194,203, 62,205, 69, 96, 87, 32,174,168,111,206, 86, 63, 74, 85,149,
206,198, 64,  4,175,149,  2, 67,172,208,162,152, 56, 25, 37,214,191,221, 72,248,
117,251,212,134,123, 71, 29,139,135,147,107, 93,  9,251, 21, 50,229, 41,105, 83,
231,201, 89,201,198,159,159, 60, 24, 57,191, 76,223,220, 50,226, 90,138, 52,183,
 84, 32,186,148,244, 14, 14,  9,143,103,114,123,107,155,149,194,104, 65,206,234,
 93,141, 16,179,248,255,115,126,249,244,205,223,249,140,119,255, 31, 69, 79,137,
 34,204,123, 91, 20,198,174, 77, 35,103, 29, 24,132, 77,230,188,189, 13,101,181,
 75,238, 96, 67,230,207,233,102, 43,209, 74,230,155,135,124, 58,253,139,164, 36,
200,187, 47, 49, 74, 83,237,206,196, 51,117,168,170,181,191, 24, 63,188,205,138,
 53,104,174,246,160,249, 55,167,228,140,213,226,208,179, 10,114,150, 17, 14,237,
172,  4, 31,249,230, 29,137,112,177, 64,126, 33,185,225,156,115,238,130,124, 87,
 81, 82,250,180, 81,117, 72, 80,104,238, 50, 74, 58, 85, 85,112, 40, 70,104,103,
213,  2,114, 14, 82,189, 96, 99, 15,154, 95,243, 16,144, 71, 41,151,203,195, 53,
 63,248,230, 87, 75, 22,  4,103,181,182,240,228,146,248,109, 23,103, 22,189, 69,
162,215,  6, 81,180,178,114, 48,185,238,139, 87,236,186, 86, 63, 41, 23, 70, 89,
105,148,112, 75,226,163,153, 72,107,145,222, 81,148,174,252,206,106,194,135, 75,
171,  5,221,180,200, 48, 98, 45,125,198, 79,159,156,213,230,222, 72,120, 74,174,
  0, 17,245,168,115, 45,206, 72,105,126, 14,135,118, 53, 73,155, 40,138,176,190,
 32,  3,125,139, 45,112,238, 30,175, 44, 63,171,162,206,176,  3, 44,140, 66,166,
 10, 56, 95,219,179, 96, 86,227,231, 60,151, 51, 48,112, 75, 70,134,199,196, 85,
 84,190, 49, 81, 29, 22,156,202, 99, 81, 77,210, 51, 36, 52, 56, 36, 48,170, 14,
139, 11,140, 47,172,  5, 64,116, 53, 17,216,116,123, 99,125, 69,173,243, 99,222,
 11,129, 91,168,177, 37, 67, 68, 35, 34,146, 20,164,160, 80,104, 12, 97, 12, 66,
148,148, 88,170, 59,130,136, 60,206,225, 16, 69, 12, 70,  2, 68,  8, 17, 16, 70,
  2,  9, 36,146,104, 36,148,160,180,122,138,147,156, 32, 45,204,252,102,100, 54,
 33, 49, 61,  5,102,113,188,116, 21,112,217,250,180, 52,243, 85, 38, 88, 89, 84,
 80,233, 98, 72,217, 68, 65,233,193,112,178,  8,152,116,123, 80, 50, 81,187, 71,
 24,217,106, 68, 58,103, 18,178, 15,118, 58,202, 71, 62,138, 71, 71,171,247, 73,
168,170,222,129,179,149, 44, 11,224,246,220,152,168, 41, 84, 56, 56,167,198, 68,
 88, 45,185,229,104,170,169,139, 37,  7, 49,148,107,  0, 61,156,156,189, 91, 18,
183, 20,131,103,137,185, 21,158,185,172,156,109,162, 67,120,  1, 90, 40,219,164,
 91,241,194,180, 60,141,144,109,226, 45,232,148,134, 46,215, 65,234, 35,206,113,
143,154, 93,131,127,164,254,194, 92,170, 37,173,  5,133,182,146,223, 16,102, 50,
125,218, 79, 13,125,170,228,200,122, 54,254,162,157,211,179, 63, 98,167,198, 59,
170,180,214,103, 37,247,183,160,145,169, 50,154, 16,235, 44,206, 42,231, 90,178,
218,135,168, 35,114,  1, 60, 76,176,107,199,138,188, 90,197, 94, 10,118,162,227,
227, 75, 98,163, 12,170, 95,216,227, 73,123,144,170, 39, 56,161, 66,254, 42,118,
196,234, 26,154,135,129, 73,107,247, 96,218,185, 61,195, 87,199,243, 27,215,158,
240,175, 18,171, 73, 14, 39,211,184,158,147,243,137, 42,233, 60, 65,168,103, 61,
 59,147,208, 77, 67,242, 48,127,132,178, 38,  1,122,134,102, 78,117,218,190, 56,
 12,156,  6,  6,138,138,164,244,210,215,  6, 45,241,216, 53,212,150,107,118, 36,
218, 59, 28, 11, 78, 88,201, 53, 31,226,102, 25,187, 35,217,162, 83, 92, 52, 58,
 29, 74,186,232, 24,100, 51,169, 21,116,121,144, 93,245, 44,225, 84,251,188, 76,
134, 79,118,129,169, 14, 75,170,248, 35,218, 96,230,214,113,234, 21,  3,178,158,
246,135,154,233,157,131, 24, 74,144,141,105, 94,120, 62, 22, 22,158,169, 52,117,
195,236,  1,108,198,191,125,238,202, 23,110,180, 49,222, 89,249, 94, 60, 88, 16,
 38,125, 91, 67,211, 34,237,193, 11,169,216, 85,155,180, 74,199, 90, 28,255,235,
170,111,202,238, 10, 64,161,166,177, 49, 11,121,110, 34,251,223,142, 99, 46,118,
 47,147,243, 21,130, 75,236,221, 29, 33,215, 23,156,176,114,236,160,179,243,194,
 48,147,167,196, 18, 21, 87, 74,167,144,100,228,225, 92, 96,224,243,178,238,151,
130, 73,191,227, 14, 82, 25, 43,174,122,176,235,219,177, 39,192, 50, 63, 98,173,
139,186,247,245,203,156, 77, 55,129,149,224,223,237,135,204,209, 25,  0,244,130,
202,177,147, 31, 54,183,  4,229,168,  7, 32, 66, 54,221, 65,250, 40,215, 79, 57,
  4,226,162, 44, 45,206, 24,122, 82, 25,179, 93,247,248,232, 12, 17,167,  7,254,
 76, 74, 23,175, 48,219,140,181,206, 86,180,154,204, 50,239, 46, 22,200,234,232,
 99,212, 98,192,205,160, 13, 33,241,166,117,174,142, 57, 66,161,113, 79,  6, 24,
223,  1, 30,113, 78, 32,165,131, 11,128,156,222,209,122,109,135,182,  9,148, 37,
185,131,  0,170,145,107,223, 65,129, 85,208, 15, 47,185,236,153,164,188, 83,181,
199, 83,132, 99, 79,129,138,243,229,241,193,  2,199,191, 64,  4, 81,121,176,196,
140,222,200, 16,186, 15,140,119, 84,100,254, 83,189,134,237, 83,244, 67,102,181,
125,165, 30, 41, 14,208,146,219,169,165, 49, 83,164, 95,190,105, 86, 63, 48,173,
234, 36,243, 20,111,189, 83,123,225, 58,  9,141, 74,209,107, 19,
} ;

// ../Source/Template/GB_add_bitmap_M_sparse_24.c:
uint8_t GB_JITpackage_47 [833] = {
 40,181, 47,253, 96,148, 11,189, 25,  0,  6,101,113, 39,208,210, 86,  7, 42, 29,
227,242,158,  4,192,207,181,189,224,185,237,200,208, 18,114,218,199,107, 99,162,
 10, 79,192,159,100,149, 46,163,212,  3, 30,176,188,107,  0, 99,  0, 99,  0, 85,
198,233, 48,161,208,120, 40,151, 28, 93,137, 37,196,113,198, 50, 38,196, 41,117,
111,  5, 23,203,101,130, 64, 96,185, 60, 18,167, 55, 60, 71,173, 57,197,189,  3,
203, 89,104, 70,188,125,156,195,195,108,223,  6,204, 71,230, 41,250, 72,148,138,
 64,149,215,220, 51, 87,218, 14,172,114,206,219,171,183, 39,113,212,  2,  7, 64,
161, 58,198,224,  2, 37,190,109, 49,228, 64,219,161, 60, 45,120, 93, 13, 95,195,
 43, 21,105, 82,169,  4,120,146, 84,116, 73, 44,226, 71, 42,172, 38,124,181,188,
 88,134, 33, 81,253,205, 64,167,146,210,190,109,111, 67,217, 59,148,209,215,  6,
100,126,205,252, 92,231,111,246,134,137, 52, 14,192,100,112,185, 50, 44, 75,206,
255, 95,146, 62, 36,137,130,229,204,186,188,253,231,114,149, 33, 73,109, 40,139,
191,106,159,131,231, 43,201, 66,185, 76, 36, 22,219,186, 99,174,156,160,153,171,
188, 54, 19,137,  3,205,114,211, 29,124,175,161, 47,153, 69,210,122,237, 88, 61,
195,111,217,149, 30,199,243, 17,141, 54, 39,234,113, 58, 40,115, 12,107,113,171,
 58,245,248, 12, 19, 20,110,159, 57,245,183,230, 81,227,244,135,206, 38, 98, 19,
  1,225, 60,112,  3,119,126,187,170,180,111,249,118,198,246, 25, 26, 28,124, 72,
 36, 87,200,220,114,106,138, 96,218,163, 26, 49,146,169,102, 51,199,123,233,226,
145, 56,115,231,146, 20, 98,201, 89, 61,158,212, 63, 36,241,148,115,157,165,229,
 26, 52,175, 90,193, 44,195,  7, 43, 60,157,234,239, 54,237,136, 97, 99,150,246,
131,196, 12,  8, 33,168, 84, 73, 71, 23,184,173,166,123, 58, 12,159,205,  4,195,
123, 86,134, 39,116,111,246,141,195,189,105,204,214,184,142,195,187,196,157,122,
117,235,  3,  3,111,137,169,180, 14,  2,242,214,104, 28,236,124, 54, 32,121,129,
102,192,155,254, 44,251,128,157,160,161,169, 50, 37, 37, 34, 34, 41, 72, 10, 82,
104, 12, 64,132, 16, 66,119,182,  1,201, 98, 31, 44,154,183,177,130, 78, 22,241,
199, 42,100,  2, 95,178,227,182,211,192,158,157,208, 22, 51, 20,104, 27,195,181,
 63, 14, 38, 52,193,185, 76,132,194,205,164,196, 66, 64, 30, 47,119,188,  8, 53,
102, 25,124,173,217, 18,170,241,139,208,154,152,120, 33,124, 33,221,  2, 35,148,
109, 52,213,220,117,179,251,192,104, 38, 20,233,165, 16, 25,100,240, 17,216, 10,
  2, 48,176,240, 58,237,171,134, 60, 69, 78,246,  2,225, 45, 12,163, 13, 25,102,
 38,223, 74,129,174, 71, 28, 59,187, 16,192, 17,237,234, 87, 86,230,191,210, 37,
178, 10,124, 65,127,221,146, 80,204,187,199,236,129,104,115,  3,  5, 54,  0,184,
134,161,187, 50, 13,196,155,  6, 90,211,225,112,235,114, 51, 96,240, 96, 38,211,
156, 65, 33, 45, 85,208,229, 84, 30,129,212,126, 44, 80, 62, 59, 70, 86, 13,114,
238, 78, 29,218,117,  9, 64,145, 44,  1,153,147, 78, 68,217, 98,216, 67,132,196,
191, 56, 99,154,  2,165,161,252,170,123,181,252, 20,159,183,240, 80, 60,126, 70,
179, 48,141,248,207,228,105,230,244,150,147, 95,142, 44,204,244,157,128, 47, 66,
  7, 86,204,101,218, 67,227,230,136,139,123,  3,110,218, 47, 18,  9,252,  9,192,
 10,124,224, 57,133, 39,213,168,173, 22,124, 71,248, 34, 46, 24, 66, 18,210, 19,
 11,154,132, 51, 43,143,168, 51, 35,107, 69,216, 33, 12,131,146, 90,155,105,113,
145,  2, 55, 48, 26,108,196,132,235,108,154,157, 63,152,108,133, 47, 74, 10,216,
 73, 68,232,113, 93, 49,198, 73, 62, 40, 69,175, 24,
} ;

// ../Source/Template/GB_add_bitmap_M_sparse_25.c:
uint8_t GB_JITpackage_48 [1087] = {
 40,181, 47,253, 96,  3, 15,173, 33,  0,134,107,132, 40,224,208,232, 24,248,189,
 18,180,156,212,224,103,121,195, 37,253,  6,201, 64, 85,143,137,126,217,148,179,
245,  8,220,180,252, 77,243, 52, 97,134,148, 24, 19,  2,125,  0,116,  0,122,  0,
146,  4, 66,121, 80, 46,155, 24,190,146,105,221,234,190, 84,203, 60,168,190, 52,
171, 13, 15,137, 11,  7,162,209, 81,166,154, 62, 92,111,238,162, 62,220, 90,248,
 71, 64,145, 80, 30,  8, 19,  9,229, 84, 54,253,233, 58,154,151, 67,224, 53,184,
221,137,170,231,175,  3, 27, 34,135,103,198, 84, 58,116, 87,140,142,100, 45,198,
 22,129,127,153, 98, 13, 46,242,248, 52,183,142,253,197, 10, 94, 10, 26,  0, 11,
246,138,  1, 69, 82,157, 39,214, 82, 35,241, 20,237,250,145,154, 54,101,196, 60,
 18,145, 30,145, 72, 33, 61,247,159,118, 41,254,219,121,110,141,191,101,193,  1,
 71, 85,221, 98, 93,242,107,162,180,157,163,155, 85,170,233,118,117,103,249, 82,
197,169,172,238,185,245, 68, 45,134, 70,185, 76,159,186, 18,155,180, 54,105,230,
182, 20, 97,220,237,150, 90, 59,243,196,199,162,238, 83,116, 49, 51, 14,176,174,
213,253,125,235,115,247, 10,245, 52,  0,147,  1, 69,235,184, 77, 53,255,127, 73,
226,144, 36, 72,252,131,251, 82, 17,181, 88,212,101,215,238,188,174,215,232,122,
 44, 91,231,186,133,  6,182,190, 93, 86,205, 75, 91,213, 46, 38,187, 45,161,156,
224,108, 48,170, 45,237,136,188, 75,237,232,  2,199,151, 94,158,118,102, 90, 98,
211, 57,155, 78, 87,249,151,  1,255, 64,117, 94,224,166, 97,110,250,121,  5,127,
157,  2,189, 58, 57, 64, 44,116, 50, 17, 11,114, 94, 46, 80,110, 58,153,141,106,
119,171,  1,214, 41,252,247,129,211,161,140, 17,243,235,243, 91, 38,252,186,  5,
166,248,  7,155,190, 89,172, 95,255,123, 27, 55,155,238,176,201,120, 50,158,  7,
200,145,  1,146,212,209, 81, 85,147, 24, 39,135,237,148,128,254,106,140,159, 79,
126, 89,153,245,250,234,122,196, 20,175,213, 98,253,215, 99,238,118, 70, 71,231,
118,232, 81,160,238, 84,103, 58,154,121, 15, 92,199, 38, 21,230,188,247, 66, 50,
226,233,144, 35, 61, 11,152,208, 31, 23,167, 71,201,  0,210,149,219, 84,232, 85,
166,248,173,195,167,220,190,118,235,102,177,126,235, 22, 20,150,201,203,170,104,
 94, 13, 45, 82,  6,244,173,166,181,126,113,171, 12, 81, 25,127,157,102,213,234,
 40,  3,128,241,168,241,169, 34, 52, 34, 50, 83, 80, 80,148, 66, 99, 48,132, 24,
 99,204, 56, 15,162,128, 72,139, 66, 24, 73, 96,160, 17, 40, 99,  8, 33, 72, 96,
  2, 73,146,153,168, 37,169, 14, 36, 67, 28,122, 76,179, 10,169,  1, 86, 20, 18,
122,232,219, 22,114,250, 83, 64,231,128, 80,107, 33,218,239,223, 63,228,108,149,
186, 80, 97, 28,218,122, 92,249, 71,136, 64,164,185,188,154, 99, 97,160,120, 55,
194, 66,170,120, 23,184, 70, 76,125,224,216, 84,215, 96, 50,152, 97,132,234, 27,
207,183,210,251,155, 47, 52,177,224,109, 92, 70,178,153,158, 16, 81, 34,254, 96,
175,140, 70,168,136, 34, 64,150,212,151,204,237,  4,159, 68, 19, 60, 11,215,230,
122,134,215,196,137, 20,  3,145, 27, 69,220,223, 17, 94, 37, 63, 77,204, 87, 90,
129, 93,252,  3,241,104,  0, 55,147, 87, 96, 99,185, 16,122,249, 14, 79,202, 74,
213,137, 17, 60, 20,255,245, 90, 84,  6,166,136, 13,234, 64, 59, 51,113,174, 34,
 95,112,238, 40,163,192,145, 24,224,182,  6,213, 44,133, 28, 54,150,114,224, 62,
112, 59,153,109,130,106, 37, 88, 52,236, 18,210, 64,133,196, 25,135,113,164,212,
108,255,197, 44,164,185,160, 46,209,149,148,125,123,214,159, 88,130,122, 66, 20,
129,235, 69,213,  5,130, 64,141,253, 69, 92, 79, 91,249,129,234, 68,185,144,  1,
127, 89, 36,126, 89,128,252, 15, 44,209,137,114, 10,153,171, 52, 16,208, 73,246,
219,181, 76,159, 45,  7,196, 70,234,229, 23, 93, 98, 44, 34, 92,235,117, 57,154,
149,102,226,  6,150, 99, 43, 86,130,145,169,159, 48,107, 46,123,222, 72,224, 62,
115, 67, 94, 13,189,157,201,169,193,241, 97, 44,174,180,178,218, 76,234,217, 26,
 97,207,221,183,141,149,216,199,205, 57,152,109,203, 71, 55,100,  8,131, 12,230,
227,155,176,154,200,186,189,128, 36, 98, 88, 83,204,124,115,231,119,184, 18, 58,
 28,197,239, 50, 44,175,253, 74,252,169,136,121,142, 69,129,102,112,188,244,107,
114,255, 44,248, 73,122, 42, 76,102, 60,203,142,231,239,164, 97, 66,  4, 22, 23,
 25, 50,124,183,  2, 47,184,  1,104,216,178,  4, 62, 94,217, 28,166, 70,125,234,
197, 87,225,164,200, 84,  0,255,134,  7,116,207, 72, 85, 70,  2,230,220,130, 97,
204,247, 84,196, 77, 94,169,196,239,212, 94,104,174, 77, 99,122,168,119,163, 40,
153, 32, 32, 55,205,245,  7, 19, 84,217,227,146, 59,192, 73,245,253, 18,127,156,
157,164,187,170,225,155,  7,
} ;

// ../Source/Template/GB_add_bitmap_M_sparse_26.c:
uint8_t GB_JITpackage_49 [1091] = {
 40,181, 47,253, 96,  1, 15,205, 33,  0,214,107,132, 40,208,208,234, 24,248,109,
212, 86, 66,  6,180,235,114, 46,248, 40,197,153, 82,130,133, 88, 83,191, 26, 67,
167,152,217, 89,234,175,104,145,171, 25,240,131, 89,  2,127,  0,118,  0,120,  0,
199,162,200, 99,226,168, 28,157, 57,158,242, 85,187,217,141,171,134,113, 84,141,
 43,181, 12,142,  8,203,230,161,213,208, 87,117,117,184,222,156,133,117,248,189,
241,144, 96, 18,153, 56, 14, 36,145,201, 39, 42, 29,106, 27,154,150, 63,226, 49,
184,237,125,108,231,144, 19, 25, 46, 46,207,239, 66,225,212,109, 65,156,232, 94,
208,  6,185, 14,191,154, 49, 56,200, 35,204,188, 58,118,120, 81,209, 74,200,  0,
 84,176, 83, 12, 38,178,234,111,102, 45, 51, 50,207,207,182,153,212,180, 41,175,
203, 33,144,200,  1,129,  4,210, 27, 52,152, 14,166,227, 16, 55,178,211,115, 31,
106,184,230,195,253,205,173,243,183, 44, 48,208,160,168, 87,170, 71,110, 73,147,
190, 51,132, 41,133,146,176,103, 55,253, 30, 81,124,162,118,207,173,165,122, 65,
 90,229,168,254,132, 37, 38,105,109,214,143,219,242,  3,194,219,111,189,119,126,
 51, 63,127,188,207,143,197,252,114, 64,117,205,238,111,108,255,121,215, 60,110,
215,204,255, 63,138, 52,162,232, 17, 15,175,141,235,167,222,252,241,232, 53, 60,
175,237, 51,218,  6, 87, 71,185,245,103,183,110, 96,107,236, 81, 42,123,180, 89,
 13, 99,210,219,242,146, 18, 27, 13,246,171,234, 91, 55, 32,207,135,184,222,208,
  5,158, 15,191,121, 39,213, 18,147,190,209,120,218,202,124,120,113, 29,122,108,
102,137, 26,134,235,212, 39,151,239,188,245,201,  3,173,212,240,160,192,193, 64,
 40,200,204, 98,137, 82,195,193,108, 85,195,155, 13,168, 62,229,195,236,146,126,
201,235,186,220,122,246, 45, 17,110,189, 34, 79, 60,195,164,111,149,231, 87,183,
126,  8, 51, 48, 13, 81,180, 65, 81,146, 24,119,157,187,102, 49,226, 57,180,143,
113, 82, 81,114,171,162,213,237,169,152, 39,110,227,173,219, 74,245, 91,143,159,
183,105, 13,157,219, 29,156, 60, 53, 52,191, 93,125,192, 58, 38,161,242,  6, 66,
216,201, 40, 99,222,200,142,194,165, 59,228,162,244, 40, 23, 60,218,114,123,234,
 32, 69,138,223,188,252,202,237,107,216,110,149,119,221,171, 87, 76, 84, 36,144,
218,207,196, 24, 90,156, 12,104, 44,227,169,121, 45,176,149, 93,149,241,214, 43,
181,  1,128,243,168,225,169, 50, 52, 34, 34,163,160, 32, 37, 41, 52,  6, 48,132,
 16,195,152,209, 60,146,112,104,146,164, 24, 22, 33,  8,  9, 36, 49,  2, 66,148,
224,  4, 51,129,132, 21,197,168, 58, 19, 67, 28,228,230,224,242, 20, 18,  2,206,
 19,242,224, 10,205, 66, 44,254,216,130,229,128, 48,195, 66,202,167,  1, 14, 17,
  9,157, 38,165, 20,143, 13,227,114,212,164, 65, 68,195, 69,171,143,194,224,227,
109,204,194,174,241,170,224,235, 17, 37,238,221,124, 37, 86, 92,216,183,246, 24,
 55,119,207, 10, 19,  4,151, 97,224,228, 12,141,192,203,250,178,253,155, 45, 80,
 68,143, 36, 31,190, 52, 27, 33,  7,204,138, 12,127,141,197,222, 78,255, 36, 97,
 89, 59,241, 12,162,137, 19, 74,  6,180,108, 54,112,255,179,188,136,119, 58,  6,
144, 43,170, 11,244,196,169,163, 16,  3, 13,165,247,122,227, 38, 72,255,190, 58,
 77, 46, 93,245,128, 26, 30, 53,191,164,166, 63,219,175,136,135,117,168,159,221,
151,243,243, 53,228,148,105, 58,170,221, 48,  1,108,254, 30,161,165,202, 89,112,
191,  1, 33, 65, 61,223,140, 10,213,129, 88, 66, 96,209,114, 23,189, 68,129, 96,
137,112, 38,193, 83,178, 16,196, 13,165, 32,168, 87,239,168,178,242,136, 65, 40,
 37,140, 90,112, 43,169,183,131,158, 80,109, 95,152,240, 19,237,136,185, 60, 81,
 32,228,207, 88, 22,206,183, 22, 88,238, 47, 23,111,138, 98,125, 48,254, 28, 40,
159,240, 91, 23,159,206,187,117,128, 74, 52,164, 44, 81,  8,198,224,134, 61,128,
190,237, 51,131, 76,114, 96, 57, 27,227,228,209,214, 67,253, 17, 73, 44, 19,184,
215, 72,204, 16,164, 28,247,193, 32, 71, 18, 53, 39,174, 99,153,184,127,221,143,
214, 34,206,155,120,123, 46, 86, 75,179,150, 63,193,128,110,202, 48, 10, 25,192,
 71,157,136,153,126,222, 65,128,154,152,108,138,171,213,220,250, 59,113,209, 92,
 89, 97,225, 12,237,181,100,213,231,116,214,164, 56,112,139,143,134,214, 77,253,
239,157,158,110,167,184,100,182,140,178,149,233,152,  2,  5, 33,  0,235,148,240,
 25,126, 55, 89, 94,210,  0, 21,236,177, 36, 71, 94, 97,172,106, 65,241,212,244,
 73,129,153,134,164,146,249, 76, 67,236,148, 85, 19, 41,193,168, 76,138,195,224,
 54,148, 46,142,179,  5, 59,106,193, 37,239, 56, 28,151, 26,152,238,108, 90,237,
  3,  5,109,140,130, 41, 78,114,211, 92,127, 48,133,202,  6, 47,189,  6, 78,242,
239, 63,228,143,176,147, 52, 84, 74,187,121,
} ;

// ../Source/Template/GB_add_bitmap_noM.c:
uint8_t GB_JITpackage_50 [467] = {
 40,181, 47,253, 96, 49,  6, 77, 14,  0,166, 19, 64, 33,  0,211,230, 87, 31,107,
 24,153,192, 65,209,  9,245,246, 51,119, 85,154,112,205, 72,127, 59,133,131,133,
157,244,255,219,127, 40,  1, 55,  0, 55,  0, 51,  0,139, 87,243, 28,111,204, 96,
 48,229,211, 54, 33,212, 11,173,216, 64,116, 22,109,184,245,136, 53,155,164, 23,
 51,159,159,142,125,162,131,169,192,142,136,100,192, 26, 90,204,136, 45,245, 94,
 91,105,227,150, 37, 41,203, 10,248,152, 36, 84, 23,213, 30,103,195,121,132,216,
184,195, 35,216, 55,163, 58,131,205, 97,  8, 85, 89, 76,170,219, 27,177,115,107,
207,163,119,193,218,191,111,126, 50, 92,132,139, 58, 20,  8,215, 37, 46,250,148,
241,198,  6,125, 59, 44,160,128,196, 37,122,143,167,102, 92,103,116,138,198,216,
182,153,171,211, 15, 62,175, 56,118,203,250,127, 41, 59, 82, 86,223,167,233,222,
162,  5, 63, 47,182, 55,226,150,252,149,100,137,158,  3, 82,126,126,  8,234,176,
236,240,  5, 13,157, 47,177, 67,142,103, 77, 95,127,  2, 92, 85,184,106,224,125,
 53, 31,  7, 94,208,126, 74, 20,130, 62,153, 17, 74, 70,235,150,213, 25,189,  3,
 97, 72, 52,198,163, 82, 50, 71, 23, 85,160,193,177, 52, 51, 19, 22,148, 36,149,
114, 53, 64,134,136,177,185, 30,201, 36,139,102, 29,149, 94,217, 63,102,178,136,
171, 57,163,104, 81,142, 75,  0, 21, 22,142, 46,145,228, 24,150, 16,122, 12,156,
 65,131, 40, 58,104,134, 54,135,  0, 26,191,212,146, 65, 68,153,104,147,182, 89,
176,139, 58,232,204,219,112,215,168,130,103,151,217,105, 24,212,243, 32,105,168,
196,112, 61, 50, 92, 62,201,124,185,180,141,101,  2,144, 89,121,212, 64,142,160,
167, 10,220, 23,230,118,198, 71, 24, 46,  2,104, 56, 90,220, 59, 75,158,244, 67,
 56, 86,208,202,232, 53,171,129,159, 97,147,117,154,218, 21,  1,135,123,176,142,
  0, 60,143,221, 94, 14, 53,142,179,  6,  0, 89,163,210, 66,178,  5, 54,  2,216,
 29,232,163,129,219, 92,202,246,166,169,243, 51,147,187,130,149,158, 40, 74,162,
147,192,198,148,162, 64, 15,
} ;

// ../Source/Template/GB_add_bitmap_noM_21.c:
uint8_t GB_JITpackage_51 [687] = {
 40,181, 47,253, 96, 19,  9, 45, 21,  0, 70, 93, 92, 32,224,220, 28,  3, 28,146,
176,166,194,249, 74, 52,132, 37, 37, 14,140,171,  9,170,161,233,113,207,204,142,
 97,140,193, 19,  3, 14, 83,  0, 81,  0, 82,  0,182,115,189, 85,169,219,121, 24,
206,203,133,  2,161, 40, 56, 18,  8,197,  7, 31,119,169,239,171, 82,110,152,143,
169,182,216,186,159, 75,207,196,116,170, 92, 71, 11,196,234,177,102,143,221,215,
229,217,186,131,184,126, 94,222,187,236,  8,115,226, 29,146, 80,208,140,136,105,
174,173,125, 79, 20,  4, 43,237, 44, 63, 28,182,194,225, 16,152,122,156,  6,171,
 29, 85,155,182, 92,248,163,136,122,104,199,154,159, 91,226,107, 43, 85,199, 12,
136, 28,188,251, 27,223, 48,172,114, 94,130,162,106,219,204,255,127,219,102,155,
 29,171,190,247, 54,132, 65, 81,176,170,175,230,121,200,104, 47,234,110,108,193,
 75,193,106,108,191,139, 41,136, 40, 28,  3,104, 95,163,213,  1,153,244,211,252,
228,223, 55,125, 80, 40,147,110, 60, 23,148,  5, 81, 87, 18,249,228,151, 82,134,
 63,238,154,205,229,115,249,116, 38,135,178,116,221,151, 32,182,249,114,143,117,
235,252, 77, 25,141, 25,129,112, 73,228,136, 79,184,129, 14,235, 11,127, 16,  2,
135,197,187,191,241, 91,233,131,239,238,186, 53,103, 67, 23,168, 63,  8,219, 86,
 35,124,222,156,117,219,211,156,168, 11, 98,143,138,155,118,116,196,217,120,239,
198, 26,214, 79,211,170,202, 97,213,128, 46,160,150, 56, 96, 27,190, 30,120,246,
184,115, 54, 21,207, 37, 84,233,186,147,168, 47,205,151,176,121,185,186,149, 82,
230,  6,211,157, 48, 88,201,203,125,187, 64,192, 29,101,117,104, 35,221,105,180,
155,  2,128,132,160,241,169, 66, 52,193, 72, 82,148, 20, 50,172,  1, 64,132, 24,
 83,118,245,201,130,102,128,244, 57, 44, 98,153,139,238,106, 51,  7, 47,235,  4,
143,192, 11,119,168, 68,197, 61, 12,242,153, 20, 15,108,202,  0, 23, 77, 65, 79,
134,154, 86,194,146,154,208,242, 45,115, 42,146, 96, 18, 17, 11, 41,100,187,186,
184,254, 94, 30,229, 67, 12,183, 64,230,131, 90,182, 18,224, 32, 28, 77,139,172,
238, 48,  4,198,170,216, 87,209, 11,168, 50,192,135,  3,156,155,117,210, 34,166,
  2,171,131, 34,199,221, 60,218, 54,148,245, 99, 42, 11,216,172, 16,239,163,161,
  8,117, 40, 89,166,  0,102,107, 19,189,160,107, 64,111,  4, 99, 57, 19, 92,138,
 11, 53, 87, 68,109,128,164,  5,216,161, 40, 73, 62,156, 60, 38,200, 58,100, 56,
  5,251, 87,186,136,  4, 87,188,169,210, 66,147, 27,104, 43,213, 90, 89, 58,241,
183,214,135,  8,  6,  1,196,145,161, 47, 76, 45, 62,243, 60,183, 78, 17,148,153,
100, 44,  9, 78,203, 41,  3, 38,124,204,210, 44,107,  6,  9, 99, 24,112,189, 13,
160,182,189, 69, 18,241, 62,130,113,  0, 11,152,121,206,  7, 15,207,140, 82, 48,
 69, 56,106, 63,160, 40, 11,187, 28, 72,132,204, 22,169, 51, 43,  9,133,142, 66,
 15,122,109, 48,152, 75, 89,185,105,122, 84,102,186, 59,180,194, 27,140,152,  9,
 39,109,131, 41, 69,221, 19,
} ;

// ../Source/Template/GB_add_bitmap_noM_22.c:
uint8_t GB_JITpackage_52 [1013] = {
 40,181, 47,253, 96, 34, 13, 93, 31,  0,230,167,121, 40,208,208, 88,  7,120,107,
239,101,162,127,  4,216, 47, 80, 65,135,193,222,181,214,216,222, 62,222, 55,160,
 55, 13,185,101,196, 59,101, 59,200,213,176,  2,191, 23,114,  0,106,  0,110,  0,
 16,202, 99,106, 87, 91,248,202,157, 52,163,185, 78, 44,243,152,184,206,139, 50,
 60, 38, 48, 27,  8, 54, 65,119,226,249,112,156, 53, 12,250,240,109,131,127,  3,
 20,  9,229, 97, 48,145, 80, 62, 93,210, 31,166,160,198, 28,  2, 31,210,114,199,
 81,136, 63, 14,100,136,154,237,171, 80,225,204, 76, 51, 56,209,157, 54,164, 69,
 38,190,109,241, 35,252,187,245, 23, 41, 88, 89,175, 80, 40,178,161,171,210, 54,
151,105, 71, 98, 88,203,168,240, 72, 36,122, 68, 34,  1,  7,231,160,168,203,237,
 45,151,188,186,149,166,139,230,206, 88,154, 91,  6, 54,181, 11, 75,146,203,168,
191, 93,246,109,110, 91,223,114,221,155,195,232,107,237,179, 36, 40,200,149, 78,
188, 77,203, 39,140,245,188, 90,174,210,250,219,168, 23,252,235, 88,210, 67,246,
226, 38,247,  8,131,129, 82,195,201,100, 19,203, 40,192,111,119,203,188,125,120,
172,246,177, 78,203,179,225,255, 31, 69, 28, 81,  4,137, 63,196,244, 86, 36,  9,
183, 51,182,248,131, 59, 87,170, 55,140, 74,229,103,202,248,234,243,162, 27,142,
 50,227, 75,179,143, 64,198,181, 67,120,224,173, 65,245,234, 87, 86,148, 81,172,
 90,178,203, 18, 74,138,141,198,234,136,212,185,129, 30,112,251,119,123,235, 11,
 75, 75,250, 70, 99,249,212, 97, 42,237,159,  6,252,243,208,150, 14, 37,  6,106,
 24, 58,207,206,169,201,243,168,116,203, 65,147,113,136, 72,224,100, 36, 18,100,
 75,207, 44,191,176, 21,175,222,207, 50, 81,212, 81, 81, 20, 53,233,136,173,217,
173, 61,127, 52,198,206,235, 36, 61,163,167,162,173, 56,165, 23,203, 95, 61,218,
219,229,107,130,174,229,207,155, 60, 19,212, 55, 11,220, 99,217,  9,101, 55,239,
189,247,254,100,180,210,225, 70, 66, 36, 40,124,254,180, 40, 61,202,133,234, 30,
 76,167,207,171, 72,241, 89,247, 60,181,124,172,210,236, 98,185,124,  5,199,  5,
163, 21, 74,170, 29,205,215,181,248, 52,121, 23,229,186,134,176, 72, 17,  8,128,
226,168,209,169, 66, 51, 35, 34,146, 36, 73, 97, 89,  3, 32,132, 24,164,170,140,
 30,194,144, 64,142, 51, 36, 66, 24,177,  2, 98, 68, 40,144,192,  2,  9, 36,148,
 64, 65, 97,105,218,201,106,196,233, 17, 51, 41,173,236, 17,156, 29,134, 36, 15,
206, 82, 56, 67,251, 84,184, 56,225,241,119,185, 37, 54,207,139,  1,171, 42,211,
  7, 50, 60,176, 37,138, 28,153,248,161, 29, 57,141,234,151, 13,255, 63,190,192,
192, 43, 83,101,111,187, 56, 23,129, 51,115, 47,200,145,199, 18, 56, 28, 21, 44,
150,152,228,173,144, 32,242, 51, 40, 98,108,104,145,130, 44, 10, 70,115, 26,156,
 82,123, 68,225,109, 34,132, 34, 82,165, 16, 15,  7,246,245, 77,245,111, 61, 59,
137,166, 60,223,107,190,158,252,211,156,132,196,192,106,163, 14,247,241, 86,130,
241,167,136,153,103, 37,118,129,173,202, 94, 86,174,129,106,207,124, 23, 66,252,
 32,109,187,250,164, 46,154,  5, 85,  9, 76,253,206,117, 50, 89,126, 22,169,184,
145, 55,102,214,231, 60,185,227, 46,242,173,231, 44,163, 89,208,130,253,147,201,
107, 79,194, 51,142, 17,247, 59,112,161,121, 11, 26,  9, 46, 52, 94,209, 17,129,
 97, 21,112,165, 14, 64,118,  2,155,163, 21,  5,163,245,239,187,109,149,138,149,
 21,169, 67, 40,232,122,112,253,187, 91,102,241,137,  9,168, 65,166, 32,153,161,
 43,111,202,165, 66,  8, 67,178,209, 39,105, 92,150, 94, 58,147, 80,190, 90, 86,
 98, 20, 44,224, 26, 33,171, 29,108,101,185, 10,160,152, 40,  0,152,  7, 53,253,
209, 44,146,131,212,223,102,142,  3,208, 54, 46, 48,238,246,247, 25,191, 38,105,
250,129,124,132, 81,228, 39,238,205, 58, 35, 54,231,242, 34,184, 29, 57,187, 90,
147,104,  9,  0,183,142,234,124, 59,152,206,205,201,189,214, 38,213, 84,129,150,
230, 88,177,195, 69, 95,122,183,207,168,148,194,206,178, 84, 72,124, 32,122,195,
129,144, 47,148,139,119, 25,119,172,180, 17, 46, 87,216, 51,104, 84,225, 52, 48,
 18, 77,209, 91,241,178,224,229,219, 78, 58,  4,168, 61, 54,  1,227,240, 66,231,
 85,112, 79,113, 45,145,153,188, 15, 57, 83,158,206,113, 24,181,240,205,  8,174,
 20,246, 98,110,158,128,198, 78, 62, 10, 61,155,166,171,  6, 83, 86,213,  8,198,
 48,230, 23, 63, 95,174,179, 13,151,210,  3,112,  2,
} ;

// ../Source/Template/GB_add_bitmap_noM_23.c:
uint8_t GB_JITpackage_53 [1015] = {
 40,181, 47,253, 96, 33, 13,109, 31,  0,102,232,122, 40,208,176,170, 14,232,147,
180,248,102,126,137,175,235, 54, 53, 57,143,233, 92,107, 16, 38, 45,252,153,247,
 71,170,228,226, 59, 13,172, 89,234, 97,208,203,128, 18,115,  0,106,  0,114,  0,
  3,147, 71,115,217,180,241,148,219,116,163,185,182,134,121, 52,174,157, 81,134,
199,132, 69, 51,160,181,231, 54,238,135,227,204, 97,208,135,119, 93, 60, 36,152,
 68, 38,143,  3, 73,100,114, 41,139, 14, 49,245, 76,203,  7,226, 63, 92,254, 60,
 10,113,184,137, 12, 22,103,231,189, 80, 54,157,105,198,  6,178, 14,111,219, 15,
  7,105,124,167,197,143,135,191, 14,173, 41, 86,215, 41,  4, 19,217,240, 85,105,
167,151, 41, 38, 53,109, 74,235,114,  8,  4,122, 64, 32,  1,175,142, 61, 75,132,
115, 76, 83,229,246,212, 35,175,110, 35, 41,163,121,102, 28,117,151,161, 53,151,
225, 72,122, 25,245,247,219,222,117,215,205, 91,239,251,244, 48,230,181,246, 89,
 22, 24,228, 74, 27,119, 77, 93,194,218,236,203,229, 42,175,195,141,154, 89,135,
216, 21,253, 99, 51,175,189, 67, 22, 75,148,153, 13,102,107,109,163,  0,191,223,
169,190,243,214,181, 58,175,125, 92,238,134,255, 63,  4,113, 64, 17,211, 95, 80,
 36, 19,129, 59, 51,182,184,131,103,174,211,236, 48, 42,149,157,150,241,213, 59,
163, 29,142, 50,227, 75,183,142, 64,198,245,163, 18, 30,184,155,158,154, 97,175,
 46,104,163, 90,189,228,151,165, 37, 41, 52,153,235, 86,  7,164,118,231,121,192,
237,225,157,221,204,176,188,162,107, 50, 31,166,210, 30,106, 88,135, 28,138, 69,
183,164, 37,102, 24,172, 79,159,156,237,230,171, 75, 28, 72, 35,135, 12,198, 33,
 66, 97,131,145, 80,144, 88,244,141,250,133,173, 56,102,  5, 16,212, 81, 77,211,
 36,233,136, 51, 55,198, 57,164,143,113,214, 41, 74,209, 55,250, 41,218,138, 83,
 90,161,254,234,209,222, 47,103,237, 57,151, 59, 80,226,180,103,222, 76, 93,224,
156, 75, 50, 89, 13,132, 16,194, 67, 25,173, 70, 66, 40, 92, 58,135, 92,140, 30,
229,130,117,121,117, 14,166, 92,150, 58,144, 18,197,111,223,115,115,249, 90,165,
 91,133,186,124,  5, 71, 69,163,148, 41,170, 31,205,217,181,184, 36,129, 25,245,
102,253,104, 49,128,225,168,225,173, 50, 52, 34, 34, 73, 82,144,194,178,  6, 32,
132, 24,163,152,217, 60,194, 80, 96, 20,200, 56, 68,224,136, 20, 32, 35,164,130,
137, 68,  2,177,140,210, 20,180,216, 41,107,210,231, 33, 87,146,194, 45, 15, 85,
 13, 12,153, 13, 46, 13,166,147,125,162, 92, 71,211,209, 29,254, 41, 98, 58, 47,
 53,174,172,194,158, 78,248,189,172,108,112,152,230,183,152, 24, 26, 18,205, 92,
184, 13,223,111, 96,148,170,146,230,174, 93, 17,  8,159,185,232,201, 81,131, 38,
 41,254, 23, 98,157,148, 76, 38,221,152,242,129,162,199, 10,  0, 26,135,177,  1,
 23,247,231,156,219,156, 98,252,136,246, 86, 91, 21,  9,217, 41,120,217,181,125,
 27,211,191,219, 51,132, 68, 27,120,118,212, 14,207,151,154,161, 24, 59,128,170,
 81,199,253,121,229, 57,  7,135,152, 36, 87, 48, 23,195,234, 98,179,218,171,129,
226, 39, 19,122,130, 64,  7, 30,218,196, 23, 58,  0, 78, 21,224,255,173, 58, 76,
 70,190,139,216,  3, 73,155,102, 52,185,223, 57,208,165,128,203,146,203, 30, 11,
236, 60,190,214,222,  5,230,245,115,174, 56,202, 65,121,192, 97, 15, 55, 70, 94,
205,241,109,232,153, 84, 38, 11,150, 73,112,115,186, 83, 72, 90, 84,225,243,181,
 82,  0,206,210,134, 31, 20, 84, 53, 15,187,192, 54,203,122, 16,172, 80,176, 89,
 97, 77,163,141,221,226, 23, 38,208, 51,229, 66, 95,210,227,114,250,159, 77,212,
248,131,144,  5,  5,  0, 95,110,115,217, 17,160,149,227, 66,  0,209, 50, 11,  0,
 37, 13,250, 35,217,  7,  9,180,255,110,205, 89,255, 28,224, 57,223, 41, 31,142,
129,116,162,100, 31,189,128,236, 47,242,210, 51,236,120,122,253, 72,228,230,242,
 56,174,129,105, 73,248,175,197, 55,173, 45,231,230,157,243,243,237,115,167, 43,
137,107,229,157,223,150, 52, 11, 53,143, 31, 47,164, 81, 16,138,100, 37,170,253,
 47,150, 10,228,165, 81,165,148,191, 41,152,131,186, 76,246,  2,225,163, 87, 35,
135, 11,191,136,238, 71, 73,197, 17, 66,218,217,237,227,200,160,246,105,234, 24,
142, 39,161,170, 18,241,148, 82,178, 82, 16,237,206,188,251, 90, 18, 15, 83, 11,
175,132,252, 48,113, 78,170,204, 92,131,  6,151, 39,229,166,217,212, 96, 26, 42,
218,129,105,100,191,240,191,173, 67,109, 85,162,244,  0,242,
} ;

// ../Source/Template/GB_add_bitmap_template.c:
uint8_t GB_JITpackage_54 [730] = {
 40,181, 47,253, 96,  8,  8,133, 22,  0,118, 39,118, 40,208,208, 88,  7, 52, 58,
177,179,237,158,184,159, 33, 99, 53, 92,195,156,189,136,209,149, 34,124,198,204,
 78, 68, 63,120, 64,181,116, 25,165, 30,120,192,242,  2,112,  0, 98,  0,108,  0,
191, 68,146,105, 18,225,236, 57, 90,157, 82,185,177,190,146, 97, 67,132,173,228,
215,154,200,  4,  6, 98,130, 12,170,108,185,115,123,179,138,238, 60,198,234, 18,
193, 68, 50,137, 28, 12, 72, 38,135,188,199, 37,219, 32,135,249, 84, 61,148,221,
169,117,196, 37, 79,165,177,100,212,213,  5, 10,219,234,168,135,111,111,158,232,
 10,150, 35,225,114,201, 34, 80, 85, 46,167,240,117,145,106,124, 47,234,180,219,
159, 11, 66,119, 89, 22, 78, 81, 81,132,162,  2,135,108, 45,191,231,126,167,188,
 88, 46, 85,199,230, 45,111,209,129, 32, 71, 40, 93,  6,177,  0, 36,235, 83, 62,
110,217,186,247,  9, 18,157,214,151,206,135, 98,116,175,239,188, 84, 11, 89,119,
174,238, 22,206,236,178,246, 24,221,227,161, 72,169,251,188, 87,114,191,198, 48,
134,210, 93,226,186,221,183,213,107, 31,186,109, 31,146,238, 12,114,217,165,123,
183,110, 97,157,118,206, 34,254,201,118,175,243,213,116, 37, 91,174,212,202,120,
240, 84,214,197,217,104, 50,155, 78,230,225,138,104,112,192, 24, 98,237, 64,184,
228,149,219,232, 64,242,253, 94,  5,  6, 87,246,180,209,221,150,248,185, 72, 35,
178,177,134, 83, 59,127, 46,191, 27,149, 77,225, 96, 56, 17,167,168,255,143,162,
140, 40,154, 56, 54,246, 10,217,112,139, 79,182,227,156,221,135, 62,135, 44, 27,
 99,232,192, 96,170,139,227,105,200, 94,103, 23,178, 47, 77,219, 88,  7, 81,180,
 17, 33, 60,133,200,229, 87,157,151,237,235, 16,141, 70, 98,243, 74,229, 86, 20,
 97, 13,229,246, 57,172,243, 18,219,203,162, 88,206, 95,235, 56,254,186, 95,202,
 15,131, 47, 93,167,213,137, 89,162,163, 36,200, 87,178,198,145,106,243, 85,166,
161,140, 98, 72, 39,  3, 65,193,112, 13,141,103, 60,157, 10,194,115, 89,143, 99,
 29,121, 35,224, 77,214,148,  1,231, 24, 55, 76,190,122,229,236, 54,111,178, 59,
 63,175,243,113, 75, 96, 32, 32,132, 16,162, 20,218, 13, 44, 67, 84, 23, 49,219,
182, 64, 10, 11, 90,151,186,151, 99,154, 13, 10,162, 75,192,106,130,  8, 40,143,
177,129,170,  3, 16,133,107,244,250, 34,  8, 44,  0,103,  9,  5,  8,130,228,110,
  1,  0,204,  5, 49, 31,205, 29, 24, 68, 39,  1,242,201,197,129, 17,144,  6,221,
 90,199,172,227,108,229,160, 30,131, 12,175,160,122,192,  7,130,236, 19, 54,108,
238, 34, 24, 44,232,155,176,149,  8,123,130,249,  5,124, 22,137, 22,100, 87, 43,
 69,194, 13,  9,176, 40,128, 64,108,225, 86, 20,206,200,113,145, 11,146, 74, 42,
163,128,164,240,152,135, 35, 64, 91, 33, 67,198, 64,132,127, 56, 87,205,225,150,
171, 44, 35,  8,112,144,161, 32, 18, 48, 27,141,180,138,210,200,139, 13,152,201,
  9,217,197,  7, 45,239, 93, 71, 69, 98, 34,225,224,129, 89,146, 26, 96,223,250,
121, 25,220, 98, 93, 55,  1, 17,172, 64, 74,227, 49, 32, 25, 27,218,210, 92,172,
 97,228, 61,126, 27,112,191,178,139,220,188,105,106,158,153,108, 91,188,154, 43,
128, 24,154, 88,192, 37, 43,138,  2, 55,
} ;

// ../Source/Template/GB_add_full_30.c:
uint8_t GB_JITpackage_55 [360] = {
 40,181, 47,253, 96,143,  2,245, 10,  0,246,212, 66, 33,  0,211, 28,  3,252,221,
 12,211,251, 17,189,170,182,177,209,110, 12,169, 23,232,203,178,125,135,104, 22,
133, 89,250,127,175, 15, 33, 57,  0, 58,  0, 55,  0, 87, 83, 21, 23,204,115, 56,
240,235,238,228, 18,155, 14,202,229,170, 25,  6,187,117,205,152,  5,111,136,197,
 91, 93, 79,191,121,245,243,242,250,129, 74, 51,113,221, 80, 17, 50,140,195, 75,
182,109, 53,163,140, 83, 84,156, 40, 42,160,125,252,255, 99,244,196, 74, 96, 77,
150,211,106,158, 55,104,123, 47, 23,244,236,214,152,236,246,172,118, 29, 83, 69,
 17, 17,108, 86,163,237,182,146,111,144,195, 92,201, 49,158,151,  4,171,178,166,
194,160,178, 30,105,208,229, 14,136,231, 31, 94, 61,241, 12,253,143,145,118,193,
 10,110,200,226,112,179,156,182, 31,121,217,  5,237,173, 90,205,129, 89, 23,122,
215,223,229,216, 98, 92,117,205,207,221,247,218, 97,170,206,  0,140,171,156,151,
219,199,  5, 49,126,226,135,242, 44,214, 60,240,124, 65,143, 64, 22, 88,131,178,
160,212,  2,157, 30, 30,125,251,102,243, 50, 95,110,230,101,230, 86,232, 51, 83,
 76,136, 35,163, 12,122,105, 62,241, 40, 35, 47,244,235, 30, 73,234,120,218,  3,
 32, 32,112, 34, 19,164,235,  1, 94,  2,223,109,198,216, 22, 27,  2, 28, 12, 72,
 58,135, 17,228,151,211,149, 53,104,140, 34, 59,251, 25,100,195, 99,136, 53, 91,
168,173,193,187,170, 36,216,235, 64, 33,115,197,168, 76,146,207, 53,163,112, 65,
114, 69,205,160,233,121,102, 90,219,128,171,185,  0,100, 18,175, 90,209,233,  6,

} ;

// ../Source/Template/GB_add_full_31.c:
uint8_t GB_JITpackage_56 [466] = {
 40,181, 47,253, 96,125,  4, 69, 14,  0, 54,152, 76, 33,  0,181,142,  1,106, 66,
 73, 74,224,238, 46, 83,220, 88,218,  9, 16, 29,140, 24, 98,150,168,230, 40, 48,
 58,204,210,255,187, 63,188, 66,  0, 68,  0, 64,  0,191,180, 21,209,198,  7,242,
 36,112,143,161,189,252,226,100, 68,  3, 49,205,143, 68,213,153, 98,174,110, 27,
226, 40, 76,195,109, 61,215,246,218,175,215, 76, 47,239,137,244,219, 21,154, 64,
 50,182, 39, 10,135,121,111,232,155,158, 71,167,246,120,150, 81, 88,150,  5,199,
225,120, 26,126,104,198,  0,133, 55,130,187, 74,254,255, 20,101,162,  8,  3,  3,
 86,193,142, 98,249, 68,174,246,179, 91,172, 30,  4,171, 90,172,157,141, 96,154,
 70,101,224, 85, 81,174,186, 90,174, 55,248,177,150,223, 43,127, 29, 12,  4,  3,
134, 40, 16, 12,183,186, 42, 17,237,  2,121,198, 45,208,101,171,111,239, 96,206,
 61, 90,245,207,158, 50,  9,  4, 37,177,251,226,248,138, 19,206, 56,174,254, 83,
 86,103, 55,221,186,170, 55,228, 85,176,211,183,196,185, 85,218,163, 53,131,123,
134, 33,241,121,252,126,235,189, 52, 83, 28, 20,117,250,172, 39,110,115,220, 83,
206, 77,133,178,101,122,105,167, 39,221,213, 51,161, 64, 38, 24, 14,242, 89, 64,
213,183,158, 50,177, 94,209,  3,199, 91,245, 10,197,193, 65, 50, 14, 77,243, 84,
215, 20,183, 70,109,167,252,133,127,141,228, 47,144,165,213,229,108, 72, 74, 61,
 32, 80,136,144,148,157,  7,177,  0, 76,225,200, 97, 28,178,115, 96, 74,225,162,
209,232, 24,192, 30,194,192, 10, 56,195,193,175, 12,232,129, 13, 92,  0,185,225,
  0, 69,144, 11, 21,  1, 26,173,193,162, 19,144, 97,173, 62,248,244, 96,122,192,
 89, 55, 81,113,194, 57,208,183, 95,204, 39, 49,254,130,165,  1, 81, 15,200, 96,
101,158,120, 95, 23, 11,220, 56,232, 24,125,246,139,230, 48,234, 66,190,161,251,
 64, 36,143,161,193,250, 88,232,110,131,145, 85,161,181, 31, 12, 13,112, 39,202,
 14,169, 52,163,236,130,228,128,154, 65,243,121,102,106, 91,227,213,114, 70, 68,
245,239,250, 20,189, 67,
} ;

// ../Source/Template/GB_add_full_32.c:
uint8_t GB_JITpackage_57 [784] = {
 40,181, 47,253, 96,252,  7, 53, 24,  0,134,100,110, 33,224, 90, 23,  3,212, 55,
 98,221,119,225, 94,213,220, 59, 84,155,121, 81,254, 23,  3,155,192, 90,  1,  5,
 29,195, 24,131, 48,194, 11,103,  0,101,  0, 99,  0,133,171,199,235, 97, 75,  1,
 20,209, 24,190,171, 42,175,190,155,235, 29,150,240,230,162,200,125, 46, 20,  8,
 69,193,145, 64, 40, 46,240,178, 79,141, 85, 54,114,  3,119, 86,184, 73, 20,238,
124,114, 56, 11, 13,179, 45, 39, 15,206,221, 56,197,193,202,155, 89,225,225,234,
210,102,125,141, 79, 63,127, 75,123,238,223,104,223,125, 82,  2,183,117,255, 67,
177,168,162,152,  2,235,247,217, 74, 39, 63, 28,176,194,225, 16,166,137,179,119,
119, 97, 50, 21,140, 71,194,169,124, 36,149, 83,  1,177,139, 64,104,141,222, 33,
207,215,142,248,246,156,253,199,  4, 30,222,118,235,236,138,169,239,134,158,190,
 96,172, 93,166, 63,123,203,112, 87, 84,106,124, 73,130, 23,175, 40,218,210,230,
103, 20,121,139, 42,217, 50,  3, 94,146,215, 62, 50,220,247,242,255,199, 48, 23,
134, 48, 40, 10, 55,244,108,230,254, 40, 47,  6,241, 30,239, 87,  9, 84,187, 98,
 80,218,173,179, 62,105,187,199, 74, 79,176,162,246,210,136,235,233, 86,250,237,
215,195,162,166,117,235, 18,131,167,193,119,101, 52,246,136,191,245, 72,122, 24,
136,191,177,171,228,174, 92, 13,105, 50,221,213,226,125, 29,198, 43,170, 30,120,
254, 44,173,104, 61, 93,187,236,154,140,118,  1,169,113,229, 62,243,231,138,251,
 52, 97,155,157,171, 17, 46, 99,177,251,146, 78,224,190, 93, 16,216, 11,123,153,
 62, 49,165,164,227, 19,182,211, 44, 58,198, 16,237,223, 78,115, 73,110,239,170,
 30,238,211, 20,152,174,202,150, 91,251,224,166, 46, 39,  8, 89, 51,231,156,243,
 27,239,103,165, 57, 59,167,169, 29,201,228,244, 25,210,236,180, 82,232,228,219,
 77, 26,135, 91,112,154,143,140, 30, 36,191,111,184,255,141, 24,132,252,116,237,
215, 62, 18,125, 59,228,195,137,233, 97,148, 29, 89, 95,128,141,168,177, 41, 67,
 68, 34, 34, 90, 80, 82,144, 66, 26,  3, 48,132, 32, 83,102,230,  1, 98,152,112,
 20,101, 64,138, 96, 98,  4, 22,  5, 35, 83, 25, 41,163,164,164,232,  1,145, 64,
 89,129,123,161,172,110, 74, 12,184, 13,189,  4, 23, 36,210,244,101, 68, 36, 68,
  1,165,227, 78,231,  1,240,  5, 48,101,108,197,146, 83,246,109,125,126, 62,185,
 89, 79,249,188, 66,179, 39,178,  7,172, 26, 60,183,223, 79,101,201,143, 54,  6,
159, 21,232,  2,131, 56,141,165, 20,104, 96,126,127, 76, 20,144,253, 78,102, 82,
 36, 69,  0,162, 26,202,253,218, 58,  3,217,152, 10,236, 39,204,  8, 58,235, 34,
 71, 35,159,223, 14,242, 75,238,114,108, 61,137,104,150,135,155, 43,151,  7, 30,
  9,230,237, 18, 88, 50, 81,168, 62, 64, 99, 24,248, 84,209,146,146,203,235,157,
 70,248,100,  0, 78, 61,183,207,249, 14, 20, 25, 20,226,124,142,132, 30,104,249,
 74, 72,252, 31, 41,120, 69,166, 71,134,188, 62,229, 14,185, 80,101,108, 29,184,
 15, 60,212, 74,168,  6,136,144,215, 64, 33, 92,125,111,112, 20, 18,  5, 71, 77,
181,119,129,239, 63,165,149,229,168,178, 43,246,185,126,183,212,158,109,188,142,
 52,235,212,191,201,237, 37, 76,173, 18,193,137,183,214,121, 39,204,141,246,173,
122, 66, 31, 41,204,172, 54,188,100,130,164,173, 90,229, 14,106, 31, 96, 33, 40,
205,156, 28,194,230,160,201,254, 96,210, 74,  5,166,176, 19,124, 50,249,  0,230,
149,210,128, 19,
} ;

// ../Source/Template/GB_add_full_33.c:
uint8_t GB_JITpackage_58 [467] = {
 40,181, 47,253, 96,128,  4, 77, 14,  0,118, 24, 77, 33,  0,181,142,  1,106,162,
134, 21, 44,222,168, 50, 88,220,147,  1, 16,141, 12, 90,165,150,168,230, 40, 48,
 58,204,210,255,187, 63,188, 66,  0, 69,  0, 65,  0,191,246, 21,213,198,  7,242,
164,111, 20,193,123,249,181,201,200,252,114,213,143,132,221,186,230,205,142, 55,
180, 81,185,130,227,245,124,223,203, 95,183,186,126,190, 11,235,181, 43,166, 64,
 50,180, 63,113, 56, 80,140, 67, 30,237,186, 74,231,227, 89, 70, 97, 89, 22,249,
 25, 20, 95,193, 79,213, 25,160,232,196,111,180,146,255, 63, 69,153, 40,194,192,
128,217,143,171, 89, 62,161,237,245,238, 24,218, 14,130,217, 29, 90,238, 70, 48,
 77,163, 50,232,172, 72,219,109, 45,223,227,247,185,150, 99, 44,127, 29, 12,  4,
  3,134, 40, 16, 12,183,184, 42,146, 18,153, 23,200, 51,110,129,174, 91, 93,123,
 39,115,238,145,213,189,123,202, 36, 16,148, 66,238,139,231, 43, 78, 56,227,185,
250, 79, 89,220, 29,235,184, 43,139, 67,157,253,184,125, 43,164, 90,181,187,106,
245, 55, 82, 48, 20, 94,139,222,177,197,184,234, 26, 20,117,242,110, 23,106, 84,
 28,233,164,155, 10, 69,251,212, 21, 87,110,211,250,101, 92, 39, 20,200,  4,179,
 65,188, 11,176, 27,219, 83, 22, 90, 44,122,224, 89,171, 94,161, 56, 54, 72,198,
 49,167,167,250, 84,220, 18,247,165,242, 87,254, 53,146,191, 64,183, 86,151,180,
 17, 60, 32, 80,134,144,152,153,  7, 73,  0,168,230,200,129, 53, 88,  5, 39,184,
126,250,130,105,101,162, 64,  2,105, 92,  0,192, 12,248,119, 43,113,193, 28, 53,
248,158,  8,110,  0, 70, 89,213, 96, 14,139, 85, 64, 40,180,202,193,231,  5,115,
  7,156,113,147, 21, 39,144,163,125,251,197, 92,137,177, 23,172, 13,216,122, 64,
134,149,121,249,157, 93, 44,112,226,  0, 99,244,217, 47,152,195,175, 11,226,134,
 54,  3,161, 60,134,  6,235, 99,161,186, 13,126, 86,117,107, 63, 56, 26,231, 78,
180, 24, 84,  9, 70, 57,  3,201,  1, 53,131, 38,230,153,233, 54,199, 87,203, 27,
 65,  5,176,181, 40, 90,220,
} ;

// ../Source/Template/GB_add_full_34.c:
uint8_t GB_JITpackage_59 [793] = {
 40,181, 47,253, 96,255,  7,125, 24,  0, 22,228,109, 40,224,176, 88,  7,248,157,
220,153,122,131,216, 76, 64,  6, 11,134, 41,119,105, 46,152,247,217,218, 79, 62,
167,183,121,246,197,147, 34,101, 48,195, 48,140, 23,  2,101,  0, 99,  0, 97,  0,
141,107, 95,147,225, 49,145,128, 25,144,221,185,141,251,225, 56,103, 24,243,225,
148,190,187,  2, 73, 68,242, 64, 32,136, 72, 30, 93,208, 29,158,157,152,240,129,
119,141, 44,111,155,  9,113,151,121, 12, 85,102,227,173, 76, 50,157, 39, 39,243,
220,182, 26, 25,164,241,141, 22, 31,207,191,187,247,141,175, 46,107,188,245,169,
146, 30,101,253, 19,131,  2, 72, 41,  7,131, 82, 70, 88, 85, 14,129, 60, 15,  8,
 36,145,198, 77,232,214, 57, 28, 46, 22,135,  8,133,140, 69, 66,  1,102, 44,216,
228,144,164,141,122,157,114,251,233,145, 83,183,208,255, 39,186,102,142, 25, 67,
 77, 57,178,179, 11, 63,170,208,130,176,140,125,179, 12, 55,156,138,157, 54,165,
241, 70,123,187,217, 30, 55, 24,241, 90,128,223,237,147,220,178,220, 13,255,255,
231,225,120, 34,  3,146, 71,103, 87,180,239,147,219, 19,155,185,182,180, 60,  2,
 26,242, 77,151,  8,220,152,177,197, 26,142,185, 74,145, 78,199,168, 19,106, 13,
223,169,247, 53, 41,126, 48,227, 59, 49, 77,224, 25, 26, 28,228, 58,159,113,221,
174,  7,155,178, 90,112,203,176,130, 20,152,139,245,170, 49,237, 14, 72,109,218,
121,192,237,221,141, 52, 94, 24, 90,208, 49,151,233,209,134, 39,180,119, 25,213,
157,102, 94, 64,175, 96,194,187, 48, 84,151, 30, 51, 75,227,169,  7,207,211,209,
161,185,155,127, 47,206, 75,212,159,173,248,156,210,163, 76, 63,245,103,239,150,
175,238, 60,203,154,139, 52,221,137, 55, 79, 23,184,198,178,  4,146,197,184, 63,
206, 57, 39,107,223,193,103, 49, 16, 66,161,162,221,101, 15,250,131, 11, 85,229,
212, 53,120,102, 57,210,220,  4,122,199,182,231,206,242,101,157, 24,229,218,167,
127,186, 69,  5, 69, 78,  2,119,205, 77,172,  1,128,146,168,145, 45, 67, 84, 34,
 34, 82, 80,144, 36,149,198, 48,132, 24,164,174,204,  3,146,128,128,146,101, 36,
 68, 20, 49,  4, 82,129, 76, 77, 82, 82, 30, 37, 69, 15,153,  6, 92,130,  0,143,
192,108,143, 45,156, 82,133,166,196,121,166,132,  6,202,199,166,221,147,237, 11,
181,  2,  5,200,253,154,  7, 88, 11, 32, 32, 99, 56, 54, 42, 43, 85,159, 96,157,
194,122,138,231, 21, 52,171,128,124, 32,180,137,120,253,151,149, 30, 39, 89, 76,
 61, 43,232,  5, 18, 77, 34,165,164,106, 64,226,221, 49, 33, 67,  8,118,164,  9,
 33, 20, 39, 49, 25,170,252,  9,181,199,108, 31,  5,182, 75,210,107, 54,108,110,
 37, 11,185,243,224,146,187,156,236, 65,211,199, 68,106,214,  2,187, 41, 63,  9,
 78, 18, 12,248, 37,235,146, 60, 33,221, 16,238,240,124, 70,233,182,164,220,239,
119,154,206,147, 65,104,253, 97,191,186,  3, 73,100,200,164, 16, 11,134,196,123,
194,243,116,144,212, 64, 34, 80, 17,142,143, 60, 60,232,147,135, 28,101,242,255,
  3,164, 76,130, 99, 22,106, 43,213, 44,  9,234, 26, 62, 12,213,215,228,197, 19,
126,217, 49,201,132,220,140,146, 44,238, 78, 73,201,168,216,232,224, 45,150, 23,
116,207,204,164,209, 73,246,242, 89,210,248,130,114, 79,109, 64,233, 91,228, 12,
 19, 58,140,166, 80,249,132,118, 40,243, 81,249,171,192,123, 73,233,148, 69,107,
 26,218, 96, 40, 84, 71,131, 77,164, 92,130,228,126, 48,  7,205,251,131,105, 43,
 53,157, 34,111,240,137,152,  2,244, 85, 74,187, 77,
} ;

// ../Source/Template/GB_add_full_template.c:
uint8_t GB_JITpackage_60 [667] = {
 40,181, 47,253, 96,161, 11,141, 20,  0, 22, 93, 89, 32,224, 88,231,136, 23, 28,
 41, 58, 98,173, 45,214,108, 48,104, 98, 82,102,252, 48,229,250,192,247, 12, 74,
 25,204, 48,  8,230,189, 81,  0, 78,  0, 77,  0,109, 26, 27,183,231, 56,123, 35,
235,249,189,243,150, 34,113, 72, 24, 26,136, 67,226,  4,110,112, 11, 91, 19,149,
252,154, 71,121, 57,252,236,231,150, 54, 51,153, 39,210,177,226,104, 60, 82, 81,
235,108, 75,154, 60,182,143,252,145, 21, 38, 36,242, 59, 58,211, 43,126,157,183,
123, 75,221, 86, 43,221,178,202, 49, 76, 26, 48, 44, 53,244,114,127,111,220, 94,
126, 23,254, 34,136,244,203, 86,244, 49,252,216, 34,202,179,240, 91,244,122, 75,
225,233,145, 91,141,237,105,236,193, 51,216,184, 71,241, 57,  4, 53, 39, 97,250,
189,189,207,127,201,195,149, 48,180,199, 81,113,222, 49,182,237,108,  6,187, 90,
 12,141,193,230,108,198, 16,146,116,174, 26,158,137,166,205,199,197,231,109,193,
200,160, 77, 73,137,100,110, 28,205,210,117,  5, 59, 27,144,242, 10,235,195,252,
 17,104, 61,234,189, 49,245,196, 99,235,229, 91, 21,164, 15,177,237, 44, 87,246,
194,231, 33,143, 28,195,254, 95,202,235,210,207,102, 49, 60,234, 94,202,217, 28,
102,241, 67, 97,250, 30,233,113, 82,118,182,130, 29,144, 43, 57,255, 11,  4,157,
 93, 40,230,204, 26,119,182,130,137,198,136,206,212,124, 44, 25,182,207,254,152,
183, 87,  0,238, 58, 40,  0,239, 90,186, 28,120,111,102,205, 91, 17, 66, 38, 16,
156,178,205,193, 83,153,201,198, 51,193,108, 31,203, 37,187, 74,181, 97,187, 77,
 66, 38,  3,218, 28,  2,185,102,240, 79,128,133,160,241,173, 35, 50, 34, 34, 41,
 44, 40, 72,105, 56,112, 70,132,134,174, 27,240,201,202, 13,133,191,244, 56, 61,
  0, 77,107,154,171,193, 38, 32, 77,251,  7,187,210,238, 93, 49,200,116, 26,246,
207,225,158, 51, 44,186, 65,147,136,196,135, 89,  1, 14,146,176,  7,205,113,162,
 33,254,247,126,140, 13,189,153, 45,134,243,178,253,172, 12,140,139, 64,229,200,
 30,188, 57,115,199,136, 33, 22,184,  3,156, 82,226,118, 88, 64,116, 24,155, 15,
 70, 59,118, 54,  0,158,208, 41,183,  5,143, 31,223,221,193,113,255, 16, 51, 54,
249, 70,140,107,104, 58,164,105,142, 57, 83,226, 33, 36,  2,114, 33,236, 76,201,
158,100, 54, 27,  5, 36, 76, 56,100,238,181,166,130, 22, 11,199,176,125,175, 26,
203,224,149, 17,241, 16,217,116,129,154,  1,126, 48,112, 68, 64, 35,178,220,108,
 22, 42,219, 38, 84,123,146,236,  6,164, 50,217,181, 99,234,116,172,245,  5,  8,
 79,210,201,168, 44,108,190,147, 72,148, 29,156,236,210,225,160,112, 44,104, 32,
230, 83,232, 98, 27,203,234,197,143,240,225,174,225, 60,203,214,167,109,129, 13,
 90,152, 54, 12,155,198, 64,123, 92,143, 96, 20,104,234, 78,129,166,115,203, 45,
 84, 64, 75,181, 10, 19, 29,178,176, 93,147,166,206,207, 76,119, 64,173,240,255,
184,252,185,254,138,  2, 61,
} ;

// ../Source/Template/GB_add_sparse_M_bitmap.c:
uint8_t GB_JITpackage_61 [1607] = {
 40,181, 47,253, 96, 93, 54,237, 49,  0,214,250,170, 40,176, 84, 85, 29,228, 88,
159,138, 65, 82,179, 28,203, 38,133,217,193, 66, 60, 66,189,254,137, 20,  5,120,
173,109,  3,134,230, 39,252, 83,250,211,228,236,120,  6,164,  0,149,  0,159,  0,
 37, 81,100,225,178,197,222, 87, 62, 66, 42,239,151,179,239,102,252, 81,  9,186,
 86,229,169,108,235,175,189,214,185,118,215,212,235,108,246,198, 30,146,221,115,
231,183,224,121, 43,194, 88, 10, 42,205,101,210,131,207,220,158,219,204,181,181,
 78,165,113,237,108, 78, 84, 54, 30, 44, 44, 90,131,110,227,190, 56,206, 28,200,
188, 56,165,240,148, 65,  1,166,160,162, 64,128, 41, 56, 37,147, 78,225,  9,146,
 15,183,192,135,184,108,187,137,113,202,  3, 39, 34,231,201, 11,145,241,116,158,
159, 39,186,117,234,182, 23,226, 46,175, 78,197,  9,110, 28,172,  6,202,135,202,
 72,213, 51,158,236,242,196, 46,235,106,124,165,135, 47, 77,147, 87,132,248,229,
 18, 85, 46,151,159,146,245,220, 32,207, 72,116,172, 11,131,  3, 17, 89,242,231,
229,207,190,218, 87,223,236,155,100, 98,220,217,167,245,125,158,221,205,204,101,
 87, 54,190,188,121,164,111,235,177,166,201,247,109, 14,164,206, 60, 45,245, 70,
 56,191,165,251,178,236,218, 58,127, 59, 75,122,173, 39,245, 60,105, 49,149,207,
248,235,222, 92,126,109, 80,111,243, 90,227,239,141, 29,135,164,  8,149,215,232,
103, 57, 28,130,101,247, 80,149,185,246,204,230,182,245, 67,183, 65,199,243,154,
229,114,119,199,147,195,  0,248,255,248,233,240,155,191,  2,176,143, 83,245,219,
 92,158,253,107,183, 83,148,126,219,255, 71,209,  3,148, 15,239,211,161,215,241,
249,233,115,154,222,112,239,154, 99,190,185,244,140, 37,141, 51,227, 59,183, 11,
 78,236,155,205, 73,234, 71, 94,158, 65, 32,176, 94,178,213,166,160, 15,252,243,
 77, 20,227, 77, 76,142,231,  5, 47, 56, 30, 15,180, 80,176,107, 47,141,107,107,
 82,122,174,141,251,122,199, 61,111,174,125, 74,229, 27, 36,185,119,155, 61,190,
 54,103, 13,162,242,211, 38,104,106,117, 62,127, 24,165,  1,160, 92,155,230,148,
238,212,  8,134,  7, 86,150,128,192, 41,150,119, 10,179,164, 91, 87,220,252, 51,
187, 83,107, 49,205,231,167,231, 43, 51,190, 54,183,188,231,235, 32, 33,215, 25,
121,156, 50,165,174,243, 91,107,245, 11, 16,  9, 81,116, 18, 99,140, 16, 66,152,
109,189, 38,111, 77, 31,127,237,225, 73,140, 49,198, 24, 29, 14, 61,  8, 33,140,
 80,122,211,201,137, 52,200,237,238, 25, 76,  1,140, 12, 48,206, 72,240,110, 44,
179,208,  0, 97,110,153, 27,131, 16,194,248,140,  2,118, 82, 93, 54, 95,241,226,
176,168,168, 30, 79,174,164, 50,195, 23, 69, 69,135, 34, 67,114, 30,149, 84,252,
184, 26, 30, 67,217,235,250,120, 38, 96,162,232,100,154, 42,111,155, 90,165,124,
 78,205, 83, 85, 37,221,162,130,227,233,104,112, 98,140,152,165, 78,141,192, 83,
159, 41,165,195,235,  1, 86, 76, 84,120, 58, 85,213,152,182,230,211,148,157,128,
227,129, 17, 22,215,195,  3, 12,136,159,224, 55,175, 46, 61,198,129,119,168,113,
185, 50, 36, 34, 34, 35, 34, 73, 82,144, 52,  6,145, 12, 65,138, 49,232, 32, 44,
 15,130,112, 68,142, 97, 12, 67, 33,  8, 69, 64, 16, 33,132, 16, 43, 32,  2, 34,
 64,  2, 34, 32,132, 48, 33,137,148, 92, 29, 33,136, 88, 98, 60,251,199,249,188,
 14, 44,133, 76,245, 61, 65, 32,199,201,187, 42,124, 83, 78,136,167,199,  5, 83,
 90, 68,248,210, 84,120,213,182,231,187, 79,252,233,143, 79,203, 29,213,233,143,
202,160,220,  7,222,244,199, 39,154,254,155,251,113, 85,251, 66, 85, 57,134,138,
 66, 72, 67,155,158, 43, 53,164, 90, 82,233,157,132,248, 44,129,157, 96,246,231,
153,100,216, 18, 95,238,252,116, 69, 25, 89,156,111,156, 85, 73,120,242,134,  4,
103,124, 67,233, 99,  8,162,235,202,206,189,226,188,127,135, 82, 17,186,  1, 71,
193,243,255, 43,131,233, 82,240,243,  5, 69, 57,138,244, 27,228, 39, 66,136, 10,
 50,235,112,  8,208,201,220,217,156, 69,159,209,229, 71, 87, 91, 72,  6, 20,105,
193,225,208, 79, 20, 87,198,  2, 33, 10,104,201,184, 89, 44,198,211,163,123, 21,
110,101, 39,249,211,200, 87,200,171,189,120, 94, 34,120,222,  0,250, 49,239,164,
154,106, 58, 36,  0,  4, 59,113,170,169,209,208,  5, 67,252,251, 11,103,  0,131,
179, 51,143,240,135, 18,254, 15,  1,157, 54,108,171,154,116,  1, 95, 27, 68,  7,
 43,206, 81, 24, 10, 60, 46,202, 65, 88,220, 27,236,100,206, 21,113,158,220, 91,
157,143,192,107,231,230,205,125, 19, 40,111,166,255,107, 58,215,174,161,233,250,
242,222,236, 40, 27,225,114, 51, 75,131,205, 43, 79,138,246,  1,164, 80, 14,242,
210,115,120,224,173,  8, 73,221,236, 13,177, 51,118,192,192,204, 53, 96, 95,241,
 14,251, 55, 85,127,  0, 72, 11, 79, 98,168,184, 12,118,227, 27,126, 47, 94,214,
138,160, 30,194,136,250,169, 17,169,  4, 63, 58, 23, 91, 93,114,226,123, 80, 51,
173,152,250, 91, 64,207,248, 38, 74, 55,249,207,229,105, 46, 32, 72,132, 28, 13,
172,  0, 18,208,207, 88,136, 51,124, 91, 29,199, 14,  8,155, 91,234,252,234, 99,
216,253, 89, 39,  8,  8,108, 90, 46,  4, 59, 23,212,206, 45, 78,  9, 16, 18,117,
106, 33,156, 37,141,120,242, 40,137,160,213,166,175,119,188,210,181,164, 81, 63,
 96, 76,135,221,213,168, 35,226,198,  2,171, 41,242, 61,150, 92, 82, 79,246,120,
 50,141,143, 23,198,196, 52, 64,245, 17, 46,133,162,142,106,138, 14, 54,102,120,
 13, 79,136,102,163, 87, 29,  4,124,227,133, 30,138,190,225, 13, 22, 41,114,182,
 90,249,134, 37, 18,254,189, 40, 64, 58, 53,216,174,225,214, 24, 73, 17,  0, 46,
 35, 28,200, 19,154, 43, 72, 33, 10,254,100,152, 48, 19, 45, 95,188,109,  4,220,
236, 46, 69,162, 26, 10,207,180, 64,152,216,167,  2, 50, 19,138,134,192,154,117,
 57,207, 51,199,176, 17, 10,215, 42, 91,  0, 42,156, 85,251,135, 16,248,216,195,
148,152, 36,192, 54,105, 41, 16, 53,209, 78,243,222, 83,155,220,135,127,220, 16,
238,183, 83, 54,228,164,126,170,154,134,244, 76,180,122, 86,166,176, 80,144,  5,
199,235,172,126, 32,218,145,252,135,195, 46,208,128, 69,176,186,116,225,129,222,
 77, 13, 76,109,  8, 38, 52,  2, 11,199,103,147, 17,149, 72,235,171, 91, 43,114,
 90,167,212, 30,176,133,105,168,187, 95,208,212, 11,148,  6,210, 46,230,195,158,
228,236,186,226,231,110, 64,225,145, 13, 27,  4, 55,142, 57,216,162,  2,213, 82,
  0,128, 91,144,226, 82,200,243, 55,233, 32,209,  9,168, 23,226, 27,249,231, 52,
 97, 79,175,249, 33,128,195,  5,  7,125,202,138, 47, 24,163,194,179, 29,144, 31,
 49, 35,244,172, 41,216,185,172, 85, 54, 97, 31, 19, 52, 83, 66, 12,  6,181,133,
124,154, 59, 57,154, 59, 73, 46,152, 53,150, 19,236,108,105, 94,132,193, 71,145,
204,187,199, 61,155, 97, 99,176,202, 20,212,128,242, 62, 31,177, 40, 85,211,  7,
 62, 34,  0,107,141, 94,198,108,183,133, 50,174,248,236,113,181,203, 26,149, 75,
108,206,166, 89,249,131,169, 95,209,120,209, 87, 61, 68,141, 44,219, 60,163, 43,
193,188,127, 95,237, 43, 30,
} ;

// ../Source/Template/GB_add_sparse_M_sparse.c:
uint8_t GB_JITpackage_62 [2495] = {
 40,181, 47,253, 96,125, 47,173, 77,  0,170, 82,244, 14, 40,192, 20,217, 28, 36,
173,112,153,132, 78,254,107,212,  6,235,  0, 32,210,171,103,177, 75,227,173,186,
221, 63,186,114, 94,232,211,167,223, 85, 20,  4, 69,  1,  8,228,  0,225,  0,228,
  0, 20, 91,220,188,112,189, 56,235,163,113,215, 39, 28, 90,221,120,198, 53,130,
226,213,  4,175,205, 89,135,188,185,252,205, 62, 55,198, 66,124,202,101,149, 19,
153, 56, 44, 21,138,162, 38,184,241,145, 57,213,249,207, 30,119,166,246,127,124,
 73,244,129,105,190,250,171, 27,244, 77,251,250,194,220, 82,121,245,  9, 62, 95,
  9, 10,249,171,184,126,206,231,238,232,219,156,200,165,191,250,181,219,193, 48,
 55,254,255, 83, 40, 37, 20, 10,245,107,143,189, 47,165, 24, 80,  7,149,230, 50,
 10,198, 95,110,215,173,230,175,181, 77,165,241,215, 89,141,168, 96,100, 58,148,
214, 33,183,113, 79, 28,103,174,163, 78,188,235,226, 39,132,  3,131,131,202,130,
197,224,224, 81,  6,125,194, 53,132,102, 78,197,127,184,108,189, 74,241,201, 19,
 35, 36,  7,210,251,224,233, 92, 67, 15,229, 54,248,225, 10, 62,175,125,244,214,
 39, 41,197,170, 97, 50, 68, 30,211,  5,178,126,153, 87,227, 75, 65,124,105, 26,
189,228,195, 11, 10, 40,149,130,130,150, 87,213, 53,158,  8,209,185, 50,153, 40,
 16,125, 66,223, 43,213, 73, 62, 15,111,186,246, 83,215,133,219, 47,165, 91,141,
195,219,252,207,237,144, 75, 99,154,189,163, 53,107, 16, 71, 17,195, 38, 38,143,
164, 70, 33, 72,202,  8, 48, 63, 48,240,107, 82, 29,197,108,215,113,154, 81,159,
 92,187, 61, 63,133, 43,166,216, 43, 31,172, 66,255,105,207,184,167,214,152,214,
142, 70,  8, 81, 30,200,175, 30,196, 93,111,254,250, 93, 71, 31, 89,160,139,214,
 89,238, 25,135,222, 49,194, 27,247,103, 39,144,122,185, 98,217,126, 31,205, 46,
 35,213,209, 27,230, 44,188, 25, 99,183,249,243,184,111, 13, 65,250,254,179, 53,
 87,237,179,217,  3, 62, 48,245,254,193,180,  3,222, 28,197,137, 69,250,186, 11,
249,244,  9,156, 87, 71, 62, 24,188,106,248,229, 30,119,184,108,190, 62, 26, 42,
243, 85,117,142,143,141,137,121, 20, 17, 81, 33,241, 10,224, 20, 19, 26,143, 39,
 70, 31,208,102,  7,187,181, 83,232,220, 60,166,111, 47,218,197, 79,125, 62,234,
 61,196,174,125,252,109, 46,215,254,151,193,206, 70,250,249,235,154,213,109,235,
123, 82, 68,  0,253,151,132,156,115, 70,130, 99,105, 60, 87,135,211, 89,189,153,
122,239,190, 92,190, 92, 16,162, 41,103,148,191, 28,108,213,195,130,222,225,104,
 60,155, 11,141,148,152, 29,137,159, 60, 42,205, 68, 78,  4,199,179,217, 90,251,
166,132, 46,107,189, 52,213,  8, 61, 94,155, 40,154, 70,166, 39, 90,179,206,106,
 89, 24,233,146,196,128,185,193,171, 67, 26,141,205,  4,135,194,210, 88, 92,153,
185,241, 92,113, 62,196,137,206,244,248,139,197,162, 89, 46,247,188,148, 50,227,
 91,183, 43,214, 87, 98,227,109,179, 87,140, 34,232,155,109,146,138, 79, 48,205,
249, 73,122,181,160,204,107,111, 78,204,171,231, 75, 51,190, 44,208,186,253,110,
231, 76, 65, 76,214,209, 26, 82,111,198, 97,254, 66,155, 61,171,157,197,188, 15,
 62, 37,165, 75, 27,  4,105,231,143, 94, 26,118,112,249, 95,205, 95,223,226, 79,
209,  3, 20,202, 73, 87,  7, 82, 82, 14,236, 40,118, 98, 93, 54, 95,241,202,232,
112,172,147, 75, 59,154,225,139,230,198, 36, 56, 27,137, 10, 73,178,192,250,234,
 28,150, 37, 73,191,181, 85, 22,134,125,146,152,148, 18,147, 82, 74, 12,147,209,
 39,232, 30,205, 38,162, 51, 55,211,116,  8,107, 34,102, 76, 68,137,141,180,100,
174,163, 94,144, 82, 24,119,247,133, 23,177, 29,174, 17,147, 21,186, 20, 65, 48,
252,176,182,251, 71,134,249, 66,187,209,136,121,135, 95,205, 17,128, 71,245,222,
 89,139, 93, 94,138,181,132,225, 19,234, 16,202, 61,146, 28,224,198,177,  8, 77,
 26,237,140, 65,175,243,149, 96,112,121, 93,112,225,100, 56, 18,206, 93, 72,143,
227, 79,245,116, 59,211,238,211,181, 86,179,214,114,119,116, 84,220,119,218, 54,
212,167,198,247,237,231,208,118, 14,165, 20, 43,203,106, 93,104, 57,252,137, 41,
247,249,173,210,236,153,158,203, 46,109,250,225,182,218,163,107, 55,104,226,198,
 52,111, 10, 60,155,105,253,117, 84,220,  1,130,165,168,226,195,144, 57,132,102,
100, 68, 36, 73,146, 66, 99,194, 40,  4,163, 96, 32,232,114, 10, 31,178,104, 84,
 18,197, 32,  8, 98, 26, 67,  8, 33,  2, 66,144, 64, 68,100, 36, 18, 25, 73, 18,
180,176,205,  1, 27,212, 22,172, 54,146,112, 78, 95,116, 10,157,194, 84,191, 59,
 49, 38,130, 48,127,116, 94, 82,222, 28, 36,130, 49,208, 99, 42,216,224, 13, 81,
138,229, 27, 22,218, 65,138, 46,209,224,173, 37,102,167,127,102,100,214,248,180,
 98,158, 26, 92,238,143,108,149, 18,127,164, 62, 77,117, 38,111,196,127, 64, 81,
  6,244,173, 92,147,172,118, 84,244,203, 18, 40, 38,  3,233, 17,237,154,241,139,
246, 18, 43,208,255, 98,238,141, 64,185,226,192,234,234, 11, 51, 42, 31,141,255,
 71,212,153,156,124,121,255,105,151,181,218,153, 63,240,204,110, 38,200, 50, 82,
125, 52,160,211,127,  8,139, 58, 35, 93,130,159,191,247, 48, 30, 90, 24,142,170,
106,121, 34,148,198, 71, 32,  8,111,203,184, 61,135,208, 16, 31, 48,109,217,132,
 78,203, 11, 58, 59,144, 31, 18,120,  2,224,188,120,141, 15, 74,195, 62, 33,113,
  4,224,197,255,131, 15, 48, 35, 64,122,215, 81, 67, 75,159,199,245,155,164, 95,
179,225,172,110,135,167,  0,252,189, 24, 28, 11,223,184,110,121,  1,110,246,191,
229,205, 73,124, 16, 23,174, 74,123,218,128, 77,104,186,209,185,111,227,223, 78,
241, 45,128, 78,110,174,229,120,  8,151,209,115,161, 82,185, 74,114, 17, 61,230,
249,164, 93, 20,170,170,173,165, 18,233,145,114, 65, 60,245,238,112,150,  8,101,
131, 92, 93, 67, 49, 34,181,137, 99,141,165,158,179,  6,168,133,  7, 18,247,246,
  8, 13,104, 18,194, 20, 90,199,236,186,100, 55,221, 60,173, 36,230,111,226,254,
144,193, 27,115, 41, 89,252, 62,122,242,111,210,116,153,178,232,136, 62, 32,110,
244,138,116, 15,170,224,208,169,113,179, 73, 72,118, 47, 71,246, 38,  8,186,124,
 24,196, 25,116,134, 57, 62, 97,210,  3, 37,254, 14,136,211,167,  4,119,248,154,
213,187,136,190,150,  6,166,220, 84,  1,220,182, 60,184,178, 66, 75,195, 47, 12,
229,215,190,252,206, 28,147,104, 67,  1,180,213,252, 11, 60,126, 84,124,159,210,
189, 72,125, 93,112, 94, 85, 79, 14,142,228, 81,183,244,253, 47,114,217, 16,112,
 52,249,184, 60,161, 88,119,202, 99, 98,230,212,246,124, 46, 80,126,188,137, 76,
198,246,240, 46,172, 50, 88,229,228,142,159, 96, 37,167,240,251, 71, 88, 58, 53,
 22, 52,210, 64,154, 53, 57,207, 43,142, 72,164,229,126,128,194, 74, 81,242,164,
248,105,215,250, 20,217, 87,191,168,162, 62,164, 99,  8,251,  1,239,  2,214, 22,
 56, 11, 17, 62, 43, 72,200, 36,  6,167,167, 16, 65,238,125, 76, 82, 49,168, 82,
249,227,164,  9,  1, 91,183, 49, 59, 89, 72, 44,152,174, 11, 32, 47,205, 97,226,
 48,153, 15,  2, 29,244,138, 25, 72, 23,176,167,182, 22,130,  5, 87,165, 48,106,
 31, 47,162, 39, 98,  2, 32,145,231, 28,113, 98,118,154, 73,215, 20, 72,207,104,
189, 73, 86,111,166,153, 47, 55,235, 15, 42, 87, 82,157,101,203, 58,213, 16, 20,
100,216,102,228, 57,106,236,230, 69, 95, 27, 46,129,254,198,142,103,168, 25,193,
177,116, 52, 52,185, 16, 50, 31,174,205,152,184, 57,233, 12, 55,118, 89, 56,122,
 19,173,188,134,210,153,136, 60,241,166,117,171,142,153, 66,150,129, 43,112, 32,
158,173, 81,180, 72,118,241,248,214,183, 20,239,164, 29,170,220,176,131,234,194,
  1,167,179, 45, 36,180,  3, 55,236, 69,194, 92,121, 65,130,203, 18, 97,106,114,
137, 97, 82,228,  5,235,194, 93, 24,230,189,197,207,114,204, 77,218,  5,145,162,
102, 56,136, 61,160, 60,207,156, 33,200,120,187, 58,251,141,228,235,  0,131,187,
235,108,173, 69,104,100, 12, 37, 81,242, 78, 40,108,132,146,208,189, 48, 69,105,
129,  7, 37, 28,230, 98,240,183,141, 10,218, 59, 25,103,169,200,192, 86,124,114,
220,109, 11,150,156, 22,124, 32,128,131, 49, 53, 78, 24,168,183,  9, 40,191,221,
 58,109,177,231,192,193,208,229,165, 99,183, 41, 42, 37,181,211, 92,113,100,123,
112,156, 64,177,129,142,234,115, 70,136, 41, 56,100, 50,189,213, 63,111, 95,168,
 77, 52, 53,254,159,195, 74, 76,145, 53,168, 32, 29,  7,152, 25, 34,161,191,121,
 12, 99, 28,201,219, 19,237,242,178,182, 59,113,155,247,112,174,178, 65, 90,140,
183,150,  0, 81, 90,190,120,245,181,246, 53, 27,223,210,140, 53, 82,213,156,153,
 44,220, 18, 10,237,162,215,217, 17,218,229,166,193, 42,217, 87,155,102,237, 26,
 82, 74, 96,243, 97, 38, 83,170, 84,198, 67,119,225,250,127, 46,199,183, 13,109,
136,255, 12,227,164, 18, 34, 96,138,104, 66,175, 24,240, 61, 80,225, 55,173, 47,
 34, 46, 21,178, 87,137,138, 30,166, 71,255, 83, 72, 89,207,148,253,198, 25,137,
 76,117, 17, 87,103, 81, 92, 18, 68,216,232,126, 72,223, 97,183,147,  0,205, 69,
102,149, 22,178,184,119,  4,144,  7, 75,195, 37,174,193, 69,244,186,190, 19, 58,
226, 92,176,198,131,231,197, 38, 98,206, 35,223,211,196,192, 45,221, 10,197,190,
223,241, 27,226,102,127, 34,203, 55, 57,199,242,185,231, 81, 79, 55,193, 46,112,
 39,210, 71,167,239, 30,146,196, 94,167,186, 14,252,150, 65,110, 20,142,251,252,
177,121, 58, 61, 17,132, 39,201, 69, 73,186, 66,134,214,217,164,139,  5,187,188,
128,126, 11,225,143, 69, 75,194,  1,187,  1, 58, 95, 58,227,158, 66, 95,  4, 27,
 66, 25,247, 70, 68,225,240,  9,  2,181,146,231, 41,217,139,168, 48,191,237,201,
 61, 35,158,185,204,135, 30,243, 38, 13, 51, 84,235, 62,211, 80,126,126, 53,  0,
131,237, 49, 21,157, 16,161,101,142, 99,112,  7,  6, 53,220,138, 36,109,246, 12,
139,154,176, 37,144,231,166,198, 48, 74, 85,  8,158, 76,154,184,250,214,  4, 39,
153,172,215,129,229, 96,148,148,115, 71,192, 42,205, 90,126,135,230, 26,218,185,
 90, 34,159,229,146,109,  9,201,221,198, 52,197,233,136,102, 44, 17,  9,215, 99,
119, 30, 47, 71,226,236, 56,177, 45,132,243,109, 14,159, 32,232,248, 26, 26, 15,
 23, 79,145, 42, 20,209,129,248,209, 97,109,  7, 66, 29,134,146,162, 80,139,134,
230,240, 28,198,131,156,239,186,216,255,212,177,132, 19, 47,162,  5,117,113, 66,
172,181,218, 45, 76,212, 35, 78,  9, 34,237, 39,226, 17,165,174,101,221, 79,234,
115,229,197,186,224,213,171,192, 92,225,216, 13,184, 19, 93,162, 80,144,213,115,
177, 93,133, 50, 65,186,200,104,155, 29,158,220, 57,241, 94,160, 62,  9,  8,171,
213,107,220, 93,143,160, 89,101,103, 37,240, 64,137,133,213,114, 24, 32,210,241,
 67,161,204,195,228, 26, 47,220,209,166,205, 61,177,147, 41,161,105, 10,182, 25,
202,  2,162,114,224,211, 13,194,205,166, 89, 15,192,244,215, 38, 82,158, 68,171,
119,182, 23,203,181, 74, 35, 58,248, 78,171,182,162, 63,129,
} ;

// ../Source/Template/GB_add_sparse_noM.c:
uint8_t GB_JITpackage_63 [2031] = {
 40,181, 47,253, 96,118, 63, 45, 63,  0,234, 70,236, 12, 40,176,148,177, 14,180,
145,158,138, 11,149,130,216, 47,240, 78,183, 38, 21,184,176, 27,178, 30, 64, 24,
 71, 39,113,155,  6,104,126,194, 63,165, 63, 77,239,142, 75,194,  0,191,  0,200,
  0,179,203,213,252,110, 62,238,219, 81,213,176,207, 55, 42, 95,253,214,121,229,
241,212,250,102, 57,250,253, 42,119,207,147,231, 60,148, 59,179,244, 62,109,238,
240,  1,104,176, 60,158, 58,252,230,214,188,179,251, 54,219,179, 86,230, 47, 59,
192,111,125,149,233,196,243,218,231, 74,143,251,159,255,255,100, 50, 50,185, 88,
 50,149,217,105,210,194,107,238,108,174, 51,157,155,167, 50, 49,157, 90, 75, 84,
 48, 56, 20,150,109,130,220,137,103,232, 56,119, 29, 29,186,231,193, 87,  5,153,
 75,166,146,128,185,100, 78,209,166, 87,184, 65, 36,231, 22,248, 82,151,235,168,
 69,175, 46, 40, 17, 59, 43, 47,132,230,154,185,191,107,242,129,229,232,149,190,
186,211,150, 58,130, 91,175, 34,  5, 55, 20,143, 74, 51, 89,215,124, 42,197, 38,
190,210, 98,108,219, 36, 22, 33, 78, 64, 48,169, 16, 16,  4,215, 96, 46, 31,  1,
129,115,  1,222, 44,201, 78,201,111, 46, 66, 61, 52, 11,204,199, 37, 73,242,184,
122,122,103,206,210,126,118,162,223,  2,127, 43,119, 60, 61,251,229,119,208,222,
232,180, 92,125,  8,238,139, 78,186,136,130,199,157,214, 29,233, 85,110, 73, 42,
101,223, 75, 30,173, 31,161,100,218,213,  3,247,134,205, 43,177,136,109, 84, 98,
240,152,111, 54,239, 92, 48,130,  2,227,112,224,116,174,  3, 98,100, 56,229, 36,
 36, 24,110, 12, 78, 23,133, 58,215,  5, 41,217,111, 37,192,116,110,114, 58,158,
125, 51,157, 19, 68,118, 31,113,245,248,214,172, 77,144,123,242,219, 26,164, 55,
218,149,231,125,156,149,163,220, 89,151,107, 22,161,165,203, 77,250, 54,243, 23,
 41,184,177,126,139,132, 68,197,196,177,252, 86,187, 60, 71,199,221,229,215,124,
218,223, 38,198,210, 62,189,125,249,194,109,113,167,215, 33, 25,203,  2,230,180,
223,241,101,151,199,119,118,116,244,205,115,171,218,185,250, 73,219, 35, 85,207,
171,156,102,163, 95,189,242,227, 86,210, 23, 48,151, 12,102, 93, 31, 44,212,145,
240, 80,124, 40,217, 89, 79,198, 44,203, 10,178,238,238,238, 74, 51,100, 22, 86,
 51,  6,177, 12, 10,144,117,165, 39, 53,140, 81,148,204, 51,155,  0,121, 38, 42,
112,149,241,120,213,150, 53,157,  2,212,185, 60, 23,157, 24, 99, 54, 61,214,234,
 85,  8,124,229,209,114, 58,196, 56, 16, 36,  1,186, 60,220,220,104,140, 20,216,
223,156,195,158,186,101, 55,222,214,169,219,142,167,224, 55, 61,221,162,168,134,
219, 51,252,242,205,237, 51,102,128,144,105, 79, 29, 13, 79,  8, 36,178, 58, 22,
 24,231,227,185, 48,248,129,128, 33,138,103, 44,189,216, 25,223,230, 48,216, 27,
105, 29,127, 93,190, 38,147, 73,201,196, 44, 75,101,151, 24, 51,104, 39,153, 43,
 61, 67,230,166, 23,127,235,161,101, 99,140, 49,118,140,209,225,176, 33,132, 25,
 74,132,  2,  2,211,167,215, 29,169, 71, 18,231,175,102,242,130,137, 49, 70,  8,
 33,140,215, 44,200, 74,165,170,122,122,132, 21,130,157, 11,203,  8,193,  9, 79,
228,238,213,154, 97, 94,129,246,155,107,105,191,191,209,230, 54, 58,177,104,223,
240, 56,161,181,179, 54,241,157,153,182,  8,165,175, 80,217,105,223, 72, 97,224,
153,130, 59,192,152,  0, 99, 83, 25, 99, 62,111,229,102,118, 60,175, 65,104,144,
242, 21,132,241,154,  3, 14, 10, 87,167, 72,227, 15, 84, 49,190,178,218,154, 94,
178,218,104,142, 74,217,224,210, 29,101,140, 22,250,137,171, 29,205, 92, 73, 12,
127,139,188,211, 86,206,  4,200,234, 92,153,  2,235,  1, 19, 93, 33,207, 67, 85,
  3,129,249,168,129,181, 50, 52, 34, 34, 34, 34, 73, 65,146, 52,  6,161, 12, 49,
134, 57,166,180,179, 14, 34,120, 56,154, 34, 34,  4,193, 16,194, 16, 66,  4, 74,
 64,168,128, 16, 33, 34, 70, 40, 50, 34, 34, 82,101,115,213, 13,208,120, 61, 87,
243,102, 19,147,  8, 54,251,251, 77,188, 12, 39, 34, 85,231, 50, 82,246,190,185,
252,235,213,231,148,180, 71, 31, 20,102,165,186,160,237, 90,173,107,190,108,173,
114, 45,214,233, 57, 76,180, 57,  7,128,137,129,198,144,220, 42,107,197, 27,181,
210,143, 90,173, 38,243, 22, 13,214,101,224,139,194,  3,202,151, 62,165,  3,255,
 84, 60,212,110, 16,  7,199,252, 69,208,177,115, 49,163, 92, 63,232,174,178, 19,
174,129, 93, 39,178,160, 21,169,226, 32,125,102,106,197, 96, 48,214,159, 75, 83,
 79, 56,205,105,116,106,  4, 35, 36,111,111,191,230,242,187, 80,182, 87, 53, 78,
152,205, 22,249,223,138, 52, 63, 91,100,170, 42,217,105, 23,158, 22, 20, 15, 71,
 29,183, 77, 79,156, 41,142,  3, 95, 39,140,197, 54,164,223,224,200,209,237,  0,
120, 82, 28,147,121, 67,130,221,144,227,  1,100,156, 50,208,172,210,226,110,241,
 71, 75,186,  3,212,243,  3,180,  7, 68,112, 53,145,175,129,173,152, 63, 26, 67,
169,191,172, 62,195, 65,227,228,121, 78,  8,184, 81,152,240,195, 53, 85,181,162,
 15, 33,182,194,182, 14,196,231, 39, 13,199, 77,157, 80,161, 71,128, 84, 43,189,
114,232,147,178, 41,  9,134, 90, 25,255,205,235, 96,217,100, 23, 60, 24,122, 11,
  9,  9,  9,131,113,  7, 48,108, 41,  9,212,214, 25,143,236, 70,  8,139, 49,248,
100, 19,148,150, 58, 56, 38,175,110,132,152, 71,119, 98, 84,174, 16,172,128,135,
238, 74, 77,112,  9, 73, 57, 46,189, 98, 22,161,251, 52,114,246, 48,172,159,167,
167, 40,201, 65,114, 83,133,141, 12, 75,207, 18,144, 30, 95,251,207, 78,136, 89,
 74,115,222, 84, 61, 76, 16, 74, 93, 28,163, 63,104, 42, 57,117, 25,172,147, 48,
 40,102,188,106,  3,236,114,255,232,151,173, 76, 26,221,157,  0,221,229, 28,124,
 28, 20,188,140,111,187,129,234,201,139, 53, 84,255,  1,188,219, 43,204,175,239,
 56, 28,104,167,224,132,206, 20,163, 20,247,251, 23,203, 29,  1,140, 27, 59,249,
 56, 19, 26,194,169,189,211, 71,218, 44,224,165, 11, 60,180,143,186,165, 50,193,
150,171, 47,  0,238,177,220, 35,160,220, 55, 63,236,238, 47, 48, 10,225,248,112,
157, 55,192, 87,235, 84,  2, 13, 53,144, 59, 13,102, 53,159,205,208,140,127, 52,
111,140, 99,130,218,  0,254,115,240,183,157,198,104,125, 97, 27, 48,164,150,197,
192,128, 88,220, 38,130,210, 58, 36,249,147,166, 33,148,217, 66, 58,180, 57,108,
192, 52,140, 60, 65,244,241,177,116,141,232,133,135,221,168, 63, 57,173, 69, 18,
220,  5, 13,118,166,180,  4,187,124,229,248,209,152,  2,212,  0, 55,  0, 77,158,
111,233, 82,207,116, 58, 49,187,109, 24,  4,  4, 88, 60,232,145,101, 64, 14, 58,
224, 50,184,107,167,187,253,148,  3,142,131, 19, 42,205,120,159, 34,233, 27,116,
 11,168, 69, 17,162, 40, 79, 71,217,116,209, 12, 88,174, 14,178,176,129,169,196,
175, 45,187,177,248,  7,223, 53,186, 21,194, 69,149,116,236, 44,160,  3, 63,125,
110,249,173,115,141,115,125,122,205,232,170,220, 78,227,  6, 99,134,177, 23, 23,
 10,125,248,239,152, 94, 34, 69, 72, 45,145,109, 62,191,164,169, 52,128,210,106,
111,135, 82, 88, 52, 45,103,110,139, 46, 58, 10,160, 91, 49,187, 36,184,184, 59,
 87,  1,220, 95,  8, 73,  2, 47,151,188, 37,  0,187,232,124,127,118,207, 83,203,
137,181, 23, 19,215,210,251, 89, 31,188,168,108,187,160, 60,163,253, 18, 97, 23,
124,182,188,130, 87, 42,  7,110, 96,101,103,  1, 13, 33, 67,144,211,246, 60,234,
113, 42,117, 11,239,171, 35,161,149,  5,  4, 51,218, 26,197,100, 67, 87, 64,122,
 47,136, 48,  7,180,201,210, 16,150,181,176, 89,102, 46, 58, 76, 50, 68,128,114,
  4, 29,117,197,105, 37,236,208,205,200, 11,141, 52,197, 80, 81,217,180,161,201,
115,210,185,  9,127, 28, 99,238,  9, 26, 31,156,139,241, 42, 79,220,193,154,182,
221,203, 78,227,151,171,203,128,207,137,  7,152,193,154,164,198,144,205, 36, 39,
239,152, 42,135,158,146,160,178, 21, 18,180,242,107, 77, 51,237,126, 35,145,240,
182, 24,247, 83,156,147, 34, 27, 72,187,229,119,189,201,168, 46,141,188,230,231,
135,148,152,219, 55, 34, 19,140,212, 14,130, 10,130,242, 38,116, 27,103,115,128,
108,211,200,135, 70, 61, 28,236,126, 37,175,184,148,165,177, 97, 93, 66,220, 25,
111,181,151,104,166, 50, 64,113,207, 45,122,116,  9,150,180, 96,164,130,101, 32,
 88,191,143,116, 52, 39,242,119,125, 35, 44, 94,140,109,235,202,197,197,229, 38,
198, 49,128,145,160,188, 66,157, 76, 50,210, 21, 53,166,156,240,177, 94,128, 73,
 55, 74,101,114,141,206, 28,109,238,108,131, 40,219, 45,125, 15, 60, 72, 73,198,
164,238, 24, 77, 85, 90, 16,146, 40,244,143, 27,242, 58,105, 58, 53, 55, 57,238,
215, 14, 84,136,118,226, 86,141, 83,136, 43, 20,179, 59,246,  4,214,224, 54, 56,
147,219,114, 20, 53,200,214, 16, 79,142, 73, 68,241,146, 26, 39,252, 86,129,217,
169, 36, 53,203, 74, 14,182, 28, 52,235,255, 96,194,170,217, 97, 38,235,224,152,
106,116, 88, 23,103, 22,156,106,191,109,  2,
} ;

// ../Source/Template/GB_add_sparse_template.c:
uint8_t GB_JITpackage_64 [1707] = {
 40,181, 47,253, 96, 89, 34, 13, 53,  0,246,252,178, 40,192, 84,177, 14,104, 89,
224,245,150,180,253, 21, 50,184, 48, 63,135,107, 27, 45, 32, 65,240,  5,178, 83,
169,100,104,165,248, 80,102,183, 77, 81,232, 40,206,  5,169,  0,159,  0,167,  0,
157, 55, 59,170, 88,  7,149, 45, 58,150,  0, 26,235,145,194, 79,125,225,113, 99,
242,102, 56,250,221,106,  6,159, 77,  0,104, 62,231,150, 89, 56,202, 82, 84,157,
250,179,220,189,178, 78,161,100,126,235, 41,  6,212,193,165, 53, 12, 90,247,204,
109,153,201, 76, 59, 78, 92, 26,211,198, 36,231,162,241,128, 65,197,  6,185,141,
219,115,156,181, 14,233,249,156,238, 19,194,129,193,193,101,  1, 99,112,240, 10,
 38,125,194, 18,  4, 62,156,114, 31,209,114, 29, 73,208,167,143,227, 60,205,194,
 27,145,249,116,150,219,135,114,219,142,104,  5,199,242,214,105,107, 33,111,232,
104,172, 79,207,226, 42,235,207,116,134,211,142, 58, 95,141, 47,180,248,138, 17,
 94, 47,226,  5,  5,148, 75, 65, 65,114,  4,233, 72,148,122,110,177, 53, 12,191,
 66, 47, 75,194, 17,246,213,242, 53,218,232,236, 57,225,133,246,135,163, 14,120,
173,128,245,131,138,199,148,145,172,107, 24,236, 83,121,220,242,102,218,207,116,
171,216, 51,152,151, 80, 40, 21, 41,211,183, 94,241,167,251,166, 53,102,110,133,
160, 70, 68,143, 88,106,217,250,173, 89, 99,219,205, 56,207, 13,247,125, 86,143,
111,141,141, 55,128,169, 49,196,222, 51, 82,168, 61, 87, 90,227, 67,234,140, 85,
203, 61,122,107,160,159,106, 60, 97,246,129,225,232, 26,153,214,194, 99,122,183,
220,247, 35, 89, 82,  4,141,161,102,107, 62,135,147, 97,113, 12, 79,229, 99, 99,
 12,109,231,180,181,252, 41,  6,180, 55, 42, 51,173,216, 43,151,208, 79,197,219,
 32, 77, 53,208,192, 64,165,121,232,131,227,214,146, 14,242,108, 62, 31,135,177,
 88,150, 10,253,183, 44,142,180,175,201,178, 36,212,  3,171, 28,179,249, 56,  9,
140,235,225,193,  9,124,124,210, 44,233,214, 37,241, 34, 94,221,195,210,242,199,
228, 81,105,168, 60,  8,174,183,142,104,197, 23, 86,172,241,236,147, 99, 13,242,
158, 89,125, 99,114,226,195,211,122,220, 25,222,182,245,240,210, 51,218,179,130,
185,188,170,164,171,169,204, 62,107, 21, 61, 99, 56, 25,168, 16,199, 51,150, 28,
208,171,103,124,101,246,241,124, 37, 40,100, 42,111,205, 86, 94, 12,119,204,185,
 59, 44, 22,124,205, 25,110,240,234, 81,102,  9, 51, 97,  1, 20,202, 73,117,203,
146,178, 58, 33,149,217,201,175, 91,177,188, 58, 37,141, 59, 21,207,  6, 99, 67,
226, 38, 38,223,124, 60, 14,227,115,125, 38,174, 78,  0, 70,117, 42, 13,120,199,
109, 98,180,226,227, 58,215,133,  5,103, 99,225,217, 84, 92,160,  9,138,172,227,
173,239,150, 87,111,152,144, 86,153,109,213,188, 39,122,239,137, 68,239,189,247,
 68,239,189,247,222,123,239,189,247,222,155,228,123,239,157,200,137, 23, 97,240,
134,203,201, 72, 37,108, 76, 59,194,124, 97,198, 87,118, 42, 29,196, 88, 42,147,
179, 78,194,104,120,230, 30,119,120,197, 93, 53, 95,150,244, 43, 51,237,144,115,
207,185,177,104,195,242, 26, 38,181,144, 79, 33,204,133,162, 40,103, 57, 46,226,
 38,233,166, 59,235, 50, 25,  3,129,183,168,129,181, 66, 51, 35, 34, 34, 82,144,
 36,133, 52,  6,209, 12, 49,200, 65,233,164,121,130,144, 40, 79, 98, 24,194,224,
136, 17, 24, 66, 32, 65,  4,  9, 70,130,145, 64, 68, 98, 70, 68,134, 60,169,  1,
122,194, 61,137,232,172,140, 74,218,144,168, 62,234, 64, 89,114,124,100,100,134,
 18,198, 72,149,218, 51,239, 40, 35,235,212, 68,233,226, 93, 37,202, 82,255,  6,
121,225,127,118,189,166, 21,204, 64,172, 44,232,224,254, 71,118,132, 60,197,118,
160,114, 12,176,108,117, 10,160, 22, 67, 46, 79,194,169,130, 65,191,182, 94,233,
250, 66, 46,  1, 34,250, 78,201, 21,101, 25, 11, 68, 58,194,252,248,240,114,149,
 95, 74, 24,175,199,194, 82,176, 38, 74,115,150,133, 71, 84,224, 19,220,165,148,
237,254,125, 13,142,219, 35, 55,248,191,133, 54, 63,129,138,230,147,138,246,241,
 12, 95, 19,241,215,201,110,108, 44,141,221, 85,168, 17,107, 49,180,109,111,143,
102,211,166, 59,154,111,181,189,102,185, 95,119,150, 93,175, 59,150,209, 28, 38,
166,103, 96, 53,102, 10,244, 26,243,130,152,199,197, 46,251,143, 50,175, 74,186,
  1,116, 80, 57, 15,142,186,229, 70,200,206,172,202,219,167, 77,201,246,222,172,
 90, 58, 53,223, 87,228,106, 71,203,146,173, 16, 21,241,138, 12,175,229,109, 77,
 88,117,219, 12, 19,146, 95,235,250, 72,151,153,240,253, 17, 20,251,230, 64,125,
132, 52,240, 84,182,159, 13, 18, 73,177,208, 83,104,244,226,252,152,196,215,190,
131,  2,127,219,216, 63, 43, 66, 43,  8,136,188,105, 84,198,194,215,106,  8,242,
245, 47, 19,149,178,103, 80,217,123,119, 29,226,234, 20,151,  9,101, 25,153, 24,
112,102, 14, 35,240, 51, 86,100,227, 49, 32,161, 72,219,236, 85,142, 89, 39,176,
142,176, 33,101,235,173,215,126,167,167,224,116, 98, 16,158,135,100, 36,143,248,
  4, 34, 72, 89,201, 54,159,107,105,114,255,223,198, 82, 94,156,102,173,172, 67,
144,228,244, 31, 29, 73,152,188,128, 91,201,152,  8,119,117, 19,105,211,231, 79,
252,249, 97,219,  7,231,140,197, 46,134,208,157,  3,120,177, 28, 32,115, 35, 82,
178, 40,156, 83, 29,244, 30,249, 91,113, 25, 21, 14, 33,185, 61,228, 63,183, 20,
 96, 48, 34,  3, 28,168,227,189,  9,222, 34,164,124,  3,223, 84,216,240,111,187,
 22,206,246,  4,208,161, 43,  0,102, 94, 66, 48,235,162,236, 42,195,204,212,206,
237,173, 57,218,114, 78,153,183, 12, 54,226,252, 22,131,137,179, 16,137,120,155,
147, 45,162,190,228,116,  9,109,189, 72, 12, 35,114,150,165,172,201, 27, 52,241,
 89,160, 42,198, 52,  0,212, 29,150,252, 87,  1,120,223, 77, 77,169, 97, 88,131,
 59,103,109, 89,218, 98, 12,196, 94,111,205,189, 71,239,208,193,159,211,101,125,
 44, 99,123, 62, 86, 78,165, 56,250,  6,252, 98,222,237,248,239,127,116,148,195,
  4,196, 74, 68,119,  9,236,121,232,122,133, 92,  6,107,167,135,144,217,226, 90,
250, 77,180, 48,  4, 55,251, 90, 12, 19,104,247, 75, 41,248, 18,  5,134, 71, 27,
170,158,136, 13,184,200,137, 70,171, 11,252, 56,227,182, 47,165,112,247, 86,  4,
 45, 10, 79,122,254,189,  2,223, 69, 63,171,243, 73,174,114,184,127,219,172,  9,
240, 62,130,217,217,149,253,230,227,237,149,139,112,184, 21,114, 66, 88, 91,147,
206,139,  6,110, 76,125,151,123, 67,  8, 83,189, 92,  1,188,207, 72,225,180,203,
 32,249,109,208,182, 10,149, 79,250, 66, 81,  3,216, 48,200,  4,113,153,236, 31,
179,154, 12,153,188, 39,241,149,126,115,182,100, 88,239,141,  0,  9,147,178,232,
 86,  4,254,165,  5,143,193, 12, 68,226, 74, 46,200,185, 48,167,  8,185,217, 62,
  2,129,165, 48,154,141,  2,157, 84, 88, 73, 16,194, 78,250, 16, 11,152,147,193,
253,177, 98,121,164,167, 86,140,247,203,173,167,130, 22,163, 84,138,144,147,197,
 55,175,199,193,248,  5, 33,122,241, 33,  1, 42, 69,119,111,221,204,178, 38, 33,
250,188,111,178,115,  6,202,209, 68,239, 89, 17, 78, 28,205,117, 16,248, 66, 65,
 15,240, 10, 23, 27,231,144,132,209,227,169, 42,139,158,132,141,156,107, 22, 56,
202,143, 43, 98, 69, 18,133,183, 39,124,177,110,218,236,189,184,229,228,106,105,
 73,167, 13,255,107, 25,232,104, 34,193, 35,113,128,143, 75,150,140, 70,215,163,
 70,231,140,157, 52, 73,127, 48,121, 43,137,230,209,208, 59, 98,253,144,242,161,
243,104,171,210,202,213,  4,
} ;

// ../Source/Template/GB_add_template.c:
uint8_t GB_JITpackage_65 [1639] = {
 40,181, 47,253, 96,  9, 26,237, 50,  0,118,125,182, 40,192,146,117, 14,106,182,
112, 62,191, 53,181,167,215,237, 25,162,165, 19,187,149, 16, 12,163,199,247,180,
 98,147,102, 17, 90,159, 62,253,174,162, 32,200,  6, 51,168,  0,173,  0,167,  0,
167,125,203, 13, 94,202,231,234,  5,206,221,189,189, 52,180, 97,199,111,152,189,
226, 60,182,183,111, 93,251,173,244,150,235,246,202,132,214,166, 23,223,182,200,
182, 49,184,  2,171,229, 27,126,161,106, 73,  7, 19,138,132, 59,109,126,241, 21,
144,155,235, 75,121,203, 72,216, 82,214, 90, 35,201,184,116, 38, 27,139, 64,182,
236,185,189, 29, 71,123,238,121,241, 85,  2,229,128, 34, 97, 64, 56,160,156,210,
166, 87,182, 69,243,242, 73,252,168,187, 53,212,160, 87,159,168,145,221, 55,193,
137, 10, 91,112,126, 31,190, 29,126, 36,  0,136,235,193,122, 37, 11,162,197, 58,
 88,185, 83, 54, 58,143,192,118,118,223, 95,225, 59,189, 47,196, 23,219,182,137,
201,137, 27, 24, 72, 18,  3,131, 92, 39, 94,160,140,252,102,232,118,134,249,120,
 98,231, 99, 61,152,142,  6, 69, 60,200,223,168,195,108, 99, 81,210, 96, 54, 30,
140,  5,  6,202, 84,112,188,113, 45, 64,217, 19,117,103, 89, 67,215, 57,252,131,
144,124,241, 87,107,240, 90,  6,  9,126, 49,133,133,107,105,213, 28,190,245,165,
109, 93,175,228,171,248,203, 28,151,164, 16, 73, 58,152,151,179, 23, 72,249,130,
123,243, 22,235,149, 75,217, 50,248,245,169,142,170,167,120,174, 17,190,225,100,
 54, 23,152, 79,  6,  3,131,125, 50, 76,155,227, 77,160,194,141,178,111,161,173,
 80,182,129, 80,104, 67,161,118,  6,231,237,245, 66,203, 96,197, 30,  7,109, 59,
 89,107,207, 30,108,235, 97,231, 61,211,150,248, 39, 22, 88,175,198,162, 78,155,
 28,175, 40,148, 79,182,218, 93, 14,253, 78,238,171,218,153, 86,176,218, 87, 96,
189, 19,228,239,159,119,110,148, 63,222,110,143,178,143, 60, 90,191,177, 13,111,
251,  8,150,214,190,125,202, 71, 32, 36,151,162, 62,166, 87, 34,166, 83, 83,119,
150,117,221,117,233, 33,  0,191,166,115,109,185,174, 11,100, 93,120, 64,159,171,
133,224,181,157,139, 99, 97, 22,159,136, 81, 34, 34,159,192,138, 93,215,117, 93,
215,117, 29,132,126, 49,  6,105,251,  1,194,174,190, 54,151,148, 82, 74, 41,165,
148, 82, 74, 41,165,148, 82, 74,201,245, 70, 29,106,181,125,206, 62,154,161,203,
248,238, 86,215, 11, 67,204, 30,237,209,208,225, 84,156,110,241,106,205,216,122,
204,169,154, 11,137,223,243,194,146, 36, 73, 26, 10,140, 84,219,212,244, 83,242,
 99,  2,179,216,122,108, 89, 33,217,116,249,  8,194, 76, 60, 98, 60, 81, 99, 97,
 46, 27,151,149,148,217, 36,169, 42,126,213, 71,156, 34,118,137, 28,205,229, 12,
156, 22,203, 94,117,244, 28,160, 95,229, 96,154,184,225,100, 64,153, 15,167,227,
205, 80, 72, 95,161, 72,  1,218, 36,224,188,133,158, 70,169,131, 44, 98, 58,177,
237, 91, 90,123, 53, 11,141, 44,194,109,203,118,106, 79,120,197,154,190,121,220,
 97, 32,148, 30,132,106,211, 47, 26, 12,197,166, 59,203,186,206,250, 44,203,178,
164,148, 50,198, 24, 45,128,233, 32, 15,230,243,137,212, 41,183, 88,166, 83, 30,
 41, 58,216,229, 18,233, 68,107,144, 41,115, 84,214, 99, 10,178,199, 71,147,251,
108, 81,129,173,168, 97, 73, 66, 35, 36, 34,146,130, 36,169,180,  6, 33,  9, 33,
  8, 74,167,206, 60, 98,144, 32, 21,145, 24,  2,129,136, 38, 48, 68, 17,162, 72,
137, 68,  2, 33,145, 96,164, 48, 73,218, 41,151, 35, 84, 98,207,148, 52, 37,209,
  0,253,205,142, 63,195, 35, 93,  0, 51, 43, 15,252,224, 66, 43,205,229, 66,233,
 64,168,235,166,196,173,  7,228,122,132,120, 26,184, 91,210,180,215,229,  7,124,
 34,232,191,122, 16,100,215,130, 88, 35,248,187,210, 65,116,195,242,244,143,175,
120, 86, 46,162,  2, 31,160, 98,252, 29,155,188,151,196,109,  0,194, 90,201, 74,
156, 52,191,  7, 77, 31,121, 63,134, 21, 14,114, 84,226, 88, 85,235,248,208,177,
192,211,211, 66,123,132, 32,  4, 75, 65,208, 92,  7, 97,122,177, 52,162,139,166,
116, 33,202, 21,220,209,199,210,  0,196,186, 17, 34, 12, 90, 34,170,215,208, 82,
107,247, 96, 92,233,107,116, 28,149,249,172,142, 66, 12,226,239,130, 77,124,235,
 38, 29,221,235, 43,132, 28,217, 14,196, 82,145,231, 42,211,190, 54,184,176,136,
 81,121, 16,189,104,134,208,155,205,117, 97,134, 67,240,220,251,189,172, 19, 91,
210,151,198,155, 48,  2,212,208, 64, 37,237,  4, 87,138, 82,147, 55, 88,  6,  2,
 20, 67,106,212,148,155, 94, 27,100,237, 78,219, 45, 83, 47, 29,176,125,148, 16,
203,215,188,150,176,181,144, 30,222,  8, 37,219,110, 54,216,255, 23,190,168,126,
179,137,186,210, 70,131,208, 58, 13, 51, 64,176,228,218,117,196, 51,226,204, 99,
 24,113,173, 29,198, 15, 98,180,152,233,  2, 38, 50, 58,135,  4, 92,240, 11,155,
194, 35,121, 30, 67,194,114,237,230,248,212, 94,116,204,105,119,187,254,108,179,
227,226, 76,192, 46,113,244,173, 29, 14,101, 68, 18,103, 17, 65,231,144,131,143,
 46,180,234,198, 67,  7,154,156,251,245, 68,213,176, 64,110,212, 15,112,174, 26,
 88,178,208, 13,  5, 69,223,153,220, 29,181,221,240,212,169, 17, 80, 21,232,205,
 44,241,230, 62, 50, 85, 29,171,167,137, 23,204,170, 20, 93, 35,205,108, 14, 20,
102,138, 70,170,199, 15, 68,177,152, 47,165, 69,227,115,178,198, 87, 16,145,172,
113, 74, 63, 84, 74, 25,106, 27,169,173, 11, 55,205,127, 77,119,154, 40,211, 37,
113,  3,144,218,160, 61,243,245,169, 88,197, 88, 68,105,189, 39,243,199,135,188,
201,171,223, 12, 67,229, 61,218,246, 77,237, 83,219,147,234, 26, 54, 81,232,134,
  5,189,147, 64,116, 94,159, 56,210,104,186,180,209,243,127,157,253, 98,100, 82,
162,116,166,254, 57,104,141, 36, 71, 34, 88,239,136,231,106, 99, 39,111,189, 24,
214, 40, 89,156, 61, 96,  6, 55, 53,101,127, 10,219, 28,113,128,239, 40, 58,192,
149, 65,250, 32,187,220,174, 70,213,248,116,212, 22, 23,168,147,191,191,234,174,
 89, 40,251,230,222,165, 87, 27, 28,158,133,108, 74,148,204,148,191,  7,237,176,
 86,247,168, 50,215,243, 41,207, 36,134,238,164,196, 23,129, 28, 33, 41,  2,249,
136,128,  1,116,  7,153,140,145,151, 52,252,110,246,118, 33,210, 29, 16,223,197,
 49,121, 88,244, 48,142,170,237, 41,114,183,135, 43,112,214,198,191,216,244,113,
 81,168, 65,201, 14,217,213,149, 89, 30,129,102,194, 77,104,100, 38,112, 58, 78,
 23, 14, 76,111,197,193, 10, 80,147,144,173, 18, 97,211,  9, 32,217, 56,  8,  7,
252, 71,220, 52, 28,  6,114,119, 21,207,164, 73,254, 81,152, 97,213,186,117,232,
253,185,254,222,117, 17,200, 44,138,234,193,239,154,194,  4,153, 81, 28,203,120,
 87, 80,231,169, 69,134, 65, 59, 84,242,188,110,198,199,117,238, 80,119, 26,139,
 94,201,171, 36,149,123, 38,209, 36, 51,157,176, 69, 45, 86,140,201,139,144,129,
 48, 75,160,  6,152, 27,186,217, 29,  7, 57, 79,103,108,162, 17,117, 50, 12,128,
220,237, 20,192,132, 87,174,159, 96,  0, 30, 75,179, 33,128, 65, 73,219,159,243,
 41,  7,109,179,150, 75,184,251, 35, 72,211, 96, 77,210,217, 24,233, 41,218, 52,
221, 42, 51, 45,109,230,230,154,102,109, 57,111, 92, 31,142, 85,122, 88,157,
} ;

// ../Source/Template/GB_apply_bind1st_template.c:
uint8_t GB_JITpackage_66 [394] = {
 40,181, 47,253, 96, 63,  2,  5, 12,  0,102,151, 74, 33,  0,181,142,  1,202,145,
 96,116,103,248,176, 11, 75,176,143,166,171,186,195,164,118, 60,130,136, 70,112,
 23,243,255,127,175, 15, 33, 66,  0, 67,  0, 62,  0,135, 79, 77,126,210, 55, 84,
 33, 39, 88, 23,113,219,  3, 93,204,167,139, 53,161, 92,174, 95,132, 97,245, 87,
243,197,238, 11, 94,226,164, 83, 40,159,189, 63, 30, 94,103,216, 93,187, 12,178,
 59,219,218,176,225,203,201, 68, 93,206, 53,163,145, 23, 10,145, 42, 20,  2,215,
 52,190,193,188, 65, 47, 11,175, 79, 41, 56, 86,217, 96,178,235,127, 36,197,138,
112,160, 44,167,213,108,157,241,217,219,185, 27,219, 77, 66, 89,141,173,118, 39,
148,  6, 82, 33,108, 54,244, 89,109, 45,215,155,243, 92,203,187,206,250,132, 56,
 84,  7,106, 97,168,  2,141, 87,127, 60,203,255,113,106,119,215,173,165,237,192,
205,114,154,254,196, 82,111,213,126,220,206, 64, 32,254,231,117,222,217,174,171,
 95,205,207, 32,239, 21,228,169, 95, 14,228,239, 44,161,216,248, 82, 74,233,156,
 27,204,248,102,161,148,130,  7, 49,150, 98,169,250, 20, 94,242, 21, 10,118,145,
100, 48,171,187,218,249,148, 63,133,244, 19,  6,139,204,207,229,200, 83,204, 98,
 77, 46, 12, 98, 65,124, 55,246,180,207,153, 63,113,168, 60,205, 40,141,  0,228,
 59,247,241,164,193, 96,132, 57,119, 60, 63, 34, 32, 96,130, 49,166,243, 78,  8,
 80,184,246, 29,199,  1, 73,233,106, 63, 12,175, 84,235, 29,160, 98,206,177, 35,
131, 17,107, 91,164,182,102,194,189,217, 29,220,129,212,221,105, 38, 70,  4, 48,
 95,251,168,  8,220,111,208,112,204, 70,144,167, 53,230,147, 23,157, 98,189, 65,
147,134, 48, 19, 58,  2,172,161, 14, 56, 90, 20,117,110,
} ;

// ../Source/Template/GB_apply_bind2nd_template.c:
uint8_t GB_JITpackage_67 [392] = {
 40,181, 47,253, 96, 63,  2,245, 11,  0,134,151, 74, 33,  0,181,142,  1,166, 20,
101,120, 35,252,169, 19,156, 81,183,187,103,176, 51,198,100,132,156,  9,137, 81,
 99,243,255,127,175, 15, 33, 66,  0, 66,  0, 62,  0,213,103, 38, 79, 63, 28,178,
144, 19,234,195,109,119, 32,140, 57,189,212,201, 99,211,214,139, 44,238,231, 89,
125,185, 27,131,151, 56, 67, 90,229,117,119,199, 69,214, 23,119, 91, 78,131,238,
198,180, 92,105, 25,115,176,144,211,218, 98,143,200, 11,133, 56, 21, 10,  1,181,
 50,190, 65,189,193, 14, 19, 89,159, 82,240,171,178,193, 96,214,255, 72,138, 20,
161,154,238,150, 89, 93,191,240, 46,238,224,157,175, 38,153,238,151,111,134, 39,
147,  6, 82, 33,104, 55,228,221,239, 90,254,237,205,131, 45,231,184,122,122,168,
168,106, 82, 24,168,103,156,186,227, 90,254,143, 51,195,219,238, 79, 94, 14,212,
238,150,125,159, 89,126,154,189,222,182, 49, 16,152,239,117,157,115,151,227,172,
103,245, 53,168,187,  5,121,172,167,  3,250, 27, 67, 36,118,198,115,134, 82, 10,
194,127,147, 49, 38,170, 53, 49,150, 98,137, 58,165, 78, 67, 75,190, 66,185, 46,
146,204,117, 63,206,118, 78,245,169,168,158, 98,174,200,252, 96, 43, 95, 47, 75,
157, 88, 23,228,130, 25,239,220,101,159, 83,159,114,170,124,197, 30,143,  8, 64,
190,131, 31, 79, 26, 12, 70,217,190,113, 29, 33, 32,112,  2, 25, 91,121, 14,217,
236,130,195,128,164,187,218, 14,195, 95,170, 22,  7,168,124,231,208,145, 33,136,
181, 45,178, 90, 51,225,222,236, 14,237, 80,134,121, 34,219,123,198,195, 24, 46,
236, 81, 10,147,  8,249,138, 33, 79,107,204, 39, 47, 58,197,122,131, 38, 25,194,
 76,232,  8,176,134, 58,224,104, 81,180,184,  1,
} ;

// ../Source/Template/GB_apply_unop_ijp.c:
uint8_t GB_JITpackage_68 [743] = {
 40,181, 47,253, 96, 68,  8,237, 22,  0,118, 35,106, 32,224, 26,231,144,114,132,
156, 16,101, 12, 86,110,108,163, 35,248,168,179, 79,154,173, 57,  2,155,140,146,
132, 25, 82, 98, 76,  8,100,  0, 92,  0, 96,  0,180,189, 12,161, 49,237,110,106,
  8,160, 10,167,224,181,234, 54,238,206,113,  6, 75,179,243, 48,220, 30, 21,137,
 67,130,208, 64, 28, 18,215,186,236, 17, 79,149,172,188,176,189,  5,230,138,154,
159, 71,207,166,153,128, 86,222,139,163,241,149,214,211,121,166, 60,152,233, 37,
 58, 61,218,182,189, 71,109,203,110,235, 35,167,220, 97, 77,147,179,149,166,184,
 86,104,173,228, 38,151, 27, 12, 24,193, 96,  8,143,188,187, 25,226,141,203,248,
206,239,244,220,205,155,113, 95,193, 51,183, 96,100, 58,159, 49,253,143, 97, 46,
 12, 43,220, 14, 67,217,189,193,124,186, 29, 85,239,119,175,167,173, 29, 73, 66,
160, 60, 90,137,202,147,244,190,242,148,123, 84, 78, 74,197,143,120,126,251,151,
249, 67, 18, 42,101,122,147, 78,101,247, 13, 59, 20, 18,132,  6, 59,105,183, 59,
110,207,111,230,142,232,200, 30, 31,137, 34,207,242,167, 91, 87,175,244,184,171,
119, 42,249, 55,  7,  3,200,227,135, 71, 50, 68,236, 38, 74,210,150,151,117,152,
242, 26,236,240, 53,202,109, 25,246,100, 95, 48,115,168, 20,253,173,223,195, 43,
237, 45,170, 94,162, 74,242,218,128, 55,243,185, 80,210, 58,243,196,213, 62,114,
 22,229,143, 39, 46,184, 50, 99,139, 79, 88,102, 58,144,225,131, 59, 53,183,  5,
 24,246,181, 71, 83,  1, 12,123, 97, 47,155,157,179,225, 66, 26, 14,103, 27, 89,
 81,167,232,204,154,102, 31, 73,147,201,  5,144,253,155,135,220,254,113,171,153,
 16,131,168,209, 14, 85,210,114, 98,140, 49,122,180, 31,185,205,114,184,143,229,
242,120,  4, 55, 14, 51,185,152,240,  4,243, 91,164,211,122,175,179,188,109,235,
155,244,154,207,210,254,213,103,143,206,239,144,159,254,184,166,  5,128,128,168,
113,181, 66,166, 70, 68,130,  4, 73, 10,147, 66, 99, 48, 66,130, 16,179,236,226,
192, 76,136,243, 16, 18, 64, 67,232, 36, 94,137, 68,242,199,  7, 61, 52,206,188,
214,118,135,196,127, 85,251,172,225, 91, 29,184,165, 73,137,180,254, 76, 84,208,
144, 88,166,218,236,226,113,139, 14, 27,151, 73,192,134,198, 90, 11, 69, 10, 82,
  1,137,121, 13,143, 13,223,171,143, 36, 15,219,136,201,249,126, 92,166,183,150,
 73,198, 78,145, 74,217,146,114,170,109, 26,166, 17,123,253, 60, 70, 32,  3, 29,
172, 50,174, 48, 67, 97,219, 78, 14,136,  1,175, 82,250,144, 11, 12, 99,147, 66,
204, 96,104, 27,237, 22, 96, 10,234, 24, 49,110,185,176,218, 24, 40, 64,  3,211,
 78,200,136, 59,236,183,162,241,138,163,118, 84, 51, 82,129,173,166,220,239, 31,
184,142, 55, 36, 17, 44,  9, 17, 68, 37,128, 50, 98,224,191,138, 49,177,172,206,
 17, 70,128, 73,146,144,180, 67, 70,  0,206,102,217,130, 58, 64, 53,131,229,186,
 52,186, 75, 36,118,249,114,243,174,196,177,132,204,182,137,183,247,142,227,132,
 81,241,123,121,  2,236, 86,130,114,228, 38, 75,159,130,  2, 27,133,150,151,140,
  8, 23,143, 88,207,  9,111,128, 14,133, 65,165, 46,205, 63,214,  9,165,  0,165,
150,254, 50,238, 84,143, 36, 54,210,166,  9,253,204, 52, 30,104,240, 93,144,174,
212,113,155,
} ;

// ../Source/Template/GB_apply_unop_ip.c:
uint8_t GB_JITpackage_69 [372] = {
 40,181, 47,253, 96,136,  2, 85, 11,  0,  6,151, 72, 33,  0,181,115,106,  8,156,
239, 98,247,240,113,109,199,218, 70,187, 99,124, 64, 81,255,  6,  0,172,160, 66,
225,164,255,223,254, 67,  9, 63,  0, 64,  0, 60,  0,144, 91,243, 34, 46,127, 94,
197,156,186,204,201,197, 93, 10, 70, 22,141, 65,122, 47,157,107,120,137,245,246,
187,168,179,223, 61,182,106,182,111,107,167,166, 41,127,191, 59,254,248,226, 86,
236,126, 54,196, 68,221,189, 20,187, 34, 31, 12, 98, 53, 24,  4, 90,119, 29, 47,
252,188, 59,183, 52,251,140,  4,203, 80, 53,151,209, 59,191,  0,187,110, 53,219,
214, 36, 85, 99,219, 89,157, 84, 25, 72,197,210, 26,  4, 54,110,203,113,230, 60,
213,242,174,155,167, 14,  6,130,161, 82, 20,  8,134, 79,153, 60,133, 43,136,  6,
 25,203,238, 66,173,185, 12,127,178,216,148, 88,163, 13,114, 25,243, 66,123,240,
219,222,117,215, 81,144,222, 95,239, 59,245, 60, 20,188,  1,198,239, 51,134, 72,
100, 91, 67,143,255,127,140,164, 24,173,199,135, 79,225,250,249, 77,242, 91,  1,
 49,110,173,217, 48, 16, 99, 41,150,166, 43, 95,161, 96,154, 73,165, 50,177, 43,
 50, 77, 31,170,202,115,238,166, 67, 91,179,253,178, 79,211, 61,213,153,242, 19,
187,174,  8, 64,126,171,143, 39,  9,  4, 35, 75,223,248, 61,227,132, 59,126,101,
 86, 51, 13, 25,  0, 69,113,207,171, 92,137,150, 77,177,100, 32,118,  3, 46, 38,
 59, 92, 38, 67, 13,214, 18, 75,245,192,149,105, 11, 46,174,204,200, 84,120,237,
159,136, 44, 51,233,161, 48,  3,217,120,232,101, 46, 98,205, 59, 54,205, 31,194,
 76,209,161,176, 53,152, 39, 12, 10, 21,  5, 67,
} ;

// ../Source/Template/GB_apply_unop_template.c:
uint8_t GB_JITpackage_70 [420] = {
 40,181, 47,253, 96, 45,  3,213, 12,  0,  6, 25, 79, 34,  0,213, 22,  3,106,132,
109, 87, 58,203,  2,207,174,120,108,139,249, 81, 66,108,  6,232, 64, 66,  1,239,
157, 96, 46,253,175,255, 80,  2, 71,  0, 70,  0, 67,  0,244, 87,  2, 97, 64, 96,
140,131,  1,113, 11,172,126,233, 43,170,145, 23,232, 73,226, 46,201,155,249,133,
161, 29, 68,204,213,156, 52,172, 54,107,198,216,125, 79, 12,101,209, 42,151,223,
206,189,  1, 22,236,174, 99, 38,237,254,114,137,207,143, 52,230, 92, 63,200,228,
 89, 70, 97, 89, 22,249,251, 83, 44, 54,190,248,126, 35, 74, 41,213,190,207,242,
 27,113,183,170,111, 31,113,131, 75, 60, 78,230,227,254, 83, 38,202, 80, 64, 96,
 86,  4,107,166,111,152,246,130,238,198, 54,164, 96, 86, 99, 11,222, 14,219, 68,
188, 66,104, 69,166,213,246,114,189,197,208,189,124, 28,  3, 35,238, 89,118,202,
 68, 32,148,112,189,227,249,218, 13,223,158, 43, 11,188,187,110, 93,217,241, 12,
173,  8,234, 91,184,210, 97,181,166,184, 63,242,196, 55, 75,208, 71, 59,142,213,
172,249,153, 44, 95,201, 80, 53,115,224,212, 77, 86,215,105, 42,223,182,127,104,
117, 80, 20,117,210,110, 79,124, 55, 46,193,127, 40,128,123,185,241,125, 40, 32,
101,144,180,228, 73, 99,253,231,129,209,107, 86,151, 89,227,106,238,151,248,151,
213, 21,124,174,228,190, 31,171, 71, 75,157,180, 91,249, 87,174,238, 89, 62, 78,
231,121,180,250,183,123,114,231,  1, 35, 32, 80,130, 65,202,172, 60,165,196,241,
 25,108,243,203, 23,184,  9, 83,208, 13, 75, 93,132, 55,103,  0, 24,132,  4, 27,
 35, 43,203, 15,129,249,  5, 98,122, 40,201,149, 88, 28,231,128, 85,108,173,  2,
 88,148,  4, 51, 50, 97,153, 29,155, 26,190,211,238, 20,154,129,  8,249, 58, 16,
132,104, 42, 73,129, 30, 52, 61,207, 76,108,227, 95, 45,124, 23, 90, 20,189,110,

} ;

// ../Source/Template/GB_assert_kernels.h:
uint8_t GB_JITpackage_71 [986] = {
 40,181, 47,253, 96, 43, 14,133, 30,  0, 54,172,134, 40,208,206,108, 14,116,121,
 77,128,239,142, 86,102, 45,172,211,208,220,132,208, 82,163,158, 68,175, 41,230,
 96, 97,122, 44,178, 78,121,145,171, 25,120,225,124,  1,122,  0,124,  0,119,  0,
231, 79,223,211,176, 94,187, 26,206,221,109,218, 28,207,119,104,119, 58, 33,135,
 39,100,224,128, 52,184,147, 17,164, 30,169,220, 92, 95,202,243,106,176,165, 44,
 27,107,108, 42,140, 99, 50, 69,101,203,217,237,237, 58,157,221,243,168, 79,  8,
 16,  3, 72, 35,225,192,  0,114, 73, 70,159,108, 83,196,234, 14,234, 22,221,253,
 62,173,125,202, 80,152,164,  3, 99,165, 68,216,214,  8,102,248,118,152,129, 44,
253,250,145,206, 97, 61,166,149, 61,219,173,108,109,220, 36,148, 63, 30, 80,227,
241,  8, 23,134,105, 44, 91,118,217,104,191,192,225,178,113, 61,233,100,143, 19,
109,179,245, 56, 35, 67, 65,225,146,229,194,166,  0, 26, 49,  7,188,  7,124,219,
 44,236, 90,216,182,  7, 60, 50,217,235,200, 61, 32, 58,166,162,169, 36,128,232,
 92, 95, 68, 92,218, 68, 28,214,123,219,223,252,241,248,127,  8,162,104, 36, 86,
197,181,150, 89,153, 12,  5, 41,252, 81,112,233, 81,193,227, 44,  0,105,217, 69,
 66,157,227, 73, 67,  1, 40, 34, 57,237,253,243, 85,238, 22,222,149, 92,123,254,
214,143, 19,207, 54,124, 92,195, 27,114,175, 31,247,201,181,195,  9,174,125,182,
 81, 94,144, 61,119, 92,202,181,134,210,134,244,243,254,209,223,144,115,238,187,
125,253,186,130,149, 41,190,203,177,247,105, 70,158,183,240,188, 72,249,210,190,
237,223,200,243,147,183,158, 26, 63,151,172,234, 50,217, 42, 42, 58, 87,102,120,
100, 66,  6,172,204, 98,160, 24, 38,218,133,226, 32,136,157,188, 95,135,160,114,
167,211,245,254,126,244,223,188, 38, 73, 19,209, 49, 48, 46,129,210,196,  4, 70,
 25,235,194, 48,149,208,140, 40, 34, 42,178, 17,253, 62,145,  6,252, 34,169,130,
 19,127, 34,157,110,132,185,178, 73,198,170, 40,140,154,100, 15,155, 43,211,168,
 10,197,114,101, 87,165,186, 46,150, 75, 69,155, 88,152,149,209,104, 54, 86,101,
185, 48, 23,136,140,178, 92, 18, 11,  3,161, 57, 60, 50,114, 60, 47, 74,218,175,
145, 65, 48, 74, 26,114, 44,105,219, 79, 52,172, 92, 35,219, 43, 89,130,243, 93,
 54,215,146, 65,235,145,220, 73,131, 75,243,195,245,204,249,244,194,175,226,151,
242,135,111,188,118,234,100,119, 21,180,163,128,185,168,225,153, 66,104,104,100,
164,160, 32, 41,100, 88,  3, 48,134,  8, 72, 29,209, 57,114,152, 48,  2, 34, 92,
133, 56,132,  9,  8, 33, 70,128,168, 48,  5, 34,161, 84, 32,129,146,212,  3,211,
178, 97,205,  2,100, 18,253, 45,113,126, 28, 25,138,127,175, 49, 93,216,113,254,
172, 31, 54,136,193,206, 16,186,111,114,178,247,201,212,167,163,165, 33,231,164,
 42,219, 67,221,121,250,176,215, 28, 49, 36, 75, 80, 37,204,238,146,232,  6,170,
 96,  8, 80,219,139,232, 92, 26, 65, 65,130,111,197, 61,240,101,135,116,195, 42,
251,199,134, 34, 14,213,139, 88, 31, 63,240,224,197,171, 16,111,107,253,117,143,
131, 92, 60, 44,221,215, 87,  3,  8,160, 96,  0, 83,172,236, 22, 23,230,110, 67,
180,177,249,138, 57,247,147, 31, 29, 21,163, 12,105,229,101,194,192,174, 86,126,
139, 38,202,161, 46,251,106,149,230, 73,214,118,109, 58,144,152,142,168,210,138,
121,196,204,226, 30,212,209,205, 92, 99,143,229,154, 42,220, 60,116, 40, 62, 84,
 38, 15,  5,120,181,240, 14, 33,231, 73, 67,185,  9,130,104,227,195,126,136,220,
227,148,108, 79,226,181,138,104,209,181, 20, 45,253, 69,218, 87,156, 17,200, 89,
188,101,182,148,198,152,143,110,240,102,151,  6,  6,181, 87, 89,217, 67,183,132,
252,147, 52, 48,  7, 37,202,228,161, 23, 45,177,212,192, 53,217,136,215, 33, 61,
157,184,252,  9, 84, 89,196,154,223, 16,159, 93, 82,223, 92,139,135, 11,169,205,
226,108,183,  2, 20,168,152, 78,206,  9, 98, 44,107,202,224,164,125,125, 20,216,
 71, 72,173,  9,176, 86, 81,102,211,120,  7, 50,188,  2,235,  8, 10, 15, 25, 21,
  5, 52,  1,141,167,155,223,139,246, 71,121,166,131, 21,152,141,176,241,214, 18,
159, 86,253,120, 48, 43,  2, 64,124, 60, 66, 90,202,212, 86,183,187,  7,170, 46,
 96,197,135,137,211,254,100,108, 97,210, 68, 85,102, 10,227,143,236, 55, 56,158,
 42,242,215, 29,104,  2,
} ;

// ../Source/Template/GB_atomics.h:
uint8_t GB_JITpackage_72 [3750] = {
 40,181, 47,253, 96,197, 72,229,116,  0, 10,118,200, 20, 44,192,176,138, 14,116,
 48,130, 36,129,100, 55,175,211,176,114,187,  8,135, 61,214,154,190,166, 58, 56,
246,197,253,159,231,246,255,201,142, 72, 25,246, 77, 81, 20, 13, 81,116, 32, 57,
  1, 76,  1, 65,  1,219, 89,184,214,132,125,117, 88,182,  1, 30, 30, 80,154, 10,
 12, 70,134,227, 82,173,131, 21,  7,184,162,231, 21,187,218, 78,188,182, 63,253,
105,177,108,103,159, 85, 25,214,114, 66,185,250,146,235, 22,178,254, 38,230,246,
122, 94,230,219,249,109,187, 99,131,156,209, 58,123, 98, 30,112,205,248,233,214,
 57,245,228,123,163, 52,172,103, 52,153, 38, 83,129, 78,118,108, 32, 49,225, 54,
194,116,206,233,241,121, 48, 90,141, 45, 15,148,238,137, 14,242,132,124,222, 72,
 19, 74,194,152,145, 93,246,154,124,154, 57, 75,200,175,162,199,110,140, 17, 73,
166,  9,255,142, 24,150,121,190, 90,159,189,143,177, 43,182,148, 72, 42, 18,163,
201,184, 36,212,236,181,158, 55,247,202,220,117,125, 45,142,238,173,182,177,116,
206,222,215,151, 29, 51, 50, 77, 82,  3,  3, 46,150,217,199, 85, 58, 91,159,144,
179,117, 49, 76,243,179, 73,183,158,229, 67,100,146,144,214,106,138, 93,210,210,
203, 21, 63, 92,135,145,214,225, 54,190,144, 40, 48,208,152,220,118,122,125, 55,
210,223,226,240, 70,190,119,201,104, 66, 34, 34, 33, 21,144, 68, 36,242,209,160,
140,156, 59,202, 32,167, 75,126,172,143, 23,115,100,164,185, 92, 44,176, 48,109,
  7,150,245, 86, 76,179,207,153,230, 65,123,177,152,217,177, 74,135,145,159, 33,
 87,235,210, 98, 77,222,248,138,175,212,  2,  7,  9,129, 60, 72, 16, 72,158, 73,
112, 33, 87,108,211, 53,121,139, 14,  2,177, 56,246,111, 89,118, 53, 29,243,237,
 67, 76,219,103,171, 53,252, 60,205,158,118,220, 66, 14, 63,109,204,125, 31,118,
177,103,  4, 49,207,141,159,  1, 72,165,215, 19, 53, 50,194,216,184,184, 93,200,
132, 66, 81, 42, 29, 21, 59,248,186,206,145, 63,141, 47,137, 72, 42,  6, 12, 72,
 58,122, 62,155, 33,194,180, 72,222, 62,160,188, 96, 56,184,108,104, 88,112, 92,
 24,104, 68,160, 44,153,153, 15, 15,143, 44, 16,153,160, 72,144, 97,161,145,161,
 18,202,231,220,  6,217,211, 69, 26,140, 71, 71,227,214, 56,123,169,107,250,229,
 34,147, 89,144,171,251, 98,124, 76, 40, 25, 81, 36, 25, 85,146, 34, 59, 32,137,
  9,141,  6, 17, 50,234,224,200,192,100, 68,178,173, 57,249, 98, 31,233, 31,103,
 27,126, 48,114,199, 17,198, 43, 55, 50, 23,209, 70,134,  2,131,140,203,133,  5,
  6, 38,194,133,  6,135,229,234,232, 17,  0,  0, 88,204,167, 14,106, 70, 18, 36,
 72,  4,  8,146, 67, 98, 72,  1,  9, 73, 41, 33,210,226, 29,215, 37, 73,146, 58,
 34, 34, 34, 34, 40,176,  8,121,147, 29, 85,204,133, 49,119,  3,181, 37,140,236,
190,141,117,236, 38,  3,191,232,179,104, 61, 79,200,156,182,163,214, 70,151, 25,
 77,152,182,104,159,219,147,145,211,237,237,181, 60, 23, 42,  4,176,184, 39,190,
167, 25, 61, 90,230, 98, 63,228,116,133,114, 61,211,215, 82,211,122,246,112,234,
197,209,198,162,125, 27,118,143, 88,118,175, 87,238,251,188, 75, 31,172, 67, 61,
 33,107,115, 36,  8, 22, 25, 24,140,140, 40, 92, 62,227, 75, 14,170,180,173,146,
148,242, 81, 49, 45,140,235,114, 55,239,217, 21, 61, 34,194,247,179,  8, 69, 34,
181,142, 95, 20,158,229,142,130, 93,141,197, 45,  7,242,110, 50,254, 39,236,236,
 49,112,175,237,  6, 89,122,143, 88,103, 54, 50, 20,135, 92,103,207,243,166,179,
 82,169, 84,178,195,129,199,  3, 18,  0,229,  3, 34,247,241,235,139, 29,  8,154,
 80, 44,228,  3,154, 80,168, 10, 13,  6,181, 97,113,129,169,160, 44,159,207,232,
162,199,218,209,201,179,117,122, 97,215,254,107,213,189,185, 23,191,  4, 19, 46,
103, 35,  2,135,198,165, 66,183,163, 36,173, 55,118,200,141, 97,173,215, 74,183,
 27,238,230,235,156,238, 59,228,237,  6,179, 42, 33, 58,  3,177, 28,168, 86,235,
176,192, 80,159, 86,200, 27,  0,254, 16, 17,193,225,169,202, 83, 19, 74,135, 60,
 64,113,128, 98, 67,228,137, 47, 90,191, 87,103,177,202, 73,211, 31,238,149,165,
195, 93,207,111,171,229,154,238, 89,216,219,137,255,180,197, 39,105,198,135,156,
191,156,214,207,142,220,152, 59,141, 47,225,131,  6,148,  6, 70,166,138,222,219,
113,150,103,175,226,215,186,235,143,135,217,152,192,224, 98,177, 65,169, 80, 72,
 14,100,247,204,226,200,116,223,214, 84,218,183, 81,110,237, 72,110, 51,180,248,
122, 31, 50,164,193,143, 67, 36, 38, 60,144, 73, 65, 16,149,192,154,220, 59,130,
 92,151,189,  6, 61,123, 88,163, 40, 24,115, 66,129, 82, 98,130, 34,161, 72, 34,
 40, 43, 80, 38,244,128, 42,148,133,131,140,203,131, 10, 10, 22, 23,  8,  4,  1,
 69,153,219,182,189, 14,  2,202,247,102,223,118, 78,223,181, 69,168,175,219,159,
206,159,150,140,  8,159, 77,239,230,202,160,195, 94,206,174,131,251, 16,102,216,
228,154,241, 93,212,219, 89, 79,124,240,120, 10,153,195,237,218,124, 31,  0,128,
124,204,132,210, 27,173,107,211,252, 60,152,121, 15,183,183,170,216, 45, 42, 62,
207, 79,153, 47,246,244,135,119,189, 53, 57,228,127,156, 45,144, 42,  2,145,  8,
  5, 89,200, 15, 70,  8,167,227,148, 65,206,228,202,157,216, 88,190,222,223, 75,
127, 95,239, 87,190, 29,243,157, 25,114,216, 93,115,192,128,230, 76,195,182, 75,
219,137, 27,125, 68, 40, 57, 27, 63,252,105,213,129,130, 34, 15, 60,114, 59,123,
172, 21,135,166,130,130, 96,161,161,162, 94,215,241,218,139,130,188, 89,127,  6,
 93, 79,196,146,211,226,100,177,179, 25, 53,251,186,200,237,183,197, 58,246,179,
  8,129,128,166,125,155, 44,186,215,248, 42,137,137,140, 34,201, 50,138, 54,176,
245,105,243,156, 80,178,227,  7, 82,207, 83,211,149, 41, 42,122,141, 51,106,141,
211,184,226,182,152, 75,113, 95, 22, 61,209, 58, 76,230,164,141, 31,198,255,178,
 43, 59,184,  3,132, 15,168,211,217,145,148,101, 16,213,200,136,164, 32, 73, 50,
 28,195,128, 24, 20, 22,143,209,167,115, 89, 89,208, 15,195,128,210,113,180, 28,
154,194, 16, 12,  1, 17, 12, 49,134, 16, 72,  8, 49,  4, 17,161, 17,136, 64,136,
208, 12, 25,231, 36, 93, 71, 29,192, 53,105,164,217, 84,190,249,249,254,151,190,
 60, 86,227,217, 98,  3,215,126,243,131, 95,182,190, 82, 92,179,248,127,232,158,
 66,220,121,175,248,197,173,  9,189,  8,  0,175, 11, 38, 16, 67, 44, 36, 67,195,
171, 79,147, 27,216,184, 57,188,121,130,199,103,209,233, 81, 41,230, 43, 68,252,
 84,100, 99,249, 41, 84, 59,103,240,140, 95,125, 66, 13, 27,199,  7, 89,150,183,
  3, 12,207,136,189, 64, 39, 90, 29,186,246,250, 18,  1, 42,214, 63, 40,168, 84,
137,114, 89,220, 51,161, 71,159,187,202, 55,143, 89,162,245,109,213,142,239,114,
 19,219,  7, 24,173, 68,224,213, 94,113,  3, 94,222,158, 51,125,192,105, 53,143,
 12,212, 21,152, 21,232,245,221, 62, 29,  0,185,164,101,117,  0,151,255, 24, 73,
132, 96,181,160,202,221, 33,167, 62,143,248,162,184,174, 84,251, 41, 84, 45, 11,
 51,244,134,195,239,207,173,101,150,117,  2,170, 85, 26, 11, 80,176, 20,136,103,
 60, 97, 69,208, 14,  4,198,169, 57, 82,227,102,189,235, 73,204, 44, 20,102,246,
116, 61,106,195,216, 30,  2,158, 73,134,  5,237, 25, 70,168,104,112, 72,107, 31,
  8,218,180,153,221,  8,128,166,  8, 37,134, 57, 99,129,205,206, 27, 90,105,116,
  2,208,138, 71,139, 85,102,  6,229,134,198,237,182, 82, 59,197,151, 69,191,131,
145,177,140,244,  1, 34, 58,163,133, 21,153, 99,165,175,248, 13,243, 97,244,252,
158,188, 75,243,103,114, 50,218, 89, 31,115,164, 62,250,152, 54,148,182, 18, 35,
227,130,239,200,198,199,  1,255,216, 44,206,181,207,113, 40,117,108, 50,113,185,
173,238,204,131,164,125,166,253,249, 44, 87, 16,119, 13,106,110,149, 71,226,177,
 95, 72,232,188,175,240,112, 16,106,241, 15, 20,203, 73,132,210, 16,171,229,106,
  9, 20,104, 11,  5,192,144, 49, 73, 59,113,128,220,124, 10,112,146, 99, 57,120,
 60, 51,205,234,104,112,204, 90,135, 10,194,232,227, 61,224, 29,151,207, 29,148,
196,108,159,188, 66, 74,132,222,218,214,202,138, 77,230, 19,177, 83, 31,116,165,
182,168,121,155,209,239, 63,212,235,239,126,102, 78, 18,  4,111,  4,105, 33, 81,
 42, 18,252,228, 83, 34,244,214,  6,140,234, 81,160,116, 98,165,191,155,125,  7,
 31,  0, 97,158,241,  4,226, 75,108,112,183, 63, 61,184,103,111,121, 85,105, 53,
236,132, 88,200,141,118,221,173, 98, 70,208,119,172,246,255,184, 34,  9, 19,113,
 96,195,163, 43, 99,107,127,134, 64, 80, 18,215, 62,204, 29, 16, 29,190,240,168,
168, 56,200,139, 24,149,203,219,193,252, 72, 78,171, 46, 84,205,154,236,176, 37,
 51, 86, 23, 56,170,166, 35, 68, 17,104,233,140,136,  9,136,116,146,  6, 51, 76,
  9,102, 42,253,  1, 85, 93, 16,217,157, 97,233,195,  7, 91,246,113,209, 15,236,
224, 43, 60,162,242,128,133,232,224, 63,222,227, 22, 12,138,138,173, 67,174,111,
205,193,111, 77,133,  3,177,128,194, 12,158,139, 24,146, 48,  1,218,120,110, 50,
134, 73,111, 69,160, 15,252,237,240,177,169, 36, 45, 99, 56, 24,233,100,110,225,
  7,  0,171, 89, 18, 44,107,195,141,167, 66, 70, 65, 97,195, 96,225, 65, 94, 94,
102,204, 33, 24, 12, 89,113,116,235,179,142, 42,215,255, 43, 60,173,117, 89, 86,
225,107,173,142,142, 15,131, 31, 45,144,162,106, 78,194, 51,202,184,224, 31, 78,
175,102,236,164,  7, 59, 10, 75,140,178,141, 68,235, 10,104, 93, 20,253, 46,245,
 30,224,233,251, 66,205,159,110,200,  6,  2,234,237,247,100, 83,237,  5,204,200,
  9,141, 35,216,  4,225, 60,  0, 28,147, 17,246,190, 55,124,164,104,178,253, 70,
174, 45,187, 34,217,124, 19,213,197, 32,186,177,196,174, 58, 97, 56, 14,145, 72,
126,135,119, 68, 62,158, 77,232,104,190,191, 30,211,155,179, 85,192,109,234,128,
130, 66, 68, 47, 38,245,150,144,222,255,218,187,111,198,106,163, 35,128,233, 43,
 13,210, 98,129, 62,176,229,202, 77, 75,166, 43,105, 45,154,207,166, 52,218,108,
 66, 86, 84, 88,137,170,  5,110,238, 34,101,232,230,131,142, 33,111,228, 20,221,
229,195,106,206, 75,128, 96, 49,216,  0,180, 18,147,  7, 14, 24, 34,180, 99,131,
 77,222,136,163, 34,119,134,152, 20,111,127,124,118,235,168, 55,167,  4,100,119,
173,110,168,  8, 72, 39,183,182,160, 42,141,136,184,251, 16, 18, 83, 34,105,248,
145,  7,164,184,205, 26,219,193, 57,160,179, 93,184, 84,158, 21,190, 48, 22,107,
219,  4,178, 83,226,  8,  5,205,235, 20,142, 21, 44,182, 49,193, 12, 36,130,  1,
184, 15,253, 82, 52,102,129, 98,227,193,123, 14, 95,250,184, 54,195,153, 33,134,
225,173, 82,169,205, 84,182,147,101,184,226, 49,221, 62, 86, 79,181, 19,  5, 42,
 32, 35, 66, 52, 56,149,168,168,119,186,236,125,170,248,249, 52, 37,200,159, 16,
 26, 82,182, 75,234, 34,246,127, 44, 29,  4, 28,137,212,124,149,216, 53, 45,124,
 12,130,195,114, 76,224, 60,162,242,183,101, 92, 66,  0, 93,171,218,116,158,131,
 16,146,132,198, 19,144,220, 67,211,137,136,183,192,204,224, 16,248,102,159,192,
 36,152, 88, 68,208, 35, 50,217, 65,194,227,  1, 52,199,178, 25, 22, 81,207, 21,
128,220,222,195,135, 97, 85,154,132,107,233,218, 95, 72, 73,129,161,212, 66, 41,
213,215,200, 76,  3, 71, 81,  2,189, 44,244,120,244,163, 40,117, 65,162,245,153,
199, 84,114, 29, 51, 66,191, 58,173,102,133,115, 28, 86,236,142,133,173,179,123,
222, 13, 65,231, 32,248,145,242,234, 80,190, 49,148,140,248,142, 44, 35, 92, 68,
 81, 86,218,200,144,242, 53,151, 50,244,105,138,187, 15,141,236,134, 84, 20,159,
225,241,189, 57,  6, 41, 92, 39, 23, 39,204,205, 47,188,130,173, 38,169,233,  4,
133,145,217, 79,251,188,216,142,139, 98,214,186,234, 13,112,184,248,141,228,105,
138,138, 97,  3, 84,150,  9,123, 57,211,144,121,132, 74, 62,209,150,109,102,216,
253,222,177,236,  8,114,251, 67,133,198, 30,177, 44,125, 47, 99,120,209,153,163,
 16, 26,229, 78, 37, 88, 56, 78,114,168,216,114, 59,139, 42,150, 63, 46,133,204,
123,  8,168,237,212,120,210,138,221,217,151, 88, 51,169, 98,116,103,184, 26, 62,
114,159,222, 39, 21, 74,217,150,231, 36,183,184,135, 11, 63,204,177,108,106,199,
124, 63, 85, 28,223,217,129,107,186, 58, 88,136, 22, 34,254,133, 44,211, 93, 74,
102,208, 48,189, 62,219, 95,190,198, 95,242,169, 82,205,245,209, 86,  0,166,  3,
122,  2, 24,136, 19, 21, 82, 98,228,204, 15, 10,187,103,141,253,113,203,129,221,
254,191,132,179,145,247,  1, 15,117, 48,176,181,208,  1,205,133, 70,203,  1, 47,
182, 69,162,125,204, 39,104,172,216,131,115,168, 54, 79,162,122,218,106, 74,208,
 37,102,177, 50,119,  8,173,133, 21,145, 39,253,  0,207,137,119, 85,112,109,  7,
247, 74, 18, 71,211,246,185,192,247,138,142, 18, 52,114, 67, 90, 22,  3,  9, 98,
163, 48, 83,118,124, 73,217, 12,205, 64,244,  0, 60,251,233, 29,157,127,  0,121,
187,250,  0,229,112,159,102,130,155,244,221,134,234,144,192, 70,133,109,135,167,
161, 91, 64, 73, 41, 57,  6,141, 49,230,213,104,221, 47,224,247, 17,167,177, 28,
 18,251,145,147,212,243,254,227, 40,118,147,157, 56, 67,149,231, 71,234, 29,250,
219, 45,158,184,165, 42,197,  1,238,196, 40,228,213,131,108, 40, 46, 60, 66,121,
146, 78, 10,202,183,204, 31, 68,168,130,106,237,169, 62,  0,157, 70,155,172,183,
133,202,117,169,129, 46,  7, 18, 55, 29, 11, 99, 22,209, 60,147,217,201, 89, 13,
182,115, 17,135, 22, 19,210, 11,148,  9,148,  7,  8, 48,  2,236,148,100,118,216,
236,187, 44,222, 45,208,  1, 34, 18,154,254,102,217,  3,226,150, 10,181, 52,115,
230,110,158,201,206,115,149,121, 60,188, 62, 80,197, 94,117,220, 18,149, 39, 23,
 76, 68, 17,215,233,190,139,106,205,240,192, 61, 92,167, 21,174,  6,183,144,182,
  5,124, 21, 56, 91,173,180,152,223,233,130,239,147,149, 50, 87, 24,108, 10,149,
 43,221, 28,200, 38,217, 64,157,141, 97,179,162, 45,205,241,250,  0, 37,210,127,
 51,232, 44, 26,167,221, 71,101,222,175,119,152,120,137,209,139,169,238,  5,187,
207,202,177,  7,113,181,226, 10,119, 34,128,210,179,107,189,182,127,112, 19,132,
170,147,189,225,191,249,206,247,148, 95,113, 82, 77,101,172,116, 82,241,115,242,
 23, 21, 65, 27, 74,160,116,114, 24,241, 37, 98,238, 16,230, 84,111, 77,172, 37,
111,102, 96, 99,217, 55,148,103, 73,118,106, 27,147, 99, 72,127,166, 31,164,110,
180,192,168, 85,231, 76,209,  6,126, 48,  7, 29,170, 55,183, 18,250, 20, 53,242,
 10, 88,226,154,130,  5,136,  5,248,158,170, 64, 20,243,114,153,128,204,139,133,
 20, 57,224, 47,185,188, 78,156, 65, 94,215, 13, 29,128,219, 83,112,109,142,162,
 74,  7, 88,253,134,196,100,114,156,128,193, 94, 67,126, 63, 68, 86, 59,152,111,
170,169, 26,197, 61, 19, 25,171,145,148, 80,232,142,187,118,140,120,106,159,173,
171,125,173, 72,182, 50, 43,  8, 24, 47,  3,159, 11, 65, 10, 22, 51, 19,207, 43,
144,115,147,130,  7, 64,144, 37, 97,101, 99, 73,222,131,230, 90,197, 74, 59,120,
 11,166,252, 78,128,171, 38, 39, 94,  1, 51,159, 48, 42, 86,226,208, 36, 92,114,
 68, 38,188,183, 85, 56,233, 67, 97,146,165,123, 49,206, 44,124,230, 95,  7,253,
 21, 20,129, 72, 27,205,178, 26,254,  7,218,203,235,161,109,132, 90, 36,173, 90,
147, 87, 61,124,157,230,162, 83,194,164, 74, 25,148, 51, 41,231,127,192,176, 90,
108,184,216, 88,196,196, 96,125, 88,240,124,107, 69, 91,  2,244,188,177, 59, 45,
 40,197, 91, 95,171,225,208,206, 84,143,153,233, 64,209,  3,124, 36,209,200,233,
101,229, 48, 35,247, 12, 66,233,236, 17,186,131,222,197,244, 14, 73,235,153,120,
 84,216, 18,171,178, 62,136,168,146, 31, 46,184, 46,129,129,250,209, 62,222,  6,
 30, 52, 16,225, 26, 96,254, 49, 54,245, 65,158,107, 93,243, 80,224,220, 21,207,
147, 67,224,117,236, 22,191,141,205,101, 37,126,225,196,241,249, 32,153,102,109,
127,164, 68,210,236,103, 29, 98, 51,236,145,121,230,197, 17, 65,251,248,197,209,
 79, 60, 74,188, 13, 22,214, 37,205, 63,226, 89,184, 82, 53,150,217,171, 85,188,
108, 84, 41,128,253, 76, 50,184,117,111,139,152,255,122, 96, 25,228,217, 69,140,
 91,192,241,209,114,156, 92,103,166,184, 72, 74,227, 93, 56,207, 71,223, 29,  0,
 92,182,240,232, 85,255, 57, 96, 51,212,225,232, 55, 82,226,106,232,198,232, 36,
 47,182,172,  3,199,137, 43,230, 23, 54, 77,242,130,153,182,  8,198,243,  3, 29,
205, 64,114,242,133,156,206,121,237,  7,
} ;

// ../Source/Template/GB_binary_search.h:
uint8_t GB_JITpackage_73 [1194] = {
 40,181, 47,253, 96,213, 44,  5, 37,  0,214,168,121, 40,224,208, 56,  7, 58,199,
 12,161, 27,171,226,180,168,133, 78,196,187, 87,189, 99, 21,175,191, 45,253,101,
118, 56,248,103,240,230,140, 23,195, 24,131, 49,132, 16,112,  0,112,  0,106,  0,
 27,199,185,117,192, 52,169,172,  8, 75, 13,118,153, 87, 42,247,214,119,114,188,
 34,108, 39,107,189,137,120, 20, 36,170,200,162,202,150, 57,183, 87,126,154,115,
142,203,252, 17, 88, 19, 43,114, 64,153, 88,167,180,199,159,109, 17, 84,120,149,
 57, 73, 94, 10,234,206, 31,150,217,104,100,  7,107, 67,133,109,133, 29,198,183,
 67,216,116,109,115,143,124, 43,181,135,159,253,191, 34, 43,169, 85,200, 54, 35,
 85, 56, 59, 35,211, 52, 92, 34,153, 34, 18, 73,177, 65,221,111, 86, 96,112,103,
 31,225,113,230, 90,142, 36,  3, 27, 29,144,156, 99,186, 56,245,158,231,245,227,
 66,173,185, 46, 20, 89,  4,229, 73, 16,244,123,253, 85,229, 88,233, 63,179,227,
100,205,218,254,223,177,220, 25, 32,186,113, 58,111,193,168, 93, 85, 85,119, 99,
174,179,184,231, 44,239,103,191, 95,249,195,119,246, 43,221,152,235, 64,109, 95,
121,184, 56,157,137,103,111, 28,  3, 38,135,204, 33,129,147, 89,192, 50, 10, 78,
  6,226,210,  4, 28, 20, 93,222, 30,221,114,215, 59,121,163,231, 73, 79,154,240,
 85, 99, 76, 14,213,123,109,125, 13,141,165,246, 56, 97,201,114,234, 29, 29,151,
199, 59,156,  5, 12,203,144,110,  7,226, 56, 67,116,187,133,178, 82, 16,223, 62,
115,159,217,246,240,244,126,142,104,124,228, 17,173, 21,206,219, 46,177,229,184,
100, 57,229,144, 11,  5, 50,251,182, 66,238, 58,248,219,127, 91, 83,125,132, 99,
 60,190, 89,110, 93,  2,185,156,185, 24,211,180,117,156, 28,208, 37,139,178,176,
203,242,203,173,158, 28,115, 42,179,253,230,179, 80,148,196,181, 97,128,152,192,
188,181,201,150,107, 87, 89,184, 52, 15, 17, 21, 89,  9,242, 83,152, 55,  5,240,
119,121,253,254,165,243,149,178, 28, 61, 58, 61,180,111,223, 10,187,215,185, 54,
 18,152,128,192,197,242,231,249,169, 87, 85,122,132, 87,150,183,249,156, 17, 57,
 42,223,199, 80, 32,148, 72,198,193,217,159,174,244,103,203,193,173,226, 80,129,
 19,168,241,165, 50, 35, 34, 34, 18, 68,146, 36, 73,107, 97, 16, 66,  8,130,210,
 74,120,  7, 34,104, 36, 17, 50, 20,139, 32,  8,141, 24, 66,  4,134, 24, 33, 17,
 42, 34, 32,  2, 67,  4,132,  8,137, 20,156,174,198, 14,  5,242, 77,137,222,169,
181,214,210, 31, 59,255,100,231, 31,146,139,167,122, 49,222,139, 37,249,200,117,
125,239, 88, 19,205, 48,180,135,193,247, 55,192,157,245,155,172, 85,169,127,104,
255, 45,158, 92, 38, 64,243, 34,  7,254,182,111, 93,178, 57,241, 53,200, 89, 61,
 30,225, 12,227,172,  8,246, 30,121,164,107,121,195, 13, 79, 10,222,185, 61, 63,
212, 22,149,203,255,150,  0, 84, 11,176,  7, 19,156,170, 70, 75,172,159, 48, 73,
  8,243,250,186,122, 14,251,161, 27, 34,113,235,171, 63, 17,198, 76, 32,196, 30,
192,158,173,238,123,  5,227, 19,140, 26, 72, 19,202,185,133, 88,161,152,102,204,
130, 30, 64, 80, 81, 93, 61,  4,181,110, 22,238, 51, 23,114,240,176,175,242,232,
 75,223, 61, 68,104, 96, 62,132,225,203, 66,209,132,175,225, 66, 85, 55,216,164,
  9,144,210,106,128,130, 42,223, 58,237, 52, 38, 72, 11, 39,218,145,130,222, 84,
248, 30,191, 53,209, 31, 78, 52,111,191, 37,203,138,161,215,168,123,156, 88,137,
 39, 61,134, 78,254,176,233,160,164,211,131, 37, 92,154,120, 93,159,  3,202,141,
  8,109,255, 38,104, 99,165,100,215, 45,174,173,143,241, 48,196, 74, 41,205, 13,
157,183, 58, 71,200,254,202,196, 51,221, 28, 99, 32,  1, 12,178, 48, 88,140,109,
 73,207, 93,223,124,169,228,157,127,216,105,108, 63, 96,111,216,160,202,224, 96,
149, 84,141,140, 99,219,212,  6, 96, 87,155,232,227,254,205,143, 14,142, 40, 83,
237,110, 83,115,145, 16,136,109, 94,232,172, 83, 91,242,182,223,128,  3,105,247,
140,172,123,168,192, 98, 56,127,214,130,185,156, 25, 81,144, 56,109, 36, 10,254,
228,  2, 89, 99,244,  2,107, 83,136, 47,149,136,147, 73,202, 96, 59,  0,  9,157,
170,202, 14,186, 29, 32,251, 38, 22,174,140, 30, 71, 73,122, 55,253,191, 83, 51,
211,240,194, 54,101,100,  8, 71,135, 92,221,121,107, 83,194,246, 89, 69,123, 46,
 23,133,151,125,198, 79,168, 61,144, 95,135,  4,193,211, 21,  9,  7,169, 18, 55,
 71,237,240, 68, 58,197,100,142, 44,121, 90, 30, 14,255,182, 55,176,145, 11,  3,
 22, 49, 70,199,207, 72,250,133,102,213, 86,210,175,137, 64, 51, 60, 80,132,168,
210, 16,105, 24, 30,184, 76, 50,193, 35, 39,106, 37, 68,234,212,118, 53,212,167,
 89, 63, 35,139, 81,162,182,187, 65, 44,102,224, 62,170,219, 96,142,239,160,  8,
 43,226,243, 97,137,112,  8,177, 94,144, 34,  0,  2,246,  4,232,254,250, 45,  7,
173,248, 73, 63,223,192,190,120, 96, 17, 68,218, 86,129,  7, 64, 90,  6,147, 72,
 24,121,251,172,247,193,122, 50,151,149,150, 34,  3, 69,179,112, 85,118, 16,219,
 15,213,153,152,210,195,  7,248, 65,182,114,115, 30, 99, 37, 76,216, 14,225, 31,
107, 80, 56,191,109, 56, 32,117,215, 66,216, 13,169,214, 13, 26, 52,203, 42, 51,
 81, 23, 45, 24, 87, 52,  7,152,129,220,168,198,  2, 39,
} ;

// ../Source/Template/GB_bitmap_scatter.h:
uint8_t GB_JITpackage_74 [244] = {
 40,181, 47,253, 96,137,  1, 85,  7,  0, 18, 78, 45, 23, 48,219,  1,180,166,187,
130, 15, 21,106,167, 41,142,162, 60,156,132,113, 54, 88, 56, 26,192,  0, 96,230,
114,125, 70,210, 22,247,166, 78,201, 44, 44,113, 95,194,238,187, 54,236,  3,160,
 10,185,201,243,158,168, 11,183,  7,243, 44,200,252,114, 53,115,  0, 36,199, 98,
 60, 74,138,237,227,142,251,217,204,123,253,210, 50, 94,175, 79,230,203,  0,165,
237, 40, 31,118, 95, 63,231,122,163,103,230, 60, 77, 31, 47,152, 37, 89,140, 70,
 73, 22, 31, 72,193, 11,157, 97, 81,242,227,241, 24,221,172,154, 61, 47,186,231,
130,208, 86,116, 41,231,181, 43,182,221,239,252,118,128, 46, 89,116,191,234,196,
122,102,173, 69,151, 53, 93,175,108,222,121,205,230,151,238,160,135,251,123,139,
164, 14, 91, 81,221,121, 12, 33,202, 17,  4, 48, 16, 36, 18,  0, 28,  3,226, 93,
248, 65,193, 14, 94,199,189, 87, 41, 97, 36,117, 79, 40,237,128, 74,226,231, 47,
 51,234, 16, 68,235, 30, 52,127,158,153,162,237, 98,171,229, 22,131, 22,144,138,
139,162,192, 13,
} ;

// ../Source/Template/GB_bld_template.c:
uint8_t GB_JITpackage_75 [1341] = {
 40,181, 47,253, 96, 78, 18,157, 41,  0,134,119,158, 39,208, 88, 77,  7,  4,234,
105,210, 29,109,119,143, 43, 13, 34,107,139,151,226, 73, 17,160,181, 98,173,100,
194,  7,138,104, 15,109,  7,185, 26,102,145, 87,  2,154,  0,142,  0,145,  0, 17,
162,156,224, 83,192, 78, 95,212,140, 81,132, 77,229,197,213,234,168,111,223,148,
179,159,215,242, 88, 12, 52,  8, 25,181,168,196, 36,222, 16,117,171,237,167,141,
147, 81,126, 74,173, 70,  6,164,162, 67,211,244, 36, 42,171,199,185, 45,146,245,
184,115, 18,159, 18, 16, 12, 16, 50, 12,  7,  6,  8,191, 80,210, 39,222,147,172,
184, 70,226, 35,171,225,181,158, 79, 29,  9,141,  9, 11,203,136,209,160, 28, 19,
235,104,111,214,177,176,246,181,147, 90,135,101,237,163,151, 87,  7,186,148, 57,
223, 94,126,186,136, 58, 82,115,155,129, 54, 34,207, 27, 40,141,118, 58,236,210,
254, 52,  7,250, 76, 96,188,160,192,146, 41, 40,  8,157, 93, 81,177, 55,103, 37,
240,253, 98,240,205,230, 79,122,181,  0,150,  6,224,218, 50, 23,208,175,224, 89,
 47,200, 47,123,232,255, 45, 22, 21,231, 50,151, 39,172, 20,149,239,129,199, 10,
219,123, 71,160, 55,117,237,165,245,134,207,243,107, 52, 52, 62, 54, 62, 25, 77,
223, 86,218, 42, 52, 56, 31, 19, 31,142, 14,103, 82, 78, 42,194,139, 95,147,121,
240, 29,242,170,213,171,215,232, 17,105, 98, 42,134,229, 89,159, 82,107,161,188,
 51,  8, 74,106,155,225, 35, 73, 76,155,251, 74,189,229, 79,172,212,198,206,139,
245,228, 86, 67,208, 35,172,174, 87, 50,175,134,163,134,  2, 43,151,158,250,147,
200, 35, 61,164,131,131,226, 83,161, 49,209,249, 69,177, 81,183, 52, 34,242,252,
225,  7,152,191, 61,117,248, 72,219, 22,185,242,103,243,142,217,220,239,143,194,
130, 10,  6,243,  7,135, 75,212,118, 54, 75,234,178,166, 22,197,191, 60,137,173,
254, 92,217,115,234, 92,198,196,142, 93,240,121,145,100,196,  2, 28,222,182,223,
239, 82,105,123,213,  6,120,154, 98,216,134, 88,212, 34,124,211,197, 32, 53,189,
253,212, 84, 22,155, 31,164, 96,191,169, 62,200,159, 22, 34,195,121,211,126,233,
 48,126, 25,123,212, 82,163,203,115, 90, 83, 63,101,141, 88,197,129,253, 86,  3,
 89,  0,  6,211,241, 81,209,148,179, 57,169, 79, 27,204, 69, 50,248,131,128,192,
249, 64,115,121,202,160,140, 73,222,118,  6, 58,236, 99,153,244, 11, 75, 45,210,
247,118,148, 87,239, 81,160,115,176,122,167,213,187,158, 80, 40,227, 13,239, 71,
 60,180,210, 61, 30, 22,157,142,196, 55,223,252,100,117,134,157,203,191,164,216,
  1,226,156,236, 13,165, 70, 80,191,149,228,161,192,204,100, 95,246,230,184,213,
 86, 41,175, 63,163,107, 84,193, 75,212, 84, 65,135,236,242,154,  8, 59,163, 98,
240,106,245,115, 79,222,244,186, 50, 62, 91,189, 40,159, 64,215, 39,174,182, 61,
 13, 80,118,106,177,  4,129, 36,168,161,161, 67,104,102, 70, 36, 73, 65, 82, 24,
214, 49, 12,129,161, 48, 11, 33,167,  7,194,160, 68, 72, 98, 36, 69, 64, 66,  4,
134, 24, 98, 68,100, 68, 36, 16,  9, 82,144,210,130, 98,214,113,229,215,  5, 49,
172,149, 98,161, 98, 19,177, 51, 81,160,158, 28, 98, 77, 67,109,122,228,144,112,
173, 49,168,157,134,100,132, 32,156, 19,109, 60,142,172,131,250,186,201,236, 79,
 80,236,121, 39,140,172,229, 81,  4,209,184,216, 47,242, 75, 67,  5,135, 60, 82,
100,194,106,195,224,119,234,114,169, 56, 65,200,164,185,176,181,195,234,236,  6,
155,244,193,131,181,111,162, 42,115, 27, 14,162,234,190,209, 69,170,179,184,177,
 62, 52,152,252,135, 35,102,133,176,209,126,112,213, 84,220,246,152, 71,253, 49,
255, 82,135, 31,135,120,147, 32,230,129, 77,  4,254, 33, 20,116, 45, 78, 26,206,
127,134,106,110,222, 20,  5,102, 32,225,168,118, 83,  7,251, 15, 85, 76,156,199,
 87,224, 81,189,147,226,127,189, 31,118, 47, 78, 35, 13,238,254,187,211,128,245,
 71,183, 81,201, 48,130,131, 54, 68, 28,124,231,153,123,154, 21,183, 63,177, 64,
 21, 48, 35,189, 41,204, 65, 15,  7,  1,104, 57,240,200,236, 14, 53, 75, 24, 65,
196, 72, 17, 22,133, 64,160,211,209,226, 69,224, 92,231, 71,  7,  3,208,225,121,
153, 48,193,115,152, 35,237,240, 23, 63,103,169,255, 65,140,151, 12,173,213, 49,
 30,115, 40,221,  4,124,168,205,174,113,226, 50,102, 25, 54,146,187, 84,206, 62,
180,168,153, 16,125,248,130,141,157,188, 22,207,136, 16, 31,169, 31,110, 80,146,
 67,  7, 30,214,245, 42,229, 44,138,102,109, 45,148,152, 22,149,160, 17, 18, 88,
 89, 51, 42,216,131,162,100, 73,  4, 47, 60,240, 24,119,133, 84, 43, 73,142,169,
101,  2,251, 11, 70,201,  5,  4, 54,219,168,176,212,225, 11,  8,192, 18, 68,106,
104,187, 89, 64, 50, 33,127,170,106, 64, 53,169, 18, 45,227, 24,248, 90, 93, 44,
200,110,242,141,182, 12, 79,232, 62,169, 33,210,158,  9, 54,  6, 71, 28,255,204,
133, 43,232,245,176, 54,223,203,243,111,117,165, 84, 77, 47,180,219,218,  2,  8,
242, 67, 51,166,  6,227, 97,  0,141,109,130,126,228, 16, 53,143,109,226,240, 45,
166, 14,106,217,211, 87, 93, 37, 42, 12, 15,166, 61,107,  5, 71,229, 20, 69,122,
236,  9,236, 61,166,232,229, 68,248,201, 23,188,137, 49,184,153,253,230, 16,180,
220,136,104, 66,216, 74,152,234,126,187,142, 73,169,160,126,  8,229, 13, 38, 99,
 22,249,178, 91,  2,207, 92, 83,134, 90,145,248,132,219, 70, 10,199, 87,150,158,
  5,113,196,106,177, 22,236, 45,119, 72,  6,209,102, 37, 24,117,102,217,217, 47,
127, 17,203, 10, 14,218,214,228,220,  6, 19,196,128,199, 93,211,102,172, 93,104,
213,133,110,227,186,153,119,  8,137,219,113,  8, 47,120, 80,101,196, 92,161, 14,
 63,198,162,232,  3, 78, 50, 65,142,217,107, 51,  2,230,180, 25,207,157,217,117,
137, 36,132,184, 83, 13, 67, 89,164,160,124,162,129,215,140,217,111,  5,255,252,
 99,209, 60,155, 38,165, 50,211,114, 51,247,114, 77,122, 19,244, 22,165, 52,  0,
 15,
} ;

// ../Source/Template/GB_bytes.h:
uint8_t GB_JITpackage_76 [376] = {
 40,181, 47,253, 96,130,  2,117, 11,  0,134,214, 69, 32, 16,179,115,172, 60, 80,
 44,101,174,250,113,186,189, 36, 12,153, 32, 25, 99,192,236,172,239,255, 98,224,
 35,  2,  0, 64,224, 32, 61,  0, 60,  0, 60,  0,  3,235,130, 44,240,168,178, 39,
 50, 62, 41,254,109,221,113,184,242,136,162,136, 44,182, 78,164, 14,196, 86, 26,
 59,148,109,246, 40,176,110,231,235, 79,150,154, 99, 15,187,236, 94,247,195,245,
136,109,170,219, 31,166, 89, 56, 78, 81, 80,162,168, 28,218,205, 47,141,175,179,
227,230,201,114,181,111,221,173,  2,  7,147, 37,237,150,197,142,226,  8,186, 44,
185,231,106, 16,105,235,220,140, 35,146,133, 33,153,180,245,208,173, 59,121,237,
109,195,147,115,156,226, 17,193, 26, 88,146,161, 10,147,189,192, 95, 45,  0, 62,
 52,148, 70,229,178,144,171, 77,201,  0,  8,167,175,153, 99, 44, 54,237, 58, 95,
234,213,185,239, 90, 48, 77, 83,224,178,219, 76,174,222,219,195, 30, 93,213,181,
 25, 31, 29, 30, 21, 30, 89,143,170,127, 28, 23,  3, 16, 74,214,230,  2, 32,172,
252,195, 16,252,184,206,150,178,118,109,107,221, 44,139,239,110,158,162,158,120,
198,194, 92, 74,175,235,255, 31,130, 96,103, 30,237, 10,175, 10,235,184,171, 42,
 92,  7,139, 80,184, 42, 75, 32,104,205,161,  3, 33, 32,128, 68,  2, 42,229,  6,
176,110,243,216,  3,161,221, 85,100, 24,132,122,  4,243, 45, 65,159,238,136, 57,
 41,184,  3,148, 80, 33,188, 64,109, 97, 17, 60, 97, 35,141,137, 72, 65, 16,  9,
 67,184, 44,157, 28, 58,144, 59,  7, 22, 95,187,250, 60,251, 58, 40, 22,231,187,
 21,224,166,217, 60, 51,209,198,191, 90,248, 62, 90, 20, 45,110,
} ;

// ../Source/Template/GB_callback.h:
uint8_t GB_JITpackage_77 [644] = {
 40,181, 47,253, 96,176,  8,213, 19,  0,198,156, 91, 33,  0,181, 30,214,212, 19,
205,178,  2,124, 60,111,130, 15,197,125, 54,148,140,214,162, 38,169, 85, 24,134,
113,150,254,223,235, 67,  8, 82,  0, 81,  0, 83,  0,175, 63,115,189,189,206,205,
252,251,166, 23, 24,139,196,194,208, 80, 36, 22, 62,176,  2, 47,232, 11,170, 17,
 63, 76, 31,121, 27,131,119,243,130, 54, 43,136, 39,214, 60,113,188,206, 85,212,
126,223, 81,147,218,191, 15,243,123, 60,227,206,117,247,220,139,163,237, 14,239,
224,177,149,243,125,213, 82,200,196, 17,  8,105, 64, 32,  2,174,243,239,240, 98,
209, 67,124,183, 13,199, 78,110, 59,230,173,169, 71,215,205, 24,137,162,170,  1,
222,  1,111,156, 69, 10,240,231,198,207,134, 31,222,128,164, 80,203, 52, 33, 85,
 53,167,238,185,176,187,  1,153, 56, 44, 12,239,217, 42, 78,119,228,191,221,221,
225,115, 21,195,235,240,237,173, 12,154,  8,118,224, 30,148,  3, 10,106,146, 81,
214,219,251,105,234,249,169, 82, 81, 22,127, 95,165,162,233,162,154,255,176, 23,
162,170,139,146,201,191,119,181, 90,172,224,190,156,140,218,182, 57,105,212,162,
216,180,182, 10,228,225,131, 65, 71,193, 81,131,163,165,162, 73, 16,  8,252,218,
174, 12,163, 22, 70,179, 48, 19,101,108, 48,205,212, 56,236,237,  7, 29,239, 82,
118,151, 11, 63,224,213,132, 92,213, 68,150,252,225, 54, 28,221,221,221, 37, 73,
230, 11,190,183,253, 65,183,163,171,232,213, 29,210,211, 35, 69,195,136, 88,164,
158,252, 33,236,194,168, 37,163, 50,116,103,172, 63,116,203, 46,237,178, 95,131,
191, 81, 26,104,141, 50,  6, 63,119,155,236,178,168, 76,162,248, 78,126, 48,113,
160, 17,146, 98,102,136,166, 36, 37,133, 44,107, 80,132,  8,161, 34,221, 79,129,
109,192,160, 57,  7, 52,  0,116,151,209,232,204, 43,134, 40,187,156, 47,146, 93,
 49,148,253, 16, 76,  3,100,191,172, 82, 58, 76, 23,100,127, 25, 87,210,226, 98,
170,248,101,155,146, 99,190, 32,251,203,102,100,152, 47,117, 17, 67,217, 15,160,
137,128,236,151, 89, 74,172,137,221,201, 30, 75, 99,177,216,148,137, 19,195,240,
237,  6,141,253,138,231,128, 47,137,253, 13,250,176,239,245,170, 27, 13,152,218,
183,100,160, 22, 43,241,186, 82,165,207, 42,111,214,208,144,134,103,233,154,208,
201,204,147,228,237,216,181,143,222, 14,  6,234,203,251, 58, 84,164, 55,171,248,
 72,125,  4, 67,165,104,223,176, 16, 15,190,102, 28, 21, 15, 60,121,104,132, 21,
120,143,148,129,150, 91,  4,  0,116,132,161,212, 46, 46, 64, 92,188,117, 68, 81,
183, 96,  6, 32,176, 99,122,164, 73,253,126,  1,113, 55, 16,232,131,140,103, 24,
 12,  4,205, 72,128, 23, 20, 15, 26,123,193, 74, 69,151,104,144,  8,129,165,140,
 60,218,131,161, 66,192, 15,154, 26,149,153,188, 23,182,170, 19, 66,204, 71, 94,
 85,244, 58,  1,
} ;

// ../Source/Template/GB_callback_proto.h:
uint8_t GB_JITpackage_78 [1746] = {
 40,181, 47,253, 96,226, 37, 69, 54,  0,170, 64,212, 11, 43,208,140,140,115, 91,
213, 38,218,213, 66, 53,231,117,229,247, 50,209, 82,213, 18, 49,120,192,128, 71,
 45, 11,102,  8, 98,229, 47,101,253, 50, 85,252,193, 21,158, 98, 16,191,172,  0,
182,  0,176,  0, 18, 58,205, 70,194,168,147, 90, 56,235,189,242, 75,189,211,206,
234, 47, 31, 82, 86,171,255,237,243,212,150,112,177,107, 36,148,208,181,220,215,
 47,155,205,119,167,148,217, 97,215,233,206,153,201,196,213,202,252, 15, 11,131,
225,225,224, 80,235, 57, 44, 58,196, 84, 88,193,150, 74, 77, 28,202, 82, 31,164,
 56, 30, 36,176, 60, 40,181,152,202,122, 57,183,165,129,151,199, 24, 29,122,112,
 96,112,112, 20,104, 96,112,120,227, 45, 28, 98,104,225, 18,252, 17,189, 99,245,
 94, 48,115,  8, 19, 81, 34, 44,204, 77,  9,  8,229,233, 48,140, 54,204, 48, 12,
126, 84, 57,117, 35, 23,246,147, 89,245,185,213, 89,177, 78, 31,194,122,108,239,
196,218,230,185, 41, 70,247, 90,132,196, 33, 16,134,  3,  2,  9, 28,165,228,164,
 89,238, 99,136,206, 22,210, 25, 38,225, 35, 95,169, 49,181,219, 61,198,220,213,
112,186, 72, 50,153, 40,130,105, 82,179, 68, 82,102, 18,209,248,102,106,  5,196,
148,211,105, 53, 31,218,200,204,122,215, 56,101, 75, 77,157,174, 76,202,183,132,
250, 28,198,155,185, 23,167,164,235, 87,251,102, 24, 33,206, 96,158,183, 13,187,
134, 60,199, 16, 56, 34,215, 10, 48, 58,  9,171, 63, 16, 40,114, 14,156,237,164,
 22, 49, 37, 22,126, 10,174,  5, 67,194, 27, 87,198, 87,246,218, 67,  7,227, 56,
110, 17,156,168, 61,144, 88,144, 40, 48, 18, 69,164, 61, 64,176, 60,136, 48, 42,
 33,  0,198,130, 86,201, 84, 46,150,198, 32, 18, 69, 80, 40, 81,164, 82, 74, 86,
 16, 64,132,216,181, 79,170,117,241,229,  7,187, 56,105, 38, 24,223, 28,202,217,
149,163, 30,130, 94,131, 64,222,216,206, 28,100, 42,214,177, 14, 44, 92, 59, 13,
121,198,152, 85,203,240, 12, 31,189,130,167,116,174,212, 24,160,226, 90,151,238,
177,194,217, 82, 33,142,187, 42,200,185,213,118,  4,121,174,187, 75,120, 14,132,
 38,  4,142,232,218,238, 91, 53,222,198,232, 26, 39, 82,105, 15, 26, 26,215,186,
104, 18, 74,101, 65, 69,131,  0,249,  0,105, 36,124, 48,114,219,104,147, 30,135,
  3,  1, 62,215,113,200,225,128,  0,185,176,221, 84,108, 31, 83,198,135, 46,118,
 54,169,129,204,142,210, 44, 58, 11,142,174, 58, 20,221,204, 46, 29, 66, 33,233,
113,119,218,254,134,221, 37, 77, 76, 76, 76, 76, 64, 19, 30, 34, 92,110,220, 55,
161, 36,220, 76, 62,145,239, 54,128,  0,252,100,242, 60, 12, 70,  5, 41,169,207,
133, 74, 57,179,214,217,176, 56, 91,128,161,184,118, 86,103,  8,191,121,174,185,
201,197, 48,171,159,  6,182, 88,219, 76,189,176, 84, 44,141,193, 69, 82, 33, 25,
 28,157,201,209, 16,189,227,230,116,111, 52,180,158,203, 20, 90,230, 82,193, 56,
224,140,227,174,111, 31,122, 18, 66,205, 74, 61,106,140,110,186,214,140,  4,243,
 88,207,181,106, 15,241,165, 13,229, 35,189, 19,163,203,250,185,179,118,103,162,
186, 65,158,237,106,191,121, 27,167,231,121,103,238,165,179,130,112,169, 72,146,
139,130,200,197, 22, 53, 79, 88, 85, 96,145,  8,183,204,246, 93, 94, 89,163, 65,
 53, 83,175,214, 32,145,184, 72,164,106, 15, 32,122, 63, 56,155,117,106,100, 66,
145,184,255, 45,162, 80, 40, 26,112,224, 12,129,164,168,225,157, 66, 34, 51, 35,
 34,146, 36, 73,134, 53, 97, 20, 98,148,130,208,113,214,  1, 66,168, 32,142,176,
  8,198, 64, 12,197, 16,132,  8, 49,148, 16, 66, 24, 17,  9, 40,146, 64, 36,176,
 48, 84, 29,111,137,106, 12,108, 85,106, 22,139, 74,204, 33,144,151, 18,175, 68,
107, 92,131,229,246,252,226, 92,132,155,152, 38,164,  1,113, 90, 47,198,171,135,
141,237, 34,221,223,229,195,150,  5,107, 31,112,217, 90,241,246, 79,112, 45,100,
 60,206, 59,133,168,139,215,180,149, 27,146, 98,243,250,213,255,166, 36,225,221,
120, 12, 69,186,193,152,  0,182, 37, 98,146,184, 47, 36,124, 24,171,216,157,230,
102,248,164,253,251, 72,119, 37,254,174, 20,214,200, 13,  3,198,202,245,223,  4,
 10,199,175, 38,211,200,106, 70,217,  7,251,122, 43,208,245,198,131,144,213,116,
222, 10,  5,118,120,180, 79,235, 31, 56, 20,240, 28,197, 13, 93, 98,231, 46,152,
151,208, 40, 52, 76, 98,233, 37,104,226, 97,117,223,165,148,165,254, 52, 15,239,
150,157, 21, 98,116,181,105,199,145,130,167,231,168,149,172,147,218, 60,133,198,
179,179,138,192,135,133,108,120,161, 64,172, 48,146, 19,208,217, 47, 97,213, 94,
 19, 24,123, 57,254,227,116, 90,228, 16, 94,188,214,167,  8,255, 60,227,  3, 70,
200,210,207,247,137,199, 86, 41, 31,  8,234,108,200,140,165,120,148,159,168,  5,
145,168,148,105,246, 33,137, 55,245,142, 84, 47, 51,103, 31,129,247, 97, 69,113,
 99, 81,  4,  8,131, 84,  0,217, 86, 65, 68,225,  9, 44, 31,140, 40,114,152, 35,
249, 60,170,121,146,233,120, 17,241,237, 19,242,130,128,241,201,182, 52, 62,141,
213,160,225,248,104, 50,247,104, 47, 36,214,225,158,  1,167, 10,178, 64, 11,194,
144,120,247, 22,171, 61, 28,232, 72,221, 97,169, 68, 61, 44,114,114,127,141,112,
163,116,208,149,141,167,248,106,127,198, 27, 52, 30,209,151,199,142,197,162,147,
 82, 99, 75,115,133,149, 18, 59,152,186,248, 28,176,198, 11,105, 59,238, 10,130,
  9,  5,180,135, 67,145, 34,228,136,247, 43,113,104,128, 99, 54,118, 46,216, 39,
229,118,204,181,250, 64, 63,182, 93,199, 79, 43,153, 15,253,102, 33,  1,229,249,
131, 87,239,247, 42, 28, 39,121,116, 58,201, 25,147,132, 96,184, 21,179,236,117,
114, 22,223, 11,189,210, 63,152,122, 46,209,164,233, 66,116,132,160,  9,188,122,
104,212,239,169, 18,113, 66,243,132, 14,177, 62,119, 16, 99, 34, 74,224, 10,219,
245, 44,208,197,141,134,159,197,184,114, 17,209,215, 66, 83,169, 94, 48,197, 37,
 34, 85,236,228, 77,242,203,125, 74,176,194,236,250, 30, 50,126,105, 90,159, 46,
 24, 87,191,228,218, 14,217,112,  8, 57,116,138,198,203,199, 76,  2,155,116,103,
187,133, 42,107,245, 61,150, 33, 60, 77,146,150,143,180, 76,189,240,254, 31,200,
131,125, 99, 19,  6, 46, 56,215, 33,234,243,255,226, 71,116, 32,158, 35,109,232,
211,215, 37, 74, 37,132,126, 58,158, 38, 69,180,213,253,239, 90,218, 11,127,214,
 50,103, 85, 86, 14,247, 43,229, 20, 16,108,202,  8,166,176,136,104,226, 40, 30,
 70,223, 18,115, 89,  2,204,245, 78,112,  5, 53, 85,164,106,153, 18, 42,209,163,
 15,222,115,235, 65,165,226, 74, 40,101, 89, 30, 66, 19, 14, 16,248, 49,154,166,
160,130,119, 84,155,132,147,248,140, 84,103,209, 73,132,247, 65,236, 80,125,255,
157, 58,128,182, 75,167,162, 71, 20, 87,240,  8,170,173, 64,225,180, 19,156, 29,
 10, 62,251, 98,136,167,163, 53,126,167,189, 26,221,149,241, 98, 73,170,226, 91,
103,194,128, 74,162, 96, 39, 83,244,147, 84,243, 80, 18,  3,215,221,219,202, 12,
 72,148,216,146, 62, 67,167,235,248,  9, 50,120, 21,109,112, 61, 46, 35, 83, 16,
108,204,227,216, 49, 98,139,180,235,  6,128,240,219, 57,228, 36, 30,235,200,164,
 79,113,117,168,239,245, 37,184,142,162, 89,152,146, 37,206, 25,123,227,251,  1,
196, 33,180,199, 82, 17, 45, 48,253, 36,207,174, 38,165, 10, 53, 62,162,217,135,
166, 30,212,158, 31, 88,232, 24,171,140, 48, 35,  2,253,132, 81,102, 66, 57,  3,
  1, 75,241, 41,197, 49,120, 71,243,132, 19, 46, 56,137, 17, 74, 43,184,167, 90,
200,147, 66,143, 78, 12,181, 37,230, 51,171,129,200, 25,149,193, 84,234,140, 66,
 65,135,226,171, 55,205,145,202, 76,252, 13,110,186,134, 48,228,176, 46, 94,250,
209,235,175,149,160,  9,
} ;

// ../Source/Template/GB_colscale_template.c:
uint8_t GB_JITpackage_79 [1052] = {
 40,181, 47,253, 96, 48, 13,149, 32,  0,134, 46,140, 39,208,210, 86,  7,212, 93,
 44,124,187, 19,202,159, 23, 94,234,202,204,165, 47,170,161,137,245,115, 64,190,
170,112, 85, 57,124,196,186,140, 82, 15, 13,176,188,130,  0,121,  0,128,  0, 88,
102, 32,137,101,224, 82,233,236,130,214, 29,115, 91, 98, 50,211,142,156, 74, 99,
218,151,132,168, 92,188,206, 64,108,143,219,184, 61,199, 57,227,144,158,207,233,
222, 12, 46,150, 75, 37,161,192,114,249,228,154,222,176,244,128,239,  3,238, 33,
 89,174, 36,  9,122,251, 56,  8, 77,102,225,221, 96, 26, 95,104, 63,157,101,233,
 35,  1,145, 55, 67,210, 39,164,149,  3,202,248,190,176,212,129, 15,143,229,223,
251,118,246,241, 71,113, 11,212, 49,157,225,180,164,206, 86, 79,120,225, 89, 47,
 75,179, 57,  1,129,164, 66, 64, 16,148,103,235,  0, 33, 83,249,140,105,189, 94,
115,111,212,115,115, 84, 44, 25, 42,212,155, 14,224, 50,159, 76,168,233, 15, 19,
214,171, 32, 52, 17, 20, 14,211, 65,158,234,243,113, 56,151, 44,149, 31, 93,255,
127,137, 68,228,182, 71,211,138, 15,229,115, 41,244,246,254, 25, 34,149, 68,239,
208, 41,188, 34,133,119,  3,142,222,206, 25,218,119,150,143,213,135,216,122, 85,
 62,106,  6, 79,245,189, 94, 31, 59,118,103,152,229,207,  9,223, 23,149,248,173,
 98, 73, 29,227, 60, 54, 46, 61, 87,250,237,146, 36, 72, 67,226,212,179, 20, 59,
187,240, 39, 19,142,176,111,150, 45, 82,137,254, 86,236,179,231,132, 23,218, 91,
 82, 61, 36,113,192,107,163,204,191,156,114, 97,198, 22,143, 48,204, 84,  0,206,
 17,  7,149,214,168,173,190,228,196,206,202,248, 74,108,132,201, 72,223,203,204,
 90, 67,141,103,107,222,196,135, 83,177,180,220,155, 74,136, 74,194, 83, 61, 88,
 32,206,177,142,152, 12,160, 61, 61, 32, 69, 81,212,123, 26,144,201,  4, 82,117,
 48, 64,150,203,178,204, 45, 67,197,125,225,214, 61, 95,242,102,220, 55, 18,201,
136,100,132, 34, 45,212,244,206, 68,245,225, 88, 84,210, 58,  9,175,112,107,171,
 12,142,103,  2, 68, 85, 21,214,139,224,124, 44, 23,177,113,158,206,173, 55,144,
247, 38, 18,197,233,154,202,227, 32,168,234,137, 68,162,  2,129, 54,177,157,214,
 90,164,253,102, 57,219,177, 64,213,102,244,150,185,233,206,106,208,108, 68, 88,
134,132, 78,235, 99,103,120,219,214,119,232, 53, 79,176,250,124, 35,149,216, 21,
 50,159, 30,101,130,105,152, 41,243, 13,141,133,103,248,209,173, 31,239, 26, 79,
 25,142, 73,  1,  1,133,204, 45, 95,152, 38,  5,  1,128,223,168,161, 61,170, 33,
 17, 73, 65, 74,146, 44,107, 80,132,  8,149,149,205,  1, 66,177, 48,145,225,140,
 97,196, 25,130, 68,  2, 17,201,136,130,148, 63, 59, 81,  0,213, 30, 41, 21,157,
242,248,153, 23, 74, 34, 59,173,233,174,124,155,100,210,130,233,217,  4,149,125,
 44, 86,226, 53,140, 97,210, 59, 14, 49,161, 19,106,171,246, 92, 74,242, 40, 25,
188, 72, 60,178,218,217,173,158, 47, 74, 32, 34, 25,196, 92,167,105,175,154, 66,
192,176, 10,137,164,111,  9, 31,102,142, 47,153,171,247,235,130, 75,123, 51,130,
176,145,201,215,248,107, 46,169,227,198,143,124,120,161,242,147,149, 47,150,  1,
 18,204, 84, 34,233,239, 46,164, 93,216, 18,243,187,173, 82,181,118, 67,244, 65,
 95,251,100,  1,195,101,108,107, 16, 85, 74, 95, 26,100, 76,232,134, 53, 97,181,
173,144, 89, 26, 52,176,133,124,167, 84, 30,230, 21,237,161,185, 84,144,249, 56,
196, 48,101,113, 74,  5, 50, 74, 37,245,162,161,128,127, 56,215, 15, 57,205,222,
128, 78, 41, 45,239, 56,162,148,162, 66, 13,190,112,144,152,212, 84,203,206,  0,
228, 18, 89, 37, 80,196, 85,130, 44,152,198,196, 85,117,242,236, 54,162, 72,177,
144, 59, 67, 31,255,155, 49,218, 20,231,  8,169, 53,207, 43,202,101,115,185,109,
156,129,100,189, 82, 79, 80,153, 72, 60,215, 41, 40,217,189,242,112, 46,221,129,
 19,148,149,102,226, 37,201,188,137,232, 34, 18,251,203,208,117, 50,172, 89, 28,
213,252,224, 14,113, 24, 76,177,239,144,145,167,224,166, 87, 39,119,224,137,107,
104,214,241, 43, 61,  0,104,127,171,114, 76,222, 83, 94,181,192,  7, 15,  8,128,
 41,251,  5, 46,118, 32,226,182,165,253,175,131,164,169, 65,159, 60,179, 38,217,
154, 32,217,224,118, 60,  8, 54,131, 59,197, 51, 68,161, 75,107,191, 63, 39,116,
 31,224,234, 10,  7, 60, 58,164,124, 65,129,227,188,105,  8,181, 21,129, 14,  8,
 60,208,219,247,209, 55,141, 97,118, 56, 21, 48,178, 27,  0, 72,156, 96,127,133,
 66,134,166,183,130,217,  3, 96,116,209, 41,245, 76,102,111, 21,219, 55, 77, 94,
101, 38, 49,102,187, 18,126, 25, 42,221,129, 39,
} ;

// ../Source/Template/GB_compiler.h:
uint8_t GB_JITpackage_80 [2496] = {
 40,181, 47,253, 96, 75, 39,181, 77,  0,186, 88,116, 16, 44,176,110,142,117,152,
108, 86,150,192, 53,128,160,170,192,234,112,162,124,191,174,249, 70,250, 19,140,
115, 75,239,250, 20, 88,167,146,109,238, 24,154, 59,165, 63, 69,255,199, 56,255,
  0,251,  0,239,  0,  7,170, 59, 88, 56,145,138,168,168,218,137,111,131, 24,167,
 13,106,170,197, 12,185, 58,175,181,  0,183, 79,133, 52, 82, 54,214, 36, 35,241,
174, 43,190,135,137,192,178,247,120,136,226, 60,237, 92, 49, 11,101,131,193,104,
 51, 24, 63,229, 98, 97, 38, 22, 76,  2,226,135,144,200, 48,216,123, 19,214, 68,
226,210, 68, 64,176, 46, 11, 72,215, 16, 35,168,222,194, 38,216,  4,102,177,152,
254,222,187,116,249,198,221,235, 60,158, 90,156, 90,104,187,157, 91, 46, 44,156,
236, 82,169, 96, 44,203,117,157,115, 97,143,255,191,174,  9, 76,215,217,176,120,
240, 52, 20, 11,150,185, 68, 92,158,150,213, 51, 27, 22, 15,170,114,180, 22, 33,
103, 93,114,123,122,102,174, 45, 49, 71,227,218,113, 90, 28,156, 73,134,146, 13,
186,141, 91,115,156,181,207,212,156, 82,235,141,  2,213,163,114, 32,128, 60,170,
 79, 81,122,  3, 79, 16,156,156,178, 62,210,178,221,230,230,141,204,178, 64,104,
 28,188, 21, 73,227, 11,185,172,243,236,178,  5,174,118,102, 56, 47,  4,253, 77,
101,133,218, 37, 26,117,155, 78,110,179,241, 65, 84,238,224,176,112, 56, 56,  4,
213, 30,203,150,114,  4, 67, 93,231, 13,134,232, 13,140,227,222,108,236,206, 39,
145,100, 93, 42,150, 38, 83,129, 97, 62,134,219,  7, 94,238,153, 75,109, 46,162,
193,  2,207, 91,118, 52,222,217, 93,232, 27, 45,165,112,155, 38,  6, 13, 38,  6,
 12,164,  7,  8, 32, 81,112, 59,158, 90,190,205,151, 45, 37,124,119, 46,105,103,
 53,220, 57,199,117,111, 52,134,177, 94, 30,123, 59, 67, 42, 91, 52, 61,221, 57,
165, 51,148,225,196,216,114,199,  2, 50,246, 83,211,163,162, 34,144, 99,  9,135,
186, 62,187,224,107, 51,188,205,217,143, 46,172,179, 51,193, 68, 92, 20, 89,225,
171,  2,151,131,183,201, 52,152,131,183,150,143,155,118, 32,158,242, 31, 72, 61,
215, 80, 40, 40, 17,239,105,155,200,167,235,220,122, 46,107,103, 47,172,184,150,
194, 51,101,189, 24,143,219, 90,182,141, 29,143,  7,228, 14,217,101,162, 81,186,
157,178,203,217, 41,236,240,156,120,246, 88,108,111,156,151,236,242,  5,133, 51,
 40,198, 39, 11,101,130, 98,121,112,109,172,204, 85,137, 31,  9, 76,101,218,100,
 28,198, 47, 16, 24, 99, 26,224,152,254, 16, 32,251,140,173, 70,137,224,118,216,
 24,214,249,134,199,190, 49, 69,164, 31,195,217,147,100, 89, 38,228,156,244,194,
 62, 16,169,211, 81,237, 70,193, 43,136, 38,220,194,132,151,211,130, 36,240,246,
 23, 82, 24,241,155,126,234,196,135, 29, 33,135, 43,174, 13,101, 88,103,238,236,
189, 99, 84,225,  5, 55,253,181,199,157, 19, 84,144,198, 48,113,231,185, 77,218,
220, 40, 59,110, 67,118,190, 22,247,133,247, 96, 35,120, 47,188,150, 63,181,169,
131, 34,  1,211, 68,108, 46,202,196,130,154, 52, 42,206,219,181, 63,141,165,231,
249,140,187, 13, 75,171,229,222, 26,  2,186,243, 10,227,230,167,112,174,189,117,
134, 25,191, 97,237, 55, 50,237,224, 71,157, 79, 19,150,112,118,146,206,144, 16,
144,170,157, 57,118,178,239, 45,204,216, 32, 32,157, 33,185,103, 86,220,134,242,
 59,195,190,177, 65,122,230, 29, 55, 56, 43,109, 46,137,  9, 69,243, 38, 23, 44,
123,117, 66, 58, 33,  8,202,109,226,223,214, 75,222, 59,110,220, 53,114,133,147,
 66, 32,215,177, 12, 99, 61,219, 42,  9, 27,139,226, 64, 34,115, 97, 40, 42,117,
 94, 26,119,230,218,155,197, 31, 44,160,233,199,218, 74, 85, 85, 85, 85, 85,143,
205, 97, 26, 91,190,183,161, 84, 52,214, 70,130, 67, 86,214, 73, 49, 73, 85,  1,
 12, 70, 81, 59,143,232,114, 28,216,158,215,113,241,167, 70, 48, 52,234, 14,237,
138, 73,243,244,224,218,137, 42,124, 61, 42,200,203, 54,154,136, 76, 38,242,200,
212,112,231,103,  1,181, 65, 80, 59, 38,162, 18, 84,251,  8, 17,219, 11, 80, 17,
108,241,237,207,231,121, 74,175,166,137,225, 17,129, 32, 67,146,164,191,215,185,
235,204,155, 51,124,239, 65, 29,160, 16,220, 65,  5, 57,192,153,176, 30,144, 10,
183,124, 39,232, 52,194,202,105, 44,215,  3, 96,224,225, 61, 36, 16,189, 12, 25,
 62, 25,120,224,188,203, 67,  2, 14,128,219,229,216,121,106, 49,247,231,194,140,
131, 63, 97,217, 33,233, 84,156, 25,110, 54,119,112, 68,115,236,123,109,108, 57,
 67,135,175, 61,113, 92,203, 51,116,137,231, 43, 18, 16, 88, 37,243,201,  2,121,
 68, 34, 13,126, 77, 54,217,123,210, 98, 58,238, 40,247, 56,133,219, 74,200, 51,
235, 65, 75, 27,223,113,  6,130,102,168,210,155,152, 99, 78,149,144, 36, 41, 40,
 20,134, 53,130, 24,  4,225, 96, 24,168,131,164, 30,146,152, 68, 71,161, 60,101,
  8, 81,198, 40, 66,136, 33,134,144,  8, 73, 48,145,136,210, 20, 36,199,165, 50,
192,218,182,134,142,216, 99,167, 90, 72, 87,174,187,239,128, 95, 53, 86,236, 19,
184, 39,107,135,195, 94,228,127,161,131, 28, 51,176,208,100,222, 37, 69, 45,102,
142, 90,195,136,171, 99, 19, 35,106, 11,234,104,172, 26, 58,174, 11,138,101, 65,
 30,237,173,221, 26, 26, 93,161, 47,169, 58, 32,232, 12,131,127,124,231,  2,213,
151, 28, 83,137, 98,112,218,  4,191,166,165, 58, 21, 35,138,139,139, 26,175, 62,
126,207,240,218, 62,  0,174,246,101,  2,167,203, 93, 97,146, 86, 57, 24,145,  0,
181,  4,204,142, 12,181, 12,145,161, 77,155, 87, 39,172, 37, 25,240,112,116,108,
192,151,138,  8,219,134,216,129, 15, 27,198,224, 73,103,125,251, 21,227,221,200,
223, 33,  0, 58, 70,208, 53, 96, 15,154,137,111,129,232, 10,134,194, 94,143, 26,
110,126, 13, 75, 69, 71,104,140, 43,240, 64, 17, 42,233,178,100,140,249,151, 59,
213,170,211,201,161, 86, 47, 85,231, 32, 38, 33, 67,119, 20, 78,227, 90,239,102,
 42,143, 76, 67, 12,207,117, 94,249,146, 40,180, 73,134,155,212,  2, 66, 34,176,
 86,126,  8, 21,197,182,153, 91,112, 87,157,189,254,246,144,193,196,182, 52,140,
164,175,230, 32,159,144,161,  5, 59, 17,103,174,148,  1,237,245,107, 26,150,223,
 38,123, 98, 16,112,  6,128,237, 94, 99,119,167, 75,136, 99,170,229, 59, 13,192,
106,157,249,232,130,212,125,213, 12, 15,109,229,104,133,163,170, 13,191,248, 13,
 47,168, 20, 29,  2,210,124, 18,185, 20, 73,184,116, 52,227,250,233,234,113, 63,
202,224,  9, 48,163, 82,172, 73, 34,190,206, 83,  3,188, 44, 76,206,114,178, 36,
102, 48, 23, 92, 37, 68,244, 79,129,139, 74,220,242, 10,193,224,238,183, 36,185,
  8, 72,135,248,159, 50,191, 35,215,133,229, 76,  8,152,209,248,105,157,215,  9,
210,208,218,233,103, 38,185,209,130, 38,213,173,  6,253,131,255,254, 64,134,170,
191, 47,144,203,240,197,192, 11,123, 77, 78,174,193,168,245,155,234,208,127,142,
  3,135,118,123,104,221,148,224,  8,171,106, 82,244,146, 42,241,252,194, 54,153,
240,171,207,150,130,113,174, 35,137,169,155, 22,138,105, 84,226, 96,140, 19,184,
168, 30,141,144,231, 49,175,229,164,150, 53,224, 64, 14,147,  3, 26,113, 48,232,
 84,246, 23, 55, 80,187,237,126,192, 40, 85, 35,105,143,183, 46,183,237,116,240,
112,  5, 54,116,207, 64,111,135,174,136, 59,250,152,186, 44,248,148, 56,108,184,
237, 61,133,203,212,200, 51,  8,157,240, 97,154,247,135,152,219,248,253,130, 87,
231,217,212,254,135,154,160, 81, 54,103,143,250,246,194,222,247, 38,145,159, 77,
241, 29,164,100,228,112,220,236, 40, 81,226, 21,110,199,164,243,119,175, 58,245,
 65, 70,241, 46, 71,195,175,171,250,128,179, 86,139, 90, 13,103, 19,  5, 62,184,
 36,234,231, 12,212,114,129, 73,186,239, 69, 77,121,188, 12,195,132,104,186,144,
139,  7,232, 86, 32, 44,225,  8,211,137, 96,227, 57,157,120,230,145,243, 99,182,
206, 21,215,  1, 51,  4, 15,252,132, 26, 90, 73, 85, 73,242,173,202,206, 23,114,
 79,113, 48,197, 70,222,195,133, 47,199,219, 52,124, 37,238, 12, 36, 82, 65,210,
158,183,250, 34, 17,235, 84,165,246,176,204,164, 35, 97, 81, 10,  7,241, 41,154,
186,185, 18,123, 38,124, 78,216,139,225, 57,132,156,132,253, 43, 12, 24, 54,124,
 26,109,111, 98,155,139, 74,248,188, 89,254,139,222, 84,141,161,  1,201,163,208,
 24,243,135,  0, 47, 33, 83,166,137,141, 29,117,163, 79,121,199,141,171,141,172,
154, 67,190, 80,211,212,181,149,152,244, 86,168, 66,212,215, 57, 54,150, 57, 50,
113,108, 30,183,147,139,161,188,107,238, 88,156,121,111, 32,156, 26, 18, 15,218,
138, 17,243, 10,149,198, 17,147,138,107, 83, 53,207,106,130, 62,236,188, 52,196,
216, 31,183,118,138, 12, 75,197, 81, 59,  2,116, 16,125,189, 74, 45,123, 71,219,
225, 62, 30,217,132, 15,170,167, 67,203,123, 53, 29, 63,194,210,172, 38, 80, 21,
239,134,156, 14, 99,113,167,255, 11,  2, 16, 51, 78,224, 48,225,245,189, 42,187,
  2, 16, 99,139, 18,200,191,215, 72,212,152,124,106, 94, 18,114,142, 26,130,184,
 50,195, 82,125, 39,117, 15,193, 18,149, 64,175, 78, 70,152, 78,232, 11,133, 94,
234,114,135,103, 46,151, 58,156, 21, 38, 93,148, 26, 93, 92, 56,241,221,230, 88,
114,197,201,227,198,212, 18,193,105, 37, 66,203,129,149,  8,  7,192,133,181,218,
140,157,145, 91,235,183,171,154, 64,129,191, 33,130,220, 97,  5,153,160, 27, 43,
 35,202,197,  7, 29,219,231, 32, 36, 19,152,228,110,170,182, 73,177,200,101,166,
233, 90, 89, 43, 27, 73,102, 69,209,226, 10,  6,  3,206, 43, 27,208,167, 28,155,
 99, 48, 81, 82,119,122,213,132,116, 44, 88, 78,123, 56,248, 20,142,227,155,173,
 74, 68,  3,148, 96,100, 15,147,146,141, 48,105, 66,188,200,110,204,241,  7,  2,
 76,132, 22,196, 26,107,195, 77, 40,196,171,147,131, 74,113, 22,209,145,218,108,
154, 41,103,147, 29,254,253, 61,120,233,146,200, 77, 81,193,  2,208, 57, 92, 29,
141,195,  5, 96, 73,201, 93, 94, 32,124,164,172,119, 16,175, 44,223,126,169,153,
128, 46,154, 96, 94, 59,135, 79, 93,190,232,223,160, 29,220,195,195, 89,104,226,
227,204,243, 13, 58,197, 84, 14, 90, 16, 27,223,183, 81, 75,237,126, 89,127,105,
 58,242, 51,181,112,189, 59,239,245,  8,147,151,205, 16, 83, 47,241,236,141,240,
254,186,194,144,159, 75, 17,115,197,140,173, 98,  9,  2,111,146,215, 28,143,162,
160,194,190,177, 11,230,208,169, 55,102,113,150, 45, 76,156,164,  1, 53,224,197,
 82, 24, 16,120, 30,164,203,153,180,155, 94, 63,  4, 91, 52,216,142,102,167,108,
 84,212,132, 70,173,159,245,231, 33, 27,173, 66,186,194, 19,240, 67,204, 58, 84,
113, 46, 75,240,169,  1, 82,254,177,227, 12, 82,  3, 27,162, 38, 36,139, 91, 38,
108,222,216, 99, 95,  5,204,217,125, 11,104,254, 44, 95,241,205,148,252,  0,109,
 74,225, 46,174, 97, 70,120,151,228, 18,167, 37, 58,185, 18,227,148, 82,241, 23,
186,182, 16,147,146,171,  9,193,160,106, 88, 66,109,141, 69, 81, 74,253, 65, 19,
212, 50, 83, 84, 32,209,205,  3,216,104, 45,246,167, 14,147, 43,
} ;

// ../Source/Template/GB_concat_bitmap_bitmap.c:
uint8_t GB_JITpackage_81 [432] = {
 40,181, 47,253, 96,254,  2, 53, 13,  0, 38, 90, 80, 32,240, 24,231,240,113,107,
181,191, 37,164,147, 34,164, 20,115,105,245,243, 95,138, 33,166,120,242,191, 58,
197, 97,145,196, 83, 47, 72,  0, 72,  0, 69,  0, 95,188,150, 64, 24, 16,  4,198,
193,128,120, 54,177,107,184, 81,146,242, 66,188,202,203, 33,216,156,107,155,120,
153,120, 86,222,138,131,226, 43,237,134,230, 62,109,174, 84,223, 44,193, 48,215,
 62,253, 58,255,242,149,222, 97, 37,152, 59,212,101, 57,107, 56,187, 73,229,219,
118, 17,182, 45,141,199,179,148,  4,187,107,166,122,242,230,181, 85,149,216,164,
242,200,177, 72,210,235,229,218,197,231,218,207,184,134,243,255, 47,214,101, 40,
 32,  8,212,155,210,198, 59, 46,237, 81,231, 74, 69, 22,  2,197,149,206,190, 16,
 58,148, 76, 65, 68, 81,151, 98,170, 57,206, 30,169, 53,255,  2,172,193, 96, 85,
229, 33,143,246,143, 27, 30,121,180,216,255, 43,155,157,101,198, 24,253, 78, 34,
234, 77,252, 12,235,192, 83,253, 13, 71,255,232,247,201, 43,237, 45, 24, 94,130,
 36,121, 45, 32,218,231, 78,177,200,181, 67, 18, 66,124,228,161,248, 60,251,102,
 76,175,224,185, 11,215,213,186, 90,135, 16,151,133,184,187,120, 45,218,107,156,
197,238,201, 96,184,110, 82, 73, 69, 16,103, 63, 79,113,223,182,121,193, 57,174,
109,  9,213, 31, 60, 95,153,113,207, 71,206,245, 86,122,188,210, 15, 37, 31,120,
180,143,188,207,202, 64,209,126, 30,138,216, 71,253, 43, 41, 32, 96,100,198,208,
 14,249,192,214,176, 68, 68,155,238,196,220,118,190, 22, 27, 64, 60,169, 11,  2,
 11, 24,171,248, 78, 85,  8,158,128,219, 61, 98, 12,250,131,149,112,107, 20,140,
 91, 18,229, 97,110, 48,127,  1,109, 19,154, 64,209, 10,231, 72,135,170,221,118,
 92, 26,185,247, 15, 97, 55,104,106,158,153,210,  6,202,106,253,  3, 50,214, 33,
 50,216, 88,  0,167, 12, 76,207,152,162, 96,  8,
} ;

// ../Source/Template/GB_concat_bitmap_full.c:
uint8_t GB_JITpackage_82 [401] = {
 40,181, 47,253, 96,138,  2, 61, 12,  0,246, 87, 74, 33,  0,151,115, 22,190, 38,
235,218,246,129,244,186,203, 44, 29,116, 84, 31, 58,169, 15, 47, 41, 62, 98,237,
179,255,255,123,127,  8,  1, 64,  0, 66,  0, 63,  0, 24,166,164,142,156, 16,111,
234,242,231,209,204, 49, 76,164, 64,186,219,160,132, 49, 49,216, 23, 51, 51, 13,
 49, 85,137,130,185,189,191,255,101, 75, 63, 43,205,127,223,206, 51,106, 13, 65,
220,109, 47, 83, 15,151, 91,218, 79,114, 16,201, 53,173,202, 52, 45,159,158, 96,
151, 45, 23,159, 45,125,198,246,147,255, 95,161,170,  2,225,144,205, 78,246,141,
103,128,147,130,104,182,243, 51,201, 38,182, 83, 82, 74,166,137, 88,  8,159, 73,
  2, 39,158,151,227,220,133,232,229,181,198, 99,136, 67,225,144, 45, 12,133,195,
 47,105, 61, 47,252,241,120,173,255,213, 37,105,238,140,173, 89,195,207,236, 36,
254,101,113, 94,104, 15,126,160,215, 89,107,131,125,127,189,239,237,133, 26,188,
128,120,159,185,132, 34, 91,218,248, 85,106,143, 59, 54,178, 97, 39,143,157,108,
 91, 16,201, 31,199,  1, 85,149,170, 82,  6,207,118,125,152,114,241, 88,188,199,
182,107,125, 99,169,108,157, 24, 59,219,229,188,180, 93,211,228,  5,223, 54,122,
 69, 36,250,193, 51,216, 25, 83,249,199, 55,170,137, 26,183,179,146,250,129,199,
233, 81,131,193,201,246, 29,143,247,141, 38, 32,112, 38, 32,202,243,121, 22,129,
  4, 43,217,120,176,  0,196, 23,187,197,  8,116,184,214,  1, 67, 90,172, 36,211,
 25, 92,193,  1,189, 95,199,192,136, 35,159, 88, 71,  8, 91,217,176, 25, 98,190,
  5, 20, 33,230,111, 17,209,236,168,137,142, 54, 35,251,253, 99,176, 27, 52, 55,
207, 76,109,227,236,106,125,  3,226,222,224, 23,214, 24,128, 63, 14, 67, 81,224,
  6,
} ;

// ../Source/Template/GB_concat_bitmap_sparse.c:
uint8_t GB_JITpackage_83 [717] = {
 40,181, 47,253, 96, 35,  6, 29, 22,  0,214, 98,107, 32,224, 28, 23,  3, 24,151,
 69,201,197,185, 35, 73,201,157,162,130,246,  0,119,100,178,249, 21,177,195,187,
 19, 49, 70,230, 24,227, 98,  0,100,  0, 97,  0,  3,171,177, 13,175,102, 32,154,
120,  8,162,117,149, 86, 91,240,122,143,168, 11,158, 36,231,187,  4,194,128, 24,
 48, 14,  6,196,185,112,123,167,175,171, 78, 78,152,135,141,155,181,186,160,119,
159,169,145,140,185,150,149,143,221,183,245,209, 94,183,220,117,245,215,179, 54,
190,183,228,221,127, 61,182,111, 88, 93,214,172,105,174,171,125, 77,116,215, 16,
179, 66, 42,169,188, 80,208,  6,133, 66, 31, 78, 36,237, 72, 99, 24, 79, 52,159,
133, 67,167,227, 90,165,107,167,197,106,203,113, 99, 58,127,186, 34,182,158,142,
199,226,171,209, 76,250,125, 32,  5,183, 28,231, 54, 85, 44, 54,190,239, 80,248,
134,151,212, 84,101,233,220,254,129, 83,227,125, 19,154,  1,191,144,230,227,128,
 95,134,130, 46,152,147, 21, 79, 23,240,255,154, 38,211, 12,  4,196,192,142, 97,
205,243,141,210,222,211,221,216,138,151, 91, 87,210,241, 18,233,118, 82,200,183,
 46,239, 73,117, 77, 38, 16, 60, 28, 55, 28,178,113,225,221,117,235,205,146, 45,
209,142,161, 62,183,209, 85, 11,191,100,157, 78, 90,146,172,101,205,207, 43,214,
235, 10, 85,203, 44,222,125,239, 56,102,200,243,252, 14,111,185,181, 45,  3,223,
 26,179,194,119,161,117,225,200, 96, 94,240,119,135,119, 25,176, 19,162,162, 11,
  8,154, 27,250,121, 23, 77,154, 54,155,105,179,131,201, 59,199,210,215,203,219,
 71,158,142,247, 42,121, 47,239,133,194,189,  0,242,153, 73,191,127, 56,126,200,
103,158,108, 46, 31, 58, 55,149,  9,122,184,131,160,227,234,179,167,187,214,189,
 19,177,125, 55,243,246,233,161,160,175,130, 45, 25,184,119,169,151, 83, 23,124,
151,117,107, 87,232, 57,206,169,222,141,115,251,164, 22,200, 83,143,171,238,120,
 37, 31,121,168, 49, 45,132,  2, 27, 25,145,180, 32, 41,181,  6, 64,132,144, 98,
118,117,  2,217, 36, 21,177, 44, 21, 16,145,161,  0,149,164,124,237,103,  3,192,
164, 33, 39,233,202,148,194,233,150,  7,227,145,105,109, 65,232,122,249,185, 60,
 47,238,109,253, 49,158,234,155,208,173,118, 90,237,202, 55,105,154,238, 67, 86,
200,179,177, 76, 98,201,208,163,148, 49,104, 17, 49, 18,214, 86, 55, 36, 82,123,
 17, 93,130, 35,112, 62, 55,191,129, 38,146,232,216,130,233,106,185,131,150,221,
200,  1,104, 38, 44,118,157,217,161,112,227,221, 40, 60, 91,253,150, 83, 32, 93,
227,164, 81,133,216,242,102,169,171,  7, 75, 91,253,  0, 55, 74,192,102,160, 65,
136,114, 69, 75,112, 65, 70,218, 88,149, 12,177,151, 97, 50, 42, 39,190,  6,135,
148,219, 35,101, 86,221,139, 31,204, 28, 93, 10,201,151, 44,204,  6, 33,148,191,
128,232, 71,130, 54,255, 22, 38, 23, 61,182,224,165, 16,121,  0, 58, 90,242,234,
164, 97,241,215,191,101, 49,202,111,249, 99,214,209,179, 82, 29, 68,214,155,169,
221, 44, 83,162,139,149, 96,161, 24,227, 83,183, 32, 58,104,162, 85, 96,218, 74,
201,  0, 45, 10,255,240, 56, 69,167, 64,251,186, 12,243,122,112, 76,
} ;

// ../Source/Template/GB_concat_bitmap_template.c:
uint8_t GB_JITpackage_84 [586] = {
 40,181, 47,253, 96, 64,  7,  5, 18,  0,182, 89, 81, 32,240, 88, 55,208, 69,138,
162, 47,207,144,131, 73, 49, 47, 49, 84,161, 40,212, 33, 68,125,249, 62, 43, 63,
136,195, 34,193,162, 66, 69,  0, 72,  0, 73,  0, 93,200,246, 68, 41,109,152,173,
  2, 95, 12,237,214,133,208,220, 76,192,145,146,151,135,103,146,142, 33,127, 91,
134,174,148, 37,159,134,221,180,197,199,182,253,218,111,218,254, 20,123, 63,252,
233, 29, 67,127,110,164,225,219,142,123, 90,177, 88,185,201,165,179,236,194,178,
 44, 26,110,195,100, 62,247, 62, 27,152, 14,126,123,152,182,214,239,165,238,238,
190, 46,214,117, 48, 36, 48,  7, 43, 29,103, 63, 72,183,159,125,236, 30,  6,243,
140,189,218, 13, 54,162,124, 12,158,159, 72,207, 14,234,252, 96,201,130,250,222,
217,  5, 69,226,144,192, 26,136, 67,162,  7, 85, 16, 14, 77,211, 82,  3, 65, 71,
 58, 53,251,171, 37, 63, 59, 73,232,202,135,180,109, 83,235,120, 52, 14,127,214,
195, 87, 20, 59,207,215,  3,180,  9,145, 94, 97,170, 85,236, 23, 34,193,102, 71,
 58,180,222,137,246,115, 11,198, 99,219,159, 61, 33, 12, 55,197,108,185,217,142,
237,166,210,  1, 85,  2,215, 44,  3,215,213, 34,125, 84,129, 77,138,253,183,164,
159,123,144, 54, 81, 39,187,206, 89,214,143,158,164, 46,237,153,214,193, 96, 10,
 90,245, 22,172,111, 81,185,149, 61,127, 38,103,195, 76,174,  3,170,225,222,242,
  3,180,123,229,173,120, 35,178,112, 44, 77, 53,138, 21,210, 93,247, 92,107,160,
241,169,161,161,161, 73, 81, 81, 10,173,  1, 80,132,204,212, 25, 55,181,  4, 81,
  6,189,145, 66,146, 57, 73, 14, 25,200, 36,119,176, 33,239,128,225, 59,120, 54,
 57,198,249,209, 28, 52,194, 50,135,194,158,146, 99, 19,151,132,217,214, 97, 33,
163,194,226, 27, 92, 89,250,105, 62,102,142,209, 96,220,194, 93, 69,229, 66,  5,
158,110, 35,200, 87,145,115, 95, 44,208,103,201, 93,140, 96,212, 29,251, 35, 58,
  9,172,144,114,116,157, 26,204,  7,197, 52, 70,188,  0, 28,211,209,  4,  8,175,
160, 56,146,166,211,104,251,166,135, 18, 10, 18,255, 57,100,252,225,225,220,134,
  7,224,201,226,176,102,214,197,  8, 67,127,172,131,128,182,  9,216,104,232,112,
132,160,108, 88, 61,183, 37,182, 96,  6, 11,252, 88,  1, 45,219, 82, 22,232, 24,
229,135,241,117, 83,230, 24,143,158, 21,  1,112,225,193, 54,134, 28,251, 90,163,
  5,161, 69,255,234, 99, 87,250,160,229,159,249,130, 80,245,226,195, 66,161,168,
177,148, 89, 36,  7,244, 28, 52, 25,149,153,210, 55, 92,177,107,134, 36,206,112,
250,126,248,138, 22, 39,
} ;

// ../Source/Template/GB_concat_full_template.c:
uint8_t GB_JITpackage_85 [561] = {
 40,181, 47,253, 96,179,  4, 61, 17,  0,134,221, 90, 32,240,218,230,224, 56,132,
148,154,154,216,142,137,118,121,144, 25, 12, 16,180,167, 14, 39,  9,240,  9,167,
 56, 44, 98,161,149, 10, 82,  0, 78,  0, 81,  0,161, 83, 26,111,104, 48, 20,140,
  3,100,161, 96,124,192,  9,110,192,147, 37, 47, 71,196,187,190, 28,130,115,116,
131, 40,118, 44,159,149, 55, 19,105,124,165, 21,117,158, 43, 81,214,154, 55, 75,
 48,204,117,190,233,204,191,124,103, 89,251,145,206,146, 90,176,243, 70,233,202,
219,178,228,106,200,109,150,204, 19,137,236,144, 72,  4,156,109,164,217,120,221,
121, 19, 16,251,203,185, 83,255,255, 44,131,101,120,245, 28,214,227,249, 46,252,
114,131,199,243,203, 55,132,120,190,175,124,124, 87,229,181,123,154, 76,129, 96,
 28,250,227,164,141,143,220,158,222,204,181, 59,205,161,113,109,110,118, 14,164,
 11,  8,209, 53,235, 54,238,208,113,254, 82, 51,222,105, 83, 42,175,180,183, 96,
120,  9,166,228,181,209,106,154,166,181,  6,130, 83,222,138,207,220,188, 25,247,
 37, 28,  3, 42,141, 50,111,118,149,134, 33,170, 49,109,128,198,201, 19, 40,127,
 85,112,118,146,202, 33,158,242,218,148, 37,159, 55,199, 35,215,249,140, 63, 34,
205, 22, 67, 60,183,248,174,179,131,241,132, 48,  1, 89,230,117, 87, 87,128, 44,
139,101,177,129, 33,218, 27, 52, 43,120,  9,244, 57,197,147,102, 77,137,  4,119,
 66,225,218,180, 42,214,124,225,249,202,140, 39,119,202,181,153, 80,201,  7, 40,
159,135, 21, 10, 19,201, 21,167, 60, 90,193,128,155, 89,102, 44,104,186,234,250,
227,240,  7,117,139,  2,220,201,190, 95,222,192, 85,253, 13,  3, 80, 32,112, 68,
134,206,234,  1,226, 28, 64,100,192, 44,219, 11,100,150,207, 65,137,178, 37, 36,
186, 15,235,188, 65,178,  8, 48,172, 30,112,163, 89, 71, 98,146, 24, 95,192, 17,
122, 89,231,192,196,167,101,  2,199,131, 53,  8, 99, 32, 52,108, 14,209,239,144,
218, 94, 48,235,168,  2, 36, 21,194,141, 76, 34, 39,141,124, 25, 63,196,198, 81,
152,132, 16,111,159, 16, 52,224,232, 92,194,192,118,205,129, 63,214,123,127,  3,
 50, 34,132,158,  1,126, 30, 36,106,168, 15,155,207,196,218, 26,209, 25,169,192,
  0, 26,230,192, 95,197,221,117,178,192,187,122,124, 61, 37,  0,216, 12, 10,147,
 80,194, 14,224,240,208,141,150,120, 80, 38,106, 25,200,  6,144,167,213,181,108,
154, 29,194, 76,235,224, 96, 13,190, 41, 50,212, 71,224,139,151,196,156,162, 96,
  8,
} ;

// ../Source/Template/GB_concat_sparse_template.c:
uint8_t GB_JITpackage_86 [1015] = {
 40,181, 47,253, 96, 35, 13,109, 31,  0,166, 44,133, 39,224,178, 86,  7,228,235,
235, 61,178,179, 77,125,124,249,229,130, 91,145,  3,119,239,157,115,174,103, 65,
181,177, 13, 68,249,136,151, 38,204, 16, 37,198,132,123,  0,120,  0,119,  0, 52,
132,221,246, 27, 99,156,168, 66,185, 76, 24,171, 32,109, 63,168,220, 87, 95,201,
 86,102,194, 86,114,213, 18, 19,140,  5, 13,197,226,142,202,150, 45,110, 47,230,
105,139,199,216, 62, 13, 92, 42,151,137,129,165,114,121,164,146, 62,217,238,128,
 11,167,180,135,176, 59, 63,205,249,180,105, 18, 10, 24,133,213,225, 96,195,183,
 65,155,232,163,235,133,159, 31,126, 94,217,231,216,247,240,124,161,228, 31,240,
133,145,126,248, 62,182, 21, 82,251, 46,172,228,172,158,130,195,  5,  4,162,137,
128, 64,153,147, 28, 59, 96, 55,134, 81,234,244, 62,130,130, 43, 91,130,129,194,
130, 33,226,113, 50, 16, 87, 91,146,  1,156,115,238, 17,230, 31,  9,147,246,136,
116,234, 31,237,183,234,122, 45,215,128, 51,104, 50, 56,175, 93,203,105,142,162,
194,189,138, 77,230, 98, 75, 94, 13,224,126,217,243,255,143, 34,144, 40,162,112,
101,236, 22, 55,157, 21, 87,120,203,160,  8, 59,110, 73,248,169, 77, 43, 25,187,
159,166,109,247, 43,243, 83, 40,252,220,222,248,157,242, 83,140,160,235,117,126,
170, 28,183, 36, 79,141,222, 54,118, 35, 28,211,129,212, 94,231,173,184,227,216,
205,174, 73,251, 58,135,198, 47,158,163,145,236, 19,214,164,183,247,160,224,112,
234, 28,  8,207,142,249, 59, 26,212, 65, 36, 18,  4,204, 43,167,164, 72,213, 23,
 94, 43,113,  4, 89,140, 85,246, 17,201, 90,144, 43,118,223,  7, 36, 95,231,245,
200, 49,194, 10,233,233,103, 30,126, 60,176, 82,171,239, 93,232,242,128, 10,175,
165, 54,179,240,202,215, 46,129,209, 35,251,101,252,184,234,104,219,187,182,246,
 21, 81,  3,  1, 76,219,175, 57, 42, 61, 67, 83,209,218,135,235,174, 78,189,227,
220, 68,226, 28,237, 52,170,241,110,157,105,137,  4,  1, 67,189,209,133,137,204,
230,181,  9,135,102,161,153,148, 66, 75, 36,179, 92,251, 74,126,  5, 74,192,200,
 54,114, 72,199, 34,153, 44, 84, 58, 69,102, 34,243, 78,157, 98,177,244,136, 17,
246,198, 67, 81,206,135,224,231,152,134,131, 68,168,103,210,175,182, 72, 44, 19,
213, 84, 58,153,198,105,133, 78, 27,225, 47,104,227, 83,163,239,178, 39,180,113,
150,211,186,133,152,128,203,168, 33, 61,135, 12,205,136,140,164, 36, 73,210, 26,
 64,132, 24, 83,101, 85,  7, 66,240, 52, 16,161, 32,  5, 13, 17, 32, 42, 16,  9,
 68, 36, 16,  9, 38, 16, 17, 81, 80, 78,118, 23,139,112,  6, 97,187,168,196,175,
 87,224, 75,218, 81,175,152, 10,188,202,195, 97,141, 41,202,174,214,234,239, 78,
249,  1,235, 66,227,169,217, 70,224,145, 40,114,186,236, 22, 24, 93, 72, 71,237,
 85,250, 61,145,200, 80,111,235,208,169,131, 92, 28, 25,  4,224,155,183, 65,250,
 71,127,222, 77,254,229,248, 75,219, 98, 67,144,247, 57,244,148, 56, 35,168, 16,
156,235,243, 32,253,181,177, 19,186, 44, 59,227,116,167, 48, 94,190, 87, 56,235,
187,113,124,237,157,205, 65,222,223,193,254, 74,248,159, 24, 81,142, 93,182,  8,
 48,126,191,195, 65,208,195, 40, 91, 20,140,208, 36,  5,115,210,112,  5,140,186,
207,136, 99,223, 67,240,126,226,141, 53,253,114, 89,130, 45,112, 76, 19,154,177,
 77,154, 77,117, 22, 25,191,136,  0,214, 32,107, 74,237, 19,164,122,239,130, 67,
 25,  2, 72,202,129,135,213, 39,145,158, 64,242, 60,134,168,102, 48,111,161,198,
239,121, 88,232, 78, 10, 82,208, 23,181,150, 88,128,133,122, 58,111, 12, 49,175,
 33,178, 83, 49,180,160, 79,167,205,  9,164, 15,208, 55, 84,117,165, 22,255,144,
137, 64, 92,  3,  1, 13,105,116, 59,177,193, 59,144, 82, 32,135, 17, 90, 35,219,
 61, 82, 28, 73,144,138,187,216, 58,253,133,100,185,165,129, 22,153,242,222,232,
  5,232,229, 69, 54, 82,179,207,144,214, 15,  3,208,215, 85,101, 15,101,138,162,
 46,145,229,178,126, 56,240, 95,131, 48,110,226, 91,213, 90,134,  5,238, 89,131,
 81,213,224,217, 20, 23,199,131,140,236,234,245,250, 26,241,118, 45,238,  5, 84,
 70, 93,198,139,208,123,187, 17,186,205,  7, 56, 71,215,185,121, 83, 84,232, 24,
 95,241,169,100, 31, 54, 64,110, 87,226, 73,202,211,206,109,233,  7,128,131,152,
 26,102,162,100,106,219,185,169, 14,  9, 28,232,182,217, 52,169,106, 48,205,117,
 93,111,150,130,107,186,157, 35,250, 47,186,175, 52,208,  4,
} ;

// ../Source/Template/GB_convert_s2b_nozombies.c:
uint8_t GB_JITpackage_87 [709] = {
 40,181, 47,253, 96,117,  7,221, 21,  0,102, 98,101, 32,240, 24,231,208, 90,236,
139,181, 45, 17,235,197,206, 46, 48,183, 86, 94, 12,189, 95, 68, 14,150, 66,112,
192, 51, 48,105, 17, 94, 97,  0, 87,  0, 92,  0,181, 55,138, 33,120, 38,154,  2,
215,225,109,220,155,227,220,145,232,230,158, 39, 31, 21,137, 67,130,208, 64, 28,
 18, 15,108,216, 35,166,225,156,188, 32,175,234, 50,248,209,206, 35, 71, 98, 34,
157,157,183,226,224,116,166, 39,206,101,231,151,169,232, 96,126,227, 59, 45,254,
  7,222,209,229,239,192, 77, 69, 31,184,  2,171, 38, 74, 96, 45,223, 14, 43,184,
105,145,202, 13,134,139, 96, 48,  4, 94,123,222,188,211,222,126,224,231, 71,154,
215,  2,178,115, 52, 63, 87, 26, 56, 88,177, 27,254,255, 98, 93, 87, 33,207,239,
130,163,207,231,218,184,175,237, 27,229,241,124,126,127, 19,191,187,252, 14,103,
119,145, 60, 87,231, 81, 93, 83,242, 47,220,182,170,238, 23,196,244,242, 58, 20,
 18,132,238,182,105,229, 29,183,233,136,230,218,220,133,208, 56,177,147,216,165,
102,137, 84, 14,121,233,152,118,249, 42,209, 43,120,174,243,188,109,193,119,160,
 20, 29,152,252,  8,124,230, 42, 29,253,113,211,179, 63,227,233,101, 15,129,222,
 27,245,176,212, 32,207,248,210,145,233, 89, 91, 48,  6,  3,108,194,243,143,236,
135, 67, 48, 68,220,232, 55,171,138,195,218, 59,113,221,109,248,129,170, 73, 12,
115,179,111,151,181,239, 84, 31,215,213,186, 90,  8,145, 12,196, 71,236, 31, 77,
 70,  2,121,  8,212,219,244,236,113,166, 29,130, 95, 54, 56,181,217,169,164, 33,
 11,122, 74,190, 79,222, 12, 31,233, 83,205, 85,122, 60, 59,138,201, 63,110,159,
221,102,175,237,133,243,130,151, 14,169, 52,135, 16,131,144,  9,116, 43, 31,227,
175, 24,185,218,143,249,206,140, 53,105, 53, 90,135, 82,201, 30, 48, 61,123,168,
193,161, 82,136, 40, 16,145,130,146, 36, 73,107, 48,132, 24, 83,117,230,  1,162,
  8, 61,204,148,  8,  9,148, 64, 80, 32, 34, 21,148,148,255,187,  3,153,  9,101,
115,212,219, 42, 32,102, 14,118,117,136,254, 19, 36,202,220,150,238,190, 94, 81,
 80,140,  5,171,194, 16,164,208,202,187,152, 80, 54,186, 18,241,100,173, 94, 84,
 59, 23, 65, 54, 29,188,253,249,184,186,144,156, 51, 86,248,223, 29, 84, 55, 80,
  6, 50,226, 98,205,226,  3,121, 64,  8,173,254,173,243,117, 92,133,247, 82,138,
 63,207, 21,232,179, 73,  5,  5, 85,246,139,183, 74,144, 25,  8,232,149,184, 51,
 59,223,140,169,235,209,160, 44, 76,157,117, 47,158, 81,103,237,157, 63, 58,165,
157,209, 25, 78,118,118, 61,123, 33, 86,207,215,244,217, 81,148, 38,208,230,242,
134,146, 72,177, 44,193,168, 76,242, 57,108,224,160, 24, 48, 95,184,227,174, 22,
111,102, 26, 95,249,135, 65, 73,247,136,109, 60,183, 30, 11, 51,237, 92, 23,147,
 34,254,218,114,126,219,223,121, 97, 57,125,166, 40,  8,187, 31, 26,170,133,207,
 40,117,134, 72,  3, 26, 64, 46,  5,192, 36,128,164,188,172, 36,178,232, 31, 98,
238, 38,243, 62,123,249, 37,  8, 28,213,124,211,188,212, 96, 82,148,107, 75,208,
 33,143, 56, 41, 85,233, 53, 12,240,
} ;

// ../Source/Template/GB_convert_s2b_template.c:
uint8_t GB_JITpackage_88 [550] = {
 40,181, 47,253, 96,120,  6,229, 16,  0, 22,155, 83, 32,224, 26,231,148,119,132,
182,223,245,238,121,217,178,100, 28,104,133,255,172,116,101,107,172, 15,195, 57,
131, 25,  6,193,188, 23, 76,  0, 70,  0, 73,  0,243,  6,133,134,208,176, 70,  2,
161,125,192,  9,110,192, 53, 69, 39,207,230, 89, 95, 22,195, 26,186,  1, 52, 53,
146,111,164,183,226,  0,117,174, 40,144, 28,105,152,107,233, 98,126,227, 75, 71,
252, 80,188,222,231,239,232, 76,193, 49,236,188,149, 52,188,229,219, 41, 43,114,
155,164,242,195, 65, 98,135, 67,184,239,216,215, 48,143,233,243, 59,164,248,253,
229,119,138,126, 47,205,119,150, 94,213,118, 53,255,236,246,200,250,126, 69, 92,
 63, 37, 34,211,176,254, 56, 58,206, 59,110, 87,175,102,219,221,  5,107,108,155,
171, 26, 76, 52,241,100, 93,167,110,227,254, 28,231,207, 84, 63,  7,193, 91,232,
130, 57,120,181,179, 29,216, 86, 95, 13,  4,171,193, 41,158, 81,104,155,130,119,
109,171,215,221,189, 26,120,216,  6, 83,180,214,239,123,124,140, 96,243,144,143,
243,153,171, 55,227,190,132,231,109,193,200,182, 62,227,249,220,166,255,191,148,
 46, 41,179, 76,195, 43,122,167,207,182,  3, 82,122,221, 89, 84, 64,202,215,235,
 31, 32, 30,185, 21,220,171,162,109, 12,246, 11,192,101,184,107, 41, 20, 91,128,
119,135,  2, 57, 11,162, 92, 36,155, 14,105,  3, 77,139,118,194,165, 25,143,248,
132,105,182,  5, 10, 62,110,178,117, 59,245,214, 92,  5,241,220, 50,190,213, 59,
185, 52, 20,206,135,146,  9, 83,160, 97,185, 49,166, 42, 24,153,  9, 75,138,218,
106, 80, 70, 32,133,144,232,  1,174,185,105,150,184,218, 72,178, 76,216, 14, 29,
 34,232, 74, 28, 82, 56,122,  8,  3,103,  4, 86, 46,196, 80, 85,148,244, 77,231,
 42,120,108,233,187,222,  4,224,  6,107, 36,  8,214,223,218,232, 27,130, 59,191,
168, 33, 41, 49, 16,196,130, 55, 19,232, 25, 28, 66,217,130,192, 17, 23,157,100,
 55, 27,182,150, 65, 56,  8,255,  7, 58, 95,208, 90, 18,108, 47,238,123,201,224,
222,153,  1,204,211,  7,250,250, 16,182,101,239,101,235,147,119,181,247,141,  2,
134,201, 77, 55, 48,184,112,100, 45, 64,122, 86,119, 73,  7,252,231,161,226,  1,
 67, 88, 20,191,184,171,172,252,161,  8,234, 46, 49,139,129,230, 31,156,233, 70,
162, 85,207,  8,146,124,108,156, 39,196,166,249,252,193,116, 43,151, 66, 68,  3,
 34,135, 12,249, 50,110, 82, 20,220,  1,
} ;

// ../Source/Template/GB_convert_s2b_zombies.c:
uint8_t GB_JITpackage_89 [738] = {
 40,181, 47,253, 96,213,  7,197, 22,  0,118, 99,105, 32,224, 26,231,148,119,132,
 76,207,234,246, 76,236, 36,105, 59,154, 22, 69,107, 45, 81, 73,139,143,120, 78,
196, 24, 41, 50, 56,  4,100,  0, 90,  0, 96,  0,253, 97, 10,141,107,123, 52, 83,
  0, 81, 56,134,175, 87,183,113,119,142, 51,120,162,157,135,161,252,182, 80, 32,
 20,  5, 71,  2,161,184,192,211,190, 97,186,154,148, 27,228, 93, 96, 30, 69,250,
249,230,145, 25,  9,104,231,181, 60, 60,157,169,202,147,217, 41,102, 90,250,152,
223,248, 78,139, 47,142,215,116,249, 63,112,211,146, 56,190,186,146,  2,119,249,
246,170,142, 94, 39,177,252,112,200, 10,135, 67, 96,238, 68, 85,125,216, 97, 56,
239,180,183,226,248, 41,158,230,181,  1,238, 31,205,207,149, 10, 14,102,202,210,
126,248,255, 44,131,101,153, 33, 79,241,142,166,207,231,218,184,175,237,187,201,
227,249,252, 22, 39,126,131,249,189,154,224, 75,242, 95,157,103,117,109,201,223,
112,219,186,192,223, 17,211,203, 12, 97, 80, 20, 26,244,166,149,127,220,166, 38,
154,107,156,238, 83,177,112, 23,164,190,129, 82,187,236, 46, 18,203, 35, 71, 29,
 83, 48,223, 85,122, 29,255,117,158,183,237,248, 22,160,182,135, 38,111, 26,159,
191, 74, 77,135, 60,117,238,207,120,134,220, 73,163,183, 71, 67, 44,187,200, 51,
190,212,148,122,238, 24, 13, 24,129,128, 83,120, 30,194, 29,241,136,150,216, 60,
 42,206,234,250,180, 14, 85, 95,131, 30,190,160,118, 82,195,223,236, 27, 89, 22,
203, 98,137,146, 20,108,223,180,135, 56,155, 73,228,164, 81,123, 51,180,199,153,
246,106, 20,  9,167, 23, 80,237, 21,140, 68,179, 17,117, 30, 12, 64,187,137, 59,
149,148,100, 71,111,201,183, 42,156,171,111,244,173,254, 42, 61,158, 32,213, 36,
228,246,220, 45,247,218,225,106,126,112,212, 35,149,102, 82,130, 64, 74,141,110,
229,183,237,217,182,125,181,191,229, 59, 51,238,164, 13,128,129,168,177,157, 82,
136, 72, 68, 68, 97, 73,146,164, 53, 32,132, 24,195,212,153,  7,178,216, 60,  9,
134,200,  8, 24, 33, 82, 32, 37, 18,145,242,191,119, 41,180,156,133,174, 59, 25,
191, 51, 64,137,115,251,105, 15, 65,107,129,151,163,111,128,237, 77, 31,206,132,
139,189, 40,176, 42, 45,153,165, 81,232,243,139, 18, 79, 75, 81, 62,160, 60,251,
 60, 50,127, 87, 14, 55, 66,144, 43,  5,136,210, 12,126,195,243,173, 97, 93, 64,
205,197, 42, 64, 71,203, 48, 80, 14,131,225,102,206,198, 18,160,128, 72, 89,253,
 27,246,245,174, 34,190, 90,251,231, 89, 81, 31,  4,165,206, 14,229,248, 39,154,
138,  5, 51,200,211,203,113,191,118, 38,142,160,235,173,157,108,189,206,103, 47,
230,227,177, 45,158,107,157,114,249,120, 21, 39, 78,187,234, 94, 58,246,165,107,
 64,224, 40, 77, 23,232,231,194, 36,165, 75, 17,149, 96,160,153,248,179,216,128,
 96, 47,128,190,144,232,213, 44,144, 58, 19,205, 92, 22,249, 37,142,193,111,100,
245,  0, 50,164,114,111,150,180,243,120, 75,129, 54,249,130, 23,214,205,231, 70,
 77,252,252,152, 86,196,123,199,170,109, 48,250,  0,100, 18, 88,  0,245,  3,164,
 20,195,152,197,131,254,169,230,205,100,  7,205,162,126,145, 25, 28,  6,103,211,
236,213, 96,162,203,101, 66, 38, 68,254,224, 40, 80,197, 87,  7,184,  3,
} ;

// ../Source/Template/GB_coverage.h:
uint8_t GB_JITpackage_90 [241] = {
 40,181, 47,253, 96, 36,  1, 61,  7,  0, 66,142, 46, 21, 32,223,161,167,221,197,
173,152,155,244,117,174,169, 93, 51,240, 19, 66, 32, 51, 52,  0,160,250,244,237,
 16, 47, 73,254, 77,166,249,175,231,175,220,191,221,  1,  4, 65,146,133,143, 19,
103, 74,172,241, 95,159,254, 57,226, 61,165, 91,244,237,175, 87,123, 26,  0,153,
121, 97,211,119,137, 93,165,246,244, 85,125,  0, 32,134, 82,116, 22, 61,227,137,
 63,114,247,170,255,111, 79,181,162,207,111, 71,253, 86,140,150,103,164,189,150,
251,220, 63, 62,127,118,245, 31,111,219,137, 19,139,130, 40,133,147, 32, 10, 31,
 80,129, 19,179,175, 79,139, 27, 19,191,217, 15,187, 62,228,  4, 56,109, 20, 27,
159, 50,246,244, 89, 62, 99,176,127, 79,131, 64,200, 95,207,231, 63,247,207,185,
 12,171,252, 97,141,190,158,114,175, 97,212,164, 48,126, 28, 64,113, 28,  1, 15,
  0, 88,  0,131,169,193,205,174,156,183,217, 78,197, 66,197,  2, 57, 18,162,136,
221,131,230,207, 51, 83,180,  9,108, 53, 15, 24,148,217,  4,243, 76, 66, 40, 10,
220,
} ;

// ../Source/Template/GB_defaults.h:
uint8_t GB_JITpackage_91 [412] = {
 40,181, 47,253, 96,226,  2,149, 12,  0,182, 25, 80, 31,  0,183, 58, 39,127,117,
183,143, 17, 36,162, 88,107, 94, 62, 86, 73, 46,128,127, 11, 24, 79,204, 56, 12,
253,255,187, 63,188, 72,  0, 69,  0, 71,  0,155,131, 96,227,132, 67,134,101,214,
194,128,101, 23,112,129, 19, 42,151, 36,228, 87,227,168,175, 41,137, 57, 39,104,
141,139,227, 11,165, 56, 97,108, 21,101,168,109,243,168, 85, 85, 52,185,123,235,
197,237, 37, 73, 81,134, 63,227,187,106,131,163,244,182,219, 28,147, 23, 10,149,
 85, 40,  4,178,116,143,190,231,246,164,220,247,235,215,173,251,113, 38,229, 14,
105,181,147,  1, 21,101,211, 56,151, 78, 67, 18,129,120,219, 77,143,  1, 21,118,
101,214,126,156, 12, 27,103,136,203, 30,247,220,174, 98,109,157,203,241,197,250,
 64, 52, 87,183, 37,113,235,110, 94,251, 19,113,255, 56,185,223, 18,139, 78, 64,
133,  4,137, 76,129, 93, 88,224,148,  7,167,226,209,182, 77, 68,  3,162, 92,130,
141,246,  8,220, 68,197,163, 66,175,252,150, 36,145,122, 87,111,221, 50,131,205,
113,154,156,246,107,143,225,228, 87,249,110,235,184,161, 79,201,189,229,215,175,
 59,130,  1, 85,229,113, 55, 23, 80, 85,138, 68,118, 78,  5, 83,217, 38,152, 10,
  4, 19,209,212,  5,195,177, 47,154,220,205, 13, 61,250, 77,113, 61, 40,185,121,
 50, 34,195, 12,  3,132,194,130,233, 80, 30,180, 59,237,143, 68,106,170,205,115,
188,  5,161,120, 87,185,224, 91,190,147, 43,126, 29, 28, 32, 48, 66, 66,  4, 44,
125, 77,172, 84,104, 21,  5,239,211,166, 93, 24,149,168,125, 19,194, 84,247,160,
 77,164, 91,243,134, 90,192, 57,105,104,220,  8,144, 37,227,145,155,135,182, 71,
176, 77,216,141, 88,161, 44, 39,145,213, 13, 32, 69, 17,152, 65,243, 60, 51,209,
 38,112,181, 60,160, 17,123,119,131,162,192, 13,
} ;

// ../Source/Template/GB_dev.h:
uint8_t GB_JITpackage_92 [395] = {
 40,181, 47,253, 96, 84,  3, 13, 12,  0,246,215, 72, 31, 16,147,117,155, 25, 37,
 40,215, 65,196, 21,194,221, 34,211, 96, 88, 66, 12, 89, 66,117,  5,223,153,205,
  8,  0, 40,  0, 84, 65,  0, 66,  0, 59,  0,137, 19,172,193, 11,182,181, 71, 93,
106,124,187, 46,197, 26,243,194,165, 49,113, 92,159, 87, 33, 19,219,250, 62, 23,
190,157, 93,220,157,140,125,168,100,141,225, 25, 82,235,149,198,219, 73,251,246,
236,200,240,211, 37,105, 12, 57, 14,200, 13,  6, 23, 25, 12,  1,240, 91,245,201,
118,102,223,203,246,142,  3, 46,194,209, 60,168,200,112,198, 14,184,131,148,136,
248,178,222,167,241,169,114,199,190,147,161, 36, 98, 59,217,234, 73,180,161, 42,
 18,100,173,178,101,203,237,189, 58,109,185,148,141, 23, 20,137, 67, 34, 90, 32,
 14,  1,  1,  1,223,119,237,249,186,231, 74, 35, 87,191, 54,243, 92,  0,201, 56,
  4,135,240, 61,210,179,236,120,150,157,217,246,175,147, 85, 76,125,210,207,154,
221,211,155,209, 67,198,168,117,174, 14,101, 70, 47,123, 41,223, 11, 87,102, 47,
114,206,197,134,147,  3,206, 85, 40, 25,138,242,160,176,245,234,253, 86, 41,198,
216,217,210,106,171,172,253, 17, 54, 57,105, 51, 64, 84,218,111,144,217, 10,177,
148, 13,250, 96,226,217,242,182,175,251,153, 73, 41,  0, 92,146,  3,  2, 56,195,
 76, 90,179,  3, 33, 32, 64, 66, 98, 16,195, 30,  5, 33,102, 33,171, 58, 32,208,
 44,130,228, 64, 21,233, 98,102,238,181, 24,227, 19,101,230,131,158,138,  9,132,
169,144,172,209,235, 90,223,  0,224, 41,136,129, 12,212,209,249,219,150, 46, 93,
139,196, 57, 26, 86,171,236,139, 57, 13,177,  8,198,201,104, 86,104, 35,181,213,
 12,154,206, 51, 19,109,  3,175,246, 46, 16, 90, 20,117,110,
} ;

// ../Source/Template/GB_ek_slice_kernels.h:
uint8_t GB_JITpackage_93 [1313] = {
 40,181, 47,253, 96,239, 27,189, 40,  0,118, 49,149, 40,192,208,170, 14,184,214,
177,207, 95, 46, 96, 16,145, 13, 74,104,186,118, 29,237, 42, 20,184,140,168, 31,
234,158,146,239, 37, 73, 46,192,178,  8,  2,  0, 83,205,139,  0,130,  0,147,  0,
 18, 67,220,100,216,131,  6,107,136,216,  5,147,109, 98,  3,198,245, 86,185,233,
144, 38, 17, 11,210,157, 38,191,235,148,219,147,155,185,246,134,129, 52,174, 25,
164,147,144,137,108, 29,186,141, 91,115,156,187,139,169, 57,165,215,161,128, 53,
177, 32,  5,213,196, 58,165, 77,135,120,134,100,194, 35,215, 71, 93,182,159,201,
 57,220, 92, 25, 66,247,201,187, 64,105,124,229,183,233, 60, 65, 27,  9, 67,126,
 46,207,217,227,107,179,214,161,111, 85, 30,247,188,185,246,187,203, 63,165,139,
 96,218,245,182, 23, 91,155, 20, 71,175, 35,194,194, 37, 18,  9, 34,145,  4,212,
 52,157,242,234,  7,167, 42,106,106, 76,123,163,242,234,150, 83, 19, 53,185,197,
242,233,156,134, 68, 73, 24,242, 19, 59, 13,244, 57,158, 25,203,166,207,242,157,
 38,251, 29,154, 23,208,171,160, 78,179, 27,149,217,102,239, 90,209,155,122, 64,
118, 59,140,183,191,216,212, 53, 85,184,209,238, 98, 70,149,207,113,128,160,206,
172, 29,214,199,115,157, 25,244,101,144,189, 68,242,255,210, 36,109,211,134,104,
157,215,102,150, 25, 95,203,189, 49,232, 54,127,147,125,187,236,248,220,206,189,
157,130, 61, 44,115,149,186, 78, 71,220, 41,151, 76, 76,120,184,226,149,137, 28,
108,129,130,175, 92,235, 80, 53,128, 88,238, 93, 81,229,214, 35,230, 43, 51,254,
  2, 36,189, 37,102,124, 39,231, 61, 50,174, 86, 59,236,108, 76,104, 32, 28, 48,
135,168,  0, 17, 57, 17, 16, 17,225, 46, 76,175, 23,148,251, 86,158,101, 87,196,
 48,141,130,228,241,209,181,159,254, 60, 36,215, 56,149,101, 17, 15,220,132, 85,
192, 67,224,240, 12,155,136, 76,108,208, 96, 18,135,135,241, 14,199, 59, 19,192,
244, 10, 12,216,153, 26, 52, 16, 18,241,237,249,136,202,103, 12,162, 23,117,226,
203, 14, 70,195,185, 28, 54,168,170,115,193,  7,140,  3,230,241,146,196,205,173,
182, 67,170, 70,158, 87,251, 89,155, 43,220,119,230,218,183,190,137,204, 36,173,
184, 88, 84,  1,191,  5,197,111,185,136, 82, 57, 61, 31,209,106, 63,146,159, 87,
174,160, 65,121,151,239,167,172, 47,126, 23,  8, 33,244,224, 54, 51,188,124,112,
171, 13,227,245, 77,218,101,186, 85,  5, 84,149, 83,181,105, 72, 30,122,135,223,
 53,253,138, 25, 74,135,172, 71,102,143,253,251,202, 91, 31,172,190,195,201,215,
137, 14,237,213,176,140,140, 60,223, 58,203,219,181, 47,222,183, 69,239,142,115,
161, 60, 72,153,174, 43,191,173,206,129, 41,168,177, 41, 67, 51, 51, 34,146,164,
 32, 41, 12,107, 97, 16, 66,144,210, 82, 66, 61,162,104, 84, 20,163, 64,  2,136,
 70,  8, 33,196, 16, 39, 64,134, 16,  9, 68, 34, 17, 17,137,132,100,166,195,  1,
103, 11, 32,186,118,108,137, 30, 64,181,204,162, 55,  2, 23,162, 64,160,  2,101,
121,129,188,135,129, 24, 26, 72,171,184,134, 80,245,240, 44,162,244, 27,192, 28,
236,186, 45, 68,  9,204,  8, 42, 10,117, 28,244, 18, 69, 71,198, 12, 48,130,161,
230,177, 67, 92,125, 61,208,190,130,158,183, 66,  0,243, 35,188,201,168,237,211,
 81, 22, 12,119,101,105,130, 55,234,108, 35, 81,246, 37,180, 70, 41, 14, 85, 17,
 12, 32, 82, 81,194,168,160, 37,170,159,240,162,141,248, 13, 37, 52,122,145, 98,
205,170,213,179,151,153, 59,  6, 18, 87, 85,129,174,229, 70,137,140, 91,151, 83,
 57,210,213,226,231,204,  0, 61, 18,212, 80,137,233, 42,249,199,214,137,138, 96,
 21,102,211, 33,211,239,109, 29, 21,139,  7,173,201,  3, 92,194, 86, 29,208,113,
103, 52, 44,171,172, 40, 64, 73,174, 41,183, 17,184, 43, 94,  0, 61,129,243, 87,
 10,  3, 55,141,242,180,212,234, 32,110,131,164, 40,239,144,160,209, 97,  1,117,
 10, 71,140,189, 64,162,174,248,170, 86,  6,  7,219,243,189,140, 45,  6,170,222,
191, 86,111, 72,187,193, 85,243, 35,145,227, 31, 62,105,231,249,137, 92,  0,  4,
 28, 30, 48,165,152,171,168,135,207, 49, 15,100, 24,214, 77,126, 74, 78,239, 46,
 56,185, 63,175, 43,  8, 32,108,210,182, 35,152,107, 50, 47,164,110,217,118,135,
 26,173,201,101,252, 94, 32,  0,198,240, 79,178,126, 13, 20,  6, 59, 13, 51, 39,
189, 54,129, 27,253,220,194,217,188,240, 89,  3, 25, 81, 62,144, 10,154,186,177,
200, 88,155,118,184, 59,228, 55,220, 91,221,187, 31, 70,253, 35,  4, 51,166, 36,
118,124,  5,178,193,  8,106,149,223, 36,147, 98,112, 15, 90,145,196,158,184,120,
 52,197, 26,161, 70,135, 22,170,  1,218, 16, 65,236, 30,109,238,245, 74,181,144,
 64,127,224, 79,139,102, 88, 41,109, 20,152,121, 51,249, 55, 45, 70,221,155, 72,
  1, 12,140,139, 13,106,192,128,223,202,221,202,190, 88,108,  6,197, 68,143,204,
 65,109,216,102, 49,163,159,213,139, 96, 44, 20,221, 19,222,215,134, 99,150, 68,
 93,198, 73, 54,134,  2, 24,200,108,228,174,197,167,192,213,115,147, 36, 64,  9,
236,249, 29,137,119, 53, 92,143,166, 97,162,243,127,136, 53, 31,178, 40,240, 77,
150,142, 98,148, 25,217,248,138,241,161, 89,246,111,  4, 98,160, 15,234,  2, 64,
119, 44,160, 43,117, 85, 77,209,179, 36,136, 69,158, 17, 21,158, 57, 49,126,157,
132, 91,235,234,133,228,208,126,180,106,188,229, 70,241, 38, 42,107,170,250,151,
 66, 56,213, 62,176, 86,101,  1,229,230, 91,182, 23,149,249,  4,222, 79,150,111,
 18,241,197,136,220,200,163,110, 41, 32, 73,151,185,139, 90, 33,  3, 37,124, 95,
 41, 12,246,180, 32,143,224,130, 12, 55, 15,102,165,207,231, 91,112,155, 21,198,
114, 29,239,180,134,202,145,  7, 20,109, 96, 14, 77,236,183, 98,157,153,252, 51,
 74,219, 49, 43, 12, 56,173, 78,110,124, 21,  6, 78,
} ;

// ../Source/Template/GB_emult_02_template.c:
uint8_t GB_JITpackage_94 [813] = {
 40,181, 47,253, 96,108, 11, 29, 25,  0,118,226,107, 33,240, 88, 55,172, 23,242,
240,156, 43, 19, 73,155,178,241,156,116, 67,186,162,  1, 77,125, 13,140, 94,128,
 82,100, 19, 65, 19, 26,  2, 98,  0, 93,  0,100,  0,123, 44, 93,144,147, 36,117,
140,177, 72, 44,178,135, 34,177,240, 66, 72,112, 76, 95,148,181,184, 70,125, 53,
110,179,188,158, 99, 29,229,212,241,180, 25, 19,233,126,223, 83,119,145,228, 73,
 68,156,182,220, 23,172, 78,194,214,243,159,171, 17,241, 58,219, 83,187,190, 78,
 29,255,152,242,106,208,168, 83,124,243,200,111, 75,158,229,239,111,145,248, 54,
121, 42,255,171, 24, 71, 32,174, 12,129,  8,121,235,207,  6,223, 95,195,177,241,
245,173,177, 25,110,213, 49,234,251, 75,238,238,126, 93,172,235,210, 48,215,184,
108, 58,166, 63,159, 38,109, 75, 55, 59,174,173,127, 62,237,240,148,183,246,213,
190, 95, 90,237, 63,110, 31,247, 77, 57,182, 93,  9,109,145,253, 24,218,147,122,
 36,255, 21,239,198, 79,202,100,175,241,135,151,147,137, 44, 31,141,244,168,252,
250, 65,174,  3,212, 69,211, 31,155,133,193,128,  0, 40,108,  4,247, 64,151,174,
163, 30, 39,196, 93, 62,241,146,112,173, 18,210, 52,193,215,228,215,234,233, 50,
 31, 53,245,125,124, 57,151, 14,232,178,249,188,140, 70,124,146,120,  5, 11, 55,
100,187,245,169, 77,218,110,124,176,164,169,132,239,103,250,239,195, 75,106,250,
109,157,175,104,  2, 43, 89,  5, 43, 68,130,159, 68,221, 59,142, 18, 63, 43,217,
 73,125,135, 55,215,213,114,247, 66, 37, 56,166,192,225,132, 58, 78,161, 56, 71,
112,241,134,159, 45,231, 18,176, 21,  8, 53, 27,240, 39,157,200, 16,127,198, 40,
231,101,234,199,242,116, 42,156, 96,178,121, 54, 41,155,183,133, 64, 94,247,225,
 60,219,183,233, 40,119,150,102,248,153,180,229,238, 61,207,109,219,182, 90,107,
149,184,170, 64, 80, 93, 62, 35,111,220, 38,246,125,  2, 29,243,  7, 29,219,208,
171,103,211,  3,128,162,160, 49, 73,164,148, 76, 48,163, 32, 73, 10, 10,133,225,
 96, 68,132,172,108,117, 27,  9, 71,139, 96, 90,136, 38,223,128,144,205,212,241,
 40,212,128, 54, 91,244,209,248,  5,  6,212,  1,216,241,227, 40,140, 56,248,183,
145,141,215, 48, 78,143, 32,151,156,166,141, 44, 35,130,  0,215,210, 46,198, 65,
109,100,144, 40, 41, 12,176,145,195, 30,136, 21,136, 30, 32,148, 23, 59,228,160,
245, 67, 10, 17,243,141, 97,163, 30, 88,130,228,147, 32,129,229, 15, 97, 42,242,
244,131,192, 12, 80,231, 54,  3,253, 50,  3,187,221,118,104,172,109,120,198,118,
 14, 23, 34, 97,196,  4, 45, 47,  4, 33, 77,225,  8,  4, 40,162,210,224,208, 60,
 15,110,  0,147, 66, 24,100,249,132,205,141,  9, 40,144,113,110, 34,141,160, 50,
 94,128, 37, 19,128,112, 65, 52,102,243, 82,  4, 68,120,147,104,240,172, 54,134,
  1, 70, 68,124, 18,143, 96, 98, 67,111,107,111, 18, 20,145, 12, 82,176,  6,142,
 58, 27,210,159,136,155,145,195,129,195,238, 44,158, 23,215, 45,235,128,160,132,
108, 60,154, 68,230,200, 24, 35, 56,231, 65, 70,135,159, 96,100,115,196,225,158,
142,  6,136,  9, 64, 13, 86,126,115,164, 80,168, 39,136, 17, 44,229,175, 78,222,
 36,  7,244,162,234,217,122,198,110, 64, 56,163,131,112,223,108,128,  0,184,209,
 12,232, 51,218,214,116,  4,219, 31,134,143, 13, 51, 86,139,110, 47, 22, 61, 97,
125, 53,178,191, 49,148, 51, 54,215,140,206,106,159,175,190,183,224, 91, 36, 91,
 41, 35,100,111,236,190, 17,252,180,113,146,183,100,211,196,252,193,132, 86,255,
 10, 35,  4,130,139,134,210,231, 87, 85, 20,140,  1,
} ;

// ../Source/Template/GB_emult_02a.c:
uint8_t GB_JITpackage_95 [723] = {
 40,181, 47,253, 96,167,  6, 77, 22,  0,134, 99,108, 33,224, 26, 29,  3,144,186,
 96,130, 62,240,135, 92, 91,132, 77, 96,109, 15,214,118, 93,117,137,212,134,207,
107, 96,134, 97, 24, 47,  4,100,  0, 95,  0, 97,  0,215, 66,  0, 69, 52,133,207,
170,178,213,118,115,189,193,210,221, 60, 12,231,165, 34,113, 72, 16, 26,136, 67,
226,154,151, 93,234,171,170,145, 23,230, 91,224, 70,137,183,115,201,153, 22, 14,
196, 53, 79, 28, 28,187,111,138,131,225, 42,238, 59,226,254,141,245,217,226, 22,
104,176, 58, 87,172,175,239,231, 71, 11,174,206,  9, 10,243,219,187, 59,106,226,
 64,119,152, 18, 45,229, 38, 55, 24, 48,130,193, 16, 84, 76,141,207, 40,210, 67,
 27,134, 53, 87,124, 44,162, 94,197, 82,205, 56,240,248,119,247,247,120,109,222,
186, 59,180,154, 37, 62, 20,184,237,229,255,143, 97, 46, 12, 43,200, 61, 90,109,
 51, 62,233, 42, 30,133,185,174,183, 57,181,189, 84,222,250,173,125,173, 88,245,
 45,184, 15,238,187,186,236,176, 67, 33, 65,176,160, 87,241,188, 35,219, 75,186,
123,180, 95,133, 96,245,104,189, 82,118,223,104,233,196,151, 19,103,239, 52, 52,
130,153,116,106,104, 71, 50, 25,109,168,186,224,166, 92,183,166, 28,126, 92, 59,
 93,130, 51,251,164, 20,110,242,237, 38,200, 79,127,252, 91,215,240,113, 81,232,
214,187,161,158,116,251,214,249,146, 78,223,116,193,112, 13,  6,250,144,199, 15,
223, 50, 13, 33,189, 43,214,177,245,101, 54, 76,125, 22,244,244,181,145,206, 76,
127,213,102,112,  7, 24,246,194, 94,131, 65,135, 73, 55,112,121, 89, 93,118, 77,
 70,194,169,124, 36, 28, 55, 66,233, 75,231, 37,107, 94,154,110,205, 62, 37,155,
105,233, 36, 17,218,177,120, 46, 18,154,225, 84, 72,246, 27, 73, 55,176, 93,212,
117,220,  5,  5,205, 36,111,102, 83,227,221, 35,202,187, 38,226, 70, 28, 32, 59,
233,126,176,125,226,208,239,252,246,123,200, 39,254,227, 29, 98, 32, 53,172,161,
184,187,196,199,164, 12,117,160, 81, 41, 67,  6, 13,201,136,136, 36, 73, 65, 33,
 29, 32,134, 24,228,216,213,  1, 25,129,210,  0,209,221,169,230,251, 23, 72,244,
 79,112, 83, 65,130,221,164, 33, 41, 20, 92,219,132,128, 72, 52, 54, 48, 25,192,
  3,110, 21,124, 33,164,192, 96,104,244,145,  8,109,  2,147, 17,249,228,132,112,
  7, 90,199, 95,180,229,220, 57, 60,216, 50,233,175,118, 26,181,  4, 99,194, 29,
  0,249,137,178,140,112, 96, 76,152, 48, 13,117,136, 18, 21,186,154,201,234, 10,
180,197,132,155,150,208,255,209,221,112, 26,240, 79,153, 98, 38,236,186,240,160,
109,225,165,181, 33,212, 68,163, 95,254,202,176,181, 77,234, 81,101, 16,118,182,
 12, 56,203,  6, 75,227,208, 14,  5, 70,163,148,230,236,115,237,155, 30,249,100,
191, 25,  1,154,  5,124, 11, 93,186, 22, 75, 92,251, 20,229,227,214, 88,177,220,
 99,152,  0, 68,230, 31,152,101,141,156,240, 73,195,203,192,121, 99,203,222, 54,
 24,215, 30, 50,185,124,152,221,143,228, 42, 87,111, 65,168, 82, 72,  7,162, 16,
137, 66,166, 37,116,168, 35,137,  0,201,156,100,132,244, 70,233,203,128, 38, 70,
137,182,201,155, 38,134, 10,166, 91,213, 45, 44,  4,209, 43,138,207,101, 88,149,
162,128,  9,
} ;

// ../Source/Template/GB_emult_02b.c:
uint8_t GB_JITpackage_96 [679] = {
 40,181, 47,253, 96, 36,  6,237, 20,  0,198, 32,100, 32,224, 88,231,168, 27, 52,
  3,181, 19,212, 42, 51,  3,100, 80,118,234,119, 79,160,117,168,147,149,197,187,
 26, 49, 70,226, 12,227, 92,  0, 88,  0, 88,  0,168,219,184, 53,199, 57, 28, 89,
205, 69,145,126, 38, 16,  6,196,128,113, 48, 32,158,121,216, 39,182,168, 10, 57,
129,126, 21,102,211,104, 57,159, 27, 90,225,194,178, 94, 73, 99,211,217,158, 54,
151, 40,158, 64,238, 31, 89,127,187, 92,133,133,198,183,150,248,216,158,158,236,
 48,117, 46, 64,160,223,254,120, 67,132, 48,116, 89, 60,141,221,113,146, 23, 10,
215,160, 80,  8,166,215,113, 84,111,  9,208,254,217,252, 76,218,190,219,227,141,
 76,132, 33, 62, 83,152,219,242,255,191, 46,214,117, 17,102, 38, 27,247, 45, 75,
184,142, 55, 93,142,235,251,158,178,119,186, 25,127,149,109,143, 21,191,195,252,
 48,219,212,231,227, 50, 16, 16,131, 14,189, 90,210, 55,110, 91,208,102,178, 63,
202,160, 49,217,158,173, 12, 62,144, 12,225,235,168,  7, 78,186, 53,227,142, 43,
181,103,165,207,144, 98,167,221,132,147,124, 59,201,241,210,181, 63,227, 42,106,
 15,129,222,158, 21, 49,237,182,103,124, 45, 88,122,238, 20, 11,150, 64,128,239,
208,110,248,134,101,135,233,217,177,146,171, 15,107,241,244,117,232,225,103,100,
 71, 49,252,213,190, 97,238,198, 19,249,107,  2, 47,182, 40,214, 91,203,151, 99,
215,213,186, 90,160,  5,124,218,  7,246, 12, 38,178,161,120, 34, 28, 39, 50, 97,
219,169,232, 39,201, 86,236, 52,162,161,149, 71,  4,210,113, 42, 29, 75,164,195,
108, 40, 36,104,  1, 95,147, 22,236,239, 43,177,126,211,110, 47,216, 78, 75,208,
173,229, 30, 32,208,111,207, 72,211, 98,119, 92,251, 65, 48,179, 50, 51,231,156,
 31,217, 29, 45, 63,105,153,233, 56, 17,  9,217, 98,113,160,145,169, 51, 67, 34,
 66,162, 32, 73, 82, 74,  7, 32, 68, 96, 16,131,103,  7,169,129,118, 11,221,177,
241,  0,132,242,  5, 55, 16, 68, 60,168, 25, 16,190,  2,  5,  1, 97,224,192,206,
  4,  9, 96,113,161,180,235,  5,128,248,193,248, 24,204, 22,219, 28,233, 80,206,
128, 13,214, 19, 24,244, 77,  4, 37, 46,113, 97,118,181,208,159, 74,221, 20,225,
241,233, 57,242,214, 31, 76,194, 42,118, 53,111,113,126, 86,  8,207, 68,194,174,
 67,161,160,120,  4,217,  6,  5, 61,186,208, 20, 89,149, 25,242,196, 30, 63, 76,
 22, 26,  8, 40, 38, 26,153, 28,161, 69,  8,248,100,180,116,134, 54,  0, 33, 15,
 78, 35, 96, 13,  9,186,150, 64, 77,178,229,213, 39, 61,250,201,190, 25, 13,135,
  1, 72, 54,180,184,168, 22,116,237,115, 52,223, 93,199,250, 36,188,198, 15, 76,
150, 61, 34, 25,183,187,224,211,  6, 38, 11,224, 69, 40,191,111, 51,183,214, 50,
183, 82,184,238,199,178,202,245, 83, 16,170, 18, 18,135, 36,124, 80,113,133,116,
  2,229, 35,242,142,159, 68, 18, 82,250,  2,242,101,152,146,  3, 66,222,190, 77,
243,161,130,233, 86,225,139,148,  6,230,147, 33,121, 57, 87,165, 40,192,  3,
} ;

// ../Source/Template/GB_emult_02c.c:
uint8_t GB_JITpackage_97 [862] = {
 40,181, 47,253, 96,252,  7,165, 26,  0,230,103,123, 41,208,208, 58,  7,120,178,
  4, 77, 37, 80,196, 89, 88, 54,203,209, 29,206,141,174,206, 51,178,195,217,134,
176, 82, 51, 67, 38, 95,234,246,  1, 95, 60, 48, 75, 47,  1,113,  0,108,  0,110,
  0, 96,107,149, 35,137,200,116, 38, 91,103,220,198,237,112,156, 59,139,234,112,
207,147,143,  3,150,138, 69, 98, 32, 80,177,156,210,166, 71, 92, 51,104,230, 19,
249, 81,151,195,175,126, 30, 61,146,115,117,150,222,205,197,211,185,134, 60,146,
231,133, 56,138,165, 95,174,160,247,165,191,190,129,244,217,171,219,118,212, 81,
 26, 95,106,241,113,189, 60,216,157,198, 47,200, 68, 90,  8,217,  3,131,253,162,
 89, 42, 51,123,161,175,231,181, 57,133, 34, 73, 40,148,249, 21,130, 36,127,207,
179, 55, 42,166, 68,212, 52,253,114, 14,231,129,225,  9,167, 38,  6,166,217, 36,
210,116, 36, 62, 51,171, 14, 66,144,100,183, 14,202,158,181,122, 51,238, 11,249,
243, 60,200, 96,125,198, 96,168, 69,203, 22,118,185,179,255,191, 36,113, 72, 82,
252, 36,147,199,244,125, 67, 89, 11,221,140, 63,202,181, 63,138,223, 93,126,151,
171,198, 35, 38, 85, 38, 22, 73,119, 26,181,242,151,219,149,171, 25,236,109, 65,
210, 56, 96, 79,105, 31,165,157,142,117,102,134, 65, 78,217,153, 31,205,  6,108,
 47,227,144, 95, 92,154,241,188,108,117, 10,227,177,147,211,229, 84,176,126,129,
169, 78,189,234, 20, 19,111,173,122, 88, 78,235, 25,223,202, 97, 60, 79,130,  2,
142, 72,  4, 31, 83,189,114,107,162,  4,162, 86, 63, 10,142,182,169,189,208,214,
157,134, 79,129, 83, 78,120,163,125,187, 60,191, 16,248, 27,114,247,218,243,232,
165,246,246, 11, 79, 63, 11,122,237, 99,171,  1,146,212, 33,117, 68, 34, 24, 87,
 31,143, 85,132, 77,239, 52,104, 60, 11, 16,154,235,  2,133,184, 78, 41, 31,169,
198, 65,114, 48, 77,102,126, 56, 15,153,102, 54,120, 22,184,222, 64,174, 62,172,
 83, 96,216,117,200, 36,214, 73,123,  5, 21, 69, 31,143,196,  2,  2,158, 77,175,
223,189, 48,  4,117,  8,172,153,162, 34,232,154,126,205,235,218,  0, 76,231,234,
 35,214,165,157,120,149,183, 94,143,121,117, 76, 32, 18, 41,219,153, 22,123,180,
151, 98,140, 17,219,  2,128,156,168, 97, 49,100,102, 68, 70,164, 32, 41, 72,161,
208, 24, 32,134, 24, 83,118,230,  1,162,113, 48, 71, 17,195,140, 50,  2,195,  8,
149,204,132, 37, 73,253,227,  1,153, 66,185, 49, 54,155, 73,201,154,148, 10, 58,
 22,228, 10,189,221, 92, 78,182,226,209,173, 89,232,176, 49, 84,160,111, 54,216,
207,224,156, 71,139, 38,227,195,215,100,  6,106,180,207,204, 17,173, 55, 62,234,
 96, 91, 36,244,233,223,124,103,158, 82,222, 70,230,132,121,182, 32, 98, 20,170,
209,163, 23, 85,233,127, 83,102,108, 44,109,209,230, 42,113,240,193,112,209,170,
204,216, 95,201, 48,254,179,103,131,126,164,139,116, 10,159,214,101,175,128,229,
 14,194,109,235,160,132,244, 93, 94,178,186, 71, 16, 38,242,232,146,150,252,159,
127,236,201,230,191,165,170,  3,177,113, 33,214,140,121,180, 45,126,179,133,234,
253, 59,216,149, 60, 37, 85,115,176, 81,114,202,210,222,109, 65, 92, 11,180, 57,
106,186,217, 87,105,216,176,233,229, 71,226, 55, 39,131,  0,218, 65,128, 80,143,
215,179,212,218,109, 55,200,  5, 22, 77,138, 52, 14,182,228,185,238, 49, 38,147,
 59, 44,164, 55,  5,243, 62,148,184,182,165,123, 11, 25,209, 20, 30,169,141,  2,
 90,152,202,143, 84,  2, 22, 45,100, 27,107,106,246, 36, 87,169, 82, 79,249,  3,
137,110,190,128, 10,240, 22,188,  2,221,123,118,164,161, 42,208, 70, 28,122,233,
117,164, 84,136,156,242,104,127, 42,241,253, 18,132, 26,176,254,  9,154,195, 79,
201,155, 64,208,155,166,250,131,  9,172,  6, 67,136, 12,110, 28,228, 79, 41, 13,
 52,  1,
} ;

// ../Source/Template/GB_emult_03_template.c:
uint8_t GB_JITpackage_98 [813] = {
 40,181, 47,253, 96,114, 11, 29, 25,  0,230,162,108, 33,240, 88, 55,172, 23,242,
240,156, 43, 19, 73,155,178,241,156,116, 67,186,162,  1, 77,125, 13,140, 94,128,
 82,100, 19, 65, 19, 26,  2, 99,  0, 94,  0,101,  0,174,247, 88,186, 32, 39, 73,
234, 24, 99,145, 88,100, 15, 69, 98,225,133,144,224,152,190, 40,107,113,141,250,
106,220,102,121, 61,199, 58,202,169,227,105, 51, 38,210,253,190,167,238,202,127,
174, 70,196,235,108, 79, 93,157,132,173,147,228, 73, 68,156,182,220, 23,116,125,
157, 58,254, 49,229,213,160, 81,167,248,230,145,223,150, 60,203,223, 31, 35,241,
109,242, 84,254, 87, 49,142, 64, 92, 25,  2, 17,121,235,207,  6,223, 95,195,177,
241,245,173,177, 25,110,213, 49,234,251, 75,238,238,126, 93,172,235,210, 48,215,
184,108, 58,166, 63,159, 38,109, 75, 55, 59,238, 90,117,109,253,243,105,135,167,
188,181,175,246,253,210,106,255,113,251,184,111,202,177,237, 74,104,139,236,199,
208,158,212, 35,249,175,120, 55,126, 82, 38,123,141, 63,188,156, 76,100,249,104,
164, 71,229,215, 15, 10,143,205,194, 96, 64,  0, 20, 54,130,123,160, 75,215, 81,
143, 19,226, 46,159,120, 73,184, 86,  9,105,154,224,107,242,107,245,116,153,143,
154,250,126,212, 31, 95,206,165,  3,186,108, 62, 47,163, 17,159, 36, 94,193,194,
 13,217,110,125,106,147,182, 27, 31, 44,105, 42,225,251,153,254,251,240,146,186,
126, 91,231, 43,154,192, 74, 70, 65, 10,145,224, 39, 81,247,142,163,196,207, 74,
 86,157,226,103,245, 29,222,215,213,114,247,  2, 37,120,197, 20, 56,156, 80,199,
 41, 20,231,  8, 46,222,240,179,117,202,129,173, 64,168,217,128, 63,233, 68,134,
248, 51, 70, 57, 47, 83, 63,150,167, 83,225,  4,147,141,178,121, 91,  8,228,117,
 31,206,179,125,155,142,114,103,105,134,159, 73, 91,238,222,243,220,182,109,171,
181, 86, 85,129,160,186,124, 70,222,184, 77,236,251,  4, 58,230, 15, 58,182,161,
 87,207,166, 83, 23, 77, 15,128,162,160,113, 73,154,154,  9, 50, 74,146,146, 74,
134,  3, 96, 68,132,140,110,117, 33,  9,167,151, 96, 42,137, 38,111, 64,206,102,
218,241, 22,112, 64,157, 45,247,104,188, 12,246,168,131,224,195,239, 40,155, 48,
 20, 56, 68, 13, 56,  6,119,108, 60,234, 18, 33, 85,133,230, 12,130,161,149,109,
236, 65,141,  8, 64,136,148, 14,208, 20, 14,147, 17,203, 66,158, 29,148,139, 17,
224,186,209, 67, 22, 34,134,219,135,198, 57,186, 83, 42,214,167,228, 73,144,117,
185, 71,184, 10, 63,217,200,153, 65,212,121,205,160, 95,108, 96,135,219,132,198,
181, 13,102,204,222,225, 35, 16, 47,240,109,184,160,101, 80, 16,210,196,142, 35,
111, 25,149,134,140,246, 50, 88,131,152,  0,231,144,209,  7, 60, 39, 46,208,128,
134,115,137, 16, 50,149, 81, 65,150, 77,  8,226,  5,208,152,221,139, 17, 18,185,
185, 39,102, 52,176,112,107,200,128,240, 32, 46,137,135, 49, 95,188, 71,139,111,
  4,138,216, 12, 34, 64,  3,227,142, 14,171, 39,233,230,224,121,120,220, 51,157,
211,201,117,123,  5,224,168,161, 26,140,145,153, 61, 40,202,  8,142,108,172,241,
160, 83, 76,109,152,248,238,193,209,  1, 53,120,249, 77,151, 66,193, 60, 39,186,
 98,  9, 59, 96,  2, 77, 34,208, 23,173,206, 45,207,214,  9, 15,125,244,  0,252,
155,  8,188,193, 24, 76,128, 63,168,111,205, 70,176,253,101,232,184,176,100,171,
226, 30,176,125, 53, 98,  0, 96,148,179, 55,215,136,198,106, 74, 93,253, 57,204,
111,149,182, 94, 22,120,240, 11, 84,226,144,230, 91,189,105, 98,254, 96,242, 86,
213,229, 40,129,235,162, 33,234,248, 85, 41, 10,242,
} ;

// ../Source/Template/GB_emult_03a.c:
uint8_t GB_JITpackage_99 [724] = {
 40,181, 47,253, 96,167,  6, 85, 22,  0, 22,229,112, 40,208,208, 88,  7, 52,156,
 65,253,142, 54,163,159, 33,135, 69, 99,186, 29,  2, 37,103,215,112,170, 39,133,
 38,102,158,108,158,  3,250,131, 43, 60,210, 65,252,  2,104,  0, 97,  0,100,  0,
 10, 15,182,147,173,198, 60, 36, 42,153,233,226,139,202,150, 29,110,111,102,209,
 14,215,180,119, 71, 32,137, 72, 30,  7,  3, 17,201, 37, 43,186,179,125, 33, 43,
159,222, 63,217,237,108,253,112,167,121, 24,152, 81, 89, 47, 19, 13,223,246,104,
160,202,244,147, 65,216, 86, 73, 45,252, 53,229,169,220,110, 87,220,246,223, 39,
103, 24,135,  2,211, 59,245,234, 19, 73, 16,137, 87,243,108, 28,225,229, 16,  8,
244,128, 64,  2, 17, 70,246,146, 92,179, 27, 55,207,124,237, 96,215, 88,211,100,
149,244,116,235, 92,110, 22,178,210,  0,202,175,190,191,179,185, 82,213, 39,146,
140,  8,174, 78,118,121,225,255, 15, 65, 26, 16, 52,185, 59,217,114,165, 28, 43,
183,119, 24,254,  9,222,202,115,245, 92,203, 83,175,253,231, 54,111,210,158,179,
251,236, 54,198, 93,  5, 69, 38,201,131, 51, 75,210,247, 73,229,198,250, 78,190,
  2,180,186,163,135,156,115,174,162,119,215,228,  8,233, 29,164,209,171, 76,172,
 48,188,248, 50,241,193,114,137,240, 50, 89,187,184,192, 55, 85, 94, 27, 31,165,
 92,226,220,101, 48, 58,140,  9,240,114,234, 27,132,115, 78, 57,245, 95, 43, 53,
202, 41, 38,206, 86,107, 22, 70,234,215,214,198, 56,191,177,192, 64,195,225,176,
 71,160, 60,114, 42,146,  6,156,213,155,156,159, 43, 98,205,115,113,102,217, 75,
 51, 16,180,  1,109, 56, 28, 21,214,215,228,128,187,206,168,162,103, 26, 44, 26,
133,  8, 11,132, 21, 29,219,241,221, 61,122,151,241,238, 54, 45,163, 63,139,195,
195, 84,150, 74,124,192, 64, 44, 88, 98,131, 70,  1,227,107, 98, 29, 64,157,162,
170,224,  5,166,119,234,210,198,117,196,158,217,119,118,172, 75, 20,143, 78,188,
226,  1, 68,199,250, 14,234,144, 78,188,225,169,247, 17, 14,233, 41,175,  6, 28,
 78,162,153, 24,109,160,145,169, 82, 68,134,100, 68,130,180, 32, 37, 73,  7, 32,
134, 24,196,236,186,  1, 25,  1,165,177,241,187,214, 74, 30,161,255,130,219, 10,
 10,108,147,  6,228,210,112,101, 19,  4,  2, 97, 80,  0,103,  0, 14,216, 50,120,
193,201,129,134,141, 34,180,101, 76, 70,228,147,211,132, 59,120,244,127,162, 88,
230, 78,217,131, 71,121,158, 70, 90, 35, 51,241, 87,138,101,135,  5,123, 42,132,
111,212,121, 52, 73,217,197,108, 22, 87,216,144, 89,103,154,  5,255, 65,161,225,
 36,224,191,  2,197,204,176,243,194, 75,211,202, 99,195, 86,208,136, 22,253,250,
 55,203,158, 86,169, 87,149,  1,216,153, 50,160,133,229,  1,213,110,104,202,210,
175,127,105, 17, 31,246,141,146,208, 56, 32,183, 16,197,189, 90,234,218,231,184,
122,221,170,212,195,184,193, 78,230, 31,152,101,141,220,176,  9,  3,151,  7,224,
143,165,244,188,197,220,183,150,145,229,195,227,126, 36, 87,185,188,  5,209, 76,
 33,142,161, 24,129, 66, 38, 36,116,104, 34,169, 66, 98,154,204,233,248,217,148,
 24,165,249, 54,111,154, 24, 42,152,108, 85,141, 96, 33,  8,188, 82,120,198,132,
 85, 21,  5,119,
} ;

// ../Source/Template/GB_emult_03b.c:
uint8_t GB_JITpackage_100 [679] = {
 40,181, 47,253, 96, 36,  6,237, 20,  0,150, 34,105, 33,240, 88, 23,  3,172, 29,
137,101,120, 11,237, 84,153, 57, 97, 41,208, 20,  2,110,157,229, 84, 90, 15, 58,
128,  5,158,129,148,129,135, 98,  0, 92,  0, 95,  0,148,129,231,129,201, 62,107,
202, 86,219,204,245, 14, 69, 55,115, 81,228, 62, 17,135,194, 97,176, 48, 20, 14,
199,188,235, 83, 95, 83,125, 60,227,158, 10,119,105,188,155, 79, 13, 71,161, 33,
174, 57,194,208,216,125, 75,141,149, 45, 78,133,  4,171,115,197,154,254, 35,235,
 69,177,  4,175,239,185,147, 54, 60,157,  6, 50,238,219, 29,103,132, 16,133,110,
139,229,104, 59, 26, 57,129, 96, 13,  8,132, 23,173, 40,214, 92,241,241, 88,122,
 29, 69, 53, 99,128,246,239,238,111,242,218,188, 57,206,192, 66, 23,226, 43,133,
219, 86,254,255,150,165,178,172,108,110,210,106,155, 49, 73,215,241, 37,203,159,
209,235,122,155,203,237,149,121,235,167,246,181, 99,213,183,225,126,184,239,233,
211, 97, 21,178,195,192,134, 94,197,220, 25,217, 94,240,110,210,126,147,129,213,
164,245,110,159, 20, 95,231, 48,221,  6, 18,233,104,132,180,162,233,129,143,114,
221,186,227,176,118,140,244, 25,210,235,180,147,208,200,183,143, 26, 39, 93,251,
246,111, 93, 69,237,160,207,173,119, 69, 77,187,237, 91,231, 11,146,190,187,132,
 66, 37, 16,232, 55,180, 23,190, 93,152, 97,122,119,172,100,234,187,172, 88,126,
 54,244,244, 49,178,163,151,254,170,205,225,238,198,146,124, 46,129,  1,150,181,
178, 86,224,253, 72, 11,248,188,142,235,152, 11, 68, 51,233, 64, 40, 13, 93,167,
 37,125, 59, 14,127,162,184,207,209,173,215, 57, 72,134,163, 56, 32,143,110, 67,
225, 84, 32,221, 69, 51, 33,193, 11,248, 44,121, 65,251, 61, 37,214,111,218,239,
  5,219, 41,254,252,210,111,191,244,129,140,251,118,108, 52,239,245,198, 41,190,
118,131, 96, 98, 24, 51,231,156, 31,105, 59,138,  3,104,160,145,165, 66, 72,134,
132, 38, 73, 10,146, 66, 26,  3, 48, 68,128, 16,187,243,233,128,206,182,180,131,
160,120,130, 13,132, 34, 66,203, 64,248, 13,224,226,195,216,  0,194,180,176, 44,
119,225, 35, 48, 62, 14,102, 19,108,134,116, 40,101,192,  6,235,  1, 52,125, 99,
 64,133, 73, 92,153,186, 90,225,239, 74,222, 22,213,219,167,112,127, 12, 21,190,
230,105,184,197,253,156, 48, 60,115,  9, 57, 14,133,  2,226, 33,144, 61,104,211,
  2,133, 38, 51,244,140,115,253, 27, 44,111,161,161,152,106,228,211,  8, 45, 49,
192, 71,195, 37, 50, 90, 64, 22,162, 32,109, 55, 52,101,233,215, 95,218,136, 15,
251, 70, 41, 20, 28,128, 92,104,113, 89, 45,227,154,231,104,224,154,213, 82,143,
113,  3,147,101,143, 72,166, 54,174,177,169,129, 73, 67,241, 99, 41,115,222,182,
183,173,101,190,124,120,156,138,100,133,235,167, 12, 84, 74, 36,188,144,232, 65,
197, 21,233,  4,250, 71, 84,199,173, 76,194, 30,188, 45,149, 26,160, 97,155, 55,
205,204, 31, 76,182,170, 66,160, 28,  4, 62, 33, 74, 15, 92,149,162,151,  9,
} ;

// ../Source/Template/GB_emult_03c.c:
uint8_t GB_JITpackage_101 [861] = {
 40,181, 47,253, 96,255,  7,157, 26,  0, 38,232,123, 41,208,208, 58,  7,120,178,
  4,205,  2, 45,226, 44, 44,155,229,232, 14,231, 70, 87,231, 25,185,241, 88,158,
 91, 64,159,226, 22,110,154,246,  1, 95, 60, 48, 75, 47,  1,114,  0,109,  0,111,
  0,146,198, 95,103,150, 35,137,200,116, 38, 90,103,220,198,237,112,156, 57, 11,
235,240,174,147,143,  3,150,138, 69, 98, 32, 80,177,156,202,166, 71,108, 51,106,
230, 19,249, 17,151, 65,207,126, 30, 61,146, 51,185,176,222,205,197,211,217,134,
 60,210,237,112,196, 81, 26,223, 26,226, 99,251,217,117,161,141, 18, 86, 47, 91,
208,251,214,203,107, 95, 61,246,175, 57,141, 79,200, 68, 90,  8,216,  3,115,253,
146, 13, 84,104,238, 66, 94,211,185, 57,133, 34, 73, 40,148,249, 21,130, 36,123,
207,180, 55, 44,166, 68,212, 52,253,114, 14,231,129,225,  9,167, 40,  6,174,216,
 36,210,116, 36, 62, 20,171, 14, 66,144, 96,183, 14,194,158, 51,123, 51,238, 11,
249, 51, 61,200,159,125,198, 31,152, 85,213,128,  6,114,185,177,255,191, 36,113,
 72,210, 36,202,127,130,205,227,250,190,161,156,133,110,198, 31,101,219, 94,197,
111, 46,159,203, 86,227,241,146, 42, 19,139,164,185,172,134,242,151,219,118,179,
249,107,109, 33,218,215,116,134,143, 51,156,126,117,104,134, 65, 82,217,161, 31,
205,230,235, 46,227,144, 95,220,154, 49,149, 97,117, 10,227,145,155,211, 39, 85,
176,126,129,169, 94,187,234, 20, 19,239,204,118,120, 82,235, 25, 95,187, 97, 60,
 83,130,  2,142, 72,  4, 31, 83,189,114,107,162,  4, 98,102,189,250,141,180,169,
187,144,214, 92,134, 79,125,116, 78, 88,171,125,185, 76,189,208,247, 11,110,239,
186,235,234,173,225, 67, 15,124,245, 44,234, 13, 31,154, 13,146,212, 33,117, 68,
 34,215,102, 31,143, 86,116, 77,239, 52,104, 60, 11, 16,154, 57, 65, 32,182, 84,
202, 71, 91, 53, 14,146,115,105, 50,244,195,121,192, 52,180,193,179,176,181,246,
109,246, 97,157,226,186,230, 33, 19,121, 43,218, 41,123,  5, 21, 69, 31,143,188,
  2,  2,142, 77,183,222, 59, 16,  4,117,232,179, 57,130,228,116, 73,231,220,  0,
 76,223,236, 35,214,103, 56,113, 59,111,221, 30,243,234,151, 64, 36, 82, 97,135,
134,215, 99,120, 41,198, 24,175,128,156,168, 97,177, 99,102, 68, 70, 68, 65, 82,
144,130, 66, 58, 48,132, 24, 99,236,234,  1,226, 97,170, 71, 17,195,140, 50,  2,
 40, 16, 27,153,  9, 75,146,250,199,  3,153, 66,185, 16,137, 57, 41,139, 38, 21,
 64, 15, 66, 66,133, 10,110,110, 90,146,156, 28,231,251,215,120,220,209, 64,111,
222,214,246, 57,228, 22, 40,195,194,151, 78,230, 20,222, 25,207,190,110,136,162,
 43,161,  5, 72,159,130, 77, 51,243, 80,150,144, 68, 55, 91,206, 49,138, 98,254,
104,136,170,240,223,228,179,108,156, 89,146,230, 74, 27,250, 24,145,104,209,249,
243,117,133,141,159,129,147,254, 17,158, 53, 67,222,218,207, 86,202, 80,131,149,
180,194,  5,116, 26, 71,194, 46,240,179,186,163, 32, 51,221,113,145,  6,248,215,
165,228,147, 93,159,126,170,209, 97,115,  9, 89,187,120, 29,237,203, 86,  1,165,
254,159,179, 16, 67,128,170, 88,216, 46,209,203, 98, 45,141, 71,124, 44,141,101,
 54,103,161,  5,  4,246,153, 30,247,163,128, 13,231, 20,  0, 29,228, 30,202,127,
113, 22,230,229, 54, 95,142,126,197,199, 73, 43,226, 86, 68,186,  7, 35, 25,229,
254,161,168,153, 49,191, 86,233,223,144,239,111,101,228,125,120,240,247,  8,228,
193,196,127, 18,224,  1,250,198,182,108,169,135, 41,243, 92, 25,137,210,238, 63,
210,142,  8,238, 16, 91, 44,213,208,123, 74, 53, 26,241, 13,169,239, 32, 66, 15,
 32, 37, 33,114, 26,141,148,246,186,105,  1, 88,208,226, 67, 43, 76,169,  5,154,
 16,201,166,233, 82,193,180, 42, 85,142,148, 66,240,209,104,202,140,167,170,  5,
 78,
} ;

// ../Source/Template/GB_emult_04_template.c:
uint8_t GB_JITpackage_102 [1145] = {
 40,181, 47,253, 96, 64, 13,125, 35,  0,230, 48,149, 40,192,146,213, 49,170,170,
 18, 27, 13, 54,104, 34,139, 59,118,246, 95,163,  8,205, 93,232,226, 81, 78, 70,
141,153, 81,163,192,187,167,223, 85, 20,  4,217, 96,  6,139,  0,135,  0,141,  0,
 86,255,110,251,219,198, 27,135,250, 26,127, 74, 22,202,101,114,183,204,230,120,
204,119, 49,  8,239,238,106, 14,147,171,187,155,225,205,132, 66,211,161,104, 87,
227,187,250,122,174,247,134,129, 61,231, 56,130,139,229, 50, 57, 24,176, 92, 78,
101,211,161,198, 26, 86,243,142,109,123, 34,140, 29, 94,113, 35,183,108, 63,  6,
204,117, 55, 30, 93, 18,199,141, 64,149,108, 69, 27,127, 46,175,117,246,241,240,
187,185, 99,171, 92,253,217,172, 79, 15,101,132, 18,159, 81,160,  9,243,152,187,
 45,151, 69,119,215,  2, 75,221,220, 72,116,171,100,120,165, 34, 77, 42,149,115,
 78, 41,165,172,206, 65, 77, 28, 86,167,  2,219, 94,247, 61,250, 28,254,126,222,
217,236,242,159,247,120,144,231, 81,  2,  2, 19, 64,117,106, 78,199, 60,214,117,
 69,108, 35, 65,173, 10,194, 90, 39,101,197,121,222,231,106,238, 74,201,185, 28,
106,244, 52,174,241,183,195, 27, 43,194, 99, 65, 84,204,225,  1,116, 53, 16, 14,
144,178,250, 71, 97, 18,159,249, 39,126,103,248,219,250,126,145,239,138,176, 59,
252,173, 59, 47,155, 80, 30,198, 67,250,125, 49,254,255,146,244, 33, 73,148,143,
165,215,246,247, 27,237,108,244,109,253,142,141,175, 40, 22,210,135, 68,146, 80,
221,242,204, 68, 13,192, 12,139,108,215,161, 77,151, 27,105,119,203,244,169, 73,
107,246,126,219,174,162, 81,247,207,  3,157,187, 28,103,111, 69, 24,246,203, 26,
222,215,248,244,247,187,219,198, 11, 52,111,219,151, 86,191, 60,242,217,173,179,
222,157,196,114, 33,140, 14,215,208,173, 25,230, 52,173, 91,127, 24, 20,194,120,
230, 74, 97,114,115,199, 22,253,122, 96,221, 93, 78,131,226,192,124,179,145,136,
248,194,169,105,162,148, 98,188,109, 89, 97, 66, 51, 45, 48,160,176, 41,225,193,
174, 14,229,204, 10,113, 69,154, 69, 94, 86, 67,218,210, 25,146, 20, 34,133, 72,
 36, 51, 31, 98,142, 57,189,195,177, 46,135,  9, 75,202, 15,140,135,216, 90,158,
184,153,150,166,118,153, 95,204, 41, 31,161, 68, 42,  3,226,169,122,230,255,160,
228,116,169,217,187,117,135, 15,  2,242,171, 71,135,154,102, 49, 28, 13,  7,163,
240, 37,240, 19,167,199, 42, 41,200,129, 93,113,130,104,182, 56, 78, 56,205,175,
 62,  7, 36,144,130,185, 83,243, 60, 60,132, 16, 78,173,187,149,230, 67,154,167,
207, 78,213, 68,196, 26, 59, 21,179, 24, 30,121, 70,117, 42,116,184,209,233,180,
 54, 72,134,140,132,234,175,126, 17,128,252,168, 49, 69,102,106, 70, 68, 68, 82,
144, 36, 25,214, 96, 68,100,204,170,115, 50, 97,164,168, 48, 14, 98,204, 40,  1,
 22,136,  8,  6,101,164, 48,  5,245,109,  9,106,144,142,115, 34, 11,225,111,124,
133,220,241,206, 10,191, 70,219,142, 93,178, 55,237,127,204,101, 51,103,114, 59,
 64, 53,252, 54,241, 56,219,113, 36, 92, 14, 64,217,180,237,255, 10,223,227,143,
 72,  2,255, 46,133, 12, 82,203,188,107,  8, 14,193,166, 20,233, 47, 43, 56, 80,
 54, 34,193, 28,139,205,208,132,109,204, 90,213, 27,252,147,240,195,160, 83,101,
227,134,215,248,118,199,202,138, 84,112,179,211,196,183,229,138, 71, 50,198, 16,
 90, 68, 65,201, 72,222,254, 69,238,148,254,141,177, 45,175,174, 76,  2,228,101,
 10,159, 93,239,235,197,194, 41,252,155,125,253, 60,240,117, 33, 68,211,173,236,
236, 54, 61, 42,205,116, 28,226, 72,  1, 42, 60, 87,208,  8, 87,197,214,110, 97,
206,150,112,126, 61,  3, 23,  3, 66,134,213,  1, 84,208, 48,252,164,111, 98, 91,
128,135,  1, 78, 88,255,154, 89, 70, 55,217,216,181, 97, 45,  6, 45,231,176,248,
132, 80,190, 81,142,181,108,179,209,109,166,231,113, 29, 47,239,155,219,221,  1,
153,147,156, 99,112, 64, 48,220, 67,104, 18, 27,148, 44, 28, 25,203,125,178,113,
166,  4, 54,165,189,214,203,125,214,235,121,217,238, 51, 78,106,251, 34,172,155,
  4,180,243, 84,  0,250,173,210,165, 52, 44,196,134,199,153,176,136,105, 69,250,
 51, 17,144,115,163,129, 21, 58,106,105,244,207,124, 28,225, 98,179,194,201,152,
221,132,116,106,248,118, 56, 33,240, 59,108, 94,102, 94,130,117, 28,187, 43,209,
106,203, 24,200,107, 69, 78, 86,132,142,205, 80, 10, 80,251,225,144, 24,174,139,
154,200,173,173,124,  7, 42,195, 60, 70, 45, 50,239, 69, 14,234,175,227, 52,103,
143, 50,104, 81,223,  0,240, 18,147,164, 50,147,217,138, 97, 81, 83, 44,214, 80,
250,131, 12, 54, 80,118, 88,214,111,137,156, 65, 44,135,164,225,134,184, 15,235,
 93, 80,207, 38,150,151,232, 65, 43, 19, 68, 95,141,188, 33,200, 98, 53,200,221,
159,103,  8,210,135,192,111, 28, 27,108,181, 59,243, 68,164, 40, 43,232,188,139,
 57, 68,126, 20, 90, 54,107,161,216, 25,238,161, 16,211,182, 75, 67, 83,250,137,
 35,151,229,166,201,170,167,215, 79,154,233,208,242,127, 46,143,210, 75,241,142,
142,170,  7,215,  4,
} ;

// ../Source/Template/GB_emult_08_meta.c:
uint8_t GB_JITpackage_103 [1227] = {
 40,181, 47,253, 96, 76, 17, 13, 38,  0, 22, 48,146, 40,192, 84,177, 14,228,188,
192,235, 47, 55,  9, 10, 19,224,  5,136,246,246,124,231,130, 65,122, 44,194, 36,
131, 16, 68,100, 55, 93, 56,184,174,162, 96,139,  2, 46,136,  0,124,  0,138,  0,
241,151,110,115,161,137,143,233, 47, 93,139, 59,119,220,102,167,201, 69,194, 88,
122, 94,146,123,207,220,166, 25,205,181, 49,142,165,113,237,139,118, 44, 26, 17,
 30,  9,235,143,219,184, 63,199,121,114,208,207, 53,237,189,130,128,185, 96, 44,
 11,  7, 23,204, 41, 87,244, 10,166, 31, 50,226,210,123,104,102,187, 81,208, 43,
212,235,192,201,201, 59,145,105,124, 37, 71,117,166, 29, 53,  1,120,136, 14,211,
 43,176, 64,122,154,233,215,102,199, 96, 85,254,160,177,156,220,159,145,185,183,
138,225, 82,101,173,219,186,130, 19, 55, 48,152, 88, 12, 12,  2, 88,135, 51, 24,
140, 96,235,240,214, 93, 56,107, 29,238,219, 26, 71,165, 88,246, 69, 53,252, 75,
177,  7,150,249, 93,169,196, 47, 77,215,230,171, 63,230, 37,251,149, 30, 55,189,
185,246, 51,123,129, 92, 59,220,117, 60,119,214, 43,153,214, 56, 95,207,182, 30,
183,197,158,145, 40,214,244,190, 61, 65, 26,203,235, 33,173,218, 99,122, 76,103,
142,142,201,206,184, 54,238, 48, 76,214,158,249, 21, 77,235,178,247,149,239, 51,
 91,235, 25,167,111,151,175,238,230, 76, 67,253, 33,231,171,188, 14, 43,239,149,
 49,  4, 84, 69, 26,227, 69,132, 16, 66,  8, 33,132, 16, 66,  8, 33,132, 16,194,
140, 98,181,225,148, 23, 93,163, 89,107, 53,214,186,147, 33,113,207,139, 32, 14,
228,228,150,169,181,161, 62,207, 67,125, 54,158, 13,138,138,226, 84,239, 21,166,
213,235,108, 46, 54, 22, 21,136, 83,145, 53,150,213,214, 62, 40,181, 44,134, 57,
 27,206, 61, 88,222, 53,231,222,243, 69,111,198,125, 11,158,171,  4,133, 92,171,
189,166,248, 10,204,205, 17, 48,165,128, 55,214,105, 87,165,  2, 31,206,243,128,
168, 15, 71, 66,102, 53,227, 75,179, 10,210,255,159, 76, 70, 66,214,  3,147, 73,
137, 38, 47,122,123,235,234, 51,152,128, 75,234, 44, 53,110,235,124, 81,205, 90,
 91,  8, 31,100, 40,157,115,226,166,105,154, 32,132,240,189,247,178,173,240, 85,
 59, 48, 16,  1, 76,209, 65,159, 13, 69, 61,104, 33,134,253, 80,142,185, 70, 19,
 29,243, 71,225,  1,117, 50,226,166,150, 60, 88, 50,133, 18, 18, 61,  3, 17,157,
 18,133, 80,106, 89,115,198,143, 68,207,232,101,123,174, 90,132, 98,128,107, 52,
 49, 70, 10,198,  5, 64,244, 92, 27,247,229, 64, 83,198,  7, 68,121, 34,198, 84,
 89, 80,175,242,192,146, 66, 66,242,232,218, 42,198, 24, 99,140,  1,129, 53,168,
 33, 93, 68, 35, 35, 35, 73, 65, 10, 82,105, 13, 17,  9, 49,136, 66,201,108, 30,
162,160, 32,151, 81, 28,130,160, 64, 10,144,  0, 33,100,196, 34,145,136, 68,154,
130,130, 74, 27,214, 16,  0, 57, 67, 49,141,123,136, 84, 60,225,163,214,162, 92,
229, 38, 22,167,144,252,213,251,111, 87, 28, 15,  1,241,  5,142, 33, 45, 10, 87,
 40, 15, 87,161,186,163,154,  4,242,119,101, 12,114, 22,243, 95,169, 34, 87, 48,
 24,201, 73, 77, 97, 73, 50,104, 37,128,230,218,191,210,110,106,199,210,156,150,
 64,161,165, 20, 78,228,108,107,124,  5, 52,231, 27, 37,198, 37,152,204, 26,154,
162,100,159,130,124,165,182, 26,192,194,205,241, 86, 89, 19, 25,  7,108,131, 63,
109,165,237,121,222,203,179, 76, 69, 58,209,151,124,163, 67,101,250,154,153,182,
246,160,110,  6, 50,189, 46,175,253,252, 44,128,215,243,225,255, 38,  0, 99,104,
 51,154,125,155,153, 43,140, 74, 83, 12,169, 84, 69, 85,190,147,242,115, 52,221,
  8, 80, 81, 82,121,127,201,146, 31, 18,254, 69, 86, 96,166, 16, 34,172, 62,163,
203, 99,  2, 64,136, 28, 71,112,163, 51,107,201, 36,119, 58,215, 93, 60,154,223,
 80,121,205,138,188,124, 39, 10,153, 94, 54,167,246,194, 77,233, 92,132, 37,232,
137,134,214,190, 34,147,238, 41, 39,246, 36, 27, 41,199,133,234,  8,227,177, 65,
150, 18,129,121,129,176, 64, 20,205, 10,236,228,118,208, 88, 49,206, 21,192,149,
 77, 14,217, 80, 72,107,145, 80, 14, 91, 89, 64,184, 10,254,169,205, 45,184,  0,
202, 59,150,241,196, 44,196, 46, 94,152,229, 22,191,185,130, 69,208, 92, 78,198,
 88,206,144,211,210,219, 97,139,194, 37, 11,  8,173,192,251,145,  5,145,130, 16,
  1, 32,194,  9,135, 77,213,155, 60,134,226, 46,153,109,187,147,  4, 56,207,179,
 66,172,186,153,  0, 23,229, 96, 20,101, 97, 49, 44,229,254,196,142,207,241,145,
 27,144,227,125, 72, 67, 51,168,106,168,216, 73,192,105,128, 94,235,219, 82,168,
196, 73,201, 98,255,225,201, 92,208,122,166,219,106, 25,245, 18,157, 40,211, 55,
102, 67,105,158,243, 33,171,242, 35, 10,129, 20,184,107,127,143,226, 99,121, 98,
 69, 26, 89,234,151,102,194, 31, 48, 81,128,244,233, 97,223,174,143, 72,106, 90,
 47,172,138,146, 69, 29, 49, 76,116,228,  5, 12,176, 64,233,160, 53, 28,179,187,
 29, 77,238,136,177,102,139, 82, 68, 25,185, 67,132,161, 64,153, 66,140, 45, 13,
199, 29, 17, 96,106, 26, 50, 65,  5,145, 36,133,118,185, 31, 79,251,176, 55,233,
209, 74,157, 14,103,194,253,200,156,108,  9,125,244,179,157,166,100,129,174,233,
206,143, 62,  3,103,152,126, 39,  3,144,162,165, 72, 86,163,135,245,163, 50, 39,
 53, 83, 69, 35, 41, 18,126,211,124,171,204,132,245,225,198, 61,228,120, 20,193,
 72,227, 36,165, 90,214,  9,
} ;

// ../Source/Template/GB_emult_08_template.c:
uint8_t GB_JITpackage_104 [2007] = {
 40,181, 47,253, 96,211, 38,109, 62,  0,218, 66, 84, 12, 40,160, 86, 85, 29,212,
135,191, 16,232,230,237, 70,186,205, 81,153, 46,218, 99, 61,183,227,127,108,161,
150,166,253,193,178,209,186, 28, 47,199,139,242, 58,120,  6,183,  0,178,  0,191,
  0, 19,143, 96,153,223,117, 74,252,213,117,109,214, 90,212,175,243,184,231,205,
181, 31,178, 23,120,115,249, 56,215, 15,127, 34,207, 95,118, 42, 68, 27,103,237,
217,214,227,182,219,173, 76, 99,201,121,214,181, 15,184,243,231,117,246,170, 96,
 42,141,165, 57, 77,122,240,214,237, 25,154,185,246, 86, 97,105, 92, 91,155, 29,
 75, 71,132, 70,181,181,232, 54,238,141,227,204,133,204,141, 83, 10, 79, 29,104,
 48, 26,139, 66,  6,163,249,164, 73,167,240, 20,201,136, 87,240, 35, 46,219,110,
130, 78,125, 96, 39,114,158,188, 19,214,167,243,252, 62,149,219,222,136,187, 52,
190,210,195,199,243,215,107,115, 36,127,240,  0,252,218,123, 28,174, 83,177,160,
130,155,235, 86,103, 73,189,174, 51,182,128,193, 50,253,186,198,226,196, 47,151,
138,229,114,  9,248, 83,197, 46,  9,111,178, 47,151,177,238,171,180, 41,149,191,
236, 66,228,245,  4, 26,190,205, 92,231, 73, 87,123, 16,232,180,161,111,115, 93,
103, 89, 86,217,221,  3,  2,170,106, 39,158, 90,111,191, 54,244, 81,158,221,159,
191,218,100,103, 92,231, 23,142, 39,151, 71,244,222, 92,187,107,234,117,243,185,
 71, 12,199,158,123,207,173,  3, 76, 70,195,240, 83,250,133,184,144,144, 39,187,
 60,179,169,167, 77,203, 22,110,109,150,203,221, 73,213, 99, 65,117,248,205,101,
 57,167,145, 88, 74,109,  8, 84,191, 99,169,125, 55,227,186, 53,205,186,206, 94,
165,246,146,121,179,236, 94,231, 45,198, 40,251,246, 97, 75, 83,109,  4,221,135,
187, 79,123, 95,121,156,233,135,251,110, 85,158,106, 26, 82, 39,150,173, 77,138,
127,  3,159, 56,248, 11,  2,225,115,110,156,125,120,158,211, 38,  5,146,177, 84,
 85,  5,189,143,151, 64,106, 66,234,208,131,161,185,213,254,234,204,147,165,218,
 90,212, 28,104, 96,  0,100,228,227, 30,104,131,243,249,192,140,193,229, 85, 32,
255,229,137, 80,150,116,193,218, 24,117,121, 38, 85, 68,155,158,225,124, 32,133,
  6,168,195,225,225,  8,140,156,226, 46,233, 23, 70, 17, 39,190,185,  8,151, 71,
 40,145,141,  3,158, 34,108, 57,146,247,181,221,175,197, 87, 90,173, 49,237,148,
203, 87, 43,111,123,246,242, 39,210, 67,181,233,148,177,124,179,145,176,174, 51,
116,106,109,246,140, 37,109,168, 64, 62,158,241,236,128,190,121,198,119,134, 70,
158, 49,132,132,107,179, 55,175,134,123,203, 29, 98, 96,112,135,134, 99,190,145,
 50,148, 54, 59, 89, 71,155,212,244,219,154,211,  2,149, 74,202,230,215,116, 73,
 84, 98,215, 98, 24,158,152,199,115,193,179,  1,158,186,222, 32,208,184,155,203,
179, 61,215,180,193,209,240,160,224,124, 54,160,198,  7,251, 84, 96, 30, 26,160,
 85,  1,239,237,163, 90,109,141, 82,121,241,129, 30, 44,  3,163,195,193,216,224,
 92, 96,160, 10, 11, 41,186,196, 83, 68,117,103,199,221, 89,109,132,231,181,198,
183, 97,156, 14,163,236,117,125,177, 38, 41, 45, 92, 27, 55,127, 56,149,213,206,
236, 89,135, 24, 99, 22, 99,150,197, 24, 99,204, 98,140, 49,198, 24, 99,140, 49,
198, 24, 99,164,102,140, 49, 74, 58,125,130, 35,114, 34,182,222,142,130,242, 20,
239,212,172,192,252,  1,131, 19,111,178,113,237, 77,230, 43, 51,198,234,172, 80,
102, 12, 40,232, 65, 73,227,225,214, 69, 58, 29, 14, 12,136,217, 44,189, 98,125,
228, 16,  1,130, 28,168,242,211,146, 41,166, 68,  2, 17, 73,146, 20, 10,141,  1,
 18, 41,132,225, 88,162, 75, 73,183, 30,194,208, 32,141, 82, 24, 69, 40, 33, 68,
 64,  8, 35, 70, 48, 68, 68,  2, 17, 17,145, 72, 70, 68,226, 54, 17,130,164,197,
182,136, 32,101, 25,125,169,170,105,114,197,117, 82,179, 78,253,201,110,179,160,
129, 43,  1,193,139, 46,163,195, 24, 76,221,104,216,149,111,255,  9,245, 96,122,
 91, 26,106,237,230,108,129, 67,183, 89, 26,163, 42,181, 32, 41,236,255, 44,210,
184, 47,185, 56,171, 21,250,  8, 50,224,201,183, 83,237, 65, 87,191,232,199,170,
 37,193,221,118,211,116,220, 38,240,175, 29,  0,102,249, 75, 72,179,253,  6,122,
 53, 40,233,206, 74, 52,204,127,  9, 72,252,144,222, 86,179,192,133,202,159,202,
224,218,243,178, 70, 66,248,202, 67, 50, 85,132, 46,174, 60, 55,156, 68, 22, 52,
132,134,107, 54,218,223,216,123, 83,126,176,112,103,130,221,224,213,175,107,161,
 48,249, 93,193, 86,255,224, 74, 97,228,220, 96,134,104,202,212, 78,151,169, 78,
 89,144,130, 72,250, 15,185,  7,127, 81, 54, 77, 40, 12,160,209, 68,115, 71,175,
243,167,228,212, 77,185, 11,173,102,243, 42,  3,146, 25,152, 54, 45,135, 82,255,
140, 78, 89,111,166, 43,  4,229,116,204,213,120,161,197,159,159,142,141, 38,152,
 22,166,174, 27, 88, 14,223,229,210,238,137, 99, 19,214, 37,126,227,138, 64, 97,
 67,132,203,162, 73, 77,141,200, 79,120,  6,148,238, 75,108,245, 67, 90,131,140,
 72,189,121,218,  8, 38, 24,233,247, 19,143,118,236, 56,121, 45, 50,163,158,218,
167,237,247,212,182,171,237,242, 45, 87, 57, 20,112, 50,145,167,119, 40,231,245,
172,241,154,222,168,189,134,165,189, 56, 59,191,248,251, 51,245,246,150,162,215,
217,  9,213,163,141,207,199, 88, 61, 58,140,210,181, 48,129, 72,217, 33,166,164,
147, 20, 35,160,251, 32,175,  9,  3, 54, 51,196,120,148,  9,131,217, 78, 61, 16,
186,221,176,101,162,198,182,  3, 79,153, 29,127, 37,235, 10, 65, 57, 26, 43, 75,
 80, 77,105,181,249,133, 88,155,176,182,207,140,134,132,  7,179, 49, 87, 89, 39,
115,175,100,124, 71,137, 31, 41, 24,154, 87,121,255, 31,226,212,251,211, 94,107,
 13, 10, 10,127, 50,  3,200,213, 53,216,225,188,243,  5,212,221,  6, 58,237,125,
 26,254,236,121,255,  7,144, 43, 18,189,139,234,249,  6, 20,219, 82,190,100,255,
158,127,213, 76,167,221, 20, 14,247,138, 17,213,  0,236,217,109,220,220,174,163,
221,173, 91,222,244,193, 81, 91, 25, 34,198,136,220,112, 34,230, 57,  2,192, 10,
180,179,125,240, 39, 92,125,215, 32,193,165,146, 93,190, 78, 28, 54, 57, 41,203,
190, 66,230,145, 46,127, 65,105, 73,106,249, 86,187,229,119,106,198, 77,166,168,
145,187,180, 82,230, 13,208,107, 91,252,145, 36,  6,250,225,  5,192,182, 70,109,
 94,  1, 92,191,141, 32,114,227, 94, 49,110, 22, 32,147, 14, 18,207,140, 49,168,
145,225, 94, 11,196,119, 71,213, 10,177, 39,244,145, 51, 48,217,181,175,183,121,
101,227, 54,169,247,103,206,135,138,  0, 30,  8,172,102, 12,242,213,  3, 25, 66,
118, 25,142, 68,139,133,237, 50,204, 64,240, 23,  7, 58,  9,226,190,167, 28, 86,
  4, 40,239,144, 64, 77,181, 57, 79,168, 84,205,252, 77,193, 45,170, 93,174,101,
252, 82,139,237,168,  4, 71, 64,163,203,130, 63,168,229, 44, 63,147,142,253,218,
217, 62, 54,224, 22,175, 13,139,220, 24,183,216,127, 90,123,172,233, 53,  7,104,
114,202,171,143, 37, 54, 84,142, 85,  1,148,239,253, 21,125,129,224,133,101, 96,
 52,237, 40,195,  7,186,145,132,115,159, 36, 36,  9, 88,  3, 17,214, 27, 12,174,
144,239,199, 50,  9, 35,196, 30,142, 33, 74,145,181,153,113, 68,224,140,255, 11,
197,132,120, 52, 43,209, 29,231,167,139, 79, 70, 96, 53,217,  4,190,216, 96,153,
 34,101,184,173,170,169,202,124, 65,196, 39,215,255,161, 62, 15,177, 69, 85,187,
255,219,200,165,168,218,179, 72, 95, 27,169, 44,  8, 76, 38,220, 78, 23,164,223,
134, 16,136,107, 18, 47,120, 37,235,154,135,132,253,141,172,186,234,215,124,112,
179,196,101,128,  3,181,229,139,232, 71, 16,213,147, 66, 83,220, 46, 47,202,216,
226,  4, 17, 79, 31,188,233, 63,162, 67, 60,200, 20, 75, 69, 87, 95,223, 39, 43,
  8,245, 76, 27, 51, 46, 41,201,167,175, 25, 12,161, 51,137,251, 27,225, 81,164,
 17,178,165,217,  0, 55,183, 88,160,172,198,138,115, 27,110,176, 96,201,100,233,
200,122,101,204,208,169,226, 89,235, 92,241, 21,177,221,163,213,135, 57,220,212,
218,165, 93, 12,159, 12,105,239,205,113,242,104, 34,195,152,106, 36,114, 78,126,
138,132,183, 48,204,207,174,  5, 82, 76, 47,135, 42,221,  9,206, 20,244,152,148,
 85,192,148, 80,223, 63, 83,188,236,171,227,144, 63,228,128,238,228,136,164, 61,
138, 97, 65,167,179,156,  8,241,116,227,241, 13,255, 72, 88,245,114, 35,185,193,
178,213, 55,106,119,151,219,170, 42,146, 48, 33, 57,  8,130,149,177,115,  5,155,
224,175, 91, 77,  3,128,143,192, 29,  0, 56,196,217,166,142, 38, 39, 96, 76, 64,
 29,101,132,193, 31,167, 11, 12,140,113,118,  1,  3,109,  2,205,168,160,147,  2,
152,121, 39,205,233,252,222, 24,247, 74, 99,203, 74,179, 71,128,245,152,170, 10,
202,104,  9,134,150,150,125,211,132, 31,130,137,213, 84, 78,135, 97,197, 57,116,
105,164, 73, 90, 43, 24, 80,
} ;

// ../Source/Template/GB_emult_08bcd.c:
uint8_t GB_JITpackage_105 [880] = {
 40,181, 47,253, 96,167, 17, 53, 27,  0, 70,165,113, 40,208,178, 76,  7,170, 74,
 60, 27,241,138, 66, 80,142,246, 52,176,161,226,149, 76,119, 83,164,160,213,152,
138,113, 25,152, 81,162,242,  5,190,120,144,165,230,  5,106,  0,100,  0,102,  0,
 91,102,154, 33,157, 90,107,166,  9,  5,  8,201, 54, 53,192, 25,206,205,195,202,
 93,244,230, 93,183,143,  4, 21, 74,101, 58, 24,160, 84, 46,105,209, 99,216, 26,
 82,225,146,125,  7, 87, 61, 79,115, 30,175,213, 48,247, 73,112,225,114,205,218,
159, 11,  2,231,215,193, 77,102,  8,202, 47,124,215,201, 79, 80,158,191, 81,249,
184,143,213, 49, 44, 32, 89,170,250,101,211, 50, 11,  5,171,221,199, 51, 49, 94,
248,100,  2, 77,147, 73,  7,183,115,218,199,243,176, 47, 97,196, 75,180,217,  5,
 94, 33,120,194, 61, 40,134,140,222,105,102,204,165,131,128, 96, 97, 99, 27,157,
179,177,174,107,207, 85, 47,147,192, 89,101,247,134, 71,139,100,249,197, 19, 73,
126,190,128,228,123,234, 85, 70, 40, 61,247,232,227,169, 87,191, 72, 91,212, 98,
 22, 89, 54,143,171,179,225,255, 15, 65, 31, 16, 69, 82,153, 38,167,201,111,127,
  1,103,119,186,210, 25,153,206,220, 40,230,125,234, 22, 85, 37, 85,213, 55,195,
110, 98, 30,137,104, 31, 56, 69,221,186,150,  1,  2,179, 80, 48,142, 38,162,193,
  2,224, 61,213,209,171,127, 72, 49,198,222,199,142,206, 80,109,214,186, 48,138,
205, 58,100,120,163,159,206,243,178,129, 79,251,157, 58,248,209,126,119,199,130,
191,138, 55,159,122,191, 98,  5,  6,149,246, 71, 36,178,209,137, 33,156,191, 99,
 30, 29,244, 58,124, 42,185, 26, 16, 20,194,204,203,219,141, 57,191,122,244,245,
147, 61,172, 97,115,204,229,110,222,128,128,232,179,107,110,163,227,157, 74, 45,
252,244,116,157, 64, 57,105,119, 29,181,185,250,250,241,178,221,152,153,119,119,
119, 89,147,217,161, 10, 20, 18,137, 84, 95,167, 55, 58,  1, 30,251,177,170,162,
 67, 60, 88, 87, 70,194, 98,206,162,179,199,177,143, 28,107,  1,163,101,244,181,
 54,171,169, 44,133,135, 43,128,180,160, 65, 69,198,148,136,136, 36, 41, 73, 74,
195,  1, 80,132,204,144, 21,113,  3,121, 64,149,237, 92,181, 82,245,164,138,237,
 81,102,209,164, 30, 62, 73,237,124, 79, 40, 16,188,200, 58,206,109,239, 48,  2,
184, 72,128, 20,245,248,102, 97,148,124,214, 47,229,193, 53, 86,149,107, 11,  5,
252,237,133, 12, 22, 25,162,254,239,231,177, 50, 22, 89, 24,243,174,133, 16,105,
161, 17,141,146, 28,195, 10,121,149, 91,176, 81,175, 66, 57, 27, 66, 33,135, 63,
226,178,186,241,  9,222, 54,  0,110, 60, 56,193, 12, 21, 44,  5,168, 65,138, 19,
172,241,  4,137, 64,197, 36,108,  1, 24, 32,233,  8,  9, 49,203,160, 11, 80, 40,
  6,119, 99,244,251,150, 98, 33,119,201,143, 33, 54, 30,143,244, 60,138,217,208,
253,130, 90, 33, 19, 28, 50,208,195, 22, 24,  1,241, 96,112,102,176,180, 73,186,
117,219,156, 79, 69, 13, 15, 31,122,161,190,  7,180, 70, 70,203,218, 12,106, 65,
105, 26, 81, 25, 86,224,  9,130, 88, 35,232, 87,227, 42,143, 95,230,109,229,  1,
133,180,211,217,244,192, 58,109,234,160, 99,205, 98, 53, 46,169,176,210, 51,  8,
 30, 42,158,140, 83, 55,174,123, 75,184,216, 45,153,215, 89,160, 42, 10,196,151,
209, 68, 64, 27,155,220,161, 55,138,173, 21,251, 69,101,246, 69, 96,235, 76, 86,
 44,230,112,182, 26,220,202,114,124,251, 32, 64,130,194,  9, 20, 18, 28,133,135,
181,129,  5,246, 99, 36, 45,  1,113,172,231,217,214,  7,246,  5,182, 94,255,200,
178,179, 62,147, 29,228, 13,127,228,248, 79,176,164, 73, 33,101,161,217, 34,173,
107, 79,195, 28,250, 19, 69,251,160,215, 97, 30,110, 60, 42,102,176, 66, 13, 97,
140,195, 14, 76,184,156, 26, 49,107,202,191,194,196,137,231, 84, 44, 16, 93,161,
 28,164,104,208,236,252,193,116,171,212,136, 17,  7, 70, 59,196,168, 42,122,199,

} ;

// ../Source/Template/GB_emult_08e.c:
uint8_t GB_JITpackage_106 [1262] = {
 40,181, 47,253, 96,243, 17, 37, 39,  0,214,118,162, 40,208,178, 58,  7,202,149,
 12,193, 35,114,204,232,169,106,199, 92,164,205,145, 83, 39, 52, 96, 95,254, 61,
 51,125,219,176,  6, 62, 98, 93, 70,169,  7, 94,160,148,152,  0,147,  0,151,  0,
249, 54,215,209,167,242,252,132,214,123,168,206,247,198,252, 94, 39,119, 25,115,
237, 79,131,247, 99,185,103, 91,143,233,177,191,218, 34, 74,101,145,244,199,205,
 27,127,  9,155,122, 52,215,238, 52,146,198,181, 57,186,145, 80, 48, 68, 84, 93,
111,132,141,155,115,156, 63, 12,202, 57,  8,198, 83,  3, 22,138, 69, 98, 80,161,
 88, 62,113,210, 41, 76, 55, 38,195,171,248,208,151,237,135,118, 78,101,113, 35,
191, 59,195,134, 75,214,153,130,178, 40,236, 27,250, 38,141,195,121,241, 59,156,
199,222,213,249,235,181, 63,142, 75,129, 42, 90, 10, 88,194,245, 75, 31, 80,180,
 12,130, 62,173,201,134, 79, 38,145,100, 50,  9, 28,167, 46, 42,146,170,170,176,
107,241, 14,140,162,216,171, 61,238, 60,195,190,246,127,252,135,  7,207,172,117,
165,158,116,175,171,173, 97, 94,145,220, 58,118,159, 53,130,130, 92,233,148, 65,
 93, 36,236,185, 49, 48,147,148,  7,  1,209, 48,213,162,244, 14, 39,147,101, 50,
 62,236,170,155,157,113,165,159, 46, 44, 21,138, 69,227,249, 93, 77, 58, 56, 70,
165, 24,116, 12,125,238, 80,135, 19,225,120,128, 82,249, 65, 16,228, 89, 16,238,
252,100,186, 77,  7,191,124,164, 95, 94,160,122,252,175,135,246,151,169,165,131,
206,126,185,177,255,127, 20,125, 68, 17,166,239,106,159,241,108,240,121, 62, 30,
107,193,123, 56, 10,210,120, 83,199,244,177,113,237,110,118, 21,100,189, 25, 49,
111, 80,165,185, 90,238, 19,192,212, 30, 20,127, 58, 58, 89,188, 48, 45,131,126,
 14, 90,187,221, 83, 84, 67, 47, 35,141, 68, 18, 48,151,142,177, 13,185,249, 76,
 67, 42,145,169, 54,184,113,138,186,152, 20, 33, 27, 40, 23, 30,139, 95,158,241,
133, 79,150,102,179,118, 73,158,205, 70,226, 33,180,167,166,208,181,220, 57, 44,
  8,206, 15,127, 74,199,243,253,153,248,250,176, 91,214,191,203,211, 24,236, 16,
204, 47, 58,106,241,140,233,166,115, 11,187,161,205, 92,111,188,191,124,207, 62,
 55,222, 64,248, 19,211,127, 28,253,  2, 81, 20,210,218,117,175,107,241,104,192,
 41,122,234,186,164, 71, 64,100, 50,205, 68, 70,202,205,118,196, 83,157, 76,  3,
134, 78,233, 49,195,137,155, 43,195, 16, 65,100, 26,175,187,138, 57,189,245,139,
235, 90,156, 94,152, 71, 34, 30, 53,131,123, 37,147, 69,135,136,206, 70,  2,203,
  4,252,214, 47,233,114,219,182, 83, 82,202, 77, 74, 41,165,203, 77, 90,151, 87,
102,174, 67,218,201,109,147, 19,189,101, 73,143, 20, 69,227,239,112,113, 98, 38,
211, 42, 56,241, 65, 35, 43,151,132,119,126, 92, 56, 27, 63, 20,206, 74,183,137,
218,162,244,168,201,140, 67,234,105,145, 94,114,250,200,115, 56, 51,214,172,199,
 11, 10,129, 11,168, 49, 61, 99, 74, 70, 68, 36, 72, 10, 10,146, 66, 58,161, 12,
 49,200,121,233,212,  3,210,112,100, 16,135, 16,133, 16,101, 68, 64,  8, 34, 34,
145, 72, 32, 18,137, 68, 34, 34, 35,217,  6, 20,  8,235,228, 78, 84, 67,213,111,
105,176,231,121, 83,120,136,179,192,131,241,191, 84, 28, 75, 24,243,210, 34, 56,
120, 35,214,  8, 49,218,150,155,133, 82,185,206, 30,211,128, 87,156,245,177, 94,
 40,146,251,150,192,107,142,208,128,249,215, 41,227,  9, 27,228,183, 49, 72, 59,
 97,127,153,218, 24,142,221,116, 29,118, 38,106, 22,  2, 43,239,205,235, 94,164,
 35, 10,159,211,126,114,148,200, 64,186,253,234,124, 64, 85, 37,223, 15,168, 20,
 70,125, 44,141, 20,165,175,205,  2,113,158, 56, 20,159,254,200,202,164, 44,237,
 82, 23,224,125, 43, 43,216, 82,194, 40,214,189, 95, 87,116,189, 16,  6,245,205,
181,147,136, 36,205, 41,173, 76,211,198,124, 72, 35,103,198,168, 27,149, 43,211,
 72,189,  2,131,119,150,191,214,191,220,  3,239,  4,174,183, 40,186,193,229,226,
206,173, 78,158, 95,159,118,147, 94,134,202, 59,  6,159,205,103,126, 55,255, 41,
252, 27, 21, 15,120,127,167,251, 26, 11, 34, 23, 35,  4,  8,191,129,  0,207,158,
209,  3,249, 36,252, 24,211,188,219,217,106, 66, 91,182,129, 54,226,226,236, 94,
  6, 56,109,120, 64, 70,121, 28,176, 18, 63, 52, 78,176,208, 33, 81, 85, 37,  0,
 55,245,162,207,160,128,122,  0,219,141,230,157, 80,236,190,109,173,203, 98,218,
133,167, 51,218,209,145,  7,121,141,214,222, 92,196,141,134,234,218, 70, 58,176,
  9,141,144, 75,208, 39,179,208,239, 66,154, 90, 86,147,238,  6, 98,246, 73,203,
238,199,103,230,190, 92,124,190,175,101, 76,114,194,248,154,230,221, 89,184,108,
 65, 53,122,194, 32, 56,116,  8,241,126, 98,162, 17, 55,232,179,141,132,252,109,
 58,240,120, 24,116, 46,183,241,197, 56, 42,183, 43, 34, 14, 41,  1,130,221,190,
145, 73,109,124, 48, 18, 27,174,145,117, 46,145,155,233,237, 90,115,207,196,104,
112,236, 60, 34,108,196, 89,  6,207, 65, 48, 96, 95,192, 77, 23, 69,189,109,235,
 42,112, 51, 55,138, 15, 46, 94, 64,176, 53,236,101,222,123,136,150, 73,179,163,
188,181, 36,118,225, 89,153, 64,105,166, 31,179, 21,138,254, 66,226,164,172,238,
164,213,110, 66,191, 59,203,232,131,199, 57,212, 22,167,212,158,188, 71,194,207,
 22,108, 45,123, 88,193,132, 26,161,107,135,188, 38,146, 36,125,170,233,103, 32,
249,252, 24, 57, 65, 30,241,228, 42,247,138, 10,142,222,223,195,173, 39,144, 13,
144,182,157,243,219,164,233, 84, 48,117, 85,227, 56,168,130,122,131, 65,117,103,
137,  1,
} ;

// ../Source/Template/GB_emult_08fgh.c:
uint8_t GB_JITpackage_107 [1042] = {
 40,181, 47,253, 96,138, 23, 69, 32,  0,118,106,128, 40,192,208,108, 14,250, 15,
102,178, 22,  0, 46,115,129, 27,201,246,137,  6,220, 83, 23, 35,141, 23, 77, 70,
115,173,179,168, 11,132, 43, 96,154,  4,129, 52,201, 65,123,  0,112,  0,117,  0,
 34,253,110,107, 87, 84,153, 88, 36,181,243, 80,145,143, 25,107,115,125,193,186,
105, 36,213,130,213,211, 27, 73,132,130,195,100,171, 22, 99,181,149,115,123,187,
 79,115,238,121,124, 57, 96,169, 88, 36,  6,  2, 21,203, 39,143,116,105,219,130,
 42,124,194,207,232,110,248,117,231, 18,227,205,236, 68, 58,102, 48, 88,189, 29,
194,162,177,138, 25, 29,165,218,145,138,246,182, 95, 29,172,221,197, 39,100,194,
 84,194, 21,128, 80, 29,211,125,184, 75, 37,187, 94,232,171,217,204,156, 66,137,
 36, 20, 74,151,162,235,114, 30,164,221,253,184,189,243,132,190, 79, 32,137,145,
 88, 59,228,150,129, 39, 92,  3,  4, 81,233, 28, 88, 61,139, 67, 14, 58,245, 59,
210,107,179, 75,252,205,  8, 10, 46,216,115, 30,124, 58,  7, 71,102, 59, 99,233,
 29,142,133, 97,255,116, 57,230,147,254,207, 67, 38,231,191,  2,  8, 17,170,143,
181,187, 93,185,203,143,225, 49, 19, 39, 93, 42, 91,216,221,122,253,255,163,104,
 35,210, 94, 71,250,249, 13,164,231,127,226,121, 33,142, 18,145,136,231,  2,167,
168, 91, 24, 47, 56,100,151, 74,214,217, 60, 92, 86,192,228, 83,127,245, 13, 41,
 89,188,108,190,108,233, 11, 21,135, 45, 44,147,224, 48,131,102,110, 96, 40,228,
  4, 46,225, 17,236,119,115,  0,147,248,133,158,172,194,210,107,170, 26,109,191,
 75,140, 14,198, 85,230,143,199,167, 75,188,212, 46,233, 87, 54,103,230,212, 65,
253,221, 11, 67,173, 31,161, 14,146, 45, 93,191,245, 67, 49,197,137,247, 60,245,
126, 36,178,129, 53,155,226, 17, 62,197, 31,  4, 81,212, 49,185, 91,154, 60,185,
155,197,249, 27,130,191, 33,237,246,218,198,168,231,207,238,201,143,135,244,234,
117,119,193,133,  7,169,199,190,126,125, 37, 35,173, 96,123,245,163,246, 55, 20,
106,220,205, 57, 39, 51, 51,243,252, 80, 45,178, 68, 81, 71, 36, 82,137, 92,  7,
 92,246,101, 85, 73,119,104,176, 48, 13,132, 53,167, 38,125,134, 24,124,217,177,
 50,160,166,210,217,226,240,166,178, 20, 26, 48, 13, 87, 55,144, 58, 69, 85, 85,
149, 88,173, 87, 15, 30,128,223,168, 81, 65, 67, 36, 34, 34, 34, 82,144,164, 32,
 25, 14,112, 68,100,136,140,230,  1,130,152, 76,200, 50,  8,134, 80, 12,103,132,
 72,160,140, 49,  2,137, 17, 17,  9, 70,100, 68,210,169,198, 37,176,133,203,  3,
168,192, 70,245,101,183,237,240,  3, 98,166,207,222,232,215, 11,207,213, 91,121,
122, 27,175,220, 29, 56,153,116,130,201,250,195, 55,199, 81,214, 60, 57,145,177,
 24, 39, 64,210,134, 45,252,228,213, 51,129,148, 76, 38,140,235, 91,205, 71, 37,
 68, 82,155, 96, 25,182,244, 75, 49, 96,173, 92, 48,165,169,218,224, 58, 48,184,
 35,234, 47,146, 33,176,146,218,  9,  4,209, 99,182,129, 50, 29, 33,141,115, 54,
 59, 55,240, 77,213, 65, 99,228, 42,184, 42, 60,251,175, 55,220,210,196,138, 70,
213, 75,104, 45,116, 47,147,205,  7,213,107, 28,180,191,228,187,171, 25,161,210,
  0,239,251,  1,128, 39,  8, 49,196,146, 69,195,184,133,207,109,147,127,166,165,
128,133,213, 13,140, 56,223, 72, 41, 10, 44,195, 73,211,207, 86, 59,207,211,203,
 18, 38, 35, 28, 84, 24, 57,125, 89, 75,108,103,146,113,172,122,129,  4,230, 61,
212,149, 34,150,119, 75,223,222,122,215,122,167,178,104,  0, 57, 96,127,254, 41,
 25,111, 31,144,217,197,214, 84,133,218,187,230,  6, 88,178,199, 21,127, 90,216,
226, 49, 52,173,147, 27,176,253,122,223,151, 13,168,189, 70, 20,106,  3, 48,162,
 79, 18,135,129, 10, 54,111, 37,204, 17,251, 81, 87,  9,214, 38, 16, 60,246,197,
222,206,186,153,150, 95, 52,133,132, 68,122,234, 49,224,112,115, 56,180, 33, 37,
231, 84,192, 70, 83,164, 80, 77, 68, 34, 80,119,177, 72, 69,165, 76,104, 81,141,
160, 89,160,196,176,178,  3,117,233,103,190, 71, 23,210,184,246,206, 17, 81,235,
 66, 64, 59, 18, 25, 18,  3, 80,214, 31,177,117,  4,160,155,169,214,198,214, 68,
202,230, 83,131,228, 59, 58,201,126,230,182,198,145,251, 50,236, 61,185,213,211,
 17, 40, 11,170, 22,173,157, 82,120,  8,159, 11,222, 60, 59, 39, 60,241, 95, 33,
  2,155,209,202,147,166,120, 59,208, 98,137,177, 44,211, 60,212,243,131,174,134,
 17,112,161,244, 71,106, 10, 28, 68, 66,118,246, 82, 64, 32, 35,199,167, 98,217,
211, 59,154, 68,230, 77,243,254,193,  4,175, 84,145,162,168, 48, 79, 92, 74,133,
211,  9,
} ;

// ../Source/Template/GB_emult_bitmap_5.c:
uint8_t GB_JITpackage_108 [637] = {
 40,181, 47,253, 96,134,  6,157, 19,  0,134, 32,100, 39,224,206,234, 24,248, 48,
200, 37,132,178, 11, 64, 89,156,115,100,135,226,231,150, 41, 46,131,209,231, 98,
230,235, 86, 12,130,177, 72, 25,204, 48, 76,243,112, 90,  0, 85,  0, 88,  0,159,
 92,117,213, 92,111, 14,194,106,222,117,242,145,  0,242,128, 52, 14,  6, 30,144,
 71, 25,124,212,246, 67, 39,159,228, 41,184,253,121,150,243,184,145,150,201, 97,
154, 41, 84,213,153,226, 77,221,214,179,129,166,125,171,174, 25,127,127,247,242,
120,109,111, 93, 50,  5, 38,249,234,214,169,  8,134,169,183,109,  7,219,157,199,
171,216,164,220,225,128, 26, 14, 71, 93,237, 58,154, 41, 62,246,190, 83, 15,130,
102,204,144, 92,179,251,251,218, 63,138,156,242,224,244,121,129,233,242,213, 45,
 42,162,125,220,174,151,255, 63,  4, 89, 64,151,127,234, 58,207,246,252,189,102,
250,121,237,210,203,127,130, 30, 19,164, 81,185,140, 98,121, 42, 87,187,217,125,
171, 86,105, 84,125,107,102, 45, 13,134, 73,102,210,106,240, 18,155,147,  2,191,
 33, 28, 95,242,234,143,177,226,102,240,  9,152, 10,167,194,209,200, 12, 54, 41,
152,132,166,251, 81,187, 21, 63,238, 76,183,198,223, 88,129,129,133, 36, 29, 65,
242,199, 43,168, 59,250,185, 25, 37,193,251,217,157,229, 67, 14,143, 50,187,233,
214,176,118, 30,173,114,153,126,116, 49, 11,106,141,214,204,109,204,243,220,231,
111,123, 16,116, 81, 73,135, 46, 36,105,224,213, 31,112,195, 59,214,102,181, 91,
 25,142, 91,187,207,  1,142, 45,248, 12,230,218, 84, 22,174, 57, 59,240,243,211,
 22,147,143,248,113, 66, 62,114, 46, 74,132,165,240,242,210, 72,139,117, 77, 56,
 22,133,203,133, 97, 54,149,173,106,119,179,140,121, 73,190,122, 20, 17, 45,188,
245,  8,199,206,132,159, 15,  8,120,132, 31, 59, 50, 98,160,161,153, 84, 70, 68,
102, 68, 36, 70, 73,161, 49, 80,132, 76,217,221,  6, 73,177, 25, 92, 31,239,100,
 80,243, 48,104, 87, 73,184,248,202,139,212,185, 81,186, 46,169,  5,128,211,120,
123, 31,176,112, 72, 17, 96,208,178,103, 84,239, 70,222, 30, 27, 56,122, 81,111,
  3,174, 29, 17, 77, 60,129, 50,179, 14, 55,213,204,183, 50, 11,110,224, 59,120,
 22, 66, 53, 95,180, 86,150, 79,244,184, 37, 28,136,227,206,233,171, 41,183,255,
166,167, 89,165, 91,158, 41,153,235,147,198, 65,248,192,138,220,168, 25, 10, 51,
 71,174,174, 13,160,201,238, 34, 45, 80,215,107,248,129,  4,147, 83, 88,169,226,
 54, 98,225,  2,162, 43, 56,198, 75,  2, 18, 72,135,134,171,214,158,122,175,115,
113,139,116, 46,131, 61, 26,  8, 96, 28,219, 24,185,172,107,129, 53,  6,188, 94,
 16, 40,  2,159,144,218,  5,169,  9, 20,226,154, 60,216,238,160,113,221,164,201,
252,204,164, 78, 97, 93,125, 98, 20,192, 18,205,197, 94,209,139,  7,
} ;

// ../Source/Template/GB_emult_bitmap_6.c:
uint8_t GB_JITpackage_109 [1043] = {
 40,181, 47,253, 96, 93, 11, 77, 32,  0,246,237,138, 40,192, 82,217, 28,170,114,
140,166,159,109,232,233, 21, 26,172,152,188, 17, 67, 88,219,119,154, 96, 98,207,
168,173, 90,104,215,205,159,126, 87, 81,168,174,  2, 16,128,  0,124,  0,125,  0,
225, 47, 97,122, 11,170, 72,150, 73,127,220, 20,169, 99,110, 83,143,102,219,157,
102,210,216, 54, 71, 55, 19,  9,  6,142,212,245,231, 54,238,206,113,254, 46,104,
231,181, 82,151,  6,150,138,101,130, 80, 80,177, 60,194, 69,151,152,126, 38,195,
 37,234, 29, 95, 14, 65,170, 93,102,212,166,250,196,121, 51,152,172, 51, 29, 51,
 72,170,117,244, 40,125,231,171,119,118,158,186,108,124,167,136,143, 93,222,186,
172,  8, 36,106, 90,192,  0, 20,172, 99, 46,155, 56,193, 76, 61, 91,174, 35,216,
 91,149, 57,133,  2, 77, 40,148,153,218,121,121, 59,231, 41, 90,250,108, 27,247,
 21, 49,197,222,183,191,141,177, 61,239,168, 54,188,157, 92, 69,125,122,  4, 67,
210,200,234, 92,156,137,134,131,128, 60,114,101, 29,138,147,109,153,102,203,192,
 51,225,145,205,  6,194,225, 19,192,177,232, 90,231,202, 50, 74,206,115,227,205,
216,218,254,242,101, 14,173,167,249,165,174,179,109,176,171,  8,134,220, 31,185,
 28,  3, 70,127, 69, 32, 81,183,  0, 46, 49,151, 46,252,114, 99,255,127,  8,250,
128, 32,233,182,216,241, 81, 48, 61,246,255,  6, 56,234, 58,118,253,113,216,138,
 54,112,180,191,161,247,218,181,206, 59,197,127,130, 23,243,138,  1, 29,205,183,
 16, 41, 78, 61,218,133,160,245, 75,150,214,138,109, 72, 51,197, 97,127,154, 84,
 48, 89,222, 99,157,159, 47,211,141, 75,143, 37,187,206,184, 19,188,237,246, 28,
207, 15,119,179,239,135,179,149, 23,150,114,180,246,134, 29,146,150, 77,187,178,
173,115,105, 26,101,101, 28, 10,211, 52,149,148, 86,244,174,225,183,177,109, 88,
149,  9,179,229,176, 20,222,246,120,152, 95,231,168,209,207,163, 39, 16, 20, 50,
 73, 48,157,222,184, 54, 20, 34,145, 20,220,163,157,237,  0,138,237,250,185,192,
 69, 43, 58,231,225,202, 52, 17, 87, 85,121, 66, 76, 55,241,146,131,186,212,174,
 76,  2,157, 87,135,218, 88, 23,131,182,129,192,174,237,193,235,206,122, 52,160,
186,228,175,162, 87, 31, 24,120, 68,188,244, 80,209,169,173,170, 50, 33,190,156,
162,123, 10, 23,167, 95, 74, 15,203, 69,119,120,208,104, 26, 45, 95,118,182,197,
203,124,197,231,237,224,242, 33,145, 92, 33,225,149, 79, 81,  4, 91, 14, 35,137,
184, 91,241,  8, 71,243,204,  1,128,213,168,161,157, 68, 37, 52, 35, 41, 51,201,
178,  6, 48,132, 24, 99,204,202,  3, 18,137, 80, 75,212, 12, 81,136, 64,129, 72,
 48,  1,  5, 34, 65,148, 36,101,165,212,  1, 73,219, 29,167,214, 75, 11, 44, 75,
136, 14, 94, 49, 31,123,192,154, 71, 68,123, 58, 34, 38,183, 31, 62,234, 67,139,
 68,220, 15,148,227,214,228,167, 69, 33, 61, 93,208, 21, 73, 97,190,195,196,150,
177,143, 73,213,190,234,248,226, 60,233, 24, 88,175,233,160,169, 31,167, 85,156,
135,112, 89,  4, 25,  7, 38,103, 56, 51, 19, 23,138,104, 13, 24, 64,231,218, 89,
 98,200, 58, 13, 22, 12, 26,  5,117,159, 72,146,125, 53,  0,172,254, 54,188,109,
242,233,168,175,140,117,212,125, 40,169,140,239,113, 23,175,218, 21,229, 52,195,
139, 28,179,199, 22, 62, 82, 90, 51, 41,125, 90, 62,249, 74,149,156,113, 40,207,
198,175,147,199,180, 11, 19,196,250, 66,237,142, 53, 98,102,194, 47, 45, 20, 47,
180,  0,  8,181, 61,  9,152, 87,194,252,213,163, 70,172,226, 19,148, 29,  1,179,
118,103,210,170,177, 59, 38, 80,188,254,145,198,155,216,108, 22,190,108, 47, 99,
147, 82, 93,214,164,130,214,  0, 24,118,205,181, 95,125,241,112,119, 76,130,205,
205,122,240,237,166, 40, 53, 98, 97, 35,152,137,209, 80, 29,176, 17,115, 98,221,
125,183, 33, 71,  3, 85, 87, 50,176,148,188, 41,233,178,217, 22,154,209,118, 38,
 45, 46, 59,154,146,191,228,133,189, 70,238,230,218,102, 50, 72, 90,224,185,144,
219,  9,186,202, 27,222,159,175, 58, 88,230,132, 13, 35,163, 88,139,255,230,226,
136,126, 85, 87,120, 96,201,105,242, 40,  0,137,101,133,186, 62,158,222, 50,176,
 13, 26,176,  1,243,192, 48,108, 10,152,102, 44,198, 69, 28,188,161, 17, 59, 44,
 36,151,  2, 33,207,130,150,180, 67, 94, 11, 35, 39,214, 69, 50, 48, 91, 51, 21,
236,145, 33,177,225, 19,189, 54,122,238, 51,255,152, 40, 64,184,251, 67,137, 65,
251,188, 91, 66,167, 49,117,168,219, 46, 61,254,204,189,101,250,152,164,255,104,
 30,229,155,102,165,  6,211, 45, 63,157, 84, 81,124,196, 68,131,253,223, 13,164,
 52, 12,154,
} ;

// ../Source/Template/GB_emult_bitmap_7.c:
uint8_t GB_JITpackage_110 [908] = {
 40,181, 47,253, 96, 91, 13, 21, 28,  0, 70, 41,127, 40,192,208,110, 49,250,125,
 72, 82,180, 35,144,249,194, 37, 28,166, 28,157, 36,161,211, 23,185,144, 45,172,
162, 20,124,149,129, 11, 56,184,174,162, 48, 20,  5, 32,117,  0,114,  0,116,  0,
101,125,101, 94,252,193, 59,223, 80, 19,185, 58, 95, 16,111, 34, 13,152,142, 36,
188, 33,243,234,235,185,222,160,  9,236,185, 40,214, 79,  4,148,  9, 37, 82, 25,
152, 80, 46,129,244,147,198, 33,139,185,164,254,  2,180,201, 17,119,159,184,186,
193, 64,165, 53, 51,213,213,166, 45,185,187,241,201, 69,162,120,126,168,107,218,
 99, 15,179,253, 84, 63,109,183,158,221,194, 30,146,122, 93, 54,135, 37,123, 85,
241, 74, 59,110,252,121, 91, 60,199,235, 97,153, 83, 84, 20,161,168, 23,123,188,
 24, 88, 91,208, 87, 10, 71, 56,189, 10,109, 55,122,137, 90,104, 29,135,206,219,
172,127,151,200,246,235,223,246, 13, 98,115,235,107, 62,254,237, 29,236,140,191,
117, 38, 65,235,210,102,179,144,112, 13,141, 75, 27,125,167,110,157,  6,243, 56,
141,135,101,232, 59,143,198,113, 21,224,151, 42,175, 70,250, 99,127, 72, 94,127,
253,178, 89,158,189,170,132, 36,104,223,237,255, 31, 69, 25, 81, 36,185, 73,254,
 18,141,159, 69, 19,  9, 37,114, 65,160, 13,159,201,162,227,106, 38, 32,112,233,
187, 78,129,199,139, 36,249, 73, 20, 19,166,219,247,157,176, 88,191,254,105,194,
200, 32,189,  2, 71,211,105, 58, 79,237,236, 79, 97,190,229,167,109,150,  5,  6,
 25, 16,200, 45,183, 62,249, 69,181,104, 67, 25,172, 32, 52,147,120,131,230, 35,
136, 75, 32,222,118,107,122,197, 51,188, 32, 80, 95,202, 94, 70,117,104,175,  9,
218,222,120,230,155,228,231,226, 21, 69,107,218,242,229, 72,222,142, 19,214, 44,
 29, 33,222,191, 68,110, 25, 81,180,113, 65, 62,217,100,190,198,215,175, 22,111,
180,  1,129, 12,252,122, 68,249,240, 47,251,224, 48, 95,  7,149,175, 24,122,192,
203,140,190,195,209, 56, 13,131,134, 97, 31,169,177, 87,235,167, 78,203, 88,216,
210, 87,205, 83, 55,153,134,233, 54, 11,155,230,113, 62, 55,204, 31,236,192, 14,
169,191,158, 29,163,199, 42,125, 13,239, 62,127,191,103, 11,102, 39,245,167,123,
154,251, 26, 31,143,212,227, 18,191,250,124,197,193,112,186, 63,168, 91,  0, 18,
 24,128,175,160, 97,173, 83, 76, 72, 36,140, 20, 20,164,160,144,198, 96, 68,134,
202,206,  3, 73, 98, 27, 40, 53,220,226, 12, 27,228, 77,150,187,207,178,148,175,
 61,113, 32, 52, 32, 63, 41,236, 62,145, 29,181,227,228,100,220,112,237, 79,225,
222,143,  2,128,146,174, 69,162, 71,102,205, 78,177,191,213,204,240,228,  0,195,
103, 13,232,122,183, 10,213,228,192,163,  1, 75,208,227, 10, 68,  8,100,140,126,
147,113,  6,237, 62,193,232,150,155,119,180, 88,182, 61, 55,220, 37,  0, 47, 90,
116,240,108,110,236, 39, 51,  3, 11,249, 59, 51, 77, 12,115, 32, 25, 60,125, 81,
144,129,251,142, 21,243, 83, 23, 84,129,253, 43, 91, 80,107, 51, 62, 94,  6, 24,
152, 51, 76, 63,215, 25,  3,212, 10,120, 90,  0, 32, 13, 56,253, 14,109,202, 90,
 73, 62,225,235, 86, 71,  9,  7,129,225,206,104, 20, 77, 35,190,217, 62,195, 75,
105,229,121, 98,169,172,185,231, 52, 22,122,180,132,  5,106,  1, 60, 58,128, 21,
121,208, 14, 19,107,142, 95,190,181, 48,216,176, 18,237,170,216,  1,220,129,  2,
205, 41,156,172,213,172,137, 29,180,180,185,205,189, 97,  5, 98, 87,248,238,158,
214, 75,131,224, 14,110,160, 27,  3,233, 26, 27,144,109, 12,185,133,183,180,223,
106,176, 30, 70,174,  3, 30, 78, 49,  5,203,186, 69,139,235,250, 36,117,231,220,
195,153, 82,230, 62, 83,  6, 55,234,  2,215,187,220,104,134,155,214,121, 48,  8,
171,237,166,229,206,228,197, 13,129, 91,176, 70,111, 33,140,125, 86, 45,133,238,
161,128,109,131,222, 95,  0, 69,161,  2,204,246,198,  5,139,221, 20, 46, 73,199,
241,158,182,158,105, 53,102,230, 62,155, 38,230,103,166,187,142, 87,112,206,168,
124,110,234,138,189,162, 28, 15,
} ;

// ../Source/Template/GB_emult_bitmap_template.c:
uint8_t GB_JITpackage_111 [876] = {
 40,181, 47,253, 96, 14, 11, 21, 27,  0,198,165,116, 40,208,176,108, 14,250,141,
 27,255, 96,191,196,151,148,134, 76, 61,146,138, 94,179,165, 62, 67,124, 96, 90,
239,230, 72,128,176, 28,199, 62,224,139,135, 34,247, 23,107,  0, 98,  0,106,  0,
212, 67,179,109,238,  2,105,108,123,163, 24,  8, 69,101, 51,113,253,  1, 27, 55,
231, 56,119, 22,148,243, 90,227, 37,131,137,100,  2, 81, 40,144, 76,254,216,162,
 75,152,126,180,202,167,248,140, 46, 95,143, 98,151,174,136,145,221,167,129, 15,
148,198,160,246, 93,157,105,120, 65,159,  0,156,213,170,  6,139, 97, 94,146,  4,
 83,124,245,121, 74,103,173,126, 94,231,236,211,188, 76, 59, 89,174,161,215,153,
124,120, 36,  2, 65, 34,145,231,224,248, 35, 70,223, 68, 11,187,200,236,186, 68,
199, 56,150,235,138,148,237,250, 57, 72,144,146,122,167,  1, 18, 95,189, 19,159,
 55, 10,102,220, 32,193,159,179,133,108,233, 51,182,119,147,226,165,249,220, 22,
255,127,  8,218,128, 32,238,118,185,189,119,151,111,239, 49,103,251,107,238,214,
 63,213, 26,122, 14,222,191, 65,237, 50,254, 19,166,159,144,100,154, 64,186,219,
180, 47,158,  2,118,222,221,178, 11,172, 89,115,206, 95, 74, 41,169, 99, 60, 34,
 12,203,166,  2,235,242,181,207, 97,231,210,187,115,171,109,151,  7,239,227, 61,
247,109,239,192, 64,  4, 48, 49,204,132,101,201,102,116,174,118,151,105, 88, 91,
253,215,176, 91,244, 10,198,  2,145,201,230,156, 30,202, 89, 41,169,122,111,167,
113,109, 41, 53,241, 98,154,197,183,165, 24, 75,134, 99,145,200,176, 75,132,167,
 57, 15, 21,144,146,250,  3,131,153,112,  8, 16,212,  1, 81, 91,199,173,232,143,
204,171,234, 86,164, 80,171,102,157, 18,104,156,  0,246,151,209, 69, 48,  7,194,
114,113,226,230,178,106,119,  4,108, 19, 66,192,155, 11,235,102, 35, 82,182,141,
 27,252,172, 75,148, 38,179, 33,121,245,207,  4,222,172,129,253,221,123,225,182,
105,221,229, 55, 14,171,214, 27,196,102,250,139,143,105,151,159,113,189,107, 42,
 26,140,  2,222,106, 98,115,130,131, 93,225,198,210,204, 76,226,138,214, 23,128,
172,168, 49, 73,135, 42, 32, 25, 73, 74, 82, 40, 53,  6, 96, 36, 16, 42, 50,154,
  7,242,120, 40, 88,113, 32,168,140, 51,198, 40, 50,161,  4, 18,140, 72, 40,146,
149,106, 27,148,136,162, 97,195, 78, 39,107,248,220, 60, 30,144, 44,226,135, 71,
  2,198,111,225, 24,150, 87,161,112,120, 54, 56,209,106,179,121, 48,193,205,240,
234,230,228, 22, 23, 32,218,105,242,194, 56,185,126,221, 21,160,226,103,132,133,
196,237, 35,105,167, 35, 82,205,246, 44,136, 63, 22,143,122,151, 19,142, 27,101,
 86, 21,215, 69,132,  7,145, 71,142,132,104,227,214,170, 13,144,  7,206,176,232,
129,201,116,141, 73, 60,234, 12,  4, 92, 10, 40, 56, 50,166,120, 17, 69,198,246,
134, 42,145, 97, 79,104,182,187, 48,105,  2,104,198,135,144, 24,238, 44,210,203,
176,108,228, 17, 88,198,135,143,249, 74,  4,185,143, 20,  6, 62,193,221,146,138,
160,201, 62, 58,217,197, 34,163,100,116,244,222,240, 63,124,  5, 34, 75,174,120,
  4, 99,156, 93, 36,197,125, 77,112,150, 11, 27,218, 49, 49,240,231,221,168, 13,
225,  6,243, 41, 14,217, 92,132,239,140,142,145,160,103,179, 12,104, 20, 48,122,
251,132, 32, 18,141, 35, 86, 13, 99,183, 73, 54, 30,145,129,150,  8, 41,167,240,
 32,161,108,  0, 93,108, 67, 55,  3,135,  9,255, 15,  6,142,160,122,228, 20, 34,
212,118,131,216,143,173,163,115,212,142, 39, 25,248, 95, 94, 76,195, 96,199, 56,
  8,198, 48,212, 83, 96,160,135, 38,182,229, 35, 74, 89,221, 94,247,121,200,180,
238,201, 45,130,170, 93, 50, 98, 93,113,192,243,216,210,247, 28,225,171,101,156,
146, 81, 54,118, 57, 42, 40, 76,193, 82, 52,114,129, 86,110,154,163,159,153,192,
 64,167,254,113,182, 91,154, 56,202,107,172,229,148,238,128, 19,
} ;

// ../Source/Template/GB_ewise_fulla_template.c:
uint8_t GB_JITpackage_112 [740] = {
 40,181, 47,253, 96,215, 10,213, 22,  0,118, 33,103, 33,208, 90,231, 64,  7, 52,
163, 10,250, 51, 53,247, 75, 24,152,144,194,255,190,145,200, 53,113,227,167,252,
131, 43, 60,226,  3, 92,  2, 92,  0, 90,  0, 93,  0, 54,243,178,164,223, 20,137,
 67,130,208, 64, 28, 18,215,196,236, 27,182,169, 42,121,129,158, 69,230,147,201,
106,190,129,180,210,145,103,189, 19, 71,227, 91, 79,176,179, 69,129, 88, 99,179,
199,247,173,199, 45,218,155,171,233,138,151,101,125,223, 38, 85,239,  6,244,220,
224,222, 29,157,107,121,154, 58,135,181, 44, 81,162,176,177, 85,117,216, 77,110,
 48, 96,  4,131, 33, 33,213,168,225, 27,229, 56, 47,251,237, 83,174, 54,116,150,
247,209,172,223,186,111,244,249,255, 49,204,133, 97,  5, 92,182,121,187,116,209,
222, 54,123,116,150, 89,127, 79,162,143,141, 81,207, 39,147,212,252,133, 19,182,
199,246,171,147,  5, 59, 20, 18,132, 38,197,122,210, 59,110, 91,145,205, 20,130,
104, 43,132,142,  4, 83, 24, 59,117, 27,119,230, 56,147,163,185,102,156,117,137,
 26,155, 20,241, 53, 51,195, 99,237, 75,230,208,132, 50,203, 46,203,122,235,249,
211,116,122, 53,141,234, 61,  3,148,134,216,134, 52,187,200, 62,126,118, 20,144,
 93,147,249, 64,144,106, 94,102,114,127, 14, 23,140,108,218,103,108,158,196,255,
113,173,101,138,217,193, 10,221, 88, 60,207,235,186,238,241, 85,132, 64,175,101,
231,190,162,130,127, 24,143, 38, 24,246, 10,133,186, 80, 23, 10, 97,216,107,192,
 33,188, 15,164,112, 62,241,113,239, 48,224, 14, 27,162,149, 29,115,177, 80,186,
 42,226,247,173,165,216, 35,162,133,137,236,104, 82,218,160,243,115,238,141,203,
 42,250,118,126, 91,209,111,154,111,242,184, 70,178, 53,123,247,101,104,197,251,
 36, 18,203,197,251,192, 16,164,132,152,139,200,222, 53, 24, 64,126,254,241,195,
185,159,153, 38,218,128,139,160,161, 65, 67, 34,129,136, 72,146, 36,217, 24,  3,
 80,132, 16, 33,187,213,  1,153, 17, 57,165, 29, 14,181,147, 61,112,  9, 22,129,
  8,101, 39,237,255,227,148, 87, 38,245,135,138,170,136,148,181,232,158, 86, 81,
202, 22,213,160,104, 56,102,235, 75, 26,182,100,104,185,  7,176, 12, 60,225,190,
133,172, 13,243,164,183,152,212, 35,133, 80,129, 18,130,193,  2, 69,209, 26,100,
144,151, 70,134,  3,160,212, 12,177,102,142,152,  4, 28, 11,208, 96,150,209, 47,
135,157,129,142,236, 98,172, 20,161, 28,106,165,  0,120, 40, 25,140,  1,133,160,
126,219,117, 73,242,224,131, 14, 71,250,  3,193,232, 53,174,  5,252,101, 24, 51,
 30, 47,149,  1,152,106,217, 90,195,178, 66, 17, 39,106,  3,217,190, 53,  1,211,
 25,  0, 74,218,199,132, 27, 62,243,158,236, 64,194,112,252,153, 67,234,239, 50,
 45,246, 36,143,255, 23, 50,179,176,249, 28,113, 15,128, 66, 63,219,160,192,112,
  9,248,  0,217, 12, 84, 82,144,  3,193,228,109,102,247, 77,176, 33,135,108,156,
145, 96, 69, 30, 57,100,148, 68,116, 59,171,209, 34,130,224,  1, 49,  0, 44, 58,
200,  9,224,111,  0, 64, 15,247, 52,130,165, 86, 33,248,240,180, 75,171, 50, 67,
126,  5, 10, 60, 72, 37, 59,148, 38,134,234,175,108,120, 15, 35, 64,156, 15,227,
105, 50, 17,207,224,212, 24, 38, 51,121, 51,177,214,194, 49, 67, 75, 81,160,  7,

} ;

// ../Source/Template/GB_ewise_fulln_template.c:
uint8_t GB_JITpackage_113 [639] = {
 40,181, 47,253, 96, 10,  6,173, 19,  0, 22, 96, 99, 32,208, 28,231, 24,149,213,
255, 59,212, 71,162,195,106, 72,143,165, 21, 58, 78,205, 40,154,106,  0,244, 15,
174,240, 72,  7,241, 11, 90,  0, 87,  0, 91,  0, 42,219, 57, 73,210,123, 11,  5,
 66, 81,112, 36, 16,138,119, 34,119, 15,219, 87,165,220, 64, 47, 27,115,217,178,
158,123, 33,205,124,163, 89,207,203,163,241, 89,205,176,179,117,133,219,251,172,
199, 45,218, 51,215,214, 23, 39,201,250, 62,123,132,253, 35,208, 75, 14,254,209,
185,146,102,171,179,233,146,164, 43,101,106,108, 97,109,250, 46, 63, 28,182,194,
225, 16,178, 24,120,212,173,247,190,123,244,185, 85,255,255,109,163,109, 91, 96,
 52, 92, 87,224,141,114,145,226,181,130,109, 51, 96,178,239,217,172,247,109,213,
101,183,254, 44, 83, 71, 53,118, 61,151,247,199,118,244,124, 67, 24, 20,133, 30,
197,106,210, 63,206,182, 41,155,111,163, 48,133,198,183, 69,155, 41,136, 40, 28,
  3,170, 95,103,227,238, 28,231, 49,176,107,239,141, 98,237, 58,230, 55,228,230,
 71, 75,108, 39,  5, 16,  0,126, 29,229,158,201,124, 44,166, 16,227,233, 84,194,
144,118, 32,119, 37,127, 54, 49, 26,249,218,103,124, 75,241,144,119,179, 43,114,
 15, 51, 20,164,  1, 65,240,251, 62,200, 99,147,  2,125,199, 93,242, 24, 29,188,
194, 25,121, 76,180,163, 63,203,195, 61, 42,145,128,220,207, 46,115,181,167,  7,
219, 86,219,106,  4,201, 17, 32,119,206,166, 18, 98, 66,149,239,244,157,184,127,
 37,147,244, 88, 99,178,166,238,153,247, 98,244,158,167,114, 89,217,202,157, 86,
 58, 52,  3, 86, 40,167, 17,  8,145,155,135, 28,113,201, 77, 78,180,185,102,204,
 53,233, 66,245, 40,226,119,151,195,168,218,231,152, 77, 45,215, 37,251,172,230,
205, 86,249,218, 82,213,211, 20,200,106, 99,160,113, 57, 83, 51, 34, 18,136, 72,
148, 66,105, 56, 96, 68,102,170,106, 55,205,133,164, 24,108,119,112,107,194,111,
 39,187, 40,104,225,142,181, 17, 69,176, 60, 65,232,113, 49,235, 26, 72,191,209,
 51,194,  4, 19, 65,171, 32,192,148, 29,220, 31,188, 17,139,150,236,207,230, 11,
173,163,241,194, 14, 28,181,229,109,248,108, 69, 74,164,108,111,203,252,129, 51,
184,124,138, 70, 50, 25,  3, 19,123, 99,139,146,180,110,224,124, 76,137, 29, 52,
 69,100,106, 24, 61, 96,116, 54,  5, 69,212,  7,160,120,234, 60,206,250,246,194,
152, 63,113,225,200,108,  2,202, 54,  8,164, 80,172,195, 67,196,116, 78,186,216,
102, 55,142,167, 29,108,179, 75,216, 62, 67,198, 91,230, 47,185, 34, 56,200,194,
195,144,  0,150,  3, 28,236,117,  2,187, 46,107, 69,  0, 73,122,215,105,177, 32,
 52,191,  6, 69,217, 37,146, 37,188,216,107, 19, 52,  2, 84,  3,112,  4, 50, 86,
  8,104,211,236,252,204,148,126,209, 10,183,  8, 19,167, 93, 85, 81,135,  7,
} ;

// ../Source/Template/GB_iceil.h:
uint8_t GB_JITpackage_114 [236] = {
 40,181, 47,253, 96, 35,  1, 21,  7,  0,114, 14, 45, 23, 64,219,  1, 22, 70,217,
219,190, 77,  7, 33,125, 81,192, 98,236, 66,  4, 26, 59,154,  4,128,  0,  0,254,
151,125,184, 61, 36,109,  8, 77,244,128,  5, 65,232,161, 43,176,208,245,151,113,
227, 70, 79, 15, 61,205,223, 37,155,118, 23, 55, 88,222, 11,120,  0, 80,156, 85,
 73, 80,  5,250,151,193, 15,  0,228, 80, 12, 23, 61,108, 58,221,156,254,224,167,
217,191,202,112, 52,187,247,150,177, 69,215,241,249,122, 58,234, 88,163,169, 24,
 62,214,227,232,116,177, 40,136, 98, 48,  9,162,244,224,  9, 93,160,191,226,168,
 15,167, 91, 49, 45,201,215,186,200, 28,235, 17, 77,124, 78,141,163, 39, 54, 51,
 79, 95,205,128,161,187, 88,232, 48,127,159, 37,216,104, 46, 63,253,252,160,127,
221,136,199,248,238, 61,247, 76,125, 47, 96,220, 27, 15,  0,  4,  3,194, 37, 40,
 94, 64, 37,196,188,106, 43,224,213, 42,156, 77, 22,208, 39,106, 87, 51,104,218,
 60, 51, 69,155,192, 86,235,  1,131,  8, 59,215,167, 40, 24,  2,
} ;

// ../Source/Template/GB_jit_kernel_proto.h:
uint8_t GB_JITpackage_115 [2452] = {
 40,181, 47,253, 96,170,145, 85, 76,  0,154, 73,  8, 14, 39,208,176,204,  3,239,
189,192,126,148, 26,178,110, 73,166,115, 34,229,154, 10, 66,140,141,213,199, 70,
126,  3, 33,132, 84, 91, 96,205, 82, 15,131, 43, 30,128,215,  0,206,  0,215,  0,
 60,212, 44,243, 98,109,152,  7, 52,189,251,125,218,142,203, 63,226,108,219, 35,
239, 70,222,187,186, 67, 96,241, 89, 99,189,200,111,250,213,143, 48, 40, 22,223,
249,158,239, 71, 31,167, 95,228,251,156, 10,122,190, 33,228, 31,107,221, 61, 46,
 30,170, 57,212,204,207,182,225,  6,164,226, 98, 97, 36, 30, 54, 95,141,245,  0,
 30, 15,211,194, 89, 46,218,196,172,236, 98, 69, 76,141,245,178,230,  2, 60,  6,
  4,164,  0,251, 85, 10,198, 71,216,246,106,110,207,214,187,  2, 44,207,182, 94,
 44,128,162,210,  4, 60,219,217,150,219,203,243,254,101,220,203, 99, 28, 63,162,
 72,  3, 82,128,193,100, 64,122,168, 66, 62,226,183, 67,171, 23,136,255,249,186,
230, 92,238,163, 45, 98,242,  3,233,118, 64,176,124, 83,112,179,253,134,219,131,
 63,119, 65, 60,198,244,183,214, 60,183,224,167, 63,194, 39,160,187,222,224,196,
 54,111,187,153,253,106, 76,233,240, 18,201, 35, 64, 34,  9,149,118, 24,211, 58,
229,111,182,205, 76,211, 68,161, 80, 50,148,179,142, 74, 27, 33,169,107,111, 74,
 79,148, 56, 75, 53, 37,  5,180, 41,166,149,127, 24,  2, 64, 13,121,254, 30,239,
110,114,248,245, 40,135,154, 37,195,208,248,137,209,203, 82,149, 73, 29,185,235,
228,129,204,119,122, 36,150,211,139,233,219,238, 63,148,243, 30,249, 94,166,239,
161, 62, 34,137,122,  8,246, 80, 79, 15, 53, 37,212,249,196,203,183,155, 31, 12,
130,220, 54,169,178, 75,206, 10, 76,211, 94,242, 59, 43, 82,202, 24, 99,229,163,
140,124,235,197,124,110,236,172,120,212,238,143,231,168,243,139,113, 53,220,157,
207, 13,167, 93,198,168, 50,117,159,212,247,122,119,231,118, 71, 95,101,242, 59,
 63, 74,198, 74,231, 89,215,136,122,207,221,157, 86, 30,242,158, 71,171, 42, 70,
 32, 15, 89, 90,  5,151,245,237, 17,200,191,214,228,107,202,237,  0,129,122,110,
 27, 86,116,112,112, 48, 77,147,148,146, 66,137, 58,223, 87,179,153, 32,  5,114,
116,237, 56,228, 88,105, 96,114, 24,166, 98, 69, 28, 54,119,146,237, 72,105,155,
220,197,154,200, 88,219, 37,106, 27,132,113,168,193, 48, 76, 67,231, 86,  8,164,
156,126,187,217,105,205, 90,172,112,151,156, 92,164, 50, 11, 85, 65, 22,211,202,
177,174, 22, 22,169, 13,179, 80, 29,185,111,218,121,143,216,108,205, 49, 47, 12,
134, 94,198,180,147,183,203, 69, 30,238,241, 13,187, 10,187, 48, 82,154, 16, 72,
158, 14,157,156,126, 51,  4, 43,  1,  1,193, 79,211, 84,161,245,173,249,212, 30,
183, 57, 80, 12,206, 44,137,108, 11,126,190,223,250,249, 83, 31,201, 72, 92, 96,
168,252, 39, 83,  5,202,  7,164, 84,104, 57,252,234, 91,220,133,218,139, 60,148,
 51, 53,153,200, 83, 51, 15,245,114,116,167,211,242, 77,117,157,150,135,209,214,
189,218,206,220, 22,156, 19,234,183,243, 80,206, 93,219,135, 19,143,135,230,122,
217,  2, 60,254, 31,218,128, 72, 84,112,154, 69,154, 92, 56,204,182,105,154, 36,
 77, 36,102,101, 44,214, 37,203, 98, 67,198,146,  7,  7,211, 68,161, 84, 44, 41,
109, 91,131,204, 42, 76, 14, 72, 19,173,170, 34,  1,193, 52, 77, 20, 10,151,101,
 82,130,244, 80,  6,  4,161, 10,244,171, 97, 55,200,245,174,148,243, 94,166, 95,
223,250,227,221,118, 81,190,115,210, 15,196, 52,235,155,195,204,114,101, 24,142,
252, 17,158,233,238, 91, 22, 47, 28,  4,132,  6, 68,214, 88,215,235,202, 87,228,
 61,214,203,215, 39,211,153, 57, 92,219, 22, 37,  6, 33,103, 92,206,105, 23,114,
207,242,240, 37, 18, 10,220, 80,151,118,232,197,224,133,105, 87,146, 36,138,163,
137,229,244,  3, 39,214, 22, 31,180,200, 98, 47,211,111, 86,170, 90,108, 57,101,
 97,214, 86,113,232,157,177, 92, 26, 64,190,217, 26,135, 53,244,236,166, 48,149,
117,201, 57,139,212,242,203, 97,163,181, 93,153,130,144,168, 50,212, 80, 33, 53,
 51, 35, 73, 73, 10, 82,104, 12,130, 82,  4, 97, 96,146,131, 56,233, 32,222, 34,
 56, 36,136, 65, 32,  6, 65, 16, 12, 97,  8, 16,132,128, 70, 16,  4,225, 16, 12,
 97, 64,132,  8,  8, 33, 20, 25, 99,172,146,179,  3, 79,112,160,252,209,165,247,
240,201,209,170,188, 21,191, 16,213, 17,113, 42,235, 99, 48,172, 65, 91,  5, 24,
228,250,251,130, 48,  5,180,158,146, 31,130,114,146, 14, 21,185,  3,129,151,247,
225,254,237,109, 84,247,139,188,136,169,136,224,192, 59,103, 68, 66, 48,186,182,
 92,224, 68,242,122,174, 77,162,126,202,  2,110,224, 75,245, 11, 40,247, 65, 61,
134, 64,108,136,198,203,195, 41,165,174,  1,168, 15,225, 10,248,166,  1, 77, 25,
 33,109,144,185,250,130, 28,128, 99,117,174,248,164, 50, 56, 56,207,247, 79, 19,
208,151,135,101, 61, 46,103,188,132, 39,137, 82,200,185,170,219, 82,199,153,249,
 65, 41, 74, 43,  4,  9,  3, 18,115, 87, 66,105, 91, 69,220,138,  2,106,  8,252,
198,244, 31, 49,155, 69, 81,153, 89,112, 38,154,143, 94,187,115,149, 38,124, 57,
224,140, 75,156,124,247,199,127,165,230,185,162,180,219,229,130,  2,120,228, 20,
244, 46, 26, 82,118, 51, 48,255, 41, 75,172,155, 73,153,178, 76,148, 77,131, 33,
135, 86,113,156,196,  0,178,152, 25, 21,135, 86,249,105,165,215,134,152,127, 54,
179, 62,179,148, 95,141, 27, 78,248,176,209,116, 96, 59, 20, 19, 92,104,244,113,
 83,244,147,135, 61, 10,132, 56,200,170,115,163, 27,108, 95,205,137, 49,102,119,
129, 89,163,106,118,205,105, 63,171, 51,195,173,211, 50,241,192,250, 11, 44,215,
 21,  0,139,184, 11,207,235, 98,  3, 79, 99,203, 62,198,217,111,199,119,214,115,
185,134,205,135, 40,185, 48,166,165, 75,237,195,170, 70,149,203,142,  8,204,138,
157, 70,162,146,108, 89, 35,155,108, 55,  2, 75,144,121,105,119, 49, 11,140,163,
235, 47, 10, 37, 63, 83, 21,200, 87,241, 21,193,202,196, 39,170,114,144, 31, 26,
135,150,156,100, 51,189, 51, 67, 46,125, 86,  5,147,246,205, 10,233,199,159,109,
 22, 31,200, 31,235,113, 43,236, 80,246,  8,164,208,241,215,154, 74, 97, 39,  1,
 99,140,159,143,235,226,110, 21, 43,173, 82,211,134,111,170,  9, 81, 93, 54, 33,
 91,138, 51,250,205, 29, 82, 22,242,127, 20,209, 57, 24,220,  3,117,191, 45,113,
109,111, 81, 52,223,132,194, 63, 76,148,223,  0,146,105, 99,186,138,113,168,  3,
 21,133, 32, 79, 60,204,120, 52, 83, 86, 48,157,181, 35,  9,244, 15, 23, 61,144,
 54, 54, 10, 99, 53,234, 96,133,166, 71,209,205, 54,113, 12, 83, 59, 96, 92,115,
157,168,201,186, 88,120,239,230,117,234, 56, 18,204,128,236, 78,234,157, 87,245,
 21,149,204,155, 10,143,117, 44, 30,149,160,113, 64,201,  9,186,  9, 87,  9,188,
 86,120,255, 44,190,101,182, 10,131,115, 31,148,  1,198,119,250,164,223, 38,  9,
 52, 13, 79,137,136,115, 91, 41, 93, 76,106,165, 50,192, 59,134, 61,221,203, 10,
 90,197,247,208,210, 29, 32,169,196,  3, 90, 64,236, 34,215, 93,214,205,213,231,
 33,141, 86,215, 63,218,104,223,  0,245, 86,107,185,222,228, 30,210, 27,  5, 92,
232,246, 76,233,203,144, 30,154,234, 20, 92, 92,242, 37,137,196,172, 55, 14,173,
128,150, 14, 31, 56, 33,123,220,233,127, 87,125, 91,191, 61,105,161, 25, 21, 58,
108, 52,124,112,225,185,143,160,117,236,141,126, 45,114, 78, 39,202,244,152,162,
109,230, 40, 69,181,128,107,128,140, 96,139,208,135, 36,239, 62, 17,229,177,123,
172, 13,181, 35, 73, 96,120,157,160,133,178, 48, 93,117, 69, 30,250,196,140,180,
  5,145,161,  7,205,178,119,154,236,  9, 26, 14,232,249,  6, 93, 60,  2,110,192,
 67, 58, 57,251, 88, 16, 51,144, 22, 32,204,192,138, 93,188,103, 24, 35, 15, 75,
143, 72, 19,218,133, 99,188, 89,136,204, 38,145, 38,129,196,221,209,124,201,132,
230, 93,235,157, 65, 97,100, 96,165, 65,101, 88,193, 60,171,148, 98, 14,223,109,
168, 86,104, 23,164, 54,  7,100,226,221,249,115,178, 28,241,108,183, 97,139,202,
 34,191, 55,127,187, 53, 16,137, 51,197,143,175, 95,106,174, 11,207,131, 71,167,
126,206, 15,204, 96, 96, 50,174,215,174,220,169,164,179, 11, 15,112, 90,  7, 69,
 61,249,126,229, 37, 98,140, 99,107,126,105, 40,193,208, 50,160,163,190, 29,217,
123, 97, 28, 56, 56, 23,164,135,125, 79,132, 79, 93,193, 10,213, 67,113, 71,178,
128, 39,130,167,113,222,211, 86,136,152,146, 21,117,200,  3, 13,163,140, 80, 86,
237, 78,151,122, 49, 10,111,204, 88, 45, 19,212, 55,255, 97, 21,216, 27,136,163,
102,119,219,139,169, 47,160, 88,114, 36, 31,132, 43, 77, 24,100,210,139,211,251,
182,159,  8, 78, 32,236,103,145, 70,217,253,  7,210,236,  0,145, 19,205,133,247,
197,180,121, 46,225, 67, 20,242, 76,243,173,196,174,210,138,159,111, 54,206, 80,
 42, 58,225, 82,209,148,153, 42,225,171, 28,198,240, 46,218,246, 64,185, 88, 32,
 12, 64,200,  1, 30,120,253,  4,163, 66,166,192,  3, 99, 50,113,104,234,213, 58,
223, 71,167,254, 55,212,241,193,163,133, 15, 42,155, 37,142,157, 56,170,  3, 49,
221, 32,242,142,131, 47,167,230,121,213,155,214,187,155,111, 79,125,153,104, 37,
106,133,  6,248, 43,249,248,149,169, 44,209,145,  8,161,217, 94,113,152,181,108,
 23,220, 28,246, 61, 52,186, 76,249,250,123,253,167,115,241,209,192, 27, 95,249,
 27, 72, 36,158,246,130,202, 90,162, 64, 30, 43, 16, 65,192,148,223,238,227,181,
127,178, 84, 59, 71, 89,138,156, 15,210, 76,160,147,217,132,225,208,150,222, 45,
113, 22, 41,202, 11,205,201,  6,237, 55,160,147,167, 29,171, 43,129,217, 76,122,
205, 86, 90,185,230,242, 10, 99,205,251, 41, 15,170,  8,173,225, 59,223, 43, 45,
 38,253,150,235, 39, 17,188,208,132,186,196, 29,243,141,193, 22,249, 17,164, 38,
216,122, 41,118, 10,208,196,231,109,195, 64,138,205, 30,209,121,  3,173, 52,100,
160,119, 34, 54,169,225, 15,  2,100, 30,133,173, 68,204, 21,184,119,108,174, 40,
 94,184,132, 94,177,155, 11, 93,112,209, 51,  1,214,245,143,103,140,102,130,211,
169, 19,  1, 41, 81,198,134,215,199,153,  0, 25,197, 16,157,159,220,218,137,167,
172, 44, 31, 68, 59, 52,233, 22, 49,178,201,227,112,180, 79, 29, 16,186,140, 77,
159,  6, 86,128,150, 77, 46, 10, 80, 91, 31, 81,  0, 36, 50, 15,130, 88,193,160,
 69,183,102, 73,132, 16,154,130,202,123,207,188,154,127, 82,161,200,242, 47, 86,
 48,111,241,250,186, 58,105,152,179,  6,229,190, 56, 42,217,161,163,241,186, 37,
  5,175, 10, 43, 43,128,240,205,167,  6,254,246,142, 83, 70,106, 76, 29, 69, 99,
128,118,  5,155, 62,160,160,110, 28,120,139,125,203,  8,181, 21, 23,111, 71,132,
185, 66,253,131,230,182, 81, 32,235,106,214, 31, 52,  3, 14,204,244, 75, 71,221,
188, 49,182, 73,237,199, 49, 23, 85,175,238, 23,
} ;

// ../Source/Template/GB_log2.h:
uint8_t GB_JITpackage_116 [613] = {
 40,181, 47,253, 96,114,  4,221, 18,  0,230,225,102, 32,  0,153, 27, 87,209,154,
120,225,232,208,118,180,139,154,137, 13,147, 19, 86,217,177,250,154, 88,174,143,
252,255,255,254, 16,  2, 95,  0, 93,  0, 92,  0,213,187,223,174,208,100,131, 77,
 63, 93,199,206,105,156,193,239, 57, 77, 41,164,  9,  7,173,160, 93, 10, 67, 65,
107,171,139, 77,192,127,146,147,198, 32,173,  2,179, 45,189,167,  9, 29,200, 22,
  1, 77,242, 90, 24,142,175, 52,117, 60,127,216,  1,104,237,217,190,142,178,166,
246,190, 73,157,131, 93,207, 42,187,175,127,158,235, 55,  3,196,180,207, 82, 46,
 98,233, 44,  3, 92, 89, 22, 22,219,219,125, 70,210,201,112, 28,202,134,217,100,
 52, 18,172, 74,  7,243, 87,159,190, 95,107,169,103, 89,177, 61,235,171,199, 61,
232, 69,108, 68,  2,145,104, 21,165,178,116,109,109,194, 87, 45,237,233,245,123,
 92,195,174,178,235, 55,206, 63, 10,120,253,  0,224,194,105, 22,205,230,249,172,
222,  7,  0,  5, 76,187, 28,236,164,  9,210,140,235,239,125,174, 62, 49,151,227,
184,179,180,218,236,187, 22, 11,235,135,117,221,151,101, 12,108,202, 25,108,119,
236,152, 58, 71,163,217, 42, 22,169, 45,167,163,208,206, 24, 99,119,108, 43,115,
136, 68,174, 31,198,184, 97, 40, 83,122,198,245,113,216,132,217,109,145,226,182,
137, 54, 74, 87,180,227,234,103,250,225,136,227,252, 36,193,206,182, 54,118, 59,
219,254, 12,115,167,169, 12,241,127, 58,123,  1,  0,171,208, 14, 71,199, 22, 68,
204, 79,159,229,231,117, 58, 14,219, 71,147,134, 22,196, 93,237, 99,236,215,132,
 31,244,116, 99,246,250,234,218, 38, 88, 84,206,157, 76,121,227,111,210,183,135,
 55, 55,126, 13,200,195, 85, 52, 28,135,  2,210,108,184, 14,  6,224,253,172,134,
190, 12,215, 21,155,209,133,126,180,165,117, 35,118,236, 82,  6, 49, 28,185,174,
131, 89,147,  5, 76, 32, 64,132, 16, 98,102,231,226,139,217,182,166,206,235, 78,
171,176,111, 57,117,149,113, 69, 87,141,131, 65,222,234,181,157,160, 13,100,164,
 40, 23, 16, 26, 41,224, 30,  4,228,209, 28,106,133, 90, 68,249, 84,214, 78,190,
 90, 74, 40,108,116, 96, 81,132,238,203, 21, 33,147, 85,  0, 24, 90,  2,197,  0,
  6,142,198,147,239,  2, 64,  7, 20,185,194,198,196,216,  0,160,149,130,248,120,
  1, 56,192, 72,161,  5,228,  2, 28,146,110,152,202,190,223,130,205,133,145,127,
 22,249,  0,166,172,114, 19, 44,221, 97,129, 90,171, 22,251,200, 97, 35, 16,182,
120, 88, 65,255,  9,191,  8,225,220,184,109, 75, 50, 70,159, 94,152,167,183, 36,
135, 63, 88, 15, 39, 86, 68,186, 64, 37, 30, 34,240,171,  5,102,208,204, 60, 51,
221,134,208,106,243, 67,224, 56, 89,133,162,206, 13,
} ;

// ../Source/Template/GB_math_macros.h:
uint8_t GB_JITpackage_117 [706] = {
 40,181, 47,253, 96,155,  5,197, 21,  0, 38,164,108, 32,224, 26,231,201, 71,  0,
188,143,108,167,114, 83,140, 76,168, 47,246,154,206, 81,212,123,234,211,218, 49,
140, 49, 24, 67,  8,  1,103,  0, 97,  0, 94,  0,225, 12, 96,134, 14,193,181,248,
201,148,247,198,237, 25,206, 92, 27,212,112,141,107,127,115,195,141, 42,159, 14,
108,214,109,220,160,227, 44,154, 38,232,148,122,223, 18,  8,  3,130, 99, 28, 12,
136,107, 95,246, 13, 79,150,172,188,243, 62,138,217,162,166,232, 91,200,219, 76,
196,148,188,152, 70,227, 43, 83,161,206,115, 21,194,254,166, 41,212,196,111,136,
 29,182,247, 19,179, 68,145, 38,152, 23, 10, 24, 87, 40,  4, 31,177,252,233,218,
150,197, 84,254, 90, 73,249, 59,109,240,194,185, 19,178,223, 78,217,127, 19,203,
210,181,225,193, 43, 51,190, 98,193,176, 88, 44,154,183,152, 95,237,113, 79,218,
247, 27,174,118,102,153, 87, 41,148,253,158,235,180, 41, 46, 75, 75,195, 95,123,
 49,213, 73,197,119,100,231, 96,149,223, 92, 18,245,173, 78, 20,214,117,  6,176,
 12, 41,228,  1, 81, 50, 34,143, 19, 54, 88,  3,242,227, 93,191,221, 15,231, 45,
174,119,149,251,226, 30, 93,225,155,150, 36,126,182, 53,127,187,205,234,150,205,
 68, 92,114,124,227,174, 75,254,184, 43,211,198,205,149, 65,254,106,124,239,106,
 71, 30,167,163,225,252,182,169,115,157, 29,110, 89, 74,173, 40,250,187,121,109,
203, 84, 93,155,213,223, 58, 60, 30,101,139,202,227, 41,230,217,122,127, 31,171,
188,  3,164, 43, 43,226, 24, 22, 78,176,118,  0,195,  0, 98, 55,  1,111,112, 69,
191, 58,  3, 88, 73,218, 86,169, 32, 31, 90, 58,251,123,116, 52,218,152,253, 92,
181, 85,211,184,236, 13,195, 33,145, 44,187,230,202, 66, 19, 79,211, 24,105,120,
 59, 75,106,232, 18, 29,130, 85,231,193,198,171,198,125,237,236,146,160,202,154,
 39,202, 10,154, 37,197,175,174,194,135, 97,248,195,129,114, 77,168,227,189, 69,
145, 45,109, 99,237,190,  1,113,168,225, 36, 99,140, 49, 19,153, 41, 72, 33,211,
 26, 48,132, 32, 67,103, 61,178, 41, 89,105,  8, 55, 66, 51,145,162,148, 31,229,
219,  1, 89, 11, 16,111, 68, 88,227, 19,  7, 92, 68, 51, 48,236, 23,234,  3, 66,
126,132,148,236,126,101, 83, 62, 53,209,176, 84,  0,144, 36,113, 38,222, 41,117,
 82, 54, 31, 45,  1,101,162,211, 78,164, 32,131, 46,188, 57,187,209,220,132, 90,
 92,158, 51,242,178, 51,205,203, 24, 79,219,174, 89,220, 25, 18, 30,164,171,125,
 92,138,152, 71, 89,183,245, 78,138, 77, 50,231,239,125,139,142,204,188, 91, 60,
159,147,250, 97, 96, 81,  2, 10,168,157,243, 60,190, 71,111, 14,  2, 89,236, 27,
182,198,150, 32, 76, 25,183,232, 53, 70,  3, 84,139,123,249, 90, 86, 44,189,142,
124,  4, 84,229,149,  7, 84,141, 33, 46,188, 28,199, 97, 55, 17, 68,111,120,241,
 14,227,220,200, 16,216,216,209,158,215,228,183, 66,128, 50,202,189,163,183,224,
  3,162,102,254,132, 86, 83,196,195, 95, 38,242,  4,179, 48,159, 24,203,123,148,
209, 36, 81,  1, 25, 83,210, 62,104, 82,149,153,178,126, 55,206, 67,236,220, 18,
 79,208,188, 53, 12,188,
} ;

// ../Source/Template/GB_memory_macros.h:
uint8_t GB_JITpackage_118 [820] = {
 40,181, 47,253, 96,241, 13, 85, 25,  0, 86, 36,111, 39,208, 20,177, 14, 84,196,
253,186, 96,251, 85, 64,172,128, 59,183, 32,236, 78, 33, 15,224,254, 90,189, 89,
  2, 97,182, 31,127,204, 62,224,139,  7, 69,238, 47,103,  0,102,  0,100,  0,140,
 89,176, 94,110,177, 44,163,188,147,175,137,  9,247,100, 75, 78, 19,141,  7, 11,
202,197, 28,203,205,212,251, 98, 30,146,122,150, 93,254, 16, 42,  6,149,137,194,
129, 65,229,206,130,254, 90,114,224,195, 41,151,119,176, 75, 53,121,241,183,185,
 76, 13, 88,133, 54,194,194,109, 97,221,240,149,219,230,249,164,242, 66,139,102,
 25,252, 45, 24,165,169,181,160, 86,117, 44,213, 88,171, 26, 34, 46, 73,207, 68,
146,  2,175,  3,183,184,107, 32,251,235,  1,232,  1,208,227,157,210, 86, 18,231,
 92,133, 34,232,  4,  4,159, 38,140,138, 51,  0,188, 66,143,146,132,227,174, 95,
133, 48, 24, 10,226,255,159,199, 34,131,241,208,215,226,143, 14,250, 71,250,190,
147, 90,191,147, 39,212, 44,215, 91, 26,111, 97,182,145,173, 37,105, 15, 79, 41,
240, 72, 84, 27, 13,229,112,201, 84, 27,148, 38,131,201, 68,190,102,148,  2,143,
  1,165, 50,  9, 22,172, 13, 98,105, 72,148,215,228,206, 88, 64,228,111,254, 34,
174, 95,245,104,203,199,189,105,128,208, 63,182, 12,175, 14,132,190, 16,158,243,
 85, 12,245,107, 90,198, 53, 20,125, 33,210, 55, 93,116,200,245,227,218,185,111,
 66, 14,154,105,186, 56,148,212,187, 40,250, 37, 41,  7,130, 94,178,112,215,127,
174, 70, 80,197,196,244,170, 10, 51, 77, 64, 84,149, 20,253,145,244, 23, 48, 57,
182,108, 68,118,174,159, 12,  5,165,201,168,158,135, 34, 34,237,133, 13,143, 89,
 91,255, 65, 77,163, 54,114,124,164,124, 81,235,108,217,141,122,192, 75,239,179,
 45,114,111,239,130, 43,255,186,  3, 67,162,252,100, 14,230,167,176,221,238, 22,
167, 60,123, 76,136, 89,157, 11,239,214,241,199, 28,218,  1, 19, 26,222, 99, 74,
214, 96,159,177,123,122,189,147,221,201,214,110,214,185, 25,187,224,128,146,160,
113, 49, 83,104, 68,100, 72, 82, 90,201,176,  6, 64,134,  8, 77,205,117,  3,241,
112,  3, 95, 60, 34, 66,172, 22, 59,156, 67, 20,187,103,217, 24,214,152,113, 51,
220, 32,143,148,163, 24,163,216,248,195, 79, 18,155,111,253, 96, 63,174,118,146,
  9,206,182,185,181,184, 28,152,190,143,  4, 66, 11,201, 60,203,107, 65, 88,102,
219,164,225,  7, 91, 13,182,156, 60,216,164,192,159,226,188, 25,107, 16,205,199,
182,167, 92,163,  1,238, 62,240,153,232,122, 87,137, 10,104, 25, 51,123, 51,192,
156, 98,202, 40,217,171,174,  0, 43, 75,149, 34,222, 20, 78,  4,165,149,134,231,
 66, 41,187,161,  7, 24,161, 68, 99,212,  2, 28, 17, 32,123, 73,  7, 65, 43, 58,
 11, 54,115,212,209,129,215, 95,194, 53,173, 28, 43,193,103, 28,113,176, 92,170,
128, 11,210, 68,120,134,130,117,153,  1,171,117, 31,  5,207, 96,  1,112, 64,103,
  6,126,224,249, 28,  4,114, 13,120, 32,  4, 88,122,187,237, 32, 14,237, 64,  5,
200,108, 63,  1, 88,191,195,  6, 29, 30,200, 18,141, 60,122,213,118, 18,186,133,
 31, 34,113,101,213, 14, 65,239,233, 89,135, 66,186,131,  4, 11,162,244,240, 44,
161,177, 42,  0,247, 99,115, 39, 44,251, 44,133,163,136, 61, 62, 39,140, 42, 32,
 27,134,225,105,176,101, 39, 12,253,140,  3, 30,115,168,  6,195,227, 80,239,147,
215,137, 27,  0,145,126,138,100,  9,  9, 51,135,100,162,193,239,160,116,238,191,
 21, 58, 14,252,212,  8, 57,244,234, 90, 92,115,106, 71, 90,220,192,167,138,  0,
 26, 52, 49, 42, 51, 81, 47,192, 10, 39,  0,234, 62, 24,133, 62,188,162, 23, 15,

} ;

// ../Source/Template/GB_meta16_definitions.h:
uint8_t GB_JITpackage_119 [2278] = {
 40,181, 47,253, 96,159, 48,229, 70,  0,138, 77, 84, 14, 45,176,204,138,117, 42,
 46,  0,184,110,151,240, 15,  1, 82, 30, 44,102, 91, 47, 54, 46, 41, 84,216, 84,
165,  0,211,237, 11,170,221,  6,144,231,148, 61,205,157,210,159,  6,255,193, 46,
215,  0,219,  0,216,  0,116,179,222,235,188,115, 20, 40,124,131,193,120,160,  0,
114, 50,255, 15,129, 68, 30,241,224, 58, 24,  9,122, 85,221,211, 30,174,164, 22,
 32,242,137, 40,208,123,101,142,121,190,177,242,237,207, 75,185,210, 83, 62,240,
193, 14,134, 98, 66, 96,163, 30,209,126,155, 94,177,213,190, 97,114,158,107,180,
108,117,182, 58, 47, 21, 61,117,122, 62, 43, 21,179,243,  4,196, 97,  2,193,192,
 22, 21,169, 59,165,114,123,250, 74,174, 50, 12,108, 37, 83,109,193,224, 96,  2,
 99, 82, 49, 71,101,203,155,219,107,109,244,230, 24,230, 30, 17,128,112,128, 96,
 56,240,224,  0,241,  8,  5, 61,178,205, 17, 39, 62,113,223,172, 59,179,238, 60,
226, 56,139,103,209, 88, 41, 40,204,225,219, 26,  7,242,226,221, 61,243,219,109,
 91, 35,181,103,235, 94,206, 87,146, 41, 87,191,209,186,183,213,180, 78,177, 38,
 86,206,190, 45,219,195, 21,140,120,136,151, 51,248, 40,222,208,  0, 97,104,104,
  8,242,146,173,142, 95,206, 87,163,217,164, 78,193,104, 46, 32,104, 52, 80,131,
 81,208,  0,126,224,  5, 98, 58, 12, 48,164,139, 75,124,212,237, 28,116,231, 92,
116,237,156,115,174, 93, 67,174, 47, 23, 37,209,185, 43, 62, 72, 50, 78,221, 45,
191, 53, 94, 11,157,139,176, 86,239, 21, 81, 32,119,230,184,160,139, 58, 19,121,
244,209,244,160, 63,248, 30,  5,228, 73,  1,172,201,190,145,233,  1,192,112, 82,
 39,243, 52, 30,205,120, 95, 23,244,190,213, 43,249,186,  7, 87,178, 47,111,156,
226,  0, 51,161,201,192,207,245, 30, 65,219,208, 65,236,141, 25,134, 69, 79, 87,
 82, 82,185,100,140, 99,250,  2,134,105, 30, 26,179,219, 83,197,132,230,226,130,
225,116, 24, 44,255,144,159,233, 65,  2, 53,174, 43,227,244,221,242, 71, 95,249,
117,221,242,207, 47, 44, 16,113,101,255, 90, 57, 41,182,253,199, 22,227,  8,195,
217, 56, 12, 78,  4,157,211,113,146,133,133,131,155,139,  4, 48,194,  3, 84, 14,
178,242,245, 78,166,226, 85,164, 99, 98, 60,157, 98,182,208,107, 71, 10,163,138,
111,100,224, 74,237,196,  0,219,104, 81,184,  0,173, 70, 49, 41,  8,159, 71, 70,
242,134,237,234, 50,246, 22,156,133,163,193, 76, 84,168,188, 37,146,190,104, 92,
104,198, 61, 46,116, 76, 39,179,105,  0, 43, 50,151,190, 22, 12,164,174,124, 66,
 68, 34,145,168,200, 72, 89,203, 84, 59, 99,123, 44, 82, 77,183, 91,177, 92, 54,
 94, 79,191, 98,108,202,180,207, 45,103,147,226,233,151,  8,196, 31,109,191, 16,
185, 71, 23,122,201,251,  2,125,163, 84,198, 89,195,194, 66, 67,103,131,225,112,
220,172, 62,239,175, 58, 59, 78,117,229, 76,147,159,242, 21,170,177, 57,101,155,
253,134,113,213,232,197, 52,203,245, 20, 10, 77,102,147,145, 50, 14,  3, 62,208,
184,137,251, 39,150, 43, 61, 79,191, 83,254, 90, 45,251,101, 99,246,203,198, 54,
100,219, 71,174, 23,244, 22, 44, 15,183, 88, 30,121,208,135, 12, 16, 72,133, 58,
239,176,197,108, 86, 31,136,106,215,156, 24, 79,205,146,171, 55,204,123,230,232,
 27, 49,174,183, 54,180, 41,217, 85, 94,177, 32,195,216, 20,239, 45, 27, 45,217,
151,204,209, 27,183,241,209,195,237, 22, 59, 48,139,228, 29, 61,106,232, 10, 46,
 27,135,225,192,  7, 27,167,201,188,135, 95,107,163, 43,141, 17, 73,155,158, 99,
115, 78,149,107, 72,146,244,233, 76,170, 60, 34, 81,232,159,134,146, 36, 73,146,
244,137,251,229,218,154,  4,174,147, 89, 85, 34,210, 50,118,219,210,173, 59,167,
115,141,119, 82, 36,147,208, 50,248, 33, 63, 89,132,  1,136, 35, 24, 48,224,159,
 16,129, 16, 94, 19, 58,  8,  2,153, 29, 44,167,  5,129, 36, 97, 81,246, 91,141,
178,167,215, 89, 35,203,198,174,109, 46,224,  7, 74, 80,227, 46,156,107,145,104,
180,196, 77, 96, 48,216, 46,205,216,211,167,125,189,247, 28, 26,218,110,127, 60,
234, 75,222,212, 37,222,175,220,193, 98, 28,130, 77,168,114,180,142, 41, 83, 35,
 34, 35, 41, 73, 10,173,  1,242, 40,  6, 33, 57, 28, 72,113,178,118,  3, 82,160,
 40, 11, 33, 17, 66, 18, 48, 34, 32,  4, 17,  1, 49,  2, 67,160,128,  8,132, 72,
 48, 34, 34, 98, 82,226, 28,164,252,234, 14,113,141, 98,179,139,200,224,224,240,
 16,102, 28,241,  8, 27, 33,158,197, 54,132, 57,143,170,217,173,254,228,120,189,
 78, 73,192,139, 75,209,192, 34, 85,183, 75,205, 28,118, 55, 41,173, 63, 23,128,
122, 39,112,204, 29,126, 83, 55,171,105, 41,146,221,244,148, 39, 27,  4,238, 23,
204, 92,233, 92,154,220,227, 41, 55,115, 99,126,246, 49,180, 10,167,173,122,  9,
 89,168, 65,230, 24,184, 82,189,211, 82, 14,138,216, 15,  4,183, 46,241,231,149,
 51,176, 71,229,200, 27,160,112,218,242,248, 16, 85,255,  3, 52,138, 29,159,227,
180,243,249,166, 29,176, 38,238, 72,117,231,184,110,166,145,235,208,144,247,138,
112,195,160,141,235, 30,109,  1,244,144,156, 97,232, 92,213,247,118,157,245,172,
 75,115,147,146, 29,155,180, 76,115, 21,249,119,220, 54,130, 27,253,180, 11,168,
172,215,195,136,135,211,134,116,118,217,120,117, 65, 67,194,113, 81, 57, 43, 15,
188,124,148, 88,180, 71,171,120,125, 87,217, 35,  0,154,252,191,179,111, 70, 32,
 90,  4,125, 50, 64,233,135, 40,128,203, 37,241,  9, 40,147, 21, 39, 69,108,106,
197,136,248, 92, 44,219,110,169,206,247,183, 11,193,204, 73, 73,188,231, 79,103,
 79,187, 26,168,138,241,115,240, 17,222, 60,164,134,  3,190,177,144,164, 35,237,
 17, 36,117,206,110, 63,143,123,198,240,143,142, 31,155,  1,132,225, 18, 93,101,
153,172, 80,202,252, 95,110, 36,122, 24,211,223,178, 80, 38,112,243, 43, 72, 77,
 14, 69,199,168,118,198, 28,101,104, 56,240,196,107,154,202,224, 46, 56, 66,168,
 51,  2, 22,184,155, 94,224, 46,145, 41, 52, 48, 14,249,138, 64,101,235, 52,242,
176,  0,  4, 99,252, 45,115,121, 33, 47, 61,210,157,101, 62,102,210, 73,228,114,
194,149, 36,245, 69, 53,101, 77,165,111,162,110,252, 28,107, 18,120,148, 73,150,
155,251,235,152,  6,200,111,162,161, 31, 79, 82,168,113,212, 31,  3,228, 72,111,
202,182,208,176, 16, 82,154, 10, 37,141,168,184,  4,149,200,125,236,  3,201,187,
 83,224,245,212,194,163,232, 45,143, 79,122,237,  7,149, 14,224,240, 29,215,211,
 65,142, 51, 46,164,211,137,245, 17,239,160, 16,192,152, 72,128, 67,184, 60,192,
 10, 61, 84,116,199,222,144, 44, 13,231,164, 73, 28,  5,234,169,175, 68, 84, 36,
 17,222,236,125,181,217,167,237,111, 43, 12,110,166,175,235,160,189, 60,116, 73,
 87,117, 84, 32,234,245,156,170, 90,245,125, 92, 13, 99, 84,  9,245,101,249,146,
 97, 19,155, 18,103, 95,213, 84, 55,194,216,181,128,230, 10,  0, 32,203,192,201,
 64, 32,180,237,  2,143,  8,179, 74,194, 41,136, 97,150, 80,139, 86, 13,131,130,
201,172,249,234,245,198,169, 79,147, 75,  4,166,198,180, 96,179,109, 77,  2, 21,
 45, 19,199, 25, 55,150,133,208,105,105,180, 90, 83, 22,145,140,109,240, 33,118,
 16,228,  9,192,188,  4, 83, 78,233, 29, 12, 30,102,142,  6,179, 43, 52, 55,254,
140, 66, 84,195,231,168,204, 10, 74,128,135,204, 30,254,214,246,222, 50,129,148,
  6,192,209, 38, 72, 40,192,244,120,157,206, 61,200, 66, 33, 48, 76,  3, 47,199,
 57, 54,173,215,163,222, 91,130, 31,205,109,231,116,143,192,  5, 57, 32, 38,123,
 16,  3, 58, 49,127, 99,241, 74,149,137, 91,193, 37, 26, 86,218,137,177,240,152,
146, 25,111,210,223,149, 87, 37,156, 40, 59,238, 98,140,100,143,173, 74, 36,193,
 95,155, 10,181, 67,150,190, 24,127, 28,253,147, 85, 68,180, 64,133,220,175, 82,
 60, 29,210,101,139,190,116,189, 95,120,122, 39,111, 43,126,225,  1, 99, 91, 28,
133,131,178, 63,240,145,  2,137, 35, 34,133,  8,200,  1,185,118, 43, 36, 93, 54,
136,  9, 40, 12,140, 43,160, 61,101,144,111,  8, 67,119, 54,163,161, 89,222,136,
 40,130, 55,132,222, 63,245, 12,  0,115,210, 30, 20,102, 22,195, 74, 35, 63, 24,
 86,233, 92,154, 36,196,228,239, 24,134,113,135,198, 60,142, 60,241,128,200,118,
210, 93, 29, 66,118,103,221,128,204,  2,206,244,215, 57,211,216, 14, 20, 80,155,
190, 25, 70, 34,120, 65, 29,134, 53, 63,198,138,135,194,234,161,251, 44, 68, 53,
127,123,144, 35,124,207,113,255, 48, 96,127,186,254, 71, 95,153,244,225,239,200,
109, 71,119, 97,  3, 89,192,107, 37,171,  1,  8, 89, 51,195,190,244,214,204,107,
129, 93, 16,225, 84,241,229, 78, 86, 55, 36,234,158,115, 87, 53, 71,157,237, 83,
 68, 48,157,143,238,163, 55,221, 86, 50, 92,247, 43,  7,150,239,142, 43,129, 31,
210, 70, 28,180,134,151, 87,170,159,171,168,229,116, 59,240, 64,  3,185,214,152,
200, 78, 65, 61, 89,196,206, 61,246,242,152, 48, 10,122, 52, 45,  4,245, 92, 38,
168,128, 98, 96, 47,207,242,139,247,121, 45,245, 15, 15,224, 58, 65, 31,193,193,
  5,206, 13, 47,204, 23,162,216,119, 95,197, 65,159,118, 55, 77, 38, 42, 13,167,
237, 44, 46,159,147, 53,162, 19, 77, 81, 75,158, 92,  1,207, 97, 63,112,113,185,
 35,159,205,250,128,224, 73,126,  8, 93,176,196,232,182,188,200, 71,239,108, 44,
  5,234,204,113,106, 62, 35,129,118,177, 97,225, 80,230,121,128,231, 87,204,150,
 72, 72, 50,185, 91,226, 75,106,246,211,155,131,117,165,198,188,106,172,204, 17,
 49, 61, 88,149,230,191,212, 13, 26,233,184,249,201, 81, 64,239,235,192,116,255,
138,137,173, 94,113,238,216,232,103, 78,197, 13, 79,225,114,239, 25,164,239, 48,
182,156, 59,250, 49,135,248,110,172,118,127,252,176,102,128, 62,  1,246,149,204,
246,  8, 94, 76,122,217,118, 82, 30,  8,  1, 62,145,  8,213, 52,184, 20,198,221,
228, 57,173,182, 17,254, 65, 75, 31, 84,117,180, 68, 62,225,193,149,112, 39, 45,
 22,164,145, 64, 98,174,142,209,151, 73,175, 50,131, 13,223, 55, 77,173, 86,152,
182, 22,255, 64,178,174,127, 18, 53,207,148,181,229,242,167,232, 27, 59,
} ;

// ../Source/Template/GB_meta16_factory.c:
uint8_t GB_JITpackage_120 [623] = {
 40,181, 47,253, 96,110, 39, 45, 19,  0,102, 22, 70, 32, 32,145,117,  3, 79,107,
131,126, 89,140, 81,194,197,153, 62,122, 70, 61, 75,166,194,250,215,122, 10, 20,
 83,  1,140,  4, 32, 15, 59,  0, 61,  0, 61,  0,223,172,108,177, 74,249, 51, 69,
136,100,105,242, 54, 18,141,175,212,166,206, 85, 51, 57,233, 51,147,143,191,150,
126, 90, 43, 55,118,121,106,143, 27,203,234,  7,248,196,118,109,174, 36,165, 14,
 80,230,198, 40,169,113,  2,193, 65,  4, 66,125,205, 76, 90,239, 43,221,139, 10,
 80, 91,149,212,226, 19,183, 43,173, 57,235,249,128, 26,103, 93, 85,  8,100, 81,
 72,162,217,155,219,184, 39,199,217,202,212,201,175, 43,254, 49, 20, 94,  1, 66,
192, 87,248,160, 18,252,193,117, 35, 21,143, 98,255,100, 33,185, 56,224, 23,211,
 36, 74, 38,106,122, 80,209,202, 22,243, 75,142, 51,160,112,165,162,224,180,254,
191,227, 56,119,128,145,178,136,116, 86,105,207,128,115,209,117,105,232,175,253,
163, 73, 44, 87,204,159,219,218,102,253,193,137, 25,206,  1,172,  8,103,182,230,
 74,123,102,154,  0,181,223,114,221, 50,137,237,173, 36,214,215,185, 14,124,240,
193, 23, 57, 17, 62,248,224,195,245,177,241,213, 29, 64, 21, 97,192,123,106,174,
 42,171,210, 15,129, 84, 24,146, 24,161, 60,164, 23,125,160, 97, 46,153, 17, 10,
 82,146, 58,149,225,112,  2, 17, 17,177,177,217,  1, 36, 17, 50, 14,109, 77, 38,
197,130, 98, 39,179, 83,132,204,150, 58,185, 18, 76,100, 37,212, 78,166,128, 41,
164,163,132, 88,149, 82, 97,228, 74, 38, 67,  5, 10,203, 21, 43,  5,177, 86,152,
108,  6, 86,164, 58,168, 66,149, 80,104, 69,178,172, 82, 61, 82, 19, 42,165, 87,
110, 55,164, 50, 10,149,142, 50, 98,213, 88, 44,113, 16,219, 23, 11, 20,150, 42,
 86, 16,196,108,215,185, 75, 89, 80, 29, 92,177, 90, 80,136,133,207,118, 84, 29,
  9, 21,150,211, 27, 14, 31, 96,105, 74,  1, 67,249, 84, 84, 17,170, 95, 65, 62,
 98,129,  8, 88,172, 58, 64, 45, 18,139, 74, 58, 51, 97,169,122, 48,101,245, 16,
129,237, 60,187,137,154, 38,229,178,144,216,113,104,192,209, 48, 16, 75, 83,148,
 23,123, 79,208,166,246, 80, 82,146,163,140,148,  2, 62, 66,143,132,116,133,169,
 35,177,100,177,202, 32, 22,128,133,105, 63, 12,165,156, 82,200,  7, 87,164, 22,
 84, 14,194, 44, 29,  8,  9,179,139,202,  9,150,  4,172, 82,183, 27,229, 93,189,
147,247, 24,246,119,139, 85,200,214,181, 11,225, 47, 33, 61,251,172,145,192,141,
162,191, 95,142, 53,187,236,187, 40,189,238,  9,202,186, 17,112,208,148,142, 94,
115, 22,192,209,241, 72, 80,184, 34,110, 79,195,144, 82,233,118,119,111, 16,133,
 69,  4,196, 17, 74,101,151, 54,105,138,249,153,201,206,232, 90,160, 47,136, 42,
 69,193, 30,
} ;

// ../Source/Template/GB_meta16_methods.c:
uint8_t GB_JITpackage_121 [400] = {
 40,181, 47,253, 96,135,  3, 53, 12,  0,118,213, 67, 32, 16,147,117,230,109,189,
195, 75,154,158, 23,212,  5,150,111,250,227,110, 85, 67,243, 67, 40, 80, 51, 98,
 35,  2,  0,168,242, 27, 60,  0, 56,  0, 55,  0,146,194, 80,168, 62,136,130, 19,
 48,237, 64,198, 39,247,207,204,118, 67, 45, 39, 92, 78,242,230,  6,239, 99,209,
248,194,237,234, 76, 57, 87, 20,167,207,181, 57,194,236,218,236, 95, 96,105,103,
194,  0,115,111,176,247, 56, 69, 69, 18, 69,  5,199,246, 70,184,121, 95,168,197,
150,167,168,255,143, 34, 80, 84,152, 42,169,103,132,155,251,226, 54,205,104,174,
 45, 35, 82,227,218,145, 74, 36, 12,195,154,100,119,110,227,174, 28,231,169,161,
149,107,154, 59,225, 80, 21,170, 86, 98,207,227,  6, 71, 88, 40, 12,193,101, 63,
203,145, 35,237,221,158, 45, 96, 78,184, 90,154,105,165, 89, 75,192, 91,114,180,
 88,105,224, 93, 86,120,247,204,254,147, 41,126,207,252,106, 47,107,111, 45,159,
225,204,  1, 81, 20,122,239, 61,137,228,226,176,220,196, 18,121,149,134,149,129,
 52,174,138,179, 46,236,138, 96,159,249, 25,149,181,114, 14,248,181,247, 54,174,
 42, 67, 99, 56, 55,236, 96,104, 92, 14, 98, 97,  7,173,  1,113,234, 12,181,109,
211, 25, 67,228, 47, 32, 80, 68, 48,136, 24, 15, 40,  4,203,  1, 25, 10,139,216,
208, 17, 76, 23, 14,173,251,132,151,103,215,137, 88, 50,160,188,  5,162, 73, 64,
 79,  0,112,162,  9, 44,192, 46, 33, 88,  2,186,229, 81, 68,163, 84, 70,196, 68,
220,227,144,  9, 47, 65,230, 94, 49,185, 83,200,143, 37, 44, 49, 48,113, 47,200,
107,196,106,104,196,  5,221, 30,130, 10, 85,160, 16,  1, 38,170,113, 11,202,160,
105,  8, 51,105,199,  2,107,112,197, 35, 36, 44, 18,170, 23,210,250, 21, 45, 67,

} ;

// ../Source/Template/GB_nthreads.h:
uint8_t GB_JITpackage_122 [473] = {
 40,181, 47,253, 96, 62,  4,125, 14,  0,102,154, 78, 32,  0,149,117,214, 44,112,
 77, 54, 47, 29, 47,224, 10,164, 42,208,233, 12,229,178,  0,169,195,  6,  7,  8,
200,255,255,189, 62,132, 70,  0, 74,  0, 64,  0,175,240,  4,193,198, 47,237, 35,
153,173,103, 98, 94, 93, 52,  9, 67,126,224,125, 32, 26, 95,248,185,116,158,221,
229, 85, 59, 57,125, 79,155, 82,120,225,231,215,114,111,220,221,230,159,179,  7,
188,235,244,220,206, 29,143,144, 23,142,176,175,204, 85,195,120, 28,195,158,133,
 97,  1, 92,228,218,127,172,165,240,117,157, 92, 71,192,131,104, 46, 13,205, 97,
129, 96, 40, 92,199,202, 77,192, 19, 92,153,213,114,131, 31,237,136,219,147,155,
185,118,140, 88,141,107,111, 83, 98,101, 26,149, 43, 54,232, 54,110,203,113,150,
156,105, 57,165,218, 43, 66, 38,200,172,195, 64,144,157,218,166, 85,211, 77,103,
227,255,191,233,213,219,229,190,199,176,255,185,206,119,157,180,206,111, 51,195,
140,223,187,170,189,197,143, 21,190,234, 11,109, 40, 19,230, 27,211,198,221,241,
124, 87,251, 17,173,246,181,101,126,213,169,157,220,  2,217, 21,239, 92, 27,122,
239,113, 51,214,  6,188, 87,162,166,106, 58, 37,130,253, 90, 75,185, 83,211, 23,
215, 20, 12,255, 95,226,212, 96,122, 70,155, 68, 22,255,255, 78,122,148,  8,122,
 52,255,159,220, 58,207,241,148,249, 25,195,166,207, 80,110,176,223,160,201,177,
145,194,108,243, 49,236,  1, 59, 32, 48,132,  8,200,161, 62,161,  0,120, 93,226,
129,109,207, 70,193, 34,112,136, 52, 64,141,  6, 43,207, 61, 38,250,188, 96,206,
 97,119,  6,143,  6,190, 54,204,145,  9,194, 30,130, 51, 16, 39,208, 90, 24, 57,
 64, 29,188,233,148,190,128, 61, 14, 12, 36, 69, 49, 11, 30,157,108, 16,200,237,
136,106, 11,118,125,229,185,176, 93,123,201,168,179, 16, 94,203,217, 88, 33,237,
 63, 17,157, 54, 17,187,188, 13,109,107,195,185,252,165, 52,207,  5, 38,103, 79,
211,229, 52,222,238,119,200,224,240, 76, 87,178,  3,218,214, 30, 52, 49,207, 76,
181,101,172, 22,199, 24,114,106,117,159,162, 96,  8,
} ;

// ../Source/Template/GB_omp_kernels.h:
uint8_t GB_JITpackage_123 [599] = {
 40,181, 47,253, 96,119,  5,109, 18,  0,118, 95, 94, 32, 16,149,115,231,182,111,
244, 50,232, 92,214,162, 49,181, 58,233,130,120,  4,252,226, 98, 66,245, 36,194,
 17,  1,  0, 84,193, 13, 86,  0, 86,  0, 80,  0,149, 45,107,110,175,252,180,230,
 28,103,157, 74, 32, 12,  8,130,226, 96, 64,124,160,  9, 78,217, 22, 65,200, 43,
235, 37,121,105,215,155, 83, 19,102, 85, 28,210,131, 53,178, 96, 91,161,135,241,
237, 15,251,236,103, 44,147, 61,204, 63,179,237,119, 59,105,223,158,189,113,252,
 66, 86,150,227, 89, 25,148,121, 29,205, 28,145, 23, 10, 19,161, 80,  8,241,113,
194, 83,246, 86,234,121,159, 61,237,248, 93,236, 28,252,108,115,142, 89,254,127,
154, 30,152, 37,211, 92,149,201, 99,210,182,149, 69, 44,111, 87,249,114,156, 56,
 48, 73, 50,172,114, 93, 52, 23, 37,203, 88, 48, 27,199,185,117, 96, 50, 84,  8,
  2, 75, 13,122,214, 23,149,123,235, 59, 57, 78,  8,108, 39,107, 93, 33,120, 32,
153, 42,178, 40, 87,  6,147,253, 91,115,220,144,213,236,122,103, 51,206,241,227,
180,217,129,106, 32, 43,203, 86,240,  8,249,218,248, 95, 40,175, 54,191,237,252,
153, 80,106, 36, 46,112,133, 94, 71,181, 71,  6,105,148,171,124,103,223,246, 41,
 30, 81,201, 95,177,253, 32,167,157,235,119, 61,168,105,221,209, 11, 69, 80,254,
210,121,203, 52,  6,193, 65,192,150,187,190,163,255,178, 76, 54,157,108,115, 69,
  6, 23,220, 70,200, 85,222,140,  4,187,236,242, 39, 59,  6,177, 46,141,100,147,
121, 44, 75, 22, 39,220,166,105,235, 56, 25, 48,248,168,188, 61, 58,215,218, 95,
136,235,  1,181,178,194,112, 96,108, 28, 71, 85,190,144,123,165, 63, 84,137,230,
 95,251,117,183,149,185,174,116,112,  9, 82, 40, 32,132, 16,163, 28,154,  7, 18,
106,174,132, 84, 35, 68, 34, 18,205, 68, 52,241, 31,101,232,  1,226,  8,194, 68,
252, 53,193,  6,  4,213,236,208, 49,167,145,188, 97,179, 84, 15, 96, 30,234,136,
228, 27, 32,129,248,  4, 31,237,128, 30, 18,130,113, 16,187,182,  6, 66, 41,  3,
 65, 14, 45,  7,183, 16,128, 22, 25, 44, 50, 37,192, 18, 59,  3,218,241,110,214,
 68,114, 19, 61, 32, 10,120, 50, 29, 89,110,103,140,227,105,222, 52, 21, 21,210,
192,  8,130, 68, 19,104,217, 63,  3,162, 13,228,122,138,102,206, 33,162, 84,  8,
232,107,173,229,255,160, 27,244, 61, 10,244,123,191,177,168,233,254, 30, 84,153,
129, 47,121,118,233,164,119,111,196,214,172,241, 10,222, 71,227,109,211,220,232,
 24,237,194,213,235, 32,121,211, 80,231, 99,118, 43,212,109, 63,230,179, 80, 93,
211,246,160,233,223, 77,  2,224,210,168, 52,128,248,230,188, 70, 43,192, 13,
} ;

// ../Source/Template/GB_prefix.h:
uint8_t GB_JITpackage_124 [259] = {
 40,181, 47,253, 96,202,  1,205,  7,  0,178,140, 41, 23, 32,221,  1,163,204, 96,
126, 23,192,172,  0, 23,171,218,171,103,223,123,129,  4,128,197,  3,  0, 48,110,
 17,125,119,199,158,110,122,245, 43, 48,176,134,133,101,150, 61,  8, 60,246, 97,
214,178,142,  5,133,123,162, 71,119,  0, 88,159,119, 81,147,150,141, 47,162,227,
 14,128,163, 72,136, 47, 67, 80,125,220, 89,127,143,187, 69, 95,188,136,103,209,
 15, 55, 70,120, 82, 86,136,255,174,207,190,230,108, 91,146, 91,115,211,124, 92,
 43,201,145, 16, 13,114, 36, 62,132,130,107,118,191,160,228,197,227,114,217,166,
231,230, 92, 59,207,174,160,186,125,187,221, 13,112, 18,221, 39,136,250,246, 96,
 80,169,130,107,229, 78, 89,196,123,252, 85,253,160,202, 13,  3, 32, 12, 35, 32,
 32, 64, 68, 32,144, 34, 31,  8,  0,156,230, 58,102,161,248,128,  7,130,106,185,
 12, 57, 16, 25,176, 70, 48,231,147,152,195,224,130,106, 28, 80, 24,192,238, 75,
163, 70,  6,216, 69,185,100,104, 95,160, 21, 24,103,207, 99,144,  2,196, 84, 96,
  6, 77,153,119,211,104, 80, 53,251,176,192,249,209,149, 27,123,138,186, 33,
} ;

// ../Source/Template/GB_printf_kernels.h:
uint8_t GB_JITpackage_125 [763] = {
 40,181, 47,253, 96,240,  7,141, 23,  0, 86,163,109, 32,224, 88, 61, 24,247,139,
 43, 50,  6,117,163, 45,196, 88,112, 37,118, 66,155, 55, 17, 32,185,174, 43,155,
 51,152, 97,152,230,225,100,  0,102,  0, 97,  0,133,215,248, 65,171, 41,124, 38,
156,140,254, 41,191,254,206,245, 14, 69,182,243,123, 53,199, 20,137, 67,162,208,
 64, 28, 18, 62,  0, 47,199,180, 61,205,137,103,154,167,194, 45,150,236,231,152,
227,117,158, 38,239,183, 29, 61,203,211, 52,145,208, 52,243,230, 37, 49, 87, 23,
 97,235, 89,172,174,177,104,183,197,182, 62,117, 71,152,233,251, 56, 63, 73,214,
141,109, 54,201,200,230,  6,131, 85, 48, 24,  2, 46,110,119,112, 54,157,137, 69,
233,130, 49, 58, 64,  0,240, 81,255,120,231,201, 81, 79,241, 69, 70,242,134, 81,
138,167,143,247, 10, 60,117, 47,118, 76,139,176,205, 91,251,158,165,193,193, 33,
 16, 55,149,192,188,245,229,131,141,233,203, 34,249,180,141,220, 62,239,  3,150,
 69,122, 26, 10,215, 81, 50,178,242,113,151,142, 83,159,226,106,  3,214, 33, 75,
 20, 62,  4,167, 73,115, 71,126, 91,237,198, 79, 47,  1,245,225,  3, 41,189,173,
211,164,230,145,242,114,149,  5,242, 65,150,101,215, 24,176, 28, 96,200,222,212,
221,224,103, 75,221,191,100,183,227, 49,251,119,193,120, 38, 18,141,161,167, 20,
 77,164,235, 68,232,235, 17,196, 99,117,109,195,239,177, 72, 93, 91, 39,129, 31,
130,158,197,156,223, 69,206, 61,219,119,212,159, 67, 61,222,138,237,209,228, 52,
 79,138,231,214,254,225,222,163, 72,183, 14,150, 85, 45,197,239,159, 75,135,225,
139,227, 38, 28,229,250, 58,237,243, 48,237,242, 56,202, 68,254, 13,229, 49,132,
 39, 56,216,224,143, 66,226, 37,185,108,218, 70,102, 36, 20,139, 68, 30, 14, 86,
199,209, 58, 75,225,233,216,110, 17, 83, 49,220, 95,242,215, 27, 65, 70, 80,155,
255, 13, 77,176,144,239,157,158, 10,137, 25,156,165, 42,238,234, 26, 77,135,171,
214,179,232,216, 95, 91,125,118,156,213, 21,128,131,168,113, 41, 82,134, 72, 70,
 38,140, 36, 73, 37, 29, 48,132, 16,165,172,230,  3,130,184,108, 24,227, 48,  1,
105,148,137, 68,100, 40,144,252, 76, 84, 88,218,  1,222,140,186, 15,206,  2,155,
 40, 27, 31,147, 50, 41,247, 43,248, 78,  5,241,183,244, 47,103, 92,243, 26,168,
189,153,224,151, 52,152, 69,183, 77, 83, 15,206, 42,116,228, 64,140,151,156,112,
147,166, 14,107,  5, 77,156,243,131,197, 81,196,248, 67,  8,236,  6,147,  8, 58,
 24, 28,116, 27,224,184, 15, 70, 95,  4,251,177,142, 40,134,250,179,200,122, 86,
202,109, 74, 56,139, 69, 74,128, 72, 16, 94,248,193, 86,142, 61,247,207, 13, 73,
215, 72,201, 83,172,173,104,162, 80,216, 38, 99,108, 98,228,112, 21, 39,142,159,
 80,232,168,206,149,152, 51, 24,195,138, 86, 49,235,228,102, 68,  4, 35, 72, 26,
136, 45, 82, 35,142, 44, 88, 49, 17, 14,  0,174,163, 33,225,194, 97,122,146,128,
 14, 12, 43, 55, 60,216,166, 93,161, 21, 76,238,220,243, 48,132,181,175,168,248,
233,109,243,  5,184,185,105, 27, 22,106,226,126,153, 66,226,131, 97, 98,162,252,
 67,115,223,148,129, 76,155,198,163,200,  2, 14,240,161, 14,248, 82,146,234, 99,
162,227, 43, 41, 63,184, 82,213,  1, 93,248,  0,164, 80, 57, 40,187,199, 61, 71,
159, 76,161, 15,154,206,127,211,178,186,194,149,193, 67,167, 76, 63,197, 94, 85,
  7,176,  3,
} ;

// ../Source/Template/GB_reduce_panel.c:
uint8_t GB_JITpackage_126 [1902] = {
 40,181, 47,253, 96,106, 38, 37, 59,  0, 54,122,171, 40,208,178, 58,  7,208, 43,
129, 98,255, 92,204,225,231,186, 85,189, 48,115,159,144,162, 23, 77,102,237, 58,
 80, 45,141, 77, 45,125,205, 23, 94,112,212, 14,170,  4,157,  0,158,  0,168,  0,
 83, 61,123,222,245,235, 94,253,148, 74,249,115, 13,122,188,210,217, 75,217,155,
 18, 82, 29,225,231, 57,157,219,181,201, 53,119,215,184,174,135,250,190, 67,194,
250,125, 19, 85, 40,  6, 20,115,217,122,213, 25, 40,195, 13,182,100,205,162,184,
 74,206, 32,134,202,176,104, 40, 26,127, 80,174,188,121,109,174,  3,110, 30, 99,
245,233,192,160, 98, 64, 45, 20, 84, 12, 46,101,146, 79, 21,126,172,229,148,234,
 32,174,103,  7,175, 79,156, 10, 19,193,121, 75, 39, 24,184,210,245, 56,220,240,
227, 68,116,227,102,245,251,217, 15,129,180,183,251,254,147, 84, 73, 30, 66,103,
136, 44,215,195, 56,251, 52,166, 88,196,196,  9,  8, 34,138,128, 32, 43, 57,  7,
 83, 93,100, 36,  0,201,175,205,133,195,169, 26, 30,  2, 65, 85,151, 36,127,120,
 72,  6,105, 87,166,  3,175,186,202,153, 85,239,255,143, 34,145, 40,218,160, 38,
 89, 32, 82, 40, 56, 75, 40, 16, 97, 46,153, 74, 35, 55, 14,193,250,142,223,110,
172,  5,112, 20,249,  5,156,181, 47,102, 18, 10, 92, 52, 26, 23,182,241,110,107,
131,196,125,  5, 45,165,123,140,107,154, 51,119,105,220,116,122,222, 87, 65, 94,
214, 45,252,200, 32,101,201, 29,175, 40,179, 66,109,185,171,132,223,185, 55,122,
 29, 55,134,205,158, 42,172,213, 55,139,161,167,155,161,131,228,158, 63,150,147,
188,237, 26,122,166,148,155, 53,148, 60,198,111,  3,113, 15,252, 33,231, 27,134,
240, 65,145, 46,127, 50,230, 50,  7,138,226, 56, 57,144, 95,174,202,162,177,192,
 44,157,207,196,155,120,222,227,194,166,117, 33, 38, 14, 13,222,236,199,216,242,
155,217, 71, 62,159,206,231,147,137, 67,195,255,145, 72,146, 91, 88,195, 59, 28,
 93, 41,220,184,134, 32,125,109,103,188, 84,160, 45, 83,174,165,164, 98,  1,174,
113,183, 79,159,166,234,186, 76,116, 10, 40, 14,  9, 20,161,198, 93, 55,129,104,
 75,254,108, 95,131, 83,206,238, 22,171, 34, 83, 65,129,105,100,170,199,149,176,
163,220, 33, 78,166, 66,  2,195, 84, 25,139, 98,115,185,176,203,166,194, 72, 92,
 44,149, 63, 60, 72, 77, 69,113, 89, 17, 24,199,146, 42,135,144,111, 12, 65,161,
 37, 12,201, 81, 52,130,225,125,239,190,186,205,215,142, 95,101,250,209,190, 92,
214,  6, 35, 70,238,238,254,255,201,169, 42, 39,108,128,  7, 75,117,217, 96, 18,
 22, 69,197,213,105, 25,157,114, 47,153, 61,  7, 45,119,254,226,126,220,131,159,
218,157,158,166,107,243,169,195,113, 12, 77,178,199,208,244,162, 19,132, 53,121,
  7, 41,131,189, 93, 37, 28,185,172, 94,194,186, 79,122,221,252,118, 29, 75, 61,
 13, 54, 93,239, 18,158, 51, 24,235, 37,200,124,109,248,122, 46, 91,142,115,122,
166,230, 10,185,238,216,184, 97, 28,191,103,186, 92,125,253,212,237, 41, 20, 42,
232, 84,164,145,207, 50,245,100, 42,172,203,178, 84,133,  4,131,131,104,129,252,
168, 33, 34,162, 25, 17,145,146,164, 32,201,176,  6, 49,  8,  1, 67, 97, 16, 66,
234,206,  7,194,136, 44, 13,225, 12,132, 49,134, 24, 73,  4,132,  8, 20, 33,  2,
 37,144, 24, 19, 74, 32, 52, 82,118,152, 24,246,107,223, 82, 10,247,126, 35, 47,
131,254, 55,247,126,103, 13,123, 65,131, 32,115,112,223,240,194,205,209, 38,220,
171,159, 54,146,198,253, 68,245,224,253,179, 95,248,115, 35,151,128, 80,170,117,
197,  4, 74, 57, 46,175, 62, 68,197,171,158,247,229,175, 37,  0,  2,131, 91,188,
195, 79,136,110,123,219,  3,128,217,170,  5,  6, 17, 30,184,171, 92, 12,225, 70,
197, 43, 29,179,246, 74,210, 20,174,123,146, 41, 18,  7,113,164, 97, 56,208,164,
108,117, 73, 13, 51,145, 12,101,126, 62,153, 65, 15, 50,153, 57,126,190,246,163,
193,123,241,203, 22, 62, 65,130, 23,120,122, 30, 11, 92,166,147, 52, 86,104,  1,
117,  2,155, 85,214, 49,105, 44, 36, 20,138, 82,160,196, 40,223, 15,161,236, 45,
 70, 12,157,120, 95, 54,217,229, 59,116,196,136,166,198, 21,160,167,145,143,218,
 68, 73,  4,209,132,188,234,150,224, 29, 86,249, 57,100, 98,229, 44,250,136,250,
  9,  0,231,221,122,184,106, 52, 11, 62,201,138,118, 80, 52,156, 93, 57,182,183,
218,146,  3, 91,209, 68,224, 24,184,204,122,112,  3,216, 75,211,153, 29, 68, 13,
199, 23,190, 74,222,203, 77,141, 32,237,203, 15,131,100,127,145,136,  0,157,114,
242,222,134, 89,248,176,  5,166,109,233, 86,232,160,180, 68,128, 44,148,227, 42,
130,150,200,  5,229, 53,137,  4,210,179,177, 49,117, 26, 49, 33,  2, 66,173, 96,
225, 35, 28,231, 81, 75,243, 41,  3,248,243,160,158, 94,198,137,155,125,162, 34,
170, 48,216,198, 94,  7,125, 93, 34, 33,124,119,192,157,243,159, 58,229,  2, 94,
 92,164,255,214,224, 46,227,231,254,124,  2, 44,204,136,255,166,146, 71,138, 48,
 93,240,123, 54, 70,152,157, 76, 56, 80,197,191,114,236, 21, 16,214,231, 45,247,
249,187,211,228, 81, 77, 80,217, 25, 45,195, 71, 53,111,208, 60,246,198, 93,232,
251, 34,162, 92,235,129,239,144, 72, 18, 34,158,148, 44, 91,180, 52,165, 88,247,
234,127,  7,241,212,238,180,145,225,155,253, 48,231,157,194,214,178, 56,194,157,
197,119,  0, 81, 16, 65, 15,241,101,148,182, 22,192, 61, 33,202,  4,191, 33, 28,
172,133,146, 96, 27,142, 75,202,219,111, 45,184,178,102,104, 42, 41,194,216, 66,
153,  8,118,243,180,177,158,186, 82,152, 21, 10,207, 60, 31, 76,114,108,198, 17,
 98, 74,192,163, 84, 43,140, 26, 90,150,190,128, 62, 59,181,237,240,152, 49,162,
 37,194,105, 25, 84, 71, 54, 97, 72, 62, 13,210,235, 96, 62,153,130,138, 34,190,
179,246,112,219, 71,183, 73,  5,  6, 31,167,122,  9, 75, 29,225,112, 92, 49,181,
  6, 95,140,194,124,180, 16, 55,202,143,232, 60,243, 75,239,252, 98, 10,180, 86,
 48,178,134,189, 87,103,213, 29,133, 97, 29,149,  3, 47,  1,218,238,121,152,147,
218,235, 78,163, 63,127,251, 82,  2,117, 54,233,  8, 16, 46,191, 20,196,161,132,
230, 47,  5,  9, 25, 86,136,227,186,229, 66,241,123,111,215,134, 55,118,176,  1,
189,248,228,239,177, 88, 32,216,165,118,184,105, 21,132,187,  0, 10, 13,231,124,
147, 62,182,128,183,241,  2, 66,144,150,219,183,148, 82,235,195,118,123,204,170,
206,214,245,  4, 82,165,168,202,213,241,145,132,152, 45,  8,226,223,163,126, 14,
 49,254,191,194, 72,158,182,243, 64,140,199,144,154,  7, 29,158,131,112,118, 67,
 19, 46,204,227, 28,122, 43, 61, 15,194, 23,153, 14,234, 95,164, 16,216, 85,152,
153,249, 91, 17,182, 15, 13,210,141,127, 67,237,111, 36,202,221, 73,236, 51,153,
237,252, 63, 97, 21,  9, 63,196,253, 66, 84, 39,141, 58, 95,229,181,145,232, 44,
106,135, 54,140, 68,211,237,242,161, 37,120,203,120,216, 66,108, 48,140, 98,  7,
173,153,122, 89, 41, 88,162,189, 69,104, 74,254,147,115,100,223, 82,243,254,244,
 17,136,182,119,229, 88,136,118,209, 86,146,174,  0,132,138,105,109,190, 98, 73,
 56,175,151,  4, 26,186,106,204,190, 50,255, 40,148, 76,108, 72,248,200, 17,178,
130,247, 11,139, 32,137,133,172,183, 69,179,174,  4, 39,  5,126,222,189,144,102,
 64,155,163,172,209,154, 50,210, 67,186,183, 20,231,119,215,214,176, 23,136,206,
 19,109,128,162, 11, 75,184,101, 53,116,248,221,177, 61, 40, 66, 93,232,187,245,
224,228,154, 75,136,125, 69,194,166,208,244,252,116,160,243, 19,248,197, 19, 18,
127, 98,137,245, 52, 96,242,122,203,217, 58,167,202,164,177,198, 23,242, 72, 62,
208, 83,106,238,107,176,200,141,226,136, 99,195,100,119, 27,183,201,213, 46,217,
 85, 75, 45, 51,102,  1,253,190,  6, 20,135,123,238,153,188,213,189,118,253,100,
180,212,100, 37, 16, 63,228,103, 33,131,106,  8,243, 74,190,158,218,158,128, 23,
172,211,147, 17,231,253,115, 31,161,148, 81,222, 57, 13, 41, 89,105,153, 29, 58,
 32,232, 44,249,105,184,147,104,132,  2, 96,128,239,249, 65,117, 61,207,181, 54,
253, 20,152,159, 21, 69,144,167,176,176, 19, 95,  4,119,159, 35,222,125,200,252,
  0,173,166, 58,153,102,226, 98,  5, 61,180, 77, 29, 41,140, 49,154, 80, 20,129,
115,192,169,217,149,158, 51,206,254,  1,225, 16,231, 70, 82,  9,254,237,164,239,
243,180, 55, 77,135,202, 76, 92,137, 97,194, 35, 94,168,  3,208, 17,139, 20, 13,
228,  1,
} ;

// ../Source/Template/GB_reduce_to_scalar_template.c:
uint8_t GB_JITpackage_127 [1289] = {
 40,181, 47,253, 96,186, 16,253, 39,  0, 86, 53,161, 40,192, 22,117, 14, 80, 61,
209, 98,243,219,127, 12, 93,218,216, 39,157, 48,152, 95, 92,129, 70,210,195,  9,
 49,  3,184,124, 96, 14, 33,219,166, 40, 16, 92, 55,  3,148,  0,150,  0,153,  0,
 21,115,109,237,104,217,171,215,164,101,202, 36,223,104, 60,  9,149,125,163,198,
158,167,207,181, 52,249,116, 65,  8,  6, 10, 21,230,180,232,193, 67, 88,150, 28,
217,148, 55,171,194,151,178, 38, 47, 21, 15,138,195, 96,227, 18,203,151,175,223,
230, 72,228,245, 57,225,167,  5,  5,  4,133,138, 67,  2,130,194, 37, 45,250,116,
101, 73,164,110,  0,239,225,186,118, 18,251,164,129, 23, 10,206,139,246,  2,130,
175,141,158,134, 91,126, 26,232,241,181,127, 34,109,199,238,241,159, 36, 24, 89,
 62,135,224,142,211,235,184, 51, 27,103,212,110, 86, 59, 99,237,219,216,102, 20,
 23, 63, 56,128, 42,  7,  7,  1, 82,116, 34,101,103, 12, 13, 17, 31,153,168,192,
 91, 62,  2,223,154,180,125,217, 18,252,239,236,161,169,124, 95, 90, 53,248,254,
127,  8, 66,145, 62, 83,103,218, 68, 31, 28,153,138,207, 45, 23,233,112,228, 70,
 89,  0,146, 94, 97,144,226,232,144,228,180,153, 62, 17, 83, 41,  0, 93,240,  2,
 43, 52, 89,  6,203, 62,224,117,193,140,162, 32,135, 55,202,169,244,147,136, 12,
249,230,150,130,127,  2, 56,250,  5,156,183,111,106, 84, 10, 64,144, 65,197,241,
129,101, 32,211, 38, 43,173, 29,167,126,206, 93,188,253, 27,185, 95, 79, 52,153,
241,155,232,221,142,173, 38,103, 14,251,239,247, 43, 63,153, 70,239,  1, 24,152,
 65,172,186,144, 34,239,211,  8,197,  5, 64,196,249,163,178, 37, 73,196, 11,185,
180,  6,  6,188,216,181, 28,169,212,214, 63,254,202,123,108, 83,150,247,100,231,
 40, 82, 65,129, 68,196, 17,110,185, 23,221, 86,206,121,146, 80,121, 47, 37,220,
 98,249,221, 34, 91,174,105,116,142,132, 51, 82,217, 89,238,143,  6,115,129, 24,
107,227,170,176,172,170,168, 40,169, 94,  0, 58,107, 29,225, 59, 89, 83, 89, 20,
 27, 25,144, 76,  3, 49, 46,203,145,174,126,178, 27,185, 12, 94, 42,204, 85,105,
100,152,149,129,240,137, 99, 87,165,209, 64,  9, 70,223, 38,115,217,135,210, 63,
226,210,135,198,232,212,165,194,192,156,  4, 16,148,242,251,113,230,119,217,122,
223,187, 47,101, 19,189, 55,150,139,108,178, 67,110,145,210,137,108, 43,204,186,
 54,181,111,235,156,220, 84,183,237,142,202, 42,172,141, 12,182,209,111,234, 62,
 48, 21,101,121, 90, 94,154,166, 41, 58, 38, 99, 97, 22,118, 65, 14,202,222,167,
182,177,239,237,220,216,244, 18, 82,194,164,201, 46, 82,207, 22,241,228,180,123,
 41,235, 62,234,117,245,177, 35,137,214,219,100,255,206,200,185,229,217,228, 57,
163,141, 30,107,114,222, 83,147,250,219,242,151,211, 34, 67, 80,138,  6,172, 46,
 10, 11,171,229,  9,223, 51,109,228,142, 70, 89, 25, 76,102,131, 10,129, 16,168,
209, 41, 66, 52, 50, 34,146, 36,  5, 41, 53,  6, 49,  8,194, 80, 36,234, 36,215,
  3, 50,145, 52,206, 66, 32,130, 16, 54,130, 33,193,132, 40,144,145, 32, 74,202,
 41,214,  3,185,215,129,143, 15, 87,114, 87, 96, 31,148,164,181,234,131,181,214,
249,124,178,117,143,102,107,122, 85, 87,123,220,110,138,169,162, 83,139,106, 52,
 90, 97,211,162,178,254,224,210, 75, 51, 99, 85, 28, 20,157, 43, 90, 65,202,159,
129,148, 46,167,234,164, 60,196,202, 69, 84,107, 14,104,196, 24,178,106, 40,157,
 12,118, 20,245, 38,142,162,175,114, 87, 95,128,242,251, 11,188, 55,  7, 64, 26,
194,248, 67,113,104,119,105,  5, 17,255,153,238, 19, 65,211, 92,144,102,230,131,
168,235, 43, 17,149,147, 34,244, 71,189,156,202,139,202,233,161,127,197,197, 48,
 37,165,187,183, 21, 36, 71, 22,114, 67, 36,169, 33,194, 12,137,196,240, 71, 58,
135,217, 30,181,245,101, 68,157,162, 13,249, 42,255,124,248,171,210,162, 82, 59,
 11,143,197,187,248, 24,166, 97, 49, 87, 41,198, 89,198, 99, 49,244,188,131,138,
119,110,219,149,236, 95,168, 10, 70,232,174, 96,244, 88,144,131,147,138,169, 53,
 21,  6,209,135, 51, 75,193,253,238,183, 62,233, 41, 32, 24,123,  9, 61,136,136,
 30, 82, 13, 42, 59,242,135,100, 62,201, 20,215, 61,233, 18,241,207,146,183,156,
197,  5,192,239,121,151, 51, 28,239, 24,145,129, 17,127,105,229, 56,166,104,122,
 84, 56,  0,168,220, 14,116, 57, 85,212, 17,  8,146, 26,144,125,117,121, 58,184,
201,201,231, 45, 45,120, 20,120, 31,162,166,179,233,102,209,122, 65,162,113,208,
 86, 21,199,166,253,111,134,241,118,139,127, 81,197, 93,229, 81, 78,151,121,234,
 20, 70,238,140,200, 56,123,139,114,167, 93, 21, 51,254, 38, 88, 88,117, 67, 28,
  6,226,225,209,125,230, 92, 73,201,182, 94, 76,169, 57,127,244,203,221, 89, 94,
 39, 48,230, 27,150,203, 74,226,219,173,216,205,165, 96,229,173,  1, 29,243, 40,
229,200,137, 34,181, 67,216,206,216, 24, 80,126,  9,111,166,249, 19, 78, 26,144,
157, 79, 44,230,174,201, 31, 65, 26, 33, 15, 17, 57,159,219,186,180,223, 32,223,
248,113,189,132,184, 99, 15,193,140,217,222,249,  6, 83,165,199,131,144, 48,191,
246,226,172, 74,185,244,184,171, 93,129,227,221,164,211, 34,  7,163,113, 38,182,
192, 34,186,192,  5,157, 78,146,217,174,122,231, 67,120,156,153,242,200,180,176,
176,205,142,  8,  1,141, 82,192,249, 10, 17,  5,194,  6, 36,127, 15, 24, 24,128,
153,250,112,173, 38, 80,183,160, 59,223, 83, 69,105, 63, 92, 93, 54, 77,196,109,
153,205, 60,137, 65,116,207,251, 72, 12,173, 35, 76, 65, 20,233,126, 42,  5,168,
 86,155, 80,  4, 33, 31,177,193, 77, 51,255,153,201,252,185,150,123, 58,198, 62,
246,166,116,  2, 23,190,238, 86, 39,
} ;

// ../Source/Template/GB_rowscale_template.c:
uint8_t GB_JITpackage_128 [887] = {
 40,181, 47,253, 96,233,  8,109, 27,  0,230, 43,132, 40,192,208,108, 14,248,118,
213,110, 18,204, 73,136,175,208,121, 36,118,103,197, 29, 83, 31, 91, 39, 14,132,
 31,165, 75,149,212, 27,224,224,186,138, 66,117, 21,128,122,  0,115,  0,121,  0,
161, 55,199,234,  9,183, 41, 72,115,237, 47,155, 26,215,246,104,101,146,184, 48,
143,175, 59,183,113,107,199, 57,212, 80,237,162, 88, 93, 42,144, 68, 36, 19,  2,
 65, 68,114,135, 23, 93,194,180, 51,175, 63,170, 99,132,217,110, 40,119,105,171,
 42, 50, 28,231,165, 36, 52,190,115,220, 58, 83,206,  6,125,232,205,115,115,113,
 86,171,153,244,123,223,201,185,192,159,199,244,215,251,118,232,185, 20,184, 40,
235,  9,157,167, 56,110, 58,119, 45, 78, 15,123,236,237, 36,229, 16,  8, 52, 65,
 32,  1, 87,116,128,201, 29, 14, 43,122,195,165,187,176,138,180, 60, 48,116,146,
 18,157,211,176,109,171,112,230,140,149,222,194,251,255, 67,144,198,237, 78, 87,
139, 63,233, 51, 39,115,233,250, 31, 95,139,153, 13,167,226,157,121,157,222,173,
127,117, 94, 62,170,122, 59,231, 57,190,195,124,208, 30, 99,180,222,228,177,225,
188,213,121,246,245,110,255,245,215,157,103,152, 47,138,243,237, 85,138, 47, 89,
 76,173,131,217,191,198,156,103, 91,143,105,200, 65,145,135,100,234,119,142, 31,
 55,246,115,163,153,119,252,104,150, 28, 50, 75,134,191,217, 55,204,245,212,177,
  5,158,185,190,182,216,201,168,149,250, 63,185, 35,163,102,162,111,149, 10,194,
129,230,206,224, 32, 87, 10,210,175, 74, 57,161, 68,107, 51,141,197,150,242,178,
101, 22,211,238,122, 87, 90,193, 28, 52,172,161,227,178,131,253,129, 52,192,178,
 44, 75, 74, 41, 39,255, 44, 76,215, 29,209,169,127,174,103,143,222,140,251, 10,
 28,195, 76,112, 93,245,140,171,245,228,245,220, 26,139,233,194,100,201, 16,180,
  1,109,  8, 80,143, 88,209, 49, 23,108,203, 34, 48,249,145,151, 42,104,134, 74,
244,210,231,186,196, 97, 20, 74,191,232, 21,166, 85, 21, 11,187, 42, 36, 26,201,
131,246,159,254, 42,189,199, 94,105,188, 68,101,116,217,101,244,227, 21, 62,126,
114,234, 24, 69,166, 93, 56, 11,131,232, 46, 75,182,117,149,133, 82,105,151, 46,
 25,151,113, 90,133,169, 61, 94,202,119,212, 24, 24, 80,152, 60,114, 42,114,120,
 52,207,140,163, 22, 57, 95,135, 30,190, 35,234, 54,156,250,107,193,139, 45,138,
 51,128,156,168, 97, 57, 82,102,102, 70, 68, 65, 65, 97,146,180,  6, 80,132,  8,
153, 89, 55,242,200, 72,203,164, 14, 25, 51, 19, 92, 32, 73, 38, 40, 41,255,242,
145, 90,166, 71,117,100, 42,184, 15,169,118, 32,114,100,161,213,240, 70,177,198,
 82,234,180, 24,128, 73, 25, 37,126, 76, 15,126, 24,  1,174, 79,247,204,235,178,
140,252,105, 29,187,240,182,125,231,193, 93,  3, 60, 26, 24,117, 39,178, 73, 34,
 42, 25, 71,102, 92,237, 35, 30,211,150,185, 13, 51, 75, 33,  1,107,194, 10, 32,
208,133, 25,136,133,155, 36, 46, 28,123,189,138, 21, 13, 55,185,233, 79,146,138,
206,210, 63,211,200,112, 43,101,139,  4, 58, 47, 21,  8,177,192,164, 94,135,237,
181,253, 16,209,207,233,160, 64,201, 48,211, 64,233,112, 28,168,247, 49,232, 83,
 26, 61,114,180, 17,200,172,146,146,148, 85,  3,121,131,186,158, 53, 68,123,203,
 57, 32,214,  8,155,253,145,131,235,170, 50,101,117, 97, 28, 70, 25, 26,240,222,
213,163, 35, 74,215, 79, 25,185,115, 40,189,105,119, 28,195,155,236,138,128, 57,
141,154,  8,175,240,138,161,226,  0, 64,176,232,120, 33,224,128,208,166,216,220,
 41,193, 99, 68, 50,110,106,183,199,102,108,162,129, 77,210, 33, 16, 49,174, 98,
230, 65,184, 43,136,236, 81, 44, 74,111, 10, 89,228,141, 67,  8,192,  2,202,  1,
162,135,234,141, 40,109,215,224,132,134, 18,128,179,  9,152, 55, 31,100,111,211,
 48,129,213,215,128, 18,194,116,136, 91,231,249,166,201,170,204,180, 97,100,  1,
132, 95,232, 74,119, 69, 12,
} ;

// ../Source/Template/GB_saxpy3task_struct.h:
uint8_t GB_JITpackage_129 [492] = {
 40,181, 47,253, 96,235,  3, 21, 15,  0,118, 24, 77, 33, 16,149, 30,166, 38, 44,
202, 36, 34,136, 71,194,103, 26,135, 18, 89,232,206,161,223,106,142,254, 98,201,
 48, 34,  0,128,170,154,  1, 68,  0, 70,  0, 65,  0,161,248,104, 43,235,143,102,
251,249, 75, 83, 90, 70,105, 80, 47, 94,136,194,241,141,158,230,249, 65, 26,148,
150,102,255,116, 55,  4, 25,195,209,215,206,198,213,126,254,250,211,101, 43,168,
149, 57,208,205,120,243,224,152, 11,159, 39,138,120,107, 64,250,186, 96,117, 93,
  1, 23,  7,198,114,209,182,137,150, 93, 10,154, 74, 38,211,166,203, 58,127,130,
  3, 11,171,156,114,209,203, 90,113,253,231,231,234, 82, 82, 57,174,206, 61,165,
202, 60, 42,150,244,208,117,236,150,198,153,114,222,210, 93,151, 53, 85,192,  6,
 88,133, 32, 12,176, 14,112,128,166,240,  7,247,198,143,  8,188,219,196,220, 20,
 71,218,211,250,232, 49,237, 16,170,133,172,238, 53,213,150,187, 54,115, 30,106,
 78,253,235,234, 69,231, 27, 51,238,188, 25, 14,185,126,119, 55, 36, 65,247,190,
 12,161,229,253,229,176,203,142,212, 18,101,238, 19,140,108,  1, 16,206,151,213,
 39,  8, 23, 13, 75,211,246,180,125,162,103,167,249,186,140,222, 53,126,154,251,
219,180,172, 32, 59, 59,208,161, 20,  0, 71,215,111,236,127,115,245,158, 22, 61,
170, 29,110,251, 62, 34,209,181,137, 57,229,219, 80,224,235,170,109, 12,232, 47,
  6, 74,160,177,165, 83, 67, 65,105, 74,202, 72,181,112, 80,134,  4, 68,105,117,
122, 68, 99,150,161,  9,173,247, 70,130,181,195,182,  7, 76, 46,208,118, 28,146,
 88, 82,216,245,104,103, 25, 33, 43,116,197,248,208, 83,  6, 73,  1, 30,182,  7,
133,232, 19, 19,244,  5,252,  2,128,218,112,120,131,146,134, 62,  5,187,110,171,
 41,161,184,117,225,120, 45,  3, 54,  8,110,140,125,163,203, 95, 55, 37, 25, 50,
190, 19,110,198,184,215,222,105,174,100,  1,173,177,253,232,162, 31,207,236,236,
181,  7,104,245,230, 18,167, 18, 40, 97,152, 40,244,219, 64,203,136,160, 13, 53,
246, 90,105, 83,237,240,208, 66, 20,120, 47, 62,230,128, 15,154,204,207, 76,235,
148,215,206, 39,138, 78,113,198, 84, 81,128,  7,
} ;

// ../Source/Template/GB_select_bitmap_bitmap_template.c:
uint8_t GB_JITpackage_130 [637] = {
 40,181, 47,253, 96,108,  7,157, 19,  0,182, 31,100, 32,208, 92, 23,  3, 24,157,
249,214,174,223, 80,173, 93,212, 20,227, 78,144,226,143, 28, 38,210, 92,171,249,
194, 11,142,170, 89,129, 91,  0, 88,  0, 87,  0,176,212,106,235,185,222,167,234,
122,142,162,224, 13,140, 69, 98,225, 61, 20,137,197,187,146,187, 65, 95, 88,189,
252,  0, 94,118,110, 87,235,142, 55,124, 64,177,114,230,154,102, 34, 86,167, 53,
127,236,190,175,207,118,125, 15, 62,117,223,177,240,235,220,  6,144,251, 44,143,
216, 93,209,220,178, 59,215,214,190, 40,114,151, 22,181,154,172,100,142, 64,108,
 30,  2, 17,132,239, 51, 76,241,108,150,109, 59,187,186,117,205,239,216,162,176,
250, 77, 54, 28, 27, 95,201, 99, 20, 15,124,199,253,123, 12,252, 46,111,186,181,
 77,  9, 15, 59,164,145,  4,183,198,174,242,255, 55,218,182, 29,108, 90, 15,222,
196,245,150, 45,113, 88,120,246, 44,107,  6, 31, 73,237, 77,221,141,173,169,241,
172,198,182,188,162, 55,186,116, 14,166, 13,166,197, 55,101,205,167,110,224,148,
 75, 71,129,168,242,155,132, 32, 86,130,231,127,191,167, 21, 10,147,231,103,174,
139, 20, 56,236,186,187, 76,191,153,222,149,119,215,173, 57,139,190, 76,123,150,
250, 29,230,180, 89,109,122,110,178,245,194, 79, 93,169,163, 22, 69,107, 90,243,
115,203,245,218, 82,213, 52,  7, 18,255,174,209, 10,195,229, 13,185, 62,219, 86,
219, 36,223, 59,139,154,184,158, 36,129, 43, 88, 82,215,196,247, 82,198, 76, 40,
174, 68,142, 37, 81,184,163,240,178,209,136, 56, 30,  0,  6,195,249, 50,160,230,
 66,  1,221,127,147, 95,111,197,125, 48, 16, 53,158,209,106,212,214,254,119,249,
134,108, 45,139, 59,134, 67,134, 32, 17, 12,145,227, 39, 28, 81, 37,247, 84,119,
 15,103,180,132, 98,248, 33, 73,158,113, 19,114, 15, 99,160, 81, 49, 83,140,140,
 76, 32,162, 73,146, 44,107,112, 68,166, 10,171,  3, 79, 36,220,140, 52,174,203,
 84,172,108,145, 89,233,144, 34, 25,226, 85, 71, 93, 49,  8,233,160,209,246,117,
156,133, 44,222,204, 12,244,152, 69, 53, 52,  5, 20,212,139,212,105,162, 36,218,
 58, 79,216, 58, 94, 26, 77, 76,108,  4,152,146, 38,161, 73,153,127,164,122,205,
  0,155, 13, 17,114,198,193,183,  7,215,156,108,179,102,107,143,204, 55, 91,251,
 13, 27,249, 16,239, 77,100, 48,250,131,141, 75, 54,194,144, 31,138, 95, 47, 62,
219, 65, 12, 29,160, 81, 66, 56, 60,121, 88,208, 14, 88, 25, 24, 29, 53, 96, 42,
130,172,  7,180,159, 32, 28,191,245,106,  6, 51,  5,  8, 34,255,230,179,250,229,
202, 68, 41, 76,245,178, 32,107,158,134,106,238,193,230,224, 29,  2,123,240, 92,
233,153, 37, 95,115, 43,154,219,196,111,184, 25, 90, 51,151,223, 52, 63, 42, 51,
173,219,112,205, 53, 68, 29, 39,156, 18, 25, 39, 77,144,162,188,  9,
} ;

// ../Source/Template/GB_select_bitmap_full_template.c:
uint8_t GB_JITpackage_131 [607] = {
 40,181, 47,253, 96,127,  6,173, 18,  0,230, 30, 98, 33,208, 92, 23,  3, 24,221,
252,109,191, 67,231,188,177,160, 41,198,157, 32,197, 31, 57, 76,164,153,156,243,
133, 23, 28, 85,179,  2,  1, 89,  0, 87,  0, 84,  0, 39,234,118,142,241,247,194,
 66,129, 80,116,142,  4, 66,113,142,220, 94, 72,175,171, 90,110,248, 14, 59, 55,
107,117,197, 23, 60, 95, 72, 57,117, 69, 49, 16,155,162, 85,123,236,190, 45,143,
246,244,254,187,121,207,169,114,235,220,133,111,243, 42,135,216, 93,177, 94,217,
 61, 98,220, 50, 71, 93, 87,251,158,198, 77, 90,108,211,145,130,249,225,160,117,
135, 67,121,210, 89, 13,219, 54,118,211,213, 45,189,103,139, 93,245,123,100, 52,
118,190,145,191, 38,221,119,110,187,247,215,247, 77, 94,116,167, 22, 29, 28,228,
140,196,241,219,105,102,145,255,175,201, 52,205,112, 67, 69, 67, 24, 20,157, 61,
201,170,191, 67, 80,123,205,187,179, 45, 51,157, 77,179, 37,111,216,137, 44, 28,
 67,105, 93,168, 77,109,231,233, 14, 54, 95,211,150, 55,111,224, 68,126,143,143,
 67, 74,112,125,239,247, 50,  2, 65,114,125,189,113, 16,194,150, 89,119,147,232,
181,210, 57,242,238,186,211,205,226, 86,105, 79, 50, 61,151,183,180,172, 22, 61,
247,184,106,229,163, 44,243,216, 98, 92,209,170,175, 87,172,215, 21,170,162, 58,
128,184,247, 20, 87, 87, 38, 95,208,245,  3,239,177,154, 54,211, 34,222, 57,139,
203, 92,207,113,176,205,  8,222, 77,154,244, 83,197,188,101,190,119, 34, 98,192,
 48, 21,110, 42,  8,194, 21,129, 22, 77, 38,180,233,  0, 46,151,141,135,249, 50,
150,201,231,222,147,252,118,169, 45,204,116, 68,108,239,113,250,  5,109,173,106,
251,101, 51,130,159,240,  3,141,162,  7, 20,223,217,136, 21, 48,  4, 61,227,168,
 35,106,192,237,101, 90,160, 97, 53, 84, 21,136,144,148, 38,  5,133,106, 53, 96,
 68,166, 10, 89,  7, 79, 68,110,147,228,174,198,200, 73,202, 68,181,164,  9,181,
 86,231,248,173,234, 42,199,112,  1,  1,149, 40, 52,246,240,202, 73,109,116,230,
225,164,111, 52,133, 65, 15, 92, 45, 26,203, 75,253,232, 37,228, 20,203,117,140,
234, 16,164,139, 55, 52, 80,125,125,123, 36, 77,246,111,183,181,183,  0, 71, 43,
227,134,177, 66,148, 57,196,143,207,102,232, 79,  3, 82, 89, 56,214,192, 26, 80,
 27,179, 48, 48, 50, 52, 96, 44,198,177,  8,180, 27, 33,221, 95, 59,213, 13,177,
  1, 50, 52, 83, 51, 89,189,115, 69,146,212,102,116,178,160, 42, 49, 12,106, 88,
194,140,  1, 63,  5,230,240,201, 90,240, 70,178,252, 78,140,118,  7,117, 72, 54,
157,194,184, 22,103,161,213, 55, 77, 71,101, 38,239, 46, 88,113,203,177,195,178,
146, 69,176, 87,212,229,  1,
} ;

// ../Source/Template/GB_select_bitmap_template.c:
uint8_t GB_JITpackage_132 [410] = {
 40,181, 47,253, 96, 93,  4,133, 12,  0,198, 83, 66, 33,  0,243, 54, 62,167,  5,
 18, 73, 57, 58,225,  4, 74, 85,224, 94, 42, 59, 16, 26, 55, 70,110,196,209,144,
199,168,170, 90, 16,  8, 16, 55,  0, 56,  0, 56,  0,229,103,102,139,215,230, 87,
118,191,241,217,209,156, 79,209,205,142,187,198, 94, 93,196, 78,216,144,231,184,
163, 58,104, 88,190,248,253,229,146,243,251,150, 31,103,227,204,221,224,231,215,
247,145, 57, 69, 81,137,162,  2, 34,222,228,135,154,244,154,124, 16, 91,  9,115,
 85,166,240, 61,230,235,231, 92,239, 81,131, 57,207,185,122,132,168, 12,149,148,
 56, 24, 42, 39,128,  3,143, 52,246,124,151, 79,213, 63,227,238,112,176,231, 81,
 87,237, 99, 12, 36, 22, 48, 60,227,144,170, 55, 60, 83, 11,190,175, 98,147,152,
162, 42,117,226,105,143,219,105,183, 90,140,194, 97,146,235,105, 17,241, 67, 17,
 11,220,221, 41,136,210,201, 39,139, 26,166, 74,250, 17,252,202,234, 11,243,113,
 20,179, 94,134, 89,187, 89, 24,236,162,104,151,141,131, 64,182,172,106,151,133,
219, 60, 11,179, 88,119,173,198,121,228, 41,160, 52,228, 78,176,214, 66,241,  6,
 96,224, 34,166, 34, 14,201,215,249, 67,  1,112, 10,248,135,103,  6,  3, 52, 32,
 64,134,136, 49,186, 14, 85, 56,160, 53,110, 91, 99,118,141,205,140,143,230,142,
224,  0, 77,166,175, 13,249,255,196,213, 78,131, 16,197, 64,213,116, 43,  7,229,
 16,133, 44,198, 13,  6,230, 43, 64,251, 12, 24,140,193,129,  7, 96,  6,181, 59,
241,182, 66,220,  5,246,  8, 64, 35, 65, 39,192,219, 69, 27, 20,137,128, 16, 65,
208,225, 17,142,135,117, 15, 71,102,  2,109,  0,111,124,240,134,217,  0,225,  0,
198, 33,151,179, 42,209,104,179, 25, 44, 54, 77,204, 51,147,219, 56,172,214, 55,
 66,135,  3, 14,105, 15, 68, 81,231,  6,
} ;

// ../Source/Template/GB_select_entry_phase1_template.c:
uint8_t GB_JITpackage_133 [1235] = {
 40,181, 47,253, 96,252, 16, 77, 38,  0,182,115,152, 39,208, 22,173, 14, 84, 95,
 81,123,110,255,103, 90,124,249, 35,  8, 46, 78,165,226,106,139,189,196,236,196,
 21,135,193,244, 28,176, 29,228,106, 56,128,223, 11,142,  0,134,  0,142,  0,147,
250, 72, 72,193,104,111, 47,124, 37,249,238,183, 63,255,255,202, 73,101,224, 66,
 48,245, 69, 49,117, 79,168, 13, 45,120,101, 87, 18, 83, 91,217, 20,172,152, 58,
 28, 50, 46, 85,143,212,182,205,185,189,215,  7,114, 30,163,123, 43, 32, 24, 32,
152, 16, 48,  3,  4,151,168,232,205,194, 17,118,248,197, 61,116,221,153, 65,207,
 91,199, 85, 48, 92,148, 43, 68, 66,219,202,180,211, 23,130, 58, 21,  9,147,160,
235, 54, 23,105, 26, 94,167,117,219,240, 87,130, 38,245,132,190, 28,105,214,247,
 97,218,242, 69, 95,168, 94,217,239, 82, 29,219, 62,  6,136, 11,  8, 84, 38,  1,
129,161,144, 14,121,136, 51,254,101,201,157,193,139,228,205,154, 29,146,129,228,
 59, 99, 27,138,215,  7, 52,235,229,188,149, 19, 94,219, 23, 68,179, 73,189,226,
174,215,253, 69,241,230,191, 72, 88, 68, 27, 42, 71,166,108, 95,247,243,190,106,
 10, 84,117,189,133,151,176,150, 16,185,143,252,186, 88,143,192,120,107,246,229,
169,243,215, 80, 61, 34,101,199, 17,134,240,186, 28, 93,152,168,203,156,224,  1,
149,175,165, 22,179,124,165,133, 99,230, 15,235,231,174,121,187,119,109,133, 22,
246, 75,193,122,109,215,128,223,103,112,112, 37,252,181, 50,145,132,105, 20,204,
 88,134,170,168,227, 69, 89,249, 92,244,104, 54,207,217,135, 43,  5,136, 29, 35,
195, 75,146,217,125, 78,196, 81, 80,190,233,112, 92, 70,231,117, 36, 50,151, 36,
 23,157,  2,227, 57,108, 42, 24, 44, 52, 38, 60,156, 77,167,227, 50, 88, 45, 76,
 77, 67,151,255,251,218,  4,218, 18, 41, 42,217,100,120,120,158,171, 92,218, 71,
 66,146, 25,227,180, 26,198,194,145,227,  5, 51,205,123,140,229,253,145, 44,225,
 49, 27, 35,223, 90,104, 89,243,157, 77,251, 89, 77, 27,217,222, 25, 29, 51,213,
  9, 43,125,119,100,120, 43,211, 10, 94,233,151,150,178,235,204, 30,149, 74, 74,
 37,115,169,181,214,104, 67,116, 76,127,106,103,175,227,249, 31,  9, 45,232,214,
172, 36,223,148, 55,112,228,216, 54,182,230, 41, 22,139,100, 65,137,118, 99,209,
 61, 56,158,139,205,123,192,120, 27,141, 10,183,241, 60,157,141,  7, 94,225,142,
 62,115, 19, 41, 66,129, 96,166,203,229,114, 71, 63, 36,  4,193, 88, 26,  8,246,
113,218, 90,107,173,146,253, 28,125,115, 52,227,121, 54, 16,153,183,203, 69,119,
 47,130,  1,226,154,139,204,107,205, 74, 66,235, 10,199,158, 57, 71,230, 32, 31,
154,200,191,124,172, 78,146, 79,121,219,179,146, 11,183,224,137, 69, 33,243,129,
107,  2,129,  8,168,113,177, 67, 67, 51,129,136,130,130,164, 32, 73, 99, 81,  8,
 98, 16,244,210, 65, 62, 98,128, 64, 81,132, 32,  2,149, 34,138,137, 36,144, 56,
  9,100, 70,146,100,148,206,  3,127, 75,199,215, 15,101,158, 93, 61,  1, 76, 23,
187,177,126,245, 17, 82,182, 42, 16, 41, 66,189, 88, 11,165, 15,209,173,209,252,
118,122,170, 32,137, 61, 18, 35,214,108,107,201,100,250,142,103,188, 80, 45, 70,
 85, 41, 29,150, 45,234, 58,160, 91,  9, 62, 26,  3, 55,245,115,123, 71,164,191,
 75, 23,118,222,146,239, 46, 88,197,237, 19,156,129,142,164,105, 87, 44, 85, 65,
  8, 19, 92,180,213,181,125,124, 70,198, 73, 28, 58,164,199, 18,216,161,235,246,
211,128, 80,193,135, 99, 82,252,200,103, 90,127, 82,253,232, 58, 52,198, 29, 60,
  3,119,108,207,160, 79,162,212,165, 57, 37, 33, 48,244,234,174,199,172,162,212,
 91, 10,129,177,243, 81, 99, 18, 29,115,181,160,164,106, 74, 12,248,114,191,225,
132, 96,199, 68,179,202,172,238,208,115, 75, 43,168,247, 83, 28, 84, 81,223, 25,
169, 49, 43,208, 64,214,220,201, 94,240, 21,244,240, 25,119,135, 82,160,159,199,
138,  4,  5,  6,107,132,242,197,240,211, 84,184, 25, 63,236,  8,  3,205,230, 81,
151, 12,221,126, 58, 22,214,237,196,120,192, 72,247, 80, 41,205,195,125, 80,206,
183,224,155, 12,230, 36,105,  0, 79,208, 76, 58,196,115,152,184, 12,152,122,188,
 99,236,175, 44,219, 28,117, 34, 87,203,150,158,130,199,145, 99, 40, 46,147,111,
141, 92,138, 49,  6,119,  0,131, 47,209,156,231, 97,219,115,  4,208, 13,206, 40,
 70, 73, 69,102, 90, 48,147, 86,156,  0,190,145,218,241,178,232, 82,171, 19,137,
130,144,182,253,241,148,173,144,209,207,110, 30,199,147,189,142, 52, 36,158,136,
231,189,165, 13, 39,128, 16,145, 41, 84, 66,160,128, 32,167,150,169, 75,203, 97,
 14,120, 33, 24, 48, 54,203,162, 28,  6,144,143, 56,242,170,174, 80, 25,174,234,
175, 82, 31, 45,151, 36, 59, 75,116, 16,100, 12, 78,152,232,127, 73,139,194, 39,
 46, 52, 88,195, 79, 12, 16, 18,104,205,149,143, 13,189,  7, 52, 98, 99,  6, 39,
141, 76,204, 23,250,242, 99, 82,131,255,  9,140,239,201, 39, 95,103,155, 70,138,
136,103,  6,159,173,192, 37,102, 49, 50,242,154, 81, 60,  4,246,167,211,  1,117,
230, 20,  0,127, 82,160, 70,137,244,202,229, 87,157,161, 71,170, 47,163,230,157,
241,110,141,115, 19, 27,  8,  8,165, 85, 86,142, 72,217, 30, 58, 64, 64,100, 37,
177,157,205,160, 97,159, 12,133, 27,133,143, 36,106, 43,200, 70,194,222,225,124,
203, 56,182, 17,  2,236,138,190,124,156, 73,  9,110,110,113,208,160,  9,127,102,
 98,118, 80, 96,231,196,124,253,249,  1, 64,165,194,181,  9,
} ;

// ../Source/Template/GB_select_phase2.c:
uint8_t GB_JITpackage_134 [1500] = {
 40,181, 47,253, 96, 44, 27,149, 46,  0, 38, 58,172, 40,176,146, 85, 29,170, 38,
139,138, 75,130, 61,172,200,  6,243,136,  8, 45,127, 75,155, 91,  3,244,133, 30,
235, 74,242,196,141, 13,154, 59,165, 63, 77,239,142, 75,159,  0,160,  0,155,  0,
184,177,212,158,113,253, 78,231,179,230,167, 88,249,229,249,249,109,143,166, 81,
100,125,163,242,112, 90,135,214, 58,150, 31,121,180, 62,211,198,125,109,158,207,
161,207,225,109, 59,234,126,235,241,241,188, 37,169, 80, 46,147,238, 52,105,227,
 19,110, 79,110,102,218,155,102,210,152,182, 54, 55, 19, 11,  6, 14,101,107,143,
219,184, 59,199,185,227,152,157,123, 94, 60, 44,184, 84, 46, 19,  4, 75,229,242,
 73,147, 14,241,244,144, 12,167,196,143,186, 92,191,137, 29,122,226,102,161,179,
242, 58, 36, 52,190,210,122, 58,207,144, 71, 50,129,104,168,203, 48, 74,149,245,
132, 75, 99,217,217, 44,107,237, 53,206, 22, 28, 78, 64, 32,153, 16, 16,  4, 22,
131,176,204,148,146, 30,230, 28,116,102,160,206,180,233,225,152,101,124, 39,  7,
226,230, 70,251,155,205, 68,195,179,109, 77,212,199,189, 85,205,214,123,176, 35,
129, 89,215,230,242,100, 92,111,148,155,  1,211, 20,165,115, 34,  4,166, 89,200,
 60, 26,  0,233, 88,231,242,120,226, 38, 59, 99, 58,191, 53, 14, 29,143,228,135,
 39,111,125,119,249,144,155,223,220,104,123, 30, 82, 97,146,229,115,214, 32, 19,
139, 38, 73,116,113, 46,176, 44,206,217,117,152, 91,133, 73,124,117, 27,159,181,
121, 51,238, 59,240,231,204,224, 32,211,249,140,105,213,226,115,115,252,255, 37,
 33, 18,  9,197, 33,106, 24,126, 43,119,207, 11,113, 31,125, 42,246,228,105,211,
122,221,176, 76, 78,161, 80,158,177, 81, 41,237, 87, 53,204,167, 13, 80,198, 45,
 20,156,108,148, 30, 51, 78,102,173,195, 67,120,  8, 58,132,150, 61,220,104, 31,
102,209, 74,183, 56, 25, 67, 68,204, 34, 39,195, 46,  7, 60, 71,159,211,250,173,
179,188,109,235,251,243,154, 63,129, 96,130, 20,207,213,231,141, 78,238,153,131,
142,121,205,216,227, 95,189,220,105,157,152,111,100, 84, 89, 30,116,235,199, 43,
 61,238,186,157, 42, 60,132,162, 50,152, 87, 94, 73, 22,168,205, 79,210,209, 38,
181, 23,218,186,211,240, 39,  9,111,178,111,151,179, 47, 68,251, 74,123,251,213,
203,143, 67, 94,187,205,252,234,214,229,  3, 87,102, 28,146,107, 51, 17, 10,200,
 88,168,145,202,226, 98,136,208, 52, 52, 72,216,195,169,177,228, 74, 33,236, 79,
 28,221, 76,251,158,164,149, 67,206, 13,211,143,250, 44,187,201, 35, 52, 53, 95,
155,  9, 57, 32,146,152,184, 58,  0,169, 79, 75,250,200,106, 95,127, 25,234,182,
203,245,243,190,242,175, 92,193,126, 82, 29,132,142, 62, 40,221, 34, 66,104, 50,
 91, 51,198, 49,135, 10,137,142,198, 69, 68, 62,125,163,233, 96, 94, 75, 70, 40,
 74, 20, 69,150,104,190,250,134,101, 89,168,204, 45,123,  1,129, 87, 10,183,236,
 57,219, 13,146,222, 32,145, 93, 19,155, 72,145, 97,158, 11,219,152, 17,175,  0,
 62, 99,204, 96, 94, 61,218,238,161,122,199,244,139, 14, 22,113, 73,223,154,206,
 63,129, 89,168,161,173, 51, 66, 35, 34, 18, 36, 73, 82, 72,107, 97,136,192, 40,
 40,153,244,204,  3,130,192, 44,149, 81, 36, 66, 24, 33,198, 56,129, 33,  2, 67,
130, 34,129,136, 72, 32, 35, 18, 69,129, 40, 29,144,224,146,127,198,252,216, 10,
 77,130,142,224,155,  8,120,216,247,106,212, 23,191, 87, 83,241,112,149,227, 98,
228, 67, 35, 21, 10, 99, 88, 34,173, 23,152,242, 16, 77,186, 42, 48, 51, 61, 21,
110,122,204, 25,234, 15,151,255,  0, 35,158, 49, 99,131, 17,195,143,180, 56, 31,
  1, 56,218, 77, 13,117,127, 31,220,110,193, 84,113,141,143,243,106,245, 35, 31,
104,163, 19,218, 46,140, 64, 60, 20,227,210,115,175, 34,115,234,121,247,132,125,
 79,149,175, 84, 91,191, 45, 97,215,  2, 54, 17, 32, 73, 41, 82,221,131,237, 60,
179,196,165, 23,226,169,214,203, 75, 19,155,142, 57, 90, 85,251,211, 39,246,101,
 71,134,245, 26, 69,145,134,197, 86, 14,185,124, 39,197,200,239,189, 50,164,204,
244,249, 76,219, 97,  4,253,235,131, 20,146, 44,191, 21,190, 61,249,189,123,167,
188,162,199,245, 22,248,232, 74, 98, 23,172,187,223,144,  8,  8, 93, 26,164,237,
 61,152,205,137, 28,145, 12,192,198, 95,144, 65, 98,227,149,207, 33,227, 54, 44,
  2,195, 33,252, 84, 92, 50,183, 62, 63,134,244,250,102,156, 97, 65, 40,190, 21,
116,218,156,164,106, 30, 44, 61, 36,213, 61,195,200,120, 38,254, 84,136,251, 75,
211,155,187,139,143,147,128,125,150,142,146,229, 78,192, 31,122,140,129,207,  3,
 97, 64,187, 47,239,252,197,182,151, 10,149, 79, 40,224, 39,206,144, 39, 40,193,
 71, 25,184,149, 97,171, 64,201,  0,177, 34, 42,123,160,122, 30, 38,189,211,132,
  4, 72,180, 25,151,156,  1,118, 32, 82,131,233, 80, 39, 62,254,122,230,148,  1,
170,195,229,207, 45,198,162, 54,102,234, 90, 21, 33, 38, 14, 69, 86,130,125, 27,
 97,184,151, 86, 61, 30, 81,228,148,  8,125, 34,106,196, 83, 43,252, 99,175,119,
166, 21,207,122,211,113, 95,149,250, 82,198, 37,253,244, 39, 16, 76, 60,169,138,
243, 85,158,110,  9,236,242, 78, 72,214, 94, 43,  9, 63,184,190,103, 36,208, 34,
 94, 74, 15,188,109,  5,242, 85,155, 25,220,221, 97, 68,142,206,236,154,182,207,
 75,184, 17,163, 13, 74,141,158, 39, 14,127, 36, 92,157,138, 92,149,195,218,194,
120, 97,100, 80, 26, 21,167, 95, 83,185,196,  0,131, 53, 38,226,209,127, 30, 74,
 68,136,121,173,  5, 28, 27,  6, 98,194,  2,237, 38,165, 33,101,214,160,242,209,
 27, 18, 46, 21, 81,220, 64,170, 24,227,  7,228,135, 35, 32, 98,126,200, 11,  2,
  3, 83,207,133,108, 56,252,185, 73,106,  2, 69, 45, 66,133,188,242, 72,172,236,
 89,231,143,232,194,  1, 81,141, 78, 51, 74, 59, 50,180,136,103, 75, 75,248,  6,
123, 61,129, 69,157, 91, 48, 32,188, 29,219,194,160,179, 23, 77, 10,104, 28,201,
153,162, 15, 59,115,219, 18,219,101,131, 79,186, 84,130,125,137, 40,196,153,217,
162,247,142,125,253,129, 49,159, 91,192, 95,129,  6, 54,  9, 67,195,142,138,237,
220,238, 85,152, 23, 83, 83, 51,152, 98,131,  9,  4,195,253, 95,119,180,190, 72,
 68, 11,145, 11,104,120,140,246,126, 11,220,140, 14,186,216,100,193, 18, 67,161,
 21,115, 26,  4,200, 12,237,179,  8,239,188, 66,102,211,245,124,131,181,237,250,
 72,213, 26,148,161, 68,220, 94,211,111,169,144, 65,173,100,194,135, 18, 40,  1,
 92,153,224,168, 36,207,141,123, 64,253, 80,176,197, 37, 26, 73, 63, 33, 76, 89,
196,213,208,166,169, 80,153,  9,231, 81,175,190, 99, 60,180,152,106,101,117,  2,

} ;

// ../Source/Template/GB_select_positional_phase1_template.c:
uint8_t GB_JITpackage_135 [1796] = {
 40,181, 47,253, 96,176, 36,213, 55,  0, 70,187,176, 40,176, 86,117, 14, 20, 56,
163,  9,104, 20, 95, 66,172, 50,227,177, 72,160, 20,174, 11,111,178,224,100,179,
230, 36, 87, 51,165,119,252,160,255,160,243, 83,130, 11,161,  0,164,  0,164,  0,
 89,215,107,185, 14,252, 98,  7,  8, 87,246,175,149, 51, 19,201,206,218,179,183,
183,175,201,120,248,203,162,255,127,165,114, 82,201, 96, 10, 40,230,178, 72,225,
 55,149,123,235, 43, 89,179, 40,182,146,179,246, 80, 25, 15, 31,140,198, 34,149,
 45,131,110, 47, 39,106,208, 61, 15,126, 50, 40,200, 20, 80,  9,154, 76,193, 45,
153,244,201,182, 72,124, 56,  6,190,132,187,115,212,161, 79, 23,244, 52,112, 52,
214,136, 13,219, 26,233,197,183,191,171, 98,233,228,199,221,  9, 74,149,195,235,
220,110,185,235,149,252, 43,191,153,125,195, 55,122,116,196, 23,211,176,141, 28,
197,188, 40,103,223,182,147, 98, 55, 99,143, 45,214, 16,113,  2,130, 10, 69, 64,
 16,149,187,216,232,147, 30,123, 94,172,145,158,142,230,227, 72, 20, 43, 13,232,
234,188, 25,139,156,203, 34, 95,246,185,172, 70,182, 47,169, 81,246,199, 55, 31,
 72, 17,178, 26,  0, 48, 58,229, 71,162, 53, 22,  1,173,135,170, 58,107, 51,163,
 83,  2,117, 62, 26, 18, 71, 65,121,231,  2,193,207,133, 93, 22,231, 22, 11,148,
254,208,241, 52, 80, 92, 76,  0, 72, 15,129, 58,215,  5, 45,  3,222,204,126,167,
252,253, 62, 62, 13,140,204,186,109,243,147, 40,182,246,233,235,122, 63,121, 93,
175,116, 58, 95,101, 44, 34, 37,123, 34,177,155,227, 32, 93,160, 40,228,188,224,
  3, 53, 94, 75,109,103,227,149, 24,252, 37,122,156, 99, 29, 99,240,213, 25, 98,
215,214,222,186,223,150,231,115,105,234,161,165,251,213,133,115,254,234,213,110,
187,162, 92,231,198, 31, 11, 41,253,202,119,139,231,209,204, 46,219,243,226, 79,
 20,222, 91,107, 18,164,251,196, 73,128, 64, 64, 88,124,250,116, 49,121, 44, 80,
136,109, 40,162,227,241, 56,160,169, 87,183, 28,100, 17,114,232,120, 58, 23,150,
209,121,168,176, 48, 44, 64,210, 53,150,189,177,246,173,  3,168, 79,109,117, 75,
240, 37,204,221,204, 23,164,111,156,179,245,226,246,234,154,252,230,252,160,162,
137,  4,201,170,107, 46,191, 38,121,234, 62, 81, 40, 29, 98,159, 99,144, 90,186,
105, 35, 93, 46, 10,239,206,121,230,213, 59, 73, 99,173, 63,145,196,222,167, 49,
151,217, 91, 36,  6, 37,171, 69, 14,149,139,141, 53,249,  5, 68, 47,229,178,185,
230, 12,167, 23, 16,176,109,229,200,252,141,220,167,140,244, 12,232,113,  5, 15,
205, 69,122,133, 69, 97, 97, 10, 30, 28,213,141,239,234, 28, 57, 79,109,225, 10,
 90,223, 95,217, 21, 76,157,178, 59,140, 58, 92, 36,251,102, 95,189, 86,106, 92,
251, 11,169, 30, 26, 10,131,201,112,216,232, 97, 96,156,239, 71, 83, 28, 60, 58,
142,211,141,219, 93,239,179, 92, 69,211,171, 96, 46,173,113,170, 46,109,111,214,
143, 41,185,116,196,156,107, 63, 16,234,159, 44,153, 87, 11, 18,  5,192, 17,201,
150, 29, 79,153, 44,219,152,157,187,243, 99,100,202,203,133,106, 46,211,214,217,
188,167,167,204,221,116,  9,  7, 16,236, 92,152,  6,  8, 86, 88, 13, 88, 40,129,
198,168,193,161, 66,102, 68, 68, 68, 68, 36, 73,146, 12,  7, 65, 12, 66, 16,115,
 88, 66,106,  7, 50,136, 28,143, 66, 12,138, 80, 12,  2,209, 16, 65,132, 16, 98,
  4, 68, 96,  4,226,136,140, 80, 32, 97,130,106, 14,136, 98, 60,242, 43,  5, 15,
 63,243,240,209,209,252,192,130,185,241,127,131,219,178, 43, 37,243, 19, 44, 49,
 82, 38, 64,166, 97,111,211,207,125, 64,191,225,103, 99,233,193,154,201,129,232,
107, 14,186, 54,195,  4,161, 19,205,234, 47,249,166,215,139,141,197,224, 49, 40,
181, 48, 55,216, 62, 40,199, 56,216,  5,189,212,130,208,135,202,122, 23,150,249,
 92, 13,101,213,189,  1, 37,127,161, 48,157, 26, 54,197,207, 11,247,243,245, 42,
245,241,230,176,193,246,219,207, 76,114, 68,118, 48,161,  7,184,196, 29, 40, 34,
249,126, 18, 94,173, 89, 51,154,118, 97, 45,  0,250, 35,234, 12,160,109,148,225,
244,120,105,  0, 88, 10,205,254,  2,140, 85, 38, 70,104,247,  6,211,240,147,138,
183,100,211, 37, 63,182,110,147, 32,212,156,196, 30,142, 99,126,188,201,150,217,
197,236, 72, 53,115,121,207, 54,212,163,194,181,131,192, 11, 12, 95,  5,103,224,
160, 85, 64,244,208, 49,188, 98,212, 12, 99, 68,180,138,  0,114,141,169,199,186,
219,146, 62,182, 47, 59, 42,103,116,198,  8, 68, 48,237, 43, 48,193, 55,126,120,
197, 16,104,153,177, 19, 88,171,  9,165,190,220, 48,161,195,146,157,118, 41,121,
 75, 84, 28, 26,  8,168,218,236, 82,254,101,192, 15, 62, 92,156,141, 64,149,142,
124,237, 91,164,177, 30,164, 92,141,236,252, 71, 68, 67,129,101,150,202, 68,103,
243,195,206,160,190,188, 52, 78,104,233, 64, 68,204,213,142,106,123,129,156, 57,
205, 57,148, 81,  7,214, 51, 88,217,125,123,114,173, 13, 85, 35,116,239,180, 57,
 15,243,217, 80,255, 97, 23,179, 81,183, 56,132,235, 71,199,123,225,106,215, 11,
206, 19, 71,169, 42,116, 81, 67,237,148,204, 38,234, 15, 39, 68,198,126,161,194,
214,206,210,  4,220,225,113,185, 52,129,167,173,121, 34, 71, 63, 85, 88,201,237,
179,196, 83, 42, 35,222,166, 10,198,227, 56,240, 13,234,129,  1,219, 11, 31, 27,
 27,194,188,101,200, 98, 63, 73, 95,128, 29, 46, 65,177,125,236, 13,  1,180,121,
 89, 31, 61, 90, 24,252, 22,147, 55, 25, 74, 46, 82,111,189,242,126,221,197,182,
237,210,196,183,152, 69,213, 28, 34, 36,205, 56,233, 17, 45,132,107,201, 33, 44,
109,248,194,202,132,105,151,157,104,199,239,162,223,216,193,171, 42, 95,116, 34,
 64, 20,153,130,132,192,228,132, 13,126,144,244, 21,174, 27,177,169, 93, 51, 27,
 87,120, 12,109,148, 77,161,181,119, 74, 12, 87,239,117,121,169,216, 10,224,144,
167, 60,220,103,169, 62, 17, 76, 90,168, 58,237,231, 14,100,183,  8, 54,232,195,
 49, 39,123,169,197, 34,186, 28,234,  8,212, 60,157,172,151,177,116, 59,110,243,
118,142,185, 65,252, 14,248,214, 67, 11, 84, 83, 20, 99,163,226, 92,238, 96,128,
171, 11,180,112,200, 75,193, 65,133,215,165,240, 87, 28, 38,120, 41,216,236, 77,
186, 88,130,254, 79, 72, 71,104, 11,227,205,247,235, 77,128, 66, 33,193,214, 75,
137,124,199,225, 96,193,122,139, 84, 50, 50,184,157, 44, 72, 21, 82, 37,146, 12,
 50,221,229,156,246,121, 17,128,231,206,200,219, 40,196, 13,239,235, 22,145, 72,
 61, 70,218,155, 92, 40,176, 69, 33, 64,125,231, 40, 67, 52,194, 10,  9,184, 68,
107,  7,248, 16,103, 10,255, 43,211,124, 69, 95,247, 99, 72, 93, 46, 10,184,181,
167,203, 30,206,108,141,197, 98,120, 15,248, 32, 92, 22,251,134,157,206, 68, 63,
142,151,146,112,198,183, 69, 38,231,229, 59, 77,105,111,143,112, 95,181,188,242,
 30,176,161,146, 11,150, 77,242,201,112, 71,143,233,143,175,204,117,200, 97,192,
 17,  5,182,206,167, 96,129,213, 80, 48,130,119,175, 23, 24,250,211,202, 71,255,
 64,217,182, 69, 80,129,148,162, 70, 67,143, 40,150,114, 12,102,156, 45,170, 80,
  2, 41,213,176,127,174, 14,190, 38, 77,124,227,171,245,177,209, 45, 91,124,125,
 91,212,174,203, 23,170,250,222,145, 26, 11,172,157,199, 67, 79,193,255,233,171,
232,253,171,113,122, 58, 19,196,177,222, 57,201,175, 16,116, 25,187,119,165,191,
 86, 82,196,222, 18,  9,134, 92,150, 94, 76,202,173,159,105, 17,196,239,164,135,
216, 68,251, 42,116,212,116, 45,146,127,228,196,101,142, 50, 17, 98, 44,185,246,
 56,242,106, 38, 77,216, 60, 69,241,172,113, 90,207,200,136, 74,249,254,211, 18,
 25, 97,140,155,117,227,109, 23, 25,110,112,121,229,192,113, 42, 52, 96,202,114,
 15,217,229,136,237, 78,134, 41,236,243,216,196, 32,148, 34, 19,219,166,211,249,
 98,111,102, 28,  9, 66, 64,124,168, 67,240,152, 40, 21,146, 72,206, 93, 31, 52,
 79, 63, 51,133, 69,102,206, 67,130,187,107, 53, 74, 29,107, 19,
} ;

// ../Source/Template/GB_split_bitmap_template.c:
uint8_t GB_JITpackage_136 [585] = {
 40,181, 47,253, 96, 81,  5,253, 17,  0,198,155, 87, 32,224, 26, 29,  3,212,159,
 96,  2,110,167,154,216, 43,110, 92,212,176, 94, 82,243, 32,143,234,249,  7, 95,
141, 24, 35, 69,  6,135, 78,  0, 77,  0, 79,  0,162,252, 32,129, 48, 32, 58,198,
193,128,248,246,105, 31,104,203,162,148, 19,228, 93,225, 86,141, 22,244,193, 71,
106, 38, 33,166,217,226,168, 58, 83,252,169,219,174, 62, 89, 21,237, 86,237,107,
223,178,121,211,241,167,191,163,110, 42,226,177,110, 15,211,113, 91,147,183,173,
136,181, 55,177,188, 80,200,186, 66, 33,146, 78, 62,242, 91, 69, 22,253,246, 20,
139,125,173,166,178,241, 84, 50, 30,232,130, 57, 85,240,100,  1,242, 53,220,  7,
 47,253,252,174,168,255,127,150,193, 50,  3,  1,209,213,240,163, 88,222,145,171,
 61,217,125, 43,120,233,170,190,245,179,154, 46, 68,233, 16,192,202,202, 85, 87,
207,245, 14, 81,214,115, 49,215,155,154,  6,105,205,225,246,198,213,125, 86,157,
 46, 86, 81,164,153,226,227, 81,117, 58,162,104,198,134, 71, 62,241,156,115,182,
 54,173,210, 17,129, 60,  9,186,104, 58, 31,143,243,185,220,147,  5,111,  5,204,
105, 50,201,239,207,230,173,107, 22, 52,182,190,170,239,187, 32,242, 22, 29, 95,
119,180,224,252, 30,  1,153, 92,  1, 34,215, 34,101,221, 44,198,113,155,196, 31,
136, 58,156, 86,107, 30,182,105, 63,149,100,105,226,209, 77,147, 94,112, 41, 45,
 78,177,236,185,239, 76,183,182,244,145, 75, 91, 72, 61,  2,145, 91, 24,199, 65,
 38,214, 54,  7,167, 93,149,221, 95, 38,125,251,236,166, 91,107, 85, 92,129, 53,
252,244,183,100,160, 33, 69,199,  8, 13, 73, 10, 10, 10,146, 74,107,112, 68,166,
204,186,  1,211,154, 92, 75,100, 32,145,252,177,148,189,  4,166,225, 45,143, 64,
 72, 20,  6,  8,  6,175,205,168,  5, 39, 64, 52,105,217, 23,136, 27, 62,163,202,
159, 37,179, 81,198, 22,100,179, 52,130, 41,154, 28,145,101, 96,246,131,166,150,
 76, 69, 25, 95,150, 35,180,172, 60, 76,100,250,140, 75,244,186,234,249,160, 45,
  1, 15,106,168,206,139,124,173, 29,244, 97, 45,173, 70, 58, 96, 54,248,216,176,
 80,247,179,106,133, 32, 20,242,190, 32,143,193,252, 28, 69,  9,137,110,  4,131,
 57,192,218,179, 82, 13,108, 62, 70,181,131,173,173,253, 89,213, 95,104,157,  5,
240, 41, 87,105,177,227, 24, 13,  0,220,225,200, 38, 35,201,162,107,129,217, 85,
231, 22,238,186,253,165,188,221, 95,100, 93, 45,244,195,133,150,198,137,169,100,
147, 28, 81,115,208,236,168,204,180,110,131,149, 92, 83, 84,226, 32,242,208, 81,
111, 95,209, 59,  6,
} ;

// ../Source/Template/GB_split_full_template.c:
uint8_t GB_JITpackage_137 [538] = {
 40,181, 47,253, 96,101,  4,133, 16,  0,246,156, 89, 33,208, 90,231, 64,  7, 28,
 75, 96,220,125, 44,237,204,237, 32,  4, 97,104,189, 17,129,135, 39,245,162,116,
 25,165, 30,120,129, 82,  2, 81,  0, 76,  0, 82,  0, 57, 52,213,207, 69,113,222,
192, 88, 36, 22,135,135, 34,177,248,192,203,110,192, 53, 69, 43, 71,204,179,194,
 76,142, 53,116,  3,104,110, 40,225,165,229,  5,210,184,164, 23,212,185,162, 64,
 88,139, 53,147,217,214,175,106,153,233,248,211, 31,210,153,138,119,236,220,137,
 34, 10,236,114, 21, 47,238, 40,151,107, 26,118,208,180,253,129, 53, 48,255, 89,
122,238,185, 77,255,127, 12,115, 97, 24,130,196,245, 93,210,227,246, 58,204,183,
 29,170,254, 53, 70, 61,147,246,184,254, 35,195,220,227,113, 13, 67, 88,  2,177,
 56,116,232,209, 59, 15, 41,187,130, 53,219,254, 48,135,198,182,189,186, 57,136,
 42, 30,196,215,169,178,113,127,142,  3, 36,120,177, 69,145,150,244,254,142,228,
233,104,162,229,229,238,128,196, 21,144, 61,244,177,128, 64,147,227, 56,110, 53,
200,190,125, 53,159,113,151,132, 91, 60,163, 80, 55, 51,182,164,  7,214,207,118,
192, 59, 97,123,203,142,245,227,188,200,228, 48,191,221,182,152,162,207, 93,195,
145,109,221, 88, 56, 31,139,166, 11, 97, 50, 96, 24,  6,246,103, 81,  1, 12,123,
 97,175,193,188, 55,140, 60,157,210,156,223, 94,226, 46, 73,211,232,  9,159,179,
222, 83,170,190,240, 92,210,140, 43,253,246, 89,181, 83, 68,176,189,222, 85, 40,
 72, 34, 79,124, 59,119,179,129, 87, 51,205, 56,107, 17,245,117,232,225, 15,108,
199,101,248,163, 93,134,185, 27, 81,246,101, 72, 32,128,  2,153, 42, 43, 15,242,
204, 64,222, 96,152,219,187, 83, 15,208, 14, 40, 13,  8,  9,220,  7,135,107,128,
225,181, 14, 26,102, 49,147,152,206,124,  5,135,233,101, 93,  7, 70, 52, 37,136,
126,159,214, 65, 32,  3,189, 97,115,136,126,199, 70,247,130, 91, 71, 21, 32,209,
 16,110,100,130, 58,209,185, 31, 86, 11,144, 39,112,220, 71, 97, 17, 34,188,125,
 66, 80,194,161, 62,212, 23,235, 70,124, 28,207,209,215, 35, 29,195, 18,227,138,
178,100,  7, 22,148,141,245,236,178,112, 39,246, 23,120,117,  7,147, 85,213,  2,
120, 88,  8,137, 39,225,111, 64,138, 25,152,147, 32,134, 45, 97,111,211,244, 60,
 51,177,173,146,213, 58,197, 72, 27, 63, 41,215,  0, 17,156,162,124,  8,
} ;

// ../Source/Template/GB_split_sparse_template.c:
uint8_t GB_JITpackage_138 [803] = {
 40,181, 47,253, 96,167,  8,205, 24,  0,198,163,108, 32,224, 88,231, 24,203,  4,
119, 25,145,215,107, 59, 67,106,120, 21,143,129,176,  1,154, 44, 51, 74,240,205,
 25,204, 48, 76,243,112, 99,  0, 99,  0, 99,  0, 89,227,219,157,205,100, 33,  9,
135,224,117,170,108,220,157,227, 12,150,108,231, 97, 72, 63, 19,  8,  3, 34, 99,
 28, 12,136,  7, 58,236, 19,219, 84,149,156, 64,191,  2,243, 40,218,207,167,135,
102, 34, 32, 89, 75, 74,195,211,217,162, 60,151,202,150,185,138,127,189, 56,150,
223, 59,180,249, 29,150,174,197,175,127,163,115, 13, 73,177, 51,215,184,172,217,
134, 36,230, 34,148, 23, 10, 87, 86, 40,  4, 32, 73,102, 78,177,200,215,102, 38,
154,206,  4,195,125, 44,151,207,122,183,  1,219,182,109,191, 28, 87, 65, 50,250,
  0,118,237, 42,250,220,217, 50,227, 46,  5,159,112, 68, 31,142,102,124,199,238,
 99,201,112, 60,220,198, 99,249,218,187,159,  5,108,255,198,151,174,237,108,136,
223, 96,158,219,189, 91, 79,159,187,244,255,191, 46,214,101, 32, 32,178,  6,187,
 74,210, 55,202,182,159,205,183, 61, 75,218,169,233,225,248, 73, 35,237,172,193,
224,225,184,225, 26, 22, 56,204,206,138,245,174, 60,172, 67,148,215, 96,135, 31,
184,220,134, 97,175,118,  9,102, 78, 68,221,151,227,247,176,195,176,150,149, 60,
 41,142,175, 98,169,150,164,103,243,243,181, 99, 62,  5,243, 87,228,216, 33, 46,
 40,107,198, 36, 62,225,154,239,160,134,220,169,185,222,184,140, 75,251,157,200,
109,211,126, 59, 76,117,214,130,  1, 23, 69,  1,174,171,117,181,166,136,179,177,
245,153,118,210,182,153,166,197,174,245,110,253, 44,136, 41, 57,186,165,214,145,
 13,180, 83,211,164, 22,163,255,198,171,218,187,246, 15,199,175,125, 35, 95,142,
185,235,212,  7,  7, 53,254,190,145,163,164,195, 96,206, 57,231,244,110,127,114,
 27,201,225, 62, 19,202,105,164,221, 64,222,107,175,251, 62,143, 55,112,170, 19,
164,216, 41, 87,137, 80, 30,128,157,168, 81,193, 66, 52, 67, 34, 73, 10, 82,200,
178,  6, 80,132,204,148, 29, 61,226,184, 84, 74, 98, 28, 66, 84, 96,136, 21,136,
  4, 34,129, 72,152,168, 41,111,  7, 14,135, 80, 28, 61,225,160, 41,203,110,126,
 98,162,185,113, 77,124,219, 13, 72, 64,204,124,149, 56, 56, 66, 30, 43, 43,182,
130, 82,194,143,200,  8,155, 33, 64,129,149,128,155,111,176,196,133,197,188,226,
199, 72, 94,  5,225,247,245, 80, 48, 89, 91,215,233,235,145,247,  9,200, 93,196,
204,122,175,138,149,174,147,168,150,155,226, 43,229,100,186,127, 62,184,115, 35,
202,  6, 32,226,175,  2,206,130,107, 24,197, 28,203,113,204,161, 12,236,199, 27,
131,172,186,148,218,178, 28,187, 40, 98, 84,221,147, 40, 90,142,135,185,134,115,
 79, 40, 76, 22,188,125, 12,236,240,145,121,131, 85,  2, 92,  4,248, 67, 40, 46,
141,101, 26,229,130,100, 24, 28,208,144, 70,179,192,141,209, 17,100, 26,164, 96,
 66, 61,169,118,150,232,  2,169, 51,149,248,237,126,229,205, 56, 83,183, 70,133,
 43, 10, 51, 73, 52, 35,147, 38,114,185, 10,205, 85, 79, 16,197,171,151, 64, 17,
 56, 95,211,201,243,180,112,  3,165,245,139,  3,221,168, 77, 49,182, 56, 35,112,
 27,130, 19,160,181,216, 53, 88,200, 65,107,186,160, 18, 40, 42,151, 15, 21,193,
189, 64, 75, 12, 38, 94,166,  0, 12,110,250, 96,140, 29,188,141, 30, 24, 34,109,
212, 87,148,206,232,233,193,171, 12,  1,223,  3, 83,  9,166,100,144, 92,104,115,
208, 68,213, 96,178,186,134,108,216,128,107, 74,188, 71,248, 21,227, 71,  6,105,
184, 52,  1,
} ;

// ../Source/Template/GB_subassign_05d_template.c:
uint8_t GB_JITpackage_139 [1166] = {
 40,181, 47,253, 96, 56, 15, 37, 36,  0, 54, 49,153, 41,176,148,117, 14,100,161,
216,231,123,124,194,197,117,107, 15,192,171,196,169,118,156,102, 12, 33, 19,162,
209, 66, 24,219,129,249,  9,255,148,254, 52,249, 15,118,  1,143,  0,141,  0,140,
  0, 26,118, 97, 50,113,244,181,  1,211,179,236,162, 24,166, 65,220,235,238,150,
  2, 38, 11,193, 65,165, 63,174,138,215, 47, 99, 91,207,230,219,157,167,210,248,
 54,103,179, 10,  6,  7, 68,208,117,200,216,184,181,227,252,121, 88,237, 32,120,
221, 66, 56,176, 28, 84, 24, 12, 44,  7,175, 56,234, 22,182, 33,149,115,130,235,
 36, 95, 14, 73, 54,116,107,187,178,205, 39,214,177,115,105, 60, 86,113,235,108,
 75,219,  4,130, 37,239,216, 94,190,199,254, 68, 62,242,204, 53,211, 65,254,210,
185,130, 34,169, 51,237, 20, 44,244,122, 88,140,171,168,132,233,166,243,130,130,
169, 82, 80, 16, 33,143,103,  3, 66,108, 53, 21,  9, 80,125, 40,  7,203, 54,179,
 66,130,122, 72,195,182,237,154,239,110,189,124,110,143, 91, 92,135, 92, 77,101,
158,242, 91, 13,183, 38,245,  9,237,115, 65, 49, 60, 90,232,154, 20,147,158,108,
171, 58,176, 63, 90,114, 47, 39,195, 34, 40,232,196, 93,237,241,179,240,  8,215,
124,233, 60,166, 93,153,196, 56, 24,251,208,187, 30,186, 25,241,232,150, 62,238,
 93,151, 88, 92,  1,107,  9,164, 31,206,247, 47, 96,131, 96, 29, 43,232,147,201,
 52,157, 96, 94,101,154,176,144,175,189,229,113, 45,103, 65, 76, 71, 77, 39,117,
208,  7, 68, 39,  2,239,216,152, 52,  3,130,245,185,126, 52,134, 34, 15,239,113,
135,221,237, 47, 87,112,116,205, 51, 30,173, 55,186,103, 41, 20,  7,204, 45,207,
 80,149,129,197, 89, 82,189, 36, 29,213, 96,169,235,143,195,175, 40, 74, 42,221,
143,161,119,241, 34, 41,124, 37,121,212, 81,236,172,228,164,148,242, 54, 24, 50,
 71,168, 95,158,101, 21, 20,127,160, 94, 81, 35, 24, 40, 35,100,237,247,137, 68,
 13,162, 56,109,143,  3,159, 60,219, 93,140,166,210, 34, 73,206,156,244, 76,159,
241, 13,185,198, 96,135,100,133, 22,218,232,196,118,101,174, 52,102, 92,103,134,
 81,104,216,  4, 13,211, 73, 21,218, 46, 89,137, 54,222,116, 98, 73,241,214,136,
164, 46,105,152,233, 88,193,202, 97,154,  1,250,112,207,188, 67,138, 27, 31,177,
 30,138,188,  3,230,207,124,138,152,134, 71,251,132, 36,102, 65, 57,211,179,209,
107,118, 46, 13, 68, 77, 68,243,  2,  2, 25,234,222,  7,102, 32, 83,125,200, 48,
 31,231,107, 67,241, 82, 52,160, 88,149,  8,178, 44,171,187,125, 43, 99, 58, 69,
234, 23,136,134,176,206,173,111, 82,159, 52, 98,211,249,192,150, 68,244, 27,190,
235, 92,199, 22,195,183,232, 97,126,117, 47,124,238,174,245,238,240,209, 49,175,
 46,214,133,194,  4,128,236,168,113,189, 66, 51, 34, 50, 34, 41, 40, 72, 82, 24,
 14, 64,132, 24, 83, 69,214, 13,194,216, 48,138,242,156, 34, 76, 17, 34,193,136,
144,  4, 18, 72, 32,161,  4, 18, 69, 73,230, 24,216, 20,136,204,121,220, 50,191,
 56, 69,109,116, 85, 23,224, 19,112,100, 68, 25, 66,141,103, 76, 56,104,190, 72,
178,133,169, 38, 65, 54,101, 30,100, 96,145, 39,209,125,247,132,210, 11, 18,210,
 84, 28,200,116,235,145, 86,140, 64,147,114, 22,109,179, 89, 22,138, 48,214,154,
 96,142,160,193,202,129,104, 78,170, 14, 81,140,227, 46,196, 50,128, 53, 74,134,
233,143,109,248, 85,128,212,241,196,224,  4,141, 23,  3, 63, 44,172,240, 60,185,
 40, 99,248, 68,244, 53,133,126,232, 12, 11, 79,138,177, 97,100,111, 59, 67,223,
137, 68, 61,192,245,135,141, 96,196,101,221,248, 82,140, 46,142, 61, 11, 54, 83,
151, 14,187, 17, 59,195,184, 35,120,224, 93,184,165,146, 68, 39, 34, 70,183,170,
  0,158, 58, 63, 14, 40,221, 99,249, 47,134,245,168, 26,209,232,223, 24,155,155,
124,196,203, 27,168, 76,174,  4,126, 77, 13, 27, 44,140,197, 39, 14, 68, 68,205,
206, 15,150,210, 15, 49,245,171,160,167,115, 80, 96, 11,153, 94, 48, 10,252,173,
  6,151, 48,199, 36,  0, 83, 67, 93,199, 22,196, 43,194, 47, 55, 84, 58, 77,234,
169,137, 42,143, 21, 42, 86, 22, 12,176,204,109,  1,110, 10,216, 85,  8, 11,204,
166,178, 37,167,194,239,160,183,129,222,198,135,137, 65,102,187,102,229, 69,111,
 15, 87, 69,235, 32, 72, 47,236, 70,241,172,229,199,247,129, 21, 36, 88,250,100,
 78, 87,135,201,110,127,192,105, 58,150,150,110, 80,198, 51, 73,151, 12,224, 18,
 91,  5, 62, 58,  5,180, 56,176, 37, 13,127,137,128,141, 22, 89, 54,119,122,232,
117,114,  5, 83,195,213,166,221,133, 64, 57,169, 23,235,127,143,  5, 12,127,162,
 22,  6,129,241,192,220, 45,157, 55,176,218, 88, 49, 33, 79,211, 42,149,228,234,
231,130,191,150,141,221, 52,108,140,220,101,116,126, 29,229, 55,196,114, 91,216,
255, 99, 26,  8,236,212, 71,250,109, 78, 15,135,140, 84,244,166,193,139, 22, 25,
  8, 18,148, 85, 33,121,116, 19,143,  8,242,193,126,200, 47,204,186,190, 80,122,
193,113,  6,181, 41,156, 89,128,230,251,244,209,246, 38,106, 83,241,245,166, 16,
 86, 93, 62,102, 58,184,128,153, 91, 12,160, 65,211,255,153, 41,207,120,133,209,
 23,181,149, 58,128, 19,
} ;

// ../Source/Template/GB_subassign_06d_template.c:
uint8_t GB_JITpackage_140 [2482] = {
 40,181, 47,253, 96, 36, 80, 69, 77,  0, 26, 74,220, 13, 40,176, 86,117, 14, 84,
114, 79, 19,104,134,208,160,171, 26,251, 89, 97, 43, 12,243,105,120,183, 22,226,
 76, 23, 78,137,212,133,129,227,  7,253,  7,189,159, 18, 92,215,  0,214,  0,201,
  0,191,231,133,156,148, 30,201,201,176,136,  9,194,166,  5, 82, 82,174,161,137,
235,180, 50, 11,227,147,129,166,  5, 72,114,178, 22,222,140, 41,103,115, 93,124,
 46,139,153, 97, 21, 92, 13,192, 57,  4,109,125,119,249,185, 69,159, 78,166, 41,
  5,243, 42, 79,133,133,108,235,163,200, 86,173,122,120,142,122, 74,234,158,142,
103, 90,124, 46,141,255, 39,211,199,219,214,128,105,179,145,243,186, 62, 18,231,
122,179, 97,192,100, 64,128, 96,233, 78,163,160,252,229,118,229,106,182,189, 97,
150,198,182,181,186,177,108,104, 60,  4, 91,143,220,198,253, 57,206,157,168,126,
238,121,242, 49,  1,193,  0,193,194,112, 96,128,240, 74,163, 30,113, 29,161,154,
 19,200,151,186,252,145,106,246,  8,146,155,136, 14,164,119,226,210,248, 82, 16,
212,185,134,160, 73, 62,243,  7,233, 96,253,210,153,122, 32,169,243,220, 22, 12,
166, 21, 85,140,105, 40,196, 51, 98,226,  5,  5,147,165,160, 32,119,224, 19, 23,
152,230,226,242, 88,116,166,230,218, 68,112, 48, 36,117,208,133, 69,112, 58, 29,
  0,242,155,149,242,216,240, 40,169, 91,124, 58, 26,115,  3,251,100,146, 51, 47,
 11,219,128, 82,  6,222, 64,253,242,131, 67,188, 58,120,134, 42,161,164,249, 24,
169, 47,255,179,211, 79,184,219,162, 75,189,211,227,173,219,254,219,215,229, 38,
 97,  6,142,144,160,245,136,173,252,153,143,238, 71,242,246, 66,225,183,225,141,
246,237, 34, 30, 97,154,237,148, 55,177,148,186,102,115, 81, 92, 76,215, 71,110,
172, 75, 51,178, 97,167,125,179,120, 52, 20,233,127,242,253,139,215,158, 71, 47,
245, 84, 22, 10, 10,245,236,115,129, 64,146,171,155,197, 60, 88, 26, 44,229, 60,
 31, 44,159,148,152, 87, 22,245,140,247,125,161,103,108, 63,173,177,215,127,172,
 74,228,171,129, 95, 30,142,108, 82, 20,245, 12, 36,173,170, 77, 42,166, 81,130,
177, 68, 82, 27,157,111,179,193,144,  8, 22, 60, 72,250, 78, 73, 34,122, 65,155,
109,227,190,224,113, 87,207,163,191,120,244,134, 24,139,253,108,135,110,169,118,
249,190,221,145, 60, 86, 90,238, 71, 11,206,242,123,171, 35,117,251,229,210, 55,
204,161,133,193, 54, 26, 60,198,249,229, 25, 82,233,228,240,116, 38, 16,  3,143,
 74,251,228,185,239, 29,122,116,228,211,168, 91,150,101, 89, 37, 85,  9,192,  5,
  4,222, 84, 83,  7,109,100,  6, 65,149, 97, 21,241,126, 89,163,220, 99,219, 22,
 81,247,218,222, 30,189,180,117,174, 37,239,214,173, 20,250,214, 56,180, 95, 99,
170, 29,215, 46,251,  9, 42,210,253,184,127,182,116,179,237,183, 39,162, 47,121,
 61, 82,179,214, 28,215,191,223,111,109,235, 98,  2,155,150,102, 89, 27, 15,  7,
203,141,111,187, 67,199,180,139, 29,222, 72,194,182,226,219,246, 70,104, 40,212,
 80,107,215,129,160,124,214,234,205,184,  3, 83, 24,240,204,100,107,135, 68,159,
151,146, 34,155,163,190,117,232, 25,135,164,148,171,  3,251,116, 50,235,202,144,
 82, 86, 75, 74, 25, 43, 22,134,230,250, 76, 13,  7,  3, 77,201,153,144, 31,143,
149, 25,120,200, 51,150,  5, 30, 84, 98,  5,122, 98,140,210, 51,179,107,226,177,
147,212,229,164,  8,233,145,119,121,244, 88,133, 56, 96, 62,170, 46,241, 66, 97,
 14,226,145,201,244,179,199,253,109,249, 15,231,170,195, 65,212, 42,137,218,210,
118,132, 15,128, 21,234, 97,254,140,156, 25,223,202,141,168,117, 76,  5, 41,174,
 23,185,157,152, 11, 77,185,193,245,241,126,143,248, 54, 88,234, 14,158,169,132,
 50,167,126,209,193, 50, 44,251, 72,207,140, 49,223, 41, 29, 46, 21,202,126,247,
 91,205,143,211,193, 99, 40, 55, 38, 53,105, 74,145,143,224, 99,137,  5,  2,254,
164, 82,113, 56,120,204, 13,168,154,105,198, 84,123,225,214,157,134,169, 73, 10,
  3,130,148,168,162,172, 20,161,153, 17, 25, 73,146, 82,161, 49,114, 24,  4, 34,
 81, 26, 72,121,180,119, 30,146,160, 40, 15, 66, 24, 66, 65, 40, 66, 12, 33,196,
 16, 66,140,192,145,  9, 39,144, 64, 68, 68, 36,184, 77, 58,133,129, 65,123,218,
  2,106,135, 86,180,202, 86,174,243,116,154,144,217, 44,188, 87, 85,161,186,135,
 58,179,255,247, 11,241,248,105,239, 60, 34,235,172,136,130, 31,212, 45, 38, 87,
 55,144,158,208, 22,201,171,167, 16,  7,102,234,239, 50,  9,250,  3, 74,104,132,
 84,162,212, 90,253,244,207, 97,  8,208, 66, 15,144,151, 21, 84, 56, 37,124,163,
227,171,105,165, 49,106, 33, 66, 67, 89, 63, 83,166, 56, 45,238,173,130, 30,220,
 94,133,104,140, 61,104,186,152,171,189, 51, 24, 18,231,180,219, 49,101,173,188,
231,241, 35, 22,254,212,149,221,188,209,125,143, 45,129,153,177, 32,185, 20,200,
209,  6, 48,219, 93,123, 53,126,  3, 31,205,249,162,236,238,118, 44,156, 60, 55,
123,179, 61,142, 38, 49, 80, 23, 53,194,221, 78, 84,215,105,124,226,245,253, 46,
 65,190,248,145, 39,137, 46, 67, 99,142,235,254,234,235,107,125,177, 99,241,237,
 86,243,147,134,228,182,161,210, 18,134,143,253,112,212,  0, 27,189,  0, 30,251,
223, 69,253, 35,214,184,178,  6, 88, 67,  0,151,109, 10, 73,128, 87, 29,  0, 64,
157,255,199,225,207, 23,232,135, 11,126,147,194,190, 38,160, 47,143,157,128,192,
255,  1,247,195,192,  0, 75, 65,  0, 23,245,191,  9,180,  9,246, 35, 63, 30, 13,
176,140, 89,115,187, 31, 87,188,241,252,187,114,108,206,199,242,232,114,108,188,
 40,248, 45,241,157,224,177,249,163,  5,223,248, 19, 20,191, 39,170,122, 44,253,
118,108,210, 26, 11,  3,164,217, 98,254, 76,210,238,175,183,170,106, 33, 21, 30,
  6,  9,106,177,  4, 15,114, 98, 18, 14, 44,165,141, 78, 15,119,187,248,101, 98,
 61,138,183,196, 11,158,222, 54,134,139,227,148, 44, 19,107,158,105,183, 23,173,
 78, 33, 83,220,192, 74,189,140,128,140,147, 23,255,247, 66,172, 81,113, 93,103,
 53,247,224,  7, 80, 63,  5,199,135, 28, 42,150,129,251, 62, 44,101,114,117, 18,
182,131, 20, 49,133, 53,152,112,163, 63,109,169,236, 85,  2, 12,106,179,141, 97,
 29,131, 68,183, 71,253,174, 56,148, 56, 35, 15,147, 24,155,133,227,139,247,254,
  7,174, 70,144,  5,169, 16, 57, 50,229, 32, 92,161, 72,149,121,167,102, 98, 15,
115, 95, 36,212,209, 53, 35,195,126,100,171, 79,250,215,199,235,  3,112,173,147,
104,212,151, 70, 94,250,190,111,137,200, 29,194,234, 62, 35,199, 77, 96,172, 28,
236, 54,167, 13, 41, 93, 81, 89,146, 96,254, 39, 17,184, 39,177,  2, 50, 47,133,
 39,218, 24,194, 28,135,212,220,188,146,120, 71, 25,130, 92, 92,104, 23,131,186,
163,225,216, 19,221, 34, 51,166,188,235, 10,223,145,155,215, 32,186, 12, 99, 81,
254,185,152, 46,193,137, 10,198,171, 37,144, 89,238,237, 97,174,228, 21,  9,160,
179, 28,124, 62,182,148,238,183, 39,148,  3,125, 44,102,103, 44,128,131,157, 55,
170,141,210,190,221, 23,139,214,230,200,103, 79,253, 23,121,129,202,104, 93, 67,
115, 18,206,165, 52, 94,147, 11,207,242,207,153, 61,101,230, 89,231,200, 65, 70,
142,203,136, 80,164,198, 92,111,  2, 91,182,108,199,112, 40, 27,254,  0,207,123,
 83,150,156,238,198,229, 83, 89, 48,214,207, 14,186, 41,247, 34,165, 65, 67,202,
178, 51,121,243,197, 22,246, 89,246, 55,216, 11,196,141,126, 97,126, 82, 14,188,
 31, 20,175, 43,246,194, 49, 18,147,120, 23,180, 95,140, 19,186, 24,154,230,177,
164,116, 93,137, 76,139,201,244, 94,254,255,152,253,204,221,104, 60,253,161,113,
157,252,188,219,116, 52, 73,203, 45, 99,206,241,190, 16,248,109, 14,112,209,223,
 14,216,245,197, 99,133, 90, 72,111, 67,199,160,180,191,249,246, 66, 31, 74, 58,
207,199,176,210, 77, 88,212,148,148,116, 24,234, 17,  0,227,173,  2, 83,231, 80,
  0,139,134,140,250, 56, 25,233,116, 20, 37,198,232, 15, 50, 92, 26,176, 15,139,
169,209,233, 51,157,234,221, 68,158, 40,112,148, 75,152,226,209,190,145,201,148,
188,106,116,239,247,116,  3,147, 47,122, 47,200, 90,118,189,163,173,220, 50,128,
193,179,178, 11,140,184, 22, 83, 51,  2, 58,216,166, 19,238,211, 21,252, 90,209,
 82, 10,  0, 74,224,120,192,  0,170,215,231,  2, 95,200,201, 50, 87,185, 58, 49,
  5,233,246, 98, 21,233,181, 64,255,135,164,234,205, 15, 65, 90,134,247, 95,168,
182,161, 92,177,200,130,195, 11,141,124,117,229, 10,101,158,246,104, 85,181, 30,
165,243,218,239, 17, 64,121, 49,156,155,225,130, 97,113,231,157,  8, 64,169, 49,
 31,207,  8, 83,172, 44,212, 58,135, 57,234,230,197,158,146,107,238,104, 99, 49,
142, 41, 80,152,245,181,  4,182,104, 76, 58,101,219,175,128, 35, 99, 98,117,161,
 40,172,205,175,  7,149,204,169, 96,151, 72,104,246,220,248, 34,134,208,159,236,
 10, 91,127,184, 66,116,145,218,124,144,147, 46,130,169,139, 35,231,167,202,242,
 60,  3,  0, 11,183,127, 44, 25, 82,248,223, 50,126,155,  0,227,141, 73,180,129,
 47, 58,165,250,148,151, 72,220,140,  9, 19, 86, 64,219, 77,193, 48,  7, 82,115,
 27, 12, 27,143,110,149,213, 98,192, 17,157, 87,223,112,178,196, 51, 63,194,193,
170, 40,190, 68,113,140, 57,229,205,222,159,157,  0,180, 32,243,188, 64, 73, 62,
 38,168, 53, 81,104,148, 34, 16, 32, 49, 60,138, 60,206,255,136,217,162, 91,210,
188, 97,108,115, 74, 16, 20,  6, 83, 95,184,135, 25,218, 19,201, 33,222,255,140,
 19,168,166,221,127, 92,174,  8, 32,224,184,117,154,116, 65,180, 10,214,136,169,
102, 59,173, 15,144, 50, 33,118, 89,103,153,207,  4,233,128,191,146,124,234, 51,
136,164, 76, 32,124,159,  5, 21, 10,  0,103, 99,211,198,183, 10, 90,224, 99,  7,
 81,198, 37,204,112,108, 30, 63,116, 52,  8, 95,185, 62,130,211, 32, 47,176,251,
121,142,254,254,108,250,202,100, 91, 99, 68,211, 86, 10, 83, 36, 88,120,  3,138,
203, 41, 54,131,119, 41,149,159,206,  5, 40,114,170,160,113,133,246, 80,237,  1,
 56,231,241,161,139,137, 51,243,115,154, 42,218,202, 87,218, 71,108, 61, 13,205,
165,219,134,127,197,143,114,215, 95,232, 65, 76,188,170, 19,101,202, 40,106,171,
 45,194,240,119,230,160, 85, 24,235,236,208,239,255, 93,  4,168, 54,146,200, 37,
 42,  1, 15,205, 23,128,192,255,145, 55, 68,228, 70, 57,204,174,187, 37,187,234,
152, 61, 19, 33,168,  4, 13,236,112,106, 63,160, 47,126,220, 38,187,172, 29, 53,
 37, 93, 28, 20, 72, 31, 19,128,159, 91,128, 11, 49,100,  0, 12, 65, 51, 38,241,
115, 31,151,201,  8,199,211,188,245,160, 23,153,227,112, 61,217, 61,102, 87, 94,
 81, 59,160,184,132,195,255,145,234, 21,113,225,253, 81, 86, 22, 24,201, 42,156,
  9, 21, 94, 72,241, 23,  1,176, 52, 40,192, 55, 90, 73,100, 96, 42,107,232,213,
 89, 10,101,246, 37,217,173,231, 42, 66,127,217,227,122,170, 76, 98,176,217, 78,
 75,170,193, 45, 81, 55, 26, 52,133,  7,102, 90,242, 40, 23,248,206, 79, 83,206,
 84, 18,
} ;

// ../Source/Template/GB_subassign_22_template.c:
uint8_t GB_JITpackage_141 [578] = {
 40,181, 47,253, 96,145,  5,197, 17,  0,102, 30, 94, 32,240, 24, 61,208,133,145,
136, 47,145,124, 48, 47,150, 42, 43, 50,238,192,245,239, 45, 28, 36,253,232,202,
  5,158,129, 52,135,191, 85,  0, 84,  0, 82,  0,135, 77, 99, 32, 14,155, 11, 40,
230,153,174,167, 57,241,  2,231, 42,112,139, 97,229,120,214,113, 23,  9,136,103,
174, 52, 94,231,137,187,223,117,236,174, 60,237,164,218,167,202,191, 59,221,218,
145,228,186,186,244,207, 15,162, 92,229, 16,130, 75,111,252,158, 22,135,191,189,
109,243,110,169,106, 61, 71,163,246, 36, 21, 55, 24, 46,205, 96,  8,250, 51, 14,
 71, 74,231,211,105,241,103, 79,126,159,197, 91,170,222,216,116,204, 91,191,182,
147,132, 67,145,122, 38, 61, 47,151, 78,198, 27, 95,182,109,254,137,224,126,204,
117, 40,108,218,131,116, 98,206, 27,249, 43,169,238,251,159, 69,123,125,159,214,
139,246,153,104, 10,223,159,242,235,223,184,222, 96,169,110,220, 90,206,179,196,
 22,155,214,188,245,231,129, 83, 52, 32,142,244,253,165,212, 12,189,204,116, 71,
144,122,118,125,235, 43, 82,137, 93,136,251,246, 20,139,125,171,187,195,  5,171,
 75, 49,239, 46,156, 39,227,201,215,163,139,219,245, 55, 63,131,219, 73,162,231,
 31,133,227,245,  7,183,255,173, 97,254,253,159, 95, 23,235,186, 10, 87,188,157,
115,251,126,215,213,186, 90,153,196,158,165, 36,230, 81, 56,220,165,131,233, 72,
201,153,178,136, 18, 73, 28,242,148,179,  8,132,135,195, 15, 14,113,137, 49,  1,
173,123,110,141,189, 29,191,  7,169,118,193,197,188, 44,146,220,190,181, 51, 79,
236, 56, 20,125,134,165,153,113, 64, 98, 81, 87,  0,230,156, 13,165,235,184, 84,
 68,147, 46,192, 28,226, 41,233,  1, 73, 32, 32,132, 16,197, 84,157,  7,222, 32,
224,117,112,246,203, 14,140, 12,111, 35, 15, 18,149,128,  8,252,197,230, 13,186,
 23,147,104,215,211, 78,162,129, 35,175,192,186, 54,129, 46, 56,199, 26,  0,118,
 61, 67,154, 77,200,152,  2,155,120,224,183,113,112, 77, 56,144,125, 78,227,  4,
  7, 69,185,108, 26, 44, 97,152,212,162, 52,161,136, 37,135,197, 19,110,196, 50,
164,103,208, 98, 98,164,105,111, 27, 12,  5,144,  1, 99, 13,154, 18,196, 27, 39,
152,156, 89, 21, 43,252,  5, 70, 79,197,133, 68,  2,130,232,181, 54, 16,129,225,
 25,132,222, 14,141, 35,117,138,160, 33, 95,183,  6,  4,161,227,239, 88,133,154,
170,  7, 28, 17,195,205,120, 35,244, 68,230,224,184,204, 57,231,108,173, 50,156,
 77,179,243,204,132,182, 77, 87,235,154,226,209,152, 43, 84, 20, 12,  1,
} ;

// ../Source/Template/GB_subassign_23_template.c:
uint8_t GB_JITpackage_142 [1589] = {
 40,181, 47,253, 96, 52, 27, 93, 49,  0,166,184,172, 41,176,148,177, 14,180, 64,
128,155,185,229,142,112, 94,128, 59, 82, 73, 16,216,154, 94, 73,180,  8, 34, 37,
222,203, 16,232,157, 37, 74,127,208,127,176,191,177, 43,  1,163,  0,161,  0,161,
  0,148,195, 50,164, 37,164, 14,250,128,100, 69,232,202,248, 95, 66,241,120, 87,
 42, 64,233,116,160,188,174, 80,196,181,206,234, 23,176,225,175,126,  1,239,236,
227,176, 74,  5, 40,151,  2,140,165, 55,108, 94,248,  6,175,169, 70,115,237,140,
 99,105, 92, 27,163, 29,139,198,  6, 84,144,181,201,107,220,161,227,188,129,208,
208, 57, 14,222, 66,192, 92, 48,150,133,131, 11,230, 21, 70,221,194,212, 52, 55,
 47,128, 63,109,217,118,116,116, 75,  4, 59, 16,219,157,158, 68, 67, 99,111, 94,
 81,103,250,137, 40, 28,247,105,199,244,241,237,245, 38,114,120, 77,229,241, 13,
157, 39,119,187,206, 18,  1, 35, 43,  8,197,120,146, 62, 44, 33, 36,110, 96, 64,
177, 24, 24,  4,109,178,239,252,221,206, 98,183,249,157,177, 19,139,107, 52, 31,
133, 46,145, 40,243,203,200,236,100,253, 54,236, 22,229, 89,248,236, 37,149,137,
  9,117, 13,107, 83,173,104, 30,226, 89,145, 55, 71,250,108,150,113,189, 73,146,
 90, 79, 82, 39,245, 77,231,154,176,192,217,108,111,179,112,  8,158,185, 74,248,
 43,  4, 59,241,218,140, 80, 47,207,238,240,189,229,183, 70,179,154,121,176, 64,
155,113,181,152,134,179,150,212,152,235,143,237, 92, 68,252, 32,232, 25,113, 32,
164,136, 35,225,157, 93,166, 36,137,169,132,157,203, 34,116, 85,200, 17,135, 66,
163,  2, 56,127,183,210,231,  6, 57,165,132, 66, 57,201,188,202, 50, 65, 33, 87,
122, 11,164, 82, 44, 29,  8,207,  5,  5,214,222,222,252,150, 45,233,214,141,212,
175, 17,236, 92,120, 46, 98,220, 50,173,124,164,191, 74,115,245,113, 59,  0, 42,
 21,135,223, 75, 85, 24,205, 51, 99,170,185, 47,235, 13,195,175, 40,217,125,245,
158,213,206, 53,199, 77,111,222,223,206,126,118, 32,211,187,  2,151, 68,202,146,
161,246,231,229, 91,151, 91,150,180, 89,150,232,148, 27,160, 79,252,184,116, 84,
167,141, 60,177,190,167, 12,175,217,247,199, 77,211,109,117,162,190, 17, 49,172,
170, 98,140, 49,142, 84,212, 53, 31,129,207, 24,245, 50,110,143,224, 23,104, 99,
 20,  1, 34,192, 45, 12,194, 45, 72,189, 34,244,201,144, 26,156,208,  8,122,228,
 21, 57, 29, 17,188, 23,148, 19, 10,127,114,  2,255, 67,250,202,227,189, 69,115,
234,144,249, 53,135,247,226,224,132, 62,163,120, 97,200,141,135, 35,146,208, 35,
  1, 67,160, 99,122,128, 15, 12, 16,188, 20,171, 82,180,249, 56, 87,106,239,227,
197, 42, 11, 69, 93,243,198,181,179,210,188,101, 89,214, 45,121,234, 64,114,116,
 73, 28, 84,222,214,  5, 73,120,111,109,144, 58,148, 19, 37, 10,166, 91,142,149,
102,159,179, 74,181, 59,100, 94, 53, 88, 13, 84,230, 31, 29,243,121,218,122,220,
 54,171, 15,215, 40,197,225,192,194,104, 55,235, 41,203,232,189, 91,153, 92,  6,
202,140, 61,170,133,100,205,145,186,175, 20,177,218,156,105, 82,186,109,247,126,
228,230, 10,129,133,168,113,185, 82,102, 68, 68, 68, 36, 41, 72, 65, 50, 28, 97,
 12, 98, 20,148, 16,106,230,  1,146,120, 80, 20,  5, 41,144,193,  4, 17, 68, 24,
145, 64, 68, 68, 66, 17, 17,145,160,156, 77,  7,176, 64, 48,165,157, 92,226, 77,
180,100,153,206,226,137,220,161, 42,211, 77, 20,222, 88,215, 64,168,211, 17, 14,
217,255, 73,127,224,232,164,  2,222,156, 68,198,183,174,253,242,230, 26,189,131,
218, 31,237,105,228,  0,151,199,224,107, 27,229,203,213, 35,121,132,160, 69,113,
 17,178,160, 41,138,153,185, 26,251,115, 91,194, 85,159,125, 43,124,204,183, 90,
 17,251,125,100, 58, 42,  4,156, 72, 33, 38,151, 29,109, 46,  1, 40,  0,124,157,
 65, 99,125,150,140,254, 17,164, 62,144,211, 48,229,248, 87, 49, 42, 80,124,107,
191,248, 56,213,232, 18,160,247,216, 16,204, 48,  0,237, 71,160,255, 77,104,144,
164,153,143, 31,182,124, 64, 37,121,161,106,140, 69,206,  2,162, 32, 16,143, 62,
120, 25,  6,206, 26, 75, 78,131, 36,255,133,  6,153,175,188,239,191,203,146,246,
189,252,174,  0, 60, 67,  4, 27,181, 33,156,231,255, 45, 44,157,115,  5,247,176,
136,124,140, 30,115, 97,135, 79,177,102,163, 86,106,226, 71,116,116,157,145,225,
190,148,113,  2,138,143,190,178,153,141, 16,130, 56,240,124, 18,154, 24,180,163,
221, 42,  0,175,120, 20, 38,160, 97, 13,129,202, 91,141, 39, 20, 67,138, 70,245,
126,169,186,234,152, 33,133, 44, 79, 41, 49,219,160,225,  0, 55,243, 64,165, 33,
 50,130, 63, 36, 26,  2,193,196,139, 98,144,171, 48,208, 10,140,191,  0,148,192,
193,102, 63,112,179, 11, 96,223,218,100,254, 79,196,146, 95,219,152,237,213,208,
 72, 45,247,  0, 29,204, 90, 36,172, 36,177,  5, 42, 18,194,229, 14,209,  7, 18,
152,225,104,184, 31, 24, 88,177, 35,149,242, 81, 49,142, 37, 92,145,197, 97,196,
203,113, 47,145,195, 13,226, 11,100, 51,188,119,244, 99,153, 68,138,185,153, 16,
  3,  0,201, 53,103,120,144,246,170,193,  1, 80, 64,203,129,  0,237, 10, 22,169,
189, 64,197, 20,159,165,156,129, 57, 45,121,224, 68, 92,110,182,  2, 60, 10,102,
128, 23,195, 38, 65,127, 69,168,237, 99, 56, 78,158,156,143,187, 86,121, 92, 96,
 77,126, 73,114,148,183,100,160,148,193,102, 67,  0,213, 62,166,148,214,193,217,
233,143,139, 61,218,234,147, 56, 20,253, 12,132,  3, 88,205,204,235,228,130,237,
130,  9,103,165,  2,222,213,233,  5,154,161, 66,104,202,181, 42,131,190, 16, 21,
123, 64, 26, 96, 40,155, 64,178,195,139,103, 51, 27,105,111, 97, 97,190, 62,141,
153,248,136,216, 29,138, 76,163, 53, 65,214, 21, 72, 48,237,238,179,236,  9,100,
 25,105, 71,168, 74, 86,  1, 50,133,121, 73, 67,175,116, 93, 77,250, 85,196,151,
144,151, 18, 76, 85,103, 22, 21,239, 68, 94,143, 44,130, 89,  6,  7,110,218,154,
102,189,208,165,228,189,253, 59, 12,233,252, 20,210,  5,147,209,133,121,167, 95,
237,173,187, 56,213,243, 80,232,170, 55,152, 91,109,147,238, 68,194,130,176, 46,
142,184, 98,238, 33,131,254,217,184, 14,122, 39, 53,125,248, 63, 50, 94,163,210,
 35,243,  2,  0,  1, 39, 24, 99,210,105,157, 37,250,104, 16, 50, 73, 40,195, 20,
 89,253, 84,129,122,220, 84,157, 35, 17, 28,245, 83,212,118,158,214,122,197, 89,
206,245, 75,119,225,193,159,188, 85,105,160, 75,120,212,239,188, 85,150,204, 31,
245,182,119,246,160,103, 87, 20,150, 29, 22,198,168,175,200, 85,149, 90,119,238,
187, 56, 29,198,238, 17,159,232, 39,140,112, 44,150,122,196, 38,222,240,126, 17,
213, 91, 26, 13,190, 29,228,  1, 62,109,221,117,119,147,142, 66, 12,166,173,129,
227, 67,115,155,204, 41,178,170,204, 39, 15,101,173,139,137, 45, 56, 88,187,  2,
 22,222,196, 66,  1,205, 10, 27,175,174, 46,210,191,223,209,155, 99,125, 67,211,
206, 25, 47, 55,130,195,174,253,  8,137, 77,174,197, 41, 26, 52,159,159,153,154,
137,116,184, 28, 81,165,138,182,198,
} ;

// ../Source/Template/GB_subassign_25_template.c:
uint8_t GB_JITpackage_143 [1745] = {
 40,181, 47,253, 96,136, 29, 61, 54,  0,198,190,188, 41,176,148,177, 14,180,128,
192,141, 72,117, 36, 16, 19,131,205,214, 96,  4,104,153,188,130,232, 17,196,244,
 12, 38,227,151,160,191,  8,255,148,254, 52,189, 59, 46,  1,174,  0,182,  0,175,
  0,213,235,123,226,238, 52,101, 58,186,103, 15, 97,215,125,164, 99,176,211,181,
218,179, 54, 71,250,117,146,236,171,215, 57,207,219,156,232,199,192,110,122, 95,
214, 62, 15,211, 99,135,243, 56,123, 51, 99, 74,  6, 83,112,105, 78,155, 55, 94,
227, 53, 37,209, 92,123,187, 46, 26,245, 92, 48, 58, 32,204,214, 33, 94,227,206,
142, 51,231, 65,179,119, 93, 60, 52, 40,200, 20, 92, 20,  8, 50,  5,175,104,212,
 33,166, 33,179,115, 76,252,137,203,214, 68, 69,135,161,232,113,224,238,244, 32,
 52,141,189,121, 67,157,233, 23,162, 52,174,189,197,111,117,254,148,143,233,171,
183,215,156,200,227, 57,111,192, 24,170,107, 58,207,238,154, 58, 75,132,  2, 89,
 61, 40,198,115,244, 97,233,  0,241,129,  1,202,101, 96, 32, 19,217,231, 66, 98,
 92,153, 40, 98,210,170, 46, 79,168,178,117,205, 73,146, 90, 59, 30, 43,130, 66,
 98,184,132, 39,196,219,108,143,203, 85, 98,183,178,232,169,172, 78,169,126,156,
246,173, 73, 40,190,116,243,  3,233, 91,236,125, 77,215, 93, 55,189,  9, 50, 49,
241,120, 42, 30,168,139, 50, 43, 20,138, 36,186,213, 77,195,197, 70,234,156,206,
218,209, 27,119,253,177,160,136,137, 46,  7, 25,186,100,148,152,202,232,177, 40,
 50,107, 66,138, 46,  9, 18, 13,192,249,187,149, 62,183,199, 41, 37, 20,202,201,
230,149, 44, 15, 18,114,165,135, 30,149,106,180,195,178,212, 18,163, 14,250,128,
228, 68,102, 93,252, 47,161,112,188, 43, 13,160,120, 60, 81, 90, 86,246,112, 82,
111,245, 11,160, 80,240,108,211,196,111, 46,159,203, 84,228, 91,  7,175, 80,210,
244,213,123,150,244,251,107,178,159, 38,143,233,221,128,141,230,111,158, 57,167,
 86,157,103,123,218,123,244, 58,181,227,166, 35,147, 37, 57,129,153, 67, 40,109,
150, 31,116,202, 12,208,199,234,124, 42,217,137,152,231,134,253, 60,185,252, 74,
 43,139, 15,237,245, 99,182,198,223,189,246,168,182,187,173,199,148, 19,117,100,
 54, 42,154,205,207,120,106,125, 79, 57,246,215,205,144, 18, 25,169,147, 74,158,
 21,209,168, 87, 85, 85,141, 84,168, 17, 17,  0,  5,196, 37, 57, 85,156,163, 81,
252, 66,237, 46,  4,163,148,227, 46,231, 23,155,248,200,142,229,113,192, 42, 36,
 50, 11,148, 17, 17,202, 34, 40, 84,157,115, 90, 61,107,212,203,184, 61,129, 87,
135, 90,135,212,134, 11,118,203, 15, 23, 14,  3,148, 47,128, 94,150,198,149,125,
 68,149,101, 33, 59,216, 21,146, 17,131,136, 25,200,155,125,239,124,215, 81,145,
122,139, 57, 22, 74, 29,116,121, 30, 42,139,229,243,184, 77, 86,235,209,201, 33,
188, 35, 21,245,170, 82, 74,189, 99, 68,111,121,196,238,198, 41,195,230,231, 28,
187,  2,255, 56,167,181, 74,241,179,205,199,185, 82,123, 31,239, 49, 31,  4, 22,
 88,185, 32,  8,183,218,135, 18,187,212, 35, 72,138, 44,136,210, 33,135, 81,199,
100,196, 71,254,105,244,106,189,190,214,230, 87,242, 86, 41,233, 12,155, 87, 52,
 80, 67,201,205, 59, 54, 48,201,121,158,109,183, 87, 60,187,210, 27,158,177, 71,
 73, 37,139,133,129,170,104, 44, 84,181, 52,107, 94,133,  0,106,212, 52,235,105,
163,186,251,182,230, 52, 28,129,174,168,225, 45,154, 33, 17, 17, 73, 74,146, 66,
 97, 56, 65,  8,194, 80, 32,118, 82, 50, 31,146,144, 56,151, 65, 12,163, 40, 68,
136, 33,142, 24, 19,136,136, 72, 32,209,196, 72, 36, 19,206,  3,133,177, 98,222,
210,233, 61, 38, 34,173, 70, 86,220,154,146,130, 11,245,161,173,198,158,  6,199,
 40, 78,250,225, 11,253, 21,196,107,136,  0, 83,114,144,112, 84, 54,143,202,141,
198,116, 40,107,164,150, 13,228,208, 10,104, 69,249, 39,194,226,206,235,199,134,
114,163, 23,251,108, 63,249, 36,121,247,188,253,234,153, 89,195,  8, 40,152,  7,
 79,  1, 22, 20,248,185,154,247,142,219, 95,240,105,215,142,143,250,238, 15,251,
199,161,215,207,108,179, 79,114,150,154,119, 15, 78, 65, 77,  7,129, 43,232,157,
  0,124,106,171, 10,237,207, 14,  9,160,180,205,167,144,255, 39,  4, 52, 65, 89,
190, 58,198, 89, 51,222,110,207, 42, 15, 45,234,201, 35,160, 28,140,129, 89, 16,
 88,205,162,190, 64, 35,212, 78,183,224,139, 64, 72, 85,181, 86, 61, 16,154,240,
 21, 28,139, 67, 95,217,  4,186,226, 41, 30,252, 39,167,190,190,251,216, 40,  1,
 75,155, 42, 41,147,  9, 65, 81,236, 61,177, 17,203, 24,239,193,  1, 60, 77, 37,
 64,164,  2, 25, 22,140, 24,118,194,  2,127, 12,176,175,143,217,  2, 99, 92, 72,
171, 96,105, 28,104, 24, 46,243, 61,217, 50,186,189,145,220, 49, 57, 98,100,226,
120, 95,197,162, 35, 58, 54, 35,111,161,227,240, 29, 37, 55,107,141,148,162, 36,
236,240,121, 94,137,233, 63,117,251,169, 50,191,167,135,125, 72,221, 95,  3, 32,
197,213,231,113, 12,238,220, 24, 89,210,165,214,220,153,157,235,109, 32, 47,170,
 59,166, 27, 85, 37,104,237,226, 35,118, 48, 49,232, 81, 44,240,186, 41,162,165,
 34,177,208,247, 50, 62, 59,137,211, 98, 49,238,178,207, 47,153, 31,249,138,247,
123, 76,208, 23, 67,190,203,216, 54, 73,109, 11,142,164, 29,234,247, 49,254,195,
 34,169,103,  1, 93,188, 15,152, 23,197,132,196, 93, 97,192, 54, 50,127,202,238,
 93, 37,239, 25,139,194,217,185,207,190, 64,176, 21, 27, 11, 76,173, 34,  2,189,
 72, 98,211, 44, 86,114,173,101, 40,234,101,234,139, 69, 60,252,133,132, 26,241,
 51, 66,160,147,175,145, 32, 86,152, 59,199,102,182,139,174, 13, 30,110,190, 19,
174,218, 72, 74, 87,163,242,147, 26,119,181,102,164,146,103,126,  0,125, 95, 89,
250,125,140, 79,198,246,193, 33, 23,244, 98,  4,190,250,238,149,198,111,158,131,
 72, 16, 35,227, 31,  4, 74,115,149, 42,134,127,225,214, 13,104,243,129, 51, 99,
159,  8,181,151,181,243, 49, 28,170, 62,171,182, 64,209,242, 80, 30, 38, 75,  3,
 68, 94,140,129,187, 26,128, 61, 99,223,137,  2, 32, 93,180,113, 88, 71,111,164,
  9, 33,  9,152, 33, 23, 27,228, 92, 13, 45,128,237,171,247,  5,170,186,102, 62,
159,175,217,157,164, 45, 86, 95, 62,210, 50,141,247,146, 97,  1,154, 93,188, 23,
148,171,233,208,139,101,208,107,163,122, 21,197, 92,127, 97,111,185, 48,186, 29,
203,101,178,229,121,  4,137, 46, 27,219, 89, 95,130,181, 53,246,229, 21, 98, 53,
 28, 27,134,199, 46,122,252, 78,195,230, 68, 79,129,185,101,180,155,228,199, 94,
140,196,167,150,233, 59,229,250, 55,  2,249, 18, 27,161,138,  0,116,239, 83,130,
 36, 28,236, 91,199, 82,251,251, 82, 36,241,195,129,186,250,111, 85, 39,169, 16,
166, 75, 50, 20,182, 89,210,157, 11, 97,208,188,136,196, 68, 40,159,120, 69, 41,
185,115,101, 74,177, 86,162, 43,105, 17, 60, 28,122,194,119, 50, 69,109,165,195,
169, 50,230, 95,152, 13,145,227, 79,143, 45,232, 42, 48,133,226, 23, 19,100, 59,
 81, 66, 94,146,236, 98,125,  4,174,  7, 90, 32,238, 88,246,126,  5,152,179,224,
106,172,162,237,148,173,219, 22,245, 52, 62,209,178,187,174, 75,165,114,143,178,
 60,232,226,130,239,169, 71, 49,159,158,185, 85, 38,169,196,169,200,  9, 91,133,
210,128,223, 57,203,132,  1,183,127,236,192, 64,149, 52,120,179,135,202,145,222,
215,189,196,116,  9,254,219,142, 59, 72, 87,232,240,238,245,229,213,156, 75,178,
 60,166,220, 56,216, 71, 57, 80,177, 46,242, 65, 19,207, 46,118, 77,227,103,110,
  0, 17,100,154,147,243, 92,168, 36, 56, 29,173,119,178, 91, 62, 61,119,169,129,
 75,  2, 46,164,169,169, 26,216,100,166,243,230,154,185,198,182,139, 33, 18,  0,
139,210, 10,144,  7,
} ;

// ../Source/Template/GB_task_struct.h:
uint8_t GB_JITpackage_144 [1044] = {
 40,181, 47,253, 96,110, 12, 85, 32,  0,150,172,131, 40,224,178, 56,  7,200,165,
 49,196,246,110,149,114,175, 91,232, 44, 85,172,126,117, 78,221, 61,125,223,139,
118,  3,195,191,163,235,155, 51,152, 97, 24,198, 11,  1,127,  0,116,  0,113,  0,
 43, 35, 64,  4,113,105, 48, 24, 23,154,204, 37,145,161, 52,217, 66,153, 69,128,
104, 96,178, 72,171, 97,143, 82,191,212,141, 89,108,185, 48, 66, 90,150,139,197,
  9,105,195, 96, 49,193,  5,213,229,189, 56,183,198,137, 23,223, 54,234,142,192,
 50, 96,145, 14, 42,  3,150, 79, 48,201, 29, 71,208, 99,248, 68, 61,164,245,244,
 68,205, 93,134,154,168, 52,250,234,195,101, 57,179, 29, 63,153,168,206,166,177,
 98,188,240,223,118,219, 94,125,244, 23,109,106,236, 83,155,175, 14,191,190,170,
135, 83, 40,145, 68,161,  4,147,226,159, 22, 20,249,179, 97, 50, 94,100, 60,215,
217,216,130,126,230,183,117,174,144,240,230, 26,179,206,221,196,254, 94,167,195,
 63,101,243, 12,101,236,124,126,244,214, 14,199,179,101,124,167,206, 15,173,207,
145, 17,139, 27, 63,212,113,184, 33,113,235,123,232,211,164,186, 59, 37, 57,157,
 87,248,130,149, 48,241,112, 23,  9,102, 39, 29,126, 30, 40,223, 93,111, 31,207,
 58,  8,159,228, 44,103,236,215, 31,234,153,216,151,227,135,212,114, 61,187,237,
 87,211,  4, 95, 26,106, 14,189,143,183,220,186, 89, 22,225, 67,242,121, 28, 38,
 63,217, 37, 39, 50,191,217, 19,  7,140, 26,151,174,240,229,237,183, 81,207,246,
  5, 25, 78,173,215,163, 97,111, 63,161,156,148,183, 86,199,150,202,249,105,205,
113, 66,195,203,159, 79,222,222,179,173, 29, 31,  6,193,184,136,113, 32,150,139,
150, 53,105,185,188,149,158,227,173,103, 81, 82,185, 88, 85,244,253,238, 64, 40,
 23, 41,138,118,243, 59, 98, 55,126, 87, 36,142,239,  9,119,101, 81,148, 69, 40,
183, 34,128, 32,185, 69,245,144,213,  5,173, 92,222,118,  4,225, 27,122,133, 83,
  2, 62,217,188,203,121,222,126,117,233,164, 30, 64, 17,249, 68,242,108,227, 19,
185, 27,104,211,185,163,155,187,120,119,109,168,132,146,253,181,220,150, 19,235,
229,252,114, 81,161,193, 52,100, 92,154,134,135, 40, 66,120, 52, 18,105,205,201,
230,119,131,242,105,114,183,170,170, 42,138,162, 40,203,178,172,138,  4,229, 94,
 28, 24,170,113, 16,204, 49,116,226,168,117, 60, 66, 95,  5,  6,255, 35,145,128,
232,168,177,169, 51, 53, 35, 34, 73, 10,146, 82,107, 80,132,200,144, 93,213,  1,
226,  0, 77,199, 66,144, 32,130,140, 68,129,  4, 34,129, 68, 19, 74, 26, 41, 40,
 72, 65, 27,  0, 72,128, 88,158, 32, 71,107,114, 21, 91,129, 54,246,137,216,191,
182, 59,137, 84,168, 36,165, 82,114,250,215,177, 37,193,240,186,115,218,147,115,
 17, 31,  5,236, 61,109,125,206,238, 21,168,115,227,180, 70, 43,  6, 35,185,252,
 18, 46,115,226, 80,152, 57, 66,129, 85,180,202,139,121,212,131,164,103, 68, 23,
101, 53,106,255,152,103,234, 56, 43,102,205, 41,252,226,159,130,234,163,227,213,
175, 54,201,207,104,184, 75,244,153,233, 80, 54,136, 72, 37,165, 17, 51, 68,196,
108, 31, 78,132, 72,154, 54, 79, 30,155,  4,151,209,193,226, 30,128,240, 71,252,
125, 21,133, 89,119,148,246,  7, 71, 46, 39,104,200,114,237,146, 94,176,233,114,
162,241,179,212,206,159, 86,192,116, 79,158, 48,177,222,184, 73,198,131,  9, 20,
164,247,156, 40, 50,167,161,184,251,239, 26,211, 80,196,208,178,144, 26, 14,191,
249,208, 24,226,177, 65,208, 57,131, 44,226,215,113, 22, 13,  7,116,  1,117, 53,
 23,221,242, 37,169,110,188,140,232, 30, 29,244,213,147, 17,150,176,212,125,199,
100,211,246,229,186, 59,117,180, 60, 68,126,148,121,245,102, 73, 76, 19, 39,111,
 51,134, 58,144, 36,146,136, 38,158, 24, 98,247,140,227, 13, 30, 12,201,219,185,
 29, 48,211,200,142,119,  0,115, 24,115,181,205,102, 35, 94, 68, 35,186,148, 95,
176, 61, 15,244,207,254, 55,110,176,109,154,177, 99,111,168,185, 38,170, 50, 77,
 42, 63, 28,207, 64,164, 30,165,160,228,116,223,115,152, 29,182,247,206,242,201,
215, 61,103, 21,188, 52, 73, 19,  8,145,139,210, 98, 13,188, 80,151,100,224,254,
 90, 12,174,179,186, 77,120,252,227,222,201, 44, 62,184,244,160,127,  4,168,129,
 78, 58,102,243,124,150,153,131, 35, 64,190,133, 25,120,135,247,134, 64,145,143,
116,240, 29,  5,212,  6, 77,165,160,105, 16,172,167,  9, 72,209, 13,164, 23,220,
212,142,132, 72, 18,100, 52, 10,223,101,100,249, 55,249,237,195,174, 84, 56,206,
201,224, 75, 97, 68,131,166,170, 14, 19, 94,239, 53, 16, 50,187,224, 64,223,232,
 95, 15, 96, 12,
} ;

// ../Source/Template/GB_transpose_bitmap.c:
uint8_t GB_JITpackage_145 [789] = {
 40,181, 47,253, 96,184,  6, 93, 24,  0, 38,169,123, 40,240,206, 56,  7,136,136,
 56, 98,117,185,214,220,179,202, 27, 27, 33,113,188,145,237, 33,193, 44,236,201,
109, 34, 34, 86, 79,102,168, 88,224, 25, 72,115,248, 11,114,  0,113,  0,105,  0,
176,190, 75, 44,199, 45,246,100,173, 82,241,157,156,197,135, 74,130,225,226,208,
248, 99,249, 50,230,183, 57, 78,196, 92,202,119,170, 32,  2,137, 84,  8,  4,144,
200,167, 76, 58,117,227,  7, 50,220,241, 30,226,154,118, 81,115, 42,243, 30, 40,
 92,133,214, 65,194,215,194,154,225,142,158, 76, 84,233, 67,178, 86,120,109,194,
 83, 92, 67,167,166, 73,224, 73,125, 97, 38, 85,106, 93,151, 84,216,117,220, 96,
124,105,189, 19,218,198, 40, 14,127, 60,162,234,241,  8,125,203,125,225,118,222,
 92,147, 30, 10,122,199, 75, 44, 12, 22,205,117,109, 54,239,157, 69,219,151,237,
192, 27, 75,232, 59,105,  6,162,114,179,252,161,183,204, 97,182,116,114,226,100,
192,250,197,156, 44, 84,239,214, 27, 51, 56,232, 25,175, 79,186,168,125, 96, 21,
218, 84,147,229,  7,254,198,107,242,105,122,210, 47, 15, 66, 83,161, 96,153, 10,
 70,113,144,174,193, 52,100, 50,239, 92,211,205,217,194, 95,239,255, 31, 69, 24,
 17,196, 17,169,152,203,  2, 24,141,198, 21, 38,135,220,146,166, 44, 54,236, 43,
177,244,104,204,101,247,211,148,174,  6,217,114,141,117,158, 41, 89, 74,104, 97,
125,237,232, 97,199,129,182,  2,104,177, 31, 57, 26,110,109, 41,119,111,233,103,
228,186,170,164,132, 45,101,  4,253,186,124, 97,118,230,250, 27,125, 95,218,221,
179,129,221,153, 99,161,188,165, 27,117,103,231,145, 52,123, 92, 16,181,111, 58,
 79, 93,150,177, 31,218,252, 70,174, 79,181,211, 81,148, 17,109, 81,155,156,241,
234,169,139,  5,155,120,184, 92,158,197,147, 94,169,  5,134,244,173, 33, 99,185,
100, 34, 30, 70,131, 89,190,177, 54,183,  8, 96,189,226,186, 42, 94,165,176,126,
251, 70, 11,198, 58, 49,107, 72, 31,120,124,227,157, 91,127,245, 83,164, 58,210,
155, 52,118,188,180,106, 51,110,143, 78,192,173,199,169, 67, 69,233,122,200,246,
228, 78,124, 51, 71, 97,114,235,167, 40, 74,122,132,165,162,169,104, 48,239, 50,
153,106, 11,251, 98, 87, 13,123,168, 17, 49, 51,  8,161, 25,  9,102, 70,146, 20,
 20,210,  1, 64, 68, 48,200, 57,155,  7, 50,  8, 93, 75,147,198, 10, 12,209,  4,
243, 41, 40,255,122,217,  0, 56,147, 73, 47,158,130, 31,232,151, 85,110, 86,232,
 98,207, 47,226,158,  3,  6,220,220,162,184, 87, 93,129, 98, 68, 27, 18,  3, 85,
210,205, 53, 58, 20,165, 12,169,143,131, 25,100,213,226, 53,  1,170,136,179,179,
  4,123,129,147,207,204, 27,205,146,200, 45,248,101,122, 25, 86,148,166, 49, 10,
 72,122, 99, 90,206, 50, 81,178, 26,167,197,145, 90,148, 45, 64, 79, 81, 92, 84,
233,148,249, 30, 16,148,116,129, 48, 30, 48,155, 61,  0,166, 83, 72, 54, 24,221,
  1,163, 54, 39,140,157, 27, 18,250,114, 10,158,172,182,212,192,  1, 63,201, 78,
157,144,167,163,216,188,197,146, 36,141,175, 34,239,242,153,132,  4, 39, 25,  0,
245,160, 62,248,  2,206, 68,175,240,226,183,156,  7,137, 90,197,204,218,143, 94,
213, 94,119,218,196,199,203, 59,182, 72, 22,144,126,151,247,116, 57, 59,232, 56,
243, 10,180,128, 62,  4, 48,218,210,157, 23,242,216,154, 72,111,101,181,189, 13,
  4,134, 49, 94, 34, 56,210,200, 65,243, 40,102,194,125,192, 11,247,172,222, 74,
226, 77, 88,138,196,215,176,  3,  3,
} ;

// ../Source/Template/GB_transpose_full.c:
uint8_t GB_JITpackage_146 [737] = {
 40,181, 47,253, 96,202,  5,189, 22,  0,118, 39,119, 40,208,208, 58,  7,120,199,
 49, 98,127,185, 12, 50, 71,203,102,156,207, 89,248,166,119, 59, 75,149,220,  5,
127,217,150,142, 76, 26,108, 59,200,213, 48,139,188, 18,110,  0,108,  0,102,  0,
150, 99, 23,123, 50, 87,169,248, 78,222,162,165,154, 96,192, 60, 56,254, 88,190,
156,249,109,143, 19, 51,151,242, 58, 85, 32,137, 72, 42,  4,130,136,228,211, 38,
157,186,241,  3, 25,254,184, 30,242,154,126, 81,115, 42,187, 44, 11, 94,133,246,
 97,194,215,194,154,113, 71, 79, 22, 85,250,144,172, 21,158,155,240, 20,215,208,
169,105, 18,184,164,190,112,147, 42,181,176, 79,164,244,116, 26, 95, 90,239,132,
182,181,133,135, 67, 32, 81,  5,129,  4,167,220,105,247,133,221,121,115, 78,122,
 40,232, 29, 63,185, 48, 92, 52, 32, 42, 59,203, 31,122,203, 28,102, 75, 39, 39,
 82,  6,172,103, 76,138, 66,117,221,122,107,  6,  7, 61, 35,118,202, 23,185, 15,
172, 66,155,106,178,252,192,223,136, 77,151,116,  7, 45,171, 80, 62, 89, 44, 17,
 16,183,172, 95,222, 96,189, 23,150, 74, 72,215,100, 26,178,236,186,215,116,115,
182,240,216,245,255,143, 34,141, 40,242,144, 84,236,109,176, 94,159,  4,236,109,
247,211,148, 46,  7,217,122,173,125,158, 41,217,194,250,250,209,195,143,  3,109,
165,156,139,253,134,236,130,201, 32,174,140, 70,187,188, 99,110,118, 17,224,209,
176,107, 75,189,123, 75, 63,171, 74, 74,216, 82, 70,208,177,203, 23,110,103,175,
223,209,247,165,223,103,124,123, 54, 91,180, 13,191, 51,199, 66,121, 75, 59,234,
206,207, 35,233,  6,185, 32,106,223,116,158,186, 44, 99, 63,180,249,141, 94,  7,
 81,180, 17,117,145,155, 12, 16,109, 76,  1, 14,136,116, 10,115,209, 40, 44, 24,
204,101,113, 93,210, 43,189,117, 11,172, 86, 28,  3, 27,120,188,227,157, 91,191,
234, 20,169,142,116, 77, 26, 59, 94, 90,185, 25, 59, 72, 39,224,214,227,212,161,
162,132, 61,100,123,114, 39,190,153,243,  4,202,173,159,162, 40,233, 16,151,138,
166,162,201, 92,152,255,147,169,182,176,175,134, 85, 13,135,227,  9,148, 71,110,
 73,211, 22, 27,246,149, 88,122,184,107,168, 33,173, 67,200,144,140,200,136, 72,
146, 36,173,  6, 48, 68, 96, 20, 59,237,162,  8,105,141, 82,103,102, 74,196,148,
 71, 73,249,207,  3, 73,106, 72,120,250,  3, 60,  3,204, 26,141,201,133, 98,235,
141,169, 56,191,136, 89,136,  3, 63,177,193, 82, 37,243, 67,179,149,224,112, 87,
 82, 94, 76,148,119,252,101,  2,182,124,198,118, 53,135,133, 19,164,161,203, 19,
228,200, 18, 99, 22,237, 41,148,139,204, 84,103,232, 15,178, 34,125, 65,144,227,
248,195,138, 17, 46,219, 32, 96,171,132,218, 33,205, 93, 57,225,125,143,130, 22,
214, 75,118,203,113,132,178, 89,135, 41,161,127,220,209,133,108,230, 17,213, 68,
194,148, 14, 67,204,244,180, 66,251,242,190,239, 16,125, 25,  0,101, 10,170,110,
165,234,143,211,127, 57,222,158,143,224,222,195, 69,242, 47,112,201,227, 20,210,
241, 22,114,204,228,132, 45,208,219, 11,171, 79, 98,103,226,129,123,123,158, 34,
  2, 66,101,104,130,184,244,131,221,106,129,195,152, 45,  8,174, 48, 25, 52,223,
207, 76, 83,  7, 64, 56,199, 72,207,105, 62,251,120,243,213,  1,150,
} ;

// ../Source/Template/GB_transpose_sparse.c:
uint8_t GB_JITpackage_147 [833] = {
 40,181, 47,253, 96,133, 15,189, 25,  0,  6,102,116, 33,224, 90, 23,  3,144,119,
226,106,206,  2,139,180,157, 49, 67,110,137, 91,178,143,  8,158, 82,  5, 26,189,
 29,195, 24,131, 48,194, 11,108,  0,103,  0,104,  0,151,116,183,105,199, 11,193,
106,211,138, 23, 67,  0, 77,190,194,104, 87,217,106,203,185,222,100,233,114, 94,
150,244,156, 34,113, 72, 16, 26,136, 67,226,155,168,157,211,119, 85, 39, 47,208,
187,200,125,162,110,231, 28, 72, 49, 18, 18,215, 92,  1,237,190, 42, 48,195,231,
 93, 37,198,245,163, 89,207, 89,236, 58,183,109,  1,170,109, 93, 69, 13,159,157,
119,135,213,185, 98, 29, 90,125, 98,109,214,188, 67, 73,229,  6, 67, 70, 48, 24,
  2,228,182,168,151, 85,149,178,250, 27,226, 93,119, 61, 86,155,201,109,106, 39,
121,158,104, 87,102,189,151, 36, 31,199, 17,  2,125,119, 76,191,197,155,183,182,
 89,240, 29, 46, 24,219,188,223,218, 60, 69,239,241,141, 67,249, 66,150,195, 96,
223,168,118, 10,200,161, 31, 24,130,151, 80, 82,209,222,225, 80, 64,144,122,127,
100,139, 93,228,243,249,235,123,250,255,207,178, 87,118, 40, 36,  8,150, 20, 43,
166,119,100, 27,164, 11, 48,189,251,200,243,  6,131,209, 21,117,247, 40, 22,253,
222,171,109,151, 51,105,222, 33,143,238, 20, 35,  6,163,105, 71, 39,209, 49,125,
247,157,235,214, 33,197,143,111,167,115, 36,213, 14,134, 22, 73,229,221, 77, 38,
206,161,209,155,247,218,222,188, 77,123, 75,238,103,187, 58,111,119,205,118,223,
215, 54, 24, 64, 30, 63,188,251, 73,123, 62, 73,143,143, 14,162,235,207,187, 91,
177, 98,125,202, 39,107, 60,  3, 89, 22, 35,152,167,185, 96,120,154, 75, 72,225,
120, 58, 31,245, 66,239,146,217,116, 60,124,135,171, 44,171,190,228,254, 57,142,
110,169, 67,122,200, 38,222, 93,183,214,108,169, 26, 45, 41,234,111, 33, 74,101,
150,182, 44,107,174,248, 24,117,190,162, 74, 53, 99,192,120,247,197,139, 58,119,
181,186,180, 89, 22, 35,221,209,180, 27,197,231, 60,172,253,219,132, 33,204,247,
209, 22,213,142,207, 22,  5,220,124,160,134,114, 58,225,134,100, 71, 51,128,142,
160,241,161, 65, 83, 52, 65, 65, 65, 65,146, 74, 26,  3, 48, 68, 96,144,178, 18,
221, 29,124,239,248,148, 66,  9,122,140,206,212, 93,194,206,235,208,206, 42, 81,
  3,197,249,164,189,105, 74,207,113,230, 52, 23,231,159,222,  4, 89,155, 71, 90,
 19, 68,154, 63, 34, 29,  9, 30,226, 10, 31,126,208, 33,148,126, 92,222,223,  6,
255,238,151, 12,245,118, 22,131,168, 34,104, 20,255, 66, 19,161, 39,113,232, 34,
130, 22,196,163,247,208,104,230, 95,131, 88,190,  8,222,206, 86,224, 80, 27, 78,
 84,130, 31, 80, 57, 62, 62,202, 40,219, 72, 27,114,207,244, 22,112,196, 75,202,
 76, 58, 12,243,233, 72,134,150,106, 49,141, 24, 60, 16,131, 66, 24, 43,137,187,
126,137, 49,146,102,171,242, 38,218, 81,238, 73,157,177,147,156, 73,162,216, 70,
132, 34,252,151,229, 51, 68, 64, 46,131, 64, 37, 78, 79, 59, 35,241,254, 49, 55,
 26,  7, 61,159, 83,125, 92, 59, 76,223,161, 37, 16,254, 24,253, 54, 20, 88,136,
 50, 10,181,211, 86,250,124,192, 68,164, 39,154,176,167,203,159,168,163, 32,223,
227,240,237,180, 99,163,213,151,112,179, 25,194, 10,248,155,104,109,133,127, 33,
  2,248,143, 56,  8,219, 14,111,153, 86,  8,198,139,113,  8,129,112,112,141,104,
108, 28,  6,  4, 19,166,  7, 71, 25,132,244,160,247,117,  3, 15,243, 24,179,  5,
113,  7,204,128,181,188,195,112, 96,201,  9,107,114,160,191,144,190, 32, 46, 19,
159,218,  7,136,153, 45,110,104, 52,104,114,126, 96, 82,171,203,241,207, 45,192,
 61, 71,212,186,118,  1,146, 98,133, 82, 20, 52,  1,
} ;

// ../Source/Template/GB_transpose_template.c:
uint8_t GB_JITpackage_148 [761] = {
 40,181, 47,253, 96, 93,  9,125, 23,  0,198,226,104, 32,224, 26,231,208, 73, 35,
108,123,143,187,231,101,203, 18,149,110,132, 94,168, 31, 50, 55,107,180,120,168,
 70,140,113,136, 49, 14, 97,  0, 95,  0, 91,  0, 30,175, 44, 55,135,222, 23, 68,
205,208,195, 48, 59,214, 96, 40, 24,  7,199, 66,193,120,161, 35, 28,235,185,146,
148, 35,178,183,192, 91, 85, 83,116,108,203, 56, 19, 80,148,246,242,224,182, 82,
220,248,206,113,  3,136,245,173, 80, 20,229, 61, 42,143,177,216, 58, 86, 40, 12,
 50,194,109,217, 17,196, 26,209,254,224, 43, 67, 81,197,151,227,174, 98, 83,105,
 47, 55,185, 60,145,  0, 28, 18,137,246, 74,213,153, 85,146,158,193,139,182,  5,
 71,241,100, 38,223,172,128, 76, 34,110,227, 54, 14, 51,185,252, 99,143,142, 90,
246,203,168,  0,136,  8,156,189, 49,236,232, 20,188, 39,120,255,213, 55,247,120,
 86,213,190,173,223, 61,238,145,142,103,101, 79, 36,254, 31,  0,112,  1, 20,  8,
198,129,193, 78,138,217, 31,150,231, 55, 47,101, 47,115,224,166,220, 77,206,161,
 68,  1, 33,  2,158, 44, 36,226, 62, 91,230,155, 30,205,178,122,159, 97, 40, 58,
217,178,170,173,164,227, 49,143, 50, 60, 58, 79,220, 33, 79, 10, 41, 12,204,  8,
 76,167,  0,209,151,242,165,181,123,223,249,110,238, 58,249,122,207,167,223, 30,
 85,213,118,216, 13,199,102,123,249,206,126,  4,198,154,116,205, 41,121,127,231,
239,120, 58, 22, 50,181,156,170,247,116,182, 20,207,154,  1,163,  0,  0,120,253,
 39, 91, 95,240, 60, 18,121,115, 39,197, 78,217, 74, 34,252,155,218, 33,150,197,
 22,120, 91,223,239,201, 45, 74,213,157, 39, 80,214, 17,101, 38,175, 64,135,  8,
195,241, 59,120,235,233,108,229, 57, 35, 11,183,101, 92,156,138, 39, 84,217,112,
162,140,230, 23,235, 35,215, 52, 77,211, 14, 57, 75,114,200, 94, 32, 60,114, 86,
246,219, 77,123,155,173,225,246,246,  1,109,  1,128,137,160,193,173, 81, 70, 70,
 68, 68, 36, 73,146, 74, 99, 48,132, 16,163,212, 89,  7,123,167,231,239, 60,138,
159,162,214,104, 54,188,220,102, 44, 37, 99,203,101,188, 65,144, 18, 57,194,  6,
 79, 16, 94, 24,  5, 25, 25, 55,  6, 49,136, 28, 22, 34, 43, 71, 14,254, 56, 43,
106, 80,242,242, 33,128,114,123,100,183, 21,208,130,161,113, 19, 71,238,216,229,
 96, 27, 99,194,  9,252,192, 70,  6, 13,165,106,115, 78,102,196,151,214, 96, 26,
 64, 22,  8, 27,  5,141,145, 89,108, 57,200,161, 88, 24,158, 41,134, 96,132, 16,
244,165, 21, 34, 62,121,200, 18,  9,241,146, 15, 12,206,194, 91,200,194,172, 69,
184,187,104,114,165, 48,113,229,114,121,155, 56,110,187,203, 21, 31,241,163,251,
 80, 35,188,236,122,102, 42, 52, 73,136,151,249,214, 64, 18,  7, 80, 17,224, 16,
144,217,  5,217, 88, 26, 24, 65,  0, 34,211,211,233, 45, 94, 93, 36,185,117,108,
123,192,211, 14,191,239, 78, 84,211,151,154,231,135,238,149, 20,215, 79,  0,214,
179, 41, 69, 48,168, 15,192,179,162,208,117,237,212,131, 59, 20,  8,225,224,133,
 59,165,105, 62,116,108,168,181,  3,  4,236,  2,162,153,180,234,121,192, 20,206,
158, 12, 88, 16, 30, 13, 89,170,119,167,242,173, 44,131, 72, 73, 53, 24,127, 22,
209,217, 17, 65, 19, 19, 85,228, 15, 49,253, 33, 75, 29,156, 93, 77,133, 34,212,
 65,147,243, 51,211, 61,148,149,115, 16, 35,182, 90,155,224,221,193, 66, 21,189,
 99,
} ;

// ../Source/Template/GB_wait_macros.h:
uint8_t GB_JITpackage_149 [499] = {
 40,181, 47,253, 96,  0,  5, 77, 15,  0, 86,151, 76, 33,240,214, 54, 20, 48,107,
216, 83,198, 13, 17,164, 72,224,211, 13,193,103,142, 54,195,199, 26,214,173,199,
 37, 44, 14,131,158,247,  2, 65,  0, 66,  0, 69,  0, 14,177,172, 57,178,120,157,
107, 73,127,219, 16,165, 44,203,178, 30, 18,155,188,160,127, 44, 67,219, 63,215,
130,247, 75,215, 85,116,146,205,187,146, 94, 61,180,254,215,146,249,247,131,190,
 16, 45,141,243, 87, 73,111,219, 58,242, 28, 17, 55, 24,168,202, 96,  8,  1,234,
178, 16,213,139, 95, 45,167, 47,242,219,208,238,251, 96, 86,189,190,255, 89,173,
210, 64, 56, 11,124, 81,126,253,157,235, 45,126,108,231,227, 56,189,144, 64, 92,
136, 74,113,184, 16, 78,248,  6, 94,208, 86, 84, 33,110, 77, 47,137, 27,147,246,
226,  5, 58,181,140,203, 27,126, 41,150, 57, 42, 22, 14,  1,224,167,147, 83, 44,
222,139,170,232,120, 59,248, 35, 60,142,213,181, 37,112,141,202,  5,  2,215, 52,
204,230, 12,192,192,  9,115, 16,217, 50,200,134,113,161,188,255,218,  0, 37,241,
168,165,123,204,138,119,201,102, 38,124,240,134, 54, 20, 21, 90,240,126,  0,163,
221,228, 40,205, 36,116, 74,188, 14,227, 54, 18,108,219,247, 47, 46, 73,252,249,
166, 81, 77,199,119,135, 60,174,243,151, 37,209,221,169, 78,103,201,108,182,153,
241,123, 32,152,230,168, 96, 38,224,143, 30, 50,  4,234, 50,246,203, 25,  1, 73,
160,193,153,146, 74,166,146,164, 36,169,177,  6, 32, 68, 64, 24, 57,122, 14,141,
 17, 16, 82,209, 17,118, 22, 24,127,246,214, 26,114,132, 29, 16, 93, 49, 96,223,
196,  9,139,173, 88,146,220, 19,236,196,169, 66, 32,198, 48, 68, 88,137,162,197,
163,254, 70,194, 83,219,132, 76, 16, 84,193, 76,126,175, 52,204,169,189, 22, 89,
 79,177,200,  9, 71, 31, 91,177,178,225,171,170,137,240,210,116,149, 33,152, 90,
 48,186,195,  2,241,164,103,  0,129,111,148,191,216,109, 28,101,240,151,172,168,
 93,  8,133,244, 68,225, 91,216,100,137, 14,217, 18, 54,167,112,179,117,232,156,
186,129,184, 99,112, 68,  1, 10,131, 68,185, 29,130, 96,179,103,122,119, 10, 14,
119,192, 15,154,157,207, 76, 90,200,117, 28,148, 81, 23,116,171, 20,  5,119,
} ;

// ../Source/Template/GB_warnings.h:
uint8_t GB_JITpackage_150 [941] = {
 40,181, 47,253, 96, 34,  9, 29, 29,  0, 70,238,135, 30,240,220, 54, 80,217,107,
191, 87,158, 33, 17,200,178,198, 85, 91, 98, 53,109, 52, 51,142,140,173, 11,139,
195,160,248, 74,134,  0,121,  0,127,  0, 92,145, 80, 28, 11,  6, 51, 51,  3,  0,
170, 90,141, 53, 26,207,138,196,249,120, 70, 32,145,166,245,  3,192, 34,209,216,
220,139, 13, 98,184, 82,253, 91,127,167,115,158,205,237,244,248,159, 77,181, 25,
 37, 56,135, 85,183, 78, 98,123,189,238, 73, 44, 37,134, 17,142,198,162,177, 73,
 24,139,  6, 27, 98,129, 17,246, 97,189,225,  4,134,103,222,165,223,155, 24, 81,
194,124, 50, 30,216,181, 83,113, 91, 27, 44,249,253,176,  4,224,234,242,193,143,
 70,110,181, 40,207, 26, 94,174,120,  9,219,205,159,181, 99,171, 76,135, 21, 10,
192,166, 80,  4,181,193, 25, 82, 34,147,219,223,164,250,157, 79,193,191, 61,159,
189,251, 49,150,253,247,231, 63, 30,142,  1,115, 62,191,229,220, 12,185,210, 22,
115,110, 67,166,213,105, 14,235,178,155,237, 31,203, 14, 95,236,224,236, 50, 87,
 24,148, 70,108,227, 24,159, 13, 92,113,201,106,251, 92,129,251,235,186,130,  3,
218, 87,122,163,195,248,210,201, 32,165,146, 43, 13,  8,  4,194,121,108,  9,178,
215,102,123, 43,  5,189,242,  5,235,  5,105,226,192, 94,221,139,241, 13, 41,171,
217, 85,251,243, 26,  2,230,188, 62,199,191,150,206,174, 13,252,224, 11,175, 86,
154, 83,168,179, 90,113,161, 82,221,235,222,147, 37, 32, 28, 99,167,209,116,164,
 15,  0,156,251,100,219, 76,112, 46,148,113,254,128,103, 44,158, 73,135,253,141,
 46,221,242, 13, 89,140,224,102, 82, 54,139,202,206,107,179, 23,223,139, 49,194,
 65,129, 48, 55,155, 37, 18,  6, 35,188,132,123,105,118, 47,129, 64,120,118, 52,
122,157,225,  4,193,136,220,103,177, 91, 42,121,214,159,237,  8,105, 52, 98,148,
107,207, 82,188,242,109, 42, 91, 18,235, 95,  7,145,  7,227, 65,159, 11,111,137,
101,135,246, 81, 92,  2,149, 64,242,173,109, 65, 55, 91,198, 78,  8,243,209,208,
 75, 43,104,  3, 87,134,189,121,241,126,204,218,109,115, 43,235,181,155,223,175,
 49,  3,219, 80,130, 81,176,109,179,193,174,169,141, 63, 90, 91,207, 77,231,218,
165,253, 74,107,117,182,109,221,187,211,  5,246,254,247,114,243,186,144, 86,239,
 74,217,173,237,126,124,  9,126,207,205,112,115,150,101,210,191, 29,103, 88,239,
 38,184, 50,191,147,198, 77, 82,202,218,230,111,119,126,106, 11,128,158,168, 81,
165,114,134,134, 72, 36, 40, 72, 10,146,100, 56, 48,132, 16, 82,236,172,  3,194,
185, 28,164, 56,144, 33, 69,  4, 72, 48, 50, 34,129,140,  4, 18,200,100, 87,205,
  6, 21,  3,168, 45,241,118, 41,129,179,186, 32, 34,  4,  4, 70, 56,170,143,151,
201,193,210,253, 57,154, 46, 59, 40,202, 78,232,174, 53, 17,156, 62, 54,200,164,
 12,138,227, 48,154,194,132, 11,123,205,144,238, 23,168,245,177, 58,225,104,157,
 66,231, 29,112,248,249,201,108,130,254, 64,122,197,164,112,137,253,141, 54,180,
178, 39,164, 50,205, 15, 61,140,149,226,229,252,235,123,166,226,114, 59,213,227,
  0,143, 15, 24, 31,186,160,228,103,249, 49,180,138, 24,190, 91,236, 52,119,143,
144, 34,203, 95, 44,105, 27, 34, 42,157, 19, 84, 29,220, 98,157,194,175,176, 94,
158,249,186,133, 20,136, 93, 53,161,106, 49,175, 78,201, 66,128,245, 54,174,198,
 88, 81, 24,162,153,160,114,202,179,128, 62,238, 62, 98,210,150,221,  5,247, 53,
228,  1,156, 89,208,176,178,159,180,243, 47, 81, 12,120,137,  5,197,104,235,253,
 96,179,218,189,131,104,237,156,157,234,117,223, 86,193,108, 82,103,137, 61, 96,
112,154, 75,172,203,  0,206, 61, 91,217,192, 51, 12, 96, 46, 32,143, 16, 15,112,
225,162, 98,223,169, 30,229,114,217,220,170,237, 65,149,111,243, 27,232,  7,163,
139,196,213,232,243,218, 57,251,213,151,139,172, 55, 11,243,195, 38, 22, 72,128,
139, 27, 55,139, 98,185, 69,118, 62,220,206, 85,106, 94, 53,117,102, 65, 61,134,
 66,172, 72, 32, 97,252,234, 14,239, 85,124, 26, 96,223,130, 85,169,252, 60,182,
186,  9, 48, 51,104,166, 63, 51,221,  4,185,226,  1,222,209,160,202,171, 22, 48,
  1,
} ;

// ../Source/Template/GB_werk.h:
uint8_t GB_JITpackage_151 [1331] = {
 40,181, 47,253, 96,172, 15, 77, 41,  0,214,185,164, 38,208, 22, 85,  7, 20,152,
244,223, 10,216,237,161, 69, 75,209, 38,144, 26,134,215, 90, 74, 79,153, 26,195,
 89,207,  2,111,148, 95,228,106,  6,188,120,130,158,  0,145,  0,155,  0, 27,110,
176,188,189,165,202,249, 86, 44,187,117,147,176, 94, 30,123,139, 97, 80, 59, 67,
102, 61,  6,210, 10, 84,177,185,216,144,240,184,212,122,215, 86,160,  1,170,192,
162,153,195, 49,172,123,109,124,106, 89, 88,180,159, 86,155,177,124, 68,104, 80,
150,118, 88, 91, 55,222, 49,195,118,227,154,230,240,201,160, 96,160,192,146, 64,
 48, 80,112,169,138, 62,245,118, 50,226,148,195, 63, 89,132,219,114,124,210, 56,
100, 30, 50, 46,153,  2,163,205,201,105, 52,110,167,129, 72,170,140,125,143,107,
 22,255,224,227,211, 77,177,124,185, 93,171,228,250, 12,175,247,131, 27,247,237,
165,214, 49, 25, 69,194,234,217, 60, 80,252,114,129, 44,151, 75,111, 43,149,225,
 43, 81, 70,195,105,255, 73,230,188,101,177,180,100,175,220,250,249, 11, 94, 77,
182,247, 18, 32, 22, 26, 74, 25, 62, 76, 59,144,147,239,220,176,100,238,170, 29,
 61, 78,207,243,215, 52, 11,195,203,195,146,197,245,188,170, 48,206, 39, 45,159,
198,247,222,140,227,138,111,153,123,253,220, 78,116, 75, 99, 86,175,227,168, 87,
182,110,249,142, 61,168, 41, 95, 59, 85,212,100,229,224,167,214,103, 76,203,178,
176,118,119, 89,252,148,  4,241,143,166,101,181,220, 39, 70,103, 24, 43,237, 92,
 74,150, 99,110,143, 29,188,196,142,123, 11,227,123,159, 85,155,121, 62,169,150,
  5, 88,  7,159,198,253,181,175, 54,102, 28,223, 32, 95, 24, 73, 74, 40, 25, 72,
137, 14,112, 41,225,  2, 81,  4,227,251, 92,247,182, 94,  7,249, 82, 71, 10, 17,
 24, 29, 25, 27,170,113,242,243, 44,141,217,187, 24, 14,114,151,172, 59,110, 19,
176,129, 80, 32,200,106,242,233,130,231, 96,228, 30, 55,145, 33,167, 28, 96, 41,
115, 87, 85,176,122,221,245, 47, 92, 89, 51, 79,192, 57,179,234,193,234,114,249,
 23, 62, 18,114,107, 97,231, 63,116,  2, 65,208,129,130,  1,  2,  1, 68, 61,108,
185,235,167,135,241, 83,172, 58,142,205,123,221,210, 42, 53,238,173, 81,  5,141,
219,168,229,149,243,216,221, 70, 73, 82,147,116,198, 87,206, 48, 16,116,173,245,
180,146, 87,146,213, 62,177, 90, 12,159, 49, 97,145,121,208,186,218,  3, 53,214,
238,180, 56, 49,247, 91, 62,194,151,197, 15,107, 71,223,109, 89,187,169,242,196,
 79,125,180, 24, 55, 61,202,215,255, 17,105,100,112,240,130,211, 39, 41,  2,136,
 46, 45, 92,138,166,143,168, 66,211,161,241,105,160, 55,141,251, 22,174,173,229,
181,121,112,243, 74,229, 31,215, 32,228, 44, 60,147,233,192, 56, 67,172,150, 99,
 43,  7, 28, 18,185, 52,125, 68, 18, 27, 14, 25,  8,137,136,167,157,197, 62,242,
202,169, 85,106, 53,228, 74, 57, 77, 51, 10,198, 44,102, 84,115, 84,243,225,236,
181,215,195,154,197,140,159,218,236,100,  1,129, 35,168,193, 33, 83,166,100,100,
 20, 20,148, 20, 36,173,  1, 33, 12,130, 64, 32,207, 82,216,  3,  2,185,108, 14,
 34, 67, 40, 34, 66, 66, 34, 18, 35, 18,136, 40,163,160, 32, 37,121,142, 57,  4,
156,224,221, 71, 13,191,107,144,  6,  0,142,132,111,248,122,119,245,136,144,199,
 87,132, 32,  1,209, 81,171, 17, 56, 39,164,201,101,136,217,  3,131,189, 29,154,
227, 12,102,178,211,236, 90, 67,218, 37,140, 10,231,142,103,111, 26, 89,252,233,
122,160,132, 55, 85, 18, 70,170,248, 98,159, 94,129,101,191, 38, 51,207,232, 13,
 89, 10,102, 42,137,140,114,184,200,253,180,215, 19,246, 82,191,182,216,181,138,
 58,158,213,235, 63, 12,108, 23,135,149, 96,236,221,178,142,251,176,133,236,147,
162,243,101, 15,102,236,226,157, 18,175,112,211, 24,211,244,163,187,168,174, 29,
108,249,128,175,105,112, 65,201, 93,167, 77, 51, 78, 34,203, 72,129,219, 50,191,
188,122, 22,106, 36, 56,  4,128,229,172,160, 72,  3, 57,139, 96, 75, 37,104,137,
 14, 36, 34,135, 85, 51,115,124, 24, 58,219,  4,153, 38,209,105,135,214, 64,230,
 27,223,120,243,180,136,200, 50, 24,137, 40, 72,  3,143,145,247,225, 71,251, 46,
 58,124,202, 33,228,150,138, 35, 97, 52,167, 72, 94,175,160, 45,  5,188,211, 19,
 68, 72,105, 90, 85,142,181,189,110,163,  0,115,174, 20,187, 71,143,151, 57,226,
230,164, 29, 97, 44,229, 36,132,  7, 39,189,115,206,190,125, 87,221,210, 77,  3,
154,124,201,127, 55, 79, 24,238, 29, 79,  6,121,108,134, 71,133, 36, 76,158,217,
184, 13,212,173, 27, 17,  9,102,176, 61, 92,105,119, 32,205,142,182,251, 67,  4,
 69,128, 84, 57, 34, 67,178,210, 50,219,117,175,176,205,104, 28,187, 70,106,184,
130,197,  8,169,125, 49, 35,159, 27,116,151, 76,244, 39,155,152, 58, 24,205, 99,
193,226, 66,188,175, 29, 91,243,131, 13, 36,160, 17, 73,250,174, 65,122,  1,159,
244, 12,118,141,243, 95, 98,170,254,  8, 90, 50,112, 73, 64,193,  3,181,116,  1,
 30,  7,199,171, 53, 61,194,140, 37,109, 47,227,123, 14,220,178,207, 63,  4,136,
217, 51,212, 98, 27, 17,193,135,160, 34, 86,216,152,172,236,114, 63, 60,155,242,
 37, 84,155,158,193, 60,229,131,128,105, 88,  5, 12, 64, 63,154,160,251, 95,  9,
164,153,199,  5, 63,116, 48,103,118, 59,148, 49,224,166, 41,166,137,167,148,168,
117, 69, 94,144, 50,236, 40,  7,157,181, 48, 51,130, 17,227,183,160,211,170, 10,
105, 99,254,119,108,137,253,234,138,130, 65, 26,181, 31, 37, 51,176,212, 91, 33,
164,161, 79, 40,  9,186, 32,178, 85, 57, 37,190,212,101,227,168,139,  4, 19,227,
255,226, 30, 19,225,233, 10,148,234, 94,137,223,248, 36,243, 28,186, 20,252,113,
197, 71,  9,135,115,  5,224, 74,129, 65, 93,216,  6,108,103,140,190, 64, 83, 60,
146, 54, 86,149,208,194,121, 90,166,129,102,104, 70, 70,138,153,150,154, 97,220,
 51,214, 81, 47, 81,239,101,125,117,  0,120,
} ;

// ../Source/Template/GB_zombie.h:
uint8_t GB_JITpackage_152 [925] = {
 40,181, 47,253, 96, 81,  7,157, 28,  0,182, 44,129, 38,208, 22,113, 14,160,213,
107,191, 81,124, 81, 30,181,176,233,138, 20,116,172,  8,213,179,144,148,125, 13,
251,243,244,148,222, 44,245, 48, 88,193,193, 11,128,  0,113,  0,108,  0, 76,114,
189,228, 99,100, 52, 17, 11, 64,153, 16,129,200, 52, 84, 92,120, 92,235,250, 98,
  0,138,101,186, 72,139, 89,170, 81, 71,136,203, 23,207, 94,151,145, 86,246, 90,
172,145, 58, 30, 48, 38,183, 37,113,229,102, 92, 78,108,195, 25,127,143,122,100,
112,177, 92,164,131,  2,203,229,144,245, 60,146, 92,162, 15,159,168,119,176,  9,
 51,222,120,164, 65,105, 26, 48, 77,163,  4,194,202,168,154,198, 78,222, 52, 40,
242, 17, 94,151, 13,121,114,243,181,238,  8,216,180, 92,101,240, 68,164, 65,226,
  4,  4, 20,137,128, 32,157, 56,123,223,212,212,129,174,183,157,219,131,178,210,
183,126,211, 76,162,243, 89,112, 96, 48,206,119,211,138, 89,159,  2, 45, 23,186,
 71,  5,210,163,221,158,150,188,242,184, 43, 95,108,131,143,193, 28,130,248,217,
146,230, 55,  7, 94, 78,142,190, 36,172,233,221,234, 82, 49,  5,183,154,198,239,
250,132, 61,249,189,216,188,229,152,133,243,175,140,201,186,230,187,149, 90, 73,
 48,238,201, 21, 42,144,158,207, 13, 86,250,138,110,182, 43,191,224, 93,  7,242,
233, 39, 59, 28,206,102,206,246, 59, 15,246, 53,104, 29,179, 24,227,156,194, 64,
 20, 81,230,113,120, 52,123,179,222,176,148, 90,109,242,157, 74, 55, 90,223,232,
241, 79,155,241,212,109,168, 59,101,243,163,181, 26,126,234,123,122, 56, 63,123,
217,226,235,218,111,132,217,165,192,228,149,155, 90,219,185,219,173,218,183, 78,
177,217,167,254,169, 82,209,187, 37,137,154,125,171,183, 90, 55,225, 56, 53,187,
190,249,208, 72,196, 15,245, 20,202,197,174, 23,130, 66,180,143, 63, 15, 56,164,
 61,143, 70,195, 97,193, 20,  5,164,247,149,104,164, 69, 76,101, 16, 24,110,185,
194,243,  0,129,161,145,129, 46,146,244, 80,166,201,202,169, 92,107,111, 25,140,
215, 97,212,145,155, 65,  7,150,174,249, 26, 16,105,136, 18, 81,223,182,217, 24,
225,148, 27, 35, 14,140,209,198,133, 69,220,169,239,110,157, 83, 56, 47,167,228,
247,125,218, 54, 93,175,118, 75,159,150,208,209,136,122,212,213, 52,213, 79, 14,
 44, 55,106,239, 56,221,248, 84,  6,128,179,168,161,169, 82,134, 72, 36,136, 20,
 36, 41, 40,164, 49, 32,132, 16,163,220,149,  7, 66, 96, 73, 16,114,230,208, 85,
 82,148,122,237,207,  1, 70,112, 39, 89,104,148,222,182,142,207,210, 17,171,204,
100,152, 69, 82,160, 56, 16,207,170, 74,203,142, 47,197,137, 65,210, 68,208, 20,
156, 37,240, 46,115, 71,195, 78,121,224, 13,109,249, 54, 83,230, 90,143, 65, 92,
182,173, 24, 88,115,142, 35, 22, 82, 25, 88,241,194,179,247,237,142,130,111, 65,
180,198, 10, 49,190, 85,153, 64,104,217, 47, 65,  9, 25,181,107, 31,106,215, 78,
201, 14,243,  6,124, 41,106,150, 32, 46, 97, 13, 33,187,184,  9, 24, 57,210, 77,
162, 73,171,193, 99, 46,195, 48,193,178,148,203, 49,147, 56,142, 38,221,197, 92,
 99,195,108, 37,170,108,110,196, 12, 42,  5,226,145,162, 87, 34,245,161,165,173,
247,214, 47,105,  2,135, 81, 89,249, 30, 50,193, 74,124,231, 15,161, 85, 74,204,
185, 64,248,194,208, 46,129,  0,206,110,233,  2,116,110,221,142,  8, 18,243, 38,
230,248, 99,126,134,133,128,179, 91, 58, 91, 69,128,124, 10, 73,107,143, 36,211,
103,157,162, 48, 90,196,134, 37,121,143, 27, 75, 92,246,126,202,207,190,239,166,
245, 68, 73,151,109,114,200,241, 42,248, 93, 56, 34,166,201,124,154,209,  4,  4,
231,239, 74, 30,140,112, 43,105,128,205,152, 68,140,244, 80, 86,245,227,  3,224,
 45,101,146,159,224,142, 57, 30,143,192,201, 92,106, 46,225,139,215,226,194, 29,
 36, 91, 76,122,102, 28,  2,170, 58, 88,176,255,134,186,176,210,143,140, 84, 35,
209,166,  2, 60, 50,189,230,232, 42, 72,103, 41,152,172, 47,159, 87,122,167, 12,
238, 97,199, 65,  3,158,137,146, 57,104,182, 63, 51,121,191,124,157, 79,217,105,
222,126,213,  2, 60,
} ;

// ../Source/JitKernels/GB_jit_kernel.h:
uint8_t GB_JITpackage_153 [562] = {
 40,181, 47,253, 96, 31,  5, 69, 17,  0,118, 28, 89, 32,240,182, 30, 12,  8,146,
156,149,114,253,188, 89,180, 32,243, 52, 16, 18, 84,205,240, 96,113, 46,253,204,
133,197, 97,128,230,189, 81,  0, 78,  0, 80,  0,122,123,158,123,113,140,165, 31,
 26, 12,  5,  3,225, 88, 40, 24,110,176,  5, 63,232, 59,170, 16,167,164,151,188,
 13,134,238,230,  7,140,196,166, 23,214, 28,121,188,206, 53,196,252,190, 34, 76,
212, 24, 87,207, 96,231,207,137,176,253,174,192,125,187, 38,238, 15,143,194,255,
229,  7,209,125, 63,116, 70, 60,145,136,136, 68, 34,191, 43, 14, 67,191,  5,226,
127, 87, 16, 37, 20,179, 42, 23,139, 66,187,231,190,238, 10, 98,164, 50, 90,229,
239,109,255, 64,215, 24, 87,  7,247,119,157, 35,232,235,143,111,231,250,122, 91,
 84, 80, 12,196,123,182,134,210, 31,249,111,119,247,247,220,133,120,253,189,189,
 24, 98,  3,209, 40,238, 71,249,245, 95, 60,181,131,113,181,159, 53, 43,187,182,
 74,230,210, 93,238,123,141, 95, 16, 13,190, 51, 24,146, 30, 99,206, 11,110, 63,
212,216, 62, 71,169,127,249, 55,233, 29,147,211,130, 69,220,221,163, 33, 82,145,
216,233,132, 93, 90,102,169,182,202, 69, 11,  0, 31, 12,220,112,177, 52,180,194,
100,180,224,156,131, 27,204, 33, 13,120, 84,113,195,200,202,210, 56, 91,150,101,
 89,150,101,217,156,115,206, 57,167,148, 82, 74, 41, 37,  4,179, 36, 24, 76,106,
 42,180,162,155,121, 73, 42,170,137,  4,209,243, 93,173,223,218, 74,145,110,222,
 53,228,246,118,158,173, 31,122,211,197,245, 58,184, 75,157,207,254,185,186,  6,
179,173, 33,127,253,222,214, 32, 27, 90,160,241, 92,163,148,144,136,104,138, 82,
144, 66, 99,176, 36,144,170, 49, 15,150, 82, 40,141,139,205, 35,122, 26,  3, 87,
142,220, 57, 38, 89,112, 30, 51, 55,  7, 92, 57, 38, 95, 56, 19, 35, 55,199,220,
 28, 72,110,224,196, 41,228,114,227,206, 81,190,224,110,174,114,198,103,139, 69,
 14,236,184,104,176, 62,254,189,134, 54,  0,186,177, 91,201,175,171,239, 88,112,
184, 71,108, 50,187,180, 53,129,136,  2, 85,120,181,129,196,197,115, 59, 45,222,
214,170, 52, 51, 10,104, 57,208, 86, 70,116, 48,216,131,110,155, 75, 60, 26,212,
 37,128,180,180, 85, 57, 96, 16, 92,  2, 27, 95, 91,  8,235, 17,  0,240, 75,238,
 54,156,  6,240,178,144,165,228,106, 22, 40,160,231, 16,208,100, 72,103, 52, 61,
 18,  5,186,105,254,252,204,196,206,129, 21,123,  3,136,185,115,147, 50, 70,138,
  2, 49,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_dot2.c:
uint8_t GB_JITpackage_154 [308] = {
 40,181, 47,253, 96,165,  1, 85,  9,  0,230,209, 60, 33,  0,243, 54,238, 78,242,
 32,143,127,186,137, 18,168,232,192,189,172,128,254,165, 22,246, 61,177,180,201,
 33,170,170, 22,  4,  2,  4, 51,  0, 52,  0, 50,  0,111,106,175,228,126,231,147,
163, 31,  9,238, 23,221,109, 65, 80, 25,141, 73, 96,113,185, 38, 51,238, 29, 36,
226, 22,158,170, 77,126,215,122,234, 13,127,212,207,185, 59,111,174,197,156,162,
168, 68, 81,  1, 56,103,210,197, 81,153,190,239,232, 55,127,115,115,131,154,188,
121, 24, 86,143, 16,149,161,146, 18,  7, 67,229,  4, 60,240,200,204, 29,207,225,
 83,245, 15,184, 73, 49,119, 30,113, 53,179, 96,233,105,204, 10,148,237, 33,241,
172, 90, 45,195,238,181, 24,141,194,240,204, 80,165, 39,238,140,113, 51,251,229,
209,198,231, 71,234,210, 45,106,152, 42,233, 65,236,149,213, 45,253, 57,147,247,
248, 31, 68,122,115,252,148,134,168,194,  9, 28,247,184, 46, 11,119,173, 30,245,
185, 95,  3,240,228,237, 23, 47,192,255, 59, 67, 60,230,128,187, 59,  5, 81,133,
 19,  6,174,117,218, 86,185, 85,167, 57,174,189,212,155, 61,  2, 18,  0, 66,128,
 82,212,229, 11,130,  8,  1, 88,  0, 66, 26,141,215,105, 49, 25, 31, 36,128,156,
 69, 55,116, 40, 72, 14, 25, 96,210,252,121,102,138, 54,140,173,214, 47,  6,185,
162,214,146, 78,236, 41, 10,134,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_dot2n.c:
uint8_t GB_JITpackage_155 [328] = {
 40,181, 47,253, 96,200,  1,245,  9,  0,166,147, 65, 33,  0,145, 55,238,114, 98,
128,176, 60, 70,153,234,234,188,106,113,127,144, 94,234, 79,122, 57, 48,107,232,
 17, 85, 85, 11,  2,  1,  2, 56,  0, 56,  0, 56,  0,119, 60, 63,141, 81,143,234,
239,236,126,231,180,171,161, 57,238,199,184, 95,130, 93, 48, 32,  1, 69,229,218,
 20,221,189,134,195, 41, 48, 42,167,109,134,248,106, 44, 38,191,212,127,193, 59,
 91,240,197, 92,146, 42, 36, 73,  1,159,197,188,203, 15, 27,208,163,229,131, 57,
131, 38, 86, 36, 10, 63,163, 31,125,206,209, 61, 86, 50,231, 36,105,253, 57, 76,
133,  9, 66, 24, 10,147, 15, 64,129, 63,104,206,124,150, 71,214, 55,227, 54, 49,
217,243,167,179, 89,  3,129,111,222,198, 69,176, 54,121,155,133,239,196,226,236,
210,184,235,225,153,189, 91,134, 97,124,177,250,144,100, 42, 74,231,135,217,153,
226,104,246,202,159, 13,166,161,169, 79,167,106, 33,154,160, 31,193,239,180, 78,
233,181,118,106,194,  7, 93,119, 85,149,164,195, 87, 99,  2, 47,117,186, 95,  3,
192,232,219,143,193, 23,  3,248,135, 41,  9,150,217,186,186, 45,210,105,150,243,
176,183,105,216,126,153,197, 15,  3,238,238,149, 83, 19, 30, 18,  0, 69,  9,174,
 67, 20,111,168, 89,190,  6, 42, 65, 72,  3,228,117, 70, 76, 22,  7,  9,200,103,
145, 12, 29, 98,146, 67, 48,152, 52,127,158,153,162, 45, 99,171,117,140, 65, 92,
 81,162,110,231, 64, 20,  5,110,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_dot3.c:
uint8_t GB_JITpackage_156 [320] = {
 40,181, 47,253, 96,178,  1,181,  9,  0, 22,211, 63, 33,  0,243, 54,238, 78,242,
 32,143,127,186, 97, 87,225,121,226,111,118, 64,255, 82, 11,251,158, 88,218,228,
 16, 85, 85, 11,  2,  1,  2, 54,  0, 55,  0, 53,  0, 96,137, 53,102,189,169,113,
201,253,206, 39, 71, 63, 18,220, 47,186,219,130,160, 50, 26,147,197,229,154,204,
184,119,144,136, 91,222,132,216,228,119,173,167,222,240, 71,253,156,187,243,230,
 90,204, 41,138, 74, 20, 21,121,143,255, 65,164, 55,199,247,114, 38, 93, 28,149,
233,251,142,126,243, 55, 55, 55,168,201,155,135, 97,245,  8, 81, 25, 42, 41,113,
 48, 84, 78,240,  6, 30,153,185,131, 29, 62, 85,255,128,155, 20,115,231, 17, 87,
 51, 27,219, 67,226, 89,181, 90,134,221,107, 49, 74,245,151, 31, 80,147,110, 58,
184, 73,140,191,198, 62,241,111,196,126,121,180,189,243, 35,117,233,223,115, 76,
 44,186, 69, 13, 83, 37, 61,232,225,178,186,165, 63,103,  2,148,134,168,194,  9,
 28,247,184, 46, 11,119,173,198,  6, 62,234,115,191,  6,120, 19,222, 47, 94,128,
255,119,134,222,152,  3,238,238, 20, 68, 21, 78, 24,184,214,105, 91,229, 34, 58,
205,113,237,165,222,236, 65,  9, 18,  0, 69,  9, 38, 33,136, 16,128,  5, 32,164,
113,122,157, 22,147,113, 72, 10,144,204, 12,240,127, 14,104, 45,227,236, 22, 38,
 77,155,103,166,104,187,216,106,221, 98,144, 35,106, 85,233,196,136,162,192, 13,

} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_dot4.c:
uint8_t GB_JITpackage_157 [386] = {
 40,181, 47,253, 96,116,  2,197, 11,  0,182,149, 71, 33,  0,213, 54, 86,202,107,
 21, 76,190,213,101,130,244,224,112,163, 64,194,227,210,238, 57,128,113,138,226,
140,252,255,223,186,  4, 16, 61,  0, 62,  0, 63,  0,223, 30,195,204,249,180,209,
172,126,160, 78, 99,140, 39,117,  7,218,126,231,114,155,222,248,237, 15,221,107,
 65, 64, 29,  6,136,235, 17,187,115, 19,138, 51,110,165,216,163,103,171,136, 90,
240, 69,253, 31,187,179,199, 86,204, 45,107, 82,150, 21,163,  6, 57, 99, 30,170,
139,250,239,118, 32,234, 12,253, 25,231, 45,190, 55,161,158, 20,255,230,140,218,
 68, 50,149,247, 33,253,228,107, 78,238,175,147, 53,  7, 65,234, 83,226, 58, 92,
212,  2,113,184,156,112,  7, 62,145, 57,212, 69,188,162, 62, 10, 29,  7,  4,187,
235,251, 59,110, 89, 18,203,132,187,104, 52,252, 30,206,  1,119,247, 73,154, 13,
 39, 12, 28,195, 97,180,140, 85,112,152,136,173, 27,106, 51,201, 69,147, 84, 60,
163, 21,147, 97,214, 86,108, 78, 32, 88, 98, 39,179, 67,124,218,183,244,  2,115,
150,102,195,  9,219, 38,129, 64, 52,155,173, 26, 27,184,168,203,253, 26,112,171,
110, 87, 12,224,239,149,224, 21, 39,206,158,248,129, 59,134, 13,127, 80,118, 20,
186,195,177, 29,233, 49,252,208,254,107, 76,138, 99,222, 87, 44,177,127,110, 33,
 32, 32,130, 71, 93,121,165,160, 55,131, 96, 46,  5,125,147,153,180,131,209,  3,
160,105,176, 29,240, 21,168,  2,140,129,250, 49,176,146,142, 63,137,130,234,167,
 45, 20, 98,163,109, 91,247,253,  0, 40,141,185,156, 22,203,184, 93,  1,226,137,
227,155,133,179, 17, 17, 38, 77,205, 51,211,219, 42, 88,173, 83, 66, 78,188,190,
244, 98, 79, 81, 48,  4,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_saxbit.c:
uint8_t GB_JITpackage_158 [377] = {
 40,181, 47,253, 96, 70,  2,125, 11,  0,214,213, 70, 33, 32,179, 27, 83, 56,173,
253,220,102,234,232,185,216,213, 22,152, 64,  2, 96,167, 25, 44,241, 51,167,202,
226, 50, 32,  4,  7,  0,  2, 59,  0, 62,  0, 64,  0, 30, 56,239, 35,225,248, 78,
112,243,252,225, 22,239,127,142,219,235,198, 62,238,217,215,211,117,168,130,159,
107,248, 53,232,111,158, 95,119,130, 78,249, 53,160,137,229,  5,178,100,117,123,
189, 35,243,115,228,245,104,138,138, 18, 69,  5, 30,157,160,213,137,235,223,125,
182,206, 65, 36,199,214,233,103, 82,198, 97,153, 56,255, 92,199,174, 53,206,222,
230,181,174,213,106,194,161, 42, 84, 18,194, 80,168,122, 64,  5, 77,192,255,153,
142,158,172, 14,121,217,243,253,165,  9,155,149, 93,  1,216,  4,114,161, 96,180,
206,185,238,  3,221,221, 81, 20, 21, 61, 16,116,229, 82,209, 44,155,188, 50,150,
204, 48,138,134, 73, 58,179,174, 74,246,144, 23, 72, 36, 70,128, 55,121,158, 21,
252, 60,203, 67,  8,188, 30,128,118, 46,172,212,126, 32, 22,166, 74,242, 49,142,
162,162,  7,219,134, 53, 26,152, 77, 94,215,222, 48,251,  5,208,216, 61,103, 93,
209, 12, 73,134,190,142,139,238,228,245,156, 39,197,114, 34,193,249,229,215, 96,
235,249, 76,109,216,117,135, 78, 77,173,147,118,246, 77, 83, 84, 30, 32, 48,  2,
162, 36,179, 30,108,160, 44,191,248, 45, 62,  0,224, 20, 10, 46, 81, 54, 29,208,
 28,  8, 68, 62,142, 16, 25,152, 17, 57, 58,232, 96, 11,222,232,182,237,247,253,
 18, 32,141,221, 15, 43,  0,  0,128, 20,101,190, 55, 88,103, 33,210,160,217,121,
102, 90, 91,136,171, 57,136, 40,155, 11,  8, 90,  3, 81, 20,184,  1,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_saxpy3.c:
uint8_t GB_JITpackage_159 [466] = {
 40,181, 47,253, 96, 70,  3, 69, 14,  0, 54,219, 86, 32,  0,151, 30, 27, 67,185,
 80,252, 66,160,155, 55,227,224,188,158, 88, 11,124,  1, 57,211,207,202,120,144,
103,233,255,189, 62,132, 75,  0, 77,  0, 79,  0,151, 84, 33, 94,144,110,250,108,
145,119, 55, 39, 76,105,185, 62, 96,205,145,197,235, 92,193,249,251,134, 51,230,
235,189,246,199,158,239,106,175,158, 69,157,155, 48,120, 55, 14, 61, 47,221,188,
171,231,190,176,133,132,  9, 44, 85, 77,175,146,164,248,191,252, 33,186, 47,136,
 94, 17,183,172, 88, 89, 86,219,220, 54,204, 91,103,151,204,131, 86,166,188,184,
131,158,200,210,144,174, 23,255,239,118,207,  5,162,161,128,168,254, 99, 43, 40,
125,145,255,118,119,127,207, 77,170,215,223,219,107,169, 54,144,172,192, 61, 41,
191,126,205,245,254,120,174,230, 24, 75, 39, 36, 16,  6, 68,165, 56, 24, 16, 62,
176,  2, 39,232, 95,216,121,200,214, 14,198,213,250,126,143, 91, 22,118,153,108,
 24,141,214, 61,215,221,128,187,123, 60, 69,134, 15,  4,158,217, 50, 90, 70, 19,
156,108, 35, 39,189, 54,146, 90, 48,140,134, 85,220, 34,175,140, 37, 66,183,  9,
 37, 70,192,167,240,187, 98,208,251, 77,175,  8,192,159, 11,177,253,110, 32,110,
 15,141, 22, 49,166, 34,195,  7,115, 98,143,135,102,210, 43,127, 57,220,159,  1,
118,160, 97, 25, 71,226, 40,148, 15, 30,  2,199,166, 38,179, 73,231,100,211,176,
 57,101,236, 46,247,125,160,163,  7,186,179, 72,143, 26,222, 81, 43,194,184,210,
210,237, 48,220, 81, 81,147,231,177,225, 29,245, 66,237,133, 86,127,162,187,109,
 41, 32, 48,  2, 98,160, 82,122,228,160, 44,113,161,130,112, 32,191,203, 66,253,
142,235,104, 91, 57,130,  1,113,232,  8, 16,242,  0, 50,206,168, 12,142,  3, 56,
200, 88, 56,222,140, 48, 37,  8,  6, 31, 79,135, 12,204,136,206,199,216,202, 80,
 88, 70,255,110,127,226, 75,184, 52,250,247,140, 64, 54,123,128,186, 42, 38,188,
128,132, 68,230, 35,107,  7, 77,135, 48, 19,116,132,186,134,131, 30,189, 51,131,
135,242,240, 20,189, 67,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_saxpy4.c:
uint8_t GB_JITpackage_160 [306] = {
 40,181, 47,253, 96,186,  1, 69,  9,  0,  6,210, 60, 33, 16,179, 30,230,109,130,
 35,245, 18, 31,103, 47,136,106,246,246, 35,165,110,240, 40,235, 51,162,  5,175,
224,136,  0,  0,170,110,  6, 50,  0, 51,  0, 50,  0,217,245, 58,219,144,254,190,
 30, 26,187,142,183,255,115,159,  4,201, 40, 96,158, 59, 25,247,202,  3,226, 23,
 71, 37, 66, 33,200,234, 58, 65,178,226,  7,243,115,234,190,155, 58, 51,175,170,
 56, 85, 85,224,115, 87,155, 46, 13, 10,213,253, 39,191,254,205,245,246, 52,119,
115,140,165, 75,  8,203, 96, 77,138,131,193,242,  1, 39,112, 73,223,143,109, 56,
 37, 61,228,237,206,119, 43, 46, 81,169, 77, 47,180, 57,114, 78,180,172,198,  8,
240,168,223, 22,135,223,239,138,152, 25,192,191,243, 96, 14,188,129, 40, 97,236,
201,184,190,142,249, 21, 13,148, 53,189,199,217, 80,250,149,255,102,238,  6,191,
123, 76,175,  3, 49,142,226,194,  7,148, 58, 48,204, 66,235,204,153,192,193,236,
217,159,  1, 28,101,247,127, 53,225,238, 30, 69,113,225,  3,129, 79, 42,147,141,
 82, 19, 24,202, 69,210, 58, 47,178,106, 14,201,230,136,184, 22, 17,  0, 71,133,
163, 50,197, 72,  8,105,116,189,206,136,201,  2,146,  2,171, 15,168,  7,105,251,
 67,212,243,134,  6,176,105,254, 60, 51, 69, 27,198, 86,235, 23,131,248, 80, 56,
145,231,240, 20,  5, 67,
} ;

// ../Source/JitKernels/GB_jit_kernel_AxB_saxpy5.c:
uint8_t GB_JITpackage_161 [1097] = {
 40,181, 47,253, 96,161, 20,253, 33,  0,198,235,136, 40,192,240, 58,  7, 60,135,
153,176,242,190, 19, 84,233,102, 31,167, 42,160,122,217,151, 53,112,239,  7,214,
238,189, 38,123,123, 31,234,224,186,138,130, 32, 27,204,125,  0,128,  0,124,  0,
222, 12,197, 87,110, 83, 15,205,182, 63, 13,210,216,182, 71, 51, 16,138,134, 45,
242,245,232, 54,238,206,113,  6, 63,180,243, 90,227, 43,  4,203,192,130, 36, 28,
 24, 88,127,120,212, 43, 76, 71,179,225,145,248, 18,152, 67, 16,237, 94,113, 49,
147,129,161,121, 49, 21,174, 51, 21,113,211,237, 80,  9,148, 52,190, 51,132,159,
 73, 66, 19,148,233,197,227,171, 90, 69,158, 99,122,203,171,140, 32, 50, 20, 88,
 94,153,148, 66,164,137,101, 70,138,178,182,189,157, 33, 51,197,144, 25,230, 18,
201,  4,145, 72,  2,175,186, 94,136,194,239, 55,244, 28,251,216,174,247,132,199,
 55,204, 94,143, 14,102,170,241, 47,  4,115,131,254, 13, 71,235, 98,183,185,104,
 46,153, 77,163, 73,138,137, 40,185,248, 32, 49, 27,173,163,105, 46,220,255, 79,
211, 22, 53,157,150, 73,206,192,192,187, 46,110,146,211, 36,192, 61, 10,127, 80,
231,116,156,206, 38, 39, 21, 27, 69,228,100, 70, 17,101,230,178,233, 92, 34,158,
137, 25, 39,131,145,157,  6, 49, 77,  1, 96,164,243,172, 33, 80,103,137,144, 97,
  2,222,159,168,122,150, 10, 76,  6, 17, 11,210, 96, 32,206,192, 51,219,103, 75,
179,152,177, 13,189,202,114, 18,189,121,106,100,118, 41, 15,105, 52,229,215,181,
134,215,138,228,228, 31, 13, 71,213,210,123, 52,207,140,187, 11,166, 19, 59,201,
117, 29,206,182, 73,112,178,115,201,104,155,134, 99,249,175, 11, 59,117,236,193,
176,112,174,211,178,141,180, 32,160, 36,229, 96,162, 45,245,244, 39, 16,193, 24,
206, 51,172, 95, 13,193,219,233, 29,244, 40,168,209,185,116,241,139,242,190,243,
248,118,198,244,211,247, 21,  7,235, 96,210,245, 99, 41,166, 28,  4,211,212,241,
177,244, 82, 80,227,246, 58, 83,208,187,243, 37, 59,111, 89, 22,199, 93, 44, 22,
234,246,138,114, 95,133, 63,170,236, 85,124,101,161,238,185, 40,146,130,145,240,
  4,165, 40,228, 81,141, 31, 57,180,207,162, 11,234,181,229, 13,165,140, 57,207,
 80,248,217,121, 76, 31,223,183, 57, 28, 28, 27, 83,101,122, 76,179, 86,106,231,
232, 58,102, 48,133,182,154, 44,203,186,176, 91,209,117, 97, 22,  2,101, 98, 89,
216,229,161,159,237,142,  0, 47,178,241,104,143, 86,130,103,121, 81,190,217, 55,
128,221,160,145, 53, 50, 51, 35, 35, 34,146, 36, 37,201,112, 80,132,200, 20, 17,
 21, 55,230,131, 84,112,248, 64, 66, 48,112,233,199,124,132,132,131,164, 35,182,
179,113,253,212,  5,240, 88, 32,128,184,  3, 58,163,164,135,166,  7,170,200,208,
 48,109,146, 68,176,115, 31,150,111, 88, 53, 71,255, 64,160,179,  0, 20,159,237,
179, 14,175,165, 98,  3,177, 32,189,113, 43,113,138,102, 83, 88,239,220, 17,167,
140,244, 19,136, 83,213, 59,167,128,124,148,176, 27,141, 49,206,156,173,253,133,
 36,145, 49, 95, 13,107, 34,135,211, 47,149,242,153,119,129, 33,210,104,169,130,
206, 64, 17, 83,147, 43,103, 82,139,181,111, 48, 72, 95, 98,159,179, 97, 48,224,
202,143, 30,115, 52, 38,  1, 38, 54,  5,200,  2,112,214, 22,142,217,  4,156,109,
 57,172,  9,118,254, 54,153, 90, 16, 54, 41,  7,139,113,143,135,201,149, 58, 46,
148, 32,220,141,181,171,199,118,211,156, 19, 44, 58,192,164, 67,184,233,199,171,
238,156,245,207,174, 59, 15,251,119,217,197,211,254,185,109,231,  6,220,155,196,
246,181,122,  2,102,142, 41,102, 80,243,161, 42,196, 88,255,251,131, 35,109,164,
239,138, 24, 70, 58, 17,144,126,154, 49,242, 64, 33,196, 94, 57,168,137, 14,170,
127, 71, 77, 11,190, 62,208,163, 64,251,  4,  0,223,196,220, 62, 42,174, 61, 54,
249,192, 50, 62, 52,124, 48,115, 93,224,115, 91,250,135,245,218,  1,  7, 30,  0,
128, 54,192,248,142,  3,174, 99, 14, 53,180, 78, 96,131, 14,173, 79, 61, 56,133,
 15,  4,240,193, 40,149,103,160,235, 99, 14, 63, 97,204,136, 33,179,145,  3, 40,
 31,195, 14,  1,141, 76, 94, 42,118,112, 76,170,115,142, 12,159,151, 41, 20,120,
 56,233,176,171,129,206, 24,156,227,177,241,181,120, 65,102,164,121,128,166,  0,
227,184,236, 37,236,104,230,  4,223,218,167,170,248,214,113,229,  9, 12,160,131,
224, 23, 16, 42,130,182,109,110, 63,194,139, 69,177,134, 13,138, 92, 56,153, 21,
138,173, 13, 21, 25, 40, 89,189, 91,134,180, 92, 15,  1,  8,129,138, 14, 60,126,
224, 58,  2,116,121, 86,  4,  1, 33,231,242,131, 14, 61, 36,132,137, 10, 96, 15,
  6, 84, 26,139,100, 32,204,125,127, 20,144,208,246, 14,  4,228,243, 80, 96,223,
176, 71,  5, 70, 23,224,245,214, 73,  3, 51,222, 17,160,105,219,206, 65, 19,230,
 15, 38,181,170, 78,142, 60,232, 92,116,  8, 85,  9,166, 20,  5,120,
} ;

// ../Source/JitKernels/GB_jit_kernel_add.c:
uint8_t GB_JITpackage_162 [287] = {
 40,181, 47,253, 96,114,  1,173,  8,  0, 86,209, 58, 33,  0,211, 60, 62,183,128,
189,105,233, 64, 32, 94,117,183,105,166,238, 33, 81,107, 55,210,127,220, 96, 49,
 88,254,255,239,245, 33,  4, 49,  0, 50,  0, 49,  0, 32,199,211, 21,241,163,246,
 56,246,119,238, 88,137,241,252, 49, 83,222,245,198,194,120,  4, 20,151, 71,148,
 48, 23,151, 35,190,  9, 99,239,134, 47,234,207,220,157, 49,151, 86,167, 40, 41,
 81, 84, 63,138,255,229, 77,170, 96,145,  9,191, 71,255,248,157,143, 27,188,228,
206,195,112,122,100,176, 42, 75, 58, 20, 42,203,  7,159,192,163, 49,123, 60,204,
167,233, 31,112,111, 52, 89,226,145,157, 27, 13,150,199,  1,119,119,  9,146,  9,
 31,  8,156,147,112, 93,228, 98,216,188, 91,  6,233, 50,135,111,147,114, 91,189,
 18,173,113,105,149,213,100, 73, 15,126, 30,103, 58, 66,127,182,228, 45, 62,214,
164, 82,134,100,194,  7,214,102,215, 53,177,151,234, 42,112, 81,119,246,107,192,
 55,253,246, 66,142,230,247,165, 21,224,143, 59,225, 39,230,202, 33,156,  6,153,
100, 86,163,100,215,106, 47,230, 13,  0, 68, 37,149,175,224,  9, 53,117, 86,129,
218,214,115,208, 91, 39,140,201,212,160,249,243,204, 20,109, 12, 91, 45, 95, 24,
244,235,130, 61, 69,193, 16,
} ;

// ../Source/JitKernels/GB_jit_kernel_apply_bind1st.c:
uint8_t GB_JITpackage_163 [271] = {
 40,181, 47,253, 96,106,  1, 45,  8,  0,118, 16, 56, 21, 16,253, 42,159,251,182,
128,245,113,202,147,  7,218,153,237,136,  0,  0,  2,  0,  1, 49,  0, 49,  0, 50,
  0,181,229,164,118, 93,210, 95,122,183,248,  7, 16, 82,161, 15,159,158, 63,244,
245,233, 59,231,113,219, 10, 42,183, 38,185,195, 52, 93,146,112, 42,215,233, 75,
222,173, 75, 74,214, 71, 16,192, 64,144,134, 72,117,  7,154,230,117,106,167,222,
183,111,118,109,189, 15,195,209, 47,152, 37, 89,140, 70, 73,150, 79,156,195, 47,
236, 54, 47,169,127, 68,127,103,239, 57,110,193, 95,124,145, 38,177,116, 25, 36,
248, 41,212,118, 73,228,168,117, 93, 68,106,213,230, 85,217,215, 34,137,211, 44,
 18,188, 48, 82,178,128,228, 88,140,148, 61, 75, 58,250, 78,157,182,106,123,203,
 41,122, 25,169, 45,167,103,171,  5,  0,208,  3,207, 39,190,175,154,166,240, 35,
165,218, 26,190, 92,227,119, 90,  7,231,145,222, 37, 76,199,233, 77,  6, 63, 69,
113,248,148, 91,225,255,255,  1, 30,120, 62, 49,124, 14,228,188, 46, 11,  0, 78,
133,156, 94,  7,  8,192,106, 17,210,160,111, 29, 39, 38, 83,131,230,207, 51, 83,
180, 21,108,181,225,  4,131, 66, 69,193, 16,
} ;

// ../Source/JitKernels/GB_jit_kernel_apply_bind2nd.c:
uint8_t GB_JITpackage_164 [271] = {
 40,181, 47,253, 96,104,  1, 45,  8,  0,102, 16, 56, 21, 16,253, 42,159,251,182,
128,245,113,202,147,  7,218,153,237,136,  0,  0,  2,  0,  1, 49,  0, 49,  0, 50,
  0,181,229,164,118, 93,210, 95,122,183,248,  7, 16,123, 17, 13,159,158, 63,244,
245,233, 59,231,129,202, 11, 42,183, 38,185,195, 52, 93,146,112, 42,215,233, 75,
222,173, 75, 74,214, 71, 16,192, 64,144,134, 72,117,  7,154,230,117,106,167,222,
183,111,118,109,189, 15,195,209, 47,152, 37, 89,140, 70, 73,150, 79,156,195, 47,
236, 54, 47,169,127, 68,127,103,239, 57,110,193, 95,124,145, 38,177,116, 25, 36,
181, 45,212,118, 73,228,168,117, 93, 68,106,213,230, 85,217,215, 34,137,211, 44,
 18,188, 48, 82,178,128,228, 88,140,148, 61, 75, 58,250, 78,157,182,106,123,203,
 41,122, 25,169, 45,167,103,171,  5,  0,208,  3,207, 39,190,175,154,166,240, 35,
165,218, 26,190, 92,227,119, 90,  7,231,145,222, 37, 76,199,233, 77,  6, 63, 69,
113,248,148, 91,225,255,255,  1, 30,120, 62, 49,112, 32,231,117,  1, 11,  0, 78,
133,140, 94,  7,  8,192, 34, 17,210,152,111,157, 49, 38, 83,131,230,207, 51, 83,
180, 21,108,181,225,  4,131, 66, 69,193, 16,
} ;

// ../Source/JitKernels/GB_jit_kernel_apply_unop.c:
uint8_t GB_JITpackage_165 [593] = {
 40,181, 47,253, 96, 35,  5, 61, 18,  0, 22, 93, 93, 33,224,152,109, 48,163,107,
189, 86,199,234,187,104,146, 24,229,154,215,197,113, 65,104,189,223,239,147,184,
 26, 49, 70, 68, 19, 28,  2, 82,  0, 84,  0, 84,  0,153,162, 64, 48,248, 21, 90,
142,153,111,  2, 35, 62,168,142, 26,119, 89,250,141, 99, 95,237,182, 49,131, 90,
194,184,166,  6,243,119,247,159, 31,205,167, 43,226,119, 93, 58, 74,131,248,116,
 93,134,252,170,150,231,210, 29,126,130, 56, 35, 28,228, 18,159, 22, 69,230, 12,
 90,242, 98,125, 73,118,255,200,110, 18,215, 52,154,105, 90,137,141, 95,245,241,
 43, 91, 94,198,122, 58,207,171, 23,127,232,138,129,107,244,224,232, 67,215, 52,
119,119, 74, 41, 22,147,177, 95,  4,195,121, 92, 36,244,  1, 74, 24, 24,178, 59,
134, 96,174,206,208,247, 67,191,241, 21, 41,217, 53,241, 13,191,203, 58, 17,111,
 32, 94,147,190,230,213,184,185, 71,209,107,156, 36,171, 99,  7,  3,193, 16,155,
253, 40,182,158, 30, 89,173,181, 54,124,159,165,189, 44,129,115,158,103, 99, 33,
 84, 69, 45,207,108, 50, 26,207,118, 28, 70,195, 89,188,171, 91,166,147,216, 13,
165, 66,105,232, 69,124, 77,242,174, 80,142,141, 28,123,199, 74,243,109, 61, 65,
 44,247, 50, 24, 78,195, 47,124, 73, 19,232, 88,118,236,171,229,213, 82, 28,254,
190, 45, 34,148,174,104,195,175,239,227, 32, 16,206,103, 55, 45,177, 28,235,115,
 95, 13,  8,  7,121,244,118,147,  0,252,138, 39, 25,226,255,113,204,121,155,184,
 12, 85,149,235, 34,225,115,220, 40,203, 18,160, 60, 30,145,188,163, 77, 97,108,
 83, 24,180, 60,210,113, 19, 12,200,225,160,234, 59,124,189,205,171,  5,190,237,
130,122,245,178,161,  4, 88,160, 97, 65, 65, 70,102, 72,102,166, 40,133,194,112,
 96, 68,100,172,140, 30,205,  8, 57, 67, 32,184, 57, 78,131,146,204, 87, 15, 36,
249, 25, 21,187,252, 82,104,218, 26, 65,148,162,218,228,147,113, 99,132,116,172,
231,157, 14, 99,210,159, 54,212, 44, 27,213,189, 84,215,109, 34,233, 24, 15, 22,
 36, 98,194, 53, 14, 53, 16,154,105,214,196, 25,255, 39, 50,216,139,  2,160, 96,
137, 72,228, 30,125,251,186, 38,  3, 89,210,179,201,250, 97,228,150, 52,103,102,
254,165, 72,204,193,141, 72,214,  6,211, 45,141,246, 22,145,103, 37, 88,210, 22,
192,  6,234,146, 18,200,230,153,  4,178, 51,  7,141,  8,  0,167, 12,255, 35,186,
  1,160, 44, 13,159,222, 85,246, 99, 31, 98, 43,230,146,116,  7,236, 12, 11,131,
 75, 54, 87, 64,219,173,132,206, 95, 28,178, 79, 58,131,117, 15,154,155,159,153,
238, 56, 90,  1,223,  4, 98, 92,240, 42, 69, 93, 19,
} ;

// ../Source/JitKernels/GB_jit_kernel_build.c:
uint8_t GB_JITpackage_166 [306] = {
 40,181, 47,253, 96,191,  1, 69,  9,  0,182,145, 59, 33,  0,211, 60,238,206,  4,
253, 16,159,143,211, 70, 18,235, 45, 88,146,135, 18, 54,189,208,237,100,134, 60,
104,255,255,247,250, 23,  2, 49,  0, 50,  0, 51,  0,212,229,157,111,135,154,203,
185, 68, 47,109,126, 98,151,179,195,235,220,137,244,247, 29,169,156,153,231,208,
226,126,176,148,135,239, 88,169,248,193,252,153,186, 47,166,206,204,171, 74, 78,
 85, 21,182, 19, 47, 63,228,191,150,187,193,247, 24,211,107,240,237,213,166,201,
 34, 66,121,191,201,175,127,115,189,191,203,221, 28,227,203,165,130, 53,176, 38,
  3, 97, 96,121,100, 33,151,244,221,116, 11, 15,  9,231,112,190,237,205, 91,127,
 22, 56, 22,161,112,149,115,119,233,145,  8,143, 32,135,112,144, 45, 82, 23, 26,
 67, 50,171,134, 61, 54,204,225,218, 53, 33, 90, 86, 57, 70,163,206, 76, 14, 40,
107,250, 47, 82,202,143, 68,120, 68, 41,166, 80, 72,104,157, 57,131, 28,204,227,
254, 12,176,212,239, 14,139,154,223,213,195,  0,127,111,196, 22,188,  1, 74, 41,
221, 26, 12, 45,194,189, 27,110,106,  4,121, 21, 32,128,194,116, 99, 27,228, 68,
105, 40, 64,207, 93,216,132, 16,175, 39, 52,246, 50, 11,220, 93,107,147,160,180,
251, 57,204,125,152, 64,166,  6,205,152,103, 38,181, 13,178,154, 11, 66, 76,199,
251,113, 24,138, 42, 55,
} ;

// ../Source/JitKernels/GB_jit_kernel_colscale.c:
uint8_t GB_JITpackage_167 [284] = {
 40,181, 47,253, 96,116,  1,149,  8,  0, 86, 17, 58, 21, 16,253, 42,159,251,225,
 11,144,251,177, 38, 53,212,211,160, 71,  4,  0, 16, 56,  8, 51,  0, 52,  0, 52,
  0,159,246,223, 77,225,149,246,165,159, 99,212,231,174,188,214,174,253,122,124,
157,235,242,245, 85, 33, 69,148,127, 76,228,187,165, 73,187,177, 73,186, 31,158,
127, 75,214, 43, 75, 78,151, 79, 18,224, 72,146,116,173,166,235,231, 93, 87,242,
 70,195, 40,204,225, 44, 10,227,  9,115,240,  6,189,222,101,229, 17,201,231,106,
 29,191,107,232, 13, 80,218, 38, 85, 46,231,235,249,244, 92,202,224,175, 87, 27,
  4,230,245, 13,224,214, 81,228,102,113,159,165,249, 77,154,186,237, 34, 67, 44,
 35,167, 11, 80, 16,230,248,170, 89,202,146,127,230,191,162,107, 13,255, 19, 59,
 62, 13,127,115,221,142,177,242,144,243,223,243,167,255,231,  3,  0,176,  3,144,
 39, 64,208,162, 40, 17, 36,167, 25,158,237,250,207,129,137,252,186,116,229,247,
215,100,224,255,105,187, 38,188, 10,222,123, 15,232,  0,228,137,193,119, 97,247,
121,164,181, 73, 84, 13,  0, 70,128,146,244,166,248, 34, 64,  0, 22,128,144,198,
200,117,154,152, 76, 13,154, 63,207, 76,209,230,177,213,188, 99, 80,102,184,  0,
 81, 81, 48,  4,
} ;

// ../Source/JitKernels/GB_jit_kernel_concat_bitmap.c:
uint8_t GB_JITpackage_168 [437] = {
 40,181, 47,253, 96,223,  2, 93, 13,  0,166, 25, 82, 33,  0,181, 30,214,170, 36,
224,202, 10, 12,199,205, 56,127, 40,  8, 73,148,196,160,183,116, 21,  3,232,184,
 83,254,255,239,245, 33,  4, 70,  0, 73,  0, 75,  0, 78,217,201,101,120, 65,149,
225,130,233,163,205,  6, 61,151,115,185, 77,237,218,228,170, 51,196,135,186,230,
237,247,253,108, 17,115,209,213,187,122,220,171,131, 27, 95,159,142,223, 17,185,
122,246,205,208, 93, 45,  6, 45,253, 30,235,239,208,125, 57,244,202,220,178, 98,
101, 89,  1,225,165, 83,206, 44,177, 60, 97, 40, 19,236,241,245,190, 11, 68,138,
115,235,228, 25,116,133,115,174,141,  3, 65,161,250,141,173,121, 58, 66,255,245,
238,198,223, 57,170, 15,241,219,171, 85, 23,  6, 69,208, 61, 72,127,248, 21, 15,
247, 70,115, 43,254,125,211,165,161, 48, 40, 84,  7,194,160, 16, 29, 91, 51,223,
 87,173,239,215,184,101, 53, 34, 14, 78, 98,169,120,223,121, 55,224,238, 30, 73,
 49,225,212,228, 19,110, 82,161, 80,202,140,112,142,139,114, 19,147,104, 13, 73,
165,  1,113,109, 94, 19, 45,163,156,227, 17, 35, 53,114,201,113,121, 93,186,156,
211, 93,138,176,201, 41, 19,137,133,  2,  3, 49,150, 98,194,169,109,107, 96,152,
101,163,151,206, 38,199,250,179, 95,  3,172,224,203,158,223,244,202,  0,254,221,
231,179, 56,122,183,195, 31,240,232, 38,252,120, 52,131,153,118,244,135, 18,190,
168,232,200,227, 10,247,232,219,251,133,180,243,238, 30, 67, 12,222,109,241,199,
243, 38, 32, 64, 68, 32,146, 33, 61, 78,194,112, 64, 65, 26,137, 20,230,154, 49,
195,103, 65,  1,  8, 68,135,254,195,137,  0, 18, 16,113, 52, 64,104, 36,  8,108,
142,115, 68,  9, 48,138,110,174,109,134,208,251, 91,168, 52,174,115,132, 13,  0,
227,217,108,  2, 29,240,220,176, 90,  7, 61,118, 44,123, 12,218,166,233, 60, 51,
121,155,166,171,245,204, 17,  2, 11, 67,  3, 56,226,225, 41,234,134,
} ;

// ../Source/JitKernels/GB_jit_kernel_concat_full.c:
uint8_t GB_JITpackage_169 [338] = {
 40,181, 47,253, 96,213,  1, 69, 10,  0, 22,212, 65, 33,  0,211, 60,238,110,  1,
 62, 58,197, 99, 92,172, 55,218, 59, 82, 80,  3,202,176,169,248, 13,119, 87, 71,
182,255,255,123,253, 11,  1, 55,  0, 57,  0, 56,  0, 25,220,185,228, 38,102, 89,
 64,171, 47,195,135,218,130,220,111,172,225, 34,117, 14,214,219,102,190,157,177,
 79,119,235,249,221,224,121, 26, 74,221,246,230,239, 86,239,179,126, 76,221,248,
 82,173,203, 41, 42, 74, 20, 21,130,169,146,222,114, 45, 56,221,160, 31, 83,240,
206, 63, 97, 72, 31,230,191, 24,147, 34,  9,109,154,252, 70,127,248,155,135,219,
 82,193,219,116, 73,168,  4,149, 84, 24,  8, 42,143, 46,228, 50,196, 27,155,240,
105,122,199,178,191,155,194,225,216,180, 50,236,170, 29,163, 17, 99,212,113,121,
113,137, 93,186,156,211, 93,114, 40,228, 90,246,128, 68, 95,136,235,148, 19,148,
 20,132, 36, 90, 70, 63, 99,202, 79,  2, 49,186, 96, 11, 57,248, 57,194, 47,248,
198, 49,126,226,193, 35,142, 83, 80, 10,225,170,165, 47,200,179,214,236,215,128,
 59,121, 96,230,119,  5,248, 79, 52,222,205, 56,224,238, 30, 61,241,224, 17,228,
 89,151,109, 90,197, 48,200,162,118,147, 62, 50, 90, 49,197, 35, 23,  0, 76,  9,
  3,128,  2, 34, 12, 16,128,181, 33,164, 33,251, 58, 35,102, 54,155,  2, 58,212,
185, 21,171,245,132, 30, 39, 22, 63, 10,218,166,249,243, 76,161, 93,  9,  0, 29,
 11,130,115, 12, 58, 49,223,220, 92,199, 11,240, 48,  7,167, 40, 24,  2,
} ;

// ../Source/JitKernels/GB_jit_kernel_concat_sparse.c:
uint8_t GB_JITpackage_170 [338] = {
 40,181, 47,253, 96,216,  1, 69, 10,  0,214, 19, 65, 33, 16,209, 60,230,145, 11,
255,252,199,116, 19, 23,100,157,136, 16, 87, 27,187,143, 61, 76, 82,211, 23, 77,
117, 68,  0,  0, 85, 53,  3, 54,  0, 56,  0, 56,  0, 59,172,224,205,103,165, 23,
229,137, 87, 43,234,111,108,169,178,114, 12,214,251, 86,220,175,135, 59, 99,167,
158,223, 13, 63,234, 43,142,118, 95, 46,135,156,  5, 63,235,167,216,141, 63, 75,
 41, 92,146, 36, 36, 73,  1, 19,244, 30,119, 69,234,  6,253, 88,130,119,254,110,
  1,253,152,159,195, 23,  4, 73,100, 81,247, 23,253,227,107, 62,110,111,130, 53,
  7, 65,234,147, 48,  9, 38,168, 48, 16, 76,254,112,142,207, 17, 95,110,194, 35,
234, 25, 47,126, 81, 10,187, 20,118, 91, 48,164,124, 50, 62, 63,159,216,167, 79,
 74,221, 39,166,114, 60,195, 28,143, 39, 28,177,165,147,138,179, 18,157, 72,134,
 85,159,177,228,187,128,124, 62,124, 29, 23, 67, 71,248,135, 57, 41,136,  2, 82,
110,228,193,159, 90,173,170,122, 84, 75,233,172, 45,251, 53,128,139, 64,177,242,
219,  2,252, 59, 11,200,101, 28,112,119,151, 26,121,240,199,113,108,195,180,204,
 90, 85,163, 89,181, 27,173, 28,151,229,208,172, 70, 24,  0, 75,128,226,212, 53,
  0, 80, 65,196,  1,  2,176, 90,132, 52,174,239, 17,182,  0, 96,204,108, 54,  5,
116,168,115, 43, 86,235,  9, 61, 78, 44,123, 20,180, 77,243,231,129, 41,154, 81,
 24,130,198,172,229, 25,131, 58, 80, 24,122,  1,142,204,225, 41, 10,134,
} ;

// ../Source/JitKernels/GB_jit_kernel_convert_s2b.c:
uint8_t GB_JITpackage_171 [335] = {
 40,181, 47,253, 96,206,  1, 45, 10,  0,198, 83, 65, 33, 16,211, 54,230,159,197,
126, 20,224,167,145,  8,166,205,  0,224, 93,178, 13,160,170, 37, 84, 45,226,232,
 30, 17,  1,  0,168,210, 25, 55,  0, 55,  0, 55,  0, 29,112,147, 24,220, 57,229,
 42,102,129,217,211, 11,  3,247, 27,103,184,153, 61,204,198, 20, 39,183,127,169,
189, 92,186, 27,238, 68,169, 74,187,245,107, 70,242, 90,241, 71,253, 23,187,113,
104,173,133, 83,212,148, 40, 42, 83, 37, 61,120,189, 92,221,160, 31, 87,240, 30,
255, 99, 72, 95,142,127, 49, 38, 73, 20,218,244,189, 70,127,249,155,151, 27,180,
224,205, 69,177, 58, 37, 84,130, 74, 42, 12,  4,149, 71, 23,114, 90, 98,141,167,
240,169,122, 88,181, 50,108, 97, 59, 70, 99,206,168,227, 52,116,138,157,146, 37,
182,213,105,118,119,215,178,  7, 36,202,148, 83, 51,221,252,200,169,208, 68,203,
 18, 63,226,202,127,129, 25,133,216,131, 60,147,142,240, 16,223, 41,  8,115,126,
230,193, 35,142,187, 18,  9,  8,103, 45, 61,234,204,126, 13,184,211,111, 79,204,
152,223, 22,224,255,101,196, 59,226,128,187,251,244,204,131, 71,144,103, 93,182,
105,214,170, 56,219,109, 87,228,129, 93,143,237,114,120, 22,  0, 73,128,194,212,
205, 28,194,  0,  1, 88, 27, 66, 26,203,247, 88, 99,  0, 37,102,230, 71,  5,240,
 79, 56,159,151,245,204,199,211, 30,202,168,183,181,196,166,105, 67,130, 41, 90,
116, 67,202, 97,  1,224, 13,131, 66,100,186, 68, 81,224,  6,
} ;

// ../Source/JitKernels/GB_jit_kernel_emult_02.c:
uint8_t GB_JITpackage_172 [271] = {
 40,181, 47,253, 96, 97,  1, 45,  8,  0,  6,144, 55, 33, 16,241, 54,150, 46, 98,
178,161,216,199,117, 98,249, 20, 72, 21,123,  4,226,228,191,236, 72,132,112, 52,
 30, 51,  2,  0, 80,  5, 51, 45,  0, 46,  0, 46,  0, 26,171,158,212,222,200,253,
206, 37, 55, 93,103, 40, 30, 93,  1,181,136,132, 35,112,176,188,250,104,165,240,
 14, 75,204,227,240, 69,253, 23,188,179,  5, 95,204,167,105, 74,211, 20, 10,  8,
157,188, 70, 63,249,155,147, 27,172,228,205,195,208,122, 68,168, 84,149, 10,  3,
170, 58,244, 61, 30,145, 89,227, 41,156, 90,223,128, 59,131,201,157, 71,156,205,
 46, 56,122,  1, 16, 92, 41,220,101, 17,199,133,179,235,177, 93, 13,207,236,213,
 50, 12,119, 11,  6,190,216,164,104,149, 30,252,188,209,122,165, 63, 83,242, 22,
127,178,144,158, 20,255,203,153, 36,  9,115,118,166,193, 33,142,187, 44, 43,194,
225,171,177,199, 69, 93,238,215,128,143,254,246,194, 17,243, 27,  3,252, 39,101,
248,137, 57,224,238, 62, 57,211,224,208,227, 90,167,109,  1, 12,  0, 73, 69,206,
 46,  2,  4, 96,  1,  8,105,244, 91,167,137,201,212,160,249,243,204, 20,109, 11,
 91,205, 21,  6, 49,255,124,181,162,192, 13,
} ;

// ../Source/JitKernels/GB_jit_kernel_emult_03.c:
uint8_t GB_JITpackage_173 [270] = {
 40,181, 47,253, 96, 97,  1, 37,  8,  0,  6, 80, 55, 33, 16,241, 54,150, 46, 98,
178,161,216,199,117, 66,237,117, 72, 18,123,164,226,228,191,172, 55, 34, 28,141,
199,140,  0,  0, 84,193, 12, 45,  0, 46,  0, 46,  0, 58,179,222,212, 95,217,253,
206,103, 71, 93, 95, 36, 14, 93, 65,181,  7, 68, 35, 96,184,220,  2,107, 53,225,
 61,158,150,199,227,147,250, 43,120,103, 10,190,153, 75, 18,141, 36, 41,137, 71,
 13, 31,163,223,124,206,205, 45, 78, 50,231,227,104, 29,170,168,137,138,  8,131,
137,242,  7,116, 28, 50, 51,230, 75,120,181,158, 17,247,197,146, 61,135, 58,171,
 93,177,252,  2, 15, 92, 77,216,211, 32, 13, 12,107,152,131,195, 24,174,217,187,
105, 25,246, 20, 11,124, 51, 58, 85, 42,122, 17,252, 74,235,150,254, 44,201,155,
252, 80, 17,189, 73, 62,152,181, 40, 18,148,110,104,193,159,174,195,174, 11,210,
225,171, 51,199, 73,125,238,215,  0,176,254,254,198,210,242, 27,  3,252,195,115,
  4,201, 28,112,119,167, 26, 90,240,199,241,205,219,184, 12,  0, 73, 69,206, 46,
  2,  4, 96,  1,  8,105,244, 91,167,137,201,212,160,249,243,204, 20,109, 11, 91,
205, 21,  6, 49,255,124,181,162,192, 13,
} ;

// ../Source/JitKernels/GB_jit_kernel_emult_04.c:
uint8_t GB_JITpackage_174 [270] = {
 40,181, 47,253, 96, 97,  1, 37,  8,  0,  6, 80, 55, 33, 16,241, 54,150, 46, 98,
178,161,216,199,117, 66,237,117, 72, 18,123,164,226,228,191,188,160, 96, 56,160,
158, 25,  1,  0,168,130, 25, 45,  0, 46,  0, 46,  0, 58,179,222,212, 95,217,253,
206,103, 71, 93,103, 40, 30, 93, 65,181,  9,197, 35,128,184,220,  2,107,129,194,
123, 60, 49,143,199, 39,245, 95,240,206, 22,124, 51,159, 38, 42, 77, 83,139, 72,
 13, 95,163,223,124,206,205, 45, 86, 50,231,227,104, 61, 34, 84, 84, 37, 25,  6,
 84,229, 16,248,120,100,102,205,183,240,106,125, 35,238, 12, 38,123, 30,117, 86,
187, 98,249,  5, 17, 92,160,176,167, 73, 30, 24,214, 48,  8,135, 57, 92,179,119,
211, 50,236, 49, 26,248,102,148,170,149,244, 34,248,149,214, 45,253,153,146, 55,
249, 33, 67,122,147,124, 48,107,210, 36,148,118,232,193,161,174,195,174, 75,210,
225,171,179,199, 73,125,238,215,  0,176,254,254,198, 18,243, 27,  3,252,195,115,
  4,201, 28,112,119,167, 28,122,112,232,241,205,219,184, 12,  0, 73, 69,206, 46,
  2,  4, 96,  1,  8,105,244, 91,167,137,201,212,160,249,243,204, 20,109, 11, 91,
205, 21,  6, 49,255,124,181,162,192, 13,
} ;

// ../Source/JitKernels/GB_jit_kernel_emult_08.c:
uint8_t GB_JITpackage_175 [260] = {
 40,181, 47,253, 96, 93,  1,213,  7,  0,194,207, 52, 33, 16,179, 30,150, 12,146,
 15, 40,128,167,156,  7, 17,206,188, 42,154,214, 21,219,173,231,187, 98,223, 46,
252,136,  0,  0,170,106,  6, 49,142, 98,194,  5,214, 98,141,134,197, 94,170, 51,
201, 63, 29,238,215,  0, 44,185,253,157, 11,240,199,132, 30,254,114,192,221, 61,
138, 98,194,  5,146, 83, 54,138, 86,185,  7,235,110,213, 34,193,110,197, 38, 26,
 22,241, 58, 41,165,102,119,123, 64, 46,205,162, 37, 47,234, 59,204,125,166, 35,
244,231, 76,222,223, 99, 30,212,131,223,227, 92,169,139,163, 34, 49, 15,210, 15,
190,230,224,238, 52, 89,115,207,155, 62, 21, 46,235,162, 12,  4,235,114,  1,150,
124,  2, 51,136,115,184,156, 30,234,182,167,147, 55,159,236,172,180,251,112, 58,
 67, 60,168,185,143,253,157, 67, 27, 93,123, 50, 62,209,129,156, 11,134, 36,160,
104, 56,  2,203,131,117,183, 23,118,254,122,255,233,231,220,157, 55,151,102, 94,
 85,145,170,170, 12,  0, 69,  5,207, 46, 34,  4, 96,  1,  8,105,244, 91,167,137,
201,212,160,249,243,204, 20,109, 11, 91,205, 21,  6, 49,255,124,181,162,192, 13,

} ;

// ../Source/JitKernels/GB_jit_kernel_emult_bitmap.c:
uint8_t GB_JITpackage_176 [357] = {
 40,181, 47,253, 96, 43,  2,221, 10,  0, 54, 85, 70, 33, 16,211, 54, 54,143,197,
236,180,158,161,201,197, 46, 64,213, 60,231,253,228, 40,221, 90,184,113,228, 93,
141, 17,  1,  0,168,170, 25, 60,  0, 61,  0, 62,  0,254,  1, 55, 39,196,157, 71,
156,149, 81,112,180, 26, 75, 60,169,237,200,253,198, 37, 55, 93,115, 62,143, 40,
 97,178, 24, 13, 45,176,112,120,226, 78,163, 13, 55,198,212,157,203,240,107,126,
 81,255,166,110,172,169, 20,115,138,154, 18, 69,  5,144, 72,165,216, 44, 76,149,
244,224,181,163,229,  9,253,248,195, 91,124, 15, 34, 61, 41,254,197,153,116,121,
 84, 38,239, 59,250,201,223,156,220, 96,  6,111,158,179,229,209,161, 42, 84, 18,
194, 80,168,124,112,  5, 30,145,184, 99, 31, 62, 89,  1, 24, 41,114,240,190, 98,
249,249,230, 90, 76,206,246,250,254,140, 83,212,165, 65,186,137,101,251,222,251,
112,192,221,125,130,166,194,  7,  2,167,116,148,173, 82, 43,150,214, 65,104,237,
 50,139,118,213,236,154,108,151,196, 51,139, 82, 50,172,118,  1,115,134,166,194,
  7, 28,119, 57, 28, 22,174, 82,141,  9, 92,212,229,126, 13,184,211,111,155,199,
240,119,165, 24,192,223, 43,243, 21,231,135, 61,241, 21,222,144,234, 39,244,201,
240,175,126,230,128,158,170,127,111,123,201,170, 85, 26, 22,  0, 77,  9,169,146,
 28,148,179, 92, 90, 54,136, 71, 16,160,176,184, 11,111,224, 92,226,199,134,115,
234, 90, 65,  9,238,185, 91,128,196, 39,129,210, 88,145,158, 49, 38, 83,131,230,
207, 51, 83,180, 77,108, 53,151, 24,148,201, 80,220, 86, 20,184,  1,
} ;

// ../Source/JitKernels/GB_jit_kernel_ewise_fulla.c:
uint8_t GB_JITpackage_177 [265] = {
 40,181, 47,253, 96, 93,  1,253,  7,  0,  6, 16, 55, 33,  0,211, 60,126,207, 18,
 79, 68,206,199,  8,120,213,221,164, 10,182,185,135, 42,204,252, 29, 70,160,120,
108,150,254,223,235, 67,  8, 44,  0, 46,  0, 46,  0,149,126, 97,167, 55,236, 69,
221,133,246, 55, 30,173,164,130,233,  7,129,103,142,121, 84,151,243, 88,185, 47,
 98,206,223,252,160,126,204,221,248,114,233,230, 85, 37,167,170, 10, 30,174,211,
  4,241,160, 40,191,209, 47, 62,231,226,254, 44,152,243,156,167, 75,132,203,186,
166,194,192,186, 60,242, 32,151, 68,188,233, 16, 78, 77,239,124, 91,147,193, 16,
151,236, 12, 14,238,113,103,173,145,196,213,172, 66,162,221,170, 53, 56,141,225,
117, 82, 71,221, 46, 68,177,184,116,147, 22,117, 77,255,121, 93, 56, 29,211,143,
 43,120,131, 79, 81, 76, 47,130, 31, 82,126,164,193, 35,107,181, 44,139,216, 75,
245,  6, 57,168,199,253, 26,224, 81,191,187, 28,102,126, 95,186,  1,252, 41, 99,
246, 64, 28,112,119,151, 30,105,240,  8,114,  7, 36, 10,  0, 76,133, 20,121,185,
176, 33, 36, 39,221, 58,120, 76,166,  6,205,159,103,166,104,243, 99,181,242, 62,
160, 69, 81,224,  6,
} ;

// ../Source/JitKernels/GB_jit_kernel_ewise_fulln.c:
uint8_t GB_JITpackage_178 [257] = {
 40,181, 47,253, 96, 92,  1,189,  7,  0,242, 15, 53, 33, 16,241, 54, 54,220,197,
  4,107,254, 26,197,  9,229,213,172,201,232, 18,206,225, 55,234, 56,126,128, 67,
 61, 51,  2,  0, 80,  5, 51,115,118,166,193, 33,107,181, 44,123,216, 75,245,246,
184,168,203,253, 26,  0, 78,191,191, 60, 94,126, 95,186,  1,252, 37,101,  6, 69,
 28,112,119,159,156,105,112,232,241,206,209,121,141,203,168,245,145,184,154,229,
 32,218,173, 26,195,211, 22, 94, 49,218,213,237, 58, 56,197,165,219,172, 38, 75,
250, 16,252, 70,204, 47,253,120,130,183,248, 18, 78,122, 82,124, 16, 87, 41,130,
104, 76,146,207,232, 39,223,115,114,135, 20,236,121,206,152, 71,  4,171,178,164,
194,160,178, 28,  2, 31,143, 72,156,249, 16, 62, 97,190,  9, 55,230,130, 29, 30,
 89,172,210,112,252,244,118, 61,169,191,209,254,198,165,157, 84,128,249,193, 51,
191,192, 73,204,185,156,220, 39,177,230,111,126, 81,191,229,110, 92,185,116,115,
138,154, 18, 69,  5, 10,  0, 76,133,244,120,185,176, 33, 36,231,220, 58,120, 76,
166,  6,205,159,103,166,104,235, 99,181,113, 62,160, 69, 81,224,  6,
} ;

// ../Source/JitKernels/GB_jit_kernel_reduce.c:
uint8_t GB_JITpackage_179 [1307] = {
 40,181, 47,253, 96,149, 12,141, 40,  0,198,123,182, 41,192,208,108, 14, 42,213,
238,181,201, 26,137, 85, 64,176,119,162,220,185,101, 95,213, 70,142,159,251, 48,
 63,202, 78,221, 57,195,150,211,239, 42, 10,213, 85,  0,  2,163,  0,162,  0,185,
  0,116,156,245, 98,135, 31,123,201,  6, 51,173, 95,165, 77,226,227, 58,214,175,
189,219, 75,167,120, 48, 87,208, 59,172,223, 41,132,224,243, 56,211,242,102, 60,
 90,250,219,162,175, 54,200, 73, 18,  8,229,209, 32,157,164,245,202,237,250,213,
 60,182,151, 61, 26,143, 77,107,230, 33,113,113, 32, 94,107,220,198,221, 57,206,
224, 69,237, 60, 12,173, 87,  6, 20,  9,229,145, 48,145, 80, 78,209,233, 21,174,
 26,243, 58,196,186,  8,204, 86,172,220,171,205,202, 88, 64,114, 94, 76,165,241,
157,228,214,185,150,155,116,103, 56, 41,190,205, 31,109,205,191,246,251,185,204,
225, 21, 10,105, 90,122,125,187,176,199,219, 25, 93,174, 24,157,  5,243, 72, 68,
122, 68, 34,  1,228,244, 10,  0,  8, 64, 33,149, 14, 73,113,134, 90,146, 42,215,
134,158, 55, 31,134, 21,116,177,106,220,226,255, 23,133,163,237,112, 30, 91,236,
190, 26, 32, 73,144, 10,194,184, 67,239,206,139,190,175,188, 14,143, 69, 19, 20,
206,227,250,133,141,115,205,165,189,157, 95,225, 10,102,175, 12,233, 88,  3, 62,
 78,175, 67,251,189,239, 60, 22,203,177, 69,222,113,125,123,150, 30,114,101,218,
 70,211,116,  7,  8, 28,134,110,243,100, 56,157,229, 94,140, 21,151,175, 68,114,
138,185,142,245,161,122,115,105,189,207,127,246,239, 92,146,162,165,207,179,130,
160, 87, 32, 27,246,167,162,124, 62,223,132, 82,186,140, 51,121,155,134,250,120,
 30,164, 37,126,213,  1, 96,195,116,130, 83, 25,211,116,106,236, 80,163,202,168,
 72,107,122, 38,227, 97,152,156, 99,105,176,173, 99,113, 54,201,223,105,232,182,
172,171, 88, 22,100,197, 67,214,201, 42,100, 93, 27, 14,195,120,222,236,104, 21,
109,158,221,244, 74,186,201,184, 76,230,177, 46,207,133,163,209,186, 75,166,209,
 56,235,  0,225, 27,151, 89, 54,147, 71,104, 25,134, 14,  6,161,105, 27, 76, 70,
141,170,130,233, 27, 45,227, 46,158, 11,235,116,151, 38,219, 58, 75,131,177, 58,
 28, 73, 72, 50, 57,198, 77, 88, 54,171,129,219, 54,218,165,147, 80,163,105,130,
203,184, 13,118,101, 29,214,177, 50, 23,236, 18,125,161,  0,227,172,139,227,161,
 68,211, 11, 78,133,166, 47,124,116, 74, 84,133,170,209,116, 93, 22,198,153,224,
 58,138,138, 87,237,104, 69,170,194,101, 24,146,212, 33, 41,156,218, 54,236,114,
241,108,211,199, 91,230,190,159,173, 70,  3,175,166,139, 72, 42,182, 56,234, 14,
128,201, 23, 22, 38, 14,142,175,  6, 52,157, 36,206,184, 54, 34,130,128,202, 97,
137,251,158, 34,152,254, 75, 27,146,194,169,233, 26,167, 97, 29,236,225, 25,203,
162,101, 48, 93,223,  6,171,  7,209,181,153, 78,  6, 92, 31,125, 73, 48,219, 15,
 46, 69, 92,164,233, 45,237, 22,249, 88,127,103,147,228,164, 16,111,156,239, 58,
155,113,158, 33, 41,118,190,  5,101, 92, 89, 92, 31,163, 29, 63,191,234,141, 29,
 64,187,  9,226,142, 98,240, 12,182,177, 42, 61,170,120,146, 11,159,167, 44,174,
213,156,230,156, 44,202,134,101, 22,141, 70,161,125, 44,178,250, 88,  4,200,170,
102, 85,128,240,168, 49, 45, 98,202,208,204,140, 36, 41, 72,161,208, 24, 32,132,
 16,227, 84, 25, 61, 50,161, 60, 11, 37, 78, 33,  1, 49, 68, 33, 36, 52, 34,146,
 52, 37, 41,169, 81, 56,210,138,113, 51,151,138,224,207,128,112,244, 92,110,135,
188, 49,192,179,216,186,111,  2,182,189,239, 20,162,  5,150, 25,222, 82,191,190,
 42,142,127, 66,138, 54,163,138,191,130,162,155, 70,138, 63,112,195,252,218,157,
  5,211,124,226, 38, 20,164,177, 91,105,177,193,  9, 20,216, 22,167,141, 83, 75,
251,211,130,133, 23,240, 99, 87,158,160, 73,186, 26,243,144, 59,230, 31,248,  9,
102,100,121,101,245,204,193,  0,143, 73,  8,202,193, 25,226,122,130, 77, 23,181,
213,100, 88,  4,233, 55, 65, 54,243, 11, 20, 50,111, 17,133, 92,154,196, 29,  4,
120,140,192, 12,192, 43,158,113, 37,  0,247,120,149,239,183,144,244,143,110, 57,
 29, 12, 48,194,112,210, 50,238,101,146,180,165,147,252,  0, 32, 82,137,  8,125,
137,172, 98,219,221, 85, 10, 68, 72,196, 87,112, 74,200,200, 27, 62,220,  8,110,
120,187,125,130,118,212,204,223,245,143, 46,  0,208,176,219,111,144, 87, 13, 18,
160,136, 44, 96,186,120,175,122, 21,184, 32, 30,120, 96,149,135, 10, 64,161,149,
130,132,184, 14,111, 68,150,150,207, 26, 20,246, 66,112,197,177,192,218, 90,134,
143, 64,212, 88,216, 14,  4,150,239, 30,237,107,102,  8,163, 17, 18,203,181,181,
181,174,135,120,184,205,229,188,178,252, 30, 11,129, 25,152,134, 80,  5,231,116,
 93,255,193, 12,161,200,184,159, 35,250, 96,213, 77, 33,195,248,235, 25,225, 59,
166,245,157,134, 23,  3,174,112,135,  0,251, 37,178,132,  0, 48,227,207,189,171,
223,232,225,152,220, 58,167, 71,167,  1,111,129, 23, 61,131,214,201,114,214,  6,
 80, 79, 52,177,244,165,216,192,248,139, 52,201,  3, 42,198, 97, 41, 82,125, 33,
 20,183,162,164, 87,159,157,237, 63,223,101,221,155,100,212,199,106, 97, 97, 87,
130, 36, 71, 14, 93, 64,192,183,  8,244,232,137,100, 13,  8,129,249,174,  1,110,
 63,202, 72,144,209,194,125,103, 44,143,241,169, 45,235, 72,195,138, 67,198,244,
248,135,145,214, 22,200, 69, 64, 26,162,179, 40,231, 60,209,197, 49,140, 65,248,
164,  0,139,160,199, 18,163,174, 91,142,222, 24, 86, 60,172,116, 35,143,104,194,
 37, 17,167,168, 91, 19,170,215,244,181,143,141, 77,146,117, 69,239,100,130, 92,
196, 23, 13,210,176, 49,224,166,249,254,204,164, 53, 57,107,112,201,125,242,120,
  4,242,253,235,  1,132,  1,
} ;

// ../Source/JitKernels/GB_jit_kernel_rowscale.c:
uint8_t GB_JITpackage_180 [286] = {
 40,181, 47,253, 96,116,  1,165,  8,  0, 86,145, 58, 33, 32,179, 27,179,251,172,
125,126, 51, 53, 50,201, 85, 31,241,241, 95,  8,165,171,  6,186,191,145, 33,130,
206, 50, 32,  4,  7,  0,  2, 48,  0, 49,  0, 50,  0,142,219,109,  6,124,220,180,
 47,  7,211, 33, 27,126,182,157,175, 65,127, 51,253,250, 34, 52, 24, 88, 43,234,
228,150, 86,252,225,220,105, 29,188,190,153,249, 53,243,210,154,162,162, 68, 81,
  1, 56,123,153,239,218, 90,171, 11,136,202, 80, 73,137,131,161,234, 65, 21,116,
  1,191,135, 54,122,178, 58,228,101,206,247,147, 46, 72,107,187,188,144, 94, 77,
225,248,210, 80,122,254,142,140,247,191,178,194,117,115,203, 34, 93,  6,233,205,
186,184, 77,155, 19,199, 99, 94, 90, 52, 76,149,228, 94,165,161,213,138,235,143,
249, 12,250,197, 33, 57,  6,189,254, 38, 89, 26,146,233,226,158,235,216,187, 14,
 49,142,226,162,  7, 82,102, 24, 70,145,243,186,224,237,100,191,128, 58,121,166,
 54,252, 60, 79, 64,251,165, 99, 43,248,129,238,238, 40,138,139, 30,  8,154,155,
112,157,100,102,155,133,  5, 13,  0, 70,128,146,244,166,248, 34, 64,  0, 22,128,
144,198,200,117,154,152, 76, 13,154, 63,207, 76,209,230,177,213,188, 99, 80,102,
184,  0, 81, 81, 48,  4,
} ;

// ../Source/JitKernels/GB_jit_kernel_select_bitmap.c:
uint8_t GB_JITpackage_181 [319] = {
 40,181, 47,253, 96,195,  1,173,  9,  0,214, 82, 63, 33,  0,145,117, 62, 79,  3,
218,207, 30,  3,165, 68,193,149,136, 51,228,  9,251, 52, 69,251, 98, 25, 50,231,
204,210,255,235,245, 33,  4, 53,  0, 54,  0, 54,  0,213, 55, 99,206, 96,240,247,
129, 87,105,214,104,130, 39,134,104,244,  4, 77,175, 51, 78,189,250, 47, 99,252,
 63,194,  4, 49, 25, 79,110, 14,155,108,244,146, 93,158,125,185, 25, 91,174,133,
125,154,106, 52, 77,  1, 84,212, 99,  8,154,213, 17,103, 99, 10,206,101,139, 89,
212,104,217, 33,214,162,200,197, 73, 98,107,206, 70,187, 59,154,199, 10,238, 78,
146,213,  7,  6,138, 64, 69,135,  2,129, 58, 20, 62, 31,160, 88,  3, 94,151,  2,
150,147,124, 87, 34,185,143,237,122,215,195,114,246,162,224,192,255, 87, 78, 77,
 28,122,190,125, 91,199, 93,174,114,124,153,117,191,133,213,172,119, 53,251,232,
108,227, 90,101,109, 26,118,191,140,113, 45,172, 18,164,181,118,106,226,144,231,
217,197,  2,226, 93,235,196,158,151,103,154,251,  4,132, 82,103,144, 52, 49,157,
175,133,  1,222, 98, 74,134, 37,  5,139,101, 39, 14, 93,202,116,204,155, 67,130,
231, 17, 92,241,205,  3, 19,  0, 78,  9,137,133, 72, 36,133,211, 71,192,  9,205,
213,155,  6,118, 90,250,106,161, 22, 33, 13, 14,215,113, 98, 50, 53,104,254, 60,
 51, 69,219,195, 86,115,135, 65,140, 41,252,192, 16,154, 57, 60, 69,193, 16,
} ;

// ../Source/JitKernels/GB_jit_kernel_select_phase1.c:
uint8_t GB_JITpackage_182 [394] = {
 40,181, 47,253, 96,107,  2,  5, 12,  0,102,215, 75, 33, 16,211, 54,134, 15,196,
236, 53, 67,137,207,  4,211,246,129, 47, 33, 34,189,  8,250,110,245,191,219,249,
 87, 17,  1,  0,168,210, 25, 65,  0, 68,  0, 65,  0, 85,193,224,210,141,124, 48,
226, 79,231,112,130,229, 37,184, 61, 29,204,249,160, 90,217,  5,138,157,198, 18,
 63,234, 78,172,191, 49, 89,167,115,144,136, 87,238,238,137,234,199, 14, 20,237,
190, 31,254,104,195,207,250, 57,118,227,141,189, 48,167,168, 57, 81, 84,214, 67,
179, 92,131,102,180,218,140, 82, 54, 42,241,204,186, 42, 25,102, 57, 72,196, 94,
216, 44, 16, 12,211,131,183, 19, 45, 79,232,199, 31,222,249, 61,200,244, 99,254,
139,179,233,226,208,  8,222,127,244,143,191,249,184, 65, 13,222, 60, 12, 45, 31,
 28, 12,  5,195,132,  8, 94,126,133, 51, 38, 91,118,124, 46,252,179,213,107,244,
119,236, 95, 28,142,150,243,238, 62,199,236,193,251,102,242,115,206,237, 50, 97,
216, 93,223,175,113,138,162, 19,  8, 71,177,108,223,123, 31, 14,184,187, 79,208,
 84,184, 20,121,133,171,108,154,173,104, 13,115,134,166,194,165, 90,105,163, 97,
169,246,210, 88,228, 89,147,251, 53,224, 18,126,119,161,216,249,109, 75,189,243,
 95, 24,192,223, 35,195,155, 37, 78, 38,193, 93,186, 36,136, 34,129, 47,188,116,
170, 97, 56,139,193, 88, 74,197, 86,  7,133,106,212, 49, 63, 28, 29, 32, 48,132,
  8,206, 44,118,212, 68,162,150, 89, 59, 75,  4,155,129,233,131,208, 91, 17,164,
220,190,128, 84, 46, 24,  7, 71,130, 32, 76,248,169,100, 80, 70,226,228,138, 54,
 92,123, 13,  1,241, 91, 84,105,128,184,227,132,153, 26, 52,155,103,166,219, 32,
173,230, 15, 67,172, 53,238, 27,211,  4, 70, 20,  5,110,
} ;

// ../Source/JitKernels/GB_jit_kernel_select_phase2.c:
uint8_t GB_JITpackage_183 [336] = {
 40,181, 47,253, 96,239,  1, 53, 10,  0,134,211, 64, 33, 16,241, 54,230,113,200,
133, 61,140,215,215,  9, 45,121,142,201, 50,248, 12,120, 95,139, 89,167,237, 98,
217,136,  0,  0, 84,193, 12, 53,  0, 55,  0, 55,  0,148,111,194,141,185,224,206,
  7,150,202,170,144,244, 50,134,120,157, 61,210,254,198,165,157,222, 49, 26, 78,
221,221, 17,244,181, 23,146,119,127, 47,190,190,226,143,249, 45,119,227,202,173,
 48,159,166, 25, 77, 83,  4,137, 70, 31,126, 30, 73, 57, 34, 63,158,224, 61, 62,
200,136, 94,143,255,225, 44,138, 92,155,  4,126, 38,191,126,206,245, 14, 41,152,
115, 81,164,124, 96,160,  4, 26, 29, 10,  4,234,208,247,248, 64,227,140,119,185,
 20,152, 11, 61,174,112,141,229,251,195,121,235,207,  2,175,155,164,187,148,187,
 79,206, 76, 56,244,184,214,105,220,118,105,181,212, 98,187,157, 85,179,106,111,
 86, 31, 92,117,120, 70, 85, 90,134,221,142,209,184, 21, 54,  3,115,118,102,194,
 33,107,171,101, 65,236,173, 50,246,248,152,203,253, 25,240, 73, 21,  6,240,  7,
 75,241, 27, 39, 24, 28, 31,178,140,101,184, 55,207, 35,112,133,111, 36,146,251,
208,174,189, 30,117,171,215,  4,  7, 18,190,203, 24, 32, 80, 66,100, 91,  7, 69,
  8, 35, 76, 18, 73,157, 62,124,102,240,  0, 65,216,227, 62,164,180,141,113,115,
149,  5,238,214,218, 46, 40, 45,162, 52, 64,244, 56,129, 76, 13,154,207, 51, 19,
218, 32, 94,205, 31, 70,172, 13,183,198, 52,194,136,162,197, 13,
} ;

// ../Source/JitKernels/GB_jit_kernel_split_bitmap.c:
uint8_t GB_JITpackage_184 [331] = {
 40,181, 47,253, 96,205,  1, 13, 10,  0,230, 83, 65, 33,  0,211, 60,238,110, 65,
100, 93, 69,167,  9, 54, 71,246, 92,144, 33,233,162,171,139,249, 27,238,174,142,
108,255,255,247,250, 23,  2, 54,  0, 56,  0, 56,  0,222,  9,119,  6,115, 61,159,
 29,205,172, 48, 91,141, 25,126,212, 54,119,191,175,166,147,151, 63,190,219,122,
102,139,215,169,187, 27,178,197,236, 59,193,121,172,248, 69,253,151,186,175,165,
 90,152, 83,148,148, 40, 42, 82, 48, 85,210,135,159,205,212, 13,250, 47,229,110,
241,193,133,244,163,248,223,205,164, 72, 98,155,192,223,232, 31,159,243,113,135,
149,203, 57,198,212, 39,161, 18, 84, 82, 97, 32,168, 60,250, 32,159,227,221,216,
132, 79, 52, 15, 78,209,240,140, 90, 90,134, 85,111,193,144, 50,234,248,180,248,
188, 62,127,196,150,226,147, 82,247,201,185, 32,223,180,  7, 36,162,121, 94, 25,
146,108,218,245,226,165, 60, 24,144,145,229, 90,200,115,198, 17,110,185, 95, 82,
126,228,193,163,174, 83, 92, 23,164,171,150,198, 32, 23,181,102,191,  6,124,211,
111,139, 51,230,119,  5,248,131, 26,252,137, 55,224,238, 46, 61,242,224, 17,228,
154,167,113, 91,221,168,195, 91, 88,217,214,213, 76, 17, 21,  0, 77,  9,121, 67,
112, 32,  0,139, 68, 72,131,248, 58, 20, 76,128, 98,102, 94, 83,192, 86,  2,124,
 19,144, 76,120,121, 20,180, 77,243,231,153, 41,218, 48,182, 90,191, 24,100,102,
190,  3,120, 99,182, 60, 76,128, 41, 10,134,
} ;

// ../Source/JitKernels/GB_jit_kernel_split_full.c:
uint8_t GB_JITpackage_185 [330] = {
 40,181, 47,253, 96,193,  1,  5, 10,  0,166, 19, 65, 33, 16,209, 60,230,145, 19,
194,135,159,176,  6,108,140,139,  4,  9,101,127,150, 85,235,152,229,166, 47,154,
234,136,  0,  0,170,106,  6, 54,  0, 56,  0, 55,  0,212, 55,223,190, 88, 48,196,
231, 70,107,245,233, 43, 94,134, 31,197,171,183,223, 24,179, 73,203, 63,227,125,
253,178, 67,236,212,221, 13, 57, 99,188,172, 71,155, 63, 20,191, 98, 55,  6,109,
117,249, 52,201,104,154,  2, 82, 32, 81,209,127,220,213,212, 13,226, 99, 15,239,
240, 59, 70,244, 99,248, 28,174,145, 36,145, 73,221,103,196, 31, 95,243,113,127,
 20,172,121,206,212, 39,129, 18, 80, 81, 97, 32,160, 28,226, 30,159, 35,206,220,
132, 75,  1,154,194,225,149, 86, 88,189, 44,132,209,144, 18,218,248,  4,125, 98,
159, 63,230,235,249,164,212,125,106,172,199, 51,236, 17,129,168,158,150,126, 38,
 25,102,125,136,189,239,  2, 18,  2,241,125, 92, 95, 28,225, 32,230,  2, 82,118,
228,193,161,109, 83, 88, 86,100,179,149,120, 61, 30,138,152,253, 34,128,147,126,
223,172, 45,191, 45,192,191,195,100, 46,196,  1,119,119,201,145,  7,135, 30,199,
 32,152,150,217, 90, 35,139,154,109,182, 42, 30,  1, 21,  0, 75,137,108, 33, 54,
 16,128, 37, 33,164,161,189,142,  4, 19,160,152,153,215, 20,176,149,  0,223,  4,
 36, 19,222, 28,  5,109,211,252,121,102,138, 54,137,173,214, 35,  6,153,152,120,
192,238, 75, 91,194,  4,152,162, 96,  8,
} ;

// ../Source/JitKernels