/*
 * Copyright (C) 1998 The XFree86 Project, Inc.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * XFREE86 PROJECT BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the XFree86 Project shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in this Software without prior written authorization from the
 * XFree86 Project.
 */
#ifndef _SESSION_H
#define _SESSION_H
#include <X11/SM/SMlib.h>

extern void ConnectToSessionManager ( char *previous_id );
extern void DieCB ( SmcConn smcConn, SmPointer clientData );
extern char * GetClientID ( Window window );
extern int GetWindowConfig ( TwmWindow *theWindow, short *x, short *y, unsigned short *width, unsigned short *height, Bool *iconified, Bool *icon_info_present, short *icon_x, short *icon_y, Bool *width_ever_changed_by_user, Bool *height_ever_changed_by_user );
extern char * GetWindowRole ( Window window );
extern void ProcessIceMsgProc ( XtPointer client_data, int *source, XtInputId *id );
extern int ReadWinConfigEntry ( FILE *configFile, unsigned short version, TWMWinConfigEntry **pentry );
extern void ReadWinConfigFile ( char *filename );
extern int read_byte ( FILE *file, unsigned char *bp );
extern int read_counted_string ( FILE *file, char **stringp );
extern int read_short ( FILE *file, short *shortp );
extern int read_ushort ( FILE *file, unsigned short *shortp );
extern void SaveCompleteCB ( SmcConn smcConn, SmPointer clientData );
extern void SaveYourselfCB ( SmcConn smcConn, SmPointer clientData, int saveType, Bool shutdown, int interactStyle, Bool fast );
extern void SaveYourselfPhase2CB ( SmcConn smcConn, SmPointer clientData );
extern void ShutdownCancelledCB ( SmcConn smcConn, SmPointer clientData );
extern int WriteWinConfigEntry ( FILE *configFile, TwmWindow *theWindow, char *clientId, char *windowRole );
extern int write_byte ( FILE *file, unsigned char b );
extern int write_counted_string ( FILE *file, char *string );
extern int write_short ( FILE *file, short s );
extern int write_ushort ( FILE *file, unsigned short s );
 
extern SmcConn smcConn;

#endif
