/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform.hsqldb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TableChange;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;

public class HsqlDbBuilder
extends SqlBuilder {
    public HsqlDbBuilder(Platform platform) {
        super(platform);
        this.addEscapedCharSequence("'", "''");
    }

    public void dropTable(Table table) throws IOException {
        this.print("DROP TABLE ");
        this.printIdentifier(this.getTableName(table));
        this.print(" IF EXISTS");
        this.printEndOfStatement();
    }

    public String getSelectLastIdentityValues(Table table) {
        return "CALL IDENTITY()";
    }

    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, Map parameters, List changes) throws IOException {
        TableChange change;
        Iterator changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            TableChange change2 = (TableChange)changeIt.next();
            if (!(change2 instanceof RemoveColumnChange) || !((RemoveColumnChange)change2).getColumn().isPrimaryKey()) continue;
            return;
        }
        ArrayList<TableChange> addColumnChanges = new ArrayList<TableChange>();
        Iterator changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = (TableChange)changeIt2.next();
            if (!(change instanceof AddColumnChange)) continue;
            addColumnChanges.add(change);
            changeIt2.remove();
        }
        changeIt2 = addColumnChanges.listIterator(addColumnChanges.size());
        while (changeIt2.hasPrevious()) {
            AddColumnChange addColumnChange = (AddColumnChange)changeIt2.previous();
            this.processChange(currentModel, desiredModel, addColumnChange);
            changeIt2.remove();
        }
        changeIt2 = changes.iterator();
        while (changeIt2.hasNext()) {
            change = (TableChange)changeIt2.next();
            if (!(change instanceof RemoveColumnChange)) continue;
            RemoveColumnChange removeColumnChange = (RemoveColumnChange)change;
            this.processChange(currentModel, desiredModel, removeColumnChange);
            changeIt2.remove();
        }
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn());
        if (change.getNextColumn() != null) {
            this.print(" BEFORE ");
            this.printIdentifier(this.getColumnName(change.getNextColumn()));
        }
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change) throws IOException {
        this.print("ALTER TABLE ");
        this.printlnIdentifier(this.getTableName(change.getChangedTable()));
        this.printIndent();
        this.print("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()));
        this.printEndOfStatement();
        change.apply(currentModel, this.getPlatform().isDelimitedIdentifierModeOn());
    }
}

