/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.exceptions;

import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.messages.ErrorMessages;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class InternalErrorException
extends CliCommandoException {
    String realReason;

    public InternalErrorException(String realReason) {
        super(ErrorMessages.ErrorCode.INTERNAL_ERROR, new String[0]);
        this.createDebugInfo(realReason, this);
        this.realReason = realReason;
    }

    public InternalErrorException(String realReason, ErrorMessages.ErrorCode errorCode, String ... arguments) {
        super(errorCode, arguments);
        this.createDebugInfo(realReason, this);
        this.realReason = realReason;
    }

    public InternalErrorException(String realReason, Exception e) {
        super(e.getMessage(), ErrorMessages.ErrorCode.INTERNAL_ERROR, new String[0]);
        this.createDebugInfo(realReason, e);
    }

    public String getRealReason() {
        return this.realReason;
    }

    private void createDebugInfo(String message, Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println(message);
        ps.println(e.getMessage());
        e.printStackTrace(ps);
        ps.flush();
        ps.close();
        this.setDebugInfo(baos.toString());
    }
}

