/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.output;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ColumnConfig;
import amazon.fws.clicommando.config.OutputDescriptionConfig;
import amazon.fws.clicommando.config.OutputFormatConfig;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.processors.output.Printable;
import amazon.fws.clicommando.processors.output.PrintableRow;
import amazon.fws.clicommando.processors.output.PrintableTable;
import amazon.fws.clicommando.util.StringUtils;
import amazon.fws.clicommando.util.XmlUtils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PrintHelper {
    private String emptyElemValue = "";
    private static final int MAX_ENTRIES = 50;
    private ColumnConfig.ColumnListType columnsToDisplay;
    private String delimiter;
    private boolean useWSPadding;
    private Command command;
    private boolean trimExcessWS;
    private Document document;
    private Boolean showHeaders;
    private PrintableTable mainResults;
    private Map<String, String> resultCache = new LinkedHashMap<String, String>(50){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 50;
        }
    };

    public PrintHelper(Command command, ColumnConfig.ColumnListType columnsToDisplay, String delimiter, String emptyElemValue, boolean showEmptyColumns, boolean useWSPadding, boolean trimExcessWS) {
        this.columnsToDisplay = columnsToDisplay;
        this.delimiter = delimiter;
        this.emptyElemValue = emptyElemValue;
        this.useWSPadding = useWSPadding;
        this.command = command;
        this.trimExcessWS = trimExcessWS;
        this.mainResults = new PrintableTable();
    }

    public String createOutputForPrinting() {
        StringBuilder retVal = new StringBuilder();
        Printable.setDelimiter(this.delimiter);
        Printable.setUseWSPadding(this.useWSPadding);
        Printable.setTrimExcessTableNameWS(this.trimExcessWS);
        String cmdResult = this.command.getCurrentCommandConfig().getResponse();
        this.document = XmlUtils.getResultDom(cmdResult);
        OutputDescriptionConfig outDesc = this.command.getCurrentOutputDescriptionConfig();
        OutputFormatConfig outForm = this.command.getCurrentCommandConfig().getOutputConfig();
        NodeList targets = this.getElements(this.document.getDocumentElement(), outForm.getTarget());
        this.mainResults.addValue(this.createTable(outForm, targets));
        retVal.append(this.mainResults.print());
        if (StringUtils.isEmpty(retVal.toString())) {
            String emptyResult = outDesc.getEmptyResult();
            if (StringUtils.notEmpty(emptyResult)) {
                return outDesc.getEmptyResult();
            }
            return "";
        }
        return retVal.toString();
    }

    private PrintableTable createTable(OutputFormatConfig outForm, NodeList targets) {
        OutputDescriptionConfig outDesc = this.command.getOutputDescription(outForm.getDescriptor());
        PrintableTable table = new PrintableTable(outDesc, this.columnsToDisplay);
        this.showHeaders = Boolean.parseBoolean(this.command.getCurrentCommandConfig().getParameter("DisplayHeaders").getValue());
        if (this.showHeaders.booleanValue()) {
            this.addHeadersToResult(table, outDesc);
        }
        this.transformTargetRows(outDesc, table, targets, this.command);
        return table;
    }

    private NodeList getElements(Element element, String tagExpression) {
        NodeList retVal = null;
        boolean usedXpath = false;
        if (tagExpression.contains("xpath:")) {
            tagExpression = tagExpression.replace("xpath:", "");
            try {
                XPath xpath = XPathFactory.newInstance().newXPath();
                retVal = (NodeList)xpath.evaluate(tagExpression, element, XPathConstants.NODESET);
                usedXpath = true;
            }
            catch (XPathExpressionException e) {
                retVal = null;
            }
            catch (Exception e) {
                retVal = null;
                e.printStackTrace();
            }
        }
        if (tagExpression.contains("relative:") || !usedXpath || retVal != null && retVal.getLength() == 0) {
            tagExpression = tagExpression.replace("relative:", "");
            retVal = element.getElementsByTagName(tagExpression);
        }
        return retVal;
    }

    private void transformTargetRows(OutputDescriptionConfig outDesc, PrintableTable table, NodeList targets, Command command) {
        List<ColumnConfig> columns = outDesc.getColumnsByType(this.columnsToDisplay);
        if (targets == null) {
            return;
        }
        for (int i = 0; i < targets.getLength(); ++i) {
            if (!(targets.item(i) instanceof Element)) continue;
            boolean printRow = true;
            Element target = (Element)targets.item(i);
            PrintableRow newRow = new PrintableRow();
            for (int j = 0; j < columns.size(); ++j) {
                ColumnConfig column = columns.get(j);
                Element source = this.getDataSource(target, column, command.getCurrentCommandConfig().getResponse());
                String resColRow = this.getTransformedData(source, command, column.getType());
                newRow.addValue(resColRow);
                if (resColRow != null && !resColRow.equals(this.emptyElemValue) || !column.getNonEmpty()) continue;
                printRow = false;
            }
            for (OutputFormatConfig outForm : outDesc.getTables()) {
                NodeList childTargets = this.getElements(target, outForm.getTarget());
                PrintableTable newTable = this.createTable(outForm, childTargets);
                newRow.addValue(newTable);
                if (newTable.getRows().size() != 0 || !outForm.getNonEmpty()) continue;
                printRow = false;
            }
            if (!printRow) continue;
            table.addRow(newRow);
        }
    }

    private void addHeadersToResult(PrintableTable table, OutputDescriptionConfig outDesc) {
        PrintableRow newRow = new PrintableRow();
        List<ColumnConfig> columns = outDesc.getColumnsByType(this.columnsToDisplay);
        for (int i = 0; i < columns.size(); ++i) {
            ColumnConfig column = columns.get(i);
            newRow.addValue(column.getHeader());
        }
        table.setHeader(newRow);
    }

    private Element getDataSource(Element target, ColumnConfig column, String cmdResult) {
        Element source;
        NodeList sourceList = this.getElements(target, column.getSource());
        if (sourceList.getLength() == 0) {
            source = null;
        } else {
            if (sourceList.getLength() != 1) {
                throw new ConfigurationErrorException("Too many tags named '" + column.getSource() + "': try using a higher level target from the response: \n" + cmdResult);
            }
            if (!(sourceList.item(0) instanceof Element)) {
                throw new ConfigurationErrorException("Problem with column looking for tag '" + column.getSource() + "' in the response " + cmdResult);
            }
            source = (Element)sourceList.item(0);
        }
        return source;
    }

    private String getTransformedData(Element source, Command command, String typeName) {
        if (source == null) {
            return this.emptyElemValue;
        }
        String ret = "";
        if (typeName.equals("print")) {
            ret = source.getTextContent();
            return ret == null || ret.equals("") ? this.emptyElemValue : this.getQuotedString(ret);
        }
        String xmlString = XmlUtils.elemToString(source);
        String cacheValue = typeName + ":" + xmlString;
        if (this.resultCache.containsKey(cacheValue)) {
            ret = this.resultCache.get(cacheValue);
        } else {
            String xslt = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output method=\"text\" encoding=\"UTF-8\"/>" + command.getColumnHandler(typeName).getXsltSource() + "</xsl:stylesheet> ";
            if (xmlString != null) {
                StringWriter out = new StringWriter();
                StreamSource xmlSource = new StreamSource(new StringReader(xmlString));
                StreamSource xsltSource = new StreamSource(new StringReader(xslt));
                StreamResult result = new StreamResult(out);
                TransformerFactory transFact = TransformerFactory.newInstance();
                try {
                    Templates cachedXSLT = transFact.newTemplates(xsltSource);
                    Transformer trans = cachedXSLT.newTransformer();
                    trans.transform(xmlSource, result);
                    ret = out.toString();
                }
                catch (TransformerConfigurationException e) {
                    throw new InternalErrorException("Problem with the following: \nXML:\n" + xmlString + "\nXSLT:\n" + xslt, e);
                }
                catch (TransformerException e) {
                    throw new InternalErrorException("Problem with the following: \nXML:\n" + xmlString + "\nXSLT:\n" + xslt, e);
                }
            } else {
                ret = this.emptyElemValue;
            }
            this.resultCache.put(cacheValue, ret);
        }
        return this.getQuotedString(ret);
    }

    private String getQuotedString(String str) {
        if (str.contains(this.delimiter)) {
            return '\"' + str + '\"';
        }
        return str;
    }
}

