/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.security;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.CommandConfig;
import amazon.fws.clicommando.exceptions.BadInputException;
import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.messages.ErrorMessages;
import amazon.fws.clicommando.security.SignatureInfo;
import amazon.fws.clicommando.util.DateUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsSignatureHelper {
    private String serviceUrl;
    private String method;
    private Command command;

    public AwsSignatureHelper(String serviceUrl, String method, Command command) {
        this.serviceUrl = serviceUrl;
        this.method = method;
        this.command = command;
    }

    public SignatureInfo signParameters(Map<String, String> parameters, String accessId, String secretKey) {
        SignatureInfo signature = new SignatureInfo();
        signature.setQueryParameterName("Signature");
        String signatureVersion = parameters.get("SignatureVersion");
        String algorithm = "HmacSHA256";
        String stringToSign = null;
        if ("1".equals(signatureVersion)) {
            algorithm = "HmacSHA1";
            parameters.put("AWSAccessKeyId", accessId);
            stringToSign = this.calculateStringToSignV1(parameters, accessId);
            signature.setSignature(AwsSignatureHelper.sign(stringToSign, secretKey, algorithm));
        } else if ("2".equals(signatureVersion)) {
            parameters.put("AWSAccessKeyId", accessId);
            stringToSign = this.calculateStringToSignV2(parameters, accessId);
            signature.setSignature(AwsSignatureHelper.sign(stringToSign, secretKey, algorithm));
        } else if ("4".equals(signatureVersion)) {
            byte[] kDate;
            signature.setQueryParameterName("X-Amz-Signature");
            parameters.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
            parameters.put("X-Amz-Date", parameters.get("Timestamp"));
            parameters.put("X-Amz-SignedHeaders", "Host");
            parameters.put("X-Amz-Expires", parameters.get("Timestamp"));
            stringToSign = this.calculateStringToSignV4(parameters, accessId);
            String kSecret = "AWS4" + secretKey;
            try {
                kDate = AwsSignatureHelper.rawSignature(DateUtils.getToday(), kSecret.getBytes("UTF-8"), algorithm);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            byte[] kRegion = AwsSignatureHelper.rawSignature(this.determineRegion(), kDate, algorithm);
            byte[] kService = AwsSignatureHelper.rawSignature(this.determineServiceSignatureName(), kRegion, algorithm);
            byte[] kSigning = AwsSignatureHelper.rawSignature("aws4_request", kService, algorithm);
            signature.setSignature(this.toHex(AwsSignatureHelper.rawSignature(stringToSign, kSigning, algorithm)));
        } else {
            throw new ConfigurationErrorException("Invalid Signature Version specified");
        }
        return signature;
    }

    private String calculateStringToSignV1(Map<String, String> parameters, String accessId) {
        StringBuilder data = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (Map.Entry param : sorted.entrySet()) {
            data.append((String)param.getKey() + (String)param.getValue());
        }
        return data.toString();
    }

    private String calculateStringToSignV2(Map<String, String> parameters, String accessId) {
        StringBuilder data = new StringBuilder();
        data.append(this.method);
        data.append("\n");
        URI endpoint = null;
        try {
            endpoint = new URI(this.serviceUrl.toLowerCase());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        data.append(endpoint.getHost());
        Integer port = endpoint.getPort();
        if (this.serviceUrl.contains(port.toString()) && port != 80 && port != 443 && port != -1) {
            data.append(":" + port);
        }
        data.append("\n");
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        data.append(AwsSignatureHelper.urlEncode(uri, true) + "\n");
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        data.append(this.canonicalQueryString(sorted));
        return data.toString();
    }

    private String calculateStringToSignV4(Map<String, String> parameters, String accessId) {
        String region = this.determineRegion();
        String service = this.determineServiceSignatureName();
        String scope = DateUtils.getToday() + "/" + region + "/" + service + "/aws4_request";
        parameters.put("X-Amz-Credential", accessId + "/" + scope);
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        String stringToSign = "AWS4-HMAC-SHA256\n";
        stringToSign = stringToSign + (String)sorted.get("Timestamp") + "\n";
        stringToSign = stringToSign + scope + "\n";
        stringToSign = stringToSign + this.sha256(this.canonicalRequestV4(sorted));
        return stringToSign;
    }

    private String determineRegion() {
        String region;
        CommandConfig commandConfig = this.command.getCurrentCommandConfig();
        if (commandConfig.doesParameterExist("Region") && (region = commandConfig.getParameter("Region").getValue()).length() > 0) {
            return region;
        }
        URI endpoint = null;
        try {
            endpoint = new URI(this.serviceUrl.toLowerCase());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        String[] endpoint_components = endpoint.getHost().split("\\.");
        String region2 = "us-east-1";
        if (endpoint_components.length == 4) {
            region2 = endpoint_components[1];
        }
        return region2;
    }

    private String determineServiceSignatureName() {
        String service;
        CommandConfig commandConfig = this.command.getCurrentCommandConfig();
        if (commandConfig.doesParameterExist("ServiceSignatureName") && (service = commandConfig.getParameter("ServiceSignatureName").getValue()).length() > 0) {
            return service;
        }
        URI endpoint = null;
        try {
            endpoint = new URI(this.serviceUrl.toLowerCase());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        String[] endpoint_components = endpoint.getHost().split("\\.");
        return endpoint_components[0];
    }

    private String canonicalRequestV4(Map<String, String> parameters) {
        URI endpoint = null;
        try {
            endpoint = new URI(this.serviceUrl.toLowerCase());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("URI Syntax Exception thrown while constructing string to sign", ex);
        }
        String request = this.method + "\n";
        request = request + (endpoint.getPath().length() == 0 ? "/" : endpoint.getPath()) + "\n";
        request = request + this.canonicalQueryString(parameters) + "\n";
        request = request + "host:" + endpoint.getHost();
        if (endpoint.getPort() > 0 && endpoint.getPort() != 80 && endpoint.getPort() != 443) {
            request = request + ":" + Integer.toString(endpoint.getPort());
        }
        request = request + "\n\n";
        request = request + "host\n";
        request = request + this.sha256("");
        return request;
    }

    private String canonicalQueryString(Map<String, String> parameters) {
        String query = "";
        for (Map.Entry<String, String> param : parameters.entrySet()) {
            query = query + AwsSignatureHelper.urlEncode(param.getKey(), false) + "=" + AwsSignatureHelper.urlEncode(param.getValue(), false) + "&";
        }
        if (query.charAt(query.length() - 1) == '&') {
            query = query.substring(0, query.length() - 1);
        }
        return query;
    }

    private String sha256(String input) {
        try {
            MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
            return this.toHex(sha256.digest(input.getBytes("UTF-8")));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to get SHA-256 digest algorithm", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported.", e);
        }
    }

    private String toHex(byte[] bytes) {
        String result = "";
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                result = result + "0";
            }
            result = result + hex;
        }
        return result;
    }

    public static String urlEncode(String value, boolean encodePath) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (encodePath) {
                encoded = encoded.replace("%2F", "/");
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return encoded;
    }

    public static String sign(String data, String key, String algorithm) {
        try {
            return new String(Base64.encodeBase64((byte[])AwsSignatureHelper.rawSignature(data, key.getBytes("UTF-8"), algorithm)));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] rawSignature(String data, byte[] key, String algorithm) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(new SecretKeySpec(key, algorithm));
            return mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new BadInputException(ErrorMessages.ErrorCode.BAD_CREDENTIALS_CANNOT_SIGN, e.getMessage());
        }
    }
}

