
     LIB (1)                Free-DOS Alpha 4 release                LIB (1)



     NNAAMMEE:

          lib - librarian for OBJ files, creating a LIB file

     SSYYNNOOPPSSIISS:

          _l_i_b [{ooppttiioonn}] libfile [{ooppttiioonn}] [{ccoommmmaanndd}] [ , lliissttffiillee ]


     DDEESSCCRRIIPPTTIIOONN:

          _l_i_b creates  a  library  (LIB file) archiving object modules
          (OBJ files).  These libraries can be used by linkers.


     OOPPTTIIOONNSS:


      /?  Display a help screen.
      /AA Internally  globbed  filenames  are  allowed  with  the   "+"
          command.  This allows to refresh modules in a library rather
          than update  the  complete library.  This option is ignored,
          if the  _/_G  option  is  not  set.   (See  there   for   more
          information.)

          All modules  with  the  command "+-" attached are refreshed.
          If there exists no OBJ file with the module name, a  warning
          is issued  and  the original module remains unchanged in the
          library.
      /CC Informs the librarian, that the symbols in  the  library  are
          case-sensitve.  Otherwise,   all   symbols   are  considered
          case-insensitve.  This option effects only the library index
          (also known as library directory).  The symbol  declarations
          within the  OBJ  modules themselves are left unchanged.  The
          effect of this option  lasts  until  the  library  index  is
          constructed again.
      /DD Double  modules will be accepted in the library.  This allows
          to add modules with the same name but different contents  as
          well as to add the same file over and over again.
      /GG Glob   wildcards  internally.   Normally  all  wildcards  are
          globbed according external files.  So the call
               LIB libfile - m*
          will subtract  all  modules  corresponding  to   the   files
          matching "M*.OBJ" in the current directory, whereas
               LIB libfile /g - m*
          will subtract all modules, which names start with the letter
          "M", from the library.

          This option  is  ignored for all modulenames with the symbol
          "+" unless the option _/_A is specified.
      /HH Display the list of options and a short description.
      /II[=[#]] Display information about the page size of the library.
          The information is displayed  as  the  last  output  of  the
          application and  contains one line for different page sizes:
          the current, the minimal, the maximal, and the optimal  one.
          If the  library  has  been changed, the output refers to the
          resulting (the new) library, but, if the page size has  also


                                      -1-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)


          been changed,  another  line for the original page size will
          be printed.

          See also the "PAGE SIZE" section.


          Below the table with the page sizes the number of used pages
          within the library index  is  displayed.   If  the  original
          library was  already created by LLIIBB and no modifications has
          been made to the library, this number will not change.

          The ccuurrrreenntt page size is  the  size  actually  used  in  the
          library

          The oorriiggnnaall  page  size  is the size of the original library
          (the .BAK file).

          The mmiinniimmaall page size  is  the  smallest  page  size,  which
          allows to  create  the  library.   Mostly,  this is the best
          (optimal) page size, too.

          The mmaaxxiimmaall page size specifies the size of the largest  OBJ
          module of  the  library,  and,  thus, a larger size will add
          additional pad bytes to aallll modules in the library.

          The ooppttiimmaall page size is the calculated size to minimize the
          complete library filling all the available  pages  with  the
          maximum amount  of  bytes.   Because  of the internally used
          heuristic this size is pprroobbaabbllyy  the  best.   Otherwise  the
          calculation would  require to much time; try the _/_I_=_0 option
          for the correct  size.   NNoottee:  The  optimal  page  size  is
          calculated according the library size except the slack area,
          but including the pad bytes of the pages.

          Each line displays four numbers:
             1) the page size itself,
             2) the  size  of  the  data  area  of the library of that
             particular size,
             3) the amount of unused pad bytes of the last page (slack
             area), and
             4) the amount of unused pad bytes of all other pages.
          If the alignment of the library index is not  disabled  (see
          _/_X option),  the  sizes  of the slack area and the data area
          are summed and displayed  as  the  size  of  the  data  area
          (position 2).   In  the  other  case,  when the alignment is
          disabled, a '+' sign is displayed between  the  positions  2
          and 3 and the number are not summed.


          The size of the resulting library file is equal to:
             The size of the data area
             plus the number of index pages * 512.

          The optional  argument  for  this  option  varies the search
          range.  The higher the number is, the more time is spent for
          the search.  If  the  number  is  zero  (0)  or  65535,  all
          available page  sizes  between  the  minimal and the maximal
          size are tested.


                                      -2-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)



          If the amount of page sizes to be tested seems  to  be  high
          and time  consuming, a counter is displayed.  The counter is
          suppressed, if the "/S" or "/Q" option  is  enabled  or  the
          standard output stream is redirected.

          The standard  value,  which  will  be used, if the option is
          given without the number _/_I_= can be retrieved  with  the  _/_V
          option.

          If the  option  is specified without both the number and the
          equal sign, the value defaults to 11, thus,  displaying  only
          the current, the minimal, and the maximal page size.
      /MM Module names are left unchanged.

          An OBJ  file  contains  a  field, where the module's name is
          stored.  Because  the  contents  of  this   field   is   not
          standardized, normally,   this   name  is  replaced  by  the
          upper-cased module's  file  name  (without  the  extension).
          Doing so asures that there is no invalid character string in
          the field,  because  it is used to name the module, firstly,
          when naming modules at the command line  and,  secondly,  to
          name the file when extracting a module.

          _N_o_t_e: An invalid contents can make the module unextractable!
          But all information stored in the particular module is still
          available.  (See also the _/_= option)
      /PP=# Set  the  page size to the amount of # bytes.  See also the
          "PAGE SIZE" section.
      /QQ Disable all output except warning and error messages.
      /SS Disable  the  output,  which  module  is   currently   added,
          extraced, or subtracted.
      /VV Display  the  version  control information and some values of
          built-in bounds and how many far memory is available.
      /WW Suppress the warning that a module associated with a  replace
          or refresh order "-+" was not already found in the library.
      /XX Do  not  align the library index at a 512 byte boundary.  The
          library index consists of pages of a  fixed  length  of  512
          bytes.  Because  of  the  heavy  useage  of this part of the
          library the index is aligned  to  a  512  byte  boundary  to
          decrease its access time.

          In the worst-case to align the index wastes 509 bytes in the
          library.

          With this   option   set  the  minimal  size  of  a  library
          containing no OBJ module is (512 + 2 * page_size), thus, 544
          bytes when the page size is equal to 16 bytes.

          To not align the library  index  reduces  the  size  of  the
          resulting LIB  file by the size of the slack area, which can
          be dislayed with the _/_I option.
      /:ffiillee Use  the  special  extraction  feature  and  report   the
          extractions into "file".

          If the   library   contains  modules  with  a  destroyed  or
          unmodified name (see the _/_M option), it can be possible that
          LLIIBB is unable to extract  the  particular  module.   In  the


                                      -3-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)


          special extraction  mode only commands attached with the "*"
          symbol (extraction) are accepted and internal globbing  (see
          the _/_G option) is always enabled.  But instead of naming the
          OBJ file  name  of  the  extracted module after the module's
          name field the OBJ files are named
               ###.OBJ
          Where ### is a continuous  number.   In  "file"  the  rename
          process is  logged, two lines are written for each extracted
          module, e.g.:
               original name: "~~~~~~~~~~~"
               new name: "###.OBJ"
          Where ~~~ is the original  contents  of  the  module's  name
          field and  ###  the  continuous number.  The quotation marks
          shall indicate  the  start  and  the  end  of   the   names.
          AAtttteennttiioonn: The   extracted   files  happily  overwrites  any
          existing files!


     CCOOMMMMAANNDDSS:


          The commands describe  how  to  modify  the  library.   Each
          command has the form:
          [{  ssyymmbbooll  }]  {  mmoodduulleennaammee  }

      mmoodduulleennaammee This  list  specifies  the modules to be extracted or
          subtracted or the file names containing the  modules  to  be
          added.  mmoodduulleennaammee  may  contain  wildcards and a path or an
          extension.  The  path  specification  is  ignored  when   it
          matches a  module  to subtract or to extract.  The extension
          is ignored when matching a module to subtract.

      SSyymmbbooll  - Order to subtract modules.
      SSyymmbbooll  + Order to add new modules or to  join  a  library.   LLIIBB
          does automatically detect, if a module or a library is about
          to be   added.   The  extension  is  not  in  need  for  the
          detection.
      SSyymmbbooll  * Order to extract modules without subtracting them  from
          the library.  The files are overwritten without notifying if
          they already exist.
      SSyymmbbooll  & It is completely ignored.  See the section DIFFERENCES.

          The symbols  _+  and _* must not be combined, because it makes
          no sense to add a new module but simultaneously extract  the
          same module.    Furthermore,   the  extracted  module  would
          overwrite the same file as it would be added later.

          Symbols can be combined in any order possibly  delimited  by
          whitespaces.  If  the  same  module  name has been specified
          more than once, either directly or  by  globbing  wildcards,
          all specified   symbols  become  active,  for  instance  the
          commands:
               + module1 * mod*
          attaches the symbols "+*" to  the  module  "module1".   This
          causes an  error, because both symbols must not be combined.
          _N_o_t_e: Because the wildcard _* is also  a  valid  symbol,  the
          modulename must not start with this wildcard.



                                      -4-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)


          LLIIBB offers  to join libraries together.  This can be done by
          specifying the library to add as a  command  with  only  the
          symbol _+ attached.  _N_o_t_e: If other symbols are also set, the
          name of  the  library  is  treated  as  a OBJ file name!  To
          specify:
               lib lib -+ library.LIB
          does nnoott mean that all modules stored in  "library.LIB"  are
          subtracted from  "lib.lib"  and then added from it.  Instead
          the line is interpreted like that:
               lib lib - library.OBJ + library.LIB

          This also implies that a library does  not  necessarily  has
          been named  with  the  extension  ".LIB".   LLIIBB  automaticly
          detects a library file and joins it when the "+"  symbol  is
          processed.

          Unless the _/_A option is enabled, mmoodduulleennaammeess with the symbol
          '+' are  always matched according to external files and will
          ignore the _/_G option.


     PPAAGGEE  SSIIZZEE:


          A page is the smallest addressable portion of  the  library.
          The specification  allows a maximum of 65,535 pages (minus 2
          for internal purpose) to store modules  in.   If  the  error
          message that  there  are  too  many  modules  stored  in the
          library or that there are not enough pages  is  issued,  the
          resulting library  would  contain  more than 65,533 modules.
          The library must be splitted into two libraries.

          The smallest possible page size may vary, at time of manual,
          it is 16, but the _/_V option reveals the actually range of  a
          valid page size.

          When the  number  of  modules grows larger the standard page
          size can become too small, in this case,  LLIIBB  automatically
          increases the  current  page  size and rewrites the library.
          It is possible that the library must be rewritten more  than
          once within a single run of LLIIBB.

          Unfortunately, LLIIBB  does  not  automaticly decrease the page
          size if  possible.   After  subtracting  many  modules   the
          library should be tested with the _/_I_= option.

          There is  no need to avoid specific page sizes, e.g.  a size
          of 61 is as good as 64.  LLIIBB does not honour specific sizes.
          It will  neither  be  much  slower  nor  much  faster   with
          particular sizes.   Therefore the page size should be set to
          a value, which minimizes the amount of pad bytes need to  be
          inserted after   each  module,  in  order  to  minimize  the
          complete size of the library.  The very exact value  can  be
          calculated by invoking the command:
             LIB /i=0 library.LIB
          The output  contains  the  value  of  page  size to minimize
          (optimize) the size of the library "library.LIB".



                                      -5-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)


          Because the library index is aligned by default to  set  the
          page size  to  its  optimal value need not actually decrease
          the library size.  Turning off the  alignment  (see  the  _/_X
          option) results in the smallest possible library size.

          Some other  librarians  may have problems dealing with a LIB
          file created by LIB, if the page size is not  equal  to  16,
          because they  support  only  specific  page sizes.  However,
          linkers do not seem to have such irregularities.

     LLIISSTTFFIILLEE:


          A listfile may be added to the  command  line  and  must  be
          separated by  a  comma from the ccoommmmaannddss.  If the exitension
          is not specified,  it  defaults  to  ".LST".   The  file  is
          overwritten without notifying if it already exists.

          Into this  file all publics are dumped, arranged by modules,
          e.g.:
          MSG_0000 size = 513
              _E_hlpScreen
          MSG_0001 size = 20
              _E_rmHlpScreen

          This means,  that  the  library  contains  the  two  modules
          "MSG_0000" and  "MSG_0001".   The  first  module defines the
          symbol "_E_hlpScreen"  and  the  second   one   the   symbol
          "_E_rmHlpScreen".

          The "ssiizzee  =  #" information displays the size of the OBJ file
          that would be created, if the module would be extracted.

     DDIIFFFFEERREENNCCEESS:


          There are the following differences to other librarians:

      oo There may be multiple module names for one symbol.
      oo The modules can contain wildcards ("*" and "?").
      oo Symbols  are  not recognized, if they are appended to a module
          name, e.g.  "m1+m2" is not equal to "m1" "+" "m2".
      oo Response files "file" may be  used  in  the  ccoommmmaannddss  section
          only.
      oo The  lines  within response files need not be concated via the
              '&' character, e.g.  the sequence:
              "+ m1 &
               + m2
               + m3" is interpreted as "+ m1 + m2 + m3" rather than "+
          m1 + m2".
      oo The character '&' is interpreted as a symbol with no  meaning,
          e.g.  "-+& m1" is legal and equal to "-+ m1".
      oo While  adding  a file to the library LLIIBB automatically detects
          if this file contains a library or a  OBJ  module.   If  the
          file is  a  library, all modules stored in it are appeneded;
          if the file is an OBJ module, only this OBJ is appended.
      oo The comma ',' delimiting the listfile from former parts of the
          command line  must  be  separated  from  the  options  by  a


                                      -6-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)


          whitespace; Otherwise it does not indicate a listfile.
      oo Some librarians support only specific page sizes.

     EERRRROORRLLEEVVEELLSS:

      00 No error or only minor warnings were encountered.
      33 ^Break or ^C pressed to terminate the program.
      110000 A file to add could not be found.
      110011 A module to subtract or to extract was not found.
      110022 The library contains a symbol twice.
      110033 A file to add was already found in the library.
      112255 Version information issued.
      112277 The help screen was issued.
      aallll  ootthheerrss Indicate an error.
          If more than one warning associated with the errorlevels 100
          through 103 were encountered, the last one is returned.

     SSEEEE  AALLSSOO:

          Compiler, assembler, linker.

     KKNNOOWWNN  BBUUGGSS:

      oo Because the character '*' is a valid symbol as well as a valid
          wildcard in  the module name, the module name must not start
          with an asterisk.  Just prepend the path, e.g.:
          "+ *.obj" ==> "+ .\\*.obj"
      oo The smallest library has 1024 bytes: 512 bytes for one library
          index page and, because this index page is aligned on a  512
          byte boundary,  512  bytes for the library structure and pad
          bytes.  See also the _/_X option.
      oo If some moduls match each other, it is undefined which  symbol
          is attached  to which modul and if some modul specifications
          are joined together.  Although, most such conditions will be
          detected and warned.
      oo If a replaced module, "-+"  or  "+-",  cannot  be  opened  for
          reading, it is subtracted from the library but not re-added.
      oo The  library  join  feature  treats the name of the library to
          join as an OBJ file name, while copying the original library
          and subtracting and extracting files.

     EEXXAAMMPPLLEESS:


      lliibb  /cc  mmssgg  +  ./*  ,,  mmssgg.llsstt
          Will add all files matching "*.OBJ" to the library "MSG.LIB"
          in the current directory and create the listfile  "MSG.LST".
          If the library is not existing, it is created.

      lliibb  /cc  mmssgg  /gg  -  ./*
          Clears the  library  "MSG.LIB".   This command will subtract
          all modules from the library.

      lliibb  mmssgg  /ccgg  -+  ./*
          Will subtract all modules, which also have  a  corresponding
          "*.OBJ" file  in the current directory, then add them.  This
          means to replace the modules in the library with the  module
          in the corresponding OBJ-file, but also add modules, if they


                                      -7-


     LIB (1)                Free-DOS Alpha 4 release                LIB (1)


          are not already in the library.

      lliibb  mmssgg  /ccggaa  -+  ./*
          Will subtract  all modules from the library, which also have
          a corresponding "*.OBJ" file in the current directory,  then
          add them.   In  opposite  of the command above, no module is
          added, which is not already in the library.


     DDIISSCCLLAAIIMMEERR:


          Librarian for LIB/OBJ compatible libraries and modules
          Copyright (C) 1995,1996 Steffen Kaiser

          This program is  free  software;  you  can  redistribute  it
          and/or modify  it  under the terms of the GNU General Public
          License as published by the Free Software Foundation; either
          version 2 of the License, or  (at  your  option)  any  later
          version.

          This program  is  distributed  in  the  hope that it will be
          useful, but WITHOUT ANY WARRANTY; without even  the  implied
          warranty of  MERCHANTABILITY  or  FITNESS  FOR  A PARTICULAR
          PURPOSE.  See  the  GNU  General  Public  License  for  more
          details.

          You should  have  received  a copy of the GNU General Public
          License along with this program; if not, write to  the  Free
          Software Foundation,  Inc.,  675  Mass  Ave,  Cambridge,  MA
          02139, USA.


     CCOONNTTRRIIBBUUTTEERRSS:

                            Steffen Kaiser
                       Ernst-Thlmann-Strae 2
                             D-39606 Iden
                        Deutschland - Germany

          e-mail: Steffen.KaiserT-Online.DE


          James W.  Lynch
          e-mail: jwlatlanta.cray.com


          Thanks to the anonymous collector of the OBJLIB.ZIP package,
          who refered to himself as "me".











                                      -8-

