/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_SSTR.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgScanString(struct Cfg_Getopt * const optstru, char ** const num
	 , int mode, int delimiter);

 *	Check and duplicate, if so, a string
 *	*num _must_ be initialized, as this value is free()'ed.
 *	Return:
 *		0: success
 *		1: failed, no argument, **num not changed
 *		2: no memory, **num not changed

ob(ject): cfgScanString
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Perform a string option
he(ader files): 
lo(ng description): Check if the current option has an argument.
	If so, the \para{*num} value is modified according the rules.
pr(erequistes): 
va(lue): 0: success \item 1: no failure\item 2: out of memory
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_sstr.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <limits.h>
#include <portable.h>
#include "dynstr.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_SSTR.C 1.6 2001/02/27 01:28:09 ska Exp ska $";
#endif

int cfgScanString(struct Cfg_Getopt * const optstru, char ** const num
	 , int mode, int delimiter)
{	char *p;
	static char delim[2] = "?";

	DBG_ENTER("cfgScanString", Suppl_cmdline)

	assert(optstru);

	if(optArgType() == CFG_TERROR)
		DBG_RETURN_I( 1)		/* no argument at all */

	chkHeap
	if(!*(p = optArgString()))
		DBG_RETURN_I( 0)
	if(!*num) 			/* first and only part */
		DBG_RETURN_BI((*num = strdup(p)) == 0? 2: 0)

	if(mode & CFG_OPT_HONOR_SIGN) {
		switch(*p) {
		case '+':		/* prepend */
			mode = CFG_OPT_PREPEND;
			++p;
			break;

		case '-':		/* overwrite */
			mode = CFG_OPT_OVERWRITE;
			++p;
			break;

		default:		/* default */
			if((mode &= ~CFG_OPT_HONOR_SIGN) == 0)
				mode = CFG_OPT_APPEND;
			break;
		}
	}

	/* at this point p and *num are not empty */
	*delim = delimiter;		/* delimiter as string */
	chkHeap
	switch(mode) {
	case CFG_OPT_PREPEND:
		if((p = StrConcat(3, p, delimiter? delim: 0, *num)) == 0)
			DBG_RETURN_I( 2)
		break;

	case CFG_OPT_APPEND:
		if((p = StrConcat(3, *num, delimiter? delim: 0, p)) == 0)
			DBG_RETURN_I( 2)
		break;

	default:
		if((p = strdup(p)) == 0)
			DBG_RETURN_I( 2)
		break;
	}

	StrRepl_(num, p);
	chkHeap
	DBG_RETURN_I( 0)
}
