/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGGETC.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfg_getc(struct Cfg_Getopt *optstru)
 *	Retreive the next character from the input channels
 *
 *	First, return the buffered character.
 *	Second, try the currently opened response file.
 *	Third, fetch the character using the user function.
 *
 *	Return:
 *		EOF: response file empty/no further character
 *		else: character

ob(ject): cfg_getc
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Return next character from input stream
he(ader files): 
lo(ng description): Returns the next character of the current input
	stream and honors a previously ungetc'ed character.
pr(erequistes): 
va(lue): EOF: on end-of-stream\item else: next character
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfggetc.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGGETC.C 1.4 1999/12/13 02:22:09 ska Exp ska $";
#endif


int cfg_getc(struct Cfg_Getopt *optstru)
{	int ch;

	DBG_ENTER("cfg_getc", Suppl_cmdline)

	assert(optstru);
	assert(C(_stk));

	if((ch = S(bufch)) != 0) {
		S(bufch) = 0;
		DBG_RETURN_C( ch)
	}

	if(S(getFct)) DBG_RETURN_BI((S(getFct))(optstru))

	DBG_RETURN_C( EOF)
}
