// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: internal/module/reverse_tunnel/tracker/tracker.proto

package tracker

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
)

// Validate checks the field values on TunnelInfo with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *TunnelInfo) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetAgentDescriptor() == nil {
		return TunnelInfoValidationError{
			field:  "AgentDescriptor",
			reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetAgentDescriptor()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TunnelInfoValidationError{
				field:  "AgentDescriptor",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ConnectionId

	// no validation rules for AgentId

	if !_TunnelInfo_KasUrl_Pattern.MatchString(m.GetKasUrl()) {
		return TunnelInfoValidationError{
			field:  "KasUrl",
			reason: "value does not match regex pattern \"(?:^$|^grpcs?://)\"",
		}
	}

	return nil
}

// TunnelInfoValidationError is the validation error returned by
// TunnelInfo.Validate if the designated constraints aren't met.
type TunnelInfoValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TunnelInfoValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TunnelInfoValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TunnelInfoValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TunnelInfoValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TunnelInfoValidationError) ErrorName() string { return "TunnelInfoValidationError" }

// Error satisfies the builtin error interface
func (e TunnelInfoValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTunnelInfo.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TunnelInfoValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TunnelInfoValidationError{}

var _TunnelInfo_KasUrl_Pattern = regexp.MustCompile("(?:^$|^grpcs?://)")
