/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VariantContextBuilder {
    private boolean fullyDecoded = false;
    private String source = null;
    private String contig = null;
    private long start = -1L;
    private long stop = -1L;
    private Collection<Allele> alleles = null;
    private String ID = ".";
    private GenotypesContext genotypes = GenotypesContext.NO_GENOTYPES;
    private double log10PError = 1.0;
    private Set<String> filters = null;
    private Map<String, Object> attributes = null;
    private boolean attributesCanBeModified = false;
    private final EnumSet<VariantContext.Validation> toValidate = EnumSet.noneOf(VariantContext.Validation.class);

    public VariantContextBuilder() {
    }

    public VariantContextBuilder(String source, String contig, long start, long stop, Collection<Allele> alleles) {
        this.source = source;
        this.contig = contig;
        this.start = start;
        this.stop = stop;
        this.alleles = alleles;
        this.attributes = Collections.emptyMap();
        this.toValidate.add(VariantContext.Validation.ALLELES);
    }

    public VariantContextBuilder(VariantContext parent) {
        if (parent == null) {
            throw new IllegalArgumentException("BUG: VariantContextBuilder parent argument cannot be null in VariantContextBuilder");
        }
        this.alleles = parent.alleles;
        this.attributes = parent.getAttributes();
        this.attributesCanBeModified = false;
        this.contig = parent.contig;
        this.filters = parent.getFiltersMaybeNull();
        this.genotypes = parent.genotypes;
        this.ID = parent.getID();
        this.log10PError = parent.getLog10PError();
        this.source = parent.getSource();
        this.start = parent.getStart();
        this.stop = parent.getEnd();
        this.fullyDecoded = parent.isFullyDecoded();
    }

    public VariantContextBuilder(VariantContextBuilder parent) {
        if (parent == null) {
            throw new IllegalArgumentException("BUG: VariantContext parent argument cannot be null in VariantContextBuilder");
        }
        this.alleles = parent.alleles;
        this.attributesCanBeModified = false;
        this.contig = parent.contig;
        this.genotypes = parent.genotypes;
        this.ID = parent.ID;
        this.log10PError = parent.log10PError;
        this.source = parent.source;
        this.start = parent.start;
        this.stop = parent.stop;
        this.fullyDecoded = parent.fullyDecoded;
        this.attributes(parent.attributes);
        this.filters(parent.filters);
    }

    public VariantContextBuilder copy() {
        return new VariantContextBuilder(this);
    }

    public VariantContextBuilder alleles(Collection<Allele> alleles) {
        this.alleles = alleles;
        this.toValidate.add(VariantContext.Validation.ALLELES);
        return this;
    }

    public VariantContextBuilder alleles(List<String> alleleStrings) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(alleleStrings.size());
        for (int i = 0; i < alleleStrings.size(); ++i) {
            alleles.add(Allele.create(alleleStrings.get(i), i == 0));
        }
        return this.alleles((Collection<Allele>)alleles);
    }

    public VariantContextBuilder alleles(String ... alleleStrings) {
        return this.alleles(Arrays.asList(alleleStrings));
    }

    public List<Allele> getAlleles() {
        return new ArrayList<Allele>(this.alleles);
    }

    public VariantContextBuilder attributes(Map<String, Object> attributes) {
        this.attributes = attributes != null ? attributes : new HashMap<String, Object>();
        this.attributesCanBeModified = true;
        return this;
    }

    public VariantContextBuilder attribute(String key, Object value) {
        this.makeAttributesModifiable();
        this.attributes.put(key, value);
        return this;
    }

    public VariantContextBuilder rmAttribute(String key) {
        this.makeAttributesModifiable();
        this.attributes.remove(key);
        return this;
    }

    public VariantContextBuilder rmAttributes(List<String> keys) {
        this.makeAttributesModifiable();
        for (String key : keys) {
            this.attributes.remove(key);
        }
        return this;
    }

    private void makeAttributesModifiable() {
        if (!this.attributesCanBeModified) {
            this.attributesCanBeModified = true;
            this.attributes = this.attributes == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.attributes);
        }
    }

    public VariantContextBuilder filters(Set<String> filters) {
        this.filters = filters;
        return this;
    }

    public VariantContextBuilder filters(String ... filters) {
        this.filters(new LinkedHashSet<String>(Arrays.asList(filters)));
        return this;
    }

    public VariantContextBuilder filter(String filter) {
        if (this.filters == null) {
            this.filters = new LinkedHashSet<String>(1);
        }
        this.filters.add(filter);
        return this;
    }

    public VariantContextBuilder passFilters() {
        return this.filters(VariantContext.PASSES_FILTERS);
    }

    public VariantContextBuilder unfiltered() {
        this.filters = null;
        return this;
    }

    public VariantContextBuilder genotypes(GenotypesContext genotypes) {
        this.genotypes = genotypes;
        if (genotypes != null) {
            this.toValidate.add(VariantContext.Validation.GENOTYPES);
        }
        return this;
    }

    public VariantContextBuilder genotypesNoValidation(GenotypesContext genotypes) {
        this.genotypes = genotypes;
        return this;
    }

    public VariantContextBuilder genotypes(Collection<Genotype> genotypes) {
        return this.genotypes(GenotypesContext.copy(genotypes));
    }

    public VariantContextBuilder genotypes(Genotype ... genotypes) {
        return this.genotypes(GenotypesContext.copy(Arrays.asList(genotypes)));
    }

    public VariantContextBuilder noGenotypes() {
        this.genotypes = null;
        return this;
    }

    public VariantContextBuilder id(String ID) {
        this.ID = ID;
        return this;
    }

    public VariantContextBuilder noID() {
        return this.id(".");
    }

    public VariantContextBuilder log10PError(double log10PError) {
        this.log10PError = log10PError;
        return this;
    }

    public VariantContextBuilder source(String source) {
        this.source = source;
        return this;
    }

    public VariantContextBuilder loc(String contig, long start, long stop) {
        this.contig = contig;
        this.start = start;
        this.stop = stop;
        this.toValidate.add(VariantContext.Validation.ALLELES);
        return this;
    }

    public VariantContextBuilder chr(String contig) {
        this.contig = contig;
        return this;
    }

    public VariantContextBuilder start(long start) {
        this.start = start;
        this.toValidate.add(VariantContext.Validation.ALLELES);
        return this;
    }

    public VariantContextBuilder stop(long stop) {
        this.stop = stop;
        return this;
    }

    public VariantContextBuilder computeEndFromAlleles(List<Allele> alleles, int start) {
        return this.computeEndFromAlleles(alleles, start, -1);
    }

    public VariantContextBuilder computeEndFromAlleles(List<Allele> alleles, int start, int endForSymbolicAlleles) {
        this.stop(VariantContextUtils.computeEndFromAlleles(alleles, start, endForSymbolicAlleles));
        return this;
    }

    public boolean isFullyDecoded() {
        return this.fullyDecoded;
    }

    public VariantContextBuilder fullyDecoded(boolean isFullyDecoded) {
        this.fullyDecoded = isFullyDecoded;
        return this;
    }

    public VariantContext make() {
        return this.make(false);
    }

    public VariantContext make(boolean leaveModifyableAsIs) {
        if (!leaveModifyableAsIs) {
            this.attributesCanBeModified = false;
        }
        return new VariantContext(this.source, this.ID, this.contig, this.start, this.stop, this.alleles, this.genotypes, this.log10PError, this.filters, this.attributes, this.fullyDecoded, this.toValidate);
    }
}

