/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.matcher.JButtonMatcher;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JOptionPaneMessageQuery;
import org.fest.swing.driver.JOptionPaneMessageTypeQuery;
import org.fest.swing.driver.JOptionPaneMessageTypes;
import org.fest.swing.driver.JOptionPaneOptionsQuery;
import org.fest.swing.driver.JOptionPaneTitleQuery;
import org.fest.swing.driver.TextAssert;

public class JOptionPaneDriver
extends JComponentDriver {
    private static final String MESSAGE_PROPERTY = "message";
    private static final String MESSAGE_TYPE_PROPERTY = "messageType";
    private static final String OPTIONS_PROPERTY = "options";
    private static final String TITLE_PROPERTY = "title";

    public JOptionPaneDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void requireTitle(JOptionPane optionPane, String title) {
        TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).isEqualOrMatches(title);
    }

    @RunsInEDT
    public void requireTitle(JOptionPane optionPane, Pattern pattern) {
        TextAssert.verifyThat(this.title(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).matches(pattern);
    }

    @RunsInEDT
    public String title(JOptionPane optionPane) {
        return JOptionPaneTitleQuery.titleOf(optionPane);
    }

    @RunsInEDT
    public void requireMessage(JOptionPane optionPane, Object message) {
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        if (message instanceof String) {
            this.requireMessage(optionPane, (String)message, this.toStringOf(actual));
            return;
        }
        Assertions.assertThat((Object)actual).as(this.messageProperty(optionPane)).isEqualTo(message);
    }

    @RunsInEDT
    private void requireMessage(JOptionPane optionPane, String expected, String actual) {
        TextAssert.verifyThat(actual).as(this.messageProperty(optionPane)).isEqualOrMatches(expected);
    }

    @RunsInEDT
    public void requireMessage(JOptionPane optionPane, Pattern pattern) {
        Object actual = JOptionPaneMessageQuery.messageOf(optionPane);
        TextAssert.verifyThat(this.toStringOf(actual)).as(this.messageProperty(optionPane)).matches(pattern);
    }

    private String toStringOf(Object o) {
        return o == null ? null : o.toString();
    }

    private Description messageProperty(JOptionPane optionPane) {
        return JOptionPaneDriver.propertyName(optionPane, MESSAGE_PROPERTY);
    }

    @RunsInEDT
    public void requireOptions(JOptionPane optionPane, Object[] options) {
        Assertions.assertThat((Object[])JOptionPaneOptionsQuery.optionsOf(optionPane)).as(JOptionPaneDriver.propertyName(optionPane, OPTIONS_PROPERTY)).isEqualTo(options);
    }

    @RunsInEDT
    public JButton okButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.okButtonText");
    }

    @RunsInEDT
    public JButton cancelButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.cancelButtonText");
    }

    @RunsInEDT
    public JButton yesButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.yesButtonText");
    }

    @RunsInEDT
    public JButton noButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.noButtonText");
    }

    @RunsInEDT
    private JButton buttonWithTextFromUIManager(JOptionPane optionPane, String key) {
        return this.buttonWithText(optionPane, UIManager.getString(key));
    }

    @RunsInEDT
    public JButton buttonWithText(JOptionPane optionPane, String text) {
        return this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(text).andShowing());
    }

    @RunsInEDT
    public JButton buttonWithText(JOptionPane optionPane, Pattern pattern) {
        return this.robot.finder().find((Container)optionPane, JButtonMatcher.withText(pattern).andShowing());
    }

    @Deprecated
    @RunsInEDT
    public JButton button(JOptionPane optionPane) {
        return this.robot.finder().findByType(optionPane, JButton.class);
    }

    @Deprecated
    @RunsInEDT
    public JTextComponent textBox(JOptionPane optionPane) {
        return this.robot.finder().findByType(optionPane, JTextComponent.class);
    }

    @RunsInEDT
    public void requireErrorMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 0);
    }

    @RunsInEDT
    public void requireInformationMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 1);
    }

    @RunsInEDT
    public void requireWarningMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 2);
    }

    @RunsInEDT
    public void requireQuestionMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 3);
    }

    @RunsInEDT
    public void requirePlainMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, -1);
    }

    @RunsInEDT
    private void assertEqualMessageType(JOptionPane optionPane, int expected) {
        String actualType = this.actualMessageTypeAsText(optionPane);
        Assertions.assertThat((String)actualType).as(JOptionPaneDriver.propertyName(optionPane, MESSAGE_TYPE_PROPERTY)).isEqualTo(JOptionPaneMessageTypes.messageTypeAsText(expected));
    }

    @RunsInEDT
    private String actualMessageTypeAsText(JOptionPane optionPane) {
        return JOptionPaneMessageTypes.messageTypeAsText(JOptionPaneMessageTypeQuery.messageTypeOf(optionPane));
    }
}

