/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import edu.cornell.med.icb.goby.compression.ChunkCodec;
import edu.cornell.med.icb.goby.compression.ProtobuffCollectionHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class BZip2ChunkCodec
implements ChunkCodec {
    private ProtobuffCollectionHandler parser;
    private byte[] magicSignature = new byte[]{66, 90, 104};
    private final byte[] bytes = new byte[7];
    public static final byte REGISTRATION_CODE = -3;

    @Override
    public void setHandler(ProtobuffCollectionHandler parser) {
        this.parser = parser;
    }

    @Override
    public boolean validate(byte firstByte, DataInputStream input) {
        try {
            int length = 7;
            if (input.read(this.bytes, 0, 7) != 7) {
                return false;
            }
            return this.bytes[3] == 66 && this.bytes[4] == 90 && this.bytes[5] == 104;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public String name() {
        return "bzip2";
    }

    @Override
    public byte registrationCode() {
        return -3;
    }

    @Override
    public ByteArrayOutputStream encode(Message readCollection) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream(10000);
        byteBuffer.write(this.magicSignature);
        CBZip2OutputStream bZip2OutputStream = new CBZip2OutputStream((OutputStream)byteBuffer);
        readCollection.writeTo((OutputStream)bZip2OutputStream);
        bZip2OutputStream.flush();
        bZip2OutputStream.close();
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message decode(byte[] bytes) throws IOException {
        if (bytes[0] != this.magicSignature[0] || bytes[1] != this.magicSignature[1] || bytes[2] != this.magicSignature[2]) {
            return null;
        }
        CBZip2InputStream uncompressStream = new CBZip2InputStream((InputStream)new ByteArrayInputStream(bytes, 3, bytes.length));
        try {
            GeneratedMessage generatedMessage = this.parser.parse((InputStream)uncompressStream);
            return generatedMessage;
        }
        finally {
            uncompressStream.close();
        }
    }

    @Override
    public int getSuggestedChunkSize() {
        return 20000;
    }
}

