/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.AggregateByteArray;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.CharacterSet;

class T2CCharByteArray
extends AggregateByteArray {
    char[] charArray;
    DBConversion conversion;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    T2CCharByteArray(char[] cArray, ByteArray byteArray) {
        super(PhysicalConnection.EMPTY_BYTE_ARRAY, byteArray);
        this.charArray = cArray;
    }

    @Override
    long length() {
        return (long)this.charArray.length + this.extension.length();
    }

    void setChars(char[] cArray) {
        this.charArray = cArray;
    }

    void setDBConversion(DBConversion dBConversion) {
        this.conversion = dBConversion;
    }

    @Override
    char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        if (l2 < (long)this.charArray.length) {
            char[] cArray = new char[n2];
            System.arraycopy(this.charArray, (int)l2, cArray, 0, n2);
            nArray[0] = n2;
            return cArray;
        }
        return this.extension.getChars(l2 - (long)this.charArray.length, n2, characterSet, nArray);
    }

    @Override
    void get(long l2, byte[] byArray, int n2, int n3) {
        if (l2 < (long)this.charArray.length) {
            try {
                int n4 = this.conversion.javaCharsToCHARBytes(this.charArray, (int)l2, byArray, n2, n3);
            }
            catch (SQLException sQLException) {}
        } else {
            this.extension.get(l2 - (long)this.charArray.length, byArray, n2, n3);
        }
    }

    @Override
    byte get(long l2) {
        if (l2 < (long)this.charArray.length) {
            return (byte)(this.charArray[(int)l2] & 0xFF);
        }
        return this.extension.get(l2 - (long)this.charArray.length);
    }
}

