/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.tools.walkers.na12878kb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.GenomeLoc;
import org.broadinstitute.gatk.utils.GenomeLocParser;
import org.broadinstitute.gatk.utils.GenomeLocSortedSet;

public class SiteSelector {
    private static Logger logger = Logger.getLogger(SiteSelector.class);
    protected static final int MAXIMUM_REASONABLE_INTERVALS_FOR_QUERY = 5;
    final GenomeLocParser parser;
    GenomeLocSortedSet intervals = null;
    boolean onlyReviewed = false;

    protected SiteSelector(GenomeLocParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("GenomeLocParser cannot be null");
        }
        this.parser = parser;
    }

    protected SiteSelector addIntervals(List<GenomeLoc> locs) {
        if (locs == null) {
            throw new IllegalArgumentException("Locs cannot be null");
        }
        for (GenomeLoc loc : locs) {
            this.addInterval(loc);
        }
        return this;
    }

    protected SiteSelector addInterval(GenomeLoc loc) {
        if (loc == null) {
            throw new IllegalArgumentException("Loc cannot be null");
        }
        if (this.intervals == null) {
            this.intervals = new GenomeLocSortedSet(this.parser);
        }
        this.intervals.addRegion(loc);
        return this;
    }

    protected SiteSelector addInterval(String contig, int start, int stop) {
        return this.addInterval(this.parser.createGenomeLoc(contig, start, stop));
    }

    protected SiteSelector onlyReviewed() {
        this.onlyReviewed = true;
        return this;
    }

    protected GenomeLocSortedSet getIntervals() {
        return this.intervals;
    }

    protected static boolean hasTooManyIntervals(List<GenomeLoc> intervals) {
        return intervals != null && intervals.size() > 5;
    }

    protected DBObject toQuery() {
        BasicDBObject query;
        LinkedList<BasicDBObject> conditions = new LinkedList<BasicDBObject>();
        if (this.intervals != null) {
            LinkedList<BasicDBObject> regionsToOr = new LinkedList<BasicDBObject>();
            for (GenomeLoc interval : this.intervals.toList()) {
                BasicDBObject StartRange = new BasicDBObject("$gte", (Object)interval.getStart()).append("$lte", (Object)interval.getStop());
                regionsToOr.add(new BasicDBObject("Chr", (Object)interval.getContig()).append("Start", (Object)StartRange));
            }
            conditions.add(new BasicDBObject("$or", regionsToOr));
        }
        if (this.onlyReviewed) {
            conditions.add(new BasicDBObject("Reviewed", (Object)true));
        }
        BasicDBObject basicDBObject = query = conditions.isEmpty() ? new BasicDBObject() : new BasicDBObject("$and", conditions);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query " + query));
        }
        return query;
    }
}

