/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.recalibration;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.samtools.SAMRecord;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.engine.report.GATKReport;
import org.broadinstitute.gatk.engine.report.GATKReportTable;
import org.broadinstitute.gatk.tools.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.gatk.utils.BaseUtils;
import org.broadinstitute.gatk.utils.R.RScriptExecutor;
import org.broadinstitute.gatk.utils.Utils;
import org.broadinstitute.gatk.utils.classloader.JVMUtils;
import org.broadinstitute.gatk.utils.classloader.PluginManager;
import org.broadinstitute.gatk.utils.collections.NestedIntegerArray;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.gatk.utils.exceptions.ReviewedGATKException;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.io.Resource;
import org.broadinstitute.gatk.utils.recalibration.EventType;
import org.broadinstitute.gatk.utils.recalibration.QuantizationInfo;
import org.broadinstitute.gatk.utils.recalibration.ReadCovariates;
import org.broadinstitute.gatk.utils.recalibration.RecalDatum;
import org.broadinstitute.gatk.utils.recalibration.RecalibrationReport;
import org.broadinstitute.gatk.utils.recalibration.RecalibrationTables;
import org.broadinstitute.gatk.utils.recalibration.covariates.Covariate;
import org.broadinstitute.gatk.utils.recalibration.covariates.QualityScoreCovariate;
import org.broadinstitute.gatk.utils.recalibration.covariates.ReadGroupCovariate;
import org.broadinstitute.gatk.utils.recalibration.covariates.RequiredCovariate;
import org.broadinstitute.gatk.utils.recalibration.covariates.StandardCovariate;
import org.broadinstitute.gatk.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;
import org.broadinstitute.gatk.utils.sam.ReadUtils;

public class RecalUtils {
    public static final String ARGUMENT_REPORT_TABLE_TITLE = "Arguments";
    public static final String QUANTIZED_REPORT_TABLE_TITLE = "Quantized";
    public static final String READGROUP_REPORT_TABLE_TITLE = "RecalTable0";
    public static final String QUALITY_SCORE_REPORT_TABLE_TITLE = "RecalTable1";
    public static final String ALL_COVARIATES_REPORT_TABLE_TITLE = "RecalTable2";
    public static final String ARGUMENT_COLUMN_NAME = "Argument";
    public static final String ARGUMENT_VALUE_COLUMN_NAME = "Value";
    public static final String QUANTIZED_VALUE_COLUMN_NAME = "QuantizedScore";
    public static final String QUANTIZED_COUNT_COLUMN_NAME = "Count";
    public static final String READGROUP_COLUMN_NAME = "ReadGroup";
    public static final String EVENT_TYPE_COLUMN_NAME = "EventType";
    public static final String EMPIRICAL_QUALITY_COLUMN_NAME = "EmpiricalQuality";
    public static final String ESTIMATED_Q_REPORTED_COLUMN_NAME = "EstimatedQReported";
    public static final String QUALITY_SCORE_COLUMN_NAME = "QualityScore";
    public static final String COVARIATE_VALUE_COLUMN_NAME = "CovariateValue";
    public static final String COVARIATE_NAME_COLUMN_NAME = "CovariateName";
    public static final String NUMBER_OBSERVATIONS_COLUMN_NAME = "Observations";
    public static final String NUMBER_ERRORS_COLUMN_NAME = "Errors";
    private static final String COLOR_SPACE_ATTRIBUTE_TAG = "CS";
    private static final String COLOR_SPACE_INCONSISTENCY_TAG = "ZC";
    private static boolean warnUserNullPlatform = false;
    private static final String SCRIPT_FILE = "BQSR.R";
    private static final Pair<String, String> covariateValue = new Pair<String, String>("CovariateValue", "%s");
    private static final Pair<String, String> covariateName = new Pair<String, String>("CovariateName", "%s");
    private static final Pair<String, String> eventType = new Pair<String, String>("EventType", "%s");
    private static final Pair<String, String> empiricalQuality = new Pair<String, String>("EmpiricalQuality", "%.4f");
    private static final Pair<String, String> estimatedQReported = new Pair<String, String>("EstimatedQReported", "%.4f");
    private static final Pair<String, String> nObservations = new Pair<String, String>("Observations", "%d");
    private static final Pair<String, String> nErrors = new Pair<String, String>("Errors", "%.2f");

    public static Pair<ArrayList<Covariate>, ArrayList<Covariate>> initializeCovariates(RecalibrationArgumentCollection argumentCollection) {
        List covariateClasses = new PluginManager(Covariate.class).getPlugins();
        List<Class<? extends RequiredCovariate>> requiredClasses = new PluginManager(RequiredCovariate.class).getPlugins();
        List<Class<? extends StandardCovariate>> standardClasses = new PluginManager(StandardCovariate.class).getPlugins();
        ArrayList<Covariate> requiredCovariates = RecalUtils.addRequiredCovariatesToList(requiredClasses);
        ArrayList<Object> optionalCovariates = new ArrayList();
        if (!argumentCollection.DO_NOT_USE_STANDARD_COVARIATES) {
            optionalCovariates = RecalUtils.addStandardCovariatesToList(standardClasses);
        }
        if (argumentCollection.COVARIATES != null) {
            for (String requestedCovariateString : argumentCollection.COVARIATES) {
                if (requestedCovariateString.equals("DinucCovariate")) {
                    throw new UserException.CommandLineException("DinucCovariate has been retired.  Please use its successor covariate ContextCovariate instead, which includes the 2 bp (dinuc) substitution model of the retired DinucCovariate as well as an indel context to model the indel error rates");
                }
                boolean foundClass = false;
                for (Class covClass : covariateClasses) {
                    if (!requestedCovariateString.equalsIgnoreCase(covClass.getSimpleName())) continue;
                    foundClass = true;
                    if (requiredClasses.contains(covClass) || !argumentCollection.DO_NOT_USE_STANDARD_COVARIATES && standardClasses.contains(covClass)) continue;
                    try {
                        Covariate covariate = (Covariate)covClass.newInstance();
                        optionalCovariates.add(covariate);
                    }
                    catch (Exception e) {
                        throw new DynamicClassResolutionException(covClass, e);
                    }
                }
                if (foundClass) continue;
                throw new UserException.CommandLineException("The requested covariate type (" + requestedCovariateString + ") isn't a valid covariate option. Use --list to see possible covariates.");
            }
        }
        return new Pair<ArrayList<Covariate>, ArrayList<Covariate>>(requiredCovariates, optionalCovariates);
    }

    private static ArrayList<Covariate> addRequiredCovariatesToList(List<Class<? extends RequiredCovariate>> classes) {
        ArrayList<Covariate> dest = new ArrayList<Covariate>(classes.size());
        if (classes.size() != 2) {
            throw new ReviewedGATKException("The number of required covariates has changed, this is a hard change in the code and needs to be inspected");
        }
        dest.add(new ReadGroupCovariate());
        dest.add(new QualityScoreCovariate());
        return dest;
    }

    private static ArrayList<Covariate> addStandardCovariatesToList(List<Class<? extends StandardCovariate>> classes) {
        ArrayList<Covariate> dest = new ArrayList<Covariate>(classes.size());
        for (Class<? extends StandardCovariate> covClass : classes) {
            try {
                Covariate covariate = covClass.newInstance();
                dest.add(covariate);
            }
            catch (Exception e) {
                throw new DynamicClassResolutionException(covClass, e);
            }
        }
        return dest;
    }

    public static void listAvailableCovariates(Logger logger) {
        logger.info((Object)"Available covariates:");
        for (Class covClass : new PluginManager(Covariate.class).getPlugins()) {
            logger.info((Object)String.format("\t%30s\t%s", covClass.getSimpleName(), JVMUtils.classInterfaces(covClass)));
        }
    }

    protected static CsvPrinter csvPrinter(File out, Covariate ... c) throws FileNotFoundException {
        if (c == null) {
            throw new IllegalArgumentException("the input covariate array cannot be null");
        }
        return new CsvPrinter(out, c);
    }

    public static void generateCsv(File out, Map<String, RecalibrationReport> reports) throws FileNotFoundException {
        if (reports.size() == 0) {
            RecalUtils.writeCsv(out, reports, new Covariate[0]);
        } else {
            Iterator<RecalibrationReport> rit = reports.values().iterator();
            RecalibrationReport first = rit.next();
            Covariate[] firstCovariates = first.getRequestedCovariates();
            LinkedHashSet covariates = new LinkedHashSet();
            Utils.addAll(covariates, firstCovariates);
            while (rit.hasNext() && covariates.size() > 0) {
                Covariate[] nextCovariates = rit.next().getRequestedCovariates();
                LinkedHashSet<String> nextCovariateNames = new LinkedHashSet<String>(nextCovariates.length);
                for (Covariate nc : nextCovariates) {
                    nextCovariateNames.add(nc.getClass().getSimpleName());
                }
                Iterator cit = covariates.iterator();
                while (cit.hasNext()) {
                    if (nextCovariateNames.contains(((Covariate)cit.next()).getClass().getSimpleName())) continue;
                    cit.remove();
                }
            }
            RecalUtils.writeCsv(out, reports, covariates.toArray(new Covariate[covariates.size()]));
        }
    }

    private static void writeCsv(File out, Map<String, RecalibrationReport> reports, Covariate[] c) throws FileNotFoundException {
        CsvPrinter p = RecalUtils.csvPrinter(out, c);
        for (Map.Entry<String, RecalibrationReport> e : reports.entrySet()) {
            p.print(e.getValue(), e.getKey());
        }
        p.close();
    }

    private static List<GATKReportTable> generateReportTables(RecalibrationTables recalibrationTables, Covariate[] requestedCovariates, boolean sortByCols) {
        LinkedList<GATKReportTable> result = new LinkedList<GATKReportTable>();
        int reportTableIndex = 0;
        int rowIndex = 0;
        HashMap<Covariate, String> covariateNameMap = new HashMap<Covariate, String>(requestedCovariates.length);
        for (Covariate covariate : requestedCovariates) {
            covariateNameMap.put(covariate, RecalUtils.parseCovariateName(covariate));
        }
        for (int tableIndex = 0; tableIndex < recalibrationTables.numTables(); ++tableIndex) {
            GATKReportTable reportTable;
            ArrayList<Pair<Object, String>> columnNames = new ArrayList<Pair<Object, String>>();
            columnNames.add(new Pair(covariateNameMap.get(requestedCovariates[0]), "%s"));
            if (tableIndex != RecalibrationTables.TableType.READ_GROUP_TABLE.ordinal()) {
                columnNames.add(new Pair(covariateNameMap.get(requestedCovariates[1]), "%s"));
                if (tableIndex >= RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal()) {
                    columnNames.add(covariateValue);
                    columnNames.add(covariateName);
                }
            }
            columnNames.add(eventType);
            columnNames.add(empiricalQuality);
            if (tableIndex == RecalibrationTables.TableType.READ_GROUP_TABLE.ordinal()) {
                columnNames.add(estimatedQReported);
            }
            columnNames.add(nObservations);
            columnNames.add(nErrors);
            if (tableIndex <= RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal()) {
                reportTable = sortByCols ? new GATKReportTable("RecalTable" + reportTableIndex++, "", columnNames.size(), GATKReportTable.TableSortingWay.SORT_BY_COLUMN) : new GATKReportTable("RecalTable" + reportTableIndex++, "", columnNames.size(), GATKReportTable.TableSortingWay.DO_NOT_SORT);
                for (Pair pair : columnNames) {
                    reportTable.addColumn((String)pair.getFirst(), (String)pair.getSecond());
                }
                rowIndex = 0;
            } else {
                reportTable = (GATKReportTable)result.get(RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal());
            }
            NestedIntegerArray<RecalDatum> table = recalibrationTables.getTable(tableIndex);
            for (NestedIntegerArray.Leaf<RecalDatum> row : table.getAllLeaves()) {
                RecalDatum datum = (RecalDatum)row.value;
                int[] keys = row.keys;
                int columnIndex = 0;
                int keyIndex = 0;
                reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)requestedCovariates[0].formatKey(keys[keyIndex++]));
                if (tableIndex != RecalibrationTables.TableType.READ_GROUP_TABLE.ordinal()) {
                    reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)requestedCovariates[1].formatKey(keys[keyIndex++]));
                    if (tableIndex >= RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal()) {
                        Covariate covariate = requestedCovariates[tableIndex];
                        reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)covariate.formatKey(keys[keyIndex++]));
                        reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), covariateNameMap.get(covariate));
                    }
                }
                EventType event = EventType.eventFrom(keys[keyIndex]);
                reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)event.toString());
                reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)datum.getEmpiricalQuality());
                if (tableIndex == RecalibrationTables.TableType.READ_GROUP_TABLE.ordinal()) {
                    reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)datum.getEstimatedQReported());
                }
                reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex++)).getFirst(), (Object)datum.getNumObservations());
                reportTable.set((Object)rowIndex, (String)((Pair)columnNames.get(columnIndex)).getFirst(), (Object)datum.getNumMismatches());
                ++rowIndex;
            }
            result.add(reportTable);
        }
        return result;
    }

    private static String parseCovariateName(Covariate covariate) {
        return covariate.getClass().getSimpleName().split("Covariate")[0];
    }

    public static String covariateNames(Covariate[] requestedCovariates) {
        ArrayList<String> names = new ArrayList<String>(requestedCovariates.length);
        for (Covariate cov : requestedCovariates) {
            names.add(cov.getClass().getSimpleName());
        }
        return Utils.join(",", names);
    }

    public static void outputRecalibrationReport(RecalibrationArgumentCollection RAC, QuantizationInfo quantizationInfo, RecalibrationTables recalibrationTables, Covariate[] requestedCovariates, boolean sortByCols) {
        GATKReport report = RecalUtils.createRecalibrationGATKReport(RAC.generateReportTable(RecalUtils.covariateNames(requestedCovariates)), quantizationInfo.generateReportTable(sortByCols), RecalUtils.generateReportTables(recalibrationTables, requestedCovariates, sortByCols));
        report.print(RAC.RECAL_TABLE);
    }

    public static GATKReport createRecalibrationGATKReport(GATKReportTable argumentTable, QuantizationInfo quantizationInfo, RecalibrationTables recalibrationTables, Covariate[] requestedCovariates, boolean sortByCols) {
        return RecalUtils.createRecalibrationGATKReport(argumentTable, quantizationInfo.generateReportTable(sortByCols), RecalUtils.generateReportTables(recalibrationTables, requestedCovariates, sortByCols));
    }

    private static GATKReport createRecalibrationGATKReport(GATKReportTable argumentTable, GATKReportTable quantizationTable, List<GATKReportTable> recalTables) {
        GATKReport report = new GATKReport();
        report.addTable(argumentTable);
        report.addTable(quantizationTable);
        report.addTables(recalTables);
        return report;
    }

    public static void generatePlots(File csvFile, File exampleReportFile, File output) {
        RScriptExecutor executor = new RScriptExecutor();
        executor.setExceptOnError(true);
        executor.addScript(new Resource(SCRIPT_FILE, RecalUtils.class));
        executor.addArgs(csvFile.getAbsolutePath());
        executor.addArgs(exampleReportFile.getAbsolutePath());
        executor.addArgs(output.getAbsolutePath());
        Logger.getLogger(RecalUtils.class).debug((Object)("R command line: " + executor.getApproximateCommandLine()));
        executor.exec();
    }

    private static void outputRecalibrationPlot(File csvFile, RecalibrationArgumentCollection RAC) {
        RScriptExecutor executor = new RScriptExecutor();
        executor.addScript(new Resource(SCRIPT_FILE, RecalUtils.class));
        executor.addArgs(csvFile.getAbsolutePath());
        executor.addArgs(RAC.RECAL_TABLE_FILE.getAbsolutePath());
        executor.exec();
    }

    @Deprecated
    public static void generateRecalibrationPlot(RecalibrationArgumentCollection RAC, RecalibrationTables original, Covariate[] requestedCovariates) {
        RecalUtils.generateRecalibrationPlot(RAC, original, null, requestedCovariates);
    }

    @Deprecated
    public static void generateRecalibrationPlot(RecalibrationArgumentCollection RAC, RecalibrationTables original, RecalibrationTables recalibrated, Covariate[] requestedCovariates) {
        PrintStream csvStream;
        File csvTempFile = null;
        try {
            File csvTmpFile = File.createTempFile("BQSR", ".csv");
            csvTmpFile.deleteOnExit();
            csvStream = new PrintStream(csvTmpFile);
        }
        catch (IOException e) {
            throw new UserException("Could not create temporary csv file", e);
        }
        if (recalibrated != null) {
            RecalUtils.writeCSV(csvStream, recalibrated, "RECALIBRATED", requestedCovariates, true);
        }
        RecalUtils.writeCSV(csvStream, original, "ORIGINAL", requestedCovariates, recalibrated == null);
        csvStream.close();
        RecalUtils.outputRecalibrationPlot(csvTempFile, RAC);
        csvTempFile.delete();
    }

    private static void writeCSV(PrintStream deltaTableFile, RecalibrationTables recalibrationTables, String recalibrationMode, Covariate[] requestedCovariates, boolean printHeader) {
        NestedIntegerArray<RecalDatum> deltaTable = RecalUtils.createDeltaTable(recalibrationTables, requestedCovariates.length);
        NestedIntegerArray<RecalDatum> qualTable = recalibrationTables.getQualityScoreTable();
        for (NestedIntegerArray.Leaf<RecalDatum> leaf : qualTable.getAllLeaves()) {
            int[] newCovs = new int[]{leaf.keys[0], requestedCovariates.length, leaf.keys[1], leaf.keys[2]};
            RecalUtils.addToDeltaTable(deltaTable, newCovs, (RecalDatum)leaf.value);
        }
        for (int i = RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal(); i < requestedCovariates.length; ++i) {
            NestedIntegerArray<RecalDatum> covTable = recalibrationTables.getTable(i);
            for (NestedIntegerArray.Leaf<RecalDatum> leaf : covTable.getAllLeaves()) {
                int[] covs = new int[]{leaf.keys[0], i, leaf.keys[2], leaf.keys[3]};
                RecalUtils.addToDeltaTable(deltaTable, covs, (RecalDatum)leaf.value);
            }
        }
        if (printHeader) {
            RecalUtils.printHeader(deltaTableFile);
        }
        HashMap<Covariate, String> covariateNameMap = new HashMap<Covariate, String>(requestedCovariates.length);
        for (Covariate covariate : requestedCovariates) {
            covariateNameMap.put(covariate, RecalUtils.parseCovariateName(covariate));
        }
        for (NestedIntegerArray.Leaf<RecalDatum> leaf : deltaTable.getAllLeaves()) {
            List<Object> deltaKeys = RecalUtils.generateValuesFromKeys(leaf.keys, requestedCovariates, covariateNameMap);
            RecalDatum deltaDatum = (RecalDatum)leaf.value;
            deltaTableFile.print(Utils.join(",", deltaKeys));
            deltaTableFile.print("," + deltaDatum.stringForCSV());
            deltaTableFile.println("," + recalibrationMode);
        }
    }

    private static void printHeader(PrintStream out) {
        LinkedList<String> header = new LinkedList<String>();
        header.add(READGROUP_COLUMN_NAME);
        header.add(COVARIATE_VALUE_COLUMN_NAME);
        header.add(COVARIATE_NAME_COLUMN_NAME);
        header.add(EVENT_TYPE_COLUMN_NAME);
        header.add(NUMBER_OBSERVATIONS_COLUMN_NAME);
        header.add(NUMBER_ERRORS_COLUMN_NAME);
        header.add(EMPIRICAL_QUALITY_COLUMN_NAME);
        header.add("AverageReportedQuality");
        header.add("Accuracy");
        header.add("Recalibration");
        out.println(Utils.join(",", header));
    }

    @Requires(value={"recalibrationTables != null && numCovariates > 0"})
    @Ensures(value={"result != null"})
    private static NestedIntegerArray<RecalDatum> createDeltaTable(RecalibrationTables recalibrationTables, int numCovariates) {
        int[] dimensionsForDeltaTable = new int[4];
        NestedIntegerArray<RecalDatum> qualTable = recalibrationTables.getQualityScoreTable();
        int[] dimensionsOfQualTable = qualTable.getDimensions();
        dimensionsForDeltaTable[0] = dimensionsOfQualTable[0];
        dimensionsForDeltaTable[1] = numCovariates + 1;
        dimensionsForDeltaTable[2] = dimensionsOfQualTable[1];
        dimensionsForDeltaTable[3] = dimensionsOfQualTable[2];
        for (int i = RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.ordinal(); i < numCovariates; ++i) {
            NestedIntegerArray<RecalDatum> covTable = recalibrationTables.getTable(i);
            int[] dimensionsOfCovTable = covTable.getDimensions();
            dimensionsForDeltaTable[2] = Math.max(dimensionsForDeltaTable[2], dimensionsOfCovTable[2]);
            dimensionsForDeltaTable[3] = Math.max(dimensionsForDeltaTable[3], dimensionsOfCovTable[3]);
        }
        return new NestedIntegerArray<RecalDatum>(dimensionsForDeltaTable);
    }

    protected static List<Object> generateValuesFromKeys(int[] keys, Covariate[] covariates, Map<Covariate, String> covariateNameMap) {
        ArrayList<Object> values = new ArrayList<Object>(4);
        values.add(covariates[RecalibrationTables.TableType.READ_GROUP_TABLE.ordinal()].formatKey(keys[0]));
        int covariateIndex = keys[1];
        int covariateKey = keys[2];
        Covariate covariate = covariateIndex == covariates.length ? covariates[RecalibrationTables.TableType.QUALITY_SCORE_TABLE.ordinal()] : covariates[covariateIndex];
        values.add(covariate.formatKey(covariateKey));
        values.add(covariateNameMap.get(covariate));
        values.add(EventType.eventFrom(keys[3]).prettyPrint());
        return values;
    }

    private static void addToDeltaTable(NestedIntegerArray<RecalDatum> deltaTable, int[] deltaKey, RecalDatum recalDatum) {
        RecalDatum deltaDatum = deltaTable.get(deltaKey);
        if (deltaDatum == null) {
            deltaTable.put(new RecalDatum(recalDatum), deltaKey);
        } else {
            deltaDatum.combine(recalDatum);
        }
    }

    public static void parsePlatformForRead(GATKSAMRecord read, RecalibrationArgumentCollection RAC) {
        GATKSAMReadGroupRecord readGroup = read.getReadGroup();
        if (!(RAC.FORCE_PLATFORM == null || readGroup.getPlatform() != null && readGroup.getPlatform().equals(RAC.FORCE_PLATFORM))) {
            readGroup.setPlatform(RAC.FORCE_PLATFORM);
        }
        if (readGroup.getPlatform() == null) {
            if (RAC.DEFAULT_PLATFORM != null) {
                if (!warnUserNullPlatform) {
                    Utils.warnUser("The input .bam file contains reads with no platform information. Defaulting to platform = " + RAC.DEFAULT_PLATFORM + ". " + "First observed at read with name = " + read.getReadName());
                    warnUserNullPlatform = true;
                }
                readGroup.setPlatform(RAC.DEFAULT_PLATFORM);
            } else {
                throw new UserException.MalformedBAM((SAMRecord)read, "The input .bam file contains reads with no platform information. First observed at read with name = " + read.getReadName());
            }
        }
    }

    public static boolean isColorSpaceConsistent(SOLID_NOCALL_STRATEGY strategy, GATKSAMRecord read) {
        if (!ReadUtils.isSOLiDRead(read)) {
            return true;
        }
        if (read.getAttribute(COLOR_SPACE_INCONSISTENCY_TAG) == null) {
            Object attr = read.getAttribute(COLOR_SPACE_ATTRIBUTE_TAG);
            if (attr != null) {
                if (!(attr instanceof String)) {
                    throw new UserException.MalformedBAM((SAMRecord)read, String.format("Value encoded by %s in %s isn't a string!", COLOR_SPACE_ATTRIBUTE_TAG, read.getReadName()));
                }
                byte[] colorSpace = ((String)attr).getBytes();
                boolean badColor = RecalUtils.hasNoCallInColorSpace(colorSpace);
                if (badColor) {
                    if (strategy == SOLID_NOCALL_STRATEGY.LEAVE_READ_UNRECALIBRATED) {
                        return false;
                    }
                    if (strategy == SOLID_NOCALL_STRATEGY.PURGE_READ) {
                        read.setReadFailsVendorQualityCheckFlag(true);
                        return false;
                    }
                }
                byte[] readBases = read.getReadBases();
                if (read.getReadNegativeStrandFlag()) {
                    readBases = BaseUtils.simpleReverseComplement(read.getReadBases());
                }
                byte[] inconsistency = new byte[readBases.length];
                byte prevBase = colorSpace[0];
                for (int i = 0; i < readBases.length; ++i) {
                    byte thisBase = RecalUtils.getNextBaseFromColor(read, prevBase, colorSpace[i + 1]);
                    inconsistency[i] = (byte)(thisBase != readBases[i] ? 1 : 0);
                    prevBase = readBases[i];
                }
                read.setAttribute(COLOR_SPACE_INCONSISTENCY_TAG, inconsistency);
            } else {
                if (strategy == SOLID_NOCALL_STRATEGY.THROW_EXCEPTION) {
                    throw new UserException.MalformedBAM((SAMRecord)read, "Unable to find color space information in SOLiD read. First observed at read with name = " + read.getReadName() + " Unfortunately this .bam file can not be recalibrated without color space information because of potential reference bias.");
                }
                return false;
            }
        }
        return true;
    }

    private static boolean hasNoCallInColorSpace(byte[] colorSpace) {
        int length = colorSpace.length;
        for (int i = 1; i < length; ++i) {
            byte color = colorSpace[i];
            if (color == 48 || color == 49 || color == 50 || color == 51) continue;
            return true;
        }
        return false;
    }

    private static byte getNextBaseFromColor(GATKSAMRecord read, byte prevBase, byte color) {
        switch (color) {
            case 48: {
                return prevBase;
            }
            case 49: {
                return RecalUtils.performColorOne(prevBase);
            }
            case 50: {
                return RecalUtils.performColorTwo(prevBase);
            }
            case 51: {
                return RecalUtils.performColorThree(prevBase);
            }
        }
        throw new UserException.MalformedBAM((SAMRecord)read, "Unrecognized color space in SOLID read, color = " + (char)color + " Unfortunately this bam file can not be recalibrated without full color space information because of potential reference bias.");
    }

    public static boolean isColorSpaceConsistent(GATKSAMRecord read, int offset) {
        Object attr = read.getAttribute(COLOR_SPACE_INCONSISTENCY_TAG);
        if (attr != null) {
            byte[] inconsistency = (byte[])attr;
            if (read.getReadNegativeStrandFlag()) {
                return inconsistency[inconsistency.length - offset - 1] == 0;
            }
            return inconsistency[offset] == 0;
        }
        return true;
    }

    public static ReadCovariates computeCovariates(GATKSAMRecord read, Covariate[] requestedCovariates) {
        ReadCovariates readCovariates = new ReadCovariates(read.getReadLength(), requestedCovariates.length);
        RecalUtils.computeCovariates(read, requestedCovariates, readCovariates);
        return readCovariates;
    }

    public static void computeCovariates(GATKSAMRecord read, Covariate[] requestedCovariates, ReadCovariates resultsStorage) {
        for (int i = 0; i < requestedCovariates.length; ++i) {
            resultsStorage.setCovariateIndex(i);
            requestedCovariates[i].recordValues(read, resultsStorage);
        }
    }

    private static byte performColorOne(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 67;
            }
            case 67: 
            case 99: {
                return 65;
            }
            case 71: 
            case 103: {
                return 84;
            }
            case 84: 
            case 116: {
                return 71;
            }
        }
        return base;
    }

    private static byte performColorTwo(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 71;
            }
            case 67: 
            case 99: {
                return 84;
            }
            case 71: 
            case 103: {
                return 65;
            }
            case 84: 
            case 116: {
                return 67;
            }
        }
        return base;
    }

    private static byte performColorThree(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
        }
        return base;
    }

    public static void combineTables(NestedIntegerArray<RecalDatum> table1, NestedIntegerArray<RecalDatum> table2) {
        if (table1 == null) {
            throw new IllegalArgumentException("table1 cannot be null");
        }
        if (table2 == null) {
            throw new IllegalArgumentException("table2 cannot be null");
        }
        if (!Arrays.equals(table1.getDimensions(), table2.getDimensions())) {
            throw new IllegalArgumentException("Table1 " + Utils.join(",", table1.getDimensions()) + " not equal to " + Utils.join(",", table2.getDimensions()));
        }
        for (NestedIntegerArray.Leaf<RecalDatum> row : table2.getAllLeaves()) {
            RecalDatum myDatum = table1.get(row.keys);
            if (myDatum == null) {
                table1.put((RecalDatum)row.value, row.keys);
                continue;
            }
            myDatum.combine((RecalDatum)row.value);
        }
    }

    public static void incrementDatumOrPutIfNecessary(NestedIntegerArray<RecalDatum> table, byte qual, double isError, int ... keys) {
        RecalDatum existingDatum = table.get(keys);
        if (existingDatum == null) {
            if (!table.put(RecalUtils.createDatumObject(qual, isError), keys)) {
                table.get(keys).increment(1L, isError);
            }
        } else {
            existingDatum.increment(1L, isError);
        }
    }

    private static RecalDatum createDatumObject(byte reportedQual, double isError) {
        return new RecalDatum(1L, isError, reportedQual);
    }

    public static enum SOLID_NOCALL_STRATEGY {
        THROW_EXCEPTION,
        LEAVE_READ_UNRECALIBRATED,
        PURGE_READ;


        public static SOLID_NOCALL_STRATEGY nocallStrategyFromString(String nocallStrategy) {
            if (nocallStrategy.equals("THROW_EXCEPTION")) {
                return THROW_EXCEPTION;
            }
            if (nocallStrategy.equals("LEAVE_READ_UNRECALIBRATED")) {
                return LEAVE_READ_UNRECALIBRATED;
            }
            if (nocallStrategy.equals("PURGE_READ")) {
                return PURGE_READ;
            }
            throw new UserException.BadArgumentValue(nocallStrategy, "is not a valid SOLID_NOCALL_STRATEGY value");
        }
    }

    public static enum SOLID_RECAL_MODE {
        DO_NOTHING,
        SET_Q_ZERO,
        SET_Q_ZERO_BASE_N,
        REMOVE_REF_BIAS;


        public static SOLID_RECAL_MODE recalModeFromString(String recalMode) {
            if (recalMode.equals("DO_NOTHING")) {
                return DO_NOTHING;
            }
            if (recalMode.equals("SET_Q_ZERO")) {
                return SET_Q_ZERO;
            }
            if (recalMode.equals("SET_Q_ZERO_BASE_N")) {
                return SET_Q_ZERO_BASE_N;
            }
            if (recalMode.equals("REMOVE_REF_BIAS")) {
                return REMOVE_REF_BIAS;
            }
            throw new UserException.BadArgumentValue(recalMode, "is not a valid SOLID_RECAL_MODE value");
        }
    }

    private static class CsvPrinter {
        private final PrintStream ps;
        private final Covariate[] covariates;

        protected CsvPrinter(File out, Covariate ... c) throws FileNotFoundException {
            this(new FileOutputStream(out), c);
        }

        protected CsvPrinter(OutputStream os, Covariate ... c) {
            this.covariates = c == null ? new Covariate[]{} : (Covariate[])c.clone();
            this.ps = new PrintStream(os);
            this.printHeader();
        }

        protected void printHeader() {
            RecalUtils.printHeader(this.ps);
        }

        public void print(RecalibrationReport report, String mode) {
            RecalUtils.writeCSV(this.ps, report.getRecalibrationTables(), mode, this.covariates, false);
        }

        public void close() {
            this.ps.close();
        }
    }
}

