/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import edu.harvard.hul.ois.jhove.module.html.JHOpenTag;
import java.util.LinkedList;
import java.util.ListIterator;

public class HtmlStack
extends LinkedList {
    private HtmlTagDesc headElement;
    private HtmlTagDesc bodyElement;
    private HtmlTagDesc framesetElement;
    private boolean headSeen;
    private boolean bodySeen;

    protected void setHeadElement(HtmlTagDesc htmlTagDesc) {
        this.headElement = htmlTagDesc;
    }

    protected void setBodyElement(HtmlTagDesc htmlTagDesc) {
        this.bodyElement = htmlTagDesc;
    }

    protected void setFramesetElement(HtmlTagDesc htmlTagDesc) {
        this.bodyElement = htmlTagDesc;
    }

    protected void popp() {
        this.removeLast();
    }

    @Override
    protected void push(JHOpenTag jHOpenTag) {
        this.add(jHOpenTag);
        HtmlTagDesc htmlTagDesc = jHOpenTag.getElement();
        if (htmlTagDesc == this.headElement) {
            this.headSeen = true;
        } else if (htmlTagDesc == this.bodyElement) {
            this.bodySeen = true;
        }
    }

    protected JHOpenTag top() {
        return (JHOpenTag)this.getLast();
    }

    protected int search(String string) {
        ListIterator listIterator = this.listIterator(this.size());
        int n = this.size() - 1;
        while (listIterator.hasPrevious()) {
            JHOpenTag jHOpenTag = (JHOpenTag)listIterator.previous();
            HtmlTagDesc htmlTagDesc = jHOpenTag.getElement();
            if (htmlTagDesc.matches(string)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    protected void popTo(int n) {
        int n2 = this.size() - n;
        for (int i = 0; i < n2; ++i) {
            this.removeLast();
        }
    }

    protected boolean isHeadSeen() {
        return this.headSeen;
    }

    protected boolean isBodySeen() {
        return this.bodySeen;
    }

    protected boolean excludesTag(String string) {
        for (JHOpenTag jHOpenTag : this) {
            if (!jHOpenTag.getElement().excludesTag(string)) continue;
            return true;
        }
        return false;
    }
}

