/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.WaveStrings;
import java.io.DataInputStream;
import java.io.IOException;

public class FormatChunk
extends Chunk {
    public static final int WAVE_FORMAT_PCM = 1;
    public static final int WAVE_FORMAT_MPEG = 80;
    public static final int WAVE_FORMAT_EXTENSIBLE = 65534;
    private static final int[] losslessCodecs = new int[]{355, 6513};

    public FormatChunk(WaveModule waveModule, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(waveModule, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        int n = -1;
        byte[] byArray = null;
        long l = -1L;
        int n2 = waveModule.readUnsignedShort(this._dstream);
        waveModule.setCompressionCode(n2);
        int n3 = waveModule.readUnsignedShort(this._dstream);
        long l2 = waveModule.readUnsignedInt(this._dstream);
        waveModule.setSampleRate(l2);
        long l3 = waveModule.readUnsignedInt(this._dstream);
        int n4 = waveModule.readUnsignedShort(this._dstream);
        waveModule.setBlockAlign(n4);
        int n5 = waveModule.readUnsignedShort(this._dstream);
        this.bytesLeft -= 16L;
        byte[] byArray2 = null;
        if (this.bytesLeft > 0L) {
            int n6 = waveModule.readUnsignedShort(this._dstream);
            byArray2 = new byte[n6];
            if (n2 == 65534 && this.bytesLeft >= 22L) {
                boolean bl = true;
                n = waveModule.readUnsignedShort(this._dstream);
                l = waveModule.readUnsignedInt(this._dstream);
                byArray = new byte[20];
                ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
                if ((n5 + 7) / 8 * n3 != n4) {
                    bl = false;
                }
                if (n5 % 8 != 0) {
                    bl = false;
                }
                if (n > n5) {
                    bl = false;
                }
                if (bl) {
                    waveModule.setWaveFormatExtensible(true);
                }
            } else {
                if (n2 != 1 || (n5 + 7) / 8 * n3 == n4) {
                    waveModule.setWaveFormatEx(true);
                }
                ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray2, (ModuleBase)waveModule);
            }
            if ((n6 & 1) != 0) {
                this._module.skipBytes(this._dstream, 1, (ModuleBase)waveModule);
            }
        } else if (n2 == 1 && (n5 + 7) / 8 * n3 == n4) {
            waveModule.setPCMWaveFormat(true);
        }
        if (n2 == 1 || n2 == 80) {
            waveModule.setBroadcastWave(true);
        }
        waveModule.addWaveProperty(waveModule.addIntegerProperty("CompressionCode", n2, WaveStrings.COMPRESSION_FORMAT, WaveStrings.COMPRESSION_INDEX));
        AESAudioMetadata aESAudioMetadata = waveModule.getAESMetadata();
        String string = WaveStrings.COMPRESSION_FORMAT[WaveStrings.COMPRESSION_INDEX[n2]];
        aESAudioMetadata.setAudioDataEncoding(string);
        aESAudioMetadata.setNumChannels(n3);
        this.setChannelLocations(aESAudioMetadata, n3);
        aESAudioMetadata.setSampleRate((double)l2);
        aESAudioMetadata.setBitDepth(n5);
        String string2 = "LOSSY";
        for (int i = 0; i < losslessCodecs.length; ++i) {
            if (n2 != losslessCodecs[i]) continue;
            string2 = "CODE_REGENERATING";
        }
        if (n2 == 1) {
            aESAudioMetadata.clearBitrateReduction();
        } else {
            aESAudioMetadata.setBitrateReduction(string, "", "", "", string2, Long.toString(l3), "FIXED");
        }
        waveModule.addWaveProperty(new Property("AverageBytesPerSecond", PropertyType.LONG, (Object)new Long(l3)));
        waveModule.addWaveProperty(new Property("BlockAlign", PropertyType.INTEGER, (Object)new Integer(n4)));
        if (byArray2 != null) {
            waveModule.addWaveProperty(new Property("ExtraFormatBytes", PropertyType.BYTE, PropertyArity.ARRAY, (Object)byArray2));
        }
        if (n != -1) {
            waveModule.addWaveProperty(new Property("ValidBitsPerSample", PropertyType.INTEGER, (Object)new Integer(n)));
        }
        if (l != -1L) {
            waveModule.addWaveProperty(new Property("ChannelMask", PropertyType.LONG, (Object)new Long(l)));
        }
        if (byArray != null) {
            waveModule.addWaveProperty(new Property("Subformat", PropertyType.BYTE, PropertyArity.ARRAY, (Object)byArray));
        }
        return true;
    }

    private void setChannelLocations(AESAudioMetadata aESAudioMetadata, int n) {
        String[] stringArray = new String[n];
        switch (n) {
            case 2: {
                stringArray[0] = "LEFT";
                stringArray[1] = "RIGHT";
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = "UNKNOWN";
                }
            }
        }
        aESAudioMetadata.setMapLocations(stringArray);
    }
}

