#######################################################################

### This file contains Distutil setup() for building UTimposter package 

###########################################################################

from distutils.core import setup, Extension
from distutils.command.sdist import sdist
from distutils.command.install_data import install_data
from distutils.command.install_lib import install_lib
from distutils.command.install import install
from distutils.command.build import build
from distutils.command.bdist_dumb import bdist_dumb
from glob import glob
import os, sys
from os import path

platform = sys.platform

buildExt = True
if platform in ('sunos5', 'linux2', 'irix6'):
    if not path.isfile("/usr/lib/libCgGL.so"):
        print "Warning: Can not build UTimposter extension. libCgGL.so is required"
        buildExt = False
# 
#  HACK: replace cc with CC (gcc with g++)
CC_exe = 'CC'
cc_exe = 'cc'

if platform in ("linux2", "darwin"):
    CC_exe = 'g++'
    cc_exe = 'gcc'
from distutils import sysconfig
save_init_posix = sysconfig._init_posix

def my_init_posix():
    save_init_posix()
    g = sysconfig._config_vars
    for n,r in [('LDSHARED',CC_exe),('CC',CC_exe)]:
        if g[n][:3] == cc_exe:
            print 'my_init_posix: changing %s = %r'%(n,g[n]),
            g[n] = r+g[n][3:]
            print 'to',`g[n]`
if platform in ('sunos5', 'linux2', 'irix6', 'darwin'):
    sysconfig._init_posix = my_init_posix

# Change the order of commands that are called by "build"
# so that 'byuld_py' comes after 'build_ext'. In this case
# 'build_py' will install python modules generated by
# 'build_ext'.

class modified_build(build):

    sub_commands = [('build_clib',    build.has_c_libraries),
                    ('build_ext',     build.has_ext_modules),
                    ('build_py',      build.has_pure_modules),
                    ('build_scripts', build.has_scripts),
                    ]

# Overwrite the prune_file_list method of sdist to not
# remove automatically the RCS/CVS directory from the distribution.


class modified_sdist(sdist):
    def prune_file_list(self):
        """
        """
        build = self.get_finalized_command('build')
        base_dir = self.distribution.get_fullname()
        self.filelist.exclude_pattern(None, prefix=build.build_base)
        self.filelist.exclude_pattern(None, prefix=base_dir)



packFullName = "UTpackages.UTimposter"
packName = "UTimposter"

# List of the python packages to be included in this distribution.
# sdist does not go recursively into subpackages so they need to be
# explicitly listed.
# From these packages only the python modules will be taken
packages = [packFullName, packFullName+".Tests"]


# libImposterRenderer.a
imposter_source_files = ["BallRenderer.cpp", "FunctionSphereRenderer.cpp",
                         "GaussianRenderer.cpp", "GlobalCGContext.cpp",
                         "HelixRenderer.cpp", "HollowCylinderRenderer.cpp",
                         "ImposterRenderer.cpp", "MeshCylinderRenderer.cpp",
                         "MeshHelixRenderer.cpp", "MeshSphereRenderer.cpp",
                         "PlainSphereRenderer.cpp", "sphereDrawing.cpp",
                         "StickRenderer.cpp", "Texture.cpp"]
for i in range(len(imposter_source_files)):
    imposter_source_files[i] = path.join("src", "ImposterRenderer", imposter_source_files[i])
source_include = [path.join("src", "ImposterRenderer"),
                  path.join("src", "UsefulMath"),
                  path.join("src", "OpenGL_Viewer")]

import numpy
numpy_include =  numpy.get_include()
source_include.append(numpy_include)

#libUsefulMath.a
math_source_files = ["LinearAlgebra.cpp", "Matrix.cpp", "Vector.cpp",  "Quaternion.cpp", "Ray.cpp", "Tuple.cpp"]
for i in range(len(math_source_files)):
    math_source_files[i] = path.join("src", "UsefulMath", math_source_files[i])


#libOpenGL_Viewer.a


viewer_source_files = [path.join("src", "OpenGL_Viewer", "MyExtensions.cpp")]

                         

# describe the extensions:
    
# _utimposterrend.so*

imposter_libs = {'posix': [ "GL", "GLU", "CgGL"], 'nt': ['OPENGL32', "CgGL", "GLU"]}.get( os.name, [])

imposter_includes = source_include


imposter_ext = [Extension (
    "_utimposterrend",
    [path.join(packName, "utimposter.i"),],
    include_dirs = imposter_includes,
    libraries = imposter_libs,
    extra_compile_args = []), ]


# description of what is going to be included in the distribution and
# installed.
dist = setup (name = packFullName,
              version = '1.0',
              description = "Volume Rendering Library python package",
              author = 'Molecular Graphics Laboratory',
              author_email = 'mgltools@scripps.edu',
              download_url = 'http://www.scripps.edu/~sanner/software/packager.html',
              url = 'http://www.scripps.edu/~sanner/software/index.html',
              packages = packages,
              package_dir = {packFullName: packName},
              libraries = [('ImposterRenderer',
                            {'sources': imposter_source_files,
                             'include_dirs': source_include} ),
                           ('OpenGL_Viewer',
                            {'sources': viewer_source_files,
                             'include_dirs': source_include} ),
                           ("UsefulMath",
                            {'sources': math_source_files,
                             'include_dirs': source_include})] ,
              ext_modules = imposter_ext,
              ext_package = packFullName,
              cmdclass = {'sdist': modified_sdist,
                          'build': modified_build,
                          },
              )
