# Code of Conduct

## On diversity

One of the great things about Free/Libre and Open Source Software is its
potential for diverse participation: all you need is a computer, an internet
connection, a chunk of free time and the desire to do something.

A further advantage of the FLOSS model is software can be modified to meet the
needs of underrepresented groups. These might otherwise not have enough
critical mass to convince the producers of proprietary software to cater to
them, and with FLOSS should be able to take matters into their own hands.

So far we have only scratched the surface of this potential.

## On governance

Notion is a relatively small community. At this scale it doesn't seem worth it
to set up a governance structure as found in larger communities, so raboof is
acting as a BDFN: "Benevolent Dictator For Now".
We will revisit this choice when the community grows.

## Guidelines

To clarify what kind of behaviour we encourage in our community, we have taken
inspiration from the
[Community Guidelines](https://wiki.blender.org/wiki/Contact/CodeOfConduct)
used in the Blender project:

*Be respectful and considerate*

* Disagreement is no excuse for poor behaviour or personal attacks.
* Remember that a community where people feel uncomfortable is not a productive one.

*Be patient and generous*

* If someone asks for help it is because they need it.
* Do politely suggest specific documentation or more appropriate venues where appropriate, but avoid aggressive or vague responses.

*Assume people mean well*

* Remember that decisions are often a difficult choice between competing priorities.
* If you disagree, please do so politely.
* If something seems outrageous, check that you did not misinterpret it.
* Ask for clarification rather than assuming the worst.

*Try to be concise*

* Avoid repeating what has been said already.
* Making a conversation larger makes it difficult to follow, and people often feel personally attacked if they receive multiple messages telling them the same thing.

## In case of problems

If, despite the above guidelines, you would ever feel disrespected or even
threatened, feel free to contact Arnout Engelen (raboof). All such reports
will be treated with respect and privacy, and we will work together to find a
way to resolve the situation.

We recognize that misunderstandings happen and well-meant actions may have
unintended effects. We will only take actions when a user appears unwilling or
unable to sufficiently adjust their behaviour after repeated conversations.
