#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Virus Named Tom
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220628.1

GAME_ID='a-virus-named-tom'
GAME_NAME='A Virus Named Tom'

ARCHIVE_BASE_0='avnt-09172013-bin'
ARCHIVE_BASE_0_MD5='85d11d3f05ad966a06a7e2f77e2fee45'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='270000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/a-virus-named-tom'

CONTENT_PATH_DEFAULT='data'
ARCHIVE_DOC_DATA_FILES='
Linux.README'
ARCHIVE_GAME_BIN32_FILES='
*.x86
lib'
ARCHIVE_GAME_BIN64_FILES='
*.x86_64
lib64'
ARCHIVE_GAME_DATA_FILES='
A?Virus?Named?TOM.bmp
AVirusNamedTOM
*.dll
*.exe
Content
mono
*.config
Xml'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='CircuitGame.bin.x86'
APP_MAIN_EXE_BIN64='CircuitGame.bin.x86_64'
APP_MAIN_ICON='A Virus Named TOM.bmp'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
