#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Celeste
# send your bug reports to contact@dotslashplay.it
###

script_version=20230125.2

GAME_ID='celeste'
GAME_NAME='Celeste'

ARCHIVE_BASE_1='celeste-linux.zip'
ARCHIVE_BASE_1_MD5='518ea69d60079109a2575d428eff8a53'
ARCHIVE_BASE_1_SIZE='1200000'
ARCHIVE_BASE_1_VERSION='1.4.0.0-itch.2021.03.29'
ARCHIVE_BASE_1_URL='https://maddymakesgamesinc.itch.io/celeste'

## WARNING - Informations about older archives are kept,
## but they will not be used due to name collisions with the newest archive
## cf. https://forge.dotslashplay.it/play.it/scripts/-/issues/355
ARCHIVE_BASE_0='celeste-linux.zip'
ARCHIVE_BASE_0_MD5='b27c983b95b2a2a35a272b7ecd94cbc2'
ARCHIVE_BASE_0_SIZE='1400000'
ARCHIVE_BASE_0_VERSION='1.3.1.2-itch'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_MAIN_FILES='
Content
Celeste.exe
Celeste.exe.config
Celeste.png
gamecontrollerdb.txt
Celeste.Content.dll
FNA.dll
FNA.dll.config
FNA3D.dll'

APP_MAIN_EXE='Celeste.exe'
APP_MAIN_ICON='Celeste.png'

PKG_MAIN_DEPS='mono'
PKG_MAIN_DEPENDENCIES_LIBRARIES='
libGL.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libXrandr.so.2'
PKG_MAIN_DEPENDENCIES_MONO_LIBRARIES='
mscorlib.dll
Mono.Posix.dll
Mono.Security.dll
System.dll
System.Configuration.dll
System.Core.dll
System.Data.dll
System.Drawing.dll
System.Numerics.dll
System.Runtime.Serialization.dll
System.Security.dll
System.Xml.dll
System.Xml.Linq.dll'

# Include shipped libraries that can not be replaced by system ones

CONTENT_LIBS_LIBS32_PATH="${CONTENT_PATH_DEFAULT}/lib"
CONTENT_LIBS_LIBS32_FILES='
libfmod*.so*
libmojoshader.so'
CONTENT_LIBS_LIBS64_PATH="${CONTENT_PATH_DEFAULT}/lib64"
CONTENT_LIBS_LIBS64_FILES='
libfmod*.so*
libmojoshader.so
libFNA3D.so.0'

PACKAGES_LIST='PKG_MAIN PKG_LIBS32 PKG_LIBS64'

PKG_LIBS_ID="${GAME_ID}-libs"
PKG_LIBS32_ID="$PKG_LIBS_ID"
PKG_LIBS32_ARCH='32'
PKG_LIBS64_ID="$PKG_LIBS_ID"
PKG_LIBS64_ARCH='64'

PKG_MAIN_DEPS="$PKG_MAIN_DEPS $PKG_LIBS_ID"

# Load common functions

target_version='2.20'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"
	set_standard_permissions .
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
