#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Hamilton: The Dating Sim
# send your bug reports to contact@dotslashplay.it
###

script_version=20240326.2

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='hamilton-the-dating-sim'
GAME_NAME='Hamilton: The Dating Sim'

ARCHIVE_BASE_0_NAME='HamiltonTheDatingSim-2.1.1-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='764b130ee2b0a940c4977295eff994cb'
ARCHIVE_BASE_0_SIZE='73000'
ARCHIVE_BASE_0_VERSION='2.1.1-itch.2019.08.23'
ARCHIVE_BASE_0_URL='https://timidsquid.itch.io/hamilton-the-dating-sim'

RENPY_NAME='HamiltonTheDatingSim'

CONTENT_PATH_DEFAULT='HamiltonTheDatingSim-2.1.1-linux'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/lib/linux-x86_64"
CONTENT_LIBS_BIN_FILES='
libGLEW.so.1.7
libavcodec.so.57
libavformat.so.57
libavresample.so.3
libavutil.so.55
libpng12.so.0
libpython2.7.so.1.0
libswresample.so.2
libswscale.so.4'
CONTENT_GAME_BIN_FILES="
lib/linux-x86_64/lib/python2.7
lib/linux-x86_64/python
lib/linux-x86_64/pythonw
lib/linux-x86_64/zsync
lib/linux-x86_64/zsyncmake
lib/linux-x86_64/${RENPY_NAME}"
CONTENT_GAME_DATA_FILES="
game
renpy
lib/pythonlib2.7
${RENPY_NAME}.py"

APP_MAIN_EXE="lib/linux-x86_64/${RENPY_NAME}"
APP_MAIN_OPTIONS="-EO ${RENPY_NAME}.py"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfreetype.so.6
libGL.so.1
libGLU.so.1
libjpeg.so.62
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_ttf-2.0.so.0
libutil.so.1
libX11.so.6
libXext.so.6
libXi.so.6
libXmu.so.6
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Use default Ren'Py icon if it is available

desktop_field_icon() {
	printf 'renpy'
}

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
