#!/bin/sh
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslahsplay.it>
set -o errexit

###
# Puzzle Agent 1
# send your bug reports to contact@dotslashplay.it
###

script_version=20240517.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='puzzle-agent-1'
GAME_NAME='Puzzle Agent'

ARCHIVE_BASE_1_NAME='setup_puzzle_agent_1.0_(21444).exe'
ARCHIVE_BASE_1_MD5='b986c9a9ed5bce6f8329cc76965ee295'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='260000'
ARCHIVE_BASE_1_VERSION='1.0-gog21444'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/puzzle_agent'

ARCHIVE_BASE_0_NAME='setup_puzzle_agent_2.0.0.3.exe'
ARCHIVE_BASE_0_MD5='68155b4aff9aa9e28c107f5b2ff994b5'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='260000'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.3'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
## TODO: Check if the Steam library is required.
CONTENT_GAME_BIN_FILES='
fmodex.dll
grickle101.exe
steam_api.dll'
CONTENT_GAME_DATA_FILES='
pack'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/Telltale Games/puzzle-agent'
WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='grickle101.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure smooth upgrade from previous game id.
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
puzzle-agent-data"

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
## Ensure smooth upgrade from previous game id.
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
puzzle-agent"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
