#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2016 Mopi
set -o errexit

###
# Anachronox
###

script_version=20240408.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='anachronox'
GAME_NAME='Anachronox'

ARCHIVE_BASE_1_NAME='setup_anachronox_1.02_(22258).exe'
ARCHIVE_BASE_1_MD5='4e23d4f7637f6914a7cd6c13feb7ad7d'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='1100000'
ARCHIVE_BASE_1_VERSION='1.02-gog22258'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/anachronox'

ARCHIVE_BASE_0_NAME='setup_anachronox_2.0.0.28.exe'
ARCHIVE_BASE_0_MD5='a9e148972e51a4980a2531d12a85dfc0'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='1.02-gog2.0.0.28'

CONTENT_PATH_DEFAULT='.'
CONTENT_PATH_DEFAULT_0='app'
CONTENT_GAME_BIN_FILES='
anoxdata/miles
anoxdata/plugins
*.dll
*.exe
*.inf
*.ini
*.ocx'
CONTENT_GAME_DATA_FILES='
anoxdata
anox.ico
*.jpg'
CONTENT_DOC_DATA_FILES='
manual.pdf
readme.htm
*readme.txt
*.rtf'

USER_PERSISTENT_DIRECTORIES='
anoxdata/save'
USER_PERSISTENT_FILES='
*.ini
anoxdata/nokill.*'

APP_MAIN_EXE='anox.exe'
APP_MAIN_ICON='anox.ico'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Delete unwanted files.
	## TODO: Use a more explicit list of files to include, so this is no longer required.
	rm --force --recursive \
		'__redist' \
		'commonappdata' \
		'galaxy_anachronox_2.1.0.29.exe' \
		'tmp'
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
