#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Startopia
###

script_version=20240523.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='startopia'
GAME_NAME='Startopia'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

## Archives

### Full game

ARCHIVE_BASE_0_NAME='setup_startopia_2.0.0.17.exe'
ARCHIVE_BASE_0_MD5='4fe8d194afc1012e136ed3e82f1de171'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='600000'
ARCHIVE_BASE_0_VERSION='1.01b-gog2.0.0.17'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/startopia'

### Free demo

ARCHIVE_BASE_DEMO_0_NAME='startopia_demo.exe'
ARCHIVE_BASE_DEMO_0_MD5='2e170f8c4700b2d271ac2a6fac23920a'
ARCHIVE_BASE_DEMO_0_TYPE='zip'
ARCHIVE_BASE_DEMO_0_SIZE='149364'
ARCHIVE_BASE_DEMO_0_VERSION='2001.5.15.1-archive.org'
ARCHIVE_BASE_DEMO_0_URL='https://archive.org/details/startopia_demo'


CONTENT_PATH_DEFAULT='app'
CONTENT_PATH_DEFAULT_DEMO='.'
CONTENT_GAME_BIN_FILES='
binkw32.dll
startopia.exe
startopia.ini'
CONTENT_GAME_DATA_FILES='
cardid.tom
data
intro
languageinis
missions
startopia.jpg
text'
CONTENT_DOC_DATA_FILES='
eula
weblinks
*.doc
*.html
*.pdf
*.rtf
*.txt'

USER_PERSISTENT_DIRECTORIES='
profiles'
USER_PERSISTENT_FILES='
startopia.ini'

WINE_VIRTUAL_DESKTOP='auto'

APP_MAIN_EXE='startopia.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## Free demo - Convert all file paths to lowercase.
	case "$(current_archive)" in
		('ARCHIVE_BASE_DEMO_'*)
			tolower .
		;;
	esac

	## Generate a minimal configuration file.
	config_file='startopia.ini'
	game_path="C:\\$(game_id)"
	intro_path="${game_path}\\intro\\"
	drive_path_music="${game_path}\\data\\"
	drive_path_sound="${game_path}\\data\\"
	drive_path_voice="${game_path}\\data\\"
	cat > "$config_file" <<- EOF
	[Intro]
	IntroPath=$intro_path
	[Sound]
	DrivePathMusic=$drive_path_music
	DrivePathSound=$drive_path_sound
	SoundPathVoice=$drive_path_voice
	EOF
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
