#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Excavation of Hob's Barrow
###

script_version=20240413.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='the-excavation-of-hobs-barrow'
GAME_NAME='The Excavation of Hobʼs Barrow'

ARCHIVE_BASE_0_NAME='the_excavation_of_hob_s_barrow_1_05_59783.sh'
ARCHIVE_BASE_0_MD5='4282957f61e4cbea9c333bc99e56660a'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.05-gog59783'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_excavation_of_hobs_barrow'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
*.cfg
*.exe
*.vox'

APP_MAIN_SCUMMID='ags:excavationhb'
APP_MAIN_ICON='TEOHB.exe'

## Prevent conflicts with packages generated with pre-20230926.2 game scripts.
PKG_MAIN_PROVIDES='
the-excavation-of-hobs-barrow-common'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
