/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.memory.LowMemory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.store.access.XATransactionController;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnectionContext;
import org.apache.derby.impl.jdbc.EmbedSQLWarning;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import org.apache.derby.jdbc.InternalDriver;

public abstract class EmbedConnection
implements EngineConnection {
    private static final StandardException exceptionClose = StandardException.closeException();
    public static final SQLException NO_MEM = Util.generateCsSQLException("08004", "java.lang.OutOfMemoryError");
    public static final LowMemory memoryState = new LowMemory();
    DatabaseMetaData dbMetadata;
    TransactionResourceImpl tr;
    private HashMap lobHashMap = null;
    private int lobHMKey = 0;
    private boolean active;
    boolean autoCommit = true;
    boolean needCommit;
    private boolean usingNoneAuth;
    private int connectionHoldAbility = 1;
    final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    private InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String connString;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_SHUTDOWN = 1;
    private static final int OP_HARD_UPGRADE = 2;

    public EmbedConnection(InternalDriver internalDriver, String string, Properties properties) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = internalDriver;
        this.tr = new TransactionResourceImpl(internalDriver, string, properties);
        this.active = true;
        this.setupContextStack();
        try {
            EmbedConnectionContext embedConnectionContext = this.pushConnectionContext(this.tr.getContextManager());
            boolean bl = Boolean.valueOf(properties.getProperty("shutdown"));
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", this.tr.getDBName());
            boolean bl2 = this.createBoot(properties);
            boolean bl3 = !bl2 && this.isEncryptionBoot(properties);
            boolean bl4 = !bl2 && this.isHardUpgradeBoot(properties);
            Properties properties2 = null;
            if (database != null) {
                this.tr.setDatabase(database);
                bl3 = false;
                bl4 = false;
            } else if (!bl) {
                if (bl3 || bl4) {
                    properties2 = properties;
                    properties = this.removePhaseTwoProps((Properties)properties.clone());
                }
                if (!this.bootDatabase(properties, bl4)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
            }
            if (bl2 && !bl) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(null, properties);
                    database = this.createDatabase(this.tr.getDBName(), properties);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                String string2 = this.tr.getDBName();
                this.setInactive();
                throw this.newSQLException("XJ004.C", string2);
            }
            this.checkUserCredentials(this.tr.getDBName(), properties);
            this.tr.startTransaction();
            if (bl3 || bl4) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(bl3 ? 0 : 2);
                }
                properties = properties2;
                this.handleException(this.tr.shutdownDatabaseException());
                this.restoreContextStack();
                this.tr = new TransactionResourceImpl(internalDriver, string, properties);
                this.active = true;
                this.setupContextStack();
                embedConnectionContext = this.pushConnectionContext(this.tr.getContextManager());
                if (!this.bootDatabase(properties, false)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
                this.tr.startTransaction();
            }
            if (bl) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                throw this.tr.shutdownDatabaseException();
            }
            if (this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J14"));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.restoreContextStack();
            this.tr.lcc = null;
            this.tr.cm = null;
            memoryState.setLowMemory();
            throw NO_MEM;
        }
        catch (Throwable throwable) {
            StandardException standardException;
            if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getSeverity() < 40000) {
                standardException.setSeverity(40000);
            }
            this.tr.cleanupOnError(throwable);
            throw this.handleException(throwable);
        }
        finally {
            this.restoreContextStack();
        }
    }

    private boolean createBoot(Properties properties) throws SQLException {
        int n = 0;
        if (Boolean.valueOf(properties.getProperty("create")).booleanValue()) {
            ++n;
        }
        int n2 = 0;
        if (properties.getProperty("createFrom") != null) {
            ++n2;
        }
        if (properties.getProperty("restoreFrom") != null) {
            ++n2;
        }
        if (properties.getProperty("rollForwardRecoveryFrom") != null) {
            ++n2;
        }
        if (n2 > 1) {
            throw this.newSQLException("XJ081.C");
        }
        if (n2 != 0 && this.isEncryptionBoot(properties)) {
            throw this.newSQLException("XJ081.C");
        }
        if ((n += n2) > 1) {
            throw this.newSQLException("XJ049.C");
        }
        return n - n2 == 1;
    }

    private boolean isEncryptionBoot(Properties properties) {
        return Boolean.valueOf(properties.getProperty("dataEncryption")) != false || properties.getProperty("newBootPassword") != null || properties.getProperty("newEncryptionKey") != null;
    }

    private boolean isHardUpgradeBoot(Properties properties) {
        return Boolean.valueOf(properties.getProperty("upgrade"));
    }

    private Properties removePhaseTwoProps(Properties properties) {
        properties.remove("dataEncryption");
        properties.remove("newBootPassword");
        properties.remove("newEncryptionKey");
        properties.remove("upgrade");
        return properties;
    }

    public EmbedConnection(EmbedConnection embedConnection) {
        this.autoCommit = false;
        this.tr = null;
        this.active = true;
        this.rootConnection = embedConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = embedConnection.factory;
        this.connectionHoldAbility = embedConnection.connectionHoldAbility;
    }

    private void checkUserCredentials(String string, Properties properties) throws SQLException {
        AuthenticationService authenticationService = null;
        authenticationService = string == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        if (authenticationService == null) {
            String string2 = MessageService.getTextMessage(string == null ? "A001" : "A002");
            throw this.newSQLException("08004", string2);
        }
        if (!authenticationService.authenticate(string, properties)) {
            throw this.newSQLException("08004", MessageService.getTextMessage("A020"));
        }
        if (authenticationService instanceof NoneAuthenticationServiceImpl) {
            this.usingNoneAuth = true;
        }
    }

    private void checkIsDBOwner(int n) throws SQLException {
        String string;
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnection();
        String string2 = languageConnectionContext.getAuthorizationId();
        if (!string2.equals(string = languageConnectionContext.getDataDictionary().getAuthorizationDatabaseOwner())) {
            switch (n) {
                case 0: {
                    throw this.newSQLException("08004.C.5", string2, this.tr.getDBName());
                }
                case 1: {
                    throw this.newSQLException("08004.C.4", string2, this.tr.getDBName());
                }
                case 2: {
                    throw this.newSQLException("08004.C.6", string2, this.tr.getDBName());
                }
            }
            throw this.newSQLException("08004.C.3");
        }
    }

    public int getEngineType() {
        Database database = this.getDatabase();
        if (null == database) {
            return 0;
        }
        return database.getEngineType();
    }

    public final Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility);
    }

    public final Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.connectionHoldAbility);
    }

    public final Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(n), n2, n3);
    }

    public final PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.connectionHoldAbility, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareStatement(string, n, n2, n3, 2, null, null);
    }

    public final PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, nArray == null ? 2 : 1, nArray, null);
    }

    public final PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, stringArray == null ? 2 : 1, null, stringArray);
    }

    public final PreparedStatement prepareStatement(String string, int n) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.connectionHoldAbility, n, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(String string, int n, int n2, int n3, int n4, int[] nArray, String[] stringArray) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            PreparedStatement preparedStatement;
            this.setupContextStack();
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, string, false, this.setResultSetType(n), n2, n3, n4, nArray, stringArray);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return preparedStatement;
        }
    }

    public final CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, this.connectionHoldAbility);
    }

    public final CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.connectionHoldAbility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkIfClosed();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            CallableStatement callableStatement;
            this.setupContextStack();
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, string, this.setResultSetType(n), n2, n3);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkIfClosed();
        return string;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && bl) {
            throw this.newSQLException("XJ030.S");
        }
        if (this.autoCommit != bl) {
            this.commit();
        }
        this.autoCommit = bl;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getTR().rollback();
                this.clearLOBMapping();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    public void close() throws SQLException {
        if (!(this.isClosed() || this.rootConnection != this || this.autoCommit || this.transactionIsIdle())) {
            throw this.newSQLException("25000");
        }
        this.close(exceptionClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(StandardException standardException) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rootConnection == this && this.active) {
                if (this.tr.isActive()) {
                    this.setupContextStack();
                    try {
                        this.tr.rollback();
                        this.tr.clearLcc();
                        this.tr.cleanupOnError(standardException);
                    }
                    catch (Throwable throwable) {
                        throw this.handleException(throwable);
                    }
                    finally {
                        this.restoreContextStack();
                    }
                } else {
                    this.tr.clearLcc();
                    this.tr.cleanupOnError(standardException);
                }
            }
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
    }

    public final boolean isClosed() {
        return !this.active || !this.getTR().isActive();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    public final int getHoldability() throws SQLException {
        this.checkIfClosed();
        return this.connectionHoldAbility;
    }

    public final void setHoldability(int n) throws SQLException {
        this.checkIfClosed();
        this.connectionHoldAbility = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReadOnly(boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setReadOnly(bl);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        return this.getLanguageConnection().isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
        this.checkIfClosed();
    }

    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionIsolation(int n) throws SQLException {
        int n2;
        if (n == this.getTransactionIsolation()) {
            return;
        }
        switch (n) {
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                throw this.newSQLException("XJ045.S", new Integer(n));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().setIsolationLevel(n2);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getLanguageConnection().getCurrentIsolationLevel()];
    }

    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.topWarning;
    }

    public final synchronized void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.topWarning = null;
    }

    public Map getTypeMap() throws SQLException {
        this.checkIfClosed();
        return Collections.EMPTY_MAP;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.Connection.setTypeMap");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
    }

    public final synchronized void addWarning(SQLWarning sQLWarning) {
        if (this.topWarning == null) {
            this.topWarning = sQLWarning;
            return;
        }
        this.topWarning.setNextWarning(sQLWarning);
    }

    public String getDBName() {
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        return this.getTR().getLcc();
    }

    protected final void checkIfClosed() throws SQLException {
        if (this.isClosed()) {
            throw Util.noCurrentConnection();
        }
    }

    SQLException handleException(Throwable throwable) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(throwable, this.autoCommit, true);
    }

    final SQLException handleException(Throwable throwable, boolean bl) throws SQLException {
        if (throwable instanceof StandardException && ((StandardException)throwable).getSeverity() >= 30000) {
            this.clearLOBMapping();
        }
        return this.getTR().handleException(throwable, this.autoCommit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (!this.active) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.active = false;
            this.dbMetadata = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.rootConnection == this) {
                this.close(exceptionClose);
            }
        }
        finally {
            super.finalize();
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            this.needCommit = false;
        }
    }

    protected void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit();
                this.clearLOBMapping();
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            this.needCommit = false;
        }
    }

    protected final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    protected final void setupContextStack() throws SQLException {
        this.checkIfClosed();
        this.getTR().setupContextStack();
    }

    protected final void restoreContextStack() throws SQLException {
        TransactionResourceImpl transactionResourceImpl = this.getTR();
        transactionResourceImpl.restoreContextStack();
    }

    private Database createDatabase(String string, Properties properties) throws SQLException {
        properties = this.filterProperties(properties);
        try {
            if (Monitor.createPersistentService("org.apache.derby.database.Database", string, properties) == null) {
                this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J01", string));
            }
        }
        catch (StandardException standardException) {
            throw Util.seeNextException("XJ041.C", new Object[]{string}, this.handleException(standardException));
        }
        properties.clear();
        return (Database)Monitor.findService("org.apache.derby.database.Database", string);
    }

    private boolean bootDatabase(Properties properties, boolean bl) throws Throwable {
        String string = this.tr.getDBName();
        try {
            properties = this.filterProperties(properties);
            if (bl) {
                properties.setProperty("softUpgradeNoFeatureCheck", "true");
            } else {
                properties.remove("softUpgradeNoFeatureCheck");
            }
            if (!Monitor.startPersistentService(string, properties)) {
                return false;
            }
            properties.clear();
            Database database = (Database)Monitor.findService("org.apache.derby.database.Database", string);
            this.tr.setDatabase(database);
        }
        catch (StandardException standardException) {
            Throwable throwable = standardException.getCause();
            SQLException sQLException = throwable instanceof StandardException ? Util.generateCsSQLException((StandardException)throwable) : (throwable != null ? Util.javaException(throwable) : Util.generateCsSQLException(standardException));
            throw Util.seeNextException("XJ040.C", new Object[]{string}, sQLException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreparedStatement prepareMetaDataStatement(String string) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.factory.newEmbedPreparedStatement(this, string, true, 1003, 1007, this.connectionHoldAbility, 2, null, null);
            }
            finally {
                this.restoreContextStack();
            }
            return preparedStatement;
        }
    }

    public final InternalDriver getLocalDriver() {
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("derby.")) continue;
            properties2.put(string, properties.getProperty(string));
        }
        return properties2;
    }

    protected Database getDatabase() {
        return this.getTR().getDatabase();
    }

    protected final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager contextManager) {
        return new EmbedConnectionContext(contextManager, this);
    }

    public final void setApplicationConnection(Connection connection) {
        this.applicationConnection = connection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    public void setDrdaID(String string) {
        this.getLanguageConnection().setDrdaID(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFromPool() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().resetFromPool();
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                XATransactionController xATransactionController = (XATransactionController)this.getLanguageConnection().getTransactionExecute();
                int n = xATransactionController.xa_prepare();
                if (n == 1) {
                    this.getLanguageConnection().internalCommit(false);
                }
                int n2 = n;
                return n2;
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean bl) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaCommit(bl);
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            try {
                this.getLanguageConnection().xaRollback();
            }
            catch (StandardException standardException) {
                throw this.handleException(standardException);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int n) {
        if (n == 1005) {
            this.addWarning(EmbedSQLWarning.newEmbedSQLWarning("01J02"));
            n = 1004;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrepareIsolation(int n) throws SQLException {
        if (n == this.getPrepareIsolation()) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw Util.generateCsSQLException("XJ045.S", new Integer(n));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.getLanguageConnection().setPrepareIsolationLevel(n);
        }
    }

    public int getPrepareIsolation() {
        return this.getLanguageConnection().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    protected SQLException newSQLException(String string) {
        return Util.generateCsSQLException(string);
    }

    protected SQLException newSQLException(String string, Object object) {
        return Util.generateCsSQLException(string, object);
    }

    protected SQLException newSQLException(String string, Object object, Object object2) {
        return Util.generateCsSQLException(string, object, object2);
    }

    public String toString() {
        if (this.connString == null) {
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnection();
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "(XID = " + languageConnectionContext.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + Integer.toString(languageConnectionContext.getInstanceNumber()) + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + ") ";
        }
        return this.connString;
    }

    public Clob createClob() throws SQLException {
        this.checkIfClosed();
        return new EmbedClob(this);
    }

    public Blob createBlob() throws SQLException {
        this.checkIfClosed();
        return new EmbedBlob(new byte[0], this);
    }

    public int addLOBMapping(Object object) {
        int n = this.getIncLOBKey();
        this.getlobHMObj().put(new Integer(n), object);
        return n;
    }

    public void removeLOBMapping(int n) {
        this.getlobHMObj().remove(new Integer(n));
    }

    public Object getLOBMapping(int n) {
        return this.getlobHMObj().get(new Integer(n));
    }

    public void clearLOBMapping() throws SQLException {
        if (this.rootConnection.lobHashMap != null) {
            Iterator iterator = this.getlobHMObj().values().iterator();
            while (iterator.hasNext()) {
                ConnectionChild connectionChild;
                Object v = iterator.next();
                if (v instanceof Clob) {
                    connectionChild = (EmbedClob)v;
                    ((EmbedClob)connectionChild).free();
                }
                if (!(v instanceof Blob)) continue;
                connectionChild = (EmbedBlob)v;
                ((EmbedBlob)connectionChild).free();
            }
            this.getlobHMObj().clear();
        }
    }

    private int getIncLOBKey() {
        return ++this.rootConnection.lobHMKey;
    }

    public HashMap getlobHMObj() {
        if (this.rootConnection.lobHashMap == null) {
            this.rootConnection.lobHashMap = new HashMap();
        }
        return this.rootConnection.lobHashMap;
    }

    public void cancelRunningStatement() {
        this.getLanguageConnection().getStatementContext().cancel();
    }
}

