/* $Id: tstIEMAImplDataFpuBinary2.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data - r150743 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_BINARY_R64_TEST_T const g_aTests_fadd_r80_by_r64[] =
{
    { 0x0000, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/0/0/u */
    { 0x007f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe296500000000000,16121) }, /* #0/0/0/c */
    { 0x0100, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/0/1/u */
    { 0x017f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0af000,16121) }, /* #0/0/1/c */
    { 0x0200, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/0/2/u */
    { 0x027f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0af000,16121) }, /* #0/0/2/c */
    { 0x0300, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/0/3/u */
    { 0x037f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0af000,16121) }, /* #0/0/3/c */
    { 0x0400, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/1/0/u */
    { 0x047f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe296510000000000,16121) }, /* #0/1/0/c */
    { 0x0500, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/1/1/u */
    { 0x057f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0af000,16121) }, /* #0/1/1/c */
    { 0x0600, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/1/2/u */
    { 0x067f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0af000,16121) }, /* #0/1/2/c */
    { 0x0700, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/1/3/u */
    { 0x077f, 0xa869, 0x3a22, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0af000,16121) }, /* #0/1/3/c */
    { 0x0800, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/2/0/u */
    { 0x087f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe296500000000000,16121) }, /* #0/2/0/c */
    { 0x0900, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/2/1/u */
    { 0x097f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0aefff,16121) }, /* #0/2/1/c */
    { 0x0a00, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/2/2/u */
    { 0x0a7f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0ae800,16121) }, /* #0/2/2/c */
    { 0x0b00, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/2/3/u */
    { 0x0b7f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0aefff,16121) }, /* #0/2/3/c */
    { 0x0c00, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/3/0/u */
    { 0x0c7f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe296500000000000,16121) }, /* #0/3/0/c */
    { 0x0d00, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/3/1/u */
    { 0x0d7f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0aefff,16121) }, /* #0/3/1/c */
    { 0x0e00, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/3/2/u */
    { 0x0e7f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0ae800,16121) }, /* #0/3/2/c */
    { 0x0f00, 0xa869, 0xb882, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0) }, /* #0/3/3/u */
    { 0x0f7f, 0xa869, 0x3822, RTFLOAT80U_INIT_C(0,0x80000008891ee6a7,0), RTFLOAT64U_INIT_C(1,0xc52ca06a1c15e,761), RTFLOAT80U_INIT_C(1,0xe29650350e0aefff,16121) }, /* #0/3/3/c */
    { 0x0000, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/0/0/u */
    { 0x007f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/0/c */
    { 0x0100, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/0/1/u */
    { 0x017f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/1/c */
    { 0x0200, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/0/2/u */
    { 0x027f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/2/c */
    { 0x0300, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/0/3/u */
    { 0x037f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/0/3/c */
    { 0x0400, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/1/0/u */
    { 0x047f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/0/c */
    { 0x0500, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/1/1/u */
    { 0x057f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/1/c */
    { 0x0600, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/1/2/u */
    { 0x067f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/2/c */
    { 0x0700, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/1/3/u */
    { 0x077f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/1/3/c */
    { 0x0800, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/2/0/u */
    { 0x087f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/0/c */
    { 0x0900, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/2/1/u */
    { 0x097f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/1/c */
    { 0x0a00, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/2/2/u */
    { 0x0a7f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/2/c */
    { 0x0b00, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/2/3/u */
    { 0x0b7f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/2/3/c */
    { 0x0c00, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/3/0/u */
    { 0x0c7f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/0/c */
    { 0x0d00, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/3/1/u */
    { 0x0d7f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/1/c */
    { 0x0e00, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/3/2/u */
    { 0x0e7f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/2/c */
    { 0x0f00, 0xf7ed, 0xfd81, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198) }, /* #1/3/3/u */
    { 0x0f7f, 0xf7ed, 0x7d01, RTFLOAT80U_INIT_C(1,0xa53a682e36edf76,26198), RTFLOAT64U_INIT_C(0,0x170e26a,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #1/3/3/c */
    { 0x0000, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/0/0/u */
    { 0x007f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/0/c */
    { 0x0100, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/0/1/u */
    { 0x017f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/1/c */
    { 0x0200, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/0/2/u */
    { 0x027f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/2/c */
    { 0x0300, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/0/3/u */
    { 0x037f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/3/c */
    { 0x0400, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/1/0/u */
    { 0x047f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/0/c */
    { 0x0500, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/1/1/u */
    { 0x057f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/1/c */
    { 0x0600, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/1/2/u */
    { 0x067f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/2/c */
    { 0x0700, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/1/3/u */
    { 0x077f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/3/c */
    { 0x0800, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/2/0/u */
    { 0x087f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/0/c */
    { 0x0900, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/2/1/u */
    { 0x097f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/1/c */
    { 0x0a00, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/2/2/u */
    { 0x0a7f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/2/c */
    { 0x0b00, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/2/3/u */
    { 0x0b7f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/3/c */
    { 0x0c00, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/3/0/u */
    { 0x0c7f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/0/c */
    { 0x0d00, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/3/1/u */
    { 0x0d7f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/1/c */
    { 0x0e00, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/3/2/u */
    { 0x0e7f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/2/c */
    { 0x0f00, 0xdd88, 0xfd81, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999) }, /* #2/3/3/u */
    { 0x0f7f, 0xdd88, 0x7d01, RTFLOAT80U_INIT_C(1,0x4bfb029ac032522b,8999), RTFLOAT64U_INIT_C(0,0x332b4489c8fb6,1425), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/3/c */
    { 0x0000, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/0/u */
    { 0x007f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/0/c */
    { 0x0100, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/1/u */
    { 0x017f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/1/c */
    { 0x0200, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/2/u */
    { 0x027f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/2/c */
    { 0x0300, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/3/u */
    { 0x037f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/0/3/c */
    { 0x0400, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/0/u */
    { 0x047f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/0/c */
    { 0x0500, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/1/u */
    { 0x057f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/1/c */
    { 0x0600, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/2/u */
    { 0x067f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/2/c */
    { 0x0700, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/3/u */
    { 0x077f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/1/3/c */
    { 0x0800, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/0/u */
    { 0x087f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/0/c */
    { 0x0900, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/1/u */
    { 0x097f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/1/c */
    { 0x0a00, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/2/u */
    { 0x0a7f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/2/c */
    { 0x0b00, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/3/u */
    { 0x0b7f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/2/3/c */
    { 0x0c00, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/0/u */
    { 0x0c7f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/0/c */
    { 0x0d00, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/1/u */
    { 0x0d7f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/1/c */
    { 0x0e00, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/2/u */
    { 0x0e7f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/2/c */
    { 0x0f00, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/3/u */
    { 0x0f7f, 0xa25f, 0x3800, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x5417db2bd8552,1592), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #3/3/3/c */
    { 0x0000, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/0/0/u */
    { 0x007f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/0/c */
    { 0x0100, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/0/1/u */
    { 0x017f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/1/c */
    { 0x0200, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/0/2/u */
    { 0x027f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/2/c */
    { 0x0300, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/0/3/u */
    { 0x037f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/3/c */
    { 0x0400, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/1/0/u */
    { 0x047f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/0/c */
    { 0x0500, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/1/1/u */
    { 0x057f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/1/c */
    { 0x0600, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/1/2/u */
    { 0x067f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/2/c */
    { 0x0700, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/1/3/u */
    { 0x077f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/3/c */
    { 0x0800, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/2/0/u */
    { 0x087f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/0/c */
    { 0x0900, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/2/1/u */
    { 0x097f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/1/c */
    { 0x0a00, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/2/2/u */
    { 0x0a7f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/2/c */
    { 0x0b00, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/2/3/u */
    { 0x0b7f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/3/c */
    { 0x0c00, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/3/0/u */
    { 0x0c7f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/0/c */
    { 0x0d00, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/3/1/u */
    { 0x0d7f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/1/c */
    { 0x0e00, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/3/2/u */
    { 0x0e7f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/2/c */
    { 0x0f00, 0x8089, 0xb881, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404) }, /* #4/3/3/u */
    { 0x0f7f, 0x8089, 0x3801, RTFLOAT80U_INIT_C(1,0x14a4ff71b64320c9,5404), RTFLOAT64U_INIT_C(0,0xe836d9e30e2ad,1330), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/3/c */
    { 0x0000, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/0/0/u */
    { 0x007f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/0/c */
    { 0x0100, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/0/1/u */
    { 0x017f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/1/c */
    { 0x0200, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/0/2/u */
    { 0x027f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/2/c */
    { 0x0300, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/0/3/u */
    { 0x037f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/3/c */
    { 0x0400, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/1/0/u */
    { 0x047f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/0/c */
    { 0x0500, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/1/1/u */
    { 0x057f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/1/c */
    { 0x0600, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/1/2/u */
    { 0x067f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/2/c */
    { 0x0700, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/1/3/u */
    { 0x077f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/3/c */
    { 0x0800, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/2/0/u */
    { 0x087f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/0/c */
    { 0x0900, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/2/1/u */
    { 0x097f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/1/c */
    { 0x0a00, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/2/2/u */
    { 0x0a7f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/2/c */
    { 0x0b00, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/2/3/u */
    { 0x0b7f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/3/c */
    { 0x0c00, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/3/0/u */
    { 0x0c7f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/0/c */
    { 0x0d00, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/3/1/u */
    { 0x0d7f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/1/c */
    { 0x0e00, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/3/2/u */
    { 0x0e7f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/2/c */
    { 0x0f00, 0x7a8b, 0xf881, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991) }, /* #5/3/3/u */
    { 0x0f7f, 0x7a8b, 0x7801, RTFLOAT80U_INIT_C(1,0xe8f9de4e48,17991), RTFLOAT64U_INIT_C(1,0xd1936e5fdcc7d,344), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/3/c */
    { 0x0000, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/0/0/u */
    { 0x007f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/0/0/c */
    { 0x0100, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/0/1/u */
    { 0x017f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/0/1/c */
    { 0x0200, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/0/2/u */
    { 0x027f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/0/2/c */
    { 0x0300, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/0/3/u */
    { 0x037f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/0/3/c */
    { 0x0400, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/1/0/u */
    { 0x047f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/1/0/c */
    { 0x0500, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/1/1/u */
    { 0x057f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/1/1/c */
    { 0x0600, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/1/2/u */
    { 0x067f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/1/2/c */
    { 0x0700, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/1/3/u */
    { 0x077f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/1/3/c */
    { 0x0800, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/2/0/u */
    { 0x087f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/2/0/c */
    { 0x0900, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/2/1/u */
    { 0x097f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/2/1/c */
    { 0x0a00, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/2/2/u */
    { 0x0a7f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/2/2/c */
    { 0x0b00, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/2/3/u */
    { 0x0b7f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/2/3/c */
    { 0x0c00, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/3/0/u */
    { 0x0c7f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/3/0/c */
    { 0x0d00, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/3/1/u */
    { 0x0d7f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/3/1/c */
    { 0x0e00, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/3/2/u */
    { 0x0e7f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/3/2/c */
    { 0x0f00, 0x6fb0, 0xfd81, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287) }, /* #6/3/3/u */
    { 0x0f7f, 0x6fb0, 0x7d01, RTFLOAT80U_INIT_C(0,0xd448f674f8c17dfa,3287), RTFLOAT64U_INIT_C(0,0x684ab08ae3f54,2047), RTFLOAT80U_INIT_C(0,0xf425584571faa000,32767) }, /* #6/3/3/c */
    { 0x0000, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/0/0/u */
    { 0x007f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba60000000000,25667) }, /* #7/0/0/c */
    { 0x0100, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/0/1/u */
    { 0x017f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/0/1/c */
    { 0x0200, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/0/2/u */
    { 0x027f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db800,25667) }, /* #7/0/2/c */
    { 0x0300, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/0/3/u */
    { 0x037f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/0/3/c */
    { 0x0400, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/1/0/u */
    { 0x047f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba60000000000,25667) }, /* #7/1/0/c */
    { 0x0500, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/1/1/u */
    { 0x057f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/1/1/c */
    { 0x0600, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/1/2/u */
    { 0x067f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db800,25667) }, /* #7/1/2/c */
    { 0x0700, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/1/3/u */
    { 0x077f, 0x9294, 0x3a22, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/1/3/c */
    { 0x0800, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/2/0/u */
    { 0x087f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba50000000000,25667) }, /* #7/2/0/c */
    { 0x0900, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/2/1/u */
    { 0x097f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f7,25667) }, /* #7/2/1/c */
    { 0x0a00, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/2/2/u */
    { 0x0a7f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db000,25667) }, /* #7/2/2/c */
    { 0x0b00, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/2/3/u */
    { 0x0b7f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f7,25667) }, /* #7/2/3/c */
    { 0x0c00, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/3/0/u */
    { 0x0c7f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba50000000000,25667) }, /* #7/3/0/c */
    { 0x0d00, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/3/1/u */
    { 0x0d7f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f7,25667) }, /* #7/3/1/c */
    { 0x0e00, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/3/2/u */
    { 0x0e7f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db000,25667) }, /* #7/3/2/c */
    { 0x0f00, 0x9294, 0xb882, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667) }, /* #7/3/3/u */
    { 0x0f7f, 0x9294, 0x3822, RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f8,25667), RTFLOAT64U_INIT_C(0,0xfc0714e6e2e68,0), RTFLOAT80U_INIT_C(1,0x985ba5e5699db4f7,25667) }, /* #7/3/3/c */
    { 0x0000, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/0/0/u */
    { 0x007f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/0/0/c */
    { 0x0100, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/0/1/u */
    { 0x017f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/0/1/c */
    { 0x0200, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/0/2/u */
    { 0x027f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/0/2/c */
    { 0x0300, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/0/3/u */
    { 0x037f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/0/3/c */
    { 0x0400, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/1/0/u */
    { 0x047f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/1/0/c */
    { 0x0500, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/1/1/u */
    { 0x057f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/1/1/c */
    { 0x0600, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/1/2/u */
    { 0x067f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/1/2/c */
    { 0x0700, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/1/3/u */
    { 0x077f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/1/3/c */
    { 0x0800, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/2/0/u */
    { 0x087f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/2/0/c */
    { 0x0900, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/2/1/u */
    { 0x097f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/2/1/c */
    { 0x0a00, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/2/2/u */
    { 0x0a7f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/2/2/c */
    { 0x0b00, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/2/3/u */
    { 0x0b7f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/2/3/c */
    { 0x0c00, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/3/0/u */
    { 0x0c7f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/3/0/c */
    { 0x0d00, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/3/1/u */
    { 0x0d7f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/3/1/c */
    { 0x0e00, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/3/2/u */
    { 0x0e7f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/3/2/c */
    { 0x0f00, 0xb0ec, 0xb881, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319) }, /* #8/3/3/u */
    { 0x0f7f, 0xb0ec, 0x3801, RTFLOAT80U_INIT_C(0,0xb5a9cfd4bdb69034,6319), RTFLOAT64U_INIT_C(1,0x363d209d70,2047), RTFLOAT80U_INIT_C(1,0xc001b1e904eb8000,32767) }, /* #8/3/3/c */
    { 0x0000, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/0/0/u */
    { 0x007f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/0/c */
    { 0x0100, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/0/1/u */
    { 0x017f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/1/c */
    { 0x0200, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/0/2/u */
    { 0x027f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/2/c */
    { 0x0300, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/0/3/u */
    { 0x037f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/3/c */
    { 0x0400, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/1/0/u */
    { 0x047f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/0/c */
    { 0x0500, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/1/1/u */
    { 0x057f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/1/c */
    { 0x0600, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/1/2/u */
    { 0x067f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/2/c */
    { 0x0700, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/1/3/u */
    { 0x077f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/3/c */
    { 0x0800, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/2/0/u */
    { 0x087f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/0/c */
    { 0x0900, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/2/1/u */
    { 0x097f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/1/c */
    { 0x0a00, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/2/2/u */
    { 0x0a7f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/2/c */
    { 0x0b00, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/2/3/u */
    { 0x0b7f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/3/c */
    { 0x0c00, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/3/0/u */
    { 0x0c7f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/0/c */
    { 0x0d00, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/3/1/u */
    { 0x0d7f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/1/c */
    { 0x0e00, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/3/2/u */
    { 0x0e7f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/2/c */
    { 0x0f00, 0x1810, 0xb881, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514) }, /* #9/3/3/u */
    { 0x0f7f, 0x1810, 0x3801, RTFLOAT80U_INIT_C(0,0x27ffd32bf0b8617f,30514), RTFLOAT64U_INIT_C(1,0x71eca52de5c3a,1849), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/3/c */
    { 0x0000, 0x7a60, 0xfaa0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd400000000000,32741) }, /* #10/0/0/u */
    { 0x007f, 0x7a60, 0x7a20, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd400000000000,32741) }, /* #10/0/0/c */
    { 0x0100, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/0/1/u */
    { 0x017f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/0/1/c */
    { 0x0200, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b800,32741) }, /* #10/0/2/u */
    { 0x027f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b800,32741) }, /* #10/0/2/c */
    { 0x0300, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/0/3/u */
    { 0x037f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/0/3/c */
    { 0x0400, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3f0000000000,32741) }, /* #10/1/0/u */
    { 0x047f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3f0000000000,32741) }, /* #10/1/0/c */
    { 0x0500, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/1/1/u */
    { 0x057f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/1/1/c */
    { 0x0600, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b800,32741) }, /* #10/1/2/u */
    { 0x067f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b800,32741) }, /* #10/1/2/c */
    { 0x0700, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/1/3/u */
    { 0x077f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/1/3/c */
    { 0x0800, 0x7a60, 0xfaa0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd400000000000,32741) }, /* #10/2/0/u */
    { 0x087f, 0x7a60, 0x7a20, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd400000000000,32741) }, /* #10/2/0/c */
    { 0x0900, 0x7a60, 0xfaa0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b951,32741) }, /* #10/2/1/u */
    { 0x097f, 0x7a60, 0x7a20, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b951,32741) }, /* #10/2/1/c */
    { 0x0a00, 0x7a60, 0xfaa0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6c000,32741) }, /* #10/2/2/u */
    { 0x0a7f, 0x7a60, 0x7a20, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6c000,32741) }, /* #10/2/2/c */
    { 0x0b00, 0x7a60, 0xfaa0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b951,32741) }, /* #10/2/3/u */
    { 0x0b7f, 0x7a60, 0x7a20, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b951,32741) }, /* #10/2/3/c */
    { 0x0c00, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3f0000000000,32741) }, /* #10/3/0/u */
    { 0x0c7f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3f0000000000,32741) }, /* #10/3/0/c */
    { 0x0d00, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/3/1/u */
    { 0x0d7f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/3/1/c */
    { 0x0e00, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b800,32741) }, /* #10/3/2/u */
    { 0x0e7f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b800,32741) }, /* #10/3/2/c */
    { 0x0f00, 0x7a60, 0xf8a0, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/3/3/u */
    { 0x0f7f, 0x7a60, 0x7820, RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741), RTFLOAT64U_INIT_C(0,0xa67263f91424e,1614), RTFLOAT80U_INIT_C(0,0xb0cd3fe78ae6b950,32741) }, /* #10/3/3/c */
    { 0x0000, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/0/0/u */
    { 0x007f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/0/0/c */
    { 0x0100, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/0/1/u */
    { 0x017f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/0/1/c */
    { 0x0200, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/0/2/u */
    { 0x027f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/0/2/c */
    { 0x0300, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/0/3/u */
    { 0x037f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/0/3/c */
    { 0x0400, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/1/0/u */
    { 0x047f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/1/0/c */
    { 0x0500, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/1/1/u */
    { 0x057f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/1/1/c */
    { 0x0600, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/1/2/u */
    { 0x067f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/1/2/c */
    { 0x0700, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/1/3/u */
    { 0x077f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/1/3/c */
    { 0x0800, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/2/0/u */
    { 0x087f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/2/0/c */
    { 0x0900, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/2/1/u */
    { 0x097f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/2/1/c */
    { 0x0a00, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/2/2/u */
    { 0x0a7f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/2/2/c */
    { 0x0b00, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/2/3/u */
    { 0x0b7f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/2/3/c */
    { 0x0c00, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/3/0/u */
    { 0x0c7f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/3/0/c */
    { 0x0d00, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/3/1/u */
    { 0x0d7f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/3/1/c */
    { 0x0e00, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/3/2/u */
    { 0x0e7f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/3/2/c */
    { 0x0f00, 0x0289, 0xb881, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041) }, /* #11/3/3/u */
    { 0x0f7f, 0x0289, 0x3801, RTFLOAT80U_INIT_C(1,0x9b0770ba6f350bff,22041), RTFLOAT64U_INIT_C(0,0x9,2047), RTFLOAT80U_INIT_C(0,0xc000000000004800,32767) }, /* #11/3/3/c */
    { 0x0000, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/0/0/u */
    { 0x007f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/0/0/c */
    { 0x0100, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/0/1/u */
    { 0x017f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/0/1/c */
    { 0x0200, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/0/2/u */
    { 0x027f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/0/2/c */
    { 0x0300, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/0/3/u */
    { 0x037f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/0/3/c */
    { 0x0400, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/1/0/u */
    { 0x047f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/1/0/c */
    { 0x0500, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/1/1/u */
    { 0x057f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/1/1/c */
    { 0x0600, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/1/2/u */
    { 0x067f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/1/2/c */
    { 0x0700, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/1/3/u */
    { 0x077f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/1/3/c */
    { 0x0800, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/2/0/u */
    { 0x087f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/2/0/c */
    { 0x0900, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/2/1/u */
    { 0x097f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/2/1/c */
    { 0x0a00, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/2/2/u */
    { 0x0a7f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/2/2/c */
    { 0x0b00, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/2/3/u */
    { 0x0b7f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/2/3/c */
    { 0x0c00, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/3/0/u */
    { 0x0c7f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/3/0/c */
    { 0x0d00, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/3/1/u */
    { 0x0d7f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/3/1/c */
    { 0x0e00, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/3/2/u */
    { 0x0e7f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/3/2/c */
    { 0x0f00, 0x9ce5, 0xbc82, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #12/3/3/u */
    { 0x0f7f, 0x9ce5, 0x3c02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT64U_INIT_C(0,0x181,0), RTFLOAT80U_INIT_C(0,0xc080000000000000,15317) }, /* #12/3/3/c */
    { 0x0000, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/0/0/u */
    { 0x007f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/0/c */
    { 0x0100, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/0/1/u */
    { 0x017f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/1/c */
    { 0x0200, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/0/2/u */
    { 0x027f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/2/c */
    { 0x0300, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/0/3/u */
    { 0x037f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/3/c */
    { 0x0400, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/1/0/u */
    { 0x047f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/0/c */
    { 0x0500, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/1/1/u */
    { 0x057f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/1/c */
    { 0x0600, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/1/2/u */
    { 0x067f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/2/c */
    { 0x0700, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/1/3/u */
    { 0x077f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/3/c */
    { 0x0800, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/2/0/u */
    { 0x087f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/0/c */
    { 0x0900, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/2/1/u */
    { 0x097f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/1/c */
    { 0x0a00, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/2/2/u */
    { 0x0a7f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/2/c */
    { 0x0b00, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/2/3/u */
    { 0x0b7f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/3/c */
    { 0x0c00, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/3/0/u */
    { 0x0c7f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/0/c */
    { 0x0d00, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/3/1/u */
    { 0x0d7f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/1/c */
    { 0x0e00, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/3/2/u */
    { 0x0e7f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/2/c */
    { 0x0f00, 0xd58e, 0xfd81, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966) }, /* #13/3/3/u */
    { 0x0f7f, 0xd58e, 0x7d01, RTFLOAT80U_INIT_C(0,0x214ebb3a0aac9897,5966), RTFLOAT64U_INIT_C(0,0x2415d78fea,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/3/c */
    { 0x0000, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/0/0/u */
    { 0x007f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3e00000000000,15360) }, /* #14/0/0/c */
    { 0x0100, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/0/1/u */
    { 0x017f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb1000,15360) }, /* #14/0/1/c */
    { 0x0200, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/0/2/u */
    { 0x027f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb1000,15360) }, /* #14/0/2/c */
    { 0x0300, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/0/3/u */
    { 0x037f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb1000,15360) }, /* #14/0/3/c */
    { 0x0400, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/1/0/u */
    { 0x047f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3df0000000000,15360) }, /* #14/1/0/c */
    { 0x0500, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/1/1/u */
    { 0x057f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb0fff,15360) }, /* #14/1/1/c */
    { 0x0600, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/1/2/u */
    { 0x067f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb0800,15360) }, /* #14/1/2/c */
    { 0x0700, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/1/3/u */
    { 0x077f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb0fff,15360) }, /* #14/1/3/c */
    { 0x0800, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/2/0/u */
    { 0x087f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3e00000000000,15360) }, /* #14/2/0/c */
    { 0x0900, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/2/1/u */
    { 0x097f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb1000,15360) }, /* #14/2/1/c */
    { 0x0a00, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/2/2/u */
    { 0x0a7f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb1000,15360) }, /* #14/2/2/c */
    { 0x0b00, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/2/3/u */
    { 0x0b7f, 0x450d, 0x7f22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb1000,15360) }, /* #14/2/3/c */
    { 0x0c00, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/3/0/u */
    { 0x0c7f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3df0000000000,15360) }, /* #14/3/0/c */
    { 0x0d00, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/3/1/u */
    { 0x0d7f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb0fff,15360) }, /* #14/3/1/c */
    { 0x0e00, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/3/2/u */
    { 0x0e7f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb0800,15360) }, /* #14/3/2/c */
    { 0x0f00, 0x450d, 0xfd82, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123) }, /* #14/3/3/u */
    { 0x0f7f, 0x450d, 0x7d22, RTFLOAT80U_INIT_C(1,0xb583186b1478b407,13123), RTFLOAT64U_INIT_C(0,0x9cc3dfc8c6bb1,0), RTFLOAT80U_INIT_C(0,0x9cc3dfc8c6bb0fff,15360) }, /* #14/3/3/c */
    { 0x0000, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/0/0/u */
    { 0x007f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/0/c */
    { 0x0100, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/0/1/u */
    { 0x017f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/1/c */
    { 0x0200, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/0/2/u */
    { 0x027f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/2/c */
    { 0x0300, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/0/3/u */
    { 0x037f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/3/c */
    { 0x0400, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/1/0/u */
    { 0x047f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/0/c */
    { 0x0500, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/1/1/u */
    { 0x057f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/1/c */
    { 0x0600, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/1/2/u */
    { 0x067f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/2/c */
    { 0x0700, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/1/3/u */
    { 0x077f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/3/c */
    { 0x0800, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/2/0/u */
    { 0x087f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/0/c */
    { 0x0900, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/2/1/u */
    { 0x097f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/1/c */
    { 0x0a00, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/2/2/u */
    { 0x0a7f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/2/c */
    { 0x0b00, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/2/3/u */
    { 0x0b7f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/3/c */
    { 0x0c00, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/3/0/u */
    { 0x0c7f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/0/c */
    { 0x0d00, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/3/1/u */
    { 0x0d7f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/1/c */
    { 0x0e00, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/3/2/u */
    { 0x0e7f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/2/c */
    { 0x0f00, 0xb2e8, 0xb881, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712) }, /* #15/3/3/u */
    { 0x0f7f, 0xb2e8, 0x3801, RTFLOAT80U_INIT_C(1,0x38e68821c86917fe,16712), RTFLOAT64U_INIT_C(1,0x2623d71d84ed,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/3/c */
    { 0x0000, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/0/u */
    { 0x007f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/0/c */
    { 0x0100, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/1/u */
    { 0x017f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/1/c */
    { 0x0200, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/2/u */
    { 0x027f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/2/c */
    { 0x0300, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/3/u */
    { 0x037f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/0/3/c */
    { 0x0400, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/0/u */
    { 0x047f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/0/c */
    { 0x0500, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/1/u */
    { 0x057f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/1/c */
    { 0x0600, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/2/u */
    { 0x067f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/2/c */
    { 0x0700, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/3/u */
    { 0x077f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/1/3/c */
    { 0x0800, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/0/u */
    { 0x087f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/0/c */
    { 0x0900, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/1/u */
    { 0x097f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/1/c */
    { 0x0a00, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/2/u */
    { 0x0a7f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/2/c */
    { 0x0b00, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/3/u */
    { 0x0b7f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/2/3/c */
    { 0x0c00, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/0/u */
    { 0x0c7f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/0/c */
    { 0x0d00, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/1/u */
    { 0x0d7f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/1/c */
    { 0x0e00, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/2/u */
    { 0x0e7f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/2/c */
    { 0x0f00, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/3/u */
    { 0x0f7f, 0xca93, 0x7800, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xecf2fa09ab4d1,2047), RTFLOAT80U_INIT_C(1,0xf6797d04d5a68800,32767) }, /* #16/3/3/c */
    { 0x0000, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/0/0/u */
    { 0x007f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a970000000000,17186) }, /* #17/0/0/c */
    { 0x0100, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/0/1/u */
    { 0x017f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279800,17186) }, /* #17/0/1/c */
    { 0x0200, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/0/2/u */
    { 0x027f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279800,17186) }, /* #17/0/2/c */
    { 0x0300, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/0/3/u */
    { 0x037f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279800,17186) }, /* #17/0/3/c */
    { 0x0400, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/1/0/u */
    { 0x047f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a970000000000,17186) }, /* #17/1/0/c */
    { 0x0500, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/1/1/u */
    { 0x057f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279800,17186) }, /* #17/1/1/c */
    { 0x0600, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/1/2/u */
    { 0x067f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279800,17186) }, /* #17/1/2/c */
    { 0x0700, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/1/3/u */
    { 0x077f, 0x61af, 0x7b22, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279800,17186) }, /* #17/1/3/c */
    { 0x0800, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/2/0/u */
    { 0x087f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a960000000000,17186) }, /* #17/2/0/c */
    { 0x0900, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/2/1/u */
    { 0x097f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d4382797ff,17186) }, /* #17/2/1/c */
    { 0x0a00, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/2/2/u */
    { 0x0a7f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279000,17186) }, /* #17/2/2/c */
    { 0x0b00, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/2/3/u */
    { 0x0b7f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d4382797ff,17186) }, /* #17/2/3/c */
    { 0x0c00, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/3/0/u */
    { 0x0c7f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a960000000000,17186) }, /* #17/3/0/c */
    { 0x0d00, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/3/1/u */
    { 0x0d7f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d4382797ff,17186) }, /* #17/3/1/c */
    { 0x0e00, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/3/2/u */
    { 0x0e7f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d438279000,17186) }, /* #17/3/2/c */
    { 0x0f00, 0x61af, 0xf982, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(0,0x8000000000000025,0) }, /* #17/3/3/u */
    { 0x0f7f, 0x61af, 0x7922, RTFLOAT80U_INIT_C(0,0x8000000000000025,0), RTFLOAT64U_INIT_C(1,0xa2352da8704f3,1826), RTFLOAT80U_INIT_C(1,0xd11a96d4382797ff,17186) }, /* #17/3/3/c */
    { 0x0000, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/0/0/u */
    { 0x007f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c0000000000,15360) }, /* #18/0/0/c */
    { 0x0100, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/0/1/u */
    { 0x017f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/0/1/c */
    { 0x0200, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/0/2/u */
    { 0x027f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/0/2/c */
    { 0x0300, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/0/3/u */
    { 0x037f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/0/3/c */
    { 0x0400, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/1/0/u */
    { 0x047f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c0000000000,15360) }, /* #18/1/0/c */
    { 0x0500, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/1/1/u */
    { 0x057f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/1/1/c */
    { 0x0600, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/1/2/u */
    { 0x067f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/1/2/c */
    { 0x0700, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/1/3/u */
    { 0x077f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/1/3/c */
    { 0x0800, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/2/0/u */
    { 0x087f, 0x3b00, 0x3b22, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3d0000000000,15360) }, /* #18/2/0/c */
    { 0x0900, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/2/1/u */
    { 0x097f, 0x3b00, 0x3b22, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e001,15360) }, /* #18/2/1/c */
    { 0x0a00, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/2/2/u */
    { 0x0a7f, 0x3b00, 0x3b22, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e800,15360) }, /* #18/2/2/c */
    { 0x0b00, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/2/3/u */
    { 0x0b7f, 0x3b00, 0x3b22, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e001,15360) }, /* #18/2/3/c */
    { 0x0c00, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/3/0/u */
    { 0x0c7f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c0000000000,15360) }, /* #18/3/0/c */
    { 0x0d00, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/3/1/u */
    { 0x0d7f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/3/1/c */
    { 0x0e00, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/3/2/u */
    { 0x0e7f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/3/2/c */
    { 0x0f00, 0x3b00, 0xb982, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758) }, /* #18/3/3/u */
    { 0x0f7f, 0x3b00, 0x3922, RTFLOAT80U_INIT_C(0,0x8053e10347241b07,10758), RTFLOAT64U_INIT_C(0,0xae0a3c279186e,0), RTFLOAT80U_INIT_C(0,0xae0a3c279186e000,15360) }, /* #18/3/3/c */
    { 0x0000, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc170000000000,16691) }, /* #19/0/0/u */
    { 0x007f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc170000000000,16691) }, /* #19/0/0/c */
    { 0x0100, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/0/1/u */
    { 0x017f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/0/1/c */
    { 0x0200, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/0/2/u */
    { 0x027f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/0/2/c */
    { 0x0300, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/0/3/u */
    { 0x037f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/0/3/c */
    { 0x0400, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc170000000000,16691) }, /* #19/1/0/u */
    { 0x047f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc170000000000,16691) }, /* #19/1/0/c */
    { 0x0500, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/1/1/u */
    { 0x057f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/1/1/c */
    { 0x0600, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/1/2/u */
    { 0x067f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/1/2/c */
    { 0x0700, 0x9370, 0xbba0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/1/3/u */
    { 0x077f, 0x9370, 0x3b20, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de20000,16691) }, /* #19/1/3/c */
    { 0x0800, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc160000000000,16691) }, /* #19/2/0/u */
    { 0x087f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc160000000000,16691) }, /* #19/2/0/c */
    { 0x0900, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/2/1/u */
    { 0x097f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/2/1/c */
    { 0x0a00, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1f800,16691) }, /* #19/2/2/u */
    { 0x0a7f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1f800,16691) }, /* #19/2/2/c */
    { 0x0b00, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/2/3/u */
    { 0x0b7f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/2/3/c */
    { 0x0c00, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc160000000000,16691) }, /* #19/3/0/u */
    { 0x0c7f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc160000000000,16691) }, /* #19/3/0/c */
    { 0x0d00, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/3/1/u */
    { 0x0d7f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/3/1/c */
    { 0x0e00, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1f800,16691) }, /* #19/3/2/u */
    { 0x0e7f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1f800,16691) }, /* #19/3/2/c */
    { 0x0f00, 0x9370, 0xb9a0, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/3/3/u */
    { 0x0f7f, 0x9370, 0x3920, RTFLOAT80U_INIT_C(0,0xc0135b15039a683c,10084), RTFLOAT64U_INIT_C(1,0x8f982d821bc40,1331), RTFLOAT80U_INIT_C(1,0xc7cc16c10de1ffff,16691) }, /* #19/3/3/c */
    { 0x0000, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/0/0/u */
    { 0x007f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/0/0/c */
    { 0x0100, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/0/1/u */
    { 0x017f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/0/1/c */
    { 0x0200, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/0/2/u */
    { 0x027f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/0/2/c */
    { 0x0300, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/0/3/u */
    { 0x037f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/0/3/c */
    { 0x0400, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/1/0/u */
    { 0x047f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/1/0/c */
    { 0x0500, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/1/1/u */
    { 0x057f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/1/1/c */
    { 0x0600, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/1/2/u */
    { 0x067f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/1/2/c */
    { 0x0700, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/1/3/u */
    { 0x077f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/1/3/c */
    { 0x0800, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/2/0/u */
    { 0x087f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/2/0/c */
    { 0x0900, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/2/1/u */
    { 0x097f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/2/1/c */
    { 0x0a00, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/2/2/u */
    { 0x0a7f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/2/2/c */
    { 0x0b00, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/2/3/u */
    { 0x0b7f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/2/3/c */
    { 0x0c00, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/3/0/u */
    { 0x0c7f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/3/0/c */
    { 0x0d00, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/3/1/u */
    { 0x0d7f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/3/1/c */
    { 0x0e00, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/3/2/u */
    { 0x0e7f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/3/2/c */
    { 0x0f00, 0x653a, 0xfd81, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249) }, /* #20/3/3/u */
    { 0x0f7f, 0x653a, 0x7d01, RTFLOAT80U_INIT_C(1,0x2cf9d51fb3afb9d2,29249), RTFLOAT64U_INIT_C(1,0xabdd78a40987,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #20/3/3/c */
    { 0x0000, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/0/u */
    { 0x007f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/0/c */
    { 0x0100, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/1/u */
    { 0x017f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/1/c */
    { 0x0200, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/2/u */
    { 0x027f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/2/c */
    { 0x0300, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/3/u */
    { 0x037f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/3/c */
    { 0x0400, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/0/u */
    { 0x047f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/0/c */
    { 0x0500, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/1/u */
    { 0x057f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/1/c */
    { 0x0600, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/2/u */
    { 0x067f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/2/c */
    { 0x0700, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/3/u */
    { 0x077f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/3/c */
    { 0x0800, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/0/u */
    { 0x087f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/0/c */
    { 0x0900, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/1/u */
    { 0x097f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/1/c */
    { 0x0a00, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/2/u */
    { 0x0a7f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/2/c */
    { 0x0b00, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/3/u */
    { 0x0b7f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/3/c */
    { 0x0c00, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/0/u */
    { 0x0c7f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/0/c */
    { 0x0d00, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/1/u */
    { 0x0d7f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/1/c */
    { 0x0e00, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/2/u */
    { 0x0e7f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/2/c */
    { 0x0f00, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/3/u */
    { 0x0f7f, 0xb993, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0xa12bdbf11d844,597), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/3/c */
    { 0x0000, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/0/0/u */
    { 0x007f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/0/0/c */
    { 0x0100, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/0/1/u */
    { 0x017f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/0/1/c */
    { 0x0200, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/0/2/u */
    { 0x027f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/0/2/c */
    { 0x0300, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/0/3/u */
    { 0x037f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/0/3/c */
    { 0x0400, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/1/0/u */
    { 0x047f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/1/0/c */
    { 0x0500, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/1/1/u */
    { 0x057f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/1/1/c */
    { 0x0600, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/1/2/u */
    { 0x067f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/1/2/c */
    { 0x0700, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/1/3/u */
    { 0x077f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/1/3/c */
    { 0x0800, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/2/0/u */
    { 0x087f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/2/0/c */
    { 0x0900, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/2/1/u */
    { 0x097f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/2/1/c */
    { 0x0a00, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/2/2/u */
    { 0x0a7f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/2/2/c */
    { 0x0b00, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/2/3/u */
    { 0x0b7f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/2/3/c */
    { 0x0c00, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/3/0/u */
    { 0x0c7f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/3/0/c */
    { 0x0d00, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/3/1/u */
    { 0x0d7f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/3/1/c */
    { 0x0e00, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/3/2/u */
    { 0x0e7f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/3/2/c */
    { 0x0f00, 0x7d86, 0xfd81, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960) }, /* #22/3/3/u */
    { 0x0f7f, 0x7d86, 0x7d01, RTFLOAT80U_INIT_C(1,0xeb64e2a79c490c21,2960), RTFLOAT64U_INIT_C(1,0x61729f1,2047), RTFLOAT80U_INIT_C(1,0xc0000030b94f8800,32767) }, /* #22/3/3/c */
    { 0x0000, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930000000000,16217) }, /* #23/0/0/u */
    { 0x007f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930000000000,16217) }, /* #23/0/0/c */
    { 0x0100, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/0/1/u */
    { 0x017f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/0/1/c */
    { 0x0200, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/0/2/u */
    { 0x027f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/0/2/c */
    { 0x0300, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/0/3/u */
    { 0x037f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/0/3/c */
    { 0x0400, 0x74b8, 0xfea0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3940000000000,16217) }, /* #23/1/0/u */
    { 0x047f, 0x74b8, 0x7e20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3940000000000,16217) }, /* #23/1/0/c */
    { 0x0500, 0x74b8, 0xfea0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d801,16217) }, /* #23/1/1/u */
    { 0x057f, 0x74b8, 0x7e20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d801,16217) }, /* #23/1/1/c */
    { 0x0600, 0x74b8, 0xfea0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528e000,16217) }, /* #23/1/2/u */
    { 0x067f, 0x74b8, 0x7e20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528e000,16217) }, /* #23/1/2/c */
    { 0x0700, 0x74b8, 0xfea0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d801,16217) }, /* #23/1/3/u */
    { 0x077f, 0x74b8, 0x7e20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d801,16217) }, /* #23/1/3/c */
    { 0x0800, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930000000000,16217) }, /* #23/2/0/u */
    { 0x087f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930000000000,16217) }, /* #23/2/0/c */
    { 0x0900, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/2/1/u */
    { 0x097f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/2/1/c */
    { 0x0a00, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/2/2/u */
    { 0x0a7f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/2/2/c */
    { 0x0b00, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/2/3/u */
    { 0x0b7f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/2/3/c */
    { 0x0c00, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930000000000,16217) }, /* #23/3/0/u */
    { 0x0c7f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930000000000,16217) }, /* #23/3/0/c */
    { 0x0d00, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/3/1/u */
    { 0x0d7f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/3/1/c */
    { 0x0e00, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/3/2/u */
    { 0x0e7f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/3/2/c */
    { 0x0f00, 0x74b8, 0xfca0, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/3/3/u */
    { 0x0f7f, 0x74b8, 0x7c20, RTFLOAT80U_INIT_C(1,0x94836b6da455c818,3470), RTFLOAT64U_INIT_C(1,0xe9a7261a4a51b,857), RTFLOAT80U_INIT_C(1,0xf4d3930d2528d800,16217) }, /* #23/3/3/c */
    { 0x0000, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/0/0/u */
    { 0x007f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/0/c */
    { 0x0100, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/0/1/u */
    { 0x017f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/1/c */
    { 0x0200, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/0/2/u */
    { 0x027f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/2/c */
    { 0x0300, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/0/3/u */
    { 0x037f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/3/c */
    { 0x0400, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/1/0/u */
    { 0x047f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/0/c */
    { 0x0500, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/1/1/u */
    { 0x057f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/1/c */
    { 0x0600, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/1/2/u */
    { 0x067f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/2/c */
    { 0x0700, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/1/3/u */
    { 0x077f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/3/c */
    { 0x0800, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/2/0/u */
    { 0x087f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/0/c */
    { 0x0900, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/2/1/u */
    { 0x097f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/1/c */
    { 0x0a00, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/2/2/u */
    { 0x0a7f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/2/c */
    { 0x0b00, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/2/3/u */
    { 0x0b7f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/3/c */
    { 0x0c00, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/3/0/u */
    { 0x0c7f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/0/c */
    { 0x0d00, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/3/1/u */
    { 0x0d7f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/1/c */
    { 0x0e00, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/3/2/u */
    { 0x0e7f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/2/c */
    { 0x0f00, 0x2bf1, 0xb981, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239) }, /* #24/3/3/u */
    { 0x0f7f, 0x2bf1, 0x3901, RTFLOAT80U_INIT_C(0,0x11ed36d0c0b54c2c,11239), RTFLOAT64U_INIT_C(0,0x8627018356e8c,1285), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/3/c */
    { 0x0000, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/0/0/u */
    { 0x007f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/0/0/c */
    { 0x0100, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/0/1/u */
    { 0x017f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/0/1/c */
    { 0x0200, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/0/2/u */
    { 0x027f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/0/2/c */
    { 0x0300, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/0/3/u */
    { 0x037f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/0/3/c */
    { 0x0400, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/1/0/u */
    { 0x047f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/1/0/c */
    { 0x0500, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/1/1/u */
    { 0x057f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/1/1/c */
    { 0x0600, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/1/2/u */
    { 0x067f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0x8000000000000000,32759) }, /* #25/1/2/c */
    { 0x0700, 0x3fbf, 0xbfa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/1/3/u */
    { 0x077f, 0x3fbf, 0x3f20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #25/1/3/c */
    { 0x0800, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #25/2/0/u */
    { 0x087f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #25/2/0/c */
    { 0x0900, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/2/1/u */
    { 0x097f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/2/1/c */
    { 0x0a00, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #25/2/2/u */
    { 0x0a7f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #25/2/2/c */
    { 0x0b00, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/2/3/u */
    { 0x0b7f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/2/3/c */
    { 0x0c00, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #25/3/0/u */
    { 0x0c7f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32758) }, /* #25/3/0/c */
    { 0x0d00, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/3/1/u */
    { 0x0d7f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/3/1/c */
    { 0x0e00, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #25/3/2/u */
    { 0x0e7f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32758) }, /* #25/3/2/c */
    { 0x0f00, 0x3fbf, 0xbda0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/3/3/u */
    { 0x0f7f, 0x3fbf, 0x3d20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0x8f757df84d809,1751), RTFLOAT80U_INIT_C(1,0xfffffffffffffffe,32758) }, /* #25/3/3/c */
    { 0x0000, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/0/0/u */
    { 0x007f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/0/c */
    { 0x0100, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/0/1/u */
    { 0x017f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/1/c */
    { 0x0200, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/0/2/u */
    { 0x027f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/2/c */
    { 0x0300, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/0/3/u */
    { 0x037f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/0/3/c */
    { 0x0400, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/1/0/u */
    { 0x047f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/0/c */
    { 0x0500, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/1/1/u */
    { 0x057f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/1/c */
    { 0x0600, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/1/2/u */
    { 0x067f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/2/c */
    { 0x0700, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/1/3/u */
    { 0x077f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/1/3/c */
    { 0x0800, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/2/0/u */
    { 0x087f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/0/c */
    { 0x0900, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/2/1/u */
    { 0x097f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/1/c */
    { 0x0a00, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/2/2/u */
    { 0x0a7f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/2/c */
    { 0x0b00, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/2/3/u */
    { 0x0b7f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/2/3/c */
    { 0x0c00, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/3/0/u */
    { 0x0c7f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/0/c */
    { 0x0d00, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/3/1/u */
    { 0x0d7f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/1/c */
    { 0x0e00, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/3/2/u */
    { 0x0e7f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/2/c */
    { 0x0f00, 0x1dbf, 0xbd81, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155) }, /* #26/3/3/u */
    { 0x0f7f, 0x1dbf, 0x3d01, RTFLOAT80U_INIT_C(0,0x67ce7f50575e902f,10155), RTFLOAT64U_INIT_C(1,0x62c14b19e3d7c,316), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #26/3/3/c */
    { 0x0000, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c00000000000,16198) }, /* #27/0/0/u */
    { 0x007f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c00000000000,16198) }, /* #27/0/0/c */
    { 0x0100, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/0/1/u */
    { 0x017f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/0/1/c */
    { 0x0200, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/0/2/u */
    { 0x027f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/0/2/c */
    { 0x0300, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/0/3/u */
    { 0x037f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/0/3/c */
    { 0x0400, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c10000000000,16198) }, /* #27/1/0/u */
    { 0x047f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c10000000000,16198) }, /* #27/1/0/c */
    { 0x0500, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/1/1/u */
    { 0x057f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/1/1/c */
    { 0x0600, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/1/2/u */
    { 0x067f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/1/2/c */
    { 0x0700, 0xd015, 0xfaa0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/1/3/u */
    { 0x077f, 0xd015, 0x7a20, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581800,16198) }, /* #27/1/3/c */
    { 0x0800, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c00000000000,16198) }, /* #27/2/0/u */
    { 0x087f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c00000000000,16198) }, /* #27/2/0/c */
    { 0x0900, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/2/1/u */
    { 0x097f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/2/1/c */
    { 0x0a00, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581000,16198) }, /* #27/2/2/u */
    { 0x0a7f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581000,16198) }, /* #27/2/2/c */
    { 0x0b00, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/2/3/u */
    { 0x0b7f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/2/3/c */
    { 0x0c00, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c00000000000,16198) }, /* #27/3/0/u */
    { 0x0c7f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c00000000000,16198) }, /* #27/3/0/c */
    { 0x0d00, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/3/1/u */
    { 0x0d7f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/3/1/c */
    { 0x0e00, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581000,16198) }, /* #27/3/2/u */
    { 0x0e7f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d8581000,16198) }, /* #27/3/2/c */
    { 0x0f00, 0xd015, 0xf8a0, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/3/3/u */
    { 0x0f7f, 0xd015, 0x7820, RTFLOAT80U_INIT_C(0,0xf92fd777d14a45d8,15665), RTFLOAT64U_INIT_C(1,0x637380ebb0b03,838), RTFLOAT80U_INIT_C(1,0xb1b9c075d85817ff,16198) }, /* #27/3/3/c */
    { 0x0000, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68e0000000000,17051) }, /* #28/0/0/u */
    { 0x007f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68e0000000000,17051) }, /* #28/0/0/c */
    { 0x0100, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/0/1/u */
    { 0x017f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/0/1/c */
    { 0x0200, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/0/2/u */
    { 0x027f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/0/2/c */
    { 0x0300, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/0/3/u */
    { 0x037f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/0/3/c */
    { 0x0400, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d0000000000,17051) }, /* #28/1/0/u */
    { 0x047f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d0000000000,17051) }, /* #28/1/0/c */
    { 0x0500, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/1/1/u */
    { 0x057f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/1/1/c */
    { 0x0600, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705000,17051) }, /* #28/1/2/u */
    { 0x067f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705000,17051) }, /* #28/1/2/c */
    { 0x0700, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/1/3/u */
    { 0x077f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/1/3/c */
    { 0x0800, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68e0000000000,17051) }, /* #28/2/0/u */
    { 0x087f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68e0000000000,17051) }, /* #28/2/0/c */
    { 0x0900, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/2/1/u */
    { 0x097f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/2/1/c */
    { 0x0a00, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/2/2/u */
    { 0x0a7f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/2/2/c */
    { 0x0b00, 0xa1cf, 0xbba0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/2/3/u */
    { 0x0b7f, 0xa1cf, 0x3b20, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705800,17051) }, /* #28/2/3/c */
    { 0x0c00, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d0000000000,17051) }, /* #28/3/0/u */
    { 0x0c7f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d0000000000,17051) }, /* #28/3/0/c */
    { 0x0d00, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/3/1/u */
    { 0x0d7f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/3/1/c */
    { 0x0e00, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705000,17051) }, /* #28/3/2/u */
    { 0x0e7f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d9332705000,17051) }, /* #28/3/2/c */
    { 0x0f00, 0xa1cf, 0xb9a0, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/3/3/u */
    { 0x0f7f, 0xa1cf, 0x3920, RTFLOAT80U_INIT_C(1,0xac7b9a1f980e53d4,6932), RTFLOAT64U_INIT_C(0,0x694d1b2664e0b,1691), RTFLOAT80U_INIT_C(0,0xb4a68d93327057ff,17051) }, /* #28/3/3/c */
    { 0x0000, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/0/0/u */
    { 0x007f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8090000000000,16569) }, /* #29/0/0/c */
    { 0x0100, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/0/1/u */
    { 0x017f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/0/1/c */
    { 0x0200, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/0/2/u */
    { 0x027f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/0/2/c */
    { 0x0300, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/0/3/u */
    { 0x037f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/0/3/c */
    { 0x0400, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/1/0/u */
    { 0x047f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8090000000000,16569) }, /* #29/1/0/c */
    { 0x0500, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/1/1/u */
    { 0x057f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/1/1/c */
    { 0x0600, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/1/2/u */
    { 0x067f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/1/2/c */
    { 0x0700, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/1/3/u */
    { 0x077f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/1/3/c */
    { 0x0800, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/2/0/u */
    { 0x087f, 0x6472, 0x7e22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a80a0000000000,16569) }, /* #29/2/0/c */
    { 0x0900, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/2/1/u */
    { 0x097f, 0x6472, 0x7e22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83801,16569) }, /* #29/2/1/c */
    { 0x0a00, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/2/2/u */
    { 0x0a7f, 0x6472, 0x7e22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b84000,16569) }, /* #29/2/2/c */
    { 0x0b00, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/2/3/u */
    { 0x0b7f, 0x6472, 0x7e22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83801,16569) }, /* #29/2/3/c */
    { 0x0c00, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/3/0/u */
    { 0x0c7f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8090000000000,16569) }, /* #29/3/0/c */
    { 0x0d00, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/3/1/u */
    { 0x0d7f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/3/1/c */
    { 0x0e00, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/3/2/u */
    { 0x0e7f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/3/2/c */
    { 0x0f00, 0x6472, 0xfc82, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0) }, /* #29/3/3/u */
    { 0x0f7f, 0x6472, 0x7c22, RTFLOAT80U_INIT_C(0,0xd1e5ce49ed5a62df,0), RTFLOAT64U_INIT_C(0,0xed501256cd707,1209), RTFLOAT80U_INIT_C(0,0xf6a8092b66b83800,16569) }, /* #29/3/3/c */
    { 0x0000, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/0/0/u */
    { 0x007f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/0/c */
    { 0x0100, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/0/1/u */
    { 0x017f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/1/c */
    { 0x0200, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/0/2/u */
    { 0x027f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/2/c */
    { 0x0300, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/0/3/u */
    { 0x037f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/3/c */
    { 0x0400, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/1/0/u */
    { 0x047f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/0/c */
    { 0x0500, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/1/1/u */
    { 0x057f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/1/c */
    { 0x0600, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/1/2/u */
    { 0x067f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/2/c */
    { 0x0700, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/1/3/u */
    { 0x077f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/3/c */
    { 0x0800, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/2/0/u */
    { 0x087f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/0/c */
    { 0x0900, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/2/1/u */
    { 0x097f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/1/c */
    { 0x0a00, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/2/2/u */
    { 0x0a7f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/2/c */
    { 0x0b00, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/2/3/u */
    { 0x0b7f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/3/c */
    { 0x0c00, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/3/0/u */
    { 0x0c7f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/0/c */
    { 0x0d00, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/3/1/u */
    { 0x0d7f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/1/c */
    { 0x0e00, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/3/2/u */
    { 0x0e7f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/2/c */
    { 0x0f00, 0x5ef5, 0xfc81, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170) }, /* #30/3/3/u */
    { 0x0f7f, 0x5ef5, 0x7c01, RTFLOAT80U_INIT_C(1,0x6c266201d166adac,14170), RTFLOAT64U_INIT_C(1,0x5746bcce178ce,779), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/3/c */
    { 0x0000, 0xb6fb, 0xbea0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7250000000000,18562) }, /* #31/0/0/u */
    { 0x007f, 0xb6fb, 0x3e20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7250000000000,18562) }, /* #31/0/0/c */
    { 0x0100, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/0/1/u */
    { 0x017f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/0/1/c */
    { 0x0200, 0xb6fb, 0xbea0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db168000,18562) }, /* #31/0/2/u */
    { 0x027f, 0xb6fb, 0x3e20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db168000,18562) }, /* #31/0/2/c */
    { 0x0300, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/0/3/u */
    { 0x037f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/0/3/c */
    { 0x0400, 0xb6fb, 0xbca0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7240000000000,18562) }, /* #31/1/0/u */
    { 0x047f, 0xb6fb, 0x3c20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7240000000000,18562) }, /* #31/1/0/c */
    { 0x0500, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/1/1/u */
    { 0x057f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/1/1/c */
    { 0x0600, 0xb6fb, 0xbca0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167800,18562) }, /* #31/1/2/u */
    { 0x067f, 0xb6fb, 0x3c20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167800,18562) }, /* #31/1/2/c */
    { 0x0700, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/1/3/u */
    { 0x077f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/1/3/c */
    { 0x0800, 0xb6fb, 0xbea0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7250000000000,18562) }, /* #31/2/0/u */
    { 0x087f, 0xb6fb, 0x3e20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7250000000000,18562) }, /* #31/2/0/c */
    { 0x0900, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/2/1/u */
    { 0x097f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/2/1/c */
    { 0x0a00, 0xb6fb, 0xbea0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db168000,18562) }, /* #31/2/2/u */
    { 0x0a7f, 0xb6fb, 0x3e20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db168000,18562) }, /* #31/2/2/c */
    { 0x0b00, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/2/3/u */
    { 0x0b7f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/2/3/c */
    { 0x0c00, 0xb6fb, 0xbca0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7240000000000,18562) }, /* #31/3/0/u */
    { 0x0c7f, 0xb6fb, 0x3c20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a7240000000000,18562) }, /* #31/3/0/c */
    { 0x0d00, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/3/1/u */
    { 0x0d7f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/3/1/c */
    { 0x0e00, 0xb6fb, 0xbca0, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167800,18562) }, /* #31/3/2/u */
    { 0x0e7f, 0xb6fb, 0x3c20, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167800,18562) }, /* #31/3/2/c */
    { 0x0f00, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/3/3/u */
    { 0x0f7f, 0xb6fb, 0x3c00, RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe7a724f9db167e79,18562) }, /* #31/3/3/c */
    { 0x0000, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e20000000000,17366) }, /* #32/0/0/u */
    { 0x007f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e20000000000,17366) }, /* #32/0/0/c */
    { 0x0100, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/0/1/u */
    { 0x017f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/0/1/c */
    { 0x0200, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/0/2/u */
    { 0x027f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/0/2/c */
    { 0x0300, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/0/3/u */
    { 0x037f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/0/3/c */
    { 0x0400, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e20000000000,17366) }, /* #32/1/0/u */
    { 0x047f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e20000000000,17366) }, /* #32/1/0/c */
    { 0x0500, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/1/1/u */
    { 0x057f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/1/1/c */
    { 0x0600, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2800,17366) }, /* #32/1/2/u */
    { 0x067f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2800,17366) }, /* #32/1/2/c */
    { 0x0700, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/1/3/u */
    { 0x077f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/1/3/c */
    { 0x0800, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e30000000000,17366) }, /* #32/2/0/u */
    { 0x087f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e30000000000,17366) }, /* #32/2/0/c */
    { 0x0900, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/2/1/u */
    { 0x097f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/2/1/c */
    { 0x0a00, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/2/2/u */
    { 0x0a7f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/2/2/c */
    { 0x0b00, 0xfea8, 0xfea0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/2/3/u */
    { 0x0b7f, 0xfea8, 0x7e20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d3000,17366) }, /* #32/2/3/c */
    { 0x0c00, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e20000000000,17366) }, /* #32/3/0/u */
    { 0x0c7f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e20000000000,17366) }, /* #32/3/0/c */
    { 0x0d00, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/3/1/u */
    { 0x0d7f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/3/1/c */
    { 0x0e00, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2800,17366) }, /* #32/3/2/u */
    { 0x0e7f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2800,17366) }, /* #32/3/2/c */
    { 0x0f00, 0xfea8, 0xfca0, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/3/3/u */
    { 0x0f7f, 0xfea8, 0x7c20, RTFLOAT80U_INIT_C(1,0xc14c13f4f86ef192,11157), RTFLOAT64U_INIT_C(0,0x45b1c4a9473a6,2006), RTFLOAT80U_INIT_C(0,0xa2d8e254a39d2fff,17366) }, /* #32/3/3/c */
    { 0x0000, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/0/0/u */
    { 0x007f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340000000000,17029) }, /* #33/0/0/c */
    { 0x0100, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/0/1/u */
    { 0x017f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecd000,17029) }, /* #33/0/1/c */
    { 0x0200, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/0/2/u */
    { 0x027f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecd000,17029) }, /* #33/0/2/c */
    { 0x0300, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/0/3/u */
    { 0x037f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecd000,17029) }, /* #33/0/3/c */
    { 0x0400, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/1/0/u */
    { 0x047f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340000000000,17029) }, /* #33/1/0/c */
    { 0x0500, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/1/1/u */
    { 0x057f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2feccfff,17029) }, /* #33/1/1/c */
    { 0x0600, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/1/2/u */
    { 0x067f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecc800,17029) }, /* #33/1/2/c */
    { 0x0700, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/1/3/u */
    { 0x077f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2feccfff,17029) }, /* #33/1/3/c */
    { 0x0800, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/2/0/u */
    { 0x087f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764350000000000,17029) }, /* #33/2/0/c */
    { 0x0900, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/2/1/u */
    { 0x097f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecd000,17029) }, /* #33/2/1/c */
    { 0x0a00, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/2/2/u */
    { 0x0a7f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecd000,17029) }, /* #33/2/2/c */
    { 0x0b00, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/2/3/u */
    { 0x0b7f, 0x79d9, 0x7b22, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecd000,17029) }, /* #33/2/3/c */
    { 0x0c00, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/3/0/u */
    { 0x0c7f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340000000000,17029) }, /* #33/3/0/c */
    { 0x0d00, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/3/1/u */
    { 0x0d7f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2feccfff,17029) }, /* #33/3/1/c */
    { 0x0e00, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/3/2/u */
    { 0x0e7f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2fecc800,17029) }, /* #33/3/2/c */
    { 0x0f00, 0x79d9, 0xf982, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0) }, /* #33/3/3/u */
    { 0x0f7f, 0x79d9, 0x7922, RTFLOAT80U_INIT_C(1,0x8000aa6892925da3,0), RTFLOAT64U_INIT_C(0,0xcec8681c5fd9a,1669), RTFLOAT80U_INIT_C(0,0xe764340e2feccfff,17029) }, /* #33/3/3/c */
    { 0x0000, 0xee76, 0xfca0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6450000000000,22567) }, /* #34/0/0/u */
    { 0x007f, 0xee76, 0x7c20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6450000000000,22567) }, /* #34/0/0/c */
    { 0x0100, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/0/1/u */
    { 0x017f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/0/1/c */
    { 0x0200, 0xee76, 0xfca0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7d800,22567) }, /* #34/0/2/u */
    { 0x027f, 0xee76, 0x7c20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7d800,22567) }, /* #34/0/2/c */
    { 0x0300, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/0/3/u */
    { 0x037f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/0/3/c */
    { 0x0400, 0xee76, 0xfea0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6460000000000,22567) }, /* #34/1/0/u */
    { 0x047f, 0xee76, 0x7e20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6460000000000,22567) }, /* #34/1/0/c */
    { 0x0500, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/1/1/u */
    { 0x057f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/1/1/c */
    { 0x0600, 0xee76, 0xfea0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7e000,22567) }, /* #34/1/2/u */
    { 0x067f, 0xee76, 0x7e20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7e000,22567) }, /* #34/1/2/c */
    { 0x0700, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/1/3/u */
    { 0x077f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/1/3/c */
    { 0x0800, 0xee76, 0xfca0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6450000000000,22567) }, /* #34/2/0/u */
    { 0x087f, 0xee76, 0x7c20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6450000000000,22567) }, /* #34/2/0/c */
    { 0x0900, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/2/1/u */
    { 0x097f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/2/1/c */
    { 0x0a00, 0xee76, 0xfca0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7d800,22567) }, /* #34/2/2/u */
    { 0x0a7f, 0xee76, 0x7c20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7d800,22567) }, /* #34/2/2/c */
    { 0x0b00, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/2/3/u */
    { 0x0b7f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/2/3/c */
    { 0x0c00, 0xee76, 0xfca0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6450000000000,22567) }, /* #34/3/0/u */
    { 0x0c7f, 0xee76, 0x7c20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb6450000000000,22567) }, /* #34/3/0/c */
    { 0x0d00, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/3/1/u */
    { 0x0d7f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/3/1/c */
    { 0x0e00, 0xee76, 0xfca0, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7d800,22567) }, /* #34/3/2/u */
    { 0x0e7f, 0xee76, 0x7c20, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7d800,22567) }, /* #34/3/2/c */
    { 0x0f00, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/3/3/u */
    { 0x0f7f, 0xee76, 0x7c00, RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xbeb645715dd7dba7,22567) }, /* #34/3/3/c */
    { 0x0000, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40000000000,16075) }, /* #35/0/0/u */
    { 0x007f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40000000000,16075) }, /* #35/0/0/c */
    { 0x0100, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/0/1/u */
    { 0x017f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/0/1/c */
    { 0x0200, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/0/2/u */
    { 0x027f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/0/2/c */
    { 0x0300, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/0/3/u */
    { 0x037f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/0/3/c */
    { 0x0400, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a50000000000,16075) }, /* #35/1/0/u */
    { 0x047f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a50000000000,16075) }, /* #35/1/0/c */
    { 0x0500, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/1/1/u */
    { 0x057f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/1/1/c */
    { 0x0600, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/1/2/u */
    { 0x067f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/1/2/c */
    { 0x0700, 0x7c10, 0xfea0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/1/3/u */
    { 0x077f, 0x7c10, 0x7e20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df800,16075) }, /* #35/1/3/c */
    { 0x0800, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40000000000,16075) }, /* #35/2/0/u */
    { 0x087f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40000000000,16075) }, /* #35/2/0/c */
    { 0x0900, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/2/1/u */
    { 0x097f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/2/1/c */
    { 0x0a00, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df000,16075) }, /* #35/2/2/u */
    { 0x0a7f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df000,16075) }, /* #35/2/2/c */
    { 0x0b00, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/2/3/u */
    { 0x0b7f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/2/3/c */
    { 0x0c00, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40000000000,16075) }, /* #35/3/0/u */
    { 0x0c7f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40000000000,16075) }, /* #35/3/0/c */
    { 0x0d00, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/3/1/u */
    { 0x0d7f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/3/1/c */
    { 0x0e00, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df000,16075) }, /* #35/3/2/u */
    { 0x0e7f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df000,16075) }, /* #35/3/2/c */
    { 0x0f00, 0x7c10, 0xfca0, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/3/3/u */
    { 0x0f7f, 0x7c10, 0x7c20, RTFLOAT80U_INIT_C(0,0xe499b2ca150f47a3,10750), RTFLOAT64U_INIT_C(1,0x35a34817625bf,715), RTFLOAT80U_INIT_C(1,0x9ad1a40bb12df7ff,16075) }, /* #35/3/3/c */
    { 0x0000, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/0/0/u */
    { 0x007f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/0/c */
    { 0x0100, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/0/1/u */
    { 0x017f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/1/c */
    { 0x0200, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/0/2/u */
    { 0x027f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/2/c */
    { 0x0300, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/0/3/u */
    { 0x037f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/0/3/c */
    { 0x0400, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/1/0/u */
    { 0x047f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/0/c */
    { 0x0500, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/1/1/u */
    { 0x057f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/1/c */
    { 0x0600, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/1/2/u */
    { 0x067f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/2/c */
    { 0x0700, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/1/3/u */
    { 0x077f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/1/3/c */
    { 0x0800, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/2/0/u */
    { 0x087f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/0/c */
    { 0x0900, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/2/1/u */
    { 0x097f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/1/c */
    { 0x0a00, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/2/2/u */
    { 0x0a7f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/2/c */
    { 0x0b00, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/2/3/u */
    { 0x0b7f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/2/3/c */
    { 0x0c00, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/3/0/u */
    { 0x0c7f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/0/c */
    { 0x0d00, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/3/1/u */
    { 0x0d7f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/1/c */
    { 0x0e00, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/3/2/u */
    { 0x0e7f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/2/c */
    { 0x0f00, 0x3266, 0xb881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #36/3/3/u */
    { 0x0f7f, 0x3266, 0x3801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x74b082ea08944,385), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #36/3/3/c */
    { 0x0000, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f60000000000,16528) }, /* #37/0/0/u */
    { 0x007f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f60000000000,16528) }, /* #37/0/0/c */
    { 0x0100, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/0/1/u */
    { 0x017f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/0/1/c */
    { 0x0200, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/0/2/u */
    { 0x027f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/0/2/c */
    { 0x0300, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/0/3/u */
    { 0x037f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/0/3/c */
    { 0x0400, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f60000000000,16528) }, /* #37/1/0/u */
    { 0x047f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f60000000000,16528) }, /* #37/1/0/c */
    { 0x0500, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/1/1/u */
    { 0x057f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/1/1/c */
    { 0x0600, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6800,16528) }, /* #37/1/2/u */
    { 0x067f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6800,16528) }, /* #37/1/2/c */
    { 0x0700, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/1/3/u */
    { 0x077f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/1/3/c */
    { 0x0800, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f70000000000,16528) }, /* #37/2/0/u */
    { 0x087f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f70000000000,16528) }, /* #37/2/0/c */
    { 0x0900, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/2/1/u */
    { 0x097f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/2/1/c */
    { 0x0a00, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/2/2/u */
    { 0x0a7f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/2/2/c */
    { 0x0b00, 0xb230, 0xbaa0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/2/3/u */
    { 0x0b7f, 0xb230, 0x3a20, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd7000,16528) }, /* #37/2/3/c */
    { 0x0c00, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f60000000000,16528) }, /* #37/3/0/u */
    { 0x0c7f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f60000000000,16528) }, /* #37/3/0/c */
    { 0x0d00, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/3/1/u */
    { 0x0d7f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/3/1/c */
    { 0x0e00, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6800,16528) }, /* #37/3/2/u */
    { 0x0e7f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6800,16528) }, /* #37/3/2/c */
    { 0x0f00, 0xb230, 0xb8a0, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/3/3/u */
    { 0x0f7f, 0xb230, 0x3820, RTFLOAT80U_INIT_C(1,0xafa686f5f6609fe5,14604), RTFLOAT64U_INIT_C(0,0xdd67eca0b3bae,1168), RTFLOAT80U_INIT_C(0,0xeeb3f65059dd6fff,16528) }, /* #37/3/3/c */
    { 0x0000, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744110000000000,16410) }, /* #38/0/0/u */
    { 0x007f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744110000000000,16410) }, /* #38/0/0/c */
    { 0x0100, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/0/1/u */
    { 0x017f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/0/1/c */
    { 0x0200, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/0/2/u */
    { 0x027f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/0/2/c */
    { 0x0300, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/0/3/u */
    { 0x037f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/0/3/c */
    { 0x0400, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744100000000000,16410) }, /* #38/1/0/u */
    { 0x047f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744100000000000,16410) }, /* #38/1/0/c */
    { 0x0500, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/1/1/u */
    { 0x057f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/1/1/c */
    { 0x0600, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df000,16410) }, /* #38/1/2/u */
    { 0x067f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df000,16410) }, /* #38/1/2/c */
    { 0x0700, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/1/3/u */
    { 0x077f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/1/3/c */
    { 0x0800, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744110000000000,16410) }, /* #38/2/0/u */
    { 0x087f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744110000000000,16410) }, /* #38/2/0/c */
    { 0x0900, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/2/1/u */
    { 0x097f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/2/1/c */
    { 0x0a00, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/2/2/u */
    { 0x0a7f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/2/2/c */
    { 0x0b00, 0xa7bc, 0xbfa0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/2/3/u */
    { 0x0b7f, 0xa7bc, 0x3f20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df800,16410) }, /* #38/2/3/c */
    { 0x0c00, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744100000000000,16410) }, /* #38/3/0/u */
    { 0x0c7f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa744100000000000,16410) }, /* #38/3/0/c */
    { 0x0d00, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/3/1/u */
    { 0x0d7f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/3/1/c */
    { 0x0e00, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df000,16410) }, /* #38/3/2/u */
    { 0x0e7f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df000,16410) }, /* #38/3/2/c */
    { 0x0f00, 0xa7bc, 0xbda0, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/3/3/u */
    { 0x0f7f, 0xa7bc, 0x3d20, RTFLOAT80U_INIT_C(1,0xfbe77e982867ccfe,9669), RTFLOAT64U_INIT_C(0,0x4e8821fbc89bf,1050), RTFLOAT80U_INIT_C(0,0xa74410fde44df7ff,16410) }, /* #38/3/3/c */
    { 0x0000, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190660000000000,15962) }, /* #39/0/0/u */
    { 0x007f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190660000000000,15962) }, /* #39/0/0/c */
    { 0x0100, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/0/1/u */
    { 0x017f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/0/1/c */
    { 0x0200, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/0/2/u */
    { 0x027f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/0/2/c */
    { 0x0300, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/0/3/u */
    { 0x037f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/0/3/c */
    { 0x0400, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190650000000000,15962) }, /* #39/1/0/u */
    { 0x047f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190650000000000,15962) }, /* #39/1/0/c */
    { 0x0500, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/1/1/u */
    { 0x057f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/1/1/c */
    { 0x0600, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627b800,15962) }, /* #39/1/2/u */
    { 0x067f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627b800,15962) }, /* #39/1/2/c */
    { 0x0700, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/1/3/u */
    { 0x077f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/1/3/c */
    { 0x0800, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190660000000000,15962) }, /* #39/2/0/u */
    { 0x087f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190660000000000,15962) }, /* #39/2/0/c */
    { 0x0900, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/2/1/u */
    { 0x097f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/2/1/c */
    { 0x0a00, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/2/2/u */
    { 0x0a7f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/2/2/c */
    { 0x0b00, 0x7665, 0xfea0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/2/3/u */
    { 0x0b7f, 0x7665, 0x7e20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627c000,15962) }, /* #39/2/3/c */
    { 0x0c00, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190650000000000,15962) }, /* #39/3/0/u */
    { 0x0c7f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf190650000000000,15962) }, /* #39/3/0/c */
    { 0x0d00, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/3/1/u */
    { 0x0d7f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/3/1/c */
    { 0x0e00, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627b800,15962) }, /* #39/3/2/u */
    { 0x0e7f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627b800,15962) }, /* #39/3/2/c */
    { 0x0f00, 0x7665, 0xfca0, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/3/3/u */
    { 0x0f7f, 0x7665, 0x7c20, RTFLOAT80U_INIT_C(1,0xd714424572620b02,13521), RTFLOAT64U_INIT_C(0,0xe320cbea0c4f8,602), RTFLOAT80U_INIT_C(0,0xf19065f50627bfff,15962) }, /* #39/3/3/c */
    { 0x0000, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/0/0/u */
    { 0x007f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/0/0/c */
    { 0x0100, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/0/1/u */
    { 0x017f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/0/1/c */
    { 0x0200, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/0/2/u */
    { 0x027f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/0/2/c */
    { 0x0300, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/0/3/u */
    { 0x037f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/0/3/c */
    { 0x0400, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/1/0/u */
    { 0x047f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/1/0/c */
    { 0x0500, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/1/1/u */
    { 0x057f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/1/1/c */
    { 0x0600, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/1/2/u */
    { 0x067f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/1/2/c */
    { 0x0700, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/1/3/u */
    { 0x077f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/1/3/c */
    { 0x0800, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/2/0/u */
    { 0x087f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/2/0/c */
    { 0x0900, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/2/1/u */
    { 0x097f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/2/1/c */
    { 0x0a00, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/2/2/u */
    { 0x0a7f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/2/2/c */
    { 0x0b00, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/2/3/u */
    { 0x0b7f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/2/3/c */
    { 0x0c00, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/3/0/u */
    { 0x0c7f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/3/0/c */
    { 0x0d00, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/3/1/u */
    { 0x0d7f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/3/1/c */
    { 0x0e00, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/3/2/u */
    { 0x0e7f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/3/2/c */
    { 0x0f00, 0x20b6, 0xb881, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0x8000000000000003,0) }, /* #40/3/3/u */
    { 0x0f7f, 0x20b6, 0x3801, RTFLOAT80U_INIT_C(0,0x8000000000000003,0), RTFLOAT64U_INIT_C(0,0x731dded,2047), RTFLOAT80U_INIT_C(0,0xc00000398eef6800,32767) }, /* #40/3/3/c */
    { 0x0000, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/0/0/u */
    { 0x007f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe150000000000,16656) }, /* #41/0/0/c */
    { 0x0100, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/0/1/u */
    { 0x017f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cf000,16656) }, /* #41/0/1/c */
    { 0x0200, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/0/2/u */
    { 0x027f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cf000,16656) }, /* #41/0/2/c */
    { 0x0300, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/0/3/u */
    { 0x037f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cf000,16656) }, /* #41/0/3/c */
    { 0x0400, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/1/0/u */
    { 0x047f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe150000000000,16656) }, /* #41/1/0/c */
    { 0x0500, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/1/1/u */
    { 0x057f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cefff,16656) }, /* #41/1/1/c */
    { 0x0600, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/1/2/u */
    { 0x067f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1ce800,16656) }, /* #41/1/2/c */
    { 0x0700, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/1/3/u */
    { 0x077f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cefff,16656) }, /* #41/1/3/c */
    { 0x0800, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/2/0/u */
    { 0x087f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe160000000000,16656) }, /* #41/2/0/c */
    { 0x0900, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/2/1/u */
    { 0x097f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cf000,16656) }, /* #41/2/1/c */
    { 0x0a00, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/2/2/u */
    { 0x0a7f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cf000,16656) }, /* #41/2/2/c */
    { 0x0b00, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/2/3/u */
    { 0x0b7f, 0x2b23, 0x3b22, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cf000,16656) }, /* #41/2/3/c */
    { 0x0c00, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/3/0/u */
    { 0x0c7f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe150000000000,16656) }, /* #41/3/0/c */
    { 0x0d00, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/3/1/u */
    { 0x0d7f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cefff,16656) }, /* #41/3/1/c */
    { 0x0e00, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/3/2/u */
    { 0x0e7f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1ce800,16656) }, /* #41/3/2/c */
    { 0x0f00, 0x2b23, 0xb982, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0) }, /* #41/3/3/u */
    { 0x0f7f, 0x2b23, 0x3922, RTFLOAT80U_INIT_C(1,0x27dfa3652157abad,0), RTFLOAT64U_INIT_C(0,0xff7c2aee5a39e,1296), RTFLOAT80U_INIT_C(0,0xffbe15772d1cefff,16656) }, /* #41/3/3/c */
    { 0x0000, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/0/u */
    { 0x007f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/0/c */
    { 0x0100, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/1/u */
    { 0x017f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/1/c */
    { 0x0200, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/2/u */
    { 0x027f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/2/c */
    { 0x0300, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/3/u */
    { 0x037f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/0/3/c */
    { 0x0400, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/0/u */
    { 0x047f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/0/c */
    { 0x0500, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/1/u */
    { 0x057f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/1/c */
    { 0x0600, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/2/u */
    { 0x067f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/2/c */
    { 0x0700, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/3/u */
    { 0x077f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/1/3/c */
    { 0x0800, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/0/u */
    { 0x087f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/0/c */
    { 0x0900, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/1/u */
    { 0x097f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/1/c */
    { 0x0a00, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/2/u */
    { 0x0a7f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/2/c */
    { 0x0b00, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/3/u */
    { 0x0b7f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/2/3/c */
    { 0x0c00, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/0/u */
    { 0x0c7f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/0/c */
    { 0x0d00, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/1/u */
    { 0x0d7f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/1/c */
    { 0x0e00, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/2/u */
    { 0x0e7f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/2/c */
    { 0x0f00, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/3/u */
    { 0x0f7f, 0x138a, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #42/3/3/c */
    { 0x0000, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d0000000000,30394) }, /* #43/0/0/u */
    { 0x007f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d0000000000,30394) }, /* #43/0/0/c */
    { 0x0100, 0xf9ae, 0xfba0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/0/1/u */
    { 0x017f, 0xf9ae, 0x7b20, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/0/1/c */
    { 0x0200, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e000,30394) }, /* #43/0/2/u */
    { 0x027f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e000,30394) }, /* #43/0/2/c */
    { 0x0300, 0xf9ae, 0xfba0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/0/3/u */
    { 0x037f, 0xf9ae, 0x7b20, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/0/3/c */
    { 0x0400, 0xf9ae, 0xfba0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9e0000000000,30394) }, /* #43/1/0/u */
    { 0x047f, 0xf9ae, 0x7b20, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9e0000000000,30394) }, /* #43/1/0/c */
    { 0x0500, 0xf9ae, 0xfba0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/1/1/u */
    { 0x057f, 0xf9ae, 0x7b20, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/1/1/c */
    { 0x0600, 0xf9ae, 0xfba0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e800,30394) }, /* #43/1/2/u */
    { 0x067f, 0xf9ae, 0x7b20, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e800,30394) }, /* #43/1/2/c */
    { 0x0700, 0xf9ae, 0xfba0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/1/3/u */
    { 0x077f, 0xf9ae, 0x7b20, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394) }, /* #43/1/3/c */
    { 0x0800, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d0000000000,30394) }, /* #43/2/0/u */
    { 0x087f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d0000000000,30394) }, /* #43/2/0/c */
    { 0x0900, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/2/1/u */
    { 0x097f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/2/1/c */
    { 0x0a00, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e000,30394) }, /* #43/2/2/u */
    { 0x0a7f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e000,30394) }, /* #43/2/2/c */
    { 0x0b00, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/2/3/u */
    { 0x0b7f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/2/3/c */
    { 0x0c00, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d0000000000,30394) }, /* #43/3/0/u */
    { 0x0c7f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d0000000000,30394) }, /* #43/3/0/c */
    { 0x0d00, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/3/1/u */
    { 0x0d7f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/3/1/c */
    { 0x0e00, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e000,30394) }, /* #43/3/2/u */
    { 0x0e7f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e000,30394) }, /* #43/3/2/c */
    { 0x0f00, 0xf9ae, 0xf9a0, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/3/3/u */
    { 0x0f7f, 0xf9ae, 0x7920, RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e5,30394), RTFLOAT64U_INIT_C(0,0x997d56c278602,967), RTFLOAT80U_INIT_C(1,0xe91e9d706b02e1e4,30394) }, /* #43/3/3/c */
    { 0x0000, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/0/0/u */
    { 0x007f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/0/c */
    { 0x0100, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/0/1/u */
    { 0x017f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/1/c */
    { 0x0200, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/0/2/u */
    { 0x027f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/2/c */
    { 0x0300, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/0/3/u */
    { 0x037f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/3/c */
    { 0x0400, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/1/0/u */
    { 0x047f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/0/c */
    { 0x0500, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/1/1/u */
    { 0x057f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/1/c */
    { 0x0600, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/1/2/u */
    { 0x067f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/2/c */
    { 0x0700, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/1/3/u */
    { 0x077f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/3/c */
    { 0x0800, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/2/0/u */
    { 0x087f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/0/c */
    { 0x0900, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/2/1/u */
    { 0x097f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/1/c */
    { 0x0a00, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/2/2/u */
    { 0x0a7f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/2/c */
    { 0x0b00, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/2/3/u */
    { 0x0b7f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/3/c */
    { 0x0c00, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/3/0/u */
    { 0x0c7f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/0/c */
    { 0x0d00, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/3/1/u */
    { 0x0d7f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/1/c */
    { 0x0e00, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/3/2/u */
    { 0x0e7f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/2/c */
    { 0x0f00, 0x4aa7, 0xf881, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695) }, /* #44/3/3/u */
    { 0x0f7f, 0x4aa7, 0x7801, RTFLOAT80U_INIT_C(1,0x6d330a4ebb3fc350,27695), RTFLOAT64U_INIT_C(1,0x6a3bd67a89a58,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/3/c */
    { 0x0000, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/0/0/u */
    { 0x007f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/0/0/c */
    { 0x0100, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/0/1/u */
    { 0x017f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/0/1/c */
    { 0x0200, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/0/2/u */
    { 0x027f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/0/2/c */
    { 0x0300, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/0/3/u */
    { 0x037f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/0/3/c */
    { 0x0400, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/1/0/u */
    { 0x047f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/1/0/c */
    { 0x0500, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/1/1/u */
    { 0x057f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/1/1/c */
    { 0x0600, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/1/2/u */
    { 0x067f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/1/2/c */
    { 0x0700, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/1/3/u */
    { 0x077f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/1/3/c */
    { 0x0800, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/2/0/u */
    { 0x087f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/2/0/c */
    { 0x0900, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/2/1/u */
    { 0x097f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/2/1/c */
    { 0x0a00, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/2/2/u */
    { 0x0a7f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/2/2/c */
    { 0x0b00, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/2/3/u */
    { 0x0b7f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/2/3/c */
    { 0x0c00, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/3/0/u */
    { 0x0c7f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/3/0/c */
    { 0x0d00, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/3/1/u */
    { 0x0d7f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/3/1/c */
    { 0x0e00, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/3/2/u */
    { 0x0e7f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/3/2/c */
    { 0x0f00, 0xb7a1, 0xbd81, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0) }, /* #45/3/3/u */
    { 0x0f7f, 0xb7a1, 0x3d01, RTFLOAT80U_INIT_C(0,0x87304bf9df0a85b5,0), RTFLOAT64U_INIT_C(0,0x4ad43,2047), RTFLOAT80U_INIT_C(0,0xc0000000256a1800,32767) }, /* #45/3/3/c */
    { 0x0000, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/0/0/u */
    { 0x007f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/0/c */
    { 0x0100, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/0/1/u */
    { 0x017f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/1/c */
    { 0x0200, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/0/2/u */
    { 0x027f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/2/c */
    { 0x0300, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/0/3/u */
    { 0x037f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/3/c */
    { 0x0400, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/1/0/u */
    { 0x047f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/0/c */
    { 0x0500, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/1/1/u */
    { 0x057f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/1/c */
    { 0x0600, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/1/2/u */
    { 0x067f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/2/c */
    { 0x0700, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/1/3/u */
    { 0x077f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/3/c */
    { 0x0800, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/2/0/u */
    { 0x087f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/0/c */
    { 0x0900, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/2/1/u */
    { 0x097f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/1/c */
    { 0x0a00, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/2/2/u */
    { 0x0a7f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/2/c */
    { 0x0b00, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/2/3/u */
    { 0x0b7f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/3/c */
    { 0x0c00, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/3/0/u */
    { 0x0c7f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/0/c */
    { 0x0d00, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/3/1/u */
    { 0x0d7f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/1/c */
    { 0x0e00, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/3/2/u */
    { 0x0e7f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/2/c */
    { 0x0f00, 0x1173, 0xb981, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767) }, /* #46/3/3/u */
    { 0x0f7f, 0x1173, 0x3901, RTFLOAT80U_INIT_C(0,0x40018e000d835002,32767), RTFLOAT64U_INIT_C(1,0x6a74ae5c7e77,1884), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/3/c */
    { 0x0000, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f0000000000,30666) }, /* #47/0/0/u */
    { 0x007f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f0000000000,30666) }, /* #47/0/0/c */
    { 0x0100, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/0/1/u */
    { 0x017f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/0/1/c */
    { 0x0200, 0x00b8, 0xbaa0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56800,30666) }, /* #47/0/2/u */
    { 0x027f, 0x00b8, 0x3a20, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56800,30666) }, /* #47/0/2/c */
    { 0x0300, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/0/3/u */
    { 0x037f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/0/3/c */
    { 0x0400, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f0000000000,30666) }, /* #47/1/0/u */
    { 0x047f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f0000000000,30666) }, /* #47/1/0/c */
    { 0x0500, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/1/1/u */
    { 0x057f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/1/1/c */
    { 0x0600, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56000,30666) }, /* #47/1/2/u */
    { 0x067f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56000,30666) }, /* #47/1/2/c */
    { 0x0700, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/1/3/u */
    { 0x077f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/1/3/c */
    { 0x0800, 0x00b8, 0xbaa0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c9100000000000,30666) }, /* #47/2/0/u */
    { 0x087f, 0x00b8, 0x3a20, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c9100000000000,30666) }, /* #47/2/0/c */
    { 0x0900, 0x00b8, 0xbaa0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56686,30666) }, /* #47/2/1/u */
    { 0x097f, 0x00b8, 0x3a20, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56686,30666) }, /* #47/2/1/c */
    { 0x0a00, 0x00b8, 0xbaa0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56800,30666) }, /* #47/2/2/u */
    { 0x0a7f, 0x00b8, 0x3a20, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56800,30666) }, /* #47/2/2/c */
    { 0x0b00, 0x00b8, 0xbaa0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56686,30666) }, /* #47/2/3/u */
    { 0x0b7f, 0x00b8, 0x3a20, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56686,30666) }, /* #47/2/3/c */
    { 0x0c00, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f0000000000,30666) }, /* #47/3/0/u */
    { 0x0c7f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f0000000000,30666) }, /* #47/3/0/c */
    { 0x0d00, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/3/1/u */
    { 0x0d7f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/3/1/c */
    { 0x0e00, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56000,30666) }, /* #47/3/2/u */
    { 0x0e7f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56000,30666) }, /* #47/3/2/c */
    { 0x0f00, 0x00b8, 0xb8a0, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/3/3/u */
    { 0x0f7f, 0x00b8, 0x3820, RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666), RTFLOAT64U_INIT_C(0,0x2ab7734e64f1c,1540), RTFLOAT80U_INIT_C(0,0xc9c90f7a60c56685,30666) }, /* #47/3/3/c */
    { 0x0000, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/0/0/u */
    { 0x007f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/0/0/c */
    { 0x0100, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/0/1/u */
    { 0x017f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/0/1/c */
    { 0x0200, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/0/2/u */
    { 0x027f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/0/2/c */
    { 0x0300, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/0/3/u */
    { 0x037f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/0/3/c */
    { 0x0400, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/1/0/u */
    { 0x047f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/1/0/c */
    { 0x0500, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/1/1/u */
    { 0x057f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/1/1/c */
    { 0x0600, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/1/2/u */
    { 0x067f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/1/2/c */
    { 0x0700, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/1/3/u */
    { 0x077f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/1/3/c */
    { 0x0800, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/2/0/u */
    { 0x087f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/2/0/c */
    { 0x0900, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/2/1/u */
    { 0x097f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/2/1/c */
    { 0x0a00, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/2/2/u */
    { 0x0a7f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/2/2/c */
    { 0x0b00, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/2/3/u */
    { 0x0b7f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/2/3/c */
    { 0x0c00, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/3/0/u */
    { 0x0c7f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/3/0/c */
    { 0x0d00, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/3/1/u */
    { 0x0d7f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/3/1/c */
    { 0x0e00, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/3/2/u */
    { 0x0e7f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/3/2/c */
    { 0x0f00, 0x0477, 0xbc82, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x1eb3165e99,0) }, /* #48/3/3/u */
    { 0x0f7f, 0x0477, 0x3c02, RTFLOAT80U_INIT_C(1,0x1eb3165e99,0), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #48/3/3/c */
    { 0x0000, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/0/0/u */
    { 0x007f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/0/c */
    { 0x0100, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/0/1/u */
    { 0x017f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/1/c */
    { 0x0200, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/0/2/u */
    { 0x027f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/2/c */
    { 0x0300, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/0/3/u */
    { 0x037f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/3/c */
    { 0x0400, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/1/0/u */
    { 0x047f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/0/c */
    { 0x0500, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/1/1/u */
    { 0x057f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/1/c */
    { 0x0600, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/1/2/u */
    { 0x067f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/2/c */
    { 0x0700, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/1/3/u */
    { 0x077f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/3/c */
    { 0x0800, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/2/0/u */
    { 0x087f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/0/c */
    { 0x0900, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/2/1/u */
    { 0x097f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/1/c */
    { 0x0a00, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/2/2/u */
    { 0x0a7f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/2/c */
    { 0x0b00, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/2/3/u */
    { 0x0b7f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/3/c */
    { 0x0c00, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/3/0/u */
    { 0x0c7f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/0/c */
    { 0x0d00, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/3/1/u */
    { 0x0d7f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/1/c */
    { 0x0e00, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/3/2/u */
    { 0x0e7f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/2/c */
    { 0x0f00, 0xe95d, 0xf981, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913) }, /* #49/3/3/u */
    { 0x0f7f, 0xe95d, 0x7901, RTFLOAT80U_INIT_C(0,0x555123b064555d5e,7913), RTFLOAT64U_INIT_C(1,0x1b74c44aedf84,1761), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/3/c */
    { 0x0000, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/0/0/u */
    { 0x007f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/0/c */
    { 0x0100, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/0/1/u */
    { 0x017f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/1/c */
    { 0x0200, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/0/2/u */
    { 0x027f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/2/c */
    { 0x0300, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/0/3/u */
    { 0x037f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/0/3/c */
    { 0x0400, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/1/0/u */
    { 0x047f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/0/c */
    { 0x0500, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/1/1/u */
    { 0x057f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/1/c */
    { 0x0600, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/1/2/u */
    { 0x067f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/2/c */
    { 0x0700, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/1/3/u */
    { 0x077f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/1/3/c */
    { 0x0800, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/2/0/u */
    { 0x087f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/0/c */
    { 0x0900, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/2/1/u */
    { 0x097f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/1/c */
    { 0x0a00, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/2/2/u */
    { 0x0a7f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/2/c */
    { 0x0b00, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/2/3/u */
    { 0x0b7f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/2/3/c */
    { 0x0c00, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/3/0/u */
    { 0x0c7f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/0/c */
    { 0x0d00, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/3/1/u */
    { 0x0d7f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/1/c */
    { 0x0e00, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/3/2/u */
    { 0x0e7f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/2/c */
    { 0x0f00, 0xca21, 0xf881, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767) }, /* #50/3/3/u */
    { 0x0f7f, 0xca21, 0x7801, RTFLOAT80U_INIT_C(1,0x5bd8a8af09d28ed1,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #50/3/3/c */
    { 0x0000, 0xbf21, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e420000000000,23287) }, /* #51/0/0/u */
    { 0x007f, 0xbf21, 0x3f20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e420000000000,23287) }, /* #51/0/0/c */
    { 0x0100, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/0/1/u */
    { 0x017f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/0/1/c */
    { 0x0200, 0xbf21, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cd000,23287) }, /* #51/0/2/u */
    { 0x027f, 0xbf21, 0x3f20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cd000,23287) }, /* #51/0/2/c */
    { 0x0300, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/0/3/u */
    { 0x037f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/0/3/c */
    { 0x0400, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e410000000000,23287) }, /* #51/1/0/u */
    { 0x047f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e410000000000,23287) }, /* #51/1/0/c */
    { 0x0500, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/1/1/u */
    { 0x057f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/1/1/c */
    { 0x0600, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cc800,23287) }, /* #51/1/2/u */
    { 0x067f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cc800,23287) }, /* #51/1/2/c */
    { 0x0700, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/1/3/u */
    { 0x077f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/1/3/c */
    { 0x0800, 0xbf21, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e420000000000,23287) }, /* #51/2/0/u */
    { 0x087f, 0xbf21, 0x3f20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e420000000000,23287) }, /* #51/2/0/c */
    { 0x0900, 0xbf21, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccdaa,23287) }, /* #51/2/1/u */
    { 0x097f, 0xbf21, 0x3f20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccdaa,23287) }, /* #51/2/1/c */
    { 0x0a00, 0xbf21, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cd000,23287) }, /* #51/2/2/u */
    { 0x0a7f, 0xbf21, 0x3f20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cd000,23287) }, /* #51/2/2/c */
    { 0x0b00, 0xbf21, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccdaa,23287) }, /* #51/2/3/u */
    { 0x0b7f, 0xbf21, 0x3f20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccdaa,23287) }, /* #51/2/3/c */
    { 0x0c00, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e410000000000,23287) }, /* #51/3/0/u */
    { 0x0c7f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e410000000000,23287) }, /* #51/3/0/c */
    { 0x0d00, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/3/1/u */
    { 0x0d7f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/3/1/c */
    { 0x0e00, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cc800,23287) }, /* #51/3/2/u */
    { 0x0e7f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700cc800,23287) }, /* #51/3/2/c */
    { 0x0f00, 0xbf21, 0xbda0, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/3/3/u */
    { 0x0f7f, 0xbf21, 0x3d20, RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287), RTFLOAT64U_INIT_C(0,0x17fe3ccc4f2c5,1672), RTFLOAT80U_INIT_C(0,0xa28e41b6700ccda9,23287) }, /* #51/3/3/c */
    { 0x0000, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/0/0/u */
    { 0x007f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/0/c */
    { 0x0100, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/0/1/u */
    { 0x017f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/1/c */
    { 0x0200, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/0/2/u */
    { 0x027f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/2/c */
    { 0x0300, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/0/3/u */
    { 0x037f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/3/c */
    { 0x0400, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/1/0/u */
    { 0x047f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/0/c */
    { 0x0500, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/1/1/u */
    { 0x057f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/1/c */
    { 0x0600, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/1/2/u */
    { 0x067f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/2/c */
    { 0x0700, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/1/3/u */
    { 0x077f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/3/c */
    { 0x0800, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/2/0/u */
    { 0x087f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/0/c */
    { 0x0900, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/2/1/u */
    { 0x097f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/1/c */
    { 0x0a00, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/2/2/u */
    { 0x0a7f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/2/c */
    { 0x0b00, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/2/3/u */
    { 0x0b7f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/3/c */
    { 0x0c00, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/3/0/u */
    { 0x0c7f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/0/c */
    { 0x0d00, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/3/1/u */
    { 0x0d7f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/1/c */
    { 0x0e00, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/3/2/u */
    { 0x0e7f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/2/c */
    { 0x0f00, 0x53ee, 0xf981, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037) }, /* #52/3/3/u */
    { 0x0f7f, 0x53ee, 0x7901, RTFLOAT80U_INIT_C(1,0x3e47efa2cf0b127a,32037), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/3/c */
    { 0x0000, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b70000000000,16078) }, /* #53/0/0/u */
    { 0x007f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b70000000000,16078) }, /* #53/0/0/c */
    { 0x0100, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/0/1/u */
    { 0x017f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/0/1/c */
    { 0x0200, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/0/2/u */
    { 0x027f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/0/2/c */
    { 0x0300, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/0/3/u */
    { 0x037f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/0/3/c */
    { 0x0400, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b70000000000,16078) }, /* #53/1/0/u */
    { 0x047f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b70000000000,16078) }, /* #53/1/0/c */
    { 0x0500, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/1/1/u */
    { 0x057f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/1/1/c */
    { 0x0600, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5b800,16078) }, /* #53/1/2/u */
    { 0x067f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5b800,16078) }, /* #53/1/2/c */
    { 0x0700, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/1/3/u */
    { 0x077f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/1/3/c */
    { 0x0800, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b80000000000,16078) }, /* #53/2/0/u */
    { 0x087f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b80000000000,16078) }, /* #53/2/0/c */
    { 0x0900, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/2/1/u */
    { 0x097f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/2/1/c */
    { 0x0a00, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/2/2/u */
    { 0x0a7f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/2/2/c */
    { 0x0b00, 0xc34d, 0xfba0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/2/3/u */
    { 0x0b7f, 0xc34d, 0x7b20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5c000,16078) }, /* #53/2/3/c */
    { 0x0c00, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b70000000000,16078) }, /* #53/3/0/u */
    { 0x0c7f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b70000000000,16078) }, /* #53/3/0/c */
    { 0x0d00, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/3/1/u */
    { 0x0d7f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/3/1/c */
    { 0x0e00, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5b800,16078) }, /* #53/3/2/u */
    { 0x0e7f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5b800,16078) }, /* #53/3/2/c */
    { 0x0f00, 0xc34d, 0xf9a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/3/3/u */
    { 0x0f7f, 0xc34d, 0x7920, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,9288), RTFLOAT64U_INIT_C(0,0x30cb6ed7536b8,718), RTFLOAT80U_INIT_C(0,0x9865b76ba9b5bfff,16078) }, /* #53/3/3/c */
    { 0x0000, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/0/0/u */
    { 0x007f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/0/0/c */
    { 0x0100, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/0/1/u */
    { 0x017f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/0/1/c */
    { 0x0200, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/0/2/u */
    { 0x027f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/0/2/c */
    { 0x0300, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/0/3/u */
    { 0x037f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/0/3/c */
    { 0x0400, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/1/0/u */
    { 0x047f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/1/0/c */
    { 0x0500, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/1/1/u */
    { 0x057f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/1/1/c */
    { 0x0600, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/1/2/u */
    { 0x067f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/1/2/c */
    { 0x0700, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/1/3/u */
    { 0x077f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/1/3/c */
    { 0x0800, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/2/0/u */
    { 0x087f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/2/0/c */
    { 0x0900, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/2/1/u */
    { 0x097f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/2/1/c */
    { 0x0a00, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/2/2/u */
    { 0x0a7f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/2/2/c */
    { 0x0b00, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/2/3/u */
    { 0x0b7f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/2/3/c */
    { 0x0c00, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/3/0/u */
    { 0x0c7f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/3/0/c */
    { 0x0d00, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/3/1/u */
    { 0x0d7f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/3/1/c */
    { 0x0e00, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/3/2/u */
    { 0x0e7f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/3/2/c */
    { 0x0f00, 0x0a2a, 0xb881, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(0,0x40000000000db568,32767) }, /* #54/3/3/u */
    { 0x0f7f, 0x0a2a, 0x3801, RTFLOAT80U_INIT_C(0,0x40000000000db568,32767), RTFLOAT64U_INIT_C(1,0x9e458a22a9e5,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #54/3/3/c */
    { 0x0000, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/0/0/u */
    { 0x007f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/0/c */
    { 0x0100, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/0/1/u */
    { 0x017f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/1/c */
    { 0x0200, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/0/2/u */
    { 0x027f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/2/c */
    { 0x0300, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/0/3/u */
    { 0x037f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/0/3/c */
    { 0x0400, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/1/0/u */
    { 0x047f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/0/c */
    { 0x0500, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/1/1/u */
    { 0x057f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/1/c */
    { 0x0600, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/1/2/u */
    { 0x067f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/2/c */
    { 0x0700, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/1/3/u */
    { 0x077f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/1/3/c */
    { 0x0800, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/2/0/u */
    { 0x087f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/0/c */
    { 0x0900, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/2/1/u */
    { 0x097f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/1/c */
    { 0x0a00, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/2/2/u */
    { 0x0a7f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/2/c */
    { 0x0b00, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/2/3/u */
    { 0x0b7f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/2/3/c */
    { 0x0c00, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/3/0/u */
    { 0x0c7f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/0/c */
    { 0x0d00, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/3/1/u */
    { 0x0d7f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/1/c */
    { 0x0e00, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/3/2/u */
    { 0x0e7f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/2/c */
    { 0x0f00, 0xe60c, 0xfc81, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444) }, /* #55/3/3/u */
    { 0x0f7f, 0xe60c, 0x7c01, RTFLOAT80U_INIT_C(1,0x19fd37800863fbbf,3444), RTFLOAT64U_INIT_C(0,0xd00eaf784dd1e,778), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #55/3/3/c */
    { 0x0000, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/0/0/u */
    { 0x007f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/0/0/c */
    { 0x0100, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/0/1/u */
    { 0x017f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/0/1/c */
    { 0x0200, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/0/2/u */
    { 0x027f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/0/2/c */
    { 0x0300, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/0/3/u */
    { 0x037f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/0/3/c */
    { 0x0400, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/1/0/u */
    { 0x047f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/1/0/c */
    { 0x0500, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/1/1/u */
    { 0x057f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/1/1/c */
    { 0x0600, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/1/2/u */
    { 0x067f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/1/2/c */
    { 0x0700, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/1/3/u */
    { 0x077f, 0x9310, 0x3b22, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x835a000000000000,15324) }, /* #56/1/3/c */
    { 0x0800, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/2/0/u */
    { 0x087f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359ff0000000000,15324) }, /* #56/2/0/c */
    { 0x0900, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/2/1/u */
    { 0x097f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359ffffffffffff,15324) }, /* #56/2/1/c */
    { 0x0a00, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/2/2/u */
    { 0x0a7f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359fffffffff800,15324) }, /* #56/2/2/c */
    { 0x0b00, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/2/3/u */
    { 0x0b7f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359ffffffffffff,15324) }, /* #56/2/3/c */
    { 0x0c00, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/3/0/u */
    { 0x0c7f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359ff0000000000,15324) }, /* #56/3/0/c */
    { 0x0d00, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/3/1/u */
    { 0x0d7f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359ffffffffffff,15324) }, /* #56/3/1/c */
    { 0x0e00, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/3/2/u */
    { 0x0e7f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359fffffffff800,15324) }, /* #56/3/2/c */
    { 0x0f00, 0x9310, 0xb982, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618) }, /* #56/3/3/u */
    { 0x0f7f, 0x9310, 0x3922, RTFLOAT80U_INIT_C(0,0xe77c68915752086b,618), RTFLOAT64U_INIT_C(1,0x835a,0), RTFLOAT80U_INIT_C(1,0x8359ffffffffffff,15324) }, /* #56/3/3/c */
    { 0x0000, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3410000000000,15416) }, /* #57/0/0/u */
    { 0x007f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3410000000000,15416) }, /* #57/0/0/c */
    { 0x0100, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/0/1/u */
    { 0x017f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/0/1/c */
    { 0x0200, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/0/2/u */
    { 0x027f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/0/2/c */
    { 0x0300, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/0/3/u */
    { 0x037f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/0/3/c */
    { 0x0400, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3410000000000,15416) }, /* #57/1/0/u */
    { 0x047f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3410000000000,15416) }, /* #57/1/0/c */
    { 0x0500, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/1/1/u */
    { 0x057f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/1/1/c */
    { 0x0600, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577800,15416) }, /* #57/1/2/u */
    { 0x067f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577800,15416) }, /* #57/1/2/c */
    { 0x0700, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/1/3/u */
    { 0x077f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/1/3/c */
    { 0x0800, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3420000000000,15416) }, /* #57/2/0/u */
    { 0x087f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3420000000000,15416) }, /* #57/2/0/c */
    { 0x0900, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/2/1/u */
    { 0x097f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/2/1/c */
    { 0x0a00, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/2/2/u */
    { 0x0a7f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/2/2/c */
    { 0x0b00, 0x233f, 0xbba0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/2/3/u */
    { 0x0b7f, 0x233f, 0x3b20, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03578000,15416) }, /* #57/2/3/c */
    { 0x0c00, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3410000000000,15416) }, /* #57/3/0/u */
    { 0x0c7f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3410000000000,15416) }, /* #57/3/0/c */
    { 0x0d00, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/3/1/u */
    { 0x0d7f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/3/1/c */
    { 0x0e00, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577800,15416) }, /* #57/3/2/u */
    { 0x0e7f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577800,15416) }, /* #57/3/2/c */
    { 0x0f00, 0x233f, 0xb9a0, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/3/3/u */
    { 0x0f7f, 0x233f, 0x3920, RTFLOAT80U_INIT_C(1,0xab55ae9df6ac7d1d,6399), RTFLOAT64U_INIT_C(0,0x7d8682b406af0,56), RTFLOAT80U_INIT_C(0,0xbec3415a03577fff,15416) }, /* #57/3/3/c */
    { 0x0000, 0x86d5, 0xbea0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c785a0000000000,16171) }, /* #58/0/0/u */
    { 0x007f, 0x86d5, 0x3e20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c785a0000000000,16171) }, /* #58/0/0/c */
    { 0x0100, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/0/1/u */
    { 0x017f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/0/1/c */
    { 0x0200, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/0/2/u */
    { 0x027f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/0/2/c */
    { 0x0300, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/0/3/u */
    { 0x037f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/0/3/c */
    { 0x0400, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c78590000000000,16171) }, /* #58/1/0/u */
    { 0x047f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c78590000000000,16171) }, /* #58/1/0/c */
    { 0x0500, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/1/1/u */
    { 0x057f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/1/1/c */
    { 0x0600, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/1/2/u */
    { 0x067f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/1/2/c */
    { 0x0700, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/1/3/u */
    { 0x077f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/1/3/c */
    { 0x0800, 0x86d5, 0xbea0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c785a0000000000,16171) }, /* #58/2/0/u */
    { 0x087f, 0x86d5, 0x3e20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c785a0000000000,16171) }, /* #58/2/0/c */
    { 0x0900, 0x86d5, 0xbea0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150001,16171) }, /* #58/2/1/u */
    { 0x097f, 0x86d5, 0x3e20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150001,16171) }, /* #58/2/1/c */
    { 0x0a00, 0x86d5, 0xbea0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150800,16171) }, /* #58/2/2/u */
    { 0x0a7f, 0x86d5, 0x3e20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150800,16171) }, /* #58/2/2/c */
    { 0x0b00, 0x86d5, 0xbea0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150001,16171) }, /* #58/2/3/u */
    { 0x0b7f, 0x86d5, 0x3e20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150001,16171) }, /* #58/2/3/c */
    { 0x0c00, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c78590000000000,16171) }, /* #58/3/0/u */
    { 0x0c7f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c78590000000000,16171) }, /* #58/3/0/c */
    { 0x0d00, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/3/1/u */
    { 0x0d7f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/3/1/c */
    { 0x0e00, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/3/2/u */
    { 0x0e7f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/3/2/c */
    { 0x0f00, 0x86d5, 0xbca0, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/3/3/u */
    { 0x0f7f, 0x86d5, 0x3c20, RTFLOAT80U_INIT_C(0,0xececbc33bd2de422,6430), RTFLOAT64U_INIT_C(0,0x18f0b38c822a0,811), RTFLOAT80U_INIT_C(0,0x8c7859c641150000,16171) }, /* #58/3/3/c */
    { 0x0000, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78680000000000,29310) }, /* #59/0/0/u */
    { 0x007f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78680000000000,29310) }, /* #59/0/0/c */
    { 0x0100, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/0/1/u */
    { 0x017f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/0/1/c */
    { 0x0200, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4000,29310) }, /* #59/0/2/u */
    { 0x027f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4000,29310) }, /* #59/0/2/c */
    { 0x0300, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/0/3/u */
    { 0x037f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/0/3/c */
    { 0x0400, 0xe542, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78690000000000,29310) }, /* #59/1/0/u */
    { 0x047f, 0xe542, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78690000000000,29310) }, /* #59/1/0/c */
    { 0x0500, 0xe542, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428c,29310) }, /* #59/1/1/u */
    { 0x057f, 0xe542, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428c,29310) }, /* #59/1/1/c */
    { 0x0600, 0xe542, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4800,29310) }, /* #59/1/2/u */
    { 0x067f, 0xe542, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4800,29310) }, /* #59/1/2/c */
    { 0x0700, 0xe542, 0xffa0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428c,29310) }, /* #59/1/3/u */
    { 0x077f, 0xe542, 0x7f20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428c,29310) }, /* #59/1/3/c */
    { 0x0800, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78680000000000,29310) }, /* #59/2/0/u */
    { 0x087f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78680000000000,29310) }, /* #59/2/0/c */
    { 0x0900, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/2/1/u */
    { 0x097f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/2/1/c */
    { 0x0a00, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4000,29310) }, /* #59/2/2/u */
    { 0x0a7f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4000,29310) }, /* #59/2/2/c */
    { 0x0b00, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/2/3/u */
    { 0x0b7f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/2/3/c */
    { 0x0c00, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78680000000000,29310) }, /* #59/3/0/u */
    { 0x0c7f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78680000000000,29310) }, /* #59/3/0/c */
    { 0x0d00, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/3/1/u */
    { 0x0d7f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/3/1/c */
    { 0x0e00, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4000,29310) }, /* #59/3/2/u */
    { 0x0e7f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e4000,29310) }, /* #59/3/2/c */
    { 0x0f00, 0xe542, 0xfda0, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/3/3/u */
    { 0x0f7f, 0xe542, 0x7d20, RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310), RTFLOAT64U_INIT_C(1,0x6e40564ec272e,709), RTFLOAT80U_INIT_C(1,0x8d78685a288e428b,29310) }, /* #59/3/3/c */
    { 0x0000, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/0/u */
    { 0x007f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/0/c */
    { 0x0100, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/1/u */
    { 0x017f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/1/c */
    { 0x0200, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/2/u */
    { 0x027f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/2/c */
    { 0x0300, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/3/u */
    { 0x037f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/3/c */
    { 0x0400, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/0/u */
    { 0x047f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/0/c */
    { 0x0500, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/1/u */
    { 0x057f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/1/c */
    { 0x0600, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/2/u */
    { 0x067f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/2/c */
    { 0x0700, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/3/u */
    { 0x077f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/3/c */
    { 0x0800, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/0/u */
    { 0x087f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/0/c */
    { 0x0900, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/1/u */
    { 0x097f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/1/c */
    { 0x0a00, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/2/u */
    { 0x0a7f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/2/c */
    { 0x0b00, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/3/u */
    { 0x0b7f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/3/c */
    { 0x0c00, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/0/u */
    { 0x0c7f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/0/c */
    { 0x0d00, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/1/u */
    { 0x0d7f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/1/c */
    { 0x0e00, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/2/u */
    { 0x0e7f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/2/c */
    { 0x0f00, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/3/u */
    { 0x0f7f, 0x0361, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x711d38093c960,1519), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/3/c */
    { 0x0000, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555b0000000000,17270) }, /* #61/0/0/u */
    { 0x007f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555b0000000000,17270) }, /* #61/0/0/c */
    { 0x0100, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/0/1/u */
    { 0x017f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/0/1/c */
    { 0x0200, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994f000,17270) }, /* #61/0/2/u */
    { 0x027f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994f000,17270) }, /* #61/0/2/c */
    { 0x0300, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/0/3/u */
    { 0x037f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/0/3/c */
    { 0x0400, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555b0000000000,17270) }, /* #61/1/0/u */
    { 0x047f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555b0000000000,17270) }, /* #61/1/0/c */
    { 0x0500, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/1/1/u */
    { 0x057f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/1/1/c */
    { 0x0600, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994f000,17270) }, /* #61/1/2/u */
    { 0x067f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994f000,17270) }, /* #61/1/2/c */
    { 0x0700, 0xee96, 0xfea0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/1/3/u */
    { 0x077f, 0xee96, 0x7e20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270) }, /* #61/1/3/c */
    { 0x0800, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555a0000000000,17270) }, /* #61/2/0/u */
    { 0x087f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555a0000000000,17270) }, /* #61/2/0/c */
    { 0x0900, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/2/1/u */
    { 0x097f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/2/1/c */
    { 0x0a00, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994e800,17270) }, /* #61/2/2/u */
    { 0x0a7f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994e800,17270) }, /* #61/2/2/c */
    { 0x0b00, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/2/3/u */
    { 0x0b7f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/2/3/c */
    { 0x0c00, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555a0000000000,17270) }, /* #61/3/0/u */
    { 0x0c7f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555a0000000000,17270) }, /* #61/3/0/c */
    { 0x0d00, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/3/1/u */
    { 0x0d7f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/3/1/c */
    { 0x0e00, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994e800,17270) }, /* #61/3/2/u */
    { 0x0e7f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994e800,17270) }, /* #61/3/2/c */
    { 0x0f00, 0xee96, 0xfca0, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/3/3/u */
    { 0x0f7f, 0xee96, 0x7c20, RTFLOAT80U_INIT_C(1,0xf4555adaa994eeca,17270), RTFLOAT64U_INIT_C(0,0x3bdbd7bf84ad6,4), RTFLOAT80U_INIT_C(1,0xf4555adaa994eec9,17270) }, /* #61/3/3/c */
    { 0x0000, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e70000000000,25411) }, /* #62/0/0/u */
    { 0x007f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e70000000000,25411) }, /* #62/0/0/c */
    { 0x0100, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/0/1/u */
    { 0x017f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/0/1/c */
    { 0x0200, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f9000,25411) }, /* #62/0/2/u */
    { 0x027f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f9000,25411) }, /* #62/0/2/c */
    { 0x0300, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/0/3/u */
    { 0x037f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/0/3/c */
    { 0x0400, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e80000000000,25411) }, /* #62/1/0/u */
    { 0x047f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e80000000000,25411) }, /* #62/1/0/c */
    { 0x0500, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/1/1/u */
    { 0x057f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/1/1/c */
    { 0x0600, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f9000,25411) }, /* #62/1/2/u */
    { 0x067f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f9000,25411) }, /* #62/1/2/c */
    { 0x0700, 0x1247, 0xbaa0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/1/3/u */
    { 0x077f, 0x1247, 0x3a20, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411) }, /* #62/1/3/c */
    { 0x0800, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e70000000000,25411) }, /* #62/2/0/u */
    { 0x087f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e70000000000,25411) }, /* #62/2/0/c */
    { 0x0900, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/2/1/u */
    { 0x097f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/2/1/c */
    { 0x0a00, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8800,25411) }, /* #62/2/2/u */
    { 0x0a7f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8800,25411) }, /* #62/2/2/c */
    { 0x0b00, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/2/3/u */
    { 0x0b7f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/2/3/c */
    { 0x0c00, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e70000000000,25411) }, /* #62/3/0/u */
    { 0x0c7f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e70000000000,25411) }, /* #62/3/0/c */
    { 0x0d00, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/3/1/u */
    { 0x0d7f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/3/1/c */
    { 0x0e00, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8800,25411) }, /* #62/3/2/u */
    { 0x0e7f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8800,25411) }, /* #62/3/2/c */
    { 0x0f00, 0x1247, 0xb8a0, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/3/3/u */
    { 0x0f7f, 0x1247, 0x3820, RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f49,25411), RTFLOAT64U_INIT_C(0,0x672e1d07bb155,907), RTFLOAT80U_INIT_C(1,0xacc2e73aa66f8f48,25411) }, /* #62/3/3/c */
    { 0x0000, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/0/0/u */
    { 0x007f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c00000000000,16618) }, /* #63/0/0/c */
    { 0x0100, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/0/1/u */
    { 0x017f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a800,16618) }, /* #63/0/1/c */
    { 0x0200, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/0/2/u */
    { 0x027f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a800,16618) }, /* #63/0/2/c */
    { 0x0300, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/0/3/u */
    { 0x037f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a800,16618) }, /* #63/0/3/c */
    { 0x0400, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/1/0/u */
    { 0x047f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c00000000000,16618) }, /* #63/1/0/c */
    { 0x0500, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/1/1/u */
    { 0x057f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a7ff,16618) }, /* #63/1/1/c */
    { 0x0600, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/1/2/u */
    { 0x067f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a000,16618) }, /* #63/1/2/c */
    { 0x0700, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/1/3/u */
    { 0x077f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a7ff,16618) }, /* #63/1/3/c */
    { 0x0800, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/2/0/u */
    { 0x087f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c10000000000,16618) }, /* #63/2/0/c */
    { 0x0900, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/2/1/u */
    { 0x097f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a800,16618) }, /* #63/2/1/c */
    { 0x0a00, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/2/2/u */
    { 0x0a7f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a800,16618) }, /* #63/2/2/c */
    { 0x0b00, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/2/3/u */
    { 0x0b7f, 0x8c4e, 0x3e22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a800,16618) }, /* #63/2/3/c */
    { 0x0c00, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/3/0/u */
    { 0x0c7f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c00000000000,16618) }, /* #63/3/0/c */
    { 0x0d00, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/3/1/u */
    { 0x0d7f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a7ff,16618) }, /* #63/3/1/c */
    { 0x0e00, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/3/2/u */
    { 0x0e7f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a000,16618) }, /* #63/3/2/c */
    { 0x0f00, 0x8c4e, 0xbc82, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(1,0x800000000000004b,0) }, /* #63/3/3/u */
    { 0x0f7f, 0x8c4e, 0x3c22, RTFLOAT80U_INIT_C(1,0x800000000000004b,0), RTFLOAT64U_INIT_C(0,0x14d80d3ba215,1258), RTFLOAT80U_INIT_C(0,0x80a6c069dd10a7ff,16618) }, /* #63/3/3/c */
    { 0x0000, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12b0000000000,22273) }, /* #64/0/0/u */
    { 0x007f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12b0000000000,22273) }, /* #64/0/0/c */
    { 0x0100, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/0/1/u */
    { 0x017f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/0/1/c */
    { 0x0200, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a800,22273) }, /* #64/0/2/u */
    { 0x027f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a800,22273) }, /* #64/0/2/c */
    { 0x0300, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/0/3/u */
    { 0x037f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/0/3/c */
    { 0x0400, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12a0000000000,22273) }, /* #64/1/0/u */
    { 0x047f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12a0000000000,22273) }, /* #64/1/0/c */
    { 0x0500, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/1/1/u */
    { 0x057f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/1/1/c */
    { 0x0600, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a800,22273) }, /* #64/1/2/u */
    { 0x067f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a800,22273) }, /* #64/1/2/c */
    { 0x0700, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/1/3/u */
    { 0x077f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/1/3/c */
    { 0x0800, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12b0000000000,22273) }, /* #64/2/0/u */
    { 0x087f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12b0000000000,22273) }, /* #64/2/0/c */
    { 0x0900, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/2/1/u */
    { 0x097f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/2/1/c */
    { 0x0a00, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2b000,22273) }, /* #64/2/2/u */
    { 0x0a7f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2b000,22273) }, /* #64/2/2/c */
    { 0x0b00, 0xf3b8, 0xfba0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/2/3/u */
    { 0x0b7f, 0xf3b8, 0x7b20, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273) }, /* #64/2/3/c */
    { 0x0c00, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12a0000000000,22273) }, /* #64/3/0/u */
    { 0x0c7f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12a0000000000,22273) }, /* #64/3/0/c */
    { 0x0d00, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/3/1/u */
    { 0x0d7f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/3/1/c */
    { 0x0e00, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a800,22273) }, /* #64/3/2/u */
    { 0x0e7f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a800,22273) }, /* #64/3/2/c */
    { 0x0f00, 0xf3b8, 0xf9a0, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/3/3/u */
    { 0x0f7f, 0xf3b8, 0x7920, RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ef,22273), RTFLOAT64U_INIT_C(1,0x9f65449ecae18,512), RTFLOAT80U_INIT_C(0,0xd6d12ad00cc2a8ee,22273) }, /* #64/3/3/c */
    { 0x0000, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/0/0/u */
    { 0x007f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea1940000000000,20243) }, /* #65/0/0/c */
    { 0x0100, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/0/1/u */
    { 0x017f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/0/1/c */
    { 0x0200, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/0/2/u */
    { 0x027f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f800,20243) }, /* #65/0/2/c */
    { 0x0300, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/0/3/u */
    { 0x037f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/0/3/c */
    { 0x0400, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/1/0/u */
    { 0x047f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea1940000000000,20243) }, /* #65/1/0/c */
    { 0x0500, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/1/1/u */
    { 0x057f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/1/1/c */
    { 0x0600, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/1/2/u */
    { 0x067f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa20000,20243) }, /* #65/1/2/c */
    { 0x0700, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/1/3/u */
    { 0x077f, 0x41b0, 0x7b22, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/1/3/c */
    { 0x0800, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/2/0/u */
    { 0x087f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea1930000000000,20243) }, /* #65/2/0/c */
    { 0x0900, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/2/1/u */
    { 0x097f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90e,20243) }, /* #65/2/1/c */
    { 0x0a00, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/2/2/u */
    { 0x0a7f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f800,20243) }, /* #65/2/2/c */
    { 0x0b00, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/2/3/u */
    { 0x0b7f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90e,20243) }, /* #65/2/3/c */
    { 0x0c00, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/3/0/u */
    { 0x0c7f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea1930000000000,20243) }, /* #65/3/0/c */
    { 0x0d00, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/3/1/u */
    { 0x0d7f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90e,20243) }, /* #65/3/1/c */
    { 0x0e00, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/3/2/u */
    { 0x0e7f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f800,20243) }, /* #65/3/2/c */
    { 0x0f00, 0x41b0, 0xf982, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243) }, /* #65/3/3/u */
    { 0x0f7f, 0x41b0, 0x7922, RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90f,20243), RTFLOAT64U_INIT_C(0,0x3d300,0), RTFLOAT80U_INIT_C(1,0xeea193ddcfa1f90e,20243) }, /* #65/3/3/c */
    { 0x0000, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/0/u */
    { 0x007f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/0/c */
    { 0x0100, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/1/u */
    { 0x017f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/1/c */
    { 0x0200, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/2/u */
    { 0x027f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/2/c */
    { 0x0300, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/3/u */
    { 0x037f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/0/3/c */
    { 0x0400, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/0/u */
    { 0x047f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/0/c */
    { 0x0500, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/1/u */
    { 0x057f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/1/c */
    { 0x0600, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/2/u */
    { 0x067f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/2/c */
    { 0x0700, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/3/u */
    { 0x077f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/1/3/c */
    { 0x0800, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/0/u */
    { 0x087f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/0/c */
    { 0x0900, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/1/u */
    { 0x097f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/1/c */
    { 0x0a00, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/2/u */
    { 0x0a7f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/2/c */
    { 0x0b00, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/3/u */
    { 0x0b7f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/2/3/c */
    { 0x0c00, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/0/u */
    { 0x0c7f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/0/c */
    { 0x0d00, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/1/u */
    { 0x0d7f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/1/c */
    { 0x0e00, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/2/u */
    { 0x0e7f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/2/c */
    { 0x0f00, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/3/u */
    { 0x0f7f, 0x0b69, 0x3900, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x59bbb3bc4e25d,1172), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #66/3/3/c */
    { 0x0000, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/0/0/u */
    { 0x007f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee50000000000,15341) }, /* #67/0/0/c */
    { 0x0100, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/0/1/u */
    { 0x017f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee56680000000,15341) }, /* #67/0/1/c */
    { 0x0200, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/0/2/u */
    { 0x027f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee56680000000,15341) }, /* #67/0/2/c */
    { 0x0300, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/0/3/u */
    { 0x037f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee56680000000,15341) }, /* #67/0/3/c */
    { 0x0400, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/1/0/u */
    { 0x047f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee50000000000,15341) }, /* #67/1/0/c */
    { 0x0500, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/1/1/u */
    { 0x057f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee5667fffffff,15341) }, /* #67/1/1/c */
    { 0x0600, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/1/2/u */
    { 0x067f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee5667ffff800,15341) }, /* #67/1/2/c */
    { 0x0700, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/1/3/u */
    { 0x077f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee5667fffffff,15341) }, /* #67/1/3/c */
    { 0x0800, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/2/0/u */
    { 0x087f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee60000000000,15341) }, /* #67/2/0/c */
    { 0x0900, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/2/1/u */
    { 0x097f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee56680000000,15341) }, /* #67/2/1/c */
    { 0x0a00, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/2/2/u */
    { 0x0a7f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee56680000000,15341) }, /* #67/2/2/c */
    { 0x0b00, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/2/3/u */
    { 0x0b7f, 0x6d0e, 0x7f22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee56680000000,15341) }, /* #67/2/3/c */
    { 0x0c00, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/3/0/u */
    { 0x0c7f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee50000000000,15341) }, /* #67/3/0/c */
    { 0x0d00, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/3/1/u */
    { 0x0d7f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee5667fffffff,15341) }, /* #67/3/1/c */
    { 0x0e00, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/3/2/u */
    { 0x0e7f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee5667ffff800,15341) }, /* #67/3/2/c */
    { 0x0f00, 0x6d0e, 0xfd82, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117) }, /* #67/3/3/u */
    { 0x0f7f, 0x6d0e, 0x7d22, RTFLOAT80U_INIT_C(1,0xff81eef3165ddfcf,13117), RTFLOAT64U_INIT_C(0,0x18eddcacd,0), RTFLOAT80U_INIT_C(0,0xc76ee5667fffffff,15341) }, /* #67/3/3/c */
    { 0x0000, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/0/0/u */
    { 0x007f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/0/0/c */
    { 0x0100, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/0/1/u */
    { 0x017f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/0/1/c */
    { 0x0200, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/0/2/u */
    { 0x027f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/0/2/c */
    { 0x0300, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/0/3/u */
    { 0x037f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/0/3/c */
    { 0x0400, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/1/0/u */
    { 0x047f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/1/0/c */
    { 0x0500, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/1/1/u */
    { 0x057f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/1/1/c */
    { 0x0600, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/1/2/u */
    { 0x067f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/1/2/c */
    { 0x0700, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/1/3/u */
    { 0x077f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/1/3/c */
    { 0x0800, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/2/0/u */
    { 0x087f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/2/0/c */
    { 0x0900, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/2/1/u */
    { 0x097f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/2/1/c */
    { 0x0a00, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/2/2/u */
    { 0x0a7f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/2/2/c */
    { 0x0b00, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/2/3/u */
    { 0x0b7f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/2/3/c */
    { 0x0c00, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/3/0/u */
    { 0x0c7f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/3/0/c */
    { 0x0d00, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/3/1/u */
    { 0x0d7f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/3/1/c */
    { 0x0e00, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/3/2/u */
    { 0x0e7f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/3/2/c */
    { 0x0f00, 0xd22b, 0xf881, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(0,0x7ae,32767) }, /* #68/3/3/u */
    { 0x0f7f, 0xd22b, 0x7801, RTFLOAT80U_INIT_C(0,0x7ae,32767), RTFLOAT64U_INIT_C(1,0x930d845693adc,1915), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #68/3/3/c */
    { 0x0000, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/0/0/u */
    { 0x007f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad120000000000,16455) }, /* #69/0/0/c */
    { 0x0100, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/0/1/u */
    { 0x017f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e1000,16455) }, /* #69/0/1/c */
    { 0x0200, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/0/2/u */
    { 0x027f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e1000,16455) }, /* #69/0/2/c */
    { 0x0300, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/0/3/u */
    { 0x037f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e1000,16455) }, /* #69/0/3/c */
    { 0x0400, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/1/0/u */
    { 0x047f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad130000000000,16455) }, /* #69/1/0/c */
    { 0x0500, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/1/1/u */
    { 0x057f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e1000,16455) }, /* #69/1/1/c */
    { 0x0600, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/1/2/u */
    { 0x067f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e1000,16455) }, /* #69/1/2/c */
    { 0x0700, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/1/3/u */
    { 0x077f, 0x8e64, 0x3e22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e1000,16455) }, /* #69/1/3/c */
    { 0x0800, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/2/0/u */
    { 0x087f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad120000000000,16455) }, /* #69/2/0/c */
    { 0x0900, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/2/1/u */
    { 0x097f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e0fff,16455) }, /* #69/2/1/c */
    { 0x0a00, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/2/2/u */
    { 0x0a7f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e0800,16455) }, /* #69/2/2/c */
    { 0x0b00, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/2/3/u */
    { 0x0b7f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e0fff,16455) }, /* #69/2/3/c */
    { 0x0c00, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/3/0/u */
    { 0x0c7f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad120000000000,16455) }, /* #69/3/0/c */
    { 0x0d00, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/3/1/u */
    { 0x0d7f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e0fff,16455) }, /* #69/3/1/c */
    { 0x0e00, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/3/2/u */
    { 0x0e7f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e0800,16455) }, /* #69/3/2/c */
    { 0x0f00, 0x8e64, 0xbc82, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(0,0x1836c6eb742,0) }, /* #69/3/3/u */
    { 0x0f7f, 0x8e64, 0x3c22, RTFLOAT80U_INIT_C(0,0x1836c6eb742,0), RTFLOAT64U_INIT_C(1,0xbf5a24cce4dc2,1095), RTFLOAT80U_INIT_C(1,0xdfad1266726e0fff,16455) }, /* #69/3/3/c */
    { 0x0000, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/0/0/u */
    { 0x007f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1450000000000,17402) }, /* #70/0/0/c */
    { 0x0100, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/0/1/u */
    { 0x017f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d800,17402) }, /* #70/0/1/c */
    { 0x0200, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/0/2/u */
    { 0x027f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d800,17402) }, /* #70/0/2/c */
    { 0x0300, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/0/3/u */
    { 0x037f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d800,17402) }, /* #70/0/3/c */
    { 0x0400, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/1/0/u */
    { 0x047f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1450000000000,17402) }, /* #70/1/0/c */
    { 0x0500, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/1/1/u */
    { 0x057f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d7ff,17402) }, /* #70/1/1/c */
    { 0x0600, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/1/2/u */
    { 0x067f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d000,17402) }, /* #70/1/2/c */
    { 0x0700, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/1/3/u */
    { 0x077f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d7ff,17402) }, /* #70/1/3/c */
    { 0x0800, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/2/0/u */
    { 0x087f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1460000000000,17402) }, /* #70/2/0/c */
    { 0x0900, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/2/1/u */
    { 0x097f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d800,17402) }, /* #70/2/1/c */
    { 0x0a00, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/2/2/u */
    { 0x0a7f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d800,17402) }, /* #70/2/2/c */
    { 0x0b00, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/2/3/u */
    { 0x0b7f, 0x3bcc, 0x3b22, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d800,17402) }, /* #70/2/3/c */
    { 0x0c00, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/3/0/u */
    { 0x0c7f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1450000000000,17402) }, /* #70/3/0/c */
    { 0x0d00, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/3/1/u */
    { 0x0d7f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d7ff,17402) }, /* #70/3/1/c */
    { 0x0e00, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/3/2/u */
    { 0x0e7f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d000,17402) }, /* #70/3/2/c */
    { 0x0f00, 0x3bcc, 0xb982, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(1,0x80000000000a1357,0) }, /* #70/3/3/u */
    { 0x0f7f, 0x3bcc, 0x3922, RTFLOAT80U_INIT_C(1,0x80000000000a1357,0), RTFLOAT64U_INIT_C(0,0xc7e28ab56e67b,2042), RTFLOAT80U_INIT_C(0,0xe3f1455ab733d7ff,17402) }, /* #70/3/3/c */
    { 0x0000, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/0/u */
    { 0x007f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/0/c */
    { 0x0100, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/1/u */
    { 0x017f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/1/c */
    { 0x0200, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/2/u */
    { 0x027f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/2/c */
    { 0x0300, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/3/u */
    { 0x037f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/0/3/c */
    { 0x0400, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/0/u */
    { 0x047f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/0/c */
    { 0x0500, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/1/u */
    { 0x057f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/1/c */
    { 0x0600, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/2/u */
    { 0x067f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/2/c */
    { 0x0700, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/3/u */
    { 0x077f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/1/3/c */
    { 0x0800, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/0/u */
    { 0x087f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/0/c */
    { 0x0900, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/1/u */
    { 0x097f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/1/c */
    { 0x0a00, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/2/u */
    { 0x0a7f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/2/c */
    { 0x0b00, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/3/u */
    { 0x0b7f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/2/3/c */
    { 0x0c00, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/0/u */
    { 0x0c7f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/0/c */
    { 0x0d00, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/1/u */
    { 0x0d7f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/1/c */
    { 0x0e00, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/2/u */
    { 0x0e7f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/2/c */
    { 0x0f00, 0x3bc8, 0xb982, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/3/u */
    { 0x0f7f, 0x3bc8, 0x3902, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #71/3/3/c */
    { 0x0000, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0840000000000,16571) }, /* #72/0/0/u */
    { 0x007f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0840000000000,16571) }, /* #72/0/0/c */
    { 0x0100, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/0/1/u */
    { 0x017f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/0/1/c */
    { 0x0200, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/0/2/u */
    { 0x027f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/0/2/c */
    { 0x0300, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/0/3/u */
    { 0x037f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/0/3/c */
    { 0x0400, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0850000000000,16571) }, /* #72/1/0/u */
    { 0x047f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0850000000000,16571) }, /* #72/1/0/c */
    { 0x0500, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/1/1/u */
    { 0x057f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/1/1/c */
    { 0x0600, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/1/2/u */
    { 0x067f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/1/2/c */
    { 0x0700, 0x9d21, 0xbfa0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/1/3/u */
    { 0x077f, 0x9d21, 0x3f20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3800,16571) }, /* #72/1/3/c */
    { 0x0800, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0840000000000,16571) }, /* #72/2/0/u */
    { 0x087f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0840000000000,16571) }, /* #72/2/0/c */
    { 0x0900, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/2/1/u */
    { 0x097f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/2/1/c */
    { 0x0a00, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3000,16571) }, /* #72/2/2/u */
    { 0x0a7f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3000,16571) }, /* #72/2/2/c */
    { 0x0b00, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/2/3/u */
    { 0x0b7f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/2/3/c */
    { 0x0c00, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0840000000000,16571) }, /* #72/3/0/u */
    { 0x0c7f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0840000000000,16571) }, /* #72/3/0/c */
    { 0x0d00, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/3/1/u */
    { 0x0d7f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/3/1/c */
    { 0x0e00, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3000,16571) }, /* #72/3/2/u */
    { 0x0e7f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa3000,16571) }, /* #72/3/2/c */
    { 0x0f00, 0x9d21, 0xbda0, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/3/3/u */
    { 0x0f7f, 0x9d21, 0x3d20, RTFLOAT80U_INIT_C(0,0x944376dfc8678a75,2792), RTFLOAT64U_INIT_C(1,0x3d810880cb547,1211), RTFLOAT80U_INIT_C(1,0x9ec0844065aa37ff,16571) }, /* #72/3/3/c */
    { 0x0000, 0x2707, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a8a0000000000,28525) }, /* #73/0/0/u */
    { 0x007f, 0x2707, 0x3f20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a8a0000000000,28525) }, /* #73/0/0/c */
    { 0x0100, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/0/1/u */
    { 0x017f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/0/1/c */
    { 0x0200, 0x2707, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a800,28525) }, /* #73/0/2/u */
    { 0x027f, 0x2707, 0x3f20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a800,28525) }, /* #73/0/2/c */
    { 0x0300, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/0/3/u */
    { 0x037f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/0/3/c */
    { 0x0400, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a890000000000,28525) }, /* #73/1/0/u */
    { 0x047f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a890000000000,28525) }, /* #73/1/0/c */
    { 0x0500, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/1/1/u */
    { 0x057f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/1/1/c */
    { 0x0600, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a000,28525) }, /* #73/1/2/u */
    { 0x067f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a000,28525) }, /* #73/1/2/c */
    { 0x0700, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/1/3/u */
    { 0x077f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/1/3/c */
    { 0x0800, 0x2707, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a8a0000000000,28525) }, /* #73/2/0/u */
    { 0x087f, 0x2707, 0x3f20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a8a0000000000,28525) }, /* #73/2/0/c */
    { 0x0900, 0x2707, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7ec,28525) }, /* #73/2/1/u */
    { 0x097f, 0x2707, 0x3f20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7ec,28525) }, /* #73/2/1/c */
    { 0x0a00, 0x2707, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a800,28525) }, /* #73/2/2/u */
    { 0x0a7f, 0x2707, 0x3f20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a800,28525) }, /* #73/2/2/c */
    { 0x0b00, 0x2707, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7ec,28525) }, /* #73/2/3/u */
    { 0x0b7f, 0x2707, 0x3f20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7ec,28525) }, /* #73/2/3/c */
    { 0x0c00, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a890000000000,28525) }, /* #73/3/0/u */
    { 0x0c7f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a890000000000,28525) }, /* #73/3/0/c */
    { 0x0d00, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/3/1/u */
    { 0x0d7f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/3/1/c */
    { 0x0e00, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a000,28525) }, /* #73/3/2/u */
    { 0x0e7f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a000,28525) }, /* #73/3/2/c */
    { 0x0f00, 0x2707, 0xbda0, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/3/3/u */
    { 0x0f7f, 0x2707, 0x3d20, RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525), RTFLOAT64U_INIT_C(0,0x8bfd56ec2050c,1586), RTFLOAT80U_INIT_C(0,0x8c7a89da8026a7eb,28525) }, /* #73/3/3/c */
    { 0x0000, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de30000000000,15499) }, /* #74/0/0/u */
    { 0x007f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de30000000000,15499) }, /* #74/0/0/c */
    { 0x0100, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/0/1/u */
    { 0x017f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/0/1/c */
    { 0x0200, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/0/2/u */
    { 0x027f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/0/2/c */
    { 0x0300, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/0/3/u */
    { 0x037f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/0/3/c */
    { 0x0400, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de30000000000,15499) }, /* #74/1/0/u */
    { 0x047f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de30000000000,15499) }, /* #74/1/0/c */
    { 0x0500, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/1/1/u */
    { 0x057f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/1/1/c */
    { 0x0600, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/1/2/u */
    { 0x067f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/1/2/c */
    { 0x0700, 0xb05b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/1/3/u */
    { 0x077f, 0xb05b, 0x3a20, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72800,15499) }, /* #74/1/3/c */
    { 0x0800, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de20000000000,15499) }, /* #74/2/0/u */
    { 0x087f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de20000000000,15499) }, /* #74/2/0/c */
    { 0x0900, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/2/1/u */
    { 0x097f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/2/1/c */
    { 0x0a00, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72000,15499) }, /* #74/2/2/u */
    { 0x0a7f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72000,15499) }, /* #74/2/2/c */
    { 0x0b00, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/2/3/u */
    { 0x0b7f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/2/3/c */
    { 0x0c00, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de20000000000,15499) }, /* #74/3/0/u */
    { 0x0c7f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de20000000000,15499) }, /* #74/3/0/c */
    { 0x0d00, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/3/1/u */
    { 0x0d7f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/3/1/c */
    { 0x0e00, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72000,15499) }, /* #74/3/2/u */
    { 0x0e7f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e72000,15499) }, /* #74/3/2/c */
    { 0x0f00, 0xb05b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/3/3/u */
    { 0x0f7f, 0xb05b, 0x3820, RTFLOAT80U_INIT_C(0,0xd821165c40c1e195,2539), RTFLOAT64U_INIT_C(1,0x767bc59eebce5,139), RTFLOAT80U_INIT_C(1,0xbb3de2cf75e727ff,15499) }, /* #74/3/3/c */
    { 0x0000, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a370000000000,16827) }, /* #75/0/0/u */
    { 0x007f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a370000000000,16827) }, /* #75/0/0/c */
    { 0x0100, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/0/1/u */
    { 0x017f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/0/1/c */
    { 0x0200, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/0/2/u */
    { 0x027f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/0/2/c */
    { 0x0300, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/0/3/u */
    { 0x037f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/0/3/c */
    { 0x0400, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a370000000000,16827) }, /* #75/1/0/u */
    { 0x047f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a370000000000,16827) }, /* #75/1/0/c */
    { 0x0500, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/1/1/u */
    { 0x057f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/1/1/c */
    { 0x0600, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/1/2/u */
    { 0x067f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/1/2/c */
    { 0x0700, 0x23be, 0xbba0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/1/3/u */
    { 0x077f, 0x23be, 0x3b20, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95800,16827) }, /* #75/1/3/c */
    { 0x0800, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a360000000000,16827) }, /* #75/2/0/u */
    { 0x087f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a360000000000,16827) }, /* #75/2/0/c */
    { 0x0900, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/2/1/u */
    { 0x097f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/2/1/c */
    { 0x0a00, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95000,16827) }, /* #75/2/2/u */
    { 0x0a7f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95000,16827) }, /* #75/2/2/c */
    { 0x0b00, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/2/3/u */
    { 0x0b7f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/2/3/c */
    { 0x0c00, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a360000000000,16827) }, /* #75/3/0/u */
    { 0x0c7f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a360000000000,16827) }, /* #75/3/0/c */
    { 0x0d00, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/3/1/u */
    { 0x0d7f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/3/1/c */
    { 0x0e00, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95000,16827) }, /* #75/3/2/u */
    { 0x0e7f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b95000,16827) }, /* #75/3/2/c */
    { 0x0f00, 0x23be, 0xb9a0, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/3/3/u */
    { 0x0f7f, 0x23be, 0x3920, RTFLOAT80U_INIT_C(0,0x829e053b98a997a0,790), RTFLOAT64U_INIT_C(1,0xa4546d3f4d72b,1467), RTFLOAT80U_INIT_C(1,0xd22a369fa6b957ff,16827) }, /* #75/3/3/c */
    { 0x0000, 0xd5d2, 0xffa0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d80000000000,26816) }, /* #76/0/0/u */
    { 0x007f, 0xd5d2, 0x7f20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d80000000000,26816) }, /* #76/0/0/c */
    { 0x0100, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/0/1/u */
    { 0x017f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/0/1/c */
    { 0x0200, 0xd5d2, 0xffa0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb8a000,26816) }, /* #76/0/2/u */
    { 0x027f, 0xd5d2, 0x7f20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb8a000,26816) }, /* #76/0/2/c */
    { 0x0300, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/0/3/u */
    { 0x037f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/0/3/c */
    { 0x0400, 0xd5d2, 0xffa0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d80000000000,26816) }, /* #76/1/0/u */
    { 0x047f, 0xd5d2, 0x7f20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d80000000000,26816) }, /* #76/1/0/c */
    { 0x0500, 0xd5d2, 0xffa0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e19,26816) }, /* #76/1/1/u */
    { 0x057f, 0xd5d2, 0x7f20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e19,26816) }, /* #76/1/1/c */
    { 0x0600, 0xd5d2, 0xffa0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb8a000,26816) }, /* #76/1/2/u */
    { 0x067f, 0xd5d2, 0x7f20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb8a000,26816) }, /* #76/1/2/c */
    { 0x0700, 0xd5d2, 0xffa0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e19,26816) }, /* #76/1/3/u */
    { 0x077f, 0xd5d2, 0x7f20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e19,26816) }, /* #76/1/3/c */
    { 0x0800, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d70000000000,26816) }, /* #76/2/0/u */
    { 0x087f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d70000000000,26816) }, /* #76/2/0/c */
    { 0x0900, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/2/1/u */
    { 0x097f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/2/1/c */
    { 0x0a00, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89800,26816) }, /* #76/2/2/u */
    { 0x0a7f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89800,26816) }, /* #76/2/2/c */
    { 0x0b00, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/2/3/u */
    { 0x0b7f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/2/3/c */
    { 0x0c00, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d70000000000,26816) }, /* #76/3/0/u */
    { 0x0c7f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d70000000000,26816) }, /* #76/3/0/c */
    { 0x0d00, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/3/1/u */
    { 0x0d7f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/3/1/c */
    { 0x0e00, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89800,26816) }, /* #76/3/2/u */
    { 0x0e7f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89800,26816) }, /* #76/3/2/c */
    { 0x0f00, 0xd5d2, 0xfda0, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/3/3/u */
    { 0x0f7f, 0xd5d2, 0x7d20, RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816), RTFLOAT64U_INIT_C(1,0xaff3e979f95cf,715), RTFLOAT80U_INIT_C(1,0xfc93d7f7ccb89e18,26816) }, /* #76/3/3/c */
    { 0x0000, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a0000000000,19045) }, /* #77/0/0/u */
    { 0x007f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a0000000000,19045) }, /* #77/0/0/c */
    { 0x0100, 0x0365, 0xbba0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/0/1/u */
    { 0x017f, 0x0365, 0x3b20, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/0/1/c */
    { 0x0200, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe000,19045) }, /* #77/0/2/u */
    { 0x027f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe000,19045) }, /* #77/0/2/c */
    { 0x0300, 0x0365, 0xbba0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/0/3/u */
    { 0x037f, 0x0365, 0x3b20, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/0/3/c */
    { 0x0400, 0x0365, 0xbba0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2b0000000000,19045) }, /* #77/1/0/u */
    { 0x047f, 0x0365, 0x3b20, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2b0000000000,19045) }, /* #77/1/0/c */
    { 0x0500, 0x0365, 0xbba0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/1/1/u */
    { 0x057f, 0x0365, 0x3b20, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/1/1/c */
    { 0x0600, 0x0365, 0xbba0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe800,19045) }, /* #77/1/2/u */
    { 0x067f, 0x0365, 0x3b20, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe800,19045) }, /* #77/1/2/c */
    { 0x0700, 0x0365, 0xbba0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/1/3/u */
    { 0x077f, 0x0365, 0x3b20, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045) }, /* #77/1/3/c */
    { 0x0800, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a0000000000,19045) }, /* #77/2/0/u */
    { 0x087f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a0000000000,19045) }, /* #77/2/0/c */
    { 0x0900, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/2/1/u */
    { 0x097f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/2/1/c */
    { 0x0a00, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe000,19045) }, /* #77/2/2/u */
    { 0x0a7f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe000,19045) }, /* #77/2/2/c */
    { 0x0b00, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/2/3/u */
    { 0x0b7f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/2/3/c */
    { 0x0c00, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a0000000000,19045) }, /* #77/3/0/u */
    { 0x0c7f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a0000000000,19045) }, /* #77/3/0/c */
    { 0x0d00, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/3/1/u */
    { 0x0d7f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/3/1/c */
    { 0x0e00, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe000,19045) }, /* #77/3/2/u */
    { 0x0e7f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe000,19045) }, /* #77/3/2/c */
    { 0x0f00, 0x0365, 0xb9a0, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/3/3/u */
    { 0x0f7f, 0x0365, 0x3920, RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b1,19045), RTFLOAT64U_INIT_C(0,0x28db630457119,1371), RTFLOAT80U_INIT_C(1,0x90af2a113dafe1b0,19045) }, /* #77/3/3/c */
    { 0x0000, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/0/0/u */
    { 0x007f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/0/0/c */
    { 0x0100, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/0/1/u */
    { 0x017f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/0/1/c */
    { 0x0200, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/0/2/u */
    { 0x027f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/0/2/c */
    { 0x0300, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/0/3/u */
    { 0x037f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/0/3/c */
    { 0x0400, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/1/0/u */
    { 0x047f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/1/0/c */
    { 0x0500, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/1/1/u */
    { 0x057f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/1/1/c */
    { 0x0600, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/1/2/u */
    { 0x067f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/1/2/c */
    { 0x0700, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/1/3/u */
    { 0x077f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/1/3/c */
    { 0x0800, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/2/0/u */
    { 0x087f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/2/0/c */
    { 0x0900, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/2/1/u */
    { 0x097f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/2/1/c */
    { 0x0a00, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/2/2/u */
    { 0x0a7f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/2/2/c */
    { 0x0b00, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/2/3/u */
    { 0x0b7f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/2/3/c */
    { 0x0c00, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/3/0/u */
    { 0x0c7f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/3/0/c */
    { 0x0d00, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/3/1/u */
    { 0x0d7f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/3/1/c */
    { 0x0e00, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/3/2/u */
    { 0x0e7f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/3/2/c */
    { 0x0f00, 0x3a77, 0xb881, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795) }, /* #78/3/3/u */
    { 0x0f7f, 0x3a77, 0x3801, RTFLOAT80U_INIT_C(0,0x6048ab686569fab6,19795), RTFLOAT64U_INIT_C(0,0xc771b284053c2,1616), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #78/3/3/c */
    { 0x0000, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/0/0/u */
    { 0x007f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d0000000000,24199) }, /* #79/0/0/c */
    { 0x0100, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/0/1/u */
    { 0x017f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/0/1/c */
    { 0x0200, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/0/2/u */
    { 0x027f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332f800,24199) }, /* #79/0/2/c */
    { 0x0300, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/0/3/u */
    { 0x037f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/0/3/c */
    { 0x0400, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/1/0/u */
    { 0x047f, 0x9466, 0x3e22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1e0000000000,24199) }, /* #79/1/0/c */
    { 0x0500, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/1/1/u */
    { 0x057f, 0x9466, 0x3e22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb28,24199) }, /* #79/1/1/c */
    { 0x0600, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/1/2/u */
    { 0x067f, 0x9466, 0x3e22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d0613330000,24199) }, /* #79/1/2/c */
    { 0x0700, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/1/3/u */
    { 0x077f, 0x9466, 0x3e22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb28,24199) }, /* #79/1/3/c */
    { 0x0800, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/2/0/u */
    { 0x087f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d0000000000,24199) }, /* #79/2/0/c */
    { 0x0900, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/2/1/u */
    { 0x097f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/2/1/c */
    { 0x0a00, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/2/2/u */
    { 0x0a7f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332f800,24199) }, /* #79/2/2/c */
    { 0x0b00, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/2/3/u */
    { 0x0b7f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/2/3/c */
    { 0x0c00, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/3/0/u */
    { 0x0c7f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d0000000000,24199) }, /* #79/3/0/c */
    { 0x0d00, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/3/1/u */
    { 0x0d7f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/3/1/c */
    { 0x0e00, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/3/2/u */
    { 0x0e7f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332f800,24199) }, /* #79/3/2/c */
    { 0x0f00, 0x9466, 0xbc82, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/3/3/u */
    { 0x0f7f, 0x9466, 0x3c22, RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199), RTFLOAT64U_INIT_C(1,0xfe2e6f8b41460,0), RTFLOAT80U_INIT_C(1,0xe05f1d061332fb27,24199) }, /* #79/3/3/c */
    { 0x0000, 0x515f, 0xfba0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9640000000000,5120) }, /* #80/0/0/u */
    { 0x007f, 0x515f, 0x7b20, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9640000000000,5120) }, /* #80/0/0/c */
    { 0x0100, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/0/1/u */
    { 0x017f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/0/1/c */
    { 0x0200, 0x515f, 0xf9a0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb000,5120) }, /* #80/0/2/u */
    { 0x027f, 0x515f, 0x7920, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb000,5120) }, /* #80/0/2/c */
    { 0x0300, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/0/3/u */
    { 0x037f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/0/3/c */
    { 0x0400, 0x515f, 0xf9a0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9630000000000,5120) }, /* #80/1/0/u */
    { 0x047f, 0x515f, 0x7920, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9630000000000,5120) }, /* #80/1/0/c */
    { 0x0500, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/1/1/u */
    { 0x057f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/1/1/c */
    { 0x0600, 0x515f, 0xf9a0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb000,5120) }, /* #80/1/2/u */
    { 0x067f, 0x515f, 0x7920, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb000,5120) }, /* #80/1/2/c */
    { 0x0700, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/1/3/u */
    { 0x077f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/1/3/c */
    { 0x0800, 0x515f, 0xfba0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9640000000000,5120) }, /* #80/2/0/u */
    { 0x087f, 0x515f, 0x7b20, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9640000000000,5120) }, /* #80/2/0/c */
    { 0x0900, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/2/1/u */
    { 0x097f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/2/1/c */
    { 0x0a00, 0x515f, 0xfba0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb800,5120) }, /* #80/2/2/u */
    { 0x0a7f, 0x515f, 0x7b20, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb800,5120) }, /* #80/2/2/c */
    { 0x0b00, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/2/3/u */
    { 0x0b7f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/2/3/c */
    { 0x0c00, 0x515f, 0xf9a0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9630000000000,5120) }, /* #80/3/0/u */
    { 0x0c7f, 0x515f, 0x7920, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f9630000000000,5120) }, /* #80/3/0/c */
    { 0x0d00, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/3/1/u */
    { 0x0d7f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/3/1/c */
    { 0x0e00, 0x515f, 0xf9a0, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb000,5120) }, /* #80/3/2/u */
    { 0x0e7f, 0x515f, 0x7920, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb000,5120) }, /* #80/3/2/c */
    { 0x0f00, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/3/3/u */
    { 0x0f7f, 0x515f, 0x7900, RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xa5f963d8740cb351,5120) }, /* #80/3/3/c */
    { 0x0000, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/0/u */
    { 0x007f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/0/c */
    { 0x0100, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/1/u */
    { 0x017f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/1/c */
    { 0x0200, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/2/u */
    { 0x027f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/2/c */
    { 0x0300, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/3/u */
    { 0x037f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/0/3/c */
    { 0x0400, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/0/u */
    { 0x047f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/0/c */
    { 0x0500, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/1/u */
    { 0x057f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/1/c */
    { 0x0600, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/2/u */
    { 0x067f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/2/c */
    { 0x0700, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/3/u */
    { 0x077f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/1/3/c */
    { 0x0800, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/0/u */
    { 0x087f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/0/c */
    { 0x0900, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/1/u */
    { 0x097f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/1/c */
    { 0x0a00, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/2/u */
    { 0x0a7f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/2/c */
    { 0x0b00, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/3/u */
    { 0x0b7f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/2/3/c */
    { 0x0c00, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/0/u */
    { 0x0c7f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/0/c */
    { 0x0d00, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/1/u */
    { 0x0d7f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/1/c */
    { 0x0e00, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/2/u */
    { 0x0e7f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/2/c */
    { 0x0f00, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/3/u */
    { 0x0f7f, 0x6eb7, 0x7c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0xe5ad34a6eb6ad,1526), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #81/3/3/c */
    { 0x0000, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/0/0/u */
    { 0x007f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/0/c */
    { 0x0100, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/0/1/u */
    { 0x017f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/1/c */
    { 0x0200, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/0/2/u */
    { 0x027f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/2/c */
    { 0x0300, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/0/3/u */
    { 0x037f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/3/c */
    { 0x0400, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/1/0/u */
    { 0x047f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/0/c */
    { 0x0500, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/1/1/u */
    { 0x057f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/1/c */
    { 0x0600, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/1/2/u */
    { 0x067f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/2/c */
    { 0x0700, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/1/3/u */
    { 0x077f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/3/c */
    { 0x0800, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/2/0/u */
    { 0x087f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/0/c */
    { 0x0900, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/2/1/u */
    { 0x097f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/1/c */
    { 0x0a00, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/2/2/u */
    { 0x0a7f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/2/c */
    { 0x0b00, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/2/3/u */
    { 0x0b7f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/3/c */
    { 0x0c00, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/3/0/u */
    { 0x0c7f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/0/c */
    { 0x0d00, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/3/1/u */
    { 0x0d7f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/1/c */
    { 0x0e00, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/3/2/u */
    { 0x0e7f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/2/c */
    { 0x0f00, 0x051d, 0xbd81, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(0,0x1408,32767) }, /* #82/3/3/u */
    { 0x0f7f, 0x051d, 0x3d01, RTFLOAT80U_INIT_C(0,0x1408,32767), RTFLOAT64U_INIT_C(1,0xb3c679b71a196,847), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/3/c */
    { 0x0000, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/0/0/u */
    { 0x007f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/0/c */
    { 0x0100, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/0/1/u */
    { 0x017f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/1/c */
    { 0x0200, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/0/2/u */
    { 0x027f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/2/c */
    { 0x0300, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/0/3/u */
    { 0x037f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/0/3/c */
    { 0x0400, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/1/0/u */
    { 0x047f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/0/c */
    { 0x0500, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/1/1/u */
    { 0x057f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/1/c */
    { 0x0600, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/1/2/u */
    { 0x067f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/2/c */
    { 0x0700, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/1/3/u */
    { 0x077f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/1/3/c */
    { 0x0800, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/2/0/u */
    { 0x087f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/0/c */
    { 0x0900, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/2/1/u */
    { 0x097f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/1/c */
    { 0x0a00, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/2/2/u */
    { 0x0a7f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/2/c */
    { 0x0b00, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/2/3/u */
    { 0x0b7f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/2/3/c */
    { 0x0c00, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/3/0/u */
    { 0x0c7f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/0/c */
    { 0x0d00, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/3/1/u */
    { 0x0d7f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/1/c */
    { 0x0e00, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/3/2/u */
    { 0x0e7f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/2/c */
    { 0x0f00, 0xdb28, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #83/3/3/u */
    { 0x0f7f, 0xdb28, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x43b58ce535c0a,1852), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #83/3/3/c */
    { 0x0000, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/0/0/u */
    { 0x007f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/0/c */
    { 0x0100, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/0/1/u */
    { 0x017f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/1/c */
    { 0x0200, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/0/2/u */
    { 0x027f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/2/c */
    { 0x0300, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/0/3/u */
    { 0x037f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/3/c */
    { 0x0400, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/1/0/u */
    { 0x047f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/0/c */
    { 0x0500, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/1/1/u */
    { 0x057f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/1/c */
    { 0x0600, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/1/2/u */
    { 0x067f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/2/c */
    { 0x0700, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/1/3/u */
    { 0x077f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/3/c */
    { 0x0800, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/2/0/u */
    { 0x087f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/0/c */
    { 0x0900, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/2/1/u */
    { 0x097f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/1/c */
    { 0x0a00, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/2/2/u */
    { 0x0a7f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/2/c */
    { 0x0b00, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/2/3/u */
    { 0x0b7f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/3/c */
    { 0x0c00, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/3/0/u */
    { 0x0c7f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/0/c */
    { 0x0d00, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/3/1/u */
    { 0x0d7f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/1/c */
    { 0x0e00, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/3/2/u */
    { 0x0e7f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/2/c */
    { 0x0f00, 0xb094, 0xb881, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767) }, /* #84/3/3/u */
    { 0x0f7f, 0xb094, 0x3801, RTFLOAT80U_INIT_C(1,0x4000000029a70044,32767), RTFLOAT64U_INIT_C(1,0x4ee6f044366a,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/3/c */
    { 0x0000, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/0/u */
    { 0x007f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/0/c */
    { 0x0100, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/1/u */
    { 0x017f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/1/c */
    { 0x0200, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/2/u */
    { 0x027f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/2/c */
    { 0x0300, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/3/u */
    { 0x037f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/0/3/c */
    { 0x0400, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/0/u */
    { 0x047f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/0/c */
    { 0x0500, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/1/u */
    { 0x057f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/1/c */
    { 0x0600, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/2/u */
    { 0x067f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/2/c */
    { 0x0700, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/3/u */
    { 0x077f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/1/3/c */
    { 0x0800, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/0/u */
    { 0x087f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/0/c */
    { 0x0900, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/1/u */
    { 0x097f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/1/c */
    { 0x0a00, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/2/u */
    { 0x0a7f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/2/c */
    { 0x0b00, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/3/u */
    { 0x0b7f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/2/3/c */
    { 0x0c00, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/0/u */
    { 0x0c7f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/0/c */
    { 0x0d00, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/1/u */
    { 0x0d7f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/1/c */
    { 0x0e00, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/2/u */
    { 0x0e7f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/2/c */
    { 0x0f00, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/3/u */
    { 0x0f7f, 0xcd8f, 0x7d00, RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767), RTFLOAT64U_INIT_C(0,0x4cb7e084bda12,1198), RTFLOAT80U_INIT_C(1,0xd9a8389fa99e94c7,32767) }, /* #85/3/3/c */
    { 0x0000, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/0/0/u */
    { 0x007f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/0/0/c */
    { 0x0100, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/0/1/u */
    { 0x017f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/0/1/c */
    { 0x0200, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/0/2/u */
    { 0x027f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/0/2/c */
    { 0x0300, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/0/3/u */
    { 0x037f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/0/3/c */
    { 0x0400, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/1/0/u */
    { 0x047f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/1/0/c */
    { 0x0500, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/1/1/u */
    { 0x057f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/1/1/c */
    { 0x0600, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/1/2/u */
    { 0x067f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/1/2/c */
    { 0x0700, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/1/3/u */
    { 0x077f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/1/3/c */
    { 0x0800, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/2/0/u */
    { 0x087f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/2/0/c */
    { 0x0900, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/2/1/u */
    { 0x097f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/2/1/c */
    { 0x0a00, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/2/2/u */
    { 0x0a7f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/2/2/c */
    { 0x0b00, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/2/3/u */
    { 0x0b7f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/2/3/c */
    { 0x0c00, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/3/0/u */
    { 0x0c7f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/3/0/c */
    { 0x0d00, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/3/1/u */
    { 0x0d7f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/3/1/c */
    { 0x0e00, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/3/2/u */
    { 0x0e7f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/3/2/c */
    { 0x0f00, 0x9eb8, 0xbc81, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0) }, /* #86/3/3/u */
    { 0x0f7f, 0x9eb8, 0x3c01, RTFLOAT80U_INIT_C(0,0xb6f5f5c23a8304aa,0), RTFLOAT64U_INIT_C(1,0x3680af27f121e,2047), RTFLOAT80U_INIT_C(1,0xdb405793f890f000,32767) }, /* #86/3/3/c */
    { 0x0000, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/0/0/u */
    { 0x007f, 0xa047, 0x3a22, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe2560000000000,16517) }, /* #87/0/0/c */
    { 0x0100, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/0/1/u */
    { 0x017f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/0/1/c */
    { 0x0200, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/0/2/u */
    { 0x027f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/0/2/c */
    { 0x0300, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/0/3/u */
    { 0x037f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/0/3/c */
    { 0x0400, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/1/0/u */
    { 0x047f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe2550000000000,16517) }, /* #87/1/0/c */
    { 0x0500, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/1/1/u */
    { 0x057f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/1/1/c */
    { 0x0600, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/1/2/u */
    { 0x067f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/1/2/c */
    { 0x0700, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/1/3/u */
    { 0x077f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/1/3/c */
    { 0x0800, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/2/0/u */
    { 0x087f, 0xa047, 0x3a22, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe2560000000000,16517) }, /* #87/2/0/c */
    { 0x0900, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/2/1/u */
    { 0x097f, 0xa047, 0x3a22, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421801,16517) }, /* #87/2/1/c */
    { 0x0a00, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/2/2/u */
    { 0x0a7f, 0xa047, 0x3a22, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72422000,16517) }, /* #87/2/2/c */
    { 0x0b00, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/2/3/u */
    { 0x0b7f, 0xa047, 0x3a22, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421801,16517) }, /* #87/2/3/c */
    { 0x0c00, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/3/0/u */
    { 0x0c7f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe2550000000000,16517) }, /* #87/3/0/c */
    { 0x0d00, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/3/1/u */
    { 0x0d7f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/3/1/c */
    { 0x0e00, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/3/2/u */
    { 0x0e7f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/3/2/c */
    { 0x0f00, 0xa047, 0xb882, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0x11b080323058f,0) }, /* #87/3/3/u */
    { 0x0f7f, 0xa047, 0x3822, RTFLOAT80U_INIT_C(0,0x11b080323058f,0), RTFLOAT64U_INIT_C(0,0xffc4ab54e4843,1157), RTFLOAT80U_INIT_C(0,0xffe255aa72421800,16517) }, /* #87/3/3/c */
    { 0x0000, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/0/0/u */
    { 0x007f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/0/c */
    { 0x0100, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/0/1/u */
    { 0x017f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/1/c */
    { 0x0200, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/0/2/u */
    { 0x027f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/2/c */
    { 0x0300, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/0/3/u */
    { 0x037f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/3/c */
    { 0x0400, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/1/0/u */
    { 0x047f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/0/c */
    { 0x0500, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/1/1/u */
    { 0x057f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/1/c */
    { 0x0600, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/1/2/u */
    { 0x067f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/2/c */
    { 0x0700, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/1/3/u */
    { 0x077f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/3/c */
    { 0x0800, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/2/0/u */
    { 0x087f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/0/c */
    { 0x0900, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/2/1/u */
    { 0x097f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/1/c */
    { 0x0a00, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/2/2/u */
    { 0x0a7f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/2/c */
    { 0x0b00, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/2/3/u */
    { 0x0b7f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/3/c */
    { 0x0c00, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/3/0/u */
    { 0x0c7f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/0/c */
    { 0x0d00, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/3/1/u */
    { 0x0d7f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/1/c */
    { 0x0e00, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/3/2/u */
    { 0x0e7f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/2/c */
    { 0x0f00, 0x9553, 0xbd81, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419) }, /* #88/3/3/u */
    { 0x0f7f, 0x9553, 0x3d01, RTFLOAT80U_INIT_C(0,0x7cf69ba81f628014,23419), RTFLOAT64U_INIT_C(0,0x21e137794fce8,911), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/3/c */
    { 0x0000, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc0000000000,24266) }, /* #89/0/0/u */
    { 0x007f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc0000000000,24266) }, /* #89/0/0/c */
    { 0x0100, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/0/1/u */
    { 0x017f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/0/1/c */
    { 0x0200, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc800,24266) }, /* #89/0/2/u */
    { 0x027f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc800,24266) }, /* #89/0/2/c */
    { 0x0300, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/0/3/u */
    { 0x037f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/0/3/c */
    { 0x0400, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc0000000000,24266) }, /* #89/1/0/u */
    { 0x047f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc0000000000,24266) }, /* #89/1/0/c */
    { 0x0500, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/1/1/u */
    { 0x057f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/1/1/c */
    { 0x0600, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc000,24266) }, /* #89/1/2/u */
    { 0x067f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc000,24266) }, /* #89/1/2/c */
    { 0x0700, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/1/3/u */
    { 0x077f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/1/3/c */
    { 0x0800, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dd0000000000,24266) }, /* #89/2/0/u */
    { 0x087f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dd0000000000,24266) }, /* #89/2/0/c */
    { 0x0900, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/2/1/u */
    { 0x097f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/2/1/c */
    { 0x0a00, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc800,24266) }, /* #89/2/2/u */
    { 0x0a7f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc800,24266) }, /* #89/2/2/c */
    { 0x0b00, 0x9d9c, 0xbfa0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/2/3/u */
    { 0x0b7f, 0x9d9c, 0x3f20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266) }, /* #89/2/3/c */
    { 0x0c00, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc0000000000,24266) }, /* #89/3/0/u */
    { 0x0c7f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc0000000000,24266) }, /* #89/3/0/c */
    { 0x0d00, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/3/1/u */
    { 0x0d7f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/3/1/c */
    { 0x0e00, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc000,24266) }, /* #89/3/2/u */
    { 0x0e7f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc000,24266) }, /* #89/3/2/c */
    { 0x0f00, 0x9d9c, 0xbda0, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/3/3/u */
    { 0x0f7f, 0x9d9c, 0x3d20, RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc410,24266), RTFLOAT64U_INIT_C(1,0x5135f0890578,843), RTFLOAT80U_INIT_C(0,0xcd38dc07f4cfc40f,24266) }, /* #89/3/3/c */
    { 0x0000, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/0/0/u */
    { 0x007f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/0/c */
    { 0x0100, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/0/1/u */
    { 0x017f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/1/c */
    { 0x0200, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/0/2/u */
    { 0x027f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/2/c */
    { 0x0300, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/0/3/u */
    { 0x037f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/0/3/c */
    { 0x0400, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/1/0/u */
    { 0x047f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/0/c */
    { 0x0500, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/1/1/u */
    { 0x057f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/1/c */
    { 0x0600, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/1/2/u */
    { 0x067f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/2/c */
    { 0x0700, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/1/3/u */
    { 0x077f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/1/3/c */
    { 0x0800, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/2/0/u */
    { 0x087f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/0/c */
    { 0x0900, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/2/1/u */
    { 0x097f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/1/c */
    { 0x0a00, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/2/2/u */
    { 0x0a7f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/2/c */
    { 0x0b00, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/2/3/u */
    { 0x0b7f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/2/3/c */
    { 0x0c00, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/3/0/u */
    { 0x0c7f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/0/c */
    { 0x0d00, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/3/1/u */
    { 0x0d7f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/1/c */
    { 0x0e00, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/3/2/u */
    { 0x0e7f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/2/c */
    { 0x0f00, 0xb021, 0xb881, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254) }, /* #90/3/3/u */
    { 0x0f7f, 0xb021, 0x3801, RTFLOAT80U_INIT_C(1,0x50cc714196a58a59,3254), RTFLOAT64U_INIT_C(0,0x3617594e73b06,630), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #90/3/3/c */
    { 0x0000, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/0/0/u */
    { 0x007f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/0/c */
    { 0x0100, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/0/1/u */
    { 0x017f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/1/c */
    { 0x0200, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/0/2/u */
    { 0x027f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/2/c */
    { 0x0300, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/0/3/u */
    { 0x037f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/3/c */
    { 0x0400, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/1/0/u */
    { 0x047f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/0/c */
    { 0x0500, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/1/1/u */
    { 0x057f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/1/c */
    { 0x0600, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/1/2/u */
    { 0x067f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/2/c */
    { 0x0700, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/1/3/u */
    { 0x077f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/3/c */
    { 0x0800, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/2/0/u */
    { 0x087f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/0/c */
    { 0x0900, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/2/1/u */
    { 0x097f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/1/c */
    { 0x0a00, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/2/2/u */
    { 0x0a7f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/2/c */
    { 0x0b00, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/2/3/u */
    { 0x0b7f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/3/c */
    { 0x0c00, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/3/0/u */
    { 0x0c7f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/0/c */
    { 0x0d00, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/3/1/u */
    { 0x0d7f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/1/c */
    { 0x0e00, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/3/2/u */
    { 0x0e7f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/2/c */
    { 0x0f00, 0x3f34, 0xbd81, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390) }, /* #91/3/3/u */
    { 0x0f7f, 0x3f34, 0x3d01, RTFLOAT80U_INIT_C(1,0x210e41c8838aa78a,27390), RTFLOAT64U_INIT_C(0,0x1800a10aca7fd,1753), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/3/c */
    { 0x0000, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b10000000000,16665) }, /* #92/0/0/u */
    { 0x007f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b10000000000,16665) }, /* #92/0/0/c */
    { 0x0100, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/0/1/u */
    { 0x017f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/0/1/c */
    { 0x0200, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/0/2/u */
    { 0x027f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/0/2/c */
    { 0x0300, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/0/3/u */
    { 0x037f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/0/3/c */
    { 0x0400, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b00000000000,16665) }, /* #92/1/0/u */
    { 0x047f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b00000000000,16665) }, /* #92/1/0/c */
    { 0x0500, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/1/1/u */
    { 0x057f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/1/1/c */
    { 0x0600, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefb800,16665) }, /* #92/1/2/u */
    { 0x067f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefb800,16665) }, /* #92/1/2/c */
    { 0x0700, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/1/3/u */
    { 0x077f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/1/3/c */
    { 0x0800, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b10000000000,16665) }, /* #92/2/0/u */
    { 0x087f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b10000000000,16665) }, /* #92/2/0/c */
    { 0x0900, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/2/1/u */
    { 0x097f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/2/1/c */
    { 0x0a00, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/2/2/u */
    { 0x0a7f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/2/2/c */
    { 0x0b00, 0x1b6d, 0xbba0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/2/3/u */
    { 0x0b7f, 0x1b6d, 0x3b20, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefc000,16665) }, /* #92/2/3/c */
    { 0x0c00, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b00000000000,16665) }, /* #92/3/0/u */
    { 0x0c7f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b00000000000,16665) }, /* #92/3/0/c */
    { 0x0d00, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/3/1/u */
    { 0x0d7f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/3/1/c */
    { 0x0e00, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefb800,16665) }, /* #92/3/2/u */
    { 0x0e7f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefb800,16665) }, /* #92/3/2/c */
    { 0x0f00, 0x1b6d, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/3/3/u */
    { 0x0f7f, 0x1b6d, 0x3920, RTFLOAT80U_INIT_C(1,0xb0c1ae4f95ef4517,10666), RTFLOAT64U_INIT_C(0,0x9d4361edf9df8,1305), RTFLOAT80U_INIT_C(0,0xcea1b0f6fcefbfff,16665) }, /* #92/3/3/c */
    { 0x0000, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083330000000000,17947) }, /* #93/0/0/u */
    { 0x007f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083330000000000,17947) }, /* #93/0/0/c */
    { 0x0100, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/0/1/u */
    { 0x017f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/0/1/c */
    { 0x0200, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75000,17947) }, /* #93/0/2/u */
    { 0x027f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75000,17947) }, /* #93/0/2/c */
    { 0x0300, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/0/3/u */
    { 0x037f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/0/3/c */
    { 0x0400, 0x385d, 0xbaa0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083340000000000,17947) }, /* #93/1/0/u */
    { 0x047f, 0x385d, 0x3a20, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083340000000000,17947) }, /* #93/1/0/c */
    { 0x0500, 0x385d, 0xbaa0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75343,17947) }, /* #93/1/1/u */
    { 0x057f, 0x385d, 0x3a20, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75343,17947) }, /* #93/1/1/c */
    { 0x0600, 0x385d, 0xbaa0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75800,17947) }, /* #93/1/2/u */
    { 0x067f, 0x385d, 0x3a20, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75800,17947) }, /* #93/1/2/c */
    { 0x0700, 0x385d, 0xbaa0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75343,17947) }, /* #93/1/3/u */
    { 0x077f, 0x385d, 0x3a20, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75343,17947) }, /* #93/1/3/c */
    { 0x0800, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083330000000000,17947) }, /* #93/2/0/u */
    { 0x087f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083330000000000,17947) }, /* #93/2/0/c */
    { 0x0900, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/2/1/u */
    { 0x097f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/2/1/c */
    { 0x0a00, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75000,17947) }, /* #93/2/2/u */
    { 0x0a7f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75000,17947) }, /* #93/2/2/c */
    { 0x0b00, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/2/3/u */
    { 0x0b7f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/2/3/c */
    { 0x0c00, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083330000000000,17947) }, /* #93/3/0/u */
    { 0x0c7f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083330000000000,17947) }, /* #93/3/0/c */
    { 0x0d00, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/3/1/u */
    { 0x0d7f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/3/1/c */
    { 0x0e00, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75000,17947) }, /* #93/3/2/u */
    { 0x0e7f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75000,17947) }, /* #93/3/2/c */
    { 0x0f00, 0x385d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/3/3/u */
    { 0x0f7f, 0x385d, 0x3820, RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947), RTFLOAT64U_INIT_C(1,0x837f4ece33ba8,629), RTFLOAT80U_INIT_C(1,0xb083335a4ac75342,17947) }, /* #93/3/3/c */
    { 0x0000, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b0000000000,32472) }, /* #94/0/0/u */
    { 0x007f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b0000000000,32472) }, /* #94/0/0/c */
    { 0x0100, 0x8f1f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/0/1/u */
    { 0x017f, 0x8f1f, 0x3f20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/0/1/c */
    { 0x0200, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921800,32472) }, /* #94/0/2/u */
    { 0x027f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921800,32472) }, /* #94/0/2/c */
    { 0x0300, 0x8f1f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/0/3/u */
    { 0x037f, 0x8f1f, 0x3f20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/0/3/c */
    { 0x0400, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b0000000000,32472) }, /* #94/1/0/u */
    { 0x047f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b0000000000,32472) }, /* #94/1/0/c */
    { 0x0500, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/1/1/u */
    { 0x057f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/1/1/c */
    { 0x0600, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921800,32472) }, /* #94/1/2/u */
    { 0x067f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921800,32472) }, /* #94/1/2/c */
    { 0x0700, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/1/3/u */
    { 0x077f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/1/3/c */
    { 0x0800, 0x8f1f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380c0000000000,32472) }, /* #94/2/0/u */
    { 0x087f, 0x8f1f, 0x3f20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380c0000000000,32472) }, /* #94/2/0/c */
    { 0x0900, 0x8f1f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/2/1/u */
    { 0x097f, 0x8f1f, 0x3f20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/2/1/c */
    { 0x0a00, 0x8f1f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c922000,32472) }, /* #94/2/2/u */
    { 0x0a7f, 0x8f1f, 0x3f20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c922000,32472) }, /* #94/2/2/c */
    { 0x0b00, 0x8f1f, 0xbfa0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/2/3/u */
    { 0x0b7f, 0x8f1f, 0x3f20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472) }, /* #94/2/3/c */
    { 0x0c00, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b0000000000,32472) }, /* #94/3/0/u */
    { 0x0c7f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b0000000000,32472) }, /* #94/3/0/c */
    { 0x0d00, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/3/1/u */
    { 0x0d7f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/3/1/c */
    { 0x0e00, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921800,32472) }, /* #94/3/2/u */
    { 0x0e7f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921800,32472) }, /* #94/3/2/c */
    { 0x0f00, 0x8f1f, 0xbda0, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/3/3/u */
    { 0x0f7f, 0x8f1f, 0x3d20, RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b2a,32472), RTFLOAT64U_INIT_C(1,0xf2ea9ff1129c1,1419), RTFLOAT80U_INIT_C(0,0xe4380b4d7c921b29,32472) }, /* #94/3/3/c */
    { 0x0000, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/0/0/u */
    { 0x007f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/0/c */
    { 0x0100, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/0/1/u */
    { 0x017f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/1/c */
    { 0x0200, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/0/2/u */
    { 0x027f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/2/c */
    { 0x0300, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/0/3/u */
    { 0x037f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/3/c */
    { 0x0400, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/1/0/u */
    { 0x047f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/0/c */
    { 0x0500, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/1/1/u */
    { 0x057f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/1/c */
    { 0x0600, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/1/2/u */
    { 0x067f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/2/c */
    { 0x0700, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/1/3/u */
    { 0x077f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/3/c */
    { 0x0800, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/2/0/u */
    { 0x087f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/0/c */
    { 0x0900, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/2/1/u */
    { 0x097f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/1/c */
    { 0x0a00, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/2/2/u */
    { 0x0a7f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/2/c */
    { 0x0b00, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/2/3/u */
    { 0x0b7f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/3/c */
    { 0x0c00, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/3/0/u */
    { 0x0c7f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/0/c */
    { 0x0d00, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/3/1/u */
    { 0x0d7f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/1/c */
    { 0x0e00, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/3/2/u */
    { 0x0e7f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/2/c */
    { 0x0f00, 0x64f5, 0xfc81, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796) }, /* #95/3/3/u */
    { 0x0f7f, 0x64f5, 0x7c01, RTFLOAT80U_INIT_C(1,0x1d01f0a967e9e022,19796), RTFLOAT64U_INIT_C(1,0xf595ec9e89374,1356), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/3/c */
    { 0x0000, 0x39b8, 0xbba0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb30000000000,16384) }, /* #96/0/0/u */
    { 0x007f, 0x39b8, 0x3b20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb30000000000,16384) }, /* #96/0/0/c */
    { 0x0100, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/0/1/u */
    { 0x017f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/0/1/c */
    { 0x0200, 0x39b8, 0xbba0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221800,16384) }, /* #96/0/2/u */
    { 0x027f, 0x39b8, 0x3b20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221800,16384) }, /* #96/0/2/c */
    { 0x0300, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/0/3/u */
    { 0x037f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/0/3/c */
    { 0x0400, 0x39b8, 0xb9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb20000000000,16384) }, /* #96/1/0/u */
    { 0x047f, 0x39b8, 0x3920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb20000000000,16384) }, /* #96/1/0/c */
    { 0x0500, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/1/1/u */
    { 0x057f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/1/1/c */
    { 0x0600, 0x39b8, 0xb9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221000,16384) }, /* #96/1/2/u */
    { 0x067f, 0x39b8, 0x3920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221000,16384) }, /* #96/1/2/c */
    { 0x0700, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/1/3/u */
    { 0x077f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/1/3/c */
    { 0x0800, 0x39b8, 0xbba0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb30000000000,16384) }, /* #96/2/0/u */
    { 0x087f, 0x39b8, 0x3b20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb30000000000,16384) }, /* #96/2/0/c */
    { 0x0900, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/2/1/u */
    { 0x097f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/2/1/c */
    { 0x0a00, 0x39b8, 0xbba0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221800,16384) }, /* #96/2/2/u */
    { 0x0a7f, 0x39b8, 0x3b20, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221800,16384) }, /* #96/2/2/c */
    { 0x0b00, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/2/3/u */
    { 0x0b7f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/2/3/c */
    { 0x0c00, 0x39b8, 0xb9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb20000000000,16384) }, /* #96/3/0/u */
    { 0x0c7f, 0x39b8, 0x3920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb20000000000,16384) }, /* #96/3/0/c */
    { 0x0d00, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/3/1/u */
    { 0x0d7f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/3/1/c */
    { 0x0e00, 0x39b8, 0xb9a0, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221000,16384) }, /* #96/3/2/u */
    { 0x0e7f, 0x39b8, 0x3920, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221000,16384) }, /* #96/3/2/c */
    { 0x0f00, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/3/3/u */
    { 0x0f7f, 0x39b8, 0x3900, RTFLOAT80U_INIT_C(0,0xffffeeeeddddcccc,16383), RTFLOAT64U_INIT_C(0,0xfeeeeddddcccc,1023), RTFLOAT80U_INIT_C(0,0xffbbb2eee6221666,16384) }, /* #96/3/3/c */
};
uint32_t const g_cTests_fadd_r80_by_r64 = RT_ELEMENTS(g_aTests_fadd_r80_by_r64);

FPU_BINARY_R64_TEST_T const g_aTests_fmul_r80_by_r64[] =
{
    { 0x0000, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/0/u */
    { 0x007f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/0/c */
    { 0x0100, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/1/u */
    { 0x017f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/1/c */
    { 0x0200, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/2/u */
    { 0x027f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/2/c */
    { 0x0300, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/3/u */
    { 0x037f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/0/3/c */
    { 0x0400, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/0/u */
    { 0x047f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/0/c */
    { 0x0500, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/1/u */
    { 0x057f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/1/c */
    { 0x0600, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/2/u */
    { 0x067f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/2/c */
    { 0x0700, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/3/u */
    { 0x077f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/1/3/c */
    { 0x0800, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/0/u */
    { 0x087f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/0/c */
    { 0x0900, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/1/u */
    { 0x097f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/1/c */
    { 0x0a00, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/2/u */
    { 0x0a7f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/2/c */
    { 0x0b00, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/3/u */
    { 0x0b7f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/2/3/c */
    { 0x0c00, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/0/u */
    { 0x0c7f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/0/c */
    { 0x0d00, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/1/u */
    { 0x0d7f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/1/c */
    { 0x0e00, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/2/u */
    { 0x0e7f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/2/c */
    { 0x0f00, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/3/u */
    { 0x0f7f, 0xc6ff, 0x7c00, RTFLOAT80U_INIT_C(1,0xc000000000007498,32767), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000007498,32767) }, /* #0/3/3/c */
    { 0x0000, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef70000000000,7326) }, /* #1/0/0/u */
    { 0x007f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef70000000000,7326) }, /* #1/0/0/c */
    { 0x0100, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/0/1/u */
    { 0x017f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/0/1/c */
    { 0x0200, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2932800,7326) }, /* #1/0/2/u */
    { 0x027f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2932800,7326) }, /* #1/0/2/c */
    { 0x0300, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/0/3/u */
    { 0x037f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/0/3/c */
    { 0x0400, 0x9bb3, 0xbba0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef80000000000,7326) }, /* #1/1/0/u */
    { 0x047f, 0x9bb3, 0x3b20, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef80000000000,7326) }, /* #1/1/0/c */
    { 0x0500, 0x9bb3, 0xbba0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e9,7326) }, /* #1/1/1/u */
    { 0x057f, 0x9bb3, 0x3b20, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e9,7326) }, /* #1/1/1/c */
    { 0x0600, 0x9bb3, 0xbba0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2933000,7326) }, /* #1/1/2/u */
    { 0x067f, 0x9bb3, 0x3b20, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2933000,7326) }, /* #1/1/2/c */
    { 0x0700, 0x9bb3, 0xbba0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e9,7326) }, /* #1/1/3/u */
    { 0x077f, 0x9bb3, 0x3b20, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e9,7326) }, /* #1/1/3/c */
    { 0x0800, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef70000000000,7326) }, /* #1/2/0/u */
    { 0x087f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef70000000000,7326) }, /* #1/2/0/c */
    { 0x0900, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/2/1/u */
    { 0x097f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/2/1/c */
    { 0x0a00, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2932800,7326) }, /* #1/2/2/u */
    { 0x0a7f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2932800,7326) }, /* #1/2/2/c */
    { 0x0b00, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/2/3/u */
    { 0x0b7f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/2/3/c */
    { 0x0c00, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef70000000000,7326) }, /* #1/3/0/u */
    { 0x0c7f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef70000000000,7326) }, /* #1/3/0/c */
    { 0x0d00, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/3/1/u */
    { 0x0d7f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/3/1/c */
    { 0x0e00, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2932800,7326) }, /* #1/3/2/u */
    { 0x0e7f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc2932800,7326) }, /* #1/3/2/c */
    { 0x0f00, 0x9bb3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/3/3/u */
    { 0x0f7f, 0x9bb3, 0x3920, RTFLOAT80U_INIT_C(1,0xcff660b92245a2c3,7584), RTFLOAT64U_INIT_C(0,0xf9c6158a3bd56,764), RTFLOAT80U_INIT_C(1,0xcd6ef76dc29328e8,7326) }, /* #1/3/3/c */
    { 0x0000, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/0/u */
    { 0x007f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/0/c */
    { 0x0100, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/1/u */
    { 0x017f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/1/c */
    { 0x0200, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/2/u */
    { 0x027f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/2/c */
    { 0x0300, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/0/3/u */
    { 0x037f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/3/c */
    { 0x0400, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/0/u */
    { 0x047f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/0/c */
    { 0x0500, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/1/u */
    { 0x057f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/1/c */
    { 0x0600, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/2/u */
    { 0x067f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/2/c */
    { 0x0700, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/1/3/u */
    { 0x077f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/3/c */
    { 0x0800, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/0/u */
    { 0x087f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/0/c */
    { 0x0900, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/1/u */
    { 0x097f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/1/c */
    { 0x0a00, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/2/u */
    { 0x0a7f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/2/c */
    { 0x0b00, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/2/3/u */
    { 0x0b7f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/3/c */
    { 0x0c00, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/0/u */
    { 0x0c7f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/0/c */
    { 0x0d00, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/1/u */
    { 0x0d7f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/1/c */
    { 0x0e00, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/2/u */
    { 0x0e7f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/2/c */
    { 0x0f00, 0x14ae, 0xbc81, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #2/3/3/u */
    { 0x0f7f, 0x14ae, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(1,0x58e6839851393,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/3/c */
    { 0x0000, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/0/u */
    { 0x007f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/0/c */
    { 0x0100, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/1/u */
    { 0x017f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/1/c */
    { 0x0200, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/2/u */
    { 0x027f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/2/c */
    { 0x0300, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/3/u */
    { 0x037f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/0/3/c */
    { 0x0400, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/0/u */
    { 0x047f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/0/c */
    { 0x0500, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/1/u */
    { 0x057f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/1/c */
    { 0x0600, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/2/u */
    { 0x067f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/2/c */
    { 0x0700, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/3/u */
    { 0x077f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/1/3/c */
    { 0x0800, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/0/u */
    { 0x087f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/0/c */
    { 0x0900, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/1/u */
    { 0x097f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/1/c */
    { 0x0a00, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/2/u */
    { 0x0a7f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/2/c */
    { 0x0b00, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/3/u */
    { 0x0b7f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/2/3/c */
    { 0x0c00, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/0/u */
    { 0x0c7f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/0/c */
    { 0x0d00, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/1/u */
    { 0x0d7f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/1/c */
    { 0x0e00, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/2/u */
    { 0x0e7f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/2/c */
    { 0x0f00, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/3/u */
    { 0x0f7f, 0x0d5b, 0x3d00, RTFLOAT80U_INIT_C(0,0x94d72cae4e4ad642,11954), RTFLOAT64U_INIT_C(0,0xcccb91a226a0b,2047), RTFLOAT80U_INIT_C(0,0xe665c8d113505800,32767) }, /* #3/3/3/c */
    { 0x0000, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53210000000000,30189) }, /* #4/0/0/u */
    { 0x007f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53210000000000,30189) }, /* #4/0/0/c */
    { 0x0100, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/0/1/u */
    { 0x017f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/0/1/c */
    { 0x0200, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e67000,30189) }, /* #4/0/2/u */
    { 0x027f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e67000,30189) }, /* #4/0/2/c */
    { 0x0300, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/0/3/u */
    { 0x037f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/0/3/c */
    { 0x0400, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53200000000000,30189) }, /* #4/1/0/u */
    { 0x047f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53200000000000,30189) }, /* #4/1/0/c */
    { 0x0500, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/1/1/u */
    { 0x057f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/1/1/c */
    { 0x0600, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66800,30189) }, /* #4/1/2/u */
    { 0x067f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66800,30189) }, /* #4/1/2/c */
    { 0x0700, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/1/3/u */
    { 0x077f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/1/3/c */
    { 0x0800, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53210000000000,30189) }, /* #4/2/0/u */
    { 0x087f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53210000000000,30189) }, /* #4/2/0/c */
    { 0x0900, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/2/1/u */
    { 0x097f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/2/1/c */
    { 0x0a00, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e67000,30189) }, /* #4/2/2/u */
    { 0x0a7f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e67000,30189) }, /* #4/2/2/c */
    { 0x0b00, 0xefe1, 0xffa0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/2/3/u */
    { 0x0b7f, 0xefe1, 0x7f20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddc,30189) }, /* #4/2/3/c */
    { 0x0c00, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53200000000000,30189) }, /* #4/3/0/u */
    { 0x0c7f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a53200000000000,30189) }, /* #4/3/0/c */
    { 0x0d00, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/3/1/u */
    { 0x0d7f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/3/1/c */
    { 0x0e00, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66800,30189) }, /* #4/3/2/u */
    { 0x0e7f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66800,30189) }, /* #4/3/2/c */
    { 0x0f00, 0xefe1, 0xfda0, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/3/3/u */
    { 0x0f7f, 0xefe1, 0x7d20, RTFLOAT80U_INIT_C(0,0xea94a99c7cb77679,29436), RTFLOAT64U_INIT_C(0,0x50d4f4bc59247,1775), RTFLOAT80U_INIT_C(0,0x9a5320fe10e66ddb,30189) }, /* #4/3/3/c */
    { 0x0000, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/0/0/u */
    { 0x007f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/0/0/c */
    { 0x0100, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/0/1/u */
    { 0x017f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/0/1/c */
    { 0x0200, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/0/2/u */
    { 0x027f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/0/2/c */
    { 0x0300, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/0/3/u */
    { 0x037f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/0/3/c */
    { 0x0400, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/1/0/u */
    { 0x047f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/1/0/c */
    { 0x0500, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/1/1/u */
    { 0x057f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/1/1/c */
    { 0x0600, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/1/2/u */
    { 0x067f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/1/2/c */
    { 0x0700, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/1/3/u */
    { 0x077f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/1/3/c */
    { 0x0800, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/2/0/u */
    { 0x087f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/2/0/c */
    { 0x0900, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/2/1/u */
    { 0x097f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/2/1/c */
    { 0x0a00, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/2/2/u */
    { 0x0a7f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/2/2/c */
    { 0x0b00, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/2/3/u */
    { 0x0b7f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/2/3/c */
    { 0x0c00, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/3/0/u */
    { 0x0c7f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/3/0/c */
    { 0x0d00, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/3/1/u */
    { 0x0d7f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/3/1/c */
    { 0x0e00, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/3/2/u */
    { 0x0e7f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/3/2/c */
    { 0x0f00, 0x171a, 0xbd81, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(1,0x8000000000000065,0) }, /* #5/3/3/u */
    { 0x0f7f, 0x171a, 0x3d01, RTFLOAT80U_INIT_C(1,0x8000000000000065,0), RTFLOAT64U_INIT_C(0,0x2b9d,2047), RTFLOAT80U_INIT_C(0,0xc0000000015ce800,32767) }, /* #5/3/3/c */
    { 0x0000, 0x9333, 0xbba8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41e0000000000,8806) }, /* #6/0/0/u */
    { 0x007f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/0/0/c */
    { 0x0100, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d151,8806) }, /* #6/0/1/u */
    { 0x017f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/0/1/c */
    { 0x0200, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d000,8806) }, /* #6/0/2/u */
    { 0x027f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/0/2/c */
    { 0x0300, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d151,8806) }, /* #6/0/3/u */
    { 0x037f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/0/3/c */
    { 0x0400, 0x9333, 0xbba8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41e0000000000,8806) }, /* #6/1/0/u */
    { 0x047f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/1/0/c */
    { 0x0500, 0x9333, 0xbba8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d152,8806) }, /* #6/1/1/u */
    { 0x057f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/1/1/c */
    { 0x0600, 0x9333, 0xbba8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d800,8806) }, /* #6/1/2/u */
    { 0x067f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/1/2/c */
    { 0x0700, 0x9333, 0xbba8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d152,8806) }, /* #6/1/3/u */
    { 0x077f, 0x9333, 0x3b28, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #6/1/3/c */
    { 0x0800, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41d0000000000,8806) }, /* #6/2/0/u */
    { 0x087f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32766) }, /* #6/2/0/c */
    { 0x0900, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d151,8806) }, /* #6/2/1/u */
    { 0x097f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #6/2/1/c */
    { 0x0a00, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d000,8806) }, /* #6/2/2/u */
    { 0x0a7f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32766) }, /* #6/2/2/c */
    { 0x0b00, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d151,8806) }, /* #6/2/3/u */
    { 0x0b7f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #6/2/3/c */
    { 0x0c00, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41d0000000000,8806) }, /* #6/3/0/u */
    { 0x0c7f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xffffff0000000000,32766) }, /* #6/3/0/c */
    { 0x0d00, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d151,8806) }, /* #6/3/1/u */
    { 0x0d7f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #6/3/1/c */
    { 0x0e00, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d000,8806) }, /* #6/3/2/u */
    { 0x0e7f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xfffffffffffff800,32766) }, /* #6/3/2/c */
    { 0x0f00, 0x9333, 0xb9a8, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xf6b41da69802d151,8806) }, /* #6/3/3/u */
    { 0x0f7f, 0x9333, 0x3928, RTFLOAT80U_INIT_C(0,0x930b436795b85e51,32610), RTFLOAT64U_INIT_C(1,0xad8140734c9c8,1795), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #6/3/3/c */
    { 0x0000, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc0000000000,7035) }, /* #7/0/0/u */
    { 0x007f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc0000000000,7035) }, /* #7/0/0/c */
    { 0x0100, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/0/1/u */
    { 0x017f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/0/1/c */
    { 0x0200, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8384000,7035) }, /* #7/0/2/u */
    { 0x027f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8384000,7035) }, /* #7/0/2/c */
    { 0x0300, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/0/3/u */
    { 0x037f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/0/3/c */
    { 0x0400, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc0000000000,7035) }, /* #7/1/0/u */
    { 0x047f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc0000000000,7035) }, /* #7/1/0/c */
    { 0x0500, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/1/1/u */
    { 0x057f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/1/1/c */
    { 0x0600, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383800,7035) }, /* #7/1/2/u */
    { 0x067f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383800,7035) }, /* #7/1/2/c */
    { 0x0700, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/1/3/u */
    { 0x077f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/1/3/c */
    { 0x0800, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edd0000000000,7035) }, /* #7/2/0/u */
    { 0x087f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edd0000000000,7035) }, /* #7/2/0/c */
    { 0x0900, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/2/1/u */
    { 0x097f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/2/1/c */
    { 0x0a00, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8384000,7035) }, /* #7/2/2/u */
    { 0x0a7f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8384000,7035) }, /* #7/2/2/c */
    { 0x0b00, 0x6d51, 0xffa0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/2/3/u */
    { 0x0b7f, 0x6d51, 0x7f20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd1,7035) }, /* #7/2/3/c */
    { 0x0c00, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc0000000000,7035) }, /* #7/3/0/u */
    { 0x0c7f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc0000000000,7035) }, /* #7/3/0/c */
    { 0x0d00, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/3/1/u */
    { 0x0d7f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/3/1/c */
    { 0x0e00, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383800,7035) }, /* #7/3/2/u */
    { 0x0e7f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383800,7035) }, /* #7/3/2/c */
    { 0x0f00, 0x6d51, 0xfda0, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/3/3/u */
    { 0x0f7f, 0x6d51, 0x7d20, RTFLOAT80U_INIT_C(1,0xd3061abfddc147f5,7081), RTFLOAT64U_INIT_C(1,0x2fe26a0f4c59a,977), RTFLOAT80U_INIT_C(0,0xfa7edc79d8383cd0,7035) }, /* #7/3/3/c */
    { 0x0000, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e10000000000,28765) }, /* #8/0/0/u */
    { 0x007f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e10000000000,28765) }, /* #8/0/0/c */
    { 0x0100, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/0/1/u */
    { 0x017f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/0/1/c */
    { 0x0200, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ad800,28765) }, /* #8/0/2/u */
    { 0x027f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ad800,28765) }, /* #8/0/2/c */
    { 0x0300, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/0/3/u */
    { 0x037f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/0/3/c */
    { 0x0400, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e10000000000,28765) }, /* #8/1/0/u */
    { 0x047f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e10000000000,28765) }, /* #8/1/0/c */
    { 0x0500, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/1/1/u */
    { 0x057f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/1/1/c */
    { 0x0600, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ae000,28765) }, /* #8/1/2/u */
    { 0x067f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ae000,28765) }, /* #8/1/2/c */
    { 0x0700, 0x88d0, 0xbaa0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/1/3/u */
    { 0x077f, 0x88d0, 0x3a20, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbaf,28765) }, /* #8/1/3/c */
    { 0x0800, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e00000000000,28765) }, /* #8/2/0/u */
    { 0x087f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e00000000000,28765) }, /* #8/2/0/c */
    { 0x0900, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/2/1/u */
    { 0x097f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/2/1/c */
    { 0x0a00, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ad800,28765) }, /* #8/2/2/u */
    { 0x0a7f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ad800,28765) }, /* #8/2/2/c */
    { 0x0b00, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/2/3/u */
    { 0x0b7f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/2/3/c */
    { 0x0c00, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e00000000000,28765) }, /* #8/3/0/u */
    { 0x0c7f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e00000000000,28765) }, /* #8/3/0/c */
    { 0x0d00, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/3/1/u */
    { 0x0d7f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/3/1/c */
    { 0x0e00, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ad800,28765) }, /* #8/3/2/u */
    { 0x0e7f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09ad800,28765) }, /* #8/3/2/c */
    { 0x0f00, 0x88d0, 0xb8a0, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/3/3/u */
    { 0x0f7f, 0x88d0, 0x3820, RTFLOAT80U_INIT_C(0,0x929fecedcb8f0140,28277), RTFLOAT64U_INIT_C(1,0x46f4d2ca2dba2,1511), RTFLOAT80U_INIT_C(1,0xbb43e0dfa09adbae,28765) }, /* #8/3/3/c */
    { 0x0000, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/0/u */
    { 0x007f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/0/c */
    { 0x0100, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/1/u */
    { 0x017f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/1/c */
    { 0x0200, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/2/u */
    { 0x027f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/2/c */
    { 0x0300, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/3/u */
    { 0x037f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/0/3/c */
    { 0x0400, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/0/u */
    { 0x047f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/0/c */
    { 0x0500, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/1/u */
    { 0x057f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/1/c */
    { 0x0600, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/2/u */
    { 0x067f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/2/c */
    { 0x0700, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/3/u */
    { 0x077f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/1/3/c */
    { 0x0800, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/0/u */
    { 0x087f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/0/c */
    { 0x0900, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/1/u */
    { 0x097f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/1/c */
    { 0x0a00, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/2/u */
    { 0x0a7f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/2/c */
    { 0x0b00, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/3/u */
    { 0x0b7f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/2/3/c */
    { 0x0c00, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/0/u */
    { 0x0c7f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/0/c */
    { 0x0d00, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/1/u */
    { 0x0d7f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/1/c */
    { 0x0e00, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/2/u */
    { 0x0e7f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/2/c */
    { 0x0f00, 0x00ee, 0xb881, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/3/u */
    { 0x0f7f, 0x00ee, 0x3801, RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767), RTFLOAT64U_INIT_C(1,0x773da1263664b,2047), RTFLOAT80U_INIT_C(1,0xf518f0359cfab261,32767) }, /* #9/3/3/c */
    { 0x0000, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/0/0/u */
    { 0x007f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba0000000000,948) }, /* #10/0/0/c */
    { 0x0100, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/0/1/u */
    { 0x017f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fb,948) }, /* #10/0/1/c */
    { 0x0200, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/0/2/u */
    { 0x027f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e7000,948) }, /* #10/0/2/c */
    { 0x0300, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/0/3/u */
    { 0x037f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fb,948) }, /* #10/0/3/c */
    { 0x0400, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/1/0/u */
    { 0x047f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba0000000000,948) }, /* #10/1/0/c */
    { 0x0500, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/1/1/u */
    { 0x057f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fb,948) }, /* #10/1/1/c */
    { 0x0600, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/1/2/u */
    { 0x067f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e7000,948) }, /* #10/1/2/c */
    { 0x0700, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/1/3/u */
    { 0x077f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fb,948) }, /* #10/1/3/c */
    { 0x0800, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/2/0/u */
    { 0x087f, 0x867d, 0x3e22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aabb0000000000,948) }, /* #10/2/0/c */
    { 0x0900, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/2/1/u */
    { 0x097f, 0x867d, 0x3e22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fc,948) }, /* #10/2/1/c */
    { 0x0a00, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/2/2/u */
    { 0x0a7f, 0x867d, 0x3e22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e7800,948) }, /* #10/2/2/c */
    { 0x0b00, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/2/3/u */
    { 0x0b7f, 0x867d, 0x3e22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fc,948) }, /* #10/2/3/c */
    { 0x0c00, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/3/0/u */
    { 0x0c7f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba0000000000,948) }, /* #10/3/0/c */
    { 0x0d00, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/3/1/u */
    { 0x0d7f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fb,948) }, /* #10/3/1/c */
    { 0x0e00, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/3/2/u */
    { 0x0e7f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e7000,948) }, /* #10/3/2/c */
    { 0x0f00, 0x867d, 0xbc82, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0) }, /* #10/3/3/u */
    { 0x0f7f, 0x867d, 0x3c22, RTFLOAT80U_INIT_C(1,0x2b263a08e9221f63,0), RTFLOAT64U_INIT_C(1,0xe28ac5ce2bd78,1971), RTFLOAT80U_INIT_C(0,0xa2aaba6e751e70fb,948) }, /* #10/3/3/c */
    { 0x0000, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/0/0/u */
    { 0x007f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/0/0/c */
    { 0x0100, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/0/1/u */
    { 0x017f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/0/1/c */
    { 0x0200, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/0/2/u */
    { 0x027f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/0/2/c */
    { 0x0300, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/0/3/u */
    { 0x037f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/0/3/c */
    { 0x0400, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/1/0/u */
    { 0x047f, 0x6119, 0x7b32, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x10000000000,0) }, /* #11/1/0/c */
    { 0x0500, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/1/1/u */
    { 0x057f, 0x6119, 0x7b32, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #11/1/1/c */
    { 0x0600, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/1/2/u */
    { 0x067f, 0x6119, 0x7b32, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x800,0) }, /* #11/1/2/c */
    { 0x0700, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/1/3/u */
    { 0x077f, 0x6119, 0x7b32, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #11/1/3/c */
    { 0x0800, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/2/0/u */
    { 0x087f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/2/0/c */
    { 0x0900, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/2/1/u */
    { 0x097f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/2/1/c */
    { 0x0a00, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/2/2/u */
    { 0x0a7f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/2/2/c */
    { 0x0b00, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/2/3/u */
    { 0x0b7f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/2/3/c */
    { 0x0c00, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/3/0/u */
    { 0x0c7f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/3/0/c */
    { 0x0d00, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/3/1/u */
    { 0x0d7f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/3/1/c */
    { 0x0e00, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/3/2/u */
    { 0x0e7f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/3/2/c */
    { 0x0f00, 0x6119, 0xf982, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0) }, /* #11/3/3/u */
    { 0x0f7f, 0x6119, 0x7932, RTFLOAT80U_INIT_C(0,0x29269da77a70b7ae,0), RTFLOAT64U_INIT_C(1,0xbecbbe55bf232,180), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #11/3/3/c */
    { 0x0000, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/0/0/u */
    { 0x007f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/0/c */
    { 0x0100, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/0/1/u */
    { 0x017f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/1/c */
    { 0x0200, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/0/2/u */
    { 0x027f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/2/c */
    { 0x0300, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/0/3/u */
    { 0x037f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/3/c */
    { 0x0400, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/1/0/u */
    { 0x047f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/0/c */
    { 0x0500, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/1/1/u */
    { 0x057f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/1/c */
    { 0x0600, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/1/2/u */
    { 0x067f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/2/c */
    { 0x0700, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/1/3/u */
    { 0x077f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/3/c */
    { 0x0800, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/2/0/u */
    { 0x087f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/0/c */
    { 0x0900, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/2/1/u */
    { 0x097f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/1/c */
    { 0x0a00, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/2/2/u */
    { 0x0a7f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/2/c */
    { 0x0b00, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/2/3/u */
    { 0x0b7f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/3/c */
    { 0x0c00, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/3/0/u */
    { 0x0c7f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/0/c */
    { 0x0d00, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/3/1/u */
    { 0x0d7f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/1/c */
    { 0x0e00, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/3/2/u */
    { 0x0e7f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/2/c */
    { 0x0f00, 0x5bae, 0xf981, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767) }, /* #12/3/3/u */
    { 0x0f7f, 0x5bae, 0x7901, RTFLOAT80U_INIT_C(1,0x40be4878e282a675,32767), RTFLOAT64U_INIT_C(1,0xd246bcd4b1074,408), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/3/c */
    { 0x0000, 0x6eb9, 0xfea0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e60000000000,7569) }, /* #13/0/0/u */
    { 0x007f, 0x6eb9, 0x7e20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e60000000000,7569) }, /* #13/0/0/c */
    { 0x0100, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/0/1/u */
    { 0x017f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/0/1/c */
    { 0x0200, 0x6eb9, 0xfea0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8f0000,7569) }, /* #13/0/2/u */
    { 0x027f, 0x6eb9, 0x7e20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8f0000,7569) }, /* #13/0/2/c */
    { 0x0300, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/0/3/u */
    { 0x037f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/0/3/c */
    { 0x0400, 0x6eb9, 0xfea0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e60000000000,7569) }, /* #13/1/0/u */
    { 0x047f, 0x6eb9, 0x7e20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e60000000000,7569) }, /* #13/1/0/c */
    { 0x0500, 0x6eb9, 0xfea0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe0a,7569) }, /* #13/1/1/u */
    { 0x057f, 0x6eb9, 0x7e20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe0a,7569) }, /* #13/1/1/c */
    { 0x0600, 0x6eb9, 0xfea0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8f0000,7569) }, /* #13/1/2/u */
    { 0x067f, 0x6eb9, 0x7e20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8f0000,7569) }, /* #13/1/2/c */
    { 0x0700, 0x6eb9, 0xfea0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe0a,7569) }, /* #13/1/3/u */
    { 0x077f, 0x6eb9, 0x7e20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe0a,7569) }, /* #13/1/3/c */
    { 0x0800, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e50000000000,7569) }, /* #13/2/0/u */
    { 0x087f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e50000000000,7569) }, /* #13/2/0/c */
    { 0x0900, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/2/1/u */
    { 0x097f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/2/1/c */
    { 0x0a00, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8ef800,7569) }, /* #13/2/2/u */
    { 0x0a7f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8ef800,7569) }, /* #13/2/2/c */
    { 0x0b00, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/2/3/u */
    { 0x0b7f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/2/3/c */
    { 0x0c00, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e50000000000,7569) }, /* #13/3/0/u */
    { 0x0c7f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e50000000000,7569) }, /* #13/3/0/c */
    { 0x0d00, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/3/1/u */
    { 0x0d7f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/3/1/c */
    { 0x0e00, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8ef800,7569) }, /* #13/3/2/u */
    { 0x0e7f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8ef800,7569) }, /* #13/3/2/c */
    { 0x0f00, 0x6eb9, 0xfca0, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/3/3/u */
    { 0x0f7f, 0x6eb9, 0x7c20, RTFLOAT80U_INIT_C(0,0xa1c4e55c5371a8d9,6948), RTFLOAT64U_INIT_C(1,0x82fa0eea247e3,1644), RTFLOAT80U_INIT_C(1,0xf488e589eb8efe09,7569) }, /* #13/3/3/c */
    { 0x0000, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/0/0/u */
    { 0x007f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/0/0/c */
    { 0x0100, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/0/1/u */
    { 0x017f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/0/1/c */
    { 0x0200, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/0/2/u */
    { 0x027f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/0/2/c */
    { 0x0300, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/0/3/u */
    { 0x037f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/0/3/c */
    { 0x0400, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/1/0/u */
    { 0x047f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/1/0/c */
    { 0x0500, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/1/1/u */
    { 0x057f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/1/1/c */
    { 0x0600, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/1/2/u */
    { 0x067f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/1/2/c */
    { 0x0700, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/1/3/u */
    { 0x077f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/1/3/c */
    { 0x0800, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/2/0/u */
    { 0x087f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/2/0/c */
    { 0x0900, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/2/1/u */
    { 0x097f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/2/1/c */
    { 0x0a00, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/2/2/u */
    { 0x0a7f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/2/2/c */
    { 0x0b00, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/2/3/u */
    { 0x0b7f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/2/3/c */
    { 0x0c00, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/3/0/u */
    { 0x0c7f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/3/0/c */
    { 0x0d00, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/3/1/u */
    { 0x0d7f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/3/1/c */
    { 0x0e00, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/3/2/u */
    { 0x0e7f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/3/2/c */
    { 0x0f00, 0x9e4e, 0xbc81, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332) }, /* #14/3/3/u */
    { 0x0f7f, 0x9e4e, 0x3c01, RTFLOAT80U_INIT_C(1,0xbfd65077e5a4cfa2,20332), RTFLOAT64U_INIT_C(0,0x27af51974b9c,2047), RTFLOAT80U_INIT_C(0,0xc13d7a8cba5ce000,32767) }, /* #14/3/3/c */
    { 0x0000, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/0/0/u */
    { 0x007f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a50000000000,566) }, /* #15/0/0/c */
    { 0x0100, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/0/1/u */
    { 0x017f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a5,566) }, /* #15/0/1/c */
    { 0x0200, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/0/2/u */
    { 0x027f, 0x4b7d, 0x7b22, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f9800,566) }, /* #15/0/2/c */
    { 0x0300, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/0/3/u */
    { 0x037f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a5,566) }, /* #15/0/3/c */
    { 0x0400, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/1/0/u */
    { 0x047f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a50000000000,566) }, /* #15/1/0/c */
    { 0x0500, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/1/1/u */
    { 0x057f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a5,566) }, /* #15/1/1/c */
    { 0x0600, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/1/2/u */
    { 0x067f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f9000,566) }, /* #15/1/2/c */
    { 0x0700, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/1/3/u */
    { 0x077f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a5,566) }, /* #15/1/3/c */
    { 0x0800, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/2/0/u */
    { 0x087f, 0x4b7d, 0x7b22, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a60000000000,566) }, /* #15/2/0/c */
    { 0x0900, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/2/1/u */
    { 0x097f, 0x4b7d, 0x7b22, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a6,566) }, /* #15/2/1/c */
    { 0x0a00, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/2/2/u */
    { 0x0a7f, 0x4b7d, 0x7b22, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f9800,566) }, /* #15/2/2/c */
    { 0x0b00, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/2/3/u */
    { 0x0b7f, 0x4b7d, 0x7b22, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a6,566) }, /* #15/2/3/c */
    { 0x0c00, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/3/0/u */
    { 0x0c7f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a50000000000,566) }, /* #15/3/0/c */
    { 0x0d00, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/3/1/u */
    { 0x0d7f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a5,566) }, /* #15/3/1/c */
    { 0x0e00, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/3/2/u */
    { 0x0e7f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f9000,566) }, /* #15/3/2/c */
    { 0x0f00, 0x4b7d, 0xf982, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0) }, /* #15/3/3/u */
    { 0x0f7f, 0x4b7d, 0x7922, RTFLOAT80U_INIT_C(1,0xc2c85b783db88267,0), RTFLOAT64U_INIT_C(1,0x4e1d3b1e0395f,1588), RTFLOAT80U_INIT_C(0,0xfe37a504406f94a5,566) }, /* #15/3/3/c */
    { 0x0000, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaaf0000000000,7427) }, /* #16/0/0/u */
    { 0x007f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaaf0000000000,7427) }, /* #16/0/0/c */
    { 0x0100, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/0/1/u */
    { 0x017f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/0/1/c */
    { 0x0200, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121800,7427) }, /* #16/0/2/u */
    { 0x027f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121800,7427) }, /* #16/0/2/c */
    { 0x0300, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/0/3/u */
    { 0x037f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/0/3/c */
    { 0x0400, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae0000000000,7427) }, /* #16/1/0/u */
    { 0x047f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae0000000000,7427) }, /* #16/1/0/c */
    { 0x0500, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/1/1/u */
    { 0x057f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/1/1/c */
    { 0x0600, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121800,7427) }, /* #16/1/2/u */
    { 0x067f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121800,7427) }, /* #16/1/2/c */
    { 0x0700, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/1/3/u */
    { 0x077f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/1/3/c */
    { 0x0800, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaaf0000000000,7427) }, /* #16/2/0/u */
    { 0x087f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaaf0000000000,7427) }, /* #16/2/0/c */
    { 0x0900, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/2/1/u */
    { 0x097f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/2/1/c */
    { 0x0a00, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38122000,7427) }, /* #16/2/2/u */
    { 0x0a7f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38122000,7427) }, /* #16/2/2/c */
    { 0x0b00, 0xe1c7, 0xfba0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/2/3/u */
    { 0x0b7f, 0xe1c7, 0x7b20, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9f,7427) }, /* #16/2/3/c */
    { 0x0c00, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae0000000000,7427) }, /* #16/3/0/u */
    { 0x0c7f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae0000000000,7427) }, /* #16/3/0/c */
    { 0x0d00, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/3/1/u */
    { 0x0d7f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/3/1/c */
    { 0x0e00, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121800,7427) }, /* #16/3/2/u */
    { 0x0e7f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121800,7427) }, /* #16/3/2/c */
    { 0x0f00, 0xe1c7, 0xf9a0, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/3/3/u */
    { 0x0f7f, 0xe1c7, 0x7920, RTFLOAT80U_INIT_C(1,0x82f35cc9ec5aff2c,7986), RTFLOAT64U_INIT_C(1,0xb36bd372d57c1,464), RTFLOAT80U_INIT_C(0,0xdebaae8c38121b9e,7427) }, /* #16/3/3/c */
    { 0x0000, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/0/0/u */
    { 0x007f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/0/c */
    { 0x0100, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/0/1/u */
    { 0x017f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/1/c */
    { 0x0200, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/0/2/u */
    { 0x027f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/2/c */
    { 0x0300, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/0/3/u */
    { 0x037f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/3/c */
    { 0x0400, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/1/0/u */
    { 0x047f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/0/c */
    { 0x0500, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/1/1/u */
    { 0x057f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/1/c */
    { 0x0600, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/1/2/u */
    { 0x067f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/2/c */
    { 0x0700, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/1/3/u */
    { 0x077f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/3/c */
    { 0x0800, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/2/0/u */
    { 0x087f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/0/c */
    { 0x0900, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/2/1/u */
    { 0x097f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/1/c */
    { 0x0a00, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/2/2/u */
    { 0x0a7f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/2/c */
    { 0x0b00, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/2/3/u */
    { 0x0b7f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/3/c */
    { 0x0c00, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/3/0/u */
    { 0x0c7f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/0/c */
    { 0x0d00, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/3/1/u */
    { 0x0d7f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/1/c */
    { 0x0e00, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/3/2/u */
    { 0x0e7f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/2/c */
    { 0x0f00, 0x55f9, 0xfd81, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331) }, /* #17/3/3/u */
    { 0x0f7f, 0x55f9, 0x7d01, RTFLOAT80U_INIT_C(0,0x3c4dd7b11e0a3c3a,26331), RTFLOAT64U_INIT_C(1,0xa93355089647f,1016), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/3/c */
    { 0x0000, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/0/0/u */
    { 0x007f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/0/0/c */
    { 0x0100, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/0/1/u */
    { 0x017f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/0/1/c */
    { 0x0200, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/0/2/u */
    { 0x027f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/0/2/c */
    { 0x0300, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/0/3/u */
    { 0x037f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/0/3/c */
    { 0x0400, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/1/0/u */
    { 0x047f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/1/0/c */
    { 0x0500, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/1/1/u */
    { 0x057f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/1/1/c */
    { 0x0600, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/1/2/u */
    { 0x067f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/1/2/c */
    { 0x0700, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/1/3/u */
    { 0x077f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/1/3/c */
    { 0x0800, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/2/0/u */
    { 0x087f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/2/0/c */
    { 0x0900, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/2/1/u */
    { 0x097f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/2/1/c */
    { 0x0a00, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/2/2/u */
    { 0x0a7f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/2/2/c */
    { 0x0b00, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/2/3/u */
    { 0x0b7f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/2/3/c */
    { 0x0c00, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/3/0/u */
    { 0x0c7f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/3/0/c */
    { 0x0d00, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/3/1/u */
    { 0x0d7f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/3/1/c */
    { 0x0e00, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/3/2/u */
    { 0x0e7f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/3/2/c */
    { 0x0f00, 0xd11d, 0xf981, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843) }, /* #18/3/3/u */
    { 0x0f7f, 0xd11d, 0x7901, RTFLOAT80U_INIT_C(0,0x340ee475a5306918,22843), RTFLOAT64U_INIT_C(0,0x334a3bd04dec1,1465), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #18/3/3/c */
    { 0x0000, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/0/0/u */
    { 0x007f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/0/0/c */
    { 0x0100, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/0/1/u */
    { 0x017f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/0/1/c */
    { 0x0200, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/0/2/u */
    { 0x027f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/0/2/c */
    { 0x0300, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/0/3/u */
    { 0x037f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/0/3/c */
    { 0x0400, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/1/0/u */
    { 0x047f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/1/0/c */
    { 0x0500, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/1/1/u */
    { 0x057f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/1/1/c */
    { 0x0600, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/1/2/u */
    { 0x067f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/1/2/c */
    { 0x0700, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/1/3/u */
    { 0x077f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/1/3/c */
    { 0x0800, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/2/0/u */
    { 0x087f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/2/0/c */
    { 0x0900, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/2/1/u */
    { 0x097f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/2/1/c */
    { 0x0a00, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/2/2/u */
    { 0x0a7f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/2/2/c */
    { 0x0b00, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/2/3/u */
    { 0x0b7f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/2/3/c */
    { 0x0c00, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/3/0/u */
    { 0x0c7f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/3/0/c */
    { 0x0d00, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/3/1/u */
    { 0x0d7f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/3/1/c */
    { 0x0e00, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/3/2/u */
    { 0x0e7f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/3/2/c */
    { 0x0f00, 0x4198, 0xf982, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0) }, /* #19/3/3/u */
    { 0x0f7f, 0x4198, 0x7902, RTFLOAT80U_INIT_C(1,0x80000024cb68c005,0), RTFLOAT64U_INIT_C(0,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #19/3/3/c */
    { 0x0000, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/0/u */
    { 0x007f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/0/c */
    { 0x0100, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/1/u */
    { 0x017f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/1/c */
    { 0x0200, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/2/u */
    { 0x027f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/2/c */
    { 0x0300, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/3/u */
    { 0x037f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/0/3/c */
    { 0x0400, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/0/u */
    { 0x047f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/0/c */
    { 0x0500, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/1/u */
    { 0x057f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/1/c */
    { 0x0600, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/2/u */
    { 0x067f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/2/c */
    { 0x0700, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/3/u */
    { 0x077f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/1/3/c */
    { 0x0800, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/0/u */
    { 0x087f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/0/c */
    { 0x0900, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/1/u */
    { 0x097f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/1/c */
    { 0x0a00, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/2/u */
    { 0x0a7f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/2/c */
    { 0x0b00, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/3/u */
    { 0x0b7f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/2/3/c */
    { 0x0c00, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/0/u */
    { 0x0c7f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/0/c */
    { 0x0d00, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/1/u */
    { 0x0d7f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/1/c */
    { 0x0e00, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/2/u */
    { 0x0e7f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/2/c */
    { 0x0f00, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/3/u */
    { 0x0f7f, 0x16c8, 0x3c00, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT64U_INIT_C(0,0x7240a40185e9f,1603), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #20/3/3/c */
    { 0x0000, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/0/0/u */
    { 0x007f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/0/c */
    { 0x0100, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/0/1/u */
    { 0x017f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/1/c */
    { 0x0200, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/0/2/u */
    { 0x027f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/2/c */
    { 0x0300, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/0/3/u */
    { 0x037f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/0/3/c */
    { 0x0400, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/1/0/u */
    { 0x047f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/0/c */
    { 0x0500, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/1/1/u */
    { 0x057f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/1/c */
    { 0x0600, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/1/2/u */
    { 0x067f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/2/c */
    { 0x0700, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/1/3/u */
    { 0x077f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/1/3/c */
    { 0x0800, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/2/0/u */
    { 0x087f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/0/c */
    { 0x0900, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/2/1/u */
    { 0x097f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/1/c */
    { 0x0a00, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/2/2/u */
    { 0x0a7f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/2/c */
    { 0x0b00, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/2/3/u */
    { 0x0b7f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/2/3/c */
    { 0x0c00, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/3/0/u */
    { 0x0c7f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/0/c */
    { 0x0d00, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/3/1/u */
    { 0x0d7f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/1/c */
    { 0x0e00, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/3/2/u */
    { 0x0e7f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/2/c */
    { 0x0f00, 0xc34a, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #21/3/3/u */
    { 0x0f7f, 0xc34a, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT64U_INIT_C(0,0x16b5951195a4f,263), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #21/3/3/c */
    { 0x0000, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/0/0/u */
    { 0x007f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/0/c */
    { 0x0100, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/0/1/u */
    { 0x017f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/1/c */
    { 0x0200, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/0/2/u */
    { 0x027f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/2/c */
    { 0x0300, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/0/3/u */
    { 0x037f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/0/3/c */
    { 0x0400, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/1/0/u */
    { 0x047f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/0/c */
    { 0x0500, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/1/1/u */
    { 0x057f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/1/c */
    { 0x0600, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/1/2/u */
    { 0x067f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/2/c */
    { 0x0700, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/1/3/u */
    { 0x077f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/1/3/c */
    { 0x0800, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/2/0/u */
    { 0x087f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/0/c */
    { 0x0900, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/2/1/u */
    { 0x097f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/1/c */
    { 0x0a00, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/2/2/u */
    { 0x0a7f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/2/c */
    { 0x0b00, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/2/3/u */
    { 0x0b7f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/2/3/c */
    { 0x0c00, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/3/0/u */
    { 0x0c7f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/0/c */
    { 0x0d00, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/3/1/u */
    { 0x0d7f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/1/c */
    { 0x0e00, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/3/2/u */
    { 0x0e7f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/2/c */
    { 0x0f00, 0xee91, 0xfc81, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483) }, /* #22/3/3/u */
    { 0x0f7f, 0xee91, 0x7c01, RTFLOAT80U_INIT_C(0,0x9f281e224e1860f,1483), RTFLOAT64U_INIT_C(0,0xc2b9936db35c0,453), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #22/3/3/c */
    { 0x0000, 0x66f9, 0xfea0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42730000000000,10465) }, /* #23/0/0/u */
    { 0x007f, 0x66f9, 0x7e20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42730000000000,10465) }, /* #23/0/0/c */
    { 0x0100, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/0/1/u */
    { 0x017f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/0/1/c */
    { 0x0200, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779000,10465) }, /* #23/0/2/u */
    { 0x027f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779000,10465) }, /* #23/0/2/c */
    { 0x0300, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/0/3/u */
    { 0x037f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/0/3/c */
    { 0x0400, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42720000000000,10465) }, /* #23/1/0/u */
    { 0x047f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42720000000000,10465) }, /* #23/1/0/c */
    { 0x0500, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/1/1/u */
    { 0x057f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/1/1/c */
    { 0x0600, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779000,10465) }, /* #23/1/2/u */
    { 0x067f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779000,10465) }, /* #23/1/2/c */
    { 0x0700, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/1/3/u */
    { 0x077f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/1/3/c */
    { 0x0800, 0x66f9, 0xfea0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42730000000000,10465) }, /* #23/2/0/u */
    { 0x087f, 0x66f9, 0x7e20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42730000000000,10465) }, /* #23/2/0/c */
    { 0x0900, 0x66f9, 0xfea0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792ca,10465) }, /* #23/2/1/u */
    { 0x097f, 0x66f9, 0x7e20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792ca,10465) }, /* #23/2/1/c */
    { 0x0a00, 0x66f9, 0xfea0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779800,10465) }, /* #23/2/2/u */
    { 0x0a7f, 0x66f9, 0x7e20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779800,10465) }, /* #23/2/2/c */
    { 0x0b00, 0x66f9, 0xfea0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792ca,10465) }, /* #23/2/3/u */
    { 0x0b7f, 0x66f9, 0x7e20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792ca,10465) }, /* #23/2/3/c */
    { 0x0c00, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42720000000000,10465) }, /* #23/3/0/u */
    { 0x0c7f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe42720000000000,10465) }, /* #23/3/0/c */
    { 0x0d00, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/3/1/u */
    { 0x0d7f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/3/1/c */
    { 0x0e00, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779000,10465) }, /* #23/3/2/u */
    { 0x0e7f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c779000,10465) }, /* #23/3/2/c */
    { 0x0f00, 0x66f9, 0xfca0, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/3/3/u */
    { 0x0f7f, 0x66f9, 0x7c20, RTFLOAT80U_INIT_C(0,0xe8b9988ccf99e8d2,10281), RTFLOAT64U_INIT_C(0,0x17b0327fa0182,1207), RTFLOAT80U_INIT_C(0,0xfe4272c29c7792c9,10465) }, /* #23/3/3/c */
    { 0x0000, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/0/u */
    { 0x007f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/0/c */
    { 0x0100, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/1/u */
    { 0x017f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/1/c */
    { 0x0200, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/2/u */
    { 0x027f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/2/c */
    { 0x0300, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/3/u */
    { 0x037f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/0/3/c */
    { 0x0400, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/0/u */
    { 0x047f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/0/c */
    { 0x0500, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/1/u */
    { 0x057f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/1/c */
    { 0x0600, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/2/u */
    { 0x067f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/2/c */
    { 0x0700, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/3/u */
    { 0x077f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/1/3/c */
    { 0x0800, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/0/u */
    { 0x087f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/0/c */
    { 0x0900, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/1/u */
    { 0x097f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/1/c */
    { 0x0a00, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/2/u */
    { 0x0a7f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/2/c */
    { 0x0b00, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/3/u */
    { 0x0b7f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/2/3/c */
    { 0x0c00, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/0/u */
    { 0x0c7f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/0/c */
    { 0x0d00, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/1/u */
    { 0x0d7f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/1/c */
    { 0x0e00, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/2/u */
    { 0x0e7f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/2/c */
    { 0x0f00, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/3/u */
    { 0x0f7f, 0xdaa0, 0x7800, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT64U_INIT_C(1,0xc3d3abb53e8d7,853), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #24/3/3/c */
    { 0x0000, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/0/0/u */
    { 0x007f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/0/c */
    { 0x0100, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/0/1/u */
    { 0x017f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/1/c */
    { 0x0200, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/0/2/u */
    { 0x027f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/2/c */
    { 0x0300, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/0/3/u */
    { 0x037f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/3/c */
    { 0x0400, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/1/0/u */
    { 0x047f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/0/c */
    { 0x0500, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/1/1/u */
    { 0x057f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/1/c */
    { 0x0600, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/1/2/u */
    { 0x067f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/2/c */
    { 0x0700, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/1/3/u */
    { 0x077f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/3/c */
    { 0x0800, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/2/0/u */
    { 0x087f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/0/c */
    { 0x0900, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/2/1/u */
    { 0x097f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/1/c */
    { 0x0a00, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/2/2/u */
    { 0x0a7f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/2/c */
    { 0x0b00, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/2/3/u */
    { 0x0b7f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/3/c */
    { 0x0c00, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/3/0/u */
    { 0x0c7f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/0/c */
    { 0x0d00, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/3/1/u */
    { 0x0d7f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/1/c */
    { 0x0e00, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/3/2/u */
    { 0x0e7f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/2/c */
    { 0x0f00, 0x99c2, 0xb981, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623) }, /* #25/3/3/u */
    { 0x0f7f, 0x99c2, 0x3901, RTFLOAT80U_INIT_C(0,0x7bfc80afbcec3790,17623), RTFLOAT64U_INIT_C(0,0xd7b20873145c0,1658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/3/c */
    { 0x0000, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/0/0/u */
    { 0x007f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/0/0/c */
    { 0x0100, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/0/1/u */
    { 0x017f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/0/1/c */
    { 0x0200, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/0/2/u */
    { 0x027f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/0/2/c */
    { 0x0300, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/0/3/u */
    { 0x037f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/0/3/c */
    { 0x0400, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/1/0/u */
    { 0x047f, 0xc1c5, 0x7b32, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x10000000000,0) }, /* #26/1/0/c */
    { 0x0500, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/1/1/u */
    { 0x057f, 0xc1c5, 0x7b32, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #26/1/1/c */
    { 0x0600, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/1/2/u */
    { 0x067f, 0xc1c5, 0x7b32, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x800,0) }, /* #26/1/2/c */
    { 0x0700, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/1/3/u */
    { 0x077f, 0xc1c5, 0x7b32, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #26/1/3/c */
    { 0x0800, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/2/0/u */
    { 0x087f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/2/0/c */
    { 0x0900, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/2/1/u */
    { 0x097f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/2/1/c */
    { 0x0a00, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/2/2/u */
    { 0x0a7f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/2/2/c */
    { 0x0b00, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/2/3/u */
    { 0x0b7f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/2/3/c */
    { 0x0c00, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/3/0/u */
    { 0x0c7f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/3/0/c */
    { 0x0d00, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/3/1/u */
    { 0x0d7f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/3/1/c */
    { 0x0e00, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/3/2/u */
    { 0x0e7f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/3/2/c */
    { 0x0f00, 0xc1c5, 0xf982, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0) }, /* #26/3/3/u */
    { 0x0f7f, 0xc1c5, 0x7932, RTFLOAT80U_INIT_C(1,0xb8ea5fc695ed86fe,0), RTFLOAT64U_INIT_C(0,0x13a56abf24bf8,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #26/3/3/c */
    { 0x0000, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/0/u */
    { 0x007f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/0/c */
    { 0x0100, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/1/u */
    { 0x017f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/1/c */
    { 0x0200, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/2/u */
    { 0x027f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/2/c */
    { 0x0300, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/3/u */
    { 0x037f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/0/3/c */
    { 0x0400, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/0/u */
    { 0x047f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/0/c */
    { 0x0500, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/1/u */
    { 0x057f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/1/c */
    { 0x0600, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/2/u */
    { 0x067f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/2/c */
    { 0x0700, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/3/u */
    { 0x077f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/1/3/c */
    { 0x0800, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/0/u */
    { 0x087f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/0/c */
    { 0x0900, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/1/u */
    { 0x097f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/1/c */
    { 0x0a00, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/2/u */
    { 0x0a7f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/2/c */
    { 0x0b00, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/3/u */
    { 0x0b7f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/2/3/c */
    { 0x0c00, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/0/u */
    { 0x0c7f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/0/c */
    { 0x0d00, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/1/u */
    { 0x0d7f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/1/c */
    { 0x0e00, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/2/u */
    { 0x0e7f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/2/c */
    { 0x0f00, 0x69d3, 0xf981, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/3/u */
    { 0x0f7f, 0x69d3, 0x7901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x434b75,2047), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #27/3/3/c */
    { 0x0000, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d30000000000,11948) }, /* #28/0/0/u */
    { 0x007f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d30000000000,11948) }, /* #28/0/0/c */
    { 0x0100, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/0/1/u */
    { 0x017f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/0/1/c */
    { 0x0200, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad6a000,11948) }, /* #28/0/2/u */
    { 0x027f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad6a000,11948) }, /* #28/0/2/c */
    { 0x0300, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/0/3/u */
    { 0x037f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/0/3/c */
    { 0x0400, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d40000000000,11948) }, /* #28/1/0/u */
    { 0x047f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d40000000000,11948) }, /* #28/1/0/c */
    { 0x0500, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/1/1/u */
    { 0x057f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/1/1/c */
    { 0x0600, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad6a000,11948) }, /* #28/1/2/u */
    { 0x067f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad6a000,11948) }, /* #28/1/2/c */
    { 0x0700, 0x8200, 0xbaa0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/1/3/u */
    { 0x077f, 0x8200, 0x3a20, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8e,11948) }, /* #28/1/3/c */
    { 0x0800, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d30000000000,11948) }, /* #28/2/0/u */
    { 0x087f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d30000000000,11948) }, /* #28/2/0/c */
    { 0x0900, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/2/1/u */
    { 0x097f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/2/1/c */
    { 0x0a00, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69800,11948) }, /* #28/2/2/u */
    { 0x0a7f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69800,11948) }, /* #28/2/2/c */
    { 0x0b00, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/2/3/u */
    { 0x0b7f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/2/3/c */
    { 0x0c00, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d30000000000,11948) }, /* #28/3/0/u */
    { 0x0c7f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d30000000000,11948) }, /* #28/3/0/c */
    { 0x0d00, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/3/1/u */
    { 0x0d7f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/3/1/c */
    { 0x0e00, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69800,11948) }, /* #28/3/2/u */
    { 0x0e7f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69800,11948) }, /* #28/3/2/c */
    { 0x0f00, 0x8200, 0xb8a0, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/3/3/u */
    { 0x0f7f, 0x8200, 0x3820, RTFLOAT80U_INIT_C(0,0xa332da73e5d35354,12769), RTFLOAT64U_INIT_C(1,0xde784f9d9790a,201), RTFLOAT80U_INIT_C(1,0x9882d33dfad69f8d,11948) }, /* #28/3/3/c */
    { 0x0000, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/0/0/u */
    { 0x007f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d10000000000,15708) }, /* #29/0/0/c */
    { 0x0100, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/0/1/u */
    { 0x017f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a8,15708) }, /* #29/0/1/c */
    { 0x0200, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/0/2/u */
    { 0x027f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e92800,15708) }, /* #29/0/2/c */
    { 0x0300, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/0/3/u */
    { 0x037f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a8,15708) }, /* #29/0/3/c */
    { 0x0400, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/1/0/u */
    { 0x047f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d10000000000,15708) }, /* #29/1/0/c */
    { 0x0500, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/1/1/u */
    { 0x057f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a8,15708) }, /* #29/1/1/c */
    { 0x0600, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/1/2/u */
    { 0x067f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e92800,15708) }, /* #29/1/2/c */
    { 0x0700, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/1/3/u */
    { 0x077f, 0xcd55, 0x7f22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a8,15708) }, /* #29/1/3/c */
    { 0x0800, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/2/0/u */
    { 0x087f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d00000000000,15708) }, /* #29/2/0/c */
    { 0x0900, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/2/1/u */
    { 0x097f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a7,15708) }, /* #29/2/1/c */
    { 0x0a00, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/2/2/u */
    { 0x0a7f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e92000,15708) }, /* #29/2/2/c */
    { 0x0b00, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/2/3/u */
    { 0x0b7f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a7,15708) }, /* #29/2/3/c */
    { 0x0c00, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/3/0/u */
    { 0x0c7f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d00000000000,15708) }, /* #29/3/0/c */
    { 0x0d00, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/3/1/u */
    { 0x0d7f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a7,15708) }, /* #29/3/1/c */
    { 0x0e00, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/3/2/u */
    { 0x0e7f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e92000,15708) }, /* #29/3/2/c */
    { 0x0f00, 0xcd55, 0xfd82, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733) }, /* #29/3/3/u */
    { 0x0f7f, 0xcd55, 0x7d22, RTFLOAT80U_INIT_C(1,0xcfee4acbf82d71a1,16733), RTFLOAT64U_INIT_C(0,0x168a818f4bc2a,0), RTFLOAT80U_INIT_C(1,0x9277d0ea84e925a7,15708) }, /* #29/3/3/c */
    { 0x0000, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/0/u */
    { 0x007f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/0/c */
    { 0x0100, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/1/u */
    { 0x017f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/1/c */
    { 0x0200, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/2/u */
    { 0x027f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/2/c */
    { 0x0300, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/3/u */
    { 0x037f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/0/3/c */
    { 0x0400, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/0/u */
    { 0x047f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/0/c */
    { 0x0500, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/1/u */
    { 0x057f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/1/c */
    { 0x0600, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/2/u */
    { 0x067f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/2/c */
    { 0x0700, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/3/u */
    { 0x077f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/1/3/c */
    { 0x0800, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/0/u */
    { 0x087f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/0/c */
    { 0x0900, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/1/u */
    { 0x097f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/1/c */
    { 0x0a00, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/2/u */
    { 0x0a7f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/2/c */
    { 0x0b00, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/3/u */
    { 0x0b7f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/2/3/c */
    { 0x0c00, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/0/u */
    { 0x0c7f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/0/c */
    { 0x0d00, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/1/u */
    { 0x0d7f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/1/c */
    { 0x0e00, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/2/u */
    { 0x0e7f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/2/c */
    { 0x0f00, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/3/u */
    { 0x0f7f, 0x5498, 0x7c00, RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767), RTFLOAT64U_INIT_C(1,0xbb2c6875ac352,739), RTFLOAT80U_INIT_C(1,0xc1c27393d6eecdcb,32767) }, /* #30/3/3/c */
    { 0x0000, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/0/0/u */
    { 0x007f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/0/c */
    { 0x0100, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/0/1/u */
    { 0x017f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/1/c */
    { 0x0200, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/0/2/u */
    { 0x027f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/2/c */
    { 0x0300, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/0/3/u */
    { 0x037f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/0/3/c */
    { 0x0400, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/1/0/u */
    { 0x047f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/0/c */
    { 0x0500, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/1/1/u */
    { 0x057f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/1/c */
    { 0x0600, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/1/2/u */
    { 0x067f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/2/c */
    { 0x0700, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/1/3/u */
    { 0x077f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/1/3/c */
    { 0x0800, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/2/0/u */
    { 0x087f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/0/c */
    { 0x0900, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/2/1/u */
    { 0x097f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/1/c */
    { 0x0a00, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/2/2/u */
    { 0x0a7f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/2/c */
    { 0x0b00, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/2/3/u */
    { 0x0b7f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/2/3/c */
    { 0x0c00, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/3/0/u */
    { 0x0c7f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/0/c */
    { 0x0d00, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/3/1/u */
    { 0x0d7f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/1/c */
    { 0x0e00, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/3/2/u */
    { 0x0e7f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/2/c */
    { 0x0f00, 0x7e27, 0xfc81, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629) }, /* #31/3/3/u */
    { 0x0f7f, 0x7e27, 0x7c01, RTFLOAT80U_INIT_C(0,0x22c59146474b7697,20629), RTFLOAT64U_INIT_C(0,0x4f91d6074983,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #31/3/3/c */
    { 0x0000, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/0/0/u */
    { 0x007f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa251a0000000000,10535) }, /* #32/0/0/c */
    { 0x0100, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/0/1/u */
    { 0x017f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a67a,10535) }, /* #32/0/1/c */
    { 0x0200, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/0/2/u */
    { 0x027f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a800,10535) }, /* #32/0/2/c */
    { 0x0300, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/0/3/u */
    { 0x037f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a67a,10535) }, /* #32/0/3/c */
    { 0x0400, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/1/0/u */
    { 0x047f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa25190000000000,10535) }, /* #32/1/0/c */
    { 0x0500, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/1/1/u */
    { 0x057f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a679,10535) }, /* #32/1/1/c */
    { 0x0600, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/1/2/u */
    { 0x067f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a000,10535) }, /* #32/1/2/c */
    { 0x0700, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/1/3/u */
    { 0x077f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a679,10535) }, /* #32/1/3/c */
    { 0x0800, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/2/0/u */
    { 0x087f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa251a0000000000,10535) }, /* #32/2/0/c */
    { 0x0900, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/2/1/u */
    { 0x097f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a67a,10535) }, /* #32/2/1/c */
    { 0x0a00, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/2/2/u */
    { 0x0a7f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a800,10535) }, /* #32/2/2/c */
    { 0x0b00, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/2/3/u */
    { 0x0b7f, 0xc7f3, 0x7f22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a67a,10535) }, /* #32/2/3/c */
    { 0x0c00, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/3/0/u */
    { 0x0c7f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa25190000000000,10535) }, /* #32/3/0/c */
    { 0x0d00, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/3/1/u */
    { 0x0d7f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a679,10535) }, /* #32/3/1/c */
    { 0x0e00, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/3/2/u */
    { 0x0e7f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a000,10535) }, /* #32/3/2/c */
    { 0x0f00, 0xc7f3, 0xfd82, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586) }, /* #32/3/3/u */
    { 0x0f7f, 0xc7f3, 0x7d22, RTFLOAT80U_INIT_C(1,0xf23dc9be0b87af2f,11586), RTFLOAT64U_INIT_C(1,0x59e783,0), RTFLOAT80U_INIT_C(0,0xaa2519b37575a679,10535) }, /* #32/3/3/c */
    { 0x0000, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/0/0/u */
    { 0x007f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb60000000000,15127) }, /* #33/0/0/c */
    { 0x0100, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/0/1/u */
    { 0x017f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8560,15127) }, /* #33/0/1/c */
    { 0x0200, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/0/2/u */
    { 0x027f, 0xc69a, 0x7e22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8800,15127) }, /* #33/0/2/c */
    { 0x0300, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/0/3/u */
    { 0x037f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8560,15127) }, /* #33/0/3/c */
    { 0x0400, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/1/0/u */
    { 0x047f, 0xc69a, 0x7e22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb70000000000,15127) }, /* #33/1/0/c */
    { 0x0500, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/1/1/u */
    { 0x057f, 0xc69a, 0x7e22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8561,15127) }, /* #33/1/1/c */
    { 0x0600, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/1/2/u */
    { 0x067f, 0xc69a, 0x7e22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8800,15127) }, /* #33/1/2/c */
    { 0x0700, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/1/3/u */
    { 0x077f, 0xc69a, 0x7e22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8561,15127) }, /* #33/1/3/c */
    { 0x0800, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/2/0/u */
    { 0x087f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb60000000000,15127) }, /* #33/2/0/c */
    { 0x0900, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/2/1/u */
    { 0x097f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8560,15127) }, /* #33/2/1/c */
    { 0x0a00, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/2/2/u */
    { 0x0a7f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8000,15127) }, /* #33/2/2/c */
    { 0x0b00, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/2/3/u */
    { 0x0b7f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8560,15127) }, /* #33/2/3/c */
    { 0x0c00, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/3/0/u */
    { 0x0c7f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb60000000000,15127) }, /* #33/3/0/c */
    { 0x0d00, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/3/1/u */
    { 0x0d7f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8560,15127) }, /* #33/3/1/c */
    { 0x0e00, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/3/2/u */
    { 0x0e7f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8000,15127) }, /* #33/3/2/c */
    { 0x0f00, 0xc69a, 0xfc82, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149) }, /* #33/3/3/u */
    { 0x0f7f, 0xc69a, 0x7c22, RTFLOAT80U_INIT_C(1,0xb0de0622831927b7,16149), RTFLOAT64U_INIT_C(0,0xd237d8a5b9e7e,0), RTFLOAT80U_INIT_C(1,0x913cb66975ac8560,15127) }, /* #33/3/3/c */
    { 0x0000, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb20000000000,3041) }, /* #34/0/0/u */
    { 0x007f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb20000000000,3041) }, /* #34/0/0/c */
    { 0x0100, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/0/1/u */
    { 0x017f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/0/1/c */
    { 0x0200, 0xe827, 0xfaa0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d6000,3041) }, /* #34/0/2/u */
    { 0x027f, 0xe827, 0x7a20, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d6000,3041) }, /* #34/0/2/c */
    { 0x0300, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/0/3/u */
    { 0x037f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/0/3/c */
    { 0x0400, 0xe827, 0xfaa0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb30000000000,3041) }, /* #34/1/0/u */
    { 0x047f, 0xe827, 0x7a20, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb30000000000,3041) }, /* #34/1/0/c */
    { 0x0500, 0xe827, 0xfaa0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dcf,3041) }, /* #34/1/1/u */
    { 0x057f, 0xe827, 0x7a20, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dcf,3041) }, /* #34/1/1/c */
    { 0x0600, 0xe827, 0xfaa0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d6000,3041) }, /* #34/1/2/u */
    { 0x067f, 0xe827, 0x7a20, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d6000,3041) }, /* #34/1/2/c */
    { 0x0700, 0xe827, 0xfaa0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dcf,3041) }, /* #34/1/3/u */
    { 0x077f, 0xe827, 0x7a20, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dcf,3041) }, /* #34/1/3/c */
    { 0x0800, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb20000000000,3041) }, /* #34/2/0/u */
    { 0x087f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb20000000000,3041) }, /* #34/2/0/c */
    { 0x0900, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/2/1/u */
    { 0x097f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/2/1/c */
    { 0x0a00, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5800,3041) }, /* #34/2/2/u */
    { 0x0a7f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5800,3041) }, /* #34/2/2/c */
    { 0x0b00, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/2/3/u */
    { 0x0b7f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/2/3/c */
    { 0x0c00, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb20000000000,3041) }, /* #34/3/0/u */
    { 0x0c7f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb20000000000,3041) }, /* #34/3/0/c */
    { 0x0d00, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/3/1/u */
    { 0x0d7f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/3/1/c */
    { 0x0e00, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5800,3041) }, /* #34/3/2/u */
    { 0x0e7f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5800,3041) }, /* #34/3/2/c */
    { 0x0f00, 0xe827, 0xf8a0, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/3/3/u */
    { 0x0f7f, 0xe827, 0x7820, RTFLOAT80U_INIT_C(1,0x850deb7c33a814a5,2236), RTFLOAT64U_INIT_C(0,0x26555563a342,1828), RTFLOAT80U_INIT_C(1,0x864cb22b842d5dce,3041) }, /* #34/3/3/c */
    { 0x0000, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/0/0/u */
    { 0x007f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/0/0/c */
    { 0x0100, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/0/1/u */
    { 0x017f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/0/1/c */
    { 0x0200, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/0/2/u */
    { 0x027f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/0/2/c */
    { 0x0300, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/0/3/u */
    { 0x037f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/0/3/c */
    { 0x0400, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/1/0/u */
    { 0x047f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/1/0/c */
    { 0x0500, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/1/1/u */
    { 0x057f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/1/1/c */
    { 0x0600, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/1/2/u */
    { 0x067f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/1/2/c */
    { 0x0700, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/1/3/u */
    { 0x077f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/1/3/c */
    { 0x0800, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/2/0/u */
    { 0x087f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/2/0/c */
    { 0x0900, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/2/1/u */
    { 0x097f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/2/1/c */
    { 0x0a00, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/2/2/u */
    { 0x0a7f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/2/2/c */
    { 0x0b00, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/2/3/u */
    { 0x0b7f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/2/3/c */
    { 0x0c00, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/3/0/u */
    { 0x0c7f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/3/0/c */
    { 0x0d00, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/3/1/u */
    { 0x0d7f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/3/1/c */
    { 0x0e00, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/3/2/u */
    { 0x0e7f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/3/2/c */
    { 0x0f00, 0x7ed5, 0xfc81, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822) }, /* #35/3/3/u */
    { 0x0f7f, 0x7ed5, 0x7c01, RTFLOAT80U_INIT_C(1,0x3ad4d32bf8ee78a9,12822), RTFLOAT64U_INIT_C(1,0x66edd52d51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #35/3/3/c */
    { 0x0000, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/0/0/u */
    { 0x007f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/0/c */
    { 0x0100, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/0/1/u */
    { 0x017f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/1/c */
    { 0x0200, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/0/2/u */
    { 0x027f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/2/c */
    { 0x0300, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/0/3/u */
    { 0x037f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/0/3/c */
    { 0x0400, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/1/0/u */
    { 0x047f, 0x2b42, 0x3b32, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x10000000000,0) }, /* #36/1/0/c */
    { 0x0500, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/1/1/u */
    { 0x057f, 0x2b42, 0x3b32, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #36/1/1/c */
    { 0x0600, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/1/2/u */
    { 0x067f, 0x2b42, 0x3b32, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x800,0) }, /* #36/1/2/c */
    { 0x0700, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/1/3/u */
    { 0x077f, 0x2b42, 0x3b32, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #36/1/3/c */
    { 0x0800, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/2/0/u */
    { 0x087f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/0/c */
    { 0x0900, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/2/1/u */
    { 0x097f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/1/c */
    { 0x0a00, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/2/2/u */
    { 0x0a7f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/2/c */
    { 0x0b00, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/2/3/u */
    { 0x0b7f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/2/3/c */
    { 0x0c00, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/3/0/u */
    { 0x0c7f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/0/c */
    { 0x0d00, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/3/1/u */
    { 0x0d7f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/1/c */
    { 0x0e00, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/3/2/u */
    { 0x0e7f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/2/c */
    { 0x0f00, 0x2b42, 0xb982, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0) }, /* #36/3/3/u */
    { 0x0f7f, 0x2b42, 0x3932, RTFLOAT80U_INIT_C(1,0x80046c6bcd0eeac0,0), RTFLOAT64U_INIT_C(0,0x220a9ef6c5a60,698), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #36/3/3/c */
    { 0x0000, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/0/0/u */
    { 0x007f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/0/c */
    { 0x0100, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/0/1/u */
    { 0x017f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/1/c */
    { 0x0200, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/0/2/u */
    { 0x027f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/2/c */
    { 0x0300, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/0/3/u */
    { 0x037f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/3/c */
    { 0x0400, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/1/0/u */
    { 0x047f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/0/c */
    { 0x0500, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/1/1/u */
    { 0x057f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/1/c */
    { 0x0600, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/1/2/u */
    { 0x067f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/2/c */
    { 0x0700, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/1/3/u */
    { 0x077f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/3/c */
    { 0x0800, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/2/0/u */
    { 0x087f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/0/c */
    { 0x0900, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/2/1/u */
    { 0x097f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/1/c */
    { 0x0a00, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/2/2/u */
    { 0x0a7f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/2/c */
    { 0x0b00, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/2/3/u */
    { 0x0b7f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/3/c */
    { 0x0c00, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/3/0/u */
    { 0x0c7f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/0/c */
    { 0x0d00, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/3/1/u */
    { 0x0d7f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/1/c */
    { 0x0e00, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/3/2/u */
    { 0x0e7f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/2/c */
    { 0x0f00, 0x7c61, 0xfc81, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497) }, /* #37/3/3/u */
    { 0x0f7f, 0x7c61, 0x7c01, RTFLOAT80U_INIT_C(0,0x400383e48c4f3f83,1497), RTFLOAT64U_INIT_C(0,0x6e5f9c28db51b,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/3/c */
    { 0x0000, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/0/0/u */
    { 0x007f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/0/c */
    { 0x0100, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/0/1/u */
    { 0x017f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/1/c */
    { 0x0200, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/0/2/u */
    { 0x027f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/2/c */
    { 0x0300, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/0/3/u */
    { 0x037f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/3/c */
    { 0x0400, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/1/0/u */
    { 0x047f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/0/c */
    { 0x0500, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/1/1/u */
    { 0x057f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/1/c */
    { 0x0600, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/1/2/u */
    { 0x067f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/2/c */
    { 0x0700, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/1/3/u */
    { 0x077f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/3/c */
    { 0x0800, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/2/0/u */
    { 0x087f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/0/c */
    { 0x0900, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/2/1/u */
    { 0x097f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/1/c */
    { 0x0a00, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/2/2/u */
    { 0x0a7f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/2/c */
    { 0x0b00, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/2/3/u */
    { 0x0b7f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/3/c */
    { 0x0c00, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/3/0/u */
    { 0x0c7f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/0/c */
    { 0x0d00, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/3/1/u */
    { 0x0d7f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/1/c */
    { 0x0e00, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/3/2/u */
    { 0x0e7f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/2/c */
    { 0x0f00, 0xda45, 0xf881, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590) }, /* #38/3/3/u */
    { 0x0f7f, 0xda45, 0x7801, RTFLOAT80U_INIT_C(0,0x294c0c4b5cf37a6,31590), RTFLOAT64U_INIT_C(0,0x2c21c588a89cf,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/3/c */
    { 0x0000, 0x7c59, 0xfea0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe70000000000,4668) }, /* #39/0/0/u */
    { 0x007f, 0x7c59, 0x7e20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe70000000000,4668) }, /* #39/0/0/c */
    { 0x0100, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/0/1/u */
    { 0x017f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/0/1/c */
    { 0x0200, 0x7c59, 0xfea0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91800,4668) }, /* #39/0/2/u */
    { 0x027f, 0x7c59, 0x7e20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91800,4668) }, /* #39/0/2/c */
    { 0x0300, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/0/3/u */
    { 0x037f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/0/3/c */
    { 0x0400, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe60000000000,4668) }, /* #39/1/0/u */
    { 0x047f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe60000000000,4668) }, /* #39/1/0/c */
    { 0x0500, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/1/1/u */
    { 0x057f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/1/1/c */
    { 0x0600, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91000,4668) }, /* #39/1/2/u */
    { 0x067f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91000,4668) }, /* #39/1/2/c */
    { 0x0700, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/1/3/u */
    { 0x077f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/1/3/c */
    { 0x0800, 0x7c59, 0xfea0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe70000000000,4668) }, /* #39/2/0/u */
    { 0x087f, 0x7c59, 0x7e20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe70000000000,4668) }, /* #39/2/0/c */
    { 0x0900, 0x7c59, 0xfea0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91798,4668) }, /* #39/2/1/u */
    { 0x097f, 0x7c59, 0x7e20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91798,4668) }, /* #39/2/1/c */
    { 0x0a00, 0x7c59, 0xfea0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91800,4668) }, /* #39/2/2/u */
    { 0x0a7f, 0x7c59, 0x7e20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91800,4668) }, /* #39/2/2/c */
    { 0x0b00, 0x7c59, 0xfea0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91798,4668) }, /* #39/2/3/u */
    { 0x0b7f, 0x7c59, 0x7e20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91798,4668) }, /* #39/2/3/c */
    { 0x0c00, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe60000000000,4668) }, /* #39/3/0/u */
    { 0x0c7f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe60000000000,4668) }, /* #39/3/0/c */
    { 0x0d00, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/3/1/u */
    { 0x0d7f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/3/1/c */
    { 0x0e00, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91000,4668) }, /* #39/3/2/u */
    { 0x0e7f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91000,4668) }, /* #39/3/2/c */
    { 0x0f00, 0x7c59, 0xfca0, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/3/3/u */
    { 0x0f7f, 0x7c59, 0x7c20, RTFLOAT80U_INIT_C(0,0xf5aaa3e565bfe0d5,5260), RTFLOAT64U_INIT_C(0,0xf325b569c3170,430), RTFLOAT80U_INIT_C(0,0xef7fe69c7cc91797,4668) }, /* #39/3/3/c */
    { 0x0000, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/0/u */
    { 0x007f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/0/c */
    { 0x0100, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/1/u */
    { 0x017f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/1/c */
    { 0x0200, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/2/u */
    { 0x027f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/2/c */
    { 0x0300, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/3/u */
    { 0x037f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/0/3/c */
    { 0x0400, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/0/u */
    { 0x047f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/0/c */
    { 0x0500, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/1/u */
    { 0x057f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/1/c */
    { 0x0600, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/2/u */
    { 0x067f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/2/c */
    { 0x0700, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/3/u */
    { 0x077f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/1/3/c */
    { 0x0800, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/0/u */
    { 0x087f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/0/c */
    { 0x0900, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/1/u */
    { 0x097f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/1/c */
    { 0x0a00, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/2/u */
    { 0x0a7f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/2/c */
    { 0x0b00, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/3/u */
    { 0x0b7f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/2/3/c */
    { 0x0c00, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/0/u */
    { 0x0c7f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/0/c */
    { 0x0d00, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/1/u */
    { 0x0d7f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/1/c */
    { 0x0e00, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/2/u */
    { 0x0e7f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/2/c */
    { 0x0f00, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/3/u */
    { 0x0f7f, 0xab3c, 0x3900, RTFLOAT80U_INIT_C(0,0xd4fc27483a4ec20b,4520), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767) }, /* #40/3/3/c */
    { 0x0000, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e950000000000,13796) }, /* #41/0/0/u */
    { 0x007f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e950000000000,13796) }, /* #41/0/0/c */
    { 0x0100, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/0/1/u */
    { 0x017f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/0/1/c */
    { 0x0200, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d81489800,13796) }, /* #41/0/2/u */
    { 0x027f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d81489800,13796) }, /* #41/0/2/c */
    { 0x0300, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/0/3/u */
    { 0x037f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/0/3/c */
    { 0x0400, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e950000000000,13796) }, /* #41/1/0/u */
    { 0x047f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e950000000000,13796) }, /* #41/1/0/c */
    { 0x0500, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/1/1/u */
    { 0x057f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/1/1/c */
    { 0x0600, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d81489800,13796) }, /* #41/1/2/u */
    { 0x067f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d81489800,13796) }, /* #41/1/2/c */
    { 0x0700, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/1/3/u */
    { 0x077f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/1/3/c */
    { 0x0800, 0xa9ec, 0xbba0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e960000000000,13796) }, /* #41/2/0/u */
    { 0x087f, 0xa9ec, 0x3b20, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e960000000000,13796) }, /* #41/2/0/c */
    { 0x0900, 0xa9ec, 0xbba0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993d,13796) }, /* #41/2/1/u */
    { 0x097f, 0xa9ec, 0x3b20, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993d,13796) }, /* #41/2/1/c */
    { 0x0a00, 0xa9ec, 0xbba0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148a000,13796) }, /* #41/2/2/u */
    { 0x0a7f, 0xa9ec, 0x3b20, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148a000,13796) }, /* #41/2/2/c */
    { 0x0b00, 0xa9ec, 0xbba0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993d,13796) }, /* #41/2/3/u */
    { 0x0b7f, 0xa9ec, 0x3b20, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993d,13796) }, /* #41/2/3/c */
    { 0x0c00, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e950000000000,13796) }, /* #41/3/0/u */
    { 0x0c7f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e950000000000,13796) }, /* #41/3/0/c */
    { 0x0d00, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/3/1/u */
    { 0x0d7f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/3/1/c */
    { 0x0e00, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d81489800,13796) }, /* #41/3/2/u */
    { 0x0e7f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d81489800,13796) }, /* #41/3/2/c */
    { 0x0f00, 0xa9ec, 0xb9a0, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/3/3/u */
    { 0x0f7f, 0xa9ec, 0x3920, RTFLOAT80U_INIT_C(1,0xe2067c6d8ffcce61,13381), RTFLOAT64U_INIT_C(1,0xe13535e95fe96,1437), RTFLOAT80U_INIT_C(0,0xd46e955d8148993c,13796) }, /* #41/3/3/c */
    { 0x0000, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/0/0/u */
    { 0x007f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/0/c */
    { 0x0100, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/0/1/u */
    { 0x017f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/1/c */
    { 0x0200, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/0/2/u */
    { 0x027f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/2/c */
    { 0x0300, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/0/3/u */
    { 0x037f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/3/c */
    { 0x0400, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/1/0/u */
    { 0x047f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/0/c */
    { 0x0500, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/1/1/u */
    { 0x057f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/1/c */
    { 0x0600, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/1/2/u */
    { 0x067f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/2/c */
    { 0x0700, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/1/3/u */
    { 0x077f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/3/c */
    { 0x0800, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/2/0/u */
    { 0x087f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/0/c */
    { 0x0900, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/2/1/u */
    { 0x097f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/1/c */
    { 0x0a00, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/2/2/u */
    { 0x0a7f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/2/c */
    { 0x0b00, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/2/3/u */
    { 0x0b7f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/3/c */
    { 0x0c00, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/3/0/u */
    { 0x0c7f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/0/c */
    { 0x0d00, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/3/1/u */
    { 0x0d7f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/1/c */
    { 0x0e00, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/3/2/u */
    { 0x0e7f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/2/c */
    { 0x0f00, 0x6501, 0xfd81, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805) }, /* #42/3/3/u */
    { 0x0f7f, 0x6501, 0x7d01, RTFLOAT80U_INIT_C(1,0x509f813b7402bbfb,805), RTFLOAT64U_INIT_C(0,0x4a696945d321c,1272), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/3/c */
    { 0x0000, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/0/0/u */
    { 0x007f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/0/0/c */
    { 0x0100, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/0/1/u */
    { 0x017f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/0/1/c */
    { 0x0200, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/0/2/u */
    { 0x027f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/0/2/c */
    { 0x0300, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/0/3/u */
    { 0x037f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/0/3/c */
    { 0x0400, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/1/0/u */
    { 0x047f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/1/0/c */
    { 0x0500, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/1/1/u */
    { 0x057f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/1/1/c */
    { 0x0600, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/1/2/u */
    { 0x067f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/1/2/c */
    { 0x0700, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/1/3/u */
    { 0x077f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/1/3/c */
    { 0x0800, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/2/0/u */
    { 0x087f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/2/0/c */
    { 0x0900, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/2/1/u */
    { 0x097f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/2/1/c */
    { 0x0a00, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/2/2/u */
    { 0x0a7f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/2/2/c */
    { 0x0b00, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/2/3/u */
    { 0x0b7f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/2/3/c */
    { 0x0c00, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/3/0/u */
    { 0x0c7f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/3/0/c */
    { 0x0d00, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/3/1/u */
    { 0x0d7f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/3/1/c */
    { 0x0e00, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/3/2/u */
    { 0x0e7f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/3/2/c */
    { 0x0f00, 0x7911, 0xf981, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767) }, /* #43/3/3/u */
    { 0x0f7f, 0x7911, 0x7901, RTFLOAT80U_INIT_C(0,0x80000000979f81df,32767), RTFLOAT64U_INIT_C(1,0x1185a4cd963a8,675), RTFLOAT80U_INIT_C(0,0xc0000000979f81df,32767) }, /* #43/3/3/c */
    { 0x0000, 0x66e0, 0xfea0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f170000000000,9681) }, /* #44/0/0/u */
    { 0x007f, 0x66e0, 0x7e20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f170000000000,9681) }, /* #44/0/0/c */
    { 0x0100, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/0/1/u */
    { 0x017f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/0/1/c */
    { 0x0200, 0x66e0, 0xfea0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf9000,9681) }, /* #44/0/2/u */
    { 0x027f, 0x66e0, 0x7e20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf9000,9681) }, /* #44/0/2/c */
    { 0x0300, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/0/3/u */
    { 0x037f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/0/3/c */
    { 0x0400, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f160000000000,9681) }, /* #44/1/0/u */
    { 0x047f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f160000000000,9681) }, /* #44/1/0/c */
    { 0x0500, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/1/1/u */
    { 0x057f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/1/1/c */
    { 0x0600, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8800,9681) }, /* #44/1/2/u */
    { 0x067f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8800,9681) }, /* #44/1/2/c */
    { 0x0700, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/1/3/u */
    { 0x077f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/1/3/c */
    { 0x0800, 0x66e0, 0xfea0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f170000000000,9681) }, /* #44/2/0/u */
    { 0x087f, 0x66e0, 0x7e20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f170000000000,9681) }, /* #44/2/0/c */
    { 0x0900, 0x66e0, 0xfea0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbf,9681) }, /* #44/2/1/u */
    { 0x097f, 0x66e0, 0x7e20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbf,9681) }, /* #44/2/1/c */
    { 0x0a00, 0x66e0, 0xfea0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf9000,9681) }, /* #44/2/2/u */
    { 0x0a7f, 0x66e0, 0x7e20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf9000,9681) }, /* #44/2/2/c */
    { 0x0b00, 0x66e0, 0xfea0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbf,9681) }, /* #44/2/3/u */
    { 0x0b7f, 0x66e0, 0x7e20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbf,9681) }, /* #44/2/3/c */
    { 0x0c00, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f160000000000,9681) }, /* #44/3/0/u */
    { 0x0c7f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f160000000000,9681) }, /* #44/3/0/c */
    { 0x0d00, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/3/1/u */
    { 0x0d7f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/3/1/c */
    { 0x0e00, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8800,9681) }, /* #44/3/2/u */
    { 0x0e7f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8800,9681) }, /* #44/3/2/c */
    { 0x0f00, 0x66e0, 0xfca0, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/3/3/u */
    { 0x0f7f, 0x66e0, 0x7c20, RTFLOAT80U_INIT_C(1,0x8ce816d2904f6e08,9840), RTFLOAT64U_INIT_C(1,0x76b5b7bac9f76,864), RTFLOAT80U_INIT_C(0,0xce3f169079cf8fbe,9681) }, /* #44/3/3/c */
    { 0x0000, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e950000000000,24227) }, /* #45/0/0/u */
    { 0x007f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/0/0/c */
    { 0x0100, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b49,24227) }, /* #45/0/1/u */
    { 0x017f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/0/1/c */
    { 0x0200, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940800,24227) }, /* #45/0/2/u */
    { 0x027f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/0/2/c */
    { 0x0300, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b49,24227) }, /* #45/0/3/u */
    { 0x037f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/0/3/c */
    { 0x0400, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e940000000000,24227) }, /* #45/1/0/u */
    { 0x047f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/1/0/c */
    { 0x0500, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b48,24227) }, /* #45/1/1/u */
    { 0x057f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/1/1/c */
    { 0x0600, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940800,24227) }, /* #45/1/2/u */
    { 0x067f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/1/2/c */
    { 0x0700, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b48,24227) }, /* #45/1/3/u */
    { 0x077f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/1/3/c */
    { 0x0800, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e950000000000,24227) }, /* #45/2/0/u */
    { 0x087f, 0xbad7, 0x3a30, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x10000000000,0) }, /* #45/2/0/c */
    { 0x0900, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b49,24227) }, /* #45/2/1/u */
    { 0x097f, 0xbad7, 0x3a30, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x1,0) }, /* #45/2/1/c */
    { 0x0a00, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384941000,24227) }, /* #45/2/2/u */
    { 0x0a7f, 0xbad7, 0x3a30, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x800,0) }, /* #45/2/2/c */
    { 0x0b00, 0xbad7, 0xbab0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b49,24227) }, /* #45/2/3/u */
    { 0x0b7f, 0xbad7, 0x3a30, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x1,0) }, /* #45/2/3/c */
    { 0x0c00, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e940000000000,24227) }, /* #45/3/0/u */
    { 0x0c7f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/3/0/c */
    { 0x0d00, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b48,24227) }, /* #45/3/1/u */
    { 0x0d7f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/3/1/c */
    { 0x0e00, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940800,24227) }, /* #45/3/2/u */
    { 0x0e7f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/3/2/c */
    { 0x0f00, 0xbad7, 0xb8b0, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0xc87e94f384940b48,24227) }, /* #45/3/3/u */
    { 0x0f7f, 0xbad7, 0x3830, RTFLOAT80U_INIT_C(1,0xd1e9e2912fa765be,351), RTFLOAT64U_INIT_C(1,0xe9069801dd177,322), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #45/3/3/c */
    { 0x0000, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/0/0/u */
    { 0x007f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/0/c */
    { 0x0100, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/0/1/u */
    { 0x017f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/1/c */
    { 0x0200, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/0/2/u */
    { 0x027f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/2/c */
    { 0x0300, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/0/3/u */
    { 0x037f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/3/c */
    { 0x0400, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/1/0/u */
    { 0x047f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/0/c */
    { 0x0500, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/1/1/u */
    { 0x057f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/1/c */
    { 0x0600, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/1/2/u */
    { 0x067f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/2/c */
    { 0x0700, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/1/3/u */
    { 0x077f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/3/c */
    { 0x0800, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/2/0/u */
    { 0x087f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/0/c */
    { 0x0900, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/2/1/u */
    { 0x097f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/1/c */
    { 0x0a00, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/2/2/u */
    { 0x0a7f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/2/c */
    { 0x0b00, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/2/3/u */
    { 0x0b7f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/3/c */
    { 0x0c00, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/3/0/u */
    { 0x0c7f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/0/c */
    { 0x0d00, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/3/1/u */
    { 0x0d7f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/1/c */
    { 0x0e00, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/3/2/u */
    { 0x0e7f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/2/c */
    { 0x0f00, 0x8222, 0xb881, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933) }, /* #46/3/3/u */
    { 0x0f7f, 0x8222, 0x3801, RTFLOAT80U_INIT_C(1,0x11dfa04bcc617bbb,10933), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/3/c */
    { 0x0000, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/0/0/u */
    { 0x007f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/0/0/c */
    { 0x0100, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/0/1/u */
    { 0x017f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/0/1/c */
    { 0x0200, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/0/2/u */
    { 0x027f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/0/2/c */
    { 0x0300, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/0/3/u */
    { 0x037f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/0/3/c */
    { 0x0400, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/1/0/u */
    { 0x047f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/1/0/c */
    { 0x0500, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/1/1/u */
    { 0x057f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/1/1/c */
    { 0x0600, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/1/2/u */
    { 0x067f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/1/2/c */
    { 0x0700, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/1/3/u */
    { 0x077f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/1/3/c */
    { 0x0800, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/2/0/u */
    { 0x087f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/2/0/c */
    { 0x0900, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/2/1/u */
    { 0x097f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/2/1/c */
    { 0x0a00, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/2/2/u */
    { 0x0a7f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/2/2/c */
    { 0x0b00, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/2/3/u */
    { 0x0b7f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/2/3/c */
    { 0x0c00, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/3/0/u */
    { 0x0c7f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/3/0/c */
    { 0x0d00, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/3/1/u */
    { 0x0d7f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/3/1/c */
    { 0x0e00, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/3/2/u */
    { 0x0e7f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/3/2/c */
    { 0x0f00, 0xe69f, 0xfc81, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637) }, /* #47/3/3/u */
    { 0x0f7f, 0xe69f, 0x7c01, RTFLOAT80U_INIT_C(1,0x323ee9c5d1bef1ba,14637), RTFLOAT64U_INIT_C(0,0x1ec1b204d6d24,812), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #47/3/3/c */
    { 0x0000, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/0/0/u */
    { 0x007f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/0/c */
    { 0x0100, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/0/1/u */
    { 0x017f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/1/c */
    { 0x0200, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/0/2/u */
    { 0x027f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/2/c */
    { 0x0300, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/0/3/u */
    { 0x037f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/0/3/c */
    { 0x0400, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/1/0/u */
    { 0x047f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/0/c */
    { 0x0500, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/1/1/u */
    { 0x057f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/1/c */
    { 0x0600, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/1/2/u */
    { 0x067f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/2/c */
    { 0x0700, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/1/3/u */
    { 0x077f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/1/3/c */
    { 0x0800, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/2/0/u */
    { 0x087f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/0/c */
    { 0x0900, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/2/1/u */
    { 0x097f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/1/c */
    { 0x0a00, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/2/2/u */
    { 0x0a7f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/2/c */
    { 0x0b00, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/2/3/u */
    { 0x0b7f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/2/3/c */
    { 0x0c00, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/3/0/u */
    { 0x0c7f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/0/c */
    { 0x0d00, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/3/1/u */
    { 0x0d7f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/1/c */
    { 0x0e00, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/3/2/u */
    { 0x0e7f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/2/c */
    { 0x0f00, 0xb495, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767) }, /* #48/3/3/u */
    { 0x0f7f, 0xb495, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000000000001f0c,32767), RTFLOAT64U_INIT_C(1,0x0,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #48/3/3/c */
    { 0x0000, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/0/0/u */
    { 0x007f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/0/c */
    { 0x0100, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/0/1/u */
    { 0x017f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/1/c */
    { 0x0200, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/0/2/u */
    { 0x027f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/2/c */
    { 0x0300, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/0/3/u */
    { 0x037f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/3/c */
    { 0x0400, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/1/0/u */
    { 0x047f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/0/c */
    { 0x0500, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/1/1/u */
    { 0x057f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/1/c */
    { 0x0600, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/1/2/u */
    { 0x067f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/2/c */
    { 0x0700, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/1/3/u */
    { 0x077f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/3/c */
    { 0x0800, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/2/0/u */
    { 0x087f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/0/c */
    { 0x0900, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/2/1/u */
    { 0x097f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/1/c */
    { 0x0a00, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/2/2/u */
    { 0x0a7f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/2/c */
    { 0x0b00, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/2/3/u */
    { 0x0b7f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/3/c */
    { 0x0c00, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/3/0/u */
    { 0x0c7f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/0/c */
    { 0x0d00, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/3/1/u */
    { 0x0d7f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/1/c */
    { 0x0e00, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/3/2/u */
    { 0x0e7f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/2/c */
    { 0x0f00, 0xd6ea, 0xfc81, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767) }, /* #49/3/3/u */
    { 0x0f7f, 0xd6ea, 0x7c01, RTFLOAT80U_INIT_C(0,0x400018b9e2e4e64a,32767), RTFLOAT64U_INIT_C(1,0xd6a69bc36b6aa,1164), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/3/c */
    { 0x0000, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/0/u */
    { 0x007f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/0/c */
    { 0x0100, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/1/u */
    { 0x017f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/1/c */
    { 0x0200, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/2/u */
    { 0x027f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/2/c */
    { 0x0300, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/3/u */
    { 0x037f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/0/3/c */
    { 0x0400, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/0/u */
    { 0x047f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/0/c */
    { 0x0500, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/1/u */
    { 0x057f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/1/c */
    { 0x0600, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/2/u */
    { 0x067f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/2/c */
    { 0x0700, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/3/u */
    { 0x077f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/1/3/c */
    { 0x0800, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/0/u */
    { 0x087f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/0/c */
    { 0x0900, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/1/u */
    { 0x097f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/1/c */
    { 0x0a00, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/2/u */
    { 0x0a7f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/2/c */
    { 0x0b00, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/3/u */
    { 0x0b7f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/2/3/c */
    { 0x0c00, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/0/u */
    { 0x0c7f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/0/c */
    { 0x0d00, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/1/u */
    { 0x0d7f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/1/c */
    { 0x0e00, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/2/u */
    { 0x0e7f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/2/c */
    { 0x0f00, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/3/u */
    { 0x0f7f, 0xbedd, 0x3c00, RTFLOAT80U_INIT_C(0,0xbb8b2019bb68d719,5021), RTFLOAT64U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #50/3/3/c */
    { 0x0000, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e0000000000,32698) }, /* #51/0/0/u */
    { 0x007f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e0000000000,32698) }, /* #51/0/0/c */
    { 0x0100, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/0/1/u */
    { 0x017f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/0/1/c */
    { 0x0200, 0x8c9e, 0xbea0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/0/2/u */
    { 0x027f, 0x8c9e, 0x3e20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/0/2/c */
    { 0x0300, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/0/3/u */
    { 0x037f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/0/3/c */
    { 0x0400, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e0000000000,32698) }, /* #51/1/0/u */
    { 0x047f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e0000000000,32698) }, /* #51/1/0/c */
    { 0x0500, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/1/1/u */
    { 0x057f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/1/1/c */
    { 0x0600, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669000,32698) }, /* #51/1/2/u */
    { 0x067f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669000,32698) }, /* #51/1/2/c */
    { 0x0700, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/1/3/u */
    { 0x077f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/1/3/c */
    { 0x0800, 0x8c9e, 0xbea0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3f0000000000,32698) }, /* #51/2/0/u */
    { 0x087f, 0x8c9e, 0x3e20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3f0000000000,32698) }, /* #51/2/0/c */
    { 0x0900, 0x8c9e, 0xbea0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/2/1/u */
    { 0x097f, 0x8c9e, 0x3e20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/2/1/c */
    { 0x0a00, 0x8c9e, 0xbea0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/2/2/u */
    { 0x0a7f, 0x8c9e, 0x3e20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/2/2/c */
    { 0x0b00, 0x8c9e, 0xbea0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/2/3/u */
    { 0x0b7f, 0x8c9e, 0x3e20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669800,32698) }, /* #51/2/3/c */
    { 0x0c00, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e0000000000,32698) }, /* #51/3/0/u */
    { 0x0c7f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e0000000000,32698) }, /* #51/3/0/c */
    { 0x0d00, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/3/1/u */
    { 0x0d7f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/3/1/c */
    { 0x0e00, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669000,32698) }, /* #51/3/2/u */
    { 0x0e7f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d6669000,32698) }, /* #51/3/2/c */
    { 0x0f00, 0x8c9e, 0xbca0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/3/3/u */
    { 0x0f7f, 0x8c9e, 0x3c20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32758), RTFLOAT64U_INIT_C(0,0xbd9e7c0baccd3,962), RTFLOAT80U_INIT_C(0,0xdecf3e05d66697ff,32698) }, /* #51/3/3/c */
    { 0x0000, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/0/0/u */
    { 0x007f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/0/c */
    { 0x0100, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/0/1/u */
    { 0x017f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/1/c */
    { 0x0200, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/0/2/u */
    { 0x027f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/2/c */
    { 0x0300, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/0/3/u */
    { 0x037f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/0/3/c */
    { 0x0400, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/1/0/u */
    { 0x047f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/0/c */
    { 0x0500, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/1/1/u */
    { 0x057f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/1/c */
    { 0x0600, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/1/2/u */
    { 0x067f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/2/c */
    { 0x0700, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/1/3/u */
    { 0x077f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/1/3/c */
    { 0x0800, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/2/0/u */
    { 0x087f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/0/c */
    { 0x0900, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/2/1/u */
    { 0x097f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/1/c */
    { 0x0a00, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/2/2/u */
    { 0x0a7f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/2/c */
    { 0x0b00, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/2/3/u */
    { 0x0b7f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/2/3/c */
    { 0x0c00, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/3/0/u */
    { 0x0c7f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/0/c */
    { 0x0d00, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/3/1/u */
    { 0x0d7f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/1/c */
    { 0x0e00, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/3/2/u */
    { 0x0e7f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/2/c */
    { 0x0f00, 0x35c4, 0xbd81, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472) }, /* #52/3/3/u */
    { 0x0f7f, 0x35c4, 0x3d01, RTFLOAT80U_INIT_C(1,0x1a5a09eb24866a91,31472), RTFLOAT64U_INIT_C(1,0x3b83d5e8c06dc,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #52/3/3/c */
    { 0x0000, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/0/0/u */
    { 0x007f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac5a00000000000,450) }, /* #53/0/0/c */
    { 0x0100, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/0/1/u */
    { 0x017f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74cb,450) }, /* #53/0/1/c */
    { 0x0200, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/0/2/u */
    { 0x027f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a7800,450) }, /* #53/0/2/c */
    { 0x0300, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/0/3/u */
    { 0x037f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74cb,450) }, /* #53/0/3/c */
    { 0x0400, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/1/0/u */
    { 0x047f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac5a00000000000,450) }, /* #53/1/0/c */
    { 0x0500, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/1/1/u */
    { 0x057f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74cb,450) }, /* #53/1/1/c */
    { 0x0600, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/1/2/u */
    { 0x067f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a7800,450) }, /* #53/1/2/c */
    { 0x0700, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/1/3/u */
    { 0x077f, 0xdec4, 0x7e22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74cb,450) }, /* #53/1/3/c */
    { 0x0800, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/2/0/u */
    { 0x087f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59f0000000000,450) }, /* #53/2/0/c */
    { 0x0900, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/2/1/u */
    { 0x097f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74ca,450) }, /* #53/2/1/c */
    { 0x0a00, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/2/2/u */
    { 0x0a7f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a7000,450) }, /* #53/2/2/c */
    { 0x0b00, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/2/3/u */
    { 0x0b7f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74ca,450) }, /* #53/2/3/c */
    { 0x0c00, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/3/0/u */
    { 0x0c7f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59f0000000000,450) }, /* #53/3/0/c */
    { 0x0d00, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/3/1/u */
    { 0x0d7f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74ca,450) }, /* #53/3/1/c */
    { 0x0e00, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/3/2/u */
    { 0x0e7f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a7000,450) }, /* #53/3/2/c */
    { 0x0f00, 0xdec4, 0xfc82, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0) }, /* #53/3/3/u */
    { 0x0f7f, 0xdec4, 0x7c22, RTFLOAT80U_INIT_C(0,0x2c5f1ed4f8296,0), RTFLOAT64U_INIT_C(1,0x52a07da41e736,1486), RTFLOAT80U_INIT_C(1,0xeac59fbd641a74ca,450) }, /* #53/3/3/c */
    { 0x0000, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/0/0/u */
    { 0x007f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/0/0/c */
    { 0x0100, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/0/1/u */
    { 0x017f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/0/1/c */
    { 0x0200, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/0/2/u */
    { 0x027f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/0/2/c */
    { 0x0300, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/0/3/u */
    { 0x037f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/0/3/c */
    { 0x0400, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/1/0/u */
    { 0x047f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/1/0/c */
    { 0x0500, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/1/1/u */
    { 0x057f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/1/1/c */
    { 0x0600, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/1/2/u */
    { 0x067f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/1/2/c */
    { 0x0700, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/1/3/u */
    { 0x077f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/1/3/c */
    { 0x0800, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/2/0/u */
    { 0x087f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/2/0/c */
    { 0x0900, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/2/1/u */
    { 0x097f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/2/1/c */
    { 0x0a00, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/2/2/u */
    { 0x0a7f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/2/2/c */
    { 0x0b00, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/2/3/u */
    { 0x0b7f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/2/3/c */
    { 0x0c00, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/3/0/u */
    { 0x0c7f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/3/0/c */
    { 0x0d00, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/3/1/u */
    { 0x0d7f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/3/1/c */
    { 0x0e00, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/3/2/u */
    { 0x0e7f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/3/2/c */
    { 0x0f00, 0xfc0b, 0xfc81, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #54/3/3/u */
    { 0x0f7f, 0xfc0b, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT64U_INIT_C(1,0x13c6288a50adb,2047), RTFLOAT80U_INIT_C(1,0xc9e314452856d800,32767) }, /* #54/3/3/c */
    { 0x0000, 0xf7eb, 0xffa0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd60000000000,21368) }, /* #55/0/0/u */
    { 0x007f, 0xf7eb, 0x7f20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd60000000000,21368) }, /* #55/0/0/c */
    { 0x0100, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/0/1/u */
    { 0x017f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/0/1/c */
    { 0x0200, 0xf7eb, 0xffa0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a18000,21368) }, /* #55/0/2/u */
    { 0x027f, 0xf7eb, 0x7f20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a18000,21368) }, /* #55/0/2/c */
    { 0x0300, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/0/3/u */
    { 0x037f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/0/3/c */
    { 0x0400, 0xf7eb, 0xffa0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd60000000000,21368) }, /* #55/1/0/u */
    { 0x047f, 0xf7eb, 0x7f20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd60000000000,21368) }, /* #55/1/0/c */
    { 0x0500, 0xf7eb, 0xffa0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8c,21368) }, /* #55/1/1/u */
    { 0x057f, 0xf7eb, 0x7f20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8c,21368) }, /* #55/1/1/c */
    { 0x0600, 0xf7eb, 0xffa0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a18000,21368) }, /* #55/1/2/u */
    { 0x067f, 0xf7eb, 0x7f20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a18000,21368) }, /* #55/1/2/c */
    { 0x0700, 0xf7eb, 0xffa0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8c,21368) }, /* #55/1/3/u */
    { 0x077f, 0xf7eb, 0x7f20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8c,21368) }, /* #55/1/3/c */
    { 0x0800, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd50000000000,21368) }, /* #55/2/0/u */
    { 0x087f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd50000000000,21368) }, /* #55/2/0/c */
    { 0x0900, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/2/1/u */
    { 0x097f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/2/1/c */
    { 0x0a00, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17800,21368) }, /* #55/2/2/u */
    { 0x0a7f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17800,21368) }, /* #55/2/2/c */
    { 0x0b00, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/2/3/u */
    { 0x0b7f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/2/3/c */
    { 0x0c00, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd50000000000,21368) }, /* #55/3/0/u */
    { 0x0c7f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd50000000000,21368) }, /* #55/3/0/c */
    { 0x0d00, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/3/1/u */
    { 0x0d7f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/3/1/c */
    { 0x0e00, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17800,21368) }, /* #55/3/2/u */
    { 0x0e7f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17800,21368) }, /* #55/3/2/c */
    { 0x0f00, 0xf7eb, 0xfda0, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/3/3/u */
    { 0x0f7f, 0xf7eb, 0x7d20, RTFLOAT80U_INIT_C(0,0xb33d64527eae9d16,21304), RTFLOAT64U_INIT_C(1,0xb588ed6fde5d9,1086), RTFLOAT80U_INIT_C(1,0x992bd58e23a17e8b,21368) }, /* #55/3/3/c */
    { 0x0000, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/0/0/u */
    { 0x007f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/0/0/c */
    { 0x0100, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/0/1/u */
    { 0x017f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/0/1/c */
    { 0x0200, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/0/2/u */
    { 0x027f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/0/2/c */
    { 0x0300, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/0/3/u */
    { 0x037f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/0/3/c */
    { 0x0400, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/1/0/u */
    { 0x047f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/1/0/c */
    { 0x0500, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/1/1/u */
    { 0x057f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/1/1/c */
    { 0x0600, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/1/2/u */
    { 0x067f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/1/2/c */
    { 0x0700, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/1/3/u */
    { 0x077f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/1/3/c */
    { 0x0800, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/2/0/u */
    { 0x087f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/2/0/c */
    { 0x0900, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/2/1/u */
    { 0x097f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/2/1/c */
    { 0x0a00, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/2/2/u */
    { 0x0a7f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/2/2/c */
    { 0x0b00, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/2/3/u */
    { 0x0b7f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/2/3/c */
    { 0x0c00, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/3/0/u */
    { 0x0c7f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/3/0/c */
    { 0x0d00, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/3/1/u */
    { 0x0d7f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/3/1/c */
    { 0x0e00, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/3/2/u */
    { 0x0e7f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/3/2/c */
    { 0x0f00, 0xb68f, 0xbc81, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767) }, /* #56/3/3/u */
    { 0x0f7f, 0xb68f, 0x3c01, RTFLOAT80U_INIT_C(0,0x80000000655ac6a2,32767), RTFLOAT64U_INIT_C(0,0xaba3b24f,2047), RTFLOAT80U_INIT_C(0,0xc000055d1d927800,32767) }, /* #56/3/3/c */
    { 0x0000, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd0000000000,12297) }, /* #57/0/0/u */
    { 0x007f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd0000000000,12297) }, /* #57/0/0/c */
    { 0x0100, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/0/1/u */
    { 0x017f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/0/1/c */
    { 0x0200, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2000,12297) }, /* #57/0/2/u */
    { 0x027f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2000,12297) }, /* #57/0/2/c */
    { 0x0300, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/0/3/u */
    { 0x037f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/0/3/c */
    { 0x0400, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd0000000000,12297) }, /* #57/1/0/u */
    { 0x047f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd0000000000,12297) }, /* #57/1/0/c */
    { 0x0500, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/1/1/u */
    { 0x057f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/1/1/c */
    { 0x0600, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2000,12297) }, /* #57/1/2/u */
    { 0x067f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2000,12297) }, /* #57/1/2/c */
    { 0x0700, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/1/3/u */
    { 0x077f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/1/3/c */
    { 0x0800, 0x1cc7, 0xbea0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbe0000000000,12297) }, /* #57/2/0/u */
    { 0x087f, 0x1cc7, 0x3e20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbe0000000000,12297) }, /* #57/2/0/c */
    { 0x0900, 0x1cc7, 0xbea0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201c,12297) }, /* #57/2/1/u */
    { 0x097f, 0x1cc7, 0x3e20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201c,12297) }, /* #57/2/1/c */
    { 0x0a00, 0x1cc7, 0xbea0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2800,12297) }, /* #57/2/2/u */
    { 0x0a7f, 0x1cc7, 0x3e20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2800,12297) }, /* #57/2/2/c */
    { 0x0b00, 0x1cc7, 0xbea0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201c,12297) }, /* #57/2/3/u */
    { 0x0b7f, 0x1cc7, 0x3e20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201c,12297) }, /* #57/2/3/c */
    { 0x0c00, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd0000000000,12297) }, /* #57/3/0/u */
    { 0x0c7f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd0000000000,12297) }, /* #57/3/0/c */
    { 0x0d00, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/3/1/u */
    { 0x0d7f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/3/1/c */
    { 0x0e00, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2000,12297) }, /* #57/3/2/u */
    { 0x0e7f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c2000,12297) }, /* #57/3/2/c */
    { 0x0f00, 0x1cc7, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/3/3/u */
    { 0x0f7f, 0x1cc7, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc5d9f2591142feb,12889), RTFLOAT64U_INIT_C(0,0xa4b1ba590e9f3,430), RTFLOAT80U_INIT_C(0,0xa7ebbd4be46c201b,12297) }, /* #57/3/3/c */
    { 0x0000, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71420000000000,521) }, /* #58/0/0/u */
    { 0x007f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71420000000000,521) }, /* #58/0/0/c */
    { 0x0100, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/0/1/u */
    { 0x017f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/0/1/c */
    { 0x0200, 0x78be, 0xfaa0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe800,521) }, /* #58/0/2/u */
    { 0x027f, 0x78be, 0x7a20, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe800,521) }, /* #58/0/2/c */
    { 0x0300, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/0/3/u */
    { 0x037f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/0/3/c */
    { 0x0400, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71420000000000,521) }, /* #58/1/0/u */
    { 0x047f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71420000000000,521) }, /* #58/1/0/c */
    { 0x0500, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/1/1/u */
    { 0x057f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/1/1/c */
    { 0x0600, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe000,521) }, /* #58/1/2/u */
    { 0x067f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe000,521) }, /* #58/1/2/c */
    { 0x0700, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/1/3/u */
    { 0x077f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/1/3/c */
    { 0x0800, 0x78be, 0xfaa0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71430000000000,521) }, /* #58/2/0/u */
    { 0x087f, 0x78be, 0x7a20, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71430000000000,521) }, /* #58/2/0/c */
    { 0x0900, 0x78be, 0xfaa0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44c,521) }, /* #58/2/1/u */
    { 0x097f, 0x78be, 0x7a20, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44c,521) }, /* #58/2/1/c */
    { 0x0a00, 0x78be, 0xfaa0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe800,521) }, /* #58/2/2/u */
    { 0x0a7f, 0x78be, 0x7a20, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe800,521) }, /* #58/2/2/c */
    { 0x0b00, 0x78be, 0xfaa0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44c,521) }, /* #58/2/3/u */
    { 0x0b7f, 0x78be, 0x7a20, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44c,521) }, /* #58/2/3/c */
    { 0x0c00, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71420000000000,521) }, /* #58/3/0/u */
    { 0x0c7f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71420000000000,521) }, /* #58/3/0/c */
    { 0x0d00, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/3/1/u */
    { 0x0d7f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/3/1/c */
    { 0x0e00, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe000,521) }, /* #58/3/2/u */
    { 0x0e7f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe000,521) }, /* #58/3/2/c */
    { 0x0f00, 0x78be, 0xf8a0, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/3/3/u */
    { 0x0f7f, 0x78be, 0x7820, RTFLOAT80U_INIT_C(0,0xc972a9d174356a87,1284), RTFLOAT64U_INIT_C(0,0x29edeee90c691,260), RTFLOAT80U_INIT_C(0,0xea71422b33bbe44b,521) }, /* #58/3/3/c */
    { 0x0000, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/0/u */
    { 0x007f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/0/c */
    { 0x0100, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/1/u */
    { 0x017f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/1/c */
    { 0x0200, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/2/u */
    { 0x027f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/2/c */
    { 0x0300, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/3/u */
    { 0x037f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/0/3/c */
    { 0x0400, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/0/u */
    { 0x047f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/0/c */
    { 0x0500, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/1/u */
    { 0x057f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/1/c */
    { 0x0600, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/2/u */
    { 0x067f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/2/c */
    { 0x0700, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/3/u */
    { 0x077f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/1/3/c */
    { 0x0800, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/0/u */
    { 0x087f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/0/c */
    { 0x0900, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/1/u */
    { 0x097f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/1/c */
    { 0x0a00, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/2/u */
    { 0x0a7f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/2/c */
    { 0x0b00, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/3/u */
    { 0x0b7f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/2/3/c */
    { 0x0c00, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/0/u */
    { 0x0c7f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/0/c */
    { 0x0d00, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/1/u */
    { 0x0d7f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/1/c */
    { 0x0e00, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/2/u */
    { 0x0e7f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/2/c */
    { 0x0f00, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/3/u */
    { 0x0f7f, 0xe317, 0x7900, RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767), RTFLOAT64U_INIT_C(1,0x4d847809e56e8,703), RTFLOAT80U_INIT_C(1,0xc0000000000039e2,32767) }, /* #59/3/3/c */
    { 0x0000, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/0/0/u */
    { 0x007f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/0/c */
    { 0x0100, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/0/1/u */
    { 0x017f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/1/c */
    { 0x0200, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/0/2/u */
    { 0x027f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/2/c */
    { 0x0300, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/0/3/u */
    { 0x037f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/0/3/c */
    { 0x0400, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/1/0/u */
    { 0x047f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/0/c */
    { 0x0500, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/1/1/u */
    { 0x057f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/1/c */
    { 0x0600, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/1/2/u */
    { 0x067f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/2/c */
    { 0x0700, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/1/3/u */
    { 0x077f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/1/3/c */
    { 0x0800, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/2/0/u */
    { 0x087f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/0/c */
    { 0x0900, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/2/1/u */
    { 0x097f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/1/c */
    { 0x0a00, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/2/2/u */
    { 0x0a7f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/2/c */
    { 0x0b00, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/2/3/u */
    { 0x0b7f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/2/3/c */
    { 0x0c00, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/3/0/u */
    { 0x0c7f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/0/c */
    { 0x0d00, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/3/1/u */
    { 0x0d7f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/1/c */
    { 0x0e00, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/3/2/u */
    { 0x0e7f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/2/c */
    { 0x0f00, 0xb201, 0xb881, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422) }, /* #60/3/3/u */
    { 0x0f7f, 0xb201, 0x3801, RTFLOAT80U_INIT_C(0,0x48d931d3cef613dc,27422), RTFLOAT64U_INIT_C(1,0xa64a757154773,1137), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #60/3/3/c */
    { 0x0000, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/0/0/u */
    { 0x007f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/0/0/c */
    { 0x0100, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/0/1/u */
    { 0x017f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/0/1/c */
    { 0x0200, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/0/2/u */
    { 0x027f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/0/2/c */
    { 0x0300, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/0/3/u */
    { 0x037f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/0/3/c */
    { 0x0400, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/1/0/u */
    { 0x047f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/1/0/c */
    { 0x0500, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/1/1/u */
    { 0x057f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/1/1/c */
    { 0x0600, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/1/2/u */
    { 0x067f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/1/2/c */
    { 0x0700, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/1/3/u */
    { 0x077f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/1/3/c */
    { 0x0800, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/2/0/u */
    { 0x087f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/2/0/c */
    { 0x0900, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/2/1/u */
    { 0x097f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/2/1/c */
    { 0x0a00, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/2/2/u */
    { 0x0a7f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/2/2/c */
    { 0x0b00, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/2/3/u */
    { 0x0b7f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/2/3/c */
    { 0x0c00, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/3/0/u */
    { 0x0c7f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/3/0/c */
    { 0x0d00, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/3/1/u */
    { 0x0d7f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/3/1/c */
    { 0x0e00, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/3/2/u */
    { 0x0e7f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/3/2/c */
    { 0x0f00, 0x1ce5, 0xbc81, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602) }, /* #61/3/3/u */
    { 0x0f7f, 0x1ce5, 0x3c01, RTFLOAT80U_INIT_C(1,0xbf0fbaff9158adf8,8602), RTFLOAT64U_INIT_C(1,0x5e,2047), RTFLOAT80U_INIT_C(1,0xc00000000002f000,32767) }, /* #61/3/3/c */
    { 0x0000, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d80000000000,9418) }, /* #62/0/0/u */
    { 0x007f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d80000000000,9418) }, /* #62/0/0/c */
    { 0x0100, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/0/1/u */
    { 0x017f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/0/1/c */
    { 0x0200, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdd000,9418) }, /* #62/0/2/u */
    { 0x027f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdd000,9418) }, /* #62/0/2/c */
    { 0x0300, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/0/3/u */
    { 0x037f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/0/3/c */
    { 0x0400, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d90000000000,9418) }, /* #62/1/0/u */
    { 0x047f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d90000000000,9418) }, /* #62/1/0/c */
    { 0x0500, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/1/1/u */
    { 0x057f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/1/1/c */
    { 0x0600, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdd000,9418) }, /* #62/1/2/u */
    { 0x067f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdd000,9418) }, /* #62/1/2/c */
    { 0x0700, 0x5911, 0xfba0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/1/3/u */
    { 0x077f, 0x5911, 0x7b20, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce1,9418) }, /* #62/1/3/c */
    { 0x0800, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d80000000000,9418) }, /* #62/2/0/u */
    { 0x087f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d80000000000,9418) }, /* #62/2/0/c */
    { 0x0900, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/2/1/u */
    { 0x097f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/2/1/c */
    { 0x0a00, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdc800,9418) }, /* #62/2/2/u */
    { 0x0a7f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdc800,9418) }, /* #62/2/2/c */
    { 0x0b00, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/2/3/u */
    { 0x0b7f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/2/3/c */
    { 0x0c00, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d80000000000,9418) }, /* #62/3/0/u */
    { 0x0c7f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d80000000000,9418) }, /* #62/3/0/c */
    { 0x0d00, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/3/1/u */
    { 0x0d7f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/3/1/c */
    { 0x0e00, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdc800,9418) }, /* #62/3/2/u */
    { 0x0e7f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdc800,9418) }, /* #62/3/2/c */
    { 0x0f00, 0x5911, 0xf9a0, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/3/3/u */
    { 0x0f7f, 0x5911, 0x7920, RTFLOAT80U_INIT_C(1,0xb70cb18773aad74b,9880), RTFLOAT64U_INIT_C(0,0xa15c52915196c,560), RTFLOAT80U_INIT_C(1,0x9536d863b4bdcce0,9418) }, /* #62/3/3/c */
    { 0x0000, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/0/u */
    { 0x007f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/0/c */
    { 0x0100, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/1/u */
    { 0x017f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/1/c */
    { 0x0200, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/2/u */
    { 0x027f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/2/c */
    { 0x0300, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/3/u */
    { 0x037f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/0/3/c */
    { 0x0400, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/0/u */
    { 0x047f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/0/c */
    { 0x0500, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/1/u */
    { 0x057f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/1/c */
    { 0x0600, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/2/u */
    { 0x067f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/2/c */
    { 0x0700, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/3/u */
    { 0x077f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/1/3/c */
    { 0x0800, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/0/u */
    { 0x087f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/0/c */
    { 0x0900, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/1/u */
    { 0x097f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/1/c */
    { 0x0a00, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/2/u */
    { 0x0a7f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/2/c */
    { 0x0b00, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/3/u */
    { 0x0b7f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/2/3/c */
    { 0x0c00, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/0/u */
    { 0x0c7f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/0/c */
    { 0x0d00, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/1/u */
    { 0x0d7f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/1/c */
    { 0x0e00, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/2/u */
    { 0x0e7f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/2/c */
    { 0x0f00, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/3/u */
    { 0x0f7f, 0x7dfa, 0x7d00, RTFLOAT80U_INIT_C(0,0xb505d47ff59ed2f8,645), RTFLOAT64U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #63/3/3/c */
    { 0x0000, 0x95b9, 0xbfa0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1b0000000000,9195) }, /* #64/0/0/u */
    { 0x007f, 0x95b9, 0x3f20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1b0000000000,9195) }, /* #64/0/0/c */
    { 0x0100, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/0/1/u */
    { 0x017f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/0/1/c */
    { 0x0200, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854000,9195) }, /* #64/0/2/u */
    { 0x027f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854000,9195) }, /* #64/0/2/c */
    { 0x0300, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/0/3/u */
    { 0x037f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/0/3/c */
    { 0x0400, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1a0000000000,9195) }, /* #64/1/0/u */
    { 0x047f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1a0000000000,9195) }, /* #64/1/0/c */
    { 0x0500, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/1/1/u */
    { 0x057f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/1/1/c */
    { 0x0600, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854000,9195) }, /* #64/1/2/u */
    { 0x067f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854000,9195) }, /* #64/1/2/c */
    { 0x0700, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/1/3/u */
    { 0x077f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/1/3/c */
    { 0x0800, 0x95b9, 0xbfa0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1b0000000000,9195) }, /* #64/2/0/u */
    { 0x087f, 0x95b9, 0x3f20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1b0000000000,9195) }, /* #64/2/0/c */
    { 0x0900, 0x95b9, 0xbfa0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854264,9195) }, /* #64/2/1/u */
    { 0x097f, 0x95b9, 0x3f20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854264,9195) }, /* #64/2/1/c */
    { 0x0a00, 0x95b9, 0xbfa0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854800,9195) }, /* #64/2/2/u */
    { 0x0a7f, 0x95b9, 0x3f20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854800,9195) }, /* #64/2/2/c */
    { 0x0b00, 0x95b9, 0xbfa0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854264,9195) }, /* #64/2/3/u */
    { 0x0b7f, 0x95b9, 0x3f20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854264,9195) }, /* #64/2/3/c */
    { 0x0c00, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1a0000000000,9195) }, /* #64/3/0/u */
    { 0x0c7f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1a0000000000,9195) }, /* #64/3/0/c */
    { 0x0d00, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/3/1/u */
    { 0x0d7f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/3/1/c */
    { 0x0e00, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854000,9195) }, /* #64/3/2/u */
    { 0x0e7f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854000,9195) }, /* #64/3/2/c */
    { 0x0f00, 0x95b9, 0xbda0, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/3/3/u */
    { 0x0f7f, 0x95b9, 0x3d20, RTFLOAT80U_INIT_C(1,0xed8fdd342ed98a27,9638), RTFLOAT64U_INIT_C(1,0x71dbaa2e71494,579), RTFLOAT80U_INIT_C(0,0xab9c1aeb8a854263,9195) }, /* #64/3/3/c */
    { 0x0000, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/0/u */
    { 0x007f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/0/c */
    { 0x0100, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/1/u */
    { 0x017f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/1/c */
    { 0x0200, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/2/u */
    { 0x027f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/2/c */
    { 0x0300, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/3/u */
    { 0x037f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/3/c */
    { 0x0400, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/0/u */
    { 0x047f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/0/c */
    { 0x0500, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/1/u */
    { 0x057f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/1/c */
    { 0x0600, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/2/u */
    { 0x067f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/2/c */
    { 0x0700, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/3/u */
    { 0x077f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/3/c */
    { 0x0800, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/0/u */
    { 0x087f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/0/c */
    { 0x0900, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/1/u */
    { 0x097f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/1/c */
    { 0x0a00, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/2/u */
    { 0x0a7f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/2/c */
    { 0x0b00, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/3/u */
    { 0x0b7f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/3/c */
    { 0x0c00, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/0/u */
    { 0x0c7f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/0/c */
    { 0x0d00, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/1/u */
    { 0x0d7f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/1/c */
    { 0x0e00, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/2/u */
    { 0x0e7f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/2/c */
    { 0x0f00, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/3/u */
    { 0x0f7f, 0xc350, 0x7900, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(1,0x6d416ac038ab0,1587), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/3/c */
    { 0x0000, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/0/0/u */
    { 0x007f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/0/c */
    { 0x0100, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/0/1/u */
    { 0x017f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/1/c */
    { 0x0200, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/0/2/u */
    { 0x027f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/2/c */
    { 0x0300, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/0/3/u */
    { 0x037f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/3/c */
    { 0x0400, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/1/0/u */
    { 0x047f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/0/c */
    { 0x0500, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/1/1/u */
    { 0x057f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/1/c */
    { 0x0600, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/1/2/u */
    { 0x067f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/2/c */
    { 0x0700, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/1/3/u */
    { 0x077f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/3/c */
    { 0x0800, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/2/0/u */
    { 0x087f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/0/c */
    { 0x0900, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/2/1/u */
    { 0x097f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/1/c */
    { 0x0a00, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/2/2/u */
    { 0x0a7f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/2/c */
    { 0x0b00, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/2/3/u */
    { 0x0b7f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/3/c */
    { 0x0c00, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/3/0/u */
    { 0x0c7f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/0/c */
    { 0x0d00, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/3/1/u */
    { 0x0d7f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/1/c */
    { 0x0e00, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/3/2/u */
    { 0x0e7f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/2/c */
    { 0x0f00, 0x0889, 0xb881, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767) }, /* #66/3/3/u */
    { 0x0f7f, 0x0889, 0x3801, RTFLOAT80U_INIT_C(0,0x7abda763d2961c94,32767), RTFLOAT64U_INIT_C(0,0x7844bb26e29e3,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/3/c */
    { 0x0000, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb60000000000,13182) }, /* #67/0/0/u */
    { 0x007f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb60000000000,13182) }, /* #67/0/0/c */
    { 0x0100, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/0/1/u */
    { 0x017f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/0/1/c */
    { 0x0200, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b000,13182) }, /* #67/0/2/u */
    { 0x027f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b000,13182) }, /* #67/0/2/c */
    { 0x0300, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/0/3/u */
    { 0x037f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/0/3/c */
    { 0x0400, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb60000000000,13182) }, /* #67/1/0/u */
    { 0x047f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb60000000000,13182) }, /* #67/1/0/c */
    { 0x0500, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/1/1/u */
    { 0x057f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/1/1/c */
    { 0x0600, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b000,13182) }, /* #67/1/2/u */
    { 0x067f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b000,13182) }, /* #67/1/2/c */
    { 0x0700, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/1/3/u */
    { 0x077f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/1/3/c */
    { 0x0800, 0xe770, 0xffa0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb70000000000,13182) }, /* #67/2/0/u */
    { 0x087f, 0xe770, 0x7f20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb70000000000,13182) }, /* #67/2/0/c */
    { 0x0900, 0xe770, 0xffa0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a4,13182) }, /* #67/2/1/u */
    { 0x097f, 0xe770, 0x7f20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a4,13182) }, /* #67/2/1/c */
    { 0x0a00, 0xe770, 0xffa0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b800,13182) }, /* #67/2/2/u */
    { 0x0a7f, 0xe770, 0x7f20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b800,13182) }, /* #67/2/2/c */
    { 0x0b00, 0xe770, 0xffa0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a4,13182) }, /* #67/2/3/u */
    { 0x0b7f, 0xe770, 0x7f20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a4,13182) }, /* #67/2/3/c */
    { 0x0c00, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb60000000000,13182) }, /* #67/3/0/u */
    { 0x0c7f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb60000000000,13182) }, /* #67/3/0/c */
    { 0x0d00, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/3/1/u */
    { 0x0d7f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/3/1/c */
    { 0x0e00, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b000,13182) }, /* #67/3/2/u */
    { 0x0e7f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b000,13182) }, /* #67/3/2/c */
    { 0x0f00, 0xe770, 0xfda0, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/3/3/u */
    { 0x0f7f, 0xe770, 0x7d20, RTFLOAT80U_INIT_C(1,0xb73ebd3257a767cf,13624), RTFLOAT64U_INIT_C(1,0x23e013d4f6a21,581), RTFLOAT80U_INIT_C(0,0xd0ecb627de39b2a3,13182) }, /* #67/3/3/c */
    { 0x0000, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c70000000000,8219) }, /* #68/0/0/u */
    { 0x007f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/0/0/c */
    { 0x0100, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2fff,8219) }, /* #68/0/1/u */
    { 0x017f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/0/1/c */
    { 0x0200, 0x6951, 0xfba8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d3000,8219) }, /* #68/0/2/u */
    { 0x027f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/0/2/c */
    { 0x0300, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2fff,8219) }, /* #68/0/3/u */
    { 0x037f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/0/3/c */
    { 0x0400, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c70000000000,8219) }, /* #68/1/0/u */
    { 0x047f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #68/1/0/c */
    { 0x0500, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2fff,8219) }, /* #68/1/1/u */
    { 0x057f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #68/1/1/c */
    { 0x0600, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2800,8219) }, /* #68/1/2/u */
    { 0x067f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #68/1/2/c */
    { 0x0700, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2fff,8219) }, /* #68/1/3/u */
    { 0x077f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #68/1/3/c */
    { 0x0800, 0x6951, 0xfba8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c80000000000,8219) }, /* #68/2/0/u */
    { 0x087f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/2/0/c */
    { 0x0900, 0x6951, 0xfba8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d3000,8219) }, /* #68/2/1/u */
    { 0x097f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/2/1/c */
    { 0x0a00, 0x6951, 0xfba8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d3000,8219) }, /* #68/2/2/u */
    { 0x0a7f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/2/2/c */
    { 0x0b00, 0x6951, 0xfba8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d3000,8219) }, /* #68/2/3/u */
    { 0x0b7f, 0x6951, 0x7b28, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #68/2/3/c */
    { 0x0c00, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c70000000000,8219) }, /* #68/3/0/u */
    { 0x0c7f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xffffff0000000000,32766) }, /* #68/3/0/c */
    { 0x0d00, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2fff,8219) }, /* #68/3/1/u */
    { 0x0d7f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #68/3/1/c */
    { 0x0e00, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2800,8219) }, /* #68/3/2/u */
    { 0x0e7f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xfffffffffffff800,32766) }, /* #68/3/2/c */
    { 0x0f00, 0x6951, 0xf9a8, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xdd26c746847d2fff,8219) }, /* #68/3/3/u */
    { 0x0f7f, 0x6951, 0x7928, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT64U_INIT_C(1,0xba4d8e8d08fa6,1051), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #68/3/3/c */
    { 0x0000, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/0/0/u */
    { 0x007f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/0/c */
    { 0x0100, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/0/1/u */
    { 0x017f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/1/c */
    { 0x0200, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/0/2/u */
    { 0x027f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/2/c */
    { 0x0300, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/0/3/u */
    { 0x037f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/0/3/c */
    { 0x0400, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/1/0/u */
    { 0x047f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/0/c */
    { 0x0500, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/1/1/u */
    { 0x057f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/1/c */
    { 0x0600, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/1/2/u */
    { 0x067f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/2/c */
    { 0x0700, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/1/3/u */
    { 0x077f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/1/3/c */
    { 0x0800, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/2/0/u */
    { 0x087f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/0/c */
    { 0x0900, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/2/1/u */
    { 0x097f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/1/c */
    { 0x0a00, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/2/2/u */
    { 0x0a7f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/2/c */
    { 0x0b00, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/2/3/u */
    { 0x0b7f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/2/3/c */
    { 0x0c00, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/3/0/u */
    { 0x0c7f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/0/c */
    { 0x0d00, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/3/1/u */
    { 0x0d7f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/1/c */
    { 0x0e00, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/3/2/u */
    { 0x0e7f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/2/c */
    { 0x0f00, 0xcdbe, 0xfd81, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572) }, /* #69/3/3/u */
    { 0x0f7f, 0xcdbe, 0x7d01, RTFLOAT80U_INIT_C(1,0x8eee603739be8cc,3572), RTFLOAT64U_INIT_C(0,0x545946cf99aff,1609), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #69/3/3/c */
    { 0x0000, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/0/0/u */
    { 0x007f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba80000000000,5265) }, /* #70/0/0/c */
    { 0x0100, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/0/1/u */
    { 0x017f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60cd,5265) }, /* #70/0/1/c */
    { 0x0200, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/0/2/u */
    { 0x027f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e6000,5265) }, /* #70/0/2/c */
    { 0x0300, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/0/3/u */
    { 0x037f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60cd,5265) }, /* #70/0/3/c */
    { 0x0400, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/1/0/u */
    { 0x047f, 0xad38, 0x3f22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba90000000000,5265) }, /* #70/1/0/c */
    { 0x0500, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/1/1/u */
    { 0x057f, 0xad38, 0x3f22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60ce,5265) }, /* #70/1/1/c */
    { 0x0600, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/1/2/u */
    { 0x067f, 0xad38, 0x3f22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e6800,5265) }, /* #70/1/2/c */
    { 0x0700, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/1/3/u */
    { 0x077f, 0xad38, 0x3f22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60ce,5265) }, /* #70/1/3/c */
    { 0x0800, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/2/0/u */
    { 0x087f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba80000000000,5265) }, /* #70/2/0/c */
    { 0x0900, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/2/1/u */
    { 0x097f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60cd,5265) }, /* #70/2/1/c */
    { 0x0a00, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/2/2/u */
    { 0x0a7f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e6000,5265) }, /* #70/2/2/c */
    { 0x0b00, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/2/3/u */
    { 0x0b7f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60cd,5265) }, /* #70/2/3/c */
    { 0x0c00, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/3/0/u */
    { 0x0c7f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba80000000000,5265) }, /* #70/3/0/c */
    { 0x0d00, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/3/1/u */
    { 0x0d7f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60cd,5265) }, /* #70/3/1/c */
    { 0x0e00, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/3/2/u */
    { 0x0e7f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e6000,5265) }, /* #70/3/2/c */
    { 0x0f00, 0xad38, 0xbd82, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287) }, /* #70/3/3/u */
    { 0x0f7f, 0xad38, 0x3d22, RTFLOAT80U_INIT_C(0,0xcb68e69ae39b839c,6287), RTFLOAT64U_INIT_C(1,0xbdc85f822c55c,0), RTFLOAT80U_INIT_C(1,0x96cba817df1e60cd,5265) }, /* #70/3/3/c */
    { 0x0000, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/0/0/u */
    { 0x007f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230820000000000,609) }, /* #71/0/0/c */
    { 0x0100, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/0/1/u */
    { 0x017f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1293,609) }, /* #71/0/1/c */
    { 0x0200, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/0/2/u */
    { 0x027f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1000,609) }, /* #71/0/2/c */
    { 0x0300, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/0/3/u */
    { 0x037f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1293,609) }, /* #71/0/3/c */
    { 0x0400, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/1/0/u */
    { 0x047f, 0x466d, 0x7e22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230830000000000,609) }, /* #71/1/0/c */
    { 0x0500, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/1/1/u */
    { 0x057f, 0x466d, 0x7e22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1294,609) }, /* #71/1/1/c */
    { 0x0600, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/1/2/u */
    { 0x067f, 0x466d, 0x7e22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1800,609) }, /* #71/1/2/c */
    { 0x0700, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/1/3/u */
    { 0x077f, 0x466d, 0x7e22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1294,609) }, /* #71/1/3/c */
    { 0x0800, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/2/0/u */
    { 0x087f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230820000000000,609) }, /* #71/2/0/c */
    { 0x0900, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/2/1/u */
    { 0x097f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1293,609) }, /* #71/2/1/c */
    { 0x0a00, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/2/2/u */
    { 0x0a7f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1000,609) }, /* #71/2/2/c */
    { 0x0b00, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/2/3/u */
    { 0x0b7f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1293,609) }, /* #71/2/3/c */
    { 0x0c00, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/3/0/u */
    { 0x0c7f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230820000000000,609) }, /* #71/3/0/c */
    { 0x0d00, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/3/1/u */
    { 0x0d7f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1293,609) }, /* #71/3/1/c */
    { 0x0e00, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/3/2/u */
    { 0x0e7f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1000,609) }, /* #71/3/2/c */
    { 0x0f00, 0x466d, 0xfc82, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x78c724aa6,0) }, /* #71/3/3/u */
    { 0x0f7f, 0x466d, 0x7c22, RTFLOAT80U_INIT_C(1,0x78c724aa6,0), RTFLOAT64U_INIT_C(0,0x13f2e03adc03d,1659), RTFLOAT80U_INIT_C(1,0x8230826db32f1293,609) }, /* #71/3/3/c */
    { 0x0000, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37b0000000000,14415) }, /* #72/0/0/u */
    { 0x007f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37b0000000000,14415) }, /* #72/0/0/c */
    { 0x0100, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/0/1/u */
    { 0x017f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/0/1/c */
    { 0x0200, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a97800,14415) }, /* #72/0/2/u */
    { 0x027f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a97800,14415) }, /* #72/0/2/c */
    { 0x0300, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/0/3/u */
    { 0x037f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/0/3/c */
    { 0x0400, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a0000000000,14415) }, /* #72/1/0/u */
    { 0x047f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a0000000000,14415) }, /* #72/1/0/c */
    { 0x0500, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/1/1/u */
    { 0x057f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/1/1/c */
    { 0x0600, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a97800,14415) }, /* #72/1/2/u */
    { 0x067f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a97800,14415) }, /* #72/1/2/c */
    { 0x0700, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/1/3/u */
    { 0x077f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/1/3/c */
    { 0x0800, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37b0000000000,14415) }, /* #72/2/0/u */
    { 0x087f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37b0000000000,14415) }, /* #72/2/0/c */
    { 0x0900, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/2/1/u */
    { 0x097f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/2/1/c */
    { 0x0a00, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a98000,14415) }, /* #72/2/2/u */
    { 0x0a7f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a98000,14415) }, /* #72/2/2/c */
    { 0x0b00, 0x3185, 0xbba0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/2/3/u */
    { 0x0b7f, 0x3185, 0x3b20, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d2,14415) }, /* #72/2/3/c */
    { 0x0c00, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a0000000000,14415) }, /* #72/3/0/u */
    { 0x0c7f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a0000000000,14415) }, /* #72/3/0/c */
    { 0x0d00, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/3/1/u */
    { 0x0d7f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/3/1/c */
    { 0x0e00, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a97800,14415) }, /* #72/3/2/u */
    { 0x0e7f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a97800,14415) }, /* #72/3/2/c */
    { 0x0f00, 0x3185, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/3/3/u */
    { 0x0f7f, 0x3185, 0x3920, RTFLOAT80U_INIT_C(1,0xd19933cddf674bee,15144), RTFLOAT64U_INIT_C(1,0xbc289b806c5db,293), RTFLOAT80U_INIT_C(0,0xb5d37a8d07a979d1,14415) }, /* #72/3/3/c */
    { 0x0000, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232b0000000000,8308) }, /* #73/0/0/u */
    { 0x007f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232b0000000000,8308) }, /* #73/0/0/c */
    { 0x0100, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/0/1/u */
    { 0x017f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/0/1/c */
    { 0x0200, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c64000,8308) }, /* #73/0/2/u */
    { 0x027f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c64000,8308) }, /* #73/0/2/c */
    { 0x0300, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/0/3/u */
    { 0x037f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/0/3/c */
    { 0x0400, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232b0000000000,8308) }, /* #73/1/0/u */
    { 0x047f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232b0000000000,8308) }, /* #73/1/0/c */
    { 0x0500, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/1/1/u */
    { 0x057f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/1/1/c */
    { 0x0600, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c64000,8308) }, /* #73/1/2/u */
    { 0x067f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c64000,8308) }, /* #73/1/2/c */
    { 0x0700, 0x7401, 0xfea0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/1/3/u */
    { 0x077f, 0x7401, 0x7e20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d51,8308) }, /* #73/1/3/c */
    { 0x0800, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a0000000000,8308) }, /* #73/2/0/u */
    { 0x087f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a0000000000,8308) }, /* #73/2/0/c */
    { 0x0900, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/2/1/u */
    { 0x097f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/2/1/c */
    { 0x0a00, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63800,8308) }, /* #73/2/2/u */
    { 0x0a7f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63800,8308) }, /* #73/2/2/c */
    { 0x0b00, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/2/3/u */
    { 0x0b7f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/2/3/c */
    { 0x0c00, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a0000000000,8308) }, /* #73/3/0/u */
    { 0x0c7f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a0000000000,8308) }, /* #73/3/0/c */
    { 0x0d00, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/3/1/u */
    { 0x0d7f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/3/1/c */
    { 0x0e00, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63800,8308) }, /* #73/3/2/u */
    { 0x0e7f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63800,8308) }, /* #73/3/2/c */
    { 0x0f00, 0x7401, 0xfca0, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/3/3/u */
    { 0x0f7f, 0x7401, 0x7c20, RTFLOAT80U_INIT_C(0,0xb137923a66bac652,8384), RTFLOAT64U_INIT_C(1,0xf152fc02d462b,946), RTFLOAT80U_INIT_C(1,0xac232a9270c63d50,8308) }, /* #73/3/3/c */
    { 0x0000, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/0/u */
    { 0x007f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/0/c */
    { 0x0100, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/1/u */
    { 0x017f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/1/c */
    { 0x0200, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/2/u */
    { 0x027f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/2/c */
    { 0x0300, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/3/u */
    { 0x037f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/0/3/c */
    { 0x0400, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/0/u */
    { 0x047f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/0/c */
    { 0x0500, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/1/u */
    { 0x057f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/1/c */
    { 0x0600, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/2/u */
    { 0x067f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/2/c */
    { 0x0700, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/3/u */
    { 0x077f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/1/3/c */
    { 0x0800, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/0/u */
    { 0x087f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/0/c */
    { 0x0900, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/1/u */
    { 0x097f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/1/c */
    { 0x0a00, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/2/u */
    { 0x0a7f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/2/c */
    { 0x0b00, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/3/u */
    { 0x0b7f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/2/3/c */
    { 0x0c00, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/0/u */
    { 0x0c7f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/0/c */
    { 0x0d00, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/1/u */
    { 0x0d7f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/1/c */
    { 0x0e00, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/2/u */
    { 0x0e7f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/2/c */
    { 0x0f00, 0x2ddb, 0xbd81, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/3/u */
    { 0x0f7f, 0x2ddb, 0x3d01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT64U_INIT_C(0,0x40491b368e234,2047), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #74/3/3/c */
    { 0x0000, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a560000000000,9542) }, /* #75/0/0/u */
    { 0x007f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a560000000000,9542) }, /* #75/0/0/c */
    { 0x0100, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/0/1/u */
    { 0x017f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/0/1/c */
    { 0x0200, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1800,9542) }, /* #75/0/2/u */
    { 0x027f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1800,9542) }, /* #75/0/2/c */
    { 0x0300, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/0/3/u */
    { 0x037f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/0/3/c */
    { 0x0400, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a550000000000,9542) }, /* #75/1/0/u */
    { 0x047f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a550000000000,9542) }, /* #75/1/0/c */
    { 0x0500, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/1/1/u */
    { 0x057f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/1/1/c */
    { 0x0600, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1000,9542) }, /* #75/1/2/u */
    { 0x067f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1000,9542) }, /* #75/1/2/c */
    { 0x0700, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/1/3/u */
    { 0x077f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/1/3/c */
    { 0x0800, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a560000000000,9542) }, /* #75/2/0/u */
    { 0x087f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a560000000000,9542) }, /* #75/2/0/c */
    { 0x0900, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/2/1/u */
    { 0x097f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/2/1/c */
    { 0x0a00, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1800,9542) }, /* #75/2/2/u */
    { 0x0a7f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1800,9542) }, /* #75/2/2/c */
    { 0x0b00, 0x281b, 0xbaa0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/2/3/u */
    { 0x0b7f, 0x281b, 0x3a20, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fd,9542) }, /* #75/2/3/c */
    { 0x0c00, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a550000000000,9542) }, /* #75/3/0/u */
    { 0x0c7f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a550000000000,9542) }, /* #75/3/0/c */
    { 0x0d00, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/3/1/u */
    { 0x0d7f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/3/1/c */
    { 0x0e00, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1000,9542) }, /* #75/3/2/u */
    { 0x0e7f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da1000,9542) }, /* #75/3/2/c */
    { 0x0f00, 0x281b, 0xb8a0, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/3/3/u */
    { 0x0f7f, 0x281b, 0x3820, RTFLOAT80U_INIT_C(0,0xe0183bcb6b654ad1,8758), RTFLOAT64U_INIT_C(0,0x52f2f40025440,1806), RTFLOAT80U_INIT_C(0,0x945a55b929da15fc,9542) }, /* #75/3/3/c */
    { 0x0000, 0x8ec8, 0xbea0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35950000000000,885) }, /* #76/0/0/u */
    { 0x007f, 0x8ec8, 0x3e20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35950000000000,885) }, /* #76/0/0/c */
    { 0x0100, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/0/1/u */
    { 0x017f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/0/1/c */
    { 0x0200, 0x8ec8, 0xbea0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb722000,885) }, /* #76/0/2/u */
    { 0x027f, 0x8ec8, 0x3e20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb722000,885) }, /* #76/0/2/c */
    { 0x0300, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/0/3/u */
    { 0x037f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/0/3/c */
    { 0x0400, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35940000000000,885) }, /* #76/1/0/u */
    { 0x047f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35940000000000,885) }, /* #76/1/0/c */
    { 0x0500, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/1/1/u */
    { 0x057f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/1/1/c */
    { 0x0600, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721800,885) }, /* #76/1/2/u */
    { 0x067f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721800,885) }, /* #76/1/2/c */
    { 0x0700, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/1/3/u */
    { 0x077f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/1/3/c */
    { 0x0800, 0x8ec8, 0xbea0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35950000000000,885) }, /* #76/2/0/u */
    { 0x087f, 0x8ec8, 0x3e20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35950000000000,885) }, /* #76/2/0/c */
    { 0x0900, 0x8ec8, 0xbea0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e59,885) }, /* #76/2/1/u */
    { 0x097f, 0x8ec8, 0x3e20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e59,885) }, /* #76/2/1/c */
    { 0x0a00, 0x8ec8, 0xbea0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb722000,885) }, /* #76/2/2/u */
    { 0x0a7f, 0x8ec8, 0x3e20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb722000,885) }, /* #76/2/2/c */
    { 0x0b00, 0x8ec8, 0xbea0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e59,885) }, /* #76/2/3/u */
    { 0x0b7f, 0x8ec8, 0x3e20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e59,885) }, /* #76/2/3/c */
    { 0x0c00, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35940000000000,885) }, /* #76/3/0/u */
    { 0x0c7f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35940000000000,885) }, /* #76/3/0/c */
    { 0x0d00, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/3/1/u */
    { 0x0d7f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/3/1/c */
    { 0x0e00, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721800,885) }, /* #76/3/2/u */
    { 0x0e7f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721800,885) }, /* #76/3/2/c */
    { 0x0f00, 0x8ec8, 0xbca0, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/3/3/u */
    { 0x0f7f, 0x8ec8, 0x3c20, RTFLOAT80U_INIT_C(1,0xcee2dd6971f4e692,196), RTFLOAT64U_INIT_C(1,0x7da2beb66a5a6,1711), RTFLOAT80U_INIT_C(0,0x9a35949aeb721e58,885) }, /* #76/3/3/c */
    { 0x0000, 0xb65f, 0xbca0, RTFLOAT80U_INIT_C(1,0xc50a33f96a70c4e6,27070), RTFLOAT64U_INIT_C(0,0x1b26045481dd8,1938), RTFLOAT80U_INIT_C(1,0xd9ef8a0000000000,27985) }, /* #77/0/0/u */
    { 0x007f, 0xb65f, 0x3c20, RTFLOAT80U_INIT_C(1,0xc50a33f96a70c4e6,27070), RTFLOAT64U_INIT_C(0,0x1b26045481dd8,1938), RTFLOAT80U_INIT_C(1,0xd9ef8a0000000000,27985) }, /* #77/0/0/c */
    { 0x0100, 0xb65f, 0xbea0, RTFLOAT80U_INIT_C(1,0xc50a33f96a70c4e6,27070),