!{\src2tex{textfont=tt}}
!!****f* ABINIT/bess
!! NAME
!! bess
!! 
!! FUNCTION
!! Compute spherical Bessel function j_l(x)
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! INPUTS
!!  ll=l-order of the Bessel function
!!  xx=where to compute j_l
!!
!! PARENTS
!!      opt_proj
!!
!! SOURCE

 function bess(xx,ll)

 use defs_basis

 implicit none
 

!Arguments ---------------------------------------------
 integer :: ll
 real(dp) :: bess,xx

! *********************************************************************

 if (ll==0) then
  if(xx<1.d-3)then
   bess=1.0_dp-xx**2/6.0_dp*(1.0_dp-xx**2/20.0_dp)
  else
   bess=sin(xx)/xx
  endif
 endif
 if (ll==1) then
  if(xx<1.d-3)then
   bess=(10.d0-xx*xx)*xx/30.0d0
  else
   bess=(sin(xx)-xx*cos(xx))/xx**2
   endif
 endif
 if (ll==2) then
  if(xx<1.d-3)then
   bess=xx*xx/15.0d0-xx**4/210.0d0
  else
   bess=((3.0d0-xx**2)*sin(xx)-3.0d0*xx*cos(xx))/xx**3
  endif
 endif
 if (ll==3) then
  if(xx<1.d-3)then
   bess=xx*xx*xx/105.0d0-xx**5/1890.0d0+xx**7/83160.0d0
  else
   bess=(15.d0*sin(xx)-15.d0*xx*cos(xx) &
&            -6.d0*xx**2*sin(xx)+xx**3*cos(xx))/xx**4
  endif
 endif

 end function bess

!!***
